/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Sparkplug B Host Application support over MQTT using Eclipse Tahu
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface TahuHostEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Tahu Host Application component.
     */
    public interface TahuHostEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedTahuHostEndpointBuilder advanced() {
            return (AdvancedTahuHostEndpointBuilder) this;
        }

        /**
         * MQTT client ID length check enabled.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param checkClientIdLength the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder checkClientIdLength(boolean checkClientIdLength) {
            doSetProperty("checkClientIdLength", checkClientIdLength);
            return this;
        }
        /**
         * MQTT client ID length check enabled.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param checkClientIdLength the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder checkClientIdLength(String checkClientIdLength) {
            doSetProperty("checkClientIdLength", checkClientIdLength);
            return this;
        }
        /**
         * MQTT client ID to use for all server definitions, rather than
         * specifying the same one for each. Note that if neither the 'clientId'
         * parameter nor an 'MqttClientId' are defined for an MQTT Server, a
         * random MQTT Client ID will be generated automatically, prefaced with
         * 'Camel'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * MQTT connection keep alive timeout, in seconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 30
         * Group: common
         * 
         * @param keepAliveTimeout the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder keepAliveTimeout(int keepAliveTimeout) {
            doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }
        /**
         * MQTT connection keep alive timeout, in seconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 30
         * Group: common
         * 
         * @param keepAliveTimeout the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder keepAliveTimeout(String keepAliveTimeout) {
            doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }
        /**
         * Delay before recurring node rebirth messages will be sent.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param rebirthDebounceDelay the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder rebirthDebounceDelay(long rebirthDebounceDelay) {
            doSetProperty("rebirthDebounceDelay", rebirthDebounceDelay);
            return this;
        }
        /**
         * Delay before recurring node rebirth messages will be sent.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param rebirthDebounceDelay the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder rebirthDebounceDelay(String rebirthDebounceDelay) {
            doSetProperty("rebirthDebounceDelay", rebirthDebounceDelay);
            return this;
        }
        /**
         * MQTT server definitions, given with the following syntax in a
         * comma-separated list:
         * MqttServerName:(MqttClientId:)(tcp/ssl)://hostname(:port),...
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         * 
         * @param servers the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder servers(String servers) {
            doSetProperty("servers", servers);
            return this;
        }
        /**
         * Password for MQTT server authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * SSL configuration for MQTT server connections.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * SSL configuration for MQTT server connections.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Username for MQTT server authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Tahu Host Application component.
     */
    public interface AdvancedTahuHostEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default TahuHostEndpointBuilder basic() {
            return (TahuHostEndpointBuilder) this;
        }

        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedTahuHostEndpointBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedTahuHostEndpointBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedTahuHostEndpointBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedTahuHostEndpointBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedTahuHostEndpointBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedTahuHostEndpointBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    public interface TahuHostBuilders {
        /**
         * Tahu Host Application (camel-tahu)
         * Sparkplug B Host Application support over MQTT using Eclipse Tahu
         * 
         * Category: messaging,iot,monitoring
         * Since: 4.8
         * Maven coordinates: org.apache.camel:camel-tahu
         * 
         * @return the dsl builder for the headers' name.
         */
        default TahuHostHeaderNameBuilder tahuHost() {
            return TahuHostHeaderNameBuilder.INSTANCE;
        }
        /**
         * Tahu Host Application (camel-tahu)
         * Sparkplug B Host Application support over MQTT using Eclipse Tahu
         * 
         * Category: messaging,iot,monitoring
         * Since: 4.8
         * Maven coordinates: org.apache.camel:camel-tahu
         * 
         * Syntax: <code>tahu-host:hostId</code>
         * 
         * Path parameter: hostId (required)
         * ID for the host application
         * 
         * @param path hostId
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder tahuHost(String path) {
            return TahuHostEndpointBuilderFactory.endpointBuilder("tahu-host", path);
        }
        /**
         * Tahu Host Application (camel-tahu)
         * Sparkplug B Host Application support over MQTT using Eclipse Tahu
         * 
         * Category: messaging,iot,monitoring
         * Since: 4.8
         * Maven coordinates: org.apache.camel:camel-tahu
         * 
         * Syntax: <code>tahu-host:hostId</code>
         * 
         * Path parameter: hostId (required)
         * ID for the host application
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path hostId
         * @return the dsl builder
         */
        default TahuHostEndpointBuilder tahuHost(String componentName, String path) {
            return TahuHostEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Tahu Host Application component.
     */
    public static class TahuHostHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final TahuHostHeaderNameBuilder INSTANCE = new TahuHostHeaderNameBuilder();

        /**
         * The Sparkplug message type of the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code TahuMessageType}.
         */
        public String tahuMessageType() {
            return "CamelTahuMessageType";
        }
        /**
         * The Sparkplug edge node descriptor string source of a message or
         * metric.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code TahuEdgeNodeDescriptor}.
         */
        public String tahuEdgeNodeDescriptor() {
            return "CamelTahuEdgeNodeDescriptor";
        }
        /**
         * The timestamp of a Sparkplug message.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code TahuMessageTimestamp}.
         */
        public String tahuMessageTimestamp() {
            return "CamelTahuMessageTimestamp";
        }
        /**
         * The UUID of a Sparkplug message.
         * 
         * The option is a: {@code java.util.UUID} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code TahuMessageUUID}.
         */
        public String tahuMessageUUID() {
            return "CamelTahuMessageUUID";
        }
        /**
         * The sequence number of a Sparkplug message.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code TahuMessageSequenceNumber}.
         */
        public String tahuMessageSequenceNumber() {
            return "CamelTahuMessageSequenceNumber";
        }
    }
    static TahuHostEndpointBuilder endpointBuilder(String componentName, String path) {
        class TahuHostEndpointBuilderImpl extends AbstractEndpointBuilder implements TahuHostEndpointBuilder, AdvancedTahuHostEndpointBuilder {
            public TahuHostEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new TahuHostEndpointBuilderImpl(path);
    }
}