/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send requests to external HTTP servers using Apache HTTP Client 5.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface HttpEndpointBuilderFactory {

    /**
     * Builder for endpoint for the HTTP component.
     */
    public interface HttpEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedHttpEndpointBuilder advanced() {
            return (AdvancedHttpEndpointBuilder) this;
        }

        /**
         * Determines whether or not the raw input stream is cached or not. The
         * Camel consumer (camel-servlet, camel-jetty etc.) will by default
         * cache the input stream to support reading it multiple times to ensure
         * it Camel can retrieve all data from the stream. However you can set
         * this option to true when you for example need to access the raw
         * stream, such as streaming it directly to a file or other persistent
         * store. DefaultHttpBinding will copy the request input stream into a
         * stream cache and put it into message body if this option is false to
         * support reading the stream multiple times. If you use Servlet to
         * bridge/proxy an endpoint then consider enabling this option to
         * improve performance, in case you do not need to read the message
         * payload multiple times. The producer (camel-http) will by default
         * cache the response body stream. If setting this option to true, then
         * the producers will not cache the response body stream but use the
         * response stream as-is (the stream can only be read once) as the
         * message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableStreamCache the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder disableStreamCache(boolean disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Determines whether or not the raw input stream is cached or not. The
         * Camel consumer (camel-servlet, camel-jetty etc.) will by default
         * cache the input stream to support reading it multiple times to ensure
         * it Camel can retrieve all data from the stream. However you can set
         * this option to true when you for example need to access the raw
         * stream, such as streaming it directly to a file or other persistent
         * store. DefaultHttpBinding will copy the request input stream into a
         * stream cache and put it into message body if this option is false to
         * support reading the stream multiple times. If you use Servlet to
         * bridge/proxy an endpoint then consider enabling this option to
         * improve performance, in case you do not need to read the message
         * payload multiple times. The producer (camel-http) will by default
         * cache the response body stream. If setting this option to true, then
         * the producers will not cache the response body stream but use the
         * response stream as-is (the stream can only be read once) as the
         * message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableStreamCache the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder disableStreamCache(String disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * If the option is true, HttpProducer will ignore the Exchange.HTTP_URI
         * header, and use the endpoint's URI for request. You may also set the
         * option throwExceptionOnFailure to be false to let the HttpProducer
         * send all the fault response back.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder bridgeEndpoint(boolean bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If the option is true, HttpProducer will ignore the Exchange.HTTP_URI
         * header, and use the endpoint's URI for request. You may also set the
         * option throwExceptionOnFailure to be false to let the HttpProducer
         * send all the fault response back.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder bridgeEndpoint(String bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * Specifies whether a Connection Close header must be added to HTTP
         * Request. By default connectionClose is false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param connectionClose the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder connectionClose(boolean connectionClose) {
            doSetProperty("connectionClose", connectionClose);
            return this;
        }
        /**
         * Specifies whether a Connection Close header must be added to HTTP
         * Request. By default connectionClose is false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param connectionClose the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder connectionClose(String connectionClose) {
            doSetProperty("connectionClose", connectionClose);
            return this;
        }
        /**
         * Configure the HTTP method to use. The HttpMethod header cannot
         * override this option if set.
         * 
         * The option is a:
         * <code>org.apache.camel.http.common.HttpMethods</code> type.
         * 
         * Group: producer
         * 
         * @param httpMethod the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder httpMethod(org.apache.camel.http.common.HttpMethods httpMethod) {
            doSetProperty("httpMethod", httpMethod);
            return this;
        }
        /**
         * Configure the HTTP method to use. The HttpMethod header cannot
         * override this option if set.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.common.HttpMethods</code> type.
         * 
         * Group: producer
         * 
         * @param httpMethod the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder httpMethod(String httpMethod) {
            doSetProperty("httpMethod", httpMethod);
            return this;
        }
        /**
         * To enable logging HTTP request and response. You can use a custom
         * LoggingHttpActivityListener as httpActivityListener to control
         * logging options.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param logHttpActivity the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder logHttpActivity(boolean logHttpActivity) {
            doSetProperty("logHttpActivity", logHttpActivity);
            return this;
        }
        /**
         * To enable logging HTTP request and response. You can use a custom
         * LoggingHttpActivityListener as httpActivityListener to control
         * logging options.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param logHttpActivity the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder logHttpActivity(String logHttpActivity) {
            doSetProperty("logHttpActivity", logHttpActivity);
            return this;
        }
        /**
         * Whether to force using multipart/form-data for easy file uploads.
         * This is only to be used for uploading the message body as a single
         * entity form-data. For uploading multiple entries then use
         * org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder to
         * build the form.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param multipartUpload the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder multipartUpload(boolean multipartUpload) {
            doSetProperty("multipartUpload", multipartUpload);
            return this;
        }
        /**
         * Whether to force using multipart/form-data for easy file uploads.
         * This is only to be used for uploading the message body as a single
         * entity form-data. For uploading multiple entries then use
         * org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder to
         * build the form.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param multipartUpload the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder multipartUpload(String multipartUpload) {
            doSetProperty("multipartUpload", multipartUpload);
            return this;
        }
        /**
         * The name of the multipart/form-data when multipartUpload is enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: data
         * Group: producer
         * 
         * @param multipartUploadName the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder multipartUploadName(String multipartUploadName) {
            doSetProperty("multipartUploadName", multipartUploadName);
            return this;
        }
        /**
         * Whether to skip Camel control headers (CamelHttp... headers) to
         * influence this endpoint. Control headers from previous HTTP
         * components can influence how this Camel component behaves such as
         * CamelHttpPath, CamelHttpQuery, etc.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param skipControlHeaders the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder skipControlHeaders(boolean skipControlHeaders) {
            doSetProperty("skipControlHeaders", skipControlHeaders);
            return this;
        }
        /**
         * Whether to skip Camel control headers (CamelHttp... headers) to
         * influence this endpoint. Control headers from previous HTTP
         * components can influence how this Camel component behaves such as
         * CamelHttpPath, CamelHttpQuery, etc.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param skipControlHeaders the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder skipControlHeaders(String skipControlHeaders) {
            doSetProperty("skipControlHeaders", skipControlHeaders);
            return this;
        }
        /**
         * Whether to skip mapping the Camel headers as HTTP request headers.
         * This is useful when you know that calling the HTTP service should not
         * include any custom headers.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param skipRequestHeaders the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder skipRequestHeaders(boolean skipRequestHeaders) {
            doSetProperty("skipRequestHeaders", skipRequestHeaders);
            return this;
        }
        /**
         * Whether to skip mapping the Camel headers as HTTP request headers.
         * This is useful when you know that calling the HTTP service should not
         * include any custom headers.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param skipRequestHeaders the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder skipRequestHeaders(String skipRequestHeaders) {
            doSetProperty("skipRequestHeaders", skipRequestHeaders);
            return this;
        }
        /**
         * Whether to skip mapping all the HTTP response headers to Camel
         * headers.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param skipResponseHeaders the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder skipResponseHeaders(boolean skipResponseHeaders) {
            doSetProperty("skipResponseHeaders", skipResponseHeaders);
            return this;
        }
        /**
         * Whether to skip mapping all the HTTP response headers to Camel
         * headers.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param skipResponseHeaders the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder skipResponseHeaders(String skipResponseHeaders) {
            doSetProperty("skipResponseHeaders", skipResponseHeaders);
            return this;
        }
        /**
         * Option to disable throwing the HttpOperationFailedException in case
         * of failed responses from the remote server. This allows you to get
         * all responses regardless of the HTTP status code.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param throwExceptionOnFailure the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder throwExceptionOnFailure(boolean throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * Option to disable throwing the HttpOperationFailedException in case
         * of failed responses from the remote server. This allows you to get
         * all responses regardless of the HTTP status code.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param throwExceptionOnFailure the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder throwExceptionOnFailure(String throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * Proxy authentication domain to use with NTLM.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthDomain the value to set
         * @return the dsl builder
         */
        @Deprecated
        default HttpEndpointBuilder proxyAuthDomain(String proxyAuthDomain) {
            doSetProperty("proxyAuthDomain", proxyAuthDomain);
            return this;
        }
        /**
         * Proxy server host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthHost the value to set
         * @return the dsl builder
         */
        @Deprecated
        default HttpEndpointBuilder proxyAuthHost(String proxyAuthHost) {
            doSetProperty("proxyAuthHost", proxyAuthHost);
            return this;
        }
        /**
         * Proxy authentication method to use (NTLM is deprecated).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthMethod the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder proxyAuthMethod(String proxyAuthMethod) {
            doSetProperty("proxyAuthMethod", proxyAuthMethod);
            return this;
        }
        /**
         * Proxy authentication domain (workstation name) to use with NTLM.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthNtHost the value to set
         * @return the dsl builder
         */
        @Deprecated
        default HttpEndpointBuilder proxyAuthNtHost(String proxyAuthNtHost) {
            doSetProperty("proxyAuthNtHost", proxyAuthNtHost);
            return this;
        }
        /**
         * Proxy server password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthPassword the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder proxyAuthPassword(String proxyAuthPassword) {
            doSetProperty("proxyAuthPassword", proxyAuthPassword);
            return this;
        }
        /**
         * Proxy server port.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthPort the value to set
         * @return the dsl builder
         */
        @Deprecated
        default HttpEndpointBuilder proxyAuthPort(int proxyAuthPort) {
            doSetProperty("proxyAuthPort", proxyAuthPort);
            return this;
        }
        /**
         * Proxy server port.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthPort the value to set
         * @return the dsl builder
         */
        @Deprecated
        default HttpEndpointBuilder proxyAuthPort(String proxyAuthPort) {
            doSetProperty("proxyAuthPort", proxyAuthPort);
            return this;
        }
        /**
         * Proxy server authentication protocol scheme to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthScheme the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder proxyAuthScheme(String proxyAuthScheme) {
            doSetProperty("proxyAuthScheme", proxyAuthScheme);
            return this;
        }
        /**
         * Proxy server username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthUsername the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder proxyAuthUsername(String proxyAuthUsername) {
            doSetProperty("proxyAuthUsername", proxyAuthUsername);
            return this;
        }
        /**
         * Proxy server host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Proxy server port.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder proxyPort(int proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Proxy server port.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Authentication bearer token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param authBearerToken the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder authBearerToken(String authBearerToken) {
            doSetProperty("authBearerToken", authBearerToken);
            return this;
        }
        /**
         * Authentication domain to use with NTLM.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param authDomain the value to set
         * @return the dsl builder
         */
        @Deprecated
        default HttpEndpointBuilder authDomain(String authDomain) {
            doSetProperty("authDomain", authDomain);
            return this;
        }
        /**
         * If this option is true, camel-http sends preemptive basic
         * authentication to the server.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param authenticationPreemptive the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder authenticationPreemptive(boolean authenticationPreemptive) {
            doSetProperty("authenticationPreemptive", authenticationPreemptive);
            return this;
        }
        /**
         * If this option is true, camel-http sends preemptive basic
         * authentication to the server.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param authenticationPreemptive the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder authenticationPreemptive(String authenticationPreemptive) {
            doSetProperty("authenticationPreemptive", authenticationPreemptive);
            return this;
        }
        /**
         * Authentication host to use with NTLM.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param authHost the value to set
         * @return the dsl builder
         */
        @Deprecated
        default HttpEndpointBuilder authHost(String authHost) {
            doSetProperty("authHost", authHost);
            return this;
        }
        /**
         * Authentication methods allowed to use as a comma separated list of
         * values Basic, Bearer, or NTLM. (NTLM is deprecated).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param authMethod the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder authMethod(String authMethod) {
            doSetProperty("authMethod", authMethod);
            return this;
        }
        /**
         * Authentication password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param authPassword the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder authPassword(String authPassword) {
            doSetProperty("authPassword", authPassword);
            return this;
        }
        /**
         * Authentication username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param authUsername the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder authUsername(String authUsername) {
            doSetProperty("authUsername", authUsername);
            return this;
        }
        /**
         * Whether to use OAuth2 body authentication.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param oauth2BodyAuthentication the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2BodyAuthentication(boolean oauth2BodyAuthentication) {
            doSetProperty("oauth2BodyAuthentication", oauth2BodyAuthentication);
            return this;
        }
        /**
         * Whether to use OAuth2 body authentication.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param oauth2BodyAuthentication the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2BodyAuthentication(String oauth2BodyAuthentication) {
            doSetProperty("oauth2BodyAuthentication", oauth2BodyAuthentication);
            return this;
        }
        /**
         * Default expiration time for cached OAuth2 tokens, in seconds. Used if
         * token response does not contain 'expires_in' field.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 3600
         * Group: security
         * 
         * @param oauth2CachedTokensDefaultExpirySeconds the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2CachedTokensDefaultExpirySeconds(long oauth2CachedTokensDefaultExpirySeconds) {
            doSetProperty("oauth2CachedTokensDefaultExpirySeconds", oauth2CachedTokensDefaultExpirySeconds);
            return this;
        }
        /**
         * Default expiration time for cached OAuth2 tokens, in seconds. Used if
         * token response does not contain 'expires_in' field.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 3600
         * Group: security
         * 
         * @param oauth2CachedTokensDefaultExpirySeconds the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2CachedTokensDefaultExpirySeconds(String oauth2CachedTokensDefaultExpirySeconds) {
            doSetProperty("oauth2CachedTokensDefaultExpirySeconds", oauth2CachedTokensDefaultExpirySeconds);
            return this;
        }
        /**
         * Amount of time which is deducted from OAuth2 tokens expiry time to
         * compensate for the time it takes OAuth2 Token Endpoint to send the
         * token over http, in seconds. Set this parameter to high value if you
         * OAuth2 Token Endpoint answers slowly or you tokens expire quickly. If
         * you set this parameter to too small value, you can get 4xx http
         * errors because camel will think that the received token is still
         * valid, while in reality the token is expired for the Authentication
         * server.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5
         * Group: security
         * 
         * @param oauth2CachedTokensExpirationMarginSeconds the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2CachedTokensExpirationMarginSeconds(long oauth2CachedTokensExpirationMarginSeconds) {
            doSetProperty("oauth2CachedTokensExpirationMarginSeconds", oauth2CachedTokensExpirationMarginSeconds);
            return this;
        }
        /**
         * Amount of time which is deducted from OAuth2 tokens expiry time to
         * compensate for the time it takes OAuth2 Token Endpoint to send the
         * token over http, in seconds. Set this parameter to high value if you
         * OAuth2 Token Endpoint answers slowly or you tokens expire quickly. If
         * you set this parameter to too small value, you can get 4xx http
         * errors because camel will think that the received token is still
         * valid, while in reality the token is expired for the Authentication
         * server.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5
         * Group: security
         * 
         * @param oauth2CachedTokensExpirationMarginSeconds the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2CachedTokensExpirationMarginSeconds(String oauth2CachedTokensExpirationMarginSeconds) {
            doSetProperty("oauth2CachedTokensExpirationMarginSeconds", oauth2CachedTokensExpirationMarginSeconds);
            return this;
        }
        /**
         * Whether to cache OAuth2 client tokens.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param oauth2CacheTokens the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2CacheTokens(boolean oauth2CacheTokens) {
            doSetProperty("oauth2CacheTokens", oauth2CacheTokens);
            return this;
        }
        /**
         * Whether to cache OAuth2 client tokens.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param oauth2CacheTokens the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2CacheTokens(String oauth2CacheTokens) {
            doSetProperty("oauth2CacheTokens", oauth2CacheTokens);
            return this;
        }
        /**
         * OAuth2 client id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param oauth2ClientId the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2ClientId(String oauth2ClientId) {
            doSetProperty("oauth2ClientId", oauth2ClientId);
            return this;
        }
        /**
         * OAuth2 client secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param oauth2ClientSecret the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2ClientSecret(String oauth2ClientSecret) {
            doSetProperty("oauth2ClientSecret", oauth2ClientSecret);
            return this;
        }
        /**
         * OAuth2 Token endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param oauth2ResourceIndicator the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2ResourceIndicator(String oauth2ResourceIndicator) {
            doSetProperty("oauth2ResourceIndicator", oauth2ResourceIndicator);
            return this;
        }
        /**
         * OAuth2 scope.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param oauth2Scope the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2Scope(String oauth2Scope) {
            doSetProperty("oauth2Scope", oauth2Scope);
            return this;
        }
        /**
         * OAuth2 Resource Indicator.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param oauth2TokenEndpoint the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder oauth2TokenEndpoint(String oauth2TokenEndpoint) {
            doSetProperty("oauth2TokenEndpoint", oauth2TokenEndpoint);
            return this;
        }
        /**
         * To configure security using SSLContextParameters. Important: Only one
         * instance of org.apache.camel.util.jsse.SSLContextParameters is
         * supported per HttpComponent. If you need to use 2 or more different
         * instances, you need to define a new HttpComponent per instance you
         * need.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters. Important: Only one
         * instance of org.apache.camel.util.jsse.SSLContextParameters is
         * supported per HttpComponent. If you need to use 2 or more different
         * instances, you need to define a new HttpComponent per instance you
         * need.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To use a custom X509HostnameVerifier such as DefaultHostnameVerifier
         * or NoopHostnameVerifier.
         * 
         * The option is a: <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param x509HostnameVerifier the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder x509HostnameVerifier(javax.net.ssl.HostnameVerifier x509HostnameVerifier) {
            doSetProperty("x509HostnameVerifier", x509HostnameVerifier);
            return this;
        }
        /**
         * To use a custom X509HostnameVerifier such as DefaultHostnameVerifier
         * or NoopHostnameVerifier.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param x509HostnameVerifier the value to set
         * @return the dsl builder
         */
        default HttpEndpointBuilder x509HostnameVerifier(String x509HostnameVerifier) {
            doSetProperty("x509HostnameVerifier", x509HostnameVerifier);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the HTTP component.
     */
    public interface AdvancedHttpEndpointBuilder
            extends
                EndpointProducerBuilder {
        default HttpEndpointBuilder basic() {
            return (HttpEndpointBuilder) this;
        }

        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common (advanced)
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common (advanced)
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to clear expired cookies before sending the HTTP request.
         * This ensures the cookies store does not keep growing by adding new
         * cookies which is newer removed when they are expired. If the
         * component has disabled cookie management then this option is disabled
         * too.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param clearExpiredCookies the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder clearExpiredCookies(boolean clearExpiredCookies) {
            doSetProperty("clearExpiredCookies", clearExpiredCookies);
            return this;
        }
        /**
         * Whether to clear expired cookies before sending the HTTP request.
         * This ensures the cookies store does not keep growing by adding new
         * cookies which is newer removed when they are expired. If the
         * component has disabled cookie management then this option is disabled
         * too.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param clearExpiredCookies the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder clearExpiredCookies(String clearExpiredCookies) {
            doSetProperty("clearExpiredCookies", clearExpiredCookies);
            return this;
        }
        /**
         * Whether the Content-Type header should automatic include charset for
         * string based content.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param contentTypeCharsetEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder contentTypeCharsetEnabled(boolean contentTypeCharsetEnabled) {
            doSetProperty("contentTypeCharsetEnabled", contentTypeCharsetEnabled);
            return this;
        }
        /**
         * Whether the Content-Type header should automatic include charset for
         * string based content.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param contentTypeCharsetEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder contentTypeCharsetEnabled(String contentTypeCharsetEnabled) {
            doSetProperty("contentTypeCharsetEnabled", contentTypeCharsetEnabled);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option is a:
         * <code>org.apache.camel.http.base.cookie.CookieHandler</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param cookieHandler the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder cookieHandler(org.apache.camel.http.base.cookie.CookieHandler cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.base.cookie.CookieHandler</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param cookieHandler the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder cookieHandler(String cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * To use a custom CookieStore. By default the BasicCookieStore is used
         * which is an in-memory only cookie store. Notice if
         * bridgeEndpoint=true then the cookie store is forced to be a noop
         * cookie store as cookie shouldn't be stored as we are just bridging
         * (eg acting as a proxy). If a cookieHandler is set then the cookie
         * store is also forced to be a noop cookie store as cookie handling is
         * then performed by the cookieHandler.
         * 
         * The option is a:
         * <code>org.apache.hc.client5.http.cookie.CookieStore</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param cookieStore the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder cookieStore(org.apache.hc.client5.http.cookie.CookieStore cookieStore) {
            doSetProperty("cookieStore", cookieStore);
            return this;
        }
        /**
         * To use a custom CookieStore. By default the BasicCookieStore is used
         * which is an in-memory only cookie store. Notice if
         * bridgeEndpoint=true then the cookie store is forced to be a noop
         * cookie store as cookie shouldn't be stored as we are just bridging
         * (eg acting as a proxy). If a cookieHandler is set then the cookie
         * store is also forced to be a noop cookie store as cookie handling is
         * then performed by the cookieHandler.
         * 
         * The option will be converted to a
         * <code>org.apache.hc.client5.http.cookie.CookieStore</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param cookieStore the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder cookieStore(String cookieStore) {
            doSetProperty("cookieStore", cookieStore);
            return this;
        }
        /**
         * If this option is true then IN exchange headers will be copied to OUT
         * exchange headers according to copy strategy. Setting this to false,
         * allows to only include the headers from the HTTP response (not
         * propagating IN headers).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param copyHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder copyHeaders(boolean copyHeaders) {
            doSetProperty("copyHeaders", copyHeaders);
            return this;
        }
        /**
         * If this option is true then IN exchange headers will be copied to OUT
         * exchange headers according to copy strategy. Setting this to false,
         * allows to only include the headers from the HTTP response (not
         * propagating IN headers).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param copyHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder copyHeaders(String copyHeaders) {
            doSetProperty("copyHeaders", copyHeaders);
            return this;
        }
        /**
         * To use custom host header for producer. When not set in query will be
         * ignored. When set will override host header derived from url.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param customHostHeader the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder customHostHeader(String customHostHeader) {
            doSetProperty("customHostHeader", customHostHeader);
            return this;
        }
        /**
         * Whether the HTTP DELETE should include the message body or not. By
         * default HTTP DELETE do not include any HTTP body. However in some
         * rare cases users may need to be able to include the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param deleteWithBody the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder deleteWithBody(boolean deleteWithBody) {
            doSetProperty("deleteWithBody", deleteWithBody);
            return this;
        }
        /**
         * Whether the HTTP DELETE should include the message body or not. By
         * default HTTP DELETE do not include any HTTP body. However in some
         * rare cases users may need to be able to include the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param deleteWithBody the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder deleteWithBody(String deleteWithBody) {
            doSetProperty("deleteWithBody", deleteWithBody);
            return this;
        }
        /**
         * Whether to the HTTP request should follow redirects. By default the
         * HTTP request does not follow redirects.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param followRedirects the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder followRedirects(boolean followRedirects) {
            doSetProperty("followRedirects", followRedirects);
            return this;
        }
        /**
         * Whether to the HTTP request should follow redirects. By default the
         * HTTP request does not follow redirects.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param followRedirects the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder followRedirects(String followRedirects) {
            doSetProperty("followRedirects", followRedirects);
            return this;
        }
        /**
         * Whether the HTTP GET should include the message body or not. By
         * default HTTP GET do not include any HTTP body. However in some rare
         * cases users may need to be able to include the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param getWithBody the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder getWithBody(boolean getWithBody) {
            doSetProperty("getWithBody", getWithBody);
            return this;
        }
        /**
         * Whether the HTTP GET should include the message body or not. By
         * default HTTP GET do not include any HTTP body. However in some rare
         * cases users may need to be able to include the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param getWithBody the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder getWithBody(String getWithBody) {
            doSetProperty("getWithBody", getWithBody);
            return this;
        }
        /**
         * To use a custom activity listener.
         * 
         * The option is a:
         * <code>org.apache.camel.component.http.HttpActivityListener</code>
         * type.
         * 
         * Group: producer (advanced)
         * 
         * @param httpActivityListener the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpActivityListener(org.apache.camel.component.http.HttpActivityListener httpActivityListener) {
            doSetProperty("httpActivityListener", httpActivityListener);
            return this;
        }
        /**
         * To use a custom activity listener.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.http.HttpActivityListener</code>
         * type.
         * 
         * Group: producer (advanced)
         * 
         * @param httpActivityListener the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpActivityListener(String httpActivityListener) {
            doSetProperty("httpActivityListener", httpActivityListener);
            return this;
        }
        /**
         * If this option is true, The http producer won't read response body
         * and cache the input stream.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param ignoreResponseBody the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder ignoreResponseBody(boolean ignoreResponseBody) {
            doSetProperty("ignoreResponseBody", ignoreResponseBody);
            return this;
        }
        /**
         * If this option is true, The http producer won't read response body
         * and cache the input stream.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param ignoreResponseBody the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder ignoreResponseBody(String ignoreResponseBody) {
            doSetProperty("ignoreResponseBody", ignoreResponseBody);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The status codes which are considered a success response. The values
         * are inclusive. Multiple ranges can be defined, separated by comma,
         * e.g. 200-204,209,301-304. Each range must be a single number or
         * from-to with the dash included.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 200-299
         * Group: producer (advanced)
         * 
         * @param okStatusCodeRange the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder okStatusCodeRange(String okStatusCodeRange) {
            doSetProperty("okStatusCodeRange", okStatusCodeRange);
            return this;
        }
        /**
         * If the option is true, HttpProducer will set the Host header to the
         * value contained in the current exchange Host header, useful in
         * reverse proxy applications where you want the Host header received by
         * the downstream server to reflect the URL called by the upstream
         * client, this allows applications which use the Host header to
         * generate accurate URL's for a proxied service.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param preserveHostHeader the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder preserveHostHeader(boolean preserveHostHeader) {
            doSetProperty("preserveHostHeader", preserveHostHeader);
            return this;
        }
        /**
         * If the option is true, HttpProducer will set the Host header to the
         * value contained in the current exchange Host header, useful in
         * reverse proxy applications where you want the Host header received by
         * the downstream server to reflect the URL called by the upstream
         * client, this allows applications which use the Host header to
         * generate accurate URL's for a proxied service.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param preserveHostHeader the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder preserveHostHeader(String preserveHostHeader) {
            doSetProperty("preserveHostHeader", preserveHostHeader);
            return this;
        }
        /**
         * To set a custom HTTP User-Agent request header.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder userAgent(String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
        /**
         * Provide access to the http client request parameters used on new
         * RequestConfig instances used by producers or consumers of this
         * endpoint.
         * 
         * The option is a:
         * <code>org.apache.hc.client5.http.impl.classic.HttpClientBuilder</code> type.
         * 
         * Group: advanced
         * 
         * @param clientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder clientBuilder(org.apache.hc.client5.http.impl.classic.HttpClientBuilder clientBuilder) {
            doSetProperty("clientBuilder", clientBuilder);
            return this;
        }
        /**
         * Provide access to the http client request parameters used on new
         * RequestConfig instances used by producers or consumers of this
         * endpoint.
         * 
         * The option will be converted to a
         * <code>org.apache.hc.client5.http.impl.classic.HttpClientBuilder</code> type.
         * 
         * Group: advanced
         * 
         * @param clientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder clientBuilder(String clientBuilder) {
            doSetProperty("clientBuilder", clientBuilder);
            return this;
        }
        /**
         * To use a custom HttpClientConnectionManager to manage connections.
         * 
         * The option is a:
         * <code>org.apache.hc.client5.http.io.HttpClientConnectionManager</code> type.
         * 
         * Group: advanced
         * 
         * @param clientConnectionManager the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder clientConnectionManager(org.apache.hc.client5.http.io.HttpClientConnectionManager clientConnectionManager) {
            doSetProperty("clientConnectionManager", clientConnectionManager);
            return this;
        }
        /**
         * To use a custom HttpClientConnectionManager to manage connections.
         * 
         * The option will be converted to a
         * <code>org.apache.hc.client5.http.io.HttpClientConnectionManager</code> type.
         * 
         * Group: advanced
         * 
         * @param clientConnectionManager the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder clientConnectionManager(String clientConnectionManager) {
            doSetProperty("clientConnectionManager", clientConnectionManager);
            return this;
        }
        /**
         * The maximum number of connections per route.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 20
         * Group: advanced
         * 
         * @param connectionsPerRoute the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder connectionsPerRoute(int connectionsPerRoute) {
            doSetProperty("connectionsPerRoute", connectionsPerRoute);
            return this;
        }
        /**
         * The maximum number of connections per route.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 20
         * Group: advanced
         * 
         * @param connectionsPerRoute the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder connectionsPerRoute(String connectionsPerRoute) {
            doSetProperty("connectionsPerRoute", connectionsPerRoute);
            return this;
        }
        /**
         * Sets a custom HttpClient to be used by the producer.
         * 
         * The option is a:
         * <code>org.apache.hc.client5.http.classic.HttpClient</code> type.
         * 
         * Group: advanced
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpClient(org.apache.hc.client5.http.classic.HttpClient httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Sets a custom HttpClient to be used by the producer.
         * 
         * The option will be converted to a
         * <code>org.apache.hc.client5.http.classic.HttpClient</code> type.
         * 
         * Group: advanced
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpClient(String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Register a custom configuration strategy for new HttpClient instances
         * created by producers or consumers such as to configure authentication
         * mechanisms etc.
         * 
         * The option is a:
         * <code>org.apache.camel.component.http.HttpClientConfigurer</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param httpClientConfigurer the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpClientConfigurer(org.apache.camel.component.http.HttpClientConfigurer httpClientConfigurer) {
            doSetProperty("httpClientConfigurer", httpClientConfigurer);
            return this;
        }
        /**
         * Register a custom configuration strategy for new HttpClient instances
         * created by producers or consumers such as to configure authentication
         * mechanisms etc.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.http.HttpClientConfigurer</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param httpClientConfigurer the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpClientConfigurer(String httpClientConfigurer) {
            doSetProperty("httpClientConfigurer", httpClientConfigurer);
            return this;
        }
        /**
         * To configure the HttpClient using the key/values from the Map. This
         * is a multi-value option with prefix: httpClient.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * httpClientOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpClientOptions(String key, Object value) {
            doSetMultiValueProperty("httpClientOptions", "httpClient." + key, value);
            return this;
        }
        /**
         * To configure the HttpClient using the key/values from the Map. This
         * is a multi-value option with prefix: httpClient.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * httpClientOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpClientOptions(Map values) {
            doSetMultiValueProperties("httpClientOptions", "httpClient.", values);
            return this;
        }
        /**
         * To configure the connection and the socket using the key/values from
         * the Map. This is a multi-value option with prefix: httpConnection.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * httpConnectionOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpConnectionOptions(String key, Object value) {
            doSetMultiValueProperty("httpConnectionOptions", "httpConnection." + key, value);
            return this;
        }
        /**
         * To configure the connection and the socket using the key/values from
         * the Map. This is a multi-value option with prefix: httpConnection.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * httpConnectionOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpConnectionOptions(Map values) {
            doSetMultiValueProperties("httpConnectionOptions", "httpConnection.", values);
            return this;
        }
        /**
         * To use a custom HttpContext instance.
         * 
         * The option is a:
         * <code>org.apache.hc.core5.http.protocol.HttpContext</code> type.
         * 
         * Group: advanced
         * 
         * @param httpContext the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpContext(org.apache.hc.core5.http.protocol.HttpContext httpContext) {
            doSetProperty("httpContext", httpContext);
            return this;
        }
        /**
         * To use a custom HttpContext instance.
         * 
         * The option will be converted to a
         * <code>org.apache.hc.core5.http.protocol.HttpContext</code> type.
         * 
         * Group: advanced
         * 
         * @param httpContext the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder httpContext(String httpContext) {
            doSetProperty("httpContext", httpContext);
            return this;
        }
        /**
         * The maximum number of connections.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 200
         * Group: advanced
         * 
         * @param maxTotalConnections the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder maxTotalConnections(int maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * The maximum number of connections.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 200
         * Group: advanced
         * 
         * @param maxTotalConnections the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder maxTotalConnections(String maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * To use System Properties as fallback for configuration for
         * configuring HTTP Client.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useSystemProperties the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder useSystemProperties(boolean useSystemProperties) {
            doSetProperty("useSystemProperties", useSystemProperties);
            return this;
        }
        /**
         * To use System Properties as fallback for configuration for
         * configuring HTTP Client.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useSystemProperties the value to set
         * @return the dsl builder
         */
        default AdvancedHttpEndpointBuilder useSystemProperties(String useSystemProperties) {
            doSetProperty("useSystemProperties", useSystemProperties);
            return this;
        }
    }

    public interface HttpBuilders {
        /**
         * HTTP (camel-http)
         * Send requests to external HTTP servers using Apache HTTP Client 5.x.
         * 
         * Category: http
         * Since: 2.3
         * Maven coordinates: org.apache.camel:camel-http
         * 
         * @return the dsl builder for the headers' name.
         */
        default HttpHeaderNameBuilder http() {
            return HttpHeaderNameBuilder.INSTANCE;
        }
        /**
         * HTTP (camel-http)
         * Send requests to external HTTP servers using Apache HTTP Client 5.x.
         * 
         * Category: http
         * Since: 2.3
         * Maven coordinates: org.apache.camel:camel-http
         * 
         * Syntax: <code>http://httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The url of the HTTP endpoint to call.
         * 
         * @param path httpUri
         * @return the dsl builder
         */
        default HttpEndpointBuilder http(String path) {
            return HttpEndpointBuilderFactory.endpointBuilder("http", path);
        }
        /**
         * HTTP (camel-http)
         * Send requests to external HTTP servers using Apache HTTP Client 5.x.
         * 
         * Category: http
         * Since: 2.3
         * Maven coordinates: org.apache.camel:camel-http
         * 
         * Syntax: <code>http://httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The url of the HTTP endpoint to call.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path httpUri
         * @return the dsl builder
         */
        default HttpEndpointBuilder http(String componentName, String path) {
            return HttpEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
        /**
         * HTTPS (Secure) (camel-http)
         * Send requests to external HTTP servers using Apache HTTP Client 5.x.
         * 
         * Category: http
         * Since: 2.3
         * Maven coordinates: org.apache.camel:camel-http
         * 
         * Syntax: <code>https://httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The url of the HTTP endpoint to call.
         * 
         * @param path httpUri
         * @return the dsl builder
         */
        default HttpEndpointBuilder https(String path) {
            return HttpEndpointBuilderFactory.endpointBuilder("https", path);
        }

    }
    /**
     * The builder of headers' name for the HTTP component.
     */
    public static class HttpHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final HttpHeaderNameBuilder INSTANCE = new HttpHeaderNameBuilder();

        /**
         * The HTTP content encoding. Is set on both the IN and OUT message to
         * provide a content encoding, such as gzip.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Content-Encoding}.
         */
        public String contentEncoding() {
            return "Content-Encoding";
        }
        /**
         * The HTTP response code from the external server. Is 200 for OK.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HttpResponseCode}.
         */
        public String httpResponseCode() {
            return "CamelHttpResponseCode";
        }
        /**
         * The HTTP response text from the external server.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HttpResponseText}.
         */
        public String httpResponseText() {
            return "CamelHttpResponseText";
        }
        /**
         * URI parameters. Will override existing URI parameters set directly on
         * the endpoint.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HttpQuery}.
         */
        public String httpQuery() {
            return "CamelHttpQuery";
        }
        /**
         * The version of the http protocol used.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HttpProtocolVersion}.
         */
        public String httpProtocolVersion() {
            return "CamelHttpProtocolVersion";
        }
        /**
         * The target host.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Host}.
         */
        public String host() {
            return "Host";
        }
        /**
         * The rest http URI.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code RestHttpUri}.
         */
        public String restHttpUri() {
            return "CamelRestHttpUri";
        }
        /**
         * URI to call. Will override existing URI set directly on the endpoint.
         * This uri is the uri of the http server to call. Its not the same as
         * the Camel endpoint uri, where you can configure endpoint options such
         * as security etc. This header does not support that, its only the uri
         * of the http server.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HttpUri}.
         */
        public String httpUri() {
            return "CamelHttpUri";
        }
        /**
         * Request URI's path, the header will be used to build the request URI
         * with the HTTP_URI.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HttpPath}.
         */
        public String httpPath() {
            return "CamelHttpPath";
        }
        /**
         * The rest http query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code RestHttpQuery}.
         */
        public String restHttpQuery() {
            return "CamelRestHttpQuery";
        }
        /**
         * The http raw query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HttpRawQuery}.
         */
        public String httpRawQuery() {
            return "CamelHttpRawQuery";
        }
        /**
         * The http method to use.
         * 
         * The option is a: {@code org.apache.camel.component.http.HttpMethods}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HttpMethod}.
         */
        public String httpMethod() {
            return "CamelHttpMethod";
        }
        /**
         * The character encoding.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HttpCharacterEncoding}.
         */
        public String httpCharacterEncoding() {
            return "CamelHttpCharacterEncoding";
        }
        /**
         * The HTTP content type. Is set on both the IN and OUT message to
         * provide a content type, such as text/html.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Content-Type}.
         */
        public String contentType() {
            return "Content-Type";
        }
    }
    static HttpEndpointBuilder endpointBuilder(String componentName, String path) {
        class HttpEndpointBuilderImpl extends AbstractEndpointBuilder implements HttpEndpointBuilder, AdvancedHttpEndpointBuilder {
            public HttpEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new HttpEndpointBuilderImpl(path);
    }
}