// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
package org.apache.cloudstack.framework.jobs.dao;

import java.util.Date;
import java.util.List;

import org.apache.cloudstack.framework.jobs.impl.VmWorkJobVO;
import org.apache.cloudstack.framework.jobs.impl.VmWorkJobVO.Step;

import com.cloud.utils.db.GenericDao;
import com.cloud.vm.VirtualMachine;

public interface VmWorkJobDao extends GenericDao<VmWorkJobVO, Long> {
    VmWorkJobVO findPendingWorkJob(VirtualMachine.Type type, long instanceId);

    List<VmWorkJobVO> listPendingWorkJobs(VirtualMachine.Type type, long instanceId);

    List<VmWorkJobVO> listPendingWorkJobs(VirtualMachine.Type type, long instanceId, String jobCmd);

    List<VmWorkJobVO> listPendingWorkJobs(VirtualMachine.Type type, long instanceId, String jobCmd, String secondaryObjectIdentifier);

    void updateStep(long workJobId, Step step);

    void expungeCompletedWorkJobs(Date cutDate);

    void expungeLeftoverWorkJobs(long msid);
}
