/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.help.OptionFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class OptionFormatterTest {
    OptionFormatterTest() {
    }

    public static Stream<Arguments> deprecatedAttributesData() {
        ArrayList<Arguments> lst = new ArrayList<Arguments>();
        DeprecatedAttributes.Builder daBuilder = DeprecatedAttributes.builder();
        lst.add(Arguments.of((Object[])new Object[]{daBuilder.get(), "[Deprecated]"}));
        daBuilder.setSince("now");
        lst.add(Arguments.of((Object[])new Object[]{daBuilder.get(), "[Deprecated since now]"}));
        daBuilder.setForRemoval(true);
        lst.add(Arguments.of((Object[])new Object[]{daBuilder.get(), "[Deprecated for removal since now]"}));
        daBuilder.setSince(null);
        lst.add(Arguments.of((Object[])new Object[]{daBuilder.get(), "[Deprecated for removal]"}));
        daBuilder.setForRemoval(false);
        daBuilder.setDescription("Use something else");
        lst.add(Arguments.of((Object[])new Object[]{daBuilder.get(), "[Deprecated. Use something else]"}));
        daBuilder.setForRemoval(true);
        lst.add(Arguments.of((Object[])new Object[]{daBuilder.get(), "[Deprecated for removal. Use something else]"}));
        daBuilder.setForRemoval(false);
        daBuilder.setSince("then");
        lst.add(Arguments.of((Object[])new Object[]{daBuilder.get(), "[Deprecated since then. Use something else]"}));
        daBuilder.setForRemoval(true);
        lst.add(Arguments.of((Object[])new Object[]{daBuilder.get(), "[Deprecated for removal since then. Use something else]"}));
        return lst.stream();
    }

    private void assertEquivalent(OptionFormatter formatter, OptionFormatter formatter2) {
        Assertions.assertEquals((Object)formatter.toSyntaxOption(), (Object)formatter2.toSyntaxOption());
        Assertions.assertEquals((Object)formatter.toSyntaxOption(true), (Object)formatter2.toSyntaxOption(true));
        Assertions.assertEquals((Object)formatter.toSyntaxOption(false), (Object)formatter2.toSyntaxOption(false));
        Assertions.assertEquals((Object)formatter.getOpt(), (Object)formatter2.getOpt());
        Assertions.assertEquals((Object)formatter.getLongOpt(), (Object)formatter2.getLongOpt());
        Assertions.assertEquals((Object)formatter.getBothOpt(), (Object)formatter2.getBothOpt());
        Assertions.assertEquals((Object)formatter.getDescription(), (Object)formatter2.getDescription());
        Assertions.assertEquals((Object)formatter.getArgName(), (Object)formatter2.getArgName());
        Assertions.assertEquals((Object)formatter.toOptional("foo"), (Object)formatter2.toOptional("foo"));
    }

    @Test
    void testAsOptional() {
        Option option = Option.builder().option("o").longOpt("opt").hasArg().get();
        OptionFormatter underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"[what]", (Object)underTest.toOptional("what"));
        Assertions.assertEquals((Object)"", (Object)underTest.toOptional(""), (String)"enpty string should return empty string");
        Assertions.assertEquals((Object)"", (Object)underTest.toOptional(null), (String)"null should return empty string");
        underTest = OptionFormatter.builder().setOptionalDelimiters("-> ", " <-").build(option);
        Assertions.assertEquals((Object)"-> what <-", (Object)underTest.toOptional("what"));
    }

    @Test
    void testAsSyntaxOption() {
        Option option = Option.builder().option("o").longOpt("opt").hasArg().get();
        OptionFormatter underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"[-o <arg>]", (Object)underTest.toSyntaxOption(), (String)"optional arg failed");
        option = Option.builder().option("o").longOpt("opt").hasArg().argName("other").get();
        underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"[-o <other>]", (Object)underTest.toSyntaxOption(), (String)"optional 'other' arg failed");
        option = Option.builder().option("o").longOpt("opt").hasArg().required().argName("other").get();
        underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"-o <other>", (Object)underTest.toSyntaxOption(), (String)"required 'other' arg failed");
        option = Option.builder().option("o").longOpt("opt").required().argName("other").get();
        underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"-o", (Object)underTest.toSyntaxOption(), (String)"required no arg failed");
        option = Option.builder().option("o").argName("other").get();
        underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"[-o]", (Object)underTest.toSyntaxOption(), (String)"optional no arg arg failed");
        option = Option.builder().longOpt("opt").hasArg().argName("other").get();
        underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"[--opt <other>]", (Object)underTest.toSyntaxOption(), (String)"optional longOpt 'other' arg failed");
        option = Option.builder().longOpt("opt").required().hasArg().argName("other").get();
        underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"--opt <other>", (Object)underTest.toSyntaxOption(), (String)"required longOpt 'other' arg failed");
        option = Option.builder().option("ot").longOpt("opt").hasArg().get();
        underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"[-ot <arg>]", (Object)underTest.toSyntaxOption(), (String)"optional multi char opt arg failed");
    }

    @Test
    void testCli343Part1() {
        Assertions.assertThrows(IllegalStateException.class, () -> Option.builder().required(false).build());
        Assertions.assertThrows(IllegalStateException.class, () -> Option.builder().required(false).get());
    }

    @Test
    void testCli343Part2() {
        Assertions.assertThrows(IllegalStateException.class, () -> Option.builder().desc("description").build());
        Assertions.assertThrows(IllegalStateException.class, () -> Option.builder().desc("description").get());
    }

    @ParameterizedTest(name="{index} {0}")
    @MethodSource(value={"deprecatedAttributesData"})
    void testComplexDeprecationFormat(DeprecatedAttributes da, String expected) {
        Option.Builder builder = Option.builder((String)"o").deprecated(da);
        Option.Builder builderWithDesc = Option.builder((String)"o").desc("The description").deprecated(da);
        Assertions.assertEquals((Object)expected, OptionFormatter.COMPLEX_DEPRECATED_FORMAT.apply(builder.get()));
        Assertions.assertEquals((Object)(expected + " The description"), OptionFormatter.COMPLEX_DEPRECATED_FORMAT.apply(builderWithDesc.get()));
    }

    @Test
    void testCopyConstructor() {
        Function<Option, String> depFunc = o -> "Ooo Deprecated";
        BiFunction<OptionFormatter, Boolean, String> fmtFunc = (o, b) -> "Yep, it worked";
        OptionFormatter.Builder builder = OptionFormatter.builder().setLongOptPrefix("l").setOptPrefix("s").setArgumentNameDelimiters("{", "}").setDefaultArgName("Some Argument").setOptSeparator(" and ").setOptionalDelimiters("?>", "<?").setSyntaxFormatFunction(fmtFunc).setDeprecatedFormatFunction(depFunc);
        Option option = Option.builder((String)"o").longOpt("opt").get();
        OptionFormatter formatter = builder.build(option);
        OptionFormatter.Builder builder2 = new OptionFormatter.Builder(formatter);
        this.assertEquivalent(formatter, builder2.build(option));
        option = Option.builder((String)"o").longOpt("opt").deprecated().required().get();
        formatter = builder.build(option);
        builder2 = new OptionFormatter.Builder(formatter);
        this.assertEquivalent(formatter, builder2.build(option));
    }

    @Test
    void testDefaultSyntaxFormat() {
        Option option = Option.builder().option("o").longOpt("opt").hasArg().get();
        OptionFormatter formatter = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"[-o <arg>]", (Object)formatter.toSyntaxOption());
        Assertions.assertEquals((Object)"-o <arg>", (Object)formatter.toSyntaxOption(true));
        option = Option.builder().option("o").longOpt("opt").hasArg().required().get();
        formatter = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"-o <arg>", (Object)formatter.toSyntaxOption());
        Assertions.assertEquals((Object)"[-o <arg>]", (Object)formatter.toSyntaxOption(false));
    }

    @Test
    void testGetBothOpt() {
        Option option = Option.builder().option("o").longOpt("opt").hasArg().get();
        OptionFormatter underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"-o, --opt", (Object)underTest.getBothOpt());
        option = Option.builder().longOpt("opt").hasArg().get();
        underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"--opt", (Object)underTest.getBothOpt());
        option = Option.builder().option("o").hasArg().get();
        underTest = OptionFormatter.from((Option)option);
        Assertions.assertEquals((Object)"-o", (Object)underTest.getBothOpt());
    }

    @Test
    void testGetDescription() {
        Option normalOption = Option.builder().option("o").longOpt("one").hasArg().desc("The description").get();
        Option deprecatedOption = Option.builder().option("o").longOpt("one").hasArg().desc("The description").deprecated().get();
        Option deprecatedOptionWithAttributes = Option.builder().option("o").longOpt("one").hasArg().desc("The description").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("now").setDescription("Use something else").get()).get();
        Assertions.assertEquals((Object)"The description", (Object)OptionFormatter.from((Option)normalOption).getDescription(), (String)"normal option failure");
        Assertions.assertEquals((Object)"The description", (Object)OptionFormatter.from((Option)deprecatedOption).getDescription(), (String)"deprecated option failure");
        Assertions.assertEquals((Object)"The description", (Object)OptionFormatter.from((Option)deprecatedOptionWithAttributes).getDescription(), (String)"complex deprecated option failure");
        OptionFormatter.Builder builder = OptionFormatter.builder().setDeprecatedFormatFunction(OptionFormatter.SIMPLE_DEPRECATED_FORMAT);
        Assertions.assertEquals((Object)"The description", (Object)builder.build(normalOption).getDescription(), (String)"normal option failure");
        Assertions.assertEquals((Object)"[Deprecated] The description", (Object)builder.build(deprecatedOption).getDescription(), (String)"deprecated option failure");
        Assertions.assertEquals((Object)"[Deprecated] The description", (Object)builder.build(deprecatedOptionWithAttributes).getDescription(), (String)"complex deprecated option failure");
        builder = OptionFormatter.builder().setDeprecatedFormatFunction(OptionFormatter.COMPLEX_DEPRECATED_FORMAT);
        Assertions.assertEquals((Object)"The description", (Object)builder.build(normalOption).getDescription(), (String)"normal option failure");
        Assertions.assertEquals((Object)"[Deprecated] The description", (Object)builder.build(deprecatedOption).getDescription(), (String)"deprecated option failure");
        Assertions.assertEquals((Object)"[Deprecated for removal since now. Use something else] The description", (Object)builder.build(deprecatedOptionWithAttributes).getDescription(), (String)"complex deprecated option failure");
    }

    @Test
    void testSetArgumentNameDelimiters() {
        Option option = Option.builder().option("o").longOpt("opt").hasArg().get();
        OptionFormatter.Builder builder = OptionFormatter.builder().setArgumentNameDelimiters("with argument named ", ".");
        Assertions.assertEquals((Object)"with argument named arg.", (Object)builder.build(option).getArgName());
        builder = OptionFormatter.builder().setArgumentNameDelimiters(null, "");
        Assertions.assertEquals((Object)"arg", (Object)builder.build(option).getArgName());
        builder = OptionFormatter.builder().setArgumentNameDelimiters("", null);
        Assertions.assertEquals((Object)"arg", (Object)builder.build(option).getArgName());
    }

    @Test
    void testSetDefaultArgName() {
        Option option = Option.builder().option("o").longOpt("opt").hasArg().get();
        OptionFormatter.Builder builder = OptionFormatter.builder().setDefaultArgName("foo");
        Assertions.assertEquals((Object)"<foo>", (Object)builder.build(option).getArgName());
        builder = OptionFormatter.builder().setDefaultArgName("");
        Assertions.assertEquals((Object)"<arg>", (Object)builder.build(option).getArgName());
        builder = OptionFormatter.builder().setDefaultArgName(null);
        Assertions.assertEquals((Object)"<arg>", (Object)builder.build(option).getArgName());
    }

    @Test
    void testSetLongOptPrefix() {
        Option option = Option.builder().option("o").longOpt("opt").hasArg().get();
        OptionFormatter.Builder builder = OptionFormatter.builder().setLongOptPrefix("fo");
        Assertions.assertEquals((Object)"foopt", (Object)builder.build(option).getLongOpt());
        builder = OptionFormatter.builder().setLongOptPrefix("");
        Assertions.assertEquals((Object)"opt", (Object)builder.build(option).getLongOpt());
        builder = OptionFormatter.builder().setLongOptPrefix(null);
        Assertions.assertEquals((Object)"opt", (Object)builder.build(option).getLongOpt());
    }

    @Test
    void testSetOptArgumentSeparator() {
        Option option = Option.builder().option("o").longOpt("opt").hasArg().get();
        OptionFormatter.Builder builder = OptionFormatter.builder().setOptArgSeparator(" with argument named ");
        Assertions.assertEquals((Object)"[-o with argument named <arg>]", (Object)builder.build(option).toSyntaxOption());
        builder = OptionFormatter.builder().setOptArgSeparator(null);
        Assertions.assertEquals((Object)"[-o<arg>]", (Object)builder.build(option).toSyntaxOption());
        builder = OptionFormatter.builder().setOptArgSeparator("=");
        Assertions.assertEquals((Object)"[-o=<arg>]", (Object)builder.build(option).toSyntaxOption());
    }

    @Test
    void testSetOptSeparator() {
        Option option = Option.builder().option("o").longOpt("opt").hasArg().get();
        OptionFormatter.Builder builder = OptionFormatter.builder().setOptSeparator(" and ");
        Assertions.assertEquals((Object)"-o and --opt", (Object)builder.build(option).getBothOpt());
        builder = OptionFormatter.builder().setOptSeparator("");
        Assertions.assertEquals((Object)"-o--opt", (Object)builder.build(option).getBothOpt(), (String)"Empty string should return default");
        builder = OptionFormatter.builder().setOptSeparator(null);
        Assertions.assertEquals((Object)"-o--opt", (Object)builder.build(option).getBothOpt(), (String)"null string should return default");
    }

    @Test
    void testSetSyntaxFormatFunction() {
        BiFunction<OptionFormatter, Boolean, String> func = (o, b) -> "Yep, it worked";
        Option option = Option.builder().option("o").longOpt("opt").hasArg().get();
        OptionFormatter.Builder builder = OptionFormatter.builder().setSyntaxFormatFunction(func);
        Assertions.assertEquals((Object)"Yep, it worked", (Object)builder.build(option).toSyntaxOption());
        builder = OptionFormatter.builder().setSyntaxFormatFunction(null);
        Assertions.assertEquals((Object)"[-o <arg>]", (Object)builder.build(option).toSyntaxOption());
    }
}

