/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LeafImplTest {
    private static final ByteOrder NBO = ByteOrder.nativeOrder();
    private static final ByteOrder NNBO = ResourceImpl.NON_NATIVE_BYTE_ORDER;
    private static final MemoryRequestServer myMemReqSvr = new DefaultMemoryRequestServer();

    public static ByteOrder otherByteOrder(ByteOrder order) {
        return order == ByteOrder.nativeOrder() ? NNBO : ByteOrder.nativeOrder();
    }

    @Test
    public void checkDirectLeafs() throws Exception {
        long off = 0L;
        long cap = 128L;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory memNO = WritableMemory.allocateDirect((long)cap, (long)8L, (ByteOrder)NBO, (MemoryRequestServer)myMemReqSvr, (Arena)arena);
            memNO.putShort(0L, (short)1);
            Assert.assertTrue((boolean)memNO.isDirect());
            LeafImplTest.checkCombinations(memNO, off, cap, memNO.isDirect(), NBO, false, true);
        }
        arena = Arena.ofConfined();
        try {
            WritableMemory memNNO = WritableMemory.allocateDirect((long)cap, (long)8L, (ByteOrder)NNBO, (MemoryRequestServer)myMemReqSvr, (Arena)arena);
            memNNO.putShort(0L, (short)1);
            Assert.assertTrue((boolean)memNNO.isDirect());
            LeafImplTest.checkCombinations(memNNO, off, cap, memNNO.isDirect(), NNBO, false, true);
        }
        finally {
            if (arena != null) {
                arena.close();
            }
        }
    }

    @Test
    public void checkByteBufferLeafs() {
        long off = 0L;
        long cap = 128L;
        ByteBuffer bb = ByteBuffer.allocate((int)cap);
        bb.order(NBO);
        bb.putShort(0, (short)1);
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)bb, (ByteOrder)NBO, (MemoryRequestServer)myMemReqSvr);
        Assert.assertEquals((boolean)bb.isDirect(), (boolean)mem.isDirect());
        LeafImplTest.checkCombinations(mem, off, cap, mem.isDirect(), mem.getTypeByteOrder(), true, false);
        ByteBuffer dbb = ByteBuffer.allocateDirect((int)cap);
        dbb.order(NBO);
        dbb.putShort(0, (short)1);
        mem = WritableMemory.writableWrap((ByteBuffer)dbb, (ByteOrder)NBO, (MemoryRequestServer)myMemReqSvr);
        Assert.assertEquals((boolean)dbb.isDirect(), (boolean)mem.isDirect());
        LeafImplTest.checkCombinations(mem, off, cap, mem.isDirect(), mem.getTypeByteOrder(), true, false);
        bb = ByteBuffer.allocate((int)cap);
        bb.order(NNBO);
        bb.putShort(0, (short)1);
        mem = WritableMemory.writableWrap((ByteBuffer)bb, (ByteOrder)NNBO, (MemoryRequestServer)myMemReqSvr);
        Assert.assertEquals((boolean)bb.isDirect(), (boolean)mem.isDirect());
        LeafImplTest.checkCombinations(mem, off, cap, mem.isDirect(), mem.getTypeByteOrder(), true, false);
        dbb = ByteBuffer.allocateDirect((int)cap);
        dbb.order(NNBO);
        dbb.putShort(0, (short)1);
        mem = WritableMemory.writableWrap((ByteBuffer)dbb, (ByteOrder)NNBO, (MemoryRequestServer)myMemReqSvr);
        Assert.assertEquals((boolean)dbb.isDirect(), (boolean)mem.isDirect());
        LeafImplTest.checkCombinations(mem, off, cap, mem.isDirect(), mem.getTypeByteOrder(), true, false);
    }

    @Test
    public void checkMapLeafs() throws IOException {
        long off = 0L;
        long cap = 128L;
        File file = File.createTempFile("TestFile2", "bin");
        file.deleteOnExit();
        Assert.assertTrue((boolean)file.setWritable(true, false));
        Assert.assertTrue((boolean)file.isFile());
        file.deleteOnExit();
        try (Arena arena = Arena.ofConfined();){
            WritableMemory memNO = WritableMemory.writableMap((File)file, (long)off, (long)cap, (ByteOrder)NBO, (Arena)arena);
            memNO.putShort(0L, (short)1);
            Assert.assertTrue((boolean)memNO.isDirect());
            LeafImplTest.checkCombinations(memNO, off, cap, memNO.isDirect(), NBO, false, false);
        }
        arena = Arena.ofConfined();
        try {
            WritableMemory memNNO = WritableMemory.writableMap((File)file, (long)off, (long)cap, (ByteOrder)NNBO, (Arena)arena);
            memNNO.putShort(0L, (short)1);
            Assert.assertTrue((boolean)memNNO.isDirect());
            LeafImplTest.checkCombinations(memNNO, off, cap, memNNO.isDirect(), NNBO, false, false);
        }
        finally {
            if (arena != null) {
                arena.close();
            }
        }
    }

    @Test
    public void checkHeapLeafs() {
        long off = 0L;
        long cap = 128L;
        WritableMemory memNO = WritableMemory.allocate((int)((int)cap), (ByteOrder)NBO, (MemoryRequestServer)myMemReqSvr);
        memNO.putShort(0L, (short)1);
        Assert.assertFalse((boolean)memNO.isDirect());
        LeafImplTest.checkCombinations(memNO, off, cap, memNO.isDirect(), NBO, false, true);
        WritableMemory memNNO = WritableMemory.allocate((int)((int)cap), (ByteOrder)NNBO, (MemoryRequestServer)myMemReqSvr);
        memNNO.putShort(0L, (short)1);
        Assert.assertFalse((boolean)memNNO.isDirect());
        LeafImplTest.checkCombinations(memNNO, off, cap, memNNO.isDirect(), NNBO, false, true);
    }

    private static void checkCombinations(WritableMemory mem, long off, long cap, boolean direct, ByteOrder bo, boolean fromByteBuffer, boolean hasMemReqSvr) {
        ByteOrder oo = LeafImplTest.otherByteOrder(bo);
        Assert.assertEquals((int)mem.writableRegion(off, cap, bo).getShort(0L), (int)1);
        Assert.assertEquals((int)mem.writableRegion(off, cap, oo).getShort(0L), (int)256);
        Assert.assertEquals((int)mem.asWritableBuffer(bo).getShort(0L), (int)1);
        Assert.assertEquals((int)mem.asWritableBuffer(oo).getShort(0L), (int)256);
        Assert.assertTrue((mem.getTypeByteOrder() == bo ? 1 : 0) != 0);
        if (fromByteBuffer) {
            Assert.assertTrue((boolean)mem.hasByteBuffer());
        } else {
            Assert.assertFalse((boolean)mem.hasByteBuffer());
        }
        if (hasMemReqSvr) {
            Assert.assertTrue((boolean)mem.hasMemoryRequestServer());
            Assert.assertTrue((boolean)(mem.getMemoryRequestServer() instanceof DefaultMemoryRequestServer));
        }
        if (direct) {
            Assert.assertTrue((boolean)mem.isDirect());
        } else {
            Assert.assertFalse((boolean)mem.isDirect());
        }
        Assert.assertTrue((mem.isAlive() ? 1 : 0) != 0);
        WritableBuffer buf = mem.asWritableBuffer();
        Assert.assertEquals((int)buf.writableRegion(off, cap, bo).getShort(0L), (int)1);
        Assert.assertEquals((int)buf.writableRegion(off, cap, oo).getShort(0L), (int)256);
        Assert.assertEquals((int)buf.writableDuplicate(bo).getShort(0L), (int)1);
        Assert.assertEquals((int)buf.writableDuplicate(oo).getShort(0L), (int)256);
        Assert.assertTrue((buf.getTypeByteOrder() == bo ? 1 : 0) != 0);
        if (fromByteBuffer) {
            Assert.assertTrue((boolean)buf.hasByteBuffer());
        }
        if (hasMemReqSvr) {
            Assert.assertTrue((boolean)buf.hasMemoryRequestServer());
            Assert.assertTrue((boolean)(buf.getMemoryRequestServer() instanceof DefaultMemoryRequestServer));
        }
        if (direct) {
            Assert.assertTrue((boolean)buf.isDirect());
        } else {
            Assert.assertFalse((boolean)buf.isDirect());
        }
        Assert.assertTrue((buf.isAlive() ? 1 : 0) != 0);
        WritableMemory nnMem = mem.writableRegion(off, cap, oo);
        Assert.assertEquals((int)nnMem.writableRegion(off, cap, bo).getShort(0L), (int)1);
        Assert.assertEquals((int)nnMem.writableRegion(off, cap, oo).getShort(0L), (int)256);
        Assert.assertEquals((int)nnMem.asWritableBuffer(bo).getShort(0L), (int)1);
        Assert.assertEquals((int)nnMem.asWritableBuffer(oo).getShort(0L), (int)256);
        Assert.assertTrue((nnMem.getTypeByteOrder() == oo ? 1 : 0) != 0);
        if (fromByteBuffer) {
            Assert.assertTrue((boolean)nnMem.hasByteBuffer());
        }
        if (hasMemReqSvr) {
            Assert.assertTrue((boolean)nnMem.hasMemoryRequestServer());
            Assert.assertTrue((boolean)(nnMem.getMemoryRequestServer() instanceof DefaultMemoryRequestServer));
        }
        if (direct) {
            Assert.assertTrue((boolean)nnMem.isDirect());
        } else {
            Assert.assertFalse((boolean)nnMem.isDirect());
        }
        Assert.assertTrue((nnMem.isAlive() ? 1 : 0) != 0);
        WritableBuffer nnBuf = mem.asWritableBuffer(oo);
        Assert.assertEquals((int)nnBuf.writableRegion(off, cap, bo).getShort(0L), (int)1);
        Assert.assertEquals((int)nnBuf.writableRegion(off, cap, oo).getShort(0L), (int)256);
        Assert.assertEquals((int)nnBuf.writableDuplicate(bo).getShort(0L), (int)1);
        Assert.assertEquals((int)nnBuf.writableDuplicate(oo).getShort(0L), (int)256);
        Assert.assertTrue((nnBuf.getTypeByteOrder() == oo ? 1 : 0) != 0);
        if (fromByteBuffer) {
            Assert.assertTrue((boolean)nnBuf.hasByteBuffer());
        }
        if (hasMemReqSvr) {
            Assert.assertTrue((boolean)(nnBuf.getMemoryRequestServer() instanceof DefaultMemoryRequestServer));
        }
        if (direct) {
            Assert.assertTrue((boolean)nnBuf.isDirect());
        } else {
            Assert.assertFalse((boolean)nnBuf.isDirect());
        }
        Assert.assertTrue((nnBuf.isAlive() ? 1 : 0) != 0);
    }
}

