/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MemoryBoundaryCheckTest {
    private WritableBuffer writableBuffer;

    @BeforeClass
    public void allocate() {
        this.writableBuffer = WritableMemory.allocate((int)8).asWritableBuffer();
    }

    @Test
    public void testGetByte() {
        this.writableBuffer.getByte(7L);
        try {
            this.writableBuffer.getByte(8L);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testPutByte() {
        this.writableBuffer.putByte(7L, (byte)1);
        try {
            this.writableBuffer.putByte(8L, (byte)1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetChar() {
        this.writableBuffer.getChar(6L);
        try {
            this.writableBuffer.getChar(7L);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testPutChar() {
        this.writableBuffer.putChar(6L, 'a');
        try {
            this.writableBuffer.putChar(7L, 'a');
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetShort() {
        this.writableBuffer.getShort(6L);
        try {
            this.writableBuffer.getShort(7L);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testPutShort() {
        this.writableBuffer.putShort(6L, (short)1);
        try {
            this.writableBuffer.putShort(7L, (short)1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetInt() {
        this.writableBuffer.getInt(4L);
        try {
            this.writableBuffer.getInt(5L);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testPutInt() {
        this.writableBuffer.putInt(4L, 1);
        try {
            this.writableBuffer.putInt(5L, 1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFloat() {
        this.writableBuffer.getFloat(4L);
        try {
            this.writableBuffer.getFloat(5L);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testPutFloat() {
        this.writableBuffer.putFloat(4L, 1.0f);
        try {
            this.writableBuffer.putFloat(5L, 1.0f);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetLong() {
        this.writableBuffer.getLong(0L);
        try {
            this.writableBuffer.getLong(1L);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testPutLong() {
        this.writableBuffer.putLong(0L, 1L);
        try {
            this.writableBuffer.putLong(1L, 1L);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDouble() {
        this.writableBuffer.getDouble(0L);
        try {
            this.writableBuffer.getDouble(1L);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testPutDouble() {
        this.writableBuffer.putDouble(0L, 1.0);
        try {
            this.writableBuffer.putDouble(1L, 1.0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

