/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.UtilForTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NonNativeWritableMemoryImplTest {
    private byte[] bArr = new byte[8];
    private final WritableMemory wmem = WritableMemory.writableWrap((byte[])this.bArr, (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);

    @Test
    public void checkPutGetNonNativeCharacters() {
        char[] srcArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        wmem.putChar(0L, srcArray[0]);
        wmem.putCharArray(2L, srcArray, 1, 2);
        wmem.putChar(6L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putChar((long)(i * 2), srcArray[i]);
        }
        WritableMemory wmem2 = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.copyTo(0L, wmem2, 0L, (long)(len * 2));
        for (int i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == Character.reverseBytes(wmem2.getChar((long)(i * 2))) ? 1 : 0) != 0);
        }
        char[] dstArray = new char[len];
        dstArray[0] = wmem.getChar(0L);
        wmem.getCharArray(2L, dstArray, 1, 2);
        dstArray[3] = wmem.getChar(6L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getChar((long)(i * 2));
        }
        Assert.assertEquals((char[])srcArray, (char[])dstArray);
    }

    @Test
    public void checkPutGetNonNativeDoubles() {
        double[] srcArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        wmem.putDouble(0L, srcArray[0]);
        wmem.putDoubleArray(8L, srcArray, 1, 2);
        wmem.putDouble(24L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putDouble((long)(i * 8), srcArray[i]);
        }
        WritableMemory wmem2 = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.copyTo(0L, wmem2, 0L, (long)(len * 8));
        for (int i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == UtilForTest.doubleReverseBytes(wmem2.getDouble((long)(i * 8))) ? 1 : 0) != 0);
        }
        double[] dstArray = new double[len];
        dstArray[0] = wmem.getDouble(0L);
        wmem.getDoubleArray(8L, dstArray, 1, 2);
        dstArray[3] = wmem.getDouble(24L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getDouble((long)(i * 8));
        }
        Assert.assertEquals((double[])srcArray, (double[])dstArray);
    }

    @Test
    public void checkPutGetNonNativeFloats() {
        float[] srcArray = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        wmem.putFloat(0L, srcArray[0]);
        wmem.putFloatArray(4L, srcArray, 1, 2);
        wmem.putFloat(12L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putFloat((long)(i * 4), srcArray[i]);
        }
        WritableMemory wmem2 = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.copyTo(0L, wmem2, 0L, (long)(len * 4));
        for (int i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == UtilForTest.floatReverseBytes(wmem2.getFloat((long)(i * 4))) ? 1 : 0) != 0);
        }
        float[] dstArray = new float[len];
        dstArray[0] = wmem.getFloat(0L);
        wmem.getFloatArray(4L, dstArray, 1, 2);
        dstArray[3] = wmem.getFloat(12L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getFloat((long)(i * 4));
        }
        Assert.assertEquals((float[])srcArray, (float[])dstArray);
    }

    @Test
    public void checkPutGetNonNativeInts() {
        int[] srcArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        wmem.putInt(0L, srcArray[0]);
        wmem.putIntArray(4L, srcArray, 1, 2);
        wmem.putInt(12L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putInt((long)(i * 4), srcArray[i]);
        }
        WritableMemory wmem2 = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.copyTo(0L, wmem2, 0L, (long)(len * 4));
        for (int i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == Integer.reverseBytes(wmem2.getInt((long)(i * 4))) ? 1 : 0) != 0);
        }
        int[] dstArray = new int[len];
        dstArray[0] = wmem.getInt(0L);
        wmem.getIntArray(4L, dstArray, 1, 2);
        dstArray[3] = wmem.getInt(12L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getInt((long)(i * 4));
        }
        Assert.assertEquals((int[])srcArray, (int[])dstArray);
    }

    @Test
    public void checkPutGetNonNativeLongs() {
        long[] srcArray = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        wmem.putLong(0L, srcArray[0]);
        wmem.putLongArray(8L, srcArray, 1, 2);
        wmem.putLong(24L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putLong((long)(i * 8), srcArray[i]);
        }
        WritableMemory wmem2 = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.copyTo(0L, wmem2, 0L, (long)(len * 8));
        for (int i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == Long.reverseBytes(wmem2.getLong((long)(i * 8))) ? 1 : 0) != 0);
        }
        long[] dstArray = new long[len];
        dstArray[0] = wmem.getLong(0L);
        wmem.getLongArray(8L, dstArray, 1, 2);
        dstArray[3] = wmem.getLong(24L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getLong((long)(i * 8));
        }
        Assert.assertEquals((long[])srcArray, (long[])dstArray);
    }

    @Test
    public void checkPutGetNonNativeShorts() {
        short[] srcArray = new short[]{1, 2, 3, 4, 5, 6, 7, 8};
        int len = srcArray.length;
        int half = len / 2;
        WritableMemory wmem = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        wmem.putShort(0L, srcArray[0]);
        wmem.putShortArray(2L, srcArray, 1, 2);
        wmem.putShort(6L, srcArray[3]);
        for (int i = half; i < len; ++i) {
            wmem.putShort((long)(i * 2), srcArray[i]);
        }
        WritableMemory wmem2 = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER);
        wmem.copyTo(0L, wmem2, 0L, (long)(len * 2));
        for (int i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == Short.reverseBytes(wmem2.getShort((long)(i * 2))) ? 1 : 0) != 0);
        }
        short[] dstArray = new short[len];
        dstArray[0] = wmem.getShort(0L);
        wmem.getShortArray(2L, dstArray, 1, 2);
        dstArray[3] = wmem.getShort(6L);
        for (int i = half; i < len; ++i) {
            dstArray[i] = wmem.getShort((long)(i * 2));
        }
        Assert.assertEquals((short[])srcArray, (short[])dstArray);
    }

    @Test
    public void checkRegion() {
        WritableMemory wreg = this.wmem.writableRegion(0L, this.wmem.getCapacity());
        Assert.assertEquals((Object)wreg.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
    }
}

