/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.jakarta.client.internal;

import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.HandshakeResponse;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.websocket.core.client.UpgradeListener;

public class JsrUpgradeListener
implements UpgradeListener {
    private final ClientEndpointConfig.Configurator configurator;

    public JsrUpgradeListener(ClientEndpointConfig.Configurator configurator) {
        this.configurator = configurator;
    }

    @Override
    public void onHandshakeRequest(Request request) {
        if (this.configurator == null) {
            return;
        }
        request.headers(headers -> {
            Map<String, List<String>> headersMap = HttpFields.asMap(headers);
            this.configurator.beforeRequest(headersMap);
        });
    }

    @Override
    public void onHandshakeResponse(Request request, Response response) {
        if (this.configurator == null) {
            return;
        }
        HandshakeResponse handshakeResponse = () -> HttpFields.asMap(response.getHeaders());
        this.configurator.afterResponse(handshakeResponse);
    }
}

