/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;

public class MemoryEstimationHelper {
    private static final long PARTIAL_PATH_INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(PartialPath.class);
    private static final long ALIGNED_PATH_INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AlignedPath.class);
    private static final long MEASUREMENT_PATH_INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AlignedPath.class);

    private MemoryEstimationHelper() {
    }

    public static long getEstimatedSizeOfAccountableObject(@Nullable Accountable accountable) {
        return accountable == null ? 0L : accountable.ramBytesUsed();
    }

    public static long getEstimatedSizeOfPartialPath(@Nullable PartialPath partialPath) {
        if (partialPath == null) {
            return 0L;
        }
        long totalSize = 0L;
        String[] nodes = partialPath.getNodes();
        if (nodes != null && nodes.length > 0) {
            totalSize += Arrays.stream(nodes).mapToLong(RamUsageEstimator::sizeOf).sum();
        }
        totalSize += RamUsageEstimator.sizeOf((String)partialPath.getDevice());
        totalSize += RamUsageEstimator.sizeOf((String)partialPath.getFullPath());
        if (partialPath instanceof AlignedPath) {
            totalSize += ALIGNED_PATH_INSTANCE_SIZE;
            AlignedPath alignedPath = (AlignedPath)partialPath;
            totalSize += alignedPath.getMeasurementList().stream().mapToLong(RamUsageEstimator::sizeOf).sum();
            totalSize += alignedPath.getSchemaList().stream().mapToLong(schema -> RamUsageEstimator.sizeOf((String)schema.getMeasurementId())).sum();
        } else if (partialPath instanceof MeasurementPath) {
            totalSize += MEASUREMENT_PATH_INSTANCE_SIZE;
            MeasurementPath measurementPath = (MeasurementPath)partialPath;
            totalSize += RamUsageEstimator.sizeOf((String)measurementPath.getMeasurementAlias());
            if (measurementPath.getMeasurementSchema() != null) {
                totalSize += RamUsageEstimator.sizeOf((String)measurementPath.getMeasurementSchema().getMeasurementId());
            }
        } else {
            totalSize += PARTIAL_PATH_INSTANCE_SIZE;
            totalSize += RamUsageEstimator.sizeOf((String)partialPath.getMeasurement());
        }
        return totalSize;
    }
}

