/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.consensus.common.Peer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusPeerManager {
    private static final String CONFIGURATION_FILE_NAME = "configuration.dat";
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusPeerManager.class);
    private final String storageDir;
    private final Set<Peer> peers;

    public PipeConsensusPeerManager(String storageDir, List<Peer> peers) {
        this.storageDir = storageDir;
        this.peers = Collections.newSetFromMap(new ConcurrentHashMap());
        this.peers.addAll(peers);
        if (this.peers.size() != peers.size()) {
            LOGGER.warn("Duplicate peers in the input list, ignore the duplicates.");
        }
    }

    public void recover() throws IOException {
        try (Stream<Path> pathStream = Files.walk(Paths.get(this.storageDir, new String[0]), 1, new FileVisitOption[0]);){
            Path[] configurationPaths;
            for (Path path2 : configurationPaths = (Path[])pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(CONFIGURATION_FILE_NAME)).toArray(Path[]::new)) {
                ByteBuffer readBuffer = ByteBuffer.wrap(Files.readAllBytes(path2));
                this.peers.add(Peer.deserialize(readBuffer));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist(Peer peer) throws IOException {
        File configurationFile = new File(this.storageDir, this.generateConfigurationFileName(peer));
        if (configurationFile.exists()) {
            LOGGER.warn("Configuration file {} already exists, delete it.", (Object)configurationFile);
            FileUtils.deleteFileOrDirectory((File)configurationFile);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(configurationFile);){
            try (DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);){
                peer.serialize(dataOutputStream);
            }
            finally {
                try {
                    fileOutputStream.flush();
                    fileOutputStream.getFD().sync();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String generateConfigurationFileName(Peer peer) {
        return peer.getNodeId() + "_" + CONFIGURATION_FILE_NAME;
    }

    public void persistAll() throws IOException {
        for (Peer peer : this.peers) {
            this.persist(peer);
        }
    }

    public boolean contains(Peer peer) {
        return this.peers.contains(peer);
    }

    public void addAndPersist(Peer peer) throws IOException {
        this.peers.add(peer);
        this.persist(peer);
    }

    public void removeAndPersist(Peer peer) throws IOException {
        Files.deleteIfExists(Paths.get(this.storageDir, this.generateConfigurationFileName(peer)));
        this.peers.remove(peer);
    }

    public List<Peer> getOtherPeers(Peer thisNode) {
        return (List)this.peers.stream().filter(peer -> !peer.equals(thisNode)).collect(ImmutableList.toImmutableList());
    }

    public List<Peer> getPeers() {
        return ImmutableList.copyOf(this.peers);
    }

    public void deleteAllFiles() throws IOException {
        IOException exception = null;
        for (Peer peer : this.peers) {
            try {
                Files.deleteIfExists(Paths.get(this.storageDir, this.generateConfigurationFileName(peer)));
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete configuration file for peer {}", (Object)peer, (Object)e);
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void clear() throws IOException {
        this.deleteAllFiles();
        this.peers.clear();
    }
}

