/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.client.container.PipeConsensusClientMgrContainer;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeConnectorRetryTimesConfigurableException;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.connector.protocol.IoTDBConnector;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeConnector;
import org.apache.iotdb.consensus.pipe.metric.PipeConsensusSyncLagManager;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.PipeConsensusSyncConnector;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.handler.PipeConsensusTabletBatchEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.handler.PipeConsensusTabletInsertNodeEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.handler.PipeConsensusTsFileInsertionEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.builder.PipeConsensusAsyncBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.request.PipeConsensusTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.request.PipeConsensusTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.consensus.PipeConsensusConnectorMetrics;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusAsyncConnector
extends IoTDBConnector
implements ConsensusPipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusAsyncConnector.class);
    private static final String ENQUEUE_EXCEPTION_MSG = "Timeout: PipeConsensusConnector offers an event into transferBuffer failed, because transferBuffer is full.";
    private static final String THRIFT_ERROR_FORMATTER_WITHOUT_ENDPOINT = "Failed to borrow client from client pool or exception occurred when sending to receiver.";
    private static final String THRIFT_ERROR_FORMATTER_WITH_ENDPOINT = "Failed to borrow client from client pool or exception occurred when sending to receiver %s:%s.";
    private static final IoTDBConfig IOTDB_CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final long PIPE_CONSENSUS_EVENT_ENQUEUE_TIMEOUT_IN_MS = IOTDB_CONFIG.getConnectionTimeoutInMS() / 6;
    private final BlockingQueue<Event> retryEventQueue = new LinkedBlockingQueue<Event>();
    private final BlockingQueue<EnrichedEvent> transferBuffer = new LinkedBlockingDeque<EnrichedEvent>(IOTDB_CONFIG.getPipeConsensusPipelineSize());
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final int thisDataNodeId = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
    private PipeConsensusConnectorMetrics pipeConsensusConnectorMetrics;
    private String consensusPipeName;
    private int consensusGroupId;
    private PipeConsensusSyncConnector retryConnector;
    private IClientManager<TEndPoint, AsyncPipeConsensusServiceClient> asyncTransferClientManager;
    private PipeConsensusAsyncBatchReqBuilder tabletBatchBuilder;
    private volatile long currentReplicateProgress = 0L;

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        PipeParameters parameters = validator.getParameters();
        validator.validate(args -> (Boolean)args[0] != false || (Boolean)args[1] != false, String.format("One of %s, %s must be specified in consensus pipe", "connector.consensus.group-id", "connector.consensus.pipe-name"), new Object[]{parameters.hasAttribute("connector.consensus.group-id"), parameters.hasAttribute("connector.consensus.pipe-name")});
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        this.consensusGroupId = parameters.getInt("connector.consensus.group-id");
        this.consensusPipeName = parameters.getString("connector.consensus.pipe-name");
        this.pipeConsensusConnectorMetrics = new PipeConsensusConnectorMetrics(this);
        PipeConsensusSyncLagManager.getInstance((String)this.getConsensusGroupIdStr()).addConsensusPipeConnector((ConsensusPipeConnector)this);
        MetricService.getInstance().addMetricSet((IMetricSet)this.pipeConsensusConnectorMetrics);
        this.retryConnector = new PipeConsensusSyncConnector(this.nodeUrls, this.consensusGroupId, this.thisDataNodeId, this.pipeConsensusConnectorMetrics);
        this.retryConnector.customize(parameters, configuration);
        this.asyncTransferClientManager = PipeConsensusClientMgrContainer.getInstance().getAsyncClientManager();
        if (this.isTabletBatchModeEnabled) {
            this.tabletBatchBuilder = new PipeConsensusAsyncBatchReqBuilder(parameters, new TConsensusGroupId(TConsensusGroupType.DataRegion, this.consensusGroupId), this.thisDataNodeId);
        }
        this.isTabletBatchModeEnabled = false;
    }

    private boolean addEvent2Buffer(EnrichedEvent event) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("PipeConsensus-ConsensusGroup-{}: no.{} event-{} added to connector buffer", new Object[]{this.consensusGroupId, event.getCommitId(), event});
            }
            if (this.transferBuffer.contains(event)) {
                return true;
            }
            long currentTime = System.nanoTime();
            boolean result = this.transferBuffer.offer(event, PIPE_CONSENSUS_EVENT_ENQUEUE_TIMEOUT_IN_MS, TimeUnit.MILLISECONDS);
            long duration = System.nanoTime() - currentTime;
            this.pipeConsensusConnectorMetrics.recordConnectorEnqueueTimer(duration);
            if (result) {
                event.increaseReferenceCount(PipeConsensusAsyncConnector.class.getName());
            }
            if (this.isClosed.get()) {
                event.clearReferenceCount(PipeConsensusAsyncConnector.class.getName());
            }
            return result;
        }
        catch (InterruptedException e) {
            LOGGER.info("PipeConsensusConnector transferBuffer queue offer is interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public synchronized void removeEventFromBuffer(EnrichedEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PipeConsensus-ConsensusGroup-{}: one event-{} successfully received by the follower, will be removed from queue, queue size = {}, limit size = {}", new Object[]{this.consensusGroupId, event, this.transferBuffer.size(), IOTDB_CONFIG.getPipeConsensusPipelineSize()});
        }
        if (this.transferBuffer.isEmpty()) {
            LOGGER.info("PipeConsensus-ConsensusGroup-{}: try to remove event-{} after pipeConsensusAsyncConnector being closed. Ignore it.", (Object)this.consensusGroupId, (Object)event);
            return;
        }
        Iterator iterator = this.transferBuffer.iterator();
        EnrichedEvent current = (EnrichedEvent)iterator.next();
        while (!current.equalsInPipeConsensus((Object)event) && iterator.hasNext()) {
            current = (EnrichedEvent)iterator.next();
        }
        iterator.remove();
        this.currentReplicateProgress = Math.max(this.currentReplicateProgress, event.getCommitId());
        event.decreaseReferenceCount(PipeConsensusAsyncConnector.class.getName(), true);
    }

    public void handshake() throws Exception {
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        this.syncTransferQueuedEventsIfNecessary();
        boolean enqueueResult = this.addEvent2Buffer((EnrichedEvent)tabletInsertionEvent);
        if (!enqueueResult) {
            throw new PipeRuntimeConnectorRetryTimesConfigurableException(ENQUEUE_EXCEPTION_MSG, Integer.MAX_VALUE);
        }
        if (this.isTabletBatchModeEnabled) {
            if (this.tabletBatchBuilder.onEvent(tabletInsertionEvent)) {
                PipeConsensusTabletBatchEventHandler pipeConsensusTabletBatchEventHandler = new PipeConsensusTabletBatchEventHandler(this.tabletBatchBuilder, this, this.pipeConsensusConnectorMetrics);
                this.transfer(pipeConsensusTabletBatchEventHandler);
                this.tabletBatchBuilder.onSuccess();
            }
        } else {
            TConsensusGroupId tConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, this.consensusGroupId);
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent;
            TCommitId tCommitId = new TCommitId(pipeInsertNodeTabletInsertionEvent.getCommitId(), pipeInsertNodeTabletInsertionEvent.getRebootTimes());
            if (!pipeInsertNodeTabletInsertionEvent.increaseReferenceCount(PipeConsensusAsyncConnector.class.getName())) {
                return;
            }
            InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible();
            ProgressIndex progressIndex = pipeInsertNodeTabletInsertionEvent.getProgressIndex();
            TPipeConsensusTransferReq pipeConsensusTransferReq = Objects.isNull(insertNode) ? PipeConsensusTabletBinaryReq.toTPipeConsensusTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer(), tCommitId, tConsensusGroupId, progressIndex, this.thisDataNodeId) : PipeConsensusTabletInsertNodeReq.toTPipeConsensusTransferReq(insertNode, tCommitId, tConsensusGroupId, progressIndex, this.thisDataNodeId);
            PipeConsensusTabletInsertNodeEventHandler pipeConsensusInsertNodeReqHandler = new PipeConsensusTabletInsertNodeEventHandler(pipeInsertNodeTabletInsertionEvent, pipeConsensusTransferReq, this, this.pipeConsensusConnectorMetrics);
            this.transfer(pipeConsensusInsertNodeReqHandler);
        }
    }

    private void transfer(PipeConsensusTabletBatchEventHandler pipeConsensusTabletBatchEventHandler) {
        AsyncPipeConsensusServiceClient client = null;
        try {
            client = (AsyncPipeConsensusServiceClient)this.asyncTransferClientManager.borrowClient((Object)this.getFollowerUrl());
            pipeConsensusTabletBatchEventHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeConsensusTabletBatchEventHandler.onError(ex);
        }
    }

    private void transfer(PipeConsensusTabletInsertNodeEventHandler pipeConsensusInsertNodeReqHandler) {
        AsyncPipeConsensusServiceClient client = null;
        try {
            client = (AsyncPipeConsensusServiceClient)this.asyncTransferClientManager.borrowClient((Object)this.getFollowerUrl());
            pipeConsensusInsertNodeReqHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeConsensusInsertNodeReqHandler.onError(ex);
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        this.syncTransferQueuedEventsIfNecessary();
        this.transferBatchedEventsIfNecessary();
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("PipeConsensusAsyncConnector only support PipeTsFileInsertionEvent. Current event: {}.", (Object)tsFileInsertionEvent);
            return;
        }
        boolean enqueueResult = this.addEvent2Buffer((EnrichedEvent)tsFileInsertionEvent);
        if (!enqueueResult) {
            throw new PipeRuntimeConnectorRetryTimesConfigurableException(ENQUEUE_EXCEPTION_MSG, Integer.MAX_VALUE);
        }
        PipeTsFileInsertionEvent pipeTsFileInsertionEvent = (PipeTsFileInsertionEvent)tsFileInsertionEvent;
        TCommitId tCommitId = new TCommitId(pipeTsFileInsertionEvent.getCommitId(), pipeTsFileInsertionEvent.getRebootTimes());
        TConsensusGroupId tConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, this.consensusGroupId);
        if (!pipeTsFileInsertionEvent.increaseReferenceCount(PipeConsensusAsyncConnector.class.getName())) {
            return;
        }
        try {
            if (!pipeTsFileInsertionEvent.getTsFile().exists()) {
                throw new FileNotFoundException(pipeTsFileInsertionEvent.getTsFile().getAbsolutePath());
            }
            PipeConsensusTsFileInsertionEventHandler pipeConsensusTsFileInsertionEventHandler = new PipeConsensusTsFileInsertionEventHandler(pipeTsFileInsertionEvent, this, tCommitId, tConsensusGroupId, this.thisDataNodeId, this.pipeConsensusConnectorMetrics);
            this.transfer(pipeConsensusTsFileInsertionEventHandler);
        }
        catch (Exception e) {
            pipeTsFileInsertionEvent.decreaseReferenceCount(PipeConsensusAsyncConnector.class.getName(), false);
            throw e;
        }
    }

    private void transfer(PipeConsensusTsFileInsertionEventHandler pipeConsensusTsFileInsertionEventHandler) {
        AsyncPipeConsensusServiceClient client = null;
        try {
            client = (AsyncPipeConsensusServiceClient)this.asyncTransferClientManager.borrowClient((Object)this.getFollowerUrl());
            pipeConsensusTsFileInsertionEventHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeConsensusTsFileInsertionEventHandler.onError(ex);
        }
    }

    public void transfer(Event event) throws Exception {
        this.syncTransferQueuedEventsIfNecessary();
        this.transferBatchedEventsIfNecessary();
        if (!(event instanceof PipeHeartbeatEvent)) {
            LOGGER.warn("PipeConsensusAsyncConnector does not support transferring generic event: {}.", (Object)event);
            return;
        }
        this.retryConnector.transfer(event);
    }

    private void transferBatchedEventsIfNecessary() throws IOException {
        if (!this.isTabletBatchModeEnabled || this.tabletBatchBuilder.isEmpty()) {
            return;
        }
        this.transfer(new PipeConsensusTabletBatchEventHandler(this.tabletBatchBuilder, this, this.pipeConsensusConnectorMetrics));
        this.tabletBatchBuilder.onSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncTransferQueuedEventsIfNecessary() throws Exception {
        while (!this.retryEventQueue.isEmpty()) {
            PipeConsensusAsyncConnector pipeConsensusAsyncConnector = this;
            synchronized (pipeConsensusAsyncConnector) {
                Event polledEvent;
                if (this.isClosed.get() || this.retryEventQueue.isEmpty()) {
                    return;
                }
                Event peekedEvent = (Event)this.retryEventQueue.peek();
                if (peekedEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                    this.retryConnector.transfer((PipeInsertNodeTabletInsertionEvent)peekedEvent);
                } else if (peekedEvent instanceof PipeRawTabletInsertionEvent) {
                    this.retryConnector.transfer((PipeRawTabletInsertionEvent)peekedEvent);
                } else if (peekedEvent instanceof PipeTsFileInsertionEvent) {
                    this.retryConnector.transfer((PipeTsFileInsertionEvent)peekedEvent);
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("PipeConsensusAsyncConnector does not support transfer generic event: {}.", (Object)peekedEvent);
                }
                if (peekedEvent instanceof EnrichedEvent) {
                    ((EnrichedEvent)peekedEvent).decreaseReferenceCount(PipeConsensusAsyncConnector.class.getName(), true);
                }
                if ((polledEvent = (Event)this.retryEventQueue.poll()) != peekedEvent && LOGGER.isErrorEnabled()) {
                    LOGGER.error("The event polled from the queue is not the same as the event peeked from the queue. Peeked event: {}, polled event: {}.", (Object)peekedEvent, (Object)polledEvent);
                }
                if (polledEvent != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Polled event {} from retry queue.", (Object)polledEvent);
                    }
                    this.removeEventFromBuffer((EnrichedEvent)polledEvent);
                }
            }
        }
    }

    public void addFailureEventToRetryQueue(Event event) {
        if (this.isClosed.get()) {
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).clearReferenceCount(PipeConsensusAsyncConnector.class.getName());
            }
            return;
        }
        this.retryEventQueue.offer(event);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PipeConsensus-ConsensusGroup-{}: Event {} transfer failed, will be added to retry queue.", (Object)this.consensusGroupId, (Object)event);
        }
        if (this.isClosed.get() && event instanceof EnrichedEvent) {
            ((EnrichedEvent)event).clearReferenceCount(PipeConsensusAsyncConnector.class.getName());
        }
    }

    public void addFailureEventsToRetryQueue(Iterable<Event> events) {
        for (Event event : events) {
            this.addFailureEventToRetryQueue(event);
        }
    }

    public synchronized void clearRetryEventsReferenceCount() {
        while (!this.retryEventQueue.isEmpty()) {
            Event event = (Event)this.retryEventQueue.poll();
            if (!(event instanceof EnrichedEvent)) continue;
            ((EnrichedEvent)event).clearReferenceCount(PipeConsensusAsyncConnector.class.getName());
        }
    }

    public synchronized void clearTransferBufferReferenceCount() {
        while (!this.transferBuffer.isEmpty()) {
            EnrichedEvent event = (EnrichedEvent)this.transferBuffer.poll();
            event.clearReferenceCount(PipeConsensusAsyncConnector.class.getName());
        }
    }

    private void logOnClientException(AsyncPipeConsensusServiceClient client, Exception e) {
        if (client == null) {
            LOGGER.warn(THRIFT_ERROR_FORMATTER_WITHOUT_ENDPOINT, (Throwable)e);
        } else {
            LOGGER.warn(String.format(THRIFT_ERROR_FORMATTER_WITH_ENDPOINT, client.getTEndpoint().getIp(), client.getTEndpoint().getPort()), (Throwable)e);
        }
    }

    private TEndPoint getFollowerUrl() {
        return (TEndPoint)this.nodeUrls.get(0);
    }

    public synchronized void close() {
        super.close();
        this.isClosed.set(true);
        this.retryConnector.close();
        this.clearRetryEventsReferenceCount();
        this.clearTransferBufferReferenceCount();
        if (this.tabletBatchBuilder != null) {
            this.tabletBatchBuilder.close();
        }
        PipeConsensusSyncLagManager.getInstance((String)this.getConsensusGroupIdStr()).removeConsensusPipeConnector((ConsensusPipeConnector)this);
        MetricService.getInstance().removeMetricSet((IMetricSet)this.pipeConsensusConnectorMetrics);
    }

    public int getTransferBufferSize() {
        return this.transferBuffer.size();
    }

    public int getRetryBufferSize() {
        return this.retryEventQueue.size();
    }

    public long getConsensusPipeCommitProgress() {
        return PipeEventCommitManager.getInstance().getGivenConsensusPipeCommitId(this.consensusPipeName, PipeDataNodeAgent.task().getPipeCreationTime(this.consensusPipeName), this.consensusGroupId);
    }

    public long getConsensusPipeReplicateProgress() {
        return this.currentReplicateProgress;
    }

    public String getConsensusGroupIdStr() {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.create((int)TConsensusGroupType.DataRegion.getValue(), (int)this.consensusGroupId);
        return groupId.toString();
    }
}

