/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.basic;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.Traverser;

public abstract class EntityTraverser<R, N extends IMNode<N>>
extends Traverser<R, N> {
    private boolean usingTemplate = false;
    private int schemaTemplateId = -1;

    public EntityTraverser(N startNode, PartialPath path, IMTreeStore<N> store, boolean isPrefixMatch, PathPatternTree scope) throws MetadataException {
        super(startNode, path, store, isPrefixMatch, scope);
    }

    protected boolean mayTargetNodeType(N node) {
        if (node.isDevice()) {
            return !this.usingTemplate || this.schemaTemplateId == node.getAsDeviceMNode().getSchemaTemplateId();
        }
        return false;
    }

    protected boolean acceptFullMatchedNode(N node) {
        if (node.isDevice()) {
            return !this.usingTemplate || this.schemaTemplateId == node.getAsDeviceMNode().getSchemaTemplateId();
        }
        return false;
    }

    protected boolean acceptInternalMatchedNode(N node) {
        return false;
    }

    protected boolean shouldVisitSubtreeOfFullMatchedNode(N node) {
        return !node.isMeasurement();
    }

    protected boolean shouldVisitSubtreeOfInternalMatchedNode(N node) {
        return !node.isMeasurement();
    }

    public void setSchemaTemplateFilter(int schemaTemplateId) {
        this.usingTemplate = true;
        this.schemaTemplateId = schemaTemplateId;
    }
}

