/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification;

import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;

public abstract class Modification {
    protected Type type;
    protected PartialPath path;
    protected long fileOffset;

    Modification(Type type, PartialPath path, long fileOffset) {
        this.type = type;
        this.path = path;
        this.fileOffset = fileOffset;
    }

    public String getPathString() {
        return this.path.getFullPath();
    }

    public PartialPath getPath() {
        return this.path;
    }

    public String getDevice() {
        return this.path.getDevice();
    }

    public String getMeasurement() {
        return this.path.getMeasurement();
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(long fileOffset) {
        this.fileOffset = fileOffset;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Modification)) {
            return false;
        }
        Modification mod = (Modification)obj;
        return mod.type.equals((Object)this.type) && mod.path.equals((Object)this.path) && mod.fileOffset == this.fileOffset;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.path, this.fileOffset});
    }

    public static enum Type {
        DELETION;

    }
}

