/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.xml;

import jakarta.validation.BootstrapConfiguration;
import jakarta.validation.ValidationException;
import jakarta.validation.executable.ExecutableType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.bval.jsr.BootstrapConfigurationImpl;
import org.apache.bval.jsr.ConfigurationImpl;
import org.apache.bval.jsr.metadata.XmlBuilder;
import org.apache.bval.jsr.xml.DefaultValidatedExecutableTypesType;
import org.apache.bval.jsr.xml.ExecutableValidationType;
import org.apache.bval.jsr.xml.PropertyType;
import org.apache.bval.jsr.xml.SchemaManager;
import org.apache.bval.jsr.xml.ValidationConfigType;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilizing;
import org.xml.sax.InputSource;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public class ValidationParser {
    private static final String DEFAULT_VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final Logger log = Logger.getLogger(ValidationParser.class.getName());
    private static final SchemaManager SCHEMA_MANAGER = new SchemaManager.Builder().add(XmlBuilder.Version.v10.getId(), "http://jboss.org/xml/ns/javax/validation/configuration", "META-INF/validation-configuration-1.0.xsd").add(XmlBuilder.Version.v11.getId(), "http://jboss.org/xml/ns/javax/validation/configuration", "META-INF/validation-configuration-1.1.xsd").add(XmlBuilder.Version.v20.getId(), "http://xmlns.jcp.org/xml/ns/validation/configuration", "META-INF/validation-configuration-2.0.xsd").add(XmlBuilder.Version.v30.getId(), "https://jakarta.ee/xml/ns/validation/configuration", "META-INF/validation-configuration-3.0.xsd").build();
    private final ClassLoader loader;

    private static String getValidationXmlFile(String file) {
        return file == null ? DEFAULT_VALIDATION_XML_FILE : file;
    }

    private static Map<String, String> toMap(List<PropertyType> property) {
        return property == null || property.isEmpty() ? Collections.emptyMap() : property.stream().collect(Collectors.toMap(PropertyType::getName, PropertyType::getValue));
    }

    public ValidationParser(ClassLoader loader) {
        this.loader = Validate.notNull(loader, null, new Object[0]);
    }

    public BootstrapConfiguration processValidationConfig(String file, ConfigurationImpl targetConfig) {
        boolean executableValidationEnabled;
        Set<ExecutableType> defaultValidatedExecutableTypes;
        ValidationConfigType xmlConfig = this.parseXmlConfig(file);
        if (xmlConfig == null) {
            return null;
        }
        if (xmlConfig.getExecutableValidation() == null) {
            defaultValidatedExecutableTypes = EnumSet.of(ExecutableType.IMPLICIT);
            executableValidationEnabled = true;
        } else {
            Optional<ExecutableValidationType> executableValidation = Optional.of(xmlConfig).map(ValidationConfigType::getExecutableValidation);
            executableValidationEnabled = executableValidation.map(ExecutableValidationType::getEnabled).filter(Predicate.isEqual(Boolean.TRUE)).isPresent();
            defaultValidatedExecutableTypes = executableValidation.filter(x -> executableValidationEnabled).map(ExecutableValidationType::getDefaultValidatedExecutableTypes).map(DefaultValidatedExecutableTypesType::getExecutableType).map(EnumSet::copyOf).orElse(EnumSet.noneOf(ExecutableType.class));
        }
        Set<String> constraintMappings = xmlConfig.getConstraintMapping().stream().map(s -> s.trim()).collect(Collectors.toSet());
        Set<String> valueExtractor = xmlConfig.getValueExtractor().stream().map(s -> s.trim()).collect(Collectors.toSet());
        String clockProvider = xmlConfig.getClockProvider() == null ? null : xmlConfig.getClockProvider().trim();
        String messageInterpolator = xmlConfig.getMessageInterpolator() == null ? null : xmlConfig.getMessageInterpolator().trim();
        String parameterNameProvider = xmlConfig.getParameterNameProvider() == null ? null : xmlConfig.getParameterNameProvider().trim();
        String traversableResolver = xmlConfig.getTraversableResolver() == null ? null : xmlConfig.getTraversableResolver().trim();
        String constraintValidatorFactory = xmlConfig.getConstraintValidatorFactory() == null ? null : xmlConfig.getConstraintValidatorFactory().trim();
        String defaultProvider = xmlConfig.getDefaultProvider() == null ? null : xmlConfig.getDefaultProvider().trim();
        return new BootstrapConfigurationImpl(defaultProvider, constraintValidatorFactory, messageInterpolator, traversableResolver, parameterNameProvider, constraintMappings, executableValidationEnabled, defaultValidatedExecutableTypes, ValidationParser.toMap(xmlConfig.getProperty()), clockProvider, valueExtractor);
    }

    public InputStream open(String mappingFileName) {
        if (mappingFileName.charAt(0) == '/') {
            mappingFileName = mappingFileName.substring(1);
        }
        try {
            InputStream in = this.getInputStream(mappingFileName);
            Exceptions.raiseIf(in == null, ValidationException::new, "Unable to open input stream for mapping file %s", mappingFileName);
            return in;
        }
        catch (IOException e) {
            throw Exceptions.create(ValidationException::new, e, "Unable to open input stream for mapping file %s", mappingFileName);
        }
    }

    InputStream getInputStream(String path) throws IOException {
        ArrayList<URL> urls = Collections.list(this.loader.getResources(path));
        Exceptions.raiseIf(urls.stream().distinct().count() > 1L, ValidationException::new, "More than one %s is found in the classpath", path);
        return urls.isEmpty() ? null : ((URL)urls.get(0)).openStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Privileged
    private ValidationConfigType parseXmlConfig(String validationXmlFile) {
        try (InputStream inputStream = this.getInputStream(ValidationParser.getValidationXmlFile(validationXmlFile));){
            if (inputStream == null) {
                log.log(Level.FINEST, String.format("No %s found. Using annotation based configuration only.", validationXmlFile));
                ValidationConfigType validationConfigType2 = null;
                return validationConfigType2;
            }
            log.log(Level.FINEST, String.format("%s found.", validationXmlFile));
            ValidationConfigType validationConfigType = SCHEMA_MANAGER.unmarshal(new InputSource(inputStream), ValidationConfigType.class);
            return validationConfigType;
        }
        catch (Exception e) {
            throw Exceptions.create(ValidationException::new, e, "Unable to parse %s", validationXmlFile);
        }
    }
}

