/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.elasticsearch.plugin.action.filter;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.elasticsearch.authorizer.RangerElasticsearchAuthorizer;
import org.apache.ranger.authorization.elasticsearch.plugin.utils.RequestUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSecurityActionFilter
extends AbstractLifecycleComponent
implements ActionFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RangerSecurityActionFilter.class);
    private final ThreadContext threadContext;
    private final RangerElasticsearchAuthorizer rangerElasticsearchAuthorizer = new RangerElasticsearchAuthorizer();

    public RangerSecurityActionFilter(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public int order() {
        return 0;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        String user = (String)this.threadContext.getTransient("username");
        if (StringUtils.isNotEmpty((String)user)) {
            List<String> indexs = RequestUtils.getIndexFromRequest(request);
            String clientIPAddress = (String)this.threadContext.getTransient("ClientIPAddress");
            for (String index : indexs) {
                boolean result = this.rangerElasticsearchAuthorizer.checkPermission(user, null, index, action, clientIPAddress);
                if (result) continue;
                String errorMsg = "Error: User[{}] could not do action[{}] on index[{}]";
                throw new ElasticsearchStatusException(errorMsg, RestStatus.FORBIDDEN, new Object[]{user, action, index});
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("User is null, no check permission for elasticsearch do action[{}] with request[{}]", (Object)action, request);
        }
        chain.proceed(task, action, request, listener);
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
    }
}

