/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.authorization.hbase.HbaseAuditHandler;
import org.apache.ranger.authorization.hbase.HbaseAuthUtils;
import org.apache.ranger.authorization.hbase.HbaseFactory;
import org.apache.ranger.authorization.hbase.HbaseUserUtils;
import org.apache.ranger.authorization.hbase.RangerHBasePlugin;
import org.apache.ranger.authorization.hbase.RangerHBaseResource;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationSession {
    private static final Logger LOG = LoggerFactory.getLogger((String)AuthorizationSession.class.getName());
    final HbaseFactory _factory = HbaseFactory.getInstance();
    final HbaseUserUtils _userUtils = this._factory.getUserUtils();
    final HbaseAuthUtils _authUtils = this._factory.getAuthUtils();
    final RangerHBasePlugin _authorizer;
    String _operation;
    String _otherInformation;
    String _access;
    String _table;
    String _column;
    String _columnFamily;
    String _remoteAddress;
    User _user;
    Set<String> _groups;
    HbaseAuditHandler _auditHandler = null;
    boolean _superUser = false;
    private RangerAccessRequest.ResourceMatchingScope _resourceMatchingScope = RangerAccessRequest.ResourceMatchingScope.SELF;
    private boolean _ignoreDescendantDeny = true;
    RangerAccessRequest _request;
    RangerAccessResult _result;

    public AuthorizationSession(RangerHBasePlugin authorizer) {
        this._authorizer = authorizer;
    }

    AuthorizationSession operation(String anOperation) {
        this._operation = anOperation;
        return this;
    }

    AuthorizationSession otherInformation(String information) {
        this._otherInformation = information;
        return this;
    }

    AuthorizationSession remoteAddress(String ipAddress) {
        this._remoteAddress = ipAddress;
        return this;
    }

    AuthorizationSession access(String anAccess) {
        this._access = anAccess;
        return this;
    }

    AuthorizationSession user(User aUser) {
        this._user = aUser;
        if (this._user == null) {
            LOG.warn("AuthorizationSession.user: user is null!");
            this._groups = null;
        } else {
            Object[] groups;
            this._groups = this._userUtils.getUserGroups(this._user);
            if (this._groups.isEmpty() && this._user.getUGI() != null && (groups = this._user.getUGI().getGroupNames()) != null) {
                this._groups = Sets.newHashSet((Object[])groups);
            }
            this._superUser = this._userUtils.isSuperUser(this._user);
        }
        return this;
    }

    AuthorizationSession table(String aTable) {
        this._table = aTable;
        return this;
    }

    AuthorizationSession columnFamily(String aColumnFamily) {
        this._columnFamily = aColumnFamily;
        return this;
    }

    AuthorizationSession column(String aColumn) {
        this._column = aColumn;
        return this;
    }

    void verifyBuildable() {
        String template = "Internal error: Incomplete/inconsisten state: [%s]. Can't build auth request!";
        if (this._factory == null) {
            String message = String.format(template, "factory is null");
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        if (this._access == null || this._access.isEmpty()) {
            String message = String.format(template, "access is null");
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        if (this._user == null) {
            String message = String.format(template, "user is null");
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        if (this.isProvided(this._columnFamily) && !this.isProvided(this._table)) {
            String message = String.format(template, "Table must be provided if column-family is provided");
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        if (this.isProvided(this._column) && !this.isProvided(this._columnFamily)) {
            String message = String.format(template, "Column family must be provided if column is provided");
            LOG.error(message);
            throw new IllegalStateException(message);
        }
    }

    void zapAuthorizationState() {
        this._request = null;
        this._result = null;
    }

    boolean isProvided(String aString) {
        return aString != null && !aString.isEmpty();
    }

    boolean isNameSpaceOperation() {
        return StringUtils.equals((String)this._operation, (String)"createNamespace") || StringUtils.equals((String)this._operation, (String)"deleteNamespace") || StringUtils.equals((String)this._operation, (String)"modifyNamespace") || StringUtils.equals((String)this._operation, (String)"setUserNamespaceQuota") || StringUtils.equals((String)this._operation, (String)"setNamespaceQuota") || StringUtils.equals((String)this._operation, (String)"getUserPermissionForNamespace");
    }

    private RangerAccessResource createHBaseResource() {
        RangerHBaseResource resource = new RangerHBaseResource();
        if (this.isNameSpaceOperation() && StringUtils.isNotBlank((String)this._otherInformation)) {
            resource.setValue("table", this._otherInformation + ":");
        } else {
            resource.setValue("table", this._table);
        }
        resource.setValue("column-family", this._columnFamily);
        resource.setValue("column", this._column);
        return resource;
    }

    private RangerAccessRequest createRangerRequest() {
        RangerAccessResource resource = this.createHBaseResource();
        String user = this._userUtils.getUserAsString(this._user);
        RangerAccessRequestImpl request = new RangerAccessRequestImpl(resource, this._access, user, this._groups, null);
        request.setAction(this._operation);
        request.setRequestData(this._otherInformation);
        request.setClientIPAddress(this._remoteAddress);
        request.setResourceMatchingScope(this._resourceMatchingScope);
        request.setAccessTime(new Date());
        request.setIgnoreDescendantDeny(Boolean.valueOf(this._ignoreDescendantDeny));
        return request;
    }

    AuthorizationSession buildRequest() {
        this.verifyBuildable();
        this.zapAuthorizationState();
        this._request = this.createRangerRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Built request: " + this._request.toString());
        }
        return this;
    }

    AuthorizationSession authorize() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AuthorizationSession.authorize: " + this.getRequestMessage());
        }
        if (this._request == null) {
            String message = String.format("Invalid state transition: buildRequest() must be called before authorize().  This request would ultimately get denied.!", new Object[0]);
            throw new IllegalStateException(message);
        }
        if (this._auditHandler != null && this._superUser) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting super-user override on audit handler");
            }
            this._auditHandler.setSuperUserOverride(this._superUser);
        }
        this._result = this._authorizer.isAccessAllowed(this._request, this._auditHandler);
        if (LOG.isDebugEnabled()) {
            boolean allowed = this.isAuthorized();
            String reason = this.getDenialReason();
            LOG.debug("<== AuthorizationSession.authorize: " + this.getLogMessage(allowed, reason));
        }
        return this;
    }

    void logCapturedEvents() {
        if (this._auditHandler != null) {
            List<AuthzAuditEvent> events = this._auditHandler.getCapturedEvents();
            this._auditHandler.logAuthzAudits(events);
        }
    }

    void publishResults() throws AccessDeniedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AuthorizationSession.publishResults()");
        }
        boolean authorized = this.isAuthorized();
        if (this._auditHandler != null && this.isAudited()) {
            ArrayList events = null;
            if (authorized) {
                ArrayList theseEvents = this._auditHandler.getCapturedEvents();
                if (theseEvents != null && !theseEvents.isEmpty()) {
                    events = theseEvents;
                }
            } else {
                AuthzAuditEvent event = this._auditHandler.getAndDiscardMostRecentEvent();
                if (event != null) {
                    events = Lists.newArrayList((Object[])new AuthzAuditEvent[]{event});
                }
            }
            if (LOG.isDebugEnabled()) {
                int size = events == null ? 0 : events.size();
                String auditMessage = events == null ? "" : ((Object)events).toString();
                String message = String.format("Writing %d messages to audit: [%s]", size, auditMessage);
                LOG.debug(message);
            }
            this._auditHandler.logAuthzAudits(events);
        }
        if (!authorized) {
            String reason = this.getDenialReason();
            String message = this.getLogMessage(false, reason);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AuthorizationSession.publishResults: throwing exception: " + message);
            }
            throw new AccessDeniedException("Insufficient permissions for user '" + this._user.getName() + "' (action=" + this._access + ")");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AuthorizationSession.publishResults()");
        }
    }

    boolean isAudited() {
        boolean audited = false;
        if (this._result == null) {
            String message = String.format("Internal error: _result was null!  Assuming no audit. Request[%s]", this._request.toString());
            LOG.error(message);
        } else {
            audited = this._result.getIsAudited();
        }
        return audited;
    }

    boolean isAuthorized() {
        boolean allowed = false;
        if (this._result == null) {
            String message = String.format("Internal error: _result was null! Returning false.", new Object[0]);
            LOG.error(message);
        } else {
            allowed = this._result.getIsAllowed();
        }
        if (!allowed && this._superUser) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("User [" + this._user + "] is a superUser!  Overriding policy engine's decision.  Request is deemed authorized!");
            }
            allowed = true;
        }
        return allowed;
    }

    String getDenialReason() {
        String reason = "";
        if (this._result == null) {
            String message = String.format("Internal error: _result was null!  Returning empty reason.", new Object[0]);
            LOG.error(message);
        } else {
            boolean allowed = this._result.getIsAllowed();
            if (!allowed) {
                reason = this._result.getReason();
            }
        }
        return reason;
    }

    String requestToString() {
        return MoreObjects.toStringHelper(this._request.getClass()).add("operation", (Object)this._operation).add("otherInformation", (Object)this._otherInformation).add("access", (Object)this._access).add("user", this._user == null ? null : this._user.getName()).add("groups", this._groups).add("auditHandler", this._auditHandler == null ? null : this._auditHandler.getClass().getSimpleName()).add("table", (Object)this._table).add("column", (Object)this._column).add("column-family", (Object)this._columnFamily).add("resource-matching-scope", (Object)this._resourceMatchingScope).add("ignoreDescendantDeny", this._ignoreDescendantDeny).toString();
    }

    String getPrintableValue(String value) {
        if (this.isProvided(value)) {
            return value;
        }
        return "";
    }

    String getRequestMessage() {
        String format = "Access[%s] by user[%s] belonging to groups[%s] to table[%s] for column-family[%s], column[%s] triggered by operation[%s], otherInformation[%s]";
        String user = this._userUtils.getUserAsString();
        String message = String.format(format, this.getPrintableValue(this._access), this.getPrintableValue(user), this._groups, this.getPrintableValue(this._table), this.getPrintableValue(this._columnFamily), this.getPrintableValue(this._column), this.getPrintableValue(this._operation), this.getPrintableValue(this._otherInformation));
        return message;
    }

    String getLogMessage(boolean allowed, String reason) {
        String format = " %s: status[%s], reason[%s]";
        String message = String.format(format, this.getRequestMessage(), allowed ? "allowed" : "denied", reason);
        return message;
    }

    AuthorizationSession auditHandler(HbaseAuditHandler anAuditHandler) {
        this._auditHandler = anAuditHandler;
        return this;
    }

    AuthorizationSession resourceMatchingScope(RangerAccessRequest.ResourceMatchingScope scope) {
        this._resourceMatchingScope = scope;
        return this;
    }

    AuthorizationSession ignoreDescendantDeny(boolean ignoreDescendantDeny) {
        this._ignoreDescendantDeny = ignoreDescendantDeny;
        return this;
    }

    public boolean getPropertyIsColumnAuthOptimizationEnabled() {
        return this._authorizer.getPropertyIsColumnAuthOptimizationEnabled();
    }
}

