/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Replica
extends ZkNodeProps {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String name;
    private final String nodeName;
    private final String core;
    public final Type type;
    public final String slice;
    public final String collection;
    private DocCollection.PrsSupplier prsSupplier;
    private State state;
    private static final Map<String, State> STATES = new HashMap<String, State>();

    void setPrsSupplier(DocCollection.PrsSupplier prsSupplier) {
        this.prsSupplier = prsSupplier;
    }

    public Replica(String name, Map<String, Object> propMap, String collection, String slice) {
        super(propMap);
        this.collection = collection;
        this.slice = slice;
        this.name = name;
        this.nodeName = (String)propMap.get("node_name");
        this.core = (String)propMap.get("core");
        this.type = Type.get((String)propMap.get("type"));
        Objects.requireNonNull(this.collection, "'collection' must not be null");
        Objects.requireNonNull(this.slice, "'slice' must not be null");
        Objects.requireNonNull(this.name, "'name' must not be null");
        Objects.requireNonNull(this.nodeName, "'node_name' must not be null");
        Objects.requireNonNull(this.core, "'core' must not be null");
        Objects.requireNonNull(this.type, "'type' must not be null");
        this.state = State.getState(String.valueOf(propMap.getOrDefault("state", State.ACTIVE.toString())));
    }

    public String getCollection() {
        return this.collection;
    }

    public String getSlice() {
        return this.slice;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Replica other = (Replica)o;
        return this.name.equals(other.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getCoreUrl() {
        return ZkCoreNodeProps.getCoreUrl(this.getBaseUrl(), this.core);
    }

    public String getBaseUrl() {
        return this.getStr("base_url");
    }

    public String getCoreName() {
        return this.core;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public State getState() {
        if (this.prsSupplier != null) {
            PerReplicaStates.State s = this.prsSupplier.get().get(this.name);
            if (s != null) {
                return s.state;
            }
            return State.DOWN;
        }
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
        this.propMap.put("state", this.state.toString());
    }

    public boolean isActive(Set<String> liveNodes) {
        return this.nodeName != null && liveNodes.contains(this.nodeName) && this.getState() == State.ACTIVE;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isLeader() {
        if (this.prsSupplier != null) {
            PerReplicaStates.State st = this.prsSupplier.get().get(this.name);
            return st == null ? false : st.isLeader;
        }
        return this.getBool("leader", false);
    }

    public String getProperty(String propertyName) {
        String propertyKey = !propertyName.startsWith("property.") ? "property." + propertyName : propertyName;
        String propertyValue = this.getStr(propertyKey);
        return propertyValue;
    }

    public Replica copyWith(PerReplicaStates.State state) {
        log.debug("A replica is updated with new state : {}", (Object)state);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(this.propMap);
        if (state == null) {
            props.put("state", State.DOWN.toString());
            props.remove("leader");
        } else {
            props.put("state", state.state.toString());
            if (state.isLeader.booleanValue()) {
                props.put("leader", "true");
            }
        }
        Replica r = new Replica(this.name, props, this.collection, this.slice);
        return r;
    }

    public PerReplicaStates.State getReplicaState() {
        if (this.prsSupplier != null) {
            return this.prsSupplier.get().get(this.name);
        }
        return null;
    }

    public static State getState(String c) {
        return STATES.get(c);
    }

    @Override
    public String toString() {
        return this.name + ':' + Utils.toJSONString(this.propMap);
    }

    static {
        STATES.put(State.ACTIVE.shortName, State.ACTIVE);
        STATES.put(State.DOWN.shortName, State.DOWN);
        STATES.put(State.RECOVERING.shortName, State.RECOVERING);
        STATES.put(State.RECOVERY_FAILED.shortName, State.RECOVERY_FAILED);
    }

    public static enum Type {
        NRT(true),
        TLOG(true),
        PULL(false);

        public final boolean leaderEligible;

        private Type(boolean b) {
            this.leaderEligible = b;
        }

        public static Type get(String name) {
            return name == null ? NRT : Type.valueOf(name.toUpperCase(Locale.ROOT));
        }
    }

    public static enum State {
        ACTIVE("A"),
        DOWN("D"),
        RECOVERING("R"),
        RECOVERY_FAILED("F");

        public final String shortName;

        private State(String c) {
            this.shortName = c;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static State getState(String stateStr) {
            return stateStr == null ? null : State.valueOf(stateStr.toUpperCase(Locale.ROOT));
        }
    }
}

