/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.servicecomb.demo.jaxrs.server;

import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.apache.servicecomb.provider.rest.common.RestSchema;

@RestSchema(schemaId = "FormRequestSchema")
@Path("/form")
@Produces(MediaType.APPLICATION_JSON)
public class FormRequestSchema {

  @Path("/formRequest")
  @POST
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public String formRequestSuccess(@FormParam("formData") String formData) throws Exception {
    return "formRequest success : " + formData.length();
  }

  @Path("/formLongName")
  @POST
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public String formLongName(@FormParam("F0123456789001234567890012345678900123456789001234567890"
      + "0123456789001234567890012345678900123456789001234567890") String formData) throws Exception {
    return "formRequest success : " + formData.length();
  }
}
