/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.springframework.core.env.Environment;

public final class SSLOption {
    public static final SSLOption DEFAULT_OPTION = new SSLOption();
    public static final String DEFAULT_CIPHERS = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";
    private String engine;
    private String protocols;
    private String ciphers;
    private boolean authPeer;
    private boolean checkCNHost;
    private boolean checkCNWhite;
    private String checkCNWhiteFile;
    private boolean allowRenegotiate;
    private String clientAuth;
    private String storePath;
    private String trustStore;
    private String trustStoreType;
    private String trustStoreValue;
    private String keyStore;
    private String keyStoreType;
    private String keyStoreValue;
    private String crl;
    private String sslCustomClass;

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void setProtocols(String protocols) {
        this.protocols = protocols;
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public void setAuthPeer(boolean authPeer) {
        this.authPeer = authPeer;
    }

    public void setCheckCNHost(boolean checkCNHost) {
        this.checkCNHost = checkCNHost;
    }

    public void setCheckCNWhite(boolean checkCNWhite) {
        this.checkCNWhite = checkCNWhite;
    }

    public void setCheckCNWhiteFile(String checkCNWhiteFile) {
        this.checkCNWhiteFile = checkCNWhiteFile;
    }

    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this.allowRenegotiate = allowRenegotiate;
    }

    public void setStorePath(String storePath) {
        this.storePath = storePath;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setTrustStoreValue(String trustStoreValue) {
        this.trustStoreValue = trustStoreValue;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setKeyStoreValue(String keyStoreValue) {
        this.keyStoreValue = keyStoreValue;
    }

    public void setCrl(String crl) {
        this.crl = crl;
    }

    public String getProtocols() {
        return this.protocols;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public boolean isAuthPeer() {
        return this.authPeer;
    }

    public boolean isCheckCNHost() {
        return this.checkCNHost;
    }

    public boolean isCheckCNWhite() {
        return this.checkCNWhite;
    }

    public String getCheckCNWhiteFile() {
        return this.checkCNWhiteFile;
    }

    public boolean isAllowRenegotiate() {
        return this.allowRenegotiate;
    }

    public String getStorePath() {
        return this.storePath;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStoreValue() {
        return this.trustStoreValue;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStoreValue() {
        return this.keyStoreValue;
    }

    public String getCrl() {
        return this.crl;
    }

    public static SSLOption build(String optionfile) {
        File file = new File(optionfile);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Bad file name.");
        }
        try {
            SSLOption option = new SSLOption();
            option.load(file.getCanonicalPath());
            return option;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Bad file name.");
        }
    }

    public static SSLOption build(InputStream inputStream) {
        SSLOption option = new SSLOption();
        option.load(inputStream);
        return option;
    }

    public static String getStringProperty(Environment environment, String defaultValue, String ... keys) {
        String key;
        String property = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && (property = environment.getProperty(key = stringArray[i])) == null; ++i) {
        }
        if (property != null) {
            return property;
        }
        return defaultValue;
    }

    private static boolean getBooleanProperty(Environment environment, boolean defaultValue, String ... keys) {
        String key;
        String property = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && (property = environment.getProperty(key = stringArray[i])) == null; ++i) {
        }
        if (property != null) {
            return Boolean.parseBoolean(property);
        }
        return defaultValue;
    }

    public static SSLOption build(String tag, Environment environment) {
        SSLOption option = new SSLOption();
        option.engine = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getEngine(), "ssl." + tag + ".engine", "ssl.engine");
        option.protocols = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getProtocols(), "ssl." + tag + ".protocols", "ssl.protocols");
        option.ciphers = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getCiphers(), "ssl." + tag + ".ciphers", "ssl.ciphers");
        option.authPeer = SSLOption.getBooleanProperty(environment, DEFAULT_OPTION.isAuthPeer(), "ssl." + tag + ".authPeer", "ssl.authPeer");
        option.checkCNHost = SSLOption.getBooleanProperty(environment, DEFAULT_OPTION.isCheckCNHost(), "ssl." + tag + ".checkCN.host", "ssl.checkCN.host");
        option.checkCNWhite = SSLOption.getBooleanProperty(environment, DEFAULT_OPTION.isCheckCNWhite(), "ssl." + tag + ".checkCN.white", "ssl.checkCN.white");
        option.checkCNWhiteFile = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getCiphers(), "ssl." + tag + ".checkCN.white.file", "ssl.checkCN.white.file");
        option.allowRenegotiate = SSLOption.getBooleanProperty(environment, DEFAULT_OPTION.isAllowRenegotiate(), "ssl." + tag + ".allowRenegotiate", "ssl.allowRenegotiate");
        option.storePath = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getStorePath(), "ssl." + tag + ".storePath", "ssl.storePath");
        option.clientAuth = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getClientAuth(), "ssl." + tag + ".storePath", "ssl.clientAuth");
        option.trustStore = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getTrustStore(), "ssl." + tag + ".trustStore", "ssl.trustStore");
        option.trustStoreType = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getTrustStoreType(), "ssl." + tag + ".trustStoreType", "ssl.trustStoreType");
        option.trustStoreValue = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getTrustStoreValue(), "ssl." + tag + ".trustStoreValue", "ssl.trustStoreValue");
        option.keyStore = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getKeyStore(), "ssl." + tag + ".keyStore", "ssl.keyStore");
        option.keyStoreType = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getKeyStoreType(), "ssl." + tag + ".keyStoreType", "ssl.keyStoreType");
        option.keyStoreValue = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getKeyStoreValue(), "ssl." + tag + ".keyStoreValue", "ssl.keyStoreValue");
        option.crl = SSLOption.getStringProperty(environment, DEFAULT_OPTION.getCrl(), "ssl." + tag + ".crl", "ssl.crl");
        option.sslCustomClass = SSLOption.getStringProperty(environment, null, "ssl." + tag + ".sslCustomClass", "ssl.sslCustomClass");
        return option;
    }

    private void fromProperty(Properties props) {
        this.protocols = this.propString(props, "ssl.protocols");
        this.ciphers = this.propString(props, "ssl.ciphers");
        this.authPeer = this.propBoolean(props, "ssl.authPeer");
        this.checkCNHost = this.propBoolean(props, "ssl.checkCN.host");
        this.checkCNWhite = this.propBoolean(props, "ssl.checkCN.white");
        this.checkCNWhiteFile = this.propString(props, "ssl.checkCN.white.file");
        this.allowRenegotiate = this.propBoolean(props, "ssl.allowRenegotiate");
        this.storePath = this.propString(props, "ssl.storePath");
        this.clientAuth = this.propString(props, "ssl.clientAuth", false);
        this.trustStore = this.propString(props, "ssl.trustStore");
        this.trustStoreType = this.propString(props, "ssl.trustStoreType");
        this.trustStoreValue = this.propString(props, "ssl.trustStoreValue");
        this.keyStore = this.propString(props, "ssl.keyStore");
        this.keyStoreType = this.propString(props, "ssl.keyStoreType");
        this.keyStoreValue = this.propString(props, "ssl.keyStoreValue");
        this.crl = this.propString(props, "ssl.crl");
        this.sslCustomClass = props.getProperty("ssl.sslCustomClass");
    }

    private String propString(Properties props, String key) {
        return this.propString(props, key, true);
    }

    private String propString(Properties props, String key, boolean required) {
        String s = props.getProperty(key);
        if (s == null && required) {
            throw new IllegalArgumentException("No key :" + key);
        }
        return s;
    }

    private boolean propBoolean(Properties props, String key) {
        String s = props.getProperty(key);
        if (s == null) {
            throw new IllegalArgumentException("No key :" + key);
        }
        return Boolean.parseBoolean(s);
    }

    private void load(InputStream inputStream) {
        Properties props = new Properties();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            props.load(reader);
            this.fromProperty(props);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not read ssl client config file");
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    this.ignore();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.ignore();
                }
            }
        }
    }

    void load(String path) {
        try {
            this.load(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Can not read ssl client config file: " + path);
        }
    }

    private void ignore() {
    }

    public String getSslCustomClass() {
        return this.sslCustomClass;
    }

    public void setSslCustomClass(String sslCustomClass) {
        this.sslCustomClass = sslCustomClass;
    }

    static {
        DEFAULT_OPTION.setEngine("jdk");
        DEFAULT_OPTION.setProtocols("TLSv1.2");
        DEFAULT_OPTION.setCiphers(DEFAULT_CIPHERS);
        DEFAULT_OPTION.setAuthPeer(false);
        DEFAULT_OPTION.setCheckCNHost(false);
        DEFAULT_OPTION.setCheckCNWhite(false);
        DEFAULT_OPTION.setCheckCNWhiteFile("white.list");
        DEFAULT_OPTION.setAllowRenegotiate(true);
        DEFAULT_OPTION.setStorePath("internal");
        DEFAULT_OPTION.setTrustStore("trust.jks");
        DEFAULT_OPTION.setTrustStoreType("JKS");
        DEFAULT_OPTION.setTrustStoreValue("trustStoreValue");
        DEFAULT_OPTION.setKeyStore("server.p12");
        DEFAULT_OPTION.setKeyStoreType("PKCS12");
        DEFAULT_OPTION.setKeyStoreValue("keyStoreValue");
        DEFAULT_OPTION.setCrl("revoke.crl");
    }
}

