/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public enum ParquetCompressionCodec {
    NONE(CompressionCodecName.UNCOMPRESSED),
    UNCOMPRESSED(CompressionCodecName.UNCOMPRESSED),
    SNAPPY(CompressionCodecName.SNAPPY),
    GZIP(CompressionCodecName.GZIP),
    LZO(CompressionCodecName.LZO),
    BROTLI(CompressionCodecName.BROTLI),
    LZ4(CompressionCodecName.LZ4),
    LZ4_RAW(CompressionCodecName.LZ4_RAW),
    ZSTD(CompressionCodecName.ZSTD);

    private final CompressionCodecName compressionCodec;
    private static final Map<String, String> codecNameMap;
    public static final List<ParquetCompressionCodec> availableCodecs;

    private ParquetCompressionCodec(CompressionCodecName compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public CompressionCodecName getCompressionCodec() {
        return this.compressionCodec;
    }

    public static ParquetCompressionCodec fromString(String s) {
        return ParquetCompressionCodec.valueOf(s.toUpperCase(Locale.ROOT));
    }

    public String lowerCaseName() {
        return codecNameMap.get(this.name());
    }

    static {
        codecNameMap = Arrays.stream(ParquetCompressionCodec.values()).collect(Collectors.toMap(codec -> codec.name(), codec -> codec.name().toLowerCase(Locale.ROOT)));
        availableCodecs = Arrays.asList(UNCOMPRESSED, SNAPPY, GZIP, ZSTD, LZ4, LZ4_RAW);
    }
}

