/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import java.util.List;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.handler.HttpGremlinResponseStreamDecoder;
import org.apache.tinkerpop.gremlin.driver.handler.InactiveChannelHandler;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;

public class HttpGremlinResponseDecoder
extends MessageToMessageDecoder<FullHttpResponse> {
    private static final String MESSAGE_NAME = "message";
    private final MessageSerializer<?> serializer;
    private final ObjectMapper mapper = new ObjectMapper();

    public HttpGremlinResponseDecoder(MessageSerializer<?> serializer) {
        this.serializer = serializer;
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpResponse msg, List<Object> out) throws Exception {
        ctx.channel().attr(InactiveChannelHandler.BYTES_READ).set((Object)0);
        ByteBuf content = msg.content();
        try {
            ResponseMessage response;
            if (HttpGremlinResponseDecoder.isError(msg.status()) && !this.serializer.mimeTypesSupported()[0].equals(msg.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE))) {
                String json = content.toString(CharsetUtil.UTF_8);
                JsonNode node = this.mapper.readTree(json);
                String message = node.has(MESSAGE_NAME) ? node.get(MESSAGE_NAME).asText() : "";
                response = ResponseMessage.build().code(msg.status()).statusMessage(message.isEmpty() ? msg.status().reasonPhrase() : message).create();
            } else {
                response = this.serializer.deserializeBinaryResponse(content);
            }
            ctx.channel().attr(HttpGremlinResponseStreamDecoder.IS_BULKED).set((Object)response.getResult().isBulked());
            out.add(response);
            out.add(Channelizer.HttpChannelizer.LAST_CONTENT_READ_RESPONSE);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isError(HttpResponseStatus status) {
        return status != HttpResponseStatus.OK;
    }
}

