/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.groovy.jsr223.TimedInterruptTimeoutException;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParserException;
import org.apache.tinkerpop.gremlin.process.traversal.Failure;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.ProcessingException;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.handler.HttpHandlerUtil;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.util.GremlinError;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.server.util.TraverserIterator;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.util.TemporaryException;
import org.apache.tinkerpop.gremlin.util.ExceptionHelper;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.ser.GraphBinaryMessageSerializerV4;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpGremlinEndpointHandler
extends SimpleChannelInboundHandler<RequestMessage> {
    private static final Logger logger = LoggerFactory.getLogger(HttpGremlinEndpointHandler.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit.org.apache.tinkerpop.gremlin.server");
    private static final Timer evalOpTimer = MetricManager.INSTANCE.getTimer(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"op", "eval"}));
    public static final long WRITE_PAUSE_TIME_MS = 10L;
    public static final Meter writePausesMeter = MetricManager.INSTANCE.getMeter(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"channels", "write-pauses"}));
    protected static final Set<String> INVALID_BINDINGS_KEYS = new HashSet<String>();
    private final GremlinExecutor gremlinExecutor;
    private final GraphManager graphManager;
    private final Settings settings;

    public HttpGremlinEndpointHandler(GremlinExecutor gremlinExecutor, GraphManager graphManager, Settings settings) {
        this.gremlinExecutor = gremlinExecutor;
        this.graphManager = graphManager;
        this.settings = settings;
    }

    public void channelRead0(ChannelHandlerContext ctx, RequestMessage requestMessage) {
        ctx.channel().attr(StateKey.HTTP_RESPONSE_SENT).set((Object)false);
        Pair serializer = (Pair)ctx.channel().attr(StateKey.SERIALIZER).get();
        Context requestCtx = new Context(requestMessage, ctx, this.settings, this.graphManager, this.gremlinExecutor, this.gremlinExecutor.getScheduledExecutorService(), RequestState.NOT_STARTED);
        Timer.Context timerContext = evalOpTimer.time();
        Long timeoutMs = (Long)requestMessage.getField("timeoutMs");
        long seto = null != timeoutMs ? timeoutMs.longValue() : requestCtx.getSettings().getEvaluationTimeout();
        FutureTask<Void> evalFuture = new FutureTask<Void>(() -> {
            requestCtx.setStartedResponse();
            try {
                logger.debug("Processing request containing script [{}] and bindings of [{}] on {}", new Object[]{requestMessage.getFieldOrDefault("gremlin", (Object)""), requestMessage.getFieldOrDefault("bindings", Collections.emptyMap()), Thread.currentThread().getName()});
                if (this.settings.enableAuditLog.booleanValue()) {
                    String address;
                    AuthenticatedUser user = (AuthenticatedUser)ctx.channel().attr(StateKey.AUTHENTICATED_USER).get();
                    if (null == user) {
                        user = AuthenticatedUser.ANONYMOUS_USER;
                    }
                    if ((address = ctx.channel().remoteAddress().toString()).startsWith("/") && address.length() > 1) {
                        address = address.substring(1);
                    }
                    auditLogger.info("User {} with address {} requested: {}", new Object[]{user.getName(), address, requestMessage.getGremlin()});
                }
                DefaultHttpResponse responseHeader = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                if (this.acceptsDeflateEncoding(((HttpHeaders)ctx.attr(StateKey.REQUEST_HEADERS).get()).getAll((CharSequence)HttpHeaderNames.ACCEPT_ENCODING))) {
                    responseHeader.headers().add((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.DEFLATE);
                }
                responseHeader.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                responseHeader.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, serializer.getValue0());
                ctx.writeAndFlush((Object)responseHeader);
                ctx.channel().attr(StateKey.HTTP_RESPONSE_SENT).set((Object)true);
                this.iterateScriptEvalResult(requestCtx, (MessageSerializer)serializer.getValue1(), requestMessage);
            }
            catch (Throwable t) {
                HttpHandlerUtil.writeError(requestCtx, this.formErrorResponseMessage(t, requestMessage), (MessageSerializer)serializer.getValue1());
            }
            finally {
                timerContext.stop();
                ScheduledFuture<?> timeoutFuture = requestCtx.getTimeoutExecutor();
                if (null != timeoutFuture) {
                    timeoutFuture.cancel(true);
                }
            }
            return null;
        });
        try {
            Future<?> executionFuture = requestCtx.getGremlinExecutor().getExecutorService().submit(evalFuture);
            if (seto > 0L) {
                requestCtx.setTimeoutExecutor(requestCtx.getScheduledExecutorService().schedule(() -> {
                    executionFuture.cancel(true);
                    if (!requestCtx.getStartedResponse()) {
                        HttpHandlerUtil.writeError(requestCtx, GremlinError.timeout(requestMessage), (MessageSerializer)serializer.getValue1());
                    }
                }, seto, TimeUnit.MILLISECONDS));
            }
        }
        catch (RejectedExecutionException ree) {
            HttpHandlerUtil.writeError(requestCtx, GremlinError.rateLimiting(), (MessageSerializer)serializer.getValue1());
        }
    }

    private GremlinError formErrorResponseMessage(Throwable t, RequestMessage requestMessage) {
        Optional<Throwable> possibleSpecialException;
        if (t instanceof UndeclaredThrowableException) {
            t = t.getCause();
        }
        if ((possibleSpecialException = this.determineIfSpecialException(t)).isPresent()) {
            Throwable special = possibleSpecialException.get();
            if (special instanceof TemporaryException) {
                return GremlinError.temporary(special);
            }
            if (special instanceof Failure) {
                return GremlinError.failStep((Failure)special);
            }
            return GremlinError.general(special);
        }
        if (t instanceof ProcessingException) {
            return ((ProcessingException)t).getError();
        }
        if ((t = ExceptionHelper.getRootCause((Throwable)t)) instanceof TooLongFrameException) {
            return GremlinError.longFrame(t);
        }
        if (t instanceof InterruptedException || t instanceof TraversalInterruptedException) {
            return GremlinError.timeout(requestMessage);
        }
        if (t instanceof TimedInterruptTimeoutException) {
            logger.warn(String.format("A timeout occurred within the script during evaluation of [%s] - consider increasing the limit given to TimedInterruptCustomizerProvider", requestMessage));
            return GremlinError.timedInterruptTimeout();
        }
        if (t instanceof TimeoutException) {
            logger.warn(String.format("Script evaluation exceeded the configured threshold for request [%s]", requestMessage));
            return GremlinError.timeout(requestMessage);
        }
        if (t instanceof MultipleCompilationErrorsException && t.getMessage().contains("Method too large") && ((MultipleCompilationErrorsException)t).getErrorCollector().getErrorCount() == 1) {
            GremlinError error = GremlinError.longRequest(requestMessage);
            logger.warn(error.getMessage());
            return error;
        }
        if (t instanceof GremlinParserException) {
            return GremlinError.parsing((GremlinParserException)t);
        }
        logger.warn(String.format("Exception processing request [%s].", requestMessage));
        return GremlinError.general(t);
    }

    private void iterateScriptEvalResult(Context context, MessageSerializer<?> serializer, RequestMessage message) throws ProcessingException, InterruptedException, ScriptException {
        boolean bulking;
        Map args;
        if (message.optionalField("bindings").isPresent()) {
            Map bindings = (Map)message.getFields().get("bindings");
            if (IteratorUtils.anyMatch(bindings.keySet().iterator(), k -> null == k || !(k instanceof String))) {
                throw new ProcessingException(GremlinError.binding());
            }
            Set badBindings = IteratorUtils.set((Iterator)IteratorUtils.filter(bindings.keySet().iterator(), INVALID_BINDINGS_KEYS::contains));
            if (!badBindings.isEmpty()) {
                throw new ProcessingException(GremlinError.binding(badBindings));
            }
            if (IteratorUtils.count((Iterator)IteratorUtils.filter(bindings.keySet().iterator(), k -> !k.toString().startsWith("#jsr223"))) > (long)this.settings.maxParameters) {
                throw new ProcessingException(GremlinError.binding(bindings.size(), this.settings.maxParameters));
            }
        }
        String language = (args = message.getFields()).containsKey("language") ? (String)args.get("language") : "gremlin-lang";
        GremlinScriptEngine scriptEngine = this.gremlinExecutor.getScriptEngineManager().getEngineByName(language);
        Bindings mergedBindings = this.mergeBindingsFromRequest(context, new SimpleBindings(this.graphManager.getAsBindings()));
        Object result = scriptEngine.eval(message.getGremlin(), mergedBindings);
        String bulkingSetting = ((HttpHeaders)context.getChannelHandlerContext().channel().attr(StateKey.REQUEST_HEADERS).get()).get("bulkResults");
        boolean bl = language.equals("gremlin-lang") && serializer instanceof GraphBinaryMessageSerializerV4 ? (args.containsKey("bulkResults") ? Objects.equals(args.get("bulkResults"), "true") : Objects.equals(bulkingSetting, "true")) : (bulking = false);
        if (bulking) {
            ((Traversal.Admin)result).applyStrategies();
            this.handleIterator(context, new TraverserIterator((Traversal.Admin)result), serializer, true);
        } else {
            this.handleIterator(context, IteratorUtils.asIterator((Object)result), serializer, false);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Error processing HTTP Request", cause);
        if (ctx.channel().isActive()) {
            HttpHandlerUtil.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, cause.getMessage());
        }
    }

    private Bindings mergeBindingsFromRequest(Context ctx, Bindings bindings) throws ProcessingException {
        RequestMessage msg = ctx.getRequestMessage();
        Optional.ofNullable((Map)msg.getFields().get("bindings")).ifPresent(bindings::putAll);
        if (msg.getFields().containsKey("g")) {
            TraversalSource ts;
            String aliased = (String)msg.getField("g");
            boolean found = false;
            Graph graph = ctx.getGraphManager().getGraph(aliased);
            if (null != graph) {
                bindings.put("g", (Object)graph);
                found = true;
            }
            if (!found && null != (ts = ctx.getGraphManager().getTraversalSource(aliased))) {
                bindings.put("g", (Object)ts);
                found = true;
            }
            if (!found) {
                throw new ProcessingException(GremlinError.binding(aliased));
            }
        }
        return bindings;
    }

    private void handleIterator(Context context, Iterator itty, MessageSerializer<?> serializer, boolean bulking) throws InterruptedException {
        ChannelHandlerContext nettyContext = context.getChannelHandlerContext();
        RequestMessage msg = context.getRequestMessage();
        Settings settings = context.getSettings();
        long lastWarningTime = 0L;
        int warnCounter = 0;
        if (!itty.hasNext()) {
            block16: {
                ByteBuf chunk = null;
                try {
                    chunk = HttpGremlinEndpointHandler.makeChunk(context, serializer, new ArrayList<Object>(), false, bulking);
                    nettyContext.writeAndFlush((Object)new DefaultHttpContent(chunk));
                }
                catch (Exception ex) {
                    if (chunk == null) break block16;
                    chunk.release();
                }
            }
            HttpHandlerUtil.sendTrailingHeaders(nettyContext, HttpResponseStatus.OK, "");
            return;
        }
        int resultIterationBatchSize = msg.optionalField("batchSize").orElse(settings.resultIterationBatchSize);
        ArrayList<Object> aggregate = new ArrayList<Object>(resultIterationBatchSize);
        boolean hasMore = itty.hasNext();
        while (hasMore) {
            long interval;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (aggregate.size() < resultIterationBatchSize && itty.hasNext()) {
                if (bulking) {
                    Traverser traverser = (Traverser)itty.next();
                    aggregate.add(traverser.get());
                    aggregate.add(traverser.bulk());
                } else {
                    aggregate.add(itty.next());
                }
            }
            if (!nettyContext.channel().isActive()) break;
            if (nettyContext.channel().isActive() && nettyContext.channel().isWritable()) {
                if (aggregate.size() != resultIterationBatchSize && itty.hasNext()) continue;
                ByteBuf chunk = null;
                try {
                    chunk = HttpGremlinEndpointHandler.makeChunk(context, serializer, aggregate, itty.hasNext(), bulking);
                }
                catch (Exception ex) {
                    if (chunk == null) break;
                    chunk.release();
                    break;
                }
                hasMore = itty.hasNext();
                try {
                    if (hasMore) {
                        aggregate = new ArrayList(resultIterationBatchSize);
                    }
                }
                catch (Exception ex) {
                    if (chunk != null) {
                        chunk.release();
                    }
                    throw ex;
                }
                nettyContext.writeAndFlush((Object)new DefaultHttpContent(chunk));
                if (hasMore) continue;
                HttpHandlerUtil.sendTrailingHeaders(nettyContext, HttpResponseStatus.OK, "");
                continue;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastWarningTime >= (interval = (long)Math.pow(2.0, warnCounter) * 1000L)) {
                Channel ch = context.getChannelHandlerContext().channel();
                logger.warn("Warning {}: Outbound buffer size={}, pausing response writing as writeBufferHighWaterMark exceeded on request {} for channel {} - writing will continue once client has caught up", new Object[]{warnCounter, ch.unsafe().outboundBuffer().totalPendingWriteBytes(), ch.attr(StateKey.REQUEST_ID), ch.id()});
                lastWarningTime = currentTime;
                ++warnCounter;
            }
            TimeUnit.MILLISECONDS.sleep(10L);
            writePausesMeter.mark();
        }
    }

    private Optional<Throwable> determineIfSpecialException(Throwable ex) {
        return Stream.of(ExceptionUtils.getThrowables((Throwable)ex)).filter(i -> i instanceof TemporaryException || i instanceof Failure).findFirst();
    }

    private boolean acceptsDeflateEncoding(List<String> encodings) {
        for (String encoding : encodings) {
            if (!encoding.contains(HttpHeaderValues.DEFLATE.toString())) continue;
            return true;
        }
        return false;
    }

    private static ByteBuf makeChunk(Context ctx, MessageSerializer<?> serializer, List<Object> aggregate, boolean hasMore, boolean bulking) throws Exception {
        try {
            ChannelHandlerContext nettyContext = ctx.getChannelHandlerContext();
            ctx.handleDetachment(aggregate);
            if (!hasMore && ctx.getRequestState() == RequestState.STREAMING) {
                ctx.setRequestState(RequestState.FINISHING);
            }
            ResponseMessage responseMessage = null;
            if (ctx.getRequestState() != RequestState.STREAMING) {
                ResponseMessage.Builder builder = ResponseMessage.build().result(aggregate);
                if (ctx.getRequestState() == RequestState.FINISHING) {
                    builder.code(HttpResponseStatus.OK);
                }
                builder.bulked(bulking);
                responseMessage = builder.create();
            }
            switch (ctx.getRequestState()) {
                case NOT_STARTED: {
                    if (hasMore) {
                        ctx.setRequestState(RequestState.STREAMING);
                        return serializer.writeHeader(responseMessage, nettyContext.alloc());
                    }
                    ctx.setRequestState(RequestState.FINISHED);
                    return serializer.serializeResponseAsBinary(ResponseMessage.build().result(aggregate).bulked(bulking).code(HttpResponseStatus.OK).create(), nettyContext.alloc());
                }
                case STREAMING: {
                    return serializer.writeChunk(aggregate, nettyContext.alloc());
                }
                case FINISHING: {
                    ctx.setRequestState(RequestState.FINISHED);
                    return serializer.writeFooter(responseMessage, nettyContext.alloc());
                }
            }
            return serializer.serializeResponseAsBinary(responseMessage, nettyContext.alloc());
        }
        catch (Exception ex) {
            UUID requestId = (UUID)ctx.getChannelHandlerContext().attr(StateKey.REQUEST_ID).get();
            logger.warn("The result [{}] in the request {} could not be serialized and returned.", new Object[]{aggregate, requestId, ex});
            HttpHandlerUtil.writeError(ctx, GremlinError.serialization(ex), serializer);
            throw ex;
        }
    }

    static {
        INVALID_BINDINGS_KEYS.addAll(Arrays.asList(T.id.name(), T.key.name(), T.label.name(), T.value.name(), T.id.getAccessor(), T.key.getAccessor(), T.label.getAccessor(), T.value.getAccessor(), T.id.getAccessor().toUpperCase(), T.key.getAccessor().toUpperCase(), T.label.getAccessor().toUpperCase(), T.value.getAccessor().toUpperCase()));
        for (Column column : Column.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Order.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Operator.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Scope.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Pop.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
    }

    public static enum RequestState {
        NOT_STARTED,
        STREAMING,
        FINISHING,
        FINISHED,
        ERROR;

    }
}

