/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.ListFunction;

public final class ConjoinStep<S>
extends ScalarMapStep<S, String>
implements ListFunction {
    private GValue<String> delimiter;

    public ConjoinStep(Traversal.Admin traversal, String delimiter) {
        this(traversal, GValue.of(null, delimiter));
    }

    public ConjoinStep(Traversal.Admin traversal, GValue<String> delimiter) {
        super(traversal);
        if (null == delimiter || null == delimiter.get()) {
            throw new IllegalArgumentException("Input delimiter to conjoin step can't be null.");
        }
        this.delimiter = delimiter;
    }

    @Override
    public String getStepName() {
        return "conjoin";
    }

    @Override
    protected String map(Traverser.Admin<S> traverser) {
        Collection elements = this.convertTraverserToCollection(traverser);
        if (elements.isEmpty()) {
            return "";
        }
        StringBuilder joinResult = new StringBuilder();
        for (Object elem : elements) {
            if (elem == null) continue;
            joinResult.append(elem).append(this.delimiter.get());
        }
        if (joinResult.length() != 0) {
            joinResult.delete(joinResult.length() - this.delimiter.get().length(), joinResult.length());
            return joinResult.toString();
        }
        return null;
    }

    public String getDelimiter() {
        return this.delimiter.get();
    }

    public GValue<String> getDelimiterGValue() {
        return this.delimiter;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public ConjoinStep<S> clone() {
        ConjoinStep clone = (ConjoinStep)super.clone();
        clone.delimiter = this.delimiter;
        return clone;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return Objects.hash(result, this.delimiter);
    }
}

