/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdScalarSerializer;

final class TraversalSerializersV4 {
    private TraversalSerializersV4() {
    }

    static final class EnumJacksonDeserializer<A extends Enum>
    extends StdDeserializer<A> {
        public EnumJacksonDeserializer(Class<A> enumClass) {
            super(enumClass);
        }

        public A deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Class enumClass = this._valueClass;
            String enumName = jsonParser.getText();
            for (Enum a : (Enum[])enumClass.getEnumConstants()) {
                if (!a.name().equals(enumName)) continue;
                return (A)a;
            }
            throw new IOException("Unknown enum type: " + enumClass);
        }

        public boolean isCachable() {
            return true;
        }
    }

    static final class BulkSetJacksonSerializer
    extends StdScalarSerializer<BulkSet> {
        public BulkSetJacksonSerializer() {
            super(BulkSet.class);
        }

        public void serialize(BulkSet bulkSet, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartArray();
            for (Object element : bulkSet) {
                jsonGenerator.writeObject(element);
            }
            jsonGenerator.writeEndArray();
        }
    }

    static class EnumJacksonSerializer
    extends StdScalarSerializer<Enum> {
        public EnumJacksonSerializer() {
            super(Enum.class);
        }

        public void serialize(Enum enumInstance, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(enumInstance.name());
        }
    }
}

