# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
# pylint: disable=redefined-builtin,wrong-import-position
"""
TVMC - TVM driver command-line interface
"""


class TVMCException(Exception):
    """TVMC Exception"""


class TVMCImportError(TVMCException):
    """TVMC TVMCImportError"""


from . import runner
from . import autotuner
from . import compiler
from . import result_utils
from .frontends import load_model as load
from .compiler import compile_model as compile
from .runner import run_module as run
from .autotuner import tune_model as tune
from .model import TVMCModel, TVMCPackage, TVMCResult
