type int = Int.int
functor MLLexFun (structure Tokens : ML_TOKENS)=
   struct
    structure UserDeclarations =
      struct
(* Heavily modified from the SML/NJ sources by sweeks@sweeks.com. *)

(* ml.lex
 *
 * Copyright 1989 by AT&T Bell Laboratories
 *
 * $Log: ml.lex,v $
 * Revision 1.3  1997/05/22  20:17:22  jhr
 * Changed lexer to accept "1e1" style floating-point literals.
 *
 * Revision 1.2  1997/01/28  23:20:40  jhr
 * Integer and word literals are now represented by IntInf.int (instead of
 * as strings).
 *
 *)

type int = Int.t

type svalue = Tokens.svalue
type pos = SourcePos.t
type lexresult = (svalue, pos) Tokens.token
type lexarg = {source: Source.t}
type arg = lexarg
type ('a,'b) token = ('a,'b) Tokens.token

val charlist: IntInf.t list ref = ref []
val colNum: int ref = ref 0
val commentLevel: int ref = ref 0
val commentStart = ref SourcePos.bogus
val lineFile: File.t ref = ref ""
val lineNum: int ref = ref 0
val stringStart = ref SourcePos.bogus
val stringtype = ref false

fun lineDirective (source, file, yypos) =
   Source.lineDirective (source, file,
                         {lineNum = !lineNum,
                          lineStart = yypos - !colNum})

fun addString (s: string) =
   charlist :=
   String.fold (s, !charlist, fn (c, ac) => Int.toIntInf (Char.ord c) :: ac)

fun addChar (c: char) = addString (String.fromChar c)

fun inc (ri as ref (i: int)) = ri := i + 1

fun dec (ri as ref (i: int)) = ri := i - 1

fun error (source, left, right, msg) = 
   Control.errorStr (Region.make {left = Source.getPos (source, left),
                                  right = Source.getPos (source, right)},
                     msg)

fun stringError (source, right, msg) =
   Control.errorStr (Region.make {left = !stringStart,
                                  right = Source.getPos (source, right)},
                     msg)

fun addOrd (i: IntInf.t): unit = List.push (charlist, i)

fun addHexEscape (s: string, source, yypos): unit =
   case StringCvt.scanString (Pervasive.IntInf.scan StringCvt.HEX) s of
      NONE => stringError (source, yypos, "illegal unicode escape")
    | SOME i => addOrd i

val eof: lexarg -> lexresult =
   fn {source, ...} =>
   let
      val pos = Source.lineStart source
      val _ =
         if !commentLevel > 0
            then Control.errorStr (Region.make {left = !commentStart,
                                                right = pos},
                                   "unclosed comment")
         else ()
   in
      Tokens.EOF (pos, pos)
   end

val size = String.size

fun tok (t, s, l, r) =
   let
      val l = Source.getPos (s, l)
      val r = Source.getPos (s, r)
      val _ =
         if true
            then ()
         else
            print (concat ["tok (",
                           SourcePos.toString l,
                           ", " ,
                           SourcePos.toString r,
                           ")\n"])
   in
      t (l, r)
   end

fun tok' (t, x, s, l) = tok (fn (l, r) => t (x, l, r), s, l, l + size x)

fun int (yytext, drop, source, yypos, {negate: bool}, radix) =
   Tokens.INT ({digits = String.dropPrefix (yytext, drop),
                negate = negate,
                radix = radix},
               Source.getPos (source, yypos),
               Source.getPos (source, yypos + size yytext))

fun word (yytext, drop, source, yypos, radix) =
   Tokens.WORD ({digits = String.dropPrefix (yytext, drop),
                 radix = radix},
                Source.getPos (source, yypos),
                Source.getPos (source, yypos + size yytext))


end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: int Vector.vector}
(* transition & final state table *)
val tab = let
fun decode s k =
  let val k' = k + k
      val hi = Char.ord(String.sub(s, k'))
      val lo = Char.ord(String.sub(s, k' + 1))
  in hi * 256 + lo end
val s = [ 
 (0,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (1,129, 
"\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\
\\000\017\001\041\001\044\000\017\001\041\001\043\000\017\000\017\
\\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\
\\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\
\\001\041\000\190\001\040\001\038\000\190\000\190\000\190\001\036\
\\001\028\001\027\000\190\000\190\001\026\001\024\001\021\000\190\
\\001\014\001\012\001\012\001\012\001\012\001\012\001\012\001\012\
\\001\012\001\012\001\010\001\009\000\190\001\007\000\190\000\190\
\\000\190\000\038\000\038\000\038\000\038\000\038\000\038\000\038\
\\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\
\\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\
\\000\038\000\038\000\038\001\006\000\190\001\005\000\190\000\191\
\\000\190\000\176\000\038\000\172\000\163\000\144\000\136\000\038\
\\000\130\000\118\000\038\000\038\000\111\000\038\000\105\000\095\
\\000\038\000\038\000\088\000\065\000\058\000\038\000\055\000\040\
\\000\038\000\038\000\038\000\037\000\036\000\035\000\018\000\017\
\\000\017"
),
 (3,129, 
"\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\050\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\048\001\045\001\046\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\
\\001\045"
),
 (5,129, 
"\001\051\001\051\001\051\001\051\001\051\001\051\001\051\001\051\
\\001\051\001\051\001\088\001\051\001\051\001\087\001\051\001\051\
\\001\051\001\051\001\051\001\051\001\051\001\051\001\051\001\051\
\\001\051\001\051\001\051\001\051\001\051\001\051\001\051\001\051\
\\001\052\001\052\001\086\001\052\001\052\001\052\001\052\001\052\
\\001\052\001\052\001\052\001\052\001\052\001\052\001\052\001\052\
\\001\052\001\052\001\052\001\052\001\052\001\052\001\052\001\052\
\\001\052\001\052\001\052\001\052\001\052\001\052\001\052\001\052\
\\001\052\001\052\001\052\001\052\001\052\001\052\001\052\001\052\
\\001\052\001\052\001\052\001\052\001\052\001\052\001\052\001\052\
\\001\052\001\052\001\052\001\052\001\052\001\052\001\052\001\052\
\\001\052\001\052\001\052\001\052\001\053\001\052\001\052\001\052\
\\001\052\001\052\001\052\001\052\001\052\001\052\001\052\001\052\
\\001\052\001\052\001\052\001\052\001\052\001\052\001\052\001\052\
\\001\052\001\052\001\052\001\052\001\052\001\052\001\052\001\052\
\\001\052\001\052\001\052\001\052\001\052\001\052\001\052\001\051\
\\001\051"
),
 (7,129, 
"\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\091\001\094\001\089\001\091\001\093\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\091\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\090\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\
\\001\089"
),
 (9,129, 
"\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\000\000\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\098\001\095\001\095\001\095\001\095\001\095\
\\001\096\001\096\001\096\001\096\001\096\001\096\001\096\001\096\
\\001\096\001\096\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095"
),
 (11,129, 
"\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\000\000\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\103\001\100\
\\001\101\001\101\001\101\001\101\001\101\001\101\001\101\001\101\
\\001\101\001\101\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100\001\100\001\100\001\100\001\100\001\100\001\100\001\100\
\\001\100"
),
 (13,129, 
"\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\107\000\000\001\095\001\107\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\107\001\095\001\106\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\104\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095\001\095\001\095\001\095\001\095\001\095\001\095\001\095\
\\001\095"
),
 (15,129, 
"\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\111\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\114\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\112\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110\001\110\001\110\001\110\001\110\001\110\001\110\001\110\
\\001\110"
),
 (18,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\019\000\000\000\019\000\019\000\019\000\019\000\000\
\\000\000\000\000\000\019\000\019\000\000\000\019\000\020\000\019\
\\000\032\000\023\000\023\000\023\000\023\000\023\000\023\000\023\
\\000\023\000\023\000\019\000\000\000\019\000\019\000\019\000\019\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\000"
),
 (19,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\019\000\000\000\019\000\019\000\019\000\019\000\000\
\\000\000\000\000\000\019\000\019\000\000\000\019\000\020\000\019\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\019\000\000\000\019\000\019\000\019\000\019\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\000"
),
 (20,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\021\000\000\000\021\000\021\000\021\000\021\000\000\
\\000\000\000\000\000\021\000\021\000\000\000\021\000\000\000\021\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\021\000\000\000\021\000\021\000\021\000\021\
\\000\021\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\000\000\021\000\000\000\021\000\000\
\\000\021\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\000\000\021\000\000\000\021\000\000\
\\000\000"
),
 (21,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\021\000\000\000\021\000\021\000\021\000\021\000\000\
\\000\000\000\000\000\021\000\021\000\000\000\021\000\020\000\021\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\021\000\000\000\021\000\021\000\021\000\021\
\\000\021\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\021\000\000\000\021\000\000\
\\000\021\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\021\000\000\000\021\000\000\
\\000\000"
),
 (22,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\022\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\000\000\000\000\000\000\000\000\022\
\\000\000\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\
\\000\022\000\022\000\022\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (23,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\027\000\000\
\\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\
\\000\023\000\023\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\024\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\024\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (24,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\026\000\026\000\026\000\026\000\026\000\026\000\026\000\026\
\\000\026\000\026\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\025\000\000\
\\000\000"
),
 (25,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\026\000\026\000\026\000\026\000\026\000\026\000\026\000\026\
\\000\026\000\026\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (27,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\028\000\028\000\028\000\028\000\028\000\028\000\028\000\028\
\\000\028\000\028\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (28,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\028\000\028\000\028\000\028\000\028\000\028\000\028\000\028\
\\000\028\000\028\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\029\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\029\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (29,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\
\\000\031\000\031\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\030\000\000\
\\000\000"
),
 (30,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\
\\000\031\000\031\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (32,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\027\000\000\
\\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\
\\000\023\000\023\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\024\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\024\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\033\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (33,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\034\000\034\000\034\000\034\000\034\000\034\000\034\000\034\
\\000\034\000\034\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\034\000\034\000\034\000\034\000\034\000\034\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\034\000\034\000\034\000\034\000\034\000\034\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (38,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (40,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\048\000\041\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (41,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\042\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (42,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\043\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (43,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\044\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (44,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\045\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (45,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\046\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (46,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\047\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (48,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\052\000\039\000\039\
\\000\039\000\049\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (49,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\050\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (50,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\051\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (52,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\053\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (53,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\054\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (55,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\056\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (56,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\057\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (58,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\062\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\059\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (59,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\060\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (60,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\061\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (62,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\063\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (63,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\064\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (65,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\082\000\074\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\066\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (66,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\067\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (67,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\068\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (68,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\069\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (69,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\070\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (70,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\071\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (71,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\072\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (72,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\073\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (74,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\075\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (75,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\076\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (76,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\077\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (77,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\078\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (78,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\079\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (79,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\080\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (80,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\081\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (82,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\083\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (83,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\084\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (84,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\085\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (85,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\086\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (86,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\087\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (88,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\091\000\039\000\039\000\039\000\089\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (89,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\090\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (91,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\092\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (92,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\093\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (93,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\094\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (95,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\104\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\101\000\039\000\096\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (96,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\097\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (97,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\098\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (98,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\099\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (99,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\100\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (101,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\102\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (102,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\103\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (105,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\106\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (106,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\107\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (107,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\108\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (108,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\109\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (109,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\110\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (111,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\116\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\112\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (112,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\113\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (113,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\114\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (114,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\115\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (116,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\117\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (118,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\129\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\119\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (119,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\124\000\039\000\039\000\120\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (120,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\121\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (121,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\122\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (122,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\123\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (124,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\125\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (125,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\126\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (126,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\127\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (127,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\128\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (130,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\131\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (131,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\132\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (132,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\133\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (133,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\134\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (134,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\135\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (136,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\143\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\137\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (137,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\138\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (138,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\139\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (139,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\140\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (140,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\141\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (141,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\142\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (144,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\160\000\039\000\158\000\039\
\\000\039\000\153\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\145\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (145,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\146\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (146,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\147\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (147,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\148\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (148,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\149\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (149,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\150\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (150,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\151\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (151,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\152\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (153,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\154\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (154,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\155\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (155,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\156\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (156,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\157\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (158,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\159\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (160,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\161\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (161,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\162\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (163,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\165\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\164\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (165,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\166\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (166,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\167\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (167,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\168\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (168,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\169\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (169,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\170\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (170,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\171\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (172,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\173\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (173,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\174\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (174,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\175\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (176,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\184\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\178\000\039\
\\000\039\000\039\000\039\000\177\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (178,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\179\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (179,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\180\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (180,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\181\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (181,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\182\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (182,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\183\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (184,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\185\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (185,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\186\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (186,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\187\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (187,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\188\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (188,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\039\
\\000\000\000\039\000\039\000\039\000\039\000\189\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\
\\000\039\000\039\000\039\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (191,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\254\000\243\000\222\000\000\000\216\000\000\000\000\
\\000\000\000\210\000\000\000\000\000\000\000\000\000\000\000\202\
\\000\198\000\000\000\000\000\192\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (192,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\193\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (193,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\194\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (194,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\195\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (195,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\196\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (196,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\197\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (198,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\199\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (199,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\200\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (200,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\201\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (202,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\203\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (203,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\204\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (204,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\205\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (205,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\206\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (206,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\207\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (207,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\208\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (208,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\209\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (210,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\211\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (211,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\212\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (212,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\213\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (213,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\214\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (214,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\215\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (216,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\217\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (217,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\218\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (218,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\219\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (219,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\220\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (220,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\221\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (222,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\223\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (223,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\227\000\224\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (224,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\225\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (225,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\226\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (227,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\228\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (228,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\229\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (229,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\230\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (230,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\231\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (231,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\232\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (232,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\233\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (233,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\234\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (234,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\235\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (235,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\236\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (236,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\237\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (237,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\238\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (238,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\239\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (239,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\240\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (240,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\241\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (241,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\242\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (243,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\244\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (244,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\245\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (245,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\246\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (246,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\247\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (247,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\248\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (248,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\249\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (249,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\250\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (250,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\251\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (251,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\252\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (252,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\253\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (254,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\255\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (255,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (256,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\001\001\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (257,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\001\002\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (258,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\001\003\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (259,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\001\004\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (263,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\019\000\000\000\019\000\019\000\019\000\019\000\000\
\\000\000\000\000\000\019\000\019\000\000\000\019\000\020\000\019\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\019\000\000\000\019\000\019\001\008\000\019\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\000"
),
 (266,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\019\000\000\000\019\000\019\000\019\000\019\000\000\
\\000\000\000\000\000\019\000\019\000\000\000\019\000\020\000\019\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\019\000\000\000\019\000\019\001\011\000\019\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\000"
),
 (268,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\027\000\000\
\\001\013\001\013\001\013\001\013\001\013\001\013\001\013\001\013\
\\001\013\001\013\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\024\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\024\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (270,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\027\000\000\
\\001\013\001\013\001\013\001\013\001\013\001\013\001\013\001\013\
\\001\013\001\013\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\024\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\024\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\017\
\\001\015\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (271,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\016\001\016\001\016\001\016\001\016\001\016\001\016\001\016\
\\001\016\001\016\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\016\001\016\001\016\001\016\001\016\001\016\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\016\001\016\001\016\001\016\001\016\001\016\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (273,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\020\001\020\001\020\001\020\001\020\001\020\001\020\001\020\
\\001\020\001\020\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\018\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (274,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\019\001\019\001\019\001\019\001\019\001\019\001\019\001\019\
\\001\019\001\019\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\019\001\019\001\019\001\019\001\019\001\019\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\019\001\019\001\019\001\019\001\019\001\019\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (276,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\020\001\020\001\020\001\020\001\020\001\020\001\020\001\020\
\\001\020\001\020\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (277,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\001\022\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (278,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\001\023\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (280,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\019\000\000\000\019\000\019\000\019\000\019\000\000\
\\000\000\000\000\000\019\000\019\000\000\000\019\000\020\000\019\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\019\000\000\000\019\000\019\001\025\000\019\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\000"
),
 (284,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\001\029\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (285,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\001\030\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (286,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\001\031\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (287,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\032\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (288,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\001\033\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (289,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\001\034\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (290,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\035\000\000\000\000\001\035\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\035\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (292,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\037\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\037\001\037\001\037\001\037\001\037\001\037\001\037\001\037\
\\001\037\001\037\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\037\001\037\001\037\001\037\001\037\001\037\001\037\
\\001\037\001\037\001\037\001\037\001\037\001\037\001\037\001\037\
\\001\037\001\037\001\037\001\037\001\037\001\037\001\037\001\037\
\\001\037\001\037\001\037\000\000\000\000\000\000\000\000\001\037\
\\000\000\001\037\001\037\001\037\001\037\001\037\001\037\001\037\
\\001\037\001\037\001\037\001\037\001\037\001\037\001\037\001\037\
\\001\037\001\037\001\037\001\037\001\037\001\037\001\037\001\037\
\\001\037\001\037\001\037\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (294,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\019\001\039\000\019\000\019\000\019\000\019\000\000\
\\000\000\000\000\000\019\000\019\000\000\000\019\000\020\000\019\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\019\000\000\000\019\000\019\000\019\000\019\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\019\000\000\000\019\000\000\
\\000\000"
),
 (297,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\042\000\000\000\000\001\042\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\042\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (299,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\001\044\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (302,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\047\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (304,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\001\049\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (309,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\083\001\085\000\000\001\083\001\084\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\083\000\000\001\082\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\079\001\079\001\079\001\079\001\079\001\079\001\079\001\079\
\\001\079\001\079\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\001\070\000\000\000\000\
\\000\000\000\000\000\000\000\000\001\069\000\000\001\066\000\000\
\\000\000\001\065\001\064\000\000\000\000\000\000\001\063\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\001\062\000\000\
\\000\000\000\000\001\061\000\000\001\060\001\055\001\054\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (311,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\056\001\056\001\056\001\056\001\056\001\056\001\056\001\056\
\\001\056\001\056\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\056\001\056\001\056\001\056\001\056\001\056\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\056\001\056\001\056\001\056\001\056\001\056\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (312,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\057\001\057\001\057\001\057\001\057\001\057\001\057\001\057\
\\001\057\001\057\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\057\001\057\001\057\001\057\001\057\001\057\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\057\001\057\001\057\001\057\001\057\001\057\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (313,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\058\001\058\001\058\001\058\001\058\001\058\001\058\001\058\
\\001\058\001\058\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\058\001\058\001\058\001\058\001\058\001\058\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\058\001\058\001\058\001\058\001\058\001\058\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (314,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\059\001\059\001\059\001\059\001\059\001\059\001\059\001\059\
\\001\059\001\059\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\059\001\059\001\059\001\059\001\059\001\059\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\059\001\059\001\059\001\059\001\059\001\059\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (322,129, 
"\001\067\001\067\001\067\001\067\001\067\001\067\001\067\001\067\
\\001\067\001\067\000\000\001\067\001\067\001\067\001\067\001\067\
\\001\067\001\067\001\067\001\067\001\067\001\067\001\067\001\067\
\\001\067\001\067\001\067\001\067\001\067\001\067\001\067\001\067\
\\001\067\001\067\001\067\001\067\001\067\001\067\001\067\001\067\
\\001\067\001\067\001\067\001\067\001\067\001\067\001\067\001\067\
\\001\067\001\067\001\067\001\067\001\067\001\067\001\067\001\067\
\\001\067\001\067\001\067\001\067\001\067\001\067\001\067\001\067\
\\001\068\001\068\001\068\001\068\001\068\001\068\001\068\001\068\
\\001\068\001\068\001\068\001\068\001\068\001\068\001\068\001\068\
\\001\068\001\068\001\068\001\068\001\068\001\068\001\068\001\068\
\\001\068\001\068\001\068\001\068\001\068\001\068\001\068\001\068\
\\001\067\001\067\001\067\001\067\001\067\001\067\001\067\001\067\
\\001\067\001\067\001\067\001\067\001\067\001\067\001\067\001\067\
\\001\067\001\067\001\067\001\067\001\067\001\067\001\067\001\067\
\\001\067\001\067\001\067\001\067\001\067\001\067\001\067\001\067\
\\001\067"
),
 (326,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\071\001\071\001\071\001\071\001\071\001\071\001\071\001\071\
\\001\071\001\071\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\071\001\071\001\071\001\071\001\071\001\071\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\071\001\071\001\071\001\071\001\071\001\071\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (327,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\072\001\072\001\072\001\072\001\072\001\072\001\072\001\072\
\\001\072\001\072\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\072\001\072\001\072\001\072\001\072\001\072\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\072\001\072\001\072\001\072\001\072\001\072\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (328,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\073\001\073\001\073\001\073\001\073\001\073\001\073\001\073\
\\001\073\001\073\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\073\001\073\001\073\001\073\001\073\001\073\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\073\001\073\001\073\001\073\001\073\001\073\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (329,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\074\001\074\001\074\001\074\001\074\001\074\001\074\001\074\
\\001\074\001\074\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\074\001\074\001\074\001\074\001\074\001\074\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\074\001\074\001\074\001\074\001\074\001\074\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (330,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\075\001\075\001\075\001\075\001\075\001\075\001\075\001\075\
\\001\075\001\075\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\075\001\075\001\075\001\075\001\075\001\075\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\075\001\075\001\075\001\075\001\075\001\075\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (331,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\076\001\076\001\076\001\076\001\076\001\076\001\076\001\076\
\\001\076\001\076\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\076\001\076\001\076\001\076\001\076\001\076\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\076\001\076\001\076\001\076\001\076\001\076\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (332,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\077\001\077\001\077\001\077\001\077\001\077\001\077\001\077\
\\001\077\001\077\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\077\001\077\001\077\001\077\001\077\001\077\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\077\001\077\001\077\001\077\001\077\001\077\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (333,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\078\001\078\001\078\001\078\001\078\001\078\001\078\001\078\
\\001\078\001\078\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\078\001\078\001\078\001\078\001\078\001\078\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\078\001\078\001\078\001\078\001\078\001\078\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (335,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\080\001\080\001\080\001\080\001\080\001\080\001\080\001\080\
\\001\080\001\080\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (336,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\081\001\081\001\081\001\081\001\081\001\081\001\081\001\081\
\\001\081\001\081\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (339,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\083\000\000\000\000\001\083\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\083\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (340,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\001\085\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (343,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\001\088\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (347,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\092\000\000\000\000\001\092\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\092\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (349,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\001\094\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (352,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\097\001\097\001\097\001\097\001\097\001\097\001\097\001\097\
\\001\097\001\097\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (354,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\099\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (357,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\102\001\102\001\102\001\102\001\102\001\102\001\102\001\102\
\\001\102\001\102\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (360,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\105\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (363,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\109\000\000\000\000\001\109\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\001\109\000\000\001\108\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (366,129, 
"\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\000\000\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111"
),
 (368,129, 
"\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\000\000\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\113\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111\001\111\001\111\001\111\001\111\001\111\001\111\001\111\
\\001\111"
),
 (370,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\001\115\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
 (371,129, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\001\116\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000"
),
(0, 0, "")]
fun f(n, i, x) = (n, Vector.tabulate(i, decode x)) 
val s = map f (rev (tl (rev s))) 
exception LexHackingError 
fun look ((j,x)::r, i) = if i = j then x else look(r, i) 
  | look ([], i) = raise LexHackingError
fun g {fin=x, trans=i} = {fin=x, trans=look(s,i)} 
in Vector.fromList(map g 
[{fin = [], trans = 0},
{fin = [(N 2)], trans = 1},
{fin = [(N 2)], trans = 1},
{fin = [], trans = 3},
{fin = [], trans = 3},
{fin = [], trans = 5},
{fin = [], trans = 5},
{fin = [(N 592)], trans = 7},
{fin = [(N 592)], trans = 7},
{fin = [], trans = 9},
{fin = [], trans = 9},
{fin = [], trans = 11},
{fin = [], trans = 11},
{fin = [], trans = 13},
{fin = [], trans = 13},
{fin = [(N 481)], trans = 15},
{fin = [(N 481)], trans = 15},
{fin = [(N 462)], trans = 0},
{fin = [(N 391),(N 462)], trans = 18},
{fin = [(N 391)], trans = 19},
{fin = [], trans = 20},
{fin = [(N 391)], trans = 21},
{fin = [(N 391)], trans = 22},
{fin = [(N 418)], trans = 23},
{fin = [], trans = 24},
{fin = [], trans = 25},
{fin = [(N 411)], trans = 25},
{fin = [], trans = 27},
{fin = [(N 411)], trans = 28},
{fin = [], trans = 29},
{fin = [], trans = 30},
{fin = [(N 411)], trans = 30},
{fin = [(N 418)], trans = 32},
{fin = [], trans = 33},
{fin = [(N 429)], trans = 33},
{fin = [(N 104),(N 462)], trans = 0},
{fin = [(N 120),(N 391),(N 462)], trans = 19},
{fin = [(N 102),(N 462)], trans = 0},
{fin = [(N 391),(N 462)], trans = 38},
{fin = [(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 40},
{fin = [(N 391)], trans = 41},
{fin = [(N 391)], trans = 42},
{fin = [(N 350),(N 391)], trans = 43},
{fin = [(N 391)], trans = 44},
{fin = [(N 391)], trans = 45},
{fin = [(N 391)], trans = 46},
{fin = [(N 359),(N 391)], trans = 38},
{fin = [(N 391)], trans = 48},
{fin = [(N 391)], trans = 49},
{fin = [(N 391)], trans = 50},
{fin = [(N 345),(N 391)], trans = 38},
{fin = [(N 391)], trans = 52},
{fin = [(N 391)], trans = 53},
{fin = [(N 339),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 55},
{fin = [(N 391)], trans = 56},
{fin = [(N 333),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 58},
{fin = [(N 391)], trans = 59},
{fin = [(N 391)], trans = 60},
{fin = [(N 329),(N 391)], trans = 38},
{fin = [(N 391)], trans = 62},
{fin = [(N 391)], trans = 63},
{fin = [(N 324),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 65},
{fin = [(N 391)], trans = 66},
{fin = [(N 391)], trans = 67},
{fin = [(N 391)], trans = 68},
{fin = [(N 391)], trans = 69},
{fin = [(N 309),(N 391)], trans = 70},
{fin = [(N 391)], trans = 71},
{fin = [(N 391)], trans = 72},
{fin = [(N 319),(N 391)], trans = 38},
{fin = [(N 391)], trans = 74},
{fin = [(N 292),(N 391)], trans = 75},
{fin = [(N 391)], trans = 76},
{fin = [(N 391)], trans = 77},
{fin = [(N 391)], trans = 78},
{fin = [(N 391)], trans = 79},
{fin = [(N 391)], trans = 80},
{fin = [(N 302),(N 391)], trans = 38},
{fin = [(N 391)], trans = 82},
{fin = [(N 391)], trans = 83},
{fin = [(N 391)], trans = 84},
{fin = [(N 391)], trans = 85},
{fin = [(N 391)], trans = 86},
{fin = [(N 288),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 88},
{fin = [(N 391)], trans = 89},
{fin = [(N 280),(N 391)], trans = 38},
{fin = [(N 391)], trans = 91},
{fin = [(N 391)], trans = 92},
{fin = [(N 391)], trans = 93},
{fin = [(N 276),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 95},
{fin = [(N 391)], trans = 96},
{fin = [(N 391)], trans = 97},
{fin = [(N 391)], trans = 98},
{fin = [(N 391)], trans = 99},
{fin = [(N 366),(N 391)], trans = 38},
{fin = [(N 265),(N 391)], trans = 101},
{fin = [(N 391)], trans = 102},
{fin = [(N 270),(N 391)], trans = 38},
{fin = [(N 262),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 105},
{fin = [(N 391)], trans = 106},
{fin = [(N 391)], trans = 107},
{fin = [(N 391)], trans = 108},
{fin = [(N 391)], trans = 109},
{fin = [(N 259),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 111},
{fin = [(N 391)], trans = 112},
{fin = [(N 391)], trans = 113},
{fin = [(N 391)], trans = 114},
{fin = [(N 252),(N 391)], trans = 38},
{fin = [(N 391)], trans = 116},
{fin = [(N 246),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 118},
{fin = [(N 221),(N 391)], trans = 119},
{fin = [(N 391)], trans = 120},
{fin = [(N 391)], trans = 121},
{fin = [(N 235),(N 391)], trans = 122},
{fin = [(N 242),(N 391)], trans = 38},
{fin = [(N 391)], trans = 124},
{fin = [(N 391)], trans = 125},
{fin = [(N 391)], trans = 126},
{fin = [(N 391)], trans = 127},
{fin = [(N 229),(N 391)], trans = 38},
{fin = [(N 218),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 130},
{fin = [(N 391)], trans = 131},
{fin = [(N 391)], trans = 132},
{fin = [(N 391)], trans = 133},
{fin = [(N 391)], trans = 134},
{fin = [(N 215),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 136},
{fin = [(N 391)], trans = 137},
{fin = [(N 200),(N 391)], trans = 138},
{fin = [(N 391)], trans = 139},
{fin = [(N 391)], trans = 140},
{fin = [(N 391)], trans = 141},
{fin = [(N 208),(N 391)], trans = 38},
{fin = [(N 196),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 144},
{fin = [(N 391)], trans = 145},
{fin = [(N 391)], trans = 146},
{fin = [(N 391)], trans = 147},
{fin = [(N 391)], trans = 148},
{fin = [(N 391)], trans = 149},
{fin = [(N 391)], trans = 150},
{fin = [(N 391)], trans = 151},
{fin = [(N 190),(N 391)], trans = 38},
{fin = [(N 391)], trans = 153},
{fin = [(N 391)], trans = 154},
{fin = [(N 391)], trans = 155},
{fin = [(N 391)], trans = 156},
{fin = [(N 180),(N 391)], trans = 38},
{fin = [(N 391)], trans = 158},
{fin = [(N 173),(N 391)], trans = 38},
{fin = [(N 391)], trans = 160},
{fin = [(N 391)], trans = 161},
{fin = [(N 169),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 163},
{fin = [(N 193),(N 391)], trans = 38},
{fin = [(N 391)], trans = 165},
{fin = [(N 391)], trans = 166},
{fin = [(N 391)], trans = 167},
{fin = [(N 391)], trans = 168},
{fin = [(N 391)], trans = 169},
{fin = [(N 391)], trans = 170},
{fin = [(N 164),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 172},
{fin = [(N 391)], trans = 173},
{fin = [(N 391)], trans = 174},
{fin = [(N 155),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 176},
{fin = [(N 150),(N 391)], trans = 38},
{fin = [(N 391)], trans = 178},
{fin = [(N 139),(N 391)], trans = 179},
{fin = [(N 391)], trans = 180},
{fin = [(N 391)], trans = 181},
{fin = [(N 391)], trans = 182},
{fin = [(N 374),(N 391)], trans = 38},
{fin = [(N 391)], trans = 184},
{fin = [(N 391)], trans = 185},
{fin = [(N 391)], trans = 186},
{fin = [(N 391)], trans = 187},
{fin = [(N 391)], trans = 188},
{fin = [(N 147),(N 391)], trans = 38},
{fin = [(N 391),(N 462)], trans = 19},
{fin = [(N 98),(N 462)], trans = 191},
{fin = [], trans = 192},
{fin = [], trans = 193},
{fin = [], trans = 194},
{fin = [], trans = 195},
{fin = [], trans = 196},
{fin = [(N 90)], trans = 0},
{fin = [], trans = 198},
{fin = [], trans = 199},
{fin = [], trans = 200},
{fin = [(N 96)], trans = 0},
{fin = [], trans = 202},
{fin = [], trans = 203},
{fin = [], trans = 204},
{fin = [], trans = 205},
{fin = [], trans = 206},
{fin = [], trans = 207},
{fin = [], trans = 208},
{fin = [(N 82)], trans = 0},
{fin = [], trans = 210},
{fin = [], trans = 211},
{fin = [], trans = 212},
{fin = [], trans = 213},
{fin = [], trans = 214},
{fin = [(N 72)], trans = 0},
{fin = [], trans = 216},
{fin = [], trans = 217},
{fin = [], trans = 218},
{fin = [], trans = 219},
{fin = [], trans = 220},
{fin = [(N 64)], trans = 0},
{fin = [], trans = 222},
{fin = [], trans = 223},
{fin = [], trans = 224},
{fin = [], trans = 225},
{fin = [(N 56)], trans = 0},
{fin = [], trans = 227},
{fin = [], trans = 228},
{fin = [], trans = 229},
{fin = [], trans = 230},
{fin = [], trans = 231},
{fin = [], trans = 232},
{fin = [], trans = 233},
{fin = [], trans = 234},
{fin = [], trans = 235},
{fin = [], trans = 236},
{fin = [], trans = 237},
{fin = [], trans = 238},
{fin = [], trans = 239},
{fin = [], trans = 240},
{fin = [], trans = 241},
{fin = [(N 49)], trans = 0},
{fin = [], trans = 243},
{fin = [], trans = 244},
{fin = [], trans = 245},
{fin = [], trans = 246},
{fin = [], trans = 247},
{fin = [], trans = 248},
{fin = [], trans = 249},
{fin = [], trans = 250},
{fin = [], trans = 251},
{fin = [], trans = 252},
{fin = [(N 29)], trans = 0},
{fin = [], trans = 254},
{fin = [], trans = 255},
{fin = [], trans = 256},
{fin = [], trans = 257},
{fin = [], trans = 258},
{fin = [], trans = 259},
{fin = [(N 16)], trans = 0},
{fin = [(N 108),(N 462)], trans = 0},
{fin = [(N 106),(N 462)], trans = 0},
{fin = [(N 127),(N 391),(N 462)], trans = 263},
{fin = [(N 135),(N 391)], trans = 19},
{fin = [(N 110),(N 462)], trans = 0},
{fin = [(N 122),(N 391),(N 462)], trans = 266},
{fin = [(N 125),(N 391)], trans = 19},
{fin = [(N 414),(N 462)], trans = 268},
{fin = [(N 414)], trans = 268},
{fin = [(N 414),(N 462)], trans = 270},
{fin = [], trans = 271},
{fin = [(N 423)], trans = 271},
{fin = [], trans = 273},
{fin = [], trans = 274},
{fin = [(N 440)], trans = 274},
{fin = [(N 434)], trans = 276},
{fin = [(N 462)], trans = 277},
{fin = [], trans = 278},
{fin = [(N 118)], trans = 0},
{fin = [(N 391),(N 462)], trans = 280},
{fin = [(N 132),(N 391)], trans = 19},
{fin = [(N 100),(N 462)], trans = 0},
{fin = [(N 114),(N 462)], trans = 0},
{fin = [(N 112),(N 462)], trans = 284},
{fin = [(N 460)], trans = 285},
{fin = [], trans = 286},
{fin = [], trans = 287},
{fin = [], trans = 288},
{fin = [], trans = 289},
{fin = [], trans = 290},
{fin = [(N 457)], trans = 290},
{fin = [(N 377),(N 462)], trans = 292},
{fin = [(N 377)], trans = 292},
{fin = [(N 129),(N 391),(N 462)], trans = 294},
{fin = [(N 445)], trans = 0},
{fin = [(N 442),(N 462)], trans = 0},
{fin = [(N 2),(N 462)], trans = 297},
{fin = [(N 2)], trans = 297},
{fin = [(N 7),(N 462)], trans = 299},
{fin = [(N 7)], trans = 0},
{fin = [(N 500)], trans = 0},
{fin = [(N 500)], trans = 302},
{fin = [(N 498)], trans = 0},
{fin = [(N 500)], trans = 304},
{fin = [(N 493)], trans = 0},
{fin = [(N 495)], trans = 0},
{fin = [(N 584)], trans = 0},
{fin = [(N 582),(N 584)], trans = 0},
{fin = [(N 574),(N 582),(N 584)], trans = 309},
{fin = [(N 523)], trans = 0},
{fin = [], trans = 311},
{fin = [], trans = 312},
{fin = [], trans = 313},
{fin = [], trans = 314},
{fin = [(N 543)], trans = 0},
{fin = [(N 520)], trans = 0},
{fin = [(N 517)], trans = 0},
{fin = [(N 514)], trans = 0},
{fin = [(N 511)], trans = 0},
{fin = [(N 508)], trans = 0},
{fin = [(N 505)], trans = 0},
{fin = [], trans = 322},
{fin = [(N 531)], trans = 0},
{fin = [(N 527),(N 531)], trans = 0},
{fin = [(N 560)], trans = 0},
{fin = [], trans = 326},
{fin = [], trans = 327},
{fin = [], trans = 328},
{fin = [], trans = 329},
{fin = [], trans = 330},
{fin = [], trans = 331},
{fin = [], trans = 332},
{fin = [], trans = 333},
{fin = [(N 554)], trans = 0},
{fin = [], trans = 335},
{fin = [], trans = 336},
{fin = [(N 536)], trans = 0},
{fin = [(N 557)], trans = 0},
{fin = [(N 566)], trans = 339},
{fin = [(N 572)], trans = 340},
{fin = [(N 572)], trans = 0},
{fin = [(N 502),(N 582),(N 584)], trans = 0},
{fin = [(N 579),(N 584)], trans = 343},
{fin = [(N 579)], trans = 0},
{fin = [(N 596)], trans = 0},
{fin = [(N 594),(N 596)], trans = 0},
{fin = [(N 592),(N 596)], trans = 347},
{fin = [(N 592)], trans = 347},
{fin = [(N 589),(N 596)], trans = 349},
{fin = [(N 589)], trans = 0},
{fin = [(N 490)], trans = 0},
{fin = [(N 465),(N 490)], trans = 352},
{fin = [(N 465)], trans = 352},
{fin = [(N 490)], trans = 354},
{fin = [(N 488)], trans = 0},
{fin = [(N 472)], trans = 0},
{fin = [(N 470),(N 472)], trans = 357},
{fin = [(N 470)], trans = 357},
{fin = [(N 467),(N 472)], trans = 0},
{fin = [(N 490)], trans = 360},
{fin = [(N 475),(N 488)], trans = 0},
{fin = [(N 479),(N 490)], trans = 0},
{fin = [(N 490)], trans = 363},
{fin = [(N 479)], trans = 0},
{fin = [], trans = 363},
{fin = [(N 481),(N 490)], trans = 366},
{fin = [(N 481)], trans = 366},
{fin = [(N 481),(N 490)], trans = 368},
{fin = [(N 481),(N 488)], trans = 366},
{fin = [(N 490)], trans = 370},
{fin = [], trans = 371},
{fin = [(N 485)], trans = 0}])
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val A = STARTSTATE 3;
val F = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val L = STARTSTATE 9;
val LL = STARTSTATE 11;
val LLC = STARTSTATE 13;
val LLCQ = STARTSTATE 15;
val S = STARTSTATE 5;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

type int = Int.int
fun makeLexer (yyinput: int -> string) =
let	val yygone0:int= ~1
	val yyb = ref "\n" 		(* buffer *)
	val yybl: int ref = ref 1		(*buffer length *)
	val yybufpos: int ref = ref 1		(* location of next character to use *)
	val yygone: int ref = ref yygone0	(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin: int ref = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex (yyarg as ({source})) =
let fun continue() : Internal.result = 
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0: int) =
	let fun action (i: int,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let fun yymktext() = String.substring(!yyb,i0,i-i0)
			     val yypos: int = i0+ !yygone
			fun REJECT() = action(i,acts::l)
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  100 => (tok (Tokens.COMMA, source, yypos, yypos + 1))
| 102 => (tok (Tokens.LBRACE, source, yypos, yypos + 1))
| 104 => (tok (Tokens.RBRACE, source, yypos, yypos + 1))
| 106 => (tok (Tokens.LBRACKET, source, yypos, yypos + 1))
| 108 => (tok (Tokens.RBRACKET, source, yypos, yypos + 1))
| 110 => (tok (Tokens.SEMICOLON, source, yypos, yypos + 1))
| 112 => (tok (Tokens.LPAREN, source, yypos, yypos + 1))
| 114 => (tok (Tokens.RPAREN, source, yypos, yypos + 1))
| 118 => (tok (Tokens.DOTDOTDOT, source, yypos, yypos + 3))
| 120 => (tok (Tokens.BAR, source, yypos, yypos + 1))
| 122 => (tok (Tokens.COLON, source, yypos, yypos + 1))
| 125 => (tok (Tokens.COLONGT, source, yypos, yypos + 1))
| 127 => (tok (Tokens.EQUALOP, source, yypos, yypos + 1))
| 129 => (tok (Tokens.HASH, source, yypos, yypos + 1))
| 132 => (tok (Tokens.ARROW, source, yypos, yypos + 2))
| 135 => (tok (Tokens.DARROW, source, yypos, yypos + 2))
| 139 => (tok (Tokens.AND, source, yypos, yypos + 3))
| 147 => (tok (Tokens.ABSTYPE, source, yypos, yypos + 7))
| 150 => (tok (Tokens.AS, source, yypos, yypos + 2))
| 155 => (tok (Tokens.CASE, source, yypos, yypos + 4))
| 16 => let val yytext=yymktext() in tok (Tokens.ADDRESS, source, yypos, yypos + size yytext) end
| 164 => (tok (Tokens.DATATYPE, source, yypos, yypos + 8))
| 169 => (tok (Tokens.ELSE, source, yypos, yypos + 4))
| 173 => (tok (Tokens.END, source, yypos, yypos + 3))
| 180 => (tok (Tokens.EQTYPE, source, yypos, yypos + 6))
| 190 => (tok (Tokens.EXCEPTION, source, yypos, yypos + 9))
| 193 => (tok (Tokens.DO, source, yypos, yypos + 2))
| 196 => (tok (Tokens.FN, source, yypos, yypos + 2))
| 2 => (continue ())
| 200 => (tok (Tokens.FUN, source, yypos, yypos + 3))
| 208 => (tok (Tokens.FUNCTOR, source, yypos, yypos + 7))
| 215 => (tok (Tokens.HANDLE, source, yypos, yypos + 6))
| 218 => (tok (Tokens.IF, source, yypos, yypos + 2))
| 221 => (tok (Tokens.IN, source, yypos, yypos + 2))
| 229 => (tok (Tokens.INCLUDE, source, yypos, yypos + 7))
| 235 => (tok (Tokens.INFIX, source, yypos, yypos + 5))
| 242 => (tok (Tokens.INFIXR, source, yypos, yypos + 6))
| 246 => (tok (Tokens.LET, source, yypos, yypos + 3))
| 252 => (tok (Tokens.LOCAL, source, yypos, yypos + 5))
| 259 => (tok (Tokens.NONFIX, source, yypos, yypos + 6))
| 262 => (tok (Tokens.OF, source, yypos, yypos + 2))
| 265 => (tok (Tokens.OP, source, yypos, yypos + 2))
| 270 => (tok (Tokens.OPEN, source, yypos, yypos + 4))
| 276 => (tok (Tokens.RAISE, source, yypos, yypos + 5))
| 280 => (tok (Tokens.REC, source, yypos, yypos + 3))
| 288 => (tok (Tokens.SHARING, source, yypos, yypos + 7))
| 29 => let val yytext=yymktext() in tok (Tokens.BUILD_CONST, source, yypos, yypos + size yytext) end
| 292 => (tok (Tokens.SIG, source, yypos, yypos + 3))
| 302 => (tok (Tokens.SIGNATURE, source, yypos, yypos + 9))
| 309 => (tok (Tokens.STRUCT, source, yypos, yypos + 6))
| 319 => (tok (Tokens.STRUCTURE, source, yypos, yypos + 9))
| 324 => (tok (Tokens.THEN, source, yypos, yypos + 4))
| 329 => (tok (Tokens.TYPE, source, yypos, yypos + 4))
| 333 => (tok (Tokens.VAL, source, yypos, yypos + 3))
| 339 => (tok (Tokens.WHERE, source, yypos, yypos + 5))
| 345 => (tok (Tokens.WHILE, source, yypos, yypos + 5))
| 350 => (tok (Tokens.WITH, source, yypos, yypos + 4))
| 359 => (tok (Tokens.WITHTYPE, source, yypos, yypos + 8))
| 366 => (tok (Tokens.ORELSE, source, yypos, yypos + 6))
| 374 => (tok (Tokens.ANDALSO, source, yypos, yypos + 7))
| 377 => let val yytext=yymktext() in tok' (Tokens.TYVAR, yytext, source, yypos) end
| 391 => let val yytext=yymktext() in case yytext of
       "*" => tok (Tokens.ASTERISK, source, yypos, yypos + 1)
     | _ => tok' (Tokens.LONGID, yytext, source, yypos) end
| 411 => let val yytext=yymktext() in tok' (Tokens.REAL, yytext, source, yypos) end
| 414 => let val yytext=yymktext() in int (yytext, 0, source, yypos, {negate = false}, StringCvt.DEC) end
| 418 => let val yytext=yymktext() in int (yytext, 1, source, yypos, {negate = true}, StringCvt.DEC) end
| 423 => let val yytext=yymktext() in int (yytext, 2, source, yypos, {negate = false}, StringCvt.HEX) end
| 429 => let val yytext=yymktext() in int (yytext, 3, source, yypos, {negate = true}, StringCvt.HEX) end
| 434 => let val yytext=yymktext() in word (yytext, 2, source, yypos, StringCvt.DEC) end
| 440 => let val yytext=yymktext() in word (yytext, 3, source, yypos, StringCvt.HEX) end
| 442 => (charlist := []
                    ; stringStart := Source.getPos (source, yypos)
                    ; stringtype := true
                    ; YYBEGIN S
                    ; continue ())
| 445 => (charlist := []
                    ; stringStart := Source.getPos (source, yypos)
                    ; stringtype := false
                    ; YYBEGIN S
                    ; continue ())
| 457 => (YYBEGIN L
                    ; commentStart := Source.getPos (source, yypos)
                    ; commentLevel := 1
                    ; continue ())
| 460 => (YYBEGIN A
                    ; commentLevel := 1
                    ; commentStart := Source.getPos (source, yypos)
                    ; continue ())
| 462 => (error (source, yypos, yypos + 1, "illegal token") ;
                    continue ())
| 465 => let val yytext=yymktext() in YYBEGIN LL
                    ; (lineNum := valOf (Int.fromString yytext)
                       ; colNum := 1)
                      handle Overflow => YYBEGIN A
                    ; continue () end
| 467 => ((* cheat: take n > 0 dots *) continue ())
| 470 => let val yytext=yymktext() in YYBEGIN LLC
                    ; (colNum := valOf (Int.fromString yytext))
                      handle Overflow => YYBEGIN A
                    ; continue () end
| 472 => (YYBEGIN LLC; continue ()
                (* note hack, since ml-lex chokes on the empty string for 0* *))
| 475 => (YYBEGIN INITIAL
                    ; lineDirective (source, NONE, yypos + 2)
                    ; commentLevel := 0; charlist := []; continue ())
| 479 => (YYBEGIN LLCQ; continue ())
| 481 => let val yytext=yymktext() in lineFile := yytext; continue () end
| 485 => (YYBEGIN INITIAL
                    ; lineDirective (source, SOME (!lineFile), yypos + 3)
                    ; commentLevel := 0; charlist := []; continue ())
| 488 => (YYBEGIN INITIAL; commentLevel := 0; charlist := []; continue ())
| 49 => let val yytext=yymktext() in tok (Tokens.COMMAND_LINE_CONST, source, yypos, yypos + size yytext) end
| 490 => (YYBEGIN A; continue ())
| 493 => (inc commentLevel; continue ())
| 495 => (Source.newline (source, yypos) ; continue ())
| 498 => (dec commentLevel
                    ; if 0 = !commentLevel then YYBEGIN INITIAL else ()
                    ; continue ())
| 500 => (continue ())
| 502 => (let
                       val s = Vector.fromListRev (!charlist)
                       val _ = charlist := nil
                       fun make (t, v) =
                          t (v, !stringStart, Source.getPos (source, yypos + 1))
                       val () = YYBEGIN INITIAL
                    in
                       if !stringtype
                          then make (Tokens.STRING, s)
                       else
                          make (Tokens.CHAR,
                                if 1 <> Vector.length s
                                   then (error
                                         (source, yypos, yypos + 1,
                                          "character constant not length 1")
                                         ; 0)
                                else Vector.sub (s, 0))
                    end)
| 505 => (addChar #"\a"; continue ())
| 508 => (addChar #"\b"; continue ())
| 511 => (addChar #"\f"; continue ())
| 514 => (addChar #"\n"; continue ())
| 517 => (addChar #"\r"; continue ())
| 520 => (addChar #"\t"; continue ())
| 523 => (addChar #"\v"; continue ())
| 527 => let val yytext=yymktext() in addChar (Char.chr(Char.ord(String.sub(yytext, 2))
                                      -Char.ord #"@"));
                    continue () end
| 531 => (error (source, yypos, yypos + 2,
                "illegal control escape; must be one of @ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_");
        continue ())
| 536 => let val yytext=yymktext() in let
                       fun c (i, scale) =
                          scale * (Char.ord (String.sub (yytext, i))
                                   - Char.ord #"0")
                       val () = addOrd (IntInf.fromInt
                                        (c (1, 100) + c (2, 10) + c (3, 1)))
                    in
                       continue ()
                    end end
| 543 => let val yytext=yymktext() in addHexEscape (String.substring (yytext, 2, 4),
                                      source, yypos)
                        ; continue () end
| 554 => let val yytext=yymktext() in addHexEscape (String.substring (yytext, 2, 8),
                                      source, yypos)
                        ; continue () end
| 557 => (addString "\""; continue ())
| 56 => let val yytext=yymktext() in tok (Tokens.CONST, source, yypos, yypos + size yytext) end
| 560 => (addString "\\"; continue ())
| 566 => (YYBEGIN F; continue ())
| 572 => (Source.newline (source, yypos + 1) ; YYBEGIN F ; continue ())
| 574 => (stringError (source, yypos, "illegal string escape")
                    ; continue ())
| 579 => (Source.newline (source, yypos)
                    ; stringError (source, yypos, "unclosed string")
                    ; continue ())
| 582 => let val yytext=yymktext() in addString yytext; continue () end
| 584 => (stringError (source, yypos + 1, "illegal character in string")
          ; continue ())
| 589 => (Source.newline (source, yypos) ; continue ())
| 592 => (continue ())
| 594 => (YYBEGIN S
                    ; stringStart := Source.getPos (source, yypos)
                    ; continue ())
| 596 => (stringError (source, yypos, "unclosed string")
                    ; continue ())
| 64 => let val yytext=yymktext() in tok (Tokens.EXPORT, source, yypos, yypos + size yytext) end
| 7 => (Source.newline (source, yypos); continue ())
| 72 => let val yytext=yymktext() in tok (Tokens.IMPORT, source, yypos, yypos + size yytext) end
| 82 => let val yytext=yymktext() in tok (Tokens.OVERLOAD, source, yypos, yypos + size yytext) end
| 90 => let val yytext=yymktext() in tok (Tokens.SYMBOL, source, yypos, yypos + size yytext) end
| 96 => let val yytext=yymktext() in tok (Tokens.PRIM, source, yypos, yypos + size yytext) end
| 98 => (tok (Tokens.WILD, source, yypos, yypos + 1))
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub (Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (String.size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := String.substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := String.size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = Char.ord (CharVector.sub (!yyb,l))
		val NewChar = if NewChar<128 then NewChar else 128
		val NewState = Vector.sub (trans, NewChar)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if String.substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end
end
