/*-
 * Copyright (c) 2009 Sylvestre Gallon.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $FreeBSD: stable/11/sys/arm/at91/at91_pitreg.h 331722 2018-03-29 02:50:57Z eadler $ */

#ifndef ARM_AT91_AT91_PITREG_H
#define ARM_AT91_AT91_PITREG_H

#define PIT_MR		0x0
#define PIT_SR		0x4
#define PIT_PIVR	0x8
#define PIT_PIIR	0xc

/* PIT_MR */
#define PIT_PIV(x)	(x & 0xfffff) /* periodic interval value */
#define PIT_CNT(x)	((x >>20) & 0xfff) /* periodic interval counter */
#define PIT_EN		(1 << 24) /* pit enable */
#define PIT_IEN		(1 << 25) /* pit interrupt enable */

/* PIT_SR */
#define PIT_PITS_DONE	1 /* interrupt done */

void at91_pit_delay(int us);

#endif /* ARM_AT91_AT91_PITREG_H */
