/*
 *  Copyright (C) 2007-2010 Lawrence Livermore National Security, LLC.
 *  Copyright (C) 2007 The Regents of the University of California.
 *  Produced at Lawrence Livermore National Laboratory (cf, DISCLAIMER).
 *  Written by Brian Behlendorf <behlendorf1@llnl.gov>.
 *  UCRL-CODE-235197
 *
 *  This file is part of the SPL, Solaris Porting Layer.
 *
 *  The SPL is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  The SPL is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with the SPL.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _SPL_VMSYSTM_H
#define	_SPL_VMSYSTM_H

#include <linux/mmzone.h>
#include <linux/mm.h>
#include <linux/swap.h>
#include <linux/highmem.h>
#include <linux/vmalloc.h>
#include <sys/types.h>
#include <asm/uaccess.h>

#ifdef HAVE_TOTALRAM_PAGES_FUNC
#define	zfs_totalram_pages	totalram_pages()
#else
#define	zfs_totalram_pages	totalram_pages
#endif

#ifdef HAVE_TOTALHIGH_PAGES
#define	zfs_totalhigh_pages	totalhigh_pages()
#else
#define	zfs_totalhigh_pages	totalhigh_pages
#endif

#define	membar_consumer()		smp_rmb()
#define	membar_producer()		smp_wmb()

#define	physmem				zfs_totalram_pages

#define	xcopyin(from, to, size)		copy_from_user(to, from, size)
#define	xcopyout(from, to, size)	copy_to_user(to, from, size)

static __inline__ int
copyin(const void *from, void *to, size_t len)
{
	/* On error copyin routine returns -1 */
	if (xcopyin(from, to, len))
		return (-1);

	return (0);
}

static __inline__ int
copyout(const void *from, void *to, size_t len)
{
	/* On error copyout routine returns -1 */
	if (xcopyout(from, to, len))
		return (-1);

	return (0);
}

static __inline__ int
copyinstr(const void *from, void *to, size_t len, size_t *done)
{
	size_t rc;

	if (len == 0)
		return (-ENAMETOOLONG);

	/* XXX: Should return ENAMETOOLONG if 'strlen(from) > len' */

	memset(to, 0, len);
	rc = copyin(from, to, len - 1);
	if (done != NULL)
		*done = rc;

	return (0);
}

#endif /* SPL_VMSYSTM_H */
