#
# String handling from the Arm Optimized Routines
# https://github.com/ARM-software/optimized-routines
#

AARCH64_STRING_FUNCS= \
	memchr \
	memcmp \
	memcpy \
	memmove \
	memrchr \
	memset \
	stpcpy \
	strchr \
	strchrnul \
	strcmp \
	strcpy \
	strlen \
	strncmp \
	strnlen \
	strrchr

#
# Add the above functions. Generate an asm file that includes the needed
# Arm Optimized Routines file defining the function name to the libc name.
# Some file need multiple macros defined or a weak symbol added we can
# override the generated file in these cases.
#
.for FUNC in ${AARCH64_STRING_FUNCS}
.if !exists(${FUNC}.S)
${FUNC}.S:
	printf '/* %sgenerated by libc/aarch64/string/Makefile.inc */\n' @ > ${.TARGET}
	printf '#define	__%s_aarch64 %s\n' ${FUNC} ${FUNC} >> ${.TARGET}
	printf '#include "aarch64/%s.S"\n' ${FUNC} >> ${.TARGET}
CLEANFILES+=	${FUNC}.S
.endif

MDSRCS+=	${FUNC}.S
CFLAGS.${FUNC}.S+=-I${SRCTOP}/contrib/arm-optimized-routines/string
.endfor
