#!/bin/sh

# panic: Bad link elm 0xfffff80b62eb7500 prev->next != elm
# cpuid = 2
# time = 1598546886
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe010154a6e0
# vpanic() at vpanic+0x182/frame 0xfffffe010154a730
# panic() at panic+0x43/frame 0xfffffe010154a790
# unp_disconnect() at unp_disconnect+0x279/frame 0xfffffe010154a7c0
# uipc_disconnect() at uipc_disconnect+0xfd/frame 0xfffffe010154a800
# soclose() at soclose+0xa2/frame 0xfffffe010154a870
# _fdrop() at _fdrop+0x1a/frame 0xfffffe010154a890
# closef() at closef+0x1ea/frame 0xfffffe010154a920
# fdescfree_fds() at fdescfree_fds+0x8c/frame 0xfffffe010154a980
# fdescfree() at fdescfree+0x3cd/frame 0xfffffe010154aa50
# exit1() at exit1+0x487/frame 0xfffffe010154aac0
# sys_sys_exit() at sys_sys_exit+0xd/frame 0xfffffe010154aad0
# amd64_syscall() at amd64_syscall+0x159/frame 0xfffffe010154abf0
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe010154abf0
# --- syscall (1, FreeBSD ELF64, sys_sys_exit), rip = 0x80045376a, rsp = 0x7fffffffe4c8, rbp = 0x7fffffffe4e0 ---

[ `uname -p` != "amd64" ] && exit 0

# Obtained from markj (syzkaller).

. ../default.cfg
cat > /tmp/syzkaller23.c <<EOF
// autogenerated by syzkaller (https://github.com/google/syzkaller)

#define _GNU_SOURCE

#include <sys/types.h>

#include <dirent.h>
#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/stat.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static __thread int skip_segv;
static __thread jmp_buf segv_env;

static void segv_handler(int sig, siginfo_t* info, void* ctx __unused)
{
  uintptr_t addr = (uintptr_t)info->si_addr;
  const uintptr_t prog_start = 1 << 20;
  const uintptr_t prog_end = 100 << 20;
  int skip = __atomic_load_n(&skip_segv, __ATOMIC_RELAXED) != 0;
  int valid = addr < prog_start || addr > prog_end;
  if (sig == SIGBUS) {
    valid = 1;
  }
  if (skip && valid) {
    _longjmp(segv_env, 1);
  }
  exit(sig);
}

static void install_segv_handler(void)
{
  struct sigaction sa;
  memset(&sa, 0, sizeof(sa));
  sa.sa_sigaction = segv_handler;
  sa.sa_flags = SA_NODEFER | SA_SIGINFO;
  sigaction(SIGSEGV, &sa, NULL);
  sigaction(SIGBUS, &sa, NULL);
}

#define NONFAILING(...)                                                        \
  {                                                                            \
    __atomic_fetch_add(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    if (_setjmp(segv_env) == 0) {                                              \
      __VA_ARGS__;                                                             \
    }                                                                          \
    __atomic_fetch_sub(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
  }

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void use_temporary_dir(void)
{
  char tmpdir_template[] = "./syzkaller.XXXXXX";
  char* tmpdir = mkdtemp(tmpdir_template);
  if (!tmpdir)
    exit(1);
  if (chmod(tmpdir, 0777))
    exit(1);
  if (chdir(tmpdir))
    exit(1);
}

static void remove_dir(const char* dir)
{
  DIR* dp = opendir(dir);
  if (dp == NULL)
    exit(1);
  struct dirent* ep = 0;
  while ((ep = readdir(dp))) {
    if (strcmp(ep->d_name, ".") == 0 || strcmp(ep->d_name, "..") == 0)
      continue;
    char filename[FILENAME_MAX];
    snprintf(filename, sizeof(filename), "%s/%s", dir, ep->d_name);
    struct stat st;
    if (lstat(filename, &st))
      exit(1);
    if (S_ISDIR(st.st_mode)) {
      remove_dir(filename);
      continue;
    }
    if (unlink(filename))
      exit(1);
  }
  closedir(dp);
  if (rmdir(dir))
    exit(1);
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void execute_one(void)
{
  int i, call, thread;
  int collide = 0;
again:
  for (call = 0; call < 5; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      if (collide && (call % 2) == 0)
        break;
      event_timedwait(&th->done, 45);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
  if (!collide) {
    collide = 1;
    goto again;
  }
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter = 0;
  for (;; iter++) {
    char cwdbuf[32];
    sprintf(cwdbuf, "./%d", iter);
    if (mkdir(cwdbuf, 0777))
      exit(1);
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      if (chdir(cwdbuf))
        exit(1);
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5 * 1000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
    remove_dir(cwdbuf);
  }
}

uint64_t r[2] = {0xffffffffffffffff, 0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    NONFAILING(memcpy((void*)0x20000000, ".\000", 2));
    res = syscall(SYS_open, 0x20000000ul, 0ul, 0ul);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    res = syscall(SYS_socketpair, 1ul, 2ul, 0, 0x20000100ul);
    if (res != -1)
      NONFAILING(r[1] = *(uint32_t*)0x20000100);
    break;
  case 2:
    NONFAILING(memcpy(
        (void*)0x20000180,
        "\x0a\x01\x2e\x2f\x66\x69\x6c\x65\x30\x00\x46\xd3\xc5\xea\xb2\xf9\xd0"
        "\x81\x73\xef\x4a\xd0\xe9\x00\x9b\x10\xb2\x6d\x40\xab\xf3\x06\x35\x55"
        "\x92\x6b\xa7\x48\x51\xed\xf1\x47\x2a\x1c\x57\xda\x98\x4d\x23\x4f\x6d"
        "\x63\x57\x71\x99\x01\x97\x42\xef\xe9\xd6\x91\x78\x55\x43\x7f\x80\x8b"
        "\xf3\xfa\x29\xeb\x62\xeb\x2f\x4b\xb5\xcd\x3f\xd7\x4f\x78\x35\xfb\xd3"
        "\x24\xe3\xc4\x10\x31\x53\xdd\xe7\x9a\x1c\x23\x36\x48\xe4\x7a\xf8\x3a"
        "\x7e\xd0\x1f\x89\xf7\xb6\xee\xff\x69\x1d\xad\x02\x57\x01\xf2\x52\x93"
        "\x3e\x6b\xda\x65\x2a\xc7\x6c\x27\xf9\x0a\xd4\x3b\x05\x00\x00\x00\x1b"
        "\x1c\x89\xc9\x3b\x41\x9c\x7b\x4f\x31\xbb\x6a\x5c\x17\xed\x78\xf1\x64"
        "\xc4\xa3\x17\x5c\x7a\x8c\x02\x75\x00\xaf\x61\xac\x90\x22\x86\x15\x67"
        "\x90\x03\x17\x8c\x55\xf6\xb9\x3a\xf8\x6c\xab\xcb\xf1\x74\x09\xc0\xbc"
        "\xf4\x5b\x76\x33\x8f\x9a\x76\xf3\x6e",
        196));
    syscall(SYS_bindat, r[0], r[1], 0x20000180ul, 0xaul);
    break;
  case 3:
    NONFAILING(*(uint8_t*)0x20000040 = 0xa);
    NONFAILING(*(uint8_t*)0x20000041 = 1);
    NONFAILING(memcpy((void*)0x20000042, "./file0\000", 8));
    syscall(SYS_connectat, r[0], r[1], 0x20000040ul, 0xaul);
    break;
  case 4:
    NONFAILING(*(uint8_t*)0x20000000 = 0xa);
    NONFAILING(*(uint8_t*)0x20000001 = 1);
    NONFAILING(memcpy((void*)0x20000002, "./file0\000", 8));
    syscall(SYS_connect, r[1], 0x20000000ul, 0xaul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  install_segv_handler();
  use_temporary_dir();
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller23 -Wall -Wextra -O0 /tmp/syzkaller23.c -lpthread ||
    exit 1

for i in `jot 256`; do
	(cd /tmp; timeout 3m ./syzkaller23) &
done
wait

rm -rf /tmp/syzkaller23 /tmp/syzkaller23.c /tmp/syzkaller.*
exit 0
