/*
 * Public system call stubs provided by libsys.
 *
 * Do not use directly, include <libsys.h> instead.
 *
 * DO NOT EDIT-- this file is automatically @generated.
 */

#ifndef __LIBSYS_H_
#define __LIBSYS_H_

#include <sys/_cpuset.h>
#include <sys/_domainset.h>
#include <sys/_ffcounter.h>
#include <sys/_semaphore.h>
#include <sys/_sigaltstack.h>
#include <machine/ucontext.h>   /* for mcontext_t */
#include <sys/_ucontext.h>
#include <sys/wait.h>

struct __siginfo;
struct __ucontext;
struct __wrusage;
struct acl;
struct aiocb;
struct auditinfo;
struct auditinfo_addr;
struct ffclock_estimate;
struct fhandle;
struct iovec;
struct itimerspec;
struct itimerval;
struct jail;
struct kevent;
struct kld_file_stat;
struct mac;
struct module_stat;
struct mq_attr;
struct msghdr;
struct msqid_ds;
struct ntptimeval;
struct pollfd;
struct rlimit;
struct rtprio;
struct rusage;
struct sched_param;
struct sctp_sndrcvinfo;
struct sembuf;
struct setcred;
struct sf_hdtr;
struct shmid_ds;
struct sigaction;
struct sigaltstack;
struct sigevent;
struct sockaddr;
struct spacectl_range;
struct stat;
struct statfs;
struct thr_param;
struct timespec;
struct timeval;
struct timex;
struct timezone;
struct uuid;
union semun;

__BEGIN_DECLS
typedef void (__sys__exit_t)(int);
typedef int (__sys_fork_t)(void);
typedef ssize_t (__sys_read_t)(int, void *, size_t);
typedef ssize_t (__sys_write_t)(int, const void *, size_t);
typedef int (__sys_open_t)(const char *, int, mode_t);
typedef int (__sys_close_t)(int);
typedef int (__sys_wait4_t)(int, int *, int, struct rusage *);
typedef int (__sys_link_t)(const char *, const char *);
typedef int (__sys_unlink_t)(const char *);
typedef int (__sys_chdir_t)(const char *);
typedef int (__sys_fchdir_t)(int);
typedef int (__sys_chmod_t)(const char *, mode_t);
typedef int (__sys_chown_t)(const char *, int, int);
typedef void * (__sys_break_t)(char *);
typedef pid_t (__sys_getpid_t)(void);
typedef int (__sys_mount_t)(const char *, const char *, int, void *);
typedef int (__sys_unmount_t)(const char *, int);
typedef int (__sys_setuid_t)(uid_t);
typedef uid_t (__sys_getuid_t)(void);
typedef uid_t (__sys_geteuid_t)(void);
typedef int (__sys_ptrace_t)(int, pid_t, caddr_t, int);
typedef ssize_t (__sys_recvmsg_t)(int, struct msghdr *, int);
typedef ssize_t (__sys_sendmsg_t)(int, const struct msghdr *, int);
typedef ssize_t (__sys_recvfrom_t)(int, void *, size_t, int, struct sockaddr *, __socklen_t *);
typedef int (__sys_accept_t)(int, struct sockaddr *, __socklen_t *);
typedef int (__sys_getpeername_t)(int, struct sockaddr *, __socklen_t *);
typedef int (__sys_getsockname_t)(int, struct sockaddr *, __socklen_t *);
typedef int (__sys_access_t)(const char *, int);
typedef int (__sys_chflags_t)(const char *, u_long);
typedef int (__sys_fchflags_t)(int, u_long);
typedef int (__sys_sync_t)(void);
typedef int (__sys_kill_t)(int, int);
typedef pid_t (__sys_getppid_t)(void);
typedef int (__sys_dup_t)(u_int);
typedef gid_t (__sys_getegid_t)(void);
typedef int (__sys_profil_t)(char *, size_t, size_t, u_int);
typedef int (__sys_ktrace_t)(const char *, int, int, int);
typedef gid_t (__sys_getgid_t)(void);
typedef int (__sys_getlogin_t)(char *, u_int);
typedef int (__sys_setlogin_t)(const char *);
typedef int (__sys_acct_t)(const char *);
typedef int (__sys_sigaltstack_t)(const struct sigaltstack *, struct sigaltstack *);
typedef int (__sys_ioctl_t)(int, u_long, char *);
typedef int (__sys_reboot_t)(int);
typedef int (__sys_revoke_t)(const char *);
typedef int (__sys_symlink_t)(const char *, const char *);
typedef ssize_t (__sys_readlink_t)(const char *, char *, size_t);
typedef int (__sys_execve_t)(const char *, char **, char **);
typedef mode_t (__sys_umask_t)(mode_t);
typedef int (__sys_chroot_t)(const char *);
typedef int (__sys_msync_t)(void *, size_t, int);
typedef int (__sys_vfork_t)(void);
typedef int (__sys_munmap_t)(void *, size_t);
typedef int (__sys_mprotect_t)(void *, size_t, int);
typedef int (__sys_madvise_t)(void *, size_t, int);
typedef int (__sys_mincore_t)(const void *, size_t, char *);
typedef int (__sys_getpgrp_t)(void);
typedef int (__sys_setpgid_t)(int, int);
typedef int (__sys_setitimer_t)(int, const struct itimerval *, struct itimerval *);
typedef int (__sys_swapon_t)(const char *);
typedef int (__sys_getitimer_t)(int, struct itimerval *);
typedef int (__sys_getdtablesize_t)(void);
typedef int (__sys_dup2_t)(u_int, u_int);
typedef int (__sys_fcntl_t)(int, int, intptr_t);
typedef int (__sys_select_t)(int, fd_set *, fd_set *, fd_set *, struct timeval *);
typedef int (__sys_fsync_t)(int);
typedef int (__sys_setpriority_t)(int, int, int);
typedef int (__sys_socket_t)(int, int, int);
typedef int (__sys_connect_t)(int, const struct sockaddr *, __socklen_t);
typedef int (__sys_getpriority_t)(int, int);
typedef int (__sys_bind_t)(int, const struct sockaddr *, __socklen_t);
typedef int (__sys_setsockopt_t)(int, int, int, const void *, __socklen_t);
typedef int (__sys_listen_t)(int, int);
typedef int (__sys_gettimeofday_t)(struct timeval *, struct timezone *);
typedef int (__sys_getrusage_t)(int, struct rusage *);
typedef int (__sys_getsockopt_t)(int, int, int, void *, __socklen_t *);
typedef ssize_t (__sys_readv_t)(int, const struct iovec *, u_int);
typedef ssize_t (__sys_writev_t)(int, const struct iovec *, u_int);
typedef int (__sys_settimeofday_t)(const struct timeval *, const struct timezone *);
typedef int (__sys_fchown_t)(int, int, int);
typedef int (__sys_fchmod_t)(int, mode_t);
typedef int (__sys_setreuid_t)(int, int);
typedef int (__sys_setregid_t)(int, int);
typedef int (__sys_rename_t)(const char *, const char *);
typedef int (__sys_flock_t)(int, int);
typedef int (__sys_mkfifo_t)(const char *, mode_t);
typedef ssize_t (__sys_sendto_t)(int, const void *, size_t, int, const struct sockaddr *, __socklen_t);
typedef int (__sys_shutdown_t)(int, int);
typedef int (__sys_socketpair_t)(int, int, int, int *);
typedef int (__sys_mkdir_t)(const char *, mode_t);
typedef int (__sys_rmdir_t)(const char *);
typedef int (__sys_utimes_t)(const char *, const struct timeval *);
typedef int (__sys_adjtime_t)(const struct timeval *, struct timeval *);
typedef int (__sys_setsid_t)(void);
typedef int (__sys_quotactl_t)(const char *, int, int, void *);
typedef int (__sys_nlm_syscall_t)(int, int, int, char **);
typedef int (__sys_nfssvc_t)(int, void *);
typedef int (__sys_lgetfh_t)(const char *, struct fhandle *);
typedef int (__sys_getfh_t)(const char *, struct fhandle *);
typedef int (__sys_sysarch_t)(int, char *);
typedef int (__sys_rtprio_t)(int, pid_t, struct rtprio *);
typedef int (__sys_semsys_t)(int, int, int, int, int);
typedef int (__sys_msgsys_t)(int, int, int, int, int, int);
typedef int (__sys_shmsys_t)(int, int, int, int);
typedef int (__sys_setfib_t)(int);
typedef int (__sys_ntp_adjtime_t)(struct timex *);
typedef int (__sys_setgid_t)(gid_t);
typedef int (__sys_setegid_t)(gid_t);
typedef int (__sys_seteuid_t)(uid_t);
typedef int (__sys_pathconf_t)(const char *, int);
typedef int (__sys_fpathconf_t)(int, int);
typedef int (__sys_getrlimit_t)(u_int, struct rlimit *);
typedef int (__sys_setrlimit_t)(u_int, struct rlimit *);
typedef int (__sys___sysctl_t)(const int *, u_int, void *, size_t *, const void *, size_t);
typedef int (__sys_mlock_t)(const void *, size_t);
typedef int (__sys_munlock_t)(const void *, size_t);
typedef int (__sys_undelete_t)(const char *);
typedef int (__sys_futimes_t)(int, const struct timeval *);
typedef int (__sys_getpgid_t)(pid_t);
typedef int (__sys_poll_t)(struct pollfd *, u_int, int);
typedef int (__sys_semget_t)(key_t, int, int);
typedef int (__sys_semop_t)(int, struct sembuf *, size_t);
typedef int (__sys_msgget_t)(key_t, int);
typedef int (__sys_msgsnd_t)(int, const void *, size_t, int);
typedef ssize_t (__sys_msgrcv_t)(int, void *, size_t, long, int);
typedef void * (__sys_shmat_t)(int, const void *, int);
typedef int (__sys_shmdt_t)(const void *);
typedef int (__sys_shmget_t)(key_t, size_t, int);
typedef int (__sys_clock_gettime_t)(clockid_t, struct timespec *);
typedef int (__sys_clock_settime_t)(clockid_t, const struct timespec *);
typedef int (__sys_clock_getres_t)(clockid_t, struct timespec *);
typedef int (__sys_ktimer_create_t)(clockid_t, struct sigevent *, int *);
typedef int (__sys_ktimer_delete_t)(int);
typedef int (__sys_ktimer_settime_t)(int, int, const struct itimerspec *, struct itimerspec *);
typedef int (__sys_ktimer_gettime_t)(int, struct itimerspec *);
typedef int (__sys_ktimer_getoverrun_t)(int);
typedef int (__sys_nanosleep_t)(const struct timespec *, struct timespec *);
typedef int (__sys_ffclock_getcounter_t)(ffcounter *);
typedef int (__sys_ffclock_setestimate_t)(struct ffclock_estimate *);
typedef int (__sys_ffclock_getestimate_t)(struct ffclock_estimate *);
typedef int (__sys_clock_nanosleep_t)(clockid_t, int, const struct timespec *, struct timespec *);
typedef int (__sys_clock_getcpuclockid2_t)(id_t, int, clockid_t *);
typedef int (__sys_ntp_gettime_t)(struct ntptimeval *);
typedef int (__sys_minherit_t)(void *, size_t, int);
typedef int (__sys_rfork_t)(int);
typedef int (__sys_issetugid_t)(void);
typedef int (__sys_lchown_t)(const char *, int, int);
typedef int (__sys_aio_read_t)(struct aiocb *);
typedef int (__sys_aio_write_t)(struct aiocb *);
typedef int (__sys_lio_listio_t)(int, struct aiocb * const *, int, struct sigevent *);
typedef int (__sys_lchmod_t)(const char *, mode_t);
typedef int (__sys_lutimes_t)(const char *, const struct timeval *);
typedef ssize_t (__sys_preadv_t)(int, struct iovec *, u_int, off_t);
typedef ssize_t (__sys_pwritev_t)(int, struct iovec *, u_int, off_t);
typedef int (__sys_fhopen_t)(const struct fhandle *, int);
typedef int (__sys_modnext_t)(int);
typedef int (__sys_modstat_t)(int, struct module_stat *);
typedef int (__sys_modfnext_t)(int);
typedef int (__sys_modfind_t)(const char *);
typedef int (__sys_kldload_t)(const char *);
typedef int (__sys_kldunload_t)(int);
typedef int (__sys_kldfind_t)(const char *);
typedef int (__sys_kldnext_t)(int);
typedef int (__sys_kldstat_t)(int, struct kld_file_stat *);
typedef int (__sys_kldfirstmod_t)(int);
typedef int (__sys_getsid_t)(pid_t);
typedef int (__sys_setresuid_t)(uid_t, uid_t, uid_t);
typedef int (__sys_setresgid_t)(gid_t, gid_t, gid_t);
typedef ssize_t (__sys_aio_return_t)(struct aiocb *);
typedef int (__sys_aio_suspend_t)(const struct aiocb * const *, int, const struct timespec *);
typedef int (__sys_aio_cancel_t)(int, struct aiocb *);
typedef int (__sys_aio_error_t)(struct aiocb *);
typedef int (__sys_mlockall_t)(int);
typedef int (__sys_munlockall_t)(void);
typedef int (__sys___getcwd_t)(char *, size_t);
typedef int (__sys_sched_setparam_t)(pid_t, const struct sched_param *);
typedef int (__sys_sched_getparam_t)(pid_t, struct sched_param *);
typedef int (__sys_sched_setscheduler_t)(pid_t, int, const struct sched_param *);
typedef int (__sys_sched_getscheduler_t)(pid_t);
typedef int (__sys_sched_yield_t)(void);
typedef int (__sys_sched_get_priority_max_t)(int);
typedef int (__sys_sched_get_priority_min_t)(int);
typedef int (__sys_sched_rr_get_interval_t)(pid_t, struct timespec *);
typedef int (__sys_utrace_t)(const void *, size_t);
typedef int (__sys_kldsym_t)(int, int, void *);
typedef int (__sys_jail_t)(struct jail *);
typedef int (__sys_nnpfs_syscall_t)(int, char *, int, void *, int);
typedef int (__sys_sigprocmask_t)(int, const sigset_t *, sigset_t *);
typedef int (__sys_sigsuspend_t)(const sigset_t *);
typedef int (__sys_sigpending_t)(sigset_t *);
typedef int (__sys_sigtimedwait_t)(const sigset_t *, struct __siginfo *, const struct timespec *);
typedef int (__sys_sigwaitinfo_t)(const sigset_t *, struct __siginfo *);
typedef int (__sys___acl_get_file_t)(const char *, __acl_type_t, struct acl *);
typedef int (__sys___acl_set_file_t)(const char *, __acl_type_t, struct acl *);
typedef int (__sys___acl_get_fd_t)(int, __acl_type_t, struct acl *);
typedef int (__sys___acl_set_fd_t)(int, __acl_type_t, struct acl *);
typedef int (__sys___acl_delete_file_t)(const char *, __acl_type_t);
typedef int (__sys___acl_delete_fd_t)(int, __acl_type_t);
typedef int (__sys___acl_aclcheck_file_t)(const char *, __acl_type_t, struct acl *);
typedef int (__sys___acl_aclcheck_fd_t)(int, __acl_type_t, struct acl *);
typedef int (__sys_extattrctl_t)(const char *, int, const char *, int, const char *);
typedef ssize_t (__sys_extattr_set_file_t)(const char *, int, const char *, void *, size_t);
typedef ssize_t (__sys_extattr_get_file_t)(const char *, int, const char *, void *, size_t);
typedef int (__sys_extattr_delete_file_t)(const char *, int, const char *);
typedef ssize_t (__sys_aio_waitcomplete_t)(struct aiocb **, struct timespec *);
typedef int (__sys_getresuid_t)(uid_t *, uid_t *, uid_t *);
typedef int (__sys_getresgid_t)(gid_t *, gid_t *, gid_t *);
typedef int (__sys_kqueue_t)(void);
typedef ssize_t (__sys_extattr_set_fd_t)(int, int, const char *, void *, size_t);
typedef ssize_t (__sys_extattr_get_fd_t)(int, int, const char *, void *, size_t);
typedef int (__sys_extattr_delete_fd_t)(int, int, const char *);
typedef int (__sys___setugid_t)(int);
typedef int (__sys_eaccess_t)(const char *, int);
typedef int (__sys_afs3_syscall_t)(long, long, long, long, long, long, long);
typedef int (__sys_nmount_t)(struct iovec *, unsigned int, int);
typedef int (__sys___mac_get_proc_t)(struct mac *);
typedef int (__sys___mac_set_proc_t)(struct mac *);
typedef int (__sys___mac_get_fd_t)(int, struct mac *);
typedef int (__sys___mac_get_file_t)(const char *, struct mac *);
typedef int (__sys___mac_set_fd_t)(int, struct mac *);
typedef int (__sys___mac_set_file_t)(const char *, struct mac *);
typedef int (__sys_kenv_t)(int, const char *, char *, int);
typedef int (__sys_lchflags_t)(const char *, u_long);
typedef int (__sys_uuidgen_t)(struct uuid *, int);
typedef int (__sys_sendfile_t)(int, int, off_t, size_t, struct sf_hdtr *, off_t *, int);
typedef int (__sys_mac_syscall_t)(const char *, int, void *);
typedef int (__sys_ksem_close_t)(semid_t);
typedef int (__sys_ksem_post_t)(semid_t);
typedef int (__sys_ksem_wait_t)(semid_t);
typedef int (__sys_ksem_trywait_t)(semid_t);
typedef int (__sys_ksem_init_t)(semid_t *, unsigned int);
typedef int (__sys_ksem_open_t)(semid_t *, const char *, int, mode_t, unsigned int);
typedef int (__sys_ksem_unlink_t)(const char *);
typedef int (__sys_ksem_getvalue_t)(semid_t, int *);
typedef int (__sys_ksem_destroy_t)(semid_t);
typedef int (__sys___mac_get_pid_t)(pid_t, struct mac *);
typedef int (__sys___mac_get_link_t)(const char *, struct mac *);
typedef int (__sys___mac_set_link_t)(const char *, struct mac *);
typedef ssize_t (__sys_extattr_set_link_t)(const char *, int, const char *, void *, size_t);
typedef ssize_t (__sys_extattr_get_link_t)(const char *, int, const char *, void *, size_t);
typedef int (__sys_extattr_delete_link_t)(const char *, int, const char *);
typedef int (__sys___mac_execve_t)(const char *, char **, char **, struct mac *);
typedef int (__sys_sigaction_t)(int, const struct sigaction *, struct sigaction *);
typedef int (__sys_sigreturn_t)(const struct __ucontext *);
typedef int (__sys_getcontext_t)(struct __ucontext *);
typedef int (__sys_setcontext_t)(const struct __ucontext *);
typedef int (__sys_swapcontext_t)(struct __ucontext *, const struct __ucontext *);
typedef int (__sys___acl_get_link_t)(const char *, __acl_type_t, struct acl *);
typedef int (__sys___acl_set_link_t)(const char *, __acl_type_t, struct acl *);
typedef int (__sys___acl_delete_link_t)(const char *, __acl_type_t);
typedef int (__sys___acl_aclcheck_link_t)(const char *, __acl_type_t, struct acl *);
typedef int (__sys_sigwait_t)(const sigset_t *, int *);
typedef int (__sys_thr_create_t)(ucontext_t *, long *, int);
typedef void (__sys_thr_exit_t)(long *);
typedef int (__sys_thr_self_t)(long *);
typedef int (__sys_thr_kill_t)(long, int);
typedef int (__sys_jail_attach_t)(int);
typedef ssize_t (__sys_extattr_list_fd_t)(int, int, void *, size_t);
typedef ssize_t (__sys_extattr_list_file_t)(const char *, int, void *, size_t);
typedef ssize_t (__sys_extattr_list_link_t)(const char *, int, void *, size_t);
typedef int (__sys_ksem_timedwait_t)(semid_t, const struct timespec *);
typedef int (__sys_thr_suspend_t)(const struct timespec *);
typedef int (__sys_thr_wake_t)(long);
typedef int (__sys_kldunloadf_t)(int, int);
typedef int (__sys_audit_t)(const void *, u_int);
typedef int (__sys_auditon_t)(int, void *, u_int);
typedef int (__sys_getauid_t)(uid_t *);
typedef int (__sys_setauid_t)(uid_t *);
typedef int (__sys_getaudit_t)(struct auditinfo *);
typedef int (__sys_setaudit_t)(struct auditinfo *);
typedef int (__sys_getaudit_addr_t)(struct auditinfo_addr *, u_int);
typedef int (__sys_setaudit_addr_t)(struct auditinfo_addr *, u_int);
typedef int (__sys_auditctl_t)(const char *);
typedef int (__sys__umtx_op_t)(void *, int, u_long, void *, void *);
typedef int (__sys_thr_new_t)(struct thr_param *, int);
typedef int (__sys_sigqueue_t)(pid_t, int, void *);
typedef int (__sys_kmq_open_t)(const char *, int, mode_t, const struct mq_attr *);
typedef int (__sys_kmq_setattr_t)(int, const struct mq_attr *, struct mq_attr *);
typedef int (__sys_kmq_timedreceive_t)(int, char *, size_t, unsigned *, const struct timespec *);
typedef int (__sys_kmq_timedsend_t)(int, const char *, size_t, unsigned, const struct timespec *);
typedef int (__sys_kmq_notify_t)(int, const struct sigevent *);
typedef int (__sys_kmq_unlink_t)(const char *);
typedef void (__sys_abort2_t)(const char *, int, void **);
typedef int (__sys_thr_set_name_t)(long, const char *);
typedef int (__sys_aio_fsync_t)(int, struct aiocb *);
typedef int (__sys_rtprio_thread_t)(int, lwpid_t, struct rtprio *);
typedef int (__sys_sctp_peeloff_t)(int, uint32_t);
typedef int (__sys_sctp_generic_sendmsg_t)(int, void *, int, const struct sockaddr *, __socklen_t, struct sctp_sndrcvinfo *, int);
typedef int (__sys_sctp_generic_sendmsg_iov_t)(int, struct iovec *, int, const struct sockaddr *, __socklen_t, struct sctp_sndrcvinfo *, int);
typedef int (__sys_sctp_generic_recvmsg_t)(int, struct iovec *, int, struct sockaddr *, __socklen_t *, struct sctp_sndrcvinfo *, int *);
typedef ssize_t (__sys_pread_t)(int, void *, size_t, off_t);
typedef ssize_t (__sys_pwrite_t)(int, const void *, size_t, off_t);
typedef void * (__sys_mmap_t)(void *, size_t, int, int, int, off_t);
typedef off_t (__sys_lseek_t)(int, off_t, int);
typedef int (__sys_truncate_t)(const char *, off_t);
typedef int (__sys_ftruncate_t)(int, off_t);
typedef int (__sys_thr_kill2_t)(pid_t, long, int);
typedef int (__sys_shm_unlink_t)(const char *);
typedef int (__sys_cpuset_t)(cpusetid_t *);
typedef int (__sys_cpuset_setid_t)(cpuwhich_t, id_t, cpusetid_t);
typedef int (__sys_cpuset_getid_t)(cpulevel_t, cpuwhich_t, id_t, cpusetid_t *);
typedef int (__sys_cpuset_getaffinity_t)(cpulevel_t, cpuwhich_t, id_t, size_t, cpuset_t *);
typedef int (__sys_cpuset_setaffinity_t)(cpulevel_t, cpuwhich_t, id_t, size_t, const cpuset_t *);
typedef int (__sys_faccessat_t)(int, const char *, int, int);
typedef int (__sys_fchmodat_t)(int, const char *, mode_t, int);
typedef int (__sys_fchownat_t)(int, const char *, uid_t, gid_t, int);
typedef int (__sys_fexecve_t)(int, char **, char **);
typedef int (__sys_futimesat_t)(int, const char *, const struct timeval *);
typedef int (__sys_linkat_t)(int, const char *, int, const char *, int);
typedef int (__sys_mkdirat_t)(int, const char *, mode_t);
typedef int (__sys_mkfifoat_t)(int, const char *, mode_t);
typedef int (__sys_openat_t)(int, const char *, int, mode_t);
typedef ssize_t (__sys_readlinkat_t)(int, const char *, char *, size_t);
typedef int (__sys_renameat_t)(int, const char *, int, const char *);
typedef int (__sys_symlinkat_t)(const char *, int, const char *);
typedef int (__sys_unlinkat_t)(int, const char *, int);
typedef int (__sys_posix_openpt_t)(int);
typedef int (__sys_jail_get_t)(struct iovec *, unsigned int, int);
typedef int (__sys_jail_set_t)(struct iovec *, unsigned int, int);
typedef int (__sys_jail_remove_t)(int);
typedef int (__sys___semctl_t)(int, int, int, union semun *);
typedef int (__sys_msgctl_t)(int, int, struct msqid_ds *);
typedef int (__sys_shmctl_t)(int, int, struct shmid_ds *);
typedef int (__sys_lpathconf_t)(const char *, int);
typedef int (__sys___cap_rights_get_t)(int, int, cap_rights_t *);
typedef int (__sys_cap_enter_t)(void);
typedef int (__sys_cap_getmode_t)(u_int *);
typedef int (__sys_pdfork_t)(int *, int);
typedef int (__sys_pdkill_t)(int, int);
typedef int (__sys_pdgetpid_t)(int, pid_t *);
typedef int (__sys_pselect_t)(int, fd_set *, fd_set *, fd_set *, const struct timespec *, const sigset_t *);
typedef int (__sys_getloginclass_t)(char *, size_t);
typedef int (__sys_setloginclass_t)(const char *);
typedef int (__sys_rctl_get_racct_t)(const void *, size_t, void *, size_t);
typedef int (__sys_rctl_get_rules_t)(const void *, size_t, void *, size_t);
typedef int (__sys_rctl_get_limits_t)(const void *, size_t, void *, size_t);
typedef int (__sys_rctl_add_rule_t)(const void *, size_t, void *, size_t);
typedef int (__sys_rctl_remove_rule_t)(const void *, size_t, void *, size_t);
typedef int (__sys_posix_fallocate_t)(int, off_t, off_t);
typedef int (__sys_posix_fadvise_t)(int, off_t, off_t, int);
typedef int (__sys_wait6_t)(idtype_t, id_t, int *, int, struct __wrusage *, struct __siginfo *);
typedef int (__sys_cap_rights_limit_t)(int, cap_rights_t *);
typedef int (__sys_cap_ioctls_limit_t)(int, const u_long *, size_t);
typedef ssize_t (__sys_cap_ioctls_get_t)(int, u_long *, size_t);
typedef int (__sys_cap_fcntls_limit_t)(int, uint32_t);
typedef int (__sys_cap_fcntls_get_t)(int, uint32_t *);
typedef int (__sys_bindat_t)(int, int, const struct sockaddr *, __socklen_t);
typedef int (__sys_connectat_t)(int, int, const struct sockaddr *, __socklen_t);
typedef int (__sys_chflagsat_t)(int, const char *, u_long, int);
typedef int (__sys_accept4_t)(int, struct sockaddr *, __socklen_t *, int);
typedef int (__sys_pipe2_t)(int *, int);
typedef int (__sys_aio_mlock_t)(struct aiocb *);
typedef int (__sys_procctl_t)(idtype_t, id_t, int, void *);
typedef int (__sys_ppoll_t)(struct pollfd *, u_int, const struct timespec *, const sigset_t *);
typedef int (__sys_futimens_t)(int, const struct timespec *);
typedef int (__sys_utimensat_t)(int, const char *, const struct timespec *, int);
typedef int (__sys_fdatasync_t)(int);
typedef int (__sys_fstat_t)(int, struct stat *);
typedef int (__sys_fstatat_t)(int, const char *, struct stat *, int);
typedef int (__sys_fhstat_t)(const struct fhandle *, struct stat *);
typedef ssize_t (__sys_getdirentries_t)(int, char *, size_t, off_t *);
typedef int (__sys_statfs_t)(const char *, struct statfs *);
typedef int (__sys_fstatfs_t)(int, struct statfs *);
typedef int (__sys_getfsstat_t)(struct statfs *, long, int);
typedef int (__sys_fhstatfs_t)(const struct fhandle *, struct statfs *);
typedef int (__sys_mknodat_t)(int, const char *, mode_t, dev_t);
typedef int (__sys_kevent_t)(int, const struct kevent *, int, struct kevent *, int, const struct timespec *);
typedef int (__sys_cpuset_getdomain_t)(cpulevel_t, cpuwhich_t, id_t, size_t, domainset_t *, int *);
typedef int (__sys_cpuset_setdomain_t)(cpulevel_t, cpuwhich_t, id_t, size_t, domainset_t *, int);
typedef int (__sys_getrandom_t)(void *, size_t, unsigned int);
typedef int (__sys_getfhat_t)(int, char *, struct fhandle *, int);
typedef int (__sys_fhlink_t)(struct fhandle *, const char *);
typedef int (__sys_fhlinkat_t)(struct fhandle *, int, const char *);
typedef int (__sys_fhreadlink_t)(struct fhandle *, char *, size_t);
typedef int (__sys_funlinkat_t)(int, const char *, int, int);
typedef ssize_t (__sys_copy_file_range_t)(int, off_t *, int, off_t *, size_t, unsigned int);
typedef int (__sys___sysctlbyname_t)(const char *, size_t, void *, size_t *, void *, size_t);
typedef int (__sys_shm_open2_t)(const char *, int, mode_t, int, const char *);
typedef int (__sys_shm_rename_t)(const char *, const char *, int);
typedef int (__sys_sigfastblock_t)(int, void *);
typedef int (__sys___realpathat_t)(int, const char *, char *, size_t, int);
typedef int (__sys_close_range_t)(u_int, u_int, int);
typedef int (__sys_rpctls_syscall_t)(uint64_t);
typedef int (__sys___specialfd_t)(int, const void *, size_t);
typedef int (__sys_aio_writev_t)(struct aiocb *);
typedef int (__sys_aio_readv_t)(struct aiocb *);
typedef int (__sys_fspacectl_t)(int, int, const struct spacectl_range *, int, struct spacectl_range *);
typedef int (__sys_sched_getcpu_t)(void);
typedef int (__sys_swapoff_t)(const char *, u_int);
typedef int (__sys_kqueuex_t)(u_int);
typedef int (__sys_membarrier_t)(int, unsigned, int);
typedef int (__sys_timerfd_create_t)(int, int);
typedef int (__sys_timerfd_gettime_t)(int, struct itimerspec *);
typedef int (__sys_timerfd_settime_t)(int, int, const struct itimerspec *, struct itimerspec *);
typedef int (__sys_kcmp_t)(pid_t, pid_t, int, uintptr_t, uintptr_t);
typedef int (__sys_getrlimitusage_t)(u_int, int, rlim_t *);
typedef int (__sys_fchroot_t)(int);
typedef int (__sys_setcred_t)(u_int, const struct setcred *, size_t);
typedef int (__sys_exterrctl_t)(u_int, u_int, void *);
typedef int (__sys_inotify_add_watch_at_t)(int, int, const char *, uint32_t);
typedef int (__sys_inotify_rm_watch_t)(int, int);
typedef int (__sys_getgroups_t)(int, gid_t *);
typedef int (__sys_setgroups_t)(int, const gid_t *);
typedef int (__sys_jail_attach_jd_t)(int);
typedef int (__sys_jail_remove_jd_t)(int);

_Noreturn void __sys__exit(int rval);
int __sys_fork(void);
ssize_t __sys_read(int fd, void * buf, size_t nbyte);
ssize_t __sys_write(int fd, const void * buf, size_t nbyte);
int __sys_open(const char * path, int flags, mode_t mode);
int __sys_close(int fd);
int __sys_wait4(int pid, int * status, int options, struct rusage * rusage);
int __sys_link(const char * path, const char * link);
int __sys_unlink(const char * path);
int __sys_chdir(const char * path);
int __sys_fchdir(int fd);
int __sys_chmod(const char * path, mode_t mode);
int __sys_chown(const char * path, int uid, int gid);
void * __sys_break(char * nsize);
pid_t __sys_getpid(void);
int __sys_mount(const char * type, const char * path, int flags, void * data);
int __sys_unmount(const char * path, int flags);
int __sys_setuid(uid_t uid);
uid_t __sys_getuid(void);
uid_t __sys_geteuid(void);
int __sys_ptrace(int req, pid_t pid, caddr_t addr, int data);
ssize_t __sys_recvmsg(int s, struct msghdr * msg, int flags);
ssize_t __sys_sendmsg(int s, const struct msghdr * msg, int flags);
ssize_t __sys_recvfrom(int s, void * buf, size_t len, int flags, struct sockaddr * from, __socklen_t * fromlenaddr);
int __sys_accept(int s, struct sockaddr * name, __socklen_t * anamelen);
int __sys_getpeername(int fdes, struct sockaddr * asa, __socklen_t * alen);
int __sys_getsockname(int fdes, struct sockaddr * asa, __socklen_t * alen);
int __sys_access(const char * path, int amode);
int __sys_chflags(const char * path, u_long flags);
int __sys_fchflags(int fd, u_long flags);
int __sys_sync(void);
int __sys_kill(int pid, int signum);
pid_t __sys_getppid(void);
int __sys_dup(u_int fd);
gid_t __sys_getegid(void);
int __sys_profil(char * samples, size_t size, size_t offset, u_int scale);
int __sys_ktrace(const char * fname, int ops, int facs, int pid);
gid_t __sys_getgid(void);
int __sys_getlogin(char * namebuf, u_int namelen);
int __sys_setlogin(const char * namebuf);
int __sys_acct(const char * path);
int __sys_sigaltstack(const struct sigaltstack * ss, struct sigaltstack * oss);
int __sys_ioctl(int fd, u_long com, char * data);
int __sys_reboot(int opt);
int __sys_revoke(const char * path);
int __sys_symlink(const char * path, const char * link);
ssize_t __sys_readlink(const char * path, char * buf, size_t count);
int __sys_execve(const char * fname, char ** argv, char ** envv);
mode_t __sys_umask(mode_t newmask);
int __sys_chroot(const char * path);
int __sys_msync(void * addr, size_t len, int flags);
int __sys_vfork(void);
int __sys_munmap(void * addr, size_t len);
int __sys_mprotect(void * addr, size_t len, int prot);
int __sys_madvise(void * addr, size_t len, int behav);
int __sys_mincore(const void * addr, size_t len, char * vec);
int __sys_getpgrp(void);
int __sys_setpgid(int pid, int pgid);
int __sys_setitimer(int which, const struct itimerval * itv, struct itimerval * oitv);
int __sys_swapon(const char * name);
int __sys_getitimer(int which, struct itimerval * itv);
int __sys_getdtablesize(void);
int __sys_dup2(u_int from, u_int to);
int __sys_fcntl(int fd, int cmd, intptr_t arg);
int __sys_select(int nd, fd_set * in, fd_set * ou, fd_set * ex, struct timeval * tv);
int __sys_fsync(int fd);
int __sys_setpriority(int which, int who, int prio);
int __sys_socket(int domain, int type, int protocol);
int __sys_connect(int s, const struct sockaddr * name, __socklen_t namelen);
int __sys_getpriority(int which, int who);
int __sys_bind(int s, const struct sockaddr * name, __socklen_t namelen);
int __sys_setsockopt(int s, int level, int name, const void * val, __socklen_t valsize);
int __sys_listen(int s, int backlog);
int __sys_gettimeofday(struct timeval * tp, struct timezone * tzp);
int __sys_getrusage(int who, struct rusage * rusage);
int __sys_getsockopt(int s, int level, int name, void * val, __socklen_t * avalsize);
ssize_t __sys_readv(int fd, const struct iovec * iovp, u_int iovcnt);
ssize_t __sys_writev(int fd, const struct iovec * iovp, u_int iovcnt);
int __sys_settimeofday(const struct timeval * tv, const struct timezone * tzp);
int __sys_fchown(int fd, int uid, int gid);
int __sys_fchmod(int fd, mode_t mode);
int __sys_setreuid(int ruid, int euid);
int __sys_setregid(int rgid, int egid);
int __sys_rename(const char * from, const char * to);
int __sys_flock(int fd, int how);
int __sys_mkfifo(const char * path, mode_t mode);
ssize_t __sys_sendto(int s, const void * buf, size_t len, int flags, const struct sockaddr * to, __socklen_t tolen);
int __sys_shutdown(int s, int how);
int __sys_socketpair(int domain, int type, int protocol, int * rsv);
int __sys_mkdir(const char * path, mode_t mode);
int __sys_rmdir(const char * path);
int __sys_utimes(const char * path, const struct timeval * tptr);
int __sys_adjtime(const struct timeval * delta, struct timeval * olddelta);
int __sys_setsid(void);
int __sys_quotactl(const char * path, int cmd, int uid, void * arg);
int __sys_nlm_syscall(int debug_level, int grace_period, int addr_count, char ** addrs);
int __sys_nfssvc(int flag, void * argp);
int __sys_lgetfh(const char * fname, struct fhandle * fhp);
int __sys_getfh(const char * fname, struct fhandle * fhp);
int __sys_sysarch(int op, char * parms);
int __sys_rtprio(int function, pid_t pid, struct rtprio * rtp);
int __sys_semsys(int which, int a2, int a3, int a4, int a5);
int __sys_msgsys(int which, int a2, int a3, int a4, int a5, int a6);
int __sys_shmsys(int which, int a2, int a3, int a4);
int __sys_setfib(int fibnum);
int __sys_ntp_adjtime(struct timex * tp);
int __sys_setgid(gid_t gid);
int __sys_setegid(gid_t egid);
int __sys_seteuid(uid_t euid);
int __sys_pathconf(const char * path, int name);
int __sys_fpathconf(int fd, int name);
int __sys_getrlimit(u_int which, struct rlimit * rlp);
int __sys_setrlimit(u_int which, struct rlimit * rlp);
int __sys___sysctl(const int * name, u_int namelen, void * old, size_t * oldlenp, const void * new, size_t newlen);
int __sys_mlock(const void * addr, size_t len);
int __sys_munlock(const void * addr, size_t len);
int __sys_undelete(const char * path);
int __sys_futimes(int fd, const struct timeval * tptr);
int __sys_getpgid(pid_t pid);
int __sys_poll(struct pollfd * fds, u_int nfds, int timeout);
int __sys_semget(key_t key, int nsems, int semflg);
int __sys_semop(int semid, struct sembuf * sops, size_t nsops);
int __sys_msgget(key_t key, int msgflg);
int __sys_msgsnd(int msqid, const void * msgp, size_t msgsz, int msgflg);
ssize_t __sys_msgrcv(int msqid, void * msgp, size_t msgsz, long msgtyp, int msgflg);
void * __sys_shmat(int shmid, const void * shmaddr, int shmflg);
int __sys_shmdt(const void * shmaddr);
int __sys_shmget(key_t key, size_t size, int shmflg);
int __sys_clock_gettime(clockid_t clock_id, struct timespec * tp);
int __sys_clock_settime(clockid_t clock_id, const struct timespec * tp);
int __sys_clock_getres(clockid_t clock_id, struct timespec * tp);
int __sys_ktimer_create(clockid_t clock_id, struct sigevent * evp, int * timerid);
int __sys_ktimer_delete(int timerid);
int __sys_ktimer_settime(int timerid, int flags, const struct itimerspec * value, struct itimerspec * ovalue);
int __sys_ktimer_gettime(int timerid, struct itimerspec * value);
int __sys_ktimer_getoverrun(int timerid);
int __sys_nanosleep(const struct timespec * rqtp, struct timespec * rmtp);
int __sys_ffclock_getcounter(ffcounter * ffcount);
int __sys_ffclock_setestimate(struct ffclock_estimate * cest);
int __sys_ffclock_getestimate(struct ffclock_estimate * cest);
int __sys_clock_nanosleep(clockid_t clock_id, int flags, const struct timespec * rqtp, struct timespec * rmtp);
int __sys_clock_getcpuclockid2(id_t id, int which, clockid_t * clock_id);
int __sys_ntp_gettime(struct ntptimeval * ntvp);
int __sys_minherit(void * addr, size_t len, int inherit);
int __sys_rfork(int flags);
int __sys_issetugid(void);
int __sys_lchown(const char * path, int uid, int gid);
int __sys_aio_read(struct aiocb * aiocbp);
int __sys_aio_write(struct aiocb * aiocbp);
int __sys_lio_listio(int mode, struct aiocb * const * acb_list, int nent, struct sigevent * sig);
int __sys_lchmod(const char * path, mode_t mode);
int __sys_lutimes(const char * path, const struct timeval * tptr);
ssize_t __sys_preadv(int fd, struct iovec * iovp, u_int iovcnt, off_t offset);
ssize_t __sys_pwritev(int fd, struct iovec * iovp, u_int iovcnt, off_t offset);
int __sys_fhopen(const struct fhandle * u_fhp, int flags);
int __sys_modnext(int modid);
int __sys_modstat(int modid, struct module_stat * stat);
int __sys_modfnext(int modid);
int __sys_modfind(const char * name);
int __sys_kldload(const char * file);
int __sys_kldunload(int fileid);
int __sys_kldfind(const char * file);
int __sys_kldnext(int fileid);
int __sys_kldstat(int fileid, struct kld_file_stat * stat);
int __sys_kldfirstmod(int fileid);
int __sys_getsid(pid_t pid);
int __sys_setresuid(uid_t ruid, uid_t euid, uid_t suid);
int __sys_setresgid(gid_t rgid, gid_t egid, gid_t sgid);
ssize_t __sys_aio_return(struct aiocb * aiocbp);
int __sys_aio_suspend(const struct aiocb * const * aiocbp, int nent, const struct timespec * timeout);
int __sys_aio_cancel(int fd, struct aiocb * aiocbp);
int __sys_aio_error(struct aiocb * aiocbp);
int __sys_mlockall(int how);
int __sys_munlockall(void);
int __sys___getcwd(char * buf, size_t buflen);
int __sys_sched_setparam(pid_t pid, const struct sched_param * param);
int __sys_sched_getparam(pid_t pid, struct sched_param * param);
int __sys_sched_setscheduler(pid_t pid, int policy, const struct sched_param * param);
int __sys_sched_getscheduler(pid_t pid);
int __sys_sched_yield(void);
int __sys_sched_get_priority_max(int policy);
int __sys_sched_get_priority_min(int policy);
int __sys_sched_rr_get_interval(pid_t pid, struct timespec * interval);
int __sys_utrace(const void * addr, size_t len);
int __sys_kldsym(int fileid, int cmd, void * data);
int __sys_jail(struct jail * jail);
int __sys_nnpfs_syscall(int operation, char * a_pathP, int a_opcode, void * a_paramsP, int a_followSymlinks);
int __sys_sigprocmask(int how, const sigset_t * set, sigset_t * oset);
int __sys_sigsuspend(const sigset_t * sigmask);
int __sys_sigpending(sigset_t * set);
int __sys_sigtimedwait(const sigset_t * set, struct __siginfo * info, const struct timespec * timeout);
int __sys_sigwaitinfo(const sigset_t * set, struct __siginfo * info);
int __sys___acl_get_file(const char * path, __acl_type_t type, struct acl * aclp);
int __sys___acl_set_file(const char * path, __acl_type_t type, struct acl * aclp);
int __sys___acl_get_fd(int filedes, __acl_type_t type, struct acl * aclp);
int __sys___acl_set_fd(int filedes, __acl_type_t type, struct acl * aclp);
int __sys___acl_delete_file(const char * path, __acl_type_t type);
int __sys___acl_delete_fd(int filedes, __acl_type_t type);
int __sys___acl_aclcheck_file(const char * path, __acl_type_t type, struct acl * aclp);
int __sys___acl_aclcheck_fd(int filedes, __acl_type_t type, struct acl * aclp);
int __sys_extattrctl(const char * path, int cmd, const char * filename, int attrnamespace, const char * attrname);
ssize_t __sys_extattr_set_file(const char * path, int attrnamespace, const char * attrname, void * data, size_t nbytes);
ssize_t __sys_extattr_get_file(const char * path, int attrnamespace, const char * attrname, void * data, size_t nbytes);
int __sys_extattr_delete_file(const char * path, int attrnamespace, const char * attrname);
ssize_t __sys_aio_waitcomplete(struct aiocb ** aiocbp, struct timespec * timeout);
int __sys_getresuid(uid_t * ruid, uid_t * euid, uid_t * suid);
int __sys_getresgid(gid_t * rgid, gid_t * egid, gid_t * sgid);
int __sys_kqueue(void);
ssize_t __sys_extattr_set_fd(int fd, int attrnamespace, const char * attrname, void * data, size_t nbytes);
ssize_t __sys_extattr_get_fd(int fd, int attrnamespace, const char * attrname, void * data, size_t nbytes);
int __sys_extattr_delete_fd(int fd, int attrnamespace, const char * attrname);
int __sys___setugid(int flag);
int __sys_eaccess(const char * path, int amode);
int __sys_afs3_syscall(long syscall, long parm1, long parm2, long parm3, long parm4, long parm5, long parm6);
int __sys_nmount(struct iovec * iovp, unsigned int iovcnt, int flags);
int __sys___mac_get_proc(struct mac * mac_p);
int __sys___mac_set_proc(struct mac * mac_p);
int __sys___mac_get_fd(int fd, struct mac * mac_p);
int __sys___mac_get_file(const char * path_p, struct mac * mac_p);
int __sys___mac_set_fd(int fd, struct mac * mac_p);
int __sys___mac_set_file(const char * path_p, struct mac * mac_p);
int __sys_kenv(int what, const char * name, char * value, int len);
int __sys_lchflags(const char * path, u_long flags);
int __sys_uuidgen(struct uuid * store, int count);
int __sys_sendfile(int fd, int s, off_t offset, size_t nbytes, struct sf_hdtr * hdtr, off_t * sbytes, int flags);
int __sys_mac_syscall(const char * policy, int call, void * arg);
int __sys_ksem_close(semid_t id);
int __sys_ksem_post(semid_t id);
int __sys_ksem_wait(semid_t id);
int __sys_ksem_trywait(semid_t id);
int __sys_ksem_init(semid_t * idp, unsigned int value);
int __sys_ksem_open(semid_t * idp, const char * name, int oflag, mode_t mode, unsigned int value);
int __sys_ksem_unlink(const char * name);
int __sys_ksem_getvalue(semid_t id, int * val);
int __sys_ksem_destroy(semid_t id);
int __sys___mac_get_pid(pid_t pid, struct mac * mac_p);
int __sys___mac_get_link(const char * path_p, struct mac * mac_p);
int __sys___mac_set_link(const char * path_p, struct mac * mac_p);
ssize_t __sys_extattr_set_link(const char * path, int attrnamespace, const char * attrname, void * data, size_t nbytes);
ssize_t __sys_extattr_get_link(const char * path, int attrnamespace, const char * attrname, void * data, size_t nbytes);
int __sys_extattr_delete_link(const char * path, int attrnamespace, const char * attrname);
int __sys___mac_execve(const char * fname, char ** argv, char ** envv, struct mac * mac_p);
int __sys_sigaction(int sig, const struct sigaction * act, struct sigaction * oact);
int __sys_sigreturn(const struct __ucontext * sigcntxp);
int __sys_getcontext(struct __ucontext * ucp);
int __sys_setcontext(const struct __ucontext * ucp);
int __sys_swapcontext(struct __ucontext * oucp, const struct __ucontext * ucp);
int __sys___acl_get_link(const char * path, __acl_type_t type, struct acl * aclp);
int __sys___acl_set_link(const char * path, __acl_type_t type, struct acl * aclp);
int __sys___acl_delete_link(const char * path, __acl_type_t type);
int __sys___acl_aclcheck_link(const char * path, __acl_type_t type, struct acl * aclp);
int __sys_sigwait(const sigset_t * set, int * sig);
int __sys_thr_create(ucontext_t * ctx, long * id, int flags);
void __sys_thr_exit(long * state);
int __sys_thr_self(long * id);
int __sys_thr_kill(long id, int sig);
int __sys_jail_attach(int jid);
ssize_t __sys_extattr_list_fd(int fd, int attrnamespace, void * data, size_t nbytes);
ssize_t __sys_extattr_list_file(const char * path, int attrnamespace, void * data, size_t nbytes);
ssize_t __sys_extattr_list_link(const char * path, int attrnamespace, void * data, size_t nbytes);
int __sys_ksem_timedwait(semid_t id, const struct timespec * abstime);
int __sys_thr_suspend(const struct timespec * timeout);
int __sys_thr_wake(long id);
int __sys_kldunloadf(int fileid, int flags);
int __sys_audit(const void * record, u_int length);
int __sys_auditon(int cmd, void * data, u_int length);
int __sys_getauid(uid_t * auid);
int __sys_setauid(uid_t * auid);
int __sys_getaudit(struct auditinfo * auditinfo);
int __sys_setaudit(struct auditinfo * auditinfo);
int __sys_getaudit_addr(struct auditinfo_addr * auditinfo_addr, u_int length);
int __sys_setaudit_addr(struct auditinfo_addr * auditinfo_addr, u_int length);
int __sys_auditctl(const char * path);
int __sys__umtx_op(void * obj, int op, u_long val, void * uaddr1, void * uaddr2);
int __sys_thr_new(struct thr_param * param, int param_size);
int __sys_sigqueue(pid_t pid, int signum, void * value);
int __sys_kmq_open(const char * path, int flags, mode_t mode, const struct mq_attr * attr);
int __sys_kmq_setattr(int mqd, const struct mq_attr * attr, struct mq_attr * oattr);
int __sys_kmq_timedreceive(int mqd, char * msg_ptr, size_t msg_len, unsigned * msg_prio, const struct timespec * abs_timeout);
int __sys_kmq_timedsend(int mqd, const char * msg_ptr, size_t msg_len, unsigned msg_prio, const struct timespec * abs_timeout);
int __sys_kmq_notify(int mqd, const struct sigevent * sigev);
int __sys_kmq_unlink(const char * path);
void __sys_abort2(const char * why, int nargs, void ** args);
int __sys_thr_set_name(long id, const char * name);
int __sys_aio_fsync(int op, struct aiocb * aiocbp);
int __sys_rtprio_thread(int function, lwpid_t lwpid, struct rtprio * rtp);
int __sys_sctp_peeloff(int sd, uint32_t name);
int __sys_sctp_generic_sendmsg(int sd, void * msg, int mlen, const struct sockaddr * to, __socklen_t tolen, struct sctp_sndrcvinfo * sinfo, int flags);
int __sys_sctp_generic_sendmsg_iov(int sd, struct iovec * iov, int iovlen, const struct sockaddr * to, __socklen_t tolen, struct sctp_sndrcvinfo * sinfo, int flags);
int __sys_sctp_generic_recvmsg(int sd, struct iovec * iov, int iovlen, struct sockaddr * from, __socklen_t * fromlenaddr, struct sctp_sndrcvinfo * sinfo, int * msg_flags);
ssize_t __sys_pread(int fd, void * buf, size_t nbyte, off_t offset);
ssize_t __sys_pwrite(int fd, const void * buf, size_t nbyte, off_t offset);
void * __sys_mmap(void * addr, size_t len, int prot, int flags, int fd, off_t pos);
off_t __sys_lseek(int fd, off_t offset, int whence);
int __sys_truncate(const char * path, off_t length);
int __sys_ftruncate(int fd, off_t length);
int __sys_thr_kill2(pid_t pid, long id, int sig);
int __sys_shm_unlink(const char * path);
int __sys_cpuset(cpusetid_t * setid);
int __sys_cpuset_setid(cpuwhich_t which, id_t id, cpusetid_t setid);
int __sys_cpuset_getid(cpulevel_t level, cpuwhich_t which, id_t id, cpusetid_t * setid);
int __sys_cpuset_getaffinity(cpulevel_t level, cpuwhich_t which, id_t id, size_t cpusetsize, cpuset_t * mask);
int __sys_cpuset_setaffinity(cpulevel_t level, cpuwhich_t which, id_t id, size_t cpusetsize, const cpuset_t * mask);
int __sys_faccessat(int fd, const char * path, int amode, int flag);
int __sys_fchmodat(int fd, const char * path, mode_t mode, int flag);
int __sys_fchownat(int fd, const char * path, uid_t uid, gid_t gid, int flag);
int __sys_fexecve(int fd, char ** argv, char ** envv);
int __sys_futimesat(int fd, const char * path, const struct timeval * times);
int __sys_linkat(int fd1, const char * path1, int fd2, const char * path2, int flag);
int __sys_mkdirat(int fd, const char * path, mode_t mode);
int __sys_mkfifoat(int fd, const char * path, mode_t mode);
int __sys_openat(int fd, const char * path, int flag, mode_t mode);
ssize_t __sys_readlinkat(int fd, const char * path, char * buf, size_t bufsize);
int __sys_renameat(int oldfd, const char * old, int newfd, const char * new);
int __sys_symlinkat(const char * path1, int fd, const char * path2);
int __sys_unlinkat(int fd, const char * path, int flag);
int __sys_posix_openpt(int flags);
int __sys_jail_get(struct iovec * iovp, unsigned int iovcnt, int flags);
int __sys_jail_set(struct iovec * iovp, unsigned int iovcnt, int flags);
int __sys_jail_remove(int jid);
int __sys___semctl(int semid, int semnum, int cmd, union semun * arg);
int __sys_msgctl(int msqid, int cmd, struct msqid_ds * buf);
int __sys_shmctl(int shmid, int cmd, struct shmid_ds * buf);
int __sys_lpathconf(const char * path, int name);
int __sys___cap_rights_get(int version, int fd, cap_rights_t * rightsp);
int __sys_cap_enter(void);
int __sys_cap_getmode(u_int * modep);
int __sys_pdfork(int * fdp, int flags);
int __sys_pdkill(int fd, int signum);
int __sys_pdgetpid(int fd, pid_t * pidp);
int __sys_pselect(int nd, fd_set * in, fd_set * ou, fd_set * ex, const struct timespec * ts, const sigset_t * sm);
int __sys_getloginclass(char * namebuf, size_t namelen);
int __sys_setloginclass(const char * namebuf);
int __sys_rctl_get_racct(const void * inbufp, size_t inbuflen, void * outbufp, size_t outbuflen);
int __sys_rctl_get_rules(const void * inbufp, size_t inbuflen, void * outbufp, size_t outbuflen);
int __sys_rctl_get_limits(const void * inbufp, size_t inbuflen, void * outbufp, size_t outbuflen);
int __sys_rctl_add_rule(const void * inbufp, size_t inbuflen, void * outbufp, size_t outbuflen);
int __sys_rctl_remove_rule(const void * inbufp, size_t inbuflen, void * outbufp, size_t outbuflen);
int __sys_posix_fallocate(int fd, off_t offset, off_t len);
int __sys_posix_fadvise(int fd, off_t offset, off_t len, int advice);
int __sys_wait6(idtype_t idtype, id_t id, int * status, int options, struct __wrusage * wrusage, struct __siginfo * info);
int __sys_cap_rights_limit(int fd, cap_rights_t * rightsp);
int __sys_cap_ioctls_limit(int fd, const u_long * cmds, size_t ncmds);
ssize_t __sys_cap_ioctls_get(int fd, u_long * cmds, size_t maxcmds);
int __sys_cap_fcntls_limit(int fd, uint32_t fcntlrights);
int __sys_cap_fcntls_get(int fd, uint32_t * fcntlrightsp);
int __sys_bindat(int fd, int s, const struct sockaddr * name, __socklen_t namelen);
int __sys_connectat(int fd, int s, const struct sockaddr * name, __socklen_t namelen);
int __sys_chflagsat(int fd, const char * path, u_long flags, int atflag);
int __sys_accept4(int s, struct sockaddr * name, __socklen_t * anamelen, int flags);
int __sys_pipe2(int * fildes, int flags);
int __sys_aio_mlock(struct aiocb * aiocbp);
int __sys_procctl(idtype_t idtype, id_t id, int com, void * data);
int __sys_ppoll(struct pollfd * fds, u_int nfds, const struct timespec * ts, const sigset_t * set);
int __sys_futimens(int fd, const struct timespec * times);
int __sys_utimensat(int fd, const char * path, const struct timespec * times, int flag);
int __sys_fdatasync(int fd);
int __sys_fstat(int fd, struct stat * sb);
int __sys_fstatat(int fd, const char * path, struct stat * buf, int flag);
int __sys_fhstat(const struct fhandle * u_fhp, struct stat * sb);
ssize_t __sys_getdirentries(int fd, char * buf, size_t count, off_t * basep);
int __sys_statfs(const char * path, struct statfs * buf);
int __sys_fstatfs(int fd, struct statfs * buf);
int __sys_getfsstat(struct statfs * buf, long bufsize, int mode);
int __sys_fhstatfs(const struct fhandle * u_fhp, struct statfs * buf);
int __sys_mknodat(int fd, const char * path, mode_t mode, dev_t dev);
int __sys_kevent(int fd, const struct kevent * changelist, int nchanges, struct kevent * eventlist, int nevents, const struct timespec * timeout);
int __sys_cpuset_getdomain(cpulevel_t level, cpuwhich_t which, id_t id, size_t domainsetsize, domainset_t * mask, int * policy);
int __sys_cpuset_setdomain(cpulevel_t level, cpuwhich_t which, id_t id, size_t domainsetsize, domainset_t * mask, int policy);
int __sys_getrandom(void * buf, size_t buflen, unsigned int flags);
int __sys_getfhat(int fd, char * path, struct fhandle * fhp, int flags);
int __sys_fhlink(struct fhandle * fhp, const char * to);
int __sys_fhlinkat(struct fhandle * fhp, int tofd, const char * to);
int __sys_fhreadlink(struct fhandle * fhp, char * buf, size_t bufsize);
int __sys_funlinkat(int dfd, const char * path, int fd, int flag);
ssize_t __sys_copy_file_range(int infd, off_t * inoffp, int outfd, off_t * outoffp, size_t len, unsigned int flags);
int __sys___sysctlbyname(const char * name, size_t namelen, void * old, size_t * oldlenp, void * new, size_t newlen);
int __sys_shm_open2(const char * path, int flags, mode_t mode, int shmflags, const char * name);
int __sys_shm_rename(const char * path_from, const char * path_to, int flags);
int __sys_sigfastblock(int cmd, void * ptr);
int __sys___realpathat(int fd, const char * path, char * buf, size_t size, int flags);
int __sys_close_range(u_int lowfd, u_int highfd, int flags);
int __sys_rpctls_syscall(uint64_t socookie);
int __sys___specialfd(int type, const void * req, size_t len);
int __sys_aio_writev(struct aiocb * aiocbp);
int __sys_aio_readv(struct aiocb * aiocbp);
int __sys_fspacectl(int fd, int cmd, const struct spacectl_range * rqsr, int flags, struct spacectl_range * rmsr);
int __sys_sched_getcpu(void);
int __sys_swapoff(const char * name, u_int flags);
int __sys_kqueuex(u_int flags);
int __sys_membarrier(int cmd, unsigned flags, int cpu_id);
int __sys_timerfd_create(int clockid, int flags);
int __sys_timerfd_gettime(int fd, struct itimerspec * curr_value);
int __sys_timerfd_settime(int fd, int flags, const struct itimerspec * new_value, struct itimerspec * old_value);
int __sys_kcmp(pid_t pid1, pid_t pid2, int type, uintptr_t idx1, uintptr_t idx2);
int __sys_getrlimitusage(u_int which, int flags, rlim_t * res);
int __sys_fchroot(int fd);
int __sys_setcred(u_int flags, const struct setcred * wcred, size_t size);
int __sys_exterrctl(u_int op, u_int flags, void * ptr);
int __sys_inotify_add_watch_at(int fd, int dfd, const char * path, uint32_t mask);
int __sys_inotify_rm_watch(int fd, int wd);
int __sys_getgroups(int gidsetsize, gid_t * gidset);
int __sys_setgroups(int gidsetsize, const gid_t * gidset);
int __sys_jail_attach_jd(int fd);
int __sys_jail_remove_jd(int fd);
__END_DECLS

#endif /* __LIBSYS_H_ */
