/*-
 * Copyright (c) 2013 Chelsio Communications, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/8/sys/dev/cxgbe/common/t4_regs.h 271555 2014-09-13 22:30:04Z np $
 *
 */

/* This file is automatically generated --- changes will be lost */

#define MYPF_BASE 0x1b000
#define MYPF_REG(reg_addr) (MYPF_BASE + (reg_addr))

#define PF0_BASE 0x1e000
#define PF0_REG(reg_addr) (PF0_BASE + (reg_addr))

#define PF1_BASE 0x1e400
#define PF1_REG(reg_addr) (PF1_BASE + (reg_addr))

#define PF2_BASE 0x1e800
#define PF2_REG(reg_addr) (PF2_BASE + (reg_addr))

#define PF3_BASE 0x1ec00
#define PF3_REG(reg_addr) (PF3_BASE + (reg_addr))

#define PF4_BASE 0x1f000
#define PF4_REG(reg_addr) (PF4_BASE + (reg_addr))

#define PF5_BASE 0x1f400
#define PF5_REG(reg_addr) (PF5_BASE + (reg_addr))

#define PF6_BASE 0x1f800
#define PF6_REG(reg_addr) (PF6_BASE + (reg_addr))

#define PF7_BASE 0x1fc00
#define PF7_REG(reg_addr) (PF7_BASE + (reg_addr))

#define PF_STRIDE 0x400
#define PF_BASE(idx) (PF0_BASE + (idx) * PF_STRIDE)
#define PF_REG(idx, reg) (PF_BASE(idx) + (reg))

#define VF_SGE_BASE 0x0
#define VF_SGE_REG(reg_addr) (VF_SGE_BASE + (reg_addr))

#define VF_MPS_BASE 0x100
#define VF_MPS_REG(reg_addr) (VF_MPS_BASE + (reg_addr))

#define VF_PL_BASE 0x200
#define VF_PL_REG(reg_addr) (VF_PL_BASE + (reg_addr))

#define VF_MBDATA_BASE 0x240
#define VF_MBDATA_REG(reg_addr) (VF_MBDATA_BASE + (reg_addr))

#define VF_CIM_BASE 0x300
#define VF_CIM_REG(reg_addr) (VF_CIM_BASE + (reg_addr))

#define MYPORT_BASE 0x1c000
#define MYPORT_REG(reg_addr) (MYPORT_BASE + (reg_addr))

#define PORT0_BASE 0x20000
#define PORT0_REG(reg_addr) (PORT0_BASE + (reg_addr))

#define PORT1_BASE 0x22000
#define PORT1_REG(reg_addr) (PORT1_BASE + (reg_addr))

#define PORT2_BASE 0x24000
#define PORT2_REG(reg_addr) (PORT2_BASE + (reg_addr))

#define PORT3_BASE 0x26000
#define PORT3_REG(reg_addr) (PORT3_BASE + (reg_addr))

#define PORT_STRIDE 0x2000
#define PORT_BASE(idx) (PORT0_BASE + (idx) * PORT_STRIDE)
#define PORT_REG(idx, reg) (PORT_BASE(idx) + (reg))

#define SGE_QUEUE_BASE_MAP_HIGH(idx) (A_SGE_QUEUE_BASE_MAP_HIGH + (idx) * 8)
#define NUM_SGE_QUEUE_BASE_MAP_HIGH_INSTANCES 136

#define SGE_QUEUE_BASE_MAP_LOW(idx) (A_SGE_QUEUE_BASE_MAP_LOW + (idx) * 8)
#define NUM_SGE_QUEUE_BASE_MAP_LOW_INSTANCES 136

#define PCIE_DMA_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_DMA_INSTANCES 4

#define PCIE_CMD_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_CMD_INSTANCES 2

#define PCIE_HMA_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_HMA_INSTANCES 1

#define PCIE_MEM_ACCESS_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_MEM_ACCESS_INSTANCES 8

#define PCIE_MAILBOX_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_MAILBOX_INSTANCES 1

#define PCIE_FW_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_PCIE_FW_INSTANCES 8

#define PCIE_FUNC_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_FUNC_INSTANCES 256

#define PCIE_FID(idx) (A_PCIE_FID + (idx) * 4)
#define NUM_PCIE_FID_INSTANCES 2048

#define PCIE_DMA_BUF_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_DMA_BUF_INSTANCES 4

#define MC_DDR3PHYDATX8_REG(reg_addr, idx) ((reg_addr) + (idx) * 256)
#define NUM_MC_DDR3PHYDATX8_INSTANCES 9

#define MC_BIST_STATUS_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_BIST_STATUS_INSTANCES 18

#define EDC_BIST_STATUS_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_EDC_BIST_STATUS_INSTANCES 18

#define CIM_PF_MAILBOX_DATA(idx) (A_CIM_PF_MAILBOX_DATA + (idx) * 4)
#define NUM_CIM_PF_MAILBOX_DATA_INSTANCES 16

#define MPS_TRC_FILTER_MATCH_CTL_A(idx) (A_MPS_TRC_FILTER_MATCH_CTL_A + (idx) * 4)
#define NUM_MPS_TRC_FILTER_MATCH_CTL_A_INSTANCES 4

#define MPS_TRC_FILTER_MATCH_CTL_B(idx) (A_MPS_TRC_FILTER_MATCH_CTL_B + (idx) * 4)
#define NUM_MPS_TRC_FILTER_MATCH_CTL_B_INSTANCES 4

#define MPS_TRC_FILTER_RUNT_CTL(idx) (A_MPS_TRC_FILTER_RUNT_CTL + (idx) * 4)
#define NUM_MPS_TRC_FILTER_RUNT_CTL_INSTANCES 4

#define MPS_TRC_FILTER_DROP(idx) (A_MPS_TRC_FILTER_DROP + (idx) * 4)
#define NUM_MPS_TRC_FILTER_DROP_INSTANCES 4

#define MPS_TRC_FILTER0_MATCH(idx) (A_MPS_TRC_FILTER0_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER0_MATCH_INSTANCES 28

#define MPS_TRC_FILTER0_DONT_CARE(idx) (A_MPS_TRC_FILTER0_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER0_DONT_CARE_INSTANCES 28

#define MPS_TRC_FILTER1_MATCH(idx) (A_MPS_TRC_FILTER1_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER1_MATCH_INSTANCES 28

#define MPS_TRC_FILTER1_DONT_CARE(idx) (A_MPS_TRC_FILTER1_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER1_DONT_CARE_INSTANCES 28

#define MPS_TRC_FILTER2_MATCH(idx) (A_MPS_TRC_FILTER2_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER2_MATCH_INSTANCES 28

#define MPS_TRC_FILTER2_DONT_CARE(idx) (A_MPS_TRC_FILTER2_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER2_DONT_CARE_INSTANCES 28

#define MPS_TRC_FILTER3_MATCH(idx) (A_MPS_TRC_FILTER3_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER3_MATCH_INSTANCES 28

#define MPS_TRC_FILTER3_DONT_CARE(idx) (A_MPS_TRC_FILTER3_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER3_DONT_CARE_INSTANCES 28

#define MPS_PORT_CLS_HASH_SRAM(idx) (A_MPS_PORT_CLS_HASH_SRAM + (idx) * 4)
#define NUM_MPS_PORT_CLS_HASH_SRAM_INSTANCES 65

#define MPS_CLS_VLAN_TABLE(idx) (A_MPS_CLS_VLAN_TABLE + (idx) * 4)
#define NUM_MPS_CLS_VLAN_TABLE_INSTANCES 9

#define MPS_CLS_SRAM_L(idx) (A_MPS_CLS_SRAM_L + (idx) * 8)
#define NUM_MPS_CLS_SRAM_L_INSTANCES 336

#define MPS_CLS_SRAM_H(idx) (A_MPS_CLS_SRAM_H + (idx) * 8)
#define NUM_MPS_CLS_SRAM_H_INSTANCES 336

#define MPS_CLS_TCAM_Y_L(idx) (A_MPS_CLS_TCAM_Y_L + (idx) * 16)
#define NUM_MPS_CLS_TCAM_Y_L_INSTANCES 512

#define MPS_CLS_TCAM_Y_H(idx) (A_MPS_CLS_TCAM_Y_H + (idx) * 16)
#define NUM_MPS_CLS_TCAM_Y_H_INSTANCES 512

#define MPS_CLS_TCAM_X_L(idx) (A_MPS_CLS_TCAM_X_L + (idx) * 16)
#define NUM_MPS_CLS_TCAM_X_L_INSTANCES 512

#define MPS_CLS_TCAM_X_H(idx) (A_MPS_CLS_TCAM_X_H + (idx) * 16)
#define NUM_MPS_CLS_TCAM_X_H_INSTANCES 512

#define PL_SEMAPHORE_LOCK(idx) (A_PL_SEMAPHORE_LOCK + (idx) * 4)
#define NUM_PL_SEMAPHORE_LOCK_INSTANCES 8

#define PL_VF_SLICE_L(idx) (A_PL_VF_SLICE_L + (idx) * 8)
#define NUM_PL_VF_SLICE_L_INSTANCES 8

#define PL_VF_SLICE_H(idx) (A_PL_VF_SLICE_H + (idx) * 8)
#define NUM_PL_VF_SLICE_H_INSTANCES 8

#define PL_FLR_VF_STATUS(idx) (A_PL_FLR_VF_STATUS + (idx) * 4)
#define NUM_PL_FLR_VF_STATUS_INSTANCES 4

#define PL_VFID_MAP(idx) (A_PL_VFID_MAP + (idx) * 4)
#define NUM_PL_VFID_MAP_INSTANCES 256

#define LE_DB_MASK_IPV4(idx) (A_LE_DB_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_MASK_IPV4_INSTANCES 17

#define LE_DB_MASK_IPV6(idx) (A_LE_DB_MASK_IPV6 + (idx) * 4)
#define NUM_LE_DB_MASK_IPV6_INSTANCES 17

#define LE_DB_DBGI_REQ_DATA(idx) (A_LE_DB_DBGI_REQ_DATA + (idx) * 4)
#define NUM_LE_DB_DBGI_REQ_DATA_INSTANCES 17

#define LE_DB_DBGI_REQ_MASK(idx) (A_LE_DB_DBGI_REQ_MASK + (idx) * 4)
#define NUM_LE_DB_DBGI_REQ_MASK_INSTANCES 17

#define LE_DB_DBGI_RSP_DATA(idx) (A_LE_DB_DBGI_RSP_DATA + (idx) * 4)
#define NUM_LE_DB_DBGI_RSP_DATA_INSTANCES 17

#define LE_DB_ACTIVE_MASK_IPV4(idx) (A_LE_DB_ACTIVE_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_ACTIVE_MASK_IPV4_INSTANCES 17

#define LE_DB_ACTIVE_MASK_IPV6(idx) (A_LE_DB_ACTIVE_MASK_IPV6 + (idx) * 4)
#define NUM_LE_DB_ACTIVE_MASK_IPV6_INSTANCES 17

#define LE_HASH_MASK_GEN_IPV4(idx) (A_LE_HASH_MASK_GEN_IPV4 + (idx) * 4)
#define NUM_LE_HASH_MASK_GEN_IPV4_INSTANCES 4

#define LE_HASH_MASK_GEN_IPV6(idx) (A_LE_HASH_MASK_GEN_IPV6 + (idx) * 4)
#define NUM_LE_HASH_MASK_GEN_IPV6_INSTANCES 12

#define LE_HASH_MASK_CMP_IPV4(idx) (A_LE_HASH_MASK_CMP_IPV4 + (idx) * 4)
#define NUM_LE_HASH_MASK_CMP_IPV4_INSTANCES 4

#define LE_HASH_MASK_CMP_IPV6(idx) (A_LE_HASH_MASK_CMP_IPV6 + (idx) * 4)
#define NUM_LE_HASH_MASK_CMP_IPV6_INSTANCES 12

#define UP_TSCH_CHANNEL_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_UP_TSCH_CHANNEL_INSTANCES 4

#define CIM_CTL_MAILBOX_VF_STATUS(idx) (A_CIM_CTL_MAILBOX_VF_STATUS + (idx) * 4)
#define NUM_CIM_CTL_MAILBOX_VF_STATUS_INSTANCES 4

#define CIM_CTL_MAILBOX_VFN_CTL(idx) (A_CIM_CTL_MAILBOX_VFN_CTL + (idx) * 16)
#define NUM_CIM_CTL_MAILBOX_VFN_CTL_INSTANCES 128

#define CIM_CTL_TSCH_CHANNEL_REG(reg_addr, idx) ((reg_addr) + (idx) * 288)
#define NUM_CIM_CTL_TSCH_CHANNEL_INSTANCES 4

#define CIM_CTL_TSCH_CHANNEL_TSCH_CLASS_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_CIM_CTL_TSCH_CHANNEL_TSCH_CLASS_INSTANCES 16

#define T5_MYPORT_BASE 0x2c000
#define T5_MYPORT_REG(reg_addr) (T5_MYPORT_BASE + (reg_addr))

#define T5_PORT0_BASE 0x30000
#define T5_PORT0_REG(reg_addr) (T5_PORT0_BASE + (reg_addr))

#define T5_PORT1_BASE 0x34000
#define T5_PORT1_REG(reg_addr) (T5_PORT1_BASE + (reg_addr))

#define T5_PORT2_BASE 0x38000
#define T5_PORT2_REG(reg_addr) (T5_PORT2_BASE + (reg_addr))

#define T5_PORT3_BASE 0x3c000
#define T5_PORT3_REG(reg_addr) (T5_PORT3_BASE + (reg_addr))

#define T5_PORT_STRIDE 0x4000
#define T5_PORT_BASE(idx) (T5_PORT0_BASE + (idx) * T5_PORT_STRIDE)
#define T5_PORT_REG(idx, reg) (T5_PORT_BASE(idx) + (reg))

#define MC_STRIDE (MC_1_BASE_ADDR - MC_0_BASE_ADDR)
#define MC_REG(reg, idx) (reg + MC_STRIDE * idx)

#define PCIE_PF_INT_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_PF_INT_INSTANCES 8

#define PCIE_VF_INT_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_VF_INT_INSTANCES 128

#define PCIE_FID_VFID(idx) (A_PCIE_FID_VFID + (idx) * 4)
#define NUM_PCIE_FID_VFID_INSTANCES 2048

#define PCIE_COOKIE_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_PCIE_COOKIE_INSTANCES 8

#define PCIE_T5_DMA_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_T5_DMA_INSTANCES 4

#define PCIE_T5_CMD_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_T5_CMD_INSTANCES 3

#define PCIE_T5_HMA_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_T5_HMA_INSTANCES 1

#define PCIE_PHY_PRESET_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_PCIE_PHY_PRESET_INSTANCES 11

#define MPS_T5_CLS_SRAM_L(idx) (A_MPS_T5_CLS_SRAM_L + (idx) * 8)
#define NUM_MPS_T5_CLS_SRAM_L_INSTANCES 512

#define MPS_T5_CLS_SRAM_H(idx) (A_MPS_T5_CLS_SRAM_H + (idx) * 8)
#define NUM_MPS_T5_CLS_SRAM_H_INSTANCES 512

#define LE_T5_DB_MASK_IPV4(idx) (A_LE_T5_DB_MASK_IPV4 + (idx) * 4)
#define NUM_LE_T5_DB_MASK_IPV4_INSTANCES 5

#define LE_T5_DB_ACTIVE_MASK_IPV4(idx) (A_LE_T5_DB_ACTIVE_MASK_IPV4 + (idx) * 4)
#define NUM_LE_T5_DB_ACTIVE_MASK_IPV4_INSTANCES 5

#define LE_HASH_MASK_GEN_IPV4T5(idx) (A_LE_HASH_MASK_GEN_IPV4T5 + (idx) * 4)
#define NUM_LE_HASH_MASK_GEN_IPV4T5_INSTANCES 5

#define LE_HASH_MASK_GEN_IPV6T5(idx) (A_LE_HASH_MASK_GEN_IPV6T5 + (idx) * 4)
#define NUM_LE_HASH_MASK_GEN_IPV6T5_INSTANCES 12

#define LE_HASH_MASK_CMP_IPV4T5(idx) (A_LE_HASH_MASK_CMP_IPV4T5 + (idx) * 4)
#define NUM_LE_HASH_MASK_CMP_IPV4T5_INSTANCES 5

#define LE_HASH_MASK_CMP_IPV6T5(idx) (A_LE_HASH_MASK_CMP_IPV6T5 + (idx) * 4)
#define NUM_LE_HASH_MASK_CMP_IPV6T5_INSTANCES 12

#define LE_DB_SECOND_ACTIVE_MASK_IPV4(idx) (A_LE_DB_SECOND_ACTIVE_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_SECOND_ACTIVE_MASK_IPV4_INSTANCES 5

#define LE_DB_SECOND_GEN_HASH_MASK_IPV4(idx) (A_LE_DB_SECOND_GEN_HASH_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_SECOND_GEN_HASH_MASK_IPV4_INSTANCES 5

#define LE_DB_SECOND_CMP_HASH_MASK_IPV4(idx) (A_LE_DB_SECOND_CMP_HASH_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_SECOND_CMP_HASH_MASK_IPV4_INSTANCES 5

#define MC_ADR_REG(reg_addr, idx) ((reg_addr) + (idx) * 512)
#define NUM_MC_ADR_INSTANCES 2

#define MC_DDRPHY_DP18_REG(reg_addr, idx) ((reg_addr) + (idx) * 512)
#define NUM_MC_DDRPHY_DP18_INSTANCES 5

#define MC_CE_ERR_DATA_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_CE_ERR_DATA_INSTANCES 8

#define MC_CE_COR_DATA_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_CE_COR_DATA_INSTANCES 8

#define MC_UE_ERR_DATA_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_UE_ERR_DATA_INSTANCES 8

#define MC_UE_COR_DATA_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_UE_COR_DATA_INSTANCES 8

#define MC_P_BIST_STATUS_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_P_BIST_STATUS_INSTANCES 18

#define EDC_H_BIST_STATUS_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_EDC_H_BIST_STATUS_INSTANCES 18

#define EDC_H_ECC_ERR_DATA_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_EDC_H_ECC_ERR_DATA_INSTANCES 16

#define EDC_STRIDE (EDC_1_BASE_ADDR - EDC_0_BASE_ADDR)
#define EDC_REG(reg, idx) (reg + EDC_STRIDE * idx)

/* registers for module SGE */
#define SGE_BASE_ADDR 0x1000

#define A_SGE_PF_KDOORBELL 0x0

#define S_QID    15
#define M_QID    0x1ffffU
#define V_QID(x) ((x) << S_QID)
#define G_QID(x) (((x) >> S_QID) & M_QID)

#define S_DBPRIO    14
#define V_DBPRIO(x) ((x) << S_DBPRIO)
#define F_DBPRIO    V_DBPRIO(1U)

#define S_PIDX    0
#define M_PIDX    0x3fffU
#define V_PIDX(x) ((x) << S_PIDX)
#define G_PIDX(x) (((x) >> S_PIDX) & M_PIDX)

#define A_SGE_VF_KDOORBELL 0x0

#define S_DBTYPE    13
#define V_DBTYPE(x) ((x) << S_DBTYPE)
#define F_DBTYPE    V_DBTYPE(1U)

#define S_PIDX_T5    0
#define M_PIDX_T5    0x1fffU
#define V_PIDX_T5(x) ((x) << S_PIDX_T5)
#define G_PIDX_T5(x) (((x) >> S_PIDX_T5) & M_PIDX_T5)

#define A_SGE_PF_GTS 0x4

#define S_INGRESSQID    16
#define M_INGRESSQID    0xffffU
#define V_INGRESSQID(x) ((x) << S_INGRESSQID)
#define G_INGRESSQID(x) (((x) >> S_INGRESSQID) & M_INGRESSQID)

#define S_TIMERREG    13
#define M_TIMERREG    0x7U
#define V_TIMERREG(x) ((x) << S_TIMERREG)
#define G_TIMERREG(x) (((x) >> S_TIMERREG) & M_TIMERREG)

#define S_SEINTARM    12
#define V_SEINTARM(x) ((x) << S_SEINTARM)
#define F_SEINTARM    V_SEINTARM(1U)

#define S_CIDXINC    0
#define M_CIDXINC    0xfffU
#define V_CIDXINC(x) ((x) << S_CIDXINC)
#define G_CIDXINC(x) (((x) >> S_CIDXINC) & M_CIDXINC)

#define A_SGE_VF_GTS 0x4
#define A_SGE_PF_KTIMESTAMP_LO 0x8
#define A_SGE_VF_KTIMESTAMP_LO 0x8
#define A_SGE_PF_KTIMESTAMP_HI 0xc

#define S_TSTAMPVAL    0
#define M_TSTAMPVAL    0xfffffffU
#define V_TSTAMPVAL(x) ((x) << S_TSTAMPVAL)
#define G_TSTAMPVAL(x) (((x) >> S_TSTAMPVAL) & M_TSTAMPVAL)

#define A_SGE_VF_KTIMESTAMP_HI 0xc
#define A_SGE_CONTROL 0x1008

#define S_IGRALLCPLTOFL    31
#define V_IGRALLCPLTOFL(x) ((x) << S_IGRALLCPLTOFL)
#define F_IGRALLCPLTOFL    V_IGRALLCPLTOFL(1U)

#define S_FLSPLITMIN    22
#define M_FLSPLITMIN    0x1ffU
#define V_FLSPLITMIN(x) ((x) << S_FLSPLITMIN)
#define G_FLSPLITMIN(x) (((x) >> S_FLSPLITMIN) & M_FLSPLITMIN)

#define S_FLSPLITMODE    20
#define M_FLSPLITMODE    0x3U
#define V_FLSPLITMODE(x) ((x) << S_FLSPLITMODE)
#define G_FLSPLITMODE(x) (((x) >> S_FLSPLITMODE) & M_FLSPLITMODE)

#define S_DCASYSTYPE    19
#define V_DCASYSTYPE(x) ((x) << S_DCASYSTYPE)
#define F_DCASYSTYPE    V_DCASYSTYPE(1U)

#define S_RXPKTCPLMODE    18
#define V_RXPKTCPLMODE(x) ((x) << S_RXPKTCPLMODE)
#define F_RXPKTCPLMODE    V_RXPKTCPLMODE(1U)

#define S_EGRSTATUSPAGESIZE    17
#define V_EGRSTATUSPAGESIZE(x) ((x) << S_EGRSTATUSPAGESIZE)
#define F_EGRSTATUSPAGESIZE    V_EGRSTATUSPAGESIZE(1U)

#define S_INGHINTENABLE1    15
#define V_INGHINTENABLE1(x) ((x) << S_INGHINTENABLE1)
#define F_INGHINTENABLE1    V_INGHINTENABLE1(1U)

#define S_INGHINTENABLE0    14
#define V_INGHINTENABLE0(x) ((x) << S_INGHINTENABLE0)
#define F_INGHINTENABLE0    V_INGHINTENABLE0(1U)

#define S_INGINTCOMPAREIDX    13
#define V_INGINTCOMPAREIDX(x) ((x) << S_INGINTCOMPAREIDX)
#define F_INGINTCOMPAREIDX    V_INGINTCOMPAREIDX(1U)

#define S_PKTSHIFT    10
#define M_PKTSHIFT    0x7U
#define V_PKTSHIFT(x) ((x) << S_PKTSHIFT)
#define G_PKTSHIFT(x) (((x) >> S_PKTSHIFT) & M_PKTSHIFT)

#define S_INGPCIEBOUNDARY    7
#define M_INGPCIEBOUNDARY    0x7U
#define V_INGPCIEBOUNDARY(x) ((x) << S_INGPCIEBOUNDARY)
#define G_INGPCIEBOUNDARY(x) (((x) >> S_INGPCIEBOUNDARY) & M_INGPCIEBOUNDARY)

#define S_INGPADBOUNDARY    4
#define M_INGPADBOUNDARY    0x7U
#define V_INGPADBOUNDARY(x) ((x) << S_INGPADBOUNDARY)
#define G_INGPADBOUNDARY(x) (((x) >> S_INGPADBOUNDARY) & M_INGPADBOUNDARY)

#define S_EGRPCIEBOUNDARY    1
#define M_EGRPCIEBOUNDARY    0x7U
#define V_EGRPCIEBOUNDARY(x) ((x) << S_EGRPCIEBOUNDARY)
#define G_EGRPCIEBOUNDARY(x) (((x) >> S_EGRPCIEBOUNDARY) & M_EGRPCIEBOUNDARY)

#define S_GLOBALENABLE    0
#define V_GLOBALENABLE(x) ((x) << S_GLOBALENABLE)
#define F_GLOBALENABLE    V_GLOBALENABLE(1U)

#define A_SGE_HOST_PAGE_SIZE 0x100c

#define S_HOSTPAGESIZEPF7    28
#define M_HOSTPAGESIZEPF7    0xfU
#define V_HOSTPAGESIZEPF7(x) ((x) << S_HOSTPAGESIZEPF7)
#define G_HOSTPAGESIZEPF7(x) (((x) >> S_HOSTPAGESIZEPF7) & M_HOSTPAGESIZEPF7)

#define S_HOSTPAGESIZEPF6    24
#define M_HOSTPAGESIZEPF6    0xfU
#define V_HOSTPAGESIZEPF6(x) ((x) << S_HOSTPAGESIZEPF6)
#define G_HOSTPAGESIZEPF6(x) (((x) >> S_HOSTPAGESIZEPF6) & M_HOSTPAGESIZEPF6)

#define S_HOSTPAGESIZEPF5    20
#define M_HOSTPAGESIZEPF5    0xfU
#define V_HOSTPAGESIZEPF5(x) ((x) << S_HOSTPAGESIZEPF5)
#define G_HOSTPAGESIZEPF5(x) (((x) >> S_HOSTPAGESIZEPF5) & M_HOSTPAGESIZEPF5)

#define S_HOSTPAGESIZEPF4    16
#define M_HOSTPAGESIZEPF4    0xfU
#define V_HOSTPAGESIZEPF4(x) ((x) << S_HOSTPAGESIZEPF4)
#define G_HOSTPAGESIZEPF4(x) (((x) >> S_HOSTPAGESIZEPF4) & M_HOSTPAGESIZEPF4)

#define S_HOSTPAGESIZEPF3    12
#define M_HOSTPAGESIZEPF3    0xfU
#define V_HOSTPAGESIZEPF3(x) ((x) << S_HOSTPAGESIZEPF3)
#define G_HOSTPAGESIZEPF3(x) (((x) >> S_HOSTPAGESIZEPF3) & M_HOSTPAGESIZEPF3)

#define S_HOSTPAGESIZEPF2    8
#define M_HOSTPAGESIZEPF2    0xfU
#define V_HOSTPAGESIZEPF2(x) ((x) << S_HOSTPAGESIZEPF2)
#define G_HOSTPAGESIZEPF2(x) (((x) >> S_HOSTPAGESIZEPF2) & M_HOSTPAGESIZEPF2)

#define S_HOSTPAGESIZEPF1    4
#define M_HOSTPAGESIZEPF1    0xfU
#define V_HOSTPAGESIZEPF1(x) ((x) << S_HOSTPAGESIZEPF1)
#define G_HOSTPAGESIZEPF1(x) (((x) >> S_HOSTPAGESIZEPF1) & M_HOSTPAGESIZEPF1)

#define S_HOSTPAGESIZEPF0    0
#define M_HOSTPAGESIZEPF0    0xfU
#define V_HOSTPAGESIZEPF0(x) ((x) << S_HOSTPAGESIZEPF0)
#define G_HOSTPAGESIZEPF0(x) (((x) >> S_HOSTPAGESIZEPF0) & M_HOSTPAGESIZEPF0)

#define A_SGE_EGRESS_QUEUES_PER_PAGE_PF 0x1010

#define S_QUEUESPERPAGEPF7    28
#define M_QUEUESPERPAGEPF7    0xfU
#define V_QUEUESPERPAGEPF7(x) ((x) << S_QUEUESPERPAGEPF7)
#define G_QUEUESPERPAGEPF7(x) (((x) >> S_QUEUESPERPAGEPF7) & M_QUEUESPERPAGEPF7)

#define S_QUEUESPERPAGEPF6    24
#define M_QUEUESPERPAGEPF6    0xfU
#define V_QUEUESPERPAGEPF6(x) ((x) << S_QUEUESPERPAGEPF6)
#define G_QUEUESPERPAGEPF6(x) (((x) >> S_QUEUESPERPAGEPF6) & M_QUEUESPERPAGEPF6)

#define S_QUEUESPERPAGEPF5    20
#define M_QUEUESPERPAGEPF5    0xfU
#define V_QUEUESPERPAGEPF5(x) ((x) << S_QUEUESPERPAGEPF5)
#define G_QUEUESPERPAGEPF5(x) (((x) >> S_QUEUESPERPAGEPF5) & M_QUEUESPERPAGEPF5)

#define S_QUEUESPERPAGEPF4    16
#define M_QUEUESPERPAGEPF4    0xfU
#define V_QUEUESPERPAGEPF4(x) ((x) << S_QUEUESPERPAGEPF4)
#define G_QUEUESPERPAGEPF4(x) (((x) >> S_QUEUESPERPAGEPF4) & M_QUEUESPERPAGEPF4)

#define S_QUEUESPERPAGEPF3    12
#define M_QUEUESPERPAGEPF3    0xfU
#define V_QUEUESPERPAGEPF3(x) ((x) << S_QUEUESPERPAGEPF3)
#define G_QUEUESPERPAGEPF3(x) (((x) >> S_QUEUESPERPAGEPF3) & M_QUEUESPERPAGEPF3)

#define S_QUEUESPERPAGEPF2    8
#define M_QUEUESPERPAGEPF2    0xfU
#define V_QUEUESPERPAGEPF2(x) ((x) << S_QUEUESPERPAGEPF2)
#define G_QUEUESPERPAGEPF2(x) (((x) >> S_QUEUESPERPAGEPF2) & M_QUEUESPERPAGEPF2)

#define S_QUEUESPERPAGEPF1    4
#define M_QUEUESPERPAGEPF1    0xfU
#define V_QUEUESPERPAGEPF1(x) ((x) << S_QUEUESPERPAGEPF1)
#define G_QUEUESPERPAGEPF1(x) (((x) >> S_QUEUESPERPAGEPF1) & M_QUEUESPERPAGEPF1)

#define S_QUEUESPERPAGEPF0    0
#define M_QUEUESPERPAGEPF0    0xfU
#define V_QUEUESPERPAGEPF0(x) ((x) << S_QUEUESPERPAGEPF0)
#define G_QUEUESPERPAGEPF0(x) (((x) >> S_QUEUESPERPAGEPF0) & M_QUEUESPERPAGEPF0)

#define A_SGE_EGRESS_QUEUES_PER_PAGE_VF 0x1014

#define S_QUEUESPERPAGEVFPF7    28
#define M_QUEUESPERPAGEVFPF7    0xfU
#define V_QUEUESPERPAGEVFPF7(x) ((x) << S_QUEUESPERPAGEVFPF7)
#define G_QUEUESPERPAGEVFPF7(x) (((x) >> S_QUEUESPERPAGEVFPF7) & M_QUEUESPERPAGEVFPF7)

#define S_QUEUESPERPAGEVFPF6    24
#define M_QUEUESPERPAGEVFPF6    0xfU
#define V_QUEUESPERPAGEVFPF6(x) ((x) << S_QUEUESPERPAGEVFPF6)
#define G_QUEUESPERPAGEVFPF6(x) (((x) >> S_QUEUESPERPAGEVFPF6) & M_QUEUESPERPAGEVFPF6)

#define S_QUEUESPERPAGEVFPF5    20
#define M_QUEUESPERPAGEVFPF5    0xfU
#define V_QUEUESPERPAGEVFPF5(x) ((x) << S_QUEUESPERPAGEVFPF5)
#define G_QUEUESPERPAGEVFPF5(x) (((x) >> S_QUEUESPERPAGEVFPF5) & M_QUEUESPERPAGEVFPF5)

#define S_QUEUESPERPAGEVFPF4    16
#define M_QUEUESPERPAGEVFPF4    0xfU
#define V_QUEUESPERPAGEVFPF4(x) ((x) << S_QUEUESPERPAGEVFPF4)
#define G_QUEUESPERPAGEVFPF4(x) (((x) >> S_QUEUESPERPAGEVFPF4) & M_QUEUESPERPAGEVFPF4)

#define S_QUEUESPERPAGEVFPF3    12
#define M_QUEUESPERPAGEVFPF3    0xfU
#define V_QUEUESPERPAGEVFPF3(x) ((x) << S_QUEUESPERPAGEVFPF3)
#define G_QUEUESPERPAGEVFPF3(x) (((x) >> S_QUEUESPERPAGEVFPF3) & M_QUEUESPERPAGEVFPF3)

#define S_QUEUESPERPAGEVFPF2    8
#define M_QUEUESPERPAGEVFPF2    0xfU
#define V_QUEUESPERPAGEVFPF2(x) ((x) << S_QUEUESPERPAGEVFPF2)
#define G_QUEUESPERPAGEVFPF2(x) (((x) >> S_QUEUESPERPAGEVFPF2) & M_QUEUESPERPAGEVFPF2)

#define S_QUEUESPERPAGEVFPF1    4
#define M_QUEUESPERPAGEVFPF1    0xfU
#define V_QUEUESPERPAGEVFPF1(x) ((x) << S_QUEUESPERPAGEVFPF1)
#define G_QUEUESPERPAGEVFPF1(x) (((x) >> S_QUEUESPERPAGEVFPF1) & M_QUEUESPERPAGEVFPF1)

#define S_QUEUESPERPAGEVFPF0    0
#define M_QUEUESPERPAGEVFPF0    0xfU
#define V_QUEUESPERPAGEVFPF0(x) ((x) << S_QUEUESPERPAGEVFPF0)
#define G_QUEUESPERPAGEVFPF0(x) (((x) >> S_QUEUESPERPAGEVFPF0) & M_QUEUESPERPAGEVFPF0)

#define A_SGE_USER_MODE_LIMITS 0x1018

#define S_OPCODE_MIN    24
#define M_OPCODE_MIN    0xffU
#define V_OPCODE_MIN(x) ((x) << S_OPCODE_MIN)
#define G_OPCODE_MIN(x) (((x) >> S_OPCODE_MIN) & M_OPCODE_MIN)

#define S_OPCODE_MAX    16
#define M_OPCODE_MAX    0xffU
#define V_OPCODE_MAX(x) ((x) << S_OPCODE_MAX)
#define G_OPCODE_MAX(x) (((x) >> S_OPCODE_MAX) & M_OPCODE_MAX)

#define S_LENGTH_MIN    8
#define M_LENGTH_MIN    0xffU
#define V_LENGTH_MIN(x) ((x) << S_LENGTH_MIN)
#define G_LENGTH_MIN(x) (((x) >> S_LENGTH_MIN) & M_LENGTH_MIN)

#define S_LENGTH_MAX    0
#define M_LENGTH_MAX    0xffU
#define V_LENGTH_MAX(x) ((x) << S_LENGTH_MAX)
#define G_LENGTH_MAX(x) (((x) >> S_LENGTH_MAX) & M_LENGTH_MAX)

#define A_SGE_WR_ERROR 0x101c

#define S_WR_ERROR_OPCODE    0
#define M_WR_ERROR_OPCODE    0xffU
#define V_WR_ERROR_OPCODE(x) ((x) << S_WR_ERROR_OPCODE)
#define G_WR_ERROR_OPCODE(x) (((x) >> S_WR_ERROR_OPCODE) & M_WR_ERROR_OPCODE)

#define A_SGE_PERR_INJECT 0x1020

#define S_MEMSEL    1
#define M_MEMSEL    0x1fU
#define V_MEMSEL(x) ((x) << S_MEMSEL)
#define G_MEMSEL(x) (((x) >> S_MEMSEL) & M_MEMSEL)

#define S_INJECTDATAERR    0
#define V_INJECTDATAERR(x) ((x) << S_INJECTDATAERR)
#define F_INJECTDATAERR    V_INJECTDATAERR(1U)

#define A_SGE_INT_CAUSE1 0x1024

#define S_PERR_FLM_CREDITFIFO    30
#define V_PERR_FLM_CREDITFIFO(x) ((x) << S_PERR_FLM_CREDITFIFO)
#define F_PERR_FLM_CREDITFIFO    V_PERR_FLM_CREDITFIFO(1U)

#define S_PERR_IMSG_HINT_FIFO    29
#define V_PERR_IMSG_HINT_FIFO(x) ((x) << S_PERR_IMSG_HINT_FIFO)
#define F_PERR_IMSG_HINT_FIFO    V_PERR_IMSG_HINT_FIFO(1U)

#define S_PERR_MC_PC    28
#define V_PERR_MC_PC(x) ((x) << S_PERR_MC_PC)
#define F_PERR_MC_PC    V_PERR_MC_PC(1U)

#define S_PERR_MC_IGR_CTXT    27
#define V_PERR_MC_IGR_CTXT(x) ((x) << S_PERR_MC_IGR_CTXT)
#define F_PERR_MC_IGR_CTXT    V_PERR_MC_IGR_CTXT(1U)

#define S_PERR_MC_EGR_CTXT    26
#define V_PERR_MC_EGR_CTXT(x) ((x) << S_PERR_MC_EGR_CTXT)
#define F_PERR_MC_EGR_CTXT    V_PERR_MC_EGR_CTXT(1U)

#define S_PERR_MC_FLM    25
#define V_PERR_MC_FLM(x) ((x) << S_PERR_MC_FLM)
#define F_PERR_MC_FLM    V_PERR_MC_FLM(1U)

#define S_PERR_PC_MCTAG    24
#define V_PERR_PC_MCTAG(x) ((x) << S_PERR_PC_MCTAG)
#define F_PERR_PC_MCTAG    V_PERR_PC_MCTAG(1U)

#define S_PERR_PC_CHPI_RSP1    23
#define V_PERR_PC_CHPI_RSP1(x) ((x) << S_PERR_PC_CHPI_RSP1)
#define F_PERR_PC_CHPI_RSP1    V_PERR_PC_CHPI_RSP1(1U)

#define S_PERR_PC_CHPI_RSP0    22
#define V_PERR_PC_CHPI_RSP0(x) ((x) << S_PERR_PC_CHPI_RSP0)
#define F_PERR_PC_CHPI_RSP0    V_PERR_PC_CHPI_RSP0(1U)

#define S_PERR_DBP_PC_RSP_FIFO3    21
#define V_PERR_DBP_PC_RSP_FIFO3(x) ((x) << S_PERR_DBP_PC_RSP_FIFO3)
#define F_PERR_DBP_PC_RSP_FIFO3    V_PERR_DBP_PC_RSP_FIFO3(1U)

#define S_PERR_DBP_PC_RSP_FIFO2    20
#define V_PERR_DBP_PC_RSP_FIFO2(x) ((x) << S_PERR_DBP_PC_RSP_FIFO2)
#define F_PERR_DBP_PC_RSP_FIFO2    V_PERR_DBP_PC_RSP_FIFO2(1U)

#define S_PERR_DBP_PC_RSP_FIFO1    19
#define V_PERR_DBP_PC_RSP_FIFO1(x) ((x) << S_PERR_DBP_PC_RSP_FIFO1)
#define F_PERR_DBP_PC_RSP_FIFO1    V_PERR_DBP_PC_RSP_FIFO1(1U)

#define S_PERR_DBP_PC_RSP_FIFO0    18
#define V_PERR_DBP_PC_RSP_FIFO0(x) ((x) << S_PERR_DBP_PC_RSP_FIFO0)
#define F_PERR_DBP_PC_RSP_FIFO0    V_PERR_DBP_PC_RSP_FIFO0(1U)

#define S_PERR_DMARBT    17
#define V_PERR_DMARBT(x) ((x) << S_PERR_DMARBT)
#define F_PERR_DMARBT    V_PERR_DMARBT(1U)

#define S_PERR_FLM_DBPFIFO    16
#define V_PERR_FLM_DBPFIFO(x) ((x) << S_PERR_FLM_DBPFIFO)
#define F_PERR_FLM_DBPFIFO    V_PERR_FLM_DBPFIFO(1U)

#define S_PERR_FLM_MCREQ_FIFO    15
#define V_PERR_FLM_MCREQ_FIFO(x) ((x) << S_PERR_FLM_MCREQ_FIFO)
#define F_PERR_FLM_MCREQ_FIFO    V_PERR_FLM_MCREQ_FIFO(1U)

#define S_PERR_FLM_HINTFIFO    14
#define V_PERR_FLM_HINTFIFO(x) ((x) << S_PERR_FLM_HINTFIFO)
#define F_PERR_FLM_HINTFIFO    V_PERR_FLM_HINTFIFO(1U)

#define S_PERR_ALIGN_CTL_FIFO3    13
#define V_PERR_ALIGN_CTL_FIFO3(x) ((x) << S_PERR_ALIGN_CTL_FIFO3)
#define F_PERR_ALIGN_CTL_FIFO3    V_PERR_ALIGN_CTL_FIFO3(1U)

#define S_PERR_ALIGN_CTL_FIFO2    12
#define V_PERR_ALIGN_CTL_FIFO2(x) ((x) << S_PERR_ALIGN_CTL_FIFO2)
#define F_PERR_ALIGN_CTL_FIFO2    V_PERR_ALIGN_CTL_FIFO2(1U)

#define S_PERR_ALIGN_CTL_FIFO1    11
#define V_PERR_ALIGN_CTL_FIFO1(x) ((x) << S_PERR_ALIGN_CTL_FIFO1)
#define F_PERR_ALIGN_CTL_FIFO1    V_PERR_ALIGN_CTL_FIFO1(1U)

#define S_PERR_ALIGN_CTL_FIFO0    10
#define V_PERR_ALIGN_CTL_FIFO0(x) ((x) << S_PERR_ALIGN_CTL_FIFO0)
#define F_PERR_ALIGN_CTL_FIFO0    V_PERR_ALIGN_CTL_FIFO0(1U)

#define S_PERR_EDMA_FIFO3    9
#define V_PERR_EDMA_FIFO3(x) ((x) << S_PERR_EDMA_FIFO3)
#define F_PERR_EDMA_FIFO3    V_PERR_EDMA_FIFO3(1U)

#define S_PERR_EDMA_FIFO2    8
#define V_PERR_EDMA_FIFO2(x) ((x) << S_PERR_EDMA_FIFO2)
#define F_PERR_EDMA_FIFO2    V_PERR_EDMA_FIFO2(1U)

#define S_PERR_EDMA_FIFO1    7
#define V_PERR_EDMA_FIFO1(x) ((x) << S_PERR_EDMA_FIFO1)
#define F_PERR_EDMA_FIFO1    V_PERR_EDMA_FIFO1(1U)

#define S_PERR_EDMA_FIFO0    6
#define V_PERR_EDMA_FIFO0(x) ((x) << S_PERR_EDMA_FIFO0)
#define F_PERR_EDMA_FIFO0    V_PERR_EDMA_FIFO0(1U)

#define S_PERR_PD_FIFO3    5
#define V_PERR_PD_FIFO3(x) ((x) << S_PERR_PD_FIFO3)
#define F_PERR_PD_FIFO3    V_PERR_PD_FIFO3(1U)

#define S_PERR_PD_FIFO2    4
#define V_PERR_PD_FIFO2(x) ((x) << S_PERR_PD_FIFO2)
#define F_PERR_PD_FIFO2    V_PERR_PD_FIFO2(1U)

#define S_PERR_PD_FIFO1    3
#define V_PERR_PD_FIFO1(x) ((x) << S_PERR_PD_FIFO1)
#define F_PERR_PD_FIFO1    V_PERR_PD_FIFO1(1U)

#define S_PERR_PD_FIFO0    2
#define V_PERR_PD_FIFO0(x) ((x) << S_PERR_PD_FIFO0)
#define F_PERR_PD_FIFO0    V_PERR_PD_FIFO0(1U)

#define S_PERR_ING_CTXT_MIFRSP    1
#define V_PERR_ING_CTXT_MIFRSP(x) ((x) << S_PERR_ING_CTXT_MIFRSP)
#define F_PERR_ING_CTXT_MIFRSP    V_PERR_ING_CTXT_MIFRSP(1U)

#define S_PERR_EGR_CTXT_MIFRSP    0
#define V_PERR_EGR_CTXT_MIFRSP(x) ((x) << S_PERR_EGR_CTXT_MIFRSP)
#define F_PERR_EGR_CTXT_MIFRSP    V_PERR_EGR_CTXT_MIFRSP(1U)

#define S_PERR_PC_CHPI_RSP2    31
#define V_PERR_PC_CHPI_RSP2(x) ((x) << S_PERR_PC_CHPI_RSP2)
#define F_PERR_PC_CHPI_RSP2    V_PERR_PC_CHPI_RSP2(1U)

#define A_SGE_INT_ENABLE1 0x1028
#define A_SGE_PERR_ENABLE1 0x102c
#define A_SGE_INT_CAUSE2 0x1030

#define S_PERR_HINT_DELAY_FIFO1    30
#define V_PERR_HINT_DELAY_FIFO1(x) ((x) << S_PERR_HINT_DELAY_FIFO1)
#define F_PERR_HINT_DELAY_FIFO1    V_PERR_HINT_DELAY_FIFO1(1U)

#define S_PERR_HINT_DELAY_FIFO0    29
#define V_PERR_HINT_DELAY_FIFO0(x) ((x) << S_PERR_HINT_DELAY_FIFO0)
#define F_PERR_HINT_DELAY_FIFO0    V_PERR_HINT_DELAY_FIFO0(1U)

#define S_PERR_IMSG_PD_FIFO    28
#define V_PERR_IMSG_PD_FIFO(x) ((x) << S_PERR_IMSG_PD_FIFO)
#define F_PERR_IMSG_PD_FIFO    V_PERR_IMSG_PD_FIFO(1U)

#define S_PERR_ULPTX_FIFO1    27
#define V_PERR_ULPTX_FIFO1(x) ((x) << S_PERR_ULPTX_FIFO1)
#define F_PERR_ULPTX_FIFO1    V_PERR_ULPTX_FIFO1(1U)

#define S_PERR_ULPTX_FIFO0    26
#define V_PERR_ULPTX_FIFO0(x) ((x) << S_PERR_ULPTX_FIFO0)
#define F_PERR_ULPTX_FIFO0    V_PERR_ULPTX_FIFO0(1U)

#define S_PERR_IDMA2IMSG_FIFO1    25
#define V_PERR_IDMA2IMSG_FIFO1(x) ((x) << S_PERR_IDMA2IMSG_FIFO1)
#define F_PERR_IDMA2IMSG_FIFO1    V_PERR_IDMA2IMSG_FIFO1(1U)

#define S_PERR_IDMA2IMSG_FIFO0    24
#define V_PERR_IDMA2IMSG_FIFO0(x) ((x) << S_PERR_IDMA2IMSG_FIFO0)
#define F_PERR_IDMA2IMSG_FIFO0    V_PERR_IDMA2IMSG_FIFO0(1U)

#define S_PERR_HEADERSPLIT_FIFO1    23
#define V_PERR_HEADERSPLIT_FIFO1(x) ((x) << S_PERR_HEADERSPLIT_FIFO1)
#define F_PERR_HEADERSPLIT_FIFO1    V_PERR_HEADERSPLIT_FIFO1(1U)

#define S_PERR_HEADERSPLIT_FIFO0    22
#define V_PERR_HEADERSPLIT_FIFO0(x) ((x) << S_PERR_HEADERSPLIT_FIFO0)
#define F_PERR_HEADERSPLIT_FIFO0    V_PERR_HEADERSPLIT_FIFO0(1U)

#define S_PERR_ESWITCH_FIFO3    21
#define V_PERR_ESWITCH_FIFO3(x) ((x) << S_PERR_ESWITCH_FIFO3)
#define F_PERR_ESWITCH_FIFO3    V_PERR_ESWITCH_FIFO3(1U)

#define S_PERR_ESWITCH_FIFO2    20
#define V_PERR_ESWITCH_FIFO2(x) ((x) << S_PERR_ESWITCH_FIFO2)
#define F_PERR_ESWITCH_FIFO2    V_PERR_ESWITCH_FIFO2(1U)

#define S_PERR_ESWITCH_FIFO1    19
#define V_PERR_ESWITCH_FIFO1(x) ((x) << S_PERR_ESWITCH_FIFO1)
#define F_PERR_ESWITCH_FIFO1    V_PERR_ESWITCH_FIFO1(1U)

#define S_PERR_ESWITCH_FIFO0    18
#define V_PERR_ESWITCH_FIFO0(x) ((x) << S_PERR_ESWITCH_FIFO0)
#define F_PERR_ESWITCH_FIFO0    V_PERR_ESWITCH_FIFO0(1U)

#define S_PERR_PC_DBP1    17
#define V_PERR_PC_DBP1(x) ((x) << S_PERR_PC_DBP1)
#define F_PERR_PC_DBP1    V_PERR_PC_DBP1(1U)

#define S_PERR_PC_DBP0    16
#define V_PERR_PC_DBP0(x) ((x) << S_PERR_PC_DBP0)
#define F_PERR_PC_DBP0    V_PERR_PC_DBP0(1U)

#define S_PERR_IMSG_OB_FIFO    15
#define V_PERR_IMSG_OB_FIFO(x) ((x) << S_PERR_IMSG_OB_FIFO)
#define F_PERR_IMSG_OB_FIFO    V_PERR_IMSG_OB_FIFO(1U)

#define S_PERR_CONM_SRAM    14
#define V_PERR_CONM_SRAM(x) ((x) << S_PERR_CONM_SRAM)
#define F_PERR_CONM_SRAM    V_PERR_CONM_SRAM(1U)

#define S_PERR_PC_MC_RSP    13
#define V_PERR_PC_MC_RSP(x) ((x) << S_PERR_PC_MC_RSP)
#define F_PERR_PC_MC_RSP    V_PERR_PC_MC_RSP(1U)

#define S_PERR_ISW_IDMA0_FIFO    12
#define V_PERR_ISW_IDMA0_FIFO(x) ((x) << S_PERR_ISW_IDMA0_FIFO)
#define F_PERR_ISW_IDMA0_FIFO    V_PERR_ISW_IDMA0_FIFO(1U)

#define S_PERR_ISW_IDMA1_FIFO    11
#define V_PERR_ISW_IDMA1_FIFO(x) ((x) << S_PERR_ISW_IDMA1_FIFO)
#define F_PERR_ISW_IDMA1_FIFO    V_PERR_ISW_IDMA1_FIFO(1U)

#define S_PERR_ISW_DBP_FIFO    10
#define V_PERR_ISW_DBP_FIFO(x) ((x) << S_PERR_ISW_DBP_FIFO)
#define F_PERR_ISW_DBP_FIFO    V_PERR_ISW_DBP_FIFO(1U)

#define S_PERR_ISW_GTS_FIFO    9
#define V_PERR_ISW_GTS_FIFO(x) ((x) << S_PERR_ISW_GTS_FIFO)
#define F_PERR_ISW_GTS_FIFO    V_PERR_ISW_GTS_FIFO(1U)

#define S_PERR_ITP_EVR    8
#define V_PERR_ITP_EVR(x) ((x) << S_PERR_ITP_EVR)
#define F_PERR_ITP_EVR    V_PERR_ITP_EVR(1U)

#define S_PERR_FLM_CNTXMEM    7
#define V_PERR_FLM_CNTXMEM(x) ((x) << S_PERR_FLM_CNTXMEM)
#define F_PERR_FLM_CNTXMEM    V_PERR_FLM_CNTXMEM(1U)

#define S_PERR_FLM_L1CACHE    6
#define V_PERR_FLM_L1CACHE(x) ((x) << S_PERR_FLM_L1CACHE)
#define F_PERR_FLM_L1CACHE    V_PERR_FLM_L1CACHE(1U)

#define S_PERR_DBP_HINT_FIFO    5
#define V_PERR_DBP_HINT_FIFO(x) ((x) << S_PERR_DBP_HINT_FIFO)
#define F_PERR_DBP_HINT_FIFO    V_PERR_DBP_HINT_FIFO(1U)

#define S_PERR_DBP_HP_FIFO    4
#define V_PERR_DBP_HP_FIFO(x) ((x) << S_PERR_DBP_HP_FIFO)
#define F_PERR_DBP_HP_FIFO    V_PERR_DBP_HP_FIFO(1U)

#define S_PERR_DBP_LP_FIFO    3
#define V_PERR_DBP_LP_FIFO(x) ((x) << S_PERR_DBP_LP_FIFO)
#define F_PERR_DBP_LP_FIFO    V_PERR_DBP_LP_FIFO(1U)

#define S_PERR_ING_CTXT_CACHE    2
#define V_PERR_ING_CTXT_CACHE(x) ((x) << S_PERR_ING_CTXT_CACHE)
#define F_PERR_ING_CTXT_CACHE    V_PERR_ING_CTXT_CACHE(1U)

#define S_PERR_EGR_CTXT_CACHE    1
#define V_PERR_EGR_CTXT_CACHE(x) ((x) << S_PERR_EGR_CTXT_CACHE)
#define F_PERR_EGR_CTXT_CACHE    V_PERR_EGR_CTXT_CACHE(1U)

#define S_PERR_BASE_SIZE    0
#define V_PERR_BASE_SIZE(x) ((x) << S_PERR_BASE_SIZE)
#define F_PERR_BASE_SIZE    V_PERR_BASE_SIZE(1U)

#define S_PERR_DBP_HINT_FL_FIFO    24
#define V_PERR_DBP_HINT_FL_FIFO(x) ((x) << S_PERR_DBP_HINT_FL_FIFO)
#define F_PERR_DBP_HINT_FL_FIFO    V_PERR_DBP_HINT_FL_FIFO(1U)

#define S_PERR_EGR_DBP_TX_COAL    23
#define V_PERR_EGR_DBP_TX_COAL(x) ((x) << S_PERR_EGR_DBP_TX_COAL)
#define F_PERR_EGR_DBP_TX_COAL    V_PERR_EGR_DBP_TX_COAL(1U)

#define S_PERR_DBP_FL_FIFO    22
#define V_PERR_DBP_FL_FIFO(x) ((x) << S_PERR_DBP_FL_FIFO)
#define F_PERR_DBP_FL_FIFO    V_PERR_DBP_FL_FIFO(1U)

#define S_PERR_PC_DBP2    15
#define V_PERR_PC_DBP2(x) ((x) << S_PERR_PC_DBP2)
#define F_PERR_PC_DBP2    V_PERR_PC_DBP2(1U)

#define A_SGE_INT_ENABLE2 0x1034
#define A_SGE_PERR_ENABLE2 0x1038
#define A_SGE_INT_CAUSE3 0x103c

#define S_ERR_FLM_DBP    31
#define V_ERR_FLM_DBP(x) ((x) << S_ERR_FLM_DBP)
#define F_ERR_FLM_DBP    V_ERR_FLM_DBP(1U)

#define S_ERR_FLM_IDMA1    30
#define V_ERR_FLM_IDMA1(x) ((x) << S_ERR_FLM_IDMA1)
#define F_ERR_FLM_IDMA1    V_ERR_FLM_IDMA1(1U)

#define S_ERR_FLM_IDMA0    29
#define V_ERR_FLM_IDMA0(x) ((x) << S_ERR_FLM_IDMA0)
#define F_ERR_FLM_IDMA0    V_ERR_FLM_IDMA0(1U)

#define S_ERR_FLM_HINT    28
#define V_ERR_FLM_HINT(x) ((x) << S_ERR_FLM_HINT)
#define F_ERR_FLM_HINT    V_ERR_FLM_HINT(1U)

#define S_ERR_PCIE_ERROR3    27
#define V_ERR_PCIE_ERROR3(x) ((x) << S_ERR_PCIE_ERROR3)
#define F_ERR_PCIE_ERROR3    V_ERR_PCIE_ERROR3(1U)

#define S_ERR_PCIE_ERROR2    26
#define V_ERR_PCIE_ERROR2(x) ((x) << S_ERR_PCIE_ERROR2)
#define F_ERR_PCIE_ERROR2    V_ERR_PCIE_ERROR2(1U)

#define S_ERR_PCIE_ERROR1    25
#define V_ERR_PCIE_ERROR1(x) ((x) << S_ERR_PCIE_ERROR1)
#define F_ERR_PCIE_ERROR1    V_ERR_PCIE_ERROR1(1U)

#define S_ERR_PCIE_ERROR0    24
#define V_ERR_PCIE_ERROR0(x) ((x) << S_ERR_PCIE_ERROR0)
#define F_ERR_PCIE_ERROR0    V_ERR_PCIE_ERROR0(1U)

#define S_ERR_TIMER_ABOVE_MAX_QID    23
#define V_ERR_TIMER_ABOVE_MAX_QID(x) ((x) << S_ERR_TIMER_ABOVE_MAX_QID)
#define F_ERR_TIMER_ABOVE_MAX_QID    V_ERR_TIMER_ABOVE_MAX_QID(1U)

#define S_ERR_CPL_EXCEED_IQE_SIZE    22
#define V_ERR_CPL_EXCEED_IQE_SIZE(x) ((x) << S_ERR_CPL_EXCEED_IQE_SIZE)
#define F_ERR_CPL_EXCEED_IQE_SIZE    V_ERR_CPL_EXCEED_IQE_SIZE(1U)

#define S_ERR_INVALID_CIDX_INC    21
#define V_ERR_INVALID_CIDX_INC(x) ((x) << S_ERR_INVALID_CIDX_INC)
#define F_ERR_INVALID_CIDX_INC    V_ERR_INVALID_CIDX_INC(1U)

#define S_ERR_ITP_TIME_PAUSED    20
#define V_ERR_ITP_TIME_PAUSED(x) ((x) << S_ERR_ITP_TIME_PAUSED)
#define F_ERR_ITP_TIME_PAUSED    V_ERR_ITP_TIME_PAUSED(1U)

#define S_ERR_CPL_OPCODE_0    19
#define V_ERR_CPL_OPCODE_0(x) ((x) << S_ERR_CPL_OPCODE_0)
#define F_ERR_CPL_OPCODE_0    V_ERR_CPL_OPCODE_0(1U)

#define S_ERR_DROPPED_DB    18
#define V_ERR_DROPPED_DB(x) ((x) << S_ERR_DROPPED_DB)
#define F_ERR_DROPPED_DB    V_ERR_DROPPED_DB(1U)

#define S_ERR_DATA_CPL_ON_HIGH_QID1    17
#define V_ERR_DATA_CPL_ON_HIGH_QID1(x) ((x) << S_ERR_DATA_CPL_ON_HIGH_QID1)
#define F_ERR_DATA_CPL_ON_HIGH_QID1    V_ERR_DATA_CPL_ON_HIGH_QID1(1U)

#define S_ERR_DATA_CPL_ON_HIGH_QID0    16
#define V_ERR_DATA_CPL_ON_HIGH_QID0(x) ((x) << S_ERR_DATA_CPL_ON_HIGH_QID0)
#define F_ERR_DATA_CPL_ON_HIGH_QID0    V_ERR_DATA_CPL_ON_HIGH_QID0(1U)

#define S_ERR_BAD_DB_PIDX3    15
#define V_ERR_BAD_DB_PIDX3(x) ((x) << S_ERR_BAD_DB_PIDX3)
#define F_ERR_BAD_DB_PIDX3    V_ERR_BAD_DB_PIDX3(1U)

#define S_ERR_BAD_DB_PIDX2    14
#define V_ERR_BAD_DB_PIDX2(x) ((x) << S_ERR_BAD_DB_PIDX2)
#define F_ERR_BAD_DB_PIDX2    V_ERR_BAD_DB_PIDX2(1U)

#define S_ERR_BAD_DB_PIDX1    13
#define V_ERR_BAD_DB_PIDX1(x) ((x) << S_ERR_BAD_DB_PIDX1)
#define F_ERR_BAD_DB_PIDX1    V_ERR_BAD_DB_PIDX1(1U)

#define S_ERR_BAD_DB_PIDX0    12
#define V_ERR_BAD_DB_PIDX0(x) ((x) << S_ERR_BAD_DB_PIDX0)
#define F_ERR_BAD_DB_PIDX0    V_ERR_BAD_DB_PIDX0(1U)

#define S_ERR_ING_PCIE_CHAN    11
#define V_ERR_ING_PCIE_CHAN(x) ((x) << S_ERR_ING_PCIE_CHAN)
#define F_ERR_ING_PCIE_CHAN    V_ERR_ING_PCIE_CHAN(1U)

#define S_ERR_ING_CTXT_PRIO    10
#define V_ERR_ING_CTXT_PRIO(x) ((x) << S_ERR_ING_CTXT_PRIO)
#define F_ERR_ING_CTXT_PRIO    V_ERR_ING_CTXT_PRIO(1U)

#define S_ERR_EGR_CTXT_PRIO    9
#define V_ERR_EGR_CTXT_PRIO(x) ((x) << S_ERR_EGR_CTXT_PRIO)
#define F_ERR_EGR_CTXT_PRIO    V_ERR_EGR_CTXT_PRIO(1U)

#define S_DBFIFO_HP_INT    8
#define V_DBFIFO_HP_INT(x) ((x) << S_DBFIFO_HP_INT)
#define F_DBFIFO_HP_INT    V_DBFIFO_HP_INT(1U)

#define S_DBFIFO_LP_INT    7
#define V_DBFIFO_LP_INT(x) ((x) << S_DBFIFO_LP_INT)
#define F_DBFIFO_LP_INT    V_DBFIFO_LP_INT(1U)

#define S_REG_ADDRESS_ERR    6
#define V_REG_ADDRESS_ERR(x) ((x) << S_REG_ADDRESS_ERR)
#define F_REG_ADDRESS_ERR    V_REG_ADDRESS_ERR(1U)

#define S_INGRESS_SIZE_ERR    5
#define V_INGRESS_SIZE_ERR(x) ((x) << S_INGRESS_SIZE_ERR)
#define F_INGRESS_SIZE_ERR    V_INGRESS_SIZE_ERR(1U)

#define S_EGRESS_SIZE_ERR    4
#define V_EGRESS_SIZE_ERR(x) ((x) << S_EGRESS_SIZE_ERR)
#define F_EGRESS_SIZE_ERR    V_EGRESS_SIZE_ERR(1U)

#define S_ERR_INV_CTXT3    3
#define V_ERR_INV_CTXT3(x) ((x) << S_ERR_INV_CTXT3)
#define F_ERR_INV_CTXT3    V_ERR_INV_CTXT3(1U)

#define S_ERR_INV_CTXT2    2
#define V_ERR_INV_CTXT2(x) ((x) << S_ERR_INV_CTXT2)
#define F_ERR_INV_CTXT2    V_ERR_INV_CTXT2(1U)

#define S_ERR_INV_CTXT1    1
#define V_ERR_INV_CTXT1(x) ((x) << S_ERR_INV_CTXT1)
#define F_ERR_INV_CTXT1    V_ERR_INV_CTXT1(1U)

#define S_ERR_INV_CTXT0    0
#define V_ERR_INV_CTXT0(x) ((x) << S_ERR_INV_CTXT0)
#define F_ERR_INV_CTXT0    V_ERR_INV_CTXT0(1U)

#define A_SGE_INT_ENABLE3 0x1040
#define A_SGE_FL_BUFFER_SIZE0 0x1044

#define S_SIZE    4
#define M_SIZE    0xfffffffU
#define V_SIZE(x) ((x) << S_SIZE)
#define G_SIZE(x) (((x) >> S_SIZE) & M_SIZE)

#define A_SGE_FL_BUFFER_SIZE1 0x1048
#define A_SGE_FL_BUFFER_SIZE2 0x104c
#define A_SGE_FL_BUFFER_SIZE3 0x1050
#define A_SGE_FL_BUFFER_SIZE4 0x1054
#define A_SGE_FL_BUFFER_SIZE5 0x1058
#define A_SGE_FL_BUFFER_SIZE6 0x105c
#define A_SGE_FL_BUFFER_SIZE7 0x1060
#define A_SGE_FL_BUFFER_SIZE8 0x1064
#define A_SGE_FL_BUFFER_SIZE9 0x1068
#define A_SGE_FL_BUFFER_SIZE10 0x106c
#define A_SGE_FL_BUFFER_SIZE11 0x1070
#define A_SGE_FL_BUFFER_SIZE12 0x1074
#define A_SGE_FL_BUFFER_SIZE13 0x1078
#define A_SGE_FL_BUFFER_SIZE14 0x107c
#define A_SGE_FL_BUFFER_SIZE15 0x1080
#define A_SGE_DBQ_CTXT_BADDR 0x1084

#define S_BASEADDR    3
#define M_BASEADDR    0x1fffffffU
#define V_BASEADDR(x) ((x) << S_BASEADDR)
#define G_BASEADDR(x) (((x) >> S_BASEADDR) & M_BASEADDR)

#define A_SGE_IMSG_CTXT_BADDR 0x1088
#define A_SGE_FLM_CACHE_BADDR 0x108c
#define A_SGE_FLM_CFG 0x1090

#define S_OPMODE    26
#define M_OPMODE    0x3fU
#define V_OPMODE(x) ((x) << S_OPMODE)
#define G_OPMODE(x) (((x) >> S_OPMODE) & M_OPMODE)

#define S_NOHDR    18
#define V_NOHDR(x) ((x) << S_NOHDR)
#define F_NOHDR    V_NOHDR(1U)

#define S_CACHEPTRCNT    16
#define M_CACHEPTRCNT    0x3U
#define V_CACHEPTRCNT(x) ((x) << S_CACHEPTRCNT)
#define G_CACHEPTRCNT(x) (((x) >> S_CACHEPTRCNT) & M_CACHEPTRCNT)

#define S_EDRAMPTRCNT    14
#define M_EDRAMPTRCNT    0x3U
#define V_EDRAMPTRCNT(x) ((x) << S_EDRAMPTRCNT)
#define G_EDRAMPTRCNT(x) (((x) >> S_EDRAMPTRCNT) & M_EDRAMPTRCNT)

#define S_HDRSTARTFLQ    11
#define M_HDRSTARTFLQ    0x7U
#define V_HDRSTARTFLQ(x) ((x) << S_HDRSTARTFLQ)
#define G_HDRSTARTFLQ(x) (((x) >> S_HDRSTARTFLQ) & M_HDRSTARTFLQ)

#define S_FETCHTHRESH    6
#define M_FETCHTHRESH    0x1fU
#define V_FETCHTHRESH(x) ((x) << S_FETCHTHRESH)
#define G_FETCHTHRESH(x) (((x) >> S_FETCHTHRESH) & M_FETCHTHRESH)

#define S_CREDITCNT    4
#define M_CREDITCNT    0x3U
#define V_CREDITCNT(x) ((x) << S_CREDITCNT)
#define G_CREDITCNT(x) (((x) >> S_CREDITCNT) & M_CREDITCNT)

#define S_NOEDRAM    0
#define V_NOEDRAM(x) ((x) << S_NOEDRAM)
#define F_NOEDRAM    V_NOEDRAM(1U)

#define S_CREDITCNTPACKING    2
#define M_CREDITCNTPACKING    0x3U
#define V_CREDITCNTPACKING(x) ((x) << S_CREDITCNTPACKING)
#define G_CREDITCNTPACKING(x) (((x) >> S_CREDITCNTPACKING) & M_CREDITCNTPACKING)

#define A_SGE_CONM_CTRL 0x1094

#define S_EGRTHRESHOLD    8
#define M_EGRTHRESHOLD    0x3fU
#define V_EGRTHRESHOLD(x) ((x) << S_EGRTHRESHOLD)
#define G_EGRTHRESHOLD(x) (((x) >> S_EGRTHRESHOLD) & M_EGRTHRESHOLD)

#define S_INGTHRESHOLD    2
#define M_INGTHRESHOLD    0x3fU
#define V_INGTHRESHOLD(x) ((x) << S_INGTHRESHOLD)
#define G_INGTHRESHOLD(x) (((x) >> S_INGTHRESHOLD) & M_INGTHRESHOLD)

#define S_MPS_ENABLE    1
#define V_MPS_ENABLE(x) ((x) << S_MPS_ENABLE)
#define F_MPS_ENABLE    V_MPS_ENABLE(1U)

#define S_TP_ENABLE    0
#define V_TP_ENABLE(x) ((x) << S_TP_ENABLE)
#define F_TP_ENABLE    V_TP_ENABLE(1U)

#define S_EGRTHRESHOLDPACKING    14
#define M_EGRTHRESHOLDPACKING    0x3fU
#define V_EGRTHRESHOLDPACKING(x) ((x) << S_EGRTHRESHOLDPACKING)
#define G_EGRTHRESHOLDPACKING(x) (((x) >> S_EGRTHRESHOLDPACKING) & M_EGRTHRESHOLDPACKING)

#define A_SGE_TIMESTAMP_LO 0x1098
#define A_SGE_TIMESTAMP_HI 0x109c

#define S_TSOP    28
#define M_TSOP    0x3U
#define V_TSOP(x) ((x) << S_TSOP)
#define G_TSOP(x) (((x) >> S_TSOP) & M_TSOP)

#define S_TSVAL    0
#define M_TSVAL    0xfffffffU
#define V_TSVAL(x) ((x) << S_TSVAL)
#define G_TSVAL(x) (((x) >> S_TSVAL) & M_TSVAL)

#define A_SGE_INGRESS_RX_THRESHOLD 0x10a0

#define S_THRESHOLD_0    24
#define M_THRESHOLD_0    0x3fU
#define V_THRESHOLD_0(x) ((x) << S_THRESHOLD_0)
#define G_THRESHOLD_0(x) (((x) >> S_THRESHOLD_0) & M_THRESHOLD_0)

#define S_THRESHOLD_1    16
#define M_THRESHOLD_1    0x3fU
#define V_THRESHOLD_1(x) ((x) << S_THRESHOLD_1)
#define G_THRESHOLD_1(x) (((x) >> S_THRESHOLD_1) & M_THRESHOLD_1)

#define S_THRESHOLD_2    8
#define M_THRESHOLD_2    0x3fU
#define V_THRESHOLD_2(x) ((x) << S_THRESHOLD_2)
#define G_THRESHOLD_2(x) (((x) >> S_THRESHOLD_2) & M_THRESHOLD_2)

#define S_THRESHOLD_3    0
#define M_THRESHOLD_3    0x3fU
#define V_THRESHOLD_3(x) ((x) << S_THRESHOLD_3)
#define G_THRESHOLD_3(x) (((x) >> S_THRESHOLD_3) & M_THRESHOLD_3)

#define A_SGE_DBFIFO_STATUS 0x10a4

#define S_HP_INT_THRESH    28
#define M_HP_INT_THRESH    0xfU
#define V_HP_INT_THRESH(x) ((x) << S_HP_INT_THRESH)
#define G_HP_INT_THRESH(x) (((x) >> S_HP_INT_THRESH) & M_HP_INT_THRESH)

#define S_HP_COUNT    16
#define M_HP_COUNT    0x7ffU
#define V_HP_COUNT(x) ((x) << S_HP_COUNT)
#define G_HP_COUNT(x) (((x) >> S_HP_COUNT) & M_HP_COUNT)

#define S_LP_INT_THRESH    12
#define M_LP_INT_THRESH    0xfU
#define V_LP_INT_THRESH(x) ((x) << S_LP_INT_THRESH)
#define G_LP_INT_THRESH(x) (((x) >> S_LP_INT_THRESH) & M_LP_INT_THRESH)

#define S_LP_COUNT    0
#define M_LP_COUNT    0x7ffU
#define V_LP_COUNT(x) ((x) << S_LP_COUNT)
#define G_LP_COUNT(x) (((x) >> S_LP_COUNT) & M_LP_COUNT)

#define S_BAR2VALID    31
#define V_BAR2VALID(x) ((x) << S_BAR2VALID)
#define F_BAR2VALID    V_BAR2VALID(1U)

#define S_BAR2FULL    30
#define V_BAR2FULL(x) ((x) << S_BAR2FULL)
#define F_BAR2FULL    V_BAR2FULL(1U)

#define S_LP_INT_THRESH_T5    18
#define M_LP_INT_THRESH_T5    0xfffU
#define V_LP_INT_THRESH_T5(x) ((x) << S_LP_INT_THRESH_T5)
#define G_LP_INT_THRESH_T5(x) (((x) >> S_LP_INT_THRESH_T5) & M_LP_INT_THRESH_T5)

#define S_LP_COUNT_T5    0
#define M_LP_COUNT_T5    0x3ffffU
#define V_LP_COUNT_T5(x) ((x) << S_LP_COUNT_T5)
#define G_LP_COUNT_T5(x) (((x) >> S_LP_COUNT_T5) & M_LP_COUNT_T5)

#define A_SGE_DOORBELL_CONTROL 0x10a8

#define S_HINTDEPTHCTL    27
#define M_HINTDEPTHCTL    0x1fU
#define V_HINTDEPTHCTL(x) ((x) << S_HINTDEPTHCTL)
#define G_HINTDEPTHCTL(x) (((x) >> S_HINTDEPTHCTL) & M_HINTDEPTHCTL)

#define S_NOCOALESCE    26
#define V_NOCOALESCE(x) ((x) << S_NOCOALESCE)
#define F_NOCOALESCE    V_NOCOALESCE(1U)

#define S_HP_WEIGHT    24
#define M_HP_WEIGHT    0x3U
#define V_HP_WEIGHT(x) ((x) << S_HP_WEIGHT)
#define G_HP_WEIGHT(x) (((x) >> S_HP_WEIGHT) & M_HP_WEIGHT)

#define S_HP_DISABLE    23
#define V_HP_DISABLE(x) ((x) << S_HP_DISABLE)
#define F_HP_DISABLE    V_HP_DISABLE(1U)

#define S_FORCEUSERDBTOLP    22
#define V_FORCEUSERDBTOLP(x) ((x) << S_FORCEUSERDBTOLP)
#define F_FORCEUSERDBTOLP    V_FORCEUSERDBTOLP(1U)

#define S_FORCEVFPF0DBTOLP    21
#define V_FORCEVFPF0DBTOLP(x) ((x) << S_FORCEVFPF0DBTOLP)
#define F_FORCEVFPF0DBTOLP    V_FORCEVFPF0DBTOLP(1U)

#define S_FORCEVFPF1DBTOLP    20
#define V_FORCEVFPF1DBTOLP(x) ((x) << S_FORCEVFPF1DBTOLP)
#define F_FORCEVFPF1DBTOLP    V_FORCEVFPF1DBTOLP(1U)

#define S_FORCEVFPF2DBTOLP    19
#define V_FORCEVFPF2DBTOLP(x) ((x) << S_FORCEVFPF2DBTOLP)
#define F_FORCEVFPF2DBTOLP    V_FORCEVFPF2DBTOLP(1U)

#define S_FORCEVFPF3DBTOLP    18
#define V_FORCEVFPF3DBTOLP(x) ((x) << S_FORCEVFPF3DBTOLP)
#define F_FORCEVFPF3DBTOLP    V_FORCEVFPF3DBTOLP(1U)

#define S_FORCEVFPF4DBTOLP    17
#define V_FORCEVFPF4DBTOLP(x) ((x) << S_FORCEVFPF4DBTOLP)
#define F_FORCEVFPF4DBTOLP    V_FORCEVFPF4DBTOLP(1U)

#define S_FORCEVFPF5DBTOLP    16
#define V_FORCEVFPF5DBTOLP(x) ((x) << S_FORCEVFPF5DBTOLP)
#define F_FORCEVFPF5DBTOLP    V_FORCEVFPF5DBTOLP(1U)

#define S_FORCEVFPF6DBTOLP    15
#define V_FORCEVFPF6DBTOLP(x) ((x) << S_FORCEVFPF6DBTOLP)
#define F_FORCEVFPF6DBTOLP    V_FORCEVFPF6DBTOLP(1U)

#define S_FORCEVFPF7DBTOLP    14
#define V_FORCEVFPF7DBTOLP(x) ((x) << S_FORCEVFPF7DBTOLP)
#define F_FORCEVFPF7DBTOLP    V_FORCEVFPF7DBTOLP(1U)

#define S_ENABLE_DROP    13
#define V_ENABLE_DROP(x) ((x) << S_ENABLE_DROP)
#define F_ENABLE_DROP    V_ENABLE_DROP(1U)

#define S_DROP_TIMEOUT    1
#define M_DROP_TIMEOUT    0xfffU
#define V_DROP_TIMEOUT(x) ((x) << S_DROP_TIMEOUT)
#define G_DROP_TIMEOUT(x) (((x) >> S_DROP_TIMEOUT) & M_DROP_TIMEOUT)

#define S_DROPPED_DB    0
#define V_DROPPED_DB(x) ((x) << S_DROPPED_DB)
#define F_DROPPED_DB    V_DROPPED_DB(1U)

#define A_SGE_DROPPED_DOORBELL 0x10ac
#define A_SGE_DOORBELL_THROTTLE_CONTROL 0x10b0

#define S_THROTTLE_COUNT    1
#define M_THROTTLE_COUNT    0xfffU
#define V_THROTTLE_COUNT(x) ((x) << S_THROTTLE_COUNT)
#define G_THROTTLE_COUNT(x) (((x) >> S_THROTTLE_COUNT) & M_THROTTLE_COUNT)

#define S_THROTTLE_ENABLE    0
#define V_THROTTLE_ENABLE(x) ((x) << S_THROTTLE_ENABLE)
#define F_THROTTLE_ENABLE    V_THROTTLE_ENABLE(1U)

#define S_BAR2THROTTLECOUNT    16
#define M_BAR2THROTTLECOUNT    0xffU
#define V_BAR2THROTTLECOUNT(x) ((x) << S_BAR2THROTTLECOUNT)
#define G_BAR2THROTTLECOUNT(x) (((x) >> S_BAR2THROTTLECOUNT) & M_BAR2THROTTLECOUNT)

#define S_CLRCOALESCEDISABLE    15
#define V_CLRCOALESCEDISABLE(x) ((x) << S_CLRCOALESCEDISABLE)
#define F_CLRCOALESCEDISABLE    V_CLRCOALESCEDISABLE(1U)

#define S_OPENBAR2GATEONCE    14
#define V_OPENBAR2GATEONCE(x) ((x) << S_OPENBAR2GATEONCE)
#define F_OPENBAR2GATEONCE    V_OPENBAR2GATEONCE(1U)

#define S_FORCEOPENBAR2GATE    13
#define V_FORCEOPENBAR2GATE(x) ((x) << S_FORCEOPENBAR2GATE)
#define F_FORCEOPENBAR2GATE    V_FORCEOPENBAR2GATE(1U)

#define A_SGE_ITP_CONTROL 0x10b4

#define S_CRITICAL_TIME    10
#define M_CRITICAL_TIME    0x7fffU
#define V_CRITICAL_TIME(x) ((x) << S_CRITICAL_TIME)
#define G_CRITICAL_TIME(x) (((x) >> S_CRITICAL_TIME) & M_CRITICAL_TIME)

#define S_LL_EMPTY    4
#define M_LL_EMPTY    0x3fU
#define V_LL_EMPTY(x) ((x) << S_LL_EMPTY)
#define G_LL_EMPTY(x) (((x) >> S_LL_EMPTY) & M_LL_EMPTY)

#define S_LL_READ_WAIT_DISABLE    0
#define V_LL_READ_WAIT_DISABLE(x) ((x) << S_LL_READ_WAIT_DISABLE)
#define F_LL_READ_WAIT_DISABLE    V_LL_READ_WAIT_DISABLE(1U)

#define A_SGE_TIMER_VALUE_0_AND_1 0x10b8

#define S_TIMERVALUE0    16
#define M_TIMERVALUE0    0xffffU
#define V_TIMERVALUE0(x) ((x) << S_TIMERVALUE0)
#define G_TIMERVALUE0(x) (((x) >> S_TIMERVALUE0) & M_TIMERVALUE0)

#define S_TIMERVALUE1    0
#define M_TIMERVALUE1    0xffffU
#define V_TIMERVALUE1(x) ((x) << S_TIMERVALUE1)
#define G_TIMERVALUE1(x) (((x) >> S_TIMERVALUE1) & M_TIMERVALUE1)

#define A_SGE_TIMER_VALUE_2_AND_3 0x10bc

#define S_TIMERVALUE2    16
#define M_TIMERVALUE2    0xffffU
#define V_TIMERVALUE2(x) ((x) << S_TIMERVALUE2)
#define G_TIMERVALUE2(x) (((x) >> S_TIMERVALUE2) & M_TIMERVALUE2)

#define S_TIMERVALUE3    0
#define M_TIMERVALUE3    0xffffU
#define V_TIMERVALUE3(x) ((x) << S_TIMERVALUE3)
#define G_TIMERVALUE3(x) (((x) >> S_TIMERVALUE3) & M_TIMERVALUE3)

#define A_SGE_TIMER_VALUE_4_AND_5 0x10c0

#define S_TIMERVALUE4    16
#define M_TIMERVALUE4    0xffffU
#define V_TIMERVALUE4(x) ((x) << S_TIMERVALUE4)
#define G_TIMERVALUE4(x) (((x) >> S_TIMERVALUE4) & M_TIMERVALUE4)

#define S_TIMERVALUE5    0
#define M_TIMERVALUE5    0xffffU
#define V_TIMERVALUE5(x) ((x) << S_TIMERVALUE5)
#define G_TIMERVALUE5(x) (((x) >> S_TIMERVALUE5) & M_TIMERVALUE5)

#define A_SGE_PD_RSP_CREDIT01 0x10c4

#define S_RSPCREDITEN0    31
#define V_RSPCREDITEN0(x) ((x) << S_RSPCREDITEN0)
#define F_RSPCREDITEN0    V_RSPCREDITEN0(1U)

#define S_MAXTAG0    24
#define M_MAXTAG0    0x7fU
#define V_MAXTAG0(x) ((x) << S_MAXTAG0)
#define G_MAXTAG0(x) (((x) >> S_MAXTAG0) & M_MAXTAG0)

#define S_MAXRSPCNT0    16
#define M_MAXRSPCNT0    0xffU
#define V_MAXRSPCNT0(x) ((x) << S_MAXRSPCNT0)
#define G_MAXRSPCNT0(x) (((x) >> S_MAXRSPCNT0) & M_MAXRSPCNT0)

#define S_RSPCREDITEN1    15
#define V_RSPCREDITEN1(x) ((x) << S_RSPCREDITEN1)
#define F_RSPCREDITEN1    V_RSPCREDITEN1(1U)

#define S_MAXTAG1    8
#define M_MAXTAG1    0x7fU
#define V_MAXTAG1(x) ((x) << S_MAXTAG1)
#define G_MAXTAG1(x) (((x) >> S_MAXTAG1) & M_MAXTAG1)

#define S_MAXRSPCNT1    0
#define M_MAXRSPCNT1    0xffU
#define V_MAXRSPCNT1(x) ((x) << S_MAXRSPCNT1)
#define G_MAXRSPCNT1(x) (((x) >> S_MAXRSPCNT1) & M_MAXRSPCNT1)

#define A_SGE_PD_RSP_CREDIT23 0x10c8

#define S_RSPCREDITEN2    31
#define V_RSPCREDITEN2(x) ((x) << S_RSPCREDITEN2)
#define F_RSPCREDITEN2    V_RSPCREDITEN2(1U)

#define S_MAXTAG2    24
#define M_MAXTAG2    0x7fU
#define V_MAXTAG2(x) ((x) << S_MAXTAG2)
#define G_MAXTAG2(x) (((x) >> S_MAXTAG2) & M_MAXTAG2)

#define S_MAXRSPCNT2    16
#define M_MAXRSPCNT2    0xffU
#define V_MAXRSPCNT2(x) ((x) << S_MAXRSPCNT2)
#define G_MAXRSPCNT2(x) (((x) >> S_MAXRSPCNT2) & M_MAXRSPCNT2)

#define S_RSPCREDITEN3    15
#define V_RSPCREDITEN3(x) ((x) << S_RSPCREDITEN3)
#define F_RSPCREDITEN3    V_RSPCREDITEN3(1U)

#define S_MAXTAG3    8
#define M_MAXTAG3    0x7fU
#define V_MAXTAG3(x) ((x) << S_MAXTAG3)
#define G_MAXTAG3(x) (((x) >> S_MAXTAG3) & M_MAXTAG3)

#define S_MAXRSPCNT3    0
#define M_MAXRSPCNT3    0xffU
#define V_MAXRSPCNT3(x) ((x) << S_MAXRSPCNT3)
#define G_MAXRSPCNT3(x) (((x) >> S_MAXRSPCNT3) & M_MAXRSPCNT3)

#define A_SGE_DEBUG_INDEX 0x10cc
#define A_SGE_DEBUG_DATA_HIGH 0x10d0
#define A_SGE_DEBUG_DATA_LOW 0x10d4
#define A_SGE_REVISION 0x10d8
#define A_SGE_INT_CAUSE4 0x10dc

#define S_ERR_BAD_UPFL_INC_CREDIT3    8
#define V_ERR_BAD_UPFL_INC_CREDIT3(x) ((x) << S_ERR_BAD_UPFL_INC_CREDIT3)
#define F_ERR_BAD_UPFL_INC_CREDIT3    V_ERR_BAD_UPFL_INC_CREDIT3(1U)

#define S_ERR_BAD_UPFL_INC_CREDIT2    7
#define V_ERR_BAD_UPFL_INC_CREDIT2(x) ((x) << S_ERR_BAD_UPFL_INC_CREDIT2)
#define F_ERR_BAD_UPFL_INC_CREDIT2    V_ERR_BAD_UPFL_INC_CREDIT2(1U)

#define S_ERR_BAD_UPFL_INC_CREDIT1    6
#define V_ERR_BAD_UPFL_INC_CREDIT1(x) ((x) << S_ERR_BAD_UPFL_INC_CREDIT1)
#define F_ERR_BAD_UPFL_INC_CREDIT1    V_ERR_BAD_UPFL_INC_CREDIT1(1U)

#define S_ERR_BAD_UPFL_INC_CREDIT0    5
#define V_ERR_BAD_UPFL_INC_CREDIT0(x) ((x) << S_ERR_BAD_UPFL_INC_CREDIT0)
#define F_ERR_BAD_UPFL_INC_CREDIT0    V_ERR_BAD_UPFL_INC_CREDIT0(1U)

#define S_ERR_PHYSADDR_LEN0_IDMA1    4
#define V_ERR_PHYSADDR_LEN0_IDMA1(x) ((x) << S_ERR_PHYSADDR_LEN0_IDMA1)
#define F_ERR_PHYSADDR_LEN0_IDMA1    V_ERR_PHYSADDR_LEN0_IDMA1(1U)

#define S_ERR_PHYSADDR_LEN0_IDMA0    3
#define V_ERR_PHYSADDR_LEN0_IDMA0(x) ((x) << S_ERR_PHYSADDR_LEN0_IDMA0)
#define F_ERR_PHYSADDR_LEN0_IDMA0    V_ERR_PHYSADDR_LEN0_IDMA0(1U)

#define S_ERR_FLM_INVALID_PKT_DROP1    2
#define V_ERR_FLM_INVALID_PKT_DROP1(x) ((x) << S_ERR_FLM_INVALID_PKT_DROP1)
#define F_ERR_FLM_INVALID_PKT_DROP1    V_ERR_FLM_INVALID_PKT_DROP1(1U)

#define S_ERR_FLM_INVALID_PKT_DROP0    1
#define V_ERR_FLM_INVALID_PKT_DROP0(x) ((x) << S_ERR_FLM_INVALID_PKT_DROP0)
#define F_ERR_FLM_INVALID_PKT_DROP0    V_ERR_FLM_INVALID_PKT_DROP0(1U)

#define S_ERR_UNEXPECTED_TIMER    0
#define V_ERR_UNEXPECTED_TIMER(x) ((x) << S_ERR_UNEXPECTED_TIMER)
#define F_ERR_UNEXPECTED_TIMER    V_ERR_UNEXPECTED_TIMER(1U)

#define S_BAR2_EGRESS_LEN_OR_ADDR_ERR    29
#define V_BAR2_EGRESS_LEN_OR_ADDR_ERR(x) ((x) << S_BAR2_EGRESS_LEN_OR_ADDR_ERR)
#define F_BAR2_EGRESS_LEN_OR_ADDR_ERR    V_BAR2_EGRESS_LEN_OR_ADDR_ERR(1U)

#define S_ERR_CPL_EXCEED_MAX_IQE_SIZE1    28
#define V_ERR_CPL_EXCEED_MAX_IQE_SIZE1(x) ((x) << S_ERR_CPL_EXCEED_MAX_IQE_SIZE1)
#define F_ERR_CPL_EXCEED_MAX_IQE_SIZE1    V_ERR_CPL_EXCEED_MAX_IQE_SIZE1(1U)

#define S_ERR_CPL_EXCEED_MAX_IQE_SIZE0    27
#define V_ERR_CPL_EXCEED_MAX_IQE_SIZE0(x) ((x) << S_ERR_CPL_EXCEED_MAX_IQE_SIZE0)
#define F_ERR_CPL_EXCEED_MAX_IQE_SIZE0    V_ERR_CPL_EXCEED_MAX_IQE_SIZE0(1U)

#define S_ERR_WR_LEN_TOO_LARGE3    26
#define V_ERR_WR_LEN_TOO_LARGE3(x) ((x) << S_ERR_WR_LEN_TOO_LARGE3)
#define F_ERR_WR_LEN_TOO_LARGE3    V_ERR_WR_LEN_TOO_LARGE3(1U)

#define S_ERR_WR_LEN_TOO_LARGE2    25
#define V_ERR_WR_LEN_TOO_LARGE2(x) ((x) << S_ERR_WR_LEN_TOO_LARGE2)
#define F_ERR_WR_LEN_TOO_LARGE2    V_ERR_WR_LEN_TOO_LARGE2(1U)

#define S_ERR_WR_LEN_TOO_LARGE1    24
#define V_ERR_WR_LEN_TOO_LARGE1(x) ((x) << S_ERR_WR_LEN_TOO_LARGE1)
#define F_ERR_WR_LEN_TOO_LARGE1    V_ERR_WR_LEN_TOO_LARGE1(1U)

#define S_ERR_WR_LEN_TOO_LARGE0    23
#define V_ERR_WR_LEN_TOO_LARGE0(x) ((x) << S_ERR_WR_LEN_TOO_LARGE0)
#define F_ERR_WR_LEN_TOO_LARGE0    V_ERR_WR_LEN_TOO_LARGE0(1U)

#define S_ERR_LARGE_MINFETCH_WITH_TXCOAL3    22
#define V_ERR_LARGE_MINFETCH_WITH_TXCOAL3(x) ((x) << S_ERR_LARGE_MINFETCH_WITH_TXCOAL3)
#define F_ERR_LARGE_MINFETCH_WITH_TXCOAL3    V_ERR_LARGE_MINFETCH_WITH_TXCOAL3(1U)

#define S_ERR_LARGE_MINFETCH_WITH_TXCOAL2    21
#define V_ERR_LARGE_MINFETCH_WITH_TXCOAL2(x) ((x) << S_ERR_LARGE_MINFETCH_WITH_TXCOAL2)
#define F_ERR_LARGE_MINFETCH_WITH_TXCOAL2    V_ERR_LARGE_MINFETCH_WITH_TXCOAL2(1U)

#define S_ERR_LARGE_MINFETCH_WITH_TXCOAL1    20
#define V_ERR_LARGE_MINFETCH_WITH_TXCOAL1(x) ((x) << S_ERR_LARGE_MINFETCH_WITH_TXCOAL1)
#define F_ERR_LARGE_MINFETCH_WITH_TXCOAL1    V_ERR_LARGE_MINFETCH_WITH_TXCOAL1(1U)

#define S_ERR_LARGE_MINFETCH_WITH_TXCOAL0    19
#define V_ERR_LARGE_MINFETCH_WITH_TXCOAL0(x) ((x) << S_ERR_LARGE_MINFETCH_WITH_TXCOAL0)
#define F_ERR_LARGE_MINFETCH_WITH_TXCOAL0    V_ERR_LARGE_MINFETCH_WITH_TXCOAL0(1U)

#define S_COAL_WITH_HP_DISABLE_ERR    18
#define V_COAL_WITH_HP_DISABLE_ERR(x) ((x) << S_COAL_WITH_HP_DISABLE_ERR)
#define F_COAL_WITH_HP_DISABLE_ERR    V_COAL_WITH_HP_DISABLE_ERR(1U)

#define S_BAR2_EGRESS_COAL0_ERR    17
#define V_BAR2_EGRESS_COAL0_ERR(x) ((x) << S_BAR2_EGRESS_COAL0_ERR)
#define F_BAR2_EGRESS_COAL0_ERR    V_BAR2_EGRESS_COAL0_ERR(1U)

#define S_BAR2_EGRESS_SIZE_ERR    16
#define V_BAR2_EGRESS_SIZE_ERR(x) ((x) << S_BAR2_EGRESS_SIZE_ERR)
#define F_BAR2_EGRESS_SIZE_ERR    V_BAR2_EGRESS_SIZE_ERR(1U)

#define S_FLM_PC_RSP_ERR    15
#define V_FLM_PC_RSP_ERR(x) ((x) << S_FLM_PC_RSP_ERR)
#define F_FLM_PC_RSP_ERR    V_FLM_PC_RSP_ERR(1U)

#define S_DBFIFO_HP_INT_LOW    14
#define V_DBFIFO_HP_INT_LOW(x) ((x) << S_DBFIFO_HP_INT_LOW)
#define F_DBFIFO_HP_INT_LOW    V_DBFIFO_HP_INT_LOW(1U)

#define S_DBFIFO_LP_INT_LOW    13
#define V_DBFIFO_LP_INT_LOW(x) ((x) << S_DBFIFO_LP_INT_LOW)
#define F_DBFIFO_LP_INT_LOW    V_DBFIFO_LP_INT_LOW(1U)

#define S_DBFIFO_FL_INT_LOW    12
#define V_DBFIFO_FL_INT_LOW(x) ((x) << S_DBFIFO_FL_INT_LOW)
#define F_DBFIFO_FL_INT_LOW    V_DBFIFO_FL_INT_LOW(1U)

#define S_DBFIFO_FL_INT    11
#define V_DBFIFO_FL_INT(x) ((x) << S_DBFIFO_FL_INT)
#define F_DBFIFO_FL_INT    V_DBFIFO_FL_INT(1U)

#define S_ERR_RX_CPL_PACKET_SIZE1    10
#define V_ERR_RX_CPL_PACKET_SIZE1(x) ((x) << S_ERR_RX_CPL_PACKET_SIZE1)
#define F_ERR_RX_CPL_PACKET_SIZE1    V_ERR_RX_CPL_PACKET_SIZE1(1U)

#define S_ERR_RX_CPL_PACKET_SIZE0    9
#define V_ERR_RX_CPL_PACKET_SIZE0(x) ((x) << S_ERR_RX_CPL_PACKET_SIZE0)
#define F_ERR_RX_CPL_PACKET_SIZE0    V_ERR_RX_CPL_PACKET_SIZE0(1U)

#define A_SGE_INT_ENABLE4 0x10e0
#define A_SGE_STAT_TOTAL 0x10e4
#define A_SGE_STAT_MATCH 0x10e8
#define A_SGE_STAT_CFG 0x10ec

#define S_ITPOPMODE    8
#define V_ITPOPMODE(x) ((x) << S_ITPOPMODE)
#define F_ITPOPMODE    V_ITPOPMODE(1U)

#define S_EGRCTXTOPMODE    6
#define M_EGRCTXTOPMODE    0x3U
#define V_EGRCTXTOPMODE(x) ((x) << S_EGRCTXTOPMODE)
#define G_EGRCTXTOPMODE(x) (((x) >> S_EGRCTXTOPMODE) & M_EGRCTXTOPMODE)

#define S_INGCTXTOPMODE    4
#define M_INGCTXTOPMODE    0x3U
#define V_INGCTXTOPMODE(x) ((x) << S_INGCTXTOPMODE)
#define G_INGCTXTOPMODE(x) (((x) >> S_INGCTXTOPMODE) & M_INGCTXTOPMODE)

#define S_STATMODE    2
#define M_STATMODE    0x3U
#define V_STATMODE(x) ((x) << S_STATMODE)
#define G_STATMODE(x) (((x) >> S_STATMODE) & M_STATMODE)

#define S_STATSOURCE    0
#define M_STATSOURCE    0x3U
#define V_STATSOURCE(x) ((x) << S_STATSOURCE)
#define G_STATSOURCE(x) (((x) >> S_STATSOURCE) & M_STATSOURCE)

#define S_STATSOURCE_T5    9
#define M_STATSOURCE_T5    0xfU
#define V_STATSOURCE_T5(x) ((x) << S_STATSOURCE_T5)
#define G_STATSOURCE_T5(x) (((x) >> S_STATSOURCE_T5) & M_STATSOURCE_T5)

#define A_SGE_HINT_CFG 0x10f0

#define S_HINTSALLOWEDNOHDR    6
#define M_HINTSALLOWEDNOHDR    0x3fU
#define V_HINTSALLOWEDNOHDR(x) ((x) << S_HINTSALLOWEDNOHDR)
#define G_HINTSALLOWEDNOHDR(x) (((x) >> S_HINTSALLOWEDNOHDR) & M_HINTSALLOWEDNOHDR)

#define S_HINTSALLOWEDHDR    0
#define M_HINTSALLOWEDHDR    0x3fU
#define V_HINTSALLOWEDHDR(x) ((x) << S_HINTSALLOWEDHDR)
#define G_HINTSALLOWEDHDR(x) (((x) >> S_HINTSALLOWEDHDR) & M_HINTSALLOWEDHDR)

#define S_UPCUTOFFTHRESHLP    12
#define M_UPCUTOFFTHRESHLP    0x7ffU
#define V_UPCUTOFFTHRESHLP(x) ((x) << S_UPCUTOFFTHRESHLP)
#define G_UPCUTOFFTHRESHLP(x) (((x) >> S_UPCUTOFFTHRESHLP) & M_UPCUTOFFTHRESHLP)

#define A_SGE_INGRESS_QUEUES_PER_PAGE_PF 0x10f4
#define A_SGE_INGRESS_QUEUES_PER_PAGE_VF 0x10f8
#define A_SGE_PD_WRR_CONFIG 0x10fc

#define S_EDMA_WEIGHT    0
#define M_EDMA_WEIGHT    0x3fU
#define V_EDMA_WEIGHT(x) ((x) << S_EDMA_WEIGHT)
#define G_EDMA_WEIGHT(x) (((x) >> S_EDMA_WEIGHT) & M_EDMA_WEIGHT)

#define A_SGE_ERROR_STATS 0x1100

#define S_UNCAPTURED_ERROR    18
#define V_UNCAPTURED_ERROR(x) ((x) << S_UNCAPTURED_ERROR)
#define F_UNCAPTURED_ERROR    V_UNCAPTURED_ERROR(1U)

#define S_ERROR_QID_VALID    17
#define V_ERROR_QID_VALID(x) ((x) << S_ERROR_QID_VALID)
#define F_ERROR_QID_VALID    V_ERROR_QID_VALID(1U)

#define S_ERROR_QID    0
#define M_ERROR_QID    0x1ffffU
#define V_ERROR_QID(x) ((x) << S_ERROR_QID)
#define G_ERROR_QID(x) (((x) >> S_ERROR_QID) & M_ERROR_QID)

#define S_CAUSE_REGISTER    24
#define M_CAUSE_REGISTER    0x7U
#define V_CAUSE_REGISTER(x) ((x) << S_CAUSE_REGISTER)
#define G_CAUSE_REGISTER(x) (((x) >> S_CAUSE_REGISTER) & M_CAUSE_REGISTER)

#define S_CAUSE_BIT    19
#define M_CAUSE_BIT    0x1fU
#define V_CAUSE_BIT(x) ((x) << S_CAUSE_BIT)
#define G_CAUSE_BIT(x) (((x) >> S_CAUSE_BIT) & M_CAUSE_BIT)

#define A_SGE_SHARED_TAG_CHAN_CFG 0x1104

#define S_MINTAG3    24
#define M_MINTAG3    0xffU
#define V_MINTAG3(x) ((x) << S_MINTAG3)
#define G_MINTAG3(x) (((x) >> S_MINTAG3) & M_MINTAG3)

#define S_MINTAG2    16
#define M_MINTAG2    0xffU
#define V_MINTAG2(x) ((x) << S_MINTAG2)
#define G_MINTAG2(x) (((x) >> S_MINTAG2) & M_MINTAG2)

#define S_MINTAG1    8
#define M_MINTAG1    0xffU
#define V_MINTAG1(x) ((x) << S_MINTAG1)
#define G_MINTAG1(x) (((x) >> S_MINTAG1) & M_MINTAG1)

#define S_MINTAG0    0
#define M_MINTAG0    0xffU
#define V_MINTAG0(x) ((x) << S_MINTAG0)
#define G_MINTAG0(x) (((x) >> S_MINTAG0) & M_MINTAG0)

#define A_SGE_SHARED_TAG_POOL_CFG 0x1108

#define S_TAGPOOLTOTAL    0
#define M_TAGPOOLTOTAL    0xffU
#define V_TAGPOOLTOTAL(x) ((x) << S_TAGPOOLTOTAL)
#define G_TAGPOOLTOTAL(x) (((x) >> S_TAGPOOLTOTAL) & M_TAGPOOLTOTAL)

#define A_SGE_INT_CAUSE5 0x110c

#define S_ERR_T_RXCRC    31
#define V_ERR_T_RXCRC(x) ((x) << S_ERR_T_RXCRC)
#define F_ERR_T_RXCRC    V_ERR_T_RXCRC(1U)

#define S_PERR_MC_RSPDATA    30
#define V_PERR_MC_RSPDATA(x) ((x) << S_PERR_MC_RSPDATA)
#define F_PERR_MC_RSPDATA    V_PERR_MC_RSPDATA(1U)

#define S_PERR_PC_RSPDATA    29
#define V_PERR_PC_RSPDATA(x) ((x) << S_PERR_PC_RSPDATA)
#define F_PERR_PC_RSPDATA    V_PERR_PC_RSPDATA(1U)

#define S_PERR_PD_RDRSPDATA    28
#define V_PERR_PD_RDRSPDATA(x) ((x) << S_PERR_PD_RDRSPDATA)
#define F_PERR_PD_RDRSPDATA    V_PERR_PD_RDRSPDATA(1U)

#define S_PERR_U_RXDATA    27
#define V_PERR_U_RXDATA(x) ((x) << S_PERR_U_RXDATA)
#define F_PERR_U_RXDATA    V_PERR_U_RXDATA(1U)

#define S_PERR_UD_RXDATA    26
#define V_PERR_UD_RXDATA(x) ((x) << S_PERR_UD_RXDATA)
#define F_PERR_UD_RXDATA    V_PERR_UD_RXDATA(1U)

#define S_PERR_UP_DATA    25
#define V_PERR_UP_DATA(x) ((x) << S_PERR_UP_DATA)
#define F_PERR_UP_DATA    V_PERR_UP_DATA(1U)

#define S_PERR_CIM2SGE_RXDATA    24
#define V_PERR_CIM2SGE_RXDATA(x) ((x) << S_PERR_CIM2SGE_RXDATA)
#define F_PERR_CIM2SGE_RXDATA    V_PERR_CIM2SGE_RXDATA(1U)

#define S_PERR_HINT_DELAY_FIFO1_T5    23
#define V_PERR_HINT_DELAY_FIFO1_T5(x) ((x) << S_PERR_HINT_DELAY_FIFO1_T5)
#define F_PERR_HINT_DELAY_FIFO1_T5    V_PERR_HINT_DELAY_FIFO1_T5(1U)

#define S_PERR_HINT_DELAY_FIFO0_T5    22
#define V_PERR_HINT_DELAY_FIFO0_T5(x) ((x) << S_PERR_HINT_DELAY_FIFO0_T5)
#define F_PERR_HINT_DELAY_FIFO0_T5    V_PERR_HINT_DELAY_FIFO0_T5(1U)

#define S_PERR_IMSG_PD_FIFO_T5    21
#define V_PERR_IMSG_PD_FIFO_T5(x) ((x) << S_PERR_IMSG_PD_FIFO_T5)
#define F_PERR_IMSG_PD_FIFO_T5    V_PERR_IMSG_PD_FIFO_T5(1U)

#define S_PERR_ULPTX_FIFO1_T5    20
#define V_PERR_ULPTX_FIFO1_T5(x) ((x) << S_PERR_ULPTX_FIFO1_T5)
#define F_PERR_ULPTX_FIFO1_T5    V_PERR_ULPTX_FIFO1_T5(1U)

#define S_PERR_ULPTX_FIFO0_T5    19
#define V_PERR_ULPTX_FIFO0_T5(x) ((x) << S_PERR_ULPTX_FIFO0_T5)
#define F_PERR_ULPTX_FIFO0_T5    V_PERR_ULPTX_FIFO0_T5(1U)

#define S_PERR_IDMA2IMSG_FIFO1_T5    18
#define V_PERR_IDMA2IMSG_FIFO1_T5(x) ((x) << S_PERR_IDMA2IMSG_FIFO1_T5)
#define F_PERR_IDMA2IMSG_FIFO1_T5    V_PERR_IDMA2IMSG_FIFO1_T5(1U)

#define S_PERR_IDMA2IMSG_FIFO0_T5    17
#define V_PERR_IDMA2IMSG_FIFO0_T5(x) ((x) << S_PERR_IDMA2IMSG_FIFO0_T5)
#define F_PERR_IDMA2IMSG_FIFO0_T5    V_PERR_IDMA2IMSG_FIFO0_T5(1U)

#define S_PERR_POINTER_DATA_FIFO0    16
#define V_PERR_POINTER_DATA_FIFO0(x) ((x) << S_PERR_POINTER_DATA_FIFO0)
#define F_PERR_POINTER_DATA_FIFO0    V_PERR_POINTER_DATA_FIFO0(1U)

#define S_PERR_POINTER_DATA_FIFO1    15
#define V_PERR_POINTER_DATA_FIFO1(x) ((x) << S_PERR_POINTER_DATA_FIFO1)
#define F_PERR_POINTER_DATA_FIFO1    V_PERR_POINTER_DATA_FIFO1(1U)

#define S_PERR_POINTER_HDR_FIFO0    14
#define V_PERR_POINTER_HDR_FIFO0(x) ((x) << S_PERR_POINTER_HDR_FIFO0)
#define F_PERR_POINTER_HDR_FIFO0    V_PERR_POINTER_HDR_FIFO0(1U)

#define S_PERR_POINTER_HDR_FIFO1    13
#define V_PERR_POINTER_HDR_FIFO1(x) ((x) << S_PERR_POINTER_HDR_FIFO1)
#define F_PERR_POINTER_HDR_FIFO1    V_PERR_POINTER_HDR_FIFO1(1U)

#define S_PERR_PAYLOAD_FIFO0    12
#define V_PERR_PAYLOAD_FIFO0(x) ((x) << S_PERR_PAYLOAD_FIFO0)
#define F_PERR_PAYLOAD_FIFO0    V_PERR_PAYLOAD_FIFO0(1U)

#define S_PERR_PAYLOAD_FIFO1    11
#define V_PERR_PAYLOAD_FIFO1(x) ((x) << S_PERR_PAYLOAD_FIFO1)
#define F_PERR_PAYLOAD_FIFO1    V_PERR_PAYLOAD_FIFO1(1U)

#define S_PERR_EDMA_INPUT_FIFO3    10
#define V_PERR_EDMA_INPUT_FIFO3(x) ((x) << S_PERR_EDMA_INPUT_FIFO3)
#define F_PERR_EDMA_INPUT_FIFO3    V_PERR_EDMA_INPUT_FIFO3(1U)

#define S_PERR_EDMA_INPUT_FIFO2    9
#define V_PERR_EDMA_INPUT_FIFO2(x) ((x) << S_PERR_EDMA_INPUT_FIFO2)
#define F_PERR_EDMA_INPUT_FIFO2    V_PERR_EDMA_INPUT_FIFO2(1U)

#define S_PERR_EDMA_INPUT_FIFO1    8
#define V_PERR_EDMA_INPUT_FIFO1(x) ((x) << S_PERR_EDMA_INPUT_FIFO1)
#define F_PERR_EDMA_INPUT_FIFO1    V_PERR_EDMA_INPUT_FIFO1(1U)

#define S_PERR_EDMA_INPUT_FIFO0    7
#define V_PERR_EDMA_INPUT_FIFO0(x) ((x) << S_PERR_EDMA_INPUT_FIFO0)
#define F_PERR_EDMA_INPUT_FIFO0    V_PERR_EDMA_INPUT_FIFO0(1U)

#define S_PERR_MGT_BAR2_FIFO    6
#define V_PERR_MGT_BAR2_FIFO(x) ((x) << S_PERR_MGT_BAR2_FIFO)
#define F_PERR_MGT_BAR2_FIFO    V_PERR_MGT_BAR2_FIFO(1U)

#define S_PERR_HEADERSPLIT_FIFO1_T5    5
#define V_PERR_HEADERSPLIT_FIFO1_T5(x) ((x) << S_PERR_HEADERSPLIT_FIFO1_T5)
#define F_PERR_HEADERSPLIT_FIFO1_T5    V_PERR_HEADERSPLIT_FIFO1_T5(1U)

#define S_PERR_HEADERSPLIT_FIFO0_T5    4
#define V_PERR_HEADERSPLIT_FIFO0_T5(x) ((x) << S_PERR_HEADERSPLIT_FIFO0_T5)
#define F_PERR_HEADERSPLIT_FIFO0_T5    V_PERR_HEADERSPLIT_FIFO0_T5(1U)

#define S_PERR_CIM_FIFO1    3
#define V_PERR_CIM_FIFO1(x) ((x) << S_PERR_CIM_FIFO1)
#define F_PERR_CIM_FIFO1    V_PERR_CIM_FIFO1(1U)

#define S_PERR_CIM_FIFO0    2
#define V_PERR_CIM_FIFO0(x) ((x) << S_PERR_CIM_FIFO0)
#define F_PERR_CIM_FIFO0    V_PERR_CIM_FIFO0(1U)

#define S_PERR_IDMA_SWITCH_OUTPUT_FIFO1    1
#define V_PERR_IDMA_SWITCH_OUTPUT_FIFO1(x) ((x) << S_PERR_IDMA_SWITCH_OUTPUT_FIFO1)
#define F_PERR_IDMA_SWITCH_OUTPUT_FIFO1    V_PERR_IDMA_SWITCH_OUTPUT_FIFO1(1U)

#define S_PERR_IDMA_SWITCH_OUTPUT_FIFO0    0
#define V_PERR_IDMA_SWITCH_OUTPUT_FIFO0(x) ((x) << S_PERR_IDMA_SWITCH_OUTPUT_FIFO0)
#define F_PERR_IDMA_SWITCH_OUTPUT_FIFO0    V_PERR_IDMA_SWITCH_OUTPUT_FIFO0(1U)

#define A_SGE_INT_ENABLE5 0x1110
#define A_SGE_PERR_ENABLE5 0x1114
#define A_SGE_DBFIFO_STATUS2 0x1118

#define S_FL_INT_THRESH    24
#define M_FL_INT_THRESH    0xfU
#define V_FL_INT_THRESH(x) ((x) << S_FL_INT_THRESH)
#define G_FL_INT_THRESH(x) (((x) >> S_FL_INT_THRESH) & M_FL_INT_THRESH)

#define S_FL_COUNT    14
#define M_FL_COUNT    0x3ffU
#define V_FL_COUNT(x) ((x) << S_FL_COUNT)
#define G_FL_COUNT(x) (((x) >> S_FL_COUNT) & M_FL_COUNT)

#define S_HP_INT_THRESH_T5    10
#define M_HP_INT_THRESH_T5    0xfU
#define V_HP_INT_THRESH_T5(x) ((x) << S_HP_INT_THRESH_T5)
#define G_HP_INT_THRESH_T5(x) (((x) >> S_HP_INT_THRESH_T5) & M_HP_INT_THRESH_T5)

#define S_HP_COUNT_T5    0
#define M_HP_COUNT_T5    0x3ffU
#define V_HP_COUNT_T5(x) ((x) << S_HP_COUNT_T5)
#define G_HP_COUNT_T5(x) (((x) >> S_HP_COUNT_T5) & M_HP_COUNT_T5)

#define A_SGE_FETCH_BURST_MAX_0_AND_1 0x111c

#define S_FETCHBURSTMAX0    16
#define M_FETCHBURSTMAX0    0x3ffU
#define V_FETCHBURSTMAX0(x) ((x) << S_FETCHBURSTMAX0)
#define G_FETCHBURSTMAX0(x) (((x) >> S_FETCHBURSTMAX0) & M_FETCHBURSTMAX0)

#define S_FETCHBURSTMAX1    0
#define M_FETCHBURSTMAX1    0x3ffU
#define V_FETCHBURSTMAX1(x) ((x) << S_FETCHBURSTMAX1)
#define G_FETCHBURSTMAX1(x) (((x) >> S_FETCHBURSTMAX1) & M_FETCHBURSTMAX1)

#define A_SGE_FETCH_BURST_MAX_2_AND_3 0x1120

#define S_FETCHBURSTMAX2    16
#define M_FETCHBURSTMAX2    0x3ffU
#define V_FETCHBURSTMAX2(x) ((x) << S_FETCHBURSTMAX2)
#define G_FETCHBURSTMAX2(x) (((x) >> S_FETCHBURSTMAX2) & M_FETCHBURSTMAX2)

#define S_FETCHBURSTMAX3    0
#define M_FETCHBURSTMAX3    0x3ffU
#define V_FETCHBURSTMAX3(x) ((x) << S_FETCHBURSTMAX3)
#define G_FETCHBURSTMAX3(x) (((x) >> S_FETCHBURSTMAX3) & M_FETCHBURSTMAX3)

#define A_SGE_CONTROL2 0x1124

#define S_UPFLCUTOFFDIS    21
#define V_UPFLCUTOFFDIS(x) ((x) << S_UPFLCUTOFFDIS)
#define F_UPFLCUTOFFDIS    V_UPFLCUTOFFDIS(1U)

#define S_RXCPLSIZEAUTOCORRECT    20
#define V_RXCPLSIZEAUTOCORRECT(x) ((x) << S_RXCPLSIZEAUTOCORRECT)
#define F_RXCPLSIZEAUTOCORRECT    V_RXCPLSIZEAUTOCORRECT(1U)

#define S_IDMAARBROUNDROBIN    19
#define V_IDMAARBROUNDROBIN(x) ((x) << S_IDMAARBROUNDROBIN)
#define F_IDMAARBROUNDROBIN    V_IDMAARBROUNDROBIN(1U)

#define S_INGPACKBOUNDARY    16
#define M_INGPACKBOUNDARY    0x7U
#define V_INGPACKBOUNDARY(x) ((x) << S_INGPACKBOUNDARY)
#define G_INGPACKBOUNDARY(x) (((x) >> S_INGPACKBOUNDARY) & M_INGPACKBOUNDARY)

#define S_CGEN_EGRESS_CONTEXT    15
#define V_CGEN_EGRESS_CONTEXT(x) ((x) << S_CGEN_EGRESS_CONTEXT)
#define F_CGEN_EGRESS_CONTEXT    V_CGEN_EGRESS_CONTEXT(1U)

#define S_CGEN_INGRESS_CONTEXT    14
#define V_CGEN_INGRESS_CONTEXT(x) ((x) << S_CGEN_INGRESS_CONTEXT)
#define F_CGEN_INGRESS_CONTEXT    V_CGEN_INGRESS_CONTEXT(1U)

#define S_CGEN_IDMA    13
#define V_CGEN_IDMA(x) ((x) << S_CGEN_IDMA)
#define F_CGEN_IDMA    V_CGEN_IDMA(1U)

#define S_CGEN_DBP    12
#define V_CGEN_DBP(x) ((x) << S_CGEN_DBP)
#define F_CGEN_DBP    V_CGEN_DBP(1U)

#define S_CGEN_EDMA    11
#define V_CGEN_EDMA(x) ((x) << S_CGEN_EDMA)
#define F_CGEN_EDMA    V_CGEN_EDMA(1U)

#define S_VFIFO_ENABLE    10
#define V_VFIFO_ENABLE(x) ((x) << S_VFIFO_ENABLE)
#define F_VFIFO_ENABLE    V_VFIFO_ENABLE(1U)

#define S_FLM_RESCHEDULE_MODE    9
#define V_FLM_RESCHEDULE_MODE(x) ((x) << S_FLM_RESCHEDULE_MODE)
#define F_FLM_RESCHEDULE_MODE    V_FLM_RESCHEDULE_MODE(1U)

#define S_HINTDEPTHCTLFL    4
#define M_HINTDEPTHCTLFL    0x1fU
#define V_HINTDEPTHCTLFL(x) ((x) << S_HINTDEPTHCTLFL)
#define G_HINTDEPTHCTLFL(x) (((x) >> S_HINTDEPTHCTLFL) & M_HINTDEPTHCTLFL)

#define S_FORCE_ORDERING    3
#define V_FORCE_ORDERING(x) ((x) << S_FORCE_ORDERING)
#define F_FORCE_ORDERING    V_FORCE_ORDERING(1U)

#define S_TX_COALESCE_SIZE    2
#define V_TX_COALESCE_SIZE(x) ((x) << S_TX_COALESCE_SIZE)
#define F_TX_COALESCE_SIZE    V_TX_COALESCE_SIZE(1U)

#define S_COAL_STRICT_CIM_PRI    1
#define V_COAL_STRICT_CIM_PRI(x) ((x) << S_COAL_STRICT_CIM_PRI)
#define F_COAL_STRICT_CIM_PRI    V_COAL_STRICT_CIM_PRI(1U)

#define S_TX_COALESCE_PRI    0
#define V_TX_COALESCE_PRI(x) ((x) << S_TX_COALESCE_PRI)
#define F_TX_COALESCE_PRI    V_TX_COALESCE_PRI(1U)

#define A_SGE_DEEP_SLEEP 0x1128

#define S_IDMA1_SLEEP_STATUS    11
#define V_IDMA1_SLEEP_STATUS(x) ((x) << S_IDMA1_SLEEP_STATUS)
#define F_IDMA1_SLEEP_STATUS    V_IDMA1_SLEEP_STATUS(1U)

#define S_IDMA0_SLEEP_STATUS    10
#define V_IDMA0_SLEEP_STATUS(x) ((x) << S_IDMA0_SLEEP_STATUS)
#define F_IDMA0_SLEEP_STATUS    V_IDMA0_SLEEP_STATUS(1U)

#define S_IDMA1_SLEEP_REQ    9
#define V_IDMA1_SLEEP_REQ(x) ((x) << S_IDMA1_SLEEP_REQ)
#define F_IDMA1_SLEEP_REQ    V_IDMA1_SLEEP_REQ(1U)

#define S_IDMA0_SLEEP_REQ    8
#define V_IDMA0_SLEEP_REQ(x) ((x) << S_IDMA0_SLEEP_REQ)
#define F_IDMA0_SLEEP_REQ    V_IDMA0_SLEEP_REQ(1U)

#define S_EDMA3_SLEEP_STATUS    7
#define V_EDMA3_SLEEP_STATUS(x) ((x) << S_EDMA3_SLEEP_STATUS)
#define F_EDMA3_SLEEP_STATUS    V_EDMA3_SLEEP_STATUS(1U)

#define S_EDMA2_SLEEP_STATUS    6
#define V_EDMA2_SLEEP_STATUS(x) ((x) << S_EDMA2_SLEEP_STATUS)
#define F_EDMA2_SLEEP_STATUS    V_EDMA2_SLEEP_STATUS(1U)

#define S_EDMA1_SLEEP_STATUS    5
#define V_EDMA1_SLEEP_STATUS(x) ((x) << S_EDMA1_SLEEP_STATUS)
#define F_EDMA1_SLEEP_STATUS    V_EDMA1_SLEEP_STATUS(1U)

#define S_EDMA0_SLEEP_STATUS    4
#define V_EDMA0_SLEEP_STATUS(x) ((x) << S_EDMA0_SLEEP_STATUS)
#define F_EDMA0_SLEEP_STATUS    V_EDMA0_SLEEP_STATUS(1U)

#define S_EDMA3_SLEEP_REQ    3
#define V_EDMA3_SLEEP_REQ(x) ((x) << S_EDMA3_SLEEP_REQ)
#define F_EDMA3_SLEEP_REQ    V_EDMA3_SLEEP_REQ(1U)

#define S_EDMA2_SLEEP_REQ    2
#define V_EDMA2_SLEEP_REQ(x) ((x) << S_EDMA2_SLEEP_REQ)
#define F_EDMA2_SLEEP_REQ    V_EDMA2_SLEEP_REQ(1U)

#define S_EDMA1_SLEEP_REQ    1
#define V_EDMA1_SLEEP_REQ(x) ((x) << S_EDMA1_SLEEP_REQ)
#define F_EDMA1_SLEEP_REQ    V_EDMA1_SLEEP_REQ(1U)

#define S_EDMA0_SLEEP_REQ    0
#define V_EDMA0_SLEEP_REQ(x) ((x) << S_EDMA0_SLEEP_REQ)
#define F_EDMA0_SLEEP_REQ    V_EDMA0_SLEEP_REQ(1U)

#define A_SGE_DOORBELL_THROTTLE_THRESHOLD 0x112c

#define S_THROTTLE_THRESHOLD_FL    16
#define M_THROTTLE_THRESHOLD_FL    0xfU
#define V_THROTTLE_THRESHOLD_FL(x) ((x) << S_THROTTLE_THRESHOLD_FL)
#define G_THROTTLE_THRESHOLD_FL(x) (((x) >> S_THROTTLE_THRESHOLD_FL) & M_THROTTLE_THRESHOLD_FL)

#define S_THROTTLE_THRESHOLD_HP    12
#define M_THROTTLE_THRESHOLD_HP    0xfU
#define V_THROTTLE_THRESHOLD_HP(x) ((x) << S_THROTTLE_THRESHOLD_HP)
#define G_THROTTLE_THRESHOLD_HP(x) (((x) >> S_THROTTLE_THRESHOLD_HP) & M_THROTTLE_THRESHOLD_HP)

#define S_THROTTLE_THRESHOLD_LP    0
#define M_THROTTLE_THRESHOLD_LP    0xfffU
#define V_THROTTLE_THRESHOLD_LP(x) ((x) << S_THROTTLE_THRESHOLD_LP)
#define G_THROTTLE_THRESHOLD_LP(x) (((x) >> S_THROTTLE_THRESHOLD_LP) & M_THROTTLE_THRESHOLD_LP)

#define A_SGE_DBP_FETCH_THRESHOLD 0x1130

#define S_DBP_FETCH_THRESHOLD_FL    21
#define M_DBP_FETCH_THRESHOLD_FL    0xfU
#define V_DBP_FETCH_THRESHOLD_FL(x) ((x) << S_DBP_FETCH_THRESHOLD_FL)
#define G_DBP_FETCH_THRESHOLD_FL(x) (((x) >> S_DBP_FETCH_THRESHOLD_FL) & M_DBP_FETCH_THRESHOLD_FL)

#define S_DBP_FETCH_THRESHOLD_HP    17
#define M_DBP_FETCH_THRESHOLD_HP    0xfU
#define V_DBP_FETCH_THRESHOLD_HP(x) ((x) << S_DBP_FETCH_THRESHOLD_HP)
#define G_DBP_FETCH_THRESHOLD_HP(x) (((x) >> S_DBP_FETCH_THRESHOLD_HP) & M_DBP_FETCH_THRESHOLD_HP)

#define S_DBP_FETCH_THRESHOLD_LP    5
#define M_DBP_FETCH_THRESHOLD_LP    0xfffU
#define V_DBP_FETCH_THRESHOLD_LP(x) ((x) << S_DBP_FETCH_THRESHOLD_LP)
#define G_DBP_FETCH_THRESHOLD_LP(x) (((x) >> S_DBP_FETCH_THRESHOLD_LP) & M_DBP_FETCH_THRESHOLD_LP)

#define S_DBP_FETCH_THRESHOLD_MODE    4
#define V_DBP_FETCH_THRESHOLD_MODE(x) ((x) << S_DBP_FETCH_THRESHOLD_MODE)
#define F_DBP_FETCH_THRESHOLD_MODE    V_DBP_FETCH_THRESHOLD_MODE(1U)

#define S_DBP_FETCH_THRESHOLD_EN3    3
#define V_DBP_FETCH_THRESHOLD_EN3(x) ((x) << S_DBP_FETCH_THRESHOLD_EN3)
#define F_DBP_FETCH_THRESHOLD_EN3    V_DBP_FETCH_THRESHOLD_EN3(1U)

#define S_DBP_FETCH_THRESHOLD_EN2    2
#define V_DBP_FETCH_THRESHOLD_EN2(x) ((x) << S_DBP_FETCH_THRESHOLD_EN2)
#define F_DBP_FETCH_THRESHOLD_EN2    V_DBP_FETCH_THRESHOLD_EN2(1U)

#define S_DBP_FETCH_THRESHOLD_EN1    1
#define V_DBP_FETCH_THRESHOLD_EN1(x) ((x) << S_DBP_FETCH_THRESHOLD_EN1)
#define F_DBP_FETCH_THRESHOLD_EN1    V_DBP_FETCH_THRESHOLD_EN1(1U)

#define S_DBP_FETCH_THRESHOLD_EN0    0
#define V_DBP_FETCH_THRESHOLD_EN0(x) ((x) << S_DBP_FETCH_THRESHOLD_EN0)
#define F_DBP_FETCH_THRESHOLD_EN0    V_DBP_FETCH_THRESHOLD_EN0(1U)

#define A_SGE_DBP_FETCH_THRESHOLD_QUEUE 0x1134

#define S_DBP_FETCH_THRESHOLD_IQ1    16
#define M_DBP_FETCH_THRESHOLD_IQ1    0xffffU
#define V_DBP_FETCH_THRESHOLD_IQ1(x) ((x) << S_DBP_FETCH_THRESHOLD_IQ1)
#define G_DBP_FETCH_THRESHOLD_IQ1(x) (((x) >> S_DBP_FETCH_THRESHOLD_IQ1) & M_DBP_FETCH_THRESHOLD_IQ1)

#define S_DBP_FETCH_THRESHOLD_IQ0    0
#define M_DBP_FETCH_THRESHOLD_IQ0    0xffffU
#define V_DBP_FETCH_THRESHOLD_IQ0(x) ((x) << S_DBP_FETCH_THRESHOLD_IQ0)
#define G_DBP_FETCH_THRESHOLD_IQ0(x) (((x) >> S_DBP_FETCH_THRESHOLD_IQ0) & M_DBP_FETCH_THRESHOLD_IQ0)

#define A_SGE_DBVFIFO_BADDR 0x1138
#define A_SGE_DBVFIFO_SIZE 0x113c

#define S_DBVFIFO_SIZE    6
#define M_DBVFIFO_SIZE    0xfffU
#define V_DBVFIFO_SIZE(x) ((x) << S_DBVFIFO_SIZE)
#define G_DBVFIFO_SIZE(x) (((x) >> S_DBVFIFO_SIZE) & M_DBVFIFO_SIZE)

#define A_SGE_DBFIFO_STATUS3 0x1140

#define S_LP_PTRS_EQUAL    21
#define V_LP_PTRS_EQUAL(x) ((x) << S_LP_PTRS_EQUAL)
#define F_LP_PTRS_EQUAL    V_LP_PTRS_EQUAL(1U)

#define S_LP_SNAPHOT    20
#define V_LP_SNAPHOT(x) ((x) << S_LP_SNAPHOT)
#define F_LP_SNAPHOT    V_LP_SNAPHOT(1U)

#define S_FL_INT_THRESH_LOW    16
#define M_FL_INT_THRESH_LOW    0xfU
#define V_FL_INT_THRESH_LOW(x) ((x) << S_FL_INT_THRESH_LOW)
#define G_FL_INT_THRESH_LOW(x) (((x) >> S_FL_INT_THRESH_LOW) & M_FL_INT_THRESH_LOW)

#define S_HP_INT_THRESH_LOW    12
#define M_HP_INT_THRESH_LOW    0xfU
#define V_HP_INT_THRESH_LOW(x) ((x) << S_HP_INT_THRESH_LOW)
#define G_HP_INT_THRESH_LOW(x) (((x) >> S_HP_INT_THRESH_LOW) & M_HP_INT_THRESH_LOW)

#define S_LP_INT_THRESH_LOW    0
#define M_LP_INT_THRESH_LOW    0xfffU
#define V_LP_INT_THRESH_LOW(x) ((x) << S_LP_INT_THRESH_LOW)
#define G_LP_INT_THRESH_LOW(x) (((x) >> S_LP_INT_THRESH_LOW) & M_LP_INT_THRESH_LOW)

#define A_SGE_CHANGESET 0x1144
#define A_SGE_PC_RSP_ERROR 0x1148
#define A_SGE_PC0_REQ_BIST_CMD 0x1180
#define A_SGE_PC0_REQ_BIST_ERROR_CNT 0x1184
#define A_SGE_PC1_REQ_BIST_CMD 0x1190
#define A_SGE_PC1_REQ_BIST_ERROR_CNT 0x1194
#define A_SGE_PC0_RSP_BIST_CMD 0x11a0
#define A_SGE_PC0_RSP_BIST_ERROR_CNT 0x11a4
#define A_SGE_PC1_RSP_BIST_CMD 0x11b0
#define A_SGE_PC1_RSP_BIST_ERROR_CNT 0x11b4
#define A_SGE_CTXT_CMD 0x11fc

#define S_BUSY    31
#define V_BUSY(x) ((x) << S_BUSY)
#define F_BUSY    V_BUSY(1U)

#define S_CTXTOP    28
#define M_CTXTOP    0x3U
#define V_CTXTOP(x) ((x) << S_CTXTOP)
#define G_CTXTOP(x) (((x) >> S_CTXTOP) & M_CTXTOP)

#define S_CTXTTYPE    24
#define M_CTXTTYPE    0x3U
#define V_CTXTTYPE(x) ((x) << S_CTXTTYPE)
#define G_CTXTTYPE(x) (((x) >> S_CTXTTYPE) & M_CTXTTYPE)

#define S_CTXTQID    0
#define M_CTXTQID    0x1ffffU
#define V_CTXTQID(x) ((x) << S_CTXTQID)
#define G_CTXTQID(x) (((x) >> S_CTXTQID) & M_CTXTQID)

#define A_SGE_CTXT_DATA0 0x1200
#define A_SGE_CTXT_DATA1 0x1204
#define A_SGE_CTXT_DATA2 0x1208
#define A_SGE_CTXT_DATA3 0x120c
#define A_SGE_CTXT_DATA4 0x1210
#define A_SGE_CTXT_DATA5 0x1214
#define A_SGE_CTXT_DATA6 0x1218
#define A_SGE_CTXT_DATA7 0x121c
#define A_SGE_CTXT_MASK0 0x1220
#define A_SGE_CTXT_MASK1 0x1224
#define A_SGE_CTXT_MASK2 0x1228
#define A_SGE_CTXT_MASK3 0x122c
#define A_SGE_CTXT_MASK4 0x1230
#define A_SGE_CTXT_MASK5 0x1234
#define A_SGE_CTXT_MASK6 0x1238
#define A_SGE_CTXT_MASK7 0x123c
#define A_SGE_DEBUG_DATA_HIGH_INDEX_0 0x1280

#define S_CIM_WM    24
#define M_CIM_WM    0x3U
#define V_CIM_WM(x) ((x) << S_CIM_WM)
#define G_CIM_WM(x) (((x) >> S_CIM_WM) & M_CIM_WM)

#define S_DEBUG_UP_SOP_CNT    20
#define M_DEBUG_UP_SOP_CNT    0xfU
#define V_DEBUG_UP_SOP_CNT(x) ((x) << S_DEBUG_UP_SOP_CNT)
#define G_DEBUG_UP_SOP_CNT(x) (((x) >> S_DEBUG_UP_SOP_CNT) & M_DEBUG_UP_SOP_CNT)

#define S_DEBUG_UP_EOP_CNT    16
#define M_DEBUG_UP_EOP_CNT    0xfU
#define V_DEBUG_UP_EOP_CNT(x) ((x) << S_DEBUG_UP_EOP_CNT)
#define G_DEBUG_UP_EOP_CNT(x) (((x) >> S_DEBUG_UP_EOP_CNT) & M_DEBUG_UP_EOP_CNT)

#define S_DEBUG_CIM_SOP1_CNT    12
#define M_DEBUG_CIM_SOP1_CNT    0xfU
#define V_DEBUG_CIM_SOP1_CNT(x) ((x) << S_DEBUG_CIM_SOP1_CNT)
#define G_DEBUG_CIM_SOP1_CNT(x) (((x) >> S_DEBUG_CIM_SOP1_CNT) & M_DEBUG_CIM_SOP1_CNT)

#define S_DEBUG_CIM_EOP1_CNT    8
#define M_DEBUG_CIM_EOP1_CNT    0xfU
#define V_DEBUG_CIM_EOP1_CNT(x) ((x) << S_DEBUG_CIM_EOP1_CNT)
#define G_DEBUG_CIM_EOP1_CNT(x) (((x) >> S_DEBUG_CIM_EOP1_CNT) & M_DEBUG_CIM_EOP1_CNT)

#define S_DEBUG_CIM_SOP0_CNT    4
#define M_DEBUG_CIM_SOP0_CNT    0xfU
#define V_DEBUG_CIM_SOP0_CNT(x) ((x) << S_DEBUG_CIM_SOP0_CNT)
#define G_DEBUG_CIM_SOP0_CNT(x) (((x) >> S_DEBUG_CIM_SOP0_CNT) & M_DEBUG_CIM_SOP0_CNT)

#define S_DEBUG_CIM_EOP0_CNT    0
#define M_DEBUG_CIM_EOP0_CNT    0xfU
#define V_DEBUG_CIM_EOP0_CNT(x) ((x) << S_DEBUG_CIM_EOP0_CNT)
#define G_DEBUG_CIM_EOP0_CNT(x) (((x) >> S_DEBUG_CIM_EOP0_CNT) & M_DEBUG_CIM_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_1 0x1284

#define S_DEBUG_T_RX_SOP1_CNT    28
#define M_DEBUG_T_RX_SOP1_CNT    0xfU
#define V_DEBUG_T_RX_SOP1_CNT(x) ((x) << S_DEBUG_T_RX_SOP1_CNT)
#define G_DEBUG_T_RX_SOP1_CNT(x) (((x) >> S_DEBUG_T_RX_SOP1_CNT) & M_DEBUG_T_RX_SOP1_CNT)

#define S_DEBUG_T_RX_EOP1_CNT    24
#define M_DEBUG_T_RX_EOP1_CNT    0xfU
#define V_DEBUG_T_RX_EOP1_CNT(x) ((x) << S_DEBUG_T_RX_EOP1_CNT)
#define G_DEBUG_T_RX_EOP1_CNT(x) (((x) >> S_DEBUG_T_RX_EOP1_CNT) & M_DEBUG_T_RX_EOP1_CNT)

#define S_DEBUG_T_RX_SOP0_CNT    20
#define M_DEBUG_T_RX_SOP0_CNT    0xfU
#define V_DEBUG_T_RX_SOP0_CNT(x) ((x) << S_DEBUG_T_RX_SOP0_CNT)
#define G_DEBUG_T_RX_SOP0_CNT(x) (((x) >> S_DEBUG_T_RX_SOP0_CNT) & M_DEBUG_T_RX_SOP0_CNT)

#define S_DEBUG_T_RX_EOP0_CNT    16
#define M_DEBUG_T_RX_EOP0_CNT    0xfU
#define V_DEBUG_T_RX_EOP0_CNT(x) ((x) << S_DEBUG_T_RX_EOP0_CNT)
#define G_DEBUG_T_RX_EOP0_CNT(x) (((x) >> S_DEBUG_T_RX_EOP0_CNT) & M_DEBUG_T_RX_EOP0_CNT)

#define S_DEBUG_U_RX_SOP1_CNT    12
#define M_DEBUG_U_RX_SOP1_CNT    0xfU
#define V_DEBUG_U_RX_SOP1_CNT(x) ((x) << S_DEBUG_U_RX_SOP1_CNT)
#define G_DEBUG_U_RX_SOP1_CNT(x) (((x) >> S_DEBUG_U_RX_SOP1_CNT) & M_DEBUG_U_RX_SOP1_CNT)

#define S_DEBUG_U_RX_EOP1_CNT    8
#define M_DEBUG_U_RX_EOP1_CNT    0xfU
#define V_DEBUG_U_RX_EOP1_CNT(x) ((x) << S_DEBUG_U_RX_EOP1_CNT)
#define G_DEBUG_U_RX_EOP1_CNT(x) (((x) >> S_DEBUG_U_RX_EOP1_CNT) & M_DEBUG_U_RX_EOP1_CNT)

#define S_DEBUG_U_RX_SOP0_CNT    4
#define M_DEBUG_U_RX_SOP0_CNT    0xfU
#define V_DEBUG_U_RX_SOP0_CNT(x) ((x) << S_DEBUG_U_RX_SOP0_CNT)
#define G_DEBUG_U_RX_SOP0_CNT(x) (((x) >> S_DEBUG_U_RX_SOP0_CNT) & M_DEBUG_U_RX_SOP0_CNT)

#define S_DEBUG_U_RX_EOP0_CNT    0
#define M_DEBUG_U_RX_EOP0_CNT    0xfU
#define V_DEBUG_U_RX_EOP0_CNT(x) ((x) << S_DEBUG_U_RX_EOP0_CNT)
#define G_DEBUG_U_RX_EOP0_CNT(x) (((x) >> S_DEBUG_U_RX_EOP0_CNT) & M_DEBUG_U_RX_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_2 0x1288

#define S_DEBUG_UD_RX_SOP3_CNT    28
#define M_DEBUG_UD_RX_SOP3_CNT    0xfU
#define V_DEBUG_UD_RX_SOP3_CNT(x) ((x) << S_DEBUG_UD_RX_SOP3_CNT)
#define G_DEBUG_UD_RX_SOP3_CNT(x) (((x) >> S_DEBUG_UD_RX_SOP3_CNT) & M_DEBUG_UD_RX_SOP3_CNT)

#define S_DEBUG_UD_RX_EOP3_CNT    24
#define M_DEBUG_UD_RX_EOP3_CNT    0xfU
#define V_DEBUG_UD_RX_EOP3_CNT(x) ((x) << S_DEBUG_UD_RX_EOP3_CNT)
#define G_DEBUG_UD_RX_EOP3_CNT(x) (((x) >> S_DEBUG_UD_RX_EOP3_CNT) & M_DEBUG_UD_RX_EOP3_CNT)

#define S_DEBUG_UD_RX_SOP2_CNT    20
#define M_DEBUG_UD_RX_SOP2_CNT    0xfU
#define V_DEBUG_UD_RX_SOP2_CNT(x) ((x) << S_DEBUG_UD_RX_SOP2_CNT)
#define G_DEBUG_UD_RX_SOP2_CNT(x) (((x) >> S_DEBUG_UD_RX_SOP2_CNT) & M_DEBUG_UD_RX_SOP2_CNT)

#define S_DEBUG_UD_RX_EOP2_CNT    16
#define M_DEBUG_UD_RX_EOP2_CNT    0xfU
#define V_DEBUG_UD_RX_EOP2_CNT(x) ((x) << S_DEBUG_UD_RX_EOP2_CNT)
#define G_DEBUG_UD_RX_EOP2_CNT(x) (((x) >> S_DEBUG_UD_RX_EOP2_CNT) & M_DEBUG_UD_RX_EOP2_CNT)

#define S_DEBUG_UD_RX_SOP1_CNT    12
#define M_DEBUG_UD_RX_SOP1_CNT    0xfU
#define V_DEBUG_UD_RX_SOP1_CNT(x) ((x) << S_DEBUG_UD_RX_SOP1_CNT)
#define G_DEBUG_UD_RX_SOP1_CNT(x) (((x) >> S_DEBUG_UD_RX_SOP1_CNT) & M_DEBUG_UD_RX_SOP1_CNT)

#define S_DEBUG_UD_RX_EOP1_CNT    8
#define M_DEBUG_UD_RX_EOP1_CNT    0xfU
#define V_DEBUG_UD_RX_EOP1_CNT(x) ((x) << S_DEBUG_UD_RX_EOP1_CNT)
#define G_DEBUG_UD_RX_EOP1_CNT(x) (((x) >> S_DEBUG_UD_RX_EOP1_CNT) & M_DEBUG_UD_RX_EOP1_CNT)

#define S_DEBUG_UD_RX_SOP0_CNT    4
#define M_DEBUG_UD_RX_SOP0_CNT    0xfU
#define V_DEBUG_UD_RX_SOP0_CNT(x) ((x) << S_DEBUG_UD_RX_SOP0_CNT)
#define G_DEBUG_UD_RX_SOP0_CNT(x) (((x) >> S_DEBUG_UD_RX_SOP0_CNT) & M_DEBUG_UD_RX_SOP0_CNT)

#define S_DEBUG_UD_RX_EOP0_CNT    0
#define M_DEBUG_UD_RX_EOP0_CNT    0xfU
#define V_DEBUG_UD_RX_EOP0_CNT(x) ((x) << S_DEBUG_UD_RX_EOP0_CNT)
#define G_DEBUG_UD_RX_EOP0_CNT(x) (((x) >> S_DEBUG_UD_RX_EOP0_CNT) & M_DEBUG_UD_RX_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_3 0x128c

#define S_DEBUG_U_TX_SOP3_CNT    28
#define M_DEBUG_U_TX_SOP3_CNT    0xfU
#define V_DEBUG_U_TX_SOP3_CNT(x) ((x) << S_DEBUG_U_TX_SOP3_CNT)
#define G_DEBUG_U_TX_SOP3_CNT(x) (((x) >> S_DEBUG_U_TX_SOP3_CNT) & M_DEBUG_U_TX_SOP3_CNT)

#define S_DEBUG_U_TX_EOP3_CNT    24
#define M_DEBUG_U_TX_EOP3_CNT    0xfU
#define V_DEBUG_U_TX_EOP3_CNT(x) ((x) << S_DEBUG_U_TX_EOP3_CNT)
#define G_DEBUG_U_TX_EOP3_CNT(x) (((x) >> S_DEBUG_U_TX_EOP3_CNT) & M_DEBUG_U_TX_EOP3_CNT)

#define S_DEBUG_U_TX_SOP2_CNT    20
#define M_DEBUG_U_TX_SOP2_CNT    0xfU
#define V_DEBUG_U_TX_SOP2_CNT(x) ((x) << S_DEBUG_U_TX_SOP2_CNT)
#define G_DEBUG_U_TX_SOP2_CNT(x) (((x) >> S_DEBUG_U_TX_SOP2_CNT) & M_DEBUG_U_TX_SOP2_CNT)

#define S_DEBUG_U_TX_EOP2_CNT    16
#define M_DEBUG_U_TX_EOP2_CNT    0xfU
#define V_DEBUG_U_TX_EOP2_CNT(x) ((x) << S_DEBUG_U_TX_EOP2_CNT)
#define G_DEBUG_U_TX_EOP2_CNT(x) (((x) >> S_DEBUG_U_TX_EOP2_CNT) & M_DEBUG_U_TX_EOP2_CNT)

#define S_DEBUG_U_TX_SOP1_CNT    12
#define M_DEBUG_U_TX_SOP1_CNT    0xfU
#define V_DEBUG_U_TX_SOP1_CNT(x) ((x) << S_DEBUG_U_TX_SOP1_CNT)
#define G_DEBUG_U_TX_SOP1_CNT(x) (((x) >> S_DEBUG_U_TX_SOP1_CNT) & M_DEBUG_U_TX_SOP1_CNT)

#define S_DEBUG_U_TX_EOP1_CNT    8
#define M_DEBUG_U_TX_EOP1_CNT    0xfU
#define V_DEBUG_U_TX_EOP1_CNT(x) ((x) << S_DEBUG_U_TX_EOP1_CNT)
#define G_DEBUG_U_TX_EOP1_CNT(x) (((x) >> S_DEBUG_U_TX_EOP1_CNT) & M_DEBUG_U_TX_EOP1_CNT)

#define S_DEBUG_U_TX_SOP0_CNT    4
#define M_DEBUG_U_TX_SOP0_CNT    0xfU
#define V_DEBUG_U_TX_SOP0_CNT(x) ((x) << S_DEBUG_U_TX_SOP0_CNT)
#define G_DEBUG_U_TX_SOP0_CNT(x) (((x) >> S_DEBUG_U_TX_SOP0_CNT) & M_DEBUG_U_TX_SOP0_CNT)

#define S_DEBUG_U_TX_EOP0_CNT    0
#define M_DEBUG_U_TX_EOP0_CNT    0xfU
#define V_DEBUG_U_TX_EOP0_CNT(x) ((x) << S_DEBUG_U_TX_EOP0_CNT)
#define G_DEBUG_U_TX_EOP0_CNT(x) (((x) >> S_DEBUG_U_TX_EOP0_CNT) & M_DEBUG_U_TX_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_4 0x1290

#define S_DEBUG_PC_RSP_SOP1_CNT    28
#define M_DEBUG_PC_RSP_SOP1_CNT    0xfU
#define V_DEBUG_PC_RSP_SOP1_CNT(x) ((x) << S_DEBUG_PC_RSP_SOP1_CNT)
#define G_DEBUG_PC_RSP_SOP1_CNT(x) (((x) >> S_DEBUG_PC_RSP_SOP1_CNT) & M_DEBUG_PC_RSP_SOP1_CNT)

#define S_DEBUG_PC_RSP_EOP1_CNT    24
#define M_DEBUG_PC_RSP_EOP1_CNT    0xfU
#define V_DEBUG_PC_RSP_EOP1_CNT(x) ((x) << S_DEBUG_PC_RSP_EOP1_CNT)
#define G_DEBUG_PC_RSP_EOP1_CNT(x) (((x) >> S_DEBUG_PC_RSP_EOP1_CNT) & M_DEBUG_PC_RSP_EOP1_CNT)

#define S_DEBUG_PC_RSP_SOP0_CNT    20
#define M_DEBUG_PC_RSP_SOP0_CNT    0xfU
#define V_DEBUG_PC_RSP_SOP0_CNT(x) ((x) << S_DEBUG_PC_RSP_SOP0_CNT)
#define G_DEBUG_PC_RSP_SOP0_CNT(x) (((x) >> S_DEBUG_PC_RSP_SOP0_CNT) & M_DEBUG_PC_RSP_SOP0_CNT)

#define S_DEBUG_PC_RSP_EOP0_CNT    16
#define M_DEBUG_PC_RSP_EOP0_CNT    0xfU
#define V_DEBUG_PC_RSP_EOP0_CNT(x) ((x) << S_DEBUG_PC_RSP_EOP0_CNT)
#define G_DEBUG_PC_RSP_EOP0_CNT(x) (((x) >> S_DEBUG_PC_RSP_EOP0_CNT) & M_DEBUG_PC_RSP_EOP0_CNT)

#define S_DEBUG_PC_REQ_SOP1_CNT    12
#define M_DEBUG_PC_REQ_SOP1_CNT    0xfU
#define V_DEBUG_PC_REQ_SOP1_CNT(x) ((x) << S_DEBUG_PC_REQ_SOP1_CNT)
#define G_DEBUG_PC_REQ_SOP1_CNT(x) (((x) >> S_DEBUG_PC_REQ_SOP1_CNT) & M_DEBUG_PC_REQ_SOP1_CNT)

#define S_DEBUG_PC_REQ_EOP1_CNT    8
#define M_DEBUG_PC_REQ_EOP1_CNT    0xfU
#define V_DEBUG_PC_REQ_EOP1_CNT(x) ((x) << S_DEBUG_PC_REQ_EOP1_CNT)
#define G_DEBUG_PC_REQ_EOP1_CNT(x) (((x) >> S_DEBUG_PC_REQ_EOP1_CNT) & M_DEBUG_PC_REQ_EOP1_CNT)

#define S_DEBUG_PC_REQ_SOP0_CNT    4
#define M_DEBUG_PC_REQ_SOP0_CNT    0xfU
#define V_DEBUG_PC_REQ_SOP0_CNT(x) ((x) << S_DEBUG_PC_REQ_SOP0_CNT)
#define G_DEBUG_PC_REQ_SOP0_CNT(x) (((x) >> S_DEBUG_PC_REQ_SOP0_CNT) & M_DEBUG_PC_REQ_SOP0_CNT)

#define S_DEBUG_PC_REQ_EOP0_CNT    0
#define M_DEBUG_PC_REQ_EOP0_CNT    0xfU
#define V_DEBUG_PC_REQ_EOP0_CNT(x) ((x) << S_DEBUG_PC_REQ_EOP0_CNT)
#define G_DEBUG_PC_REQ_EOP0_CNT(x) (((x) >> S_DEBUG_PC_REQ_EOP0_CNT) & M_DEBUG_PC_REQ_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_5 0x1294

#define S_DEBUG_PD_RDREQ_SOP3_CNT    28
#define M_DEBUG_PD_RDREQ_SOP3_CNT    0xfU
#define V_DEBUG_PD_RDREQ_SOP3_CNT(x) ((x) << S_DEBUG_PD_RDREQ_SOP3_CNT)
#define G_DEBUG_PD_RDREQ_SOP3_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_SOP3_CNT) & M_DEBUG_PD_RDREQ_SOP3_CNT)

#define S_DEBUG_PD_RDREQ_EOP3_CNT    24
#define M_DEBUG_PD_RDREQ_EOP3_CNT    0xfU
#define V_DEBUG_PD_RDREQ_EOP3_CNT(x) ((x) << S_DEBUG_PD_RDREQ_EOP3_CNT)
#define G_DEBUG_PD_RDREQ_EOP3_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_EOP3_CNT) & M_DEBUG_PD_RDREQ_EOP3_CNT)

#define S_DEBUG_PD_RDREQ_SOP2_CNT    20
#define M_DEBUG_PD_RDREQ_SOP2_CNT    0xfU
#define V_DEBUG_PD_RDREQ_SOP2_CNT(x) ((x) << S_DEBUG_PD_RDREQ_SOP2_CNT)
#define G_DEBUG_PD_RDREQ_SOP2_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_SOP2_CNT) & M_DEBUG_PD_RDREQ_SOP2_CNT)

#define S_DEBUG_PD_RDREQ_EOP2_CNT    16
#define M_DEBUG_PD_RDREQ_EOP2_CNT    0xfU
#define V_DEBUG_PD_RDREQ_EOP2_CNT(x) ((x) << S_DEBUG_PD_RDREQ_EOP2_CNT)
#define G_DEBUG_PD_RDREQ_EOP2_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_EOP2_CNT) & M_DEBUG_PD_RDREQ_EOP2_CNT)

#define S_DEBUG_PD_RDREQ_SOP1_CNT    12
#define M_DEBUG_PD_RDREQ_SOP1_CNT    0xfU
#define V_DEBUG_PD_RDREQ_SOP1_CNT(x) ((x) << S_DEBUG_PD_RDREQ_SOP1_CNT)
#define G_DEBUG_PD_RDREQ_SOP1_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_SOP1_CNT) & M_DEBUG_PD_RDREQ_SOP1_CNT)

#define S_DEBUG_PD_RDREQ_EOP1_CNT    8
#define M_DEBUG_PD_RDREQ_EOP1_CNT    0xfU
#define V_DEBUG_PD_RDREQ_EOP1_CNT(x) ((x) << S_DEBUG_PD_RDREQ_EOP1_CNT)
#define G_DEBUG_PD_RDREQ_EOP1_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_EOP1_CNT) & M_DEBUG_PD_RDREQ_EOP1_CNT)

#define S_DEBUG_PD_RDREQ_SOP0_CNT    4
#define M_DEBUG_PD_RDREQ_SOP0_CNT    0xfU
#define V_DEBUG_PD_RDREQ_SOP0_CNT(x) ((x) << S_DEBUG_PD_RDREQ_SOP0_CNT)
#define G_DEBUG_PD_RDREQ_SOP0_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_SOP0_CNT) & M_DEBUG_PD_RDREQ_SOP0_CNT)

#define S_DEBUG_PD_RDREQ_EOP0_CNT    0
#define M_DEBUG_PD_RDREQ_EOP0_CNT    0xfU
#define V_DEBUG_PD_RDREQ_EOP0_CNT(x) ((x) << S_DEBUG_PD_RDREQ_EOP0_CNT)
#define G_DEBUG_PD_RDREQ_EOP0_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_EOP0_CNT) & M_DEBUG_PD_RDREQ_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_6 0x1298

#define S_DEBUG_PD_RDRSP_SOP3_CNT    28
#define M_DEBUG_PD_RDRSP_SOP3_CNT    0xfU
#define V_DEBUG_PD_RDRSP_SOP3_CNT(x) ((x) << S_DEBUG_PD_RDRSP_SOP3_CNT)
#define G_DEBUG_PD_RDRSP_SOP3_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_SOP3_CNT) & M_DEBUG_PD_RDRSP_SOP3_CNT)

#define S_DEBUG_PD_RDRSP_EOP3_CNT    24
#define M_DEBUG_PD_RDRSP_EOP3_CNT    0xfU
#define V_DEBUG_PD_RDRSP_EOP3_CNT(x) ((x) << S_DEBUG_PD_RDRSP_EOP3_CNT)
#define G_DEBUG_PD_RDRSP_EOP3_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_EOP3_CNT) & M_DEBUG_PD_RDRSP_EOP3_CNT)

#define S_DEBUG_PD_RDRSP_SOP2_CNT    20
#define M_DEBUG_PD_RDRSP_SOP2_CNT    0xfU
#define V_DEBUG_PD_RDRSP_SOP2_CNT(x) ((x) << S_DEBUG_PD_RDRSP_SOP2_CNT)
#define G_DEBUG_PD_RDRSP_SOP2_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_SOP2_CNT) & M_DEBUG_PD_RDRSP_SOP2_CNT)

#define S_DEBUG_PD_RDRSP_EOP2_CNT    16
#define M_DEBUG_PD_RDRSP_EOP2_CNT    0xfU
#define V_DEBUG_PD_RDRSP_EOP2_CNT(x) ((x) << S_DEBUG_PD_RDRSP_EOP2_CNT)
#define G_DEBUG_PD_RDRSP_EOP2_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_EOP2_CNT) & M_DEBUG_PD_RDRSP_EOP2_CNT)

#define S_DEBUG_PD_RDRSP_SOP1_CNT    12
#define M_DEBUG_PD_RDRSP_SOP1_CNT    0xfU
#define V_DEBUG_PD_RDRSP_SOP1_CNT(x) ((x) << S_DEBUG_PD_RDRSP_SOP1_CNT)
#define G_DEBUG_PD_RDRSP_SOP1_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_SOP1_CNT) & M_DEBUG_PD_RDRSP_SOP1_CNT)

#define S_DEBUG_PD_RDRSP_EOP1_CNT    8
#define M_DEBUG_PD_RDRSP_EOP1_CNT    0xfU
#define V_DEBUG_PD_RDRSP_EOP1_CNT(x) ((x) << S_DEBUG_PD_RDRSP_EOP1_CNT)
#define G_DEBUG_PD_RDRSP_EOP1_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_EOP1_CNT) & M_DEBUG_PD_RDRSP_EOP1_CNT)

#define S_DEBUG_PD_RDRSP_SOP0_CNT    4
#define M_DEBUG_PD_RDRSP_SOP0_CNT    0xfU
#define V_DEBUG_PD_RDRSP_SOP0_CNT(x) ((x) << S_DEBUG_PD_RDRSP_SOP0_CNT)
#define G_DEBUG_PD_RDRSP_SOP0_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_SOP0_CNT) & M_DEBUG_PD_RDRSP_SOP0_CNT)

#define S_DEBUG_PD_RDRSP_EOP0_CNT    0
#define M_DEBUG_PD_RDRSP_EOP0_CNT    0xfU
#define V_DEBUG_PD_RDRSP_EOP0_CNT(x) ((x) << S_DEBUG_PD_RDRSP_EOP0_CNT)
#define G_DEBUG_PD_RDRSP_EOP0_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_EOP0_CNT) & M_DEBUG_PD_RDRSP_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_7 0x129c

#define S_DEBUG_PD_WRREQ_SOP3_CNT    28
#define M_DEBUG_PD_WRREQ_SOP3_CNT    0xfU
#define V_DEBUG_PD_WRREQ_SOP3_CNT(x) ((x) << S_DEBUG_PD_WRREQ_SOP3_CNT)
#define G_DEBUG_PD_WRREQ_SOP3_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_SOP3_CNT) & M_DEBUG_PD_WRREQ_SOP3_CNT)

#define S_DEBUG_PD_WRREQ_EOP3_CNT    24
#define M_DEBUG_PD_WRREQ_EOP3_CNT    0xfU
#define V_DEBUG_PD_WRREQ_EOP3_CNT(x) ((x) << S_DEBUG_PD_WRREQ_EOP3_CNT)
#define G_DEBUG_PD_WRREQ_EOP3_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_EOP3_CNT) & M_DEBUG_PD_WRREQ_EOP3_CNT)

#define S_DEBUG_PD_WRREQ_SOP2_CNT    20
#define M_DEBUG_PD_WRREQ_SOP2_CNT    0xfU
#define V_DEBUG_PD_WRREQ_SOP2_CNT(x) ((x) << S_DEBUG_PD_WRREQ_SOP2_CNT)
#define G_DEBUG_PD_WRREQ_SOP2_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_SOP2_CNT) & M_DEBUG_PD_WRREQ_SOP2_CNT)

#define S_DEBUG_PD_WRREQ_EOP2_CNT    16
#define M_DEBUG_PD_WRREQ_EOP2_CNT    0xfU
#define V_DEBUG_PD_WRREQ_EOP2_CNT(x) ((x) << S_DEBUG_PD_WRREQ_EOP2_CNT)
#define G_DEBUG_PD_WRREQ_EOP2_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_EOP2_CNT) & M_DEBUG_PD_WRREQ_EOP2_CNT)

#define S_DEBUG_PD_WRREQ_SOP1_CNT    12
#define M_DEBUG_PD_WRREQ_SOP1_CNT    0xfU
#define V_DEBUG_PD_WRREQ_SOP1_CNT(x) ((x) << S_DEBUG_PD_WRREQ_SOP1_CNT)
#define G_DEBUG_PD_WRREQ_SOP1_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_SOP1_CNT) & M_DEBUG_PD_WRREQ_SOP1_CNT)

#define S_DEBUG_PD_WRREQ_EOP1_CNT    8
#define M_DEBUG_PD_WRREQ_EOP1_CNT    0xfU
#define V_DEBUG_PD_WRREQ_EOP1_CNT(x) ((x) << S_DEBUG_PD_WRREQ_EOP1_CNT)
#define G_DEBUG_PD_WRREQ_EOP1_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_EOP1_CNT) & M_DEBUG_PD_WRREQ_EOP1_CNT)

#define S_DEBUG_PD_WRREQ_SOP0_CNT    4
#define M_DEBUG_PD_WRREQ_SOP0_CNT    0xfU
#define V_DEBUG_PD_WRREQ_SOP0_CNT(x) ((x) << S_DEBUG_PD_WRREQ_SOP0_CNT)
#define G_DEBUG_PD_WRREQ_SOP0_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_SOP0_CNT) & M_DEBUG_PD_WRREQ_SOP0_CNT)

#define S_DEBUG_PD_WRREQ_EOP0_CNT    0
#define M_DEBUG_PD_WRREQ_EOP0_CNT    0xfU
#define V_DEBUG_PD_WRREQ_EOP0_CNT(x) ((x) << S_DEBUG_PD_WRREQ_EOP0_CNT)
#define G_DEBUG_PD_WRREQ_EOP0_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_EOP0_CNT) & M_DEBUG_PD_WRREQ_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_8 0x12a0

#define S_GLOBALENABLE_OFF    29
#define V_GLOBALENABLE_OFF(x) ((x) << S_GLOBALENABLE_OFF)
#define F_GLOBALENABLE_OFF    V_GLOBALENABLE_OFF(1U)

#define S_DEBUG_CIM2SGE_RXAFULL_D    27
#define M_DEBUG_CIM2SGE_RXAFULL_D    0x3U
#define V_DEBUG_CIM2SGE_RXAFULL_D(x) ((x) << S_DEBUG_CIM2SGE_RXAFULL_D)
#define G_DEBUG_CIM2SGE_RXAFULL_D(x) (((x) >> S_DEBUG_CIM2SGE_RXAFULL_D) & M_DEBUG_CIM2SGE_RXAFULL_D)

#define S_DEBUG_CPLSW_CIM_TXAFULL_D    25
#define M_DEBUG_CPLSW_CIM_TXAFULL_D    0x3U
#define V_DEBUG_CPLSW_CIM_TXAFULL_D(x) ((x) << S_DEBUG_CPLSW_CIM_TXAFULL_D)
#define G_DEBUG_CPLSW_CIM_TXAFULL_D(x) (((x) >> S_DEBUG_CPLSW_CIM_TXAFULL_D) & M_DEBUG_CPLSW_CIM_TXAFULL_D)

#define S_DEBUG_UP_FULL    24
#define V_DEBUG_UP_FULL(x) ((x) << S_DEBUG_UP_FULL)
#define F_DEBUG_UP_FULL    V_DEBUG_UP_FULL(1U)

#define S_DEBUG_M_RD_REQ_OUTSTANDING_PC    23
#define V_DEBUG_M_RD_REQ_OUTSTANDING_PC(x) ((x) << S_DEBUG_M_RD_REQ_OUTSTANDING_PC)
#define F_DEBUG_M_RD_REQ_OUTSTANDING_PC    V_DEBUG_M_RD_REQ_OUTSTANDING_PC(1U)

#define S_DEBUG_M_RD_REQ_OUTSTANDING_VFIFO    22
#define V_DEBUG_M_RD_REQ_OUTSTANDING_VFIFO(x) ((x) << S_DEBUG_M_RD_REQ_OUTSTANDING_VFIFO)
#define F_DEBUG_M_RD_REQ_OUTSTANDING_VFIFO    V_DEBUG_M_RD_REQ_OUTSTANDING_VFIFO(1U)

#define S_DEBUG_M_RD_REQ_OUTSTANDING_IMSG    21
#define V_DEBUG_M_RD_REQ_OUTSTANDING_IMSG(x) ((x) << S_DEBUG_M_RD_REQ_OUTSTANDING_IMSG)
#define F_DEBUG_M_RD_REQ_OUTSTANDING_IMSG    V_DEBUG_M_RD_REQ_OUTSTANDING_IMSG(1U)

#define S_DEBUG_M_RD_REQ_OUTSTANDING_CMARB    20
#define V_DEBUG_M_RD_REQ_OUTSTANDING_CMARB(x) ((x) << S_DEBUG_M_RD_REQ_OUTSTANDING_CMARB)
#define F_DEBUG_M_RD_REQ_OUTSTANDING_CMARB    V_DEBUG_M_RD_REQ_OUTSTANDING_CMARB(1U)

#define S_DEBUG_M_RD_REQ_OUTSTANDING_FLM    19
#define V_DEBUG_M_RD_REQ_OUTSTANDING_FLM(x) ((x) << S_DEBUG_M_RD_REQ_OUTSTANDING_FLM)
#define F_DEBUG_M_RD_REQ_OUTSTANDING_FLM    V_DEBUG_M_RD_REQ_OUTSTANDING_FLM(1U)

#define S_DEBUG_M_REQVLD    18
#define V_DEBUG_M_REQVLD(x) ((x) << S_DEBUG_M_REQVLD)
#define F_DEBUG_M_REQVLD    V_DEBUG_M_REQVLD(1U)

#define S_DEBUG_M_REQRDY    17
#define V_DEBUG_M_REQRDY(x) ((x) << S_DEBUG_M_REQRDY)
#define F_DEBUG_M_REQRDY    V_DEBUG_M_REQRDY(1U)

#define S_DEBUG_M_RSPVLD    16
#define V_DEBUG_M_RSPVLD(x) ((x) << S_DEBUG_M_RSPVLD)
#define F_DEBUG_M_RSPVLD    V_DEBUG_M_RSPVLD(1U)

#define S_DEBUG_PD_WRREQ_INT3_CNT    12
#define M_DEBUG_PD_WRREQ_INT3_CNT    0xfU
#define V_DEBUG_PD_WRREQ_INT3_CNT(x) ((x) << S_DEBUG_PD_WRREQ_INT3_CNT)
#define G_DEBUG_PD_WRREQ_INT3_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_INT3_CNT) & M_DEBUG_PD_WRREQ_INT3_CNT)

#define S_DEBUG_PD_WRREQ_INT2_CNT    8
#define M_DEBUG_PD_WRREQ_INT2_CNT    0xfU
#define V_DEBUG_PD_WRREQ_INT2_CNT(x) ((x) << S_DEBUG_PD_WRREQ_INT2_CNT)
#define G_DEBUG_PD_WRREQ_INT2_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_INT2_CNT) & M_DEBUG_PD_WRREQ_INT2_CNT)

#define S_DEBUG_PD_WRREQ_INT1_CNT    4
#define M_DEBUG_PD_WRREQ_INT1_CNT    0xfU
#define V_DEBUG_PD_WRREQ_INT1_CNT(x) ((x) << S_DEBUG_PD_WRREQ_INT1_CNT)
#define G_DEBUG_PD_WRREQ_INT1_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_INT1_CNT) & M_DEBUG_PD_WRREQ_INT1_CNT)

#define S_DEBUG_PD_WRREQ_INT0_CNT    0
#define M_DEBUG_PD_WRREQ_INT0_CNT    0xfU
#define V_DEBUG_PD_WRREQ_INT0_CNT(x) ((x) << S_DEBUG_PD_WRREQ_INT0_CNT)
#define G_DEBUG_PD_WRREQ_INT0_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_INT0_CNT) & M_DEBUG_PD_WRREQ_INT0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_9 0x12a4

#define S_DEBUG_CPLSW_TP_RX_SOP1_CNT    28
#define M_DEBUG_CPLSW_TP_RX_SOP1_CNT    0xfU
#define V_DEBUG_CPLSW_TP_RX_SOP1_CNT(x) ((x) << S_DEBUG_CPLSW_TP_RX_SOP1_CNT)
#define G_DEBUG_CPLSW_TP_RX_SOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_TP_RX_SOP1_CNT) & M_DEBUG_CPLSW_TP_RX_SOP1_CNT)

#define S_DEBUG_CPLSW_TP_RX_EOP1_CNT    24
#define M_DEBUG_CPLSW_TP_RX_EOP1_CNT    0xfU
#define V_DEBUG_CPLSW_TP_RX_EOP1_CNT(x) ((x) << S_DEBUG_CPLSW_TP_RX_EOP1_CNT)
#define G_DEBUG_CPLSW_TP_RX_EOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_TP_RX_EOP1_CNT) & M_DEBUG_CPLSW_TP_RX_EOP1_CNT)

#define S_DEBUG_CPLSW_TP_RX_SOP0_CNT    20
#define M_DEBUG_CPLSW_TP_RX_SOP0_CNT    0xfU
#define V_DEBUG_CPLSW_TP_RX_SOP0_CNT(x) ((x) << S_DEBUG_CPLSW_TP_RX_SOP0_CNT)
#define G_DEBUG_CPLSW_TP_RX_SOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_TP_RX_SOP0_CNT) & M_DEBUG_CPLSW_TP_RX_SOP0_CNT)

#define S_DEBUG_CPLSW_TP_RX_EOP0_CNT    16
#define M_DEBUG_CPLSW_TP_RX_EOP0_CNT    0xfU
#define V_DEBUG_CPLSW_TP_RX_EOP0_CNT(x) ((x) << S_DEBUG_CPLSW_TP_RX_EOP0_CNT)
#define G_DEBUG_CPLSW_TP_RX_EOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_TP_RX_EOP0_CNT) & M_DEBUG_CPLSW_TP_RX_EOP0_CNT)

#define S_DEBUG_CPLSW_CIM_SOP1_CNT    12
#define M_DEBUG_CPLSW_CIM_SOP1_CNT    0xfU
#define V_DEBUG_CPLSW_CIM_SOP1_CNT(x) ((x) << S_DEBUG_CPLSW_CIM_SOP1_CNT)
#define G_DEBUG_CPLSW_CIM_SOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_CIM_SOP1_CNT) & M_DEBUG_CPLSW_CIM_SOP1_CNT)

#define S_DEBUG_CPLSW_CIM_EOP1_CNT    8
#define M_DEBUG_CPLSW_CIM_EOP1_CNT    0xfU
#define V_DEBUG_CPLSW_CIM_EOP1_CNT(x) ((x) << S_DEBUG_CPLSW_CIM_EOP1_CNT)
#define G_DEBUG_CPLSW_CIM_EOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_CIM_EOP1_CNT) & M_DEBUG_CPLSW_CIM_EOP1_CNT)

#define S_DEBUG_CPLSW_CIM_SOP0_CNT    4
#define M_DEBUG_CPLSW_CIM_SOP0_CNT    0xfU
#define V_DEBUG_CPLSW_CIM_SOP0_CNT(x) ((x) << S_DEBUG_CPLSW_CIM_SOP0_CNT)
#define G_DEBUG_CPLSW_CIM_SOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_CIM_SOP0_CNT) & M_DEBUG_CPLSW_CIM_SOP0_CNT)

#define S_DEBUG_CPLSW_CIM_EOP0_CNT    0
#define M_DEBUG_CPLSW_CIM_EOP0_CNT    0xfU
#define V_DEBUG_CPLSW_CIM_EOP0_CNT(x) ((x) << S_DEBUG_CPLSW_CIM_EOP0_CNT)
#define G_DEBUG_CPLSW_CIM_EOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_CIM_EOP0_CNT) & M_DEBUG_CPLSW_CIM_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_10 0x12a8

#define S_DEBUG_T_RXAFULL_D    30
#define M_DEBUG_T_RXAFULL_D    0x3U
#define V_DEBUG_T_RXAFULL_D(x) ((x) << S_DEBUG_T_RXAFULL_D)
#define G_DEBUG_T_RXAFULL_D(x) (((x) >> S_DEBUG_T_RXAFULL_D) & M_DEBUG_T_RXAFULL_D)

#define S_DEBUG_PD_RDRSPAFULL_D    26
#define M_DEBUG_PD_RDRSPAFULL_D    0xfU
#define V_DEBUG_PD_RDRSPAFULL_D(x) ((x) << S_DEBUG_PD_RDRSPAFULL_D)
#define G_DEBUG_PD_RDRSPAFULL_D(x) (((x) >> S_DEBUG_PD_RDRSPAFULL_D) & M_DEBUG_PD_RDRSPAFULL_D)

#define S_DEBUG_PD_RDREQAFULL_D    22
#define M_DEBUG_PD_RDREQAFULL_D    0xfU
#define V_DEBUG_PD_RDREQAFULL_D(x) ((x) << S_DEBUG_PD_RDREQAFULL_D)
#define G_DEBUG_PD_RDREQAFULL_D(x) (((x) >> S_DEBUG_PD_RDREQAFULL_D) & M_DEBUG_PD_RDREQAFULL_D)

#define S_DEBUG_PD_WRREQAFULL_D    18
#define M_DEBUG_PD_WRREQAFULL_D    0xfU
#define V_DEBUG_PD_WRREQAFULL_D(x) ((x) << S_DEBUG_PD_WRREQAFULL_D)
#define G_DEBUG_PD_WRREQAFULL_D(x) (((x) >> S_DEBUG_PD_WRREQAFULL_D) & M_DEBUG_PD_WRREQAFULL_D)

#define S_DEBUG_PC_RSPAFULL_D    15
#define M_DEBUG_PC_RSPAFULL_D    0x7U
#define V_DEBUG_PC_RSPAFULL_D(x) ((x) << S_DEBUG_PC_RSPAFULL_D)
#define G_DEBUG_PC_RSPAFULL_D(x) (((x) >> S_DEBUG_PC_RSPAFULL_D) & M_DEBUG_PC_RSPAFULL_D)

#define S_DEBUG_PC_REQAFULL_D    12
#define M_DEBUG_PC_REQAFULL_D    0x7U
#define V_DEBUG_PC_REQAFULL_D(x) ((x) << S_DEBUG_PC_REQAFULL_D)
#define G_DEBUG_PC_REQAFULL_D(x) (((x) >> S_DEBUG_PC_REQAFULL_D) & M_DEBUG_PC_REQAFULL_D)

#define S_DEBUG_U_TXAFULL_D    8
#define M_DEBUG_U_TXAFULL_D    0xfU
#define V_DEBUG_U_TXAFULL_D(x) ((x) << S_DEBUG_U_TXAFULL_D)
#define G_DEBUG_U_TXAFULL_D(x) (((x) >> S_DEBUG_U_TXAFULL_D) & M_DEBUG_U_TXAFULL_D)

#define S_DEBUG_UD_RXAFULL_D    4
#define M_DEBUG_UD_RXAFULL_D    0xfU
#define V_DEBUG_UD_RXAFULL_D(x) ((x) << S_DEBUG_UD_RXAFULL_D)
#define G_DEBUG_UD_RXAFULL_D(x) (((x) >> S_DEBUG_UD_RXAFULL_D) & M_DEBUG_UD_RXAFULL_D)

#define S_DEBUG_U_RXAFULL_D    2
#define M_DEBUG_U_RXAFULL_D    0x3U
#define V_DEBUG_U_RXAFULL_D(x) ((x) << S_DEBUG_U_RXAFULL_D)
#define G_DEBUG_U_RXAFULL_D(x) (((x) >> S_DEBUG_U_RXAFULL_D) & M_DEBUG_U_RXAFULL_D)

#define S_DEBUG_CIM_AFULL_D    0
#define M_DEBUG_CIM_AFULL_D    0x3U
#define V_DEBUG_CIM_AFULL_D(x) ((x) << S_DEBUG_CIM_AFULL_D)
#define G_DEBUG_CIM_AFULL_D(x) (((x) >> S_DEBUG_CIM_AFULL_D) & M_DEBUG_CIM_AFULL_D)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_11 0x12ac

#define S_DEBUG_FLM_IDMA1_CACHE_DATA_ACTIVE    24
#define V_DEBUG_FLM_IDMA1_CACHE_DATA_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA1_CACHE_DATA_ACTIVE)
#define F_DEBUG_FLM_IDMA1_CACHE_DATA_ACTIVE    V_DEBUG_FLM_IDMA1_CACHE_DATA_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA1_CACHE_HDR_ACTIVE    23
#define V_DEBUG_FLM_IDMA1_CACHE_HDR_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA1_CACHE_HDR_ACTIVE)
#define F_DEBUG_FLM_IDMA1_CACHE_HDR_ACTIVE    V_DEBUG_FLM_IDMA1_CACHE_HDR_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA1_CTXT_DATA_ACTIVE    22
#define V_DEBUG_FLM_IDMA1_CTXT_DATA_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA1_CTXT_DATA_ACTIVE)
#define F_DEBUG_FLM_IDMA1_CTXT_DATA_ACTIVE    V_DEBUG_FLM_IDMA1_CTXT_DATA_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA1_CTXT_HDR_ACTIVE    21
#define V_DEBUG_FLM_IDMA1_CTXT_HDR_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA1_CTXT_HDR_ACTIVE)
#define F_DEBUG_FLM_IDMA1_CTXT_HDR_ACTIVE    V_DEBUG_FLM_IDMA1_CTXT_HDR_ACTIVE(1U)

#define S_DEBUG_ST_FLM_IDMA1_CACHE    19
#define M_DEBUG_ST_FLM_IDMA1_CACHE    0x3U
#define V_DEBUG_ST_FLM_IDMA1_CACHE(x) ((x) << S_DEBUG_ST_FLM_IDMA1_CACHE)
#define G_DEBUG_ST_FLM_IDMA1_CACHE(x) (((x) >> S_DEBUG_ST_FLM_IDMA1_CACHE) & M_DEBUG_ST_FLM_IDMA1_CACHE)

#define S_DEBUG_ST_FLM_IDMA1_CTXT    16
#define M_DEBUG_ST_FLM_IDMA1_CTXT    0x7U
#define V_DEBUG_ST_FLM_IDMA1_CTXT(x) ((x) << S_DEBUG_ST_FLM_IDMA1_CTXT)
#define G_DEBUG_ST_FLM_IDMA1_CTXT(x) (((x) >> S_DEBUG_ST_FLM_IDMA1_CTXT) & M_DEBUG_ST_FLM_IDMA1_CTXT)

#define S_DEBUG_FLM_IDMA0_CACHE_DATA_ACTIVE    8
#define V_DEBUG_FLM_IDMA0_CACHE_DATA_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA0_CACHE_DATA_ACTIVE)
#define F_DEBUG_FLM_IDMA0_CACHE_DATA_ACTIVE    V_DEBUG_FLM_IDMA0_CACHE_DATA_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA0_CACHE_HDR_ACTIVE    7
#define V_DEBUG_FLM_IDMA0_CACHE_HDR_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA0_CACHE_HDR_ACTIVE)
#define F_DEBUG_FLM_IDMA0_CACHE_HDR_ACTIVE    V_DEBUG_FLM_IDMA0_CACHE_HDR_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA0_CTXT_DATA_ACTIVE    6
#define V_DEBUG_FLM_IDMA0_CTXT_DATA_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA0_CTXT_DATA_ACTIVE)
#define F_DEBUG_FLM_IDMA0_CTXT_DATA_ACTIVE    V_DEBUG_FLM_IDMA0_CTXT_DATA_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA0_CTXT_HDR_ACTIVE    5
#define V_DEBUG_FLM_IDMA0_CTXT_HDR_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA0_CTXT_HDR_ACTIVE)
#define F_DEBUG_FLM_IDMA0_CTXT_HDR_ACTIVE    V_DEBUG_FLM_IDMA0_CTXT_HDR_ACTIVE(1U)

#define S_DEBUG_ST_FLM_IDMA0_CACHE    3
#define M_DEBUG_ST_FLM_IDMA0_CACHE    0x3U
#define V_DEBUG_ST_FLM_IDMA0_CACHE(x) ((x) << S_DEBUG_ST_FLM_IDMA0_CACHE)
#define G_DEBUG_ST_FLM_IDMA0_CACHE(x) (((x) >> S_DEBUG_ST_FLM_IDMA0_CACHE) & M_DEBUG_ST_FLM_IDMA0_CACHE)

#define S_DEBUG_ST_FLM_IDMA0_CTXT    0
#define M_DEBUG_ST_FLM_IDMA0_CTXT    0x7U
#define V_DEBUG_ST_FLM_IDMA0_CTXT(x) ((x) << S_DEBUG_ST_FLM_IDMA0_CTXT)
#define G_DEBUG_ST_FLM_IDMA0_CTXT(x) (((x) >> S_DEBUG_ST_FLM_IDMA0_CTXT) & M_DEBUG_ST_FLM_IDMA0_CTXT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_12 0x12b0

#define S_DEBUG_CPLSW_SOP1_CNT    28
#define M_DEBUG_CPLSW_SOP1_CNT    0xfU
#define V_DEBUG_CPLSW_SOP1_CNT(x) ((x) << S_DEBUG_CPLSW_SOP1_CNT)
#define G_DEBUG_CPLSW_SOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_SOP1_CNT) & M_DEBUG_CPLSW_SOP1_CNT)

#define S_DEBUG_CPLSW_EOP1_CNT    24
#define M_DEBUG_CPLSW_EOP1_CNT    0xfU
#define V_DEBUG_CPLSW_EOP1_CNT(x) ((x) << S_DEBUG_CPLSW_EOP1_CNT)
#define G_DEBUG_CPLSW_EOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_EOP1_CNT) & M_DEBUG_CPLSW_EOP1_CNT)

#define S_DEBUG_CPLSW_SOP0_CNT    20
#define M_DEBUG_CPLSW_SOP0_CNT    0xfU
#define V_DEBUG_CPLSW_SOP0_CNT(x) ((x) << S_DEBUG_CPLSW_SOP0_CNT)
#define G_DEBUG_CPLSW_SOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_SOP0_CNT) & M_DEBUG_CPLSW_SOP0_CNT)

#define S_DEBUG_CPLSW_EOP0_CNT    16
#define M_DEBUG_CPLSW_EOP0_CNT    0xfU
#define V_DEBUG_CPLSW_EOP0_CNT(x) ((x) << S_DEBUG_CPLSW_EOP0_CNT)
#define G_DEBUG_CPLSW_EOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_EOP0_CNT) & M_DEBUG_CPLSW_EOP0_CNT)

#define S_DEBUG_PC_RSP_SOP2_CNT    12
#define M_DEBUG_PC_RSP_SOP2_CNT    0xfU
#define V_DEBUG_PC_RSP_SOP2_CNT(x) ((x) << S_DEBUG_PC_RSP_SOP2_CNT)
#define G_DEBUG_PC_RSP_SOP2_CNT(x) (((x) >> S_DEBUG_PC_RSP_SOP2_CNT) & M_DEBUG_PC_RSP_SOP2_CNT)

#define S_DEBUG_PC_RSP_EOP2_CNT    8
#define M_DEBUG_PC_RSP_EOP2_CNT    0xfU
#define V_DEBUG_PC_RSP_EOP2_CNT(x) ((x) << S_DEBUG_PC_RSP_EOP2_CNT)
#define G_DEBUG_PC_RSP_EOP2_CNT(x) (((x) >> S_DEBUG_PC_RSP_EOP2_CNT) & M_DEBUG_PC_RSP_EOP2_CNT)

#define S_DEBUG_PC_REQ_SOP2_CNT    4
#define M_DEBUG_PC_REQ_SOP2_CNT    0xfU
#define V_DEBUG_PC_REQ_SOP2_CNT(x) ((x) << S_DEBUG_PC_REQ_SOP2_CNT)
#define G_DEBUG_PC_REQ_SOP2_CNT(x) (((x) >> S_DEBUG_PC_REQ_SOP2_CNT) & M_DEBUG_PC_REQ_SOP2_CNT)

#define S_DEBUG_PC_REQ_EOP2_CNT    0
#define M_DEBUG_PC_REQ_EOP2_CNT    0xfU
#define V_DEBUG_PC_REQ_EOP2_CNT(x) ((x) << S_DEBUG_PC_REQ_EOP2_CNT)
#define G_DEBUG_PC_REQ_EOP2_CNT(x) (((x) >> S_DEBUG_PC_REQ_EOP2_CNT) & M_DEBUG_PC_REQ_EOP2_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_13 0x12b4
#define A_SGE_DEBUG_DATA_HIGH_INDEX_14 0x12b8
#define A_SGE_DEBUG_DATA_HIGH_INDEX_15 0x12bc
#define A_SGE_DEBUG_DATA_LOW_INDEX_0 0x12c0

#define S_DEBUG_ST_IDMA1_FLM_REQ    29
#define M_DEBUG_ST_IDMA1_FLM_REQ    0x7U
#define V_DEBUG_ST_IDMA1_FLM_REQ(x) ((x) << S_DEBUG_ST_IDMA1_FLM_REQ)
#define G_DEBUG_ST_IDMA1_FLM_REQ(x) (((x) >> S_DEBUG_ST_IDMA1_FLM_REQ) & M_DEBUG_ST_IDMA1_FLM_REQ)

#define S_DEBUG_ST_IDMA0_FLM_REQ    26
#define M_DEBUG_ST_IDMA0_FLM_REQ    0x7U
#define V_DEBUG_ST_IDMA0_FLM_REQ(x) ((x) << S_DEBUG_ST_IDMA0_FLM_REQ)
#define G_DEBUG_ST_IDMA0_FLM_REQ(x) (((x) >> S_DEBUG_ST_IDMA0_FLM_REQ) & M_DEBUG_ST_IDMA0_FLM_REQ)

#define S_DEBUG_ST_IMSG_CTXT    23
#define M_DEBUG_ST_IMSG_CTXT    0x7U
#define V_DEBUG_ST_IMSG_CTXT(x) ((x) << S_DEBUG_ST_IMSG_CTXT)
#define G_DEBUG_ST_IMSG_CTXT(x) (((x) >> S_DEBUG_ST_IMSG_CTXT) & M_DEBUG_ST_IMSG_CTXT)

#define S_DEBUG_ST_IMSG    18
#define M_DEBUG_ST_IMSG    0x1fU
#define V_DEBUG_ST_IMSG(x) ((x) << S_DEBUG_ST_IMSG)
#define G_DEBUG_ST_IMSG(x) (((x) >> S_DEBUG_ST_IMSG) & M_DEBUG_ST_IMSG)

#define S_DEBUG_ST_IDMA1_IALN    16
#define M_DEBUG_ST_IDMA1_IALN    0x3U
#define V_DEBUG_ST_IDMA1_IALN(x) ((x) << S_DEBUG_ST_IDMA1_IALN)
#define G_DEBUG_ST_IDMA1_IALN(x) (((x) >> S_DEBUG_ST_IDMA1_IALN) & M_DEBUG_ST_IDMA1_IALN)

#define S_DEBUG_ST_IDMA1_IDMA_SM    9
#define M_DEBUG_ST_IDMA1_IDMA_SM    0x3fU
#define V_DEBUG_ST_IDMA1_IDMA_SM(x) ((x) << S_DEBUG_ST_IDMA1_IDMA_SM)
#define G_DEBUG_ST_IDMA1_IDMA_SM(x) (((x) >> S_DEBUG_ST_IDMA1_IDMA_SM) & M_DEBUG_ST_IDMA1_IDMA_SM)

#define S_DEBUG_ST_IDMA0_IALN    7
#define M_DEBUG_ST_IDMA0_IALN    0x3U
#define V_DEBUG_ST_IDMA0_IALN(x) ((x) << S_DEBUG_ST_IDMA0_IALN)
#define G_DEBUG_ST_IDMA0_IALN(x) (((x) >> S_DEBUG_ST_IDMA0_IALN) & M_DEBUG_ST_IDMA0_IALN)

#define S_DEBUG_ST_IDMA0_IDMA_SM    0
#define M_DEBUG_ST_IDMA0_IDMA_SM    0x3fU
#define V_DEBUG_ST_IDMA0_IDMA_SM(x) ((x) << S_DEBUG_ST_IDMA0_IDMA_SM)
#define G_DEBUG_ST_IDMA0_IDMA_SM(x) (((x) >> S_DEBUG_ST_IDMA0_IDMA_SM) & M_DEBUG_ST_IDMA0_IDMA_SM)

#define A_SGE_DEBUG_DATA_LOW_INDEX_1 0x12c4

#define S_DEBUG_ITP_EMPTY    12
#define M_DEBUG_ITP_EMPTY    0x3fU
#define V_DEBUG_ITP_EMPTY(x) ((x) << S_DEBUG_ITP_EMPTY)
#define G_DEBUG_ITP_EMPTY(x) (((x) >> S_DEBUG_ITP_EMPTY) & M_DEBUG_ITP_EMPTY)

#define S_DEBUG_ITP_EXPIRED    6
#define M_DEBUG_ITP_EXPIRED    0x3fU
#define V_DEBUG_ITP_EXPIRED(x) ((x) << S_DEBUG_ITP_EXPIRED)
#define G_DEBUG_ITP_EXPIRED(x) (((x) >> S_DEBUG_ITP_EXPIRED) & M_DEBUG_ITP_EXPIRED)

#define S_DEBUG_ITP_PAUSE    5
#define V_DEBUG_ITP_PAUSE(x) ((x) << S_DEBUG_ITP_PAUSE)
#define F_DEBUG_ITP_PAUSE    V_DEBUG_ITP_PAUSE(1U)

#define S_DEBUG_ITP_DEL_DONE    4
#define V_DEBUG_ITP_DEL_DONE(x) ((x) << S_DEBUG_ITP_DEL_DONE)
#define F_DEBUG_ITP_DEL_DONE    V_DEBUG_ITP_DEL_DONE(1U)

#define S_DEBUG_ITP_ADD_DONE    3
#define V_DEBUG_ITP_ADD_DONE(x) ((x) << S_DEBUG_ITP_ADD_DONE)
#define F_DEBUG_ITP_ADD_DONE    V_DEBUG_ITP_ADD_DONE(1U)

#define S_DEBUG_ITP_EVR_STATE    0
#define M_DEBUG_ITP_EVR_STATE    0x7U
#define V_DEBUG_ITP_EVR_STATE(x) ((x) << S_DEBUG_ITP_EVR_STATE)
#define G_DEBUG_ITP_EVR_STATE(x) (((x) >> S_DEBUG_ITP_EVR_STATE) & M_DEBUG_ITP_EVR_STATE)

#define A_SGE_DEBUG_DATA_LOW_INDEX_2 0x12c8

#define S_DEBUG_ST_DBP_THREAD2_CIMFL    25
#define M_DEBUG_ST_DBP_THREAD2_CIMFL    0x1fU
#define V_DEBUG_ST_DBP_THREAD2_CIMFL(x) ((x) << S_DEBUG_ST_DBP_THREAD2_CIMFL)
#define G_DEBUG_ST_DBP_THREAD2_CIMFL(x) (((x) >> S_DEBUG_ST_DBP_THREAD2_CIMFL) & M_DEBUG_ST_DBP_THREAD2_CIMFL)

#define S_DEBUG_ST_DBP_THREAD2_MAIN    20
#define M_DEBUG_ST_DBP_THREAD2_MAIN    0x1fU
#define V_DEBUG_ST_DBP_THREAD2_MAIN(x) ((x) << S_DEBUG_ST_DBP_THREAD2_MAIN)
#define G_DEBUG_ST_DBP_THREAD2_MAIN(x) (((x) >> S_DEBUG_ST_DBP_THREAD2_MAIN) & M_DEBUG_ST_DBP_THREAD2_MAIN)

#define S_DEBUG_ST_DBP_THREAD1_CIMFL    15
#define M_DEBUG_ST_DBP_THREAD1_CIMFL    0x1fU
#define V_DEBUG_ST_DBP_THREAD1_CIMFL(x) ((x) << S_DEBUG_ST_DBP_THREAD1_CIMFL)
#define G_DEBUG_ST_DBP_THREAD1_CIMFL(x) (((x) >> S_DEBUG_ST_DBP_THREAD1_CIMFL) & M_DEBUG_ST_DBP_THREAD1_CIMFL)

#define S_DEBUG_ST_DBP_THREAD1_MAIN    10
#define M_DEBUG_ST_DBP_THREAD1_MAIN    0x1fU
#define V_DEBUG_ST_DBP_THREAD1_MAIN(x) ((x) << S_DEBUG_ST_DBP_THREAD1_MAIN)
#define G_DEBUG_ST_DBP_THREAD1_MAIN(x) (((x) >> S_DEBUG_ST_DBP_THREAD1_MAIN) & M_DEBUG_ST_DBP_THREAD1_MAIN)

#define S_DEBUG_ST_DBP_THREAD0_CIMFL    5
#define M_DEBUG_ST_DBP_THREAD0_CIMFL    0x1fU
#define V_DEBUG_ST_DBP_THREAD0_CIMFL(x) ((x) << S_DEBUG_ST_DBP_THREAD0_CIMFL)
#define G_DEBUG_ST_DBP_THREAD0_CIMFL(x) (((x) >> S_DEBUG_ST_DBP_THREAD0_CIMFL) & M_DEBUG_ST_DBP_THREAD0_CIMFL)

#define S_DEBUG_ST_DBP_THREAD0_MAIN    0
#define M_DEBUG_ST_DBP_THREAD0_MAIN    0x1fU
#define V_DEBUG_ST_DBP_THREAD0_MAIN(x) ((x) << S_DEBUG_ST_DBP_THREAD0_MAIN)
#define G_DEBUG_ST_DBP_THREAD0_MAIN(x) (((x) >> S_DEBUG_ST_DBP_THREAD0_MAIN) & M_DEBUG_ST_DBP_THREAD0_MAIN)

#define A_SGE_DEBUG_DATA_LOW_INDEX_3 0x12cc

#define S_DEBUG_ST_DBP_UPCP_MAIN    14
#define M_DEBUG_ST_DBP_UPCP_MAIN    0x1fU
#define V_DEBUG_ST_DBP_UPCP_MAIN(x) ((x) << S_DEBUG_ST_DBP_UPCP_MAIN)
#define G_DEBUG_ST_DBP_UPCP_MAIN(x) (((x) >> S_DEBUG_ST_DBP_UPCP_MAIN) & M_DEBUG_ST_DBP_UPCP_MAIN)

#define S_DEBUG_ST_DBP_DBFIFO_MAIN    13
#define V_DEBUG_ST_DBP_DBFIFO_MAIN(x) ((x) << S_DEBUG_ST_DBP_DBFIFO_MAIN)
#define F_DEBUG_ST_DBP_DBFIFO_MAIN    V_DEBUG_ST_DBP_DBFIFO_MAIN(1U)

#define S_DEBUG_ST_DBP_CTXT    10
#define M_DEBUG_ST_DBP_CTXT    0x7U
#define V_DEBUG_ST_DBP_CTXT(x) ((x) << S_DEBUG_ST_DBP_CTXT)
#define G_DEBUG_ST_DBP_CTXT(x) (((x) >> S_DEBUG_ST_DBP_CTXT) & M_DEBUG_ST_DBP_CTXT)

#define S_DEBUG_ST_DBP_THREAD3_CIMFL    5
#define M_DEBUG_ST_DBP_THREAD3_CIMFL    0x1fU
#define V_DEBUG_ST_DBP_THREAD3_CIMFL(x) ((x) << S_DEBUG_ST_DBP_THREAD3_CIMFL)
#define G_DEBUG_ST_DBP_THREAD3_CIMFL(x) (((x) >> S_DEBUG_ST_DBP_THREAD3_CIMFL) & M_DEBUG_ST_DBP_THREAD3_CIMFL)

#define S_DEBUG_ST_DBP_THREAD3_MAIN    0
#define M_DEBUG_ST_DBP_THREAD3_MAIN    0x1fU
#define V_DEBUG_ST_DBP_THREAD3_MAIN(x) ((x) << S_DEBUG_ST_DBP_THREAD3_MAIN)
#define G_DEBUG_ST_DBP_THREAD3_MAIN(x) (((x) >> S_DEBUG_ST_DBP_THREAD3_MAIN) & M_DEBUG_ST_DBP_THREAD3_MAIN)

#define A_SGE_DEBUG_DATA_LOW_INDEX_4 0x12d0

#define S_DEBUG_ST_EDMA3_ALIGN_SUB    29
#define M_DEBUG_ST_EDMA3_ALIGN_SUB    0x7U
#define V_DEBUG_ST_EDMA3_ALIGN_SUB(x) ((x) << S_DEBUG_ST_EDMA3_ALIGN_SUB)
#define G_DEBUG_ST_EDMA3_ALIGN_SUB(x) (((x) >> S_DEBUG_ST_EDMA3_ALIGN_SUB) & M_DEBUG_ST_EDMA3_ALIGN_SUB)

#define S_DEBUG_ST_EDMA3_ALIGN    27
#define M_DEBUG_ST_EDMA3_ALIGN    0x3U
#define V_DEBUG_ST_EDMA3_ALIGN(x) ((x) << S_DEBUG_ST_EDMA3_ALIGN)
#define G_DEBUG_ST_EDMA3_ALIGN(x) (((x) >> S_DEBUG_ST_EDMA3_ALIGN) & M_DEBUG_ST_EDMA3_ALIGN)

#define S_DEBUG_ST_EDMA3_REQ    24
#define M_DEBUG_ST_EDMA3_REQ    0x7U
#define V_DEBUG_ST_EDMA3_REQ(x) ((x) << S_DEBUG_ST_EDMA3_REQ)
#define G_DEBUG_ST_EDMA3_REQ(x) (((x) >> S_DEBUG_ST_EDMA3_REQ) & M_DEBUG_ST_EDMA3_REQ)

#define S_DEBUG_ST_EDMA2_ALIGN_SUB    21
#define M_DEBUG_ST_EDMA2_ALIGN_SUB    0x7U
#define V_DEBUG_ST_EDMA2_ALIGN_SUB(x) ((x) << S_DEBUG_ST_EDMA2_ALIGN_SUB)
#define G_DEBUG_ST_EDMA2_ALIGN_SUB(x) (((x) >> S_DEBUG_ST_EDMA2_ALIGN_SUB) & M_DEBUG_ST_EDMA2_ALIGN_SUB)

#define S_DEBUG_ST_EDMA2_ALIGN    19
#define M_DEBUG_ST_EDMA2_ALIGN    0x3U
#define V_DEBUG_ST_EDMA2_ALIGN(x) ((x) << S_DEBUG_ST_EDMA2_ALIGN)
#define G_DEBUG_ST_EDMA2_ALIGN(x) (((x) >> S_DEBUG_ST_EDMA2_ALIGN) & M_DEBUG_ST_EDMA2_ALIGN)

#define S_DEBUG_ST_EDMA2_REQ    16
#define M_DEBUG_ST_EDMA2_REQ    0x7U
#define V_DEBUG_ST_EDMA2_REQ(x) ((x) << S_DEBUG_ST_EDMA2_REQ)
#define G_DEBUG_ST_EDMA2_REQ(x) (((x) >> S_DEBUG_ST_EDMA2_REQ) & M_DEBUG_ST_EDMA2_REQ)

#define S_DEBUG_ST_EDMA1_ALIGN_SUB    13
#define M_DEBUG_ST_EDMA1_ALIGN_SUB    0x7U
#define V_DEBUG_ST_EDMA1_ALIGN_SUB(x) ((x) << S_DEBUG_ST_EDMA1_ALIGN_SUB)
#define G_DEBUG_ST_EDMA1_ALIGN_SUB(x) (((x) >> S_DEBUG_ST_EDMA1_ALIGN_SUB) & M_DEBUG_ST_EDMA1_ALIGN_SUB)

#define S_DEBUG_ST_EDMA1_ALIGN    11
#define M_DEBUG_ST_EDMA1_ALIGN    0x3U
#define V_DEBUG_ST_EDMA1_ALIGN(x) ((x) << S_DEBUG_ST_EDMA1_ALIGN)
#define G_DEBUG_ST_EDMA1_ALIGN(x) (((x) >> S_DEBUG_ST_EDMA1_ALIGN) & M_DEBUG_ST_EDMA1_ALIGN)

#define S_DEBUG_ST_EDMA1_REQ    8
#define M_DEBUG_ST_EDMA1_REQ    0x7U
#define V_DEBUG_ST_EDMA1_REQ(x) ((x) << S_DEBUG_ST_EDMA1_REQ)
#define G_DEBUG_ST_EDMA1_REQ(x) (((x) >> S_DEBUG_ST_EDMA1_REQ) & M_DEBUG_ST_EDMA1_REQ)

#define S_DEBUG_ST_EDMA0_ALIGN_SUB    5
#define M_DEBUG_ST_EDMA0_ALIGN_SUB    0x7U
#define V_DEBUG_ST_EDMA0_ALIGN_SUB(x) ((x) << S_DEBUG_ST_EDMA0_ALIGN_SUB)
#define G_DEBUG_ST_EDMA0_ALIGN_SUB(x) (((x) >> S_DEBUG_ST_EDMA0_ALIGN_SUB) & M_DEBUG_ST_EDMA0_ALIGN_SUB)

#define S_DEBUG_ST_EDMA0_ALIGN    3
#define M_DEBUG_ST_EDMA0_ALIGN    0x3U
#define V_DEBUG_ST_EDMA0_ALIGN(x) ((x) << S_DEBUG_ST_EDMA0_ALIGN)
#define G_DEBUG_ST_EDMA0_ALIGN(x) (((x) >> S_DEBUG_ST_EDMA0_ALIGN) & M_DEBUG_ST_EDMA0_ALIGN)

#define S_DEBUG_ST_EDMA0_REQ    0
#define M_DEBUG_ST_EDMA0_REQ    0x7U
#define V_DEBUG_ST_EDMA0_REQ(x) ((x) << S_DEBUG_ST_EDMA0_REQ)
#define G_DEBUG_ST_EDMA0_REQ(x) (((x) >> S_DEBUG_ST_EDMA0_REQ) & M_DEBUG_ST_EDMA0_REQ)

#define A_SGE_DEBUG_DATA_LOW_INDEX_5 0x12d4

#define S_DEBUG_ST_FLM_DBPTR    30
#define M_DEBUG_ST_FLM_DBPTR    0x3U
#define V_DEBUG_ST_FLM_DBPTR(x) ((x) << S_DEBUG_ST_FLM_DBPTR)
#define G_DEBUG_ST_FLM_DBPTR(x) (((x) >> S_DEBUG_ST_FLM_DBPTR) & M_DEBUG_ST_FLM_DBPTR)

#define S_DEBUG_FLM_CACHE_LOCKED_COUNT    23
#define M_DEBUG_FLM_CACHE_LOCKED_COUNT    0x7fU
#define V_DEBUG_FLM_CACHE_LOCKED_COUNT(x) ((x) << S_DEBUG_FLM_CACHE_LOCKED_COUNT)
#define G_DEBUG_FLM_CACHE_LOCKED_COUNT(x) (((x) >> S_DEBUG_FLM_CACHE_LOCKED_COUNT) & M_DEBUG_FLM_CACHE_LOCKED_COUNT)

#define S_DEBUG_FLM_CACHE_AGENT    20
#define M_DEBUG_FLM_CACHE_AGENT    0x7U
#define V_DEBUG_FLM_CACHE_AGENT(x) ((x) << S_DEBUG_FLM_CACHE_AGENT)
#define G_DEBUG_FLM_CACHE_AGENT(x) (((x) >> S_DEBUG_FLM_CACHE_AGENT) & M_DEBUG_FLM_CACHE_AGENT)

#define S_DEBUG_ST_FLM_CACHE    16
#define M_DEBUG_ST_FLM_CACHE    0xfU
#define V_DEBUG_ST_FLM_CACHE(x) ((x) << S_DEBUG_ST_FLM_CACHE)
#define G_DEBUG_ST_FLM_CACHE(x) (((x) >> S_DEBUG_ST_FLM_CACHE) & M_DEBUG_ST_FLM_CACHE)

#define S_DEBUG_FLM_DBPTR_CIDX_STALL    12
#define V_DEBUG_FLM_DBPTR_CIDX_STALL(x) ((x) << S_DEBUG_FLM_DBPTR_CIDX_STALL)
#define F_DEBUG_FLM_DBPTR_CIDX_STALL    V_DEBUG_FLM_DBPTR_CIDX_STALL(1U)

#define S_DEBUG_FLM_DBPTR_QID    0
#define M_DEBUG_FLM_DBPTR_QID    0xfffU
#define V_DEBUG_FLM_DBPTR_QID(x) ((x) << S_DEBUG_FLM_DBPTR_QID)
#define G_DEBUG_FLM_DBPTR_QID(x) (((x) >> S_DEBUG_FLM_DBPTR_QID) & M_DEBUG_FLM_DBPTR_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_6 0x12d8

#define S_DEBUG_DBP_THREAD0_QID    0
#define M_DEBUG_DBP_THREAD0_QID    0x1ffffU
#define V_DEBUG_DBP_THREAD0_QID(x) ((x) << S_DEBUG_DBP_THREAD0_QID)
#define G_DEBUG_DBP_THREAD0_QID(x) (((x) >> S_DEBUG_DBP_THREAD0_QID) & M_DEBUG_DBP_THREAD0_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_7 0x12dc

#define S_DEBUG_DBP_THREAD1_QID    0
#define M_DEBUG_DBP_THREAD1_QID    0x1ffffU
#define V_DEBUG_DBP_THREAD1_QID(x) ((x) << S_DEBUG_DBP_THREAD1_QID)
#define G_DEBUG_DBP_THREAD1_QID(x) (((x) >> S_DEBUG_DBP_THREAD1_QID) & M_DEBUG_DBP_THREAD1_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_8 0x12e0

#define S_DEBUG_DBP_THREAD2_QID    0
#define M_DEBUG_DBP_THREAD2_QID    0x1ffffU
#define V_DEBUG_DBP_THREAD2_QID(x) ((x) << S_DEBUG_DBP_THREAD2_QID)
#define G_DEBUG_DBP_THREAD2_QID(x) (((x) >> S_DEBUG_DBP_THREAD2_QID) & M_DEBUG_DBP_THREAD2_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_9 0x12e4

#define S_DEBUG_DBP_THREAD3_QID    0
#define M_DEBUG_DBP_THREAD3_QID    0x1ffffU
#define V_DEBUG_DBP_THREAD3_QID(x) ((x) << S_DEBUG_DBP_THREAD3_QID)
#define G_DEBUG_DBP_THREAD3_QID(x) (((x) >> S_DEBUG_DBP_THREAD3_QID) & M_DEBUG_DBP_THREAD3_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_10 0x12e8

#define S_DEBUG_IMSG_CPL    16
#define M_DEBUG_IMSG_CPL    0xffU
#define V_DEBUG_IMSG_CPL(x) ((x) << S_DEBUG_IMSG_CPL)
#define G_DEBUG_IMSG_CPL(x) (((x) >> S_DEBUG_IMSG_CPL) & M_DEBUG_IMSG_CPL)

#define S_DEBUG_IMSG_QID    0
#define M_DEBUG_IMSG_QID    0xffffU
#define V_DEBUG_IMSG_QID(x) ((x) << S_DEBUG_IMSG_QID)
#define G_DEBUG_IMSG_QID(x) (((x) >> S_DEBUG_IMSG_QID) & M_DEBUG_IMSG_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_11 0x12ec

#define S_DEBUG_IDMA1_QID    16
#define M_DEBUG_IDMA1_QID    0xffffU
#define V_DEBUG_IDMA1_QID(x) ((x) << S_DEBUG_IDMA1_QID)
#define G_DEBUG_IDMA1_QID(x) (((x) >> S_DEBUG_IDMA1_QID) & M_DEBUG_IDMA1_QID)

#define S_DEBUG_IDMA0_QID    0
#define M_DEBUG_IDMA0_QID    0xffffU
#define V_DEBUG_IDMA0_QID(x) ((x) << S_DEBUG_IDMA0_QID)
#define G_DEBUG_IDMA0_QID(x) (((x) >> S_DEBUG_IDMA0_QID) & M_DEBUG_IDMA0_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_12 0x12f0

#define S_DEBUG_IDMA1_FLM_REQ_QID    16
#define M_DEBUG_IDMA1_FLM_REQ_QID    0xffffU
#define V_DEBUG_IDMA1_FLM_REQ_QID(x) ((x) << S_DEBUG_IDMA1_FLM_REQ_QID)
#define G_DEBUG_IDMA1_FLM_REQ_QID(x) (((x) >> S_DEBUG_IDMA1_FLM_REQ_QID) & M_DEBUG_IDMA1_FLM_REQ_QID)

#define S_DEBUG_IDMA0_FLM_REQ_QID    0
#define M_DEBUG_IDMA0_FLM_REQ_QID    0xffffU
#define V_DEBUG_IDMA0_FLM_REQ_QID(x) ((x) << S_DEBUG_IDMA0_FLM_REQ_QID)
#define G_DEBUG_IDMA0_FLM_REQ_QID(x) (((x) >> S_DEBUG_IDMA0_FLM_REQ_QID) & M_DEBUG_IDMA0_FLM_REQ_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_13 0x12f4
#define A_SGE_DEBUG_DATA_LOW_INDEX_14 0x12f8
#define A_SGE_DEBUG_DATA_LOW_INDEX_15 0x12fc
#define A_SGE_QUEUE_BASE_MAP_HIGH 0x1300

#define S_EGRESS_LOG2SIZE    27
#define M_EGRESS_LOG2SIZE    0x1fU
#define V_EGRESS_LOG2SIZE(x) ((x) << S_EGRESS_LOG2SIZE)
#define G_EGRESS_LOG2SIZE(x) (((x) >> S_EGRESS_LOG2SIZE) & M_EGRESS_LOG2SIZE)

#define S_EGRESS_BASE    10
#define M_EGRESS_BASE    0x1ffffU
#define V_EGRESS_BASE(x) ((x) << S_EGRESS_BASE)
#define G_EGRESS_BASE(x) (((x) >> S_EGRESS_BASE) & M_EGRESS_BASE)

#define S_INGRESS2_LOG2SIZE    5
#define M_INGRESS2_LOG2SIZE    0x1fU
#define V_INGRESS2_LOG2SIZE(x) ((x) << S_INGRESS2_LOG2SIZE)
#define G_INGRESS2_LOG2SIZE(x) (((x) >> S_INGRESS2_LOG2SIZE) & M_INGRESS2_LOG2SIZE)

#define S_INGRESS1_LOG2SIZE    0
#define M_INGRESS1_LOG2SIZE    0x1fU
#define V_INGRESS1_LOG2SIZE(x) ((x) << S_INGRESS1_LOG2SIZE)
#define G_INGRESS1_LOG2SIZE(x) (((x) >> S_INGRESS1_LOG2SIZE) & M_INGRESS1_LOG2SIZE)

#define S_EGRESS_SIZE    27
#define M_EGRESS_SIZE    0x1fU
#define V_EGRESS_SIZE(x) ((x) << S_EGRESS_SIZE)
#define G_EGRESS_SIZE(x) (((x) >> S_EGRESS_SIZE) & M_EGRESS_SIZE)

#define S_INGRESS2_SIZE    5
#define M_INGRESS2_SIZE    0x1fU
#define V_INGRESS2_SIZE(x) ((x) << S_INGRESS2_SIZE)
#define G_INGRESS2_SIZE(x) (((x) >> S_INGRESS2_SIZE) & M_INGRESS2_SIZE)

#define S_INGRESS1_SIZE    0
#define M_INGRESS1_SIZE    0x1fU
#define V_INGRESS1_SIZE(x) ((x) << S_INGRESS1_SIZE)
#define G_INGRESS1_SIZE(x) (((x) >> S_INGRESS1_SIZE) & M_INGRESS1_SIZE)

#define A_SGE_QUEUE_BASE_MAP_LOW 0x1304

#define S_INGRESS2_BASE    16
#define M_INGRESS2_BASE    0xffffU
#define V_INGRESS2_BASE(x) ((x) << S_INGRESS2_BASE)
#define G_INGRESS2_BASE(x) (((x) >> S_INGRESS2_BASE) & M_INGRESS2_BASE)

#define S_INGRESS1_BASE    0
#define M_INGRESS1_BASE    0xffffU
#define V_INGRESS1_BASE(x) ((x) << S_INGRESS1_BASE)
#define G_INGRESS1_BASE(x) (((x) >> S_INGRESS1_BASE) & M_INGRESS1_BASE)

#define A_SGE_LA_RDPTR_0 0x1800
#define A_SGE_LA_RDDATA_0 0x1804
#define A_SGE_LA_WRPTR_0 0x1808
#define A_SGE_LA_RESERVED_0 0x180c
#define A_SGE_LA_RDPTR_1 0x1810
#define A_SGE_LA_RDDATA_1 0x1814
#define A_SGE_LA_WRPTR_1 0x1818
#define A_SGE_LA_RESERVED_1 0x181c
#define A_SGE_LA_RDPTR_2 0x1820
#define A_SGE_LA_RDDATA_2 0x1824
#define A_SGE_LA_WRPTR_2 0x1828
#define A_SGE_LA_RESERVED_2 0x182c
#define A_SGE_LA_RDPTR_3 0x1830
#define A_SGE_LA_RDDATA_3 0x1834
#define A_SGE_LA_WRPTR_3 0x1838
#define A_SGE_LA_RESERVED_3 0x183c
#define A_SGE_LA_RDPTR_4 0x1840
#define A_SGE_LA_RDDATA_4 0x1844
#define A_SGE_LA_WRPTR_4 0x1848
#define A_SGE_LA_RESERVED_4 0x184c
#define A_SGE_LA_RDPTR_5 0x1850
#define A_SGE_LA_RDDATA_5 0x1854
#define A_SGE_LA_WRPTR_5 0x1858
#define A_SGE_LA_RESERVED_5 0x185c
#define A_SGE_LA_RDPTR_6 0x1860
#define A_SGE_LA_RDDATA_6 0x1864
#define A_SGE_LA_WRPTR_6 0x1868
#define A_SGE_LA_RESERVED_6 0x186c
#define A_SGE_LA_RDPTR_7 0x1870
#define A_SGE_LA_RDDATA_7 0x1874
#define A_SGE_LA_WRPTR_7 0x1878
#define A_SGE_LA_RESERVED_7 0x187c
#define A_SGE_LA_RDPTR_8 0x1880
#define A_SGE_LA_RDDATA_8 0x1884
#define A_SGE_LA_WRPTR_8 0x1888
#define A_SGE_LA_RESERVED_8 0x188c
#define A_SGE_LA_RDPTR_9 0x1890
#define A_SGE_LA_RDDATA_9 0x1894
#define A_SGE_LA_WRPTR_9 0x1898
#define A_SGE_LA_RESERVED_9 0x189c
#define A_SGE_LA_RDPTR_10 0x18a0
#define A_SGE_LA_RDDATA_10 0x18a4
#define A_SGE_LA_WRPTR_10 0x18a8
#define A_SGE_LA_RESERVED_10 0x18ac
#define A_SGE_LA_RDPTR_11 0x18b0
#define A_SGE_LA_RDDATA_11 0x18b4
#define A_SGE_LA_WRPTR_11 0x18b8
#define A_SGE_LA_RESERVED_11 0x18bc
#define A_SGE_LA_RDPTR_12 0x18c0
#define A_SGE_LA_RDDATA_12 0x18c4
#define A_SGE_LA_WRPTR_12 0x18c8
#define A_SGE_LA_RESERVED_12 0x18cc
#define A_SGE_LA_RDPTR_13 0x18d0
#define A_SGE_LA_RDDATA_13 0x18d4
#define A_SGE_LA_WRPTR_13 0x18d8
#define A_SGE_LA_RESERVED_13 0x18dc
#define A_SGE_LA_RDPTR_14 0x18e0
#define A_SGE_LA_RDDATA_14 0x18e4
#define A_SGE_LA_WRPTR_14 0x18e8
#define A_SGE_LA_RESERVED_14 0x18ec
#define A_SGE_LA_RDPTR_15 0x18f0
#define A_SGE_LA_RDDATA_15 0x18f4
#define A_SGE_LA_WRPTR_15 0x18f8
#define A_SGE_LA_RESERVED_15 0x18fc

/* registers for module PCIE */
#define PCIE_BASE_ADDR 0x3000

#define A_PCIE_PF_CFG 0x40

#define S_INTXSTAT    16
#define V_INTXSTAT(x) ((x) << S_INTXSTAT)
#define F_INTXSTAT    V_INTXSTAT(1U)

#define S_AUXPWRPMEN    15
#define V_AUXPWRPMEN(x) ((x) << S_AUXPWRPMEN)
#define F_AUXPWRPMEN    V_AUXPWRPMEN(1U)

#define S_NOSOFTRESET    14
#define V_NOSOFTRESET(x) ((x) << S_NOSOFTRESET)
#define F_NOSOFTRESET    V_NOSOFTRESET(1U)

#define S_AIVEC    4
#define M_AIVEC    0x3ffU
#define V_AIVEC(x) ((x) << S_AIVEC)
#define G_AIVEC(x) (((x) >> S_AIVEC) & M_AIVEC)

#define S_INTXTYPE    2
#define M_INTXTYPE    0x3U
#define V_INTXTYPE(x) ((x) << S_INTXTYPE)
#define G_INTXTYPE(x) (((x) >> S_INTXTYPE) & M_INTXTYPE)

#define S_D3HOTEN    1
#define V_D3HOTEN(x) ((x) << S_D3HOTEN)
#define F_D3HOTEN    V_D3HOTEN(1U)

#define S_CLIDECEN    0
#define V_CLIDECEN(x) ((x) << S_CLIDECEN)
#define F_CLIDECEN    V_CLIDECEN(1U)

#define A_PCIE_PF_CLI 0x44
#define A_PCIE_PF_GEN_MSG 0x48

#define S_MSGTYPE    0
#define M_MSGTYPE    0xffU
#define V_MSGTYPE(x) ((x) << S_MSGTYPE)
#define G_MSGTYPE(x) (((x) >> S_MSGTYPE) & M_MSGTYPE)

#define A_PCIE_PF_EXPROM_OFST 0x4c

#define S_OFFSET    10
#define M_OFFSET    0x3fffU
#define V_OFFSET(x) ((x) << S_OFFSET)
#define G_OFFSET(x) (((x) >> S_OFFSET) & M_OFFSET)

#define A_PCIE_INT_ENABLE 0x3000

#define S_NONFATALERR    30
#define V_NONFATALERR(x) ((x) << S_NONFATALERR)
#define F_NONFATALERR    V_NONFATALERR(1U)

#define S_UNXSPLCPLERR    29
#define V_UNXSPLCPLERR(x) ((x) << S_UNXSPLCPLERR)
#define F_UNXSPLCPLERR    V_UNXSPLCPLERR(1U)

#define S_PCIEPINT    28
#define V_PCIEPINT(x) ((x) << S_PCIEPINT)
#define F_PCIEPINT    V_PCIEPINT(1U)

#define S_PCIESINT    27
#define V_PCIESINT(x) ((x) << S_PCIESINT)
#define F_PCIESINT    V_PCIESINT(1U)

#define S_RPLPERR    26
#define V_RPLPERR(x) ((x) << S_RPLPERR)
#define F_RPLPERR    V_RPLPERR(1U)

#define S_RXWRPERR    25
#define V_RXWRPERR(x) ((x) << S_RXWRPERR)
#define F_RXWRPERR    V_RXWRPERR(1U)

#define S_RXCPLPERR    24
#define V_RXCPLPERR(x) ((x) << S_RXCPLPERR)
#define F_RXCPLPERR    V_RXCPLPERR(1U)

#define S_PIOTAGPERR    23
#define V_PIOTAGPERR(x) ((x) << S_PIOTAGPERR)
#define F_PIOTAGPERR    V_PIOTAGPERR(1U)

#define S_MATAGPERR    22
#define V_MATAGPERR(x) ((x) << S_MATAGPERR)
#define F_MATAGPERR    V_MATAGPERR(1U)

#define S_INTXCLRPERR    21
#define V_INTXCLRPERR(x) ((x) << S_INTXCLRPERR)
#define F_INTXCLRPERR    V_INTXCLRPERR(1U)

#define S_FIDPERR    20
#define V_FIDPERR(x) ((x) << S_FIDPERR)
#define F_FIDPERR    V_FIDPERR(1U)

#define S_CFGSNPPERR    19
#define V_CFGSNPPERR(x) ((x) << S_CFGSNPPERR)
#define F_CFGSNPPERR    V_CFGSNPPERR(1U)

#define S_HRSPPERR    18
#define V_HRSPPERR(x) ((x) << S_HRSPPERR)
#define F_HRSPPERR    V_HRSPPERR(1U)

#define S_HREQPERR    17
#define V_HREQPERR(x) ((x) << S_HREQPERR)
#define F_HREQPERR    V_HREQPERR(1U)

#define S_HCNTPERR    16
#define V_HCNTPERR(x) ((x) << S_HCNTPERR)
#define F_HCNTPERR    V_HCNTPERR(1U)

#define S_DRSPPERR    15
#define V_DRSPPERR(x) ((x) << S_DRSPPERR)
#define F_DRSPPERR    V_DRSPPERR(1U)

#define S_DREQPERR    14
#define V_DREQPERR(x) ((x) << S_DREQPERR)
#define F_DREQPERR    V_DREQPERR(1U)

#define S_DCNTPERR    13
#define V_DCNTPERR(x) ((x) << S_DCNTPERR)
#define F_DCNTPERR    V_DCNTPERR(1U)

#define S_CRSPPERR    12
#define V_CRSPPERR(x) ((x) << S_CRSPPERR)
#define F_CRSPPERR    V_CRSPPERR(1U)

#define S_CREQPERR    11
#define V_CREQPERR(x) ((x) << S_CREQPERR)
#define F_CREQPERR    V_CREQPERR(1U)

#define S_CCNTPERR    10
#define V_CCNTPERR(x) ((x) << S_CCNTPERR)
#define F_CCNTPERR    V_CCNTPERR(1U)

#define S_TARTAGPERR    9
#define V_TARTAGPERR(x) ((x) << S_TARTAGPERR)
#define F_TARTAGPERR    V_TARTAGPERR(1U)

#define S_PIOREQPERR    8
#define V_PIOREQPERR(x) ((x) << S_PIOREQPERR)
#define F_PIOREQPERR    V_PIOREQPERR(1U)

#define S_PIOCPLPERR    7
#define V_PIOCPLPERR(x) ((x) << S_PIOCPLPERR)
#define F_PIOCPLPERR    V_PIOCPLPERR(1U)

#define S_MSIXDIPERR    6
#define V_MSIXDIPERR(x) ((x) << S_MSIXDIPERR)
#define F_MSIXDIPERR    V_MSIXDIPERR(1U)

#define S_MSIXDATAPERR    5
#define V_MSIXDATAPERR(x) ((x) << S_MSIXDATAPERR)
#define F_MSIXDATAPERR    V_MSIXDATAPERR(1U)

#define S_MSIXADDRHPERR    4
#define V_MSIXADDRHPERR(x) ((x) << S_MSIXADDRHPERR)
#define F_MSIXADDRHPERR    V_MSIXADDRHPERR(1U)

#define S_MSIXADDRLPERR    3
#define V_MSIXADDRLPERR(x) ((x) << S_MSIXADDRLPERR)
#define F_MSIXADDRLPERR    V_MSIXADDRLPERR(1U)

#define S_MSIDATAPERR    2
#define V_MSIDATAPERR(x) ((x) << S_MSIDATAPERR)
#define F_MSIDATAPERR    V_MSIDATAPERR(1U)

#define S_MSIADDRHPERR    1
#define V_MSIADDRHPERR(x) ((x) << S_MSIADDRHPERR)
#define F_MSIADDRHPERR    V_MSIADDRHPERR(1U)

#define S_MSIADDRLPERR    0
#define V_MSIADDRLPERR(x) ((x) << S_MSIADDRLPERR)
#define F_MSIADDRLPERR    V_MSIADDRLPERR(1U)

#define S_IPGRPPERR    31
#define V_IPGRPPERR(x) ((x) << S_IPGRPPERR)
#define F_IPGRPPERR    V_IPGRPPERR(1U)

#define S_READRSPERR    29
#define V_READRSPERR(x) ((x) << S_READRSPERR)
#define F_READRSPERR    V_READRSPERR(1U)

#define S_TRGT1GRPPERR    28
#define V_TRGT1GRPPERR(x) ((x) << S_TRGT1GRPPERR)
#define F_TRGT1GRPPERR    V_TRGT1GRPPERR(1U)

#define S_IPSOTPERR    27
#define V_IPSOTPERR(x) ((x) << S_IPSOTPERR)
#define F_IPSOTPERR    V_IPSOTPERR(1U)

#define S_IPRETRYPERR    26
#define V_IPRETRYPERR(x) ((x) << S_IPRETRYPERR)
#define F_IPRETRYPERR    V_IPRETRYPERR(1U)

#define S_IPRXDATAGRPPERR    25
#define V_IPRXDATAGRPPERR(x) ((x) << S_IPRXDATAGRPPERR)
#define F_IPRXDATAGRPPERR    V_IPRXDATAGRPPERR(1U)

#define S_IPRXHDRGRPPERR    24
#define V_IPRXHDRGRPPERR(x) ((x) << S_IPRXHDRGRPPERR)
#define F_IPRXHDRGRPPERR    V_IPRXHDRGRPPERR(1U)

#define S_PIOTAGQPERR    23
#define V_PIOTAGQPERR(x) ((x) << S_PIOTAGQPERR)
#define F_PIOTAGQPERR    V_PIOTAGQPERR(1U)

#define S_MAGRPPERR    22
#define V_MAGRPPERR(x) ((x) << S_MAGRPPERR)
#define F_MAGRPPERR    V_MAGRPPERR(1U)

#define S_VFIDPERR    21
#define V_VFIDPERR(x) ((x) << S_VFIDPERR)
#define F_VFIDPERR    V_VFIDPERR(1U)

#define S_HREQRDPERR    17
#define V_HREQRDPERR(x) ((x) << S_HREQRDPERR)
#define F_HREQRDPERR    V_HREQRDPERR(1U)

#define S_HREQWRPERR    16
#define V_HREQWRPERR(x) ((x) << S_HREQWRPERR)
#define F_HREQWRPERR    V_HREQWRPERR(1U)

#define S_DREQRDPERR    14
#define V_DREQRDPERR(x) ((x) << S_DREQRDPERR)
#define F_DREQRDPERR    V_DREQRDPERR(1U)

#define S_DREQWRPERR    13
#define V_DREQWRPERR(x) ((x) << S_DREQWRPERR)
#define F_DREQWRPERR    V_DREQWRPERR(1U)

#define S_CREQRDPERR    11
#define V_CREQRDPERR(x) ((x) << S_CREQRDPERR)
#define F_CREQRDPERR    V_CREQRDPERR(1U)

#define S_MSTTAGQPERR    10
#define V_MSTTAGQPERR(x) ((x) << S_MSTTAGQPERR)
#define F_MSTTAGQPERR    V_MSTTAGQPERR(1U)

#define S_TGTTAGQPERR    9
#define V_TGTTAGQPERR(x) ((x) << S_TGTTAGQPERR)
#define F_TGTTAGQPERR    V_TGTTAGQPERR(1U)

#define S_PIOREQGRPPERR    8
#define V_PIOREQGRPPERR(x) ((x) << S_PIOREQGRPPERR)
#define F_PIOREQGRPPERR    V_PIOREQGRPPERR(1U)

#define S_PIOCPLGRPPERR    7
#define V_PIOCPLGRPPERR(x) ((x) << S_PIOCPLGRPPERR)
#define F_PIOCPLGRPPERR    V_PIOCPLGRPPERR(1U)

#define S_MSIXSTIPERR    2
#define V_MSIXSTIPERR(x) ((x) << S_MSIXSTIPERR)
#define F_MSIXSTIPERR    V_MSIXSTIPERR(1U)

#define S_MSTTIMEOUTPERR    1
#define V_MSTTIMEOUTPERR(x) ((x) << S_MSTTIMEOUTPERR)
#define F_MSTTIMEOUTPERR    V_MSTTIMEOUTPERR(1U)

#define S_MSTGRPPERR    0
#define V_MSTGRPPERR(x) ((x) << S_MSTGRPPERR)
#define F_MSTGRPPERR    V_MSTGRPPERR(1U)

#define A_PCIE_INT_CAUSE 0x3004
#define A_PCIE_PERR_ENABLE 0x3008
#define A_PCIE_PERR_INJECT 0x300c

#define S_IDE    0
#define V_IDE(x) ((x) << S_IDE)
#define F_IDE    V_IDE(1U)

#define A_PCIE_NONFAT_ERR 0x3010

#define S_RDRSPERR    9
#define V_RDRSPERR(x) ((x) << S_RDRSPERR)
#define F_RDRSPERR    V_RDRSPERR(1U)

#define S_VPDRSPERR    8
#define V_VPDRSPERR(x) ((x) << S_VPDRSPERR)
#define F_VPDRSPERR    V_VPDRSPERR(1U)

#define S_POPD    7
#define V_POPD(x) ((x) << S_POPD)
#define F_POPD    V_POPD(1U)

#define S_POPH    6
#define V_POPH(x) ((x) << S_POPH)
#define F_POPH    V_POPH(1U)

#define S_POPC    5
#define V_POPC(x) ((x) << S_POPC)
#define F_POPC    V_POPC(1U)

#define S_MEMREQ    4
#define V_MEMREQ(x) ((x) << S_MEMREQ)
#define F_MEMREQ    V_MEMREQ(1U)

#define S_PIOREQ    3
#define V_PIOREQ(x) ((x) << S_PIOREQ)
#define F_PIOREQ    V_PIOREQ(1U)

#define S_TAGDROP    2
#define V_TAGDROP(x) ((x) << S_TAGDROP)
#define F_TAGDROP    V_TAGDROP(1U)

#define S_TAGCPL    1
#define V_TAGCPL(x) ((x) << S_TAGCPL)
#define F_TAGCPL    V_TAGCPL(1U)

#define S_CFGSNP    0
#define V_CFGSNP(x) ((x) << S_CFGSNP)
#define F_CFGSNP    V_CFGSNP(1U)

#define S_MAREQTIMEOUT    29
#define V_MAREQTIMEOUT(x) ((x) << S_MAREQTIMEOUT)
#define F_MAREQTIMEOUT    V_MAREQTIMEOUT(1U)

#define S_TRGT1BARTYPEERR    28
#define V_TRGT1BARTYPEERR(x) ((x) << S_TRGT1BARTYPEERR)
#define F_TRGT1BARTYPEERR    V_TRGT1BARTYPEERR(1U)

#define S_MAEXTRARSPERR    27
#define V_MAEXTRARSPERR(x) ((x) << S_MAEXTRARSPERR)
#define F_MAEXTRARSPERR    V_MAEXTRARSPERR(1U)

#define S_MARSPTIMEOUT    26
#define V_MARSPTIMEOUT(x) ((x) << S_MARSPTIMEOUT)
#define F_MARSPTIMEOUT    V_MARSPTIMEOUT(1U)

#define S_INTVFALLMSIDISERR    25
#define V_INTVFALLMSIDISERR(x) ((x) << S_INTVFALLMSIDISERR)
#define F_INTVFALLMSIDISERR    V_INTVFALLMSIDISERR(1U)

#define S_INTVFRANGEERR    24
#define V_INTVFRANGEERR(x) ((x) << S_INTVFRANGEERR)
#define F_INTVFRANGEERR    V_INTVFRANGEERR(1U)

#define S_INTPLIRSPERR    23
#define V_INTPLIRSPERR(x) ((x) << S_INTPLIRSPERR)
#define F_INTPLIRSPERR    V_INTPLIRSPERR(1U)

#define S_MEMREQRDTAGERR    22
#define V_MEMREQRDTAGERR(x) ((x) << S_MEMREQRDTAGERR)
#define F_MEMREQRDTAGERR    V_MEMREQRDTAGERR(1U)

#define S_CFGINITDONEERR    21
#define V_CFGINITDONEERR(x) ((x) << S_CFGINITDONEERR)
#define F_CFGINITDONEERR    V_CFGINITDONEERR(1U)

#define S_BAR2TIMEOUT    20
#define V_BAR2TIMEOUT(x) ((x) << S_BAR2TIMEOUT)
#define F_BAR2TIMEOUT    V_BAR2TIMEOUT(1U)

#define S_VPDTIMEOUT    19
#define V_VPDTIMEOUT(x) ((x) << S_VPDTIMEOUT)
#define F_VPDTIMEOUT    V_VPDTIMEOUT(1U)

#define S_MEMRSPRDTAGERR    18
#define V_MEMRSPRDTAGERR(x) ((x) << S_MEMRSPRDTAGERR)
#define F_MEMRSPRDTAGERR    V_MEMRSPRDTAGERR(1U)

#define S_MEMRSPWRTAGERR    17
#define V_MEMRSPWRTAGERR(x) ((x) << S_MEMRSPWRTAGERR)
#define F_MEMRSPWRTAGERR    V_MEMRSPWRTAGERR(1U)

#define S_PIORSPRDTAGERR    16
#define V_PIORSPRDTAGERR(x) ((x) << S_PIORSPRDTAGERR)
#define F_PIORSPRDTAGERR    V_PIORSPRDTAGERR(1U)

#define S_PIORSPWRTAGERR    15
#define V_PIORSPWRTAGERR(x) ((x) << S_PIORSPWRTAGERR)
#define F_PIORSPWRTAGERR    V_PIORSPWRTAGERR(1U)

#define S_DBITIMEOUT    14
#define V_DBITIMEOUT(x) ((x) << S_DBITIMEOUT)
#define F_DBITIMEOUT    V_DBITIMEOUT(1U)

#define S_PIOUNALINDWR    13
#define V_PIOUNALINDWR(x) ((x) << S_PIOUNALINDWR)
#define F_PIOUNALINDWR    V_PIOUNALINDWR(1U)

#define S_BAR2RDERR    12
#define V_BAR2RDERR(x) ((x) << S_BAR2RDERR)
#define F_BAR2RDERR    V_BAR2RDERR(1U)

#define S_MAWREOPERR    11
#define V_MAWREOPERR(x) ((x) << S_MAWREOPERR)
#define F_MAWREOPERR    V_MAWREOPERR(1U)

#define S_MARDEOPERR    10
#define V_MARDEOPERR(x) ((x) << S_MARDEOPERR)
#define F_MARDEOPERR    V_MARDEOPERR(1U)

#define S_BAR2REQ    2
#define V_BAR2REQ(x) ((x) << S_BAR2REQ)
#define F_BAR2REQ    V_BAR2REQ(1U)

#define A_PCIE_CFG 0x3014

#define S_CFGDMAXPYLDSZRX    26
#define M_CFGDMAXPYLDSZRX    0x7U
#define V_CFGDMAXPYLDSZRX(x) ((x) << S_CFGDMAXPYLDSZRX)
#define G_CFGDMAXPYLDSZRX(x) (((x) >> S_CFGDMAXPYLDSZRX) & M_CFGDMAXPYLDSZRX)

#define S_CFGDMAXPYLDSZTX    23
#define M_CFGDMAXPYLDSZTX    0x7U
#define V_CFGDMAXPYLDSZTX(x) ((x) << S_CFGDMAXPYLDSZTX)
#define G_CFGDMAXPYLDSZTX(x) (((x) >> S_CFGDMAXPYLDSZTX) & M_CFGDMAXPYLDSZTX)

#define S_CFGDMAXRDREQSZ    20
#define M_CFGDMAXRDREQSZ    0x7U
#define V_CFGDMAXRDREQSZ(x) ((x) << S_CFGDMAXRDREQSZ)
#define G_CFGDMAXRDREQSZ(x) (((x) >> S_CFGDMAXRDREQSZ) & M_CFGDMAXRDREQSZ)

#define S_MASYNCEN    19
#define V_MASYNCEN(x) ((x) << S_MASYNCEN)
#define F_MASYNCEN    V_MASYNCEN(1U)

#define S_DCAENDMA    18
#define V_DCAENDMA(x) ((x) << S_DCAENDMA)
#define F_DCAENDMA    V_DCAENDMA(1U)

#define S_DCAENCMD    17
#define V_DCAENCMD(x) ((x) << S_DCAENCMD)
#define F_DCAENCMD    V_DCAENCMD(1U)

#define S_VFMSIPNDEN    16
#define V_VFMSIPNDEN(x) ((x) << S_VFMSIPNDEN)
#define F_VFMSIPNDEN    V_VFMSIPNDEN(1U)

#define S_FORCETXERROR    15
#define V_FORCETXERROR(x) ((x) << S_FORCETXERROR)
#define F_FORCETXERROR    V_FORCETXERROR(1U)

#define S_VPDREQPROTECT    14
#define V_VPDREQPROTECT(x) ((x) << S_VPDREQPROTECT)
#define F_VPDREQPROTECT    V_VPDREQPROTECT(1U)

#define S_FIDTABLEINVALID    13
#define V_FIDTABLEINVALID(x) ((x) << S_FIDTABLEINVALID)
#define F_FIDTABLEINVALID    V_FIDTABLEINVALID(1U)

#define S_BYPASSMSIXCACHE    12
#define V_BYPASSMSIXCACHE(x) ((x) << S_BYPASSMSIXCACHE)
#define F_BYPASSMSIXCACHE    V_BYPASSMSIXCACHE(1U)

#define S_BYPASSMSICACHE    11
#define V_BYPASSMSICACHE(x) ((x) << S_BYPASSMSICACHE)
#define F_BYPASSMSICACHE    V_BYPASSMSICACHE(1U)

#define S_SIMSPEED    10
#define V_SIMSPEED(x) ((x) << S_SIMSPEED)
#define F_SIMSPEED    V_SIMSPEED(1U)

#define S_TC0_STAMP    9
#define V_TC0_STAMP(x) ((x) << S_TC0_STAMP)
#define F_TC0_STAMP    V_TC0_STAMP(1U)

#define S_AI_TCVAL    6
#define M_AI_TCVAL    0x7U
#define V_AI_TCVAL(x) ((x) << S_AI_TCVAL)
#define G_AI_TCVAL(x) (((x) >> S_AI_TCVAL) & M_AI_TCVAL)

#define S_DMASTOPEN    5
#define V_DMASTOPEN(x) ((x) << S_DMASTOPEN)
#define F_DMASTOPEN    V_DMASTOPEN(1U)

#define S_DEVSTATERSTMODE    4
#define V_DEVSTATERSTMODE(x) ((x) << S_DEVSTATERSTMODE)
#define F_DEVSTATERSTMODE    V_DEVSTATERSTMODE(1U)

#define S_HOTRSTPCIECRSTMODE    3
#define V_HOTRSTPCIECRSTMODE(x) ((x) << S_HOTRSTPCIECRSTMODE)
#define F_HOTRSTPCIECRSTMODE    V_HOTRSTPCIECRSTMODE(1U)

#define S_DLDNPCIECRSTMODE    2
#define V_DLDNPCIECRSTMODE(x) ((x) << S_DLDNPCIECRSTMODE)
#define F_DLDNPCIECRSTMODE    V_DLDNPCIECRSTMODE(1U)

#define S_DLDNPCIEPRECRSTMODE    1
#define V_DLDNPCIEPRECRSTMODE(x) ((x) << S_DLDNPCIEPRECRSTMODE)
#define F_DLDNPCIEPRECRSTMODE    V_DLDNPCIEPRECRSTMODE(1U)

#define S_LINKDNRSTEN    0
#define V_LINKDNRSTEN(x) ((x) << S_LINKDNRSTEN)
#define F_LINKDNRSTEN    V_LINKDNRSTEN(1U)

#define S_DIAGCTRLBUS    28
#define M_DIAGCTRLBUS    0x7U
#define V_DIAGCTRLBUS(x) ((x) << S_DIAGCTRLBUS)
#define G_DIAGCTRLBUS(x) (((x) >> S_DIAGCTRLBUS) & M_DIAGCTRLBUS)

#define S_IPPERREN    27
#define V_IPPERREN(x) ((x) << S_IPPERREN)
#define F_IPPERREN    V_IPPERREN(1U)

#define S_CFGDEXTTAGEN    26
#define V_CFGDEXTTAGEN(x) ((x) << S_CFGDEXTTAGEN)
#define F_CFGDEXTTAGEN    V_CFGDEXTTAGEN(1U)

#define S_CFGDMAXPYLDSZ    23
#define M_CFGDMAXPYLDSZ    0x7U
#define V_CFGDMAXPYLDSZ(x) ((x) << S_CFGDMAXPYLDSZ)
#define G_CFGDMAXPYLDSZ(x) (((x) >> S_CFGDMAXPYLDSZ) & M_CFGDMAXPYLDSZ)

#define S_DCAEN    17
#define V_DCAEN(x) ((x) << S_DCAEN)
#define F_DCAEN    V_DCAEN(1U)

#define S_T5CMDREQPRIORITY    16
#define V_T5CMDREQPRIORITY(x) ((x) << S_T5CMDREQPRIORITY)
#define F_T5CMDREQPRIORITY    V_T5CMDREQPRIORITY(1U)

#define S_T5VPDREQPROTECT    14
#define M_T5VPDREQPROTECT    0x3U
#define V_T5VPDREQPROTECT(x) ((x) << S_T5VPDREQPROTECT)
#define G_T5VPDREQPROTECT(x) (((x) >> S_T5VPDREQPROTECT) & M_T5VPDREQPROTECT)

#define S_DROPPEDRDRSPDATA    12
#define V_DROPPEDRDRSPDATA(x) ((x) << S_DROPPEDRDRSPDATA)
#define F_DROPPEDRDRSPDATA    V_DROPPEDRDRSPDATA(1U)

#define S_AI_INTX_REASSERTEN    11
#define V_AI_INTX_REASSERTEN(x) ((x) << S_AI_INTX_REASSERTEN)
#define F_AI_INTX_REASSERTEN    V_AI_INTX_REASSERTEN(1U)

#define S_AUTOTXNDISABLE    10
#define V_AUTOTXNDISABLE(x) ((x) << S_AUTOTXNDISABLE)
#define F_AUTOTXNDISABLE    V_AUTOTXNDISABLE(1U)

#define S_LINKREQRSTPCIECRSTMODE    3
#define V_LINKREQRSTPCIECRSTMODE(x) ((x) << S_LINKREQRSTPCIECRSTMODE)
#define F_LINKREQRSTPCIECRSTMODE    V_LINKREQRSTPCIECRSTMODE(1U)

#define A_PCIE_DMA_CTRL 0x3018

#define S_LITTLEENDIAN    7
#define V_LITTLEENDIAN(x) ((x) << S_LITTLEENDIAN)
#define F_LITTLEENDIAN    V_LITTLEENDIAN(1U)

#define A_PCIE_CFG2 0x3018

#define S_VPDTIMER    16
#define M_VPDTIMER    0xffffU
#define V_VPDTIMER(x) ((x) << S_VPDTIMER)
#define G_VPDTIMER(x) (((x) >> S_VPDTIMER) & M_VPDTIMER)

#define S_BAR2TIMER    4
#define M_BAR2TIMER    0xfffU
#define V_BAR2TIMER(x) ((x) << S_BAR2TIMER)
#define G_BAR2TIMER(x) (((x) >> S_BAR2TIMER) & M_BAR2TIMER)

#define S_MSTREQRDRRASIMPLE    3
#define V_MSTREQRDRRASIMPLE(x) ((x) << S_MSTREQRDRRASIMPLE)
#define F_MSTREQRDRRASIMPLE    V_MSTREQRDRRASIMPLE(1U)

#define S_TOTMAXTAG    0
#define M_TOTMAXTAG    0x3U
#define V_TOTMAXTAG(x) ((x) << S_TOTMAXTAG)
#define G_TOTMAXTAG(x) (((x) >> S_TOTMAXTAG) & M_TOTMAXTAG)

#define A_PCIE_DMA_CFG 0x301c

#define S_MAXPYLDSIZE    28
#define M_MAXPYLDSIZE    0x7U
#define V_MAXPYLDSIZE(x) ((x) << S_MAXPYLDSIZE)
#define G_MAXPYLDSIZE(x) (((x) >> S_MAXPYLDSIZE) & M_MAXPYLDSIZE)

#define S_MAXRDREQSIZE    25
#define M_MAXRDREQSIZE    0x7U
#define V_MAXRDREQSIZE(x) ((x) << S_MAXRDREQSIZE)
#define G_MAXRDREQSIZE(x) (((x) >> S_MAXRDREQSIZE) & M_MAXRDREQSIZE)

#define S_DMA_MAXRSPCNT    16
#define M_DMA_MAXRSPCNT    0x1ffU
#define V_DMA_MAXRSPCNT(x) ((x) << S_DMA_MAXRSPCNT)
#define G_DMA_MAXRSPCNT(x) (((x) >> S_DMA_MAXRSPCNT) & M_DMA_MAXRSPCNT)

#define S_DMA_MAXREQCNT    8
#define M_DMA_MAXREQCNT    0xffU
#define V_DMA_MAXREQCNT(x) ((x) << S_DMA_MAXREQCNT)
#define G_DMA_MAXREQCNT(x) (((x) >> S_DMA_MAXREQCNT) & M_DMA_MAXREQCNT)

#define S_MAXTAG    0
#define M_MAXTAG    0x7fU
#define V_MAXTAG(x) ((x) << S_MAXTAG)
#define G_MAXTAG(x) (((x) >> S_MAXTAG) & M_MAXTAG)

#define A_PCIE_CFG3 0x301c

#define S_AUTOPIOCOOKIEMATCH    6
#define V_AUTOPIOCOOKIEMATCH(x) ((x) << S_AUTOPIOCOOKIEMATCH)
#define F_AUTOPIOCOOKIEMATCH    V_AUTOPIOCOOKIEMATCH(1U)

#define S_FLRPNDCPLMODE    4
#define M_FLRPNDCPLMODE    0x3U
#define V_FLRPNDCPLMODE(x) ((x) << S_FLRPNDCPLMODE)
#define G_FLRPNDCPLMODE(x) (((x) >> S_FLRPNDCPLMODE) & M_FLRPNDCPLMODE)

#define S_HMADCASTFIRSTONLY    2
#define V_HMADCASTFIRSTONLY(x) ((x) << S_HMADCASTFIRSTONLY)
#define F_HMADCASTFIRSTONLY    V_HMADCASTFIRSTONLY(1U)

#define S_CMDDCASTFIRSTONLY    1
#define V_CMDDCASTFIRSTONLY(x) ((x) << S_CMDDCASTFIRSTONLY)
#define F_CMDDCASTFIRSTONLY    V_CMDDCASTFIRSTONLY(1U)

#define S_DMADCASTFIRSTONLY    0
#define V_DMADCASTFIRSTONLY(x) ((x) << S_DMADCASTFIRSTONLY)
#define F_DMADCASTFIRSTONLY    V_DMADCASTFIRSTONLY(1U)

#define A_PCIE_DMA_STAT 0x3020

#define S_STATEREQ    28
#define M_STATEREQ    0xfU
#define V_STATEREQ(x) ((x) << S_STATEREQ)
#define G_STATEREQ(x) (((x) >> S_STATEREQ) & M_STATEREQ)

#define S_DMA_RSPCNT    16
#define M_DMA_RSPCNT    0xfffU
#define V_DMA_RSPCNT(x) ((x) << S_DMA_RSPCNT)
#define G_DMA_RSPCNT(x) (((x) >> S_DMA_RSPCNT) & M_DMA_RSPCNT)

#define S_STATEAREQ    13
#define M_STATEAREQ    0x7U
#define V_STATEAREQ(x) ((x) << S_STATEAREQ)
#define G_STATEAREQ(x) (((x) >> S_STATEAREQ) & M_STATEAREQ)

#define S_TAGFREE    12
#define V_TAGFREE(x) ((x) << S_TAGFREE)
#define F_TAGFREE    V_TAGFREE(1U)

#define S_DMA_REQCNT    0
#define M_DMA_REQCNT    0x7ffU
#define V_DMA_REQCNT(x) ((x) << S_DMA_REQCNT)
#define G_DMA_REQCNT(x) (((x) >> S_DMA_REQCNT) & M_DMA_REQCNT)

#define A_PCIE_CFG4 0x3020

#define S_L1CLKREMOVALEN    17
#define V_L1CLKREMOVALEN(x) ((x) << S_L1CLKREMOVALEN)
#define F_L1CLKREMOVALEN    V_L1CLKREMOVALEN(1U)

#define S_READYENTERL23    16
#define V_READYENTERL23(x) ((x) << S_READYENTERL23)
#define F_READYENTERL23    V_READYENTERL23(1U)

#define S_EXITL1    12
#define V_EXITL1(x) ((x) << S_EXITL1)
#define F_EXITL1    V_EXITL1(1U)

#define S_ENTERL1    8
#define V_ENTERL1(x) ((x) << S_ENTERL1)
#define F_ENTERL1    V_ENTERL1(1U)

#define S_GENPME    0
#define M_GENPME    0xffU
#define V_GENPME(x) ((x) << S_GENPME)
#define G_GENPME(x) (((x) >> S_GENPME) & M_GENPME)

#define A_PCIE_CFG5 0x3024

#define S_ENABLESKPPARITYFIX    2
#define V_ENABLESKPPARITYFIX(x) ((x) << S_ENABLESKPPARITYFIX)
#define F_ENABLESKPPARITYFIX    V_ENABLESKPPARITYFIX(1U)

#define S_ENABLEL2ENTRYINL1    1
#define V_ENABLEL2ENTRYINL1(x) ((x) << S_ENABLEL2ENTRYINL1)
#define F_ENABLEL2ENTRYINL1    V_ENABLEL2ENTRYINL1(1U)

#define S_HOLDCPLENTERINGL1    0
#define V_HOLDCPLENTERINGL1(x) ((x) << S_HOLDCPLENTERINGL1)
#define F_HOLDCPLENTERINGL1    V_HOLDCPLENTERINGL1(1U)

#define A_PCIE_CFG6 0x3028

#define S_PERSTTIMERCOUNT    12
#define M_PERSTTIMERCOUNT    0x3fffU
#define V_PERSTTIMERCOUNT(x) ((x) << S_PERSTTIMERCOUNT)
#define G_PERSTTIMERCOUNT(x) (((x) >> S_PERSTTIMERCOUNT) & M_PERSTTIMERCOUNT)

#define S_PERSTTIMEOUT    8
#define V_PERSTTIMEOUT(x) ((x) << S_PERSTTIMEOUT)
#define F_PERSTTIMEOUT    V_PERSTTIMEOUT(1U)

#define S_PERSTTIMER    0
#define M_PERSTTIMER    0xfU
#define V_PERSTTIMER(x) ((x) << S_PERSTTIMER)
#define G_PERSTTIMER(x) (((x) >> S_PERSTTIMER) & M_PERSTTIMER)

#define A_PCIE_CMD_CTRL 0x303c
#define A_PCIE_CMD_CFG 0x3040

#define S_MAXRSPCNT    16
#define M_MAXRSPCNT    0xfU
#define V_MAXRSPCNT(x) ((x) << S_MAXRSPCNT)
#define G_MAXRSPCNT(x) (((x) >> S_MAXRSPCNT) & M_MAXRSPCNT)

#define S_MAXREQCNT    8
#define M_MAXREQCNT    0x1fU
#define V_MAXREQCNT(x) ((x) << S_MAXREQCNT)
#define G_MAXREQCNT(x) (((x) >> S_MAXREQCNT) & M_MAXREQCNT)

#define A_PCIE_CMD_STAT 0x3044

#define S_RSPCNT    16
#define M_RSPCNT    0x7fU
#define V_RSPCNT(x) ((x) << S_RSPCNT)
#define G_RSPCNT(x) (((x) >> S_RSPCNT) & M_RSPCNT)

#define S_REQCNT    0
#define M_REQCNT    0xffU
#define V_REQCNT(x) ((x) << S_REQCNT)
#define G_REQCNT(x) (((x) >> S_REQCNT) & M_REQCNT)

#define A_PCIE_HMA_CTRL 0x3050

#define S_IPLTSSM    12
#define M_IPLTSSM    0xfU
#define V_IPLTSSM(x) ((x) << S_IPLTSSM)
#define G_IPLTSSM(x) (((x) >> S_IPLTSSM) & M_IPLTSSM)

#define S_IPCONFIGDOWN    8
#define M_IPCONFIGDOWN    0x7U
#define V_IPCONFIGDOWN(x) ((x) << S_IPCONFIGDOWN)
#define G_IPCONFIGDOWN(x) (((x) >> S_IPCONFIGDOWN) & M_IPCONFIGDOWN)

#define A_PCIE_HMA_CFG 0x3054

#define S_HMA_MAXRSPCNT    16
#define M_HMA_MAXRSPCNT    0x1fU
#define V_HMA_MAXRSPCNT(x) ((x) << S_HMA_MAXRSPCNT)
#define G_HMA_MAXRSPCNT(x) (((x) >> S_HMA_MAXRSPCNT) & M_HMA_MAXRSPCNT)

#define A_PCIE_HMA_STAT 0x3058

#define S_HMA_RSPCNT    16
#define M_HMA_RSPCNT    0xffU
#define V_HMA_RSPCNT(x) ((x) << S_HMA_RSPCNT)
#define G_HMA_RSPCNT(x) (((x) >> S_HMA_RSPCNT) & M_HMA_RSPCNT)

#define A_PCIE_PIO_FIFO_CFG 0x305c

#define S_CPLCONFIG    16
#define M_CPLCONFIG    0xffffU
#define V_CPLCONFIG(x) ((x) << S_CPLCONFIG)
#define G_CPLCONFIG(x) (((x) >> S_CPLCONFIG) & M_CPLCONFIG)

#define S_PIOSTOPEN    12
#define V_PIOSTOPEN(x) ((x) << S_PIOSTOPEN)
#define F_PIOSTOPEN    V_PIOSTOPEN(1U)

#define S_IPLANESWAP    11
#define V_IPLANESWAP(x) ((x) << S_IPLANESWAP)
#define F_IPLANESWAP    V_IPLANESWAP(1U)

#define S_FORCESTRICTTS1    10
#define V_FORCESTRICTTS1(x) ((x) << S_FORCESTRICTTS1)
#define F_FORCESTRICTTS1    V_FORCESTRICTTS1(1U)

#define S_FORCEPROGRESSCNT    0
#define M_FORCEPROGRESSCNT    0x3ffU
#define V_FORCEPROGRESSCNT(x) ((x) << S_FORCEPROGRESSCNT)
#define G_FORCEPROGRESSCNT(x) (((x) >> S_FORCEPROGRESSCNT) & M_FORCEPROGRESSCNT)

#define A_PCIE_CFG_SPACE_REQ 0x3060

#define S_ENABLE    30
#define V_ENABLE(x) ((x) << S_ENABLE)
#define F_ENABLE    V_ENABLE(1U)

#define S_AI    29
#define V_AI(x) ((x) << S_AI)
#define F_AI    V_AI(1U)

#define S_LOCALCFG    28
#define V_LOCALCFG(x) ((x) << S_LOCALCFG)
#define F_LOCALCFG    V_LOCALCFG(1U)

#define S_BUS    20
#define M_BUS    0xffU
#define V_BUS(x) ((x) << S_BUS)
#define G_BUS(x) (((x) >> S_BUS) & M_BUS)

#define S_DEVICE    15
#define M_DEVICE    0x1fU
#define V_DEVICE(x) ((x) << S_DEVICE)
#define G_DEVICE(x) (((x) >> S_DEVICE) & M_DEVICE)

#define S_FUNCTION    12
#define M_FUNCTION    0x7U
#define V_FUNCTION(x) ((x) << S_FUNCTION)
#define G_FUNCTION(x) (((x) >> S_FUNCTION) & M_FUNCTION)

#define S_EXTREGISTER    8
#define M_EXTREGISTER    0xfU
#define V_EXTREGISTER(x) ((x) << S_EXTREGISTER)
#define G_EXTREGISTER(x) (((x) >> S_EXTREGISTER) & M_EXTREGISTER)

#define S_REGISTER    0
#define M_REGISTER    0xffU
#define V_REGISTER(x) ((x) << S_REGISTER)
#define G_REGISTER(x) (((x) >> S_REGISTER) & M_REGISTER)

#define S_CS2    28
#define V_CS2(x) ((x) << S_CS2)
#define F_CS2    V_CS2(1U)

#define S_WRBE    24
#define M_WRBE    0xfU
#define V_WRBE(x) ((x) << S_WRBE)
#define G_WRBE(x) (((x) >> S_WRBE) & M_WRBE)

#define S_CFG_SPACE_VFVLD    23
#define V_CFG_SPACE_VFVLD(x) ((x) << S_CFG_SPACE_VFVLD)
#define F_CFG_SPACE_VFVLD    V_CFG_SPACE_VFVLD(1U)

#define S_CFG_SPACE_RVF    16
#define M_CFG_SPACE_RVF    0x7fU
#define V_CFG_SPACE_RVF(x) ((x) << S_CFG_SPACE_RVF)
#define G_CFG_SPACE_RVF(x) (((x) >> S_CFG_SPACE_RVF) & M_CFG_SPACE_RVF)

#define S_CFG_SPACE_PF    12
#define M_CFG_SPACE_PF    0x7U
#define V_CFG_SPACE_PF(x) ((x) << S_CFG_SPACE_PF)
#define G_CFG_SPACE_PF(x) (((x) >> S_CFG_SPACE_PF) & M_CFG_SPACE_PF)

#define A_PCIE_CFG_SPACE_DATA 0x3064
#define A_PCIE_MEM_ACCESS_BASE_WIN 0x3068

#define S_PCIEOFST    10
#define M_PCIEOFST    0x3fffffU
#define V_PCIEOFST(x) ((x) << S_PCIEOFST)
#define G_PCIEOFST(x) (((x) >> S_PCIEOFST) & M_PCIEOFST)

#define S_BIR    8
#define M_BIR    0x3U
#define V_BIR(x) ((x) << S_BIR)
#define G_BIR(x) (((x) >> S_BIR) & M_BIR)

#define S_WINDOW    0
#define M_WINDOW    0xffU
#define V_WINDOW(x) ((x) << S_WINDOW)
#define G_WINDOW(x) (((x) >> S_WINDOW) & M_WINDOW)

#define A_PCIE_MEM_ACCESS_OFFSET 0x306c

#define S_MEMOFST    7
#define M_MEMOFST    0x1ffffffU
#define V_MEMOFST(x) ((x) << S_MEMOFST)
#define G_MEMOFST(x) (((x) >> S_MEMOFST) & M_MEMOFST)

#define A_PCIE_MAILBOX_BASE_WIN 0x30a8

#define S_MBOXPCIEOFST    6
#define M_MBOXPCIEOFST    0x3ffffffU
#define V_MBOXPCIEOFST(x) ((x) << S_MBOXPCIEOFST)
#define G_MBOXPCIEOFST(x) (((x) >> S_MBOXPCIEOFST) & M_MBOXPCIEOFST)

#define S_MBOXBIR    4
#define M_MBOXBIR    0x3U
#define V_MBOXBIR(x) ((x) << S_MBOXBIR)
#define G_MBOXBIR(x) (((x) >> S_MBOXBIR) & M_MBOXBIR)

#define S_MBOXWIN    0
#define M_MBOXWIN    0x3U
#define V_MBOXWIN(x) ((x) << S_MBOXWIN)
#define G_MBOXWIN(x) (((x) >> S_MBOXWIN) & M_MBOXWIN)

#define A_PCIE_MAILBOX_OFFSET 0x30ac
#define A_PCIE_MA_CTRL 0x30b0

#define S_MA_TAGFREE    29
#define V_MA_TAGFREE(x) ((x) << S_MA_TAGFREE)
#define F_MA_TAGFREE    V_MA_TAGFREE(1U)

#define S_MA_MAXRSPCNT    24
#define M_MA_MAXRSPCNT    0x1fU
#define V_MA_MAXRSPCNT(x) ((x) << S_MA_MAXRSPCNT)
#define G_MA_MAXRSPCNT(x) (((x) >> S_MA_MAXRSPCNT) & M_MA_MAXRSPCNT)

#define S_MA_MAXREQCNT    16
#define M_MA_MAXREQCNT    0x1fU
#define V_MA_MAXREQCNT(x) ((x) << S_MA_MAXREQCNT)
#define G_MA_MAXREQCNT(x) (((x) >> S_MA_MAXREQCNT) & M_MA_MAXREQCNT)

#define S_MA_LE    15
#define V_MA_LE(x) ((x) << S_MA_LE)
#define F_MA_LE    V_MA_LE(1U)

#define S_MA_MAXPYLDSIZE    12
#define M_MA_MAXPYLDSIZE    0x7U
#define V_MA_MAXPYLDSIZE(x) ((x) << S_MA_MAXPYLDSIZE)
#define G_MA_MAXPYLDSIZE(x) (((x) >> S_MA_MAXPYLDSIZE) & M_MA_MAXPYLDSIZE)

#define S_MA_MAXRDREQSIZE    8
#define M_MA_MAXRDREQSIZE    0x7U
#define V_MA_MAXRDREQSIZE(x) ((x) << S_MA_MAXRDREQSIZE)
#define G_MA_MAXRDREQSIZE(x) (((x) >> S_MA_MAXRDREQSIZE) & M_MA_MAXRDREQSIZE)

#define S_MA_MAXTAG    0
#define M_MA_MAXTAG    0x1fU
#define V_MA_MAXTAG(x) ((x) << S_MA_MAXTAG)
#define G_MA_MAXTAG(x) (((x) >> S_MA_MAXTAG) & M_MA_MAXTAG)

#define S_T5_MA_MAXREQCNT    16
#define M_T5_MA_MAXREQCNT    0x7fU
#define V_T5_MA_MAXREQCNT(x) ((x) << S_T5_MA_MAXREQCNT)
#define G_T5_MA_MAXREQCNT(x) (((x) >> S_T5_MA_MAXREQCNT) & M_T5_MA_MAXREQCNT)

#define S_MA_MAXREQSIZE    8
#define M_MA_MAXREQSIZE    0x7U
#define V_MA_MAXREQSIZE(x) ((x) << S_MA_MAXREQSIZE)
#define G_MA_MAXREQSIZE(x) (((x) >> S_MA_MAXREQSIZE) & M_MA_MAXREQSIZE)

#define A_PCIE_MA_SYNC 0x30b4
#define A_PCIE_FW 0x30b8
#define A_PCIE_FW_PF 0x30bc
#define A_PCIE_PIO_PAUSE 0x30dc

#define S_PIOPAUSEDONE    31
#define V_PIOPAUSEDONE(x) ((x) << S_PIOPAUSEDONE)
#define F_PIOPAUSEDONE    V_PIOPAUSEDONE(1U)

#define S_PIOPAUSETIME    4
#define M_PIOPAUSETIME    0xffffffU
#define V_PIOPAUSETIME(x) ((x) << S_PIOPAUSETIME)
#define G_PIOPAUSETIME(x) (((x) >> S_PIOPAUSETIME) & M_PIOPAUSETIME)

#define S_PIOPAUSE    0
#define V_PIOPAUSE(x) ((x) << S_PIOPAUSE)
#define F_PIOPAUSE    V_PIOPAUSE(1U)

#define S_MSTPAUSEDONE    30
#define V_MSTPAUSEDONE(x) ((x) << S_MSTPAUSEDONE)
#define F_MSTPAUSEDONE    V_MSTPAUSEDONE(1U)

#define S_MSTPAUSE    1
#define V_MSTPAUSE(x) ((x) << S_MSTPAUSE)
#define F_MSTPAUSE    V_MSTPAUSE(1U)

#define A_PCIE_SYS_CFG_READY 0x30e0
#define A_PCIE_MA_STAT 0x30e0
#define A_PCIE_STATIC_CFG1 0x30e4

#define S_LINKDOWN_RESET_EN    26
#define V_LINKDOWN_RESET_EN(x) ((x) << S_LINKDOWN_RESET_EN)
#define F_LINKDOWN_RESET_EN    V_LINKDOWN_RESET_EN(1U)

#define S_IN_WR_DISCONTIG    25
#define V_IN_WR_DISCONTIG(x) ((x) << S_IN_WR_DISCONTIG)
#define F_IN_WR_DISCONTIG    V_IN_WR_DISCONTIG(1U)

#define S_IN_RD_CPLSIZE    22
#define M_IN_RD_CPLSIZE    0x7U
#define V_IN_RD_CPLSIZE(x) ((x) << S_IN_RD_CPLSIZE)
#define G_IN_RD_CPLSIZE(x) (((x) >> S_IN_RD_CPLSIZE) & M_IN_RD_CPLSIZE)

#define S_IN_RD_BUFMODE    20
#define M_IN_RD_BUFMODE    0x3U
#define V_IN_RD_BUFMODE(x) ((x) << S_IN_RD_BUFMODE)
#define G_IN_RD_BUFMODE(x) (((x) >> S_IN_RD_BUFMODE) & M_IN_RD_BUFMODE)

#define S_GBIF_NPTRANS_TOT    18
#define M_GBIF_NPTRANS_TOT    0x3U
#define V_GBIF_NPTRANS_TOT(x) ((x) << S_GBIF_NPTRANS_TOT)
#define G_GBIF_NPTRANS_TOT(x) (((x) >> S_GBIF_NPTRANS_TOT) & M_GBIF_NPTRANS_TOT)

#define S_IN_PDAT_TOT    15
#define M_IN_PDAT_TOT    0x7U
#define V_IN_PDAT_TOT(x) ((x) << S_IN_PDAT_TOT)
#define G_IN_PDAT_TOT(x) (((x) >> S_IN_PDAT_TOT) & M_IN_PDAT_TOT)

#define S_PCIE_NPTRANS_TOT    12
#define M_PCIE_NPTRANS_TOT    0x7U
#define V_PCIE_NPTRANS_TOT(x) ((x) << S_PCIE_NPTRANS_TOT)
#define G_PCIE_NPTRANS_TOT(x) (((x) >> S_PCIE_NPTRANS_TOT) & M_PCIE_NPTRANS_TOT)

#define S_OUT_PDAT_TOT    9
#define M_OUT_PDAT_TOT    0x7U
#define V_OUT_PDAT_TOT(x) ((x) << S_OUT_PDAT_TOT)
#define G_OUT_PDAT_TOT(x) (((x) >> S_OUT_PDAT_TOT) & M_OUT_PDAT_TOT)

#define S_GBIF_MAX_WRSIZE    6
#define M_GBIF_MAX_WRSIZE    0x7U
#define V_GBIF_MAX_WRSIZE(x) ((x) << S_GBIF_MAX_WRSIZE)
#define G_GBIF_MAX_WRSIZE(x) (((x) >> S_GBIF_MAX_WRSIZE) & M_GBIF_MAX_WRSIZE)

#define S_GBIF_MAX_RDSIZE    3
#define M_GBIF_MAX_RDSIZE    0x7U
#define V_GBIF_MAX_RDSIZE(x) ((x) << S_GBIF_MAX_RDSIZE)
#define G_GBIF_MAX_RDSIZE(x) (((x) >> S_GBIF_MAX_RDSIZE) & M_GBIF_MAX_RDSIZE)

#define S_PCIE_MAX_RDSIZE    0
#define M_PCIE_MAX_RDSIZE    0x7U
#define V_PCIE_MAX_RDSIZE(x) ((x) << S_PCIE_MAX_RDSIZE)
#define G_PCIE_MAX_RDSIZE(x) (((x) >> S_PCIE_MAX_RDSIZE) & M_PCIE_MAX_RDSIZE)

#define S_AUXPOWER_DETECTED    27
#define V_AUXPOWER_DETECTED(x) ((x) << S_AUXPOWER_DETECTED)
#define F_AUXPOWER_DETECTED    V_AUXPOWER_DETECTED(1U)

#define A_PCIE_STATIC_CFG2 0x30e8

#define S_PL_CONTROL    16
#define M_PL_CONTROL    0xffffU
#define V_PL_CONTROL(x) ((x) << S_PL_CONTROL)
#define G_PL_CONTROL(x) (((x) >> S_PL_CONTROL) & M_PL_CONTROL)

#define S_STATIC_SPARE3    0
#define M_STATIC_SPARE3    0x3fffU
#define V_STATIC_SPARE3(x) ((x) << S_STATIC_SPARE3)
#define G_STATIC_SPARE3(x) (((x) >> S_STATIC_SPARE3) & M_STATIC_SPARE3)

#define A_PCIE_DBG_INDIR_REQ 0x30ec

#define S_DBGENABLE    31
#define V_DBGENABLE(x) ((x) << S_DBGENABLE)
#define F_DBGENABLE    V_DBGENABLE(1U)

#define S_DBGAUTOINC    30
#define V_DBGAUTOINC(x) ((x) << S_DBGAUTOINC)
#define F_DBGAUTOINC    V_DBGAUTOINC(1U)

#define S_POINTER    8
#define M_POINTER    0xffffU
#define V_POINTER(x) ((x) << S_POINTER)
#define G_POINTER(x) (((x) >> S_POINTER) & M_POINTER)

#define S_SELECT    0
#define M_SELECT    0xfU
#define V_SELECT(x) ((x) << S_SELECT)
#define G_SELECT(x) (((x) >> S_SELECT) & M_SELECT)

#define A_PCIE_DBG_INDIR_DATA_0 0x30f0
#define A_PCIE_DBG_INDIR_DATA_1 0x30f4
#define A_PCIE_DBG_INDIR_DATA_2 0x30f8
#define A_PCIE_DBG_INDIR_DATA_3 0x30fc
#define A_PCIE_FUNC_INT_CFG 0x3100

#define S_PBAOFST    28
#define M_PBAOFST    0xfU
#define V_PBAOFST(x) ((x) << S_PBAOFST)
#define G_PBAOFST(x) (((x) >> S_PBAOFST) & M_PBAOFST)

#define S_TABOFST    24
#define M_TABOFST    0xfU
#define V_TABOFST(x) ((x) << S_TABOFST)
#define G_TABOFST(x) (((x) >> S_TABOFST) & M_TABOFST)

#define S_VECNUM    12
#define M_VECNUM    0x3ffU
#define V_VECNUM(x) ((x) << S_VECNUM)
#define G_VECNUM(x) (((x) >> S_VECNUM) & M_VECNUM)

#define S_VECBASE    0
#define M_VECBASE    0x7ffU
#define V_VECBASE(x) ((x) << S_VECBASE)
#define G_VECBASE(x) (((x) >> S_VECBASE) & M_VECBASE)

#define A_PCIE_FUNC_CTL_STAT 0x3104

#define S_SENDFLRRSP    31
#define V_SENDFLRRSP(x) ((x) << S_SENDFLRRSP)
#define F_SENDFLRRSP    V_SENDFLRRSP(1U)

#define S_IMMFLRRSP    24
#define V_IMMFLRRSP(x) ((x) << S_IMMFLRRSP)
#define F_IMMFLRRSP    V_IMMFLRRSP(1U)

#define S_TXNDISABLE    20
#define V_TXNDISABLE(x) ((x) << S_TXNDISABLE)
#define F_TXNDISABLE    V_TXNDISABLE(1U)

#define S_PNDTXNS    8
#define M_PNDTXNS    0x3ffU
#define V_PNDTXNS(x) ((x) << S_PNDTXNS)
#define G_PNDTXNS(x) (((x) >> S_PNDTXNS) & M_PNDTXNS)

#define S_VFVLD    3
#define V_VFVLD(x) ((x) << S_VFVLD)
#define F_VFVLD    V_VFVLD(1U)

#define S_PFNUM    0
#define M_PFNUM    0x7U
#define V_PFNUM(x) ((x) << S_PFNUM)
#define G_PFNUM(x) (((x) >> S_PFNUM) & M_PFNUM)

#define A_PCIE_PF_INT_CFG 0x3140
#define A_PCIE_PF_INT_CFG2 0x3144
#define A_PCIE_VF_INT_CFG 0x3180
#define A_PCIE_VF_INT_CFG2 0x3184
#define A_PCIE_PF_MSI_EN 0x35a8

#define S_PFMSIEN_7_0    0
#define M_PFMSIEN_7_0    0xffU
#define V_PFMSIEN_7_0(x) ((x) << S_PFMSIEN_7_0)
#define G_PFMSIEN_7_0(x) (((x) >> S_PFMSIEN_7_0) & M_PFMSIEN_7_0)

#define A_PCIE_VF_MSI_EN_0 0x35ac
#define A_PCIE_VF_MSI_EN_1 0x35b0
#define A_PCIE_VF_MSI_EN_2 0x35b4
#define A_PCIE_VF_MSI_EN_3 0x35b8
#define A_PCIE_PF_MSIX_EN 0x35bc

#define S_PFMSIXEN_7_0    0
#define M_PFMSIXEN_7_0    0xffU
#define V_PFMSIXEN_7_0(x) ((x) << S_PFMSIXEN_7_0)
#define G_PFMSIXEN_7_0(x) (((x) >> S_PFMSIXEN_7_0) & M_PFMSIXEN_7_0)

#define A_PCIE_VF_MSIX_EN_0 0x35c0
#define A_PCIE_VF_MSIX_EN_1 0x35c4
#define A_PCIE_VF_MSIX_EN_2 0x35c8
#define A_PCIE_VF_MSIX_EN_3 0x35cc
#define A_PCIE_FID_VFID_SEL 0x35ec

#define S_FID_VFID_SEL_SELECT    0
#define M_FID_VFID_SEL_SELECT    0x3U
#define V_FID_VFID_SEL_SELECT(x) ((x) << S_FID_VFID_SEL_SELECT)
#define G_FID_VFID_SEL_SELECT(x) (((x) >> S_FID_VFID_SEL_SELECT) & M_FID_VFID_SEL_SELECT)

#define A_PCIE_FID_VFID 0x3600

#define S_FID_VFID_SELECT    30
#define M_FID_VFID_SELECT    0x3U
#define V_FID_VFID_SELECT(x) ((x) << S_FID_VFID_SELECT)
#define G_FID_VFID_SELECT(x) (((x) >> S_FID_VFID_SELECT) & M_FID_VFID_SELECT)

#define S_IDO    24
#define V_IDO(x) ((x) << S_IDO)
#define F_IDO    V_IDO(1U)

#define S_FID_VFID_VFID    16
#define M_FID_VFID_VFID    0xffU
#define V_FID_VFID_VFID(x) ((x) << S_FID_VFID_VFID)
#define G_FID_VFID_VFID(x) (((x) >> S_FID_VFID_VFID) & M_FID_VFID_VFID)

#define S_FID_VFID_TC    11
#define M_FID_VFID_TC    0x7U
#define V_FID_VFID_TC(x) ((x) << S_FID_VFID_TC)
#define G_FID_VFID_TC(x) (((x) >> S_FID_VFID_TC) & M_FID_VFID_TC)

#define S_FID_VFID_VFVLD    10
#define V_FID_VFID_VFVLD(x) ((x) << S_FID_VFID_VFVLD)
#define F_FID_VFID_VFVLD    V_FID_VFID_VFVLD(1U)

#define S_FID_VFID_PF    7
#define M_FID_VFID_PF    0x7U
#define V_FID_VFID_PF(x) ((x) << S_FID_VFID_PF)
#define G_FID_VFID_PF(x) (((x) >> S_FID_VFID_PF) & M_FID_VFID_PF)

#define S_FID_VFID_RVF    0
#define M_FID_VFID_RVF    0x7fU
#define V_FID_VFID_RVF(x) ((x) << S_FID_VFID_RVF)
#define G_FID_VFID_RVF(x) (((x) >> S_FID_VFID_RVF) & M_FID_VFID_RVF)

#define A_PCIE_FID 0x3900

#define S_PAD    11
#define V_PAD(x) ((x) << S_PAD)
#define F_PAD    V_PAD(1U)

#define S_TC    8
#define M_TC    0x7U
#define V_TC(x) ((x) << S_TC)
#define G_TC(x) (((x) >> S_TC) & M_TC)

#define S_FUNC    0
#define M_FUNC    0xffU
#define V_FUNC(x) ((x) << S_FUNC)
#define G_FUNC(x) (((x) >> S_FUNC) & M_FUNC)

#define A_PCIE_COOKIE_STAT 0x5600

#define S_COOKIEB    16
#define M_COOKIEB    0x3ffU
#define V_COOKIEB(x) ((x) << S_COOKIEB)
#define G_COOKIEB(x) (((x) >> S_COOKIEB) & M_COOKIEB)

#define S_COOKIEA    0
#define M_COOKIEA    0x3ffU
#define V_COOKIEA(x) ((x) << S_COOKIEA)
#define G_COOKIEA(x) (((x) >> S_COOKIEA) & M_COOKIEA)

#define A_PCIE_FLR_PIO 0x5620

#define S_RCVDBAR2COOKIE    24
#define M_RCVDBAR2COOKIE    0xffU
#define V_RCVDBAR2COOKIE(x) ((x) << S_RCVDBAR2COOKIE)
#define G_RCVDBAR2COOKIE(x) (((x) >> S_RCVDBAR2COOKIE) & M_RCVDBAR2COOKIE)

#define S_RCVDMARSPCOOKIE    16
#define M_RCVDMARSPCOOKIE    0xffU
#define V_RCVDMARSPCOOKIE(x) ((x) << S_RCVDMARSPCOOKIE)
#define G_RCVDMARSPCOOKIE(x) (((x) >> S_RCVDMARSPCOOKIE) & M_RCVDMARSPCOOKIE)

#define S_RCVDPIORSPCOOKIE    8
#define M_RCVDPIORSPCOOKIE    0xffU
#define V_RCVDPIORSPCOOKIE(x) ((x) << S_RCVDPIORSPCOOKIE)
#define G_RCVDPIORSPCOOKIE(x) (((x) >> S_RCVDPIORSPCOOKIE) & M_RCVDPIORSPCOOKIE)

#define S_EXPDCOOKIE    0
#define M_EXPDCOOKIE    0xffU
#define V_EXPDCOOKIE(x) ((x) << S_EXPDCOOKIE)
#define G_EXPDCOOKIE(x) (((x) >> S_EXPDCOOKIE) & M_EXPDCOOKIE)

#define A_PCIE_FLR_PIO2 0x5624

#define S_RCVDMAREQCOOKIE    16
#define M_RCVDMAREQCOOKIE    0xffU
#define V_RCVDMAREQCOOKIE(x) ((x) << S_RCVDMAREQCOOKIE)
#define G_RCVDMAREQCOOKIE(x) (((x) >> S_RCVDMAREQCOOKIE) & M_RCVDMAREQCOOKIE)

#define S_RCVDPIOREQCOOKIE    8
#define M_RCVDPIOREQCOOKIE    0xffU
#define V_RCVDPIOREQCOOKIE(x) ((x) << S_RCVDPIOREQCOOKIE)
#define G_RCVDPIOREQCOOKIE(x) (((x) >> S_RCVDPIOREQCOOKIE) & M_RCVDPIOREQCOOKIE)

#define A_PCIE_VC0_CDTS0 0x56cc

#define S_CPLD0    20
#define M_CPLD0    0xfffU
#define V_CPLD0(x) ((x) << S_CPLD0)
#define G_CPLD0(x) (((x) >> S_CPLD0) & M_CPLD0)

#define S_PH0    12
#define M_PH0    0xffU
#define V_PH0(x) ((x) << S_PH0)
#define G_PH0(x) (((x) >> S_PH0) & M_PH0)

#define S_PD0    0
#define M_PD0    0xfffU
#define V_PD0(x) ((x) << S_PD0)
#define G_PD0(x) (((x) >> S_PD0) & M_PD0)

#define A_PCIE_VC0_CDTS1 0x56d0

#define S_CPLH0    20
#define M_CPLH0    0xffU
#define V_CPLH0(x) ((x) << S_CPLH0)
#define G_CPLH0(x) (((x) >> S_CPLH0) & M_CPLH0)

#define S_NPH0    12
#define M_NPH0    0xffU
#define V_NPH0(x) ((x) << S_NPH0)
#define G_NPH0(x) (((x) >> S_NPH0) & M_NPH0)

#define S_NPD0    0
#define M_NPD0    0xfffU
#define V_NPD0(x) ((x) << S_NPD0)
#define G_NPD0(x) (((x) >> S_NPD0) & M_NPD0)

#define A_PCIE_VC1_CDTS0 0x56d4

#define S_CPLD1    20
#define M_CPLD1    0xfffU
#define V_CPLD1(x) ((x) << S_CPLD1)
#define G_CPLD1(x) (((x) >> S_CPLD1) & M_CPLD1)

#define S_PH1    12
#define M_PH1    0xffU
#define V_PH1(x) ((x) << S_PH1)
#define G_PH1(x) (((x) >> S_PH1) & M_PH1)

#define S_PD1    0
#define M_PD1    0xfffU
#define V_PD1(x) ((x) << S_PD1)
#define G_PD1(x) (((x) >> S_PD1) & M_PD1)

#define A_PCIE_VC1_CDTS1 0x56d8

#define S_CPLH1    20
#define M_CPLH1    0xffU
#define V_CPLH1(x) ((x) << S_CPLH1)
#define G_CPLH1(x) (((x) >> S_CPLH1) & M_CPLH1)

#define S_NPH1    12
#define M_NPH1    0xffU
#define V_NPH1(x) ((x) << S_NPH1)
#define G_NPH1(x) (((x) >> S_NPH1) & M_NPH1)

#define S_NPD1    0
#define M_NPD1    0xfffU
#define V_NPD1(x) ((x) << S_NPD1)
#define G_NPD1(x) (((x) >> S_NPD1) & M_NPD1)

#define A_PCIE_FLR_PF_STATUS 0x56dc
#define A_PCIE_FLR_VF0_STATUS 0x56e0
#define A_PCIE_FLR_VF1_STATUS 0x56e4
#define A_PCIE_FLR_VF2_STATUS 0x56e8
#define A_PCIE_FLR_VF3_STATUS 0x56ec
#define A_PCIE_STAT 0x56f4

#define S_PM_STATUS    24
#define M_PM_STATUS    0xffU
#define V_PM_STATUS(x) ((x) << S_PM_STATUS)
#define G_PM_STATUS(x) (((x) >> S_PM_STATUS) & M_PM_STATUS)

#define S_PM_CURRENTSTATE    20
#define M_PM_CURRENTSTATE    0x7U
#define V_PM_CURRENTSTATE(x) ((x) << S_PM_CURRENTSTATE)
#define G_PM_CURRENTSTATE(x) (((x) >> S_PM_CURRENTSTATE) & M_PM_CURRENTSTATE)

#define S_LTSSMENABLE    12
#define V_LTSSMENABLE(x) ((x) << S_LTSSMENABLE)
#define F_LTSSMENABLE    V_LTSSMENABLE(1U)

#define S_STATECFGINITF    4
#define M_STATECFGINITF    0x7fU
#define V_STATECFGINITF(x) ((x) << S_STATECFGINITF)
#define G_STATECFGINITF(x) (((x) >> S_STATECFGINITF) & M_STATECFGINITF)

#define S_STATECFGINIT    0
#define M_STATECFGINIT    0xfU
#define V_STATECFGINIT(x) ((x) << S_STATECFGINIT)
#define G_STATECFGINIT(x) (((x) >> S_STATECFGINIT) & M_STATECFGINIT)

#define A_PCIE_CRS 0x56f8

#define S_CRS_ENABLE    0
#define V_CRS_ENABLE(x) ((x) << S_CRS_ENABLE)
#define F_CRS_ENABLE    V_CRS_ENABLE(1U)

#define A_PCIE_LTSSM 0x56fc

#define S_LTSSM_ENABLE    0
#define V_LTSSM_ENABLE(x) ((x) << S_LTSSM_ENABLE)
#define F_LTSSM_ENABLE    V_LTSSM_ENABLE(1U)

#define A_PCIE_CORE_ACK_LATENCY_TIMER_REPLAY_TIMER 0x5700

#define S_REPLAY_TIME_LIMIT    16
#define M_REPLAY_TIME_LIMIT    0xffffU
#define V_REPLAY_TIME_LIMIT(x) ((x) << S_REPLAY_TIME_LIMIT)
#define G_REPLAY_TIME_LIMIT(x) (((x) >> S_REPLAY_TIME_LIMIT) & M_REPLAY_TIME_LIMIT)

#define S_ACK_LATENCY_TIMER_LIMIT    0
#define M_ACK_LATENCY_TIMER_LIMIT    0xffffU
#define V_ACK_LATENCY_TIMER_LIMIT(x) ((x) << S_ACK_LATENCY_TIMER_LIMIT)
#define G_ACK_LATENCY_TIMER_LIMIT(x) (((x) >> S_ACK_LATENCY_TIMER_LIMIT) & M_ACK_LATENCY_TIMER_LIMIT)

#define A_PCIE_CORE_VENDOR_SPECIFIC_DLLP 0x5704
#define A_PCIE_CORE_PORT_FORCE_LINK 0x5708

#define S_LOW_POWER_ENTRANCE_COUNT    24
#define M_LOW_POWER_ENTRANCE_COUNT    0xffU
#define V_LOW_POWER_ENTRANCE_COUNT(x) ((x) << S_LOW_POWER_ENTRANCE_COUNT)
#define G_LOW_POWER_ENTRANCE_COUNT(x) (((x) >> S_LOW_POWER_ENTRANCE_COUNT) & M_LOW_POWER_ENTRANCE_COUNT)

#define S_LINK_STATE    16
#define M_LINK_STATE    0x3fU
#define V_LINK_STATE(x) ((x) << S_LINK_STATE)
#define G_LINK_STATE(x) (((x) >> S_LINK_STATE) & M_LINK_STATE)

#define S_FORCE_LINK    15
#define V_FORCE_LINK(x) ((x) << S_FORCE_LINK)
#define F_FORCE_LINK    V_FORCE_LINK(1U)

#define S_LINK_NUMBER    0
#define M_LINK_NUMBER    0xffU
#define V_LINK_NUMBER(x) ((x) << S_LINK_NUMBER)
#define G_LINK_NUMBER(x) (((x) >> S_LINK_NUMBER) & M_LINK_NUMBER)

#define A_PCIE_CORE_ACK_FREQUENCY_L0L1_ASPM_CONTROL 0x570c

#define S_ENTER_ASPM_L1_WO_L0S    30
#define V_ENTER_ASPM_L1_WO_L0S(x) ((x) << S_ENTER_ASPM_L1_WO_L0S)
#define F_ENTER_ASPM_L1_WO_L0S    V_ENTER_ASPM_L1_WO_L0S(1U)

#define S_L1_ENTRANCE_LATENCY    27
#define M_L1_ENTRANCE_LATENCY    0x7U
#define V_L1_ENTRANCE_LATENCY(x) ((x) << S_L1_ENTRANCE_LATENCY)
#define G_L1_ENTRANCE_LATENCY(x) (((x) >> S_L1_ENTRANCE_LATENCY) & M_L1_ENTRANCE_LATENCY)

#define S_L0S_ENTRANCE_LATENCY    24
#define M_L0S_ENTRANCE_LATENCY    0x7U
#define V_L0S_ENTRANCE_LATENCY(x) ((x) << S_L0S_ENTRANCE_LATENCY)
#define G_L0S_ENTRANCE_LATENCY(x) (((x) >> S_L0S_ENTRANCE_LATENCY) & M_L0S_ENTRANCE_LATENCY)

#define S_COMMON_CLOCK_N_FTS    16
#define M_COMMON_CLOCK_N_FTS    0xffU
#define V_COMMON_CLOCK_N_FTS(x) ((x) << S_COMMON_CLOCK_N_FTS)
#define G_COMMON_CLOCK_N_FTS(x) (((x) >> S_COMMON_CLOCK_N_FTS) & M_COMMON_CLOCK_N_FTS)

#define S_N_FTS    8
#define M_N_FTS    0xffU
#define V_N_FTS(x) ((x) << S_N_FTS)
#define G_N_FTS(x) (((x) >> S_N_FTS) & M_N_FTS)

#define S_ACK_FREQUENCY    0
#define M_ACK_FREQUENCY    0xffU
#define V_ACK_FREQUENCY(x) ((x) << S_ACK_FREQUENCY)
#define G_ACK_FREQUENCY(x) (((x) >> S_ACK_FREQUENCY) & M_ACK_FREQUENCY)

#define A_PCIE_CORE_PORT_LINK_CONTROL 0x5710

#define S_CROSSLINK_ACTIVE    23
#define V_CROSSLINK_ACTIVE(x) ((x) << S_CROSSLINK_ACTIVE)
#define F_CROSSLINK_ACTIVE    V_CROSSLINK_ACTIVE(1U)

#define S_CROSSLINK_ENABLE    22
#define V_CROSSLINK_ENABLE(x) ((x) << S_CROSSLINK_ENABLE)
#define F_CROSSLINK_ENABLE    V_CROSSLINK_ENABLE(1U)

#define S_LINK_MODE_ENABLE    16
#define M_LINK_MODE_ENABLE    0x3fU
#define V_LINK_MODE_ENABLE(x) ((x) << S_LINK_MODE_ENABLE)
#define G_LINK_MODE_ENABLE(x) (((x) >> S_LINK_MODE_ENABLE) & M_LINK_MODE_ENABLE)

#define S_FAST_LINK_MODE    7
#define V_FAST_LINK_MODE(x) ((x) << S_FAST_LINK_MODE)
#define F_FAST_LINK_MODE    V_FAST_LINK_MODE(1U)

#define S_DLL_LINK_ENABLE    5
#define V_DLL_LINK_ENABLE(x) ((x) << S_DLL_LINK_ENABLE)
#define F_DLL_LINK_ENABLE    V_DLL_LINK_ENABLE(1U)

#define S_RESET_ASSERT    3
#define V_RESET_ASSERT(x) ((x) << S_RESET_ASSERT)
#define F_RESET_ASSERT    V_RESET_ASSERT(1U)

#define S_LOOPBACK_ENABLE    2
#define V_LOOPBACK_ENABLE(x) ((x) << S_LOOPBACK_ENABLE)
#define F_LOOPBACK_ENABLE    V_LOOPBACK_ENABLE(1U)

#define S_SCRAMBLE_DISABLE    1
#define V_SCRAMBLE_DISABLE(x) ((x) << S_SCRAMBLE_DISABLE)
#define F_SCRAMBLE_DISABLE    V_SCRAMBLE_DISABLE(1U)

#define S_VENDOR_SPECIFIC_DLLP_REQUEST    0
#define V_VENDOR_SPECIFIC_DLLP_REQUEST(x) ((x) << S_VENDOR_SPECIFIC_DLLP_REQUEST)
#define F_VENDOR_SPECIFIC_DLLP_REQUEST    V_VENDOR_SPECIFIC_DLLP_REQUEST(1U)

#define A_PCIE_CORE_LANE_SKEW 0x5714

#define S_DISABLE_DESKEW    31
#define V_DISABLE_DESKEW(x) ((x) << S_DISABLE_DESKEW)
#define F_DISABLE_DESKEW    V_DISABLE_DESKEW(1U)

#define S_ACK_NAK_DISABLE    25
#define V_ACK_NAK_DISABLE(x) ((x) << S_ACK_NAK_DISABLE)
#define F_ACK_NAK_DISABLE    V_ACK_NAK_DISABLE(1U)

#define S_FLOW_CONTROL_DISABLE    24
#define V_FLOW_CONTROL_DISABLE(x) ((x) << S_FLOW_CONTROL_DISABLE)
#define F_FLOW_CONTROL_DISABLE    V_FLOW_CONTROL_DISABLE(1U)

#define S_INSERT_TXSKEW    0
#define M_INSERT_TXSKEW    0xffffffU
#define V_INSERT_TXSKEW(x) ((x) << S_INSERT_TXSKEW)
#define G_INSERT_TXSKEW(x) (((x) >> S_INSERT_TXSKEW) & M_INSERT_TXSKEW)

#define A_PCIE_CORE_SYMBOL_NUMBER 0x5718

#define S_FLOW_CONTROL_TIMER_MODIFIER    24
#define M_FLOW_CONTROL_TIMER_MODIFIER    0x1fU
#define V_FLOW_CONTROL_TIMER_MODIFIER(x) ((x) << S_FLOW_CONTROL_TIMER_MODIFIER)
#define G_FLOW_CONTROL_TIMER_MODIFIER(x) (((x) >> S_FLOW_CONTROL_TIMER_MODIFIER) & M_FLOW_CONTROL_TIMER_MODIFIER)

#define S_ACK_NAK_TIMER_MODIFIER    19
#define M_ACK_NAK_TIMER_MODIFIER    0x1fU
#define V_ACK_NAK_TIMER_MODIFIER(x) ((x) << S_ACK_NAK_TIMER_MODIFIER)
#define G_ACK_NAK_TIMER_MODIFIER(x) (((x) >> S_ACK_NAK_TIMER_MODIFIER) & M_ACK_NAK_TIMER_MODIFIER)

#define S_REPLAY_TIMER_MODIFIER    14
#define M_REPLAY_TIMER_MODIFIER    0x1fU
#define V_REPLAY_TIMER_MODIFIER(x) ((x) << S_REPLAY_TIMER_MODIFIER)
#define G_REPLAY_TIMER_MODIFIER(x) (((x) >> S_REPLAY_TIMER_MODIFIER) & M_REPLAY_TIMER_MODIFIER)

#define S_MAXFUNC    0
#define M_MAXFUNC    0x7U
#define V_MAXFUNC(x) ((x) << S_MAXFUNC)
#define G_MAXFUNC(x) (((x) >> S_MAXFUNC) & M_MAXFUNC)

#define A_PCIE_CORE_SYMBOL_TIMER_FILTER_MASK1 0x571c

#define S_MASK_RADM_FILTER    16
#define M_MASK_RADM_FILTER    0xffffU
#define V_MASK_RADM_FILTER(x) ((x) << S_MASK_RADM_FILTER)
#define G_MASK_RADM_FILTER(x) (((x) >> S_MASK_RADM_FILTER) & M_MASK_RADM_FILTER)

#define S_DISABLE_FC_WATCHDOG    15
#define V_DISABLE_FC_WATCHDOG(x) ((x) << S_DISABLE_FC_WATCHDOG)
#define F_DISABLE_FC_WATCHDOG    V_DISABLE_FC_WATCHDOG(1U)

#define S_SKP_INTERVAL    0
#define M_SKP_INTERVAL    0x7ffU
#define V_SKP_INTERVAL(x) ((x) << S_SKP_INTERVAL)
#define G_SKP_INTERVAL(x) (((x) >> S_SKP_INTERVAL) & M_SKP_INTERVAL)

#define A_PCIE_CORE_FILTER_MASK2 0x5720
#define A_PCIE_CORE_DEBUG_0 0x5728
#define A_PCIE_CORE_DEBUG_1 0x572c
#define A_PCIE_CORE_TRANSMIT_POSTED_FC_CREDIT_STATUS 0x5730

#define S_TXPH_FC    12
#define M_TXPH_FC    0xffU
#define V_TXPH_FC(x) ((x) << S_TXPH_FC)
#define G_TXPH_FC(x) (((x) >> S_TXPH_FC) & M_TXPH_FC)

#define S_TXPD_FC    0
#define M_TXPD_FC    0xfffU
#define V_TXPD_FC(x) ((x) << S_TXPD_FC)
#define G_TXPD_FC(x) (((x) >> S_TXPD_FC) & M_TXPD_FC)

#define A_PCIE_CORE_TRANSMIT_NONPOSTED_FC_CREDIT_STATUS 0x5734

#define S_TXNPH_FC    12
#define M_TXNPH_FC    0xffU
#define V_TXNPH_FC(x) ((x) << S_TXNPH_FC)
#define G_TXNPH_FC(x) (((x) >> S_TXNPH_FC) & M_TXNPH_FC)

#define S_TXNPD_FC    0
#define M_TXNPD_FC    0xfffU
#define V_TXNPD_FC(x) ((x) << S_TXNPD_FC)
#define G_TXNPD_FC(x) (((x) >> S_TXNPD_FC) & M_TXNPD_FC)

#define A_PCIE_CORE_TRANSMIT_COMPLETION_FC_CREDIT_STATUS 0x5738

#define S_TXCPLH_FC    12
#define M_TXCPLH_FC    0xffU
#define V_TXCPLH_FC(x) ((x) << S_TXCPLH_FC)
#define G_TXCPLH_FC(x) (((x) >> S_TXCPLH_FC) & M_TXCPLH_FC)

#define S_TXCPLD_FC    0
#define M_TXCPLD_FC    0xfffU
#define V_TXCPLD_FC(x) ((x) << S_TXCPLD_FC)
#define G_TXCPLD_FC(x) (((x) >> S_TXCPLD_FC) & M_TXCPLD_FC)

#define A_PCIE_CORE_QUEUE_STATUS 0x573c

#define S_RXQUEUE_NOT_EMPTY    2
#define V_RXQUEUE_NOT_EMPTY(x) ((x) << S_RXQUEUE_NOT_EMPTY)
#define F_RXQUEUE_NOT_EMPTY    V_RXQUEUE_NOT_EMPTY(1U)

#define S_TXRETRYBUF_NOT_EMPTY    1
#define V_TXRETRYBUF_NOT_EMPTY(x) ((x) << S_TXRETRYBUF_NOT_EMPTY)
#define F_TXRETRYBUF_NOT_EMPTY    V_TXRETRYBUF_NOT_EMPTY(1U)

#define S_RXTLP_FC_NOT_RETURNED    0
#define V_RXTLP_FC_NOT_RETURNED(x) ((x) << S_RXTLP_FC_NOT_RETURNED)
#define F_RXTLP_FC_NOT_RETURNED    V_RXTLP_FC_NOT_RETURNED(1U)

#define A_PCIE_CORE_VC_TRANSMIT_ARBITRATION_1 0x5740

#define S_VC3_WRR    24
#define M_VC3_WRR    0xffU
#define V_VC3_WRR(x) ((x) << S_VC3_WRR)
#define G_VC3_WRR(x) (((x) >> S_VC3_WRR) & M_VC3_WRR)

#define S_VC2_WRR    16
#define M_VC2_WRR    0xffU
#define V_VC2_WRR(x) ((x) << S_VC2_WRR)
#define G_VC2_WRR(x) (((x) >> S_VC2_WRR) & M_VC2_WRR)

#define S_VC1_WRR    8
#define M_VC1_WRR    0xffU
#define V_VC1_WRR(x) ((x) << S_VC1_WRR)
#define G_VC1_WRR(x) (((x) >> S_VC1_WRR) & M_VC1_WRR)

#define S_VC0_WRR    0
#define M_VC0_WRR    0xffU
#define V_VC0_WRR(x) ((x) << S_VC0_WRR)
#define G_VC0_WRR(x) (((x) >> S_VC0_WRR) & M_VC0_WRR)

#define A_PCIE_CORE_VC_TRANSMIT_ARBITRATION_2 0x5744

#define S_VC7_WRR    24
#define M_VC7_WRR    0xffU
#define V_VC7_WRR(x) ((x) << S_VC7_WRR)
#define G_VC7_WRR(x) (((x) >> S_VC7_WRR) & M_VC7_WRR)

#define S_VC6_WRR    16
#define M_VC6_WRR    0xffU
#define V_VC6_WRR(x) ((x) << S_VC6_WRR)
#define G_VC6_WRR(x) (((x) >> S_VC6_WRR) & M_VC6_WRR)

#define S_VC5_WRR    8
#define M_VC5_WRR    0xffU
#define V_VC5_WRR(x) ((x) << S_VC5_WRR)
#define G_VC5_WRR(x) (((x) >> S_VC5_WRR) & M_VC5_WRR)

#define S_VC4_WRR    0
#define M_VC4_WRR    0xffU
#define V_VC4_WRR(x) ((x) << S_VC4_WRR)
#define G_VC4_WRR(x) (((x) >> S_VC4_WRR) & M_VC4_WRR)

#define A_PCIE_CORE_VC0_POSTED_RECEIVE_QUEUE_CONTROL 0x5748

#define S_VC0_RX_ORDERING    31
#define V_VC0_RX_ORDERING(x) ((x) << S_VC0_RX_ORDERING)
#define F_VC0_RX_ORDERING    V_VC0_RX_ORDERING(1U)

#define S_VC0_TLP_ORDERING    30
#define V_VC0_TLP_ORDERING(x) ((x) << S_VC0_TLP_ORDERING)
#define F_VC0_TLP_ORDERING    V_VC0_TLP_ORDERING(1U)

#define S_VC0_PTLP_QUEUE_MODE    21
#define M_VC0_PTLP_QUEUE_MODE    0x7U
#define V_VC0_PTLP_QUEUE_MODE(x) ((x) << S_VC0_PTLP_QUEUE_MODE)
#define G_VC0_PTLP_QUEUE_MODE(x) (((x) >> S_VC0_PTLP_QUEUE_MODE) & M_VC0_PTLP_QUEUE_MODE)

#define S_VC0_PH_CREDITS    12
#define M_VC0_PH_CREDITS    0xffU
#define V_VC0_PH_CREDITS(x) ((x) << S_VC0_PH_CREDITS)
#define G_VC0_PH_CREDITS(x) (((x) >> S_VC0_PH_CREDITS) & M_VC0_PH_CREDITS)

#define S_VC0_PD_CREDITS    0
#define M_VC0_PD_CREDITS    0xfffU
#define V_VC0_PD_CREDITS(x) ((x) << S_VC0_PD_CREDITS)
#define G_VC0_PD_CREDITS(x) (((x) >> S_VC0_PD_CREDITS) & M_VC0_PD_CREDITS)

#define A_PCIE_CORE_VC0_NONPOSTED_RECEIVE_QUEUE_CONTROL 0x574c

#define S_VC0_NPTLP_QUEUE_MODE    21
#define M_VC0_NPTLP_QUEUE_MODE    0x7U
#define V_VC0_NPTLP_QUEUE_MODE(x) ((x) << S_VC0_NPTLP_QUEUE_MODE)
#define G_VC0_NPTLP_QUEUE_MODE(x) (((x) >> S_VC0_NPTLP_QUEUE_MODE) & M_VC0_NPTLP_QUEUE_MODE)

#define S_VC0_NPH_CREDITS    12
#define M_VC0_NPH_CREDITS    0xffU
#define V_VC0_NPH_CREDITS(x) ((x) << S_VC0_NPH_CREDITS)
#define G_VC0_NPH_CREDITS(x) (((x) >> S_VC0_NPH_CREDITS) & M_VC0_NPH_CREDITS)

#define S_VC0_NPD_CREDITS    0
#define M_VC0_NPD_CREDITS    0xfffU
#define V_VC0_NPD_CREDITS(x) ((x) << S_VC0_NPD_CREDITS)
#define G_VC0_NPD_CREDITS(x) (((x) >> S_VC0_NPD_CREDITS) & M_VC0_NPD_CREDITS)

#define A_PCIE_CORE_VC0_COMPLETION_RECEIVE_QUEUE_CONTROL 0x5750

#define S_VC0_CPLTLP_QUEUE_MODE    21
#define M_VC0_CPLTLP_QUEUE_MODE    0x7U
#define V_VC0_CPLTLP_QUEUE_MODE(x) ((x) << S_VC0_CPLTLP_QUEUE_MODE)
#define G_VC0_CPLTLP_QUEUE_MODE(x) (((x) >> S_VC0_CPLTLP_QUEUE_MODE) & M_VC0_CPLTLP_QUEUE_MODE)

#define S_VC0_CPLH_CREDITS    12
#define M_VC0_CPLH_CREDITS    0xffU
#define V_VC0_CPLH_CREDITS(x) ((x) << S_VC0_CPLH_CREDITS)
#define G_VC0_CPLH_CREDITS(x) (((x) >> S_VC0_CPLH_CREDITS) & M_VC0_CPLH_CREDITS)

#define S_VC0_CPLD_CREDITS    0
#define M_VC0_CPLD_CREDITS    0xfffU
#define V_VC0_CPLD_CREDITS(x) ((x) << S_VC0_CPLD_CREDITS)
#define G_VC0_CPLD_CREDITS(x) (((x) >> S_VC0_CPLD_CREDITS) & M_VC0_CPLD_CREDITS)

#define A_PCIE_CORE_VC1_POSTED_RECEIVE_QUEUE_CONTROL 0x5754

#define S_VC1_TLP_ORDERING    30
#define V_VC1_TLP_ORDERING(x) ((x) << S_VC1_TLP_ORDERING)
#define F_VC1_TLP_ORDERING    V_VC1_TLP_ORDERING(1U)

#define S_VC1_PTLP_QUEUE_MODE    21
#define M_VC1_PTLP_QUEUE_MODE    0x7U
#define V_VC1_PTLP_QUEUE_MODE(x) ((x) << S_VC1_PTLP_QUEUE_MODE)
#define G_VC1_PTLP_QUEUE_MODE(x) (((x) >> S_VC1_PTLP_QUEUE_MODE) & M_VC1_PTLP_QUEUE_MODE)

#define S_VC1_PH_CREDITS    12
#define M_VC1_PH_CREDITS    0xffU
#define V_VC1_PH_CREDITS(x) ((x) << S_VC1_PH_CREDITS)
#define G_VC1_PH_CREDITS(x) (((x) >> S_VC1_PH_CREDITS) & M_VC1_PH_CREDITS)

#define S_VC1_PD_CREDITS    0
#define M_VC1_PD_CREDITS    0xfffU
#define V_VC1_PD_CREDITS(x) ((x) << S_VC1_PD_CREDITS)
#define G_VC1_PD_CREDITS(x) (((x) >> S_VC1_PD_CREDITS) & M_VC1_PD_CREDITS)

#define A_PCIE_CORE_VC1_NONPOSTED_RECEIVE_QUEUE_CONTROL 0x5758

#define S_VC1_NPTLP_QUEUE_MODE    21
#define M_VC1_NPTLP_QUEUE_MODE    0x7U
#define V_VC1_NPTLP_QUEUE_MODE(x) ((x) << S_VC1_NPTLP_QUEUE_MODE)
#define G_VC1_NPTLP_QUEUE_MODE(x) (((x) >> S_VC1_NPTLP_QUEUE_MODE) & M_VC1_NPTLP_QUEUE_MODE)

#define S_VC1_NPH_CREDITS    12
#define M_VC1_NPH_CREDITS    0xffU
#define V_VC1_NPH_CREDITS(x) ((x) << S_VC1_NPH_CREDITS)
#define G_VC1_NPH_CREDITS(x) (((x) >> S_VC1_NPH_CREDITS) & M_VC1_NPH_CREDITS)

#define S_VC1_NPD_CREDITS    0
#define M_VC1_NPD_CREDITS    0xfffU
#define V_VC1_NPD_CREDITS(x) ((x) << S_VC1_NPD_CREDITS)
#define G_VC1_NPD_CREDITS(x) (((x) >> S_VC1_NPD_CREDITS) & M_VC1_NPD_CREDITS)

#define A_PCIE_CORE_VC1_COMPLETION_RECEIVE_QUEUE_CONTROL 0x575c

#define S_VC1_CPLTLP_QUEUE_MODE    21
#define M_VC1_CPLTLP_QUEUE_MODE    0x7U
#define V_VC1_CPLTLP_QUEUE_MODE(x) ((x) << S_VC1_CPLTLP_QUEUE_MODE)
#define G_VC1_CPLTLP_QUEUE_MODE(x) (((x) >> S_VC1_CPLTLP_QUEUE_MODE) & M_VC1_CPLTLP_QUEUE_MODE)

#define S_VC1_CPLH_CREDITS    12
#define M_VC1_CPLH_CREDITS    0xffU
#define V_VC1_CPLH_CREDITS(x) ((x) << S_VC1_CPLH_CREDITS)
#define G_VC1_CPLH_CREDITS(x) (((x) >> S_VC1_CPLH_CREDITS) & M_VC1_CPLH_CREDITS)

#define S_VC1_CPLD_CREDITS    0
#define M_VC1_CPLD_CREDITS    0xfffU
#define V_VC1_CPLD_CREDITS(x) ((x) << S_VC1_CPLD_CREDITS)
#define G_VC1_CPLD_CREDITS(x) (((x) >> S_VC1_CPLD_CREDITS) & M_VC1_CPLD_CREDITS)

#define A_PCIE_CORE_LINK_WIDTH_SPEED_CHANGE 0x580c

#define S_SEL_DEEMPHASIS    20
#define V_SEL_DEEMPHASIS(x) ((x) << S_SEL_DEEMPHASIS)
#define F_SEL_DEEMPHASIS    V_SEL_DEEMPHASIS(1U)

#define S_TXCMPLRCV    19
#define V_TXCMPLRCV(x) ((x) << S_TXCMPLRCV)
#define F_TXCMPLRCV    V_TXCMPLRCV(1U)

#define S_PHYTXSWING    18
#define V_PHYTXSWING(x) ((x) << S_PHYTXSWING)
#define F_PHYTXSWING    V_PHYTXSWING(1U)

#define S_DIRSPDCHANGE    17
#define V_DIRSPDCHANGE(x) ((x) << S_DIRSPDCHANGE)
#define F_DIRSPDCHANGE    V_DIRSPDCHANGE(1U)

#define S_NUM_LANES    8
#define M_NUM_LANES    0x1ffU
#define V_NUM_LANES(x) ((x) << S_NUM_LANES)
#define G_NUM_LANES(x) (((x) >> S_NUM_LANES) & M_NUM_LANES)

#define S_NFTS_GEN2_3    0
#define M_NFTS_GEN2_3    0xffU
#define V_NFTS_GEN2_3(x) ((x) << S_NFTS_GEN2_3)
#define G_NFTS_GEN2_3(x) (((x) >> S_NFTS_GEN2_3) & M_NFTS_GEN2_3)

#define A_PCIE_CORE_PHY_STATUS 0x5810
#define A_PCIE_CORE_PHY_CONTROL 0x5814
#define A_PCIE_CORE_GEN3_CONTROL 0x5890

#define S_DC_BALANCE_DISABLE    18
#define V_DC_BALANCE_DISABLE(x) ((x) << S_DC_BALANCE_DISABLE)
#define F_DC_BALANCE_DISABLE    V_DC_BALANCE_DISABLE(1U)

#define S_DLLP_DELAY_DISABLE    17
#define V_DLLP_DELAY_DISABLE(x) ((x) << S_DLLP_DELAY_DISABLE)
#define F_DLLP_DELAY_DISABLE    V_DLLP_DELAY_DISABLE(1U)

#define S_EQL_DISABLE    16
#define V_EQL_DISABLE(x) ((x) << S_EQL_DISABLE)
#define F_EQL_DISABLE    V_EQL_DISABLE(1U)

#define S_EQL_REDO_DISABLE    11
#define V_EQL_REDO_DISABLE(x) ((x) << S_EQL_REDO_DISABLE)
#define F_EQL_REDO_DISABLE    V_EQL_REDO_DISABLE(1U)

#define S_EQL_EIEOS_CNTRST_DISABLE    10
#define V_EQL_EIEOS_CNTRST_DISABLE(x) ((x) << S_EQL_EIEOS_CNTRST_DISABLE)
#define F_EQL_EIEOS_CNTRST_DISABLE    V_EQL_EIEOS_CNTRST_DISABLE(1U)

#define S_EQL_PH2_PH3_DISABLE    9
#define V_EQL_PH2_PH3_DISABLE(x) ((x) << S_EQL_PH2_PH3_DISABLE)
#define F_EQL_PH2_PH3_DISABLE    V_EQL_PH2_PH3_DISABLE(1U)

#define S_DISABLE_SCRAMBLER    8
#define V_DISABLE_SCRAMBLER(x) ((x) << S_DISABLE_SCRAMBLER)
#define F_DISABLE_SCRAMBLER    V_DISABLE_SCRAMBLER(1U)

#define A_PCIE_CORE_GEN3_EQ_FS_LF 0x5894

#define S_FULL_SWING    6
#define M_FULL_SWING    0x3fU
#define V_FULL_SWING(x) ((x) << S_FULL_SWING)
#define G_FULL_SWING(x) (((x) >> S_FULL_SWING) & M_FULL_SWING)

#define S_LOW_FREQUENCY    0
#define M_LOW_FREQUENCY    0x3fU
#define V_LOW_FREQUENCY(x) ((x) << S_LOW_FREQUENCY)
#define G_LOW_FREQUENCY(x) (((x) >> S_LOW_FREQUENCY) & M_LOW_FREQUENCY)

#define A_PCIE_CORE_GEN3_EQ_PRESET_COEFF 0x5898

#define S_POSTCURSOR    12
#define M_POSTCURSOR    0x3fU
#define V_POSTCURSOR(x) ((x) << S_POSTCURSOR)
#define G_POSTCURSOR(x) (((x) >> S_POSTCURSOR) & M_POSTCURSOR)

#define S_CURSOR    6
#define M_CURSOR    0x3fU
#define V_CURSOR(x) ((x) << S_CURSOR)
#define G_CURSOR(x) (((x) >> S_CURSOR) & M_CURSOR)

#define S_PRECURSOR    0
#define M_PRECURSOR    0x3fU
#define V_PRECURSOR(x) ((x) << S_PRECURSOR)
#define G_PRECURSOR(x) (((x) >> S_PRECURSOR) & M_PRECURSOR)

#define A_PCIE_CORE_GEN3_EQ_PRESET_INDEX 0x589c

#define S_INDEX    0
#define M_INDEX    0xfU
#define V_INDEX(x) ((x) << S_INDEX)
#define G_INDEX(x) (((x) >> S_INDEX) & M_INDEX)

#define A_PCIE_CORE_GEN3_EQ_STATUS 0x58a4

#define S_LEGALITY_STATUS    0
#define V_LEGALITY_STATUS(x) ((x) << S_LEGALITY_STATUS)
#define F_LEGALITY_STATUS    V_LEGALITY_STATUS(1U)

#define A_PCIE_CORE_GEN3_EQ_CONTROL 0x58a8

#define S_INCLUDE_INITIAL_FOM    24
#define V_INCLUDE_INITIAL_FOM(x) ((x) << S_INCLUDE_INITIAL_FOM)
#define F_INCLUDE_INITIAL_FOM    V_INCLUDE_INITIAL_FOM(1U)

#define S_PRESET_REQUEST_VECTOR    8
#define M_PRESET_REQUEST_VECTOR    0xffffU
#define V_PRESET_REQUEST_VECTOR(x) ((x) << S_PRESET_REQUEST_VECTOR)
#define G_PRESET_REQUEST_VECTOR(x) (((x) >> S_PRESET_REQUEST_VECTOR) & M_PRESET_REQUEST_VECTOR)

#define S_PHASE23_2MS_TIMEOUT_DISABLE    5
#define V_PHASE23_2MS_TIMEOUT_DISABLE(x) ((x) << S_PHASE23_2MS_TIMEOUT_DISABLE)
#define F_PHASE23_2MS_TIMEOUT_DISABLE    V_PHASE23_2MS_TIMEOUT_DISABLE(1U)

#define S_AFTER24MS    4
#define V_AFTER24MS(x) ((x) << S_AFTER24MS)
#define F_AFTER24MS    V_AFTER24MS(1U)

#define S_FEEDBACK_MODE    0
#define M_FEEDBACK_MODE    0xfU
#define V_FEEDBACK_MODE(x) ((x) << S_FEEDBACK_MODE)
#define G_FEEDBACK_MODE(x) (((x) >> S_FEEDBACK_MODE) & M_FEEDBACK_MODE)

#define A_PCIE_CORE_GEN3_EQ_DIRCHANGE_FEEDBACK 0x58ac

#define S_WINAPERTURE_CPLUS1    14
#define M_WINAPERTURE_CPLUS1    0xfU
#define V_WINAPERTURE_CPLUS1(x) ((x) << S_WINAPERTURE_CPLUS1)
#define G_WINAPERTURE_CPLUS1(x) (((x) >> S_WINAPERTURE_CPLUS1) & M_WINAPERTURE_CPLUS1)

#define S_WINAPERTURE_CMINS1    10
#define M_WINAPERTURE_CMINS1    0xfU
#define V_WINAPERTURE_CMINS1(x) ((x) << S_WINAPERTURE_CMINS1)
#define G_WINAPERTURE_CMINS1(x) (((x) >> S_WINAPERTURE_CMINS1) & M_WINAPERTURE_CMINS1)

#define S_CONVERGENCE_WINDEPTH    5
#define M_CONVERGENCE_WINDEPTH    0x1fU
#define V_CONVERGENCE_WINDEPTH(x) ((x) << S_CONVERGENCE_WINDEPTH)
#define G_CONVERGENCE_WINDEPTH(x) (((x) >> S_CONVERGENCE_WINDEPTH) & M_CONVERGENCE_WINDEPTH)

#define S_EQMASTERPHASE_MINTIME    0
#define M_EQMASTERPHASE_MINTIME    0x1fU
#define V_EQMASTERPHASE_MINTIME(x) ((x) << S_EQMASTERPHASE_MINTIME)
#define G_EQMASTERPHASE_MINTIME(x) (((x) >> S_EQMASTERPHASE_MINTIME) & M_EQMASTERPHASE_MINTIME)

#define A_PCIE_CORE_PIPE_CONTROL 0x58b8

#define S_PIPE_LOOPBACK_EN    0
#define V_PIPE_LOOPBACK_EN(x) ((x) << S_PIPE_LOOPBACK_EN)
#define F_PIPE_LOOPBACK_EN    V_PIPE_LOOPBACK_EN(1U)

#define A_PCIE_CORE_DBI_RO_WE 0x58bc

#define S_READONLY_WRITEEN    0
#define V_READONLY_WRITEEN(x) ((x) << S_READONLY_WRITEEN)
#define F_READONLY_WRITEEN    V_READONLY_WRITEEN(1U)

#define A_PCIE_CORE_UTL_SYSTEM_BUS_CONTROL 0x5900

#define S_SMTD    27
#define V_SMTD(x) ((x) << S_SMTD)
#define F_SMTD    V_SMTD(1U)

#define S_SSTD    26
#define V_SSTD(x) ((x) << S_SSTD)
#define F_SSTD    V_SSTD(1U)

#define S_SWD0    23
#define V_SWD0(x) ((x) << S_SWD0)
#define F_SWD0    V_SWD0(1U)

#define S_SWD1    22
#define V_SWD1(x) ((x) << S_SWD1)
#define F_SWD1    V_SWD1(1U)

#define S_SWD2    21
#define V_SWD2(x) ((x) << S_SWD2)
#define F_SWD2    V_SWD2(1U)

#define S_SWD3    20
#define V_SWD3(x) ((x) << S_SWD3)
#define F_SWD3    V_SWD3(1U)

#define S_SWD4    19
#define V_SWD4(x) ((x) << S_SWD4)
#define F_SWD4    V_SWD4(1U)

#define S_SWD5    18
#define V_SWD5(x) ((x) << S_SWD5)
#define F_SWD5    V_SWD5(1U)

#define S_SWD6    17
#define V_SWD6(x) ((x) << S_SWD6)
#define F_SWD6    V_SWD6(1U)

#define S_SWD7    16
#define V_SWD7(x) ((x) << S_SWD7)
#define F_SWD7    V_SWD7(1U)

#define S_SWD8    15
#define V_SWD8(x) ((x) << S_SWD8)
#define F_SWD8    V_SWD8(1U)

#define S_SRD0    13
#define V_SRD0(x) ((x) << S_SRD0)
#define F_SRD0    V_SRD0(1U)

#define S_SRD1    12
#define V_SRD1(x) ((x) << S_SRD1)
#define F_SRD1    V_SRD1(1U)

#define S_SRD2    11
#define V_SRD2(x) ((x) << S_SRD2)
#define F_SRD2    V_SRD2(1U)

#define S_SRD3    10
#define V_SRD3(x) ((x) << S_SRD3)
#define F_SRD3    V_SRD3(1U)

#define S_SRD4    9
#define V_SRD4(x) ((x) << S_SRD4)
#define F_SRD4    V_SRD4(1U)

#define S_SRD5    8
#define V_SRD5(x) ((x) << S_SRD5)
#define F_SRD5    V_SRD5(1U)

#define S_SRD6    7
#define V_SRD6(x) ((x) << S_SRD6)
#define F_SRD6    V_SRD6(1U)

#define S_SRD7    6
#define V_SRD7(x) ((x) << S_SRD7)
#define F_SRD7    V_SRD7(1U)

#define S_SRD8    5
#define V_SRD8(x) ((x) << S_SRD8)
#define F_SRD8    V_SRD8(1U)

#define S_CRRE    3
#define V_CRRE(x) ((x) << S_CRRE)
#define F_CRRE    V_CRRE(1U)

#define S_CRMC    0
#define M_CRMC    0x7U
#define V_CRMC(x) ((x) << S_CRMC)
#define G_CRMC(x) (((x) >> S_CRMC) & M_CRMC)

#define A_PCIE_CORE_UTL_STATUS 0x5904

#define S_USBP    31
#define V_USBP(x) ((x) << S_USBP)
#define F_USBP    V_USBP(1U)

#define S_UPEP    30
#define V_UPEP(x) ((x) << S_UPEP)
#define F_UPEP    V_UPEP(1U)

#define S_RCEP    29
#define V_RCEP(x) ((x) << S_RCEP)
#define F_RCEP    V_RCEP(1U)

#define S_EPEP    28
#define V_EPEP(x) ((x) << S_EPEP)
#define F_EPEP    V_EPEP(1U)

#define S_USBS    27
#define V_USBS(x) ((x) << S_USBS)
#define F_USBS    V_USBS(1U)

#define S_UPES    26
#define V_UPES(x) ((x) << S_UPES)
#define F_UPES    V_UPES(1U)

#define S_RCES    25
#define V_RCES(x) ((x) << S_RCES)
#define F_RCES    V_RCES(1U)

#define S_EPES    24
#define V_EPES(x) ((x) << S_EPES)
#define F_EPES    V_EPES(1U)

#define A_PCIE_CORE_UTL_SYSTEM_BUS_AGENT_STATUS 0x5908

#define S_RNPP    31
#define V_RNPP(x) ((x) << S_RNPP)
#define F_RNPP    V_RNPP(1U)

#define S_RPCP    29
#define V_RPCP(x) ((x) << S_RPCP)
#define F_RPCP    V_RPCP(1U)

#define S_RCIP    27
#define V_RCIP(x) ((x) << S_RCIP)
#define F_RCIP    V_RCIP(1U)

#define S_RCCP    26
#define V_RCCP(x) ((x) << S_RCCP)
#define F_RCCP    V_RCCP(1U)

#define S_RFTP    23
#define V_RFTP(x) ((x) << S_RFTP)
#define F_RFTP    V_RFTP(1U)

#define S_PTRP    20
#define V_PTRP(x) ((x) << S_PTRP)
#define F_PTRP    V_PTRP(1U)

#define A_PCIE_CORE_UTL_SYSTEM_BUS_AGENT_ERROR_SEVERITY 0x590c

#define S_RNPS    31
#define V_RNPS(x) ((x) << S_RNPS)
#define F_RNPS    V_RNPS(1U)

#define S_RPCS    29
#define V_RPCS(x) ((x) << S_RPCS)
#define F_RPCS    V_RPCS(1U)

#define S_RCIS    27
#define V_RCIS(x) ((x) << S_RCIS)
#define F_RCIS    V_RCIS(1U)

#define S_RCCS    26
#define V_RCCS(x) ((x) << S_RCCS)
#define F_RCCS    V_RCCS(1U)

#define S_RFTS    23
#define V_RFTS(x) ((x) << S_RFTS)
#define F_RFTS    V_RFTS(1U)

#define A_PCIE_CORE_UTL_SYSTEM_BUS_AGENT_INTERRUPT_ENABLE 0x5910

#define S_RNPI    31
#define V_RNPI(x) ((x) << S_RNPI)
#define F_RNPI    V_RNPI(1U)

#define S_RPCI    29
#define V_RPCI(x) ((x) << S_RPCI)
#define F_RPCI    V_RPCI(1U)

#define S_RCII    27
#define V_RCII(x) ((x) << S_RCII)
#define F_RCII    V_RCII(1U)

#define S_RCCI    26
#define V_RCCI(x) ((x) << S_RCCI)
#define F_RCCI    V_RCCI(1U)

#define S_RFTI    23
#define V_RFTI(x) ((x) << S_RFTI)
#define F_RFTI    V_RFTI(1U)

#define A_PCIE_CORE_SYSTEM_BUS_BURST_SIZE_CONFIGURATION 0x5920

#define S_SBRS    28
#define M_SBRS    0x7U
#define V_SBRS(x) ((x) << S_SBRS)
#define G_SBRS(x) (((x) >> S_SBRS) & M_SBRS)

#define S_OTWS    20
#define M_OTWS    0x7U
#define V_OTWS(x) ((x) << S_OTWS)
#define G_OTWS(x) (((x) >> S_OTWS) & M_OTWS)

#define A_PCIE_CORE_REVISION_ID 0x5924

#define S_RVID    20
#define M_RVID    0xfffU
#define V_RVID(x) ((x) << S_RVID)
#define G_RVID(x) (((x) >> S_RVID) & M_RVID)

#define S_BRVN    12
#define M_BRVN    0xffU
#define V_BRVN(x) ((x) << S_BRVN)
#define G_BRVN(x) (((x) >> S_BRVN) & M_BRVN)

#define A_PCIE_T5_DMA_CFG 0x5940

#define S_T5_DMA_MAXREQCNT    20
#define M_T5_DMA_MAXREQCNT    0xffU
#define V_T5_DMA_MAXREQCNT(x) ((x) << S_T5_DMA_MAXREQCNT)
#define G_T5_DMA_MAXREQCNT(x) (((x) >> S_T5_DMA_MAXREQCNT) & M_T5_DMA_MAXREQCNT)

#define S_T5_DMA_MAXRDREQSIZE    17
#define M_T5_DMA_MAXRDREQSIZE    0x7U
#define V_T5_DMA_MAXRDREQSIZE(x) ((x) << S_T5_DMA_MAXRDREQSIZE)
#define G_T5_DMA_MAXRDREQSIZE(x) (((x) >> S_T5_DMA_MAXRDREQSIZE) & M_T5_DMA_MAXRDREQSIZE)

#define S_T5_DMA_MAXRSPCNT    8
#define M_T5_DMA_MAXRSPCNT    0x1ffU
#define V_T5_DMA_MAXRSPCNT(x) ((x) << S_T5_DMA_MAXRSPCNT)
#define G_T5_DMA_MAXRSPCNT(x) (((x) >> S_T5_DMA_MAXRSPCNT) & M_T5_DMA_MAXRSPCNT)

#define S_SEQCHKDIS    7
#define V_SEQCHKDIS(x) ((x) << S_SEQCHKDIS)
#define F_SEQCHKDIS    V_SEQCHKDIS(1U)

#define S_MINTAG    0
#define M_MINTAG    0x7fU
#define V_MINTAG(x) ((x) << S_MINTAG)
#define G_MINTAG(x) (((x) >> S_MINTAG) & M_MINTAG)

#define A_PCIE_T5_DMA_STAT 0x5944

#define S_DMA_RESPCNT    20
#define M_DMA_RESPCNT    0xfffU
#define V_DMA_RESPCNT(x) ((x) << S_DMA_RESPCNT)
#define G_DMA_RESPCNT(x) (((x) >> S_DMA_RESPCNT) & M_DMA_RESPCNT)

#define S_DMA_RDREQCNT    12
#define M_DMA_RDREQCNT    0xffU
#define V_DMA_RDREQCNT(x) ((x) << S_DMA_RDREQCNT)
#define G_DMA_RDREQCNT(x) (((x) >> S_DMA_RDREQCNT) & M_DMA_RDREQCNT)

#define S_DMA_WRREQCNT    0
#define M_DMA_WRREQCNT    0x7ffU
#define V_DMA_WRREQCNT(x) ((x) << S_DMA_WRREQCNT)
#define G_DMA_WRREQCNT(x) (((x) >> S_DMA_WRREQCNT) & M_DMA_WRREQCNT)

#define A_PCIE_T5_DMA_STAT2 0x5948

#define S_COOKIECNT    24
#define M_COOKIECNT    0xfU
#define V_COOKIECNT(x) ((x) << S_COOKIECNT)
#define G_COOKIECNT(x) (((x) >> S_COOKIECNT) & M_COOKIECNT)

#define S_RDSEQNUMUPDCNT    20
#define M_RDSEQNUMUPDCNT    0xfU
#define V_RDSEQNUMUPDCNT(x) ((x) << S_RDSEQNUMUPDCNT)
#define G_RDSEQNUMUPDCNT(x) (((x) >> S_RDSEQNUMUPDCNT) & M_RDSEQNUMUPDCNT)

#define S_SIREQCNT    16
#define M_SIREQCNT    0xfU
#define V_SIREQCNT(x) ((x) << S_SIREQCNT)
#define G_SIREQCNT(x) (((x) >> S_SIREQCNT) & M_SIREQCNT)

#define S_WREOPMATCHSOP    12
#define V_WREOPMATCHSOP(x) ((x) << S_WREOPMATCHSOP)
#define F_WREOPMATCHSOP    V_WREOPMATCHSOP(1U)

#define S_WRSOPCNT    8
#define M_WRSOPCNT    0xfU
#define V_WRSOPCNT(x) ((x) << S_WRSOPCNT)
#define G_WRSOPCNT(x) (((x) >> S_WRSOPCNT) & M_WRSOPCNT)

#define S_RDSOPCNT    0
#define M_RDSOPCNT    0xffU
#define V_RDSOPCNT(x) ((x) << S_RDSOPCNT)
#define G_RDSOPCNT(x) (((x) >> S_RDSOPCNT) & M_RDSOPCNT)

#define A_PCIE_T5_DMA_STAT3 0x594c

#define S_ATMREQSOPCNT    24
#define M_ATMREQSOPCNT    0xffU
#define V_ATMREQSOPCNT(x) ((x) << S_ATMREQSOPCNT)
#define G_ATMREQSOPCNT(x) (((x) >> S_ATMREQSOPCNT) & M_ATMREQSOPCNT)

#define S_ATMEOPMATCHSOP    17
#define V_ATMEOPMATCHSOP(x) ((x) << S_ATMEOPMATCHSOP)
#define F_ATMEOPMATCHSOP    V_ATMEOPMATCHSOP(1U)

#define S_RSPEOPMATCHSOP    16
#define V_RSPEOPMATCHSOP(x) ((x) << S_RSPEOPMATCHSOP)
#define F_RSPEOPMATCHSOP    V_RSPEOPMATCHSOP(1U)

#define S_RSPERRCNT    8
#define M_RSPERRCNT    0xffU
#define V_RSPERRCNT(x) ((x) << S_RSPERRCNT)
#define G_RSPERRCNT(x) (((x) >> S_RSPERRCNT) & M_RSPERRCNT)

#define S_RSPSOPCNT    0
#define M_RSPSOPCNT    0xffU
#define V_RSPSOPCNT(x) ((x) << S_RSPSOPCNT)
#define G_RSPSOPCNT(x) (((x) >> S_RSPSOPCNT) & M_RSPSOPCNT)

#define A_PCIE_CORE_OUTBOUND_POSTED_HEADER_BUFFER_ALLOCATION 0x5960

#define S_OP0H    24
#define M_OP0H    0xfU
#define V_OP0H(x) ((x) << S_OP0H)
#define G_OP0H(x) (((x) >> S_OP0H) & M_OP0H)

#define S_OP1H    16
#define M_OP1H    0xfU
#define V_OP1H(x) ((x) << S_OP1H)
#define G_OP1H(x) (((x) >> S_OP1H) & M_OP1H)

#define S_OP2H    8
#define M_OP2H    0xfU
#define V_OP2H(x) ((x) << S_OP2H)
#define G_OP2H(x) (((x) >> S_OP2H) & M_OP2H)

#define S_OP3H    0
#define M_OP3H    0xfU
#define V_OP3H(x) ((x) << S_OP3H)
#define G_OP3H(x) (((x) >> S_OP3H) & M_OP3H)

#define A_PCIE_CORE_OUTBOUND_POSTED_DATA_BUFFER_ALLOCATION 0x5968

#define S_OP0D    24
#define M_OP0D    0x7fU
#define V_OP0D(x) ((x) << S_OP0D)
#define G_OP0D(x) (((x) >> S_OP0D) & M_OP0D)

#define S_OP1D    16
#define M_OP1D    0x7fU
#define V_OP1D(x) ((x) << S_OP1D)
#define G_OP1D(x) (((x) >> S_OP1D) & M_OP1D)

#define S_OP2D    8
#define M_OP2D    0x7fU
#define V_OP2D(x) ((x) << S_OP2D)
#define G_OP2D(x) (((x) >> S_OP2D) & M_OP2D)

#define S_OP3D    0
#define M_OP3D    0x7fU
#define V_OP3D(x) ((x) << S_OP3D)
#define G_OP3D(x) (((x) >> S_OP3D) & M_OP3D)

#define A_PCIE_CORE_INBOUND_POSTED_HEADER_BUFFER_ALLOCATION 0x5970

#define S_IP0H    24
#define M_IP0H    0x3fU
#define V_IP0H(x) ((x) << S_IP0H)
#define G_IP0H(x) (((x) >> S_IP0H) & M_IP0H)

#define S_IP1H    16
#define M_IP1H    0x3fU
#define V_IP1H(x) ((x) << S_IP1H)
#define G_IP1H(x) (((x) >> S_IP1H) & M_IP1H)

#define S_IP2H    8
#define M_IP2H    0x3fU
#define V_IP2H(x) ((x) << S_IP2H)
#define G_IP2H(x) (((x) >> S_IP2H) & M_IP2H)

#define S_IP3H    0
#define M_IP3H    0x3fU
#define V_IP3H(x) ((x) << S_IP3H)
#define G_IP3H(x) (((x) >> S_IP3H) & M_IP3H)

#define A_PCIE_CORE_INBOUND_POSTED_DATA_BUFFER_ALLOCATION 0x5978

#define S_IP0D    24
#define M_IP0D    0xffU
#define V_IP0D(x) ((x) << S_IP0D)
#define G_IP0D(x) (((x) >> S_IP0D) & M_IP0D)

#define S_IP1D    16
#define M_IP1D    0xffU
#define V_IP1D(x) ((x) << S_IP1D)
#define G_IP1D(x) (((x) >> S_IP1D) & M_IP1D)

#define S_IP2D    8
#define M_IP2D    0xffU
#define V_IP2D(x) ((x) << S_IP2D)
#define G_IP2D(x) (((x) >> S_IP2D) & M_IP2D)

#define S_IP3D    0
#define M_IP3D    0xffU
#define V_IP3D(x) ((x) << S_IP3D)
#define G_IP3D(x) (((x) >> S_IP3D) & M_IP3D)

#define A_PCIE_CORE_OUTBOUND_NON_POSTED_BUFFER_ALLOCATION 0x5980

#define S_ON0H    24
#define M_ON0H    0xfU
#define V_ON0H(x) ((x) << S_ON0H)
#define G_ON0H(x) (((x) >> S_ON0H) & M_ON0H)

#define S_ON1H    16
#define M_ON1H    0xfU
#define V_ON1H(x) ((x) << S_ON1H)
#define G_ON1H(x) (((x) >> S_ON1H) & M_ON1H)

#define S_ON2H    8
#define M_ON2H    0xfU
#define V_ON2H(x) ((x) << S_ON2H)
#define G_ON2H(x) (((x) >> S_ON2H) & M_ON2H)

#define S_ON3H    0
#define M_ON3H    0xfU
#define V_ON3H(x) ((x) << S_ON3H)
#define G_ON3H(x) (((x) >> S_ON3H) & M_ON3H)

#define A_PCIE_T5_CMD_CFG 0x5980

#define S_T5_CMD_MAXRDREQSIZE    17
#define M_T5_CMD_MAXRDREQSIZE    0x7U
#define V_T5_CMD_MAXRDREQSIZE(x) ((x) << S_T5_CMD_MAXRDREQSIZE)
#define G_T5_CMD_MAXRDREQSIZE(x) (((x) >> S_T5_CMD_MAXRDREQSIZE) & M_T5_CMD_MAXRDREQSIZE)

#define S_T5_CMD_MAXRSPCNT    8
#define M_T5_CMD_MAXRSPCNT    0xffU
#define V_T5_CMD_MAXRSPCNT(x) ((x) << S_T5_CMD_MAXRSPCNT)
#define G_T5_CMD_MAXRSPCNT(x) (((x) >> S_T5_CMD_MAXRSPCNT) & M_T5_CMD_MAXRSPCNT)

#define S_USECMDPOOL    7
#define V_USECMDPOOL(x) ((x) << S_USECMDPOOL)
#define F_USECMDPOOL    V_USECMDPOOL(1U)

#define A_PCIE_T5_CMD_STAT 0x5984

#define S_T5_STAT_RSPCNT    20
#define M_T5_STAT_RSPCNT    0x7ffU
#define V_T5_STAT_RSPCNT(x) ((x) << S_T5_STAT_RSPCNT)
#define G_T5_STAT_RSPCNT(x) (((x) >> S_T5_STAT_RSPCNT) & M_T5_STAT_RSPCNT)

#define S_RDREQCNT    12
#define M_RDREQCNT    0x1fU
#define V_RDREQCNT(x) ((x) << S_RDREQCNT)
#define G_RDREQCNT(x) (((x) >> S_RDREQCNT) & M_RDREQCNT)

#define A_PCIE_CORE_INBOUND_NON_POSTED_REQUESTS_BUFFER_ALLOCATION 0x5988

#define S_IN0H    24
#define M_IN0H    0x3fU
#define V_IN0H(x) ((x) << S_IN0H)
#define G_IN0H(x) (((x) >> S_IN0H) & M_IN0H)

#define S_IN1H    16
#define M_IN1H    0x3fU
#define V_IN1H(x) ((x) << S_IN1H)
#define G_IN1H(x) (((x) >> S_IN1H) & M_IN1H)

#define S_IN2H    8
#define M_IN2H    0x3fU
#define V_IN2H(x) ((x) << S_IN2H)
#define G_IN2H(x) (((x) >> S_IN2H) & M_IN2H)

#define S_IN3H    0
#define M_IN3H    0x3fU
#define V_IN3H(x) ((x) << S_IN3H)
#define G_IN3H(x) (((x) >> S_IN3H) & M_IN3H)

#define A_PCIE_T5_CMD_STAT2 0x5988
#define A_PCIE_T5_CMD_STAT3 0x598c
#define A_PCIE_CORE_PCI_EXPRESS_TAGS_ALLOCATION 0x5990

#define S_OC0T    24
#define M_OC0T    0xffU
#define V_OC0T(x) ((x) << S_OC0T)
#define G_OC0T(x) (((x) >> S_OC0T) & M_OC0T)

#define S_OC1T    16
#define M_OC1T    0xffU
#define V_OC1T(x) ((x) << S_OC1T)
#define G_OC1T(x) (((x) >> S_OC1T) & M_OC1T)

#define S_OC2T    8
#define M_OC2T    0xffU
#define V_OC2T(x) ((x) << S_OC2T)
#define G_OC2T(x) (((x) >> S_OC2T) & M_OC2T)

#define S_OC3T    0
#define M_OC3T    0xffU
#define V_OC3T(x) ((x) << S_OC3T)
#define G_OC3T(x) (((x) >> S_OC3T) & M_OC3T)

#define A_PCIE_CORE_GBIF_READ_TAGS_ALLOCATION 0x5998

#define S_IC0T    24
#define M_IC0T    0x3fU
#define V_IC0T(x) ((x) << S_IC0T)
#define G_IC0T(x) (((x) >> S_IC0T) & M_IC0T)

#define S_IC1T    16
#define M_IC1T    0x3fU
#define V_IC1T(x) ((x) << S_IC1T)
#define G_IC1T(x) (((x) >> S_IC1T) & M_IC1T)

#define S_IC2T    8
#define M_IC2T    0x3fU
#define V_IC2T(x) ((x) << S_IC2T)
#define G_IC2T(x) (((x) >> S_IC2T) & M_IC2T)

#define S_IC3T    0
#define M_IC3T    0x3fU
#define V_IC3T(x) ((x) << S_IC3T)
#define G_IC3T(x) (((x) >> S_IC3T) & M_IC3T)

#define A_PCIE_CORE_UTL_PCI_EXPRESS_PORT_CONTROL 0x59a0

#define S_VRB0    31
#define V_VRB0(x) ((x) << S_VRB0)
#define F_VRB0    V_VRB0(1U)

#define S_VRB1    30
#define V_VRB1(x) ((x) << S_VRB1)
#define F_VRB1    V_VRB1(1U)

#define S_VRB2    29
#define V_VRB2(x) ((x) << S_VRB2)
#define F_VRB2    V_VRB2(1U)

#define S_VRB3    28
#define V_VRB3(x) ((x) << S_VRB3)
#define F_VRB3    V_VRB3(1U)

#define S_PSFE    26
#define V_PSFE(x) ((x) << S_PSFE)
#define F_PSFE    V_PSFE(1U)

#define S_RVDE    25
#define V_RVDE(x) ((x) << S_RVDE)
#define F_RVDE    V_RVDE(1U)

#define S_TXE0    23
#define V_TXE0(x) ((x) << S_TXE0)
#define F_TXE0    V_TXE0(1U)

#define S_TXE1    22
#define V_TXE1(x) ((x) << S_TXE1)
#define F_TXE1    V_TXE1(1U)

#define S_TXE2    21
#define V_TXE2(x) ((x) << S_TXE2)
#define F_TXE2    V_TXE2(1U)

#define S_TXE3    20
#define V_TXE3(x) ((x) << S_TXE3)
#define F_TXE3    V_TXE3(1U)

#define S_RPAM    13
#define V_RPAM(x) ((x) << S_RPAM)
#define F_RPAM    V_RPAM(1U)

#define S_RTOS    4
#define M_RTOS    0xfU
#define V_RTOS(x) ((x) << S_RTOS)
#define G_RTOS(x) (((x) >> S_RTOS) & M_RTOS)

#define A_PCIE_CORE_UTL_PCI_EXPRESS_PORT_STATUS 0x59a4

#define S_TPCP    30
#define V_TPCP(x) ((x) << S_TPCP)
#define F_TPCP    V_TPCP(1U)

#define S_TNPP    29
#define V_TNPP(x) ((x) << S_TNPP)
#define F_TNPP    V_TNPP(1U)

#define S_TFTP    28
#define V_TFTP(x) ((x) << S_TFTP)
#define F_TFTP    V_TFTP(1U)

#define S_TCAP    27
#define V_TCAP(x) ((x) << S_TCAP)
#define F_TCAP    V_TCAP(1U)

#define S_TCIP    26
#define V_TCIP(x) ((x) << S_TCIP)
#define F_TCIP    V_TCIP(1U)

#define S_RCAP    25
#define V_RCAP(x) ((x) << S_RCAP)
#define F_RCAP    V_RCAP(1U)

#define S_PLUP    23
#define V_PLUP(x) ((x) << S_PLUP)
#define F_PLUP    V_PLUP(1U)

#define S_PLDN    22
#define V_PLDN(x) ((x) << S_PLDN)
#define F_PLDN    V_PLDN(1U)

#define S_OTDD    21
#define V_OTDD(x) ((x) << S_OTDD)
#define F_OTDD    V_OTDD(1U)

#define S_GTRP    20
#define V_GTRP(x) ((x) << S_GTRP)
#define F_GTRP    V_GTRP(1U)

#define S_RDPE    18
#define V_RDPE(x) ((x) << S_RDPE)
#define F_RDPE    V_RDPE(1U)

#define S_TDCE    17
#define V_TDCE(x) ((x) << S_TDCE)
#define F_TDCE    V_TDCE(1U)

#define S_TDUE    16
#define V_TDUE(x) ((x) << S_TDUE)
#define F_TDUE    V_TDUE(1U)

#define A_PCIE_CORE_UTL_PCI_EXPRESS_PORT_ERROR_SEVERITY 0x59a8

#define S_TPCS    30
#define V_TPCS(x) ((x) << S_TPCS)
#define F_TPCS    V_TPCS(1U)

#define S_TNPS    29
#define V_TNPS(x) ((x) << S_TNPS)
#define F_TNPS    V_TNPS(1U)

#define S_TFTS    28
#define V_TFTS(x) ((x) << S_TFTS)
#define F_TFTS    V_TFTS(1U)

#define S_TCAS    27
#define V_TCAS(x) ((x) << S_TCAS)
#define F_TCAS    V_TCAS(1U)

#define S_TCIS    26
#define V_TCIS(x) ((x) << S_TCIS)
#define F_TCIS    V_TCIS(1U)

#define S_RCAS    25
#define V_RCAS(x) ((x) << S_RCAS)
#define F_RCAS    V_RCAS(1U)

#define S_PLUS    23
#define V_PLUS(x) ((x) << S_PLUS)
#define F_PLUS    V_PLUS(1U)

#define S_PLDS    22
#define V_PLDS(x) ((x) << S_PLDS)
#define F_PLDS    V_PLDS(1U)

#define S_OTDS    21
#define V_OTDS(x) ((x) << S_OTDS)
#define F_OTDS    V_OTDS(1U)

#define S_RDPS    18
#define V_RDPS(x) ((x) << S_RDPS)
#define F_RDPS    V_RDPS(1U)

#define S_TDCS    17
#define V_TDCS(x) ((x) << S_TDCS)
#define F_TDCS    V_TDCS(1U)

#define S_TDUS    16
#define V_TDUS(x) ((x) << S_TDUS)
#define F_TDUS    V_TDUS(1U)

#define A_PCIE_CORE_UTL_PCI_EXPRESS_PORT_INTERRUPT_ENABLE 0x59ac

#define S_TPCI    30
#define V_TPCI(x) ((x) << S_TPCI)
#define F_TPCI    V_TPCI(1U)

#define S_TNPI    29
#define V_TNPI(x) ((x) << S_TNPI)
#define F_TNPI    V_TNPI(1U)

#define S_TFTI    28
#define V_TFTI(x) ((x) << S_TFTI)
#define F_TFTI    V_TFTI(1U)

#define S_TCAI    27
#define V_TCAI(x) ((x) << S_TCAI)
#define F_TCAI    V_TCAI(1U)

#define S_TCII    26
#define V_TCII(x) ((x) << S_TCII)
#define F_TCII    V_TCII(1U)

#define S_RCAI    25
#define V_RCAI(x) ((x) << S_RCAI)
#define F_RCAI    V_RCAI(1U)

#define S_PLUI    23
#define V_PLUI(x) ((x) << S_PLUI)
#define F_PLUI    V_PLUI(1U)

#define S_PLDI    22
#define V_PLDI(x) ((x) << S_PLDI)
#define F_PLDI    V_PLDI(1U)

#define S_OTDI    21
#define V_OTDI(x) ((x) << S_OTDI)
#define F_OTDI    V_OTDI(1U)

#define A_PCIE_CORE_ROOT_COMPLEX_STATUS 0x59b0

#define S_RLCE    31
#define V_RLCE(x) ((x) << S_RLCE)
#define F_RLCE    V_RLCE(1U)

#define S_RLNE    30
#define V_RLNE(x) ((x) << S_RLNE)
#define F_RLNE    V_RLNE(1U)

#define S_RLFE    29
#define V_RLFE(x) ((x) << S_RLFE)
#define F_RLFE    V_RLFE(1U)

#define S_RCPE    25
#define V_RCPE(x) ((x) << S_RCPE)
#define F_RCPE    V_RCPE(1U)

#define S_RCTO    24
#define V_RCTO(x) ((x) << S_RCTO)
#define F_RCTO    V_RCTO(1U)

#define S_PINA    23
#define V_PINA(x) ((x) << S_PINA)
#define F_PINA    V_PINA(1U)

#define S_PINB    22
#define V_PINB(x) ((x) << S_PINB)
#define F_PINB    V_PINB(1U)

#define S_PINC    21
#define V_PINC(x) ((x) << S_PINC)
#define F_PINC    V_PINC(1U)

#define S_PIND    20
#define V_PIND(x) ((x) << S_PIND)
#define F_PIND    V_PIND(1U)

#define S_ALER    19
#define V_ALER(x) ((x) << S_ALER)
#define F_ALER    V_ALER(1U)

#define S_CRSE    18
#define V_CRSE(x) ((x) << S_CRSE)
#define F_CRSE    V_CRSE(1U)

#define A_PCIE_T5_HMA_CFG 0x59b0

#define S_HMA_MAXREQCNT    20
#define M_HMA_MAXREQCNT    0x1fU
#define V_HMA_MAXREQCNT(x) ((x) << S_HMA_MAXREQCNT)
#define G_HMA_MAXREQCNT(x) (((x) >> S_HMA_MAXREQCNT) & M_HMA_MAXREQCNT)

#define S_T5_HMA_MAXRDREQSIZE    17
#define M_T5_HMA_MAXRDREQSIZE    0x7U
#define V_T5_HMA_MAXRDREQSIZE(x) ((x) << S_T5_HMA_MAXRDREQSIZE)
#define G_T5_HMA_MAXRDREQSIZE(x) (((x) >> S_T5_HMA_MAXRDREQSIZE) & M_T5_HMA_MAXRDREQSIZE)

#define S_T5_HMA_MAXRSPCNT    8
#define M_T5_HMA_MAXRSPCNT    0x1fU
#define V_T5_HMA_MAXRSPCNT(x) ((x) << S_T5_HMA_MAXRSPCNT)
#define G_T5_HMA_MAXRSPCNT(x) (((x) >> S_T5_HMA_MAXRSPCNT) & M_T5_HMA_MAXRSPCNT)

#define A_PCIE_CORE_ROOT_COMPLEX_ERROR_SEVERITY 0x59b4

#define S_RLCS    31
#define V_RLCS(x) ((x) << S_RLCS)
#define F_RLCS    V_RLCS(1U)

#define S_RLNS    30
#define V_RLNS(x) ((x) << S_RLNS)
#define F_RLNS    V_RLNS(1U)

#define S_RLFS    29
#define V_RLFS(x) ((x) << S_RLFS)
#define F_RLFS    V_RLFS(1U)

#define S_RCPS    25
#define V_RCPS(x) ((x) << S_RCPS)
#define F_RCPS    V_RCPS(1U)

#define S_RCTS    24
#define V_RCTS(x) ((x) << S_RCTS)
#define F_RCTS    V_RCTS(1U)

#define S_PAAS    23
#define V_PAAS(x) ((x) << S_PAAS)
#define F_PAAS    V_PAAS(1U)

#define S_PABS    22
#define V_PABS(x) ((x) << S_PABS)
#define F_PABS    V_PABS(1U)

#define S_PACS    21
#define V_PACS(x) ((x) << S_PACS)
#define F_PACS    V_PACS(1U)

#define S_PADS    20
#define V_PADS(x) ((x) << S_PADS)
#define F_PADS    V_PADS(1U)

#define S_ALES    19
#define V_ALES(x) ((x) << S_ALES)
#define F_ALES    V_ALES(1U)

#define S_CRSS    18
#define V_CRSS(x) ((x) << S_CRSS)
#define F_CRSS    V_CRSS(1U)

#define A_PCIE_T5_HMA_STAT 0x59b4

#define S_HMA_RESPCNT    20
#define M_HMA_RESPCNT    0x1ffU
#define V_HMA_RESPCNT(x) ((x) << S_HMA_RESPCNT)
#define G_HMA_RESPCNT(x) (((x) >> S_HMA_RESPCNT) & M_HMA_RESPCNT)

#define S_HMA_RDREQCNT    12
#define M_HMA_RDREQCNT    0x3fU
#define V_HMA_RDREQCNT(x) ((x) << S_HMA_RDREQCNT)
#define G_HMA_RDREQCNT(x) (((x) >> S_HMA_RDREQCNT) & M_HMA_RDREQCNT)

#define S_HMA_WRREQCNT    0
#define M_HMA_WRREQCNT    0x1ffU
#define V_HMA_WRREQCNT(x) ((x) << S_HMA_WRREQCNT)
#define G_HMA_WRREQCNT(x) (((x) >> S_HMA_WRREQCNT) & M_HMA_WRREQCNT)

#define A_PCIE_CORE_ROOT_COMPLEX_INTERRUPT_ENABLE 0x59b8

#define S_RLCI    31
#define V_RLCI(x) ((x) << S_RLCI)
#define F_RLCI    V_RLCI(1U)

#define S_RLNI    30
#define V_RLNI(x) ((x) << S_RLNI)
#define F_RLNI    V_RLNI(1U)

#define S_RLFI    29
#define V_RLFI(x) ((x) << S_RLFI)
#define F_RLFI    V_RLFI(1U)

#define S_RCPI    25
#define V_RCPI(x) ((x) << S_RCPI)
#define F_RCPI    V_RCPI(1U)

#define S_RCTI    24
#define V_RCTI(x) ((x) << S_RCTI)
#define F_RCTI    V_RCTI(1U)

#define S_PAAI    23
#define V_PAAI(x) ((x) << S_PAAI)
#define F_PAAI    V_PAAI(1U)

#define S_PABI    22
#define V_PABI(x) ((x) << S_PABI)
#define F_PABI    V_PABI(1U)

#define S_PACI    21
#define V_PACI(x) ((x) << S_PACI)
#define F_PACI    V_PACI(1U)

#define S_PADI    20
#define V_PADI(x) ((x) << S_PADI)
#define F_PADI    V_PADI(1U)

#define S_ALEI    19
#define V_ALEI(x) ((x) << S_ALEI)
#define F_ALEI    V_ALEI(1U)

#define S_CRSI    18
#define V_CRSI(x) ((x) << S_CRSI)
#define F_CRSI    V_CRSI(1U)

#define A_PCIE_T5_HMA_STAT2 0x59b8
#define A_PCIE_CORE_ENDPOINT_STATUS 0x59bc

#define S_PTOM    31
#define V_PTOM(x) ((x) << S_PTOM)
#define F_PTOM    V_PTOM(1U)

#define S_ALEA    29
#define V_ALEA(x) ((x) << S_ALEA)
#define F_ALEA    V_ALEA(1U)

#define S_PMC0    23
#define V_PMC0(x) ((x) << S_PMC0)
#define F_PMC0    V_PMC0(1U)

#define S_PMC1    22
#define V_PMC1(x) ((x) << S_PMC1)
#define F_PMC1    V_PMC1(1U)

#define S_PMC2    21
#define V_PMC2(x) ((x) << S_PMC2)
#define F_PMC2    V_PMC2(1U)

#define S_PMC3    20
#define V_PMC3(x) ((x) << S_PMC3)
#define F_PMC3    V_PMC3(1U)

#define S_PMC4    19
#define V_PMC4(x) ((x) << S_PMC4)
#define F_PMC4    V_PMC4(1U)

#define S_PMC5    18
#define V_PMC5(x) ((x) << S_PMC5)
#define F_PMC5    V_PMC5(1U)

#define S_PMC6    17
#define V_PMC6(x) ((x) << S_PMC6)
#define F_PMC6    V_PMC6(1U)

#define S_PMC7    16
#define V_PMC7(x) ((x) << S_PMC7)
#define F_PMC7    V_PMC7(1U)

#define A_PCIE_T5_HMA_STAT3 0x59bc
#define A_PCIE_CORE_ENDPOINT_ERROR_SEVERITY 0x59c0

#define S_PTOS    31
#define V_PTOS(x) ((x) << S_PTOS)
#define F_PTOS    V_PTOS(1U)

#define S_AENS    29
#define V_AENS(x) ((x) << S_AENS)
#define F_AENS    V_AENS(1U)

#define S_PC0S    23
#define V_PC0S(x) ((x) << S_PC0S)
#define F_PC0S    V_PC0S(1U)

#define S_PC1S    22
#define V_PC1S(x) ((x) << S_PC1S)
#define F_PC1S    V_PC1S(1U)

#define S_PC2S    21
#define V_PC2S(x) ((x) << S_PC2S)
#define F_PC2S    V_PC2S(1U)

#define S_PC3S    20
#define V_PC3S(x) ((x) << S_PC3S)
#define F_PC3S    V_PC3S(1U)

#define S_PC4S    19
#define V_PC4S(x) ((x) << S_PC4S)
#define F_PC4S    V_PC4S(1U)

#define S_PC5S    18
#define V_PC5S(x) ((x) << S_PC5S)
#define F_PC5S    V_PC5S(1U)

#define S_PC6S    17
#define V_PC6S(x) ((x) << S_PC6S)
#define F_PC6S    V_PC6S(1U)

#define S_PC7S    16
#define V_PC7S(x) ((x) << S_PC7S)
#define F_PC7S    V_PC7S(1U)

#define S_PME0    15
#define V_PME0(x) ((x) << S_PME0)
#define F_PME0    V_PME0(1U)

#define S_PME1    14
#define V_PME1(x) ((x) << S_PME1)
#define F_PME1    V_PME1(1U)

#define S_PME2    13
#define V_PME2(x) ((x) << S_PME2)
#define F_PME2    V_PME2(1U)

#define S_PME3    12
#define V_PME3(x) ((x) << S_PME3)
#define F_PME3    V_PME3(1U)

#define S_PME4    11
#define V_PME4(x) ((x) << S_PME4)
#define F_PME4    V_PME4(1U)

#define S_PME5    10
#define V_PME5(x) ((x) << S_PME5)
#define F_PME5    V_PME5(1U)

#define S_PME6    9
#define V_PME6(x) ((x) << S_PME6)
#define F_PME6    V_PME6(1U)

#define S_PME7    8
#define V_PME7(x) ((x) << S_PME7)
#define F_PME7    V_PME7(1U)

#define A_PCIE_CGEN 0x59c0

#define S_VPD_DYNAMIC_CGEN    26
#define V_VPD_DYNAMIC_CGEN(x) ((x) << S_VPD_DYNAMIC_CGEN)
#define F_VPD_DYNAMIC_CGEN    V_VPD_DYNAMIC_CGEN(1U)

#define S_MA_DYNAMIC_CGEN    25
#define V_MA_DYNAMIC_CGEN(x) ((x) << S_MA_DYNAMIC_CGEN)
#define F_MA_DYNAMIC_CGEN    V_MA_DYNAMIC_CGEN(1U)

#define S_TAGQ_DYNAMIC_CGEN    24
#define V_TAGQ_DYNAMIC_CGEN(x) ((x) << S_TAGQ_DYNAMIC_CGEN)
#define F_TAGQ_DYNAMIC_CGEN    V_TAGQ_DYNAMIC_CGEN(1U)

#define S_REQCTL_DYNAMIC_CGEN    23
#define V_REQCTL_DYNAMIC_CGEN(x) ((x) << S_REQCTL_DYNAMIC_CGEN)
#define F_REQCTL_DYNAMIC_CGEN    V_REQCTL_DYNAMIC_CGEN(1U)

#define S_RSPDATAPROC_DYNAMIC_CGEN    22
#define V_RSPDATAPROC_DYNAMIC_CGEN(x) ((x) << S_RSPDATAPROC_DYNAMIC_CGEN)
#define F_RSPDATAPROC_DYNAMIC_CGEN    V_RSPDATAPROC_DYNAMIC_CGEN(1U)

#define S_RSPRDQ_DYNAMIC_CGEN    21
#define V_RSPRDQ_DYNAMIC_CGEN(x) ((x) << S_RSPRDQ_DYNAMIC_CGEN)
#define F_RSPRDQ_DYNAMIC_CGEN    V_RSPRDQ_DYNAMIC_CGEN(1U)

#define S_RSPIPIF_DYNAMIC_CGEN    20
#define V_RSPIPIF_DYNAMIC_CGEN(x) ((x) << S_RSPIPIF_DYNAMIC_CGEN)
#define F_RSPIPIF_DYNAMIC_CGEN    V_RSPIPIF_DYNAMIC_CGEN(1U)

#define S_HMA_STATIC_CGEN    19
#define V_HMA_STATIC_CGEN(x) ((x) << S_HMA_STATIC_CGEN)
#define F_HMA_STATIC_CGEN    V_HMA_STATIC_CGEN(1U)

#define S_HMA_DYNAMIC_CGEN    18
#define V_HMA_DYNAMIC_CGEN(x) ((x) << S_HMA_DYNAMIC_CGEN)
#define F_HMA_DYNAMIC_CGEN    V_HMA_DYNAMIC_CGEN(1U)

#define S_CMD_STATIC_CGEN    16
#define V_CMD_STATIC_CGEN(x) ((x) << S_CMD_STATIC_CGEN)
#define F_CMD_STATIC_CGEN    V_CMD_STATIC_CGEN(1U)

#define S_CMD_DYNAMIC_CGEN    15
#define V_CMD_DYNAMIC_CGEN(x) ((x) << S_CMD_DYNAMIC_CGEN)
#define F_CMD_DYNAMIC_CGEN    V_CMD_DYNAMIC_CGEN(1U)

#define S_DMA_STATIC_CGEN    13
#define V_DMA_STATIC_CGEN(x) ((x) << S_DMA_STATIC_CGEN)
#define F_DMA_STATIC_CGEN    V_DMA_STATIC_CGEN(1U)

#define S_DMA_DYNAMIC_CGEN    12
#define V_DMA_DYNAMIC_CGEN(x) ((x) << S_DMA_DYNAMIC_CGEN)
#define F_DMA_DYNAMIC_CGEN    V_DMA_DYNAMIC_CGEN(1U)

#define S_VFID_SLEEPSTATUS    10
#define V_VFID_SLEEPSTATUS(x) ((x) << S_VFID_SLEEPSTATUS)
#define F_VFID_SLEEPSTATUS    V_VFID_SLEEPSTATUS(1U)

#define S_VC1_SLEEPSTATUS    9
#define V_VC1_SLEEPSTATUS(x) ((x) << S_VC1_SLEEPSTATUS)
#define F_VC1_SLEEPSTATUS    V_VC1_SLEEPSTATUS(1U)

#define S_STI_SLEEPSTATUS    8
#define V_STI_SLEEPSTATUS(x) ((x) << S_STI_SLEEPSTATUS)
#define F_STI_SLEEPSTATUS    V_STI_SLEEPSTATUS(1U)

#define S_VFID_SLEEPREQ    2
#define V_VFID_SLEEPREQ(x) ((x) << S_VFID_SLEEPREQ)
#define F_VFID_SLEEPREQ    V_VFID_SLEEPREQ(1U)

#define S_VC1_SLEEPREQ    1
#define V_VC1_SLEEPREQ(x) ((x) << S_VC1_SLEEPREQ)
#define F_VC1_SLEEPREQ    V_VC1_SLEEPREQ(1U)

#define S_STI_SLEEPREQ    0
#define V_STI_SLEEPREQ(x) ((x) << S_STI_SLEEPREQ)
#define F_STI_SLEEPREQ    V_STI_SLEEPREQ(1U)

#define A_PCIE_CORE_ENDPOINT_INTERRUPT_ENABLE 0x59c4

#define S_PTOI    31
#define V_PTOI(x) ((x) << S_PTOI)
#define F_PTOI    V_PTOI(1U)

#define S_AENI    29
#define V_AENI(x) ((x) << S_AENI)
#define F_AENI    V_AENI(1U)

#define S_PC0I    23
#define V_PC0I(x) ((x) << S_PC0I)
#define F_PC0I    V_PC0I(1U)

#define S_PC1I    22
#define V_PC1I(x) ((x) << S_PC1I)
#define F_PC1I    V_PC1I(1U)

#define S_PC2I    21
#define V_PC2I(x) ((x) << S_PC2I)
#define F_PC2I    V_PC2I(1U)

#define S_PC3I    20
#define V_PC3I(x) ((x) << S_PC3I)
#define F_PC3I    V_PC3I(1U)

#define S_PC4I    19
#define V_PC4I(x) ((x) << S_PC4I)
#define F_PC4I    V_PC4I(1U)

#define S_PC5I    18
#define V_PC5I(x) ((x) << S_PC5I)
#define F_PC5I    V_PC5I(1U)

#define S_PC6I    17
#define V_PC6I(x) ((x) << S_PC6I)
#define F_PC6I    V_PC6I(1U)

#define S_PC7I    16
#define V_PC7I(x) ((x) << S_PC7I)
#define F_PC7I    V_PC7I(1U)

#define A_PCIE_MA_RSP 0x59c4

#define S_TIMERVALUE    8
#define M_TIMERVALUE    0xffffffU
#define V_TIMERVALUE(x) ((x) << S_TIMERVALUE)
#define G_TIMERVALUE(x) (((x) >> S_TIMERVALUE) & M_TIMERVALUE)

#define S_MAREQTIMEREN    1
#define V_MAREQTIMEREN(x) ((x) << S_MAREQTIMEREN)
#define F_MAREQTIMEREN    V_MAREQTIMEREN(1U)

#define S_MARSPTIMEREN    0
#define V_MARSPTIMEREN(x) ((x) << S_MARSPTIMEREN)
#define F_MARSPTIMEREN    V_MARSPTIMEREN(1U)

#define A_PCIE_CORE_PCI_POWER_MANAGEMENT_CONTROL_1 0x59c8

#define S_TOAK    31
#define V_TOAK(x) ((x) << S_TOAK)
#define F_TOAK    V_TOAK(1U)

#define S_L1RS    23
#define V_L1RS(x) ((x) << S_L1RS)
#define F_L1RS    V_L1RS(1U)

#define S_L23S    22
#define V_L23S(x) ((x) << S_L23S)
#define F_L23S    V_L23S(1U)

#define S_AL1S    21
#define V_AL1S(x) ((x) << S_AL1S)
#define F_AL1S    V_AL1S(1U)

#define S_ALET    19
#define V_ALET(x) ((x) << S_ALET)
#define F_ALET    V_ALET(1U)

#define A_PCIE_HPRD 0x59c8

#define S_NPH_CREDITSAVAILVC0    19
#define M_NPH_CREDITSAVAILVC0    0x3U
#define V_NPH_CREDITSAVAILVC0(x) ((x) << S_NPH_CREDITSAVAILVC0)
#define G_NPH_CREDITSAVAILVC0(x) (((x) >> S_NPH_CREDITSAVAILVC0) & M_NPH_CREDITSAVAILVC0)

#define S_NPD_CREDITSAVAILVC0    17
#define M_NPD_CREDITSAVAILVC0    0x3U
#define V_NPD_CREDITSAVAILVC0(x) ((x) << S_NPD_CREDITSAVAILVC0)
#define G_NPD_CREDITSAVAILVC0(x) (((x) >> S_NPD_CREDITSAVAILVC0) & M_NPD_CREDITSAVAILVC0)

#define S_NPH_CREDITSAVAILVC1    15
#define M_NPH_CREDITSAVAILVC1    0x3U
#define V_NPH_CREDITSAVAILVC1(x) ((x) << S_NPH_CREDITSAVAILVC1)
#define G_NPH_CREDITSAVAILVC1(x) (((x) >> S_NPH_CREDITSAVAILVC1) & M_NPH_CREDITSAVAILVC1)

#define S_NPD_CREDITSAVAILVC1    13
#define M_NPD_CREDITSAVAILVC1    0x3U
#define V_NPD_CREDITSAVAILVC1(x) ((x) << S_NPD_CREDITSAVAILVC1)
#define G_NPD_CREDITSAVAILVC1(x) (((x) >> S_NPD_CREDITSAVAILVC1) & M_NPD_CREDITSAVAILVC1)

#define S_NPH_CREDITSREQUIRED    11
#define M_NPH_CREDITSREQUIRED    0x3U
#define V_NPH_CREDITSREQUIRED(x) ((x) << S_NPH_CREDITSREQUIRED)
#define G_NPH_CREDITSREQUIRED(x) (((x) >> S_NPH_CREDITSREQUIRED) & M_NPH_CREDITSREQUIRED)

#define S_NPD_CREDITSREQUIRED    9
#define M_NPD_CREDITSREQUIRED    0x3U
#define V_NPD_CREDITSREQUIRED(x) ((x) << S_NPD_CREDITSREQUIRED)
#define G_NPD_CREDITSREQUIRED(x) (((x) >> S_NPD_CREDITSREQUIRED) & M_NPD_CREDITSREQUIRED)

#define S_REQBURSTCOUNT    5
#define M_REQBURSTCOUNT    0xfU
#define V_REQBURSTCOUNT(x) ((x) << S_REQBURSTCOUNT)
#define G_REQBURSTCOUNT(x) (((x) >> S_REQBURSTCOUNT) & M_REQBURSTCOUNT)

#define S_REQBURSTFREQUENCY    1
#define M_REQBURSTFREQUENCY    0xfU
#define V_REQBURSTFREQUENCY(x) ((x) << S_REQBURSTFREQUENCY)
#define G_REQBURSTFREQUENCY(x) (((x) >> S_REQBURSTFREQUENCY) & M_REQBURSTFREQUENCY)

#define S_ENABLEVC1    0
#define V_ENABLEVC1(x) ((x) << S_ENABLEVC1)
#define F_ENABLEVC1    V_ENABLEVC1(1U)

#define A_PCIE_CORE_PCI_POWER_MANAGEMENT_CONTROL_2 0x59cc

#define S_CPM0    30
#define M_CPM0    0x3U
#define V_CPM0(x) ((x) << S_CPM0)
#define G_CPM0(x) (((x) >> S_CPM0) & M_CPM0)

#define S_CPM1    28
#define M_CPM1    0x3U
#define V_CPM1(x) ((x) << S_CPM1)
#define G_CPM1(x) (((x) >> S_CPM1) & M_CPM1)

#define S_CPM2    26
#define M_CPM2    0x3U
#define V_CPM2(x) ((x) << S_CPM2)
#define G_CPM2(x) (((x) >> S_CPM2) & M_CPM2)

#define S_CPM3    24
#define M_CPM3    0x3U
#define V_CPM3(x) ((x) << S_CPM3)
#define G_CPM3(x) (((x) >> S_CPM3) & M_CPM3)

#define S_CPM4    22
#define M_CPM4    0x3U
#define V_CPM4(x) ((x) << S_CPM4)
#define G_CPM4(x) (((x) >> S_CPM4) & M_CPM4)

#define S_CPM5    20
#define M_CPM5    0x3U
#define V_CPM5(x) ((x) << S_CPM5)
#define G_CPM5(x) (((x) >> S_CPM5) & M_CPM5)

#define S_CPM6    18
#define M_CPM6    0x3U
#define V_CPM6(x) ((x) << S_CPM6)
#define G_CPM6(x) (((x) >> S_CPM6) & M_CPM6)

#define S_CPM7    16
#define M_CPM7    0x3U
#define V_CPM7(x) ((x) << S_CPM7)
#define G_CPM7(x) (((x) >> S_CPM7) & M_CPM7)

#define S_OPM0    14
#define M_OPM0    0x3U
#define V_OPM0(x) ((x) << S_OPM0)
#define G_OPM0(x) (((x) >> S_OPM0) & M_OPM0)

#define S_OPM1    12
#define M_OPM1    0x3U
#define V_OPM1(x) ((x) << S_OPM1)
#define G_OPM1(x) (((x) >> S_OPM1) & M_OPM1)

#define S_OPM2    10
#define M_OPM2    0x3U
#define V_OPM2(x) ((x) << S_OPM2)
#define G_OPM2(x) (((x) >> S_OPM2) & M_OPM2)

#define S_OPM3    8
#define M_OPM3    0x3U
#define V_OPM3(x) ((x) << S_OPM3)
#define G_OPM3(x) (((x) >> S_OPM3) & M_OPM3)

#define S_OPM4    6
#define M_OPM4    0x3U
#define V_OPM4(x) ((x) << S_OPM4)
#define G_OPM4(x) (((x) >> S_OPM4) & M_OPM4)

#define S_OPM5    4
#define M_OPM5    0x3U
#define V_OPM5(x) ((x) << S_OPM5)
#define G_OPM5(x) (((x) >> S_OPM5) & M_OPM5)

#define S_OPM6    2
#define M_OPM6    0x3U
#define V_OPM6(x) ((x) << S_OPM6)
#define G_OPM6(x) (((x) >> S_OPM6) & M_OPM6)

#define S_OPM7    0
#define M_OPM7    0x3U
#define V_OPM7(x) ((x) << S_OPM7)
#define G_OPM7(x) (((x) >> S_OPM7) & M_OPM7)

#define A_PCIE_CORE_GENERAL_PURPOSE_CONTROL_1 0x59d0
#define A_PCIE_PERR_GROUP 0x59d0

#define S_MST_DATAPATHPERR    25
#define V_MST_DATAPATHPERR(x) ((x) << S_MST_DATAPATHPERR)
#define F_MST_DATAPATHPERR    V_MST_DATAPATHPERR(1U)

#define S_MST_RSPRDQPERR    24
#define V_MST_RSPRDQPERR(x) ((x) << S_MST_RSPRDQPERR)
#define F_MST_RSPRDQPERR    V_MST_RSPRDQPERR(1U)

#define S_IP_RXPERR    23
#define V_IP_RXPERR(x) ((x) << S_IP_RXPERR)
#define F_IP_RXPERR    V_IP_RXPERR(1U)

#define S_IP_BACKTXPERR    22
#define V_IP_BACKTXPERR(x) ((x) << S_IP_BACKTXPERR)
#define F_IP_BACKTXPERR    V_IP_BACKTXPERR(1U)

#define S_IP_FRONTTXPERR    21
#define V_IP_FRONTTXPERR(x) ((x) << S_IP_FRONTTXPERR)
#define F_IP_FRONTTXPERR    V_IP_FRONTTXPERR(1U)

#define S_TRGT1_FIDLKUPHDRPERR    20
#define V_TRGT1_FIDLKUPHDRPERR(x) ((x) << S_TRGT1_FIDLKUPHDRPERR)
#define F_TRGT1_FIDLKUPHDRPERR    V_TRGT1_FIDLKUPHDRPERR(1U)

#define S_TRGT1_ALINDDATAPERR    19
#define V_TRGT1_ALINDDATAPERR(x) ((x) << S_TRGT1_ALINDDATAPERR)
#define F_TRGT1_ALINDDATAPERR    V_TRGT1_ALINDDATAPERR(1U)

#define S_TRGT1_UNALINDATAPERR    18
#define V_TRGT1_UNALINDATAPERR(x) ((x) << S_TRGT1_UNALINDATAPERR)
#define F_TRGT1_UNALINDATAPERR    V_TRGT1_UNALINDATAPERR(1U)

#define S_TRGT1_REQDATAPERR    17
#define V_TRGT1_REQDATAPERR(x) ((x) << S_TRGT1_REQDATAPERR)
#define F_TRGT1_REQDATAPERR    V_TRGT1_REQDATAPERR(1U)

#define S_TRGT1_REQHDRPERR    16
#define V_TRGT1_REQHDRPERR(x) ((x) << S_TRGT1_REQHDRPERR)
#define F_TRGT1_REQHDRPERR    V_TRGT1_REQHDRPERR(1U)

#define S_IPRXDATA_VC1PERR    15
#define V_IPRXDATA_VC1PERR(x) ((x) << S_IPRXDATA_VC1PERR)
#define F_IPRXDATA_VC1PERR    V_IPRXDATA_VC1PERR(1U)

#define S_IPRXDATA_VC0PERR    14
#define V_IPRXDATA_VC0PERR(x) ((x) << S_IPRXDATA_VC0PERR)
#define F_IPRXDATA_VC0PERR    V_IPRXDATA_VC0PERR(1U)

#define S_IPRXHDR_VC1PERR    13
#define V_IPRXHDR_VC1PERR(x) ((x) << S_IPRXHDR_VC1PERR)
#define F_IPRXHDR_VC1PERR    V_IPRXHDR_VC1PERR(1U)

#define S_IPRXHDR_VC0PERR    12
#define V_IPRXHDR_VC0PERR(x) ((x) << S_IPRXHDR_VC0PERR)
#define F_IPRXHDR_VC0PERR    V_IPRXHDR_VC0PERR(1U)

#define S_MA_RSPDATAPERR    11
#define V_MA_RSPDATAPERR(x) ((x) << S_MA_RSPDATAPERR)
#define F_MA_RSPDATAPERR    V_MA_RSPDATAPERR(1U)

#define S_MA_CPLTAGQPERR    10
#define V_MA_CPLTAGQPERR(x) ((x) << S_MA_CPLTAGQPERR)
#define F_MA_CPLTAGQPERR    V_MA_CPLTAGQPERR(1U)

#define S_MA_REQTAGQPERR    9
#define V_MA_REQTAGQPERR(x) ((x) << S_MA_REQTAGQPERR)
#define F_MA_REQTAGQPERR    V_MA_REQTAGQPERR(1U)

#define S_PIOREQ_BAR2CTLPERR    8
#define V_PIOREQ_BAR2CTLPERR(x) ((x) << S_PIOREQ_BAR2CTLPERR)
#define F_PIOREQ_BAR2CTLPERR    V_PIOREQ_BAR2CTLPERR(1U)

#define S_PIOREQ_MEMCTLPERR    7
#define V_PIOREQ_MEMCTLPERR(x) ((x) << S_PIOREQ_MEMCTLPERR)
#define F_PIOREQ_MEMCTLPERR    V_PIOREQ_MEMCTLPERR(1U)

#define S_PIOREQ_PLMCTLPERR    6
#define V_PIOREQ_PLMCTLPERR(x) ((x) << S_PIOREQ_PLMCTLPERR)
#define F_PIOREQ_PLMCTLPERR    V_PIOREQ_PLMCTLPERR(1U)

#define S_PIOREQ_BAR2DATAPERR    5
#define V_PIOREQ_BAR2DATAPERR(x) ((x) << S_PIOREQ_BAR2DATAPERR)
#define F_PIOREQ_BAR2DATAPERR    V_PIOREQ_BAR2DATAPERR(1U)

#define S_PIOREQ_MEMDATAPERR    4
#define V_PIOREQ_MEMDATAPERR(x) ((x) << S_PIOREQ_MEMDATAPERR)
#define F_PIOREQ_MEMDATAPERR    V_PIOREQ_MEMDATAPERR(1U)

#define S_PIOREQ_PLMDATAPERR    3
#define V_PIOREQ_PLMDATAPERR(x) ((x) << S_PIOREQ_PLMDATAPERR)
#define F_PIOREQ_PLMDATAPERR    V_PIOREQ_PLMDATAPERR(1U)

#define S_PIOCPL_CTLPERR    2
#define V_PIOCPL_CTLPERR(x) ((x) << S_PIOCPL_CTLPERR)
#define F_PIOCPL_CTLPERR    V_PIOCPL_CTLPERR(1U)

#define S_PIOCPL_DATAPERR    1
#define V_PIOCPL_DATAPERR(x) ((x) << S_PIOCPL_DATAPERR)
#define F_PIOCPL_DATAPERR    V_PIOCPL_DATAPERR(1U)

#define S_PIOCPL_PLMRSPPERR    0
#define V_PIOCPL_PLMRSPPERR(x) ((x) << S_PIOCPL_PLMRSPPERR)
#define F_PIOCPL_PLMRSPPERR    V_PIOCPL_PLMRSPPERR(1U)

#define A_PCIE_CORE_GENERAL_PURPOSE_CONTROL_2 0x59d4
#define A_PCIE_RSP_ERR_INT_LOG_EN 0x59d4

#define S_CPLSTATUSINTEN    12
#define V_CPLSTATUSINTEN(x) ((x) << S_CPLSTATUSINTEN)
#define F_CPLSTATUSINTEN    V_CPLSTATUSINTEN(1U)

#define S_REQTIMEOUTINTEN    11
#define V_REQTIMEOUTINTEN(x) ((x) << S_REQTIMEOUTINTEN)
#define F_REQTIMEOUTINTEN    V_REQTIMEOUTINTEN(1U)

#define S_DISABLEDINTEN    10
#define V_DISABLEDINTEN(x) ((x) << S_DISABLEDINTEN)
#define F_DISABLEDINTEN    V_DISABLEDINTEN(1U)

#define S_RSPDROPFLRINTEN    9
#define V_RSPDROPFLRINTEN(x) ((x) << S_RSPDROPFLRINTEN)
#define F_RSPDROPFLRINTEN    V_RSPDROPFLRINTEN(1U)

#define S_REQUNDERFLRINTEN    8
#define V_REQUNDERFLRINTEN(x) ((x) << S_REQUNDERFLRINTEN)
#define F_REQUNDERFLRINTEN    V_REQUNDERFLRINTEN(1U)

#define S_CPLSTATUSLOGEN    4
#define V_CPLSTATUSLOGEN(x) ((x) << S_CPLSTATUSLOGEN)
#define F_CPLSTATUSLOGEN    V_CPLSTATUSLOGEN(1U)

#define S_TIMEOUTLOGEN    3
#define V_TIMEOUTLOGEN(x) ((x) << S_TIMEOUTLOGEN)
#define F_TIMEOUTLOGEN    V_TIMEOUTLOGEN(1U)

#define S_DISABLEDLOGEN    2
#define V_DISABLEDLOGEN(x) ((x) << S_DISABLEDLOGEN)
#define F_DISABLEDLOGEN    V_DISABLEDLOGEN(1U)

#define S_RSPDROPFLRLOGEN    1
#define V_RSPDROPFLRLOGEN(x) ((x) << S_RSPDROPFLRLOGEN)
#define F_RSPDROPFLRLOGEN    V_RSPDROPFLRLOGEN(1U)

#define S_REQUNDERFLRLOGEN    0
#define V_REQUNDERFLRLOGEN(x) ((x) << S_REQUNDERFLRLOGEN)
#define F_REQUNDERFLRLOGEN    V_REQUNDERFLRLOGEN(1U)

#define A_PCIE_RSP_ERR_LOG1 0x59d8

#define S_REQTAG    25
#define M_REQTAG    0x7fU
#define V_REQTAG(x) ((x) << S_REQTAG)
#define G_REQTAG(x) (((x) >> S_REQTAG) & M_REQTAG)

#define S_CID    22
#define M_CID    0x7U
#define V_CID(x) ((x) << S_CID)
#define G_CID(x) (((x) >> S_CID) & M_CID)

#define S_CHNUM    19
#define M_CHNUM    0x7U
#define V_CHNUM(x) ((x) << S_CHNUM)
#define G_CHNUM(x) (((x) >> S_CHNUM) & M_CHNUM)

#define S_BYTELEN    6
#define M_BYTELEN    0x1fffU
#define V_BYTELEN(x) ((x) << S_BYTELEN)
#define G_BYTELEN(x) (((x) >> S_BYTELEN) & M_BYTELEN)

#define S_REASON    3
#define M_REASON    0x7U
#define V_REASON(x) ((x) << S_REASON)
#define G_REASON(x) (((x) >> S_REASON) & M_REASON)

#define S_CPLSTATUS    0
#define M_CPLSTATUS    0x7U
#define V_CPLSTATUS(x) ((x) << S_CPLSTATUS)
#define G_CPLSTATUS(x) (((x) >> S_CPLSTATUS) & M_CPLSTATUS)

#define A_PCIE_RSP_ERR_LOG2 0x59dc

#define S_LOGVALID    31
#define V_LOGVALID(x) ((x) << S_LOGVALID)
#define F_LOGVALID    V_LOGVALID(1U)

#define S_ADDR10B    8
#define M_ADDR10B    0x3ffU
#define V_ADDR10B(x) ((x) << S_ADDR10B)
#define G_ADDR10B(x) (((x) >> S_ADDR10B) & M_ADDR10B)

#define S_REQVFID    0
#define M_REQVFID    0xffU
#define V_REQVFID(x) ((x) << S_REQVFID)
#define G_REQVFID(x) (((x) >> S_REQVFID) & M_REQVFID)

#define A_PCIE_CHANGESET 0x59fc
#define A_PCIE_REVISION 0x5a00
#define A_PCIE_PDEBUG_INDEX 0x5a04

#define S_PDEBUGSELH    16
#define M_PDEBUGSELH    0x3fU
#define V_PDEBUGSELH(x) ((x) << S_PDEBUGSELH)
#define G_PDEBUGSELH(x) (((x) >> S_PDEBUGSELH) & M_PDEBUGSELH)

#define S_PDEBUGSELL    0
#define M_PDEBUGSELL    0x3fU
#define V_PDEBUGSELL(x) ((x) << S_PDEBUGSELL)
#define G_PDEBUGSELL(x) (((x) >> S_PDEBUGSELL) & M_PDEBUGSELL)

#define A_PCIE_PDEBUG_DATA_HIGH 0x5a08
#define A_PCIE_PDEBUG_DATA_LOW 0x5a0c
#define A_PCIE_CDEBUG_INDEX 0x5a10

#define S_CDEBUGSELH    16
#define M_CDEBUGSELH    0xffU
#define V_CDEBUGSELH(x) ((x) << S_CDEBUGSELH)
#define G_CDEBUGSELH(x) (((x) >> S_CDEBUGSELH) & M_CDEBUGSELH)

#define S_CDEBUGSELL    0
#define M_CDEBUGSELL    0xffU
#define V_CDEBUGSELL(x) ((x) << S_CDEBUGSELL)
#define G_CDEBUGSELL(x) (((x) >> S_CDEBUGSELL) & M_CDEBUGSELL)

#define A_PCIE_CDEBUG_DATA_HIGH 0x5a14
#define A_PCIE_CDEBUG_DATA_LOW 0x5a18
#define A_PCIE_DMAW_SOP_CNT 0x5a1c

#define S_CH3    24
#define M_CH3    0xffU
#define V_CH3(x) ((x) << S_CH3)
#define G_CH3(x) (((x) >> S_CH3) & M_CH3)

#define S_CH2    16
#define M_CH2    0xffU
#define V_CH2(x) ((x) << S_CH2)
#define G_CH2(x) (((x) >> S_CH2) & M_CH2)

#define S_CH1    8
#define M_CH1    0xffU
#define V_CH1(x) ((x) << S_CH1)
#define G_CH1(x) (((x) >> S_CH1) & M_CH1)

#define S_CH0    0
#define M_CH0    0xffU
#define V_CH0(x) ((x) << S_CH0)
#define G_CH0(x) (((x) >> S_CH0) & M_CH0)

#define A_PCIE_DMAW_EOP_CNT 0x5a20
#define A_PCIE_DMAR_REQ_CNT 0x5a24
#define A_PCIE_DMAR_RSP_SOP_CNT 0x5a28
#define A_PCIE_DMAR_RSP_EOP_CNT 0x5a2c
#define A_PCIE_DMAR_RSP_ERR_CNT 0x5a30
#define A_PCIE_DMAI_CNT 0x5a34
#define A_PCIE_CMDW_CNT 0x5a38

#define S_CH1_EOP    24
#define M_CH1_EOP    0xffU
#define V_CH1_EOP(x) ((x) << S_CH1_EOP)
#define G_CH1_EOP(x) (((x) >> S_CH1_EOP) & M_CH1_EOP)

#define S_CH1_SOP    16
#define M_CH1_SOP    0xffU
#define V_CH1_SOP(x) ((x) << S_CH1_SOP)
#define G_CH1_SOP(x) (((x) >> S_CH1_SOP) & M_CH1_SOP)

#define S_CH0_EOP    8
#define M_CH0_EOP    0xffU
#define V_CH0_EOP(x) ((x) << S_CH0_EOP)
#define G_CH0_EOP(x) (((x) >> S_CH0_EOP) & M_CH0_EOP)

#define S_CH0_SOP    0
#define M_CH0_SOP    0xffU
#define V_CH0_SOP(x) ((x) << S_CH0_SOP)
#define G_CH0_SOP(x) (((x) >> S_CH0_SOP) & M_CH0_SOP)

#define A_PCIE_CMDR_REQ_CNT 0x5a3c
#define A_PCIE_CMDR_RSP_CNT 0x5a40
#define A_PCIE_CMDR_RSP_ERR_CNT 0x5a44
#define A_PCIE_HMA_REQ_CNT 0x5a48

#define S_CH0_READ    16
#define M_CH0_READ    0xffU
#define V_CH0_READ(x) ((x) << S_CH0_READ)
#define G_CH0_READ(x) (((x) >> S_CH0_READ) & M_CH0_READ)

#define S_CH0_WEOP    8
#define M_CH0_WEOP    0xffU
#define V_CH0_WEOP(x) ((x) << S_CH0_WEOP)
#define G_CH0_WEOP(x) (((x) >> S_CH0_WEOP) & M_CH0_WEOP)

#define S_CH0_WSOP    0
#define M_CH0_WSOP    0xffU
#define V_CH0_WSOP(x) ((x) << S_CH0_WSOP)
#define G_CH0_WSOP(x) (((x) >> S_CH0_WSOP) & M_CH0_WSOP)

#define A_PCIE_HMA_RSP_CNT 0x5a4c
#define A_PCIE_DMA10_RSP_FREE 0x5a50

#define S_CH1_RSP_FREE    16
#define M_CH1_RSP_FREE    0xfffU
#define V_CH1_RSP_FREE(x) ((x) << S_CH1_RSP_FREE)
#define G_CH1_RSP_FREE(x) (((x) >> S_CH1_RSP_FREE) & M_CH1_RSP_FREE)

#define S_CH0_RSP_FREE    0
#define M_CH0_RSP_FREE    0xfffU
#define V_CH0_RSP_FREE(x) ((x) << S_CH0_RSP_FREE)
#define G_CH0_RSP_FREE(x) (((x) >> S_CH0_RSP_FREE) & M_CH0_RSP_FREE)

#define A_PCIE_DMA32_RSP_FREE 0x5a54

#define S_CH3_RSP_FREE    16
#define M_CH3_RSP_FREE    0xfffU
#define V_CH3_RSP_FREE(x) ((x) << S_CH3_RSP_FREE)
#define G_CH3_RSP_FREE(x) (((x) >> S_CH3_RSP_FREE) & M_CH3_RSP_FREE)

#define S_CH2_RSP_FREE    0
#define M_CH2_RSP_FREE    0xfffU
#define V_CH2_RSP_FREE(x) ((x) << S_CH2_RSP_FREE)
#define G_CH2_RSP_FREE(x) (((x) >> S_CH2_RSP_FREE) & M_CH2_RSP_FREE)

#define A_PCIE_CMD_RSP_FREE 0x5a58

#define S_CMD_CH1_RSP_FREE    16
#define M_CMD_CH1_RSP_FREE    0x7fU
#define V_CMD_CH1_RSP_FREE(x) ((x) << S_CMD_CH1_RSP_FREE)
#define G_CMD_CH1_RSP_FREE(x) (((x) >> S_CMD_CH1_RSP_FREE) & M_CMD_CH1_RSP_FREE)

#define S_CMD_CH0_RSP_FREE    0
#define M_CMD_CH0_RSP_FREE    0x7fU
#define V_CMD_CH0_RSP_FREE(x) ((x) << S_CMD_CH0_RSP_FREE)
#define G_CMD_CH0_RSP_FREE(x) (((x) >> S_CMD_CH0_RSP_FREE) & M_CMD_CH0_RSP_FREE)

#define A_PCIE_HMA_RSP_FREE 0x5a5c
#define A_PCIE_BUS_MST_STAT_0 0x5a60
#define A_PCIE_BUS_MST_STAT_1 0x5a64
#define A_PCIE_BUS_MST_STAT_2 0x5a68
#define A_PCIE_BUS_MST_STAT_3 0x5a6c
#define A_PCIE_BUS_MST_STAT_4 0x5a70

#define S_BUSMST_135_128    0
#define M_BUSMST_135_128    0xffU
#define V_BUSMST_135_128(x) ((x) << S_BUSMST_135_128)
#define G_BUSMST_135_128(x) (((x) >> S_BUSMST_135_128) & M_BUSMST_135_128)

#define A_PCIE_BUS_MST_STAT_5 0x5a74
#define A_PCIE_BUS_MST_STAT_6 0x5a78
#define A_PCIE_BUS_MST_STAT_7 0x5a7c
#define A_PCIE_RSP_ERR_STAT_0 0x5a80
#define A_PCIE_RSP_ERR_STAT_1 0x5a84
#define A_PCIE_RSP_ERR_STAT_2 0x5a88
#define A_PCIE_RSP_ERR_STAT_3 0x5a8c
#define A_PCIE_RSP_ERR_STAT_4 0x5a90

#define S_RSPERR_135_128    0
#define M_RSPERR_135_128    0xffU
#define V_RSPERR_135_128(x) ((x) << S_RSPERR_135_128)
#define G_RSPERR_135_128(x) (((x) >> S_RSPERR_135_128) & M_RSPERR_135_128)

#define A_PCIE_RSP_ERR_STAT_5 0x5a94
#define A_PCIE_DBI_TIMEOUT_CTL 0x5a94

#define S_DBI_TIMER    0
#define M_DBI_TIMER    0xffffU
#define V_DBI_TIMER(x) ((x) << S_DBI_TIMER)
#define G_DBI_TIMER(x) (((x) >> S_DBI_TIMER) & M_DBI_TIMER)

#define A_PCIE_RSP_ERR_STAT_6 0x5a98
#define A_PCIE_DBI_TIMEOUT_STATUS0 0x5a98
#define A_PCIE_RSP_ERR_STAT_7 0x5a9c
#define A_PCIE_DBI_TIMEOUT_STATUS1 0x5a9c

#define S_SOURCE    16
#define M_SOURCE    0x3U
#define V_SOURCE(x) ((x) << S_SOURCE)
#define G_SOURCE(x) (((x) >> S_SOURCE) & M_SOURCE)

#define S_DBI_WRITE    12
#define M_DBI_WRITE    0xfU
#define V_DBI_WRITE(x) ((x) << S_DBI_WRITE)
#define G_DBI_WRITE(x) (((x) >> S_DBI_WRITE) & M_DBI_WRITE)

#define S_DBI_CS2    11
#define V_DBI_CS2(x) ((x) << S_DBI_CS2)
#define F_DBI_CS2    V_DBI_CS2(1U)

#define S_DBI_PF    8
#define M_DBI_PF    0x7U
#define V_DBI_PF(x) ((x) << S_DBI_PF)
#define G_DBI_PF(x) (((x) >> S_DBI_PF) & M_DBI_PF)

#define S_PL_TOVFVLD    7
#define V_PL_TOVFVLD(x) ((x) << S_PL_TOVFVLD)
#define F_PL_TOVFVLD    V_PL_TOVFVLD(1U)

#define S_PL_TOVF    0
#define M_PL_TOVF    0x7fU
#define V_PL_TOVF(x) ((x) << S_PL_TOVF)
#define G_PL_TOVF(x) (((x) >> S_PL_TOVF) & M_PL_TOVF)

#define A_PCIE_MSI_EN_0 0x5aa0
#define A_PCIE_MSI_EN_1 0x5aa4
#define A_PCIE_MSI_EN_2 0x5aa8
#define A_PCIE_MSI_EN_3 0x5aac
#define A_PCIE_MSI_EN_4 0x5ab0
#define A_PCIE_MSI_EN_5 0x5ab4
#define A_PCIE_MSI_EN_6 0x5ab8
#define A_PCIE_MSI_EN_7 0x5abc
#define A_PCIE_MSIX_EN_0 0x5ac0
#define A_PCIE_MSIX_EN_1 0x5ac4
#define A_PCIE_MSIX_EN_2 0x5ac8
#define A_PCIE_MSIX_EN_3 0x5acc
#define A_PCIE_MSIX_EN_4 0x5ad0
#define A_PCIE_MSIX_EN_5 0x5ad4
#define A_PCIE_MSIX_EN_6 0x5ad8
#define A_PCIE_MSIX_EN_7 0x5adc
#define A_PCIE_DMA_BUF_CTL 0x5ae0

#define S_BUFRDCNT    18
#define M_BUFRDCNT    0x3fffU
#define V_BUFRDCNT(x) ((x) << S_BUFRDCNT)
#define G_BUFRDCNT(x) (((x) >> S_BUFRDCNT) & M_BUFRDCNT)

#define S_BUFWRCNT    9
#define M_BUFWRCNT    0x1ffU
#define V_BUFWRCNT(x) ((x) << S_BUFWRCNT)
#define G_BUFWRCNT(x) (((x) >> S_BUFWRCNT) & M_BUFWRCNT)

#define S_MAXBUFWRREQ    0
#define M_MAXBUFWRREQ    0x1ffU
#define V_MAXBUFWRREQ(x) ((x) << S_MAXBUFWRREQ)
#define G_MAXBUFWRREQ(x) (((x) >> S_MAXBUFWRREQ) & M_MAXBUFWRREQ)

#define A_PCIE_PB_CTL 0x5b94

#define S_PB_SEL    16
#define M_PB_SEL    0xffU
#define V_PB_SEL(x) ((x) << S_PB_SEL)
#define G_PB_SEL(x) (((x) >> S_PB_SEL) & M_PB_SEL)

#define S_PB_SELREG    8
#define M_PB_SELREG    0xffU
#define V_PB_SELREG(x) ((x) << S_PB_SELREG)
#define G_PB_SELREG(x) (((x) >> S_PB_SELREG) & M_PB_SELREG)

#define S_PB_FUNC    0
#define M_PB_FUNC    0x7U
#define V_PB_FUNC(x) ((x) << S_PB_FUNC)
#define G_PB_FUNC(x) (((x) >> S_PB_FUNC) & M_PB_FUNC)

#define A_PCIE_PB_DATA 0x5b98
#define A_PCIE_CUR_LINK 0x5b9c

#define S_CFGINITCOEFFDONESEEN    22
#define V_CFGINITCOEFFDONESEEN(x) ((x) << S_CFGINITCOEFFDONESEEN)
#define F_CFGINITCOEFFDONESEEN    V_CFGINITCOEFFDONESEEN(1U)

#define S_CFGINITCOEFFDONE    21
#define V_CFGINITCOEFFDONE(x) ((x) << S_CFGINITCOEFFDONE)
#define F_CFGINITCOEFFDONE    V_CFGINITCOEFFDONE(1U)

#define S_XMLH_LINK_UP    20
#define V_XMLH_LINK_UP(x) ((x) << S_XMLH_LINK_UP)
#define F_XMLH_LINK_UP    V_XMLH_LINK_UP(1U)

#define S_PM_LINKST_IN_L0S    19
#define V_PM_LINKST_IN_L0S(x) ((x) << S_PM_LINKST_IN_L0S)
#define F_PM_LINKST_IN_L0S    V_PM_LINKST_IN_L0S(1U)

#define S_PM_LINKST_IN_L1    18
#define V_PM_LINKST_IN_L1(x) ((x) << S_PM_LINKST_IN_L1)
#define F_PM_LINKST_IN_L1    V_PM_LINKST_IN_L1(1U)

#define S_PM_LINKST_IN_L2    17
#define V_PM_LINKST_IN_L2(x) ((x) << S_PM_LINKST_IN_L2)
#define F_PM_LINKST_IN_L2    V_PM_LINKST_IN_L2(1U)

#define S_PM_LINKST_L2_EXIT    16
#define V_PM_LINKST_L2_EXIT(x) ((x) << S_PM_LINKST_L2_EXIT)
#define F_PM_LINKST_L2_EXIT    V_PM_LINKST_L2_EXIT(1U)

#define S_XMLH_IN_RL0S    15
#define V_XMLH_IN_RL0S(x) ((x) << S_XMLH_IN_RL0S)
#define F_XMLH_IN_RL0S    V_XMLH_IN_RL0S(1U)

#define S_XMLH_LTSSM_STATE_RCVRY_EQ    14
#define V_XMLH_LTSSM_STATE_RCVRY_EQ(x) ((x) << S_XMLH_LTSSM_STATE_RCVRY_EQ)
#define F_XMLH_LTSSM_STATE_RCVRY_EQ    V_XMLH_LTSSM_STATE_RCVRY_EQ(1U)

#define S_NEGOTIATEDWIDTH    8
#define M_NEGOTIATEDWIDTH    0x3fU
#define V_NEGOTIATEDWIDTH(x) ((x) << S_NEGOTIATEDWIDTH)
#define G_NEGOTIATEDWIDTH(x) (((x) >> S_NEGOTIATEDWIDTH) & M_NEGOTIATEDWIDTH)

#define S_ACTIVELANES    0
#define M_ACTIVELANES    0xffU
#define V_ACTIVELANES(x) ((x) << S_ACTIVELANES)
#define G_ACTIVELANES(x) (((x) >> S_ACTIVELANES) & M_ACTIVELANES)

#define A_PCIE_PHY_REQRXPWR 0x5ba0

#define S_LNH_RXSTATEDONE    31
#define V_LNH_RXSTATEDONE(x) ((x) << S_LNH_RXSTATEDONE)
#define F_LNH_RXSTATEDONE    V_LNH_RXSTATEDONE(1U)

#define S_LNH_RXSTATEREQ    30
#define V_LNH_RXSTATEREQ(x) ((x) << S_LNH_RXSTATEREQ)
#define F_LNH_RXSTATEREQ    V_LNH_RXSTATEREQ(1U)

#define S_LNH_RXPWRSTATE    28
#define M_LNH_RXPWRSTATE    0x3U
#define V_LNH_RXPWRSTATE(x) ((x) << S_LNH_RXPWRSTATE)
#define G_LNH_RXPWRSTATE(x) (((x) >> S_LNH_RXPWRSTATE) & M_LNH_RXPWRSTATE)

#define S_LNG_RXSTATEDONE    27
#define V_LNG_RXSTATEDONE(x) ((x) << S_LNG_RXSTATEDONE)
#define F_LNG_RXSTATEDONE    V_LNG_RXSTATEDONE(1U)

#define S_LNG_RXSTATEREQ    26
#define V_LNG_RXSTATEREQ(x) ((x) << S_LNG_RXSTATEREQ)
#define F_LNG_RXSTATEREQ    V_LNG_RXSTATEREQ(1U)

#define S_LNG_RXPWRSTATE    24
#define M_LNG_RXPWRSTATE    0x3U
#define V_LNG_RXPWRSTATE(x) ((x) << S_LNG_RXPWRSTATE)
#define G_LNG_RXPWRSTATE(x) (((x) >> S_LNG_RXPWRSTATE) & M_LNG_RXPWRSTATE)

#define S_LNF_RXSTATEDONE    23
#define V_LNF_RXSTATEDONE(x) ((x) << S_LNF_RXSTATEDONE)
#define F_LNF_RXSTATEDONE    V_LNF_RXSTATEDONE(1U)

#define S_LNF_RXSTATEREQ    22
#define V_LNF_RXSTATEREQ(x) ((x) << S_LNF_RXSTATEREQ)
#define F_LNF_RXSTATEREQ    V_LNF_RXSTATEREQ(1U)

#define S_LNF_RXPWRSTATE    20
#define M_LNF_RXPWRSTATE    0x3U
#define V_LNF_RXPWRSTATE(x) ((x) << S_LNF_RXPWRSTATE)
#define G_LNF_RXPWRSTATE(x) (((x) >> S_LNF_RXPWRSTATE) & M_LNF_RXPWRSTATE)

#define S_LNE_RXSTATEDONE    19
#define V_LNE_RXSTATEDONE(x) ((x) << S_LNE_RXSTATEDONE)
#define F_LNE_RXSTATEDONE    V_LNE_RXSTATEDONE(1U)

#define S_LNE_RXSTATEREQ    18
#define V_LNE_RXSTATEREQ(x) ((x) << S_LNE_RXSTATEREQ)
#define F_LNE_RXSTATEREQ    V_LNE_RXSTATEREQ(1U)

#define S_LNE_RXPWRSTATE    16
#define M_LNE_RXPWRSTATE    0x3U
#define V_LNE_RXPWRSTATE(x) ((x) << S_LNE_RXPWRSTATE)
#define G_LNE_RXPWRSTATE(x) (((x) >> S_LNE_RXPWRSTATE) & M_LNE_RXPWRSTATE)

#define S_LND_RXSTATEDONE    15
#define V_LND_RXSTATEDONE(x) ((x) << S_LND_RXSTATEDONE)
#define F_LND_RXSTATEDONE    V_LND_RXSTATEDONE(1U)

#define S_LND_RXSTATEREQ    14
#define V_LND_RXSTATEREQ(x) ((x) << S_LND_RXSTATEREQ)
#define F_LND_RXSTATEREQ    V_LND_RXSTATEREQ(1U)

#define S_LND_RXPWRSTATE    12
#define M_LND_RXPWRSTATE    0x3U
#define V_LND_RXPWRSTATE(x) ((x) << S_LND_RXPWRSTATE)
#define G_LND_RXPWRSTATE(x) (((x) >> S_LND_RXPWRSTATE) & M_LND_RXPWRSTATE)

#define S_LNC_RXSTATEDONE    11
#define V_LNC_RXSTATEDONE(x) ((x) << S_LNC_RXSTATEDONE)
#define F_LNC_RXSTATEDONE    V_LNC_RXSTATEDONE(1U)

#define S_LNC_RXSTATEREQ    10
#define V_LNC_RXSTATEREQ(x) ((x) << S_LNC_RXSTATEREQ)
#define F_LNC_RXSTATEREQ    V_LNC_RXSTATEREQ(1U)

#define S_LNC_RXPWRSTATE    8
#define M_LNC_RXPWRSTATE    0x3U
#define V_LNC_RXPWRSTATE(x) ((x) << S_LNC_RXPWRSTATE)
#define G_LNC_RXPWRSTATE(x) (((x) >> S_LNC_RXPWRSTATE) & M_LNC_RXPWRSTATE)

#define S_LNB_RXSTATEDONE    7
#define V_LNB_RXSTATEDONE(x) ((x) << S_LNB_RXSTATEDONE)
#define F_LNB_RXSTATEDONE    V_LNB_RXSTATEDONE(1U)

#define S_LNB_RXSTATEREQ    6
#define V_LNB_RXSTATEREQ(x) ((x) << S_LNB_RXSTATEREQ)
#define F_LNB_RXSTATEREQ    V_LNB_RXSTATEREQ(1U)

#define S_LNB_RXPWRSTATE    4
#define M_LNB_RXPWRSTATE    0x3U
#define V_LNB_RXPWRSTATE(x) ((x) << S_LNB_RXPWRSTATE)
#define G_LNB_RXPWRSTATE(x) (((x) >> S_LNB_RXPWRSTATE) & M_LNB_RXPWRSTATE)

#define S_LNA_RXSTATEDONE    3
#define V_LNA_RXSTATEDONE(x) ((x) << S_LNA_RXSTATEDONE)
#define F_LNA_RXSTATEDONE    V_LNA_RXSTATEDONE(1U)

#define S_LNA_RXSTATEREQ    2
#define V_LNA_RXSTATEREQ(x) ((x) << S_LNA_RXSTATEREQ)
#define F_LNA_RXSTATEREQ    V_LNA_RXSTATEREQ(1U)

#define S_LNA_RXPWRSTATE    0
#define M_LNA_RXPWRSTATE    0x3U
#define V_LNA_RXPWRSTATE(x) ((x) << S_LNA_RXPWRSTATE)
#define G_LNA_RXPWRSTATE(x) (((x) >> S_LNA_RXPWRSTATE) & M_LNA_RXPWRSTATE)

#define A_PCIE_PHY_CURRXPWR 0x5ba4
#define A_PCIE_PHY_GEN3_AE0 0x5ba8

#define S_LND_STAT    28
#define M_LND_STAT    0x7U
#define V_LND_STAT(x) ((x) << S_LND_STAT)
#define G_LND_STAT(x) (((x) >> S_LND_STAT) & M_LND_STAT)

#define S_LND_CMD    24
#define M_LND_CMD    0x7U
#define V_LND_CMD(x) ((x) << S_LND_CMD)
#define G_LND_CMD(x) (((x) >> S_LND_CMD) & M_LND_CMD)

#define S_LNC_STAT    20
#define M_LNC_STAT    0x7U
#define V_LNC_STAT(x) ((x) << S_LNC_STAT)
#define G_LNC_STAT(x) (((x) >> S_LNC_STAT) & M_LNC_STAT)

#define S_LNC_CMD    16
#define M_LNC_CMD    0x7U
#define V_LNC_CMD(x) ((x) << S_LNC_CMD)
#define G_LNC_CMD(x) (((x) >> S_LNC_CMD) & M_LNC_CMD)

#define S_LNB_STAT    12
#define M_LNB_STAT    0x7U
#define V_LNB_STAT(x) ((x) << S_LNB_STAT)
#define G_LNB_STAT(x) (((x) >> S_LNB_STAT) & M_LNB_STAT)

#define S_LNB_CMD    8
#define M_LNB_CMD    0x7U
#define V_LNB_CMD(x) ((x) << S_LNB_CMD)
#define G_LNB_CMD(x) (((x) >> S_LNB_CMD) & M_LNB_CMD)

#define S_LNA_STAT    4
#define M_LNA_STAT    0x7U
#define V_LNA_STAT(x) ((x) << S_LNA_STAT)
#define G_LNA_STAT(x) (((x) >> S_LNA_STAT) & M_LNA_STAT)

#define S_LNA_CMD    0
#define M_LNA_CMD    0x7U
#define V_LNA_CMD(x) ((x) << S_LNA_CMD)
#define G_LNA_CMD(x) (((x) >> S_LNA_CMD) & M_LNA_CMD)

#define A_PCIE_PHY_GEN3_AE1 0x5bac

#define S_LNH_STAT    28
#define M_LNH_STAT    0x7U
#define V_LNH_STAT(x) ((x) << S_LNH_STAT)
#define G_LNH_STAT(x) (((x) >> S_LNH_STAT) & M_LNH_STAT)

#define S_LNH_CMD    24
#define M_LNH_CMD    0x7U
#define V_LNH_CMD(x) ((x) << S_LNH_CMD)
#define G_LNH_CMD(x) (((x) >> S_LNH_CMD) & M_LNH_CMD)

#define S_LNG_STAT    20
#define M_LNG_STAT    0x7U
#define V_LNG_STAT(x) ((x) << S_LNG_STAT)
#define G_LNG_STAT(x) (((x) >> S_LNG_STAT) & M_LNG_STAT)

#define S_LNG_CMD    16
#define M_LNG_CMD    0x7U
#define V_LNG_CMD(x) ((x) << S_LNG_CMD)
#define G_LNG_CMD(x) (((x) >> S_LNG_CMD) & M_LNG_CMD)

#define S_LNF_STAT    12
#define M_LNF_STAT    0x7U
#define V_LNF_STAT(x) ((x) << S_LNF_STAT)
#define G_LNF_STAT(x) (((x) >> S_LNF_STAT) & M_LNF_STAT)

#define S_LNF_CMD    8
#define M_LNF_CMD    0x7U
#define V_LNF_CMD(x) ((x) << S_LNF_CMD)
#define G_LNF_CMD(x) (((x) >> S_LNF_CMD) & M_LNF_CMD)

#define S_LNE_STAT    4
#define M_LNE_STAT    0x7U
#define V_LNE_STAT(x) ((x) << S_LNE_STAT)
#define G_LNE_STAT(x) (((x) >> S_LNE_STAT) & M_LNE_STAT)

#define S_LNE_CMD    0
#define M_LNE_CMD    0x7U
#define V_LNE_CMD(x) ((x) << S_LNE_CMD)
#define G_LNE_CMD(x) (((x) >> S_LNE_CMD) & M_LNE_CMD)

#define A_PCIE_PHY_FS_LF0 0x5bb0

#define S_LANE1LF    24
#define M_LANE1LF    0x3fU
#define V_LANE1LF(x) ((x) << S_LANE1LF)
#define G_LANE1LF(x) (((x) >> S_LANE1LF) & M_LANE1LF)

#define S_LANE1FS    16
#define M_LANE1FS    0x3fU
#define V_LANE1FS(x) ((x) << S_LANE1FS)
#define G_LANE1FS(x) (((x) >> S_LANE1FS) & M_LANE1FS)

#define S_LANE0LF    8
#define M_LANE0LF    0x3fU
#define V_LANE0LF(x) ((x) << S_LANE0LF)
#define G_LANE0LF(x) (((x) >> S_LANE0LF) & M_LANE0LF)

#define S_LANE0FS    0
#define M_LANE0FS    0x3fU
#define V_LANE0FS(x) ((x) << S_LANE0FS)
#define G_LANE0FS(x) (((x) >> S_LANE0FS) & M_LANE0FS)

#define A_PCIE_PHY_FS_LF1 0x5bb4

#define S_LANE3LF    24
#define M_LANE3LF    0x3fU
#define V_LANE3LF(x) ((x) << S_LANE3LF)
#define G_LANE3LF(x) (((x) >> S_LANE3LF) & M_LANE3LF)

#define S_LANE3FS    16
#define M_LANE3FS    0x3fU
#define V_LANE3FS(x) ((x) << S_LANE3FS)
#define G_LANE3FS(x) (((x) >> S_LANE3FS) & M_LANE3FS)

#define S_LANE2LF    8
#define M_LANE2LF    0x3fU
#define V_LANE2LF(x) ((x) << S_LANE2LF)
#define G_LANE2LF(x) (((x) >> S_LANE2LF) & M_LANE2LF)

#define S_LANE2FS    0
#define M_LANE2FS    0x3fU
#define V_LANE2FS(x) ((x) << S_LANE2FS)
#define G_LANE2FS(x) (((x) >> S_LANE2FS) & M_LANE2FS)

#define A_PCIE_PHY_FS_LF2 0x5bb8

#define S_LANE5LF    24
#define M_LANE5LF    0x3fU
#define V_LANE5LF(x) ((x) << S_LANE5LF)
#define G_LANE5LF(x) (((x) >> S_LANE5LF) & M_LANE5LF)

#define S_LANE5FS    16
#define M_LANE5FS    0x3fU
#define V_LANE5FS(x) ((x) << S_LANE5FS)
#define G_LANE5FS(x) (((x) >> S_LANE5FS) & M_LANE5FS)

#define S_LANE4LF    8
#define M_LANE4LF    0x3fU
#define V_LANE4LF(x) ((x) << S_LANE4LF)
#define G_LANE4LF(x) (((x) >> S_LANE4LF) & M_LANE4LF)

#define S_LANE4FS    0
#define M_LANE4FS    0x3fU
#define V_LANE4FS(x) ((x) << S_LANE4FS)
#define G_LANE4FS(x) (((x) >> S_LANE4FS) & M_LANE4FS)

#define A_PCIE_PHY_FS_LF3 0x5bbc

#define S_LANE7LF    24
#define M_LANE7LF    0x3fU
#define V_LANE7LF(x) ((x) << S_LANE7LF)
#define G_LANE7LF(x) (((x) >> S_LANE7LF) & M_LANE7LF)

#define S_LANE7FS    16
#define M_LANE7FS    0x3fU
#define V_LANE7FS(x) ((x) << S_LANE7FS)
#define G_LANE7FS(x) (((x) >> S_LANE7FS) & M_LANE7FS)

#define S_LANE6LF    8
#define M_LANE6LF    0x3fU
#define V_LANE6LF(x) ((x) << S_LANE6LF)
#define G_LANE6LF(x) (((x) >> S_LANE6LF) & M_LANE6LF)

#define S_LANE6FS    0
#define M_LANE6FS    0x3fU
#define V_LANE6FS(x) ((x) << S_LANE6FS)
#define G_LANE6FS(x) (((x) >> S_LANE6FS) & M_LANE6FS)

#define A_PCIE_PHY_PRESET_REQ 0x5bc0

#define S_COEFFDONE    16
#define V_COEFFDONE(x) ((x) << S_COEFFDONE)
#define F_COEFFDONE    V_COEFFDONE(1U)

#define S_COEFFLANE    8
#define M_COEFFLANE    0x7U
#define V_COEFFLANE(x) ((x) << S_COEFFLANE)
#define G_COEFFLANE(x) (((x) >> S_COEFFLANE) & M_COEFFLANE)

#define S_COEFFSTART    0
#define V_COEFFSTART(x) ((x) << S_COEFFSTART)
#define F_COEFFSTART    V_COEFFSTART(1U)

#define A_PCIE_PHY_PRESET_COEFF 0x5bc4

#define S_COEFF    0
#define M_COEFF    0x3ffffU
#define V_COEFF(x) ((x) << S_COEFF)
#define G_COEFF(x) (((x) >> S_COEFF) & M_COEFF)

#define A_PCIE_PHY_INDIR_REQ 0x5bf0

#define S_PHYENABLE    31
#define V_PHYENABLE(x) ((x) << S_PHYENABLE)
#define F_PHYENABLE    V_PHYENABLE(1U)

#define S_PCIE_PHY_REGADDR    0
#define M_PCIE_PHY_REGADDR    0xffffU
#define V_PCIE_PHY_REGADDR(x) ((x) << S_PCIE_PHY_REGADDR)
#define G_PCIE_PHY_REGADDR(x) (((x) >> S_PCIE_PHY_REGADDR) & M_PCIE_PHY_REGADDR)

#define A_PCIE_PHY_INDIR_DATA 0x5bf4
#define A_PCIE_STATIC_SPARE1 0x5bf8
#define A_PCIE_STATIC_SPARE2 0x5bfc

/* registers for module DBG */
#define DBG_BASE_ADDR 0x6000

#define A_DBG_DBG0_CFG 0x6000

#define S_MODULESELECT    12
#define M_MODULESELECT    0xffU
#define V_MODULESELECT(x) ((x) << S_MODULESELECT)
#define G_MODULESELECT(x) (((x) >> S_MODULESELECT) & M_MODULESELECT)

#define S_REGSELECT    4
#define M_REGSELECT    0xffU
#define V_REGSELECT(x) ((x) << S_REGSELECT)
#define G_REGSELECT(x) (((x) >> S_REGSELECT) & M_REGSELECT)

#define S_CLKSELECT    0
#define M_CLKSELECT    0xfU
#define V_CLKSELECT(x) ((x) << S_CLKSELECT)
#define G_CLKSELECT(x) (((x) >> S_CLKSELECT) & M_CLKSELECT)

#define A_DBG_DBG0_EN 0x6004

#define S_PORTEN_PONR    16
#define V_PORTEN_PONR(x) ((x) << S_PORTEN_PONR)
#define F_PORTEN_PONR    V_PORTEN_PONR(1U)

#define S_PORTEN_POND    12
#define V_PORTEN_POND(x) ((x) << S_PORTEN_POND)
#define F_PORTEN_POND    V_PORTEN_POND(1U)

#define S_SDRHALFWORD0    8
#define V_SDRHALFWORD0(x) ((x) << S_SDRHALFWORD0)
#define F_SDRHALFWORD0    V_SDRHALFWORD0(1U)

#define S_DDREN    4
#define V_DDREN(x) ((x) << S_DDREN)
#define F_DDREN    V_DDREN(1U)

#define S_DBG_PORTEN    0
#define V_DBG_PORTEN(x) ((x) << S_DBG_PORTEN)
#define F_DBG_PORTEN    V_DBG_PORTEN(1U)

#define A_DBG_DBG1_CFG 0x6008
#define A_DBG_DBG1_EN 0x600c

#define S_CLK_EN_ON_DBG1    20
#define V_CLK_EN_ON_DBG1(x) ((x) << S_CLK_EN_ON_DBG1)
#define F_CLK_EN_ON_DBG1    V_CLK_EN_ON_DBG1(1U)

#define A_DBG_GPIO_EN 0x6010

#define S_GPIO15_OEN    31
#define V_GPIO15_OEN(x) ((x) << S_GPIO15_OEN)
#define F_GPIO15_OEN    V_GPIO15_OEN(1U)

#define S_GPIO14_OEN    30
#define V_GPIO14_OEN(x) ((x) << S_GPIO14_OEN)
#define F_GPIO14_OEN    V_GPIO14_OEN(1U)

#define S_GPIO13_OEN    29
#define V_GPIO13_OEN(x) ((x) << S_GPIO13_OEN)
#define F_GPIO13_OEN    V_GPIO13_OEN(1U)

#define S_GPIO12_OEN    28
#define V_GPIO12_OEN(x) ((x) << S_GPIO12_OEN)
#define F_GPIO12_OEN    V_GPIO12_OEN(1U)

#define S_GPIO11_OEN    27
#define V_GPIO11_OEN(x) ((x) << S_GPIO11_OEN)
#define F_GPIO11_OEN    V_GPIO11_OEN(1U)

#define S_GPIO10_OEN    26
#define V_GPIO10_OEN(x) ((x) << S_GPIO10_OEN)
#define F_GPIO10_OEN    V_GPIO10_OEN(1U)

#define S_GPIO9_OEN    25
#define V_GPIO9_OEN(x) ((x) << S_GPIO9_OEN)
#define F_GPIO9_OEN    V_GPIO9_OEN(1U)

#define S_GPIO8_OEN    24
#define V_GPIO8_OEN(x) ((x) << S_GPIO8_OEN)
#define F_GPIO8_OEN    V_GPIO8_OEN(1U)

#define S_GPIO7_OEN    23
#define V_GPIO7_OEN(x) ((x) << S_GPIO7_OEN)
#define F_GPIO7_OEN    V_GPIO7_OEN(1U)

#define S_GPIO6_OEN    22
#define V_GPIO6_OEN(x) ((x) << S_GPIO6_OEN)
#define F_GPIO6_OEN    V_GPIO6_OEN(1U)

#define S_GPIO5_OEN    21
#define V_GPIO5_OEN(x) ((x) << S_GPIO5_OEN)
#define F_GPIO5_OEN    V_GPIO5_OEN(1U)

#define S_GPIO4_OEN    20
#define V_GPIO4_OEN(x) ((x) << S_GPIO4_OEN)
#define F_GPIO4_OEN    V_GPIO4_OEN(1U)

#define S_GPIO3_OEN    19
#define V_GPIO3_OEN(x) ((x) << S_GPIO3_OEN)
#define F_GPIO3_OEN    V_GPIO3_OEN(1U)

#define S_GPIO2_OEN    18
#define V_GPIO2_OEN(x) ((x) << S_GPIO2_OEN)
#define F_GPIO2_OEN    V_GPIO2_OEN(1U)

#define S_GPIO1_OEN    17
#define V_GPIO1_OEN(x) ((x) << S_GPIO1_OEN)
#define F_GPIO1_OEN    V_GPIO1_OEN(1U)

#define S_GPIO0_OEN    16
#define V_GPIO0_OEN(x) ((x) << S_GPIO0_OEN)
#define F_GPIO0_OEN    V_GPIO0_OEN(1U)

#define S_GPIO15_OUT_VAL    15
#define V_GPIO15_OUT_VAL(x) ((x) << S_GPIO15_OUT_VAL)
#define F_GPIO15_OUT_VAL    V_GPIO15_OUT_VAL(1U)

#define S_GPIO14_OUT_VAL    14
#define V_GPIO14_OUT_VAL(x) ((x) << S_GPIO14_OUT_VAL)
#define F_GPIO14_OUT_VAL    V_GPIO14_OUT_VAL(1U)

#define S_GPIO13_OUT_VAL    13
#define V_GPIO13_OUT_VAL(x) ((x) << S_GPIO13_OUT_VAL)
#define F_GPIO13_OUT_VAL    V_GPIO13_OUT_VAL(1U)

#define S_GPIO12_OUT_VAL    12
#define V_GPIO12_OUT_VAL(x) ((x) << S_GPIO12_OUT_VAL)
#define F_GPIO12_OUT_VAL    V_GPIO12_OUT_VAL(1U)

#define S_GPIO11_OUT_VAL    11
#define V_GPIO11_OUT_VAL(x) ((x) << S_GPIO11_OUT_VAL)
#define F_GPIO11_OUT_VAL    V_GPIO11_OUT_VAL(1U)

#define S_GPIO10_OUT_VAL    10
#define V_GPIO10_OUT_VAL(x) ((x) << S_GPIO10_OUT_VAL)
#define F_GPIO10_OUT_VAL    V_GPIO10_OUT_VAL(1U)

#define S_GPIO9_OUT_VAL    9
#define V_GPIO9_OUT_VAL(x) ((x) << S_GPIO9_OUT_VAL)
#define F_GPIO9_OUT_VAL    V_GPIO9_OUT_VAL(1U)

#define S_GPIO8_OUT_VAL    8
#define V_GPIO8_OUT_VAL(x) ((x) << S_GPIO8_OUT_VAL)
#define F_GPIO8_OUT_VAL    V_GPIO8_OUT_VAL(1U)

#define S_GPIO7_OUT_VAL    7
#define V_GPIO7_OUT_VAL(x) ((x) << S_GPIO7_OUT_VAL)
#define F_GPIO7_OUT_VAL    V_GPIO7_OUT_VAL(1U)

#define S_GPIO6_OUT_VAL    6
#define V_GPIO6_OUT_VAL(x) ((x) << S_GPIO6_OUT_VAL)
#define F_GPIO6_OUT_VAL    V_GPIO6_OUT_VAL(1U)

#define S_GPIO5_OUT_VAL    5
#define V_GPIO5_OUT_VAL(x) ((x) << S_GPIO5_OUT_VAL)
#define F_GPIO5_OUT_VAL    V_GPIO5_OUT_VAL(1U)

#define S_GPIO4_OUT_VAL    4
#define V_GPIO4_OUT_VAL(x) ((x) << S_GPIO4_OUT_VAL)
#define F_GPIO4_OUT_VAL    V_GPIO4_OUT_VAL(1U)

#define S_GPIO3_OUT_VAL    3
#define V_GPIO3_OUT_VAL(x) ((x) << S_GPIO3_OUT_VAL)
#define F_GPIO3_OUT_VAL    V_GPIO3_OUT_VAL(1U)

#define S_GPIO2_OUT_VAL    2
#define V_GPIO2_OUT_VAL(x) ((x) << S_GPIO2_OUT_VAL)
#define F_GPIO2_OUT_VAL    V_GPIO2_OUT_VAL(1U)

#define S_GPIO1_OUT_VAL    1
#define V_GPIO1_OUT_VAL(x) ((x) << S_GPIO1_OUT_VAL)
#define F_GPIO1_OUT_VAL    V_GPIO1_OUT_VAL(1U)

#define S_GPIO0_OUT_VAL    0
#define V_GPIO0_OUT_VAL(x) ((x) << S_GPIO0_OUT_VAL)
#define F_GPIO0_OUT_VAL    V_GPIO0_OUT_VAL(1U)

#define A_DBG_GPIO_IN 0x6014

#define S_GPIO15_CHG_DET    31
#define V_GPIO15_CHG_DET(x) ((x) << S_GPIO15_CHG_DET)
#define F_GPIO15_CHG_DET    V_GPIO15_CHG_DET(1U)

#define S_GPIO14_CHG_DET    30
#define V_GPIO14_CHG_DET(x) ((x) << S_GPIO14_CHG_DET)
#define F_GPIO14_CHG_DET    V_GPIO14_CHG_DET(1U)

#define S_GPIO13_CHG_DET    29
#define V_GPIO13_CHG_DET(x) ((x) << S_GPIO13_CHG_DET)
#define F_GPIO13_CHG_DET    V_GPIO13_CHG_DET(1U)

#define S_GPIO12_CHG_DET    28
#define V_GPIO12_CHG_DET(x) ((x) << S_GPIO12_CHG_DET)
#define F_GPIO12_CHG_DET    V_GPIO12_CHG_DET(1U)

#define S_GPIO11_CHG_DET    27
#define V_GPIO11_CHG_DET(x) ((x) << S_GPIO11_CHG_DET)
#define F_GPIO11_CHG_DET    V_GPIO11_CHG_DET(1U)

#define S_GPIO10_CHG_DET    26
#define V_GPIO10_CHG_DET(x) ((x) << S_GPIO10_CHG_DET)
#define F_GPIO10_CHG_DET    V_GPIO10_CHG_DET(1U)

#define S_GPIO9_CHG_DET    25
#define V_GPIO9_CHG_DET(x) ((x) << S_GPIO9_CHG_DET)
#define F_GPIO9_CHG_DET    V_GPIO9_CHG_DET(1U)

#define S_GPIO8_CHG_DET    24
#define V_GPIO8_CHG_DET(x) ((x) << S_GPIO8_CHG_DET)
#define F_GPIO8_CHG_DET    V_GPIO8_CHG_DET(1U)

#define S_GPIO7_CHG_DET    23
#define V_GPIO7_CHG_DET(x) ((x) << S_GPIO7_CHG_DET)
#define F_GPIO7_CHG_DET    V_GPIO7_CHG_DET(1U)

#define S_GPIO6_CHG_DET    22
#define V_GPIO6_CHG_DET(x) ((x) << S_GPIO6_CHG_DET)
#define F_GPIO6_CHG_DET    V_GPIO6_CHG_DET(1U)

#define S_GPIO5_CHG_DET    21
#define V_GPIO5_CHG_DET(x) ((x) << S_GPIO5_CHG_DET)
#define F_GPIO5_CHG_DET    V_GPIO5_CHG_DET(1U)

#define S_GPIO4_CHG_DET    20
#define V_GPIO4_CHG_DET(x) ((x) << S_GPIO4_CHG_DET)
#define F_GPIO4_CHG_DET    V_GPIO4_CHG_DET(1U)

#define S_GPIO3_CHG_DET    19
#define V_GPIO3_CHG_DET(x) ((x) << S_GPIO3_CHG_DET)
#define F_GPIO3_CHG_DET    V_GPIO3_CHG_DET(1U)

#define S_GPIO2_CHG_DET    18
#define V_GPIO2_CHG_DET(x) ((x) << S_GPIO2_CHG_DET)
#define F_GPIO2_CHG_DET    V_GPIO2_CHG_DET(1U)

#define S_GPIO1_CHG_DET    17
#define V_GPIO1_CHG_DET(x) ((x) << S_GPIO1_CHG_DET)
#define F_GPIO1_CHG_DET    V_GPIO1_CHG_DET(1U)

#define S_GPIO0_CHG_DET    16
#define V_GPIO0_CHG_DET(x) ((x) << S_GPIO0_CHG_DET)
#define F_GPIO0_CHG_DET    V_GPIO0_CHG_DET(1U)

#define S_GPIO15_IN    15
#define V_GPIO15_IN(x) ((x) << S_GPIO15_IN)
#define F_GPIO15_IN    V_GPIO15_IN(1U)

#define S_GPIO14_IN    14
#define V_GPIO14_IN(x) ((x) << S_GPIO14_IN)
#define F_GPIO14_IN    V_GPIO14_IN(1U)

#define S_GPIO13_IN    13
#define V_GPIO13_IN(x) ((x) << S_GPIO13_IN)
#define F_GPIO13_IN    V_GPIO13_IN(1U)

#define S_GPIO12_IN    12
#define V_GPIO12_IN(x) ((x) << S_GPIO12_IN)
#define F_GPIO12_IN    V_GPIO12_IN(1U)

#define S_GPIO11_IN    11
#define V_GPIO11_IN(x) ((x) << S_GPIO11_IN)
#define F_GPIO11_IN    V_GPIO11_IN(1U)

#define S_GPIO10_IN    10
#define V_GPIO10_IN(x) ((x) << S_GPIO10_IN)
#define F_GPIO10_IN    V_GPIO10_IN(1U)

#define S_GPIO9_IN    9
#define V_GPIO9_IN(x) ((x) << S_GPIO9_IN)
#define F_GPIO9_IN    V_GPIO9_IN(1U)

#define S_GPIO8_IN    8
#define V_GPIO8_IN(x) ((x) << S_GPIO8_IN)
#define F_GPIO8_IN    V_GPIO8_IN(1U)

#define S_GPIO7_IN    7
#define V_GPIO7_IN(x) ((x) << S_GPIO7_IN)
#define F_GPIO7_IN    V_GPIO7_IN(1U)

#define S_GPIO6_IN    6
#define V_GPIO6_IN(x) ((x) << S_GPIO6_IN)
#define F_GPIO6_IN    V_GPIO6_IN(1U)

#define S_GPIO5_IN    5
#define V_GPIO5_IN(x) ((x) << S_GPIO5_IN)
#define F_GPIO5_IN    V_GPIO5_IN(1U)

#define S_GPIO4_IN    4
#define V_GPIO4_IN(x) ((x) << S_GPIO4_IN)
#define F_GPIO4_IN    V_GPIO4_IN(1U)

#define S_GPIO3_IN    3
#define V_GPIO3_IN(x) ((x) << S_GPIO3_IN)
#define F_GPIO3_IN    V_GPIO3_IN(1U)

#define S_GPIO2_IN    2
#define V_GPIO2_IN(x) ((x) << S_GPIO2_IN)
#define F_GPIO2_IN    V_GPIO2_IN(1U)

#define S_GPIO1_IN    1
#define V_GPIO1_IN(x) ((x) << S_GPIO1_IN)
#define F_GPIO1_IN    V_GPIO1_IN(1U)

#define S_GPIO0_IN    0
#define V_GPIO0_IN(x) ((x) << S_GPIO0_IN)
#define F_GPIO0_IN    V_GPIO0_IN(1U)

#define A_DBG_INT_ENABLE 0x6018

#define S_IBM_FDL_FAIL_INT_ENBL    25
#define V_IBM_FDL_FAIL_INT_ENBL(x) ((x) << S_IBM_FDL_FAIL_INT_ENBL)
#define F_IBM_FDL_FAIL_INT_ENBL    V_IBM_FDL_FAIL_INT_ENBL(1U)

#define S_ARM_FAIL_INT_ENBL    24
#define V_ARM_FAIL_INT_ENBL(x) ((x) << S_ARM_FAIL_INT_ENBL)
#define F_ARM_FAIL_INT_ENBL    V_ARM_FAIL_INT_ENBL(1U)

#define S_ARM_ERROR_OUT_INT_ENBL    23
#define V_ARM_ERROR_OUT_INT_ENBL(x) ((x) << S_ARM_ERROR_OUT_INT_ENBL)
#define F_ARM_ERROR_OUT_INT_ENBL    V_ARM_ERROR_OUT_INT_ENBL(1U)

#define S_PLL_LOCK_LOST_INT_ENBL    22
#define V_PLL_LOCK_LOST_INT_ENBL(x) ((x) << S_PLL_LOCK_LOST_INT_ENBL)
#define F_PLL_LOCK_LOST_INT_ENBL    V_PLL_LOCK_LOST_INT_ENBL(1U)

#define S_C_LOCK    21
#define V_C_LOCK(x) ((x) << S_C_LOCK)
#define F_C_LOCK    V_C_LOCK(1U)

#define S_M_LOCK    20
#define V_M_LOCK(x) ((x) << S_M_LOCK)
#define F_M_LOCK    V_M_LOCK(1U)

#define S_U_LOCK    19
#define V_U_LOCK(x) ((x) << S_U_LOCK)
#define F_U_LOCK    V_U_LOCK(1U)

#define S_PCIE_LOCK    18
#define V_PCIE_LOCK(x) ((x) << S_PCIE_LOCK)
#define F_PCIE_LOCK    V_PCIE_LOCK(1U)

#define S_KX_LOCK    17
#define V_KX_LOCK(x) ((x) << S_KX_LOCK)
#define F_KX_LOCK    V_KX_LOCK(1U)

#define S_KR_LOCK    16
#define V_KR_LOCK(x) ((x) << S_KR_LOCK)
#define F_KR_LOCK    V_KR_LOCK(1U)

#define S_GPIO15    15
#define V_GPIO15(x) ((x) << S_GPIO15)
#define F_GPIO15    V_GPIO15(1U)

#define S_GPIO14    14
#define V_GPIO14(x) ((x) << S_GPIO14)
#define F_GPIO14    V_GPIO14(1U)

#define S_GPIO13    13
#define V_GPIO13(x) ((x) << S_GPIO13)
#define F_GPIO13    V_GPIO13(1U)

#define S_GPIO12    12
#define V_GPIO12(x) ((x) << S_GPIO12)
#define F_GPIO12    V_GPIO12(1U)

#define S_GPIO11    11
#define V_GPIO11(x) ((x) << S_GPIO11)
#define F_GPIO11    V_GPIO11(1U)

#define S_GPIO10    10
#define V_GPIO10(x) ((x) << S_GPIO10)
#define F_GPIO10    V_GPIO10(1U)

#define S_GPIO9    9
#define V_GPIO9(x) ((x) << S_GPIO9)
#define F_GPIO9    V_GPIO9(1U)

#define S_GPIO8    8
#define V_GPIO8(x) ((x) << S_GPIO8)
#define F_GPIO8    V_GPIO8(1U)

#define S_GPIO7    7
#define V_GPIO7(x) ((x) << S_GPIO7)
#define F_GPIO7    V_GPIO7(1U)

#define S_GPIO6    6
#define V_GPIO6(x) ((x) << S_GPIO6)
#define F_GPIO6    V_GPIO6(1U)

#define S_GPIO5    5
#define V_GPIO5(x) ((x) << S_GPIO5)
#define F_GPIO5    V_GPIO5(1U)

#define S_GPIO4    4
#define V_GPIO4(x) ((x) << S_GPIO4)
#define F_GPIO4    V_GPIO4(1U)

#define S_GPIO3    3
#define V_GPIO3(x) ((x) << S_GPIO3)
#define F_GPIO3    V_GPIO3(1U)

#define S_GPIO2    2
#define V_GPIO2(x) ((x) << S_GPIO2)
#define F_GPIO2    V_GPIO2(1U)

#define S_GPIO1    1
#define V_GPIO1(x) ((x) << S_GPIO1)
#define F_GPIO1    V_GPIO1(1U)

#define S_GPIO0    0
#define V_GPIO0(x) ((x) << S_GPIO0)
#define F_GPIO0    V_GPIO0(1U)

#define S_GPIO19    29
#define V_GPIO19(x) ((x) << S_GPIO19)
#define F_GPIO19    V_GPIO19(1U)

#define S_GPIO18    28
#define V_GPIO18(x) ((x) << S_GPIO18)
#define F_GPIO18    V_GPIO18(1U)

#define S_GPIO17    27
#define V_GPIO17(x) ((x) << S_GPIO17)
#define F_GPIO17    V_GPIO17(1U)

#define S_GPIO16    26
#define V_GPIO16(x) ((x) << S_GPIO16)
#define F_GPIO16    V_GPIO16(1U)

#define A_DBG_INT_CAUSE 0x601c

#define S_IBM_FDL_FAIL_INT_CAUSE    25
#define V_IBM_FDL_FAIL_INT_CAUSE(x) ((x) << S_IBM_FDL_FAIL_INT_CAUSE)
#define F_IBM_FDL_FAIL_INT_CAUSE    V_IBM_FDL_FAIL_INT_CAUSE(1U)

#define S_ARM_FAIL_INT_CAUSE    24
#define V_ARM_FAIL_INT_CAUSE(x) ((x) << S_ARM_FAIL_INT_CAUSE)
#define F_ARM_FAIL_INT_CAUSE    V_ARM_FAIL_INT_CAUSE(1U)

#define S_ARM_ERROR_OUT_INT_CAUSE    23
#define V_ARM_ERROR_OUT_INT_CAUSE(x) ((x) << S_ARM_ERROR_OUT_INT_CAUSE)
#define F_ARM_ERROR_OUT_INT_CAUSE    V_ARM_ERROR_OUT_INT_CAUSE(1U)

#define S_PLL_LOCK_LOST_INT_CAUSE    22
#define V_PLL_LOCK_LOST_INT_CAUSE(x) ((x) << S_PLL_LOCK_LOST_INT_CAUSE)
#define F_PLL_LOCK_LOST_INT_CAUSE    V_PLL_LOCK_LOST_INT_CAUSE(1U)

#define A_DBG_DBG0_RST_VALUE 0x6020

#define S_DEBUGDATA    0
#define M_DEBUGDATA    0xffffU
#define V_DEBUGDATA(x) ((x) << S_DEBUGDATA)
#define G_DEBUGDATA(x) (((x) >> S_DEBUGDATA) & M_DEBUGDATA)

#define A_DBG_OVERWRSERCFG_EN 0x6024

#define S_OVERWRSERCFG_EN    0
#define V_OVERWRSERCFG_EN(x) ((x) << S_OVERWRSERCFG_EN)
#define F_OVERWRSERCFG_EN    V_OVERWRSERCFG_EN(1U)

#define A_DBG_PLL_OCLK_PAD_EN 0x6028

#define S_PCIE_OCLK_EN    20
#define V_PCIE_OCLK_EN(x) ((x) << S_PCIE_OCLK_EN)
#define F_PCIE_OCLK_EN    V_PCIE_OCLK_EN(1U)

#define S_KX_OCLK_EN    16
#define V_KX_OCLK_EN(x) ((x) << S_KX_OCLK_EN)
#define F_KX_OCLK_EN    V_KX_OCLK_EN(1U)

#define S_U_OCLK_EN    12
#define V_U_OCLK_EN(x) ((x) << S_U_OCLK_EN)
#define F_U_OCLK_EN    V_U_OCLK_EN(1U)

#define S_KR_OCLK_EN    8
#define V_KR_OCLK_EN(x) ((x) << S_KR_OCLK_EN)
#define F_KR_OCLK_EN    V_KR_OCLK_EN(1U)

#define S_M_OCLK_EN    4
#define V_M_OCLK_EN(x) ((x) << S_M_OCLK_EN)
#define F_M_OCLK_EN    V_M_OCLK_EN(1U)

#define S_C_OCLK_EN    0
#define V_C_OCLK_EN(x) ((x) << S_C_OCLK_EN)
#define F_C_OCLK_EN    V_C_OCLK_EN(1U)

#define A_DBG_PLL_LOCK 0x602c

#define S_PLL_P_LOCK    20
#define V_PLL_P_LOCK(x) ((x) << S_PLL_P_LOCK)
#define F_PLL_P_LOCK    V_PLL_P_LOCK(1U)

#define S_PLL_KX_LOCK    16
#define V_PLL_KX_LOCK(x) ((x) << S_PLL_KX_LOCK)
#define F_PLL_KX_LOCK    V_PLL_KX_LOCK(1U)

#define S_PLL_U_LOCK    12
#define V_PLL_U_LOCK(x) ((x) << S_PLL_U_LOCK)
#define F_PLL_U_LOCK    V_PLL_U_LOCK(1U)

#define S_PLL_KR_LOCK    8
#define V_PLL_KR_LOCK(x) ((x) << S_PLL_KR_LOCK)
#define F_PLL_KR_LOCK    V_PLL_KR_LOCK(1U)

#define S_PLL_M_LOCK    4
#define V_PLL_M_LOCK(x) ((x) << S_PLL_M_LOCK)
#define F_PLL_M_LOCK    V_PLL_M_LOCK(1U)

#define S_PLL_C_LOCK    0
#define V_PLL_C_LOCK(x) ((x) << S_PLL_C_LOCK)
#define F_PLL_C_LOCK    V_PLL_C_LOCK(1U)

#define A_DBG_GPIO_ACT_LOW 0x6030

#define S_P_LOCK_ACT_LOW    21
#define V_P_LOCK_ACT_LOW(x) ((x) << S_P_LOCK_ACT_LOW)
#define F_P_LOCK_ACT_LOW    V_P_LOCK_ACT_LOW(1U)

#define S_C_LOCK_ACT_LOW    20
#define V_C_LOCK_ACT_LOW(x) ((x) << S_C_LOCK_ACT_LOW)
#define F_C_LOCK_ACT_LOW    V_C_LOCK_ACT_LOW(1U)

#define S_M_LOCK_ACT_LOW    19
#define V_M_LOCK_ACT_LOW(x) ((x) << S_M_LOCK_ACT_LOW)
#define F_M_LOCK_ACT_LOW    V_M_LOCK_ACT_LOW(1U)

#define S_U_LOCK_ACT_LOW    18
#define V_U_LOCK_ACT_LOW(x) ((x) << S_U_LOCK_ACT_LOW)
#define F_U_LOCK_ACT_LOW    V_U_LOCK_ACT_LOW(1U)

#define S_KR_LOCK_ACT_LOW    17
#define V_KR_LOCK_ACT_LOW(x) ((x) << S_KR_LOCK_ACT_LOW)
#define F_KR_LOCK_ACT_LOW    V_KR_LOCK_ACT_LOW(1U)

#define S_KX_LOCK_ACT_LOW    16
#define V_KX_LOCK_ACT_LOW(x) ((x) << S_KX_LOCK_ACT_LOW)
#define F_KX_LOCK_ACT_LOW    V_KX_LOCK_ACT_LOW(1U)

#define S_GPIO15_ACT_LOW    15
#define V_GPIO15_ACT_LOW(x) ((x) << S_GPIO15_ACT_LOW)
#define F_GPIO15_ACT_LOW    V_GPIO15_ACT_LOW(1U)

#define S_GPIO14_ACT_LOW    14
#define V_GPIO14_ACT_LOW(x) ((x) << S_GPIO14_ACT_LOW)
#define F_GPIO14_ACT_LOW    V_GPIO14_ACT_LOW(1U)

#define S_GPIO13_ACT_LOW    13
#define V_GPIO13_ACT_LOW(x) ((x) << S_GPIO13_ACT_LOW)
#define F_GPIO13_ACT_LOW    V_GPIO13_ACT_LOW(1U)

#define S_GPIO12_ACT_LOW    12
#define V_GPIO12_ACT_LOW(x) ((x) << S_GPIO12_ACT_LOW)
#define F_GPIO12_ACT_LOW    V_GPIO12_ACT_LOW(1U)

#define S_GPIO11_ACT_LOW    11
#define V_GPIO11_ACT_LOW(x) ((x) << S_GPIO11_ACT_LOW)
#define F_GPIO11_ACT_LOW    V_GPIO11_ACT_LOW(1U)

#define S_GPIO10_ACT_LOW    10
#define V_GPIO10_ACT_LOW(x) ((x) << S_GPIO10_ACT_LOW)
#define F_GPIO10_ACT_LOW    V_GPIO10_ACT_LOW(1U)

#define S_GPIO9_ACT_LOW    9
#define V_GPIO9_ACT_LOW(x) ((x) << S_GPIO9_ACT_LOW)
#define F_GPIO9_ACT_LOW    V_GPIO9_ACT_LOW(1U)

#define S_GPIO8_ACT_LOW    8
#define V_GPIO8_ACT_LOW(x) ((x) << S_GPIO8_ACT_LOW)
#define F_GPIO8_ACT_LOW    V_GPIO8_ACT_LOW(1U)

#define S_GPIO7_ACT_LOW    7
#define V_GPIO7_ACT_LOW(x) ((x) << S_GPIO7_ACT_LOW)
#define F_GPIO7_ACT_LOW    V_GPIO7_ACT_LOW(1U)

#define S_GPIO6_ACT_LOW    6
#define V_GPIO6_ACT_LOW(x) ((x) << S_GPIO6_ACT_LOW)
#define F_GPIO6_ACT_LOW    V_GPIO6_ACT_LOW(1U)

#define S_GPIO5_ACT_LOW    5
#define V_GPIO5_ACT_LOW(x) ((x) << S_GPIO5_ACT_LOW)
#define F_GPIO5_ACT_LOW    V_GPIO5_ACT_LOW(1U)

#define S_GPIO4_ACT_LOW    4
#define V_GPIO4_ACT_LOW(x) ((x) << S_GPIO4_ACT_LOW)
#define F_GPIO4_ACT_LOW    V_GPIO4_ACT_LOW(1U)

#define S_GPIO3_ACT_LOW    3
#define V_GPIO3_ACT_LOW(x) ((x) << S_GPIO3_ACT_LOW)
#define F_GPIO3_ACT_LOW    V_GPIO3_ACT_LOW(1U)

#define S_GPIO2_ACT_LOW    2
#define V_GPIO2_ACT_LOW(x) ((x) << S_GPIO2_ACT_LOW)
#define F_GPIO2_ACT_LOW    V_GPIO2_ACT_LOW(1U)

#define S_GPIO1_ACT_LOW    1
#define V_GPIO1_ACT_LOW(x) ((x) << S_GPIO1_ACT_LOW)
#define F_GPIO1_ACT_LOW    V_GPIO1_ACT_LOW(1U)

#define S_GPIO0_ACT_LOW    0
#define V_GPIO0_ACT_LOW(x) ((x) << S_GPIO0_ACT_LOW)
#define F_GPIO0_ACT_LOW    V_GPIO0_ACT_LOW(1U)

#define S_GPIO19_ACT_LOW    25
#define V_GPIO19_ACT_LOW(x) ((x) << S_GPIO19_ACT_LOW)
#define F_GPIO19_ACT_LOW    V_GPIO19_ACT_LOW(1U)

#define S_GPIO18_ACT_LOW    24
#define V_GPIO18_ACT_LOW(x) ((x) << S_GPIO18_ACT_LOW)
#define F_GPIO18_ACT_LOW    V_GPIO18_ACT_LOW(1U)

#define S_GPIO17_ACT_LOW    23
#define V_GPIO17_ACT_LOW(x) ((x) << S_GPIO17_ACT_LOW)
#define F_GPIO17_ACT_LOW    V_GPIO17_ACT_LOW(1U)

#define S_GPIO16_ACT_LOW    22
#define V_GPIO16_ACT_LOW(x) ((x) << S_GPIO16_ACT_LOW)
#define F_GPIO16_ACT_LOW    V_GPIO16_ACT_LOW(1U)

#define A_DBG_EFUSE_BYTE0_3 0x6034
#define A_DBG_EFUSE_BYTE4_7 0x6038
#define A_DBG_EFUSE_BYTE8_11 0x603c
#define A_DBG_EFUSE_BYTE12_15 0x6040
#define A_DBG_STATIC_U_PLL_CONF 0x6044

#define S_STATIC_U_PLL_MULT    23
#define M_STATIC_U_PLL_MULT    0x1ffU
#define V_STATIC_U_PLL_MULT(x) ((x) << S_STATIC_U_PLL_MULT)
#define G_STATIC_U_PLL_MULT(x) (((x) >> S_STATIC_U_PLL_MULT) & M_STATIC_U_PLL_MULT)

#define S_STATIC_U_PLL_PREDIV    18
#define M_STATIC_U_PLL_PREDIV    0x1fU
#define V_STATIC_U_PLL_PREDIV(x) ((x) << S_STATIC_U_PLL_PREDIV)
#define G_STATIC_U_PLL_PREDIV(x) (((x) >> S_STATIC_U_PLL_PREDIV) & M_STATIC_U_PLL_PREDIV)

#define S_STATIC_U_PLL_RANGEA    14
#define M_STATIC_U_PLL_RANGEA    0xfU
#define V_STATIC_U_PLL_RANGEA(x) ((x) << S_STATIC_U_PLL_RANGEA)
#define G_STATIC_U_PLL_RANGEA(x) (((x) >> S_STATIC_U_PLL_RANGEA) & M_STATIC_U_PLL_RANGEA)

#define S_STATIC_U_PLL_RANGEB    10
#define M_STATIC_U_PLL_RANGEB    0xfU
#define V_STATIC_U_PLL_RANGEB(x) ((x) << S_STATIC_U_PLL_RANGEB)
#define G_STATIC_U_PLL_RANGEB(x) (((x) >> S_STATIC_U_PLL_RANGEB) & M_STATIC_U_PLL_RANGEB)

#define S_STATIC_U_PLL_TUNE    0
#define M_STATIC_U_PLL_TUNE    0x3ffU
#define V_STATIC_U_PLL_TUNE(x) ((x) << S_STATIC_U_PLL_TUNE)
#define G_STATIC_U_PLL_TUNE(x) (((x) >> S_STATIC_U_PLL_TUNE) & M_STATIC_U_PLL_TUNE)

#define A_DBG_STATIC_C_PLL_CONF 0x6048

#define S_STATIC_C_PLL_MULT    23
#define M_STATIC_C_PLL_MULT    0x1ffU
#define V_STATIC_C_PLL_MULT(x) ((x) << S_STATIC_C_PLL_MULT)
#define G_STATIC_C_PLL_MULT(x) (((x) >> S_STATIC_C_PLL_MULT) & M_STATIC_C_PLL_MULT)

#define S_STATIC_C_PLL_PREDIV    18
#define M_STATIC_C_PLL_PREDIV    0x1fU
#define V_STATIC_C_PLL_PREDIV(x) ((x) << S_STATIC_C_PLL_PREDIV)
#define G_STATIC_C_PLL_PREDIV(x) (((x) >> S_STATIC_C_PLL_PREDIV) & M_STATIC_C_PLL_PREDIV)

#define S_STATIC_C_PLL_RANGEA    14
#define M_STATIC_C_PLL_RANGEA    0xfU
#define V_STATIC_C_PLL_RANGEA(x) ((x) << S_STATIC_C_PLL_RANGEA)
#define G_STATIC_C_PLL_RANGEA(x) (((x) >> S_STATIC_C_PLL_RANGEA) & M_STATIC_C_PLL_RANGEA)

#define S_STATIC_C_PLL_RANGEB    10
#define M_STATIC_C_PLL_RANGEB    0xfU
#define V_STATIC_C_PLL_RANGEB(x) ((x) << S_STATIC_C_PLL_RANGEB)
#define G_STATIC_C_PLL_RANGEB(x) (((x) >> S_STATIC_C_PLL_RANGEB) & M_STATIC_C_PLL_RANGEB)

#define S_STATIC_C_PLL_TUNE    0
#define M_STATIC_C_PLL_TUNE    0x3ffU
#define V_STATIC_C_PLL_TUNE(x) ((x) << S_STATIC_C_PLL_TUNE)
#define G_STATIC_C_PLL_TUNE(x) (((x) >> S_STATIC_C_PLL_TUNE) & M_STATIC_C_PLL_TUNE)

#define A_DBG_STATIC_M_PLL_CONF 0x604c

#define S_STATIC_M_PLL_MULT    23
#define M_STATIC_M_PLL_MULT    0x1ffU
#define V_STATIC_M_PLL_MULT(x) ((x) << S_STATIC_M_PLL_MULT)
#define G_STATIC_M_PLL_MULT(x) (((x) >> S_STATIC_M_PLL_MULT) & M_STATIC_M_PLL_MULT)

#define S_STATIC_M_PLL_PREDIV    18
#define M_STATIC_M_PLL_PREDIV    0x1fU
#define V_STATIC_M_PLL_PREDIV(x) ((x) << S_STATIC_M_PLL_PREDIV)
#define G_STATIC_M_PLL_PREDIV(x) (((x) >> S_STATIC_M_PLL_PREDIV) & M_STATIC_M_PLL_PREDIV)

#define S_STATIC_M_PLL_RANGEA    14
#define M_STATIC_M_PLL_RANGEA    0xfU
#define V_STATIC_M_PLL_RANGEA(x) ((x) << S_STATIC_M_PLL_RANGEA)
#define G_STATIC_M_PLL_RANGEA(x) (((x) >> S_STATIC_M_PLL_RANGEA) & M_STATIC_M_PLL_RANGEA)

#define S_STATIC_M_PLL_RANGEB    10
#define M_STATIC_M_PLL_RANGEB    0xfU
#define V_STATIC_M_PLL_RANGEB(x) ((x) << S_STATIC_M_PLL_RANGEB)
#define G_STATIC_M_PLL_RANGEB(x) (((x) >> S_STATIC_M_PLL_RANGEB) & M_STATIC_M_PLL_RANGEB)

#define S_STATIC_M_PLL_TUNE    0
#define M_STATIC_M_PLL_TUNE    0x3ffU
#define V_STATIC_M_PLL_TUNE(x) ((x) << S_STATIC_M_PLL_TUNE)
#define G_STATIC_M_PLL_TUNE(x) (((x) >> S_STATIC_M_PLL_TUNE) & M_STATIC_M_PLL_TUNE)

#define A_DBG_STATIC_KX_PLL_CONF 0x6050

#define S_STATIC_KX_PLL_C    21
#define M_STATIC_KX_PLL_C    0xffU
#define V_STATIC_KX_PLL_C(x) ((x) << S_STATIC_KX_PLL_C)
#define G_STATIC_KX_PLL_C(x) (((x) >> S_STATIC_KX_PLL_C) & M_STATIC_KX_PLL_C)

#define S_STATIC_KX_PLL_M    15
#define M_STATIC_KX_PLL_M    0x3fU
#define V_STATIC_KX_PLL_M(x) ((x) << S_STATIC_KX_PLL_M)
#define G_STATIC_KX_PLL_M(x) (((x) >> S_STATIC_KX_PLL_M) & M_STATIC_KX_PLL_M)

#define S_STATIC_KX_PLL_N1    11
#define M_STATIC_KX_PLL_N1    0xfU
#define V_STATIC_KX_PLL_N1(x) ((x) << S_STATIC_KX_PLL_N1)
#define G_STATIC_KX_PLL_N1(x) (((x) >> S_STATIC_KX_PLL_N1) & M_STATIC_KX_PLL_N1)

#define S_STATIC_KX_PLL_N2    7
#define M_STATIC_KX_PLL_N2    0xfU
#define V_STATIC_KX_PLL_N2(x) ((x) << S_STATIC_KX_PLL_N2)
#define G_STATIC_KX_PLL_N2(x) (((x) >> S_STATIC_KX_PLL_N2) & M_STATIC_KX_PLL_N2)

#define S_STATIC_KX_PLL_N3    3
#define M_STATIC_KX_PLL_N3    0xfU
#define V_STATIC_KX_PLL_N3(x) ((x) << S_STATIC_KX_PLL_N3)
#define G_STATIC_KX_PLL_N3(x) (((x) >> S_STATIC_KX_PLL_N3) & M_STATIC_KX_PLL_N3)

#define S_STATIC_KX_PLL_P    0
#define M_STATIC_KX_PLL_P    0x7U
#define V_STATIC_KX_PLL_P(x) ((x) << S_STATIC_KX_PLL_P)
#define G_STATIC_KX_PLL_P(x) (((x) >> S_STATIC_KX_PLL_P) & M_STATIC_KX_PLL_P)

#define A_DBG_STATIC_KR_PLL_CONF 0x6054

#define S_STATIC_KR_PLL_C    21
#define M_STATIC_KR_PLL_C    0xffU
#define V_STATIC_KR_PLL_C(x) ((x) << S_STATIC_KR_PLL_C)
#define G_STATIC_KR_PLL_C(x) (((x) >> S_STATIC_KR_PLL_C) & M_STATIC_KR_PLL_C)

#define S_STATIC_KR_PLL_M    15
#define M_STATIC_KR_PLL_M    0x3fU
#define V_STATIC_KR_PLL_M(x) ((x) << S_STATIC_KR_PLL_M)
#define G_STATIC_KR_PLL_M(x) (((x) >> S_STATIC_KR_PLL_M) & M_STATIC_KR_PLL_M)

#define S_STATIC_KR_PLL_N1    11
#define M_STATIC_KR_PLL_N1    0xfU
#define V_STATIC_KR_PLL_N1(x) ((x) << S_STATIC_KR_PLL_N1)
#define G_STATIC_KR_PLL_N1(x) (((x) >> S_STATIC_KR_PLL_N1) & M_STATIC_KR_PLL_N1)

#define S_STATIC_KR_PLL_N2    7
#define M_STATIC_KR_PLL_N2    0xfU
#define V_STATIC_KR_PLL_N2(x) ((x) << S_STATIC_KR_PLL_N2)
#define G_STATIC_KR_PLL_N2(x) (((x) >> S_STATIC_KR_PLL_N2) & M_STATIC_KR_PLL_N2)

#define S_STATIC_KR_PLL_N3    3
#define M_STATIC_KR_PLL_N3    0xfU
#define V_STATIC_KR_PLL_N3(x) ((x) << S_STATIC_KR_PLL_N3)
#define G_STATIC_KR_PLL_N3(x) (((x) >> S_STATIC_KR_PLL_N3) & M_STATIC_KR_PLL_N3)

#define S_STATIC_KR_PLL_P    0
#define M_STATIC_KR_PLL_P    0x7U
#define V_STATIC_KR_PLL_P(x) ((x) << S_STATIC_KR_PLL_P)
#define G_STATIC_KR_PLL_P(x) (((x) >> S_STATIC_KR_PLL_P) & M_STATIC_KR_PLL_P)

#define A_DBG_EXTRA_STATIC_BITS_CONF 0x6058

#define S_STATIC_M_PLL_RESET    30
#define V_STATIC_M_PLL_RESET(x) ((x) << S_STATIC_M_PLL_RESET)
#define F_STATIC_M_PLL_RESET    V_STATIC_M_PLL_RESET(1U)

#define S_STATIC_M_PLL_SLEEP    29
#define V_STATIC_M_PLL_SLEEP(x) ((x) << S_STATIC_M_PLL_SLEEP)
#define F_STATIC_M_PLL_SLEEP    V_STATIC_M_PLL_SLEEP(1U)

#define S_STATIC_M_PLL_BYPASS    28
#define V_STATIC_M_PLL_BYPASS(x) ((x) << S_STATIC_M_PLL_BYPASS)
#define F_STATIC_M_PLL_BYPASS    V_STATIC_M_PLL_BYPASS(1U)

#define S_STATIC_MPLL_CLK_SEL    27
#define V_STATIC_MPLL_CLK_SEL(x) ((x) << S_STATIC_MPLL_CLK_SEL)
#define F_STATIC_MPLL_CLK_SEL    V_STATIC_MPLL_CLK_SEL(1U)

#define S_STATIC_U_PLL_SLEEP    26
#define V_STATIC_U_PLL_SLEEP(x) ((x) << S_STATIC_U_PLL_SLEEP)
#define F_STATIC_U_PLL_SLEEP    V_STATIC_U_PLL_SLEEP(1U)

#define S_STATIC_C_PLL_SLEEP    25
#define V_STATIC_C_PLL_SLEEP(x) ((x) << S_STATIC_C_PLL_SLEEP)
#define F_STATIC_C_PLL_SLEEP    V_STATIC_C_PLL_SLEEP(1U)

#define S_STATIC_LVDS_CLKOUT_SEL    23
#define M_STATIC_LVDS_CLKOUT_SEL    0x3U
#define V_STATIC_LVDS_CLKOUT_SEL(x) ((x) << S_STATIC_LVDS_CLKOUT_SEL)
#define G_STATIC_LVDS_CLKOUT_SEL(x) (((x) >> S_STATIC_LVDS_CLKOUT_SEL) & M_STATIC_LVDS_CLKOUT_SEL)

#define S_STATIC_LVDS_CLKOUT_EN    22
#define V_STATIC_LVDS_CLKOUT_EN(x) ((x) << S_STATIC_LVDS_CLKOUT_EN)
#define F_STATIC_LVDS_CLKOUT_EN    V_STATIC_LVDS_CLKOUT_EN(1U)

#define S_STATIC_CCLK_FREQ_SEL    20
#define M_STATIC_CCLK_FREQ_SEL    0x3U
#define V_STATIC_CCLK_FREQ_SEL(x) ((x) << S_STATIC_CCLK_FREQ_SEL)
#define G_STATIC_CCLK_FREQ_SEL(x) (((x) >> S_STATIC_CCLK_FREQ_SEL) & M_STATIC_CCLK_FREQ_SEL)

#define S_STATIC_UCLK_FREQ_SEL    18
#define M_STATIC_UCLK_FREQ_SEL    0x3U
#define V_STATIC_UCLK_FREQ_SEL(x) ((x) << S_STATIC_UCLK_FREQ_SEL)
#define G_STATIC_UCLK_FREQ_SEL(x) (((x) >> S_STATIC_UCLK_FREQ_SEL) & M_STATIC_UCLK_FREQ_SEL)

#define S_EXPHYCLK_SEL_EN    17
#define V_EXPHYCLK_SEL_EN(x) ((x) << S_EXPHYCLK_SEL_EN)
#define F_EXPHYCLK_SEL_EN    V_EXPHYCLK_SEL_EN(1U)

#define S_EXPHYCLK_SEL    15
#define M_EXPHYCLK_SEL    0x3U
#define V_EXPHYCLK_SEL(x) ((x) << S_EXPHYCLK_SEL)
#define G_EXPHYCLK_SEL(x) (((x) >> S_EXPHYCLK_SEL) & M_EXPHYCLK_SEL)

#define S_STATIC_U_PLL_BYPASS    14
#define V_STATIC_U_PLL_BYPASS(x) ((x) << S_STATIC_U_PLL_BYPASS)
#define F_STATIC_U_PLL_BYPASS    V_STATIC_U_PLL_BYPASS(1U)

#define S_STATIC_C_PLL_BYPASS    13
#define V_STATIC_C_PLL_BYPASS(x) ((x) << S_STATIC_C_PLL_BYPASS)
#define F_STATIC_C_PLL_BYPASS    V_STATIC_C_PLL_BYPASS(1U)

#define S_STATIC_KR_PLL_BYPASS    12
#define V_STATIC_KR_PLL_BYPASS(x) ((x) << S_STATIC_KR_PLL_BYPASS)
#define F_STATIC_KR_PLL_BYPASS    V_STATIC_KR_PLL_BYPASS(1U)

#define S_STATIC_KX_PLL_BYPASS    11
#define V_STATIC_KX_PLL_BYPASS(x) ((x) << S_STATIC_KX_PLL_BYPASS)
#define F_STATIC_KX_PLL_BYPASS    V_STATIC_KX_PLL_BYPASS(1U)

#define S_STATIC_KX_PLL_V    7
#define M_STATIC_KX_PLL_V    0xfU
#define V_STATIC_KX_PLL_V(x) ((x) << S_STATIC_KX_PLL_V)
#define G_STATIC_KX_PLL_V(x) (((x) >> S_STATIC_KX_PLL_V) & M_STATIC_KX_PLL_V)

#define S_STATIC_KR_PLL_V    3
#define M_STATIC_KR_PLL_V    0xfU
#define V_STATIC_KR_PLL_V(x) ((x) << S_STATIC_KR_PLL_V)
#define G_STATIC_KR_PLL_V(x) (((x) >> S_STATIC_KR_PLL_V) & M_STATIC_KR_PLL_V)

#define S_PSRO_SEL    0
#define M_PSRO_SEL    0x7U
#define V_PSRO_SEL(x) ((x) << S_PSRO_SEL)
#define G_PSRO_SEL(x) (((x) >> S_PSRO_SEL) & M_PSRO_SEL)

#define A_DBG_STATIC_OCLK_MUXSEL_CONF 0x605c

#define S_M_OCLK_MUXSEL    12
#define V_M_OCLK_MUXSEL(x) ((x) << S_M_OCLK_MUXSEL)
#define F_M_OCLK_MUXSEL    V_M_OCLK_MUXSEL(1U)

#define S_C_OCLK_MUXSEL    10
#define M_C_OCLK_MUXSEL    0x3U
#define V_C_OCLK_MUXSEL(x) ((x) << S_C_OCLK_MUXSEL)
#define G_C_OCLK_MUXSEL(x) (((x) >> S_C_OCLK_MUXSEL) & M_C_OCLK_MUXSEL)

#define S_U_OCLK_MUXSEL    8
#define M_U_OCLK_MUXSEL    0x3U
#define V_U_OCLK_MUXSEL(x) ((x) << S_U_OCLK_MUXSEL)
#define G_U_OCLK_MUXSEL(x) (((x) >> S_U_OCLK_MUXSEL) & M_U_OCLK_MUXSEL)

#define S_P_OCLK_MUXSEL    6
#define M_P_OCLK_MUXSEL    0x3U
#define V_P_OCLK_MUXSEL(x) ((x) << S_P_OCLK_MUXSEL)
#define G_P_OCLK_MUXSEL(x) (((x) >> S_P_OCLK_MUXSEL) & M_P_OCLK_MUXSEL)

#define S_KX_OCLK_MUXSEL    3
#define M_KX_OCLK_MUXSEL    0x7U
#define V_KX_OCLK_MUXSEL(x) ((x) << S_KX_OCLK_MUXSEL)
#define G_KX_OCLK_MUXSEL(x) (((x) >> S_KX_OCLK_MUXSEL) & M_KX_OCLK_MUXSEL)

#define S_KR_OCLK_MUXSEL    0
#define M_KR_OCLK_MUXSEL    0x7U
#define V_KR_OCLK_MUXSEL(x) ((x) << S_KR_OCLK_MUXSEL)
#define G_KR_OCLK_MUXSEL(x) (((x) >> S_KR_OCLK_MUXSEL) & M_KR_OCLK_MUXSEL)

#define S_T5_P_OCLK_MUXSEL    13
#define M_T5_P_OCLK_MUXSEL    0xfU
#define V_T5_P_OCLK_MUXSEL(x) ((x) << S_T5_P_OCLK_MUXSEL)
#define G_T5_P_OCLK_MUXSEL(x) (((x) >> S_T5_P_OCLK_MUXSEL) & M_T5_P_OCLK_MUXSEL)

#define A_DBG_TRACE0_CONF_COMPREG0 0x6060
#define A_DBG_TRACE0_CONF_COMPREG1 0x6064
#define A_DBG_TRACE1_CONF_COMPREG0 0x6068
#define A_DBG_TRACE1_CONF_COMPREG1 0x606c
#define A_DBG_TRACE0_CONF_MASKREG0 0x6070
#define A_DBG_TRACE0_CONF_MASKREG1 0x6074
#define A_DBG_TRACE1_CONF_MASKREG0 0x6078
#define A_DBG_TRACE1_CONF_MASKREG1 0x607c
#define A_DBG_TRACE_COUNTER 0x6080

#define S_COUNTER1    16
#define M_COUNTER1    0xffffU
#define V_COUNTER1(x) ((x) << S_COUNTER1)
#define G_COUNTER1(x) (((x) >> S_COUNTER1) & M_COUNTER1)

#define S_COUNTER0    0
#define M_COUNTER0    0xffffU
#define V_COUNTER0(x) ((x) << S_COUNTER0)
#define G_COUNTER0(x) (((x) >> S_COUNTER0) & M_COUNTER0)

#define A_DBG_STATIC_REFCLK_PERIOD 0x6084

#define S_STATIC_REFCLK_PERIOD    0
#define M_STATIC_REFCLK_PERIOD    0xffffU
#define V_STATIC_REFCLK_PERIOD(x) ((x) << S_STATIC_REFCLK_PERIOD)
#define G_STATIC_REFCLK_PERIOD(x) (((x) >> S_STATIC_REFCLK_PERIOD) & M_STATIC_REFCLK_PERIOD)

#define A_DBG_TRACE_CONF 0x6088

#define S_DBG_TRACE_OPERATE_WITH_TRG    5
#define V_DBG_TRACE_OPERATE_WITH_TRG(x) ((x) << S_DBG_TRACE_OPERATE_WITH_TRG)
#define F_DBG_TRACE_OPERATE_WITH_TRG    V_DBG_TRACE_OPERATE_WITH_TRG(1U)

#define S_DBG_TRACE_OPERATE_EN    4
#define V_DBG_TRACE_OPERATE_EN(x) ((x) << S_DBG_TRACE_OPERATE_EN)
#define F_DBG_TRACE_OPERATE_EN    V_DBG_TRACE_OPERATE_EN(1U)

#define S_DBG_OPERATE_INDV_COMBINED    3
#define V_DBG_OPERATE_INDV_COMBINED(x) ((x) << S_DBG_OPERATE_INDV_COMBINED)
#define F_DBG_OPERATE_INDV_COMBINED    V_DBG_OPERATE_INDV_COMBINED(1U)

#define S_DBG_OPERATE_ORDER_OF_TRIGGER    2
#define V_DBG_OPERATE_ORDER_OF_TRIGGER(x) ((x) << S_DBG_OPERATE_ORDER_OF_TRIGGER)
#define F_DBG_OPERATE_ORDER_OF_TRIGGER    V_DBG_OPERATE_ORDER_OF_TRIGGER(1U)

#define S_DBG_OPERATE_SGL_DBL_TRIGGER    1
#define V_DBG_OPERATE_SGL_DBL_TRIGGER(x) ((x) << S_DBG_OPERATE_SGL_DBL_TRIGGER)
#define F_DBG_OPERATE_SGL_DBL_TRIGGER    V_DBG_OPERATE_SGL_DBL_TRIGGER(1U)

#define S_DBG_OPERATE0_OR_1    0
#define V_DBG_OPERATE0_OR_1(x) ((x) << S_DBG_OPERATE0_OR_1)
#define F_DBG_OPERATE0_OR_1    V_DBG_OPERATE0_OR_1(1U)

#define A_DBG_TRACE_RDEN 0x608c

#define S_RD_ADDR1    10
#define M_RD_ADDR1    0xffU
#define V_RD_ADDR1(x) ((x) << S_RD_ADDR1)
#define G_RD_ADDR1(x) (((x) >> S_RD_ADDR1) & M_RD_ADDR1)

#define S_RD_ADDR0    2
#define M_RD_ADDR0    0xffU
#define V_RD_ADDR0(x) ((x) << S_RD_ADDR0)
#define G_RD_ADDR0(x) (((x) >> S_RD_ADDR0) & M_RD_ADDR0)

#define S_RD_EN1    1
#define V_RD_EN1(x) ((x) << S_RD_EN1)
#define F_RD_EN1    V_RD_EN1(1U)

#define S_RD_EN0    0
#define V_RD_EN0(x) ((x) << S_RD_EN0)
#define F_RD_EN0    V_RD_EN0(1U)

#define A_DBG_TRACE_WRADDR 0x6090

#define S_WR_POINTER_ADDR1    16
#define M_WR_POINTER_ADDR1    0xffU
#define V_WR_POINTER_ADDR1(x) ((x) << S_WR_POINTER_ADDR1)
#define G_WR_POINTER_ADDR1(x) (((x) >> S_WR_POINTER_ADDR1) & M_WR_POINTER_ADDR1)

#define S_WR_POINTER_ADDR0    0
#define M_WR_POINTER_ADDR0    0xffU
#define V_WR_POINTER_ADDR0(x) ((x) << S_WR_POINTER_ADDR0)
#define G_WR_POINTER_ADDR0(x) (((x) >> S_WR_POINTER_ADDR0) & M_WR_POINTER_ADDR0)

#define A_DBG_TRACE0_DATA_OUT 0x6094
#define A_DBG_TRACE1_DATA_OUT 0x6098
#define A_DBG_FUSE_SENSE_DONE 0x609c

#define S_STATIC_JTAG_VERSIONNR    5
#define M_STATIC_JTAG_VERSIONNR    0xfU
#define V_STATIC_JTAG_VERSIONNR(x) ((x) << S_STATIC_JTAG_VERSIONNR)
#define G_STATIC_JTAG_VERSIONNR(x) (((x) >> S_STATIC_JTAG_VERSIONNR) & M_STATIC_JTAG_VERSIONNR)

#define S_UNQ0    1
#define M_UNQ0    0xfU
#define V_UNQ0(x) ((x) << S_UNQ0)
#define G_UNQ0(x) (((x) >> S_UNQ0) & M_UNQ0)

#define S_FUSE_DONE_SENSE    0
#define V_FUSE_DONE_SENSE(x) ((x) << S_FUSE_DONE_SENSE)
#define F_FUSE_DONE_SENSE    V_FUSE_DONE_SENSE(1U)

#define A_DBG_TVSENSE_EN 0x60a8

#define S_MCIMPED1_OUT    29
#define V_MCIMPED1_OUT(x) ((x) << S_MCIMPED1_OUT)
#define F_MCIMPED1_OUT    V_MCIMPED1_OUT(1U)

#define S_MCIMPED2_OUT    28
#define V_MCIMPED2_OUT(x) ((x) << S_MCIMPED2_OUT)
#define F_MCIMPED2_OUT    V_MCIMPED2_OUT(1U)

#define S_TVSENSE_SNSOUT    17
#define M_TVSENSE_SNSOUT    0x1ffU
#define V_TVSENSE_SNSOUT(x) ((x) << S_TVSENSE_SNSOUT)
#define G_TVSENSE_SNSOUT(x) (((x) >> S_TVSENSE_SNSOUT) & M_TVSENSE_SNSOUT)

#define S_TVSENSE_OUTPUTVALID    16
#define V_TVSENSE_OUTPUTVALID(x) ((x) << S_TVSENSE_OUTPUTVALID)
#define F_TVSENSE_OUTPUTVALID    V_TVSENSE_OUTPUTVALID(1U)

#define S_TVSENSE_SLEEP    10
#define V_TVSENSE_SLEEP(x) ((x) << S_TVSENSE_SLEEP)
#define F_TVSENSE_SLEEP    V_TVSENSE_SLEEP(1U)

#define S_TVSENSE_SENSV    9
#define V_TVSENSE_SENSV(x) ((x) << S_TVSENSE_SENSV)
#define F_TVSENSE_SENSV    V_TVSENSE_SENSV(1U)

#define S_TVSENSE_RST    8
#define V_TVSENSE_RST(x) ((x) << S_TVSENSE_RST)
#define F_TVSENSE_RST    V_TVSENSE_RST(1U)

#define S_TVSENSE_RATIO    0
#define M_TVSENSE_RATIO    0xffU
#define V_TVSENSE_RATIO(x) ((x) << S_TVSENSE_RATIO)
#define G_TVSENSE_RATIO(x) (((x) >> S_TVSENSE_RATIO) & M_TVSENSE_RATIO)

#define A_DBG_CUST_EFUSE_OUT_EN 0x60ac
#define A_DBG_CUST_EFUSE_SEL1_EN 0x60b0
#define A_DBG_CUST_EFUSE_SEL2_EN 0x60b4

#define S_DBG_FEENABLE    29
#define V_DBG_FEENABLE(x) ((x) << S_DBG_FEENABLE)
#define F_DBG_FEENABLE    V_DBG_FEENABLE(1U)

#define S_DBG_FEF    23
#define M_DBG_FEF    0x3fU
#define V_DBG_FEF(x) ((x) << S_DBG_FEF)
#define G_DBG_FEF(x) (((x) >> S_DBG_FEF) & M_DBG_FEF)

#define S_DBG_FEMIMICN    22
#define V_DBG_FEMIMICN(x) ((x) << S_DBG_FEMIMICN)
#define F_DBG_FEMIMICN    V_DBG_FEMIMICN(1U)

#define S_DBG_FEGATEC    21
#define V_DBG_FEGATEC(x) ((x) << S_DBG_FEGATEC)
#define F_DBG_FEGATEC    V_DBG_FEGATEC(1U)

#define S_DBG_FEPROGP    20
#define V_DBG_FEPROGP(x) ((x) << S_DBG_FEPROGP)
#define F_DBG_FEPROGP    V_DBG_FEPROGP(1U)

#define S_DBG_FEREADCLK    19
#define V_DBG_FEREADCLK(x) ((x) << S_DBG_FEREADCLK)
#define F_DBG_FEREADCLK    V_DBG_FEREADCLK(1U)

#define S_DBG_FERSEL    3
#define M_DBG_FERSEL    0xffffU
#define V_DBG_FERSEL(x) ((x) << S_DBG_FERSEL)
#define G_DBG_FERSEL(x) (((x) >> S_DBG_FERSEL) & M_DBG_FERSEL)

#define S_DBG_FETIME    0
#define M_DBG_FETIME    0x7U
#define V_DBG_FETIME(x) ((x) << S_DBG_FETIME)
#define G_DBG_FETIME(x) (((x) >> S_DBG_FETIME) & M_DBG_FETIME)

#define A_DBG_T5_STATIC_M_PLL_CONF1 0x60b8

#define S_T5_STATIC_M_PLL_MULTFRAC    8
#define M_T5_STATIC_M_PLL_MULTFRAC    0xffffffU
#define V_T5_STATIC_M_PLL_MULTFRAC(x) ((x) << S_T5_STATIC_M_PLL_MULTFRAC)
#define G_T5_STATIC_M_PLL_MULTFRAC(x) (((x) >> S_T5_STATIC_M_PLL_MULTFRAC) & M_T5_STATIC_M_PLL_MULTFRAC)

#define S_T5_STATIC_M_PLL_FFSLEWRATE    0
#define M_T5_STATIC_M_PLL_FFSLEWRATE    0xffU
#define V_T5_STATIC_M_PLL_FFSLEWRATE(x) ((x) << S_T5_STATIC_M_PLL_FFSLEWRATE)
#define G_T5_STATIC_M_PLL_FFSLEWRATE(x) (((x) >> S_T5_STATIC_M_PLL_FFSLEWRATE) & M_T5_STATIC_M_PLL_FFSLEWRATE)

#define A_DBG_T5_STATIC_M_PLL_CONF2 0x60bc

#define S_T5_STATIC_M_PLL_DCO_BYPASS    23
#define V_T5_STATIC_M_PLL_DCO_BYPASS(x) ((x) << S_T5_STATIC_M_PLL_DCO_BYPASS)
#define F_T5_STATIC_M_PLL_DCO_BYPASS    V_T5_STATIC_M_PLL_DCO_BYPASS(1U)

#define S_T5_STATIC_M_PLL_SDORDER    21
#define M_T5_STATIC_M_PLL_SDORDER    0x3U
#define V_T5_STATIC_M_PLL_SDORDER(x) ((x) << S_T5_STATIC_M_PLL_SDORDER)
#define G_T5_STATIC_M_PLL_SDORDER(x) (((x) >> S_T5_STATIC_M_PLL_SDORDER) & M_T5_STATIC_M_PLL_SDORDER)

#define S_T5_STATIC_M_PLL_FFENABLE    20
#define V_T5_STATIC_M_PLL_FFENABLE(x) ((x) << S_T5_STATIC_M_PLL_FFENABLE)
#define F_T5_STATIC_M_PLL_FFENABLE    V_T5_STATIC_M_PLL_FFENABLE(1U)

#define S_T5_STATIC_M_PLL_STOPCLKB    19
#define V_T5_STATIC_M_PLL_STOPCLKB(x) ((x) << S_T5_STATIC_M_PLL_STOPCLKB)
#define F_T5_STATIC_M_PLL_STOPCLKB    V_T5_STATIC_M_PLL_STOPCLKB(1U)

#define S_T5_STATIC_M_PLL_STOPCLKA    18
#define V_T5_STATIC_M_PLL_STOPCLKA(x) ((x) << S_T5_STATIC_M_PLL_STOPCLKA)
#define F_T5_STATIC_M_PLL_STOPCLKA    V_T5_STATIC_M_PLL_STOPCLKA(1U)

#define S_T5_STATIC_M_PLL_SLEEP    17
#define V_T5_STATIC_M_PLL_SLEEP(x) ((x) << S_T5_STATIC_M_PLL_SLEEP)
#define F_T5_STATIC_M_PLL_SLEEP    V_T5_STATIC_M_PLL_SLEEP(1U)

#define S_T5_STATIC_M_PLL_BYPASS    16
#define V_T5_STATIC_M_PLL_BYPASS(x) ((x) << S_T5_STATIC_M_PLL_BYPASS)
#define F_T5_STATIC_M_PLL_BYPASS    V_T5_STATIC_M_PLL_BYPASS(1U)

#define S_T5_STATIC_M_PLL_LOCKTUNE    0
#define M_T5_STATIC_M_PLL_LOCKTUNE    0xffffU
#define V_T5_STATIC_M_PLL_LOCKTUNE(x) ((x) << S_T5_STATIC_M_PLL_LOCKTUNE)
#define G_T5_STATIC_M_PLL_LOCKTUNE(x) (((x) >> S_T5_STATIC_M_PLL_LOCKTUNE) & M_T5_STATIC_M_PLL_LOCKTUNE)

#define A_DBG_T5_STATIC_M_PLL_CONF3 0x60c0

#define S_T5_STATIC_M_PLL_MULTPRE    30
#define M_T5_STATIC_M_PLL_MULTPRE    0x3U
#define V_T5_STATIC_M_PLL_MULTPRE(x) ((x) << S_T5_STATIC_M_PLL_MULTPRE)
#define G_T5_STATIC_M_PLL_MULTPRE(x) (((x) >> S_T5_STATIC_M_PLL_MULTPRE) & M_T5_STATIC_M_PLL_MULTPRE)

#define S_T5_STATIC_M_PLL_LOCKSEL    28
#define M_T5_STATIC_M_PLL_LOCKSEL    0x3U
#define V_T5_STATIC_M_PLL_LOCKSEL(x) ((x) << S_T5_STATIC_M_PLL_LOCKSEL)
#define G_T5_STATIC_M_PLL_LOCKSEL(x) (((x) >> S_T5_STATIC_M_PLL_LOCKSEL) & M_T5_STATIC_M_PLL_LOCKSEL)

#define S_T5_STATIC_M_PLL_FFTUNE    12
#define M_T5_STATIC_M_PLL_FFTUNE    0xffffU
#define V_T5_STATIC_M_PLL_FFTUNE(x) ((x) << S_T5_STATIC_M_PLL_FFTUNE)
#define G_T5_STATIC_M_PLL_FFTUNE(x) (((x) >> S_T5_STATIC_M_PLL_FFTUNE) & M_T5_STATIC_M_PLL_FFTUNE)

#define S_T5_STATIC_M_PLL_RANGEPRE    10
#define M_T5_STATIC_M_PLL_RANGEPRE    0x3U
#define V_T5_STATIC_M_PLL_RANGEPRE(x) ((x) << S_T5_STATIC_M_PLL_RANGEPRE)
#define G_T5_STATIC_M_PLL_RANGEPRE(x) (((x) >> S_T5_STATIC_M_PLL_RANGEPRE) & M_T5_STATIC_M_PLL_RANGEPRE)

#define S_T5_STATIC_M_PLL_RANGEB    5
#define M_T5_STATIC_M_PLL_RANGEB    0x1fU
#define V_T5_STATIC_M_PLL_RANGEB(x) ((x) << S_T5_STATIC_M_PLL_RANGEB)
#define G_T5_STATIC_M_PLL_RANGEB(x) (((x) >> S_T5_STATIC_M_PLL_RANGEB) & M_T5_STATIC_M_PLL_RANGEB)

#define S_T5_STATIC_M_PLL_RANGEA    0
#define M_T5_STATIC_M_PLL_RANGEA    0x1fU
#define V_T5_STATIC_M_PLL_RANGEA(x) ((x) << S_T5_STATIC_M_PLL_RANGEA)
#define G_T5_STATIC_M_PLL_RANGEA(x) (((x) >> S_T5_STATIC_M_PLL_RANGEA) & M_T5_STATIC_M_PLL_RANGEA)

#define A_DBG_T5_STATIC_M_PLL_CONF4 0x60c4
#define A_DBG_T5_STATIC_M_PLL_CONF5 0x60c8

#define S_T5_STATIC_M_PLL_VCVTUNE    24
#define M_T5_STATIC_M_PLL_VCVTUNE    0x7U
#define V_T5_STATIC_M_PLL_VCVTUNE(x) ((x) << S_T5_STATIC_M_PLL_VCVTUNE)
#define G_T5_STATIC_M_PLL_VCVTUNE(x) (((x) >> S_T5_STATIC_M_PLL_VCVTUNE) & M_T5_STATIC_M_PLL_VCVTUNE)

#define S_T5_STATIC_M_PLL_RESET    23
#define V_T5_STATIC_M_PLL_RESET(x) ((x) << S_T5_STATIC_M_PLL_RESET)
#define F_T5_STATIC_M_PLL_RESET    V_T5_STATIC_M_PLL_RESET(1U)

#define S_T5_STATIC_MPLL_REFCLK_SEL    22
#define V_T5_STATIC_MPLL_REFCLK_SEL(x) ((x) << S_T5_STATIC_MPLL_REFCLK_SEL)
#define F_T5_STATIC_MPLL_REFCLK_SEL    V_T5_STATIC_MPLL_REFCLK_SEL(1U)

#define S_T5_STATIC_M_PLL_LFTUNE_32_40    13
#define M_T5_STATIC_M_PLL_LFTUNE_32_40    0x1ffU
#define V_T5_STATIC_M_PLL_LFTUNE_32_40(x) ((x) << S_T5_STATIC_M_PLL_LFTUNE_32_40)
#define G_T5_STATIC_M_PLL_LFTUNE_32_40(x) (((x) >> S_T5_STATIC_M_PLL_LFTUNE_32_40) & M_T5_STATIC_M_PLL_LFTUNE_32_40)

#define S_T5_STATIC_M_PLL_PREDIV    8
#define M_T5_STATIC_M_PLL_PREDIV    0x1fU
#define V_T5_STATIC_M_PLL_PREDIV(x) ((x) << S_T5_STATIC_M_PLL_PREDIV)
#define G_T5_STATIC_M_PLL_PREDIV(x) (((x) >> S_T5_STATIC_M_PLL_PREDIV) & M_T5_STATIC_M_PLL_PREDIV)

#define S_T5_STATIC_M_PLL_MULT    0
#define M_T5_STATIC_M_PLL_MULT    0xffU
#define V_T5_STATIC_M_PLL_MULT(x) ((x) << S_T5_STATIC_M_PLL_MULT)
#define G_T5_STATIC_M_PLL_MULT(x) (((x) >> S_T5_STATIC_M_PLL_MULT) & M_T5_STATIC_M_PLL_MULT)

#define A_DBG_T5_STATIC_M_PLL_CONF6 0x60cc

#define S_T5_STATIC_PHY0RECRST_    5
#define V_T5_STATIC_PHY0RECRST_(x) ((x) << S_T5_STATIC_PHY0RECRST_)
#define F_T5_STATIC_PHY0RECRST_    V_T5_STATIC_PHY0RECRST_(1U)

#define S_T5_STATIC_PHY1RECRST_    4
#define V_T5_STATIC_PHY1RECRST_(x) ((x) << S_T5_STATIC_PHY1RECRST_)
#define F_T5_STATIC_PHY1RECRST_    V_T5_STATIC_PHY1RECRST_(1U)

#define S_T5_STATIC_SWMC0RST_    3
#define V_T5_STATIC_SWMC0RST_(x) ((x) << S_T5_STATIC_SWMC0RST_)
#define F_T5_STATIC_SWMC0RST_    V_T5_STATIC_SWMC0RST_(1U)

#define S_T5_STATIC_SWMC0CFGRST_    2
#define V_T5_STATIC_SWMC0CFGRST_(x) ((x) << S_T5_STATIC_SWMC0CFGRST_)
#define F_T5_STATIC_SWMC0CFGRST_    V_T5_STATIC_SWMC0CFGRST_(1U)

#define S_T5_STATIC_SWMC1RST_    1
#define V_T5_STATIC_SWMC1RST_(x) ((x) << S_T5_STATIC_SWMC1RST_)
#define F_T5_STATIC_SWMC1RST_    V_T5_STATIC_SWMC1RST_(1U)

#define S_T5_STATIC_SWMC1CFGRST_    0
#define V_T5_STATIC_SWMC1CFGRST_(x) ((x) << S_T5_STATIC_SWMC1CFGRST_)
#define F_T5_STATIC_SWMC1CFGRST_    V_T5_STATIC_SWMC1CFGRST_(1U)

#define A_DBG_T5_STATIC_C_PLL_CONF1 0x60d0

#define S_T5_STATIC_C_PLL_MULTFRAC    8
#define M_T5_STATIC_C_PLL_MULTFRAC    0xffffffU
#define V_T5_STATIC_C_PLL_MULTFRAC(x) ((x) << S_T5_STATIC_C_PLL_MULTFRAC)
#define G_T5_STATIC_C_PLL_MULTFRAC(x) (((x) >> S_T5_STATIC_C_PLL_MULTFRAC) & M_T5_STATIC_C_PLL_MULTFRAC)

#define S_T5_STATIC_C_PLL_FFSLEWRATE    0
#define M_T5_STATIC_C_PLL_FFSLEWRATE    0xffU
#define V_T5_STATIC_C_PLL_FFSLEWRATE(x) ((x) << S_T5_STATIC_C_PLL_FFSLEWRATE)
#define G_T5_STATIC_C_PLL_FFSLEWRATE(x) (((x) >> S_T5_STATIC_C_PLL_FFSLEWRATE) & M_T5_STATIC_C_PLL_FFSLEWRATE)

#define A_DBG_T5_STATIC_C_PLL_CONF2 0x60d4

#define S_T5_STATIC_C_PLL_DCO_BYPASS    23
#define V_T5_STATIC_C_PLL_DCO_BYPASS(x) ((x) << S_T5_STATIC_C_PLL_DCO_BYPASS)
#define F_T5_STATIC_C_PLL_DCO_BYPASS    V_T5_STATIC_C_PLL_DCO_BYPASS(1U)

#define S_T5_STATIC_C_PLL_SDORDER    21
#define M_T5_STATIC_C_PLL_SDORDER    0x3U
#define V_T5_STATIC_C_PLL_SDORDER(x) ((x) << S_T5_STATIC_C_PLL_SDORDER)
#define G_T5_STATIC_C_PLL_SDORDER(x) (((x) >> S_T5_STATIC_C_PLL_SDORDER) & M_T5_STATIC_C_PLL_SDORDER)

#define S_T5_STATIC_C_PLL_FFENABLE    20
#define V_T5_STATIC_C_PLL_FFENABLE(x) ((x) << S_T5_STATIC_C_PLL_FFENABLE)
#define F_T5_STATIC_C_PLL_FFENABLE    V_T5_STATIC_C_PLL_FFENABLE(1U)

#define S_T5_STATIC_C_PLL_STOPCLKB    19
#define V_T5_STATIC_C_PLL_STOPCLKB(x) ((x) << S_T5_STATIC_C_PLL_STOPCLKB)
#define F_T5_STATIC_C_PLL_STOPCLKB    V_T5_STATIC_C_PLL_STOPCLKB(1U)

#define S_T5_STATIC_C_PLL_STOPCLKA    18
#define V_T5_STATIC_C_PLL_STOPCLKA(x) ((x) << S_T5_STATIC_C_PLL_STOPCLKA)
#define F_T5_STATIC_C_PLL_STOPCLKA    V_T5_STATIC_C_PLL_STOPCLKA(1U)

#define S_T5_STATIC_C_PLL_SLEEP    17
#define V_T5_STATIC_C_PLL_SLEEP(x) ((x) << S_T5_STATIC_C_PLL_SLEEP)
#define F_T5_STATIC_C_PLL_SLEEP    V_T5_STATIC_C_PLL_SLEEP(1U)

#define S_T5_STATIC_C_PLL_BYPASS    16
#define V_T5_STATIC_C_PLL_BYPASS(x) ((x) << S_T5_STATIC_C_PLL_BYPASS)
#define F_T5_STATIC_C_PLL_BYPASS    V_T5_STATIC_C_PLL_BYPASS(1U)

#define S_T5_STATIC_C_PLL_LOCKTUNE    0
#define M_T5_STATIC_C_PLL_LOCKTUNE    0xffffU
#define V_T5_STATIC_C_PLL_LOCKTUNE(x) ((x) << S_T5_STATIC_C_PLL_LOCKTUNE)
#define G_T5_STATIC_C_PLL_LOCKTUNE(x) (((x) >> S_T5_STATIC_C_PLL_LOCKTUNE) & M_T5_STATIC_C_PLL_LOCKTUNE)

#define A_DBG_T5_STATIC_C_PLL_CONF3 0x60d8

#define S_T5_STATIC_C_PLL_MULTPRE    30
#define M_T5_STATIC_C_PLL_MULTPRE    0x3U
#define V_T5_STATIC_C_PLL_MULTPRE(x) ((x) << S_T5_STATIC_C_PLL_MULTPRE)
#define G_T5_STATIC_C_PLL_MULTPRE(x) (((x) >> S_T5_STATIC_C_PLL_MULTPRE) & M_T5_STATIC_C_PLL_MULTPRE)

#define S_T5_STATIC_C_PLL_LOCKSEL    28
#define M_T5_STATIC_C_PLL_LOCKSEL    0x3U
#define V_T5_STATIC_C_PLL_LOCKSEL(x) ((x) << S_T5_STATIC_C_PLL_LOCKSEL)
#define G_T5_STATIC_C_PLL_LOCKSEL(x) (((x) >> S_T5_STATIC_C_PLL_LOCKSEL) & M_T5_STATIC_C_PLL_LOCKSEL)

#define S_T5_STATIC_C_PLL_FFTUNE    12
#define M_T5_STATIC_C_PLL_FFTUNE    0xffffU
#define V_T5_STATIC_C_PLL_FFTUNE(x) ((x) << S_T5_STATIC_C_PLL_FFTUNE)
#define G_T5_STATIC_C_PLL_FFTUNE(x) (((x) >> S_T5_STATIC_C_PLL_FFTUNE) & M_T5_STATIC_C_PLL_FFTUNE)

#define S_T5_STATIC_C_PLL_RANGEPRE    10
#define M_T5_STATIC_C_PLL_RANGEPRE    0x3U
#define V_T5_STATIC_C_PLL_RANGEPRE(x) ((x) << S_T5_STATIC_C_PLL_RANGEPRE)
#define G_T5_STATIC_C_PLL_RANGEPRE(x) (((x) >> S_T5_STATIC_C_PLL_RANGEPRE) & M_T5_STATIC_C_PLL_RANGEPRE)

#define S_T5_STATIC_C_PLL_RANGEB    5
#define M_T5_STATIC_C_PLL_RANGEB    0x1fU
#define V_T5_STATIC_C_PLL_RANGEB(x) ((x) << S_T5_STATIC_C_PLL_RANGEB)
#define G_T5_STATIC_C_PLL_RANGEB(x) (((x) >> S_T5_STATIC_C_PLL_RANGEB) & M_T5_STATIC_C_PLL_RANGEB)

#define S_T5_STATIC_C_PLL_RANGEA    0
#define M_T5_STATIC_C_PLL_RANGEA    0x1fU
#define V_T5_STATIC_C_PLL_RANGEA(x) ((x) << S_T5_STATIC_C_PLL_RANGEA)
#define G_T5_STATIC_C_PLL_RANGEA(x) (((x) >> S_T5_STATIC_C_PLL_RANGEA) & M_T5_STATIC_C_PLL_RANGEA)

#define A_DBG_T5_STATIC_C_PLL_CONF4 0x60dc
#define A_DBG_T5_STATIC_C_PLL_CONF5 0x60e0

#define S_T5_STATIC_C_PLL_VCVTUNE    22
#define M_T5_STATIC_C_PLL_VCVTUNE    0x7U
#define V_T5_STATIC_C_PLL_VCVTUNE(x) ((x) << S_T5_STATIC_C_PLL_VCVTUNE)
#define G_T5_STATIC_C_PLL_VCVTUNE(x) (((x) >> S_T5_STATIC_C_PLL_VCVTUNE) & M_T5_STATIC_C_PLL_VCVTUNE)

#define S_T5_STATIC_C_PLL_LFTUNE_32_40    13
#define M_T5_STATIC_C_PLL_LFTUNE_32_40    0x1ffU
#define V_T5_STATIC_C_PLL_LFTUNE_32_40(x) ((x) << S_T5_STATIC_C_PLL_LFTUNE_32_40)
#define G_T5_STATIC_C_PLL_LFTUNE_32_40(x) (((x) >> S_T5_STATIC_C_PLL_LFTUNE_32_40) & M_T5_STATIC_C_PLL_LFTUNE_32_40)

#define S_T5_STATIC_C_PLL_PREDIV    8
#define M_T5_STATIC_C_PLL_PREDIV    0x1fU
#define V_T5_STATIC_C_PLL_PREDIV(x) ((x) << S_T5_STATIC_C_PLL_PREDIV)
#define G_T5_STATIC_C_PLL_PREDIV(x) (((x) >> S_T5_STATIC_C_PLL_PREDIV) & M_T5_STATIC_C_PLL_PREDIV)

#define S_T5_STATIC_C_PLL_MULT    0
#define M_T5_STATIC_C_PLL_MULT    0xffU
#define V_T5_STATIC_C_PLL_MULT(x) ((x) << S_T5_STATIC_C_PLL_MULT)
#define G_T5_STATIC_C_PLL_MULT(x) (((x) >> S_T5_STATIC_C_PLL_MULT) & M_T5_STATIC_C_PLL_MULT)

#define A_DBG_T5_STATIC_U_PLL_CONF1 0x60e4

#define S_T5_STATIC_U_PLL_MULTFRAC    8
#define M_T5_STATIC_U_PLL_MULTFRAC    0xffffffU
#define V_T5_STATIC_U_PLL_MULTFRAC(x) ((x) << S_T5_STATIC_U_PLL_MULTFRAC)
#define G_T5_STATIC_U_PLL_MULTFRAC(x) (((x) >> S_T5_STATIC_U_PLL_MULTFRAC) & M_T5_STATIC_U_PLL_MULTFRAC)

#define S_T5_STATIC_U_PLL_FFSLEWRATE    0
#define M_T5_STATIC_U_PLL_FFSLEWRATE    0xffU
#define V_T5_STATIC_U_PLL_FFSLEWRATE(x) ((x) << S_T5_STATIC_U_PLL_FFSLEWRATE)
#define G_T5_STATIC_U_PLL_FFSLEWRATE(x) (((x) >> S_T5_STATIC_U_PLL_FFSLEWRATE) & M_T5_STATIC_U_PLL_FFSLEWRATE)

#define A_DBG_T5_STATIC_U_PLL_CONF2 0x60e8

#define S_T5_STATIC_U_PLL_DCO_BYPASS    23
#define V_T5_STATIC_U_PLL_DCO_BYPASS(x) ((x) << S_T5_STATIC_U_PLL_DCO_BYPASS)
#define F_T5_STATIC_U_PLL_DCO_BYPASS    V_T5_STATIC_U_PLL_DCO_BYPASS(1U)

#define S_T5_STATIC_U_PLL_SDORDER    21
#define M_T5_STATIC_U_PLL_SDORDER    0x3U
#define V_T5_STATIC_U_PLL_SDORDER(x) ((x) << S_T5_STATIC_U_PLL_SDORDER)
#define G_T5_STATIC_U_PLL_SDORDER(x) (((x) >> S_T5_STATIC_U_PLL_SDORDER) & M_T5_STATIC_U_PLL_SDORDER)

#define S_T5_STATIC_U_PLL_FFENABLE    20
#define V_T5_STATIC_U_PLL_FFENABLE(x) ((x) << S_T5_STATIC_U_PLL_FFENABLE)
#define F_T5_STATIC_U_PLL_FFENABLE    V_T5_STATIC_U_PLL_FFENABLE(1U)

#define S_T5_STATIC_U_PLL_STOPCLKB    19
#define V_T5_STATIC_U_PLL_STOPCLKB(x) ((x) << S_T5_STATIC_U_PLL_STOPCLKB)
#define F_T5_STATIC_U_PLL_STOPCLKB    V_T5_STATIC_U_PLL_STOPCLKB(1U)

#define S_T5_STATIC_U_PLL_STOPCLKA    18
#define V_T5_STATIC_U_PLL_STOPCLKA(x) ((x) << S_T5_STATIC_U_PLL_STOPCLKA)
#define F_T5_STATIC_U_PLL_STOPCLKA    V_T5_STATIC_U_PLL_STOPCLKA(1U)

#define S_T5_STATIC_U_PLL_SLEEP    17
#define V_T5_STATIC_U_PLL_SLEEP(x) ((x) << S_T5_STATIC_U_PLL_SLEEP)
#define F_T5_STATIC_U_PLL_SLEEP    V_T5_STATIC_U_PLL_SLEEP(1U)

#define S_T5_STATIC_U_PLL_BYPASS    16
#define V_T5_STATIC_U_PLL_BYPASS(x) ((x) << S_T5_STATIC_U_PLL_BYPASS)
#define F_T5_STATIC_U_PLL_BYPASS    V_T5_STATIC_U_PLL_BYPASS(1U)

#define S_T5_STATIC_U_PLL_LOCKTUNE    0
#define M_T5_STATIC_U_PLL_LOCKTUNE    0xffffU
#define V_T5_STATIC_U_PLL_LOCKTUNE(x) ((x) << S_T5_STATIC_U_PLL_LOCKTUNE)
#define G_T5_STATIC_U_PLL_LOCKTUNE(x) (((x) >> S_T5_STATIC_U_PLL_LOCKTUNE) & M_T5_STATIC_U_PLL_LOCKTUNE)

#define A_DBG_T5_STATIC_U_PLL_CONF3 0x60ec

#define S_T5_STATIC_U_PLL_MULTPRE    30
#define M_T5_STATIC_U_PLL_MULTPRE    0x3U
#define V_T5_STATIC_U_PLL_MULTPRE(x) ((x) << S_T5_STATIC_U_PLL_MULTPRE)
#define G_T5_STATIC_U_PLL_MULTPRE(x) (((x) >> S_T5_STATIC_U_PLL_MULTPRE) & M_T5_STATIC_U_PLL_MULTPRE)

#define S_T5_STATIC_U_PLL_LOCKSEL    28
#define M_T5_STATIC_U_PLL_LOCKSEL    0x3U
#define V_T5_STATIC_U_PLL_LOCKSEL(x) ((x) << S_T5_STATIC_U_PLL_LOCKSEL)
#define G_T5_STATIC_U_PLL_LOCKSEL(x) (((x) >> S_T5_STATIC_U_PLL_LOCKSEL) & M_T5_STATIC_U_PLL_LOCKSEL)

#define S_T5_STATIC_U_PLL_FFTUNE    12
#define M_T5_STATIC_U_PLL_FFTUNE    0xffffU
#define V_T5_STATIC_U_PLL_FFTUNE(x) ((x) << S_T5_STATIC_U_PLL_FFTUNE)
#define G_T5_STATIC_U_PLL_FFTUNE(x) (((x) >> S_T5_STATIC_U_PLL_FFTUNE) & M_T5_STATIC_U_PLL_FFTUNE)

#define S_T5_STATIC_U_PLL_RANGEPRE    10
#define M_T5_STATIC_U_PLL_RANGEPRE    0x3U
#define V_T5_STATIC_U_PLL_RANGEPRE(x) ((x) << S_T5_STATIC_U_PLL_RANGEPRE)
#define G_T5_STATIC_U_PLL_RANGEPRE(x) (((x) >> S_T5_STATIC_U_PLL_RANGEPRE) & M_T5_STATIC_U_PLL_RANGEPRE)

#define S_T5_STATIC_U_PLL_RANGEB    5
#define M_T5_STATIC_U_PLL_RANGEB    0x1fU
#define V_T5_STATIC_U_PLL_RANGEB(x) ((x) << S_T5_STATIC_U_PLL_RANGEB)
#define G_T5_STATIC_U_PLL_RANGEB(x) (((x) >> S_T5_STATIC_U_PLL_RANGEB) & M_T5_STATIC_U_PLL_RANGEB)

#define S_T5_STATIC_U_PLL_RANGEA    0
#define M_T5_STATIC_U_PLL_RANGEA    0x1fU
#define V_T5_STATIC_U_PLL_RANGEA(x) ((x) << S_T5_STATIC_U_PLL_RANGEA)
#define G_T5_STATIC_U_PLL_RANGEA(x) (((x) >> S_T5_STATIC_U_PLL_RANGEA) & M_T5_STATIC_U_PLL_RANGEA)

#define A_DBG_T5_STATIC_U_PLL_CONF4 0x60f0
#define A_DBG_T5_STATIC_U_PLL_CONF5 0x60f4

#define S_T5_STATIC_U_PLL_VCVTUNE    22
#define M_T5_STATIC_U_PLL_VCVTUNE    0x7U
#define V_T5_STATIC_U_PLL_VCVTUNE(x) ((x) << S_T5_STATIC_U_PLL_VCVTUNE)
#define G_T5_STATIC_U_PLL_VCVTUNE(x) (((x) >> S_T5_STATIC_U_PLL_VCVTUNE) & M_T5_STATIC_U_PLL_VCVTUNE)

#define S_T5_STATIC_U_PLL_LFTUNE_32_40    13
#define M_T5_STATIC_U_PLL_LFTUNE_32_40    0x1ffU
#define V_T5_STATIC_U_PLL_LFTUNE_32_40(x) ((x) << S_T5_STATIC_U_PLL_LFTUNE_32_40)
#define G_T5_STATIC_U_PLL_LFTUNE_32_40(x) (((x) >> S_T5_STATIC_U_PLL_LFTUNE_32_40) & M_T5_STATIC_U_PLL_LFTUNE_32_40)

#define S_T5_STATIC_U_PLL_PREDIV    8
#define M_T5_STATIC_U_PLL_PREDIV    0x1fU
#define V_T5_STATIC_U_PLL_PREDIV(x) ((x) << S_T5_STATIC_U_PLL_PREDIV)
#define G_T5_STATIC_U_PLL_PREDIV(x) (((x) >> S_T5_STATIC_U_PLL_PREDIV) & M_T5_STATIC_U_PLL_PREDIV)

#define S_T5_STATIC_U_PLL_MULT    0
#define M_T5_STATIC_U_PLL_MULT    0xffU
#define V_T5_STATIC_U_PLL_MULT(x) ((x) << S_T5_STATIC_U_PLL_MULT)
#define G_T5_STATIC_U_PLL_MULT(x) (((x) >> S_T5_STATIC_U_PLL_MULT) & M_T5_STATIC_U_PLL_MULT)

#define A_DBG_T5_STATIC_KR_PLL_CONF1 0x60f8

#define S_T5_STATIC_KR_PLL_BYPASS    30
#define V_T5_STATIC_KR_PLL_BYPASS(x) ((x) << S_T5_STATIC_KR_PLL_BYPASS)
#define F_T5_STATIC_KR_PLL_BYPASS    V_T5_STATIC_KR_PLL_BYPASS(1U)

#define S_T5_STATIC_KR_PLL_VBOOSTDIV    27
#define M_T5_STATIC_KR_PLL_VBOOSTDIV    0x7U
#define V_T5_STATIC_KR_PLL_VBOOSTDIV(x) ((x) << S_T5_STATIC_KR_PLL_VBOOSTDIV)
#define G_T5_STATIC_KR_PLL_VBOOSTDIV(x) (((x) >> S_T5_STATIC_KR_PLL_VBOOSTDIV) & M_T5_STATIC_KR_PLL_VBOOSTDIV)

#define S_T5_STATIC_KR_PLL_CPISEL    24
#define M_T5_STATIC_KR_PLL_CPISEL    0x7U
#define V_T5_STATIC_KR_PLL_CPISEL(x) ((x) << S_T5_STATIC_KR_PLL_CPISEL)
#define G_T5_STATIC_KR_PLL_CPISEL(x) (((x) >> S_T5_STATIC_KR_PLL_CPISEL) & M_T5_STATIC_KR_PLL_CPISEL)

#define S_T5_STATIC_KR_PLL_CCALMETHOD    23
#define V_T5_STATIC_KR_PLL_CCALMETHOD(x) ((x) << S_T5_STATIC_KR_PLL_CCALMETHOD)
#define F_T5_STATIC_KR_PLL_CCALMETHOD    V_T5_STATIC_KR_PLL_CCALMETHOD(1U)

#define S_T5_STATIC_KR_PLL_CCALLOAD    22
#define V_T5_STATIC_KR_PLL_CCALLOAD(x) ((x) << S_T5_STATIC_KR_PLL_CCALLOAD)
#define F_T5_STATIC_KR_PLL_CCALLOAD    V_T5_STATIC_KR_PLL_CCALLOAD(1U)

#define S_T5_STATIC_KR_PLL_CCALFMIN    21
#define V_T5_STATIC_KR_PLL_CCALFMIN(x) ((x) << S_T5_STATIC_KR_PLL_CCALFMIN)
#define F_T5_STATIC_KR_PLL_CCALFMIN    V_T5_STATIC_KR_PLL_CCALFMIN(1U)

#define S_T5_STATIC_KR_PLL_CCALFMAX    20
#define V_T5_STATIC_KR_PLL_CCALFMAX(x) ((x) << S_T5_STATIC_KR_PLL_CCALFMAX)
#define F_T5_STATIC_KR_PLL_CCALFMAX    V_T5_STATIC_KR_PLL_CCALFMAX(1U)

#define S_T5_STATIC_KR_PLL_CCALCVHOLD    19
#define V_T5_STATIC_KR_PLL_CCALCVHOLD(x) ((x) << S_T5_STATIC_KR_PLL_CCALCVHOLD)
#define F_T5_STATIC_KR_PLL_CCALCVHOLD    V_T5_STATIC_KR_PLL_CCALCVHOLD(1U)

#define S_T5_STATIC_KR_PLL_CCALBANDSEL    15
#define M_T5_STATIC_KR_PLL_CCALBANDSEL    0xfU
#define V_T5_STATIC_KR_PLL_CCALBANDSEL(x) ((x) << S_T5_STATIC_KR_PLL_CCALBANDSEL)
#define G_T5_STATIC_KR_PLL_CCALBANDSEL(x) (((x) >> S_T5_STATIC_KR_PLL_CCALBANDSEL) & M_T5_STATIC_KR_PLL_CCALBANDSEL)

#define S_T5_STATIC_KR_PLL_BGOFFSET    11
#define M_T5_STATIC_KR_PLL_BGOFFSET    0xfU
#define V_T5_STATIC_KR_PLL_BGOFFSET(x) ((x) << S_T5_STATIC_KR_PLL_BGOFFSET)
#define G_T5_STATIC_KR_PLL_BGOFFSET(x) (((x) >> S_T5_STATIC_KR_PLL_BGOFFSET) & M_T5_STATIC_KR_PLL_BGOFFSET)

#define S_T5_STATIC_KR_PLL_P    8
#define M_T5_STATIC_KR_PLL_P    0x7U
#define V_T5_STATIC_KR_PLL_P(x) ((x) << S_T5_STATIC_KR_PLL_P)
#define G_T5_STATIC_KR_PLL_P(x) (((x) >> S_T5_STATIC_KR_PLL_P) & M_T5_STATIC_KR_PLL_P)

#define S_T5_STATIC_KR_PLL_N2    4
#define M_T5_STATIC_KR_PLL_N2    0xfU
#define V_T5_STATIC_KR_PLL_N2(x) ((x) << S_T5_STATIC_KR_PLL_N2)
#define G_T5_STATIC_KR_PLL_N2(x) (((x) >> S_T5_STATIC_KR_PLL_N2) & M_T5_STATIC_KR_PLL_N2)

#define S_T5_STATIC_KR_PLL_N1    0
#define M_T5_STATIC_KR_PLL_N1    0xfU
#define V_T5_STATIC_KR_PLL_N1(x) ((x) << S_T5_STATIC_KR_PLL_N1)
#define G_T5_STATIC_KR_PLL_N1(x) (((x) >> S_T5_STATIC_KR_PLL_N1) & M_T5_STATIC_KR_PLL_N1)

#define A_DBG_T5_STATIC_KR_PLL_CONF2 0x60fc

#define S_T5_STATIC_KR_PLL_M    11
#define M_T5_STATIC_KR_PLL_M    0x1ffU
#define V_T5_STATIC_KR_PLL_M(x) ((x) << S_T5_STATIC_KR_PLL_M)
#define G_T5_STATIC_KR_PLL_M(x) (((x) >> S_T5_STATIC_KR_PLL_M) & M_T5_STATIC_KR_PLL_M)

#define S_T5_STATIC_KR_PLL_ANALOGTUNE    0
#define M_T5_STATIC_KR_PLL_ANALOGTUNE    0x7ffU
#define V_T5_STATIC_KR_PLL_ANALOGTUNE(x) ((x) << S_T5_STATIC_KR_PLL_ANALOGTUNE)
#define G_T5_STATIC_KR_PLL_ANALOGTUNE(x) (((x) >> S_T5_STATIC_KR_PLL_ANALOGTUNE) & M_T5_STATIC_KR_PLL_ANALOGTUNE)

#define A_DBG_PVT_REG_CALIBRATE_CTL 0x6100

#define S_HALT_CALIBRATE    1
#define V_HALT_CALIBRATE(x) ((x) << S_HALT_CALIBRATE)
#define F_HALT_CALIBRATE    V_HALT_CALIBRATE(1U)

#define S_RESET_CALIBRATE    0
#define V_RESET_CALIBRATE(x) ((x) << S_RESET_CALIBRATE)
#define F_RESET_CALIBRATE    V_RESET_CALIBRATE(1U)

#define A_DBG_GPIO_EN_NEW 0x6100

#define S_GPIO16_OEN    7
#define V_GPIO16_OEN(x) ((x) << S_GPIO16_OEN)
#define F_GPIO16_OEN    V_GPIO16_OEN(1U)

#define S_GPIO17_OEN    6
#define V_GPIO17_OEN(x) ((x) << S_GPIO17_OEN)
#define F_GPIO17_OEN    V_GPIO17_OEN(1U)

#define S_GPIO18_OEN    5
#define V_GPIO18_OEN(x) ((x) << S_GPIO18_OEN)
#define F_GPIO18_OEN    V_GPIO18_OEN(1U)

#define S_GPIO19_OEN    4
#define V_GPIO19_OEN(x) ((x) << S_GPIO19_OEN)
#define F_GPIO19_OEN    V_GPIO19_OEN(1U)

#define S_GPIO16_OUT_VAL    3
#define V_GPIO16_OUT_VAL(x) ((x) << S_GPIO16_OUT_VAL)
#define F_GPIO16_OUT_VAL    V_GPIO16_OUT_VAL(1U)

#define S_GPIO17_OUT_VAL    2
#define V_GPIO17_OUT_VAL(x) ((x) << S_GPIO17_OUT_VAL)
#define F_GPIO17_OUT_VAL    V_GPIO17_OUT_VAL(1U)

#define S_GPIO18_OUT_VAL    1
#define V_GPIO18_OUT_VAL(x) ((x) << S_GPIO18_OUT_VAL)
#define F_GPIO18_OUT_VAL    V_GPIO18_OUT_VAL(1U)

#define S_GPIO19_OUT_VAL    0
#define V_GPIO19_OUT_VAL(x) ((x) << S_GPIO19_OUT_VAL)
#define F_GPIO19_OUT_VAL    V_GPIO19_OUT_VAL(1U)

#define A_DBG_PVT_REG_UPDATE_CTL 0x6104

#define S_FAST_UPDATE    8
#define V_FAST_UPDATE(x) ((x) << S_FAST_UPDATE)
#define F_FAST_UPDATE    V_FAST_UPDATE(1U)

#define S_FORCE_REG_IN_VALUE    2
#define V_FORCE_REG_IN_VALUE(x) ((x) << S_FORCE_REG_IN_VALUE)
#define F_FORCE_REG_IN_VALUE    V_FORCE_REG_IN_VALUE(1U)

#define S_HALT_UPDATE    1
#define V_HALT_UPDATE(x) ((x) << S_HALT_UPDATE)
#define F_HALT_UPDATE    V_HALT_UPDATE(1U)

#define A_DBG_GPIO_IN_NEW 0x6104

#define S_GPIO16_CHG_DET    7
#define V_GPIO16_CHG_DET(x) ((x) << S_GPIO16_CHG_DET)
#define F_GPIO16_CHG_DET    V_GPIO16_CHG_DET(1U)

#define S_GPIO17_CHG_DET    6
#define V_GPIO17_CHG_DET(x) ((x) << S_GPIO17_CHG_DET)
#define F_GPIO17_CHG_DET    V_GPIO17_CHG_DET(1U)

#define S_GPIO18_CHG_DET    5
#define V_GPIO18_CHG_DET(x) ((x) << S_GPIO18_CHG_DET)
#define F_GPIO18_CHG_DET    V_GPIO18_CHG_DET(1U)

#define S_GPIO19_CHG_DET    4
#define V_GPIO19_CHG_DET(x) ((x) << S_GPIO19_CHG_DET)
#define F_GPIO19_CHG_DET    V_GPIO19_CHG_DET(1U)

#define S_GPIO16_IN    3
#define V_GPIO16_IN(x) ((x) << S_GPIO16_IN)
#define F_GPIO16_IN    V_GPIO16_IN(1U)

#define S_GPIO17_IN    2
#define V_GPIO17_IN(x) ((x) << S_GPIO17_IN)
#define F_GPIO17_IN    V_GPIO17_IN(1U)

#define S_GPIO18_IN    1
#define V_GPIO18_IN(x) ((x) << S_GPIO18_IN)
#define F_GPIO18_IN    V_GPIO18_IN(1U)

#define S_GPIO19_IN    0
#define V_GPIO19_IN(x) ((x) << S_GPIO19_IN)
#define F_GPIO19_IN    V_GPIO19_IN(1U)

#define A_DBG_PVT_REG_LAST_MEASUREMENT 0x6108

#define S_LAST_MEASUREMENT_SELECT    8
#define M_LAST_MEASUREMENT_SELECT    0x3U
#define V_LAST_MEASUREMENT_SELECT(x) ((x) << S_LAST_MEASUREMENT_SELECT)
#define G_LAST_MEASUREMENT_SELECT(x) (((x) >> S_LAST_MEASUREMENT_SELECT) & M_LAST_MEASUREMENT_SELECT)

#define S_LAST_MEASUREMENT_RESULT_BANK_B    4
#define M_LAST_MEASUREMENT_RESULT_BANK_B    0xfU
#define V_LAST_MEASUREMENT_RESULT_BANK_B(x) ((x) << S_LAST_MEASUREMENT_RESULT_BANK_B)
#define G_LAST_MEASUREMENT_RESULT_BANK_B(x) (((x) >> S_LAST_MEASUREMENT_RESULT_BANK_B) & M_LAST_MEASUREMENT_RESULT_BANK_B)

#define S_LAST_MEASUREMENT_RESULT_BANK_A    0
#define M_LAST_MEASUREMENT_RESULT_BANK_A    0xfU
#define V_LAST_MEASUREMENT_RESULT_BANK_A(x) ((x) << S_LAST_MEASUREMENT_RESULT_BANK_A)
#define G_LAST_MEASUREMENT_RESULT_BANK_A(x) (((x) >> S_LAST_MEASUREMENT_RESULT_BANK_A) & M_LAST_MEASUREMENT_RESULT_BANK_A)

#define A_DBG_T5_STATIC_KX_PLL_CONF1 0x6108

#define S_T5_STATIC_KX_PLL_BYPASS    30
#define V_T5_STATIC_KX_PLL_BYPASS(x) ((x) << S_T5_STATIC_KX_PLL_BYPASS)
#define F_T5_STATIC_KX_PLL_BYPASS    V_T5_STATIC_KX_PLL_BYPASS(1U)

#define S_T5_STATIC_KX_PLL_VBOOSTDIV    27
#define M_T5_STATIC_KX_PLL_VBOOSTDIV    0x7U
#define V_T5_STATIC_KX_PLL_VBOOSTDIV(x) ((x) << S_T5_STATIC_KX_PLL_VBOOSTDIV)
#define G_T5_STATIC_KX_PLL_VBOOSTDIV(x) (((x) >> S_T5_STATIC_KX_PLL_VBOOSTDIV) & M_T5_STATIC_KX_PLL_VBOOSTDIV)

#define S_T5_STATIC_KX_PLL_CPISEL    24
#define M_T5_STATIC_KX_PLL_CPISEL    0x7U
#define V_T5_STATIC_KX_PLL_CPISEL(x) ((x) << S_T5_STATIC_KX_PLL_CPISEL)
#define G_T5_STATIC_KX_PLL_CPISEL(x) (((x) >> S_T5_STATIC_KX_PLL_CPISEL) & M_T5_STATIC_KX_PLL_CPISEL)

#define S_T5_STATIC_KX_PLL_CCALMETHOD    23
#define V_T5_STATIC_KX_PLL_CCALMETHOD(x) ((x) << S_T5_STATIC_KX_PLL_CCALMETHOD)
#define F_T5_STATIC_KX_PLL_CCALMETHOD    V_T5_STATIC_KX_PLL_CCALMETHOD(1U)

#define S_T5_STATIC_KX_PLL_CCALLOAD    22
#define V_T5_STATIC_KX_PLL_CCALLOAD(x) ((x) << S_T5_STATIC_KX_PLL_CCALLOAD)
#define F_T5_STATIC_KX_PLL_CCALLOAD    V_T5_STATIC_KX_PLL_CCALLOAD(1U)

#define S_T5_STATIC_KX_PLL_CCALFMIN    21
#define V_T5_STATIC_KX_PLL_CCALFMIN(x) ((x) << S_T5_STATIC_KX_PLL_CCALFMIN)
#define F_T5_STATIC_KX_PLL_CCALFMIN    V_T5_STATIC_KX_PLL_CCALFMIN(1U)

#define S_T5_STATIC_KX_PLL_CCALFMAX    20
#define V_T5_STATIC_KX_PLL_CCALFMAX(x) ((x) << S_T5_STATIC_KX_PLL_CCALFMAX)
#define F_T5_STATIC_KX_PLL_CCALFMAX    V_T5_STATIC_KX_PLL_CCALFMAX(1U)

#define S_T5_STATIC_KX_PLL_CCALCVHOLD    19
#define V_T5_STATIC_KX_PLL_CCALCVHOLD(x) ((x) << S_T5_STATIC_KX_PLL_CCALCVHOLD)
#define F_T5_STATIC_KX_PLL_CCALCVHOLD    V_T5_STATIC_KX_PLL_CCALCVHOLD(1U)

#define S_T5_STATIC_KX_PLL_CCALBANDSEL    15
#define M_T5_STATIC_KX_PLL_CCALBANDSEL    0xfU
#define V_T5_STATIC_KX_PLL_CCALBANDSEL(x) ((x) << S_T5_STATIC_KX_PLL_CCALBANDSEL)
#define G_T5_STATIC_KX_PLL_CCALBANDSEL(x) (((x) >> S_T5_STATIC_KX_PLL_CCALBANDSEL) & M_T5_STATIC_KX_PLL_CCALBANDSEL)

#define S_T5_STATIC_KX_PLL_BGOFFSET    11
#define M_T5_STATIC_KX_PLL_BGOFFSET    0xfU
#define V_T5_STATIC_KX_PLL_BGOFFSET(x) ((x) << S_T5_STATIC_KX_PLL_BGOFFSET)
#define G_T5_STATIC_KX_PLL_BGOFFSET(x) (((x) >> S_T5_STATIC_KX_PLL_BGOFFSET) & M_T5_STATIC_KX_PLL_BGOFFSET)

#define S_T5_STATIC_KX_PLL_P    8
#define M_T5_STATIC_KX_PLL_P    0x7U
#define V_T5_STATIC_KX_PLL_P(x) ((x) << S_T5_STATIC_KX_PLL_P)
#define G_T5_STATIC_KX_PLL_P(x) (((x) >> S_T5_STATIC_KX_PLL_P) & M_T5_STATIC_KX_PLL_P)

#define S_T5_STATIC_KX_PLL_N2    4
#define M_T5_STATIC_KX_PLL_N2    0xfU
#define V_T5_STATIC_KX_PLL_N2(x) ((x) << S_T5_STATIC_KX_PLL_N2)
#define G_T5_STATIC_KX_PLL_N2(x) (((x) >> S_T5_STATIC_KX_PLL_N2) & M_T5_STATIC_KX_PLL_N2)

#define S_T5_STATIC_KX_PLL_N1    0
#define M_T5_STATIC_KX_PLL_N1    0xfU
#define V_T5_STATIC_KX_PLL_N1(x) ((x) << S_T5_STATIC_KX_PLL_N1)
#define G_T5_STATIC_KX_PLL_N1(x) (((x) >> S_T5_STATIC_KX_PLL_N1) & M_T5_STATIC_KX_PLL_N1)

#define A_DBG_PVT_REG_DRVN 0x610c

#define S_PVT_REG_DRVN_EN    8
#define V_PVT_REG_DRVN_EN(x) ((x) << S_PVT_REG_DRVN_EN)
#define F_PVT_REG_DRVN_EN    V_PVT_REG_DRVN_EN(1U)

#define S_PVT_REG_DRVN_B    4
#define M_PVT_REG_DRVN_B    0xfU
#define V_PVT_REG_DRVN_B(x) ((x) << S_PVT_REG_DRVN_B)
#define G_PVT_REG_DRVN_B(x) (((x) >> S_PVT_REG_DRVN_B) & M_PVT_REG_DRVN_B)

#define S_PVT_REG_DRVN_A    0
#define M_PVT_REG_DRVN_A    0xfU
#define V_PVT_REG_DRVN_A(x) ((x) << S_PVT_REG_DRVN_A)
#define G_PVT_REG_DRVN_A(x) (((x) >> S_PVT_REG_DRVN_A) & M_PVT_REG_DRVN_A)

#define A_DBG_T5_STATIC_KX_PLL_CONF2 0x610c

#define S_T5_STATIC_KX_PLL_M    11
#define M_T5_STATIC_KX_PLL_M    0x1ffU
#define V_T5_STATIC_KX_PLL_M(x) ((x) << S_T5_STATIC_KX_PLL_M)
#define G_T5_STATIC_KX_PLL_M(x) (((x) >> S_T5_STATIC_KX_PLL_M) & M_T5_STATIC_KX_PLL_M)

#define S_T5_STATIC_KX_PLL_ANALOGTUNE    0
#define M_T5_STATIC_KX_PLL_ANALOGTUNE    0x7ffU
#define V_T5_STATIC_KX_PLL_ANALOGTUNE(x) ((x) << S_T5_STATIC_KX_PLL_ANALOGTUNE)
#define G_T5_STATIC_KX_PLL_ANALOGTUNE(x) (((x) >> S_T5_STATIC_KX_PLL_ANALOGTUNE) & M_T5_STATIC_KX_PLL_ANALOGTUNE)

#define A_DBG_PVT_REG_DRVP 0x6110

#define S_PVT_REG_DRVP_EN    8
#define V_PVT_REG_DRVP_EN(x) ((x) << S_PVT_REG_DRVP_EN)
#define F_PVT_REG_DRVP_EN    V_PVT_REG_DRVP_EN(1U)

#define S_PVT_REG_DRVP_B    4
#define M_PVT_REG_DRVP_B    0xfU
#define V_PVT_REG_DRVP_B(x) ((x) << S_PVT_REG_DRVP_B)
#define G_PVT_REG_DRVP_B(x) (((x) >> S_PVT_REG_DRVP_B) & M_PVT_REG_DRVP_B)

#define S_PVT_REG_DRVP_A    0
#define M_PVT_REG_DRVP_A    0xfU
#define V_PVT_REG_DRVP_A(x) ((x) << S_PVT_REG_DRVP_A)
#define G_PVT_REG_DRVP_A(x) (((x) >> S_PVT_REG_DRVP_A) & M_PVT_REG_DRVP_A)

#define A_DBG_T5_STATIC_C_DFS_CONF 0x6110

#define S_STATIC_C_DFS_RANGEA    8
#define M_STATIC_C_DFS_RANGEA    0x1fU
#define V_STATIC_C_DFS_RANGEA(x) ((x) << S_STATIC_C_DFS_RANGEA)
#define G_STATIC_C_DFS_RANGEA(x) (((x) >> S_STATIC_C_DFS_RANGEA) & M_STATIC_C_DFS_RANGEA)

#define S_STATIC_C_DFS_RANGEB    3
#define M_STATIC_C_DFS_RANGEB    0x1fU
#define V_STATIC_C_DFS_RANGEB(x) ((x) << S_STATIC_C_DFS_RANGEB)
#define G_STATIC_C_DFS_RANGEB(x) (((x) >> S_STATIC_C_DFS_RANGEB) & M_STATIC_C_DFS_RANGEB)

#define S_STATIC_C_DFS_FFTUNE4    2
#define V_STATIC_C_DFS_FFTUNE4(x) ((x) << S_STATIC_C_DFS_FFTUNE4)
#define F_STATIC_C_DFS_FFTUNE4    V_STATIC_C_DFS_FFTUNE4(1U)

#define S_STATIC_C_DFS_FFTUNE5    1
#define V_STATIC_C_DFS_FFTUNE5(x) ((x) << S_STATIC_C_DFS_FFTUNE5)
#define F_STATIC_C_DFS_FFTUNE5    V_STATIC_C_DFS_FFTUNE5(1U)

#define S_STATIC_C_DFS_ENABLE    0
#define V_STATIC_C_DFS_ENABLE(x) ((x) << S_STATIC_C_DFS_ENABLE)
#define F_STATIC_C_DFS_ENABLE    V_STATIC_C_DFS_ENABLE(1U)

#define A_DBG_PVT_REG_TERMN 0x6114

#define S_PVT_REG_TERMN_EN    8
#define V_PVT_REG_TERMN_EN(x) ((x) << S_PVT_REG_TERMN_EN)
#define F_PVT_REG_TERMN_EN    V_PVT_REG_TERMN_EN(1U)

#define S_PVT_REG_TERMN_B    4
#define M_PVT_REG_TERMN_B    0xfU
#define V_PVT_REG_TERMN_B(x) ((x) << S_PVT_REG_TERMN_B)
#define G_PVT_REG_TERMN_B(x) (((x) >> S_PVT_REG_TERMN_B) & M_PVT_REG_TERMN_B)

#define S_PVT_REG_TERMN_A    0
#define M_PVT_REG_TERMN_A    0xfU
#define V_PVT_REG_TERMN_A(x) ((x) << S_PVT_REG_TERMN_A)
#define G_PVT_REG_TERMN_A(x) (((x) >> S_PVT_REG_TERMN_A) & M_PVT_REG_TERMN_A)

#define A_DBG_T5_STATIC_U_DFS_CONF 0x6114

#define S_STATIC_U_DFS_RANGEA    8
#define M_STATIC_U_DFS_RANGEA    0x1fU
#define V_STATIC_U_DFS_RANGEA(x) ((x) << S_STATIC_U_DFS_RANGEA)
#define G_STATIC_U_DFS_RANGEA(x) (((x) >> S_STATIC_U_DFS_RANGEA) & M_STATIC_U_DFS_RANGEA)

#define S_STATIC_U_DFS_RANGEB    3
#define M_STATIC_U_DFS_RANGEB    0x1fU
#define V_STATIC_U_DFS_RANGEB(x) ((x) << S_STATIC_U_DFS_RANGEB)
#define G_STATIC_U_DFS_RANGEB(x) (((x) >> S_STATIC_U_DFS_RANGEB) & M_STATIC_U_DFS_RANGEB)

#define S_STATIC_U_DFS_FFTUNE4    2
#define V_STATIC_U_DFS_FFTUNE4(x) ((x) << S_STATIC_U_DFS_FFTUNE4)
#define F_STATIC_U_DFS_FFTUNE4    V_STATIC_U_DFS_FFTUNE4(1U)

#define S_STATIC_U_DFS_FFTUNE5    1
#define V_STATIC_U_DFS_FFTUNE5(x) ((x) << S_STATIC_U_DFS_FFTUNE5)
#define F_STATIC_U_DFS_FFTUNE5    V_STATIC_U_DFS_FFTUNE5(1U)

#define S_STATIC_U_DFS_ENABLE    0
#define V_STATIC_U_DFS_ENABLE(x) ((x) << S_STATIC_U_DFS_ENABLE)
#define F_STATIC_U_DFS_ENABLE    V_STATIC_U_DFS_ENABLE(1U)

#define A_DBG_PVT_REG_TERMP 0x6118

#define S_PVT_REG_TERMP_EN    8
#define V_PVT_REG_TERMP_EN(x) ((x) << S_PVT_REG_TERMP_EN)
#define F_PVT_REG_TERMP_EN    V_PVT_REG_TERMP_EN(1U)

#define S_PVT_REG_TERMP_B    4
#define M_PVT_REG_TERMP_B    0xfU
#define V_PVT_REG_TERMP_B(x) ((x) << S_PVT_REG_TERMP_B)
#define G_PVT_REG_TERMP_B(x) (((x) >> S_PVT_REG_TERMP_B) & M_PVT_REG_TERMP_B)

#define S_PVT_REG_TERMP_A    0
#define M_PVT_REG_TERMP_A    0xfU
#define V_PVT_REG_TERMP_A(x) ((x) << S_PVT_REG_TERMP_A)
#define G_PVT_REG_TERMP_A(x) (((x) >> S_PVT_REG_TERMP_A) & M_PVT_REG_TERMP_A)

#define A_DBG_GPIO_PE_EN 0x6118

#define S_GPIO19_PE_EN    19
#define V_GPIO19_PE_EN(x) ((x) << S_GPIO19_PE_EN)
#define F_GPIO19_PE_EN    V_GPIO19_PE_EN(1U)

#define S_GPIO18_PE_EN    18
#define V_GPIO18_PE_EN(x) ((x) << S_GPIO18_PE_EN)
#define F_GPIO18_PE_EN    V_GPIO18_PE_EN(1U)

#define S_GPIO17_PE_EN    17
#define V_GPIO17_PE_EN(x) ((x) << S_GPIO17_PE_EN)
#define F_GPIO17_PE_EN    V_GPIO17_PE_EN(1U)

#define S_GPIO16_PE_EN    16
#define V_GPIO16_PE_EN(x) ((x) << S_GPIO16_PE_EN)
#define F_GPIO16_PE_EN    V_GPIO16_PE_EN(1U)

#define S_GPIO15_PE_EN    15
#define V_GPIO15_PE_EN(x) ((x) << S_GPIO15_PE_EN)
#define F_GPIO15_PE_EN    V_GPIO15_PE_EN(1U)

#define S_GPIO14_PE_EN    14
#define V_GPIO14_PE_EN(x) ((x) << S_GPIO14_PE_EN)
#define F_GPIO14_PE_EN    V_GPIO14_PE_EN(1U)

#define S_GPIO13_PE_EN    13
#define V_GPIO13_PE_EN(x) ((x) << S_GPIO13_PE_EN)
#define F_GPIO13_PE_EN    V_GPIO13_PE_EN(1U)

#define S_GPIO12_PE_EN    12
#define V_GPIO12_PE_EN(x) ((x) << S_GPIO12_PE_EN)
#define F_GPIO12_PE_EN    V_GPIO12_PE_EN(1U)

#define S_GPIO11_PE_EN    11
#define V_GPIO11_PE_EN(x) ((x) << S_GPIO11_PE_EN)
#define F_GPIO11_PE_EN    V_GPIO11_PE_EN(1U)

#define S_GPIO10_PE_EN    10
#define V_GPIO10_PE_EN(x) ((x) << S_GPIO10_PE_EN)
#define F_GPIO10_PE_EN    V_GPIO10_PE_EN(1U)

#define S_GPIO9_PE_EN    9
#define V_GPIO9_PE_EN(x) ((x) << S_GPIO9_PE_EN)
#define F_GPIO9_PE_EN    V_GPIO9_PE_EN(1U)

#define S_GPIO8_PE_EN    8
#define V_GPIO8_PE_EN(x) ((x) << S_GPIO8_PE_EN)
#define F_GPIO8_PE_EN    V_GPIO8_PE_EN(1U)

#define S_GPIO7_PE_EN    7
#define V_GPIO7_PE_EN(x) ((x) << S_GPIO7_PE_EN)
#define F_GPIO7_PE_EN    V_GPIO7_PE_EN(1U)

#define S_GPIO6_PE_EN    6
#define V_GPIO6_PE_EN(x) ((x) << S_GPIO6_PE_EN)
#define F_GPIO6_PE_EN    V_GPIO6_PE_EN(1U)

#define S_GPIO5_PE_EN    5
#define V_GPIO5_PE_EN(x) ((x) << S_GPIO5_PE_EN)
#define F_GPIO5_PE_EN    V_GPIO5_PE_EN(1U)

#define S_GPIO4_PE_EN    4
#define V_GPIO4_PE_EN(x) ((x) << S_GPIO4_PE_EN)
#define F_GPIO4_PE_EN    V_GPIO4_PE_EN(1U)

#define S_GPIO3_PE_EN    3
#define V_GPIO3_PE_EN(x) ((x) << S_GPIO3_PE_EN)
#define F_GPIO3_PE_EN    V_GPIO3_PE_EN(1U)

#define S_GPIO2_PE_EN    2
#define V_GPIO2_PE_EN(x) ((x) << S_GPIO2_PE_EN)
#define F_GPIO2_PE_EN    V_GPIO2_PE_EN(1U)

#define S_GPIO1_PE_EN    1
#define V_GPIO1_PE_EN(x) ((x) << S_GPIO1_PE_EN)
#define F_GPIO1_PE_EN    V_GPIO1_PE_EN(1U)

#define S_GPIO0_PE_EN    0
#define V_GPIO0_PE_EN(x) ((x) << S_GPIO0_PE_EN)
#define F_GPIO0_PE_EN    V_GPIO0_PE_EN(1U)

#define A_DBG_PVT_REG_THRESHOLD 0x611c

#define S_PVT_CALIBRATION_DONE    8
#define V_PVT_CALIBRATION_DONE(x) ((x) << S_PVT_CALIBRATION_DONE)
#define F_PVT_CALIBRATION_DONE    V_PVT_CALIBRATION_DONE(1U)

#define S_THRESHOLD_TERMP_MAX_SYNC    7
#define V_THRESHOLD_TERMP_MAX_SYNC(x) ((x) << S_THRESHOLD_TERMP_MAX_SYNC)
#define F_THRESHOLD_TERMP_MAX_SYNC    V_THRESHOLD_TERMP_MAX_SYNC(1U)

#define S_THRESHOLD_TERMP_MIN_SYNC    6
#define V_THRESHOLD_TERMP_MIN_SYNC(x) ((x) << S_THRESHOLD_TERMP_MIN_SYNC)
#define F_THRESHOLD_TERMP_MIN_SYNC    V_THRESHOLD_TERMP_MIN_SYNC(1U)

#define S_THRESHOLD_TERMN_MAX_SYNC    5
#define V_THRESHOLD_TERMN_MAX_SYNC(x) ((x) << S_THRESHOLD_TERMN_MAX_SYNC)
#define F_THRESHOLD_TERMN_MAX_SYNC    V_THRESHOLD_TERMN_MAX_SYNC(1U)

#define S_THRESHOLD_TERMN_MIN_SYNC    4
#define V_THRESHOLD_TERMN_MIN_SYNC(x) ((x) << S_THRESHOLD_TERMN_MIN_SYNC)
#define F_THRESHOLD_TERMN_MIN_SYNC    V_THRESHOLD_TERMN_MIN_SYNC(1U)

#define S_THRESHOLD_DRVP_MAX_SYNC    3
#define V_THRESHOLD_DRVP_MAX_SYNC(x) ((x) << S_THRESHOLD_DRVP_MAX_SYNC)
#define F_THRESHOLD_DRVP_MAX_SYNC    V_THRESHOLD_DRVP_MAX_SYNC(1U)

#define S_THRESHOLD_DRVP_MIN_SYNC    2
#define V_THRESHOLD_DRVP_MIN_SYNC(x) ((x) << S_THRESHOLD_DRVP_MIN_SYNC)
#define F_THRESHOLD_DRVP_MIN_SYNC    V_THRESHOLD_DRVP_MIN_SYNC(1U)

#define S_THRESHOLD_DRVN_MAX_SYNC    1
#define V_THRESHOLD_DRVN_MAX_SYNC(x) ((x) << S_THRESHOLD_DRVN_MAX_SYNC)
#define F_THRESHOLD_DRVN_MAX_SYNC    V_THRESHOLD_DRVN_MAX_SYNC(1U)

#define S_THRESHOLD_DRVN_MIN_SYNC    0
#define V_THRESHOLD_DRVN_MIN_SYNC(x) ((x) << S_THRESHOLD_DRVN_MIN_SYNC)
#define F_THRESHOLD_DRVN_MIN_SYNC    V_THRESHOLD_DRVN_MIN_SYNC(1U)

#define A_DBG_GPIO_PS_EN 0x611c

#define S_GPIO19_PS_EN    19
#define V_GPIO19_PS_EN(x) ((x) << S_GPIO19_PS_EN)
#define F_GPIO19_PS_EN    V_GPIO19_PS_EN(1U)

#define S_GPIO18_PS_EN    18
#define V_GPIO18_PS_EN(x) ((x) << S_GPIO18_PS_EN)
#define F_GPIO18_PS_EN    V_GPIO18_PS_EN(1U)

#define S_GPIO17_PS_EN    17
#define V_GPIO17_PS_EN(x) ((x) << S_GPIO17_PS_EN)
#define F_GPIO17_PS_EN    V_GPIO17_PS_EN(1U)

#define S_GPIO16_PS_EN    16
#define V_GPIO16_PS_EN(x) ((x) << S_GPIO16_PS_EN)
#define F_GPIO16_PS_EN    V_GPIO16_PS_EN(1U)

#define S_GPIO15_PS_EN    15
#define V_GPIO15_PS_EN(x) ((x) << S_GPIO15_PS_EN)
#define F_GPIO15_PS_EN    V_GPIO15_PS_EN(1U)

#define S_GPIO14_PS_EN    14
#define V_GPIO14_PS_EN(x) ((x) << S_GPIO14_PS_EN)
#define F_GPIO14_PS_EN    V_GPIO14_PS_EN(1U)

#define S_GPIO13_PS_EN    13
#define V_GPIO13_PS_EN(x) ((x) << S_GPIO13_PS_EN)
#define F_GPIO13_PS_EN    V_GPIO13_PS_EN(1U)

#define S_GPIO12_PS_EN    12
#define V_GPIO12_PS_EN(x) ((x) << S_GPIO12_PS_EN)
#define F_GPIO12_PS_EN    V_GPIO12_PS_EN(1U)

#define S_GPIO11_PS_EN    11
#define V_GPIO11_PS_EN(x) ((x) << S_GPIO11_PS_EN)
#define F_GPIO11_PS_EN    V_GPIO11_PS_EN(1U)

#define S_GPIO10_PS_EN    10
#define V_GPIO10_PS_EN(x) ((x) << S_GPIO10_PS_EN)
#define F_GPIO10_PS_EN    V_GPIO10_PS_EN(1U)

#define S_GPIO9_PS_EN    9
#define V_GPIO9_PS_EN(x) ((x) << S_GPIO9_PS_EN)
#define F_GPIO9_PS_EN    V_GPIO9_PS_EN(1U)

#define S_GPIO8_PS_EN    8
#define V_GPIO8_PS_EN(x) ((x) << S_GPIO8_PS_EN)
#define F_GPIO8_PS_EN    V_GPIO8_PS_EN(1U)

#define S_GPIO7_PS_EN    7
#define V_GPIO7_PS_EN(x) ((x) << S_GPIO7_PS_EN)
#define F_GPIO7_PS_EN    V_GPIO7_PS_EN(1U)

#define S_GPIO6_PS_EN    6
#define V_GPIO6_PS_EN(x) ((x) << S_GPIO6_PS_EN)
#define F_GPIO6_PS_EN    V_GPIO6_PS_EN(1U)

#define S_GPIO5_PS_EN    5
#define V_GPIO5_PS_EN(x) ((x) << S_GPIO5_PS_EN)
#define F_GPIO5_PS_EN    V_GPIO5_PS_EN(1U)

#define S_GPIO4_PS_EN    4
#define V_GPIO4_PS_EN(x) ((x) << S_GPIO4_PS_EN)
#define F_GPIO4_PS_EN    V_GPIO4_PS_EN(1U)

#define S_GPIO3_PS_EN    3
#define V_GPIO3_PS_EN(x) ((x) << S_GPIO3_PS_EN)
#define F_GPIO3_PS_EN    V_GPIO3_PS_EN(1U)

#define S_GPIO2_PS_EN    2
#define V_GPIO2_PS_EN(x) ((x) << S_GPIO2_PS_EN)
#define F_GPIO2_PS_EN    V_GPIO2_PS_EN(1U)

#define S_GPIO1_PS_EN    1
#define V_GPIO1_PS_EN(x) ((x) << S_GPIO1_PS_EN)
#define F_GPIO1_PS_EN    V_GPIO1_PS_EN(1U)

#define S_GPIO0_PS_EN    0
#define V_GPIO0_PS_EN(x) ((x) << S_GPIO0_PS_EN)
#define F_GPIO0_PS_EN    V_GPIO0_PS_EN(1U)

#define A_DBG_PVT_REG_IN_TERMP 0x6120

#define S_REG_IN_TERMP_B    4
#define M_REG_IN_TERMP_B    0xfU
#define V_REG_IN_TERMP_B(x) ((x) << S_REG_IN_TERMP_B)
#define G_REG_IN_TERMP_B(x) (((x) >> S_REG_IN_TERMP_B) & M_REG_IN_TERMP_B)

#define S_REG_IN_TERMP_A    0
#define M_REG_IN_TERMP_A    0xfU
#define V_REG_IN_TERMP_A(x) ((x) << S_REG_IN_TERMP_A)
#define G_REG_IN_TERMP_A(x) (((x) >> S_REG_IN_TERMP_A) & M_REG_IN_TERMP_A)

#define A_DBG_EFUSE_BYTE16_19 0x6120
#define A_DBG_PVT_REG_IN_TERMN 0x6124

#define S_REG_IN_TERMN_B    4
#define M_REG_IN_TERMN_B    0xfU
#define V_REG_IN_TERMN_B(x) ((x) << S_REG_IN_TERMN_B)
#define G_REG_IN_TERMN_B(x) (((x) >> S_REG_IN_TERMN_B) & M_REG_IN_TERMN_B)

#define S_REG_IN_TERMN_A    0
#define M_REG_IN_TERMN_A    0xfU
#define V_REG_IN_TERMN_A(x) ((x) << S_REG_IN_TERMN_A)
#define G_REG_IN_TERMN_A(x) (((x) >> S_REG_IN_TERMN_A) & M_REG_IN_TERMN_A)

#define A_DBG_EFUSE_BYTE20_23 0x6124
#define A_DBG_PVT_REG_IN_DRVP 0x6128

#define S_REG_IN_DRVP_B    4
#define M_REG_IN_DRVP_B    0xfU
#define V_REG_IN_DRVP_B(x) ((x) << S_REG_IN_DRVP_B)
#define G_REG_IN_DRVP_B(x) (((x) >> S_REG_IN_DRVP_B) & M_REG_IN_DRVP_B)

#define S_REG_IN_DRVP_A    0
#define M_REG_IN_DRVP_A    0xfU
#define V_REG_IN_DRVP_A(x) ((x) << S_REG_IN_DRVP_A)
#define G_REG_IN_DRVP_A(x) (((x) >> S_REG_IN_DRVP_A) & M_REG_IN_DRVP_A)

#define A_DBG_EFUSE_BYTE24_27 0x6128
#define A_DBG_PVT_REG_IN_DRVN 0x612c

#define S_REG_IN_DRVN_B    4
#define M_REG_IN_DRVN_B    0xfU
#define V_REG_IN_DRVN_B(x) ((x) << S_REG_IN_DRVN_B)
#define G_REG_IN_DRVN_B(x) (((x) >> S_REG_IN_DRVN_B) & M_REG_IN_DRVN_B)

#define S_REG_IN_DRVN_A    0
#define M_REG_IN_DRVN_A    0xfU
#define V_REG_IN_DRVN_A(x) ((x) << S_REG_IN_DRVN_A)
#define G_REG_IN_DRVN_A(x) (((x) >> S_REG_IN_DRVN_A) & M_REG_IN_DRVN_A)

#define A_DBG_EFUSE_BYTE28_31 0x612c
#define A_DBG_PVT_REG_OUT_TERMP 0x6130

#define S_REG_OUT_TERMP_B    4
#define M_REG_OUT_TERMP_B    0xfU
#define V_REG_OUT_TERMP_B(x) ((x) << S_REG_OUT_TERMP_B)
#define G_REG_OUT_TERMP_B(x) (((x) >> S_REG_OUT_TERMP_B) & M_REG_OUT_TERMP_B)

#define S_REG_OUT_TERMP_A    0
#define M_REG_OUT_TERMP_A    0xfU
#define V_REG_OUT_TERMP_A(x) ((x) << S_REG_OUT_TERMP_A)
#define G_REG_OUT_TERMP_A(x) (((x) >> S_REG_OUT_TERMP_A) & M_REG_OUT_TERMP_A)

#define A_DBG_EFUSE_BYTE32_35 0x6130
#define A_DBG_PVT_REG_OUT_TERMN 0x6134

#define S_REG_OUT_TERMN_B    4
#define M_REG_OUT_TERMN_B    0xfU
#define V_REG_OUT_TERMN_B(x) ((x) << S_REG_OUT_TERMN_B)
#define G_REG_OUT_TERMN_B(x) (((x) >> S_REG_OUT_TERMN_B) & M_REG_OUT_TERMN_B)

#define S_REG_OUT_TERMN_A    0
#define M_REG_OUT_TERMN_A    0xfU
#define V_REG_OUT_TERMN_A(x) ((x) << S_REG_OUT_TERMN_A)
#define G_REG_OUT_TERMN_A(x) (((x) >> S_REG_OUT_TERMN_A) & M_REG_OUT_TERMN_A)

#define A_DBG_EFUSE_BYTE36_39 0x6134
#define A_DBG_PVT_REG_OUT_DRVP 0x6138

#define S_REG_OUT_DRVP_B    4
#define M_REG_OUT_DRVP_B    0xfU
#define V_REG_OUT_DRVP_B(x) ((x) << S_REG_OUT_DRVP_B)
#define G_REG_OUT_DRVP_B(x) (((x) >> S_REG_OUT_DRVP_B) & M_REG_OUT_DRVP_B)

#define S_REG_OUT_DRVP_A    0
#define M_REG_OUT_DRVP_A    0xfU
#define V_REG_OUT_DRVP_A(x) ((x) << S_REG_OUT_DRVP_A)
#define G_REG_OUT_DRVP_A(x) (((x) >> S_REG_OUT_DRVP_A) & M_REG_OUT_DRVP_A)

#define A_DBG_EFUSE_BYTE40_43 0x6138
#define A_DBG_PVT_REG_OUT_DRVN 0x613c

#define S_REG_OUT_DRVN_B    4
#define M_REG_OUT_DRVN_B    0xfU
#define V_REG_OUT_DRVN_B(x) ((x) << S_REG_OUT_DRVN_B)
#define G_REG_OUT_DRVN_B(x) (((x) >> S_REG_OUT_DRVN_B) & M_REG_OUT_DRVN_B)

#define S_REG_OUT_DRVN_A    0
#define M_REG_OUT_DRVN_A    0xfU
#define V_REG_OUT_DRVN_A(x) ((x) << S_REG_OUT_DRVN_A)
#define G_REG_OUT_DRVN_A(x) (((x) >> S_REG_OUT_DRVN_A) & M_REG_OUT_DRVN_A)

#define A_DBG_EFUSE_BYTE44_47 0x613c
#define A_DBG_PVT_REG_HISTORY_TERMP 0x6140

#define S_TERMP_B_HISTORY    4
#define M_TERMP_B_HISTORY    0xfU
#define V_TERMP_B_HISTORY(x) ((x) << S_TERMP_B_HISTORY)
#define G_TERMP_B_HISTORY(x) (((x) >> S_TERMP_B_HISTORY) & M_TERMP_B_HISTORY)

#define S_TERMP_A_HISTORY    0
#define M_TERMP_A_HISTORY    0xfU
#define V_TERMP_A_HISTORY(x) ((x) << S_TERMP_A_HISTORY)
#define G_TERMP_A_HISTORY(x) (((x) >> S_TERMP_A_HISTORY) & M_TERMP_A_HISTORY)

#define A_DBG_EFUSE_BYTE48_51 0x6140
#define A_DBG_PVT_REG_HISTORY_TERMN 0x6144

#define S_TERMN_B_HISTORY    4
#define M_TERMN_B_HISTORY    0xfU
#define V_TERMN_B_HISTORY(x) ((x) << S_TERMN_B_HISTORY)
#define G_TERMN_B_HISTORY(x) (((x) >> S_TERMN_B_HISTORY) & M_TERMN_B_HISTORY)

#define S_TERMN_A_HISTORY    0
#define M_TERMN_A_HISTORY    0xfU
#define V_TERMN_A_HISTORY(x) ((x) << S_TERMN_A_HISTORY)
#define G_TERMN_A_HISTORY(x) (((x) >> S_TERMN_A_HISTORY) & M_TERMN_A_HISTORY)

#define A_DBG_EFUSE_BYTE52_55 0x6144
#define A_DBG_PVT_REG_HISTORY_DRVP 0x6148

#define S_DRVP_B_HISTORY    4
#define M_DRVP_B_HISTORY    0xfU
#define V_DRVP_B_HISTORY(x) ((x) << S_DRVP_B_HISTORY)
#define G_DRVP_B_HISTORY(x) (((x) >> S_DRVP_B_HISTORY) & M_DRVP_B_HISTORY)

#define S_DRVP_A_HISTORY    0
#define M_DRVP_A_HISTORY    0xfU
#define V_DRVP_A_HISTORY(x) ((x) << S_DRVP_A_HISTORY)
#define G_DRVP_A_HISTORY(x) (((x) >> S_DRVP_A_HISTORY) & M_DRVP_A_HISTORY)

#define A_DBG_EFUSE_BYTE56_59 0x6148
#define A_DBG_PVT_REG_HISTORY_DRVN 0x614c

#define S_DRVN_B_HISTORY    4
#define M_DRVN_B_HISTORY    0xfU
#define V_DRVN_B_HISTORY(x) ((x) << S_DRVN_B_HISTORY)
#define G_DRVN_B_HISTORY(x) (((x) >> S_DRVN_B_HISTORY) & M_DRVN_B_HISTORY)

#define S_DRVN_A_HISTORY    0
#define M_DRVN_A_HISTORY    0xfU
#define V_DRVN_A_HISTORY(x) ((x) << S_DRVN_A_HISTORY)
#define G_DRVN_A_HISTORY(x) (((x) >> S_DRVN_A_HISTORY) & M_DRVN_A_HISTORY)

#define A_DBG_EFUSE_BYTE60_63 0x614c
#define A_DBG_PVT_REG_SAMPLE_WAIT_CLKS 0x6150

#define S_SAMPLE_WAIT_CLKS    0
#define M_SAMPLE_WAIT_CLKS    0x1fU
#define V_SAMPLE_WAIT_CLKS(x) ((x) << S_SAMPLE_WAIT_CLKS)
#define G_SAMPLE_WAIT_CLKS(x) (((x) >> S_SAMPLE_WAIT_CLKS) & M_SAMPLE_WAIT_CLKS)

/* registers for module MC */
#define MC_BASE_ADDR 0x6200

#define A_MC_PCTL_SCFG 0x6200

#define S_RKINF_EN    5
#define V_RKINF_EN(x) ((x) << S_RKINF_EN)
#define F_RKINF_EN    V_RKINF_EN(1U)

#define S_DUAL_PCTL_EN    4
#define V_DUAL_PCTL_EN(x) ((x) << S_DUAL_PCTL_EN)
#define F_DUAL_PCTL_EN    V_DUAL_PCTL_EN(1U)

#define S_SLAVE_MODE    3
#define V_SLAVE_MODE(x) ((x) << S_SLAVE_MODE)
#define F_SLAVE_MODE    V_SLAVE_MODE(1U)

#define S_LOOPBACK_EN    1
#define V_LOOPBACK_EN(x) ((x) << S_LOOPBACK_EN)
#define F_LOOPBACK_EN    V_LOOPBACK_EN(1U)

#define S_HW_LOW_POWER_EN    0
#define V_HW_LOW_POWER_EN(x) ((x) << S_HW_LOW_POWER_EN)
#define F_HW_LOW_POWER_EN    V_HW_LOW_POWER_EN(1U)

#define A_MC_PCTL_SCTL 0x6204

#define S_STATE_CMD    0
#define M_STATE_CMD    0x7U
#define V_STATE_CMD(x) ((x) << S_STATE_CMD)
#define G_STATE_CMD(x) (((x) >> S_STATE_CMD) & M_STATE_CMD)

#define A_MC_PCTL_STAT 0x6208

#define S_CTL_STAT    0
#define M_CTL_STAT    0x7U
#define V_CTL_STAT(x) ((x) << S_CTL_STAT)
#define G_CTL_STAT(x) (((x) >> S_CTL_STAT) & M_CTL_STAT)

#define A_MC_PCTL_MCMD 0x6240

#define S_START_CMD    31
#define V_START_CMD(x) ((x) << S_START_CMD)
#define F_START_CMD    V_START_CMD(1U)

#define S_CMD_ADD_DEL    24
#define M_CMD_ADD_DEL    0xfU
#define V_CMD_ADD_DEL(x) ((x) << S_CMD_ADD_DEL)
#define G_CMD_ADD_DEL(x) (((x) >> S_CMD_ADD_DEL) & M_CMD_ADD_DEL)

#define S_RANK_SEL    20
#define M_RANK_SEL    0xfU
#define V_RANK_SEL(x) ((x) << S_RANK_SEL)
#define G_RANK_SEL(x) (((x) >> S_RANK_SEL) & M_RANK_SEL)

#define S_BANK_ADDR    17
#define M_BANK_ADDR    0x7U
#define V_BANK_ADDR(x) ((x) << S_BANK_ADDR)
#define G_BANK_ADDR(x) (((x) >> S_BANK_ADDR) & M_BANK_ADDR)

#define S_CMD_ADDR    4
#define M_CMD_ADDR    0x1fffU
#define V_CMD_ADDR(x) ((x) << S_CMD_ADDR)
#define G_CMD_ADDR(x) (((x) >> S_CMD_ADDR) & M_CMD_ADDR)

#define S_CMD_OPCODE    0
#define M_CMD_OPCODE    0x7U
#define V_CMD_OPCODE(x) ((x) << S_CMD_OPCODE)
#define G_CMD_OPCODE(x) (((x) >> S_CMD_OPCODE) & M_CMD_OPCODE)

#define A_MC_PCTL_POWCTL 0x6244

#define S_POWER_UP_START    0
#define V_POWER_UP_START(x) ((x) << S_POWER_UP_START)
#define F_POWER_UP_START    V_POWER_UP_START(1U)

#define A_MC_PCTL_POWSTAT 0x6248

#define S_PHY_CALIBDONE    1
#define V_PHY_CALIBDONE(x) ((x) << S_PHY_CALIBDONE)
#define F_PHY_CALIBDONE    V_PHY_CALIBDONE(1U)

#define S_POWER_UP_DONE    0
#define V_POWER_UP_DONE(x) ((x) << S_POWER_UP_DONE)
#define F_POWER_UP_DONE    V_POWER_UP_DONE(1U)

#define A_MC_PCTL_MCFG 0x6280

#define S_TFAW_CFG    18
#define M_TFAW_CFG    0x3U
#define V_TFAW_CFG(x) ((x) << S_TFAW_CFG)
#define G_TFAW_CFG(x) (((x) >> S_TFAW_CFG) & M_TFAW_CFG)

#define S_PD_EXIT_MODE    17
#define V_PD_EXIT_MODE(x) ((x) << S_PD_EXIT_MODE)
#define F_PD_EXIT_MODE    V_PD_EXIT_MODE(1U)

#define S_PD_TYPE    16
#define V_PD_TYPE(x) ((x) << S_PD_TYPE)
#define F_PD_TYPE    V_PD_TYPE(1U)

#define S_PD_IDLE    8
#define M_PD_IDLE    0xffU
#define V_PD_IDLE(x) ((x) << S_PD_IDLE)
#define G_PD_IDLE(x) (((x) >> S_PD_IDLE) & M_PD_IDLE)

#define S_PAGE_POLICY    6
#define M_PAGE_POLICY    0x3U
#define V_PAGE_POLICY(x) ((x) << S_PAGE_POLICY)
#define G_PAGE_POLICY(x) (((x) >> S_PAGE_POLICY) & M_PAGE_POLICY)

#define S_DDR3_EN    5
#define V_DDR3_EN(x) ((x) << S_DDR3_EN)
#define F_DDR3_EN    V_DDR3_EN(1U)

#define S_TWO_T_EN    3
#define V_TWO_T_EN(x) ((x) << S_TWO_T_EN)
#define F_TWO_T_EN    V_TWO_T_EN(1U)

#define S_BL8INT_EN    2
#define V_BL8INT_EN(x) ((x) << S_BL8INT_EN)
#define F_BL8INT_EN    V_BL8INT_EN(1U)

#define S_MEM_BL    0
#define V_MEM_BL(x) ((x) << S_MEM_BL)
#define F_MEM_BL    V_MEM_BL(1U)

#define A_MC_PCTL_PPCFG 0x6284

#define S_RPMEM_DIS    1
#define M_RPMEM_DIS    0xffU
#define V_RPMEM_DIS(x) ((x) << S_RPMEM_DIS)
#define G_RPMEM_DIS(x) (((x) >> S_RPMEM_DIS) & M_RPMEM_DIS)

#define S_PPMEM_EN    0
#define V_PPMEM_EN(x) ((x) << S_PPMEM_EN)
#define F_PPMEM_EN    V_PPMEM_EN(1U)

#define A_MC_PCTL_MSTAT 0x6288

#define S_POWER_DOWN    0
#define V_POWER_DOWN(x) ((x) << S_POWER_DOWN)
#define F_POWER_DOWN    V_POWER_DOWN(1U)

#define A_MC_PCTL_ODTCFG 0x628c

#define S_RANK3_ODT_DEFAULT    28
#define V_RANK3_ODT_DEFAULT(x) ((x) << S_RANK3_ODT_DEFAULT)
#define F_RANK3_ODT_DEFAULT    V_RANK3_ODT_DEFAULT(1U)

#define S_RANK3_ODT_WRITE_SEL    27
#define V_RANK3_ODT_WRITE_SEL(x) ((x) << S_RANK3_ODT_WRITE_SEL)
#define F_RANK3_ODT_WRITE_SEL    V_RANK3_ODT_WRITE_SEL(1U)

#define S_RANK3_ODT_WRITE_NSE    26
#define V_RANK3_ODT_WRITE_NSE(x) ((x) << S_RANK3_ODT_WRITE_NSE)
#define F_RANK3_ODT_WRITE_NSE    V_RANK3_ODT_WRITE_NSE(1U)

#define S_RANK3_ODT_READ_SEL    25
#define V_RANK3_ODT_READ_SEL(x) ((x) << S_RANK3_ODT_READ_SEL)
#define F_RANK3_ODT_READ_SEL    V_RANK3_ODT_READ_SEL(1U)

#define S_RANK3_ODT_READ_NSEL    24
#define V_RANK3_ODT_READ_NSEL(x) ((x) << S_RANK3_ODT_READ_NSEL)
#define F_RANK3_ODT_READ_NSEL    V_RANK3_ODT_READ_NSEL(1U)

#define S_RANK2_ODT_DEFAULT    20
#define V_RANK2_ODT_DEFAULT(x) ((x) << S_RANK2_ODT_DEFAULT)
#define F_RANK2_ODT_DEFAULT    V_RANK2_ODT_DEFAULT(1U)

#define S_RANK2_ODT_WRITE_SEL    19
#define V_RANK2_ODT_WRITE_SEL(x) ((x) << S_RANK2_ODT_WRITE_SEL)
#define F_RANK2_ODT_WRITE_SEL    V_RANK2_ODT_WRITE_SEL(1U)

#define S_RANK2_ODT_WRITE_NSEL    18
#define V_RANK2_ODT_WRITE_NSEL(x) ((x) << S_RANK2_ODT_WRITE_NSEL)
#define F_RANK2_ODT_WRITE_NSEL    V_RANK2_ODT_WRITE_NSEL(1U)

#define S_RANK2_ODT_READ_SEL    17
#define V_RANK2_ODT_READ_SEL(x) ((x) << S_RANK2_ODT_READ_SEL)
#define F_RANK2_ODT_READ_SEL    V_RANK2_ODT_READ_SEL(1U)

#define S_RANK2_ODT_READ_NSEL    16
#define V_RANK2_ODT_READ_NSEL(x) ((x) << S_RANK2_ODT_READ_NSEL)
#define F_RANK2_ODT_READ_NSEL    V_RANK2_ODT_READ_NSEL(1U)

#define S_RANK1_ODT_DEFAULT    12
#define V_RANK1_ODT_DEFAULT(x) ((x) << S_RANK1_ODT_DEFAULT)
#define F_RANK1_ODT_DEFAULT    V_RANK1_ODT_DEFAULT(1U)

#define S_RANK1_ODT_WRITE_SEL    11
#define V_RANK1_ODT_WRITE_SEL(x) ((x) << S_RANK1_ODT_WRITE_SEL)
#define F_RANK1_ODT_WRITE_SEL    V_RANK1_ODT_WRITE_SEL(1U)

#define S_RANK1_ODT_WRITE_NSEL    10
#define V_RANK1_ODT_WRITE_NSEL(x) ((x) << S_RANK1_ODT_WRITE_NSEL)
#define F_RANK1_ODT_WRITE_NSEL    V_RANK1_ODT_WRITE_NSEL(1U)

#define S_RANK1_ODT_READ_SEL    9
#define V_RANK1_ODT_READ_SEL(x) ((x) << S_RANK1_ODT_READ_SEL)
#define F_RANK1_ODT_READ_SEL    V_RANK1_ODT_READ_SEL(1U)

#define S_RANK1_ODT_READ_NSEL    8
#define V_RANK1_ODT_READ_NSEL(x) ((x) << S_RANK1_ODT_READ_NSEL)
#define F_RANK1_ODT_READ_NSEL    V_RANK1_ODT_READ_NSEL(1U)

#define S_RANK0_ODT_DEFAULT    4
#define V_RANK0_ODT_DEFAULT(x) ((x) << S_RANK0_ODT_DEFAULT)
#define F_RANK0_ODT_DEFAULT    V_RANK0_ODT_DEFAULT(1U)

#define S_RANK0_ODT_WRITE_SEL    3
#define V_RANK0_ODT_WRITE_SEL(x) ((x) << S_RANK0_ODT_WRITE_SEL)
#define F_RANK0_ODT_WRITE_SEL    V_RANK0_ODT_WRITE_SEL(1U)

#define S_RANK0_ODT_WRITE_NSEL    2
#define V_RANK0_ODT_WRITE_NSEL(x) ((x) << S_RANK0_ODT_WRITE_NSEL)
#define F_RANK0_ODT_WRITE_NSEL    V_RANK0_ODT_WRITE_NSEL(1U)

#define S_RANK0_ODT_READ_SEL    1
#define V_RANK0_ODT_READ_SEL(x) ((x) << S_RANK0_ODT_READ_SEL)
#define F_RANK0_ODT_READ_SEL    V_RANK0_ODT_READ_SEL(1U)

#define S_RANK0_ODT_READ_NSEL    0
#define V_RANK0_ODT_READ_NSEL(x) ((x) << S_RANK0_ODT_READ_NSEL)
#define F_RANK0_ODT_READ_NSEL    V_RANK0_ODT_READ_NSEL(1U)

#define A_MC_PCTL_DQSECFG 0x6290

#define S_DV_ALAT    20
#define M_DV_ALAT    0xfU
#define V_DV_ALAT(x) ((x) << S_DV_ALAT)
#define G_DV_ALAT(x) (((x) >> S_DV_ALAT) & M_DV_ALAT)

#define S_DV_ALEN    16
#define M_DV_ALEN    0x3U
#define V_DV_ALEN(x) ((x) << S_DV_ALEN)
#define G_DV_ALEN(x) (((x) >> S_DV_ALEN) & M_DV_ALEN)

#define S_DSE_ALAT    12
#define M_DSE_ALAT    0xfU
#define V_DSE_ALAT(x) ((x) << S_DSE_ALAT)
#define G_DSE_ALAT(x) (((x) >> S_DSE_ALAT) & M_DSE_ALAT)

#define S_DSE_ALEN    8
#define M_DSE_ALEN    0x3U
#define V_DSE_ALEN(x) ((x) << S_DSE_ALEN)
#define G_DSE_ALEN(x) (((x) >> S_DSE_ALEN) & M_DSE_ALEN)

#define S_QSE_ALAT    4
#define M_QSE_ALAT    0xfU
#define V_QSE_ALAT(x) ((x) << S_QSE_ALAT)
#define G_QSE_ALAT(x) (((x) >> S_QSE_ALAT) & M_QSE_ALAT)

#define S_QSE_ALEN    0
#define M_QSE_ALEN    0x3U
#define V_QSE_ALEN(x) ((x) << S_QSE_ALEN)
#define G_QSE_ALEN(x) (((x) >> S_QSE_ALEN) & M_QSE_ALEN)

#define A_MC_PCTL_DTUPDES 0x6294

#define S_DTU_RD_MISSING    13
#define V_DTU_RD_MISSING(x) ((x) << S_DTU_RD_MISSING)
#define F_DTU_RD_MISSING    V_DTU_RD_MISSING(1U)

#define S_DTU_EAFFL    9
#define M_DTU_EAFFL    0xfU
#define V_DTU_EAFFL(x) ((x) << S_DTU_EAFFL)
#define G_DTU_EAFFL(x) (((x) >> S_DTU_EAFFL) & M_DTU_EAFFL)

#define S_DTU_RANDOM_ERROR    8
#define V_DTU_RANDOM_ERROR(x) ((x) << S_DTU_RANDOM_ERROR)
#define F_DTU_RANDOM_ERROR    V_DTU_RANDOM_ERROR(1U)

#define S_DTU_ERROR_B7    7
#define V_DTU_ERROR_B7(x) ((x) << S_DTU_ERROR_B7)
#define F_DTU_ERROR_B7    V_DTU_ERROR_B7(1U)

#define S_DTU_ERR_B6    6
#define V_DTU_ERR_B6(x) ((x) << S_DTU_ERR_B6)
#define F_DTU_ERR_B6    V_DTU_ERR_B6(1U)

#define S_DTU_ERR_B5    5
#define V_DTU_ERR_B5(x) ((x) << S_DTU_ERR_B5)
#define F_DTU_ERR_B5    V_DTU_ERR_B5(1U)

#define S_DTU_ERR_B4    4
#define V_DTU_ERR_B4(x) ((x) << S_DTU_ERR_B4)
#define F_DTU_ERR_B4    V_DTU_ERR_B4(1U)

#define S_DTU_ERR_B3    3
#define V_DTU_ERR_B3(x) ((x) << S_DTU_ERR_B3)
#define F_DTU_ERR_B3    V_DTU_ERR_B3(1U)

#define S_DTU_ERR_B2    2
#define V_DTU_ERR_B2(x) ((x) << S_DTU_ERR_B2)
#define F_DTU_ERR_B2    V_DTU_ERR_B2(1U)

#define S_DTU_ERR_B1    1
#define V_DTU_ERR_B1(x) ((x) << S_DTU_ERR_B1)
#define F_DTU_ERR_B1    V_DTU_ERR_B1(1U)

#define S_DTU_ERR_B0    0
#define V_DTU_ERR_B0(x) ((x) << S_DTU_ERR_B0)
#define F_DTU_ERR_B0    V_DTU_ERR_B0(1U)

#define A_MC_PCTL_DTUNA 0x6298
#define A_MC_PCTL_DTUNE 0x629c
#define A_MC_PCTL_DTUPRDO 0x62a0

#define S_DTU_ALLBITS_1    16
#define M_DTU_ALLBITS_1    0xffffU
#define V_DTU_ALLBITS_1(x) ((x) << S_DTU_ALLBITS_1)
#define G_DTU_ALLBITS_1(x) (((x) >> S_DTU_ALLBITS_1) & M_DTU_ALLBITS_1)

#define S_DTU_ALLBITS_0    0
#define M_DTU_ALLBITS_0    0xffffU
#define V_DTU_ALLBITS_0(x) ((x) << S_DTU_ALLBITS_0)
#define G_DTU_ALLBITS_0(x) (((x) >> S_DTU_ALLBITS_0) & M_DTU_ALLBITS_0)

#define A_MC_PCTL_DTUPRD1 0x62a4

#define S_DTU_ALLBITS_3    16
#define M_DTU_ALLBITS_3    0xffffU
#define V_DTU_ALLBITS_3(x) ((x) << S_DTU_ALLBITS_3)
#define G_DTU_ALLBITS_3(x) (((x) >> S_DTU_ALLBITS_3) & M_DTU_ALLBITS_3)

#define S_DTU_ALLBITS_2    0
#define M_DTU_ALLBITS_2    0xffffU
#define V_DTU_ALLBITS_2(x) ((x) << S_DTU_ALLBITS_2)
#define G_DTU_ALLBITS_2(x) (((x) >> S_DTU_ALLBITS_2) & M_DTU_ALLBITS_2)

#define A_MC_PCTL_DTUPRD2 0x62a8

#define S_DTU_ALLBITS_5    16
#define M_DTU_ALLBITS_5    0xffffU
#define V_DTU_ALLBITS_5(x) ((x) << S_DTU_ALLBITS_5)
#define G_DTU_ALLBITS_5(x) (((x) >> S_DTU_ALLBITS_5) & M_DTU_ALLBITS_5)

#define S_DTU_ALLBITS_4    0
#define M_DTU_ALLBITS_4    0xffffU
#define V_DTU_ALLBITS_4(x) ((x) << S_DTU_ALLBITS_4)
#define G_DTU_ALLBITS_4(x) (((x) >> S_DTU_ALLBITS_4) & M_DTU_ALLBITS_4)

#define A_MC_PCTL_DTUPRD3 0x62ac

#define S_DTU_ALLBITS_7    16
#define M_DTU_ALLBITS_7    0xffffU
#define V_DTU_ALLBITS_7(x) ((x) << S_DTU_ALLBITS_7)
#define G_DTU_ALLBITS_7(x) (((x) >> S_DTU_ALLBITS_7) & M_DTU_ALLBITS_7)

#define S_DTU_ALLBITS_6    0
#define M_DTU_ALLBITS_6    0xffffU
#define V_DTU_ALLBITS_6(x) ((x) << S_DTU_ALLBITS_6)
#define G_DTU_ALLBITS_6(x) (((x) >> S_DTU_ALLBITS_6) & M_DTU_ALLBITS_6)

#define A_MC_PCTL_DTUAWDT 0x62b0

#define S_NUMBER_RANKS    9
#define M_NUMBER_RANKS    0x3U
#define V_NUMBER_RANKS(x) ((x) << S_NUMBER_RANKS)
#define G_NUMBER_RANKS(x) (((x) >> S_NUMBER_RANKS) & M_NUMBER_RANKS)

#define S_ROW_ADDR_WIDTH    6
#define M_ROW_ADDR_WIDTH    0x3U
#define V_ROW_ADDR_WIDTH(x) ((x) << S_ROW_ADDR_WIDTH)
#define G_ROW_ADDR_WIDTH(x) (((x) >> S_ROW_ADDR_WIDTH) & M_ROW_ADDR_WIDTH)

#define S_BANK_ADDR_WIDTH    3
#define M_BANK_ADDR_WIDTH    0x3U
#define V_BANK_ADDR_WIDTH(x) ((x) << S_BANK_ADDR_WIDTH)
#define G_BANK_ADDR_WIDTH(x) (((x) >> S_BANK_ADDR_WIDTH) & M_BANK_ADDR_WIDTH)

#define S_COLUMN_ADDR_WIDTH    0
#define M_COLUMN_ADDR_WIDTH    0x3U
#define V_COLUMN_ADDR_WIDTH(x) ((x) << S_COLUMN_ADDR_WIDTH)
#define G_COLUMN_ADDR_WIDTH(x) (((x) >> S_COLUMN_ADDR_WIDTH) & M_COLUMN_ADDR_WIDTH)

#define A_MC_PCTL_TOGCNT1U 0x62c0

#define S_TOGGLE_COUNTER_1U    0
#define M_TOGGLE_COUNTER_1U    0x3ffU
#define V_TOGGLE_COUNTER_1U(x) ((x) << S_TOGGLE_COUNTER_1U)
#define G_TOGGLE_COUNTER_1U(x) (((x) >> S_TOGGLE_COUNTER_1U) & M_TOGGLE_COUNTER_1U)

#define A_MC_PCTL_TINIT 0x62c4

#define S_T_INIT    0
#define M_T_INIT    0x1ffU
#define V_T_INIT(x) ((x) << S_T_INIT)
#define G_T_INIT(x) (((x) >> S_T_INIT) & M_T_INIT)

#define A_MC_PCTL_TRSTH 0x62c8

#define S_T_RSTH    0
#define M_T_RSTH    0x3ffU
#define V_T_RSTH(x) ((x) << S_T_RSTH)
#define G_T_RSTH(x) (((x) >> S_T_RSTH) & M_T_RSTH)

#define A_MC_PCTL_TOGCNT100N 0x62cc

#define S_TOGGLE_COUNTER_100N    0
#define M_TOGGLE_COUNTER_100N    0x7fU
#define V_TOGGLE_COUNTER_100N(x) ((x) << S_TOGGLE_COUNTER_100N)
#define G_TOGGLE_COUNTER_100N(x) (((x) >> S_TOGGLE_COUNTER_100N) & M_TOGGLE_COUNTER_100N)

#define A_MC_PCTL_TREFI 0x62d0

#define S_T_REFI    0
#define M_T_REFI    0xffU
#define V_T_REFI(x) ((x) << S_T_REFI)
#define G_T_REFI(x) (((x) >> S_T_REFI) & M_T_REFI)

#define A_MC_PCTL_TMRD 0x62d4

#define S_T_MRD    0
#define M_T_MRD    0x7U
#define V_T_MRD(x) ((x) << S_T_MRD)
#define G_T_MRD(x) (((x) >> S_T_MRD) & M_T_MRD)

#define A_MC_PCTL_TRFC 0x62d8

#define S_T_RFC    0
#define M_T_RFC    0xffU
#define V_T_RFC(x) ((x) << S_T_RFC)
#define G_T_RFC(x) (((x) >> S_T_RFC) & M_T_RFC)

#define A_MC_PCTL_TRP 0x62dc

#define S_T_RP    0
#define M_T_RP    0xfU
#define V_T_RP(x) ((x) << S_T_RP)
#define G_T_RP(x) (((x) >> S_T_RP) & M_T_RP)

#define A_MC_PCTL_TRTW 0x62e0

#define S_T_RTW    0
#define M_T_RTW    0x7U
#define V_T_RTW(x) ((x) << S_T_RTW)
#define G_T_RTW(x) (((x) >> S_T_RTW) & M_T_RTW)

#define A_MC_PCTL_TAL 0x62e4

#define S_T_AL    0
#define M_T_AL    0xfU
#define V_T_AL(x) ((x) << S_T_AL)
#define G_T_AL(x) (((x) >> S_T_AL) & M_T_AL)

#define A_MC_PCTL_TCL 0x62e8

#define S_T_CL    0
#define M_T_CL    0xfU
#define V_T_CL(x) ((x) << S_T_CL)
#define G_T_CL(x) (((x) >> S_T_CL) & M_T_CL)

#define A_MC_PCTL_TCWL 0x62ec

#define S_T_CWL    0
#define M_T_CWL    0xfU
#define V_T_CWL(x) ((x) << S_T_CWL)
#define G_T_CWL(x) (((x) >> S_T_CWL) & M_T_CWL)

#define A_MC_PCTL_TRAS 0x62f0

#define S_T_RAS    0
#define M_T_RAS    0x3fU
#define V_T_RAS(x) ((x) << S_T_RAS)
#define G_T_RAS(x) (((x) >> S_T_RAS) & M_T_RAS)

#define A_MC_PCTL_TRC 0x62f4

#define S_T_RC    0
#define M_T_RC    0x3fU
#define V_T_RC(x) ((x) << S_T_RC)
#define G_T_RC(x) (((x) >> S_T_RC) & M_T_RC)

#define A_MC_PCTL_TRCD 0x62f8

#define S_T_RCD    0
#define M_T_RCD    0xfU
#define V_T_RCD(x) ((x) << S_T_RCD)
#define G_T_RCD(x) (((x) >> S_T_RCD) & M_T_RCD)

#define A_MC_PCTL_TRRD 0x62fc

#define S_T_RRD    0
#define M_T_RRD    0xfU
#define V_T_RRD(x) ((x) << S_T_RRD)
#define G_T_RRD(x) (((x) >> S_T_RRD) & M_T_RRD)

#define A_MC_PCTL_TRTP 0x6300

#define S_T_RTP    0
#define M_T_RTP    0x7U
#define V_T_RTP(x) ((x) << S_T_RTP)
#define G_T_RTP(x) (((x) >> S_T_RTP) & M_T_RTP)

#define A_MC_PCTL_TWR 0x6304

#define S_T_WR    0
#define M_T_WR    0x7U
#define V_T_WR(x) ((x) << S_T_WR)
#define G_T_WR(x) (((x) >> S_T_WR) & M_T_WR)

#define A_MC_PCTL_TWTR 0x6308

#define S_T_WTR    0
#define M_T_WTR    0x7U
#define V_T_WTR(x) ((x) << S_T_WTR)
#define G_T_WTR(x) (((x) >> S_T_WTR) & M_T_WTR)

#define A_MC_PCTL_TEXSR 0x630c

#define S_T_EXSR    0
#define M_T_EXSR    0x3ffU
#define V_T_EXSR(x) ((x) << S_T_EXSR)
#define G_T_EXSR(x) (((x) >> S_T_EXSR) & M_T_EXSR)

#define A_MC_PCTL_TXP 0x6310

#define S_T_XP    0
#define M_T_XP    0x7U
#define V_T_XP(x) ((x) << S_T_XP)
#define G_T_XP(x) (((x) >> S_T_XP) & M_T_XP)

#define A_MC_PCTL_TXPDLL 0x6314

#define S_T_XPDLL    0
#define M_T_XPDLL    0x3fU
#define V_T_XPDLL(x) ((x) << S_T_XPDLL)
#define G_T_XPDLL(x) (((x) >> S_T_XPDLL) & M_T_XPDLL)

#define A_MC_PCTL_TZQCS 0x6318

#define S_T_ZQCS    0
#define M_T_ZQCS    0x7fU
#define V_T_ZQCS(x) ((x) << S_T_ZQCS)
#define G_T_ZQCS(x) (((x) >> S_T_ZQCS) & M_T_ZQCS)

#define A_MC_PCTL_TZQCSI 0x631c

#define S_T_ZQCSI    0
#define M_T_ZQCSI    0xfffU
#define V_T_ZQCSI(x) ((x) << S_T_ZQCSI)
#define G_T_ZQCSI(x) (((x) >> S_T_ZQCSI) & M_T_ZQCSI)

#define A_MC_PCTL_TDQS 0x6320

#define S_T_DQS    0
#define M_T_DQS    0x7U
#define V_T_DQS(x) ((x) << S_T_DQS)
#define G_T_DQS(x) (((x) >> S_T_DQS) & M_T_DQS)

#define A_MC_PCTL_TCKSRE 0x6324

#define S_T_CKSRE    0
#define M_T_CKSRE    0xfU
#define V_T_CKSRE(x) ((x) << S_T_CKSRE)
#define G_T_CKSRE(x) (((x) >> S_T_CKSRE) & M_T_CKSRE)

#define A_MC_PCTL_TCKSRX 0x6328

#define S_T_CKSRX    0
#define M_T_CKSRX    0xfU
#define V_T_CKSRX(x) ((x) << S_T_CKSRX)
#define G_T_CKSRX(x) (((x) >> S_T_CKSRX) & M_T_CKSRX)

#define A_MC_PCTL_TCKE 0x632c

#define S_T_CKE    0
#define M_T_CKE    0x7U
#define V_T_CKE(x) ((x) << S_T_CKE)
#define G_T_CKE(x) (((x) >> S_T_CKE) & M_T_CKE)

#define A_MC_PCTL_TMOD 0x6330

#define S_T_MOD    0
#define M_T_MOD    0xfU
#define V_T_MOD(x) ((x) << S_T_MOD)
#define G_T_MOD(x) (((x) >> S_T_MOD) & M_T_MOD)

#define A_MC_PCTL_TRSTL 0x6334

#define S_RSTHOLD    0
#define M_RSTHOLD    0x7fU
#define V_RSTHOLD(x) ((x) << S_RSTHOLD)
#define G_RSTHOLD(x) (((x) >> S_RSTHOLD) & M_RSTHOLD)

#define A_MC_PCTL_TZQCL 0x6338

#define S_T_ZQCL    0
#define M_T_ZQCL    0x3ffU
#define V_T_ZQCL(x) ((x) << S_T_ZQCL)
#define G_T_ZQCL(x) (((x) >> S_T_ZQCL) & M_T_ZQCL)

#define A_MC_PCTL_DWLCFG0 0x6370

#define S_T_ADWL_VEC    0
#define M_T_ADWL_VEC    0x1ffU
#define V_T_ADWL_VEC(x) ((x) << S_T_ADWL_VEC)
#define G_T_ADWL_VEC(x) (((x) >> S_T_ADWL_VEC) & M_T_ADWL_VEC)

#define A_MC_PCTL_DWLCFG1 0x6374
#define A_MC_PCTL_DWLCFG2 0x6378
#define A_MC_PCTL_DWLCFG3 0x637c
#define A_MC_PCTL_ECCCFG 0x6380

#define S_INLINE_SYN_EN    4
#define V_INLINE_SYN_EN(x) ((x) << S_INLINE_SYN_EN)
#define F_INLINE_SYN_EN    V_INLINE_SYN_EN(1U)

#define S_ECC_EN    3
#define V_ECC_EN(x) ((x) << S_ECC_EN)
#define F_ECC_EN    V_ECC_EN(1U)

#define S_ECC_INTR_EN    2
#define V_ECC_INTR_EN(x) ((x) << S_ECC_INTR_EN)
#define F_ECC_INTR_EN    V_ECC_INTR_EN(1U)

#define A_MC_PCTL_ECCTST 0x6384

#define S_ECC_TEST_MASK    0
#define M_ECC_TEST_MASK    0xffU
#define V_ECC_TEST_MASK(x) ((x) << S_ECC_TEST_MASK)
#define G_ECC_TEST_MASK(x) (((x) >> S_ECC_TEST_MASK) & M_ECC_TEST_MASK)

#define A_MC_PCTL_ECCCLR 0x6388

#define S_CLR_ECC_LOG    1
#define V_CLR_ECC_LOG(x) ((x) << S_CLR_ECC_LOG)
#define F_CLR_ECC_LOG    V_CLR_ECC_LOG(1U)

#define S_CLR_ECC_INTR    0
#define V_CLR_ECC_INTR(x) ((x) << S_CLR_ECC_INTR)
#define F_CLR_ECC_INTR    V_CLR_ECC_INTR(1U)

#define A_MC_PCTL_ECCLOG 0x638c
#define A_MC_PCTL_DTUWACTL 0x6400

#define S_DTU_WR_RANK    30
#define M_DTU_WR_RANK    0x3U
#define V_DTU_WR_RANK(x) ((x) << S_DTU_WR_RANK)
#define G_DTU_WR_RANK(x) (((x) >> S_DTU_WR_RANK) & M_DTU_WR_RANK)

#define S_DTU_WR_ROW    13
#define M_DTU_WR_ROW    0x1ffffU
#define V_DTU_WR_ROW(x) ((x) << S_DTU_WR_ROW)
#define G_DTU_WR_ROW(x) (((x) >> S_DTU_WR_ROW) & M_DTU_WR_ROW)

#define S_DTU_WR_BANK    10
#define M_DTU_WR_BANK    0x7U
#define V_DTU_WR_BANK(x) ((x) << S_DTU_WR_BANK)
#define G_DTU_WR_BANK(x) (((x) >> S_DTU_WR_BANK) & M_DTU_WR_BANK)

#define S_DTU_WR_COL    0
#define M_DTU_WR_COL    0x3ffU
#define V_DTU_WR_COL(x) ((x) << S_DTU_WR_COL)
#define G_DTU_WR_COL(x) (((x) >> S_DTU_WR_COL) & M_DTU_WR_COL)

#define A_MC_PCTL_DTURACTL 0x6404

#define S_DTU_RD_RANK    30
#define M_DTU_RD_RANK    0x3U
#define V_DTU_RD_RANK(x) ((x) << S_DTU_RD_RANK)
#define G_DTU_RD_RANK(x) (((x) >> S_DTU_RD_RANK) & M_DTU_RD_RANK)

#define S_DTU_RD_ROW    13
#define M_DTU_RD_ROW    0x1ffffU
#define V_DTU_RD_ROW(x) ((x) << S_DTU_RD_ROW)
#define G_DTU_RD_ROW(x) (((x) >> S_DTU_RD_ROW) & M_DTU_RD_ROW)

#define S_DTU_RD_BANK    10
#define M_DTU_RD_BANK    0x7U
#define V_DTU_RD_BANK(x) ((x) << S_DTU_RD_BANK)
#define G_DTU_RD_BANK(x) (((x) >> S_DTU_RD_BANK) & M_DTU_RD_BANK)

#define S_DTU_RD_COL    0
#define M_DTU_RD_COL    0x3ffU
#define V_DTU_RD_COL(x) ((x) << S_DTU_RD_COL)
#define G_DTU_RD_COL(x) (((x) >> S_DTU_RD_COL) & M_DTU_RD_COL)

#define A_MC_PCTL_DTUCFG 0x6408

#define S_DTU_ROW_INCREMENTS    16
#define M_DTU_ROW_INCREMENTS    0x7fU
#define V_DTU_ROW_INCREMENTS(x) ((x) << S_DTU_ROW_INCREMENTS)
#define G_DTU_ROW_INCREMENTS(x) (((x) >> S_DTU_ROW_INCREMENTS) & M_DTU_ROW_INCREMENTS)

#define S_DTU_WR_MULTI_RD    15
#define V_DTU_WR_MULTI_RD(x) ((x) << S_DTU_WR_MULTI_RD)
#define F_DTU_WR_MULTI_RD    V_DTU_WR_MULTI_RD(1U)

#define S_DTU_DATA_MASK_EN    14
#define V_DTU_DATA_MASK_EN(x) ((x) << S_DTU_DATA_MASK_EN)
#define F_DTU_DATA_MASK_EN    V_DTU_DATA_MASK_EN(1U)

#define S_DTU_TARGET_LANE    10
#define M_DTU_TARGET_LANE    0xfU
#define V_DTU_TARGET_LANE(x) ((x) << S_DTU_TARGET_LANE)
#define G_DTU_TARGET_LANE(x) (((x) >> S_DTU_TARGET_LANE) & M_DTU_TARGET_LANE)

#define S_DTU_GENERATE_RANDOM    9
#define V_DTU_GENERATE_RANDOM(x) ((x) << S_DTU_GENERATE_RANDOM)
#define F_DTU_GENERATE_RANDOM    V_DTU_GENERATE_RANDOM(1U)

#define S_DTU_INCR_BANKS    8
#define V_DTU_INCR_BANKS(x) ((x) << S_DTU_INCR_BANKS)
#define F_DTU_INCR_BANKS    V_DTU_INCR_BANKS(1U)

#define S_DTU_INCR_COLS    7
#define V_DTU_INCR_COLS(x) ((x) << S_DTU_INCR_COLS)
#define F_DTU_INCR_COLS    V_DTU_INCR_COLS(1U)

#define S_DTU_NALEN    1
#define M_DTU_NALEN    0x3fU
#define V_DTU_NALEN(x) ((x) << S_DTU_NALEN)
#define G_DTU_NALEN(x) (((x) >> S_DTU_NALEN) & M_DTU_NALEN)

#define S_DTU_ENABLE    0
#define V_DTU_ENABLE(x) ((x) << S_DTU_ENABLE)
#define F_DTU_ENABLE    V_DTU_ENABLE(1U)

#define A_MC_PCTL_DTUECTL 0x640c

#define S_WR_MULTI_RD_RST    2
#define V_WR_MULTI_RD_RST(x) ((x) << S_WR_MULTI_RD_RST)
#define F_WR_MULTI_RD_RST    V_WR_MULTI_RD_RST(1U)

#define S_RUN_ERROR_REPORTS    1
#define V_RUN_ERROR_REPORTS(x) ((x) << S_RUN_ERROR_REPORTS)
#define F_RUN_ERROR_REPORTS    V_RUN_ERROR_REPORTS(1U)

#define S_RUN_DTU    0
#define V_RUN_DTU(x) ((x) << S_RUN_DTU)
#define F_RUN_DTU    V_RUN_DTU(1U)

#define A_MC_PCTL_DTUWD0 0x6410

#define S_DTU_WR_BYTE3    24
#define M_DTU_WR_BYTE3    0xffU
#define V_DTU_WR_BYTE3(x) ((x) << S_DTU_WR_BYTE3)
#define G_DTU_WR_BYTE3(x) (((x) >> S_DTU_WR_BYTE3) & M_DTU_WR_BYTE3)

#define S_DTU_WR_BYTE2    16
#define M_DTU_WR_BYTE2    0xffU
#define V_DTU_WR_BYTE2(x) ((x) << S_DTU_WR_BYTE2)
#define G_DTU_WR_BYTE2(x) (((x) >> S_DTU_WR_BYTE2) & M_DTU_WR_BYTE2)

#define S_DTU_WR_BYTE1    8
#define M_DTU_WR_BYTE1    0xffU
#define V_DTU_WR_BYTE1(x) ((x) << S_DTU_WR_BYTE1)
#define G_DTU_WR_BYTE1(x) (((x) >> S_DTU_WR_BYTE1) & M_DTU_WR_BYTE1)

#define S_DTU_WR_BYTE0    0
#define M_DTU_WR_BYTE0    0xffU
#define V_DTU_WR_BYTE0(x) ((x) << S_DTU_WR_BYTE0)
#define G_DTU_WR_BYTE0(x) (((x) >> S_DTU_WR_BYTE0) & M_DTU_WR_BYTE0)

#define A_MC_PCTL_DTUWD1 0x6414

#define S_DTU_WR_BYTE7    24
#define M_DTU_WR_BYTE7    0xffU
#define V_DTU_WR_BYTE7(x) ((x) << S_DTU_WR_BYTE7)
#define G_DTU_WR_BYTE7(x) (((x) >> S_DTU_WR_BYTE7) & M_DTU_WR_BYTE7)

#define S_DTU_WR_BYTE6    16
#define M_DTU_WR_BYTE6    0xffU
#define V_DTU_WR_BYTE6(x) ((x) << S_DTU_WR_BYTE6)
#define G_DTU_WR_BYTE6(x) (((x) >> S_DTU_WR_BYTE6) & M_DTU_WR_BYTE6)

#define S_DTU_WR_BYTE5    8
#define M_DTU_WR_BYTE5    0xffU
#define V_DTU_WR_BYTE5(x) ((x) << S_DTU_WR_BYTE5)
#define G_DTU_WR_BYTE5(x) (((x) >> S_DTU_WR_BYTE5) & M_DTU_WR_BYTE5)

#define S_DTU_WR_BYTE4    0
#define M_DTU_WR_BYTE4    0xffU
#define V_DTU_WR_BYTE4(x) ((x) << S_DTU_WR_BYTE4)
#define G_DTU_WR_BYTE4(x) (((x) >> S_DTU_WR_BYTE4) & M_DTU_WR_BYTE4)

#define A_MC_PCTL_DTUWD2 0x6418

#define S_DTU_WR_BYTE11    24
#define M_DTU_WR_BYTE11    0xffU
#define V_DTU_WR_BYTE11(x) ((x) << S_DTU_WR_BYTE11)
#define G_DTU_WR_BYTE11(x) (((x) >> S_DTU_WR_BYTE11) & M_DTU_WR_BYTE11)

#define S_DTU_WR_BYTE10    16
#define M_DTU_WR_BYTE10    0xffU
#define V_DTU_WR_BYTE10(x) ((x) << S_DTU_WR_BYTE10)
#define G_DTU_WR_BYTE10(x) (((x) >> S_DTU_WR_BYTE10) & M_DTU_WR_BYTE10)

#define S_DTU_WR_BYTE9    8
#define M_DTU_WR_BYTE9    0xffU
#define V_DTU_WR_BYTE9(x) ((x) << S_DTU_WR_BYTE9)
#define G_DTU_WR_BYTE9(x) (((x) >> S_DTU_WR_BYTE9) & M_DTU_WR_BYTE9)

#define S_DTU_WR_BYTE8    0
#define M_DTU_WR_BYTE8    0xffU
#define V_DTU_WR_BYTE8(x) ((x) << S_DTU_WR_BYTE8)
#define G_DTU_WR_BYTE8(x) (((x) >> S_DTU_WR_BYTE8) & M_DTU_WR_BYTE8)

#define A_MC_PCTL_DTUWD3 0x641c

#define S_DTU_WR_BYTE15    24
#define M_DTU_WR_BYTE15    0xffU
#define V_DTU_WR_BYTE15(x) ((x) << S_DTU_WR_BYTE15)
#define G_DTU_WR_BYTE15(x) (((x) >> S_DTU_WR_BYTE15) & M_DTU_WR_BYTE15)

#define S_DTU_WR_BYTE14    16
#define M_DTU_WR_BYTE14    0xffU
#define V_DTU_WR_BYTE14(x) ((x) << S_DTU_WR_BYTE14)
#define G_DTU_WR_BYTE14(x) (((x) >> S_DTU_WR_BYTE14) & M_DTU_WR_BYTE14)

#define S_DTU_WR_BYTE13    8
#define M_DTU_WR_BYTE13    0xffU
#define V_DTU_WR_BYTE13(x) ((x) << S_DTU_WR_BYTE13)
#define G_DTU_WR_BYTE13(x) (((x) >> S_DTU_WR_BYTE13) & M_DTU_WR_BYTE13)

#define S_DTU_WR_BYTE12    0
#define M_DTU_WR_BYTE12    0xffU
#define V_DTU_WR_BYTE12(x) ((x) << S_DTU_WR_BYTE12)
#define G_DTU_WR_BYTE12(x) (((x) >> S_DTU_WR_BYTE12) & M_DTU_WR_BYTE12)

#define A_MC_PCTL_DTUWDM 0x6420

#define S_DM_WR_BYTE0    0
#define M_DM_WR_BYTE0    0xffffU
#define V_DM_WR_BYTE0(x) ((x) << S_DM_WR_BYTE0)
#define G_DM_WR_BYTE0(x) (((x) >> S_DM_WR_BYTE0) & M_DM_WR_BYTE0)

#define A_MC_PCTL_DTURD0 0x6424

#define S_DTU_RD_BYTE3    24
#define M_DTU_RD_BYTE3    0xffU
#define V_DTU_RD_BYTE3(x) ((x) << S_DTU_RD_BYTE3)
#define G_DTU_RD_BYTE3(x) (((x) >> S_DTU_RD_BYTE3) & M_DTU_RD_BYTE3)

#define S_DTU_RD_BYTE2    16
#define M_DTU_RD_BYTE2    0xffU
#define V_DTU_RD_BYTE2(x) ((x) << S_DTU_RD_BYTE2)
#define G_DTU_RD_BYTE2(x) (((x) >> S_DTU_RD_BYTE2) & M_DTU_RD_BYTE2)

#define S_DTU_RD_BYTE1    8
#define M_DTU_RD_BYTE1    0xffU
#define V_DTU_RD_BYTE1(x) ((x) << S_DTU_RD_BYTE1)
#define G_DTU_RD_BYTE1(x) (((x) >> S_DTU_RD_BYTE1) & M_DTU_RD_BYTE1)

#define S_DTU_RD_BYTE0    0
#define M_DTU_RD_BYTE0    0xffU
#define V_DTU_RD_BYTE0(x) ((x) << S_DTU_RD_BYTE0)
#define G_DTU_RD_BYTE0(x) (((x) >> S_DTU_RD_BYTE0) & M_DTU_RD_BYTE0)

#define A_MC_PCTL_DTURD1 0x6428

#define S_DTU_RD_BYTE7    24
#define M_DTU_RD_BYTE7    0xffU
#define V_DTU_RD_BYTE7(x) ((x) << S_DTU_RD_BYTE7)
#define G_DTU_RD_BYTE7(x) (((x) >> S_DTU_RD_BYTE7) & M_DTU_RD_BYTE7)

#define S_DTU_RD_BYTE6    16
#define M_DTU_RD_BYTE6    0xffU
#define V_DTU_RD_BYTE6(x) ((x) << S_DTU_RD_BYTE6)
#define G_DTU_RD_BYTE6(x) (((x) >> S_DTU_RD_BYTE6) & M_DTU_RD_BYTE6)

#define S_DTU_RD_BYTE5    8
#define M_DTU_RD_BYTE5    0xffU
#define V_DTU_RD_BYTE5(x) ((x) << S_DTU_RD_BYTE5)
#define G_DTU_RD_BYTE5(x) (((x) >> S_DTU_RD_BYTE5) & M_DTU_RD_BYTE5)

#define S_DTU_RD_BYTE4    0
#define M_DTU_RD_BYTE4    0xffU
#define V_DTU_RD_BYTE4(x) ((x) << S_DTU_RD_BYTE4)
#define G_DTU_RD_BYTE4(x) (((x) >> S_DTU_RD_BYTE4) & M_DTU_RD_BYTE4)

#define A_MC_PCTL_DTURD2 0x642c

#define S_DTU_RD_BYTE11    24
#define M_DTU_RD_BYTE11    0xffU
#define V_DTU_RD_BYTE11(x) ((x) << S_DTU_RD_BYTE11)
#define G_DTU_RD_BYTE11(x) (((x) >> S_DTU_RD_BYTE11) & M_DTU_RD_BYTE11)

#define S_DTU_RD_BYTE10    16
#define M_DTU_RD_BYTE10    0xffU
#define V_DTU_RD_BYTE10(x) ((x) << S_DTU_RD_BYTE10)
#define G_DTU_RD_BYTE10(x) (((x) >> S_DTU_RD_BYTE10) & M_DTU_RD_BYTE10)

#define S_DTU_RD_BYTE9    8
#define M_DTU_RD_BYTE9    0xffU
#define V_DTU_RD_BYTE9(x) ((x) << S_DTU_RD_BYTE9)
#define G_DTU_RD_BYTE9(x) (((x) >> S_DTU_RD_BYTE9) & M_DTU_RD_BYTE9)

#define S_DTU_RD_BYTE8    0
#define M_DTU_RD_BYTE8    0xffU
#define V_DTU_RD_BYTE8(x) ((x) << S_DTU_RD_BYTE8)
#define G_DTU_RD_BYTE8(x) (((x) >> S_DTU_RD_BYTE8) & M_DTU_RD_BYTE8)

#define A_MC_PCTL_DTURD3 0x6430

#define S_DTU_RD_BYTE15    24
#define M_DTU_RD_BYTE15    0xffU
#define V_DTU_RD_BYTE15(x) ((x) << S_DTU_RD_BYTE15)
#define G_DTU_RD_BYTE15(x) (((x) >> S_DTU_RD_BYTE15) & M_DTU_RD_BYTE15)

#define S_DTU_RD_BYTE14    16
#define M_DTU_RD_BYTE14    0xffU
#define V_DTU_RD_BYTE14(x) ((x) << S_DTU_RD_BYTE14)
#define G_DTU_RD_BYTE14(x) (((x) >> S_DTU_RD_BYTE14) & M_DTU_RD_BYTE14)

#define S_DTU_RD_BYTE13    8
#define M_DTU_RD_BYTE13    0xffU
#define V_DTU_RD_BYTE13(x) ((x) << S_DTU_RD_BYTE13)
#define G_DTU_RD_BYTE13(x) (((x) >> S_DTU_RD_BYTE13) & M_DTU_RD_BYTE13)

#define S_DTU_RD_BYTE12    0
#define M_DTU_RD_BYTE12    0xffU
#define V_DTU_RD_BYTE12(x) ((x) << S_DTU_RD_BYTE12)
#define G_DTU_RD_BYTE12(x) (((x) >> S_DTU_RD_BYTE12) & M_DTU_RD_BYTE12)

#define A_MC_DTULFSRWD 0x6434
#define A_MC_PCTL_DTULFSRRD 0x6438
#define A_MC_PCTL_DTUEAF 0x643c

#define S_EA_RANK    30
#define M_EA_RANK    0x3U
#define V_EA_RANK(x) ((x) << S_EA_RANK)
#define G_EA_RANK(x) (((x) >> S_EA_RANK) & M_EA_RANK)

#define S_EA_ROW    13
#define M_EA_ROW    0x1ffffU
#define V_EA_ROW(x) ((x) << S_EA_ROW)
#define G_EA_ROW(x) (((x) >> S_EA_ROW) & M_EA_ROW)

#define S_EA_BANK    10
#define M_EA_BANK    0x7U
#define V_EA_BANK(x) ((x) << S_EA_BANK)
#define G_EA_BANK(x) (((x) >> S_EA_BANK) & M_EA_BANK)

#define S_EA_COLUMN    0
#define M_EA_COLUMN    0x3ffU
#define V_EA_COLUMN(x) ((x) << S_EA_COLUMN)
#define G_EA_COLUMN(x) (((x) >> S_EA_COLUMN) & M_EA_COLUMN)

#define A_MC_PCTL_PHYPVTCFG 0x6500

#define S_PVT_UPD_REQ_EN    15
#define V_PVT_UPD_REQ_EN(x) ((x) << S_PVT_UPD_REQ_EN)
#define F_PVT_UPD_REQ_EN    V_PVT_UPD_REQ_EN(1U)

#define S_PVT_UPD_TRIG_POL    14
#define V_PVT_UPD_TRIG_POL(x) ((x) << S_PVT_UPD_TRIG_POL)
#define F_PVT_UPD_TRIG_POL    V_PVT_UPD_TRIG_POL(1U)

#define S_PVT_UPD_TRIG_TYPE    12
#define V_PVT_UPD_TRIG_TYPE(x) ((x) << S_PVT_UPD_TRIG_TYPE)
#define F_PVT_UPD_TRIG_TYPE    V_PVT_UPD_TRIG_TYPE(1U)

#define S_PVT_UPD_DONE_POL    10
#define V_PVT_UPD_DONE_POL(x) ((x) << S_PVT_UPD_DONE_POL)
#define F_PVT_UPD_DONE_POL    V_PVT_UPD_DONE_POL(1U)

#define S_PVT_UPD_DONE_TYPE    8
#define M_PVT_UPD_DONE_TYPE    0x3U
#define V_PVT_UPD_DONE_TYPE(x) ((x) << S_PVT_UPD_DONE_TYPE)
#define G_PVT_UPD_DONE_TYPE(x) (((x) >> S_PVT_UPD_DONE_TYPE) & M_PVT_UPD_DONE_TYPE)

#define S_PHY_UPD_REQ_EN    7
#define V_PHY_UPD_REQ_EN(x) ((x) << S_PHY_UPD_REQ_EN)
#define F_PHY_UPD_REQ_EN    V_PHY_UPD_REQ_EN(1U)

#define S_PHY_UPD_TRIG_POL    6
#define V_PHY_UPD_TRIG_POL(x) ((x) << S_PHY_UPD_TRIG_POL)
#define F_PHY_UPD_TRIG_POL    V_PHY_UPD_TRIG_POL(1U)

#define S_PHY_UPD_TRIG_TYPE    4
#define V_PHY_UPD_TRIG_TYPE(x) ((x) << S_PHY_UPD_TRIG_TYPE)
#define F_PHY_UPD_TRIG_TYPE    V_PHY_UPD_TRIG_TYPE(1U)

#define S_PHY_UPD_DONE_POL    2
#define V_PHY_UPD_DONE_POL(x) ((x) << S_PHY_UPD_DONE_POL)
#define F_PHY_UPD_DONE_POL    V_PHY_UPD_DONE_POL(1U)

#define S_PHY_UPD_DONE_TYPE    0
#define M_PHY_UPD_DONE_TYPE    0x3U
#define V_PHY_UPD_DONE_TYPE(x) ((x) << S_PHY_UPD_DONE_TYPE)
#define G_PHY_UPD_DONE_TYPE(x) (((x) >> S_PHY_UPD_DONE_TYPE) & M_PHY_UPD_DONE_TYPE)

#define A_MC_PCTL_PHYPVTSTAT 0x6504

#define S_I_PVT_UPD_TRIG    5
#define V_I_PVT_UPD_TRIG(x) ((x) << S_I_PVT_UPD_TRIG)
#define F_I_PVT_UPD_TRIG    V_I_PVT_UPD_TRIG(1U)

#define S_I_PVT_UPD_DONE    4
#define V_I_PVT_UPD_DONE(x) ((x) << S_I_PVT_UPD_DONE)
#define F_I_PVT_UPD_DONE    V_I_PVT_UPD_DONE(1U)

#define S_I_PHY_UPD_TRIG    1
#define V_I_PHY_UPD_TRIG(x) ((x) << S_I_PHY_UPD_TRIG)
#define F_I_PHY_UPD_TRIG    V_I_PHY_UPD_TRIG(1U)

#define S_I_PHY_UPD_DONE    0
#define V_I_PHY_UPD_DONE(x) ((x) << S_I_PHY_UPD_DONE)
#define F_I_PHY_UPD_DONE    V_I_PHY_UPD_DONE(1U)

#define A_MC_PCTL_PHYTUPDON 0x6508

#define S_PHY_T_UPDON    0
#define M_PHY_T_UPDON    0xffU
#define V_PHY_T_UPDON(x) ((x) << S_PHY_T_UPDON)
#define G_PHY_T_UPDON(x) (((x) >> S_PHY_T_UPDON) & M_PHY_T_UPDON)

#define A_MC_PCTL_PHYTUPDDLY 0x650c

#define S_PHY_T_UPDDLY    0
#define M_PHY_T_UPDDLY    0xfU
#define V_PHY_T_UPDDLY(x) ((x) << S_PHY_T_UPDDLY)
#define G_PHY_T_UPDDLY(x) (((x) >> S_PHY_T_UPDDLY) & M_PHY_T_UPDDLY)

#define A_MC_PCTL_PVTTUPON 0x6510

#define S_PVT_T_UPDON    0
#define M_PVT_T_UPDON    0xffU
#define V_PVT_T_UPDON(x) ((x) << S_PVT_T_UPDON)
#define G_PVT_T_UPDON(x) (((x) >> S_PVT_T_UPDON) & M_PVT_T_UPDON)

#define A_MC_PCTL_PVTTUPDDLY 0x6514

#define S_PVT_T_UPDDLY    0
#define M_PVT_T_UPDDLY    0xfU
#define V_PVT_T_UPDDLY(x) ((x) << S_PVT_T_UPDDLY)
#define G_PVT_T_UPDDLY(x) (((x) >> S_PVT_T_UPDDLY) & M_PVT_T_UPDDLY)

#define A_MC_PCTL_PHYPVTUPDI 0x6518

#define S_PHYPVT_T_UPDI    0
#define M_PHYPVT_T_UPDI    0xffU
#define V_PHYPVT_T_UPDI(x) ((x) << S_PHYPVT_T_UPDI)
#define G_PHYPVT_T_UPDI(x) (((x) >> S_PHYPVT_T_UPDI) & M_PHYPVT_T_UPDI)

#define A_MC_PCTL_PHYIOCRV1 0x651c

#define S_BYTE_OE_CTL    16
#define M_BYTE_OE_CTL    0x3U
#define V_BYTE_OE_CTL(x) ((x) << S_BYTE_OE_CTL)
#define G_BYTE_OE_CTL(x) (((x) >> S_BYTE_OE_CTL) & M_BYTE_OE_CTL)

#define S_DYN_SOC_ODT_ALAT    12
#define M_DYN_SOC_ODT_ALAT    0xfU
#define V_DYN_SOC_ODT_ALAT(x) ((x) << S_DYN_SOC_ODT_ALAT)
#define G_DYN_SOC_ODT_ALAT(x) (((x) >> S_DYN_SOC_ODT_ALAT) & M_DYN_SOC_ODT_ALAT)

#define S_DYN_SOC_ODT_ATEN    8
#define M_DYN_SOC_ODT_ATEN    0x3U
#define V_DYN_SOC_ODT_ATEN(x) ((x) << S_DYN_SOC_ODT_ATEN)
#define G_DYN_SOC_ODT_ATEN(x) (((x) >> S_DYN_SOC_ODT_ATEN) & M_DYN_SOC_ODT_ATEN)

#define S_DYN_SOC_ODT    2
#define V_DYN_SOC_ODT(x) ((x) << S_DYN_SOC_ODT)
#define F_DYN_SOC_ODT    V_DYN_SOC_ODT(1U)

#define S_SOC_ODT_EN    0
#define V_SOC_ODT_EN(x) ((x) << S_SOC_ODT_EN)
#define F_SOC_ODT_EN    V_SOC_ODT_EN(1U)

#define A_MC_PCTL_PHYTUPDWAIT 0x6520

#define S_PHY_T_UPDWAIT    0
#define M_PHY_T_UPDWAIT    0x3fU
#define V_PHY_T_UPDWAIT(x) ((x) << S_PHY_T_UPDWAIT)
#define G_PHY_T_UPDWAIT(x) (((x) >> S_PHY_T_UPDWAIT) & M_PHY_T_UPDWAIT)

#define A_MC_PCTL_PVTTUPDWAIT 0x6524

#define S_PVT_T_UPDWAIT    0
#define M_PVT_T_UPDWAIT    0x3fU
#define V_PVT_T_UPDWAIT(x) ((x) << S_PVT_T_UPDWAIT)
#define G_PVT_T_UPDWAIT(x) (((x) >> S_PVT_T_UPDWAIT) & M_PVT_T_UPDWAIT)

#define A_MC_DDR3PHYAC_GCR 0x6a00

#define S_WLRANK    8
#define M_WLRANK    0x3U
#define V_WLRANK(x) ((x) << S_WLRANK)
#define G_WLRANK(x) (((x) >> S_WLRANK) & M_WLRANK)

#define S_FDEPTH    6
#define M_FDEPTH    0x3U
#define V_FDEPTH(x) ((x) << S_FDEPTH)
#define G_FDEPTH(x) (((x) >> S_FDEPTH) & M_FDEPTH)

#define S_LPFDEPTH    4
#define M_LPFDEPTH    0x3U
#define V_LPFDEPTH(x) ((x) << S_LPFDEPTH)
#define G_LPFDEPTH(x) (((x) >> S_LPFDEPTH) & M_LPFDEPTH)

#define S_LPFEN    3
#define V_LPFEN(x) ((x) << S_LPFEN)
#define F_LPFEN    V_LPFEN(1U)

#define S_WL    2
#define V_WL(x) ((x) << S_WL)
#define F_WL    V_WL(1U)

#define S_CAL    1
#define V_CAL(x) ((x) << S_CAL)
#define F_CAL    V_CAL(1U)

#define S_MDLEN    0
#define V_MDLEN(x) ((x) << S_MDLEN)
#define F_MDLEN    V_MDLEN(1U)

#define A_MC_DDR3PHYAC_RCR0 0x6a04

#define S_OCPONR    8
#define V_OCPONR(x) ((x) << S_OCPONR)
#define F_OCPONR    V_OCPONR(1U)

#define S_OCPOND    7
#define V_OCPOND(x) ((x) << S_OCPOND)
#define F_OCPOND    V_OCPOND(1U)

#define S_OCOEN    6
#define V_OCOEN(x) ((x) << S_OCOEN)
#define F_OCOEN    V_OCOEN(1U)

#define S_CKEPONR    5
#define V_CKEPONR(x) ((x) << S_CKEPONR)
#define F_CKEPONR    V_CKEPONR(1U)

#define S_CKEPOND    4
#define V_CKEPOND(x) ((x) << S_CKEPOND)
#define F_CKEPOND    V_CKEPOND(1U)

#define S_CKEOEN    3
#define V_CKEOEN(x) ((x) << S_CKEOEN)
#define F_CKEOEN    V_CKEOEN(1U)

#define S_CKPONR    2
#define V_CKPONR(x) ((x) << S_CKPONR)
#define F_CKPONR    V_CKPONR(1U)

#define S_CKPOND    1
#define V_CKPOND(x) ((x) << S_CKPOND)
#define F_CKPOND    V_CKPOND(1U)

#define S_CKOEN    0
#define V_CKOEN(x) ((x) << S_CKOEN)
#define F_CKOEN    V_CKOEN(1U)

#define A_MC_DDR3PHYAC_ACCR 0x6a14

#define S_ACPONR    8
#define V_ACPONR(x) ((x) << S_ACPONR)
#define F_ACPONR    V_ACPONR(1U)

#define S_ACPOND    7
#define V_ACPOND(x) ((x) << S_ACPOND)
#define F_ACPOND    V_ACPOND(1U)

#define S_ACOEN    6
#define V_ACOEN(x) ((x) << S_ACOEN)
#define F_ACOEN    V_ACOEN(1U)

#define S_CK5PONR    5
#define V_CK5PONR(x) ((x) << S_CK5PONR)
#define F_CK5PONR    V_CK5PONR(1U)

#define S_CK5POND    4
#define V_CK5POND(x) ((x) << S_CK5POND)
#define F_CK5POND    V_CK5POND(1U)

#define S_CK5OEN    3
#define V_CK5OEN(x) ((x) << S_CK5OEN)
#define F_CK5OEN    V_CK5OEN(1U)

#define S_CK4PONR    2
#define V_CK4PONR(x) ((x) << S_CK4PONR)
#define F_CK4PONR    V_CK4PONR(1U)

#define S_CK4POND    1
#define V_CK4POND(x) ((x) << S_CK4POND)
#define F_CK4POND    V_CK4POND(1U)

#define S_CK4OEN    0
#define V_CK4OEN(x) ((x) << S_CK4OEN)
#define F_CK4OEN    V_CK4OEN(1U)

#define A_MC_DDR3PHYAC_GSR 0x6a18

#define S_WLERR    4
#define V_WLERR(x) ((x) << S_WLERR)
#define F_WLERR    V_WLERR(1U)

#define S_INIT    3
#define V_INIT(x) ((x) << S_INIT)
#define F_INIT    V_INIT(1U)

#define S_ACCAL    0
#define V_ACCAL(x) ((x) << S_ACCAL)
#define F_ACCAL    V_ACCAL(1U)

#define A_MC_DDR3PHYAC_ECSR 0x6a1c

#define S_WLDEC    1
#define V_WLDEC(x) ((x) << S_WLDEC)
#define F_WLDEC    V_WLDEC(1U)

#define S_WLINC    0
#define V_WLINC(x) ((x) << S_WLINC)
#define F_WLINC    V_WLINC(1U)

#define A_MC_DDR3PHYAC_OCSR 0x6a20
#define A_MC_DDR3PHYAC_MDIPR 0x6a24

#define S_PRD    0
#define M_PRD    0x3ffU
#define V_PRD(x) ((x) << S_PRD)
#define G_PRD(x) (((x) >> S_PRD) & M_PRD)

#define A_MC_DDR3PHYAC_MDTPR 0x6a28
#define A_MC_DDR3PHYAC_MDPPR0 0x6a2c
#define A_MC_DDR3PHYAC_MDPPR1 0x6a30
#define A_MC_DDR3PHYAC_PMBDR0 0x6a34

#define S_DFLTDLY    0
#define M_DFLTDLY    0x7fU
#define V_DFLTDLY(x) ((x) << S_DFLTDLY)
#define G_DFLTDLY(x) (((x) >> S_DFLTDLY) & M_DFLTDLY)

#define A_MC_DDR3PHYAC_PMBDR1 0x6a38
#define A_MC_DDR3PHYAC_ACR 0x6a60

#define S_TSEL    9
#define V_TSEL(x) ((x) << S_TSEL)
#define F_TSEL    V_TSEL(1U)

#define S_ISEL    7
#define M_ISEL    0x3U
#define V_ISEL(x) ((x) << S_ISEL)
#define G_ISEL(x) (((x) >> S_ISEL) & M_ISEL)

#define S_CALBYP    2
#define V_CALBYP(x) ((x) << S_CALBYP)
#define F_CALBYP    V_CALBYP(1U)

#define S_SDRSELINV    1
#define V_SDRSELINV(x) ((x) << S_SDRSELINV)
#define F_SDRSELINV    V_SDRSELINV(1U)

#define S_CKINV    0
#define V_CKINV(x) ((x) << S_CKINV)
#define F_CKINV    V_CKINV(1U)

#define A_MC_DDR3PHYAC_PSCR 0x6a64

#define S_PSCALE    0
#define M_PSCALE    0x3ffU
#define V_PSCALE(x) ((x) << S_PSCALE)
#define G_PSCALE(x) (((x) >> S_PSCALE) & M_PSCALE)

#define A_MC_DDR3PHYAC_PRCR 0x6a68

#define S_PHYINIT    9
#define V_PHYINIT(x) ((x) << S_PHYINIT)
#define F_PHYINIT    V_PHYINIT(1U)

#define S_PHYHRST    7
#define V_PHYHRST(x) ((x) << S_PHYHRST)
#define F_PHYHRST    V_PHYHRST(1U)

#define S_RSTCLKS    3
#define M_RSTCLKS    0xfU
#define V_RSTCLKS(x) ((x) << S_RSTCLKS)
#define G_RSTCLKS(x) (((x) >> S_RSTCLKS) & M_RSTCLKS)

#define S_PLLPD    2
#define V_PLLPD(x) ((x) << S_PLLPD)
#define F_PLLPD    V_PLLPD(1U)

#define S_PLLRST    1
#define V_PLLRST(x) ((x) << S_PLLRST)
#define F_PLLRST    V_PLLRST(1U)

#define S_PHYRST    0
#define V_PHYRST(x) ((x) << S_PHYRST)
#define F_PHYRST    V_PHYRST(1U)

#define A_MC_DDR3PHYAC_PLLCR0 0x6a6c

#define S_RSTCXKS    4
#define M_RSTCXKS    0x1fU
#define V_RSTCXKS(x) ((x) << S_RSTCXKS)
#define G_RSTCXKS(x) (((x) >> S_RSTCXKS) & M_RSTCXKS)

#define S_ICPSEL    3
#define V_ICPSEL(x) ((x) << S_ICPSEL)
#define F_ICPSEL    V_ICPSEL(1U)

#define S_TESTA    0
#define M_TESTA    0x7U
#define V_TESTA(x) ((x) << S_TESTA)
#define G_TESTA(x) (((x) >> S_TESTA) & M_TESTA)

#define A_MC_DDR3PHYAC_PLLCR1 0x6a70

#define S_BYPASS    9
#define V_BYPASS(x) ((x) << S_BYPASS)
#define F_BYPASS    V_BYPASS(1U)

#define S_BDIV    3
#define M_BDIV    0x3U
#define V_BDIV(x) ((x) << S_BDIV)
#define G_BDIV(x) (((x) >> S_BDIV) & M_BDIV)

#define S_TESTD    0
#define M_TESTD    0x7U
#define V_TESTD(x) ((x) << S_TESTD)
#define G_TESTD(x) (((x) >> S_TESTD) & M_TESTD)

#define A_MC_DDR3PHYAC_CLKENR 0x6a78

#define S_CKCLKEN    3
#define M_CKCLKEN    0x3fU
#define V_CKCLKEN(x) ((x) << S_CKCLKEN)
#define G_CKCLKEN(x) (((x) >> S_CKCLKEN) & M_CKCLKEN)

#define S_HDRCLKEN    2
#define V_HDRCLKEN(x) ((x) << S_HDRCLKEN)
#define F_HDRCLKEN    V_HDRCLKEN(1U)

#define S_SDRCLKEN    1
#define V_SDRCLKEN(x) ((x) << S_SDRCLKEN)
#define F_SDRCLKEN    V_SDRCLKEN(1U)

#define S_DDRCLKEN    0
#define V_DDRCLKEN(x) ((x) << S_DDRCLKEN)
#define F_DDRCLKEN    V_DDRCLKEN(1U)

#define A_MC_DDR3PHYDATX8_GCR 0x6b00

#define S_PONR    6
#define V_PONR(x) ((x) << S_PONR)
#define F_PONR    V_PONR(1U)

#define S_POND    5
#define V_POND(x) ((x) << S_POND)
#define F_POND    V_POND(1U)

#define S_RDBDVT    4
#define V_RDBDVT(x) ((x) << S_RDBDVT)
#define F_RDBDVT    V_RDBDVT(1U)

#define S_WDBDVT    3
#define V_WDBDVT(x) ((x) << S_WDBDVT)
#define F_WDBDVT    V_WDBDVT(1U)

#define S_RDSDVT    2
#define V_RDSDVT(x) ((x) << S_RDSDVT)
#define F_RDSDVT    V_RDSDVT(1U)

#define S_WDSDVT    1
#define V_WDSDVT(x) ((x) << S_WDSDVT)
#define F_WDSDVT    V_WDSDVT(1U)

#define S_WLSDVT    0
#define V_WLSDVT(x) ((x) << S_WLSDVT)
#define F_WLSDVT    V_WLSDVT(1U)

#define A_MC_DDR3PHYDATX8_WDSDR 0x6b04

#define S_WDSDR_DLY    0
#define M_WDSDR_DLY    0x3ffU
#define V_WDSDR_DLY(x) ((x) << S_WDSDR_DLY)
#define G_WDSDR_DLY(x) (((x) >> S_WDSDR_DLY) & M_WDSDR_DLY)

#define A_MC_DDR3PHYDATX8_WLDPR 0x6b08
#define A_MC_DDR3PHYDATX8_WLDR 0x6b0c

#define S_WL_DLY    0
#define M_WL_DLY    0x3ffU
#define V_WL_DLY(x) ((x) << S_WL_DLY)
#define G_WL_DLY(x) (((x) >> S_WL_DLY) & M_WL_DLY)

#define A_MC_DDR3PHYDATX8_WDBDR0 0x6b1c

#define S_DLY    0
#define M_DLY    0x7fU
#define V_DLY(x) ((x) << S_DLY)
#define G_DLY(x) (((x) >> S_DLY) & M_DLY)

#define A_MC_DDR3PHYDATX8_WDBDR1 0x6b20
#define A_MC_DDR3PHYDATX8_WDBDR2 0x6b24
#define A_MC_DDR3PHYDATX8_WDBDR3 0x6b28
#define A_MC_DDR3PHYDATX8_WDBDR4 0x6b2c
#define A_MC_DDR3PHYDATX8_WDBDR5 0x6b30
#define A_MC_DDR3PHYDATX8_WDBDR6 0x6b34
#define A_MC_DDR3PHYDATX8_WDBDR7 0x6b38
#define A_MC_DDR3PHYDATX8_WDBDR8 0x6b3c
#define A_MC_DDR3PHYDATX8_WDBDMR 0x6b40

#define S_MAXDLY    0
#define M_MAXDLY    0x7fU
#define V_MAXDLY(x) ((x) << S_MAXDLY)
#define G_MAXDLY(x) (((x) >> S_MAXDLY) & M_MAXDLY)

#define A_MC_DDR3PHYDATX8_RDSDR 0x6b44

#define S_RDSDR_DLY    0
#define M_RDSDR_DLY    0x3ffU
#define V_RDSDR_DLY(x) ((x) << S_RDSDR_DLY)
#define G_RDSDR_DLY(x) (((x) >> S_RDSDR_DLY) & M_RDSDR_DLY)

#define A_MC_DDR3PHYDATX8_RDBDR0 0x6b48
#define A_MC_DDR3PHYDATX8_RDBDR1 0x6b4c
#define A_MC_DDR3PHYDATX8_RDBDR2 0x6b50
#define A_MC_DDR3PHYDATX8_RDBDR3 0x6b54
#define A_MC_DDR3PHYDATX8_RDBDR4 0x6b58
#define A_MC_DDR3PHYDATX8_RDBDR5 0x6b5c
#define A_MC_DDR3PHYDATX8_RDBDR6 0x6b60
#define A_MC_DDR3PHYDATX8_RDBDR7 0x6b64
#define A_MC_DDR3PHYDATX8_RDBDMR 0x6b68
#define A_MC_DDR3PHYDATX8_PMBDR0 0x6b6c
#define A_MC_DDR3PHYDATX8_PMBDR1 0x6b70
#define A_MC_DDR3PHYDATX8_PMBDR2 0x6b74
#define A_MC_DDR3PHYDATX8_PMBDR3 0x6b78
#define A_MC_DDR3PHYDATX8_WDBDPR 0x6b7c

#define S_DP_DLY    0
#define M_DP_DLY    0x1ffU
#define V_DP_DLY(x) ((x) << S_DP_DLY)
#define G_DP_DLY(x) (((x) >> S_DP_DLY) & M_DP_DLY)

#define A_MC_DDR3PHYDATX8_RDBDPR 0x6b80
#define A_MC_DDR3PHYDATX8_GSR 0x6b84

#define S_WLDONE    3
#define V_WLDONE(x) ((x) << S_WLDONE)
#define F_WLDONE    V_WLDONE(1U)

#define S_WLCAL    2
#define V_WLCAL(x) ((x) << S_WLCAL)
#define F_WLCAL    V_WLCAL(1U)

#define S_READ    1
#define V_READ(x) ((x) << S_READ)
#define F_READ    V_READ(1U)

#define S_RDQSCAL    0
#define V_RDQSCAL(x) ((x) << S_RDQSCAL)
#define F_RDQSCAL    V_RDQSCAL(1U)

#define A_MC_DDR3PHYDATX8_ACR 0x6bf0

#define S_PHYHSRST    9
#define V_PHYHSRST(x) ((x) << S_PHYHSRST)
#define F_PHYHSRST    V_PHYHSRST(1U)

#define S_WLSTEP    8
#define V_WLSTEP(x) ((x) << S_WLSTEP)
#define F_WLSTEP    V_WLSTEP(1U)

#define S_SDR_SEL_INV    2
#define V_SDR_SEL_INV(x) ((x) << S_SDR_SEL_INV)
#define F_SDR_SEL_INV    V_SDR_SEL_INV(1U)

#define S_DDRSELINV    1
#define V_DDRSELINV(x) ((x) << S_DDRSELINV)
#define F_DDRSELINV    V_DDRSELINV(1U)

#define S_DSINV    0
#define V_DSINV(x) ((x) << S_DSINV)
#define F_DSINV    V_DSINV(1U)

#define A_MC_DDR3PHYDATX8_RSR 0x6bf4

#define S_WLRANKSEL    9
#define V_WLRANKSEL(x) ((x) << S_WLRANKSEL)
#define F_WLRANKSEL    V_WLRANKSEL(1U)

#define S_RANK    0
#define M_RANK    0x3U
#define V_RANK(x) ((x) << S_RANK)
#define G_RANK(x) (((x) >> S_RANK) & M_RANK)

#define A_MC_DDR3PHYDATX8_CLKENR 0x6bf8

#define S_DTOSEL    8
#define M_DTOSEL    0x3U
#define V_DTOSEL(x) ((x) << S_DTOSEL)
#define G_DTOSEL(x) (((x) >> S_DTOSEL) & M_DTOSEL)

#define A_MC_PVT_REG_CALIBRATE_CTL 0x7400
#define A_MC_PVT_REG_UPDATE_CTL 0x7404
#define A_MC_PVT_REG_LAST_MEASUREMENT 0x7408
#define A_MC_PVT_REG_DRVN 0x740c
#define A_MC_PVT_REG_DRVP 0x7410
#define A_MC_PVT_REG_TERMN 0x7414
#define A_MC_PVT_REG_TERMP 0x7418
#define A_MC_PVT_REG_THRESHOLD 0x741c
#define A_MC_PVT_REG_IN_TERMP 0x7420
#define A_MC_PVT_REG_IN_TERMN 0x7424
#define A_MC_PVT_REG_IN_DRVP 0x7428
#define A_MC_PVT_REG_IN_DRVN 0x742c
#define A_MC_PVT_REG_OUT_TERMP 0x7430
#define A_MC_PVT_REG_OUT_TERMN 0x7434
#define A_MC_PVT_REG_OUT_DRVP 0x7438
#define A_MC_PVT_REG_OUT_DRVN 0x743c
#define A_MC_PVT_REG_HISTORY_TERMP 0x7440
#define A_MC_PVT_REG_HISTORY_TERMN 0x7444
#define A_MC_PVT_REG_HISTORY_DRVP 0x7448
#define A_MC_PVT_REG_HISTORY_DRVN 0x744c
#define A_MC_PVT_REG_SAMPLE_WAIT_CLKS 0x7450
#define A_MC_DDRPHY_RST_CTRL 0x7500

#define S_DDRIO_ENABLE    1
#define V_DDRIO_ENABLE(x) ((x) << S_DDRIO_ENABLE)
#define F_DDRIO_ENABLE    V_DDRIO_ENABLE(1U)

#define S_PHY_RST_N    0
#define V_PHY_RST_N(x) ((x) << S_PHY_RST_N)
#define F_PHY_RST_N    V_PHY_RST_N(1U)

#define A_MC_PERFORMANCE_CTRL 0x7504

#define S_STALL_CHK_BIT    2
#define V_STALL_CHK_BIT(x) ((x) << S_STALL_CHK_BIT)
#define F_STALL_CHK_BIT    V_STALL_CHK_BIT(1U)

#define S_DDR3_BRC_MODE    1
#define V_DDR3_BRC_MODE(x) ((x) << S_DDR3_BRC_MODE)
#define F_DDR3_BRC_MODE    V_DDR3_BRC_MODE(1U)

#define S_RMW_PERF_CTRL    0
#define V_RMW_PERF_CTRL(x) ((x) << S_RMW_PERF_CTRL)
#define F_RMW_PERF_CTRL    V_RMW_PERF_CTRL(1U)

#define A_MC_ECC_CTRL 0x7508

#define S_ECC_BYPASS_BIST    1
#define V_ECC_BYPASS_BIST(x) ((x) << S_ECC_BYPASS_BIST)
#define F_ECC_BYPASS_BIST    V_ECC_BYPASS_BIST(1U)

#define S_ECC_DISABLE    0
#define V_ECC_DISABLE(x) ((x) << S_ECC_DISABLE)
#define F_ECC_DISABLE    V_ECC_DISABLE(1U)

#define A_MC_PAR_ENABLE 0x750c

#define S_ECC_UE_PAR_ENABLE    3
#define V_ECC_UE_PAR_ENABLE(x) ((x) << S_ECC_UE_PAR_ENABLE)
#define F_ECC_UE_PAR_ENABLE    V_ECC_UE_PAR_ENABLE(1U)

#define S_ECC_CE_PAR_ENABLE    2
#define V_ECC_CE_PAR_ENABLE(x) ((x) << S_ECC_CE_PAR_ENABLE)
#define F_ECC_CE_PAR_ENABLE    V_ECC_CE_PAR_ENABLE(1U)

#define S_PERR_REG_INT_ENABLE    1
#define V_PERR_REG_INT_ENABLE(x) ((x) << S_PERR_REG_INT_ENABLE)
#define F_PERR_REG_INT_ENABLE    V_PERR_REG_INT_ENABLE(1U)

#define S_PERR_BLK_INT_ENABLE    0
#define V_PERR_BLK_INT_ENABLE(x) ((x) << S_PERR_BLK_INT_ENABLE)
#define F_PERR_BLK_INT_ENABLE    V_PERR_BLK_INT_ENABLE(1U)

#define A_MC_PAR_CAUSE 0x7510

#define S_ECC_UE_PAR_CAUSE    3
#define V_ECC_UE_PAR_CAUSE(x) ((x) << S_ECC_UE_PAR_CAUSE)
#define F_ECC_UE_PAR_CAUSE    V_ECC_UE_PAR_CAUSE(1U)

#define S_ECC_CE_PAR_CAUSE    2
#define V_ECC_CE_PAR_CAUSE(x) ((x) << S_ECC_CE_PAR_CAUSE)
#define F_ECC_CE_PAR_CAUSE    V_ECC_CE_PAR_CAUSE(1U)

#define S_FIFOR_PAR_CAUSE    1
#define V_FIFOR_PAR_CAUSE(x) ((x) << S_FIFOR_PAR_CAUSE)
#define F_FIFOR_PAR_CAUSE    V_FIFOR_PAR_CAUSE(1U)

#define S_RDATA_FIFOR_PAR_CAUSE    0
#define V_RDATA_FIFOR_PAR_CAUSE(x) ((x) << S_RDATA_FIFOR_PAR_CAUSE)
#define F_RDATA_FIFOR_PAR_CAUSE    V_RDATA_FIFOR_PAR_CAUSE(1U)

#define A_MC_INT_ENABLE 0x7514

#define S_ECC_UE_INT_ENABLE    2
#define V_ECC_UE_INT_ENABLE(x) ((x) << S_ECC_UE_INT_ENABLE)
#define F_ECC_UE_INT_ENABLE    V_ECC_UE_INT_ENABLE(1U)

#define S_ECC_CE_INT_ENABLE    1
#define V_ECC_CE_INT_ENABLE(x) ((x) << S_ECC_CE_INT_ENABLE)
#define F_ECC_CE_INT_ENABLE    V_ECC_CE_INT_ENABLE(1U)

#define S_PERR_INT_ENABLE    0
#define V_PERR_INT_ENABLE(x) ((x) << S_PERR_INT_ENABLE)
#define F_PERR_INT_ENABLE    V_PERR_INT_ENABLE(1U)

#define A_MC_INT_CAUSE 0x7518

#define S_ECC_UE_INT_CAUSE    2
#define V_ECC_UE_INT_CAUSE(x) ((x) << S_ECC_UE_INT_CAUSE)
#define F_ECC_UE_INT_CAUSE    V_ECC_UE_INT_CAUSE(1U)

#define S_ECC_CE_INT_CAUSE    1
#define V_ECC_CE_INT_CAUSE(x) ((x) << S_ECC_CE_INT_CAUSE)
#define F_ECC_CE_INT_CAUSE    V_ECC_CE_INT_CAUSE(1U)

#define S_PERR_INT_CAUSE    0
#define V_PERR_INT_CAUSE(x) ((x) << S_PERR_INT_CAUSE)
#define F_PERR_INT_CAUSE    V_PERR_INT_CAUSE(1U)

#define A_MC_ECC_STATUS 0x751c

#define S_ECC_CECNT    16
#define M_ECC_CECNT    0xffffU
#define V_ECC_CECNT(x) ((x) << S_ECC_CECNT)
#define G_ECC_CECNT(x) (((x) >> S_ECC_CECNT) & M_ECC_CECNT)

#define S_ECC_UECNT    0
#define M_ECC_UECNT    0xffffU
#define V_ECC_UECNT(x) ((x) << S_ECC_UECNT)
#define G_ECC_UECNT(x) (((x) >> S_ECC_UECNT) & M_ECC_UECNT)

#define A_MC_PHY_CTRL 0x7520

#define S_CTLPHYRR    0
#define V_CTLPHYRR(x) ((x) << S_CTLPHYRR)
#define F_CTLPHYRR    V_CTLPHYRR(1U)

#define A_MC_STATIC_CFG_STATUS 0x7524

#define S_STATIC_MODE    9
#define V_STATIC_MODE(x) ((x) << S_STATIC_MODE)
#define F_STATIC_MODE    V_STATIC_MODE(1U)

#define S_STATIC_DEN    6
#define M_STATIC_DEN    0x7U
#define V_STATIC_DEN(x) ((x) << S_STATIC_DEN)
#define G_STATIC_DEN(x) (((x) >> S_STATIC_DEN) & M_STATIC_DEN)

#define S_STATIC_ORG    5
#define V_STATIC_ORG(x) ((x) << S_STATIC_ORG)
#define F_STATIC_ORG    V_STATIC_ORG(1U)

#define S_STATIC_RKS    4
#define V_STATIC_RKS(x) ((x) << S_STATIC_RKS)
#define F_STATIC_RKS    V_STATIC_RKS(1U)

#define S_STATIC_WIDTH    1
#define M_STATIC_WIDTH    0x7U
#define V_STATIC_WIDTH(x) ((x) << S_STATIC_WIDTH)
#define G_STATIC_WIDTH(x) (((x) >> S_STATIC_WIDTH) & M_STATIC_WIDTH)

#define S_STATIC_SLOW    0
#define V_STATIC_SLOW(x) ((x) << S_STATIC_SLOW)
#define F_STATIC_SLOW    V_STATIC_SLOW(1U)

#define A_MC_CORE_PCTL_STAT 0x7528

#define S_PCTL_ACCESS_STAT    0
#define M_PCTL_ACCESS_STAT    0x7U
#define V_PCTL_ACCESS_STAT(x) ((x) << S_PCTL_ACCESS_STAT)
#define G_PCTL_ACCESS_STAT(x) (((x) >> S_PCTL_ACCESS_STAT) & M_PCTL_ACCESS_STAT)

#define A_MC_DEBUG_CNT 0x752c

#define S_WDATA_OCNT    8
#define M_WDATA_OCNT    0x1fU
#define V_WDATA_OCNT(x) ((x) << S_WDATA_OCNT)
#define G_WDATA_OCNT(x) (((x) >> S_WDATA_OCNT) & M_WDATA_OCNT)

#define S_RDATA_OCNT    0
#define M_RDATA_OCNT    0x1fU
#define V_RDATA_OCNT(x) ((x) << S_RDATA_OCNT)
#define G_RDATA_OCNT(x) (((x) >> S_RDATA_OCNT) & M_RDATA_OCNT)

#define A_MC_BONUS 0x7530
#define A_MC_BIST_CMD 0x7600

#define S_START_BIST    31
#define V_START_BIST(x) ((x) << S_START_BIST)
#define F_START_BIST    V_START_BIST(1U)

#define S_BIST_CMD_GAP    8
#define M_BIST_CMD_GAP    0xffU
#define V_BIST_CMD_GAP(x) ((x) << S_BIST_CMD_GAP)
#define G_BIST_CMD_GAP(x) (((x) >> S_BIST_CMD_GAP) & M_BIST_CMD_GAP)

#define S_BIST_OPCODE    0
#define M_BIST_OPCODE    0x3U
#define V_BIST_OPCODE(x) ((x) << S_BIST_OPCODE)
#define G_BIST_OPCODE(x) (((x) >> S_BIST_OPCODE) & M_BIST_OPCODE)

#define A_MC_BIST_CMD_ADDR 0x7604
#define A_MC_BIST_CMD_LEN 0x7608
#define A_MC_BIST_DATA_PATTERN 0x760c

#define S_BIST_DATA_TYPE    0
#define M_BIST_DATA_TYPE    0xfU
#define V_BIST_DATA_TYPE(x) ((x) << S_BIST_DATA_TYPE)
#define G_BIST_DATA_TYPE(x) (((x) >> S_BIST_DATA_TYPE) & M_BIST_DATA_TYPE)

#define A_MC_BIST_USER_WDATA0 0x7614
#define A_MC_BIST_USER_WDATA1 0x7618
#define A_MC_BIST_USER_WDATA2 0x761c

#define S_USER_DATA2    0
#define M_USER_DATA2    0xffU
#define V_USER_DATA2(x) ((x) << S_USER_DATA2)
#define G_USER_DATA2(x) (((x) >> S_USER_DATA2) & M_USER_DATA2)

#define A_MC_BIST_NUM_ERR 0x7680
#define A_MC_BIST_ERR_FIRST_ADDR 0x7684
#define A_MC_BIST_STATUS_RDATA 0x7688

/* registers for module MA */
#define MA_BASE_ADDR 0x7700

#define A_MA_CLIENT0_RD_LATENCY_THRESHOLD 0x7700

#define S_THRESHOLD1    17
#define M_THRESHOLD1    0x7fffU
#define V_THRESHOLD1(x) ((x) << S_THRESHOLD1)
#define G_THRESHOLD1(x) (((x) >> S_THRESHOLD1) & M_THRESHOLD1)

#define S_THRESHOLD1_EN    16
#define V_THRESHOLD1_EN(x) ((x) << S_THRESHOLD1_EN)
#define F_THRESHOLD1_EN    V_THRESHOLD1_EN(1U)

#define S_THRESHOLD0    1
#define M_THRESHOLD0    0x7fffU
#define V_THRESHOLD0(x) ((x) << S_THRESHOLD0)
#define G_THRESHOLD0(x) (((x) >> S_THRESHOLD0) & M_THRESHOLD0)

#define S_THRESHOLD0_EN    0
#define V_THRESHOLD0_EN(x) ((x) << S_THRESHOLD0_EN)
#define F_THRESHOLD0_EN    V_THRESHOLD0_EN(1U)

#define A_MA_CLIENT0_WR_LATENCY_THRESHOLD 0x7704
#define A_MA_CLIENT1_RD_LATENCY_THRESHOLD 0x7708
#define A_MA_CLIENT1_WR_LATENCY_THRESHOLD 0x770c
#define A_MA_CLIENT2_RD_LATENCY_THRESHOLD 0x7710
#define A_MA_CLIENT2_WR_LATENCY_THRESHOLD 0x7714
#define A_MA_CLIENT3_RD_LATENCY_THRESHOLD 0x7718
#define A_MA_CLIENT3_WR_LATENCY_THRESHOLD 0x771c
#define A_MA_CLIENT4_RD_LATENCY_THRESHOLD 0x7720
#define A_MA_CLIENT4_WR_LATENCY_THRESHOLD 0x7724
#define A_MA_CLIENT5_RD_LATENCY_THRESHOLD 0x7728
#define A_MA_CLIENT5_WR_LATENCY_THRESHOLD 0x772c
#define A_MA_CLIENT6_RD_LATENCY_THRESHOLD 0x7730
#define A_MA_CLIENT6_WR_LATENCY_THRESHOLD 0x7734
#define A_MA_CLIENT7_RD_LATENCY_THRESHOLD 0x7738
#define A_MA_CLIENT7_WR_LATENCY_THRESHOLD 0x773c
#define A_MA_CLIENT8_RD_LATENCY_THRESHOLD 0x7740
#define A_MA_CLIENT8_WR_LATENCY_THRESHOLD 0x7744
#define A_MA_CLIENT9_RD_LATENCY_THRESHOLD 0x7748
#define A_MA_CLIENT9_WR_LATENCY_THRESHOLD 0x774c
#define A_MA_CLIENT10_RD_LATENCY_THRESHOLD 0x7750
#define A_MA_CLIENT10_WR_LATENCY_THRESHOLD 0x7754
#define A_MA_CLIENT11_RD_LATENCY_THRESHOLD 0x7758
#define A_MA_CLIENT11_WR_LATENCY_THRESHOLD 0x775c
#define A_MA_CLIENT12_RD_LATENCY_THRESHOLD 0x7760
#define A_MA_CLIENT12_WR_LATENCY_THRESHOLD 0x7764
#define A_MA_SGE_TH0_DEBUG_CNT 0x7768

#define S_DBG_READ_DATA_CNT    24
#define M_DBG_READ_DATA_CNT    0xffU
#define V_DBG_READ_DATA_CNT(x) ((x) << S_DBG_READ_DATA_CNT)
#define G_DBG_READ_DATA_CNT(x) (((x) >> S_DBG_READ_DATA_CNT) & M_DBG_READ_DATA_CNT)

#define S_DBG_READ_REQ_CNT    16
#define M_DBG_READ_REQ_CNT    0xffU
#define V_DBG_READ_REQ_CNT(x) ((x) << S_DBG_READ_REQ_CNT)
#define G_DBG_READ_REQ_CNT(x) (((x) >> S_DBG_READ_REQ_CNT) & M_DBG_READ_REQ_CNT)

#define S_DBG_WRITE_DATA_CNT    8
#define M_DBG_WRITE_DATA_CNT    0xffU
#define V_DBG_WRITE_DATA_CNT(x) ((x) << S_DBG_WRITE_DATA_CNT)
#define G_DBG_WRITE_DATA_CNT(x) (((x) >> S_DBG_WRITE_DATA_CNT) & M_DBG_WRITE_DATA_CNT)

#define S_DBG_WRITE_REQ_CNT    0
#define M_DBG_WRITE_REQ_CNT    0xffU
#define V_DBG_WRITE_REQ_CNT(x) ((x) << S_DBG_WRITE_REQ_CNT)
#define G_DBG_WRITE_REQ_CNT(x) (((x) >> S_DBG_WRITE_REQ_CNT) & M_DBG_WRITE_REQ_CNT)

#define A_MA_SGE_TH1_DEBUG_CNT 0x776c
#define A_MA_ULPTX_DEBUG_CNT 0x7770
#define A_MA_ULPRX_DEBUG_CNT 0x7774
#define A_MA_ULPTXRX_DEBUG_CNT 0x7778
#define A_MA_TP_TH0_DEBUG_CNT 0x777c
#define A_MA_TP_TH1_DEBUG_CNT 0x7780
#define A_MA_LE_DEBUG_CNT 0x7784
#define A_MA_CIM_DEBUG_CNT 0x7788
#define A_MA_PCIE_DEBUG_CNT 0x778c
#define A_MA_PMTX_DEBUG_CNT 0x7790
#define A_MA_PMRX_DEBUG_CNT 0x7794
#define A_MA_HMA_DEBUG_CNT 0x7798
#define A_MA_EDRAM0_BAR 0x77c0

#define S_EDRAM0_BASE    16
#define M_EDRAM0_BASE    0xfffU
#define V_EDRAM0_BASE(x) ((x) << S_EDRAM0_BASE)
#define G_EDRAM0_BASE(x) (((x) >> S_EDRAM0_BASE) & M_EDRAM0_BASE)

#define S_EDRAM0_SIZE    0
#define M_EDRAM0_SIZE    0xfffU
#define V_EDRAM0_SIZE(x) ((x) << S_EDRAM0_SIZE)
#define G_EDRAM0_SIZE(x) (((x) >> S_EDRAM0_SIZE) & M_EDRAM0_SIZE)

#define A_MA_EDRAM1_BAR 0x77c4

#define S_EDRAM1_BASE    16
#define M_EDRAM1_BASE    0xfffU
#define V_EDRAM1_BASE(x) ((x) << S_EDRAM1_BASE)
#define G_EDRAM1_BASE(x) (((x) >> S_EDRAM1_BASE) & M_EDRAM1_BASE)

#define S_EDRAM1_SIZE    0
#define M_EDRAM1_SIZE    0xfffU
#define V_EDRAM1_SIZE(x) ((x) << S_EDRAM1_SIZE)
#define G_EDRAM1_SIZE(x) (((x) >> S_EDRAM1_SIZE) & M_EDRAM1_SIZE)

#define A_MA_EXT_MEMORY_BAR 0x77c8

#define S_EXT_MEM_BASE    16
#define M_EXT_MEM_BASE    0xfffU
#define V_EXT_MEM_BASE(x) ((x) << S_EXT_MEM_BASE)
#define G_EXT_MEM_BASE(x) (((x) >> S_EXT_MEM_BASE) & M_EXT_MEM_BASE)

#define S_EXT_MEM_SIZE    0
#define M_EXT_MEM_SIZE    0xfffU
#define V_EXT_MEM_SIZE(x) ((x) << S_EXT_MEM_SIZE)
#define G_EXT_MEM_SIZE(x) (((x) >> S_EXT_MEM_SIZE) & M_EXT_MEM_SIZE)

#define A_MA_EXT_MEMORY0_BAR 0x77c8

#define S_EXT_MEM0_BASE    16
#define M_EXT_MEM0_BASE    0xfffU
#define V_EXT_MEM0_BASE(x) ((x) << S_EXT_MEM0_BASE)
#define G_EXT_MEM0_BASE(x) (((x) >> S_EXT_MEM0_BASE) & M_EXT_MEM0_BASE)

#define S_EXT_MEM0_SIZE    0
#define M_EXT_MEM0_SIZE    0xfffU
#define V_EXT_MEM0_SIZE(x) ((x) << S_EXT_MEM0_SIZE)
#define G_EXT_MEM0_SIZE(x) (((x) >> S_EXT_MEM0_SIZE) & M_EXT_MEM0_SIZE)

#define A_MA_HOST_MEMORY_BAR 0x77cc

#define S_HMA_BASE    16
#define M_HMA_BASE    0xfffU
#define V_HMA_BASE(x) ((x) << S_HMA_BASE)
#define G_HMA_BASE(x) (((x) >> S_HMA_BASE) & M_HMA_BASE)

#define S_HMA_SIZE    0
#define M_HMA_SIZE    0xfffU
#define V_HMA_SIZE(x) ((x) << S_HMA_SIZE)
#define G_HMA_SIZE(x) (((x) >> S_HMA_SIZE) & M_HMA_SIZE)

#define A_MA_EXT_MEM_PAGE_SIZE 0x77d0

#define S_BRC_MODE    2
#define V_BRC_MODE(x) ((x) << S_BRC_MODE)
#define F_BRC_MODE    V_BRC_MODE(1U)

#define S_EXT_MEM_PAGE_SIZE    0
#define M_EXT_MEM_PAGE_SIZE    0x3U
#define V_EXT_MEM_PAGE_SIZE(x) ((x) << S_EXT_MEM_PAGE_SIZE)
#define G_EXT_MEM_PAGE_SIZE(x) (((x) >> S_EXT_MEM_PAGE_SIZE) & M_EXT_MEM_PAGE_SIZE)

#define S_BRC_MODE1    6
#define V_BRC_MODE1(x) ((x) << S_BRC_MODE1)
#define F_BRC_MODE1    V_BRC_MODE1(1U)

#define S_EXT_MEM_PAGE_SIZE1    4
#define M_EXT_MEM_PAGE_SIZE1    0x3U
#define V_EXT_MEM_PAGE_SIZE1(x) ((x) << S_EXT_MEM_PAGE_SIZE1)
#define G_EXT_MEM_PAGE_SIZE1(x) (((x) >> S_EXT_MEM_PAGE_SIZE1) & M_EXT_MEM_PAGE_SIZE1)

#define A_MA_ARB_CTRL 0x77d4

#define S_DIS_PAGE_HINT    1
#define V_DIS_PAGE_HINT(x) ((x) << S_DIS_PAGE_HINT)
#define F_DIS_PAGE_HINT    V_DIS_PAGE_HINT(1U)

#define S_DIS_ADV_ARB    0
#define V_DIS_ADV_ARB(x) ((x) << S_DIS_ADV_ARB)
#define F_DIS_ADV_ARB    V_DIS_ADV_ARB(1U)

#define S_DIS_BANK_FAIR    2
#define V_DIS_BANK_FAIR(x) ((x) << S_DIS_BANK_FAIR)
#define F_DIS_BANK_FAIR    V_DIS_BANK_FAIR(1U)

#define A_MA_TARGET_MEM_ENABLE 0x77d8

#define S_HMA_ENABLE    3
#define V_HMA_ENABLE(x) ((x) << S_HMA_ENABLE)
#define F_HMA_ENABLE    V_HMA_ENABLE(1U)

#define S_EXT_MEM_ENABLE    2
#define V_EXT_MEM_ENABLE(x) ((x) << S_EXT_MEM_ENABLE)
#define F_EXT_MEM_ENABLE    V_EXT_MEM_ENABLE(1U)

#define S_EDRAM1_ENABLE    1
#define V_EDRAM1_ENABLE(x) ((x) << S_EDRAM1_ENABLE)
#define F_EDRAM1_ENABLE    V_EDRAM1_ENABLE(1U)

#define S_EDRAM0_ENABLE    0
#define V_EDRAM0_ENABLE(x) ((x) << S_EDRAM0_ENABLE)
#define F_EDRAM0_ENABLE    V_EDRAM0_ENABLE(1U)

#define S_HMA_MUX    5
#define V_HMA_MUX(x) ((x) << S_HMA_MUX)
#define F_HMA_MUX    V_HMA_MUX(1U)

#define S_EXT_MEM1_ENABLE    4
#define V_EXT_MEM1_ENABLE(x) ((x) << S_EXT_MEM1_ENABLE)
#define F_EXT_MEM1_ENABLE    V_EXT_MEM1_ENABLE(1U)

#define S_EXT_MEM0_ENABLE    2
#define V_EXT_MEM0_ENABLE(x) ((x) << S_EXT_MEM0_ENABLE)
#define F_EXT_MEM0_ENABLE    V_EXT_MEM0_ENABLE(1U)

#define A_MA_INT_ENABLE 0x77dc

#define S_MEM_PERR_INT_ENABLE    1
#define V_MEM_PERR_INT_ENABLE(x) ((x) << S_MEM_PERR_INT_ENABLE)
#define F_MEM_PERR_INT_ENABLE    V_MEM_PERR_INT_ENABLE(1U)

#define S_MEM_WRAP_INT_ENABLE    0
#define V_MEM_WRAP_INT_ENABLE(x) ((x) << S_MEM_WRAP_INT_ENABLE)
#define F_MEM_WRAP_INT_ENABLE    V_MEM_WRAP_INT_ENABLE(1U)

#define S_MEM_TO_INT_ENABLE    2
#define V_MEM_TO_INT_ENABLE(x) ((x) << S_MEM_TO_INT_ENABLE)
#define F_MEM_TO_INT_ENABLE    V_MEM_TO_INT_ENABLE(1U)

#define A_MA_INT_CAUSE 0x77e0

#define S_MEM_PERR_INT_CAUSE    1
#define V_MEM_PERR_INT_CAUSE(x) ((x) << S_MEM_PERR_INT_CAUSE)
#define F_MEM_PERR_INT_CAUSE    V_MEM_PERR_INT_CAUSE(1U)

#define S_MEM_WRAP_INT_CAUSE    0
#define V_MEM_WRAP_INT_CAUSE(x) ((x) << S_MEM_WRAP_INT_CAUSE)
#define F_MEM_WRAP_INT_CAUSE    V_MEM_WRAP_INT_CAUSE(1U)

#define S_MEM_TO_INT_CAUSE    2
#define V_MEM_TO_INT_CAUSE(x) ((x) << S_MEM_TO_INT_CAUSE)
#define F_MEM_TO_INT_CAUSE    V_MEM_TO_INT_CAUSE(1U)

#define A_MA_INT_WRAP_STATUS 0x77e4

#define S_MEM_WRAP_ADDRESS    4
#define M_MEM_WRAP_ADDRESS    0xfffffffU
#define V_MEM_WRAP_ADDRESS(x) ((x) << S_MEM_WRAP_ADDRESS)
#define G_MEM_WRAP_ADDRESS(x) (((x) >> S_MEM_WRAP_ADDRESS) & M_MEM_WRAP_ADDRESS)

#define S_MEM_WRAP_CLIENT_NUM    0
#define M_MEM_WRAP_CLIENT_NUM    0xfU
#define V_MEM_WRAP_CLIENT_NUM(x) ((x) << S_MEM_WRAP_CLIENT_NUM)
#define G_MEM_WRAP_CLIENT_NUM(x) (((x) >> S_MEM_WRAP_CLIENT_NUM) & M_MEM_WRAP_CLIENT_NUM)

#define A_MA_TP_THREAD1_MAPPER 0x77e8

#define S_TP_THREAD1_EN    0
#define M_TP_THREAD1_EN    0xffU
#define V_TP_THREAD1_EN(x) ((x) << S_TP_THREAD1_EN)
#define G_TP_THREAD1_EN(x) (((x) >> S_TP_THREAD1_EN) & M_TP_THREAD1_EN)

#define A_MA_SGE_THREAD1_MAPPER 0x77ec

#define S_SGE_THREAD1_EN    0
#define M_SGE_THREAD1_EN    0xffU
#define V_SGE_THREAD1_EN(x) ((x) << S_SGE_THREAD1_EN)
#define G_SGE_THREAD1_EN(x) (((x) >> S_SGE_THREAD1_EN) & M_SGE_THREAD1_EN)

#define A_MA_PARITY_ERROR_ENABLE 0x77f0

#define S_TP_DMARBT_PAR_ERROR_EN    31
#define V_TP_DMARBT_PAR_ERROR_EN(x) ((x) << S_TP_DMARBT_PAR_ERROR_EN)
#define F_TP_DMARBT_PAR_ERROR_EN    V_TP_DMARBT_PAR_ERROR_EN(1U)

#define S_LOGIC_FIFO_PAR_ERROR_EN    30
#define V_LOGIC_FIFO_PAR_ERROR_EN(x) ((x) << S_LOGIC_FIFO_PAR_ERROR_EN)
#define F_LOGIC_FIFO_PAR_ERROR_EN    V_LOGIC_FIFO_PAR_ERROR_EN(1U)

#define S_ARB3_PAR_WRQUEUE_ERROR_EN    29
#define V_ARB3_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB3_PAR_WRQUEUE_ERROR_EN)
#define F_ARB3_PAR_WRQUEUE_ERROR_EN    V_ARB3_PAR_WRQUEUE_ERROR_EN(1U)

#define S_ARB2_PAR_WRQUEUE_ERROR_EN    28
#define V_ARB2_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB2_PAR_WRQUEUE_ERROR_EN)
#define F_ARB2_PAR_WRQUEUE_ERROR_EN    V_ARB2_PAR_WRQUEUE_ERROR_EN(1U)

#define S_ARB1_PAR_WRQUEUE_ERROR_EN    27
#define V_ARB1_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB1_PAR_WRQUEUE_ERROR_EN)
#define F_ARB1_PAR_WRQUEUE_ERROR_EN    V_ARB1_PAR_WRQUEUE_ERROR_EN(1U)

#define S_ARB0_PAR_WRQUEUE_ERROR_EN    26
#define V_ARB0_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB0_PAR_WRQUEUE_ERROR_EN)
#define F_ARB0_PAR_WRQUEUE_ERROR_EN    V_ARB0_PAR_WRQUEUE_ERROR_EN(1U)

#define S_ARB3_PAR_RDQUEUE_ERROR_EN    25
#define V_ARB3_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB3_PAR_RDQUEUE_ERROR_EN)
#define F_ARB3_PAR_RDQUEUE_ERROR_EN    V_ARB3_PAR_RDQUEUE_ERROR_EN(1U)

#define S_ARB2_PAR_RDQUEUE_ERROR_EN    24
#define V_ARB2_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB2_PAR_RDQUEUE_ERROR_EN)
#define F_ARB2_PAR_RDQUEUE_ERROR_EN    V_ARB2_PAR_RDQUEUE_ERROR_EN(1U)

#define S_ARB1_PAR_RDQUEUE_ERROR_EN    23
#define V_ARB1_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB1_PAR_RDQUEUE_ERROR_EN)
#define F_ARB1_PAR_RDQUEUE_ERROR_EN    V_ARB1_PAR_RDQUEUE_ERROR_EN(1U)

#define S_ARB0_PAR_RDQUEUE_ERROR_EN    22
#define V_ARB0_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB0_PAR_RDQUEUE_ERROR_EN)
#define F_ARB0_PAR_RDQUEUE_ERROR_EN    V_ARB0_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL10_PAR_WRQUEUE_ERROR_EN    21
#define V_CL10_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL10_PAR_WRQUEUE_ERROR_EN)
#define F_CL10_PAR_WRQUEUE_ERROR_EN    V_CL10_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL9_PAR_WRQUEUE_ERROR_EN    20
#define V_CL9_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL9_PAR_WRQUEUE_ERROR_EN)
#define F_CL9_PAR_WRQUEUE_ERROR_EN    V_CL9_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL8_PAR_WRQUEUE_ERROR_EN    19
#define V_CL8_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL8_PAR_WRQUEUE_ERROR_EN)
#define F_CL8_PAR_WRQUEUE_ERROR_EN    V_CL8_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL7_PAR_WRQUEUE_ERROR_EN    18
#define V_CL7_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL7_PAR_WRQUEUE_ERROR_EN)
#define F_CL7_PAR_WRQUEUE_ERROR_EN    V_CL7_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL6_PAR_WRQUEUE_ERROR_EN    17
#define V_CL6_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL6_PAR_WRQUEUE_ERROR_EN)
#define F_CL6_PAR_WRQUEUE_ERROR_EN    V_CL6_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL5_PAR_WRQUEUE_ERROR_EN    16
#define V_CL5_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL5_PAR_WRQUEUE_ERROR_EN)
#define F_CL5_PAR_WRQUEUE_ERROR_EN    V_CL5_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL4_PAR_WRQUEUE_ERROR_EN    15
#define V_CL4_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL4_PAR_WRQUEUE_ERROR_EN)
#define F_CL4_PAR_WRQUEUE_ERROR_EN    V_CL4_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL3_PAR_WRQUEUE_ERROR_EN    14
#define V_CL3_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL3_PAR_WRQUEUE_ERROR_EN)
#define F_CL3_PAR_WRQUEUE_ERROR_EN    V_CL3_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL2_PAR_WRQUEUE_ERROR_EN    13
#define V_CL2_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL2_PAR_WRQUEUE_ERROR_EN)
#define F_CL2_PAR_WRQUEUE_ERROR_EN    V_CL2_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL1_PAR_WRQUEUE_ERROR_EN    12
#define V_CL1_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL1_PAR_WRQUEUE_ERROR_EN)
#define F_CL1_PAR_WRQUEUE_ERROR_EN    V_CL1_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL0_PAR_WRQUEUE_ERROR_EN    11
#define V_CL0_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL0_PAR_WRQUEUE_ERROR_EN)
#define F_CL0_PAR_WRQUEUE_ERROR_EN    V_CL0_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL10_PAR_RDQUEUE_ERROR_EN    10
#define V_CL10_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL10_PAR_RDQUEUE_ERROR_EN)
#define F_CL10_PAR_RDQUEUE_ERROR_EN    V_CL10_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL9_PAR_RDQUEUE_ERROR_EN    9
#define V_CL9_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL9_PAR_RDQUEUE_ERROR_EN)
#define F_CL9_PAR_RDQUEUE_ERROR_EN    V_CL9_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL8_PAR_RDQUEUE_ERROR_EN    8
#define V_CL8_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL8_PAR_RDQUEUE_ERROR_EN)
#define F_CL8_PAR_RDQUEUE_ERROR_EN    V_CL8_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL7_PAR_RDQUEUE_ERROR_EN    7
#define V_CL7_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL7_PAR_RDQUEUE_ERROR_EN)
#define F_CL7_PAR_RDQUEUE_ERROR_EN    V_CL7_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL6_PAR_RDQUEUE_ERROR_EN    6
#define V_CL6_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL6_PAR_RDQUEUE_ERROR_EN)
#define F_CL6_PAR_RDQUEUE_ERROR_EN    V_CL6_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL5_PAR_RDQUEUE_ERROR_EN    5
#define V_CL5_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL5_PAR_RDQUEUE_ERROR_EN)
#define F_CL5_PAR_RDQUEUE_ERROR_EN    V_CL5_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL4_PAR_RDQUEUE_ERROR_EN    4
#define V_CL4_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL4_PAR_RDQUEUE_ERROR_EN)
#define F_CL4_PAR_RDQUEUE_ERROR_EN    V_CL4_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL3_PAR_RDQUEUE_ERROR_EN    3
#define V_CL3_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL3_PAR_RDQUEUE_ERROR_EN)
#define F_CL3_PAR_RDQUEUE_ERROR_EN    V_CL3_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL2_PAR_RDQUEUE_ERROR_EN    2
#define V_CL2_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL2_PAR_RDQUEUE_ERROR_EN)
#define F_CL2_PAR_RDQUEUE_ERROR_EN    V_CL2_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL1_PAR_RDQUEUE_ERROR_EN    1
#define V_CL1_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL1_PAR_RDQUEUE_ERROR_EN)
#define F_CL1_PAR_RDQUEUE_ERROR_EN    V_CL1_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL0_PAR_RDQUEUE_ERROR_EN    0
#define V_CL0_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL0_PAR_RDQUEUE_ERROR_EN)
#define F_CL0_PAR_RDQUEUE_ERROR_EN    V_CL0_PAR_RDQUEUE_ERROR_EN(1U)

#define A_MA_PARITY_ERROR_ENABLE1 0x77f0
#define A_MA_PARITY_ERROR_STATUS 0x77f4

#define S_TP_DMARBT_PAR_ERROR    31
#define V_TP_DMARBT_PAR_ERROR(x) ((x) << S_TP_DMARBT_PAR_ERROR)
#define F_TP_DMARBT_PAR_ERROR    V_TP_DMARBT_PAR_ERROR(1U)

#define S_LOGIC_FIFO_PAR_ERROR    30
#define V_LOGIC_FIFO_PAR_ERROR(x) ((x) << S_LOGIC_FIFO_PAR_ERROR)
#define F_LOGIC_FIFO_PAR_ERROR    V_LOGIC_FIFO_PAR_ERROR(1U)

#define S_ARB3_PAR_WRQUEUE_ERROR    29
#define V_ARB3_PAR_WRQUEUE_ERROR(x) ((x) << S_ARB3_PAR_WRQUEUE_ERROR)
#define F_ARB3_PAR_WRQUEUE_ERROR    V_ARB3_PAR_WRQUEUE_ERROR(1U)

#define S_ARB2_PAR_WRQUEUE_ERROR    28
#define V_ARB2_PAR_WRQUEUE_ERROR(x) ((x) << S_ARB2_PAR_WRQUEUE_ERROR)
#define F_ARB2_PAR_WRQUEUE_ERROR    V_ARB2_PAR_WRQUEUE_ERROR(1U)

#define S_ARB1_PAR_WRQUEUE_ERROR    27
#define V_ARB1_PAR_WRQUEUE_ERROR(x) ((x) << S_ARB1_PAR_WRQUEUE_ERROR)
#define F_ARB1_PAR_WRQUEUE_ERROR    V_ARB1_PAR_WRQUEUE_ERROR(1U)

#define S_ARB0_PAR_WRQUEUE_ERROR    26
#define V_ARB0_PAR_WRQUEUE_ERROR(x) ((x) << S_ARB0_PAR_WRQUEUE_ERROR)
#define F_ARB0_PAR_WRQUEUE_ERROR    V_ARB0_PAR_WRQUEUE_ERROR(1U)

#define S_ARB3_PAR_RDQUEUE_ERROR    25
#define V_ARB3_PAR_RDQUEUE_ERROR(x) ((x) << S_ARB3_PAR_RDQUEUE_ERROR)
#define F_ARB3_PAR_RDQUEUE_ERROR    V_ARB3_PAR_RDQUEUE_ERROR(1U)

#define S_ARB2_PAR_RDQUEUE_ERROR    24
#define V_ARB2_PAR_RDQUEUE_ERROR(x) ((x) << S_ARB2_PAR_RDQUEUE_ERROR)
#define F_ARB2_PAR_RDQUEUE_ERROR    V_ARB2_PAR_RDQUEUE_ERROR(1U)

#define S_ARB1_PAR_RDQUEUE_ERROR    23
#define V_ARB1_PAR_RDQUEUE_ERROR(x) ((x) << S_ARB1_PAR_RDQUEUE_ERROR)
#define F_ARB1_PAR_RDQUEUE_ERROR    V_ARB1_PAR_RDQUEUE_ERROR(1U)

#define S_ARB0_PAR_RDQUEUE_ERROR    22
#define V_ARB0_PAR_RDQUEUE_ERROR(x) ((x) << S_ARB0_PAR_RDQUEUE_ERROR)
#define F_ARB0_PAR_RDQUEUE_ERROR    V_ARB0_PAR_RDQUEUE_ERROR(1U)

#define S_CL10_PAR_WRQUEUE_ERROR    21
#define V_CL10_PAR_WRQUEUE_ERROR(x) ((x) << S_CL10_PAR_WRQUEUE_ERROR)
#define F_CL10_PAR_WRQUEUE_ERROR    V_CL10_PAR_WRQUEUE_ERROR(1U)

#define S_CL9_PAR_WRQUEUE_ERROR    20
#define V_CL9_PAR_WRQUEUE_ERROR(x) ((x) << S_CL9_PAR_WRQUEUE_ERROR)
#define F_CL9_PAR_WRQUEUE_ERROR    V_CL9_PAR_WRQUEUE_ERROR(1U)

#define S_CL8_PAR_WRQUEUE_ERROR    19
#define V_CL8_PAR_WRQUEUE_ERROR(x) ((x) << S_CL8_PAR_WRQUEUE_ERROR)
#define F_CL8_PAR_WRQUEUE_ERROR    V_CL8_PAR_WRQUEUE_ERROR(1U)

#define S_CL7_PAR_WRQUEUE_ERROR    18
#define V_CL7_PAR_WRQUEUE_ERROR(x) ((x) << S_CL7_PAR_WRQUEUE_ERROR)
#define F_CL7_PAR_WRQUEUE_ERROR    V_CL7_PAR_WRQUEUE_ERROR(1U)

#define S_CL6_PAR_WRQUEUE_ERROR    17
#define V_CL6_PAR_WRQUEUE_ERROR(x) ((x) << S_CL6_PAR_WRQUEUE_ERROR)
#define F_CL6_PAR_WRQUEUE_ERROR    V_CL6_PAR_WRQUEUE_ERROR(1U)

#define S_CL5_PAR_WRQUEUE_ERROR    16
#define V_CL5_PAR_WRQUEUE_ERROR(x) ((x) << S_CL5_PAR_WRQUEUE_ERROR)
#define F_CL5_PAR_WRQUEUE_ERROR    V_CL5_PAR_WRQUEUE_ERROR(1U)

#define S_CL4_PAR_WRQUEUE_ERROR    15
#define V_CL4_PAR_WRQUEUE_ERROR(x) ((x) << S_CL4_PAR_WRQUEUE_ERROR)
#define F_CL4_PAR_WRQUEUE_ERROR    V_CL4_PAR_WRQUEUE_ERROR(1U)

#define S_CL3_PAR_WRQUEUE_ERROR    14
#define V_CL3_PAR_WRQUEUE_ERROR(x) ((x) << S_CL3_PAR_WRQUEUE_ERROR)
#define F_CL3_PAR_WRQUEUE_ERROR    V_CL3_PAR_WRQUEUE_ERROR(1U)

#define S_CL2_PAR_WRQUEUE_ERROR    13
#define V_CL2_PAR_WRQUEUE_ERROR(x) ((x) << S_CL2_PAR_WRQUEUE_ERROR)
#define F_CL2_PAR_WRQUEUE_ERROR    V_CL2_PAR_WRQUEUE_ERROR(1U)

#define S_CL1_PAR_WRQUEUE_ERROR    12
#define V_CL1_PAR_WRQUEUE_ERROR(x) ((x) << S_CL1_PAR_WRQUEUE_ERROR)
#define F_CL1_PAR_WRQUEUE_ERROR    V_CL1_PAR_WRQUEUE_ERROR(1U)

#define S_CL0_PAR_WRQUEUE_ERROR    11
#define V_CL0_PAR_WRQUEUE_ERROR(x) ((x) << S_CL0_PAR_WRQUEUE_ERROR)
#define F_CL0_PAR_WRQUEUE_ERROR    V_CL0_PAR_WRQUEUE_ERROR(1U)

#define S_CL10_PAR_RDQUEUE_ERROR    10
#define V_CL10_PAR_RDQUEUE_ERROR(x) ((x) << S_CL10_PAR_RDQUEUE_ERROR)
#define F_CL10_PAR_RDQUEUE_ERROR    V_CL10_PAR_RDQUEUE_ERROR(1U)

#define S_CL9_PAR_RDQUEUE_ERROR    9
#define V_CL9_PAR_RDQUEUE_ERROR(x) ((x) << S_CL9_PAR_RDQUEUE_ERROR)
#define F_CL9_PAR_RDQUEUE_ERROR    V_CL9_PAR_RDQUEUE_ERROR(1U)

#define S_CL8_PAR_RDQUEUE_ERROR    8
#define V_CL8_PAR_RDQUEUE_ERROR(x) ((x) << S_CL8_PAR_RDQUEUE_ERROR)
#define F_CL8_PAR_RDQUEUE_ERROR    V_CL8_PAR_RDQUEUE_ERROR(1U)

#define S_CL7_PAR_RDQUEUE_ERROR    7
#define V_CL7_PAR_RDQUEUE_ERROR(x) ((x) << S_CL7_PAR_RDQUEUE_ERROR)
#define F_CL7_PAR_RDQUEUE_ERROR    V_CL7_PAR_RDQUEUE_ERROR(1U)

#define S_CL6_PAR_RDQUEUE_ERROR    6
#define V_CL6_PAR_RDQUEUE_ERROR(x) ((x) << S_CL6_PAR_RDQUEUE_ERROR)
#define F_CL6_PAR_RDQUEUE_ERROR    V_CL6_PAR_RDQUEUE_ERROR(1U)

#define S_CL5_PAR_RDQUEUE_ERROR    5
#define V_CL5_PAR_RDQUEUE_ERROR(x) ((x) << S_CL5_PAR_RDQUEUE_ERROR)
#define F_CL5_PAR_RDQUEUE_ERROR    V_CL5_PAR_RDQUEUE_ERROR(1U)

#define S_CL4_PAR_RDQUEUE_ERROR    4
#define V_CL4_PAR_RDQUEUE_ERROR(x) ((x) << S_CL4_PAR_RDQUEUE_ERROR)
#define F_CL4_PAR_RDQUEUE_ERROR    V_CL4_PAR_RDQUEUE_ERROR(1U)

#define S_CL3_PAR_RDQUEUE_ERROR    3
#define V_CL3_PAR_RDQUEUE_ERROR(x) ((x) << S_CL3_PAR_RDQUEUE_ERROR)
#define F_CL3_PAR_RDQUEUE_ERROR    V_CL3_PAR_RDQUEUE_ERROR(1U)

#define S_CL2_PAR_RDQUEUE_ERROR    2
#define V_CL2_PAR_RDQUEUE_ERROR(x) ((x) << S_CL2_PAR_RDQUEUE_ERROR)
#define F_CL2_PAR_RDQUEUE_ERROR    V_CL2_PAR_RDQUEUE_ERROR(1U)

#define S_CL1_PAR_RDQUEUE_ERROR    1
#define V_CL1_PAR_RDQUEUE_ERROR(x) ((x) << S_CL1_PAR_RDQUEUE_ERROR)
#define F_CL1_PAR_RDQUEUE_ERROR    V_CL1_PAR_RDQUEUE_ERROR(1U)

#define S_CL0_PAR_RDQUEUE_ERROR    0
#define V_CL0_PAR_RDQUEUE_ERROR(x) ((x) << S_CL0_PAR_RDQUEUE_ERROR)
#define F_CL0_PAR_RDQUEUE_ERROR    V_CL0_PAR_RDQUEUE_ERROR(1U)

#define A_MA_PARITY_ERROR_STATUS1 0x77f4
#define A_MA_SGE_PCIE_COHERANCY_CTRL 0x77f8

#define S_BONUS_REG    6
#define M_BONUS_REG    0x3ffffffU
#define V_BONUS_REG(x) ((x) << S_BONUS_REG)
#define G_BONUS_REG(x) (((x) >> S_BONUS_REG) & M_BONUS_REG)

#define S_COHERANCY_CMD_TYPE    4
#define M_COHERANCY_CMD_TYPE    0x3U
#define V_COHERANCY_CMD_TYPE(x) ((x) << S_COHERANCY_CMD_TYPE)
#define G_COHERANCY_CMD_TYPE(x) (((x) >> S_COHERANCY_CMD_TYPE) & M_COHERANCY_CMD_TYPE)

#define S_COHERANCY_THREAD_NUM    1
#define M_COHERANCY_THREAD_NUM    0x7U
#define V_COHERANCY_THREAD_NUM(x) ((x) << S_COHERANCY_THREAD_NUM)
#define G_COHERANCY_THREAD_NUM(x) (((x) >> S_COHERANCY_THREAD_NUM) & M_COHERANCY_THREAD_NUM)

#define S_COHERANCY_ENABLE    0
#define V_COHERANCY_ENABLE(x) ((x) << S_COHERANCY_ENABLE)
#define F_COHERANCY_ENABLE    V_COHERANCY_ENABLE(1U)

#define A_MA_ERROR_ENABLE 0x77fc

#define S_UE_ENABLE    0
#define V_UE_ENABLE(x) ((x) << S_UE_ENABLE)
#define F_UE_ENABLE    V_UE_ENABLE(1U)

#define S_FUTURE_EXPANSION    1
#define M_FUTURE_EXPANSION    0x7fffffffU
#define V_FUTURE_EXPANSION(x) ((x) << S_FUTURE_EXPANSION)
#define G_FUTURE_EXPANSION(x) (((x) >> S_FUTURE_EXPANSION) & M_FUTURE_EXPANSION)

#define A_MA_PARITY_ERROR_ENABLE2 0x7800

#define S_ARB4_PAR_WRQUEUE_ERROR_EN    1
#define V_ARB4_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB4_PAR_WRQUEUE_ERROR_EN)
#define F_ARB4_PAR_WRQUEUE_ERROR_EN    V_ARB4_PAR_WRQUEUE_ERROR_EN(1U)

#define S_ARB4_PAR_RDQUEUE_ERROR_EN    0
#define V_ARB4_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB4_PAR_RDQUEUE_ERROR_EN)
#define F_ARB4_PAR_RDQUEUE_ERROR_EN    V_ARB4_PAR_RDQUEUE_ERROR_EN(1U)

#define A_MA_PARITY_ERROR_STATUS2 0x7804

#define S_ARB4_PAR_WRQUEUE_ERROR    1
#define V_ARB4_PAR_WRQUEUE_ERROR(x) ((x) << S_ARB4_PAR_WRQUEUE_ERROR)
#define F_ARB4_PAR_WRQUEUE_ERROR    V_ARB4_PAR_WRQUEUE_ERROR(1U)

#define S_ARB4_PAR_RDQUEUE_ERROR    0
#define V_ARB4_PAR_RDQUEUE_ERROR(x) ((x) << S_ARB4_PAR_RDQUEUE_ERROR)
#define F_ARB4_PAR_RDQUEUE_ERROR    V_ARB4_PAR_RDQUEUE_ERROR(1U)

#define A_MA_EXT_MEMORY1_BAR 0x7808

#define S_EXT_MEM1_BASE    16
#define M_EXT_MEM1_BASE    0xfffU
#define V_EXT_MEM1_BASE(x) ((x) << S_EXT_MEM1_BASE)
#define G_EXT_MEM1_BASE(x) (((x) >> S_EXT_MEM1_BASE) & M_EXT_MEM1_BASE)

#define S_EXT_MEM1_SIZE    0
#define M_EXT_MEM1_SIZE    0xfffU
#define V_EXT_MEM1_SIZE(x) ((x) << S_EXT_MEM1_SIZE)
#define G_EXT_MEM1_SIZE(x) (((x) >> S_EXT_MEM1_SIZE) & M_EXT_MEM1_SIZE)

#define A_MA_PMTX_THROTTLE 0x780c

#define S_FL_ENABLE    31
#define V_FL_ENABLE(x) ((x) << S_FL_ENABLE)
#define F_FL_ENABLE    V_FL_ENABLE(1U)

#define S_FL_LIMIT    0
#define M_FL_LIMIT    0xffU
#define V_FL_LIMIT(x) ((x) << S_FL_LIMIT)
#define G_FL_LIMIT(x) (((x) >> S_FL_LIMIT) & M_FL_LIMIT)

#define A_MA_PMRX_THROTTLE 0x7810
#define A_MA_SGE_TH0_WRDATA_CNT 0x7814
#define A_MA_SGE_TH1_WRDATA_CNT 0x7818
#define A_MA_ULPTX_WRDATA_CNT 0x781c
#define A_MA_ULPRX_WRDATA_CNT 0x7820
#define A_MA_ULPTXRX_WRDATA_CNT 0x7824
#define A_MA_TP_TH0_WRDATA_CNT 0x7828
#define A_MA_TP_TH1_WRDATA_CNT 0x782c
#define A_MA_LE_WRDATA_CNT 0x7830
#define A_MA_CIM_WRDATA_CNT 0x7834
#define A_MA_PCIE_WRDATA_CNT 0x7838
#define A_MA_PMTX_WRDATA_CNT 0x783c
#define A_MA_PMRX_WRDATA_CNT 0x7840
#define A_MA_HMA_WRDATA_CNT 0x7844
#define A_MA_SGE_TH0_RDDATA_CNT 0x7848
#define A_MA_SGE_TH1_RDDATA_CNT 0x784c
#define A_MA_ULPTX_RDDATA_CNT 0x7850
#define A_MA_ULPRX_RDDATA_CNT 0x7854
#define A_MA_ULPTXRX_RDDATA_CNT 0x7858
#define A_MA_TP_TH0_RDDATA_CNT 0x785c
#define A_MA_TP_TH1_RDDATA_CNT 0x7860
#define A_MA_LE_RDDATA_CNT 0x7864
#define A_MA_CIM_RDDATA_CNT 0x7868
#define A_MA_PCIE_RDDATA_CNT 0x786c
#define A_MA_PMTX_RDDATA_CNT 0x7870
#define A_MA_PMRX_RDDATA_CNT 0x7874
#define A_MA_HMA_RDDATA_CNT 0x7878
#define A_MA_EDRAM0_WRDATA_CNT1 0x787c
#define A_MA_EDRAM0_WRDATA_CNT0 0x7880
#define A_MA_EDRAM1_WRDATA_CNT1 0x7884
#define A_MA_EDRAM1_WRDATA_CNT0 0x7888
#define A_MA_EXT_MEMORY0_WRDATA_CNT1 0x788c
#define A_MA_EXT_MEMORY0_WRDATA_CNT0 0x7890
#define A_MA_HOST_MEMORY_WRDATA_CNT1 0x7894
#define A_MA_HOST_MEMORY_WRDATA_CNT0 0x7898
#define A_MA_EXT_MEMORY1_WRDATA_CNT1 0x789c
#define A_MA_EXT_MEMORY1_WRDATA_CNT0 0x78a0
#define A_MA_EDRAM0_RDDATA_CNT1 0x78a4
#define A_MA_EDRAM0_RDDATA_CNT0 0x78a8
#define A_MA_EDRAM1_RDDATA_CNT1 0x78ac
#define A_MA_EDRAM1_RDDATA_CNT0 0x78b0
#define A_MA_EXT_MEMORY0_RDDATA_CNT1 0x78b4
#define A_MA_EXT_MEMORY0_RDDATA_CNT0 0x78b8
#define A_MA_HOST_MEMORY_RDDATA_CNT1 0x78bc
#define A_MA_HOST_MEMORY_RDDATA_CNT0 0x78c0
#define A_MA_EXT_MEMORY1_RDDATA_CNT1 0x78c4
#define A_MA_EXT_MEMORY1_RDDATA_CNT0 0x78c8
#define A_MA_TIMEOUT_CFG 0x78cc

#define S_CLR    31
#define V_CLR(x) ((x) << S_CLR)
#define F_CLR    V_CLR(1U)

#define S_CNT_LOCK    30
#define V_CNT_LOCK(x) ((x) << S_CNT_LOCK)
#define F_CNT_LOCK    V_CNT_LOCK(1U)

#define S_WRN    24
#define V_WRN(x) ((x) << S_WRN)
#define F_WRN    V_WRN(1U)

#define S_DIR    23
#define V_DIR(x) ((x) << S_DIR)
#define F_DIR    V_DIR(1U)

#define S_TO_BUS    22
#define V_TO_BUS(x) ((x) << S_TO_BUS)
#define F_TO_BUS    V_TO_BUS(1U)

#define S_CLIENT    16
#define M_CLIENT    0xfU
#define V_CLIENT(x) ((x) << S_CLIENT)
#define G_CLIENT(x) (((x) >> S_CLIENT) & M_CLIENT)

#define S_DELAY    0
#define M_DELAY    0xffffU
#define V_DELAY(x) ((x) << S_DELAY)
#define G_DELAY(x) (((x) >> S_DELAY) & M_DELAY)

#define A_MA_TIMEOUT_CNT 0x78d0

#define S_CNT_VAL    0
#define M_CNT_VAL    0xffffU
#define V_CNT_VAL(x) ((x) << S_CNT_VAL)
#define G_CNT_VAL(x) (((x) >> S_CNT_VAL) & M_CNT_VAL)

#define A_MA_WRITE_TIMEOUT_ERROR_ENABLE 0x78d4

#define S_FUTURE_CEXPANSION    29
#define M_FUTURE_CEXPANSION    0x7U
#define V_FUTURE_CEXPANSION(x) ((x) << S_FUTURE_CEXPANSION)
#define G_FUTURE_CEXPANSION(x) (((x) >> S_FUTURE_CEXPANSION) & M_FUTURE_CEXPANSION)

#define S_CL12_WR_CMD_TO_EN    28
#define V_CL12_WR_CMD_TO_EN(x) ((x) << S_CL12_WR_CMD_TO_EN)
#define F_CL12_WR_CMD_TO_EN    V_CL12_WR_CMD_TO_EN(1U)

#define S_CL11_WR_CMD_TO_EN    27
#define V_CL11_WR_CMD_TO_EN(x) ((x) << S_CL11_WR_CMD_TO_EN)
#define F_CL11_WR_CMD_TO_EN    V_CL11_WR_CMD_TO_EN(1U)

#define S_CL10_WR_CMD_TO_EN    26
#define V_CL10_WR_CMD_TO_EN(x) ((x) << S_CL10_WR_CMD_TO_EN)
#define F_CL10_WR_CMD_TO_EN    V_CL10_WR_CMD_TO_EN(1U)

#define S_CL9_WR_CMD_TO_EN    25
#define V_CL9_WR_CMD_TO_EN(x) ((x) << S_CL9_WR_CMD_TO_EN)
#define F_CL9_WR_CMD_TO_EN    V_CL9_WR_CMD_TO_EN(1U)

#define S_CL8_WR_CMD_TO_EN    24
#define V_CL8_WR_CMD_TO_EN(x) ((x) << S_CL8_WR_CMD_TO_EN)
#define F_CL8_WR_CMD_TO_EN    V_CL8_WR_CMD_TO_EN(1U)

#define S_CL7_WR_CMD_TO_EN    23
#define V_CL7_WR_CMD_TO_EN(x) ((x) << S_CL7_WR_CMD_TO_EN)
#define F_CL7_WR_CMD_TO_EN    V_CL7_WR_CMD_TO_EN(1U)

#define S_CL6_WR_CMD_TO_EN    22
#define V_CL6_WR_CMD_TO_EN(x) ((x) << S_CL6_WR_CMD_TO_EN)
#define F_CL6_WR_CMD_TO_EN    V_CL6_WR_CMD_TO_EN(1U)

#define S_CL5_WR_CMD_TO_EN    21
#define V_CL5_WR_CMD_TO_EN(x) ((x) << S_CL5_WR_CMD_TO_EN)
#define F_CL5_WR_CMD_TO_EN    V_CL5_WR_CMD_TO_EN(1U)

#define S_CL4_WR_CMD_TO_EN    20
#define V_CL4_WR_CMD_TO_EN(x) ((x) << S_CL4_WR_CMD_TO_EN)
#define F_CL4_WR_CMD_TO_EN    V_CL4_WR_CMD_TO_EN(1U)

#define S_CL3_WR_CMD_TO_EN    19
#define V_CL3_WR_CMD_TO_EN(x) ((x) << S_CL3_WR_CMD_TO_EN)
#define F_CL3_WR_CMD_TO_EN    V_CL3_WR_CMD_TO_EN(1U)

#define S_CL2_WR_CMD_TO_EN    18
#define V_CL2_WR_CMD_TO_EN(x) ((x) << S_CL2_WR_CMD_TO_EN)
#define F_CL2_WR_CMD_TO_EN    V_CL2_WR_CMD_TO_EN(1U)

#define S_CL1_WR_CMD_TO_EN    17
#define V_CL1_WR_CMD_TO_EN(x) ((x) << S_CL1_WR_CMD_TO_EN)
#define F_CL1_WR_CMD_TO_EN    V_CL1_WR_CMD_TO_EN(1U)

#define S_CL0_WR_CMD_TO_EN    16
#define V_CL0_WR_CMD_TO_EN(x) ((x) << S_CL0_WR_CMD_TO_EN)
#define F_CL0_WR_CMD_TO_EN    V_CL0_WR_CMD_TO_EN(1U)

#define S_FUTURE_DEXPANSION    13
#define M_FUTURE_DEXPANSION    0x7U
#define V_FUTURE_DEXPANSION(x) ((x) << S_FUTURE_DEXPANSION)
#define G_FUTURE_DEXPANSION(x) (((x) >> S_FUTURE_DEXPANSION) & M_FUTURE_DEXPANSION)

#define S_CL12_WR_DATA_TO_EN    12
#define V_CL12_WR_DATA_TO_EN(x) ((x) << S_CL12_WR_DATA_TO_EN)
#define F_CL12_WR_DATA_TO_EN    V_CL12_WR_DATA_TO_EN(1U)

#define S_CL11_WR_DATA_TO_EN    11
#define V_CL11_WR_DATA_TO_EN(x) ((x) << S_CL11_WR_DATA_TO_EN)
#define F_CL11_WR_DATA_TO_EN    V_CL11_WR_DATA_TO_EN(1U)

#define S_CL10_WR_DATA_TO_EN    10
#define V_CL10_WR_DATA_TO_EN(x) ((x) << S_CL10_WR_DATA_TO_EN)
#define F_CL10_WR_DATA_TO_EN    V_CL10_WR_DATA_TO_EN(1U)

#define S_CL9_WR_DATA_TO_EN    9
#define V_CL9_WR_DATA_TO_EN(x) ((x) << S_CL9_WR_DATA_TO_EN)
#define F_CL9_WR_DATA_TO_EN    V_CL9_WR_DATA_TO_EN(1U)

#define S_CL8_WR_DATA_TO_EN    8
#define V_CL8_WR_DATA_TO_EN(x) ((x) << S_CL8_WR_DATA_TO_EN)
#define F_CL8_WR_DATA_TO_EN    V_CL8_WR_DATA_TO_EN(1U)

#define S_CL7_WR_DATA_TO_EN    7
#define V_CL7_WR_DATA_TO_EN(x) ((x) << S_CL7_WR_DATA_TO_EN)
#define F_CL7_WR_DATA_TO_EN    V_CL7_WR_DATA_TO_EN(1U)

#define S_CL6_WR_DATA_TO_EN    6
#define V_CL6_WR_DATA_TO_EN(x) ((x) << S_CL6_WR_DATA_TO_EN)
#define F_CL6_WR_DATA_TO_EN    V_CL6_WR_DATA_TO_EN(1U)

#define S_CL5_WR_DATA_TO_EN    5
#define V_CL5_WR_DATA_TO_EN(x) ((x) << S_CL5_WR_DATA_TO_EN)
#define F_CL5_WR_DATA_TO_EN    V_CL5_WR_DATA_TO_EN(1U)

#define S_CL4_WR_DATA_TO_EN    4
#define V_CL4_WR_DATA_TO_EN(x) ((x) << S_CL4_WR_DATA_TO_EN)
#define F_CL4_WR_DATA_TO_EN    V_CL4_WR_DATA_TO_EN(1U)

#define S_CL3_WR_DATA_TO_EN    3
#define V_CL3_WR_DATA_TO_EN(x) ((x) << S_CL3_WR_DATA_TO_EN)
#define F_CL3_WR_DATA_TO_EN    V_CL3_WR_DATA_TO_EN(1U)

#define S_CL2_WR_DATA_TO_EN    2
#define V_CL2_WR_DATA_TO_EN(x) ((x) << S_CL2_WR_DATA_TO_EN)
#define F_CL2_WR_DATA_TO_EN    V_CL2_WR_DATA_TO_EN(1U)

#define S_CL1_WR_DATA_TO_EN    1
#define V_CL1_WR_DATA_TO_EN(x) ((x) << S_CL1_WR_DATA_TO_EN)
#define F_CL1_WR_DATA_TO_EN    V_CL1_WR_DATA_TO_EN(1U)

#define S_CL0_WR_DATA_TO_EN    0
#define V_CL0_WR_DATA_TO_EN(x) ((x) << S_CL0_WR_DATA_TO_EN)
#define F_CL0_WR_DATA_TO_EN    V_CL0_WR_DATA_TO_EN(1U)

#define A_MA_WRITE_TIMEOUT_ERROR_STATUS 0x78d8

#define S_CL12_WR_CMD_TO_ERROR    28
#define V_CL12_WR_CMD_TO_ERROR(x) ((x) << S_CL12_WR_CMD_TO_ERROR)
#define F_CL12_WR_CMD_TO_ERROR    V_CL12_WR_CMD_TO_ERROR(1U)

#define S_CL11_WR_CMD_TO_ERROR    27
#define V_CL11_WR_CMD_TO_ERROR(x) ((x) << S_CL11_WR_CMD_TO_ERROR)
#define F_CL11_WR_CMD_TO_ERROR    V_CL11_WR_CMD_TO_ERROR(1U)

#define S_CL10_WR_CMD_TO_ERROR    26
#define V_CL10_WR_CMD_TO_ERROR(x) ((x) << S_CL10_WR_CMD_TO_ERROR)
#define F_CL10_WR_CMD_TO_ERROR    V_CL10_WR_CMD_TO_ERROR(1U)

#define S_CL9_WR_CMD_TO_ERROR    25
#define V_CL9_WR_CMD_TO_ERROR(x) ((x) << S_CL9_WR_CMD_TO_ERROR)
#define F_CL9_WR_CMD_TO_ERROR    V_CL9_WR_CMD_TO_ERROR(1U)

#define S_CL8_WR_CMD_TO_ERROR    24
#define V_CL8_WR_CMD_TO_ERROR(x) ((x) << S_CL8_WR_CMD_TO_ERROR)
#define F_CL8_WR_CMD_TO_ERROR    V_CL8_WR_CMD_TO_ERROR(1U)

#define S_CL7_WR_CMD_TO_ERROR    23
#define V_CL7_WR_CMD_TO_ERROR(x) ((x) << S_CL7_WR_CMD_TO_ERROR)
#define F_CL7_WR_CMD_TO_ERROR    V_CL7_WR_CMD_TO_ERROR(1U)

#define S_CL6_WR_CMD_TO_ERROR    22
#define V_CL6_WR_CMD_TO_ERROR(x) ((x) << S_CL6_WR_CMD_TO_ERROR)
#define F_CL6_WR_CMD_TO_ERROR    V_CL6_WR_CMD_TO_ERROR(1U)

#define S_CL5_WR_CMD_TO_ERROR    21
#define V_CL5_WR_CMD_TO_ERROR(x) ((x) << S_CL5_WR_CMD_TO_ERROR)
#define F_CL5_WR_CMD_TO_ERROR    V_CL5_WR_CMD_TO_ERROR(1U)

#define S_CL4_WR_CMD_TO_ERROR    20
#define V_CL4_WR_CMD_TO_ERROR(x) ((x) << S_CL4_WR_CMD_TO_ERROR)
#define F_CL4_WR_CMD_TO_ERROR    V_CL4_WR_CMD_TO_ERROR(1U)

#define S_CL3_WR_CMD_TO_ERROR    19
#define V_CL3_WR_CMD_TO_ERROR(x) ((x) << S_CL3_WR_CMD_TO_ERROR)
#define F_CL3_WR_CMD_TO_ERROR    V_CL3_WR_CMD_TO_ERROR(1U)

#define S_CL2_WR_CMD_TO_ERROR    18
#define V_CL2_WR_CMD_TO_ERROR(x) ((x) << S_CL2_WR_CMD_TO_ERROR)
#define F_CL2_WR_CMD_TO_ERROR    V_CL2_WR_CMD_TO_ERROR(1U)

#define S_CL1_WR_CMD_TO_ERROR    17
#define V_CL1_WR_CMD_TO_ERROR(x) ((x) << S_CL1_WR_CMD_TO_ERROR)
#define F_CL1_WR_CMD_TO_ERROR    V_CL1_WR_CMD_TO_ERROR(1U)

#define S_CL0_WR_CMD_TO_ERROR    16
#define V_CL0_WR_CMD_TO_ERROR(x) ((x) << S_CL0_WR_CMD_TO_ERROR)
#define F_CL0_WR_CMD_TO_ERROR    V_CL0_WR_CMD_TO_ERROR(1U)

#define S_CL12_WR_DATA_TO_ERROR    12
#define V_CL12_WR_DATA_TO_ERROR(x) ((x) << S_CL12_WR_DATA_TO_ERROR)
#define F_CL12_WR_DATA_TO_ERROR    V_CL12_WR_DATA_TO_ERROR(1U)

#define S_CL11_WR_DATA_TO_ERROR    11
#define V_CL11_WR_DATA_TO_ERROR(x) ((x) << S_CL11_WR_DATA_TO_ERROR)
#define F_CL11_WR_DATA_TO_ERROR    V_CL11_WR_DATA_TO_ERROR(1U)

#define S_CL10_WR_DATA_TO_ERROR    10
#define V_CL10_WR_DATA_TO_ERROR(x) ((x) << S_CL10_WR_DATA_TO_ERROR)
#define F_CL10_WR_DATA_TO_ERROR    V_CL10_WR_DATA_TO_ERROR(1U)

#define S_CL9_WR_DATA_TO_ERROR    9
#define V_CL9_WR_DATA_TO_ERROR(x) ((x) << S_CL9_WR_DATA_TO_ERROR)
#define F_CL9_WR_DATA_TO_ERROR    V_CL9_WR_DATA_TO_ERROR(1U)

#define S_CL8_WR_DATA_TO_ERROR    8
#define V_CL8_WR_DATA_TO_ERROR(x) ((x) << S_CL8_WR_DATA_TO_ERROR)
#define F_CL8_WR_DATA_TO_ERROR    V_CL8_WR_DATA_TO_ERROR(1U)

#define S_CL7_WR_DATA_TO_ERROR    7
#define V_CL7_WR_DATA_TO_ERROR(x) ((x) << S_CL7_WR_DATA_TO_ERROR)
#define F_CL7_WR_DATA_TO_ERROR    V_CL7_WR_DATA_TO_ERROR(1U)

#define S_CL6_WR_DATA_TO_ERROR    6
#define V_CL6_WR_DATA_TO_ERROR(x) ((x) << S_CL6_WR_DATA_TO_ERROR)
#define F_CL6_WR_DATA_TO_ERROR    V_CL6_WR_DATA_TO_ERROR(1U)

#define S_CL5_WR_DATA_TO_ERROR    5
#define V_CL5_WR_DATA_TO_ERROR(x) ((x) << S_CL5_WR_DATA_TO_ERROR)
#define F_CL5_WR_DATA_TO_ERROR    V_CL5_WR_DATA_TO_ERROR(1U)

#define S_CL4_WR_DATA_TO_ERROR    4
#define V_CL4_WR_DATA_TO_ERROR(x) ((x) << S_CL4_WR_DATA_TO_ERROR)
#define F_CL4_WR_DATA_TO_ERROR    V_CL4_WR_DATA_TO_ERROR(1U)

#define S_CL3_WR_DATA_TO_ERROR    3
#define V_CL3_WR_DATA_TO_ERROR(x) ((x) << S_CL3_WR_DATA_TO_ERROR)
#define F_CL3_WR_DATA_TO_ERROR    V_CL3_WR_DATA_TO_ERROR(1U)

#define S_CL2_WR_DATA_TO_ERROR    2
#define V_CL2_WR_DATA_TO_ERROR(x) ((x) << S_CL2_WR_DATA_TO_ERROR)
#define F_CL2_WR_DATA_TO_ERROR    V_CL2_WR_DATA_TO_ERROR(1U)

#define S_CL1_WR_DATA_TO_ERROR    1
#define V_CL1_WR_DATA_TO_ERROR(x) ((x) << S_CL1_WR_DATA_TO_ERROR)
#define F_CL1_WR_DATA_TO_ERROR    V_CL1_WR_DATA_TO_ERROR(1U)

#define S_CL0_WR_DATA_TO_ERROR    0
#define V_CL0_WR_DATA_TO_ERROR(x) ((x) << S_CL0_WR_DATA_TO_ERROR)
#define F_CL0_WR_DATA_TO_ERROR    V_CL0_WR_DATA_TO_ERROR(1U)

#define A_MA_READ_TIMEOUT_ERROR_ENABLE 0x78dc

#define S_CL12_RD_CMD_TO_EN    28
#define V_CL12_RD_CMD_TO_EN(x) ((x) << S_CL12_RD_CMD_TO_EN)
#define F_CL12_RD_CMD_TO_EN    V_CL12_RD_CMD_TO_EN(1U)

#define S_CL11_RD_CMD_TO_EN    27
#define V_CL11_RD_CMD_TO_EN(x) ((x) << S_CL11_RD_CMD_TO_EN)
#define F_CL11_RD_CMD_TO_EN    V_CL11_RD_CMD_TO_EN(1U)

#define S_CL10_RD_CMD_TO_EN    26
#define V_CL10_RD_CMD_TO_EN(x) ((x) << S_CL10_RD_CMD_TO_EN)
#define F_CL10_RD_CMD_TO_EN    V_CL10_RD_CMD_TO_EN(1U)

#define S_CL9_RD_CMD_TO_EN    25
#define V_CL9_RD_CMD_TO_EN(x) ((x) << S_CL9_RD_CMD_TO_EN)
#define F_CL9_RD_CMD_TO_EN    V_CL9_RD_CMD_TO_EN(1U)

#define S_CL8_RD_CMD_TO_EN    24
#define V_CL8_RD_CMD_TO_EN(x) ((x) << S_CL8_RD_CMD_TO_EN)
#define F_CL8_RD_CMD_TO_EN    V_CL8_RD_CMD_TO_EN(1U)

#define S_CL7_RD_CMD_TO_EN    23
#define V_CL7_RD_CMD_TO_EN(x) ((x) << S_CL7_RD_CMD_TO_EN)
#define F_CL7_RD_CMD_TO_EN    V_CL7_RD_CMD_TO_EN(1U)

#define S_CL6_RD_CMD_TO_EN    22
#define V_CL6_RD_CMD_TO_EN(x) ((x) << S_CL6_RD_CMD_TO_EN)
#define F_CL6_RD_CMD_TO_EN    V_CL6_RD_CMD_TO_EN(1U)

#define S_CL5_RD_CMD_TO_EN    21
#define V_CL5_RD_CMD_TO_EN(x) ((x) << S_CL5_RD_CMD_TO_EN)
#define F_CL5_RD_CMD_TO_EN    V_CL5_RD_CMD_TO_EN(1U)

#define S_CL4_RD_CMD_TO_EN    20
#define V_CL4_RD_CMD_TO_EN(x) ((x) << S_CL4_RD_CMD_TO_EN)
#define F_CL4_RD_CMD_TO_EN    V_CL4_RD_CMD_TO_EN(1U)

#define S_CL3_RD_CMD_TO_EN    19
#define V_CL3_RD_CMD_TO_EN(x) ((x) << S_CL3_RD_CMD_TO_EN)
#define F_CL3_RD_CMD_TO_EN    V_CL3_RD_CMD_TO_EN(1U)

#define S_CL2_RD_CMD_TO_EN    18
#define V_CL2_RD_CMD_TO_EN(x) ((x) << S_CL2_RD_CMD_TO_EN)
#define F_CL2_RD_CMD_TO_EN    V_CL2_RD_CMD_TO_EN(1U)

#define S_CL1_RD_CMD_TO_EN    17
#define V_CL1_RD_CMD_TO_EN(x) ((x) << S_CL1_RD_CMD_TO_EN)
#define F_CL1_RD_CMD_TO_EN    V_CL1_RD_CMD_TO_EN(1U)

#define S_CL0_RD_CMD_TO_EN    16
#define V_CL0_RD_CMD_TO_EN(x) ((x) << S_CL0_RD_CMD_TO_EN)
#define F_CL0_RD_CMD_TO_EN    V_CL0_RD_CMD_TO_EN(1U)

#define S_CL12_RD_DATA_TO_EN    12
#define V_CL12_RD_DATA_TO_EN(x) ((x) << S_CL12_RD_DATA_TO_EN)
#define F_CL12_RD_DATA_TO_EN    V_CL12_RD_DATA_TO_EN(1U)

#define S_CL11_RD_DATA_TO_EN    11
#define V_CL11_RD_DATA_TO_EN(x) ((x) << S_CL11_RD_DATA_TO_EN)
#define F_CL11_RD_DATA_TO_EN    V_CL11_RD_DATA_TO_EN(1U)

#define S_CL10_RD_DATA_TO_EN    10
#define V_CL10_RD_DATA_TO_EN(x) ((x) << S_CL10_RD_DATA_TO_EN)
#define F_CL10_RD_DATA_TO_EN    V_CL10_RD_DATA_TO_EN(1U)

#define S_CL9_RD_DATA_TO_EN    9
#define V_CL9_RD_DATA_TO_EN(x) ((x) << S_CL9_RD_DATA_TO_EN)
#define F_CL9_RD_DATA_TO_EN    V_CL9_RD_DATA_TO_EN(1U)

#define S_CL8_RD_DATA_TO_EN    8
#define V_CL8_RD_DATA_TO_EN(x) ((x) << S_CL8_RD_DATA_TO_EN)
#define F_CL8_RD_DATA_TO_EN    V_CL8_RD_DATA_TO_EN(1U)

#define S_CL7_RD_DATA_TO_EN    7
#define V_CL7_RD_DATA_TO_EN(x) ((x) << S_CL7_RD_DATA_TO_EN)
#define F_CL7_RD_DATA_TO_EN    V_CL7_RD_DATA_TO_EN(1U)

#define S_CL6_RD_DATA_TO_EN    6
#define V_CL6_RD_DATA_TO_EN(x) ((x) << S_CL6_RD_DATA_TO_EN)
#define F_CL6_RD_DATA_TO_EN    V_CL6_RD_DATA_TO_EN(1U)

#define S_CL5_RD_DATA_TO_EN    5
#define V_CL5_RD_DATA_TO_EN(x) ((x) << S_CL5_RD_DATA_TO_EN)
#define F_CL5_RD_DATA_TO_EN    V_CL5_RD_DATA_TO_EN(1U)

#define S_CL4_RD_DATA_TO_EN    4
#define V_CL4_RD_DATA_TO_EN(x) ((x) << S_CL4_RD_DATA_TO_EN)
#define F_CL4_RD_DATA_TO_EN    V_CL4_RD_DATA_TO_EN(1U)

#define S_CL3_RD_DATA_TO_EN    3
#define V_CL3_RD_DATA_TO_EN(x) ((x) << S_CL3_RD_DATA_TO_EN)
#define F_CL3_RD_DATA_TO_EN    V_CL3_RD_DATA_TO_EN(1U)

#define S_CL2_RD_DATA_TO_EN    2
#define V_CL2_RD_DATA_TO_EN(x) ((x) << S_CL2_RD_DATA_TO_EN)
#define F_CL2_RD_DATA_TO_EN    V_CL2_RD_DATA_TO_EN(1U)

#define S_CL1_RD_DATA_TO_EN    1
#define V_CL1_RD_DATA_TO_EN(x) ((x) << S_CL1_RD_DATA_TO_EN)
#define F_CL1_RD_DATA_TO_EN    V_CL1_RD_DATA_TO_EN(1U)

#define S_CL0_RD_DATA_TO_EN    0
#define V_CL0_RD_DATA_TO_EN(x) ((x) << S_CL0_RD_DATA_TO_EN)
#define F_CL0_RD_DATA_TO_EN    V_CL0_RD_DATA_TO_EN(1U)

#define A_MA_READ_TIMEOUT_ERROR_STATUS 0x78e0

#define S_CL12_RD_CMD_TO_ERROR    28
#define V_CL12_RD_CMD_TO_ERROR(x) ((x) << S_CL12_RD_CMD_TO_ERROR)
#define F_CL12_RD_CMD_TO_ERROR    V_CL12_RD_CMD_TO_ERROR(1U)

#define S_CL11_RD_CMD_TO_ERROR    27
#define V_CL11_RD_CMD_TO_ERROR(x) ((x) << S_CL11_RD_CMD_TO_ERROR)
#define F_CL11_RD_CMD_TO_ERROR    V_CL11_RD_CMD_TO_ERROR(1U)

#define S_CL10_RD_CMD_TO_ERROR    26
#define V_CL10_RD_CMD_TO_ERROR(x) ((x) << S_CL10_RD_CMD_TO_ERROR)
#define F_CL10_RD_CMD_TO_ERROR    V_CL10_RD_CMD_TO_ERROR(1U)

#define S_CL9_RD_CMD_TO_ERROR    25
#define V_CL9_RD_CMD_TO_ERROR(x) ((x) << S_CL9_RD_CMD_TO_ERROR)
#define F_CL9_RD_CMD_TO_ERROR    V_CL9_RD_CMD_TO_ERROR(1U)

#define S_CL8_RD_CMD_TO_ERROR    24
#define V_CL8_RD_CMD_TO_ERROR(x) ((x) << S_CL8_RD_CMD_TO_ERROR)
#define F_CL8_RD_CMD_TO_ERROR    V_CL8_RD_CMD_TO_ERROR(1U)

#define S_CL7_RD_CMD_TO_ERROR    23
#define V_CL7_RD_CMD_TO_ERROR(x) ((x) << S_CL7_RD_CMD_TO_ERROR)
#define F_CL7_RD_CMD_TO_ERROR    V_CL7_RD_CMD_TO_ERROR(1U)

#define S_CL6_RD_CMD_TO_ERROR    22
#define V_CL6_RD_CMD_TO_ERROR(x) ((x) << S_CL6_RD_CMD_TO_ERROR)
#define F_CL6_RD_CMD_TO_ERROR    V_CL6_RD_CMD_TO_ERROR(1U)

#define S_CL5_RD_CMD_TO_ERROR    21
#define V_CL5_RD_CMD_TO_ERROR(x) ((x) << S_CL5_RD_CMD_TO_ERROR)
#define F_CL5_RD_CMD_TO_ERROR    V_CL5_RD_CMD_TO_ERROR(1U)

#define S_CL4_RD_CMD_TO_ERROR    20
#define V_CL4_RD_CMD_TO_ERROR(x) ((x) << S_CL4_RD_CMD_TO_ERROR)
#define F_CL4_RD_CMD_TO_ERROR    V_CL4_RD_CMD_TO_ERROR(1U)

#define S_CL3_RD_CMD_TO_ERROR    19
#define V_CL3_RD_CMD_TO_ERROR(x) ((x) << S_CL3_RD_CMD_TO_ERROR)
#define F_CL3_RD_CMD_TO_ERROR    V_CL3_RD_CMD_TO_ERROR(1U)

#define S_CL2_RD_CMD_TO_ERROR    18
#define V_CL2_RD_CMD_TO_ERROR(x) ((x) << S_CL2_RD_CMD_TO_ERROR)
#define F_CL2_RD_CMD_TO_ERROR    V_CL2_RD_CMD_TO_ERROR(1U)

#define S_CL1_RD_CMD_TO_ERROR    17
#define V_CL1_RD_CMD_TO_ERROR(x) ((x) << S_CL1_RD_CMD_TO_ERROR)
#define F_CL1_RD_CMD_TO_ERROR    V_CL1_RD_CMD_TO_ERROR(1U)

#define S_CL0_RD_CMD_TO_ERROR    16
#define V_CL0_RD_CMD_TO_ERROR(x) ((x) << S_CL0_RD_CMD_TO_ERROR)
#define F_CL0_RD_CMD_TO_ERROR    V_CL0_RD_CMD_TO_ERROR(1U)

#define S_CL12_RD_DATA_TO_ERROR    12
#define V_CL12_RD_DATA_TO_ERROR(x) ((x) << S_CL12_RD_DATA_TO_ERROR)
#define F_CL12_RD_DATA_TO_ERROR    V_CL12_RD_DATA_TO_ERROR(1U)

#define S_CL11_RD_DATA_TO_ERROR    11
#define V_CL11_RD_DATA_TO_ERROR(x) ((x) << S_CL11_RD_DATA_TO_ERROR)
#define F_CL11_RD_DATA_TO_ERROR    V_CL11_RD_DATA_TO_ERROR(1U)

#define S_CL10_RD_DATA_TO_ERROR    10
#define V_CL10_RD_DATA_TO_ERROR(x) ((x) << S_CL10_RD_DATA_TO_ERROR)
#define F_CL10_RD_DATA_TO_ERROR    V_CL10_RD_DATA_TO_ERROR(1U)

#define S_CL9_RD_DATA_TO_ERROR    9
#define V_CL9_RD_DATA_TO_ERROR(x) ((x) << S_CL9_RD_DATA_TO_ERROR)
#define F_CL9_RD_DATA_TO_ERROR    V_CL9_RD_DATA_TO_ERROR(1U)

#define S_CL8_RD_DATA_TO_ERROR    8
#define V_CL8_RD_DATA_TO_ERROR(x) ((x) << S_CL8_RD_DATA_TO_ERROR)
#define F_CL8_RD_DATA_TO_ERROR    V_CL8_RD_DATA_TO_ERROR(1U)

#define S_CL7_RD_DATA_TO_ERROR    7
#define V_CL7_RD_DATA_TO_ERROR(x) ((x) << S_CL7_RD_DATA_TO_ERROR)
#define F_CL7_RD_DATA_TO_ERROR    V_CL7_RD_DATA_TO_ERROR(1U)

#define S_CL6_RD_DATA_TO_ERROR    6
#define V_CL6_RD_DATA_TO_ERROR(x) ((x) << S_CL6_RD_DATA_TO_ERROR)
#define F_CL6_RD_DATA_TO_ERROR    V_CL6_RD_DATA_TO_ERROR(1U)

#define S_CL5_RD_DATA_TO_ERROR    5
#define V_CL5_RD_DATA_TO_ERROR(x) ((x) << S_CL5_RD_DATA_TO_ERROR)
#define F_CL5_RD_DATA_TO_ERROR    V_CL5_RD_DATA_TO_ERROR(1U)

#define S_CL4_RD_DATA_TO_ERROR    4
#define V_CL4_RD_DATA_TO_ERROR(x) ((x) << S_CL4_RD_DATA_TO_ERROR)
#define F_CL4_RD_DATA_TO_ERROR    V_CL4_RD_DATA_TO_ERROR(1U)

#define S_CL3_RD_DATA_TO_ERROR    3
#define V_CL3_RD_DATA_TO_ERROR(x) ((x) << S_CL3_RD_DATA_TO_ERROR)
#define F_CL3_RD_DATA_TO_ERROR    V_CL3_RD_DATA_TO_ERROR(1U)

#define S_CL2_RD_DATA_TO_ERROR    2
#define V_CL2_RD_DATA_TO_ERROR(x) ((x) << S_CL2_RD_DATA_TO_ERROR)
#define F_CL2_RD_DATA_TO_ERROR    V_CL2_RD_DATA_TO_ERROR(1U)

#define S_CL1_RD_DATA_TO_ERROR    1
#define V_CL1_RD_DATA_TO_ERROR(x) ((x) << S_CL1_RD_DATA_TO_ERROR)
#define F_CL1_RD_DATA_TO_ERROR    V_CL1_RD_DATA_TO_ERROR(1U)

#define S_CL0_RD_DATA_TO_ERROR    0
#define V_CL0_RD_DATA_TO_ERROR(x) ((x) << S_CL0_RD_DATA_TO_ERROR)
#define F_CL0_RD_DATA_TO_ERROR    V_CL0_RD_DATA_TO_ERROR(1U)

#define A_MA_BKP_CNT_SEL 0x78e4

#define S_BKP_CNT_TYPE    30
#define M_BKP_CNT_TYPE    0x3U
#define V_BKP_CNT_TYPE(x) ((x) << S_BKP_CNT_TYPE)
#define G_BKP_CNT_TYPE(x) (((x) >> S_BKP_CNT_TYPE) & M_BKP_CNT_TYPE)

#define S_BKP_CLIENT    24
#define M_BKP_CLIENT    0xfU
#define V_BKP_CLIENT(x) ((x) << S_BKP_CLIENT)
#define G_BKP_CLIENT(x) (((x) >> S_BKP_CLIENT) & M_BKP_CLIENT)

#define A_MA_BKP_CNT 0x78e8
#define A_MA_WRT_ARB 0x78ec

#define S_WRT_EN    31
#define V_WRT_EN(x) ((x) << S_WRT_EN)
#define F_WRT_EN    V_WRT_EN(1U)

#define S_WR_TIM    16
#define M_WR_TIM    0xffU
#define V_WR_TIM(x) ((x) << S_WR_TIM)
#define G_WR_TIM(x) (((x) >> S_WR_TIM) & M_WR_TIM)

#define S_RD_WIN    8
#define M_RD_WIN    0xffU
#define V_RD_WIN(x) ((x) << S_RD_WIN)
#define G_RD_WIN(x) (((x) >> S_RD_WIN) & M_RD_WIN)

#define S_WR_WIN    0
#define M_WR_WIN    0xffU
#define V_WR_WIN(x) ((x) << S_WR_WIN)
#define G_WR_WIN(x) (((x) >> S_WR_WIN) & M_WR_WIN)

#define A_MA_IF_PARITY_ERROR_ENABLE 0x78f0

#define S_CL12_IF_PAR_EN    12
#define V_CL12_IF_PAR_EN(x) ((x) << S_CL12_IF_PAR_EN)
#define F_CL12_IF_PAR_EN    V_CL12_IF_PAR_EN(1U)

#define S_CL11_IF_PAR_EN    11
#define V_CL11_IF_PAR_EN(x) ((x) << S_CL11_IF_PAR_EN)
#define F_CL11_IF_PAR_EN    V_CL11_IF_PAR_EN(1U)

#define S_CL10_IF_PAR_EN    10
#define V_CL10_IF_PAR_EN(x) ((x) << S_CL10_IF_PAR_EN)
#define F_CL10_IF_PAR_EN    V_CL10_IF_PAR_EN(1U)

#define S_CL9_IF_PAR_EN    9
#define V_CL9_IF_PAR_EN(x) ((x) << S_CL9_IF_PAR_EN)
#define F_CL9_IF_PAR_EN    V_CL9_IF_PAR_EN(1U)

#define S_CL8_IF_PAR_EN    8
#define V_CL8_IF_PAR_EN(x) ((x) << S_CL8_IF_PAR_EN)
#define F_CL8_IF_PAR_EN    V_CL8_IF_PAR_EN(1U)

#define S_CL7_IF_PAR_EN    7
#define V_CL7_IF_PAR_EN(x) ((x) << S_CL7_IF_PAR_EN)
#define F_CL7_IF_PAR_EN    V_CL7_IF_PAR_EN(1U)

#define S_CL6_IF_PAR_EN    6
#define V_CL6_IF_PAR_EN(x) ((x) << S_CL6_IF_PAR_EN)
#define F_CL6_IF_PAR_EN    V_CL6_IF_PAR_EN(1U)

#define S_CL5_IF_PAR_EN    5
#define V_CL5_IF_PAR_EN(x) ((x) << S_CL5_IF_PAR_EN)
#define F_CL5_IF_PAR_EN    V_CL5_IF_PAR_EN(1U)

#define S_CL4_IF_PAR_EN    4
#define V_CL4_IF_PAR_EN(x) ((x) << S_CL4_IF_PAR_EN)
#define F_CL4_IF_PAR_EN    V_CL4_IF_PAR_EN(1U)

#define S_CL3_IF_PAR_EN    3
#define V_CL3_IF_PAR_EN(x) ((x) << S_CL3_IF_PAR_EN)
#define F_CL3_IF_PAR_EN    V_CL3_IF_PAR_EN(1U)

#define S_CL2_IF_PAR_EN    2
#define V_CL2_IF_PAR_EN(x) ((x) << S_CL2_IF_PAR_EN)
#define F_CL2_IF_PAR_EN    V_CL2_IF_PAR_EN(1U)

#define S_CL1_IF_PAR_EN    1
#define V_CL1_IF_PAR_EN(x) ((x) << S_CL1_IF_PAR_EN)
#define F_CL1_IF_PAR_EN    V_CL1_IF_PAR_EN(1U)

#define S_CL0_IF_PAR_EN    0
#define V_CL0_IF_PAR_EN(x) ((x) << S_CL0_IF_PAR_EN)
#define F_CL0_IF_PAR_EN    V_CL0_IF_PAR_EN(1U)

#define A_MA_IF_PARITY_ERROR_STATUS 0x78f4

#define S_CL12_IF_PAR_ERROR    12
#define V_CL12_IF_PAR_ERROR(x) ((x) << S_CL12_IF_PAR_ERROR)
#define F_CL12_IF_PAR_ERROR    V_CL12_IF_PAR_ERROR(1U)

#define S_CL11_IF_PAR_ERROR    11
#define V_CL11_IF_PAR_ERROR(x) ((x) << S_CL11_IF_PAR_ERROR)
#define F_CL11_IF_PAR_ERROR    V_CL11_IF_PAR_ERROR(1U)

#define S_CL10_IF_PAR_ERROR    10
#define V_CL10_IF_PAR_ERROR(x) ((x) << S_CL10_IF_PAR_ERROR)
#define F_CL10_IF_PAR_ERROR    V_CL10_IF_PAR_ERROR(1U)

#define S_CL9_IF_PAR_ERROR    9
#define V_CL9_IF_PAR_ERROR(x) ((x) << S_CL9_IF_PAR_ERROR)
#define F_CL9_IF_PAR_ERROR    V_CL9_IF_PAR_ERROR(1U)

#define S_CL8_IF_PAR_ERROR    8
#define V_CL8_IF_PAR_ERROR(x) ((x) << S_CL8_IF_PAR_ERROR)
#define F_CL8_IF_PAR_ERROR    V_CL8_IF_PAR_ERROR(1U)

#define S_CL7_IF_PAR_ERROR    7
#define V_CL7_IF_PAR_ERROR(x) ((x) << S_CL7_IF_PAR_ERROR)
#define F_CL7_IF_PAR_ERROR    V_CL7_IF_PAR_ERROR(1U)

#define S_CL6_IF_PAR_ERROR    6
#define V_CL6_IF_PAR_ERROR(x) ((x) << S_CL6_IF_PAR_ERROR)
#define F_CL6_IF_PAR_ERROR    V_CL6_IF_PAR_ERROR(1U)

#define S_CL5_IF_PAR_ERROR    5
#define V_CL5_IF_PAR_ERROR(x) ((x) << S_CL5_IF_PAR_ERROR)
#define F_CL5_IF_PAR_ERROR    V_CL5_IF_PAR_ERROR(1U)

#define S_CL4_IF_PAR_ERROR    4
#define V_CL4_IF_PAR_ERROR(x) ((x) << S_CL4_IF_PAR_ERROR)
#define F_CL4_IF_PAR_ERROR    V_CL4_IF_PAR_ERROR(1U)

#define S_CL3_IF_PAR_ERROR    3
#define V_CL3_IF_PAR_ERROR(x) ((x) << S_CL3_IF_PAR_ERROR)
#define F_CL3_IF_PAR_ERROR    V_CL3_IF_PAR_ERROR(1U)

#define S_CL2_IF_PAR_ERROR    2
#define V_CL2_IF_PAR_ERROR(x) ((x) << S_CL2_IF_PAR_ERROR)
#define F_CL2_IF_PAR_ERROR    V_CL2_IF_PAR_ERROR(1U)

#define S_CL1_IF_PAR_ERROR    1
#define V_CL1_IF_PAR_ERROR(x) ((x) << S_CL1_IF_PAR_ERROR)
#define F_CL1_IF_PAR_ERROR    V_CL1_IF_PAR_ERROR(1U)

#define S_CL0_IF_PAR_ERROR    0
#define V_CL0_IF_PAR_ERROR(x) ((x) << S_CL0_IF_PAR_ERROR)
#define F_CL0_IF_PAR_ERROR    V_CL0_IF_PAR_ERROR(1U)

#define A_MA_LOCAL_DEBUG_CFG 0x78f8

#define S_DEBUG_OR    15
#define V_DEBUG_OR(x) ((x) << S_DEBUG_OR)
#define F_DEBUG_OR    V_DEBUG_OR(1U)

#define S_DEBUG_HI    14
#define V_DEBUG_HI(x) ((x) << S_DEBUG_HI)
#define F_DEBUG_HI    V_DEBUG_HI(1U)

#define S_DEBUG_RPT    13
#define V_DEBUG_RPT(x) ((x) << S_DEBUG_RPT)
#define F_DEBUG_RPT    V_DEBUG_RPT(1U)

#define S_DEBUGPAGE    10
#define M_DEBUGPAGE    0x7U
#define V_DEBUGPAGE(x) ((x) << S_DEBUGPAGE)
#define G_DEBUGPAGE(x) (((x) >> S_DEBUGPAGE) & M_DEBUGPAGE)

#define A_MA_LOCAL_DEBUG_RPT 0x78fc

/* registers for module EDC_0 */
#define EDC_0_BASE_ADDR 0x7900

#define A_EDC_REF 0x7900

#define S_EDC_INST_NUM    18
#define V_EDC_INST_NUM(x) ((x) << S_EDC_INST_NUM)
#define F_EDC_INST_NUM    V_EDC_INST_NUM(1U)

#define S_ENABLE_PERF    17
#define V_ENABLE_PERF(x) ((x) << S_ENABLE_PERF)
#define F_ENABLE_PERF    V_ENABLE_PERF(1U)

#define S_ECC_BYPASS    16
#define V_ECC_BYPASS(x) ((x) << S_ECC_BYPASS)
#define F_ECC_BYPASS    V_ECC_BYPASS(1U)

#define S_REFFREQ    0
#define M_REFFREQ    0xffffU
#define V_REFFREQ(x) ((x) << S_REFFREQ)
#define G_REFFREQ(x) (((x) >> S_REFFREQ) & M_REFFREQ)

#define A_EDC_BIST_CMD 0x7904
#define A_EDC_BIST_CMD_ADDR 0x7908
#define A_EDC_BIST_CMD_LEN 0x790c
#define A_EDC_BIST_DATA_PATTERN 0x7910
#define A_EDC_BIST_USER_WDATA0 0x7914
#define A_EDC_BIST_USER_WDATA1 0x7918
#define A_EDC_BIST_USER_WDATA2 0x791c
#define A_EDC_BIST_NUM_ERR 0x7920
#define A_EDC_BIST_ERR_FIRST_ADDR 0x7924
#define A_EDC_BIST_STATUS_RDATA 0x7928
#define A_EDC_PAR_ENABLE 0x7970

#define S_ECC_UE    2
#define V_ECC_UE(x) ((x) << S_ECC_UE)
#define F_ECC_UE    V_ECC_UE(1U)

#define S_ECC_CE    1
#define V_ECC_CE(x) ((x) << S_ECC_CE)
#define F_ECC_CE    V_ECC_CE(1U)

#define A_EDC_INT_ENABLE 0x7974
#define A_EDC_INT_CAUSE 0x7978

#define S_ECC_UE_PAR    5
#define V_ECC_UE_PAR(x) ((x) << S_ECC_UE_PAR)
#define F_ECC_UE_PAR    V_ECC_UE_PAR(1U)

#define S_ECC_CE_PAR    4
#define V_ECC_CE_PAR(x) ((x) << S_ECC_CE_PAR)
#define F_ECC_CE_PAR    V_ECC_CE_PAR(1U)

#define S_PERR_PAR_CAUSE    3
#define V_PERR_PAR_CAUSE(x) ((x) << S_PERR_PAR_CAUSE)
#define F_PERR_PAR_CAUSE    V_PERR_PAR_CAUSE(1U)

#define A_EDC_ECC_STATUS 0x797c

/* registers for module EDC_1 */
#define EDC_1_BASE_ADDR 0x7980

/* registers for module HMA */
#define HMA_BASE_ADDR 0x7a00

/* registers for module CIM */
#define CIM_BASE_ADDR 0x7b00

#define A_CIM_VF_EXT_MAILBOX_CTRL 0x0

#define S_VFMBGENERIC    4
#define M_VFMBGENERIC    0xfU
#define V_VFMBGENERIC(x) ((x) << S_VFMBGENERIC)
#define G_VFMBGENERIC(x) (((x) >> S_VFMBGENERIC) & M_VFMBGENERIC)

#define A_CIM_VF_EXT_MAILBOX_STATUS 0x4

#define S_MBVFREADY    0
#define V_MBVFREADY(x) ((x) << S_MBVFREADY)
#define F_MBVFREADY    V_MBVFREADY(1U)

#define A_CIM_PF_MAILBOX_DATA 0x240
#define A_CIM_PF_MAILBOX_CTRL 0x280

#define S_MBGENERIC    4
#define M_MBGENERIC    0xfffffffU
#define V_MBGENERIC(x) ((x) << S_MBGENERIC)
#define G_MBGENERIC(x) (((x) >> S_MBGENERIC) & M_MBGENERIC)

#define S_MBMSGVALID    3
#define V_MBMSGVALID(x) ((x) << S_MBMSGVALID)
#define F_MBMSGVALID    V_MBMSGVALID(1U)

#define S_MBINTREQ    2
#define V_MBINTREQ(x) ((x) << S_MBINTREQ)
#define F_MBINTREQ    V_MBINTREQ(1U)

#define S_MBOWNER    0
#define M_MBOWNER    0x3U
#define V_MBOWNER(x) ((x) << S_MBOWNER)
#define G_MBOWNER(x) (((x) >> S_MBOWNER) & M_MBOWNER)

#define A_CIM_PF_MAILBOX_ACC_STATUS 0x284

#define S_MBWRBUSY    31
#define V_MBWRBUSY(x) ((x) << S_MBWRBUSY)
#define F_MBWRBUSY    V_MBWRBUSY(1U)

#define A_CIM_PF_HOST_INT_ENABLE 0x288

#define S_MBMSGRDYINTEN    19
#define V_MBMSGRDYINTEN(x) ((x) << S_MBMSGRDYINTEN)
#define F_MBMSGRDYINTEN    V_MBMSGRDYINTEN(1U)

#define A_CIM_PF_HOST_INT_CAUSE 0x28c

#define S_MBMSGRDYINT    19
#define V_MBMSGRDYINT(x) ((x) << S_MBMSGRDYINT)
#define F_MBMSGRDYINT    V_MBMSGRDYINT(1U)

#define A_CIM_PF_MAILBOX_CTRL_SHADOW_COPY 0x290
#define A_CIM_BOOT_CFG 0x7b00

#define S_BOOTADDR    8
#define M_BOOTADDR    0xffffffU
#define V_BOOTADDR(x) ((x) << S_BOOTADDR)
#define G_BOOTADDR(x) (((x) >> S_BOOTADDR) & M_BOOTADDR)

#define S_UPGEN    2
#define M_UPGEN    0x3fU
#define V_UPGEN(x) ((x) << S_UPGEN)
#define G_UPGEN(x) (((x) >> S_UPGEN) & M_UPGEN)

#define S_BOOTSDRAM    1
#define V_BOOTSDRAM(x) ((x) << S_BOOTSDRAM)
#define F_BOOTSDRAM    V_BOOTSDRAM(1U)

#define S_UPCRST    0
#define V_UPCRST(x) ((x) << S_UPCRST)
#define F_UPCRST    V_UPCRST(1U)

#define A_CIM_FLASH_BASE_ADDR 0x7b04

#define S_FLASHBASEADDR    6
#define M_FLASHBASEADDR    0x3ffffU
#define V_FLASHBASEADDR(x) ((x) << S_FLASHBASEADDR)
#define G_FLASHBASEADDR(x) (((x) >> S_FLASHBASEADDR) & M_FLASHBASEADDR)

#define A_CIM_FLASH_ADDR_SIZE 0x7b08

#define S_FLASHADDRSIZE    4
#define M_FLASHADDRSIZE    0xfffffU
#define V_FLASHADDRSIZE(x) ((x) << S_FLASHADDRSIZE)
#define G_FLASHADDRSIZE(x) (((x) >> S_FLASHADDRSIZE) & M_FLASHADDRSIZE)

#define A_CIM_EEPROM_BASE_ADDR 0x7b0c

#define S_EEPROMBASEADDR    6
#define M_EEPROMBASEADDR    0x3ffffU
#define V_EEPROMBASEADDR(x) ((x) << S_EEPROMBASEADDR)
#define G_EEPROMBASEADDR(x) (((x) >> S_EEPROMBASEADDR) & M_EEPROMBASEADDR)

#define A_CIM_EEPROM_ADDR_SIZE 0x7b10

#define S_EEPROMADDRSIZE    4
#define M_EEPROMADDRSIZE    0xfffffU
#define V_EEPROMADDRSIZE(x) ((x) << S_EEPROMADDRSIZE)
#define G_EEPROMADDRSIZE(x) (((x) >> S_EEPROMADDRSIZE) & M_EEPROMADDRSIZE)

#define A_CIM_SDRAM_BASE_ADDR 0x7b14

#define S_SDRAMBASEADDR    6
#define M_SDRAMBASEADDR    0x3ffffffU
#define V_SDRAMBASEADDR(x) ((x) << S_SDRAMBASEADDR)
#define G_SDRAMBASEADDR(x) (((x) >> S_SDRAMBASEADDR) & M_SDRAMBASEADDR)

#define A_CIM_SDRAM_ADDR_SIZE 0x7b18

#define S_SDRAMADDRSIZE    4
#define M_SDRAMADDRSIZE    0xfffffffU
#define V_SDRAMADDRSIZE(x) ((x) << S_SDRAMADDRSIZE)
#define G_SDRAMADDRSIZE(x) (((x) >> S_SDRAMADDRSIZE) & M_SDRAMADDRSIZE)

#define A_CIM_EXTMEM2_BASE_ADDR 0x7b1c

#define S_EXTMEM2BASEADDR    6
#define M_EXTMEM2BASEADDR    0x3ffffffU
#define V_EXTMEM2BASEADDR(x) ((x) << S_EXTMEM2BASEADDR)
#define G_EXTMEM2BASEADDR(x) (((x) >> S_EXTMEM2BASEADDR) & M_EXTMEM2BASEADDR)

#define A_CIM_EXTMEM2_ADDR_SIZE 0x7b20

#define S_EXTMEM2ADDRSIZE    4
#define M_EXTMEM2ADDRSIZE    0xfffffffU
#define V_EXTMEM2ADDRSIZE(x) ((x) << S_EXTMEM2ADDRSIZE)
#define G_EXTMEM2ADDRSIZE(x) (((x) >> S_EXTMEM2ADDRSIZE) & M_EXTMEM2ADDRSIZE)

#define A_CIM_UP_SPARE_INT 0x7b24

#define S_TDEBUGINT    4
#define V_TDEBUGINT(x) ((x) << S_TDEBUGINT)
#define F_TDEBUGINT    V_TDEBUGINT(1U)

#define S_BOOTVECSEL    3
#define V_BOOTVECSEL(x) ((x) << S_BOOTVECSEL)
#define F_BOOTVECSEL    V_BOOTVECSEL(1U)

#define S_UPSPAREINT    0
#define M_UPSPAREINT    0x7U
#define V_UPSPAREINT(x) ((x) << S_UPSPAREINT)
#define G_UPSPAREINT(x) (((x) >> S_UPSPAREINT) & M_UPSPAREINT)

#define A_CIM_HOST_INT_ENABLE 0x7b28

#define S_TIEQOUTPARERRINTEN    20
#define V_TIEQOUTPARERRINTEN(x) ((x) << S_TIEQOUTPARERRINTEN)
#define F_TIEQOUTPARERRINTEN    V_TIEQOUTPARERRINTEN(1U)

#define S_TIEQINPARERRINTEN    19
#define V_TIEQINPARERRINTEN(x) ((x) << S_TIEQINPARERRINTEN)
#define F_TIEQINPARERRINTEN    V_TIEQINPARERRINTEN(1U)

#define S_MBHOSTPARERR    18
#define V_MBHOSTPARERR(x) ((x) << S_MBHOSTPARERR)
#define F_MBHOSTPARERR    V_MBHOSTPARERR(1U)

#define S_MBUPPARERR    17
#define V_MBUPPARERR(x) ((x) << S_MBUPPARERR)
#define F_MBUPPARERR    V_MBUPPARERR(1U)

#define S_IBQTP0PARERR    16
#define V_IBQTP0PARERR(x) ((x) << S_IBQTP0PARERR)
#define F_IBQTP0PARERR    V_IBQTP0PARERR(1U)

#define S_IBQTP1PARERR    15
#define V_IBQTP1PARERR(x) ((x) << S_IBQTP1PARERR)
#define F_IBQTP1PARERR    V_IBQTP1PARERR(1U)

#define S_IBQULPPARERR    14
#define V_IBQULPPARERR(x) ((x) << S_IBQULPPARERR)
#define F_IBQULPPARERR    V_IBQULPPARERR(1U)

#define S_IBQSGELOPARERR    13
#define V_IBQSGELOPARERR(x) ((x) << S_IBQSGELOPARERR)
#define F_IBQSGELOPARERR    V_IBQSGELOPARERR(1U)

#define S_IBQSGEHIPARERR    12
#define V_IBQSGEHIPARERR(x) ((x) << S_IBQSGEHIPARERR)
#define F_IBQSGEHIPARERR    V_IBQSGEHIPARERR(1U)

#define S_IBQNCSIPARERR    11
#define V_IBQNCSIPARERR(x) ((x) << S_IBQNCSIPARERR)
#define F_IBQNCSIPARERR    V_IBQNCSIPARERR(1U)

#define S_OBQULP0PARERR    10
#define V_OBQULP0PARERR(x) ((x) << S_OBQULP0PARERR)
#define F_OBQULP0PARERR    V_OBQULP0PARERR(1U)

#define S_OBQULP1PARERR    9
#define V_OBQULP1PARERR(x) ((x) << S_OBQULP1PARERR)
#define F_OBQULP1PARERR    V_OBQULP1PARERR(1U)

#define S_OBQULP2PARERR    8
#define V_OBQULP2PARERR(x) ((x) << S_OBQULP2PARERR)
#define F_OBQULP2PARERR    V_OBQULP2PARERR(1U)

#define S_OBQULP3PARERR    7
#define V_OBQULP3PARERR(x) ((x) << S_OBQULP3PARERR)
#define F_OBQULP3PARERR    V_OBQULP3PARERR(1U)

#define S_OBQSGEPARERR    6
#define V_OBQSGEPARERR(x) ((x) << S_OBQSGEPARERR)
#define F_OBQSGEPARERR    V_OBQSGEPARERR(1U)

#define S_OBQNCSIPARERR    5
#define V_OBQNCSIPARERR(x) ((x) << S_OBQNCSIPARERR)
#define F_OBQNCSIPARERR    V_OBQNCSIPARERR(1U)

#define S_TIMER1INTEN    3
#define V_TIMER1INTEN(x) ((x) << S_TIMER1INTEN)
#define F_TIMER1INTEN    V_TIMER1INTEN(1U)

#define S_TIMER0INTEN    2
#define V_TIMER0INTEN(x) ((x) << S_TIMER0INTEN)
#define F_TIMER0INTEN    V_TIMER0INTEN(1U)

#define S_PREFDROPINTEN    1
#define V_PREFDROPINTEN(x) ((x) << S_PREFDROPINTEN)
#define F_PREFDROPINTEN    V_PREFDROPINTEN(1U)

#define S_MA_CIM_INTFPERR    28
#define V_MA_CIM_INTFPERR(x) ((x) << S_MA_CIM_INTFPERR)
#define F_MA_CIM_INTFPERR    V_MA_CIM_INTFPERR(1U)

#define S_PLCIM_MSTRSPDATAPARERR    27
#define V_PLCIM_MSTRSPDATAPARERR(x) ((x) << S_PLCIM_MSTRSPDATAPARERR)
#define F_PLCIM_MSTRSPDATAPARERR    V_PLCIM_MSTRSPDATAPARERR(1U)

#define S_NCSI2CIMINTFPARERR    26
#define V_NCSI2CIMINTFPARERR(x) ((x) << S_NCSI2CIMINTFPARERR)
#define F_NCSI2CIMINTFPARERR    V_NCSI2CIMINTFPARERR(1U)

#define S_SGE2CIMINTFPARERR    25
#define V_SGE2CIMINTFPARERR(x) ((x) << S_SGE2CIMINTFPARERR)
#define F_SGE2CIMINTFPARERR    V_SGE2CIMINTFPARERR(1U)

#define S_ULP2CIMINTFPARERR    24
#define V_ULP2CIMINTFPARERR(x) ((x) << S_ULP2CIMINTFPARERR)
#define F_ULP2CIMINTFPARERR    V_ULP2CIMINTFPARERR(1U)

#define S_TP2CIMINTFPARERR    23
#define V_TP2CIMINTFPARERR(x) ((x) << S_TP2CIMINTFPARERR)
#define F_TP2CIMINTFPARERR    V_TP2CIMINTFPARERR(1U)

#define S_OBQSGERX1PARERR    22
#define V_OBQSGERX1PARERR(x) ((x) << S_OBQSGERX1PARERR)
#define F_OBQSGERX1PARERR    V_OBQSGERX1PARERR(1U)

#define S_OBQSGERX0PARERR    21
#define V_OBQSGERX0PARERR(x) ((x) << S_OBQSGERX0PARERR)
#define F_OBQSGERX0PARERR    V_OBQSGERX0PARERR(1U)

#define A_CIM_HOST_INT_CAUSE 0x7b2c

#define S_TIEQOUTPARERRINT    20
#define V_TIEQOUTPARERRINT(x) ((x) << S_TIEQOUTPARERRINT)
#define F_TIEQOUTPARERRINT    V_TIEQOUTPARERRINT(1U)

#define S_TIEQINPARERRINT    19
#define V_TIEQINPARERRINT(x) ((x) << S_TIEQINPARERRINT)
#define F_TIEQINPARERRINT    V_TIEQINPARERRINT(1U)

#define S_TIMER1INT    3
#define V_TIMER1INT(x) ((x) << S_TIMER1INT)
#define F_TIMER1INT    V_TIMER1INT(1U)

#define S_TIMER0INT    2
#define V_TIMER0INT(x) ((x) << S_TIMER0INT)
#define F_TIMER0INT    V_TIMER0INT(1U)

#define S_PREFDROPINT    1
#define V_PREFDROPINT(x) ((x) << S_PREFDROPINT)
#define F_PREFDROPINT    V_PREFDROPINT(1U)

#define S_UPACCNONZERO    0
#define V_UPACCNONZERO(x) ((x) << S_UPACCNONZERO)
#define F_UPACCNONZERO    V_UPACCNONZERO(1U)

#define A_CIM_HOST_UPACC_INT_ENABLE 0x7b30

#define S_EEPROMWRINTEN    30
#define V_EEPROMWRINTEN(x) ((x) << S_EEPROMWRINTEN)
#define F_EEPROMWRINTEN    V_EEPROMWRINTEN(1U)

#define S_TIMEOUTMAINTEN    29
#define V_TIMEOUTMAINTEN(x) ((x) << S_TIMEOUTMAINTEN)
#define F_TIMEOUTMAINTEN    V_TIMEOUTMAINTEN(1U)

#define S_TIMEOUTINTEN    28
#define V_TIMEOUTINTEN(x) ((x) << S_TIMEOUTINTEN)
#define F_TIMEOUTINTEN    V_TIMEOUTINTEN(1U)

#define S_RSPOVRLOOKUPINTEN    27
#define V_RSPOVRLOOKUPINTEN(x) ((x) << S_RSPOVRLOOKUPINTEN)
#define F_RSPOVRLOOKUPINTEN    V_RSPOVRLOOKUPINTEN(1U)

#define S_REQOVRLOOKUPINTEN    26
#define V_REQOVRLOOKUPINTEN(x) ((x) << S_REQOVRLOOKUPINTEN)
#define F_REQOVRLOOKUPINTEN    V_REQOVRLOOKUPINTEN(1U)

#define S_BLKWRPLINTEN    25
#define V_BLKWRPLINTEN(x) ((x) << S_BLKWRPLINTEN)
#define F_BLKWRPLINTEN    V_BLKWRPLINTEN(1U)

#define S_BLKRDPLINTEN    24
#define V_BLKRDPLINTEN(x) ((x) << S_BLKRDPLINTEN)
#define F_BLKRDPLINTEN    V_BLKRDPLINTEN(1U)

#define S_SGLWRPLINTEN    23
#define V_SGLWRPLINTEN(x) ((x) << S_SGLWRPLINTEN)
#define F_SGLWRPLINTEN    V_SGLWRPLINTEN(1U)

#define S_SGLRDPLINTEN    22
#define V_SGLRDPLINTEN(x) ((x) << S_SGLRDPLINTEN)
#define F_SGLRDPLINTEN    V_SGLRDPLINTEN(1U)

#define S_BLKWRCTLINTEN    21
#define V_BLKWRCTLINTEN(x) ((x) << S_BLKWRCTLINTEN)
#define F_BLKWRCTLINTEN    V_BLKWRCTLINTEN(1U)

#define S_BLKRDCTLINTEN    20
#define V_BLKRDCTLINTEN(x) ((x) << S_BLKRDCTLINTEN)
#define F_BLKRDCTLINTEN    V_BLKRDCTLINTEN(1U)

#define S_SGLWRCTLINTEN    19
#define V_SGLWRCTLINTEN(x) ((x) << S_SGLWRCTLINTEN)
#define F_SGLWRCTLINTEN    V_SGLWRCTLINTEN(1U)

#define S_SGLRDCTLINTEN    18
#define V_SGLRDCTLINTEN(x) ((x) << S_SGLRDCTLINTEN)
#define F_SGLRDCTLINTEN    V_SGLRDCTLINTEN(1U)

#define S_BLKWREEPROMINTEN    17
#define V_BLKWREEPROMINTEN(x) ((x) << S_BLKWREEPROMINTEN)
#define F_BLKWREEPROMINTEN    V_BLKWREEPROMINTEN(1U)

#define S_BLKRDEEPROMINTEN    16
#define V_BLKRDEEPROMINTEN(x) ((x) << S_BLKRDEEPROMINTEN)
#define F_BLKRDEEPROMINTEN    V_BLKRDEEPROMINTEN(1U)

#define S_SGLWREEPROMINTEN    15
#define V_SGLWREEPROMINTEN(x) ((x) << S_SGLWREEPROMINTEN)
#define F_SGLWREEPROMINTEN    V_SGLWREEPROMINTEN(1U)

#define S_SGLRDEEPROMINTEN    14
#define V_SGLRDEEPROMINTEN(x) ((x) << S_SGLRDEEPROMINTEN)
#define F_SGLRDEEPROMINTEN    V_SGLRDEEPROMINTEN(1U)

#define S_BLKWRFLASHINTEN    13
#define V_BLKWRFLASHINTEN(x) ((x) << S_BLKWRFLASHINTEN)
#define F_BLKWRFLASHINTEN    V_BLKWRFLASHINTEN(1U)

#define S_BLKRDFLASHINTEN    12
#define V_BLKRDFLASHINTEN(x) ((x) << S_BLKRDFLASHINTEN)
#define F_BLKRDFLASHINTEN    V_BLKRDFLASHINTEN(1U)

#define S_SGLWRFLASHINTEN    11
#define V_SGLWRFLASHINTEN(x) ((x) << S_SGLWRFLASHINTEN)
#define F_SGLWRFLASHINTEN    V_SGLWRFLASHINTEN(1U)

#define S_SGLRDFLASHINTEN    10
#define V_SGLRDFLASHINTEN(x) ((x) << S_SGLRDFLASHINTEN)
#define F_SGLRDFLASHINTEN    V_SGLRDFLASHINTEN(1U)

#define S_BLKWRBOOTINTEN    9
#define V_BLKWRBOOTINTEN(x) ((x) << S_BLKWRBOOTINTEN)
#define F_BLKWRBOOTINTEN    V_BLKWRBOOTINTEN(1U)

#define S_BLKRDBOOTINTEN    8
#define V_BLKRDBOOTINTEN(x) ((x) << S_BLKRDBOOTINTEN)
#define F_BLKRDBOOTINTEN    V_BLKRDBOOTINTEN(1U)

#define S_SGLWRBOOTINTEN    7
#define V_SGLWRBOOTINTEN(x) ((x) << S_SGLWRBOOTINTEN)
#define F_SGLWRBOOTINTEN    V_SGLWRBOOTINTEN(1U)

#define S_SGLRDBOOTINTEN    6
#define V_SGLRDBOOTINTEN(x) ((x) << S_SGLRDBOOTINTEN)
#define F_SGLRDBOOTINTEN    V_SGLRDBOOTINTEN(1U)

#define S_ILLWRBEINTEN    5
#define V_ILLWRBEINTEN(x) ((x) << S_ILLWRBEINTEN)
#define F_ILLWRBEINTEN    V_ILLWRBEINTEN(1U)

#define S_ILLRDBEINTEN    4
#define V_ILLRDBEINTEN(x) ((x) << S_ILLRDBEINTEN)
#define F_ILLRDBEINTEN    V_ILLRDBEINTEN(1U)

#define S_ILLRDINTEN    3
#define V_ILLRDINTEN(x) ((x) << S_ILLRDINTEN)
#define F_ILLRDINTEN    V_ILLRDINTEN(1U)

#define S_ILLWRINTEN    2
#define V_ILLWRINTEN(x) ((x) << S_ILLWRINTEN)
#define F_ILLWRINTEN    V_ILLWRINTEN(1U)

#define S_ILLTRANSINTEN    1
#define V_ILLTRANSINTEN(x) ((x) << S_ILLTRANSINTEN)
#define F_ILLTRANSINTEN    V_ILLTRANSINTEN(1U)

#define S_RSVDSPACEINTEN    0
#define V_RSVDSPACEINTEN(x) ((x) << S_RSVDSPACEINTEN)
#define F_RSVDSPACEINTEN    V_RSVDSPACEINTEN(1U)

#define A_CIM_HOST_UPACC_INT_CAUSE 0x7b34

#define S_EEPROMWRINT    30
#define V_EEPROMWRINT(x) ((x) << S_EEPROMWRINT)
#define F_EEPROMWRINT    V_EEPROMWRINT(1U)

#define S_TIMEOUTMAINT    29
#define V_TIMEOUTMAINT(x) ((x) << S_TIMEOUTMAINT)
#define F_TIMEOUTMAINT    V_TIMEOUTMAINT(1U)

#define S_TIMEOUTINT    28
#define V_TIMEOUTINT(x) ((x) << S_TIMEOUTINT)
#define F_TIMEOUTINT    V_TIMEOUTINT(1U)

#define S_RSPOVRLOOKUPINT    27
#define V_RSPOVRLOOKUPINT(x) ((x) << S_RSPOVRLOOKUPINT)
#define F_RSPOVRLOOKUPINT    V_RSPOVRLOOKUPINT(1U)

#define S_REQOVRLOOKUPINT    26
#define V_REQOVRLOOKUPINT(x) ((x) << S_REQOVRLOOKUPINT)
#define F_REQOVRLOOKUPINT    V_REQOVRLOOKUPINT(1U)

#define S_BLKWRPLINT    25
#define V_BLKWRPLINT(x) ((x) << S_BLKWRPLINT)
#define F_BLKWRPLINT    V_BLKWRPLINT(1U)

#define S_BLKRDPLINT    24
#define V_BLKRDPLINT(x) ((x) << S_BLKRDPLINT)
#define F_BLKRDPLINT    V_BLKRDPLINT(1U)

#define S_SGLWRPLINT    23
#define V_SGLWRPLINT(x) ((x) << S_SGLWRPLINT)
#define F_SGLWRPLINT    V_SGLWRPLINT(1U)

#define S_SGLRDPLINT    22
#define V_SGLRDPLINT(x) ((x) << S_SGLRDPLINT)
#define F_SGLRDPLINT    V_SGLRDPLINT(1U)

#define S_BLKWRCTLINT    21
#define V_BLKWRCTLINT(x) ((x) << S_BLKWRCTLINT)
#define F_BLKWRCTLINT    V_BLKWRCTLINT(1U)

#define S_BLKRDCTLINT    20
#define V_BLKRDCTLINT(x) ((x) << S_BLKRDCTLINT)
#define F_BLKRDCTLINT    V_BLKRDCTLINT(1U)

#define S_SGLWRCTLINT    19
#define V_SGLWRCTLINT(x) ((x) << S_SGLWRCTLINT)
#define F_SGLWRCTLINT    V_SGLWRCTLINT(1U)

#define S_SGLRDCTLINT    18
#define V_SGLRDCTLINT(x) ((x) << S_SGLRDCTLINT)
#define F_SGLRDCTLINT    V_SGLRDCTLINT(1U)

#define S_BLKWREEPROMINT    17
#define V_BLKWREEPROMINT(x) ((x) << S_BLKWREEPROMINT)
#define F_BLKWREEPROMINT    V_BLKWREEPROMINT(1U)

#define S_BLKRDEEPROMINT    16
#define V_BLKRDEEPROMINT(x) ((x) << S_BLKRDEEPROMINT)
#define F_BLKRDEEPROMINT    V_BLKRDEEPROMINT(1U)

#define S_SGLWREEPROMINT    15
#define V_SGLWREEPROMINT(x) ((x) << S_SGLWREEPROMINT)
#define F_SGLWREEPROMINT    V_SGLWREEPROMINT(1U)

#define S_SGLRDEEPROMINT    14
#define V_SGLRDEEPROMINT(x) ((x) << S_SGLRDEEPROMINT)
#define F_SGLRDEEPROMINT    V_SGLRDEEPROMINT(1U)

#define S_BLKWRFLASHINT    13
#define V_BLKWRFLASHINT(x) ((x) << S_BLKWRFLASHINT)
#define F_BLKWRFLASHINT    V_BLKWRFLASHINT(1U)

#define S_BLKRDFLASHINT    12
#define V_BLKRDFLASHINT(x) ((x) << S_BLKRDFLASHINT)
#define F_BLKRDFLASHINT    V_BLKRDFLASHINT(1U)

#define S_SGLWRFLASHINT    11
#define V_SGLWRFLASHINT(x) ((x) << S_SGLWRFLASHINT)
#define F_SGLWRFLASHINT    V_SGLWRFLASHINT(1U)

#define S_SGLRDFLASHINT    10
#define V_SGLRDFLASHINT(x) ((x) << S_SGLRDFLASHINT)
#define F_SGLRDFLASHINT    V_SGLRDFLASHINT(1U)

#define S_BLKWRBOOTINT    9
#define V_BLKWRBOOTINT(x) ((x) << S_BLKWRBOOTINT)
#define F_BLKWRBOOTINT    V_BLKWRBOOTINT(1U)

#define S_BLKRDBOOTINT    8
#define V_BLKRDBOOTINT(x) ((x) << S_BLKRDBOOTINT)
#define F_BLKRDBOOTINT    V_BLKRDBOOTINT(1U)

#define S_SGLWRBOOTINT    7
#define V_SGLWRBOOTINT(x) ((x) << S_SGLWRBOOTINT)
#define F_SGLWRBOOTINT    V_SGLWRBOOTINT(1U)

#define S_SGLRDBOOTINT    6
#define V_SGLRDBOOTINT(x) ((x) << S_SGLRDBOOTINT)
#define F_SGLRDBOOTINT    V_SGLRDBOOTINT(1U)

#define S_ILLWRBEINT    5
#define V_ILLWRBEINT(x) ((x) << S_ILLWRBEINT)
#define F_ILLWRBEINT    V_ILLWRBEINT(1U)

#define S_ILLRDBEINT    4
#define V_ILLRDBEINT(x) ((x) << S_ILLRDBEINT)
#define F_ILLRDBEINT    V_ILLRDBEINT(1U)

#define S_ILLRDINT    3
#define V_ILLRDINT(x) ((x) << S_ILLRDINT)
#define F_ILLRDINT    V_ILLRDINT(1U)

#define S_ILLWRINT    2
#define V_ILLWRINT(x) ((x) << S_ILLWRINT)
#define F_ILLWRINT    V_ILLWRINT(1U)

#define S_ILLTRANSINT    1
#define V_ILLTRANSINT(x) ((x) << S_ILLTRANSINT)
#define F_ILLTRANSINT    V_ILLTRANSINT(1U)

#define S_RSVDSPACEINT    0
#define V_RSVDSPACEINT(x) ((x) << S_RSVDSPACEINT)
#define F_RSVDSPACEINT    V_RSVDSPACEINT(1U)

#define A_CIM_UP_INT_ENABLE 0x7b38

#define S_MSTPLINTEN    4
#define V_MSTPLINTEN(x) ((x) << S_MSTPLINTEN)
#define F_MSTPLINTEN    V_MSTPLINTEN(1U)

#define A_CIM_UP_INT_CAUSE 0x7b3c

#define S_MSTPLINT    4
#define V_MSTPLINT(x) ((x) << S_MSTPLINT)
#define F_MSTPLINT    V_MSTPLINT(1U)

#define A_CIM_UP_ACC_INT_ENABLE 0x7b40
#define A_CIM_UP_ACC_INT_CAUSE 0x7b44
#define A_CIM_QUEUE_CONFIG_REF 0x7b48

#define S_OBQSELECT    4
#define V_OBQSELECT(x) ((x) << S_OBQSELECT)
#define F_OBQSELECT    V_OBQSELECT(1U)

#define S_IBQSELECT    3
#define V_IBQSELECT(x) ((x) << S_IBQSELECT)
#define F_IBQSELECT    V_IBQSELECT(1U)

#define S_QUENUMSELECT    0
#define M_QUENUMSELECT    0x7U
#define V_QUENUMSELECT(x) ((x) << S_QUENUMSELECT)
#define G_QUENUMSELECT(x) (((x) >> S_QUENUMSELECT) & M_QUENUMSELECT)

#define A_CIM_QUEUE_CONFIG_CTRL 0x7b4c

#define S_CIMQSIZE    24
#define M_CIMQSIZE    0x3fU
#define V_CIMQSIZE(x) ((x) << S_CIMQSIZE)
#define G_CIMQSIZE(x) (((x) >> S_CIMQSIZE) & M_CIMQSIZE)

#define S_CIMQBASE    16
#define M_CIMQBASE    0x3fU
#define V_CIMQBASE(x) ((x) << S_CIMQBASE)
#define G_CIMQBASE(x) (((x) >> S_CIMQBASE) & M_CIMQBASE)

#define S_CIMQDBG8BEN    9
#define V_CIMQDBG8BEN(x) ((x) << S_CIMQDBG8BEN)
#define F_CIMQDBG8BEN    V_CIMQDBG8BEN(1U)

#define S_QUEFULLTHRSH    0
#define M_QUEFULLTHRSH    0x1ffU
#define V_QUEFULLTHRSH(x) ((x) << S_QUEFULLTHRSH)
#define G_QUEFULLTHRSH(x) (((x) >> S_QUEFULLTHRSH) & M_QUEFULLTHRSH)

#define A_CIM_HOST_ACC_CTRL 0x7b50

#define S_HOSTBUSY    17
#define V_HOSTBUSY(x) ((x) << S_HOSTBUSY)
#define F_HOSTBUSY    V_HOSTBUSY(1U)

#define S_HOSTWRITE    16
#define V_HOSTWRITE(x) ((x) << S_HOSTWRITE)
#define F_HOSTWRITE    V_HOSTWRITE(1U)

#define S_HOSTADDR    0
#define M_HOSTADDR    0xffffU
#define V_HOSTADDR(x) ((x) << S_HOSTADDR)
#define G_HOSTADDR(x) (((x) >> S_HOSTADDR) & M_HOSTADDR)

#define A_CIM_HOST_ACC_DATA 0x7b54
#define A_CIM_CDEBUGDATA 0x7b58

#define S_CDEBUGDATAH    16
#define M_CDEBUGDATAH    0xffffU
#define V_CDEBUGDATAH(x) ((x) << S_CDEBUGDATAH)
#define G_CDEBUGDATAH(x) (((x) >> S_CDEBUGDATAH) & M_CDEBUGDATAH)

#define S_CDEBUGDATAL    0
#define M_CDEBUGDATAL    0xffffU
#define V_CDEBUGDATAL(x) ((x) << S_CDEBUGDATAL)
#define G_CDEBUGDATAL(x) (((x) >> S_CDEBUGDATAL) & M_CDEBUGDATAL)

#define A_CIM_IBQ_DBG_CFG 0x7b60

#define S_IBQDBGADDR    16
#define M_IBQDBGADDR    0xfffU
#define V_IBQDBGADDR(x) ((x) << S_IBQDBGADDR)
#define G_IBQDBGADDR(x) (((x) >> S_IBQDBGADDR) & M_IBQDBGADDR)

#define S_IBQDBGWR    2
#define V_IBQDBGWR(x) ((x) << S_IBQDBGWR)
#define F_IBQDBGWR    V_IBQDBGWR(1U)

#define S_IBQDBGBUSY    1
#define V_IBQDBGBUSY(x) ((x) << S_IBQDBGBUSY)
#define F_IBQDBGBUSY    V_IBQDBGBUSY(1U)

#define S_IBQDBGEN    0
#define V_IBQDBGEN(x) ((x) << S_IBQDBGEN)
#define F_IBQDBGEN    V_IBQDBGEN(1U)

#define A_CIM_OBQ_DBG_CFG 0x7b64

#define S_OBQDBGADDR    16
#define M_OBQDBGADDR    0xfffU
#define V_OBQDBGADDR(x) ((x) << S_OBQDBGADDR)
#define G_OBQDBGADDR(x) (((x) >> S_OBQDBGADDR) & M_OBQDBGADDR)

#define S_OBQDBGWR    2
#define V_OBQDBGWR(x) ((x) << S_OBQDBGWR)
#define F_OBQDBGWR    V_OBQDBGWR(1U)

#define S_OBQDBGBUSY    1
#define V_OBQDBGBUSY(x) ((x) << S_OBQDBGBUSY)
#define F_OBQDBGBUSY    V_OBQDBGBUSY(1U)

#define S_OBQDBGEN    0
#define V_OBQDBGEN(x) ((x) << S_OBQDBGEN)
#define F_OBQDBGEN    V_OBQDBGEN(1U)

#define A_CIM_IBQ_DBG_DATA 0x7b68
#define A_CIM_OBQ_DBG_DATA 0x7b6c
#define A_CIM_DEBUGCFG 0x7b70

#define S_POLADBGRDPTR    23
#define M_POLADBGRDPTR    0x1ffU
#define V_POLADBGRDPTR(x) ((x) << S_POLADBGRDPTR)
#define G_POLADBGRDPTR(x) (((x) >> S_POLADBGRDPTR) & M_POLADBGRDPTR)

#define S_PILADBGRDPTR    14
#define M_PILADBGRDPTR    0x1ffU
#define V_PILADBGRDPTR(x) ((x) << S_PILADBGRDPTR)
#define G_PILADBGRDPTR(x) (((x) >> S_PILADBGRDPTR) & M_PILADBGRDPTR)

#define S_LAMASKTRIG    13
#define V_LAMASKTRIG(x) ((x) << S_LAMASKTRIG)
#define F_LAMASKTRIG    V_LAMASKTRIG(1U)

#define S_LADBGEN    12
#define V_LADBGEN(x) ((x) << S_LADBGEN)
#define F_LADBGEN    V_LADBGEN(1U)

#define S_LAFILLONCE    11
#define V_LAFILLONCE(x) ((x) << S_LAFILLONCE)
#define F_LAFILLONCE    V_LAFILLONCE(1U)

#define S_LAMASKSTOP    10
#define V_LAMASKSTOP(x) ((x) << S_LAMASKSTOP)
#define F_LAMASKSTOP    V_LAMASKSTOP(1U)

#define S_DEBUGSELH    5
#define M_DEBUGSELH    0x1fU
#define V_DEBUGSELH(x) ((x) << S_DEBUGSELH)
#define G_DEBUGSELH(x) (((x) >> S_DEBUGSELH) & M_DEBUGSELH)

#define S_DEBUGSELL    0
#define M_DEBUGSELL    0x1fU
#define V_DEBUGSELL(x) ((x) << S_DEBUGSELL)
#define G_DEBUGSELL(x) (((x) >> S_DEBUGSELL) & M_DEBUGSELL)

#define A_CIM_DEBUGSTS 0x7b74

#define S_LARESET    31
#define V_LARESET(x) ((x) << S_LARESET)
#define F_LARESET    V_LARESET(1U)

#define S_POLADBGWRPTR    16
#define M_POLADBGWRPTR    0x1ffU
#define V_POLADBGWRPTR(x) ((x) << S_POLADBGWRPTR)
#define G_POLADBGWRPTR(x) (((x) >> S_POLADBGWRPTR) & M_POLADBGWRPTR)

#define S_PILADBGWRPTR    0
#define M_PILADBGWRPTR    0x1ffU
#define V_PILADBGWRPTR(x) ((x) << S_PILADBGWRPTR)
#define G_PILADBGWRPTR(x) (((x) >> S_PILADBGWRPTR) & M_PILADBGWRPTR)

#define A_CIM_PO_LA_DEBUGDATA 0x7b78
#define A_CIM_PI_LA_DEBUGDATA 0x7b7c
#define A_CIM_PO_LA_MADEBUGDATA 0x7b80
#define A_CIM_PI_LA_MADEBUGDATA 0x7b84
#define A_CIM_PO_LA_PIFSMDEBUGDATA 0x7b8c
#define A_CIM_MEM_ZONE0_VA 0x7b90

#define S_MEM_ZONE_VA    4
#define M_MEM_ZONE_VA    0xfffffffU
#define V_MEM_ZONE_VA(x) ((x) << S_MEM_ZONE_VA)
#define G_MEM_ZONE_VA(x) (((x) >> S_MEM_ZONE_VA) & M_MEM_ZONE_VA)

#define A_CIM_MEM_ZONE0_BA 0x7b94

#define S_MEM_ZONE_BA    6
#define M_MEM_ZONE_BA    0x3ffffffU
#define V_MEM_ZONE_BA(x) ((x) << S_MEM_ZONE_BA)
#define G_MEM_ZONE_BA(x) (((x) >> S_MEM_ZONE_BA) & M_MEM_ZONE_BA)

#define S_PBT_ENABLE    5
#define V_PBT_ENABLE(x) ((x) << S_PBT_ENABLE)
#define F_PBT_ENABLE    V_PBT_ENABLE(1U)

#define S_ZONE_DST    0
#define M_ZONE_DST    0x3U
#define V_ZONE_DST(x) ((x) << S_ZONE_DST)
#define G_ZONE_DST(x) (((x) >> S_ZONE_DST) & M_ZONE_DST)

#define A_CIM_MEM_ZONE0_LEN 0x7b98

#define S_MEM_ZONE_LEN    4
#define M_MEM_ZONE_LEN    0xfffffffU
#define V_MEM_ZONE_LEN(x) ((x) << S_MEM_ZONE_LEN)
#define G_MEM_ZONE_LEN(x) (((x) >> S_MEM_ZONE_LEN) & M_MEM_ZONE_LEN)

#define A_CIM_MEM_ZONE1_VA 0x7b9c
#define A_CIM_MEM_ZONE1_BA 0x7ba0
#define A_CIM_MEM_ZONE1_LEN 0x7ba4
#define A_CIM_MEM_ZONE2_VA 0x7ba8
#define A_CIM_MEM_ZONE2_BA 0x7bac
#define A_CIM_MEM_ZONE2_LEN 0x7bb0
#define A_CIM_MEM_ZONE3_VA 0x7bb4
#define A_CIM_MEM_ZONE3_BA 0x7bb8
#define A_CIM_MEM_ZONE3_LEN 0x7bbc
#define A_CIM_MEM_ZONE4_VA 0x7bc0
#define A_CIM_MEM_ZONE4_BA 0x7bc4
#define A_CIM_MEM_ZONE4_LEN 0x7bc8
#define A_CIM_MEM_ZONE5_VA 0x7bcc
#define A_CIM_MEM_ZONE5_BA 0x7bd0
#define A_CIM_MEM_ZONE5_LEN 0x7bd4
#define A_CIM_MEM_ZONE6_VA 0x7bd8
#define A_CIM_MEM_ZONE6_BA 0x7bdc
#define A_CIM_MEM_ZONE6_LEN 0x7be0
#define A_CIM_MEM_ZONE7_VA 0x7be4
#define A_CIM_MEM_ZONE7_BA 0x7be8
#define A_CIM_MEM_ZONE7_LEN 0x7bec
#define A_CIM_BOOT_LEN 0x7bf0

#define S_BOOTLEN    4
#define M_BOOTLEN    0xfffffffU
#define V_BOOTLEN(x) ((x) << S_BOOTLEN)
#define G_BOOTLEN(x) (((x) >> S_BOOTLEN) & M_BOOTLEN)

#define A_CIM_GLB_TIMER_CTL 0x7bf4

#define S_TIMER1EN    4
#define V_TIMER1EN(x) ((x) << S_TIMER1EN)
#define F_TIMER1EN    V_TIMER1EN(1U)

#define S_TIMER0EN    3
#define V_TIMER0EN(x) ((x) << S_TIMER0EN)
#define F_TIMER0EN    V_TIMER0EN(1U)

#define S_TIMEREN    1
#define V_TIMEREN(x) ((x) << S_TIMEREN)
#define F_TIMEREN    V_TIMEREN(1U)

#define A_CIM_GLB_TIMER 0x7bf8
#define A_CIM_GLB_TIMER_TICK 0x7bfc

#define S_GLBLTTICK    0
#define M_GLBLTTICK    0xffffU
#define V_GLBLTTICK(x) ((x) << S_GLBLTTICK)
#define G_GLBLTTICK(x) (((x) >> S_GLBLTTICK) & M_GLBLTTICK)

#define A_CIM_TIMER0 0x7c00
#define A_CIM_TIMER1 0x7c04
#define A_CIM_DEBUG_ADDR_TIMEOUT 0x7c08

#define S_DADDRTIMEOUT    2
#define M_DADDRTIMEOUT    0x3fffffffU
#define V_DADDRTIMEOUT(x) ((x) << S_DADDRTIMEOUT)
#define G_DADDRTIMEOUT(x) (((x) >> S_DADDRTIMEOUT) & M_DADDRTIMEOUT)

#define A_CIM_DEBUG_ADDR_ILLEGAL 0x7c0c

#define S_DADDRILLEGAL    2
#define M_DADDRILLEGAL    0x3fffffffU
#define V_DADDRILLEGAL(x) ((x) << S_DADDRILLEGAL)
#define G_DADDRILLEGAL(x) (((x) >> S_DADDRILLEGAL) & M_DADDRILLEGAL)

#define A_CIM_DEBUG_PIF_CAUSE_MASK 0x7c10

#define S_DPIFHOSTMASK    0
#define M_DPIFHOSTMASK    0x1fffffU
#define V_DPIFHOSTMASK(x) ((x) << S_DPIFHOSTMASK)
#define G_DPIFHOSTMASK(x) (((x) >> S_DPIFHOSTMASK) & M_DPIFHOSTMASK)

#define S_T5_DPIFHOSTMASK    0
#define M_T5_DPIFHOSTMASK    0x1fffffffU
#define V_T5_DPIFHOSTMASK(x) ((x) << S_T5_DPIFHOSTMASK)
#define G_T5_DPIFHOSTMASK(x) (((x) >> S_T5_DPIFHOSTMASK) & M_T5_DPIFHOSTMASK)

#define A_CIM_DEBUG_PIF_UPACC_CAUSE_MASK 0x7c14

#define S_DPIFHUPAMASK    0
#define M_DPIFHUPAMASK    0x7fffffffU
#define V_DPIFHUPAMASK(x) ((x) << S_DPIFHUPAMASK)
#define G_DPIFHUPAMASK(x) (((x) >> S_DPIFHUPAMASK) & M_DPIFHUPAMASK)

#define A_CIM_DEBUG_UP_CAUSE_MASK 0x7c18

#define S_DUPMASK    0
#define M_DUPMASK    0x1fffffU
#define V_DUPMASK(x) ((x) << S_DUPMASK)
#define G_DUPMASK(x) (((x) >> S_DUPMASK) & M_DUPMASK)

#define S_T5_DUPMASK    0
#define M_T5_DUPMASK    0x1fffffffU
#define V_T5_DUPMASK(x) ((x) << S_T5_DUPMASK)
#define G_T5_DUPMASK(x) (((x) >> S_T5_DUPMASK) & M_T5_DUPMASK)

#define A_CIM_DEBUG_UP_UPACC_CAUSE_MASK 0x7c1c

#define S_DUPUACCMASK    0
#define M_DUPUACCMASK    0x7fffffffU
#define V_DUPUACCMASK(x) ((x) << S_DUPUACCMASK)
#define G_DUPUACCMASK(x) (((x) >> S_DUPUACCMASK) & M_DUPUACCMASK)

#define A_CIM_PERR_INJECT 0x7c20
#define A_CIM_PERR_ENABLE 0x7c24

#define S_PERREN    0
#define M_PERREN    0x1fffffU
#define V_PERREN(x) ((x) << S_PERREN)
#define G_PERREN(x) (((x) >> S_PERREN) & M_PERREN)

#define S_T5_PERREN    0
#define M_T5_PERREN    0x1fffffffU
#define V_T5_PERREN(x) ((x) << S_T5_PERREN)
#define G_T5_PERREN(x) (((x) >> S_T5_PERREN) & M_T5_PERREN)

#define A_CIM_EEPROM_BUSY_BIT 0x7c28

#define S_EEPROMBUSY    0
#define V_EEPROMBUSY(x) ((x) << S_EEPROMBUSY)
#define F_EEPROMBUSY    V_EEPROMBUSY(1U)

#define A_CIM_MA_TIMER_EN 0x7c2c

#define S_MA_TIMER_ENABLE    0
#define V_MA_TIMER_ENABLE(x) ((x) << S_MA_TIMER_ENABLE)
#define F_MA_TIMER_ENABLE    V_MA_TIMER_ENABLE(1U)

#define A_CIM_UP_PO_SINGLE_OUTSTANDING 0x7c30

#define S_UP_PO_SINGLE_OUTSTANDING    0
#define V_UP_PO_SINGLE_OUTSTANDING(x) ((x) << S_UP_PO_SINGLE_OUTSTANDING)
#define F_UP_PO_SINGLE_OUTSTANDING    V_UP_PO_SINGLE_OUTSTANDING(1U)

#define A_CIM_CIM_DEBUG_SPARE 0x7c34
#define A_CIM_UP_OPERATION_FREQ 0x7c38
#define A_CIM_CIM_IBQ_ERR_CODE 0x7c3c

#define S_CIM_ULP_TX_PKT_ERR_CODE    16
#define M_CIM_ULP_TX_PKT_ERR_CODE    0xffU
#define V_CIM_ULP_TX_PKT_ERR_CODE(x) ((x) << S_CIM_ULP_TX_PKT_ERR_CODE)
#define G_CIM_ULP_TX_PKT_ERR_CODE(x) (((x) >> S_CIM_ULP_TX_PKT_ERR_CODE) & M_CIM_ULP_TX_PKT_ERR_CODE)

#define S_CIM_SGE1_PKT_ERR_CODE    8
#define M_CIM_SGE1_PKT_ERR_CODE    0xffU
#define V_CIM_SGE1_PKT_ERR_CODE(x) ((x) << S_CIM_SGE1_PKT_ERR_CODE)
#define G_CIM_SGE1_PKT_ERR_CODE(x) (((x) >> S_CIM_SGE1_PKT_ERR_CODE) & M_CIM_SGE1_PKT_ERR_CODE)

#define S_CIM_SGE0_PKT_ERR_CODE    0
#define M_CIM_SGE0_PKT_ERR_CODE    0xffU
#define V_CIM_SGE0_PKT_ERR_CODE(x) ((x) << S_CIM_SGE0_PKT_ERR_CODE)
#define G_CIM_SGE0_PKT_ERR_CODE(x) (((x) >> S_CIM_SGE0_PKT_ERR_CODE) & M_CIM_SGE0_PKT_ERR_CODE)

#define A_CIM_IBQ_DBG_WAIT_COUNTER 0x7c40
#define A_CIM_PIO_UP_MST_CFG_SEL 0x7c44

#define S_PIO_UP_MST_CFG_SEL    0
#define V_PIO_UP_MST_CFG_SEL(x) ((x) << S_PIO_UP_MST_CFG_SEL)
#define F_PIO_UP_MST_CFG_SEL    V_PIO_UP_MST_CFG_SEL(1U)

#define A_CIM_CGEN 0x7c48

#define S_TSCH_CGEN    0
#define V_TSCH_CGEN(x) ((x) << S_TSCH_CGEN)
#define F_TSCH_CGEN    V_TSCH_CGEN(1U)

#define A_CIM_QUEUE_FEATURE_DISABLE 0x7c4c

#define S_OBQ_THROUTTLE_ON_EOP    4
#define V_OBQ_THROUTTLE_ON_EOP(x) ((x) << S_OBQ_THROUTTLE_ON_EOP)
#define F_OBQ_THROUTTLE_ON_EOP    V_OBQ_THROUTTLE_ON_EOP(1U)

#define S_OBQ_READ_CTL_PERF_MODE_DISABLE    3
#define V_OBQ_READ_CTL_PERF_MODE_DISABLE(x) ((x) << S_OBQ_READ_CTL_PERF_MODE_DISABLE)
#define F_OBQ_READ_CTL_PERF_MODE_DISABLE    V_OBQ_READ_CTL_PERF_MODE_DISABLE(1U)

#define S_OBQ_WAIT_FOR_EOP_FLUSH_DISABLE    2
#define V_OBQ_WAIT_FOR_EOP_FLUSH_DISABLE(x) ((x) << S_OBQ_WAIT_FOR_EOP_FLUSH_DISABLE)
#define F_OBQ_WAIT_FOR_EOP_FLUSH_DISABLE    V_OBQ_WAIT_FOR_EOP_FLUSH_DISABLE(1U)

#define S_IBQ_RRA_DSBL    1
#define V_IBQ_RRA_DSBL(x) ((x) << S_IBQ_RRA_DSBL)
#define F_IBQ_RRA_DSBL    V_IBQ_RRA_DSBL(1U)

#define S_IBQ_SKID_FIFO_EOP_FLSH_DSBL    0
#define V_IBQ_SKID_FIFO_EOP_FLSH_DSBL(x) ((x) << S_IBQ_SKID_FIFO_EOP_FLSH_DSBL)
#define F_IBQ_SKID_FIFO_EOP_FLSH_DSBL    V_IBQ_SKID_FIFO_EOP_FLSH_DSBL(1U)

#define A_CIM_CGEN_GLOBAL 0x7c50

#define S_CGEN_GLOBAL    0
#define V_CGEN_GLOBAL(x) ((x) << S_CGEN_GLOBAL)
#define F_CGEN_GLOBAL    V_CGEN_GLOBAL(1U)

#define A_CIM_DPSLP_EN 0x7c54

#define S_PIFDBGLA_DPSLP_EN    0
#define V_PIFDBGLA_DPSLP_EN(x) ((x) << S_PIFDBGLA_DPSLP_EN)
#define F_PIFDBGLA_DPSLP_EN    V_PIFDBGLA_DPSLP_EN(1U)

/* registers for module TP */
#define TP_BASE_ADDR 0x7d00

#define A_TP_IN_CONFIG 0x7d00

#define S_TCPOPTPARSERDISCH3    27
#define V_TCPOPTPARSERDISCH3(x) ((x) << S_TCPOPTPARSERDISCH3)
#define F_TCPOPTPARSERDISCH3    V_TCPOPTPARSERDISCH3(1U)

#define S_TCPOPTPARSERDISCH2    26
#define V_TCPOPTPARSERDISCH2(x) ((x) << S_TCPOPTPARSERDISCH2)
#define F_TCPOPTPARSERDISCH2    V_TCPOPTPARSERDISCH2(1U)

#define S_TCPOPTPARSERDISCH1    25
#define V_TCPOPTPARSERDISCH1(x) ((x) << S_TCPOPTPARSERDISCH1)
#define F_TCPOPTPARSERDISCH1    V_TCPOPTPARSERDISCH1(1U)

#define S_TCPOPTPARSERDISCH0    24
#define V_TCPOPTPARSERDISCH0(x) ((x) << S_TCPOPTPARSERDISCH0)
#define F_TCPOPTPARSERDISCH0    V_TCPOPTPARSERDISCH0(1U)

#define S_CRCPASSPRT3    23
#define V_CRCPASSPRT3(x) ((x) << S_CRCPASSPRT3)
#define F_CRCPASSPRT3    V_CRCPASSPRT3(1U)

#define S_CRCPASSPRT2    22
#define V_CRCPASSPRT2(x) ((x) << S_CRCPASSPRT2)
#define F_CRCPASSPRT2    V_CRCPASSPRT2(1U)

#define S_CRCPASSPRT1    21
#define V_CRCPASSPRT1(x) ((x) << S_CRCPASSPRT1)
#define F_CRCPASSPRT1    V_CRCPASSPRT1(1U)

#define S_CRCPASSPRT0    20
#define V_CRCPASSPRT0(x) ((x) << S_CRCPASSPRT0)
#define F_CRCPASSPRT0    V_CRCPASSPRT0(1U)

#define S_VEPAMODE    19
#define V_VEPAMODE(x) ((x) << S_VEPAMODE)
#define F_VEPAMODE    V_VEPAMODE(1U)

#define S_FIPUPEN    18
#define V_FIPUPEN(x) ((x) << S_FIPUPEN)
#define F_FIPUPEN    V_FIPUPEN(1U)

#define S_FCOEUPEN    17
#define V_FCOEUPEN(x) ((x) << S_FCOEUPEN)
#define F_FCOEUPEN    V_FCOEUPEN(1U)

#define S_FCOEENABLE    16
#define V_FCOEENABLE(x) ((x) << S_FCOEENABLE)
#define F_FCOEENABLE    V_FCOEENABLE(1U)

#define S_IPV6ENABLE    15
#define V_IPV6ENABLE(x) ((x) << S_IPV6ENABLE)
#define F_IPV6ENABLE    V_IPV6ENABLE(1U)

#define S_NICMODE    14
#define V_NICMODE(x) ((x) << S_NICMODE)
#define F_NICMODE    V_NICMODE(1U)

#define S_ECHECKSUMCHECKTCP    13
#define V_ECHECKSUMCHECKTCP(x) ((x) << S_ECHECKSUMCHECKTCP)
#define F_ECHECKSUMCHECKTCP    V_ECHECKSUMCHECKTCP(1U)

#define S_ECHECKSUMCHECKIP    12
#define V_ECHECKSUMCHECKIP(x) ((x) << S_ECHECKSUMCHECKIP)
#define F_ECHECKSUMCHECKIP    V_ECHECKSUMCHECKIP(1U)

#define S_EREPORTUDPHDRLEN    11
#define V_EREPORTUDPHDRLEN(x) ((x) << S_EREPORTUDPHDRLEN)
#define F_EREPORTUDPHDRLEN    V_EREPORTUDPHDRLEN(1U)

#define S_IN_ECPL    10
#define V_IN_ECPL(x) ((x) << S_IN_ECPL)
#define F_IN_ECPL    V_IN_ECPL(1U)

#define S_VNTAGENABLE    9
#define V_VNTAGENABLE(x) ((x) << S_VNTAGENABLE)
#define F_VNTAGENABLE    V_VNTAGENABLE(1U)

#define S_IN_EETH    8
#define V_IN_EETH(x) ((x) << S_IN_EETH)
#define F_IN_EETH    V_IN_EETH(1U)

#define S_CCHECKSUMCHECKTCP    6
#define V_CCHECKSUMCHECKTCP(x) ((x) << S_CCHECKSUMCHECKTCP)
#define F_CCHECKSUMCHECKTCP    V_CCHECKSUMCHECKTCP(1U)

#define S_CCHECKSUMCHECKIP    5
#define V_CCHECKSUMCHECKIP(x) ((x) << S_CCHECKSUMCHECKIP)
#define F_CCHECKSUMCHECKIP    V_CCHECKSUMCHECKIP(1U)

#define S_CTAG    4
#define V_CTAG(x) ((x) << S_CTAG)
#define F_CTAG    V_CTAG(1U)

#define S_IN_CCPL    3
#define V_IN_CCPL(x) ((x) << S_IN_CCPL)
#define F_IN_CCPL    V_IN_CCPL(1U)

#define S_IN_CETH    1
#define V_IN_CETH(x) ((x) << S_IN_CETH)
#define F_IN_CETH    V_IN_CETH(1U)

#define S_CTUNNEL    0
#define V_CTUNNEL(x) ((x) << S_CTUNNEL)
#define F_CTUNNEL    V_CTUNNEL(1U)

#define S_VLANEXTENPORT3    31
#define V_VLANEXTENPORT3(x) ((x) << S_VLANEXTENPORT3)
#define F_VLANEXTENPORT3    V_VLANEXTENPORT3(1U)

#define S_VLANEXTENPORT2    30
#define V_VLANEXTENPORT2(x) ((x) << S_VLANEXTENPORT2)
#define F_VLANEXTENPORT2    V_VLANEXTENPORT2(1U)

#define S_VLANEXTENPORT1    29
#define V_VLANEXTENPORT1(x) ((x) << S_VLANEXTENPORT1)
#define F_VLANEXTENPORT1    V_VLANEXTENPORT1(1U)

#define S_VLANEXTENPORT0    28
#define V_VLANEXTENPORT0(x) ((x) << S_VLANEXTENPORT0)
#define F_VLANEXTENPORT0    V_VLANEXTENPORT0(1U)

#define S_VNTAGDEFAULTVAL    13
#define V_VNTAGDEFAULTVAL(x) ((x) << S_VNTAGDEFAULTVAL)
#define F_VNTAGDEFAULTVAL    V_VNTAGDEFAULTVAL(1U)

#define S_ECHECKUDPLEN    12
#define V_ECHECKUDPLEN(x) ((x) << S_ECHECKUDPLEN)
#define F_ECHECKUDPLEN    V_ECHECKUDPLEN(1U)

#define S_FCOEFPMA    10
#define V_FCOEFPMA(x) ((x) << S_FCOEFPMA)
#define F_FCOEFPMA    V_FCOEFPMA(1U)

#define S_VNTAGETHENABLE    8
#define V_VNTAGETHENABLE(x) ((x) << S_VNTAGETHENABLE)
#define F_VNTAGETHENABLE    V_VNTAGETHENABLE(1U)

#define S_IP_CCSM    7
#define V_IP_CCSM(x) ((x) << S_IP_CCSM)
#define F_IP_CCSM    V_IP_CCSM(1U)

#define S_CCHECKSUMCHECKUDP    6
#define V_CCHECKSUMCHECKUDP(x) ((x) << S_CCHECKSUMCHECKUDP)
#define F_CCHECKSUMCHECKUDP    V_CCHECKSUMCHECKUDP(1U)

#define S_TCP_CCSM    5
#define V_TCP_CCSM(x) ((x) << S_TCP_CCSM)
#define F_TCP_CCSM    V_TCP_CCSM(1U)

#define S_CDEMUX    3
#define V_CDEMUX(x) ((x) << S_CDEMUX)
#define F_CDEMUX    V_CDEMUX(1U)

#define S_ETHUPEN    2
#define V_ETHUPEN(x) ((x) << S_ETHUPEN)
#define F_ETHUPEN    V_ETHUPEN(1U)

#define A_TP_OUT_CONFIG 0x7d04

#define S_PORTQFCEN    28
#define M_PORTQFCEN    0xfU
#define V_PORTQFCEN(x) ((x) << S_PORTQFCEN)
#define G_PORTQFCEN(x) (((x) >> S_PORTQFCEN) & M_PORTQFCEN)

#define S_EPKTDISTCHN3    23
#define V_EPKTDISTCHN3(x) ((x) << S_EPKTDISTCHN3)
#define F_EPKTDISTCHN3    V_EPKTDISTCHN3(1U)

#define S_EPKTDISTCHN2    22
#define V_EPKTDISTCHN2(x) ((x) << S_EPKTDISTCHN2)
#define F_EPKTDISTCHN2    V_EPKTDISTCHN2(1U)

#define S_EPKTDISTCHN1    21
#define V_EPKTDISTCHN1(x) ((x) << S_EPKTDISTCHN1)
#define F_EPKTDISTCHN1    V_EPKTDISTCHN1(1U)

#define S_EPKTDISTCHN0    20
#define V_EPKTDISTCHN0(x) ((x) << S_EPKTDISTCHN0)
#define F_EPKTDISTCHN0    V_EPKTDISTCHN0(1U)

#define S_TTLMODE    19
#define V_TTLMODE(x) ((x) << S_TTLMODE)
#define F_TTLMODE    V_TTLMODE(1U)

#define S_EQFCDMAC    18
#define V_EQFCDMAC(x) ((x) << S_EQFCDMAC)
#define F_EQFCDMAC    V_EQFCDMAC(1U)

#define S_ELPBKINCMPSSTAT    17
#define V_ELPBKINCMPSSTAT(x) ((x) << S_ELPBKINCMPSSTAT)
#define F_ELPBKINCMPSSTAT    V_ELPBKINCMPSSTAT(1U)

#define S_IPIDSPLITMODE    16
#define V_IPIDSPLITMODE(x) ((x) << S_IPIDSPLITMODE)
#define F_IPIDSPLITMODE    V_IPIDSPLITMODE(1U)

#define S_VLANEXTENABLEPORT3    15
#define V_VLANEXTENABLEPORT3(x) ((x) << S_VLANEXTENABLEPORT3)
#define F_VLANEXTENABLEPORT3    V_VLANEXTENABLEPORT3(1U)

#define S_VLANEXTENABLEPORT2    14
#define V_VLANEXTENABLEPORT2(x) ((x) << S_VLANEXTENABLEPORT2)
#define F_VLANEXTENABLEPORT2    V_VLANEXTENABLEPORT2(1U)

#define S_VLANEXTENABLEPORT1    13
#define V_VLANEXTENABLEPORT1(x) ((x) << S_VLANEXTENABLEPORT1)
#define F_VLANEXTENABLEPORT1    V_VLANEXTENABLEPORT1(1U)

#define S_VLANEXTENABLEPORT0    12
#define V_VLANEXTENABLEPORT0(x) ((x) << S_VLANEXTENABLEPORT0)
#define F_VLANEXTENABLEPORT0    V_VLANEXTENABLEPORT0(1U)

#define S_ECHECKSUMINSERTTCP    11
#define V_ECHECKSUMINSERTTCP(x) ((x) << S_ECHECKSUMINSERTTCP)
#define F_ECHECKSUMINSERTTCP    V_ECHECKSUMINSERTTCP(1U)

#define S_ECHECKSUMINSERTIP    10
#define V_ECHECKSUMINSERTIP(x) ((x) << S_ECHECKSUMINSERTIP)
#define F_ECHECKSUMINSERTIP    V_ECHECKSUMINSERTIP(1U)

#define S_ECPL    8
#define V_ECPL(x) ((x) << S_ECPL)
#define F_ECPL    V_ECPL(1U)

#define S_EPRIORITY    7
#define V_EPRIORITY(x) ((x) << S_EPRIORITY)
#define F_EPRIORITY    V_EPRIORITY(1U)

#define S_EETHERNET    6
#define V_EETHERNET(x) ((x) << S_EETHERNET)
#define F_EETHERNET    V_EETHERNET(1U)

#define S_CCHECKSUMINSERTTCP    5
#define V_CCHECKSUMINSERTTCP(x) ((x) << S_CCHECKSUMINSERTTCP)
#define F_CCHECKSUMINSERTTCP    V_CCHECKSUMINSERTTCP(1U)

#define S_CCHECKSUMINSERTIP    4
#define V_CCHECKSUMINSERTIP(x) ((x) << S_CCHECKSUMINSERTIP)
#define F_CCHECKSUMINSERTIP    V_CCHECKSUMINSERTIP(1U)

#define S_CCPL    2
#define V_CCPL(x) ((x) << S_CCPL)
#define F_CCPL    V_CCPL(1U)

#define S_CETHERNET    0
#define V_CETHERNET(x) ((x) << S_CETHERNET)
#define F_CETHERNET    V_CETHERNET(1U)

#define S_EVNTAGEN    9
#define V_EVNTAGEN(x) ((x) << S_EVNTAGEN)
#define F_EVNTAGEN    V_EVNTAGEN(1U)

#define A_TP_GLOBAL_CONFIG 0x7d08

#define S_SYNCOOKIEPARAMS    26
#define M_SYNCOOKIEPARAMS    0x3fU
#define V_SYNCOOKIEPARAMS(x) ((x) << S_SYNCOOKIEPARAMS)
#define G_SYNCOOKIEPARAMS(x) (((x) >> S_SYNCOOKIEPARAMS) & M_SYNCOOKIEPARAMS)

#define S_RXFLOWCONTROLDISABLE    25
#define V_RXFLOWCONTROLDISABLE(x) ((x) << S_RXFLOWCONTROLDISABLE)
#define F_RXFLOWCONTROLDISABLE    V_RXFLOWCONTROLDISABLE(1U)

#define S_TXPACINGENABLE    24
#define V_TXPACINGENABLE(x) ((x) << S_TXPACINGENABLE)
#define F_TXPACINGENABLE    V_TXPACINGENABLE(1U)

#define S_ATTACKFILTERENABLE    23
#define V_ATTACKFILTERENABLE(x) ((x) << S_ATTACKFILTERENABLE)
#define F_ATTACKFILTERENABLE    V_ATTACKFILTERENABLE(1U)

#define S_SYNCOOKIENOOPTIONS    22
#define V_SYNCOOKIENOOPTIONS(x) ((x) << S_SYNCOOKIENOOPTIONS)
#define F_SYNCOOKIENOOPTIONS    V_SYNCOOKIENOOPTIONS(1U)

#define S_PROTECTEDMODE    21
#define V_PROTECTEDMODE(x) ((x) << S_PROTECTEDMODE)
#define F_PROTECTEDMODE    V_PROTECTEDMODE(1U)

#define S_PINGDROP    20
#define V_PINGDROP(x) ((x) << S_PINGDROP)
#define F_PINGDROP    V_PINGDROP(1U)

#define S_FRAGMENTDROP    19
#define V_FRAGMENTDROP(x) ((x) << S_FRAGMENTDROP)
#define F_FRAGMENTDROP    V_FRAGMENTDROP(1U)

#define S_FIVETUPLELOOKUP    17
#define M_FIVETUPLELOOKUP    0x3U
#define V_FIVETUPLELOOKUP(x) ((x) << S_FIVETUPLELOOKUP)
#define G_FIVETUPLELOOKUP(x) (((x) >> S_FIVETUPLELOOKUP) & M_FIVETUPLELOOKUP)

#define S_OFDMPSSTATS    16
#define V_OFDMPSSTATS(x) ((x) << S_OFDMPSSTATS)
#define F_OFDMPSSTATS    V_OFDMPSSTATS(1U)

#define S_DONTFRAGMENT    15
#define V_DONTFRAGMENT(x) ((x) << S_DONTFRAGMENT)
#define F_DONTFRAGMENT    V_DONTFRAGMENT(1U)

#define S_IPIDENTSPLIT    14
#define V_IPIDENTSPLIT(x) ((x) << S_IPIDENTSPLIT)
#define F_IPIDENTSPLIT    V_IPIDENTSPLIT(1U)

#define S_IPCHECKSUMOFFLOAD    13
#define V_IPCHECKSUMOFFLOAD(x) ((x) << S_IPCHECKSUMOFFLOAD)
#define F_IPCHECKSUMOFFLOAD    V_IPCHECKSUMOFFLOAD(1U)

#define S_UDPCHECKSUMOFFLOAD    12
#define V_UDPCHECKSUMOFFLOAD(x) ((x) << S_UDPCHECKSUMOFFLOAD)
#define F_UDPCHECKSUMOFFLOAD    V_UDPCHECKSUMOFFLOAD(1U)

#define S_TCPCHECKSUMOFFLOAD    11
#define V_TCPCHECKSUMOFFLOAD(x) ((x) << S_TCPCHECKSUMOFFLOAD)
#define F_TCPCHECKSUMOFFLOAD    V_TCPCHECKSUMOFFLOAD(1U)

#define S_RSSLOOPBACKENABLE    10
#define V_RSSLOOPBACKENABLE(x) ((x) << S_RSSLOOPBACKENABLE)
#define F_RSSLOOPBACKENABLE    V_RSSLOOPBACKENABLE(1U)

#define S_TCAMSERVERUSE    8
#define M_TCAMSERVERUSE    0x3U
#define V_TCAMSERVERUSE(x) ((x) << S_TCAMSERVERUSE)
#define G_TCAMSERVERUSE(x) (((x) >> S_TCAMSERVERUSE) & M_TCAMSERVERUSE)

#define S_IPTTL    0
#define M_IPTTL    0xffU
#define V_IPTTL(x) ((x) << S_IPTTL)
#define G_IPTTL(x) (((x) >> S_IPTTL) & M_IPTTL)

#define S_RSSSYNSTEERENABLE    12
#define V_RSSSYNSTEERENABLE(x) ((x) << S_RSSSYNSTEERENABLE)
#define F_RSSSYNSTEERENABLE    V_RSSSYNSTEERENABLE(1U)

#define S_ISSFROMCPLENABLE    11
#define V_ISSFROMCPLENABLE(x) ((x) << S_ISSFROMCPLENABLE)
#define F_ISSFROMCPLENABLE    V_ISSFROMCPLENABLE(1U)

#define A_TP_DB_CONFIG 0x7d0c

#define S_DBMAXOPCNT    24
#define M_DBMAXOPCNT    0xffU
#define V_DBMAXOPCNT(x) ((x) << S_DBMAXOPCNT)
#define G_DBMAXOPCNT(x) (((x) >> S_DBMAXOPCNT) & M_DBMAXOPCNT)

#define S_CXMAXOPCNTDISABLE    23
#define V_CXMAXOPCNTDISABLE(x) ((x) << S_CXMAXOPCNTDISABLE)
#define F_CXMAXOPCNTDISABLE    V_CXMAXOPCNTDISABLE(1U)

#define S_CXMAXOPCNT    16
#define M_CXMAXOPCNT    0x7fU
#define V_CXMAXOPCNT(x) ((x) << S_CXMAXOPCNT)
#define G_CXMAXOPCNT(x) (((x) >> S_CXMAXOPCNT) & M_CXMAXOPCNT)

#define S_TXMAXOPCNTDISABLE    15
#define V_TXMAXOPCNTDISABLE(x) ((x) << S_TXMAXOPCNTDISABLE)
#define F_TXMAXOPCNTDISABLE    V_TXMAXOPCNTDISABLE(1U)

#define S_TXMAXOPCNT    8
#define M_TXMAXOPCNT    0x7fU
#define V_TXMAXOPCNT(x) ((x) << S_TXMAXOPCNT)
#define G_TXMAXOPCNT(x) (((x) >> S_TXMAXOPCNT) & M_TXMAXOPCNT)

#define S_RXMAXOPCNTDISABLE    7
#define V_RXMAXOPCNTDISABLE(x) ((x) << S_RXMAXOPCNTDISABLE)
#define F_RXMAXOPCNTDISABLE    V_RXMAXOPCNTDISABLE(1U)

#define S_RXMAXOPCNT    0
#define M_RXMAXOPCNT    0x7fU
#define V_RXMAXOPCNT(x) ((x) << S_RXMAXOPCNT)
#define G_RXMAXOPCNT(x) (((x) >> S_RXMAXOPCNT) & M_RXMAXOPCNT)

#define A_TP_CMM_TCB_BASE 0x7d10
#define A_TP_CMM_MM_BASE 0x7d14
#define A_TP_CMM_TIMER_BASE 0x7d18
#define A_TP_CMM_MM_FLST_SIZE 0x7d1c

#define S_RXPOOLSIZE    16
#define M_RXPOOLSIZE    0xffffU
#define V_RXPOOLSIZE(x) ((x) << S_RXPOOLSIZE)
#define G_RXPOOLSIZE(x) (((x) >> S_RXPOOLSIZE) & M_RXPOOLSIZE)

#define S_TXPOOLSIZE    0
#define M_TXPOOLSIZE    0xffffU
#define V_TXPOOLSIZE(x) ((x) << S_TXPOOLSIZE)
#define G_TXPOOLSIZE(x) (((x) >> S_TXPOOLSIZE) & M_TXPOOLSIZE)

#define A_TP_PMM_TX_BASE 0x7d20
#define A_TP_PMM_DEFRAG_BASE 0x7d24
#define A_TP_PMM_RX_BASE 0x7d28
#define A_TP_PMM_RX_PAGE_SIZE 0x7d2c
#define A_TP_PMM_RX_MAX_PAGE 0x7d30

#define S_PMRXNUMCHN    31
#define V_PMRXNUMCHN(x) ((x) << S_PMRXNUMCHN)
#define F_PMRXNUMCHN    V_PMRXNUMCHN(1U)

#define S_PMRXMAXPAGE    0
#define M_PMRXMAXPAGE    0x1fffffU
#define V_PMRXMAXPAGE(x) ((x) << S_PMRXMAXPAGE)
#define G_PMRXMAXPAGE(x) (((x) >> S_PMRXMAXPAGE) & M_PMRXMAXPAGE)

#define A_TP_PMM_TX_PAGE_SIZE 0x7d34
#define A_TP_PMM_TX_MAX_PAGE 0x7d38

#define S_PMTXNUMCHN    30
#define M_PMTXNUMCHN    0x3U
#define V_PMTXNUMCHN(x) ((x) << S_PMTXNUMCHN)
#define G_PMTXNUMCHN(x) (((x) >> S_PMTXNUMCHN) & M_PMTXNUMCHN)

#define S_PMTXMAXPAGE    0
#define M_PMTXMAXPAGE    0x1fffffU
#define V_PMTXMAXPAGE(x) ((x) << S_PMTXMAXPAGE)
#define G_PMTXMAXPAGE(x) (((x) >> S_PMTXMAXPAGE) & M_PMTXMAXPAGE)

#define A_TP_TCP_OPTIONS 0x7d40

#define S_MTUDEFAULT    16
#define M_MTUDEFAULT    0xffffU
#define V_MTUDEFAULT(x) ((x) << S_MTUDEFAULT)
#define G_MTUDEFAULT(x) (((x) >> S_MTUDEFAULT) & M_MTUDEFAULT)

#define S_MTUENABLE    10
#define V_MTUENABLE(x) ((x) << S_MTUENABLE)
#define F_MTUENABLE    V_MTUENABLE(1U)

#define S_SACKTX    9
#define V_SACKTX(x) ((x) << S_SACKTX)
#define F_SACKTX    V_SACKTX(1U)

#define S_SACKRX    8
#define V_SACKRX(x) ((x) << S_SACKRX)
#define F_SACKRX    V_SACKRX(1U)

#define S_SACKMODE    4
#define M_SACKMODE    0x3U
#define V_SACKMODE(x) ((x) << S_SACKMODE)
#define G_SACKMODE(x) (((x) >> S_SACKMODE) & M_SACKMODE)

#define S_WINDOWSCALEMODE    2
#define M_WINDOWSCALEMODE    0x3U
#define V_WINDOWSCALEMODE(x) ((x) << S_WINDOWSCALEMODE)
#define G_WINDOWSCALEMODE(x) (((x) >> S_WINDOWSCALEMODE) & M_WINDOWSCALEMODE)

#define S_TIMESTAMPSMODE    0
#define M_TIMESTAMPSMODE    0x3U
#define V_TIMESTAMPSMODE(x) ((x) << S_TIMESTAMPSMODE)
#define G_TIMESTAMPSMODE(x) (((x) >> S_TIMESTAMPSMODE) & M_TIMESTAMPSMODE)

#define A_TP_DACK_CONFIG 0x7d44

#define S_AUTOSTATE3    30
#define M_AUTOSTATE3    0x3U
#define V_AUTOSTATE3(x) ((x) << S_AUTOSTATE3)
#define G_AUTOSTATE3(x) (((x) >> S_AUTOSTATE3) & M_AUTOSTATE3)

#define S_AUTOSTATE2    28
#define M_AUTOSTATE2    0x3U
#define V_AUTOSTATE2(x) ((x) << S_AUTOSTATE2)
#define G_AUTOSTATE2(x) (((x) >> S_AUTOSTATE2) & M_AUTOSTATE2)

#define S_AUTOSTATE1    26
#define M_AUTOSTATE1    0x3U
#define V_AUTOSTATE1(x) ((x) << S_AUTOSTATE1)
#define G_AUTOSTATE1(x) (((x) >> S_AUTOSTATE1) & M_AUTOSTATE1)

#define S_BYTETHRESHOLD    8
#define M_BYTETHRESHOLD    0x3ffffU
#define V_BYTETHRESHOLD(x) ((x) << S_BYTETHRESHOLD)
#define G_BYTETHRESHOLD(x) (((x) >> S_BYTETHRESHOLD) & M_BYTETHRESHOLD)

#define S_MSSTHRESHOLD    4
#define M_MSSTHRESHOLD    0x7U
#define V_MSSTHRESHOLD(x) ((x) << S_MSSTHRESHOLD)
#define G_MSSTHRESHOLD(x) (((x) >> S_MSSTHRESHOLD) & M_MSSTHRESHOLD)

#define S_AUTOCAREFUL    2
#define V_AUTOCAREFUL(x) ((x) << S_AUTOCAREFUL)
#define F_AUTOCAREFUL    V_AUTOCAREFUL(1U)

#define S_AUTOENABLE    1
#define V_AUTOENABLE(x) ((x) << S_AUTOENABLE)
#define F_AUTOENABLE    V_AUTOENABLE(1U)

#define S_MODE    0
#define V_MODE(x) ((x) << S_MODE)
#define F_MODE    V_MODE(1U)

#define A_TP_PC_CONFIG 0x7d48

#define S_CMCACHEDISABLE    31
#define V_CMCACHEDISABLE(x) ((x) << S_CMCACHEDISABLE)
#define F_CMCACHEDISABLE    V_CMCACHEDISABLE(1U)

#define S_ENABLEOCSPIFULL    30
#define V_ENABLEOCSPIFULL(x) ((x) << S_ENABLEOCSPIFULL)
#define F_ENABLEOCSPIFULL    V_ENABLEOCSPIFULL(1U)

#define S_ENABLEFLMERRORDDP    29
#define V_ENABLEFLMERRORDDP(x) ((x) << S_ENABLEFLMERRORDDP)
#define F_ENABLEFLMERRORDDP    V_ENABLEFLMERRORDDP(1U)

#define S_LOCKTID    28
#define V_LOCKTID(x) ((x) << S_LOCKTID)
#define F_LOCKTID    V_LOCKTID(1U)

#define S_DISABLEINVPEND    27
#define V_DISABLEINVPEND(x) ((x) << S_DISABLEINVPEND)
#define F_DISABLEINVPEND    V_DISABLEINVPEND(1U)

#define S_ENABLEFILTERCOUNT    26
#define V_ENABLEFILTERCOUNT(x) ((x) << S_ENABLEFILTERCOUNT)
#define F_ENABLEFILTERCOUNT    V_ENABLEFILTERCOUNT(1U)

#define S_RDDPCONGEN    25
#define V_RDDPCONGEN(x) ((x) << S_RDDPCONGEN)
#define F_RDDPCONGEN    V_RDDPCONGEN(1U)

#define S_ENABLEONFLYPDU    24
#define V_ENABLEONFLYPDU(x) ((x) << S_ENABLEONFLYPDU)
#define F_ENABLEONFLYPDU    V_ENABLEONFLYPDU(1U)

#define S_ENABLEMINRCVWND    23
#define V_ENABLEMINRCVWND(x) ((x) << S_ENABLEMINRCVWND)
#define F_ENABLEMINRCVWND    V_ENABLEMINRCVWND(1U)

#define S_ENABLEMAXRCVWND    22
#define V_ENABLEMAXRCVWND(x) ((x) << S_ENABLEMAXRCVWND)
#define F_ENABLEMAXRCVWND    V_ENABLEMAXRCVWND(1U)

#define S_TXDATAACKRATEENABLE    21
#define V_TXDATAACKRATEENABLE(x) ((x) << S_TXDATAACKRATEENABLE)
#define F_TXDATAACKRATEENABLE    V_TXDATAACKRATEENABLE(1U)

#define S_TXDEFERENABLE    20
#define V_TXDEFERENABLE(x) ((x) << S_TXDEFERENABLE)
#define F_TXDEFERENABLE    V_TXDEFERENABLE(1U)

#define S_RXCONGESTIONMODE    19
#define V_RXCONGESTIONMODE(x) ((x) << S_RXCONGESTIONMODE)
#define F_RXCONGESTIONMODE    V_RXCONGESTIONMODE(1U)

#define S_HEARBEATONCEDACK    18
#define V_HEARBEATONCEDACK(x) ((x) << S_HEARBEATONCEDACK)
#define F_HEARBEATONCEDACK    V_HEARBEATONCEDACK(1U)

#define S_HEARBEATONCEHEAP    17
#define V_HEARBEATONCEHEAP(x) ((x) << S_HEARBEATONCEHEAP)
#define F_HEARBEATONCEHEAP    V_HEARBEATONCEHEAP(1U)

#define S_HEARBEATDACK    16
#define V_HEARBEATDACK(x) ((x) << S_HEARBEATDACK)
#define F_HEARBEATDACK    V_HEARBEATDACK(1U)

#define S_TXCONGESTIONMODE    15
#define V_TXCONGESTIONMODE(x) ((x) << S_TXCONGESTIONMODE)
#define F_TXCONGESTIONMODE    V_TXCONGESTIONMODE(1U)

#define S_ACCEPTLATESTRCVADV    14
#define V_ACCEPTLATESTRCVADV(x) ((x) << S_ACCEPTLATESTRCVADV)
#define F_ACCEPTLATESTRCVADV    V_ACCEPTLATESTRCVADV(1U)

#define S_DISABLESYNDATA    13
#define V_DISABLESYNDATA(x) ((x) << S_DISABLESYNDATA)
#define F_DISABLESYNDATA    V_DISABLESYNDATA(1U)

#define S_DISABLEWINDOWPSH    12
#define V_DISABLEWINDOWPSH(x) ((x) << S_DISABLEWINDOWPSH)
#define F_DISABLEWINDOWPSH    V_DISABLEWINDOWPSH(1U)

#define S_DISABLEFINOLDDATA    11
#define V_DISABLEFINOLDDATA(x) ((x) << S_DISABLEFINOLDDATA)
#define F_DISABLEFINOLDDATA    V_DISABLEFINOLDDATA(1U)

#define S_ENABLEFLMERROR    10
#define V_ENABLEFLMERROR(x) ((x) << S_ENABLEFLMERROR)
#define F_ENABLEFLMERROR    V_ENABLEFLMERROR(1U)

#define S_ENABLEOPTMTU    9
#define V_ENABLEOPTMTU(x) ((x) << S_ENABLEOPTMTU)
#define F_ENABLEOPTMTU    V_ENABLEOPTMTU(1U)

#define S_FILTERPEERFIN    8
#define V_FILTERPEERFIN(x) ((x) << S_FILTERPEERFIN)
#define F_FILTERPEERFIN    V_FILTERPEERFIN(1U)

#define S_ENABLEFEEDBACKSEND    7
#define V_ENABLEFEEDBACKSEND(x) ((x) << S_ENABLEFEEDBACKSEND)
#define F_ENABLEFEEDBACKSEND    V_ENABLEFEEDBACKSEND(1U)

#define S_ENABLERDMAERROR    6
#define V_ENABLERDMAERROR(x) ((x) << S_ENABLERDMAERROR)
#define F_ENABLERDMAERROR    V_ENABLERDMAERROR(1U)

#define S_ENABLEDDPFLOWCONTROL    5
#define V_ENABLEDDPFLOWCONTROL(x) ((x) << S_ENABLEDDPFLOWCONTROL)
#define F_ENABLEDDPFLOWCONTROL    V_ENABLEDDPFLOWCONTROL(1U)

#define S_DISABLEHELDFIN    4
#define V_DISABLEHELDFIN(x) ((x) << S_DISABLEHELDFIN)
#define F_DISABLEHELDFIN    V_DISABLEHELDFIN(1U)

#define S_ENABLEOFDOVLAN    3
#define V_ENABLEOFDOVLAN(x) ((x) << S_ENABLEOFDOVLAN)
#define F_ENABLEOFDOVLAN    V_ENABLEOFDOVLAN(1U)

#define S_DISABLETIMEWAIT    2
#define V_DISABLETIMEWAIT(x) ((x) << S_DISABLETIMEWAIT)
#define F_DISABLETIMEWAIT    V_DISABLETIMEWAIT(1U)

#define S_ENABLEVLANCHECK    1
#define V_ENABLEVLANCHECK(x) ((x) << S_ENABLEVLANCHECK)
#define F_ENABLEVLANCHECK    V_ENABLEVLANCHECK(1U)

#define S_TXDATAACKPAGEENABLE    0
#define V_TXDATAACKPAGEENABLE(x) ((x) << S_TXDATAACKPAGEENABLE)
#define F_TXDATAACKPAGEENABLE    V_TXDATAACKPAGEENABLE(1U)

#define S_ENABLEFILTERNAT    5
#define V_ENABLEFILTERNAT(x) ((x) << S_ENABLEFILTERNAT)
#define F_ENABLEFILTERNAT    V_ENABLEFILTERNAT(1U)

#define A_TP_PC_CONFIG2 0x7d4c

#define S_ENABLEMTUVFMODE    31
#define V_ENABLEMTUVFMODE(x) ((x) << S_ENABLEMTUVFMODE)
#define F_ENABLEMTUVFMODE    V_ENABLEMTUVFMODE(1U)

#define S_ENABLEMIBVFMODE    30
#define V_ENABLEMIBVFMODE(x) ((x) << S_ENABLEMIBVFMODE)
#define F_ENABLEMIBVFMODE    V_ENABLEMIBVFMODE(1U)

#define S_DISABLELBKCHECK    29
#define V_DISABLELBKCHECK(x) ((x) << S_DISABLELBKCHECK)
#define F_DISABLELBKCHECK    V_DISABLELBKCHECK(1U)

#define S_ENABLEURGDDPOFF    28
#define V_ENABLEURGDDPOFF(x) ((x) << S_ENABLEURGDDPOFF)
#define F_ENABLEURGDDPOFF    V_ENABLEURGDDPOFF(1U)

#define S_ENABLEFILTERLPBK    27
#define V_ENABLEFILTERLPBK(x) ((x) << S_ENABLEFILTERLPBK)
#define F_ENABLEFILTERLPBK    V_ENABLEFILTERLPBK(1U)

#define S_DISABLETBLMMGR    26
#define V_DISABLETBLMMGR(x) ((x) << S_DISABLETBLMMGR)
#define F_DISABLETBLMMGR    V_DISABLETBLMMGR(1U)

#define S_CNGRECSNDNXT    25
#define V_CNGRECSNDNXT(x) ((x) << S_CNGRECSNDNXT)
#define F_CNGRECSNDNXT    V_CNGRECSNDNXT(1U)

#define S_ENABLELBKCHN    24
#define V_ENABLELBKCHN(x) ((x) << S_ENABLELBKCHN)
#define F_ENABLELBKCHN    V_ENABLELBKCHN(1U)

#define S_ENABLELROECN    23
#define V_ENABLELROECN(x) ((x) << S_ENABLELROECN)
#define F_ENABLELROECN    V_ENABLELROECN(1U)

#define S_ENABLEPCMDCHECK    22
#define V_ENABLEPCMDCHECK(x) ((x) << S_ENABLEPCMDCHECK)
#define F_ENABLEPCMDCHECK    V_ENABLEPCMDCHECK(1U)

#define S_ENABLEELBKAFULL    21
#define V_ENABLEELBKAFULL(x) ((x) << S_ENABLEELBKAFULL)
#define F_ENABLEELBKAFULL    V_ENABLEELBKAFULL(1U)

#define S_ENABLECLBKAFULL    20
#define V_ENABLECLBKAFULL(x) ((x) << S_ENABLECLBKAFULL)
#define F_ENABLECLBKAFULL    V_ENABLECLBKAFULL(1U)

#define S_ENABLEOESPIFULL    19
#define V_ENABLEOESPIFULL(x) ((x) << S_ENABLEOESPIFULL)
#define F_ENABLEOESPIFULL    V_ENABLEOESPIFULL(1U)

#define S_DISABLEHITCHECK    18
#define V_DISABLEHITCHECK(x) ((x) << S_DISABLEHITCHECK)
#define F_DISABLEHITCHECK    V_DISABLEHITCHECK(1U)

#define S_ENABLERSSERRCHECK    17
#define V_ENABLERSSERRCHECK(x) ((x) << S_ENABLERSSERRCHECK)
#define F_ENABLERSSERRCHECK    V_ENABLERSSERRCHECK(1U)

#define S_DISABLENEWPSHFLAG    16
#define V_DISABLENEWPSHFLAG(x) ((x) << S_DISABLENEWPSHFLAG)
#define F_DISABLENEWPSHFLAG    V_DISABLENEWPSHFLAG(1U)

#define S_ENABLERDDPRCVADVCLR    15
#define V_ENABLERDDPRCVADVCLR(x) ((x) << S_ENABLERDDPRCVADVCLR)
#define F_ENABLERDDPRCVADVCLR    V_ENABLERDDPRCVADVCLR(1U)

#define S_ENABLETXDATAARPMISS    14
#define V_ENABLETXDATAARPMISS(x) ((x) << S_ENABLETXDATAARPMISS)
#define F_ENABLETXDATAARPMISS    V_ENABLETXDATAARPMISS(1U)

#define S_ENABLEARPMISS    13
#define V_ENABLEARPMISS(x) ((x) << S_ENABLEARPMISS)
#define F_ENABLEARPMISS    V_ENABLEARPMISS(1U)

#define S_ENABLERSTPAWS    12
#define V_ENABLERSTPAWS(x) ((x) << S_ENABLERSTPAWS)
#define F_ENABLERSTPAWS    V_ENABLERSTPAWS(1U)

#define S_ENABLEIPV6RSS    11
#define V_ENABLEIPV6RSS(x) ((x) << S_ENABLEIPV6RSS)
#define F_ENABLEIPV6RSS    V_ENABLEIPV6RSS(1U)

#define S_ENABLENONOFDHYBRSS    10
#define V_ENABLENONOFDHYBRSS(x) ((x) << S_ENABLENONOFDHYBRSS)
#define F_ENABLENONOFDHYBRSS    V_ENABLENONOFDHYBRSS(1U)

#define S_ENABLEUDP4TUPRSS    9
#define V_ENABLEUDP4TUPRSS(x) ((x) << S_ENABLEUDP4TUPRSS)
#define F_ENABLEUDP4TUPRSS    V_ENABLEUDP4TUPRSS(1U)

#define S_ENABLERXPKTTMSTPRSS    8
#define V_ENABLERXPKTTMSTPRSS(x) ((x) << S_ENABLERXPKTTMSTPRSS)
#define F_ENABLERXPKTTMSTPRSS    V_ENABLERXPKTTMSTPRSS(1U)

#define S_ENABLEEPCMDAFULL    7
#define V_ENABLEEPCMDAFULL(x) ((x) << S_ENABLEEPCMDAFULL)
#define F_ENABLEEPCMDAFULL    V_ENABLEEPCMDAFULL(1U)

#define S_ENABLECPCMDAFULL    6
#define V_ENABLECPCMDAFULL(x) ((x) << S_ENABLECPCMDAFULL)
#define F_ENABLECPCMDAFULL    V_ENABLECPCMDAFULL(1U)

#define S_ENABLEEHDRAFULL    5
#define V_ENABLEEHDRAFULL(x) ((x) << S_ENABLEEHDRAFULL)
#define F_ENABLEEHDRAFULL    V_ENABLEEHDRAFULL(1U)

#define S_ENABLECHDRAFULL    4
#define V_ENABLECHDRAFULL(x) ((x) << S_ENABLECHDRAFULL)
#define F_ENABLECHDRAFULL    V_ENABLECHDRAFULL(1U)

#define S_ENABLEEMACAFULL    3
#define V_ENABLEEMACAFULL(x) ((x) << S_ENABLEEMACAFULL)
#define F_ENABLEEMACAFULL    V_ENABLEEMACAFULL(1U)

#define S_ENABLENONOFDTIDRSS    2
#define V_ENABLENONOFDTIDRSS(x) ((x) << S_ENABLENONOFDTIDRSS)
#define F_ENABLENONOFDTIDRSS    V_ENABLENONOFDTIDRSS(1U)

#define S_ENABLENONOFDTCBRSS    1
#define V_ENABLENONOFDTCBRSS(x) ((x) << S_ENABLENONOFDTCBRSS)
#define F_ENABLENONOFDTCBRSS    V_ENABLENONOFDTCBRSS(1U)

#define S_ENABLETNLOFDCLOSED    0
#define V_ENABLETNLOFDCLOSED(x) ((x) << S_ENABLETNLOFDCLOSED)
#define F_ENABLETNLOFDCLOSED    V_ENABLETNLOFDCLOSED(1U)

#define S_ENABLEFINDDPOFF    14
#define V_ENABLEFINDDPOFF(x) ((x) << S_ENABLEFINDDPOFF)
#define F_ENABLEFINDDPOFF    V_ENABLEFINDDPOFF(1U)

#define A_TP_TCP_BACKOFF_REG0 0x7d50

#define S_TIMERBACKOFFINDEX3    24
#define M_TIMERBACKOFFINDEX3    0xffU
#define V_TIMERBACKOFFINDEX3(x) ((x) << S_TIMERBACKOFFINDEX3)
#define G_TIMERBACKOFFINDEX3(x) (((x) >> S_TIMERBACKOFFINDEX3) & M_TIMERBACKOFFINDEX3)

#define S_TIMERBACKOFFINDEX2    16
#define M_TIMERBACKOFFINDEX2    0xffU
#define V_TIMERBACKOFFINDEX2(x) ((x) << S_TIMERBACKOFFINDEX2)
#define G_TIMERBACKOFFINDEX2(x) (((x) >> S_TIMERBACKOFFINDEX2) & M_TIMERBACKOFFINDEX2)

#define S_TIMERBACKOFFINDEX1    8
#define M_TIMERBACKOFFINDEX1    0xffU
#define V_TIMERBACKOFFINDEX1(x) ((x) << S_TIMERBACKOFFINDEX1)
#define G_TIMERBACKOFFINDEX1(x) (((x) >> S_TIMERBACKOFFINDEX1) & M_TIMERBACKOFFINDEX1)

#define S_TIMERBACKOFFINDEX0    0
#define M_TIMERBACKOFFINDEX0    0xffU
#define V_TIMERBACKOFFINDEX0(x) ((x) << S_TIMERBACKOFFINDEX0)
#define G_TIMERBACKOFFINDEX0(x) (((x) >> S_TIMERBACKOFFINDEX0) & M_TIMERBACKOFFINDEX0)

#define A_TP_TCP_BACKOFF_REG1 0x7d54

#define S_TIMERBACKOFFINDEX7    24
#define M_TIMERBACKOFFINDEX7    0xffU
#define V_TIMERBACKOFFINDEX7(x) ((x) << S_TIMERBACKOFFINDEX7)
#define G_TIMERBACKOFFINDEX7(x) (((x) >> S_TIMERBACKOFFINDEX7) & M_TIMERBACKOFFINDEX7)

#define S_TIMERBACKOFFINDEX6    16
#define M_TIMERBACKOFFINDEX6    0xffU
#define V_TIMERBACKOFFINDEX6(x) ((x) << S_TIMERBACKOFFINDEX6)
#define G_TIMERBACKOFFINDEX6(x) (((x) >> S_TIMERBACKOFFINDEX6) & M_TIMERBACKOFFINDEX6)

#define S_TIMERBACKOFFINDEX5    8
#define M_TIMERBACKOFFINDEX5    0xffU
#define V_TIMERBACKOFFINDEX5(x) ((x) << S_TIMERBACKOFFINDEX5)
#define G_TIMERBACKOFFINDEX5(x) (((x) >> S_TIMERBACKOFFINDEX5) & M_TIMERBACKOFFINDEX5)

#define S_TIMERBACKOFFINDEX4    0
#define M_TIMERBACKOFFINDEX4    0xffU
#define V_TIMERBACKOFFINDEX4(x) ((x) << S_TIMERBACKOFFINDEX4)
#define G_TIMERBACKOFFINDEX4(x) (((x) >> S_TIMERBACKOFFINDEX4) & M_TIMERBACKOFFINDEX4)

#define A_TP_TCP_BACKOFF_REG2 0x7d58

#define S_TIMERBACKOFFINDEX11    24
#define M_TIMERBACKOFFINDEX11    0xffU
#define V_TIMERBACKOFFINDEX11(x) ((x) << S_TIMERBACKOFFINDEX11)
#define G_TIMERBACKOFFINDEX11(x) (((x) >> S_TIMERBACKOFFINDEX11) & M_TIMERBACKOFFINDEX11)

#define S_TIMERBACKOFFINDEX10    16
#define M_TIMERBACKOFFINDEX10    0xffU
#define V_TIMERBACKOFFINDEX10(x) ((x) << S_TIMERBACKOFFINDEX10)
#define G_TIMERBACKOFFINDEX10(x) (((x) >> S_TIMERBACKOFFINDEX10) & M_TIMERBACKOFFINDEX10)

#define S_TIMERBACKOFFINDEX9    8
#define M_TIMERBACKOFFINDEX9    0xffU
#define V_TIMERBACKOFFINDEX9(x) ((x) << S_TIMERBACKOFFINDEX9)
#define G_TIMERBACKOFFINDEX9(x) (((x) >> S_TIMERBACKOFFINDEX9) & M_TIMERBACKOFFINDEX9)

#define S_TIMERBACKOFFINDEX8    0
#define M_TIMERBACKOFFINDEX8    0xffU
#define V_TIMERBACKOFFINDEX8(x) ((x) << S_TIMERBACKOFFINDEX8)
#define G_TIMERBACKOFFINDEX8(x) (((x) >> S_TIMERBACKOFFINDEX8) & M_TIMERBACKOFFINDEX8)

#define A_TP_TCP_BACKOFF_REG3 0x7d5c

#define S_TIMERBACKOFFINDEX15    24
#define M_TIMERBACKOFFINDEX15    0xffU
#define V_TIMERBACKOFFINDEX15(x) ((x) << S_TIMERBACKOFFINDEX15)
#define G_TIMERBACKOFFINDEX15(x) (((x) >> S_TIMERBACKOFFINDEX15) & M_TIMERBACKOFFINDEX15)

#define S_TIMERBACKOFFINDEX14    16
#define M_TIMERBACKOFFINDEX14    0xffU
#define V_TIMERBACKOFFINDEX14(x) ((x) << S_TIMERBACKOFFINDEX14)
#define G_TIMERBACKOFFINDEX14(x) (((x) >> S_TIMERBACKOFFINDEX14) & M_TIMERBACKOFFINDEX14)

#define S_TIMERBACKOFFINDEX13    8
#define M_TIMERBACKOFFINDEX13    0xffU
#define V_TIMERBACKOFFINDEX13(x) ((x) << S_TIMERBACKOFFINDEX13)
#define G_TIMERBACKOFFINDEX13(x) (((x) >> S_TIMERBACKOFFINDEX13) & M_TIMERBACKOFFINDEX13)

#define S_TIMERBACKOFFINDEX12    0
#define M_TIMERBACKOFFINDEX12    0xffU
#define V_TIMERBACKOFFINDEX12(x) ((x) << S_TIMERBACKOFFINDEX12)
#define G_TIMERBACKOFFINDEX12(x) (((x) >> S_TIMERBACKOFFINDEX12) & M_TIMERBACKOFFINDEX12)

#define A_TP_PARA_REG0 0x7d60

#define S_INITCWNDIDLE    27
#define V_INITCWNDIDLE(x) ((x) << S_INITCWNDIDLE)
#define F_INITCWNDIDLE    V_INITCWNDIDLE(1U)

#define S_INITCWND    24
#define M_INITCWND    0x7U
#define V_INITCWND(x) ((x) << S_INITCWND)
#define G_INITCWND(x) (((x) >> S_INITCWND) & M_INITCWND)

#define S_DUPACKTHRESH    20
#define M_DUPACKTHRESH    0xfU
#define V_DUPACKTHRESH(x) ((x) << S_DUPACKTHRESH)
#define G_DUPACKTHRESH(x) (((x) >> S_DUPACKTHRESH) & M_DUPACKTHRESH)

#define S_CPLERRENABLE    12
#define V_CPLERRENABLE(x) ((x) << S_CPLERRENABLE)
#define F_CPLERRENABLE    V_CPLERRENABLE(1U)

#define S_FASTTNLCNT    11
#define V_FASTTNLCNT(x) ((x) << S_FASTTNLCNT)
#define F_FASTTNLCNT    V_FASTTNLCNT(1U)

#define S_FASTTBLCNT    10
#define V_FASTTBLCNT(x) ((x) << S_FASTTBLCNT)
#define F_FASTTBLCNT    V_FASTTBLCNT(1U)

#define S_TPTCAMKEY    9
#define V_TPTCAMKEY(x) ((x) << S_TPTCAMKEY)
#define F_TPTCAMKEY    V_TPTCAMKEY(1U)

#define S_SWSMODE    8
#define V_SWSMODE(x) ((x) << S_SWSMODE)
#define F_SWSMODE    V_SWSMODE(1U)

#define S_TSMPMODE    6
#define M_TSMPMODE    0x3U
#define V_TSMPMODE(x) ((x) << S_TSMPMODE)
#define G_TSMPMODE(x) (((x) >> S_TSMPMODE) & M_TSMPMODE)

#define S_BYTECOUNTLIMIT    4
#define M_BYTECOUNTLIMIT    0x3U
#define V_BYTECOUNTLIMIT(x) ((x) << S_BYTECOUNTLIMIT)
#define G_BYTECOUNTLIMIT(x) (((x) >> S_BYTECOUNTLIMIT) & M_BYTECOUNTLIMIT)

#define S_SWSSHOVE    3
#define V_SWSSHOVE(x) ((x) << S_SWSSHOVE)
#define F_SWSSHOVE    V_SWSSHOVE(1U)

#define S_TBLTIMER    2
#define V_TBLTIMER(x) ((x) << S_TBLTIMER)
#define F_TBLTIMER    V_TBLTIMER(1U)

#define S_RXTPACE    1
#define V_RXTPACE(x) ((x) << S_RXTPACE)
#define F_RXTPACE    V_RXTPACE(1U)

#define S_SWSTIMER    0
#define V_SWSTIMER(x) ((x) << S_SWSTIMER)
#define F_SWSTIMER    V_SWSTIMER(1U)

#define S_LIMTXTHRESH    28
#define M_LIMTXTHRESH    0xfU
#define V_LIMTXTHRESH(x) ((x) << S_LIMTXTHRESH)
#define G_LIMTXTHRESH(x) (((x) >> S_LIMTXTHRESH) & M_LIMTXTHRESH)

#define S_CHNERRENABLE    14
#define V_CHNERRENABLE(x) ((x) << S_CHNERRENABLE)
#define F_CHNERRENABLE    V_CHNERRENABLE(1U)

#define S_SETTIMEENABLE    13
#define V_SETTIMEENABLE(x) ((x) << S_SETTIMEENABLE)
#define F_SETTIMEENABLE    V_SETTIMEENABLE(1U)

#define A_TP_PARA_REG1 0x7d64

#define S_INITRWND    16
#define M_INITRWND    0xffffU
#define V_INITRWND(x) ((x) << S_INITRWND)
#define G_INITRWND(x) (((x) >> S_INITRWND) & M_INITRWND)

#define S_INITIALSSTHRESH    0
#define M_INITIALSSTHRESH    0xffffU
#define V_INITIALSSTHRESH(x) ((x) << S_INITIALSSTHRESH)
#define G_INITIALSSTHRESH(x) (((x) >> S_INITIALSSTHRESH) & M_INITIALSSTHRESH)

#define A_TP_PARA_REG2 0x7d68

#define S_MAXRXDATA    16
#define M_MAXRXDATA    0xffffU
#define V_MAXRXDATA(x) ((x) << S_MAXRXDATA)
#define G_MAXRXDATA(x) (((x) >> S_MAXRXDATA) & M_MAXRXDATA)

#define S_RXCOALESCESIZE    0
#define M_RXCOALESCESIZE    0xffffU
#define V_RXCOALESCESIZE(x) ((x) << S_RXCOALESCESIZE)
#define G_RXCOALESCESIZE(x) (((x) >> S_RXCOALESCESIZE) & M_RXCOALESCESIZE)

#define A_TP_PARA_REG3 0x7d6c

#define S_ENABLETNLCNGLPBK    31
#define V_ENABLETNLCNGLPBK(x) ((x) << S_ENABLETNLCNGLPBK)
#define F_ENABLETNLCNGLPBK    V_ENABLETNLCNGLPBK(1U)

#define S_ENABLETNLCNGFIFO    30
#define V_ENABLETNLCNGFIFO(x) ((x) << S_ENABLETNLCNGFIFO)
#define F_ENABLETNLCNGFIFO    V_ENABLETNLCNGFIFO(1U)

#define S_ENABLETNLCNGHDR    29
#define V_ENABLETNLCNGHDR(x) ((x) << S_ENABLETNLCNGHDR)
#define F_ENABLETNLCNGHDR    V_ENABLETNLCNGHDR(1U)

#define S_ENABLETNLCNGSGE    28
#define V_ENABLETNLCNGSGE(x) ((x) << S_ENABLETNLCNGSGE)
#define F_ENABLETNLCNGSGE    V_ENABLETNLCNGSGE(1U)

#define S_RXMACCHECK    27
#define V_RXMACCHECK(x) ((x) << S_RXMACCHECK)
#define F_RXMACCHECK    V_RXMACCHECK(1U)

#define S_RXSYNFILTER    26
#define V_RXSYNFILTER(x) ((x) << S_RXSYNFILTER)
#define F_RXSYNFILTER    V_RXSYNFILTER(1U)

#define S_CNGCTRLECN    25
#define V_CNGCTRLECN(x) ((x) << S_CNGCTRLECN)
#define F_CNGCTRLECN    V_CNGCTRLECN(1U)

#define S_RXDDPOFFINIT    24
#define V_RXDDPOFFINIT(x) ((x) << S_RXDDPOFFINIT)
#define F_RXDDPOFFINIT    V_RXDDPOFFINIT(1U)

#define S_TUNNELCNGDROP3    23
#define V_TUNNELCNGDROP3(x) ((x) << S_TUNNELCNGDROP3)
#define F_TUNNELCNGDROP3    V_TUNNELCNGDROP3(1U)

#define S_TUNNELCNGDROP2    22
#define V_TUNNELCNGDROP2(x) ((x) << S_TUNNELCNGDROP2)
#define F_TUNNELCNGDROP2    V_TUNNELCNGDROP2(1U)

#define S_TUNNELCNGDROP1    21
#define V_TUNNELCNGDROP1(x) ((x) << S_TUNNELCNGDROP1)
#define F_TUNNELCNGDROP1    V_TUNNELCNGDROP1(1U)

#define S_TUNNELCNGDROP0    20
#define V_TUNNELCNGDROP0(x) ((x) << S_TUNNELCNGDROP0)
#define F_TUNNELCNGDROP0    V_TUNNELCNGDROP0(1U)

#define S_TXDATAACKIDX    16
#define M_TXDATAACKIDX    0xfU
#define V_TXDATAACKIDX(x) ((x) << S_TXDATAACKIDX)
#define G_TXDATAACKIDX(x) (((x) >> S_TXDATAACKIDX) & M_TXDATAACKIDX)

#define S_RXFRAGENABLE    12
#define M_RXFRAGENABLE    0x7U
#define V_RXFRAGENABLE(x) ((x) << S_RXFRAGENABLE)
#define G_RXFRAGENABLE(x) (((x) >> S_RXFRAGENABLE) & M_RXFRAGENABLE)

#define S_TXPACEFIXEDSTRICT    11
#define V_TXPACEFIXEDSTRICT(x) ((x) << S_TXPACEFIXEDSTRICT)
#define F_TXPACEFIXEDSTRICT    V_TXPACEFIXEDSTRICT(1U)

#define S_TXPACEAUTOSTRICT    10
#define V_TXPACEAUTOSTRICT(x) ((x) << S_TXPACEAUTOSTRICT)
#define F_TXPACEAUTOSTRICT    V_TXPACEAUTOSTRICT(1U)

#define S_TXPACEFIXED    9
#define V_TXPACEFIXED(x) ((x) << S_TXPACEFIXED)
#define F_TXPACEFIXED    V_TXPACEFIXED(1U)

#define S_TXPACEAUTO    8
#define V_TXPACEAUTO(x) ((x) << S_TXPACEAUTO)
#define F_TXPACEAUTO    V_TXPACEAUTO(1U)

#define S_RXCHNTUNNEL    7
#define V_RXCHNTUNNEL(x) ((x) << S_RXCHNTUNNEL)
#define F_RXCHNTUNNEL    V_RXCHNTUNNEL(1U)

#define S_RXURGTUNNEL    6
#define V_RXURGTUNNEL(x) ((x) << S_RXURGTUNNEL)
#define F_RXURGTUNNEL    V_RXURGTUNNEL(1U)

#define S_RXURGMODE    5
#define V_RXURGMODE(x) ((x) << S_RXURGMODE)
#define F_RXURGMODE    V_RXURGMODE(1U)

#define S_TXURGMODE    4
#define V_TXURGMODE(x) ((x) << S_TXURGMODE)
#define F_TXURGMODE    V_TXURGMODE(1U)

#define S_CNGCTRLMODE    2
#define M_CNGCTRLMODE    0x3U
#define V_CNGCTRLMODE(x) ((x) << S_CNGCTRLMODE)
#define G_CNGCTRLMODE(x) (((x) >> S_CNGCTRLMODE) & M_CNGCTRLMODE)

#define S_RXCOALESCEENABLE    1
#define V_RXCOALESCEENABLE(x) ((x) << S_RXCOALESCEENABLE)
#define F_RXCOALESCEENABLE    V_RXCOALESCEENABLE(1U)

#define S_RXCOALESCEPSHEN    0
#define V_RXCOALESCEPSHEN(x) ((x) << S_RXCOALESCEPSHEN)
#define F_RXCOALESCEPSHEN    V_RXCOALESCEPSHEN(1U)

#define A_TP_PARA_REG4 0x7d70

#define S_HIGHSPEEDCFG    24
#define M_HIGHSPEEDCFG    0xffU
#define V_HIGHSPEEDCFG(x) ((x) << S_HIGHSPEEDCFG)
#define G_HIGHSPEEDCFG(x) (((x) >> S_HIGHSPEEDCFG) & M_HIGHSPEEDCFG)

#define S_NEWRENOCFG    16
#define M_NEWRENOCFG    0xffU
#define V_NEWRENOCFG(x) ((x) << S_NEWRENOCFG)
#define G_NEWRENOCFG(x) (((x) >> S_NEWRENOCFG) & M_NEWRENOCFG)

#define S_TAHOECFG    8
#define M_TAHOECFG    0xffU
#define V_TAHOECFG(x) ((x) << S_TAHOECFG)
#define G_TAHOECFG(x) (((x) >> S_TAHOECFG) & M_TAHOECFG)

#define S_RENOCFG    0
#define M_RENOCFG    0xffU
#define V_RENOCFG(x) ((x) << S_RENOCFG)
#define G_RENOCFG(x) (((x) >> S_RENOCFG) & M_RENOCFG)

#define S_IDLECWNDHIGHSPEED    28
#define V_IDLECWNDHIGHSPEED(x) ((x) << S_IDLECWNDHIGHSPEED)
#define F_IDLECWNDHIGHSPEED    V_IDLECWNDHIGHSPEED(1U)

#define S_RXMTCWNDHIGHSPEED    27
#define V_RXMTCWNDHIGHSPEED(x) ((x) << S_RXMTCWNDHIGHSPEED)
#define F_RXMTCWNDHIGHSPEED    V_RXMTCWNDHIGHSPEED(1U)

#define S_OVERDRIVEHIGHSPEED    25
#define M_OVERDRIVEHIGHSPEED    0x3U
#define V_OVERDRIVEHIGHSPEED(x) ((x) << S_OVERDRIVEHIGHSPEED)
#define G_OVERDRIVEHIGHSPEED(x) (((x) >> S_OVERDRIVEHIGHSPEED) & M_OVERDRIVEHIGHSPEED)

#define S_BYTECOUNTHIGHSPEED    24
#define V_BYTECOUNTHIGHSPEED(x) ((x) << S_BYTECOUNTHIGHSPEED)
#define F_BYTECOUNTHIGHSPEED    V_BYTECOUNTHIGHSPEED(1U)

#define S_IDLECWNDNEWRENO    20
#define V_IDLECWNDNEWRENO(x) ((x) << S_IDLECWNDNEWRENO)
#define F_IDLECWNDNEWRENO    V_IDLECWNDNEWRENO(1U)

#define S_RXMTCWNDNEWRENO    19
#define V_RXMTCWNDNEWRENO(x) ((x) << S_RXMTCWNDNEWRENO)
#define F_RXMTCWNDNEWRENO    V_RXMTCWNDNEWRENO(1U)

#define S_OVERDRIVENEWRENO    17
#define M_OVERDRIVENEWRENO    0x3U
#define V_OVERDRIVENEWRENO(x) ((x) << S_OVERDRIVENEWRENO)
#define G_OVERDRIVENEWRENO(x) (((x) >> S_OVERDRIVENEWRENO) & M_OVERDRIVENEWRENO)

#define S_BYTECOUNTNEWRENO    16
#define V_BYTECOUNTNEWRENO(x) ((x) << S_BYTECOUNTNEWRENO)
#define F_BYTECOUNTNEWRENO    V_BYTECOUNTNEWRENO(1U)

#define S_IDLECWNDTAHOE    12
#define V_IDLECWNDTAHOE(x) ((x) << S_IDLECWNDTAHOE)
#define F_IDLECWNDTAHOE    V_IDLECWNDTAHOE(1U)

#define S_RXMTCWNDTAHOE    11
#define V_RXMTCWNDTAHOE(x) ((x) << S_RXMTCWNDTAHOE)
#define F_RXMTCWNDTAHOE    V_RXMTCWNDTAHOE(1U)

#define S_OVERDRIVETAHOE    9
#define M_OVERDRIVETAHOE    0x3U
#define V_OVERDRIVETAHOE(x) ((x) << S_OVERDRIVETAHOE)
#define G_OVERDRIVETAHOE(x) (((x) >> S_OVERDRIVETAHOE) & M_OVERDRIVETAHOE)

#define S_BYTECOUNTTAHOE    8
#define V_BYTECOUNTTAHOE(x) ((x) << S_BYTECOUNTTAHOE)
#define F_BYTECOUNTTAHOE    V_BYTECOUNTTAHOE(1U)

#define S_IDLECWNDRENO    4
#define V_IDLECWNDRENO(x) ((x) << S_IDLECWNDRENO)
#define F_IDLECWNDRENO    V_IDLECWNDRENO(1U)

#define S_RXMTCWNDRENO    3
#define V_RXMTCWNDRENO(x) ((x) << S_RXMTCWNDRENO)
#define F_RXMTCWNDRENO    V_RXMTCWNDRENO(1U)

#define S_OVERDRIVERENO    1
#define M_OVERDRIVERENO    0x3U
#define V_OVERDRIVERENO(x) ((x) << S_OVERDRIVERENO)
#define G_OVERDRIVERENO(x) (((x) >> S_OVERDRIVERENO) & M_OVERDRIVERENO)

#define S_BYTECOUNTRENO    0
#define V_BYTECOUNTRENO(x) ((x) << S_BYTECOUNTRENO)
#define F_BYTECOUNTRENO    V_BYTECOUNTRENO(1U)

#define A_TP_PARA_REG5 0x7d74

#define S_INDICATESIZE    16
#define M_INDICATESIZE    0xffffU
#define V_INDICATESIZE(x) ((x) << S_INDICATESIZE)
#define G_INDICATESIZE(x) (((x) >> S_INDICATESIZE) & M_INDICATESIZE)

#define S_MAXPROXYSIZE    12
#define M_MAXPROXYSIZE    0xfU
#define V_MAXPROXYSIZE(x) ((x) << S_MAXPROXYSIZE)
#define G_MAXPROXYSIZE(x) (((x) >> S_MAXPROXYSIZE) & M_MAXPROXYSIZE)

#define S_ENABLEREADPDU    11
#define V_ENABLEREADPDU(x) ((x) << S_ENABLEREADPDU)
#define F_ENABLEREADPDU    V_ENABLEREADPDU(1U)

#define S_RXREADAHEAD    10
#define V_RXREADAHEAD(x) ((x) << S_RXREADAHEAD)
#define F_RXREADAHEAD    V_RXREADAHEAD(1U)

#define S_EMPTYRQENABLE    9
#define V_EMPTYRQENABLE(x) ((x) << S_EMPTYRQENABLE)
#define F_EMPTYRQENABLE    V_EMPTYRQENABLE(1U)

#define S_SCHDENABLE    8
#define V_SCHDENABLE(x) ((x) << S_SCHDENABLE)
#define F_SCHDENABLE    V_SCHDENABLE(1U)

#define S_REARMDDPOFFSET    4
#define V_REARMDDPOFFSET(x) ((x) << S_REARMDDPOFFSET)
#define F_REARMDDPOFFSET    V_REARMDDPOFFSET(1U)

#define S_RESETDDPOFFSET    3
#define V_RESETDDPOFFSET(x) ((x) << S_RESETDDPOFFSET)
#define F_RESETDDPOFFSET    V_RESETDDPOFFSET(1U)

#define S_ONFLYDDPENABLE    2
#define V_ONFLYDDPENABLE(x) ((x) << S_ONFLYDDPENABLE)
#define F_ONFLYDDPENABLE    V_ONFLYDDPENABLE(1U)

#define S_DACKTIMERSPIN    1
#define V_DACKTIMERSPIN(x) ((x) << S_DACKTIMERSPIN)
#define F_DACKTIMERSPIN    V_DACKTIMERSPIN(1U)

#define S_PUSHTIMERENABLE    0
#define V_PUSHTIMERENABLE(x) ((x) << S_PUSHTIMERENABLE)
#define F_PUSHTIMERENABLE    V_PUSHTIMERENABLE(1U)

#define S_ENABLEXOFFPDU    7
#define V_ENABLEXOFFPDU(x) ((x) << S_ENABLEXOFFPDU)
#define F_ENABLEXOFFPDU    V_ENABLEXOFFPDU(1U)

#define S_ENABLENEWFAR    6
#define V_ENABLENEWFAR(x) ((x) << S_ENABLENEWFAR)
#define F_ENABLENEWFAR    V_ENABLENEWFAR(1U)

#define S_ENABLEFRAGCHECK    5
#define V_ENABLEFRAGCHECK(x) ((x) << S_ENABLEFRAGCHECK)
#define F_ENABLEFRAGCHECK    V_ENABLEFRAGCHECK(1U)

#define A_TP_PARA_REG6 0x7d78

#define S_TXPDUSIZEADJ    24
#define M_TXPDUSIZEADJ    0xffU
#define V_TXPDUSIZEADJ(x) ((x) << S_TXPDUSIZEADJ)
#define G_TXPDUSIZEADJ(x) (((x) >> S_TXPDUSIZEADJ) & M_TXPDUSIZEADJ)

#define S_LIMITEDTRANSMIT    20
#define M_LIMITEDTRANSMIT    0xfU
#define V_LIMITEDTRANSMIT(x) ((x) << S_LIMITEDTRANSMIT)
#define G_LIMITEDTRANSMIT(x) (((x) >> S_LIMITEDTRANSMIT) & M_LIMITEDTRANSMIT)

#define S_ENABLECSAV    19
#define V_ENABLECSAV(x) ((x) << S_ENABLECSAV)
#define F_ENABLECSAV    V_ENABLECSAV(1U)

#define S_ENABLEDEFERPDU    18
#define V_ENABLEDEFERPDU(x) ((x) << S_ENABLEDEFERPDU)
#define F_ENABLEDEFERPDU    V_ENABLEDEFERPDU(1U)

#define S_ENABLEFLUSH    17
#define V_ENABLEFLUSH(x) ((x) << S_ENABLEFLUSH)
#define F_ENABLEFLUSH    V_ENABLEFLUSH(1U)

#define S_ENABLEBYTEPERSIST    16
#define V_ENABLEBYTEPERSIST(x) ((x) << S_ENABLEBYTEPERSIST)
#define F_ENABLEBYTEPERSIST    V_ENABLEBYTEPERSIST(1U)

#define S_DISABLETMOCNG    15
#define V_DISABLETMOCNG(x) ((x) << S_DISABLETMOCNG)
#define F_DISABLETMOCNG    V_DISABLETMOCNG(1U)

#define S_TXREADAHEAD    14
#define V_TXREADAHEAD(x) ((x) << S_TXREADAHEAD)
#define F_TXREADAHEAD    V_TXREADAHEAD(1U)

#define S_ALLOWEXEPTION    13
#define V_ALLOWEXEPTION(x) ((x) << S_ALLOWEXEPTION)
#define F_ALLOWEXEPTION    V_ALLOWEXEPTION(1U)

#define S_ENABLEDEFERACK    12
#define V_ENABLEDEFERACK(x) ((x) << S_ENABLEDEFERACK)
#define F_ENABLEDEFERACK    V_ENABLEDEFERACK(1U)

#define S_ENABLEESND    11
#define V_ENABLEESND(x) ((x) << S_ENABLEESND)
#define F_ENABLEESND    V_ENABLEESND(1U)

#define S_ENABLECSND    10
#define V_ENABLECSND(x) ((x) << S_ENABLECSND)
#define F_ENABLECSND    V_ENABLECSND(1U)

#define S_ENABLEPDUE    9
#define V_ENABLEPDUE(x) ((x) << S_ENABLEPDUE)
#define F_ENABLEPDUE    V_ENABLEPDUE(1U)

#define S_ENABLEPDUC    8
#define V_ENABLEPDUC(x) ((x) << S_ENABLEPDUC)
#define F_ENABLEPDUC    V_ENABLEPDUC(1U)

#define S_ENABLEBUFI    7
#define V_ENABLEBUFI(x) ((x) << S_ENABLEBUFI)
#define F_ENABLEBUFI    V_ENABLEBUFI(1U)

#define S_ENABLEBUFE    6
#define V_ENABLEBUFE(x) ((x) << S_ENABLEBUFE)
#define F_ENABLEBUFE    V_ENABLEBUFE(1U)

#define S_ENABLEDEFER    5
#define V_ENABLEDEFER(x) ((x) << S_ENABLEDEFER)
#define F_ENABLEDEFER    V_ENABLEDEFER(1U)

#define S_ENABLECLEARRXMTOOS    4
#define V_ENABLECLEARRXMTOOS(x) ((x) << S_ENABLECLEARRXMTOOS)
#define F_ENABLECLEARRXMTOOS    V_ENABLECLEARRXMTOOS(1U)

#define S_DISABLEPDUCNG    3
#define V_DISABLEPDUCNG(x) ((x) << S_DISABLEPDUCNG)
#define F_DISABLEPDUCNG    V_DISABLEPDUCNG(1U)

#define S_DISABLEPDUTIMEOUT    2
#define V_DISABLEPDUTIMEOUT(x) ((x) << S_DISABLEPDUTIMEOUT)
#define F_DISABLEPDUTIMEOUT    V_DISABLEPDUTIMEOUT(1U)

#define S_DISABLEPDURXMT    1
#define V_DISABLEPDURXMT(x) ((x) << S_DISABLEPDURXMT)
#define F_DISABLEPDURXMT    V_DISABLEPDURXMT(1U)

#define S_DISABLEPDUXMT    0
#define V_DISABLEPDUXMT(x) ((x) << S_DISABLEPDUXMT)
#define F_DISABLEPDUXMT    V_DISABLEPDUXMT(1U)

#define S_DISABLEPDUACK    20
#define V_DISABLEPDUACK(x) ((x) << S_DISABLEPDUACK)
#define F_DISABLEPDUACK    V_DISABLEPDUACK(1U)

#define A_TP_PARA_REG7 0x7d7c

#define S_PMMAXXFERLEN1    16
#define M_PMMAXXFERLEN1    0xffffU
#define V_PMMAXXFERLEN1(x) ((x) << S_PMMAXXFERLEN1)
#define G_PMMAXXFERLEN1(x) (((x) >> S_PMMAXXFERLEN1) & M_PMMAXXFERLEN1)

#define S_PMMAXXFERLEN0    0
#define M_PMMAXXFERLEN0    0xffffU
#define V_PMMAXXFERLEN0(x) ((x) << S_PMMAXXFERLEN0)
#define G_PMMAXXFERLEN0(x) (((x) >> S_PMMAXXFERLEN0) & M_PMMAXXFERLEN0)

#define A_TP_ENG_CONFIG 0x7d80

#define S_TABLELATENCYDONE    28
#define M_TABLELATENCYDONE    0xfU
#define V_TABLELATENCYDONE(x) ((x) << S_TABLELATENCYDONE)
#define G_TABLELATENCYDONE(x) (((x) >> S_TABLELATENCYDONE) & M_TABLELATENCYDONE)

#define S_TABLELATENCYSTART    24
#define M_TABLELATENCYSTART    0xfU
#define V_TABLELATENCYSTART(x) ((x) << S_TABLELATENCYSTART)
#define G_TABLELATENCYSTART(x) (((x) >> S_TABLELATENCYSTART) & M_TABLELATENCYSTART)

#define S_ENGINELATENCYDELTA    16
#define M_ENGINELATENCYDELTA    0xfU
#define V_ENGINELATENCYDELTA(x) ((x) << S_ENGINELATENCYDELTA)
#define G_ENGINELATENCYDELTA(x) (((x) >> S_ENGINELATENCYDELTA) & M_ENGINELATENCYDELTA)

#define S_ENGINELATENCYMMGR    12
#define M_ENGINELATENCYMMGR    0xfU
#define V_ENGINELATENCYMMGR(x) ((x) << S_ENGINELATENCYMMGR)
#define G_ENGINELATENCYMMGR(x) (((x) >> S_ENGINELATENCYMMGR) & M_ENGINELATENCYMMGR)

#define S_ENGINELATENCYWIREIP6    8
#define M_ENGINELATENCYWIREIP6    0xfU
#define V_ENGINELATENCYWIREIP6(x) ((x) << S_ENGINELATENCYWIREIP6)
#define G_ENGINELATENCYWIREIP6(x) (((x) >> S_ENGINELATENCYWIREIP6) & M_ENGINELATENCYWIREIP6)

#define S_ENGINELATENCYWIRE    4
#define M_ENGINELATENCYWIRE    0xfU
#define V_ENGINELATENCYWIRE(x) ((x) << S_ENGINELATENCYWIRE)
#define G_ENGINELATENCYWIRE(x) (((x) >> S_ENGINELATENCYWIRE) & M_ENGINELATENCYWIRE)

#define S_ENGINELATENCYBASE    0
#define M_ENGINELATENCYBASE    0xfU
#define V_ENGINELATENCYBASE(x) ((x) << S_ENGINELATENCYBASE)
#define G_ENGINELATENCYBASE(x) (((x) >> S_ENGINELATENCYBASE) & M_ENGINELATENCYBASE)

#define A_TP_ERR_CONFIG 0x7d8c

#define S_TNLERRORPING    30
#define V_TNLERRORPING(x) ((x) << S_TNLERRORPING)
#define F_TNLERRORPING    V_TNLERRORPING(1U)

#define S_TNLERRORCSUM    29
#define V_TNLERRORCSUM(x) ((x) << S_TNLERRORCSUM)
#define F_TNLERRORCSUM    V_TNLERRORCSUM(1U)

#define S_TNLERRORCSUMIP    28
#define V_TNLERRORCSUMIP(x) ((x) << S_TNLERRORCSUMIP)
#define F_TNLERRORCSUMIP    V_TNLERRORCSUMIP(1U)

#define S_TNLERRORTCPOPT    25
#define V_TNLERRORTCPOPT(x) ((x) << S_TNLERRORTCPOPT)
#define F_TNLERRORTCPOPT    V_TNLERRORTCPOPT(1U)

#define S_TNLERRORPKTLEN    24
#define V_TNLERRORPKTLEN(x) ((x) << S_TNLERRORPKTLEN)
#define F_TNLERRORPKTLEN    V_TNLERRORPKTLEN(1U)

#define S_TNLERRORTCPHDRLEN    23
#define V_TNLERRORTCPHDRLEN(x) ((x) << S_TNLERRORTCPHDRLEN)
#define F_TNLERRORTCPHDRLEN    V_TNLERRORTCPHDRLEN(1U)

#define S_TNLERRORIPHDRLEN    22
#define V_TNLERRORIPHDRLEN(x) ((x) << S_TNLERRORIPHDRLEN)
#define F_TNLERRORIPHDRLEN    V_TNLERRORIPHDRLEN(1U)

#define S_TNLERRORETHHDRLEN    21
#define V_TNLERRORETHHDRLEN(x) ((x) << S_TNLERRORETHHDRLEN)
#define F_TNLERRORETHHDRLEN    V_TNLERRORETHHDRLEN(1U)

#define S_TNLERRORATTACK    20
#define V_TNLERRORATTACK(x) ((x) << S_TNLERRORATTACK)
#define F_TNLERRORATTACK    V_TNLERRORATTACK(1U)

#define S_TNLERRORFRAG    19
#define V_TNLERRORFRAG(x) ((x) << S_TNLERRORFRAG)
#define F_TNLERRORFRAG    V_TNLERRORFRAG(1U)

#define S_TNLERRORIPVER    18
#define V_TNLERRORIPVER(x) ((x) << S_TNLERRORIPVER)
#define F_TNLERRORIPVER    V_TNLERRORIPVER(1U)

#define S_TNLERRORMAC    17
#define V_TNLERRORMAC(x) ((x) << S_TNLERRORMAC)
#define F_TNLERRORMAC    V_TNLERRORMAC(1U)

#define S_TNLERRORANY    16
#define V_TNLERRORANY(x) ((x) << S_TNLERRORANY)
#define F_TNLERRORANY    V_TNLERRORANY(1U)

#define S_DROPERRORPING    14
#define V_DROPERRORPING(x) ((x) << S_DROPERRORPING)
#define F_DROPERRORPING    V_DROPERRORPING(1U)

#define S_DROPERRORCSUM    13
#define V_DROPERRORCSUM(x) ((x) << S_DROPERRORCSUM)
#define F_DROPERRORCSUM    V_DROPERRORCSUM(1U)

#define S_DROPERRORCSUMIP    12
#define V_DROPERRORCSUMIP(x) ((x) << S_DROPERRORCSUMIP)
#define F_DROPERRORCSUMIP    V_DROPERRORCSUMIP(1U)

#define S_DROPERRORTCPOPT    9
#define V_DROPERRORTCPOPT(x) ((x) << S_DROPERRORTCPOPT)
#define F_DROPERRORTCPOPT    V_DROPERRORTCPOPT(1U)

#define S_DROPERRORPKTLEN    8
#define V_DROPERRORPKTLEN(x) ((x) << S_DROPERRORPKTLEN)
#define F_DROPERRORPKTLEN    V_DROPERRORPKTLEN(1U)

#define S_DROPERRORTCPHDRLEN    7
#define V_DROPERRORTCPHDRLEN(x) ((x) << S_DROPERRORTCPHDRLEN)
#define F_DROPERRORTCPHDRLEN    V_DROPERRORTCPHDRLEN(1U)

#define S_DROPERRORIPHDRLEN    6
#define V_DROPERRORIPHDRLEN(x) ((x) << S_DROPERRORIPHDRLEN)
#define F_DROPERRORIPHDRLEN    V_DROPERRORIPHDRLEN(1U)

#define S_DROPERRORETHHDRLEN    5
#define V_DROPERRORETHHDRLEN(x) ((x) << S_DROPERRORETHHDRLEN)
#define F_DROPERRORETHHDRLEN    V_DROPERRORETHHDRLEN(1U)

#define S_DROPERRORATTACK    4
#define V_DROPERRORATTACK(x) ((x) << S_DROPERRORATTACK)
#define F_DROPERRORATTACK    V_DROPERRORATTACK(1U)

#define S_DROPERRORFRAG    3
#define V_DROPERRORFRAG(x) ((x) << S_DROPERRORFRAG)
#define F_DROPERRORFRAG    V_DROPERRORFRAG(1U)

#define S_DROPERRORIPVER    2
#define V_DROPERRORIPVER(x) ((x) << S_DROPERRORIPVER)
#define F_DROPERRORIPVER    V_DROPERRORIPVER(1U)

#define S_DROPERRORMAC    1
#define V_DROPERRORMAC(x) ((x) << S_DROPERRORMAC)
#define F_DROPERRORMAC    V_DROPERRORMAC(1U)

#define S_DROPERRORANY    0
#define V_DROPERRORANY(x) ((x) << S_DROPERRORANY)
#define F_DROPERRORANY    V_DROPERRORANY(1U)

#define S_TNLERRORFPMA    31
#define V_TNLERRORFPMA(x) ((x) << S_TNLERRORFPMA)
#define F_TNLERRORFPMA    V_TNLERRORFPMA(1U)

#define S_DROPERRORFPMA    15
#define V_DROPERRORFPMA(x) ((x) << S_DROPERRORFPMA)
#define F_DROPERRORFPMA    V_DROPERRORFPMA(1U)

#define A_TP_TIMER_RESOLUTION 0x7d90

#define S_TIMERRESOLUTION    16
#define M_TIMERRESOLUTION    0xffU
#define V_TIMERRESOLUTION(x) ((x) << S_TIMERRESOLUTION)
#define G_TIMERRESOLUTION(x) (((x) >> S_TIMERRESOLUTION) & M_TIMERRESOLUTION)

#define S_TIMESTAMPRESOLUTION    8
#define M_TIMESTAMPRESOLUTION    0xffU
#define V_TIMESTAMPRESOLUTION(x) ((x) << S_TIMESTAMPRESOLUTION)
#define G_TIMESTAMPRESOLUTION(x) (((x) >> S_TIMESTAMPRESOLUTION) & M_TIMESTAMPRESOLUTION)

#define S_DELAYEDACKRESOLUTION    0
#define M_DELAYEDACKRESOLUTION    0xffU
#define V_DELAYEDACKRESOLUTION(x) ((x) << S_DELAYEDACKRESOLUTION)
#define G_DELAYEDACKRESOLUTION(x) (((x) >> S_DELAYEDACKRESOLUTION) & M_DELAYEDACKRESOLUTION)

#define A_TP_MSL 0x7d94

#define S_MSL    0
#define M_MSL    0x3fffffffU
#define V_MSL(x) ((x) << S_MSL)
#define G_MSL(x) (((x) >> S_MSL) & M_MSL)

#define A_TP_RXT_MIN 0x7d98

#define S_RXTMIN    0
#define M_RXTMIN    0x3fffffffU
#define V_RXTMIN(x) ((x) << S_RXTMIN)
#define G_RXTMIN(x) (((x) >> S_RXTMIN) & M_RXTMIN)

#define A_TP_RXT_MAX 0x7d9c

#define S_RXTMAX    0
#define M_RXTMAX    0x3fffffffU
#define V_RXTMAX(x) ((x) << S_RXTMAX)
#define G_RXTMAX(x) (((x) >> S_RXTMAX) & M_RXTMAX)

#define A_TP_PERS_MIN 0x7da0

#define S_PERSMIN    0
#define M_PERSMIN    0x3fffffffU
#define V_PERSMIN(x) ((x) << S_PERSMIN)
#define G_PERSMIN(x) (((x) >> S_PERSMIN) & M_PERSMIN)

#define A_TP_PERS_MAX 0x7da4

#define S_PERSMAX    0
#define M_PERSMAX    0x3fffffffU
#define V_PERSMAX(x) ((x) << S_PERSMAX)
#define G_PERSMAX(x) (((x) >> S_PERSMAX) & M_PERSMAX)

#define A_TP_KEEP_IDLE 0x7da8

#define S_KEEPALIVEIDLE    0
#define M_KEEPALIVEIDLE    0x3fffffffU
#define V_KEEPALIVEIDLE(x) ((x) << S_KEEPALIVEIDLE)
#define G_KEEPALIVEIDLE(x) (((x) >> S_KEEPALIVEIDLE) & M_KEEPALIVEIDLE)

#define A_TP_KEEP_INTVL 0x7dac

#define S_KEEPALIVEINTVL    0
#define M_KEEPALIVEINTVL    0x3fffffffU
#define V_KEEPALIVEINTVL(x) ((x) << S_KEEPALIVEINTVL)
#define G_KEEPALIVEINTVL(x) (((x) >> S_KEEPALIVEINTVL) & M_KEEPALIVEINTVL)

#define A_TP_INIT_SRTT 0x7db0

#define S_MAXRTT    16
#define M_MAXRTT    0xffffU
#define V_MAXRTT(x) ((x) << S_MAXRTT)
#define G_MAXRTT(x) (((x) >> S_MAXRTT) & M_MAXRTT)

#define S_INITSRTT    0
#define M_INITSRTT    0xffffU
#define V_INITSRTT(x) ((x) << S_INITSRTT)
#define G_INITSRTT(x) (((x) >> S_INITSRTT) & M_INITSRTT)

#define A_TP_DACK_TIMER 0x7db4

#define S_DACKTIME    0
#define M_DACKTIME    0xfffU
#define V_DACKTIME(x) ((x) << S_DACKTIME)
#define G_DACKTIME(x) (((x) >> S_DACKTIME) & M_DACKTIME)

#define A_TP_FINWAIT2_TIMER 0x7db8

#define S_FINWAIT2TIME    0
#define M_FINWAIT2TIME    0x3fffffffU
#define V_FINWAIT2TIME(x) ((x) << S_FINWAIT2TIME)
#define G_FINWAIT2TIME(x) (((x) >> S_FINWAIT2TIME) & M_FINWAIT2TIME)

#define A_TP_FAST_FINWAIT2_TIMER 0x7dbc

#define S_FASTFINWAIT2TIME    0
#define M_FASTFINWAIT2TIME    0x3fffffffU
#define V_FASTFINWAIT2TIME(x) ((x) << S_FASTFINWAIT2TIME)
#define G_FASTFINWAIT2TIME(x) (((x) >> S_FASTFINWAIT2TIME) & M_FASTFINWAIT2TIME)

#define A_TP_SHIFT_CNT 0x7dc0

#define S_SYNSHIFTMAX    24
#define M_SYNSHIFTMAX    0xffU
#define V_SYNSHIFTMAX(x) ((x) << S_SYNSHIFTMAX)
#define G_SYNSHIFTMAX(x) (((x) >> S_SYNSHIFTMAX) & M_SYNSHIFTMAX)

#define S_RXTSHIFTMAXR1    20
#define M_RXTSHIFTMAXR1    0xfU
#define V_RXTSHIFTMAXR1(x) ((x) << S_RXTSHIFTMAXR1)
#define G_RXTSHIFTMAXR1(x) (((x) >> S_RXTSHIFTMAXR1) & M_RXTSHIFTMAXR1)

#define S_RXTSHIFTMAXR2    16
#define M_RXTSHIFTMAXR2    0xfU
#define V_RXTSHIFTMAXR2(x) ((x) << S_RXTSHIFTMAXR2)
#define G_RXTSHIFTMAXR2(x) (((x) >> S_RXTSHIFTMAXR2) & M_RXTSHIFTMAXR2)

#define S_PERSHIFTBACKOFFMAX    12
#define M_PERSHIFTBACKOFFMAX    0xfU
#define V_PERSHIFTBACKOFFMAX(x) ((x) << S_PERSHIFTBACKOFFMAX)
#define G_PERSHIFTBACKOFFMAX(x) (((x) >> S_PERSHIFTBACKOFFMAX) & M_PERSHIFTBACKOFFMAX)

#define S_PERSHIFTMAX    8
#define M_PERSHIFTMAX    0xfU
#define V_PERSHIFTMAX(x) ((x) << S_PERSHIFTMAX)
#define G_PERSHIFTMAX(x) (((x) >> S_PERSHIFTMAX) & M_PERSHIFTMAX)

#define S_KEEPALIVEMAXR1    4
#define M_KEEPALIVEMAXR1    0xfU
#define V_KEEPALIVEMAXR1(x) ((x) << S_KEEPALIVEMAXR1)
#define G_KEEPALIVEMAXR1(x) (((x) >> S_KEEPALIVEMAXR1) & M_KEEPALIVEMAXR1)

#define S_KEEPALIVEMAXR2    0
#define M_KEEPALIVEMAXR2    0xfU
#define V_KEEPALIVEMAXR2(x) ((x) << S_KEEPALIVEMAXR2)
#define G_KEEPALIVEMAXR2(x) (((x) >> S_KEEPALIVEMAXR2) & M_KEEPALIVEMAXR2)

#define A_TP_TM_CONFIG 0x7dc4

#define S_CMTIMERMAXNUM    0
#define M_CMTIMERMAXNUM    0x7U
#define V_CMTIMERMAXNUM(x) ((x) << S_CMTIMERMAXNUM)
#define G_CMTIMERMAXNUM(x) (((x) >> S_CMTIMERMAXNUM) & M_CMTIMERMAXNUM)

#define A_TP_TIME_LO 0x7dc8
#define A_TP_TIME_HI 0x7dcc
#define A_TP_PORT_MTU_0 0x7dd0

#define S_PORT1MTUVALUE    16
#define M_PORT1MTUVALUE    0xffffU
#define V_PORT1MTUVALUE(x) ((x) << S_PORT1MTUVALUE)
#define G_PORT1MTUVALUE(x) (((x) >> S_PORT1MTUVALUE) & M_PORT1MTUVALUE)

#define S_PORT0MTUVALUE    0
#define M_PORT0MTUVALUE    0xffffU
#define V_PORT0MTUVALUE(x) ((x) << S_PORT0MTUVALUE)
#define G_PORT0MTUVALUE(x) (((x) >> S_PORT0MTUVALUE) & M_PORT0MTUVALUE)

#define A_TP_PORT_MTU_1 0x7dd4

#define S_PORT3MTUVALUE    16
#define M_PORT3MTUVALUE    0xffffU
#define V_PORT3MTUVALUE(x) ((x) << S_PORT3MTUVALUE)
#define G_PORT3MTUVALUE(x) (((x) >> S_PORT3MTUVALUE) & M_PORT3MTUVALUE)

#define S_PORT2MTUVALUE    0
#define M_PORT2MTUVALUE    0xffffU
#define V_PORT2MTUVALUE(x) ((x) << S_PORT2MTUVALUE)
#define G_PORT2MTUVALUE(x) (((x) >> S_PORT2MTUVALUE) & M_PORT2MTUVALUE)

#define A_TP_PACE_TABLE 0x7dd8
#define A_TP_CCTRL_TABLE 0x7ddc

#define S_ROWINDEX    16
#define M_ROWINDEX    0xffffU
#define V_ROWINDEX(x) ((x) << S_ROWINDEX)
#define G_ROWINDEX(x) (((x) >> S_ROWINDEX) & M_ROWINDEX)

#define S_ROWVALUE    0
#define M_ROWVALUE    0xffffU
#define V_ROWVALUE(x) ((x) << S_ROWVALUE)
#define G_ROWVALUE(x) (((x) >> S_ROWVALUE) & M_ROWVALUE)

#define A_TP_MTU_TABLE 0x7de4

#define S_MTUINDEX    24
#define M_MTUINDEX    0xffU
#define V_MTUINDEX(x) ((x) << S_MTUINDEX)
#define G_MTUINDEX(x) (((x) >> S_MTUINDEX) & M_MTUINDEX)

#define S_MTUWIDTH    16
#define M_MTUWIDTH    0xfU
#define V_MTUWIDTH(x) ((x) << S_MTUWIDTH)
#define G_MTUWIDTH(x) (((x) >> S_MTUWIDTH) & M_MTUWIDTH)

#define S_MTUVALUE    0
#define M_MTUVALUE    0x3fffU
#define V_MTUVALUE(x) ((x) << S_MTUVALUE)
#define G_MTUVALUE(x) (((x) >> S_MTUVALUE) & M_MTUVALUE)

#define A_TP_ULP_TABLE 0x7de8

#define S_ULPTYPE7FIELD    28
#define M_ULPTYPE7FIELD    0xfU
#define V_ULPTYPE7FIELD(x) ((x) << S_ULPTYPE7FIELD)
#define G_ULPTYPE7FIELD(x) (((x) >> S_ULPTYPE7FIELD) & M_ULPTYPE7FIELD)

#define S_ULPTYPE6FIELD    24
#define M_ULPTYPE6FIELD    0xfU
#define V_ULPTYPE6FIELD(x) ((x) << S_ULPTYPE6FIELD)
#define G_ULPTYPE6FIELD(x) (((x) >> S_ULPTYPE6FIELD) & M_ULPTYPE6FIELD)

#define S_ULPTYPE5FIELD    20
#define M_ULPTYPE5FIELD    0xfU
#define V_ULPTYPE5FIELD(x) ((x) << S_ULPTYPE5FIELD)
#define G_ULPTYPE5FIELD(x) (((x) >> S_ULPTYPE5FIELD) & M_ULPTYPE5FIELD)

#define S_ULPTYPE4FIELD    16
#define M_ULPTYPE4FIELD    0xfU
#define V_ULPTYPE4FIELD(x) ((x) << S_ULPTYPE4FIELD)
#define G_ULPTYPE4FIELD(x) (((x) >> S_ULPTYPE4FIELD) & M_ULPTYPE4FIELD)

#define S_ULPTYPE3FIELD    12
#define M_ULPTYPE3FIELD    0xfU
#define V_ULPTYPE3FIELD(x) ((x) << S_ULPTYPE3FIELD)
#define G_ULPTYPE3FIELD(x) (((x) >> S_ULPTYPE3FIELD) & M_ULPTYPE3FIELD)

#define S_ULPTYPE2FIELD    8
#define M_ULPTYPE2FIELD    0xfU
#define V_ULPTYPE2FIELD(x) ((x) << S_ULPTYPE2FIELD)
#define G_ULPTYPE2FIELD(x) (((x) >> S_ULPTYPE2FIELD) & M_ULPTYPE2FIELD)

#define S_ULPTYPE1FIELD    4
#define M_ULPTYPE1FIELD    0xfU
#define V_ULPTYPE1FIELD(x) ((x) << S_ULPTYPE1FIELD)
#define G_ULPTYPE1FIELD(x) (((x) >> S_ULPTYPE1FIELD) & M_ULPTYPE1FIELD)

#define S_ULPTYPE0FIELD    0
#define M_ULPTYPE0FIELD    0xfU
#define V_ULPTYPE0FIELD(x) ((x) << S_ULPTYPE0FIELD)
#define G_ULPTYPE0FIELD(x) (((x) >> S_ULPTYPE0FIELD) & M_ULPTYPE0FIELD)

#define A_TP_RSS_LKP_TABLE 0x7dec

#define S_LKPTBLROWVLD    31
#define V_LKPTBLROWVLD(x) ((x) << S_LKPTBLROWVLD)
#define F_LKPTBLROWVLD    V_LKPTBLROWVLD(1U)

#define S_LKPTBLROWIDX    20
#define M_LKPTBLROWIDX    0x3ffU
#define V_LKPTBLROWIDX(x) ((x) << S_LKPTBLROWIDX)
#define G_LKPTBLROWIDX(x) (((x) >> S_LKPTBLROWIDX) & M_LKPTBLROWIDX)

#define S_LKPTBLQUEUE1    10
#define M_LKPTBLQUEUE1    0x3ffU
#define V_LKPTBLQUEUE1(x) ((x) << S_LKPTBLQUEUE1)
#define G_LKPTBLQUEUE1(x) (((x) >> S_LKPTBLQUEUE1) & M_LKPTBLQUEUE1)

#define S_LKPTBLQUEUE0    0
#define M_LKPTBLQUEUE0    0x3ffU
#define V_LKPTBLQUEUE0(x) ((x) << S_LKPTBLQUEUE0)
#define G_LKPTBLQUEUE0(x) (((x) >> S_LKPTBLQUEUE0) & M_LKPTBLQUEUE0)

#define A_TP_RSS_CONFIG 0x7df0

#define S_TNL4TUPENIPV6    31
#define V_TNL4TUPENIPV6(x) ((x) << S_TNL4TUPENIPV6)
#define F_TNL4TUPENIPV6    V_TNL4TUPENIPV6(1U)

#define S_TNL2TUPENIPV6    30
#define V_TNL2TUPENIPV6(x) ((x) << S_TNL2TUPENIPV6)
#define F_TNL2TUPENIPV6    V_TNL2TUPENIPV6(1U)

#define S_TNL4TUPENIPV4    29
#define V_TNL4TUPENIPV4(x) ((x) << S_TNL4TUPENIPV4)
#define F_TNL4TUPENIPV4    V_TNL4TUPENIPV4(1U)

#define S_TNL2TUPENIPV4    28
#define V_TNL2TUPENIPV4(x) ((x) << S_TNL2TUPENIPV4)
#define F_TNL2TUPENIPV4    V_TNL2TUPENIPV4(1U)

#define S_TNLTCPSEL    27
#define V_TNLTCPSEL(x) ((x) << S_TNLTCPSEL)
#define F_TNLTCPSEL    V_TNLTCPSEL(1U)

#define S_TNLIP6SEL    26
#define V_TNLIP6SEL(x) ((x) << S_TNLIP6SEL)
#define F_TNLIP6SEL    V_TNLIP6SEL(1U)

#define S_TNLVRTSEL    25
#define V_TNLVRTSEL(x) ((x) << S_TNLVRTSEL)
#define F_TNLVRTSEL    V_TNLVRTSEL(1U)

#define S_TNLMAPEN    24
#define V_TNLMAPEN(x) ((x) << S_TNLMAPEN)
#define F_TNLMAPEN    V_TNLMAPEN(1U)

#define S_OFDHASHSAVE    19
#define V_OFDHASHSAVE(x) ((x) << S_OFDHASHSAVE)
#define F_OFDHASHSAVE    V_OFDHASHSAVE(1U)

#define S_OFDVRTSEL    18
#define V_OFDVRTSEL(x) ((x) << S_OFDVRTSEL)
#define F_OFDVRTSEL    V_OFDVRTSEL(1U)

#define S_OFDMAPEN    17
#define V_OFDMAPEN(x) ((x) << S_OFDMAPEN)
#define F_OFDMAPEN    V_OFDMAPEN(1U)

#define S_OFDLKPEN    16
#define V_OFDLKPEN(x) ((x) << S_OFDLKPEN)
#define F_OFDLKPEN    V_OFDLKPEN(1U)

#define S_SYN4TUPENIPV6    15
#define V_SYN4TUPENIPV6(x) ((x) << S_SYN4TUPENIPV6)
#define F_SYN4TUPENIPV6    V_SYN4TUPENIPV6(1U)

#define S_SYN2TUPENIPV6    14
#define V_SYN2TUPENIPV6(x) ((x) << S_SYN2TUPENIPV6)
#define F_SYN2TUPENIPV6    V_SYN2TUPENIPV6(1U)

#define S_SYN4TUPENIPV4    13
#define V_SYN4TUPENIPV4(x) ((x) << S_SYN4TUPENIPV4)
#define F_SYN4TUPENIPV4    V_SYN4TUPENIPV4(1U)

#define S_SYN2TUPENIPV4    12
#define V_SYN2TUPENIPV4(x) ((x) << S_SYN2TUPENIPV4)
#define F_SYN2TUPENIPV4    V_SYN2TUPENIPV4(1U)

#define S_SYNIP6SEL    11
#define V_SYNIP6SEL(x) ((x) << S_SYNIP6SEL)
#define F_SYNIP6SEL    V_SYNIP6SEL(1U)

#define S_SYNVRTSEL    10
#define V_SYNVRTSEL(x) ((x) << S_SYNVRTSEL)
#define F_SYNVRTSEL    V_SYNVRTSEL(1U)

#define S_SYNMAPEN    9
#define V_SYNMAPEN(x) ((x) << S_SYNMAPEN)
#define F_SYNMAPEN    V_SYNMAPEN(1U)

#define S_SYNLKPEN    8
#define V_SYNLKPEN(x) ((x) << S_SYNLKPEN)
#define F_SYNLKPEN    V_SYNLKPEN(1U)

#define S_CHANNELENABLE    7
#define V_CHANNELENABLE(x) ((x) << S_CHANNELENABLE)
#define F_CHANNELENABLE    V_CHANNELENABLE(1U)

#define S_PORTENABLE    6
#define V_PORTENABLE(x) ((x) << S_PORTENABLE)
#define F_PORTENABLE    V_PORTENABLE(1U)

#define S_TNLALLLOOKUP    5
#define V_TNLALLLOOKUP(x) ((x) << S_TNLALLLOOKUP)
#define F_TNLALLLOOKUP    V_TNLALLLOOKUP(1U)

#define S_VIRTENABLE    4
#define V_VIRTENABLE(x) ((x) << S_VIRTENABLE)
#define F_VIRTENABLE    V_VIRTENABLE(1U)

#define S_CONGESTIONENABLE    3
#define V_CONGESTIONENABLE(x) ((x) << S_CONGESTIONENABLE)
#define F_CONGESTIONENABLE    V_CONGESTIONENABLE(1U)

#define S_HASHTOEPLITZ    2
#define V_HASHTOEPLITZ(x) ((x) << S_HASHTOEPLITZ)
#define F_HASHTOEPLITZ    V_HASHTOEPLITZ(1U)

#define S_UDPENABLE    1
#define V_UDPENABLE(x) ((x) << S_UDPENABLE)
#define F_UDPENABLE    V_UDPENABLE(1U)

#define S_DISABLE    0
#define V_DISABLE(x) ((x) << S_DISABLE)
#define F_DISABLE    V_DISABLE(1U)

#define S_TNLFCOEMODE    23
#define V_TNLFCOEMODE(x) ((x) << S_TNLFCOEMODE)
#define F_TNLFCOEMODE    V_TNLFCOEMODE(1U)

#define S_TNLFCOEEN    21
#define V_TNLFCOEEN(x) ((x) << S_TNLFCOEEN)
#define F_TNLFCOEEN    V_TNLFCOEEN(1U)

#define S_HASHXOR    20
#define V_HASHXOR(x) ((x) << S_HASHXOR)
#define F_HASHXOR    V_HASHXOR(1U)

#define A_TP_RSS_CONFIG_TNL 0x7df4

#define S_MASKSIZE    28
#define M_MASKSIZE    0xfU
#define V_MASKSIZE(x) ((x) << S_MASKSIZE)
#define G_MASKSIZE(x) (((x) >> S_MASKSIZE) & M_MASKSIZE)

#define S_MASKFILTER    16
#define M_MASKFILTER    0x7ffU
#define V_MASKFILTER(x) ((x) << S_MASKFILTER)
#define G_MASKFILTER(x) (((x) >> S_MASKFILTER) & M_MASKFILTER)

#define S_USEWIRECH    0
#define V_USEWIRECH(x) ((x) << S_USEWIRECH)
#define F_USEWIRECH    V_USEWIRECH(1U)

#define A_TP_RSS_CONFIG_OFD 0x7df8

#define S_RRCPLMAPEN    20
#define V_RRCPLMAPEN(x) ((x) << S_RRCPLMAPEN)
#define F_RRCPLMAPEN    V_RRCPLMAPEN(1U)

#define S_RRCPLQUEWIDTH    16
#define M_RRCPLQUEWIDTH    0xfU
#define V_RRCPLQUEWIDTH(x) ((x) << S_RRCPLQUEWIDTH)
#define G_RRCPLQUEWIDTH(x) (((x) >> S_RRCPLQUEWIDTH) & M_RRCPLQUEWIDTH)

#define S_FRMWRQUEMASK    12
#define M_FRMWRQUEMASK    0xfU
#define V_FRMWRQUEMASK(x) ((x) << S_FRMWRQUEMASK)
#define G_FRMWRQUEMASK(x) (((x) >> S_FRMWRQUEMASK) & M_FRMWRQUEMASK)

#define A_TP_RSS_CONFIG_SYN 0x7dfc
#define A_TP_RSS_CONFIG_VRT 0x7e00

#define S_VFRDRG    25
#define V_VFRDRG(x) ((x) << S_VFRDRG)
#define F_VFRDRG    V_VFRDRG(1U)

#define S_VFRDEN    24
#define V_VFRDEN(x) ((x) << S_VFRDEN)
#define F_VFRDEN    V_VFRDEN(1U)

#define S_VFPERREN    23
#define V_VFPERREN(x) ((x) << S_VFPERREN)
#define F_VFPERREN    V_VFPERREN(1U)

#define S_KEYPERREN    22
#define V_KEYPERREN(x) ((x) << S_KEYPERREN)
#define F_KEYPERREN    V_KEYPERREN(1U)

#define S_DISABLEVLAN    21
#define V_DISABLEVLAN(x) ((x) << S_DISABLEVLAN)
#define F_DISABLEVLAN    V_DISABLEVLAN(1U)

#define S_ENABLEUP0    20
#define V_ENABLEUP0(x) ((x) << S_ENABLEUP0)
#define F_ENABLEUP0    V_ENABLEUP0(1U)

#define S_HASHDELAY    16
#define M_HASHDELAY    0xfU
#define V_HASHDELAY(x) ((x) << S_HASHDELAY)
#define G_HASHDELAY(x) (((x) >> S_HASHDELAY) & M_HASHDELAY)

#define S_VFWRADDR    8
#define M_VFWRADDR    0x7fU
#define V_VFWRADDR(x) ((x) << S_VFWRADDR)
#define G_VFWRADDR(x) (((x) >> S_VFWRADDR) & M_VFWRADDR)

#define S_KEYMODE    6
#define M_KEYMODE    0x3U
#define V_KEYMODE(x) ((x) << S_KEYMODE)
#define G_KEYMODE(x) (((x) >> S_KEYMODE) & M_KEYMODE)

#define S_VFWREN    5
#define V_VFWREN(x) ((x) << S_VFWREN)
#define F_VFWREN    V_VFWREN(1U)

#define S_KEYWREN    4
#define V_KEYWREN(x) ((x) << S_KEYWREN)
#define F_KEYWREN    V_KEYWREN(1U)

#define S_KEYWRADDR    0
#define M_KEYWRADDR    0xfU
#define V_KEYWRADDR(x) ((x) << S_KEYWRADDR)
#define G_KEYWRADDR(x) (((x) >> S_KEYWRADDR) & M_KEYWRADDR)

#define S_VFVLANEN    21
#define V_VFVLANEN(x) ((x) << S_VFVLANEN)
#define F_VFVLANEN    V_VFVLANEN(1U)

#define S_VFFWEN    20
#define V_VFFWEN(x) ((x) << S_VFFWEN)
#define F_VFFWEN    V_VFFWEN(1U)

#define A_TP_RSS_CONFIG_CNG 0x7e04

#define S_CHNCOUNT3    31
#define V_CHNCOUNT3(x) ((x) << S_CHNCOUNT3)
#define F_CHNCOUNT3    V_CHNCOUNT3(1U)

#define S_CHNCOUNT2    30
#define V_CHNCOUNT2(x) ((x) << S_CHNCOUNT2)
#define F_CHNCOUNT2    V_CHNCOUNT2(1U)

#define S_CHNCOUNT1    29
#define V_CHNCOUNT1(x) ((x) << S_CHNCOUNT1)
#define F_CHNCOUNT1    V_CHNCOUNT1(1U)

#define S_CHNCOUNT0    28
#define V_CHNCOUNT0(x) ((x) << S_CHNCOUNT0)
#define F_CHNCOUNT0    V_CHNCOUNT0(1U)

#define S_CHNUNDFLOW3    27
#define V_CHNUNDFLOW3(x) ((x) << S_CHNUNDFLOW3)
#define F_CHNUNDFLOW3    V_CHNUNDFLOW3(1U)

#define S_CHNUNDFLOW2    26
#define V_CHNUNDFLOW2(x) ((x) << S_CHNUNDFLOW2)
#define F_CHNUNDFLOW2    V_CHNUNDFLOW2(1U)

#define S_CHNUNDFLOW1    25
#define V_CHNUNDFLOW1(x) ((x) << S_CHNUNDFLOW1)
#define F_CHNUNDFLOW1    V_CHNUNDFLOW1(1U)

#define S_CHNUNDFLOW0    24
#define V_CHNUNDFLOW0(x) ((x) << S_CHNUNDFLOW0)
#define F_CHNUNDFLOW0    V_CHNUNDFLOW0(1U)

#define S_CHNOVRFLOW3    23
#define V_CHNOVRFLOW3(x) ((x) << S_CHNOVRFLOW3)
#define F_CHNOVRFLOW3    V_CHNOVRFLOW3(1U)

#define S_CHNOVRFLOW2    22
#define V_CHNOVRFLOW2(x) ((x) << S_CHNOVRFLOW2)
#define F_CHNOVRFLOW2    V_CHNOVRFLOW2(1U)

#define S_CHNOVRFLOW1    21
#define V_CHNOVRFLOW1(x) ((x) << S_CHNOVRFLOW1)
#define F_CHNOVRFLOW1    V_CHNOVRFLOW1(1U)

#define S_CHNOVRFLOW0    20
#define V_CHNOVRFLOW0(x) ((x) << S_CHNOVRFLOW0)
#define F_CHNOVRFLOW0    V_CHNOVRFLOW0(1U)

#define S_RSTCHN3    19
#define V_RSTCHN3(x) ((x) << S_RSTCHN3)
#define F_RSTCHN3    V_RSTCHN3(1U)

#define S_RSTCHN2    18
#define V_RSTCHN2(x) ((x) << S_RSTCHN2)
#define F_RSTCHN2    V_RSTCHN2(1U)

#define S_RSTCHN1    17
#define V_RSTCHN1(x) ((x) << S_RSTCHN1)
#define F_RSTCHN1    V_RSTCHN1(1U)

#define S_RSTCHN0    16
#define V_RSTCHN0(x) ((x) << S_RSTCHN0)
#define F_RSTCHN0    V_RSTCHN0(1U)

#define S_UPDVLD    15
#define V_UPDVLD(x) ((x) << S_UPDVLD)
#define F_UPDVLD    V_UPDVLD(1U)

#define S_XOFF    14
#define V_XOFF(x) ((x) << S_XOFF)
#define F_XOFF    V_XOFF(1U)

#define S_UPDCHN3    13
#define V_UPDCHN3(x) ((x) << S_UPDCHN3)
#define F_UPDCHN3    V_UPDCHN3(1U)

#define S_UPDCHN2    12
#define V_UPDCHN2(x) ((x) << S_UPDCHN2)
#define F_UPDCHN2    V_UPDCHN2(1U)

#define S_UPDCHN1    11
#define V_UPDCHN1(x) ((x) << S_UPDCHN1)
#define F_UPDCHN1    V_UPDCHN1(1U)

#define S_UPDCHN0    10
#define V_UPDCHN0(x) ((x) << S_UPDCHN0)
#define F_UPDCHN0    V_UPDCHN0(1U)

#define S_QUEUE    0
#define M_QUEUE    0x3ffU
#define V_QUEUE(x) ((x) << S_QUEUE)
#define G_QUEUE(x) (((x) >> S_QUEUE) & M_QUEUE)

#define A_TP_LA_TABLE_0 0x7e10

#define S_VIRTPORT1TABLE    16
#define M_VIRTPORT1TABLE    0xffffU
#define V_VIRTPORT1TABLE(x) ((x) << S_VIRTPORT1TABLE)
#define G_VIRTPORT1TABLE(x) (((x) >> S_VIRTPORT1TABLE) & M_VIRTPORT1TABLE)

#define S_VIRTPORT0TABLE    0
#define M_VIRTPORT0TABLE    0xffffU
#define V_VIRTPORT0TABLE(x) ((x) << S_VIRTPORT0TABLE)
#define G_VIRTPORT0TABLE(x) (((x) >> S_VIRTPORT0TABLE) & M_VIRTPORT0TABLE)

#define A_TP_LA_TABLE_1 0x7e14

#define S_VIRTPORT3TABLE    16
#define M_VIRTPORT3TABLE    0xffffU
#define V_VIRTPORT3TABLE(x) ((x) << S_VIRTPORT3TABLE)
#define G_VIRTPORT3TABLE(x) (((x) >> S_VIRTPORT3TABLE) & M_VIRTPORT3TABLE)

#define S_VIRTPORT2TABLE    0
#define M_VIRTPORT2TABLE    0xffffU
#define V_VIRTPORT2TABLE(x) ((x) << S_VIRTPORT2TABLE)
#define G_VIRTPORT2TABLE(x) (((x) >> S_VIRTPORT2TABLE) & M_VIRTPORT2TABLE)

#define A_TP_TM_PIO_ADDR 0x7e18
#define A_TP_TM_PIO_DATA 0x7e1c
#define A_TP_MOD_CONFIG 0x7e24

#define S_RXCHANNELWEIGHT1    24
#define M_RXCHANNELWEIGHT1    0xffU
#define V_RXCHANNELWEIGHT1(x) ((x) << S_RXCHANNELWEIGHT1)
#define G_RXCHANNELWEIGHT1(x) (((x) >> S_RXCHANNELWEIGHT1) & M_RXCHANNELWEIGHT1)

#define S_RXCHANNELWEIGHT0    16
#define M_RXCHANNELWEIGHT0    0xffU
#define V_RXCHANNELWEIGHT0(x) ((x) << S_RXCHANNELWEIGHT0)
#define G_RXCHANNELWEIGHT0(x) (((x) >> S_RXCHANNELWEIGHT0) & M_RXCHANNELWEIGHT0)

#define S_TIMERMODE    8
#define M_TIMERMODE    0xffU
#define V_TIMERMODE(x) ((x) << S_TIMERMODE)
#define G_TIMERMODE(x) (((x) >> S_TIMERMODE) & M_TIMERMODE)

#define S_TXCHANNELXOFFEN    0
#define M_TXCHANNELXOFFEN    0xfU
#define V_TXCHANNELXOFFEN(x) ((x) << S_TXCHANNELXOFFEN)
#define G_TXCHANNELXOFFEN(x) (((x) >> S_TXCHANNELXOFFEN) & M_TXCHANNELXOFFEN)

#define A_TP_TX_MOD_QUEUE_REQ_MAP 0x7e28

#define S_RX_MOD_WEIGHT    24
#define M_RX_MOD_WEIGHT    0xffU
#define V_RX_MOD_WEIGHT(x) ((x) << S_RX_MOD_WEIGHT)
#define G_RX_MOD_WEIGHT(x) (((x) >> S_RX_MOD_WEIGHT) & M_RX_MOD_WEIGHT)

#define S_TX_MOD_WEIGHT    16
#define M_TX_MOD_WEIGHT    0xffU
#define V_TX_MOD_WEIGHT(x) ((x) << S_TX_MOD_WEIGHT)
#define G_TX_MOD_WEIGHT(x) (((x) >> S_TX_MOD_WEIGHT) & M_TX_MOD_WEIGHT)

#define S_TX_MOD_QUEUE_REQ_MAP    0
#define M_TX_MOD_QUEUE_REQ_MAP    0xffffU
#define V_TX_MOD_QUEUE_REQ_MAP(x) ((x) << S_TX_MOD_QUEUE_REQ_MAP)
#define G_TX_MOD_QUEUE_REQ_MAP(x) (((x) >> S_TX_MOD_QUEUE_REQ_MAP) & M_TX_MOD_QUEUE_REQ_MAP)

#define A_TP_TX_MOD_QUEUE_WEIGHT1 0x7e2c

#define S_TX_MODQ_WEIGHT7    24
#define M_TX_MODQ_WEIGHT7    0xffU
#define V_TX_MODQ_WEIGHT7(x) ((x) << S_TX_MODQ_WEIGHT7)
#define G_TX_MODQ_WEIGHT7(x) (((x) >> S_TX_MODQ_WEIGHT7) & M_TX_MODQ_WEIGHT7)

#define S_TX_MODQ_WEIGHT6    16
#define M_TX_MODQ_WEIGHT6    0xffU
#define V_TX_MODQ_WEIGHT6(x) ((x) << S_TX_MODQ_WEIGHT6)
#define G_TX_MODQ_WEIGHT6(x) (((x) >> S_TX_MODQ_WEIGHT6) & M_TX_MODQ_WEIGHT6)

#define S_TX_MODQ_WEIGHT5    8
#define M_TX_MODQ_WEIGHT5    0xffU
#define V_TX_MODQ_WEIGHT5(x) ((x) << S_TX_MODQ_WEIGHT5)
#define G_TX_MODQ_WEIGHT5(x) (((x) >> S_TX_MODQ_WEIGHT5) & M_TX_MODQ_WEIGHT5)

#define S_TX_MODQ_WEIGHT4    0
#define M_TX_MODQ_WEIGHT4    0xffU
#define V_TX_MODQ_WEIGHT4(x) ((x) << S_TX_MODQ_WEIGHT4)
#define G_TX_MODQ_WEIGHT4(x) (((x) >> S_TX_MODQ_WEIGHT4) & M_TX_MODQ_WEIGHT4)

#define A_TP_TX_MOD_QUEUE_WEIGHT0 0x7e30

#define S_TX_MODQ_WEIGHT3    24
#define M_TX_MODQ_WEIGHT3    0xffU
#define V_TX_MODQ_WEIGHT3(x) ((x) << S_TX_MODQ_WEIGHT3)
#define G_TX_MODQ_WEIGHT3(x) (((x) >> S_TX_MODQ_WEIGHT3) & M_TX_MODQ_WEIGHT3)

#define S_TX_MODQ_WEIGHT2    16
#define M_TX_MODQ_WEIGHT2    0xffU
#define V_TX_MODQ_WEIGHT2(x) ((x) << S_TX_MODQ_WEIGHT2)
#define G_TX_MODQ_WEIGHT2(x) (((x) >> S_TX_MODQ_WEIGHT2) & M_TX_MODQ_WEIGHT2)

#define S_TX_MODQ_WEIGHT1    8
#define M_TX_MODQ_WEIGHT1    0xffU
#define V_TX_MODQ_WEIGHT1(x) ((x) << S_TX_MODQ_WEIGHT1)
#define G_TX_MODQ_WEIGHT1(x) (((x) >> S_TX_MODQ_WEIGHT1) & M_TX_MODQ_WEIGHT1)

#define S_TX_MODQ_WEIGHT0    0
#define M_TX_MODQ_WEIGHT0    0xffU
#define V_TX_MODQ_WEIGHT0(x) ((x) << S_TX_MODQ_WEIGHT0)
#define G_TX_MODQ_WEIGHT0(x) (((x) >> S_TX_MODQ_WEIGHT0) & M_TX_MODQ_WEIGHT0)

#define A_TP_TX_MOD_CHANNEL_WEIGHT 0x7e34
#define A_TP_MOD_RATE_LIMIT 0x7e38

#define S_RX_MOD_RATE_LIMIT_INC    24
#define M_RX_MOD_RATE_LIMIT_INC    0xffU
#define V_RX_MOD_RATE_LIMIT_INC(x) ((x) << S_RX_MOD_RATE_LIMIT_INC)
#define G_RX_MOD_RATE_LIMIT_INC(x) (((x) >> S_RX_MOD_RATE_LIMIT_INC) & M_RX_MOD_RATE_LIMIT_INC)

#define S_RX_MOD_RATE_LIMIT_TICK    16
#define M_RX_MOD_RATE_LIMIT_TICK    0xffU
#define V_RX_MOD_RATE_LIMIT_TICK(x) ((x) << S_RX_MOD_RATE_LIMIT_TICK)
#define G_RX_MOD_RATE_LIMIT_TICK(x) (((x) >> S_RX_MOD_RATE_LIMIT_TICK) & M_RX_MOD_RATE_LIMIT_TICK)

#define S_TX_MOD_RATE_LIMIT_INC    8
#define M_TX_MOD_RATE_LIMIT_INC    0xffU
#define V_TX_MOD_RATE_LIMIT_INC(x) ((x) << S_TX_MOD_RATE_LIMIT_INC)
#define G_TX_MOD_RATE_LIMIT_INC(x) (((x) >> S_TX_MOD_RATE_LIMIT_INC) & M_TX_MOD_RATE_LIMIT_INC)

#define S_TX_MOD_RATE_LIMIT_TICK    0
#define M_TX_MOD_RATE_LIMIT_TICK    0xffU
#define V_TX_MOD_RATE_LIMIT_TICK(x) ((x) << S_TX_MOD_RATE_LIMIT_TICK)
#define G_TX_MOD_RATE_LIMIT_TICK(x) (((x) >> S_TX_MOD_RATE_LIMIT_TICK) & M_TX_MOD_RATE_LIMIT_TICK)

#define A_TP_PIO_ADDR 0x7e40
#define A_TP_PIO_DATA 0x7e44
#define A_TP_RESET 0x7e4c

#define S_FLSTINITENABLE    1
#define V_FLSTINITENABLE(x) ((x) << S_FLSTINITENABLE)
#define F_FLSTINITENABLE    V_FLSTINITENABLE(1U)

#define S_TPRESET    0
#define V_TPRESET(x) ((x) << S_TPRESET)
#define F_TPRESET    V_TPRESET(1U)

#define A_TP_MIB_INDEX 0x7e50
#define A_TP_MIB_DATA 0x7e54
#define A_TP_SYNC_TIME_HI 0x7e58
#define A_TP_SYNC_TIME_LO 0x7e5c
#define A_TP_CMM_MM_RX_FLST_BASE 0x7e60
#define A_TP_CMM_MM_TX_FLST_BASE 0x7e64
#define A_TP_CMM_MM_PS_FLST_BASE 0x7e68
#define A_TP_CMM_MM_MAX_PSTRUCT 0x7e6c

#define S_CMMAXPSTRUCT    0
#define M_CMMAXPSTRUCT    0x1fffffU
#define V_CMMAXPSTRUCT(x) ((x) << S_CMMAXPSTRUCT)
#define G_CMMAXPSTRUCT(x) (((x) >> S_CMMAXPSTRUCT) & M_CMMAXPSTRUCT)

#define A_TP_INT_ENABLE 0x7e70

#define S_FLMTXFLSTEMPTY    30
#define V_FLMTXFLSTEMPTY(x) ((x) << S_FLMTXFLSTEMPTY)
#define F_FLMTXFLSTEMPTY    V_FLMTXFLSTEMPTY(1U)

#define S_RSSLKPPERR    29
#define V_RSSLKPPERR(x) ((x) << S_RSSLKPPERR)
#define F_RSSLKPPERR    V_RSSLKPPERR(1U)

#define S_FLMPERRSET    28
#define V_FLMPERRSET(x) ((x) << S_FLMPERRSET)
#define F_FLMPERRSET    V_FLMPERRSET(1U)

#define S_PROTOCOLSRAMPERR    27
#define V_PROTOCOLSRAMPERR(x) ((x) << S_PROTOCOLSRAMPERR)
#define F_PROTOCOLSRAMPERR    V_PROTOCOLSRAMPERR(1U)

#define S_ARPLUTPERR    26
#define V_ARPLUTPERR(x) ((x) << S_ARPLUTPERR)
#define F_ARPLUTPERR    V_ARPLUTPERR(1U)

#define S_CMRCFOPPERR    25
#define V_CMRCFOPPERR(x) ((x) << S_CMRCFOPPERR)
#define F_CMRCFOPPERR    V_CMRCFOPPERR(1U)

#define S_CMCACHEPERR    24
#define V_CMCACHEPERR(x) ((x) << S_CMCACHEPERR)
#define F_CMCACHEPERR    V_CMCACHEPERR(1U)

#define S_CMRCFDATAPERR    23
#define V_CMRCFDATAPERR(x) ((x) << S_CMRCFDATAPERR)
#define F_CMRCFDATAPERR    V_CMRCFDATAPERR(1U)

#define S_DBL2TLUTPERR    22
#define V_DBL2TLUTPERR(x) ((x) << S_DBL2TLUTPERR)
#define F_DBL2TLUTPERR    V_DBL2TLUTPERR(1U)

#define S_DBTXTIDPERR    21
#define V_DBTXTIDPERR(x) ((x) << S_DBTXTIDPERR)
#define F_DBTXTIDPERR    V_DBTXTIDPERR(1U)

#define S_DBEXTPERR    20
#define V_DBEXTPERR(x) ((x) << S_DBEXTPERR)
#define F_DBEXTPERR    V_DBEXTPERR(1U)

#define S_DBOPPERR    19
#define V_DBOPPERR(x) ((x) << S_DBOPPERR)
#define F_DBOPPERR    V_DBOPPERR(1U)

#define S_TMCACHEPERR    18
#define V_TMCACHEPERR(x) ((x) << S_TMCACHEPERR)
#define F_TMCACHEPERR    V_TMCACHEPERR(1U)

#define S_ETPOUTCPLFIFOPERR    17
#define V_ETPOUTCPLFIFOPERR(x) ((x) << S_ETPOUTCPLFIFOPERR)
#define F_ETPOUTCPLFIFOPERR    V_ETPOUTCPLFIFOPERR(1U)

#define S_ETPOUTTCPFIFOPERR    16
#define V_ETPOUTTCPFIFOPERR(x) ((x) << S_ETPOUTTCPFIFOPERR)
#define F_ETPOUTTCPFIFOPERR    V_ETPOUTTCPFIFOPERR(1U)

#define S_ETPOUTIPFIFOPERR    15
#define V_ETPOUTIPFIFOPERR(x) ((x) << S_ETPOUTIPFIFOPERR)
#define F_ETPOUTIPFIFOPERR    V_ETPOUTIPFIFOPERR(1U)

#define S_ETPOUTETHFIFOPERR    14
#define V_ETPOUTETHFIFOPERR(x) ((x) << S_ETPOUTETHFIFOPERR)
#define F_ETPOUTETHFIFOPERR    V_ETPOUTETHFIFOPERR(1U)

#define S_ETPINCPLFIFOPERR    13
#define V_ETPINCPLFIFOPERR(x) ((x) << S_ETPINCPLFIFOPERR)
#define F_ETPINCPLFIFOPERR    V_ETPINCPLFIFOPERR(1U)

#define S_ETPINTCPOPTFIFOPERR    12
#define V_ETPINTCPOPTFIFOPERR(x) ((x) << S_ETPINTCPOPTFIFOPERR)
#define F_ETPINTCPOPTFIFOPERR    V_ETPINTCPOPTFIFOPERR(1U)

#define S_ETPINTCPFIFOPERR    11
#define V_ETPINTCPFIFOPERR(x) ((x) << S_ETPINTCPFIFOPERR)
#define F_ETPINTCPFIFOPERR    V_ETPINTCPFIFOPERR(1U)

#define S_ETPINIPFIFOPERR    10
#define V_ETPINIPFIFOPERR(x) ((x) << S_ETPINIPFIFOPERR)
#define F_ETPINIPFIFOPERR    V_ETPINIPFIFOPERR(1U)

#define S_ETPINETHFIFOPERR    9
#define V_ETPINETHFIFOPERR(x) ((x) << S_ETPINETHFIFOPERR)
#define F_ETPINETHFIFOPERR    V_ETPINETHFIFOPERR(1U)

#define S_CTPOUTCPLFIFOPERR    8
#define V_CTPOUTCPLFIFOPERR(x) ((x) << S_CTPOUTCPLFIFOPERR)
#define F_CTPOUTCPLFIFOPERR    V_CTPOUTCPLFIFOPERR(1U)

#define S_CTPOUTTCPFIFOPERR    7
#define V_CTPOUTTCPFIFOPERR(x) ((x) << S_CTPOUTTCPFIFOPERR)
#define F_CTPOUTTCPFIFOPERR    V_CTPOUTTCPFIFOPERR(1U)

#define S_CTPOUTIPFIFOPERR    6
#define V_CTPOUTIPFIFOPERR(x) ((x) << S_CTPOUTIPFIFOPERR)
#define F_CTPOUTIPFIFOPERR    V_CTPOUTIPFIFOPERR(1U)

#define S_CTPOUTETHFIFOPERR    5
#define V_CTPOUTETHFIFOPERR(x) ((x) << S_CTPOUTETHFIFOPERR)
#define F_CTPOUTETHFIFOPERR    V_CTPOUTETHFIFOPERR(1U)

#define S_CTPINCPLFIFOPERR    4
#define V_CTPINCPLFIFOPERR(x) ((x) << S_CTPINCPLFIFOPERR)
#define F_CTPINCPLFIFOPERR    V_CTPINCPLFIFOPERR(1U)

#define S_CTPINTCPOPFIFOPERR    3
#define V_CTPINTCPOPFIFOPERR(x) ((x) << S_CTPINTCPOPFIFOPERR)
#define F_CTPINTCPOPFIFOPERR    V_CTPINTCPOPFIFOPERR(1U)

#define S_PDUFBKFIFOPERR    2
#define V_PDUFBKFIFOPERR(x) ((x) << S_PDUFBKFIFOPERR)
#define F_PDUFBKFIFOPERR    V_PDUFBKFIFOPERR(1U)

#define S_CMOPEXTFIFOPERR    1
#define V_CMOPEXTFIFOPERR(x) ((x) << S_CMOPEXTFIFOPERR)
#define F_CMOPEXTFIFOPERR    V_CMOPEXTFIFOPERR(1U)

#define S_DELINVFIFOPERR    0
#define V_DELINVFIFOPERR(x) ((x) << S_DELINVFIFOPERR)
#define F_DELINVFIFOPERR    V_DELINVFIFOPERR(1U)

#define S_CTPOUTPLDFIFOPERR    7
#define V_CTPOUTPLDFIFOPERR(x) ((x) << S_CTPOUTPLDFIFOPERR)
#define F_CTPOUTPLDFIFOPERR    V_CTPOUTPLDFIFOPERR(1U)

#define A_TP_INT_CAUSE 0x7e74
#define A_TP_PER_ENABLE 0x7e78
#define A_TP_FLM_FREE_PS_CNT 0x7e80

#define S_FREEPSTRUCTCOUNT    0
#define M_FREEPSTRUCTCOUNT    0x1fffffU
#define V_FREEPSTRUCTCOUNT(x) ((x) << S_FREEPSTRUCTCOUNT)
#define G_FREEPSTRUCTCOUNT(x) (((x) >> S_FREEPSTRUCTCOUNT) & M_FREEPSTRUCTCOUNT)

#define A_TP_FLM_FREE_RX_CNT 0x7e84

#define S_FREERXPAGECHN    28
#define V_FREERXPAGECHN(x) ((x) << S_FREERXPAGECHN)
#define F_FREERXPAGECHN    V_FREERXPAGECHN(1U)

#define S_FREERXPAGECOUNT    0
#define M_FREERXPAGECOUNT    0x1fffffU
#define V_FREERXPAGECOUNT(x) ((x) << S_FREERXPAGECOUNT)
#define G_FREERXPAGECOUNT(x) (((x) >> S_FREERXPAGECOUNT) & M_FREERXPAGECOUNT)

#define A_TP_FLM_FREE_TX_CNT 0x7e88

#define S_FREETXPAGECHN    28
#define M_FREETXPAGECHN    0x3U
#define V_FREETXPAGECHN(x) ((x) << S_FREETXPAGECHN)
#define G_FREETXPAGECHN(x) (((x) >> S_FREETXPAGECHN) & M_FREETXPAGECHN)

#define S_FREETXPAGECOUNT    0
#define M_FREETXPAGECOUNT    0x1fffffU
#define V_FREETXPAGECOUNT(x) ((x) << S_FREETXPAGECOUNT)
#define G_FREETXPAGECOUNT(x) (((x) >> S_FREETXPAGECOUNT) & M_FREETXPAGECOUNT)

#define A_TP_TM_HEAP_PUSH_CNT 0x7e8c
#define A_TP_TM_HEAP_POP_CNT 0x7e90
#define A_TP_TM_DACK_PUSH_CNT 0x7e94
#define A_TP_TM_DACK_POP_CNT 0x7e98
#define A_TP_TM_MOD_PUSH_CNT 0x7e9c
#define A_TP_MOD_POP_CNT 0x7ea0
#define A_TP_TIMER_SEPARATOR 0x7ea4

#define S_TIMERSEPARATOR    16
#define M_TIMERSEPARATOR    0xffffU
#define V_TIMERSEPARATOR(x) ((x) << S_TIMERSEPARATOR)
#define G_TIMERSEPARATOR(x) (((x) >> S_TIMERSEPARATOR) & M_TIMERSEPARATOR)

#define S_DISABLETIMEFREEZE    0
#define V_DISABLETIMEFREEZE(x) ((x) << S_DISABLETIMEFREEZE)
#define F_DISABLETIMEFREEZE    V_DISABLETIMEFREEZE(1U)

#define A_TP_STAMP_TIME 0x7ea8
#define A_TP_DEBUG_FLAGS 0x7eac

#define S_RXTIMERDACKFIRST    26
#define V_RXTIMERDACKFIRST(x) ((x) << S_RXTIMERDACKFIRST)
#define F_RXTIMERDACKFIRST    V_RXTIMERDACKFIRST(1U)

#define S_RXTIMERDACK    25
#define V_RXTIMERDACK(x) ((x) << S_RXTIMERDACK)
#define F_RXTIMERDACK    V_RXTIMERDACK(1U)

#define S_RXTIMERHEARTBEAT    24
#define V_RXTIMERHEARTBEAT(x) ((x) << S_RXTIMERHEARTBEAT)
#define F_RXTIMERHEARTBEAT    V_RXTIMERHEARTBEAT(1U)

#define S_RXPAWSDROP    23
#define V_RXPAWSDROP(x) ((x) << S_RXPAWSDROP)
#define F_RXPAWSDROP    V_RXPAWSDROP(1U)

#define S_RXURGDATADROP    22
#define V_RXURGDATADROP(x) ((x) << S_RXURGDATADROP)
#define F_RXURGDATADROP    V_RXURGDATADROP(1U)

#define S_RXFUTUREDATA    21
#define V_RXFUTUREDATA(x) ((x) << S_RXFUTUREDATA)
#define F_RXFUTUREDATA    V_RXFUTUREDATA(1U)

#define S_RXRCVRXMDATA    20
#define V_RXRCVRXMDATA(x) ((x) << S_RXRCVRXMDATA)
#define F_RXRCVRXMDATA    V_RXRCVRXMDATA(1U)

#define S_RXRCVOOODATAFIN    19
#define V_RXRCVOOODATAFIN(x) ((x) << S_RXRCVOOODATAFIN)
#define F_RXRCVOOODATAFIN    V_RXRCVOOODATAFIN(1U)

#define S_RXRCVOOODATA    18
#define V_RXRCVOOODATA(x) ((x) << S_RXRCVOOODATA)
#define F_RXRCVOOODATA    V_RXRCVOOODATA(1U)

#define S_RXRCVWNDZERO    17
#define V_RXRCVWNDZERO(x) ((x) << S_RXRCVWNDZERO)
#define F_RXRCVWNDZERO    V_RXRCVWNDZERO(1U)

#define S_RXRCVWNDLTMSS    16
#define V_RXRCVWNDLTMSS(x) ((x) << S_RXRCVWNDLTMSS)
#define F_RXRCVWNDLTMSS    V_RXRCVWNDLTMSS(1U)

#define S_TXDUPACKINC    11
#define V_TXDUPACKINC(x) ((x) << S_TXDUPACKINC)
#define F_TXDUPACKINC    V_TXDUPACKINC(1U)

#define S_TXRXMURG    10
#define V_TXRXMURG(x) ((x) << S_TXRXMURG)
#define F_TXRXMURG    V_TXRXMURG(1U)

#define S_TXRXMFIN    9
#define V_TXRXMFIN(x) ((x) << S_TXRXMFIN)
#define F_TXRXMFIN    V_TXRXMFIN(1U)

#define S_TXRXMSYN    8
#define V_TXRXMSYN(x) ((x) << S_TXRXMSYN)
#define F_TXRXMSYN    V_TXRXMSYN(1U)

#define S_TXRXMNEWRENO    7
#define V_TXRXMNEWRENO(x) ((x) << S_TXRXMNEWRENO)
#define F_TXRXMNEWRENO    V_TXRXMNEWRENO(1U)

#define S_TXRXMFAST    6
#define V_TXRXMFAST(x) ((x) << S_TXRXMFAST)
#define F_TXRXMFAST    V_TXRXMFAST(1U)

#define S_TXRXMTIMER    5
#define V_TXRXMTIMER(x) ((x) << S_TXRXMTIMER)
#define F_TXRXMTIMER    V_TXRXMTIMER(1U)

#define S_TXRXMTIMERKEEPALIVE    4
#define V_TXRXMTIMERKEEPALIVE(x) ((x) << S_TXRXMTIMERKEEPALIVE)
#define F_TXRXMTIMERKEEPALIVE    V_TXRXMTIMERKEEPALIVE(1U)

#define S_TXRXMTIMERPERSIST    3
#define V_TXRXMTIMERPERSIST(x) ((x) << S_TXRXMTIMERPERSIST)
#define F_TXRXMTIMERPERSIST    V_TXRXMTIMERPERSIST(1U)

#define S_TXRCVADVSHRUNK    2
#define V_TXRCVADVSHRUNK(x) ((x) << S_TXRCVADVSHRUNK)
#define F_TXRCVADVSHRUNK    V_TXRCVADVSHRUNK(1U)

#define S_TXRCVADVZERO    1
#define V_TXRCVADVZERO(x) ((x) << S_TXRCVADVZERO)
#define F_TXRCVADVZERO    V_TXRCVADVZERO(1U)

#define S_TXRCVADVLTMSS    0
#define V_TXRCVADVLTMSS(x) ((x) << S_TXRCVADVLTMSS)
#define F_TXRCVADVLTMSS    V_TXRCVADVLTMSS(1U)

#define S_RXTIMERCOMPBUFFER    27
#define V_RXTIMERCOMPBUFFER(x) ((x) << S_RXTIMERCOMPBUFFER)
#define F_RXTIMERCOMPBUFFER    V_RXTIMERCOMPBUFFER(1U)

#define S_TXDFRFAST    13
#define V_TXDFRFAST(x) ((x) << S_TXDFRFAST)
#define F_TXDFRFAST    V_TXDFRFAST(1U)

#define S_TXRXMMISC    12
#define V_TXRXMMISC(x) ((x) << S_TXRXMMISC)
#define F_TXRXMMISC    V_TXRXMMISC(1U)

#define A_TP_RX_SCHED 0x7eb0

#define S_RXCOMMITRESET1    31
#define V_RXCOMMITRESET1(x) ((x) << S_RXCOMMITRESET1)
#define F_RXCOMMITRESET1    V_RXCOMMITRESET1(1U)

#define S_RXCOMMITRESET0    30
#define V_RXCOMMITRESET0(x) ((x) << S_RXCOMMITRESET0)
#define F_RXCOMMITRESET0    V_RXCOMMITRESET0(1U)

#define S_RXFORCECONG1    29
#define V_RXFORCECONG1(x) ((x) << S_RXFORCECONG1)
#define F_RXFORCECONG1    V_RXFORCECONG1(1U)

#define S_RXFORCECONG0    28
#define V_RXFORCECONG0(x) ((x) << S_RXFORCECONG0)
#define F_RXFORCECONG0    V_RXFORCECONG0(1U)

#define S_ENABLELPBKFULL1    26
#define M_ENABLELPBKFULL1    0x3U
#define V_ENABLELPBKFULL1(x) ((x) << S_ENABLELPBKFULL1)
#define G_ENABLELPBKFULL1(x) (((x) >> S_ENABLELPBKFULL1) & M_ENABLELPBKFULL1)

#define S_ENABLELPBKFULL0    24
#define M_ENABLELPBKFULL0    0x3U
#define V_ENABLELPBKFULL0(x) ((x) << S_ENABLELPBKFULL0)
#define G_ENABLELPBKFULL0(x) (((x) >> S_ENABLELPBKFULL0) & M_ENABLELPBKFULL0)

#define S_ENABLEFIFOFULL1    22
#define M_ENABLEFIFOFULL1    0x3U
#define V_ENABLEFIFOFULL1(x) ((x) << S_ENABLEFIFOFULL1)
#define G_ENABLEFIFOFULL1(x) (((x) >> S_ENABLEFIFOFULL1) & M_ENABLEFIFOFULL1)

#define S_ENABLEPCMDFULL1    20
#define M_ENABLEPCMDFULL1    0x3U
#define V_ENABLEPCMDFULL1(x) ((x) << S_ENABLEPCMDFULL1)
#define G_ENABLEPCMDFULL1(x) (((x) >> S_ENABLEPCMDFULL1) & M_ENABLEPCMDFULL1)

#define S_ENABLEHDRFULL1    18
#define M_ENABLEHDRFULL1    0x3U
#define V_ENABLEHDRFULL1(x) ((x) << S_ENABLEHDRFULL1)
#define G_ENABLEHDRFULL1(x) (((x) >> S_ENABLEHDRFULL1) & M_ENABLEHDRFULL1)

#define S_ENABLEFIFOFULL0    16
#define M_ENABLEFIFOFULL0    0x3U
#define V_ENABLEFIFOFULL0(x) ((x) << S_ENABLEFIFOFULL0)
#define G_ENABLEFIFOFULL0(x) (((x) >> S_ENABLEFIFOFULL0) & M_ENABLEFIFOFULL0)

#define S_ENABLEPCMDFULL0    14
#define M_ENABLEPCMDFULL0    0x3U
#define V_ENABLEPCMDFULL0(x) ((x) << S_ENABLEPCMDFULL0)
#define G_ENABLEPCMDFULL0(x) (((x) >> S_ENABLEPCMDFULL0) & M_ENABLEPCMDFULL0)

#define S_ENABLEHDRFULL0    12
#define M_ENABLEHDRFULL0    0x3U
#define V_ENABLEHDRFULL0(x) ((x) << S_ENABLEHDRFULL0)
#define G_ENABLEHDRFULL0(x) (((x) >> S_ENABLEHDRFULL0) & M_ENABLEHDRFULL0)

#define S_COMMITLIMIT1    6
#define M_COMMITLIMIT1    0x3fU
#define V_COMMITLIMIT1(x) ((x) << S_COMMITLIMIT1)
#define G_COMMITLIMIT1(x) (((x) >> S_COMMITLIMIT1) & M_COMMITLIMIT1)

#define S_COMMITLIMIT0    0
#define M_COMMITLIMIT0    0x3fU
#define V_COMMITLIMIT0(x) ((x) << S_COMMITLIMIT0)
#define G_COMMITLIMIT0(x) (((x) >> S_COMMITLIMIT0) & M_COMMITLIMIT0)

#define A_TP_TX_SCHED 0x7eb4

#define S_COMMITRESET3    31
#define V_COMMITRESET3(x) ((x) << S_COMMITRESET3)
#define F_COMMITRESET3    V_COMMITRESET3(1U)

#define S_COMMITRESET2    30
#define V_COMMITRESET2(x) ((x) << S_COMMITRESET2)
#define F_COMMITRESET2    V_COMMITRESET2(1U)

#define S_COMMITRESET1    29
#define V_COMMITRESET1(x) ((x) << S_COMMITRESET1)
#define F_COMMITRESET1    V_COMMITRESET1(1U)

#define S_COMMITRESET0    28
#define V_COMMITRESET0(x) ((x) << S_COMMITRESET0)
#define F_COMMITRESET0    V_COMMITRESET0(1U)

#define S_FORCECONG3    27
#define V_FORCECONG3(x) ((x) << S_FORCECONG3)
#define F_FORCECONG3    V_FORCECONG3(1U)

#define S_FORCECONG2    26
#define V_FORCECONG2(x) ((x) << S_FORCECONG2)
#define F_FORCECONG2    V_FORCECONG2(1U)

#define S_FORCECONG1    25
#define V_FORCECONG1(x) ((x) << S_FORCECONG1)
#define F_FORCECONG1    V_FORCECONG1(1U)

#define S_FORCECONG0    24
#define V_FORCECONG0(x) ((x) << S_FORCECONG0)
#define F_FORCECONG0    V_FORCECONG0(1U)

#define S_COMMITLIMIT3    18
#define M_COMMITLIMIT3    0x3fU
#define V_COMMITLIMIT3(x) ((x) << S_COMMITLIMIT3)
#define G_COMMITLIMIT3(x) (((x) >> S_COMMITLIMIT3) & M_COMMITLIMIT3)

#define S_COMMITLIMIT2    12
#define M_COMMITLIMIT2    0x3fU
#define V_COMMITLIMIT2(x) ((x) << S_COMMITLIMIT2)
#define G_COMMITLIMIT2(x) (((x) >> S_COMMITLIMIT2) & M_COMMITLIMIT2)

#define A_TP_FX_SCHED 0x7eb8

#define S_TXCHNXOFF3    19
#define V_TXCHNXOFF3(x) ((x) << S_TXCHNXOFF3)
#define F_TXCHNXOFF3    V_TXCHNXOFF3(1U)

#define S_TXCHNXOFF2    18
#define V_TXCHNXOFF2(x) ((x) << S_TXCHNXOFF2)
#define F_TXCHNXOFF2    V_TXCHNXOFF2(1U)

#define S_TXCHNXOFF1    17
#define V_TXCHNXOFF1(x) ((x) << S_TXCHNXOFF1)
#define F_TXCHNXOFF1    V_TXCHNXOFF1(1U)

#define S_TXCHNXOFF0    16
#define V_TXCHNXOFF0(x) ((x) << S_TXCHNXOFF0)
#define F_TXCHNXOFF0    V_TXCHNXOFF0(1U)

#define S_TXMODXOFF7    15
#define V_TXMODXOFF7(x) ((x) << S_TXMODXOFF7)
#define F_TXMODXOFF7    V_TXMODXOFF7(1U)

#define S_TXMODXOFF6    14
#define V_TXMODXOFF6(x) ((x) << S_TXMODXOFF6)
#define F_TXMODXOFF6    V_TXMODXOFF6(1U)

#define S_TXMODXOFF5    13
#define V_TXMODXOFF5(x) ((x) << S_TXMODXOFF5)
#define F_TXMODXOFF5    V_TXMODXOFF5(1U)

#define S_TXMODXOFF4    12
#define V_TXMODXOFF4(x) ((x) << S_TXMODXOFF4)
#define F_TXMODXOFF4    V_TXMODXOFF4(1U)

#define S_TXMODXOFF3    11
#define V_TXMODXOFF3(x) ((x) << S_TXMODXOFF3)
#define F_TXMODXOFF3    V_TXMODXOFF3(1U)

#define S_TXMODXOFF2    10
#define V_TXMODXOFF2(x) ((x) << S_TXMODXOFF2)
#define F_TXMODXOFF2    V_TXMODXOFF2(1U)

#define S_TXMODXOFF1    9
#define V_TXMODXOFF1(x) ((x) << S_TXMODXOFF1)
#define F_TXMODXOFF1    V_TXMODXOFF1(1U)

#define S_TXMODXOFF0    8
#define V_TXMODXOFF0(x) ((x) << S_TXMODXOFF0)
#define F_TXMODXOFF0    V_TXMODXOFF0(1U)

#define S_RXCHNXOFF3    7
#define V_RXCHNXOFF3(x) ((x) << S_RXCHNXOFF3)
#define F_RXCHNXOFF3    V_RXCHNXOFF3(1U)

#define S_RXCHNXOFF2    6
#define V_RXCHNXOFF2(x) ((x) << S_RXCHNXOFF2)
#define F_RXCHNXOFF2    V_RXCHNXOFF2(1U)

#define S_RXCHNXOFF1    5
#define V_RXCHNXOFF1(x) ((x) << S_RXCHNXOFF1)
#define F_RXCHNXOFF1    V_RXCHNXOFF1(1U)

#define S_RXCHNXOFF0    4
#define V_RXCHNXOFF0(x) ((x) << S_RXCHNXOFF0)
#define F_RXCHNXOFF0    V_RXCHNXOFF0(1U)

#define S_RXMODXOFF1    1
#define V_RXMODXOFF1(x) ((x) << S_RXMODXOFF1)
#define F_RXMODXOFF1    V_RXMODXOFF1(1U)

#define S_RXMODXOFF0    0
#define V_RXMODXOFF0(x) ((x) << S_RXMODXOFF0)
#define F_RXMODXOFF0    V_RXMODXOFF0(1U)

#define A_TP_TX_ORATE 0x7ebc

#define S_OFDRATE3    24
#define M_OFDRATE3    0xffU
#define V_OFDRATE3(x) ((x) << S_OFDRATE3)
#define G_OFDRATE3(x) (((x) >> S_OFDRATE3) & M_OFDRATE3)

#define S_OFDRATE2    16
#define M_OFDRATE2    0xffU
#define V_OFDRATE2(x) ((x) << S_OFDRATE2)
#define G_OFDRATE2(x) (((x) >> S_OFDRATE2) & M_OFDRATE2)

#define S_OFDRATE1    8
#define M_OFDRATE1    0xffU
#define V_OFDRATE1(x) ((x) << S_OFDRATE1)
#define G_OFDRATE1(x) (((x) >> S_OFDRATE1) & M_OFDRATE1)

#define S_OFDRATE0    0
#define M_OFDRATE0    0xffU
#define V_OFDRATE0(x) ((x) << S_OFDRATE0)
#define G_OFDRATE0(x) (((x) >> S_OFDRATE0) & M_OFDRATE0)

#define A_TP_IX_SCHED0 0x7ec0
#define A_TP_IX_SCHED1 0x7ec4
#define A_TP_IX_SCHED2 0x7ec8
#define A_TP_IX_SCHED3 0x7ecc
#define A_TP_TX_TRATE 0x7ed0

#define S_TNLRATE3    24
#define M_TNLRATE3    0xffU
#define V_TNLRATE3(x) ((x) << S_TNLRATE3)
#define G_TNLRATE3(x) (((x) >> S_TNLRATE3) & M_TNLRATE3)

#define S_TNLRATE2    16
#define M_TNLRATE2    0xffU
#define V_TNLRATE2(x) ((x) << S_TNLRATE2)
#define G_TNLRATE2(x) (((x) >> S_TNLRATE2) & M_TNLRATE2)

#define S_TNLRATE1    8
#define M_TNLRATE1    0xffU
#define V_TNLRATE1(x) ((x) << S_TNLRATE1)
#define G_TNLRATE1(x) (((x) >> S_TNLRATE1) & M_TNLRATE1)

#define S_TNLRATE0    0
#define M_TNLRATE0    0xffU
#define V_TNLRATE0(x) ((x) << S_TNLRATE0)
#define G_TNLRATE0(x) (((x) >> S_TNLRATE0) & M_TNLRATE0)

#define A_TP_DBG_LA_CONFIG 0x7ed4

#define S_DBGLAOPCENABLE    24
#define M_DBGLAOPCENABLE    0xffU
#define V_DBGLAOPCENABLE(x) ((x) << S_DBGLAOPCENABLE)
#define G_DBGLAOPCENABLE(x) (((x) >> S_DBGLAOPCENABLE) & M_DBGLAOPCENABLE)

#define S_DBGLAWHLF    23
#define V_DBGLAWHLF(x) ((x) << S_DBGLAWHLF)
#define F_DBGLAWHLF    V_DBGLAWHLF(1U)

#define S_DBGLAWPTR    16
#define M_DBGLAWPTR    0x7fU
#define V_DBGLAWPTR(x) ((x) << S_DBGLAWPTR)
#define G_DBGLAWPTR(x) (((x) >> S_DBGLAWPTR) & M_DBGLAWPTR)

#define S_DBGLAMODE    14
#define M_DBGLAMODE    0x3U
#define V_DBGLAMODE(x) ((x) << S_DBGLAMODE)
#define G_DBGLAMODE(x) (((x) >> S_DBGLAMODE) & M_DBGLAMODE)

#define S_DBGLAFATALFREEZE    13
#define V_DBGLAFATALFREEZE(x) ((x) << S_DBGLAFATALFREEZE)
#define F_DBGLAFATALFREEZE    V_DBGLAFATALFREEZE(1U)

#define S_DBGLAENABLE    12
#define V_DBGLAENABLE(x) ((x) << S_DBGLAENABLE)
#define F_DBGLAENABLE    V_DBGLAENABLE(1U)

#define S_DBGLARPTR    0
#define M_DBGLARPTR    0x7fU
#define V_DBGLARPTR(x) ((x) << S_DBGLARPTR)
#define G_DBGLARPTR(x) (((x) >> S_DBGLARPTR) & M_DBGLARPTR)

#define A_TP_DBG_LA_DATAL 0x7ed8
#define A_TP_DBG_LA_DATAH 0x7edc
#define A_TP_PROTOCOL_CNTRL 0x7ee8

#define S_WRITEENABLE    31
#define V_WRITEENABLE(x) ((x) << S_WRITEENABLE)
#define F_WRITEENABLE    V_WRITEENABLE(1U)

#define S_TCAMENABLE    10
#define V_TCAMENABLE(x) ((x) << S_TCAMENABLE)
#define F_TCAMENABLE    V_TCAMENABLE(1U)

#define S_BLOCKSELECT    8
#define M_BLOCKSELECT    0x3U
#define V_BLOCKSELECT(x) ((x) << S_BLOCKSELECT)
#define G_BLOCKSELECT(x) (((x) >> S_BLOCKSELECT) & M_BLOCKSELECT)

#define S_LINEADDRESS    1
#define M_LINEADDRESS    0x7fU
#define V_LINEADDRESS(x) ((x) << S_LINEADDRESS)
#define G_LINEADDRESS(x) (((x) >> S_LINEADDRESS) & M_LINEADDRESS)

#define S_REQUESTDONE    0
#define V_REQUESTDONE(x) ((x) << S_REQUESTDONE)
#define F_REQUESTDONE    V_REQUESTDONE(1U)

#define A_TP_PROTOCOL_DATA0 0x7eec
#define A_TP_PROTOCOL_DATA1 0x7ef0
#define A_TP_PROTOCOL_DATA2 0x7ef4
#define A_TP_PROTOCOL_DATA3 0x7ef8
#define A_TP_PROTOCOL_DATA4 0x7efc

#define S_PROTOCOLDATAFIELD    0
#define M_PROTOCOLDATAFIELD    0xfU
#define V_PROTOCOLDATAFIELD(x) ((x) << S_PROTOCOLDATAFIELD)
#define G_PROTOCOLDATAFIELD(x) (((x) >> S_PROTOCOLDATAFIELD) & M_PROTOCOLDATAFIELD)

#define A_TP_TX_MOD_Q7_Q6_TIMER_SEPARATOR 0x0

#define S_TXTIMERSEPQ7    16
#define M_TXTIMERSEPQ7    0xffffU
#define V_TXTIMERSEPQ7(x) ((x) << S_TXTIMERSEPQ7)
#define G_TXTIMERSEPQ7(x) (((x) >> S_TXTIMERSEPQ7) & M_TXTIMERSEPQ7)

#define S_TXTIMERSEPQ6    0
#define M_TXTIMERSEPQ6    0xffffU
#define V_TXTIMERSEPQ6(x) ((x) << S_TXTIMERSEPQ6)
#define G_TXTIMERSEPQ6(x) (((x) >> S_TXTIMERSEPQ6) & M_TXTIMERSEPQ6)

#define A_TP_TX_MOD_Q5_Q4_TIMER_SEPARATOR 0x1

#define S_TXTIMERSEPQ5    16
#define M_TXTIMERSEPQ5    0xffffU
#define V_TXTIMERSEPQ5(x) ((x) << S_TXTIMERSEPQ5)
#define G_TXTIMERSEPQ5(x) (((x) >> S_TXTIMERSEPQ5) & M_TXTIMERSEPQ5)

#define S_TXTIMERSEPQ4    0
#define M_TXTIMERSEPQ4    0xffffU
#define V_TXTIMERSEPQ4(x) ((x) << S_TXTIMERSEPQ4)
#define G_TXTIMERSEPQ4(x) (((x) >> S_TXTIMERSEPQ4) & M_TXTIMERSEPQ4)

#define A_TP_TX_MOD_Q3_Q2_TIMER_SEPARATOR 0x2

#define S_TXTIMERSEPQ3    16
#define M_TXTIMERSEPQ3    0xffffU
#define V_TXTIMERSEPQ3(x) ((x) << S_TXTIMERSEPQ3)
#define G_TXTIMERSEPQ3(x) (((x) >> S_TXTIMERSEPQ3) & M_TXTIMERSEPQ3)

#define S_TXTIMERSEPQ2    0
#define M_TXTIMERSEPQ2    0xffffU
#define V_TXTIMERSEPQ2(x) ((x) << S_TXTIMERSEPQ2)
#define G_TXTIMERSEPQ2(x) (((x) >> S_TXTIMERSEPQ2) & M_TXTIMERSEPQ2)

#define A_TP_TX_MOD_Q1_Q0_TIMER_SEPARATOR 0x3

#define S_TXTIMERSEPQ1    16
#define M_TXTIMERSEPQ1    0xffffU
#define V_TXTIMERSEPQ1(x) ((x) << S_TXTIMERSEPQ1)
#define G_TXTIMERSEPQ1(x) (((x) >> S_TXTIMERSEPQ1) & M_TXTIMERSEPQ1)

#define S_TXTIMERSEPQ0    0
#define M_TXTIMERSEPQ0    0xffffU
#define V_TXTIMERSEPQ0(x) ((x) << S_TXTIMERSEPQ0)
#define G_TXTIMERSEPQ0(x) (((x) >> S_TXTIMERSEPQ0) & M_TXTIMERSEPQ0)

#define A_TP_RX_MOD_Q1_Q0_TIMER_SEPARATOR 0x4

#define S_RXTIMERSEPQ1    16
#define M_RXTIMERSEPQ1    0xffffU
#define V_RXTIMERSEPQ1(x) ((x) << S_RXTIMERSEPQ1)
#define G_RXTIMERSEPQ1(x) (((x) >> S_RXTIMERSEPQ1) & M_RXTIMERSEPQ1)

#define S_RXTIMERSEPQ0    0
#define M_RXTIMERSEPQ0    0xffffU
#define V_RXTIMERSEPQ0(x) ((x) << S_RXTIMERSEPQ0)
#define G_RXTIMERSEPQ0(x) (((x) >> S_RXTIMERSEPQ0) & M_RXTIMERSEPQ0)

#define A_TP_TX_MOD_Q7_Q6_RATE_LIMIT 0x5

#define S_TXRATEINCQ7    24
#define M_TXRATEINCQ7    0xffU
#define V_TXRATEINCQ7(x) ((x) << S_TXRATEINCQ7)
#define G_TXRATEINCQ7(x) (((x) >> S_TXRATEINCQ7) & M_TXRATEINCQ7)

#define S_TXRATETCKQ7    16
#define M_TXRATETCKQ7    0xffU
#define V_TXRATETCKQ7(x) ((x) << S_TXRATETCKQ7)
#define G_TXRATETCKQ7(x) (((x) >> S_TXRATETCKQ7) & M_TXRATETCKQ7)

#define S_TXRATEINCQ6    8
#define M_TXRATEINCQ6    0xffU
#define V_TXRATEINCQ6(x) ((x) << S_TXRATEINCQ6)
#define G_TXRATEINCQ6(x) (((x) >> S_TXRATEINCQ6) & M_TXRATEINCQ6)

#define S_TXRATETCKQ6    0
#define M_TXRATETCKQ6    0xffU
#define V_TXRATETCKQ6(x) ((x) << S_TXRATETCKQ6)
#define G_TXRATETCKQ6(x) (((x) >> S_TXRATETCKQ6) & M_TXRATETCKQ6)

#define A_TP_TX_MOD_Q5_Q4_RATE_LIMIT 0x6

#define S_TXRATEINCQ5    24
#define M_TXRATEINCQ5    0xffU
#define V_TXRATEINCQ5(x) ((x) << S_TXRATEINCQ5)
#define G_TXRATEINCQ5(x) (((x) >> S_TXRATEINCQ5) & M_TXRATEINCQ5)

#define S_TXRATETCKQ5    16
#define M_TXRATETCKQ5    0xffU
#define V_TXRATETCKQ5(x) ((x) << S_TXRATETCKQ5)
#define G_TXRATETCKQ5(x) (((x) >> S_TXRATETCKQ5) & M_TXRATETCKQ5)

#define S_TXRATEINCQ4    8
#define M_TXRATEINCQ4    0xffU
#define V_TXRATEINCQ4(x) ((x) << S_TXRATEINCQ4)
#define G_TXRATEINCQ4(x) (((x) >> S_TXRATEINCQ4) & M_TXRATEINCQ4)

#define S_TXRATETCKQ4    0
#define M_TXRATETCKQ4    0xffU
#define V_TXRATETCKQ4(x) ((x) << S_TXRATETCKQ4)
#define G_TXRATETCKQ4(x) (((x) >> S_TXRATETCKQ4) & M_TXRATETCKQ4)

#define A_TP_TX_MOD_Q3_Q2_RATE_LIMIT 0x7

#define S_TXRATEINCQ3    24
#define M_TXRATEINCQ3    0xffU
#define V_TXRATEINCQ3(x) ((x) << S_TXRATEINCQ3)
#define G_TXRATEINCQ3(x) (((x) >> S_TXRATEINCQ3) & M_TXRATEINCQ3)

#define S_TXRATETCKQ3    16
#define M_TXRATETCKQ3    0xffU
#define V_TXRATETCKQ3(x) ((x) << S_TXRATETCKQ3)
#define G_TXRATETCKQ3(x) (((x) >> S_TXRATETCKQ3) & M_TXRATETCKQ3)

#define S_TXRATEINCQ2    8
#define M_TXRATEINCQ2    0xffU
#define V_TXRATEINCQ2(x) ((x) << S_TXRATEINCQ2)
#define G_TXRATEINCQ2(x) (((x) >> S_TXRATEINCQ2) & M_TXRATEINCQ2)

#define S_TXRATETCKQ2    0
#define M_TXRATETCKQ2    0xffU
#define V_TXRATETCKQ2(x) ((x) << S_TXRATETCKQ2)
#define G_TXRATETCKQ2(x) (((x) >> S_TXRATETCKQ2) & M_TXRATETCKQ2)

#define A_TP_TX_MOD_Q1_Q0_RATE_LIMIT 0x8

#define S_TXRATEINCQ1    24
#define M_TXRATEINCQ1    0xffU
#define V_TXRATEINCQ1(x) ((x) << S_TXRATEINCQ1)
#define G_TXRATEINCQ1(x) (((x) >> S_TXRATEINCQ1) & M_TXRATEINCQ1)

#define S_TXRATETCKQ1    16
#define M_TXRATETCKQ1    0xffU
#define V_TXRATETCKQ1(x) ((x) << S_TXRATETCKQ1)
#define G_TXRATETCKQ1(x) (((x) >> S_TXRATETCKQ1) & M_TXRATETCKQ1)

#define S_TXRATEINCQ0    8
#define M_TXRATEINCQ0    0xffU
#define V_TXRATEINCQ0(x) ((x) << S_TXRATEINCQ0)
#define G_TXRATEINCQ0(x) (((x) >> S_TXRATEINCQ0) & M_TXRATEINCQ0)

#define S_TXRATETCKQ0    0
#define M_TXRATETCKQ0    0xffU
#define V_TXRATETCKQ0(x) ((x) << S_TXRATETCKQ0)
#define G_TXRATETCKQ0(x) (((x) >> S_TXRATETCKQ0) & M_TXRATETCKQ0)

#define A_TP_RX_MOD_Q1_Q0_RATE_LIMIT 0x9

#define S_RXRATEINCQ1    24
#define M_RXRATEINCQ1    0xffU
#define V_RXRATEINCQ1(x) ((x) << S_RXRATEINCQ1)
#define G_RXRATEINCQ1(x) (((x) >> S_RXRATEINCQ1) & M_RXRATEINCQ1)

#define S_RXRATETCKQ1    16
#define M_RXRATETCKQ1    0xffU
#define V_RXRATETCKQ1(x) ((x) << S_RXRATETCKQ1)
#define G_RXRATETCKQ1(x) (((x) >> S_RXRATETCKQ1) & M_RXRATETCKQ1)

#define S_RXRATEINCQ0    8
#define M_RXRATEINCQ0    0xffU
#define V_RXRATEINCQ0(x) ((x) << S_RXRATEINCQ0)
#define G_RXRATEINCQ0(x) (((x) >> S_RXRATEINCQ0) & M_RXRATEINCQ0)

#define S_RXRATETCKQ0    0
#define M_RXRATETCKQ0    0xffU
#define V_RXRATETCKQ0(x) ((x) << S_RXRATETCKQ0)
#define G_RXRATETCKQ0(x) (((x) >> S_RXRATETCKQ0) & M_RXRATETCKQ0)

#define A_TP_TX_MOD_C3_C2_RATE_LIMIT 0xa
#define A_TP_TX_MOD_C1_C0_RATE_LIMIT 0xb
#define A_TP_RX_SCHED_MAP 0x20

#define S_RXMAPCHANNEL3    24
#define M_RXMAPCHANNEL3    0xffU
#define V_RXMAPCHANNEL3(x) ((x) << S_RXMAPCHANNEL3)
#define G_RXMAPCHANNEL3(x) (((x) >> S_RXMAPCHANNEL3) & M_RXMAPCHANNEL3)

#define S_RXMAPCHANNEL2    16
#define M_RXMAPCHANNEL2    0xffU
#define V_RXMAPCHANNEL2(x) ((x) << S_RXMAPCHANNEL2)
#define G_RXMAPCHANNEL2(x) (((x) >> S_RXMAPCHANNEL2) & M_RXMAPCHANNEL2)

#define S_RXMAPCHANNEL1    8
#define M_RXMAPCHANNEL1    0xffU
#define V_RXMAPCHANNEL1(x) ((x) << S_RXMAPCHANNEL1)
#define G_RXMAPCHANNEL1(x) (((x) >> S_RXMAPCHANNEL1) & M_RXMAPCHANNEL1)

#define S_RXMAPCHANNEL0    0
#define M_RXMAPCHANNEL0    0xffU
#define V_RXMAPCHANNEL0(x) ((x) << S_RXMAPCHANNEL0)
#define G_RXMAPCHANNEL0(x) (((x) >> S_RXMAPCHANNEL0) & M_RXMAPCHANNEL0)

#define A_TP_RX_SCHED_SGE 0x21

#define S_RXSGEMOD1    12
#define M_RXSGEMOD1    0xfU
#define V_RXSGEMOD1(x) ((x) << S_RXSGEMOD1)
#define G_RXSGEMOD1(x) (((x) >> S_RXSGEMOD1) & M_RXSGEMOD1)

#define S_RXSGEMOD0    8
#define M_RXSGEMOD0    0xfU
#define V_RXSGEMOD0(x) ((x) << S_RXSGEMOD0)
#define G_RXSGEMOD0(x) (((x) >> S_RXSGEMOD0) & M_RXSGEMOD0)

#define S_RXSGECHANNEL3    3
#define V_RXSGECHANNEL3(x) ((x) << S_RXSGECHANNEL3)
#define F_RXSGECHANNEL3    V_RXSGECHANNEL3(1U)

#define S_RXSGECHANNEL2    2
#define V_RXSGECHANNEL2(x) ((x) << S_RXSGECHANNEL2)
#define F_RXSGECHANNEL2    V_RXSGECHANNEL2(1U)

#define S_RXSGECHANNEL1    1
#define V_RXSGECHANNEL1(x) ((x) << S_RXSGECHANNEL1)
#define F_RXSGECHANNEL1    V_RXSGECHANNEL1(1U)

#define S_RXSGECHANNEL0    0
#define V_RXSGECHANNEL0(x) ((x) << S_RXSGECHANNEL0)
#define F_RXSGECHANNEL0    V_RXSGECHANNEL0(1U)

#define A_TP_TX_SCHED_MAP 0x22

#define S_TXMAPCHANNEL3    12
#define M_TXMAPCHANNEL3    0xfU
#define V_TXMAPCHANNEL3(x) ((x) << S_TXMAPCHANNEL3)
#define G_TXMAPCHANNEL3(x) (((x) >> S_TXMAPCHANNEL3) & M_TXMAPCHANNEL3)

#define S_TXMAPCHANNEL2    8
#define M_TXMAPCHANNEL2    0xfU
#define V_TXMAPCHANNEL2(x) ((x) << S_TXMAPCHANNEL2)
#define G_TXMAPCHANNEL2(x) (((x) >> S_TXMAPCHANNEL2) & M_TXMAPCHANNEL2)

#define S_TXMAPCHANNEL1    4
#define M_TXMAPCHANNEL1    0xfU
#define V_TXMAPCHANNEL1(x) ((x) << S_TXMAPCHANNEL1)
#define G_TXMAPCHANNEL1(x) (((x) >> S_TXMAPCHANNEL1) & M_TXMAPCHANNEL1)

#define S_TXMAPCHANNEL0    0
#define M_TXMAPCHANNEL0    0xfU
#define V_TXMAPCHANNEL0(x) ((x) << S_TXMAPCHANNEL0)
#define G_TXMAPCHANNEL0(x) (((x) >> S_TXMAPCHANNEL0) & M_TXMAPCHANNEL0)

#define A_TP_TX_SCHED_HDR 0x23

#define S_TXMAPHDRCHANNEL7    28
#define M_TXMAPHDRCHANNEL7    0xfU
#define V_TXMAPHDRCHANNEL7(x) ((x) << S_TXMAPHDRCHANNEL7)
#define G_TXMAPHDRCHANNEL7(x) (((x) >> S_TXMAPHDRCHANNEL7) & M_TXMAPHDRCHANNEL7)

#define S_TXMAPHDRCHANNEL6    24
#define M_TXMAPHDRCHANNEL6    0xfU
#define V_TXMAPHDRCHANNEL6(x) ((x) << S_TXMAPHDRCHANNEL6)
#define G_TXMAPHDRCHANNEL6(x) (((x) >> S_TXMAPHDRCHANNEL6) & M_TXMAPHDRCHANNEL6)

#define S_TXMAPHDRCHANNEL5    20
#define M_TXMAPHDRCHANNEL5    0xfU
#define V_TXMAPHDRCHANNEL5(x) ((x) << S_TXMAPHDRCHANNEL5)
#define G_TXMAPHDRCHANNEL5(x) (((x) >> S_TXMAPHDRCHANNEL5) & M_TXMAPHDRCHANNEL5)

#define S_TXMAPHDRCHANNEL4    16
#define M_TXMAPHDRCHANNEL4    0xfU
#define V_TXMAPHDRCHANNEL4(x) ((x) << S_TXMAPHDRCHANNEL4)
#define G_TXMAPHDRCHANNEL4(x) (((x) >> S_TXMAPHDRCHANNEL4) & M_TXMAPHDRCHANNEL4)

#define S_TXMAPHDRCHANNEL3    12
#define M_TXMAPHDRCHANNEL3    0xfU
#define V_TXMAPHDRCHANNEL3(x) ((x) << S_TXMAPHDRCHANNEL3)
#define G_TXMAPHDRCHANNEL3(x) (((x) >> S_TXMAPHDRCHANNEL3) & M_TXMAPHDRCHANNEL3)

#define S_TXMAPHDRCHANNEL2    8
#define M_TXMAPHDRCHANNEL2    0xfU
#define V_TXMAPHDRCHANNEL2(x) ((x) << S_TXMAPHDRCHANNEL2)
#define G_TXMAPHDRCHANNEL2(x) (((x) >> S_TXMAPHDRCHANNEL2) & M_TXMAPHDRCHANNEL2)

#define S_TXMAPHDRCHANNEL1    4
#define M_TXMAPHDRCHANNEL1    0xfU
#define V_TXMAPHDRCHANNEL1(x) ((x) << S_TXMAPHDRCHANNEL1)
#define G_TXMAPHDRCHANNEL1(x) (((x) >> S_TXMAPHDRCHANNEL1) & M_TXMAPHDRCHANNEL1)

#define S_TXMAPHDRCHANNEL0    0
#define M_TXMAPHDRCHANNEL0    0xfU
#define V_TXMAPHDRCHANNEL0(x) ((x) << S_TXMAPHDRCHANNEL0)
#define G_TXMAPHDRCHANNEL0(x) (((x) >> S_TXMAPHDRCHANNEL0) & M_TXMAPHDRCHANNEL0)

#define A_TP_TX_SCHED_FIFO 0x24

#define S_TXMAPFIFOCHANNEL7    28
#define M_TXMAPFIFOCHANNEL7    0xfU
#define V_TXMAPFIFOCHANNEL7(x) ((x) << S_TXMAPFIFOCHANNEL7)
#define G_TXMAPFIFOCHANNEL7(x) (((x) >> S_TXMAPFIFOCHANNEL7) & M_TXMAPFIFOCHANNEL7)

#define S_TXMAPFIFOCHANNEL6    24
#define M_TXMAPFIFOCHANNEL6    0xfU
#define V_TXMAPFIFOCHANNEL6(x) ((x) << S_TXMAPFIFOCHANNEL6)
#define G_TXMAPFIFOCHANNEL6(x) (((x) >> S_TXMAPFIFOCHANNEL6) & M_TXMAPFIFOCHANNEL6)

#define S_TXMAPFIFOCHANNEL5    20
#define M_TXMAPFIFOCHANNEL5    0xfU
#define V_TXMAPFIFOCHANNEL5(x) ((x) << S_TXMAPFIFOCHANNEL5)
#define G_TXMAPFIFOCHANNEL5(x) (((x) >> S_TXMAPFIFOCHANNEL5) & M_TXMAPFIFOCHANNEL5)

#define S_TXMAPFIFOCHANNEL4    16
#define M_TXMAPFIFOCHANNEL4    0xfU
#define V_TXMAPFIFOCHANNEL4(x) ((x) << S_TXMAPFIFOCHANNEL4)
#define G_TXMAPFIFOCHANNEL4(x) (((x) >> S_TXMAPFIFOCHANNEL4) & M_TXMAPFIFOCHANNEL4)

#define S_TXMAPFIFOCHANNEL3    12
#define M_TXMAPFIFOCHANNEL3    0xfU
#define V_TXMAPFIFOCHANNEL3(x) ((x) << S_TXMAPFIFOCHANNEL3)
#define G_TXMAPFIFOCHANNEL3(x) (((x) >> S_TXMAPFIFOCHANNEL3) & M_TXMAPFIFOCHANNEL3)

#define S_TXMAPFIFOCHANNEL2    8
#define M_TXMAPFIFOCHANNEL2    0xfU
#define V_TXMAPFIFOCHANNEL2(x) ((x) << S_TXMAPFIFOCHANNEL2)
#define G_TXMAPFIFOCHANNEL2(x) (((x) >> S_TXMAPFIFOCHANNEL2) & M_TXMAPFIFOCHANNEL2)

#define S_TXMAPFIFOCHANNEL1    4
#define M_TXMAPFIFOCHANNEL1    0xfU
#define V_TXMAPFIFOCHANNEL1(x) ((x) << S_TXMAPFIFOCHANNEL1)
#define G_TXMAPFIFOCHANNEL1(x) (((x) >> S_TXMAPFIFOCHANNEL1) & M_TXMAPFIFOCHANNEL1)

#define S_TXMAPFIFOCHANNEL0    0
#define M_TXMAPFIFOCHANNEL0    0xfU
#define V_TXMAPFIFOCHANNEL0(x) ((x) << S_TXMAPFIFOCHANNEL0)
#define G_TXMAPFIFOCHANNEL0(x) (((x) >> S_TXMAPFIFOCHANNEL0) & M_TXMAPFIFOCHANNEL0)

#define A_TP_TX_SCHED_PCMD 0x25

#define S_TXMAPPCMDCHANNEL7    28
#define M_TXMAPPCMDCHANNEL7    0xfU
#define V_TXMAPPCMDCHANNEL7(x) ((x) << S_TXMAPPCMDCHANNEL7)
#define G_TXMAPPCMDCHANNEL7(x) (((x) >> S_TXMAPPCMDCHANNEL7) & M_TXMAPPCMDCHANNEL7)

#define S_TXMAPPCMDCHANNEL6    24
#define M_TXMAPPCMDCHANNEL6    0xfU
#define V_TXMAPPCMDCHANNEL6(x) ((x) << S_TXMAPPCMDCHANNEL6)
#define G_TXMAPPCMDCHANNEL6(x) (((x) >> S_TXMAPPCMDCHANNEL6) & M_TXMAPPCMDCHANNEL6)

#define S_TXMAPPCMDCHANNEL5    20
#define M_TXMAPPCMDCHANNEL5    0xfU
#define V_TXMAPPCMDCHANNEL5(x) ((x) << S_TXMAPPCMDCHANNEL5)
#define G_TXMAPPCMDCHANNEL5(x) (((x) >> S_TXMAPPCMDCHANNEL5) & M_TXMAPPCMDCHANNEL5)

#define S_TXMAPPCMDCHANNEL4    16
#define M_TXMAPPCMDCHANNEL4    0xfU
#define V_TXMAPPCMDCHANNEL4(x) ((x) << S_TXMAPPCMDCHANNEL4)
#define G_TXMAPPCMDCHANNEL4(x) (((x) >> S_TXMAPPCMDCHANNEL4) & M_TXMAPPCMDCHANNEL4)

#define S_TXMAPPCMDCHANNEL3    12
#define M_TXMAPPCMDCHANNEL3    0xfU
#define V_TXMAPPCMDCHANNEL3(x) ((x) << S_TXMAPPCMDCHANNEL3)
#define G_TXMAPPCMDCHANNEL3(x) (((x) >> S_TXMAPPCMDCHANNEL3) & M_TXMAPPCMDCHANNEL3)

#define S_TXMAPPCMDCHANNEL2    8
#define M_TXMAPPCMDCHANNEL2    0xfU
#define V_TXMAPPCMDCHANNEL2(x) ((x) << S_TXMAPPCMDCHANNEL2)
#define G_TXMAPPCMDCHANNEL2(x) (((x) >> S_TXMAPPCMDCHANNEL2) & M_TXMAPPCMDCHANNEL2)

#define S_TXMAPPCMDCHANNEL1    4
#define M_TXMAPPCMDCHANNEL1    0xfU
#define V_TXMAPPCMDCHANNEL1(x) ((x) << S_TXMAPPCMDCHANNEL1)
#define G_TXMAPPCMDCHANNEL1(x) (((x) >> S_TXMAPPCMDCHANNEL1) & M_TXMAPPCMDCHANNEL1)

#define S_TXMAPPCMDCHANNEL0    0
#define M_TXMAPPCMDCHANNEL0    0xfU
#define V_TXMAPPCMDCHANNEL0(x) ((x) << S_TXMAPPCMDCHANNEL0)
#define G_TXMAPPCMDCHANNEL0(x) (((x) >> S_TXMAPPCMDCHANNEL0) & M_TXMAPPCMDCHANNEL0)

#define A_TP_TX_SCHED_LPBK 0x26

#define S_TXMAPLPBKCHANNEL7    28
#define M_TXMAPLPBKCHANNEL7    0xfU
#define V_TXMAPLPBKCHANNEL7(x) ((x) << S_TXMAPLPBKCHANNEL7)
#define G_TXMAPLPBKCHANNEL7(x) (((x) >> S_TXMAPLPBKCHANNEL7) & M_TXMAPLPBKCHANNEL7)

#define S_TXMAPLPBKCHANNEL6    24
#define M_TXMAPLPBKCHANNEL6    0xfU
#define V_TXMAPLPBKCHANNEL6(x) ((x) << S_TXMAPLPBKCHANNEL6)
#define G_TXMAPLPBKCHANNEL6(x) (((x) >> S_TXMAPLPBKCHANNEL6) & M_TXMAPLPBKCHANNEL6)

#define S_TXMAPLPBKCHANNEL5    20
#define M_TXMAPLPBKCHANNEL5    0xfU
#define V_TXMAPLPBKCHANNEL5(x) ((x) << S_TXMAPLPBKCHANNEL5)
#define G_TXMAPLPBKCHANNEL5(x) (((x) >> S_TXMAPLPBKCHANNEL5) & M_TXMAPLPBKCHANNEL5)

#define S_TXMAPLPBKCHANNEL4    16
#define M_TXMAPLPBKCHANNEL4    0xfU
#define V_TXMAPLPBKCHANNEL4(x) ((x) << S_TXMAPLPBKCHANNEL4)
#define G_TXMAPLPBKCHANNEL4(x) (((x) >> S_TXMAPLPBKCHANNEL4) & M_TXMAPLPBKCHANNEL4)

#define S_TXMAPLPBKCHANNEL3    12
#define M_TXMAPLPBKCHANNEL3    0xfU
#define V_TXMAPLPBKCHANNEL3(x) ((x) << S_TXMAPLPBKCHANNEL3)
#define G_TXMAPLPBKCHANNEL3(x) (((x) >> S_TXMAPLPBKCHANNEL3) & M_TXMAPLPBKCHANNEL3)

#define S_TXMAPLPBKCHANNEL2    8
#define M_TXMAPLPBKCHANNEL2    0xfU
#define V_TXMAPLPBKCHANNEL2(x) ((x) << S_TXMAPLPBKCHANNEL2)
#define G_TXMAPLPBKCHANNEL2(x) (((x) >> S_TXMAPLPBKCHANNEL2) & M_TXMAPLPBKCHANNEL2)

#define S_TXMAPLPBKCHANNEL1    4
#define M_TXMAPLPBKCHANNEL1    0xfU
#define V_TXMAPLPBKCHANNEL1(x) ((x) << S_TXMAPLPBKCHANNEL1)
#define G_TXMAPLPBKCHANNEL1(x) (((x) >> S_TXMAPLPBKCHANNEL1) & M_TXMAPLPBKCHANNEL1)

#define S_TXMAPLPBKCHANNEL0    0
#define M_TXMAPLPBKCHANNEL0    0xfU
#define V_TXMAPLPBKCHANNEL0(x) ((x) << S_TXMAPLPBKCHANNEL0)
#define G_TXMAPLPBKCHANNEL0(x) (((x) >> S_TXMAPLPBKCHANNEL0) & M_TXMAPLPBKCHANNEL0)

#define A_TP_CHANNEL_MAP 0x27

#define S_RXMAPCHANNELELN    16
#define M_RXMAPCHANNELELN    0xfU
#define V_RXMAPCHANNELELN(x) ((x) << S_RXMAPCHANNELELN)
#define G_RXMAPCHANNELELN(x) (((x) >> S_RXMAPCHANNELELN) & M_RXMAPCHANNELELN)

#define S_RXMAPE2LCHANNEL3    14
#define M_RXMAPE2LCHANNEL3    0x3U
#define V_RXMAPE2LCHANNEL3(x) ((x) << S_RXMAPE2LCHANNEL3)
#define G_RXMAPE2LCHANNEL3(x) (((x) >> S_RXMAPE2LCHANNEL3) & M_RXMAPE2LCHANNEL3)

#define S_RXMAPE2LCHANNEL2    12
#define M_RXMAPE2LCHANNEL2    0x3U
#define V_RXMAPE2LCHANNEL2(x) ((x) << S_RXMAPE2LCHANNEL2)
#define G_RXMAPE2LCHANNEL2(x) (((x) >> S_RXMAPE2LCHANNEL2) & M_RXMAPE2LCHANNEL2)

#define S_RXMAPE2LCHANNEL1    10
#define M_RXMAPE2LCHANNEL1    0x3U
#define V_RXMAPE2LCHANNEL1(x) ((x) << S_RXMAPE2LCHANNEL1)
#define G_RXMAPE2LCHANNEL1(x) (((x) >> S_RXMAPE2LCHANNEL1) & M_RXMAPE2LCHANNEL1)

#define S_RXMAPE2LCHANNEL0    8
#define M_RXMAPE2LCHANNEL0    0x3U
#define V_RXMAPE2LCHANNEL0(x) ((x) << S_RXMAPE2LCHANNEL0)
#define G_RXMAPE2LCHANNEL0(x) (((x) >> S_RXMAPE2LCHANNEL0) & M_RXMAPE2LCHANNEL0)

#define S_RXMAPC2CCHANNEL3    7
#define V_RXMAPC2CCHANNEL3(x) ((x) << S_RXMAPC2CCHANNEL3)
#define F_RXMAPC2CCHANNEL3    V_RXMAPC2CCHANNEL3(1U)

#define S_RXMAPC2CCHANNEL2    6
#define V_RXMAPC2CCHANNEL2(x) ((x) << S_RXMAPC2CCHANNEL2)
#define F_RXMAPC2CCHANNEL2    V_RXMAPC2CCHANNEL2(1U)

#define S_RXMAPC2CCHANNEL1    5
#define V_RXMAPC2CCHANNEL1(x) ((x) << S_RXMAPC2CCHANNEL1)
#define F_RXMAPC2CCHANNEL1    V_RXMAPC2CCHANNEL1(1U)

#define S_RXMAPC2CCHANNEL0    4
#define V_RXMAPC2CCHANNEL0(x) ((x) << S_RXMAPC2CCHANNEL0)
#define F_RXMAPC2CCHANNEL0    V_RXMAPC2CCHANNEL0(1U)

#define S_RXMAPE2CCHANNEL3    3
#define V_RXMAPE2CCHANNEL3(x) ((x) << S_RXMAPE2CCHANNEL3)
#define F_RXMAPE2CCHANNEL3    V_RXMAPE2CCHANNEL3(1U)

#define S_RXMAPE2CCHANNEL2    2
#define V_RXMAPE2CCHANNEL2(x) ((x) << S_RXMAPE2CCHANNEL2)
#define F_RXMAPE2CCHANNEL2    V_RXMAPE2CCHANNEL2(1U)

#define S_RXMAPE2CCHANNEL1    1
#define V_RXMAPE2CCHANNEL1(x) ((x) << S_RXMAPE2CCHANNEL1)
#define F_RXMAPE2CCHANNEL1    V_RXMAPE2CCHANNEL1(1U)

#define S_RXMAPE2CCHANNEL0    0
#define V_RXMAPE2CCHANNEL0(x) ((x) << S_RXMAPE2CCHANNEL0)
#define F_RXMAPE2CCHANNEL0    V_RXMAPE2CCHANNEL0(1U)

#define A_TP_RX_LPBK 0x28
#define A_TP_TX_LPBK 0x29
#define A_TP_TX_SCHED_PPP 0x2a

#define S_TXPPPENPORT3    24
#define M_TXPPPENPORT3    0xffU
#define V_TXPPPENPORT3(x) ((x) << S_TXPPPENPORT3)
#define G_TXPPPENPORT3(x) (((x) >> S_TXPPPENPORT3) & M_TXPPPENPORT3)

#define S_TXPPPENPORT2    16
#define M_TXPPPENPORT2    0xffU
#define V_TXPPPENPORT2(x) ((x) << S_TXPPPENPORT2)
#define G_TXPPPENPORT2(x) (((x) >> S_TXPPPENPORT2) & M_TXPPPENPORT2)

#define S_TXPPPENPORT1    8
#define M_TXPPPENPORT1    0xffU
#define V_TXPPPENPORT1(x) ((x) << S_TXPPPENPORT1)
#define G_TXPPPENPORT1(x) (((x) >> S_TXPPPENPORT1) & M_TXPPPENPORT1)

#define S_TXPPPENPORT0    0
#define M_TXPPPENPORT0    0xffU
#define V_TXPPPENPORT0(x) ((x) << S_TXPPPENPORT0)
#define G_TXPPPENPORT0(x) (((x) >> S_TXPPPENPORT0) & M_TXPPPENPORT0)

#define A_TP_RX_SCHED_FIFO 0x2b

#define S_COMMITLIMIT1H    24
#define M_COMMITLIMIT1H    0xffU
#define V_COMMITLIMIT1H(x) ((x) << S_COMMITLIMIT1H)
#define G_COMMITLIMIT1H(x) (((x) >> S_COMMITLIMIT1H) & M_COMMITLIMIT1H)

#define S_COMMITLIMIT1L    16
#define M_COMMITLIMIT1L    0xffU
#define V_COMMITLIMIT1L(x) ((x) << S_COMMITLIMIT1L)
#define G_COMMITLIMIT1L(x) (((x) >> S_COMMITLIMIT1L) & M_COMMITLIMIT1L)

#define S_COMMITLIMIT0H    8
#define M_COMMITLIMIT0H    0xffU
#define V_COMMITLIMIT0H(x) ((x) << S_COMMITLIMIT0H)
#define G_COMMITLIMIT0H(x) (((x) >> S_COMMITLIMIT0H) & M_COMMITLIMIT0H)

#define S_COMMITLIMIT0L    0
#define M_COMMITLIMIT0L    0xffU
#define V_COMMITLIMIT0L(x) ((x) << S_COMMITLIMIT0L)
#define G_COMMITLIMIT0L(x) (((x) >> S_COMMITLIMIT0L) & M_COMMITLIMIT0L)

#define A_TP_IPMI_CFG1 0x2e

#define S_VLANENABLE    31
#define V_VLANENABLE(x) ((x) << S_VLANENABLE)
#define F_VLANENABLE    V_VLANENABLE(1U)

#define S_PRIMARYPORTENABLE    30
#define V_PRIMARYPORTENABLE(x) ((x) << S_PRIMARYPORTENABLE)
#define F_PRIMARYPORTENABLE    V_PRIMARYPORTENABLE(1U)

#define S_SECUREPORTENABLE    29
#define V_SECUREPORTENABLE(x) ((x) << S_SECUREPORTENABLE)
#define F_SECUREPORTENABLE    V_SECUREPORTENABLE(1U)

#define S_ARPENABLE    28
#define V_ARPENABLE(x) ((x) << S_ARPENABLE)
#define F_ARPENABLE    V_ARPENABLE(1U)

#define S_IPMI_VLAN    0
#define M_IPMI_VLAN    0xffffU
#define V_IPMI_VLAN(x) ((x) << S_IPMI_VLAN)
#define G_IPMI_VLAN(x) (((x) >> S_IPMI_VLAN) & M_IPMI_VLAN)

#define A_TP_IPMI_CFG2 0x2f

#define S_SECUREPORT    16
#define M_SECUREPORT    0xffffU
#define V_SECUREPORT(x) ((x) << S_SECUREPORT)
#define G_SECUREPORT(x) (((x) >> S_SECUREPORT) & M_SECUREPORT)

#define S_PRIMARYPORT    0
#define M_PRIMARYPORT    0xffffU
#define V_PRIMARYPORT(x) ((x) << S_PRIMARYPORT)
#define G_PRIMARYPORT(x) (((x) >> S_PRIMARYPORT) & M_PRIMARYPORT)

#define A_TP_RSS_PF0_CONFIG 0x30

#define S_MAPENABLE    31
#define V_MAPENABLE(x) ((x) << S_MAPENABLE)
#define F_MAPENABLE    V_MAPENABLE(1U)

#define S_CHNENABLE    30
#define V_CHNENABLE(x) ((x) << S_CHNENABLE)
#define F_CHNENABLE    V_CHNENABLE(1U)

#define S_PRTENABLE    29
#define V_PRTENABLE(x) ((x) << S_PRTENABLE)
#define F_PRTENABLE    V_PRTENABLE(1U)

#define S_UDPFOURTUPEN    28
#define V_UDPFOURTUPEN(x) ((x) << S_UDPFOURTUPEN)
#define F_UDPFOURTUPEN    V_UDPFOURTUPEN(1U)

#define S_IP6FOURTUPEN    27
#define V_IP6FOURTUPEN(x) ((x) << S_IP6FOURTUPEN)
#define F_IP6FOURTUPEN    V_IP6FOURTUPEN(1U)

#define S_IP6TWOTUPEN    26
#define V_IP6TWOTUPEN(x) ((x) << S_IP6TWOTUPEN)
#define F_IP6TWOTUPEN    V_IP6TWOTUPEN(1U)

#define S_IP4FOURTUPEN    25
#define V_IP4FOURTUPEN(x) ((x) << S_IP4FOURTUPEN)
#define F_IP4FOURTUPEN    V_IP4FOURTUPEN(1U)

#define S_IP4TWOTUPEN    24
#define V_IP4TWOTUPEN(x) ((x) << S_IP4TWOTUPEN)
#define F_IP4TWOTUPEN    V_IP4TWOTUPEN(1U)

#define S_IVFWIDTH    20
#define M_IVFWIDTH    0xfU
#define V_IVFWIDTH(x) ((x) << S_IVFWIDTH)
#define G_IVFWIDTH(x) (((x) >> S_IVFWIDTH) & M_IVFWIDTH)

#define S_CH1DEFAULTQUEUE    10
#define M_CH1DEFAULTQUEUE    0x3ffU
#define V_CH1DEFAULTQUEUE(x) ((x) << S_CH1DEFAULTQUEUE)
#define G_CH1DEFAULTQUEUE(x) (((x) >> S_CH1DEFAULTQUEUE) & M_CH1DEFAULTQUEUE)

#define S_CH0DEFAULTQUEUE    0
#define M_CH0DEFAULTQUEUE    0x3ffU
#define V_CH0DEFAULTQUEUE(x) ((x) << S_CH0DEFAULTQUEUE)
#define G_CH0DEFAULTQUEUE(x) (((x) >> S_CH0DEFAULTQUEUE) & M_CH0DEFAULTQUEUE)

#define A_TP_RSS_PF1_CONFIG 0x31
#define A_TP_RSS_PF2_CONFIG 0x32
#define A_TP_RSS_PF3_CONFIG 0x33
#define A_TP_RSS_PF4_CONFIG 0x34
#define A_TP_RSS_PF5_CONFIG 0x35
#define A_TP_RSS_PF6_CONFIG 0x36
#define A_TP_RSS_PF7_CONFIG 0x37
#define A_TP_RSS_PF_MAP 0x38

#define S_LKPIDXSIZE    24
#define M_LKPIDXSIZE    0x3U
#define V_LKPIDXSIZE(x) ((x) << S_LKPIDXSIZE)
#define G_LKPIDXSIZE(x) (((x) >> S_LKPIDXSIZE) & M_LKPIDXSIZE)

#define S_PF7LKPIDX    21
#define M_PF7LKPIDX    0x7U
#define V_PF7LKPIDX(x) ((x) << S_PF7LKPIDX)
#define G_PF7LKPIDX(x) (((x) >> S_PF7LKPIDX) & M_PF7LKPIDX)

#define S_PF6LKPIDX    18
#define M_PF6LKPIDX    0x7U
#define V_PF6LKPIDX(x) ((x) << S_PF6LKPIDX)
#define G_PF6LKPIDX(x) (((x) >> S_PF6LKPIDX) & M_PF6LKPIDX)

#define S_PF5LKPIDX    15
#define M_PF5LKPIDX    0x7U
#define V_PF5LKPIDX(x) ((x) << S_PF5LKPIDX)
#define G_PF5LKPIDX(x) (((x) >> S_PF5LKPIDX) & M_PF5LKPIDX)

#define S_PF4LKPIDX    12
#define M_PF4LKPIDX    0x7U
#define V_PF4LKPIDX(x) ((x) << S_PF4LKPIDX)
#define G_PF4LKPIDX(x) (((x) >> S_PF4LKPIDX) & M_PF4LKPIDX)

#define S_PF3LKPIDX    9
#define M_PF3LKPIDX    0x7U
#define V_PF3LKPIDX(x) ((x) << S_PF3LKPIDX)
#define G_PF3LKPIDX(x) (((x) >> S_PF3LKPIDX) & M_PF3LKPIDX)

#define S_PF2LKPIDX    6
#define M_PF2LKPIDX    0x7U
#define V_PF2LKPIDX(x) ((x) << S_PF2LKPIDX)
#define G_PF2LKPIDX(x) (((x) >> S_PF2LKPIDX) & M_PF2LKPIDX)

#define S_PF1LKPIDX    3
#define M_PF1LKPIDX    0x7U
#define V_PF1LKPIDX(x) ((x) << S_PF1LKPIDX)
#define G_PF1LKPIDX(x) (((x) >> S_PF1LKPIDX) & M_PF1LKPIDX)

#define S_PF0LKPIDX    0
#define M_PF0LKPIDX    0x7U
#define V_PF0LKPIDX(x) ((x) << S_PF0LKPIDX)
#define G_PF0LKPIDX(x) (((x) >> S_PF0LKPIDX) & M_PF0LKPIDX)

#define A_TP_RSS_PF_MSK 0x39

#define S_PF7MSKSIZE    28
#define M_PF7MSKSIZE    0xfU
#define V_PF7MSKSIZE(x) ((x) << S_PF7MSKSIZE)
#define G_PF7MSKSIZE(x) (((x) >> S_PF7MSKSIZE) & M_PF7MSKSIZE)

#define S_PF6MSKSIZE    24
#define M_PF6MSKSIZE    0xfU
#define V_PF6MSKSIZE(x) ((x) << S_PF6MSKSIZE)
#define G_PF6MSKSIZE(x) (((x) >> S_PF6MSKSIZE) & M_PF6MSKSIZE)

#define S_PF5MSKSIZE    20
#define M_PF5MSKSIZE    0xfU
#define V_PF5MSKSIZE(x) ((x) << S_PF5MSKSIZE)
#define G_PF5MSKSIZE(x) (((x) >> S_PF5MSKSIZE) & M_PF5MSKSIZE)

#define S_PF4MSKSIZE    16
#define M_PF4MSKSIZE    0xfU
#define V_PF4MSKSIZE(x) ((x) << S_PF4MSKSIZE)
#define G_PF4MSKSIZE(x) (((x) >> S_PF4MSKSIZE) & M_PF4MSKSIZE)

#define S_PF3MSKSIZE    12
#define M_PF3MSKSIZE    0xfU
#define V_PF3MSKSIZE(x) ((x) << S_PF3MSKSIZE)
#define G_PF3MSKSIZE(x) (((x) >> S_PF3MSKSIZE) & M_PF3MSKSIZE)

#define S_PF2MSKSIZE    8
#define M_PF2MSKSIZE    0xfU
#define V_PF2MSKSIZE(x) ((x) << S_PF2MSKSIZE)
#define G_PF2MSKSIZE(x) (((x) >> S_PF2MSKSIZE) & M_PF2MSKSIZE)

#define S_PF1MSKSIZE    4
#define M_PF1MSKSIZE    0xfU
#define V_PF1MSKSIZE(x) ((x) << S_PF1MSKSIZE)
#define G_PF1MSKSIZE(x) (((x) >> S_PF1MSKSIZE) & M_PF1MSKSIZE)

#define S_PF0MSKSIZE    0
#define M_PF0MSKSIZE    0xfU
#define V_PF0MSKSIZE(x) ((x) << S_PF0MSKSIZE)
#define G_PF0MSKSIZE(x) (((x) >> S_PF0MSKSIZE) & M_PF0MSKSIZE)

#define A_TP_RSS_VFL_CONFIG 0x3a
#define A_TP_RSS_VFH_CONFIG 0x3b

#define S_ENABLEUDPHASH    31
#define V_ENABLEUDPHASH(x) ((x) << S_ENABLEUDPHASH)
#define F_ENABLEUDPHASH    V_ENABLEUDPHASH(1U)

#define S_VFUPEN    30
#define V_VFUPEN(x) ((x) << S_VFUPEN)
#define F_VFUPEN    V_VFUPEN(1U)

#define S_VFVLNEX    28
#define V_VFVLNEX(x) ((x) << S_VFVLNEX)
#define F_VFVLNEX    V_VFVLNEX(1U)

#define S_VFPRTEN    27
#define V_VFPRTEN(x) ((x) << S_VFPRTEN)
#define F_VFPRTEN    V_VFPRTEN(1U)

#define S_VFCHNEN    26
#define V_VFCHNEN(x) ((x) << S_VFCHNEN)
#define F_VFCHNEN    V_VFCHNEN(1U)

#define S_DEFAULTQUEUE    16
#define M_DEFAULTQUEUE    0x3ffU
#define V_DEFAULTQUEUE(x) ((x) << S_DEFAULTQUEUE)
#define G_DEFAULTQUEUE(x) (((x) >> S_DEFAULTQUEUE) & M_DEFAULTQUEUE)

#define S_VFLKPIDX    8
#define M_VFLKPIDX    0xffU
#define V_VFLKPIDX(x) ((x) << S_VFLKPIDX)
#define G_VFLKPIDX(x) (((x) >> S_VFLKPIDX) & M_VFLKPIDX)

#define S_VFIP6FOURTUPEN    7
#define V_VFIP6FOURTUPEN(x) ((x) << S_VFIP6FOURTUPEN)
#define F_VFIP6FOURTUPEN    V_VFIP6FOURTUPEN(1U)

#define S_VFIP6TWOTUPEN    6
#define V_VFIP6TWOTUPEN(x) ((x) << S_VFIP6TWOTUPEN)
#define F_VFIP6TWOTUPEN    V_VFIP6TWOTUPEN(1U)

#define S_VFIP4FOURTUPEN    5
#define V_VFIP4FOURTUPEN(x) ((x) << S_VFIP4FOURTUPEN)
#define F_VFIP4FOURTUPEN    V_VFIP4FOURTUPEN(1U)

#define S_VFIP4TWOTUPEN    4
#define V_VFIP4TWOTUPEN(x) ((x) << S_VFIP4TWOTUPEN)
#define F_VFIP4TWOTUPEN    V_VFIP4TWOTUPEN(1U)

#define S_KEYINDEX    0
#define M_KEYINDEX    0xfU
#define V_KEYINDEX(x) ((x) << S_KEYINDEX)
#define G_KEYINDEX(x) (((x) >> S_KEYINDEX) & M_KEYINDEX)

#define A_TP_RSS_SECRET_KEY0 0x40
#define A_TP_RSS_SECRET_KEY1 0x41
#define A_TP_RSS_SECRET_KEY2 0x42
#define A_TP_RSS_SECRET_KEY3 0x43
#define A_TP_RSS_SECRET_KEY4 0x44
#define A_TP_RSS_SECRET_KEY5 0x45
#define A_TP_RSS_SECRET_KEY6 0x46
#define A_TP_RSS_SECRET_KEY7 0x47
#define A_TP_RSS_SECRET_KEY8 0x48
#define A_TP_RSS_SECRET_KEY9 0x49
#define A_TP_ETHER_TYPE_VL 0x50

#define S_CQFCTYPE    16
#define M_CQFCTYPE    0xffffU
#define V_CQFCTYPE(x) ((x) << S_CQFCTYPE)
#define G_CQFCTYPE(x) (((x) >> S_CQFCTYPE) & M_CQFCTYPE)

#define S_VLANTYPE    0
#define M_VLANTYPE    0xffffU
#define V_VLANTYPE(x) ((x) << S_VLANTYPE)
#define G_VLANTYPE(x) (((x) >> S_VLANTYPE) & M_VLANTYPE)

#define A_TP_ETHER_TYPE_IP 0x51

#define S_IPV6TYPE    16
#define M_IPV6TYPE    0xffffU
#define V_IPV6TYPE(x) ((x) << S_IPV6TYPE)
#define G_IPV6TYPE(x) (((x) >> S_IPV6TYPE) & M_IPV6TYPE)

#define S_IPV4TYPE    0
#define M_IPV4TYPE    0xffffU
#define V_IPV4TYPE(x) ((x) << S_IPV4TYPE)
#define G_IPV4TYPE(x) (((x) >> S_IPV4TYPE) & M_IPV4TYPE)

#define A_TP_ETHER_TYPE_FW 0x52

#define S_ETHTYPE1    16
#define M_ETHTYPE1    0xffffU
#define V_ETHTYPE1(x) ((x) << S_ETHTYPE1)
#define G_ETHTYPE1(x) (((x) >> S_ETHTYPE1) & M_ETHTYPE1)

#define S_ETHTYPE0    0
#define M_ETHTYPE0    0xffffU
#define V_ETHTYPE0(x) ((x) << S_ETHTYPE0)
#define G_ETHTYPE0(x) (((x) >> S_ETHTYPE0) & M_ETHTYPE0)

#define A_TP_CORE_POWER 0x54

#define S_SLEEPRDYVNT    12
#define V_SLEEPRDYVNT(x) ((x) << S_SLEEPRDYVNT)
#define F_SLEEPRDYVNT    V_SLEEPRDYVNT(1U)

#define S_SLEEPRDYTBL    11
#define V_SLEEPRDYTBL(x) ((x) << S_SLEEPRDYTBL)
#define F_SLEEPRDYTBL    V_SLEEPRDYTBL(1U)

#define S_SLEEPRDYMIB    10
#define V_SLEEPRDYMIB(x) ((x) << S_SLEEPRDYMIB)
#define F_SLEEPRDYMIB    V_SLEEPRDYMIB(1U)

#define S_SLEEPRDYARP    9
#define V_SLEEPRDYARP(x) ((x) << S_SLEEPRDYARP)
#define F_SLEEPRDYARP    V_SLEEPRDYARP(1U)

#define S_SLEEPRDYRSS    8
#define V_SLEEPRDYRSS(x) ((x) << S_SLEEPRDYRSS)
#define F_SLEEPRDYRSS    V_SLEEPRDYRSS(1U)

#define S_SLEEPREQVNT    4
#define V_SLEEPREQVNT(x) ((x) << S_SLEEPREQVNT)
#define F_SLEEPREQVNT    V_SLEEPREQVNT(1U)

#define S_SLEEPREQTBL    3
#define V_SLEEPREQTBL(x) ((x) << S_SLEEPREQTBL)
#define F_SLEEPREQTBL    V_SLEEPREQTBL(1U)

#define S_SLEEPREQMIB    2
#define V_SLEEPREQMIB(x) ((x) << S_SLEEPREQMIB)
#define F_SLEEPREQMIB    V_SLEEPREQMIB(1U)

#define S_SLEEPREQARP    1
#define V_SLEEPREQARP(x) ((x) << S_SLEEPREQARP)
#define F_SLEEPREQARP    V_SLEEPREQARP(1U)

#define S_SLEEPREQRSS    0
#define V_SLEEPREQRSS(x) ((x) << S_SLEEPREQRSS)
#define F_SLEEPREQRSS    V_SLEEPREQRSS(1U)

#define A_TP_CORE_RDMA 0x55

#define S_IMMEDIATEOP    20
#define M_IMMEDIATEOP    0xfU
#define V_IMMEDIATEOP(x) ((x) << S_IMMEDIATEOP)
#define G_IMMEDIATEOP(x) (((x) >> S_IMMEDIATEOP) & M_IMMEDIATEOP)

#define S_IMMEDIATESE    16
#define M_IMMEDIATESE    0xfU
#define V_IMMEDIATESE(x) ((x) << S_IMMEDIATESE)
#define G_IMMEDIATESE(x) (((x) >> S_IMMEDIATESE) & M_IMMEDIATESE)

#define S_ATOMICREQOP    12
#define M_ATOMICREQOP    0xfU
#define V_ATOMICREQOP(x) ((x) << S_ATOMICREQOP)
#define G_ATOMICREQOP(x) (((x) >> S_ATOMICREQOP) & M_ATOMICREQOP)

#define S_ATOMICRSPOP    8
#define M_ATOMICRSPOP    0xfU
#define V_ATOMICRSPOP(x) ((x) << S_ATOMICRSPOP)
#define G_ATOMICRSPOP(x) (((x) >> S_ATOMICRSPOP) & M_ATOMICRSPOP)

#define S_IMMEDIASEEN    1
#define V_IMMEDIASEEN(x) ((x) << S_IMMEDIASEEN)
#define F_IMMEDIASEEN    V_IMMEDIASEEN(1U)

#define S_IMMEDIATEEN    0
#define V_IMMEDIATEEN(x) ((x) << S_IMMEDIATEEN)
#define F_IMMEDIATEEN    V_IMMEDIATEEN(1U)

#define A_TP_DBG_CLEAR 0x60
#define A_TP_DBG_CORE_HDR0 0x61

#define S_E_TCP_OP_SRDY    16
#define V_E_TCP_OP_SRDY(x) ((x) << S_E_TCP_OP_SRDY)
#define F_E_TCP_OP_SRDY    V_E_TCP_OP_SRDY(1U)

#define S_E_PLD_TXZEROP_SRDY    15
#define V_E_PLD_TXZEROP_SRDY(x) ((x) << S_E_PLD_TXZEROP_SRDY)
#define F_E_PLD_TXZEROP_SRDY    V_E_PLD_TXZEROP_SRDY(1U)

#define S_E_PLD_RX_SRDY    14
#define V_E_PLD_RX_SRDY(x) ((x) << S_E_PLD_RX_SRDY)
#define F_E_PLD_RX_SRDY    V_E_PLD_RX_SRDY(1U)

#define S_E_RX_ERROR_SRDY    13
#define V_E_RX_ERROR_SRDY(x) ((x) << S_E_RX_ERROR_SRDY)
#define F_E_RX_ERROR_SRDY    V_E_RX_ERROR_SRDY(1U)

#define S_E_RX_ISS_SRDY    12
#define V_E_RX_ISS_SRDY(x) ((x) << S_E_RX_ISS_SRDY)
#define F_E_RX_ISS_SRDY    V_E_RX_ISS_SRDY(1U)

#define S_C_TCP_OP_SRDY    11
#define V_C_TCP_OP_SRDY(x) ((x) << S_C_TCP_OP_SRDY)
#define F_C_TCP_OP_SRDY    V_C_TCP_OP_SRDY(1U)

#define S_C_PLD_TXZEROP_SRDY    10
#define V_C_PLD_TXZEROP_SRDY(x) ((x) << S_C_PLD_TXZEROP_SRDY)
#define F_C_PLD_TXZEROP_SRDY    V_C_PLD_TXZEROP_SRDY(1U)

#define S_C_PLD_RX_SRDY    9
#define V_C_PLD_RX_SRDY(x) ((x) << S_C_PLD_RX_SRDY)
#define F_C_PLD_RX_SRDY    V_C_PLD_RX_SRDY(1U)

#define S_C_RX_ERROR_SRDY    8
#define V_C_RX_ERROR_SRDY(x) ((x) << S_C_RX_ERROR_SRDY)
#define F_C_RX_ERROR_SRDY    V_C_RX_ERROR_SRDY(1U)

#define S_C_RX_ISS_SRDY    7
#define V_C_RX_ISS_SRDY(x) ((x) << S_C_RX_ISS_SRDY)
#define F_C_RX_ISS_SRDY    V_C_RX_ISS_SRDY(1U)

#define S_E_CPL5_TXVALID    6
#define V_E_CPL5_TXVALID(x) ((x) << S_E_CPL5_TXVALID)
#define F_E_CPL5_TXVALID    V_E_CPL5_TXVALID(1U)

#define S_E_ETH_TXVALID    5
#define V_E_ETH_TXVALID(x) ((x) << S_E_ETH_TXVALID)
#define F_E_ETH_TXVALID    V_E_ETH_TXVALID(1U)

#define S_E_IP_TXVALID    4
#define V_E_IP_TXVALID(x) ((x) << S_E_IP_TXVALID)
#define F_E_IP_TXVALID    V_E_IP_TXVALID(1U)

#define S_E_TCP_TXVALID    3
#define V_E_TCP_TXVALID(x) ((x) << S_E_TCP_TXVALID)
#define F_E_TCP_TXVALID    V_E_TCP_TXVALID(1U)

#define S_C_CPL5_RXVALID    2
#define V_C_CPL5_RXVALID(x) ((x) << S_C_CPL5_RXVALID)
#define F_C_CPL5_RXVALID    V_C_CPL5_RXVALID(1U)

#define S_C_CPL5_TXVALID    1
#define V_C_CPL5_TXVALID(x) ((x) << S_C_CPL5_TXVALID)
#define F_C_CPL5_TXVALID    V_C_CPL5_TXVALID(1U)

#define S_E_TCP_OPT_RXVALID    0
#define V_E_TCP_OPT_RXVALID(x) ((x) << S_E_TCP_OPT_RXVALID)
#define F_E_TCP_OPT_RXVALID    V_E_TCP_OPT_RXVALID(1U)

#define A_TP_DBG_CORE_HDR1 0x62

#define S_E_CPL5_TXFULL    6
#define V_E_CPL5_TXFULL(x) ((x) << S_E_CPL5_TXFULL)
#define F_E_CPL5_TXFULL    V_E_CPL5_TXFULL(1U)

#define S_E_ETH_TXFULL    5
#define V_E_ETH_TXFULL(x) ((x) << S_E_ETH_TXFULL)
#define F_E_ETH_TXFULL    V_E_ETH_TXFULL(1U)

#define S_E_IP_TXFULL    4
#define V_E_IP_TXFULL(x) ((x) << S_E_IP_TXFULL)
#define F_E_IP_TXFULL    V_E_IP_TXFULL(1U)

#define S_E_TCP_TXFULL    3
#define V_E_TCP_TXFULL(x) ((x) << S_E_TCP_TXFULL)
#define F_E_TCP_TXFULL    V_E_TCP_TXFULL(1U)

#define S_C_CPL5_RXFULL    2
#define V_C_CPL5_RXFULL(x) ((x) << S_C_CPL5_RXFULL)
#define F_C_CPL5_RXFULL    V_C_CPL5_RXFULL(1U)

#define S_C_CPL5_TXFULL    1
#define V_C_CPL5_TXFULL(x) ((x) << S_C_CPL5_TXFULL)
#define F_C_CPL5_TXFULL    V_C_CPL5_TXFULL(1U)

#define S_E_TCP_OPT_RXFULL    0
#define V_E_TCP_OPT_RXFULL(x) ((x) << S_E_TCP_OPT_RXFULL)
#define F_E_TCP_OPT_RXFULL    V_E_TCP_OPT_RXFULL(1U)

#define A_TP_DBG_CORE_FATAL 0x63

#define S_EMSGFATAL    31
#define V_EMSGFATAL(x) ((x) << S_EMSGFATAL)
#define F_EMSGFATAL    V_EMSGFATAL(1U)

#define S_CMSGFATAL    30
#define V_CMSGFATAL(x) ((x) << S_CMSGFATAL)
#define F_CMSGFATAL    V_CMSGFATAL(1U)

#define S_PAWSFATAL    29
#define V_PAWSFATAL(x) ((x) << S_PAWSFATAL)
#define F_PAWSFATAL    V_PAWSFATAL(1U)

#define S_SRAMFATAL    28
#define V_SRAMFATAL(x) ((x) << S_SRAMFATAL)
#define F_SRAMFATAL    V_SRAMFATAL(1U)

#define S_CPCMDCONG    24
#define M_CPCMDCONG    0xfU
#define V_CPCMDCONG(x) ((x) << S_CPCMDCONG)
#define G_CPCMDCONG(x) (((x) >> S_CPCMDCONG) & M_CPCMDCONG)

#define S_EPCMDCONG    22
#define M_EPCMDCONG    0x3U
#define V_EPCMDCONG(x) ((x) << S_EPCMDCONG)
#define G_EPCMDCONG(x) (((x) >> S_EPCMDCONG) & M_EPCMDCONG)

#define S_CPCMDLENFATAL    21
#define V_CPCMDLENFATAL(x) ((x) << S_CPCMDLENFATAL)
#define F_CPCMDLENFATAL    V_CPCMDLENFATAL(1U)

#define S_EPCMDLENFATAL    20
#define V_EPCMDLENFATAL(x) ((x) << S_EPCMDLENFATAL)
#define F_EPCMDLENFATAL    V_EPCMDLENFATAL(1U)

#define S_CPCMDVALID    16
#define M_CPCMDVALID    0xfU
#define V_CPCMDVALID(x) ((x) << S_CPCMDVALID)
#define G_CPCMDVALID(x) (((x) >> S_CPCMDVALID) & M_CPCMDVALID)

#define S_CPCMDAFULL    12
#define M_CPCMDAFULL    0xfU
#define V_CPCMDAFULL(x) ((x) << S_CPCMDAFULL)
#define G_CPCMDAFULL(x) (((x) >> S_CPCMDAFULL) & M_CPCMDAFULL)

#define S_EPCMDVALID    10
#define M_EPCMDVALID    0x3U
#define V_EPCMDVALID(x) ((x) << S_EPCMDVALID)
#define G_EPCMDVALID(x) (((x) >> S_EPCMDVALID) & M_EPCMDVALID)

#define S_EPCMDAFULL    8
#define M_EPCMDAFULL    0x3U
#define V_EPCMDAFULL(x) ((x) << S_EPCMDAFULL)
#define G_EPCMDAFULL(x) (((x) >> S_EPCMDAFULL) & M_EPCMDAFULL)

#define S_CPCMDEOIFATAL    7
#define V_CPCMDEOIFATAL(x) ((x) << S_CPCMDEOIFATAL)
#define F_CPCMDEOIFATAL    V_CPCMDEOIFATAL(1U)

#define S_CMDBRQFATAL    4
#define V_CMDBRQFATAL(x) ((x) << S_CMDBRQFATAL)
#define F_CMDBRQFATAL    V_CMDBRQFATAL(1U)

#define S_CNONZEROPPOPCNT    2
#define M_CNONZEROPPOPCNT    0x3U
#define V_CNONZEROPPOPCNT(x) ((x) << S_CNONZEROPPOPCNT)
#define G_CNONZEROPPOPCNT(x) (((x) >> S_CNONZEROPPOPCNT) & M_CNONZEROPPOPCNT)

#define S_CPCMDEOICNT    0
#define M_CPCMDEOICNT    0x3U
#define V_CPCMDEOICNT(x) ((x) << S_CPCMDEOICNT)
#define G_CPCMDEOICNT(x) (((x) >> S_CPCMDEOICNT) & M_CPCMDEOICNT)

#define S_CPCMDTTLFATAL    6
#define V_CPCMDTTLFATAL(x) ((x) << S_CPCMDTTLFATAL)
#define F_CPCMDTTLFATAL    V_CPCMDTTLFATAL(1U)

#define S_CDATACHNFATAL    5
#define V_CDATACHNFATAL(x) ((x) << S_CDATACHNFATAL)
#define F_CDATACHNFATAL    V_CDATACHNFATAL(1U)

#define A_TP_DBG_CORE_OUT 0x64

#define S_CCPLENC    26
#define V_CCPLENC(x) ((x) << S_CCPLENC)
#define F_CCPLENC    V_CCPLENC(1U)

#define S_CWRCPLPKT    25
#define V_CWRCPLPKT(x) ((x) << S_CWRCPLPKT)
#define F_CWRCPLPKT    V_CWRCPLPKT(1U)

#define S_CWRETHPKT    24
#define V_CWRETHPKT(x) ((x) << S_CWRETHPKT)
#define F_CWRETHPKT    V_CWRETHPKT(1U)

#define S_CWRIPPKT    23
#define V_CWRIPPKT(x) ((x) << S_CWRIPPKT)
#define F_CWRIPPKT    V_CWRIPPKT(1U)

#define S_CWRTCPPKT    22
#define V_CWRTCPPKT(x) ((x) << S_CWRTCPPKT)
#define F_CWRTCPPKT    V_CWRTCPPKT(1U)

#define S_CWRZEROP    21
#define V_CWRZEROP(x) ((x) << S_CWRZEROP)
#define F_CWRZEROP    V_CWRZEROP(1U)

#define S_CCPLTXFULL    20
#define V_CCPLTXFULL(x) ((x) << S_CCPLTXFULL)
#define F_CCPLTXFULL    V_CCPLTXFULL(1U)

#define S_CETHTXFULL    19
#define V_CETHTXFULL(x) ((x) << S_CETHTXFULL)
#define F_CETHTXFULL    V_CETHTXFULL(1U)

#define S_CIPTXFULL    18
#define V_CIPTXFULL(x) ((x) << S_CIPTXFULL)
#define F_CIPTXFULL    V_CIPTXFULL(1U)

#define S_CTCPTXFULL    17
#define V_CTCPTXFULL(x) ((x) << S_CTCPTXFULL)
#define F_CTCPTXFULL    V_CTCPTXFULL(1U)

#define S_CPLDTXZEROPDRDY    16
#define V_CPLDTXZEROPDRDY(x) ((x) << S_CPLDTXZEROPDRDY)
#define F_CPLDTXZEROPDRDY    V_CPLDTXZEROPDRDY(1U)

#define S_ECPLENC    10
#define V_ECPLENC(x) ((x) << S_ECPLENC)
#define F_ECPLENC    V_ECPLENC(1U)

#define S_EWRCPLPKT    9
#define V_EWRCPLPKT(x) ((x) << S_EWRCPLPKT)
#define F_EWRCPLPKT    V_EWRCPLPKT(1U)

#define S_EWRETHPKT    8
#define V_EWRETHPKT(x) ((x) << S_EWRETHPKT)
#define F_EWRETHPKT    V_EWRETHPKT(1U)

#define S_EWRIPPKT    7
#define V_EWRIPPKT(x) ((x) << S_EWRIPPKT)
#define F_EWRIPPKT    V_EWRIPPKT(1U)

#define S_EWRTCPPKT    6
#define V_EWRTCPPKT(x) ((x) << S_EWRTCPPKT)
#define F_EWRTCPPKT    V_EWRTCPPKT(1U)

#define S_EWRZEROP    5
#define V_EWRZEROP(x) ((x) << S_EWRZEROP)
#define F_EWRZEROP    V_EWRZEROP(1U)

#define S_ECPLTXFULL    4
#define V_ECPLTXFULL(x) ((x) << S_ECPLTXFULL)
#define F_ECPLTXFULL    V_ECPLTXFULL(1U)

#define S_EETHTXFULL    3
#define V_EETHTXFULL(x) ((x) << S_EETHTXFULL)
#define F_EETHTXFULL    V_EETHTXFULL(1U)

#define S_EIPTXFULL    2
#define V_EIPTXFULL(x) ((x) << S_EIPTXFULL)
#define F_EIPTXFULL    V_EIPTXFULL(1U)

#define S_ETCPTXFULL    1
#define V_ETCPTXFULL(x) ((x) << S_ETCPTXFULL)
#define F_ETCPTXFULL    V_ETCPTXFULL(1U)

#define S_EPLDTXZEROPDRDY    0
#define V_EPLDTXZEROPDRDY(x) ((x) << S_EPLDTXZEROPDRDY)
#define F_EPLDTXZEROPDRDY    V_EPLDTXZEROPDRDY(1U)

#define S_CRXBUSYOUT    31
#define V_CRXBUSYOUT(x) ((x) << S_CRXBUSYOUT)
#define F_CRXBUSYOUT    V_CRXBUSYOUT(1U)

#define S_CTXBUSYOUT    30
#define V_CTXBUSYOUT(x) ((x) << S_CTXBUSYOUT)
#define F_CTXBUSYOUT    V_CTXBUSYOUT(1U)

#define S_CRDCPLPKT    29
#define V_CRDCPLPKT(x) ((x) << S_CRDCPLPKT)
#define F_CRDCPLPKT    V_CRDCPLPKT(1U)

#define S_CRDTCPPKT    28
#define V_CRDTCPPKT(x) ((x) << S_CRDTCPPKT)
#define F_CRDTCPPKT    V_CRDTCPPKT(1U)

#define S_CNEWMSG    27
#define V_CNEWMSG(x) ((x) << S_CNEWMSG)
#define F_CNEWMSG    V_CNEWMSG(1U)

#define S_ERXBUSYOUT    15
#define V_ERXBUSYOUT(x) ((x) << S_ERXBUSYOUT)
#define F_ERXBUSYOUT    V_ERXBUSYOUT(1U)

#define S_ETXBUSYOUT    14
#define V_ETXBUSYOUT(x) ((x) << S_ETXBUSYOUT)
#define F_ETXBUSYOUT    V_ETXBUSYOUT(1U)

#define S_ERDCPLPKT    13
#define V_ERDCPLPKT(x) ((x) << S_ERDCPLPKT)
#define F_ERDCPLPKT    V_ERDCPLPKT(1U)

#define S_ERDTCPPKT    12
#define V_ERDTCPPKT(x) ((x) << S_ERDTCPPKT)
#define F_ERDTCPPKT    V_ERDTCPPKT(1U)

#define S_ENEWMSG    11
#define V_ENEWMSG(x) ((x) << S_ENEWMSG)
#define F_ENEWMSG    V_ENEWMSG(1U)

#define A_TP_DBG_CORE_TID 0x65

#define S_LINENUMBER    24
#define M_LINENUMBER    0x7fU
#define V_LINENUMBER(x) ((x) << S_LINENUMBER)
#define G_LINENUMBER(x) (((x) >> S_LINENUMBER) & M_LINENUMBER)

#define S_SPURIOUSMSG    23
#define V_SPURIOUSMSG(x) ((x) << S_SPURIOUSMSG)
#define F_SPURIOUSMSG    V_SPURIOUSMSG(1U)

#define S_SYNLEARNED    20
#define V_SYNLEARNED(x) ((x) << S_SYNLEARNED)
#define F_SYNLEARNED    V_SYNLEARNED(1U)

#define S_TIDVALUE    0
#define M_TIDVALUE    0xfffffU
#define V_TIDVALUE(x) ((x) << S_TIDVALUE)
#define G_TIDVALUE(x) (((x) >> S_TIDVALUE) & M_TIDVALUE)

#define S_SRC    21
#define M_SRC    0x3U
#define V_SRC(x) ((x) << S_SRC)
#define G_SRC(x) (((x) >> S_SRC) & M_SRC)

#define A_TP_DBG_ENG_RES0 0x66

#define S_RESOURCESREADY    31
#define V_RESOURCESREADY(x) ((x) << S_RESOURCESREADY)
#define F_RESOURCESREADY    V_RESOURCESREADY(1U)

#define S_RCFOPCODEOUTSRDY    30
#define V_RCFOPCODEOUTSRDY(x) ((x) << S_RCFOPCODEOUTSRDY)
#define F_RCFOPCODEOUTSRDY    V_RCFOPCODEOUTSRDY(1U)

#define S_RCFDATAOUTSRDY    29
#define V_RCFDATAOUTSRDY(x) ((x) << S_RCFDATAOUTSRDY)
#define F_RCFDATAOUTSRDY    V_RCFDATAOUTSRDY(1U)

#define S_FLUSHINPUTMSG    28
#define V_FLUSHINPUTMSG(x) ((x) << S_FLUSHINPUTMSG)
#define F_FLUSHINPUTMSG    V_FLUSHINPUTMSG(1U)

#define S_RCFOPSRCOUT    26
#define M_RCFOPSRCOUT    0x3U
#define V_RCFOPSRCOUT(x) ((x) << S_RCFOPSRCOUT)
#define G_RCFOPSRCOUT(x) (((x) >> S_RCFOPSRCOUT) & M_RCFOPSRCOUT)

#define S_C_MSG    25
#define V_C_MSG(x) ((x) << S_C_MSG)
#define F_C_MSG    V_C_MSG(1U)

#define S_E_MSG    24
#define V_E_MSG(x) ((x) << S_E_MSG)
#define F_E_MSG    V_E_MSG(1U)

#define S_RCFOPCODEOUT    20
#define M_RCFOPCODEOUT    0xfU
#define V_RCFOPCODEOUT(x) ((x) << S_RCFOPCODEOUT)
#define G_RCFOPCODEOUT(x) (((x) >> S_RCFOPCODEOUT) & M_RCFOPCODEOUT)

#define S_EFFRCFOPCODEOUT    16
#define M_EFFRCFOPCODEOUT    0xfU
#define V_EFFRCFOPCODEOUT(x) ((x) << S_EFFRCFOPCODEOUT)
#define G_EFFRCFOPCODEOUT(x) (((x) >> S_EFFRCFOPCODEOUT) & M_EFFRCFOPCODEOUT)

#define S_SEENRESOURCESREADY    15
#define V_SEENRESOURCESREADY(x) ((x) << S_SEENRESOURCESREADY)
#define F_SEENRESOURCESREADY    V_SEENRESOURCESREADY(1U)

#define S_RESOURCESREADYCOPY    14
#define V_RESOURCESREADYCOPY(x) ((x) << S_RESOURCESREADYCOPY)
#define F_RESOURCESREADYCOPY    V_RESOURCESREADYCOPY(1U)

#define S_OPCODEWAITSFORDATA    13
#define V_OPCODEWAITSFORDATA(x) ((x) << S_OPCODEWAITSFORDATA)
#define F_OPCODEWAITSFORDATA    V_OPCODEWAITSFORDATA(1U)

#define S_CPLDRXSRDY    12
#define V_CPLDRXSRDY(x) ((x) << S_CPLDRXSRDY)
#define F_CPLDRXSRDY    V_CPLDRXSRDY(1U)

#define S_CPLDRXZEROPSRDY    11
#define V_CPLDRXZEROPSRDY(x) ((x) << S_CPLDRXZEROPSRDY)
#define F_CPLDRXZEROPSRDY    V_CPLDRXZEROPSRDY(1U)

#define S_EPLDRXZEROPSRDY    10
#define V_EPLDRXZEROPSRDY(x) ((x) << S_EPLDRXZEROPSRDY)
#define F_EPLDRXZEROPSRDY    V_EPLDRXZEROPSRDY(1U)

#define S_ERXERRORSRDY    9
#define V_ERXERRORSRDY(x) ((x) << S_ERXERRORSRDY)
#define F_ERXERRORSRDY    V_ERXERRORSRDY(1U)

#define S_EPLDRXSRDY    8
#define V_EPLDRXSRDY(x) ((x) << S_EPLDRXSRDY)
#define F_EPLDRXSRDY    V_EPLDRXSRDY(1U)

#define S_CRXBUSY    7
#define V_CRXBUSY(x) ((x) << S_CRXBUSY)
#define F_CRXBUSY    V_CRXBUSY(1U)

#define S_ERXBUSY    6
#define V_ERXBUSY(x) ((x) << S_ERXBUSY)
#define F_ERXBUSY    V_ERXBUSY(1U)

#define S_TIMERINSERTBUSY    5
#define V_TIMERINSERTBUSY(x) ((x) << S_TIMERINSERTBUSY)
#define F_TIMERINSERTBUSY    V_TIMERINSERTBUSY(1U)

#define S_WCFBUSY    4
#define V_WCFBUSY(x) ((x) << S_WCFBUSY)
#define F_WCFBUSY    V_WCFBUSY(1U)

#define S_CTXBUSY    3
#define V_CTXBUSY(x) ((x) << S_CTXBUSY)
#define F_CTXBUSY    V_CTXBUSY(1U)

#define S_CPCMDBUSY    2
#define V_CPCMDBUSY(x) ((x) << S_CPCMDBUSY)
#define F_CPCMDBUSY    V_CPCMDBUSY(1U)

#define S_EPCMDBUSY    1
#define V_EPCMDBUSY(x) ((x) << S_EPCMDBUSY)
#define F_EPCMDBUSY    V_EPCMDBUSY(1U)

#define S_ETXBUSY    0
#define V_ETXBUSY(x) ((x) << S_ETXBUSY)
#define F_ETXBUSY    V_ETXBUSY(1U)

#define S_EFFOPCODEOUT    16
#define M_EFFOPCODEOUT    0xfU
#define V_EFFOPCODEOUT(x) ((x) << S_EFFOPCODEOUT)
#define G_EFFOPCODEOUT(x) (((x) >> S_EFFOPCODEOUT) & M_EFFOPCODEOUT)

#define S_DELDRDY    14
#define V_DELDRDY(x) ((x) << S_DELDRDY)
#define F_DELDRDY    V_DELDRDY(1U)

#define A_TP_DBG_ENG_RES1 0x67

#define S_RXCPLSRDY    31
#define V_RXCPLSRDY(x) ((x) << S_RXCPLSRDY)
#define F_RXCPLSRDY    V_RXCPLSRDY(1U)

#define S_RXOPTSRDY    30
#define V_RXOPTSRDY(x) ((x) << S_RXOPTSRDY)
#define F_RXOPTSRDY    V_RXOPTSRDY(1U)

#define S_RXPLDLENSRDY    29
#define V_RXPLDLENSRDY(x) ((x) << S_RXPLDLENSRDY)
#define F_RXPLDLENSRDY    V_RXPLDLENSRDY(1U)

#define S_RXNOTBUSY    28
#define V_RXNOTBUSY(x) ((x) << S_RXNOTBUSY)
#define F_RXNOTBUSY    V_RXNOTBUSY(1U)

#define S_CPLCMDIN    20
#define M_CPLCMDIN    0xffU
#define V_CPLCMDIN(x) ((x) << S_CPLCMDIN)
#define G_CPLCMDIN(x) (((x) >> S_CPLCMDIN) & M_CPLCMDIN)

#define S_RCFPTIDSRDY    19
#define V_RCFPTIDSRDY(x) ((x) << S_RCFPTIDSRDY)
#define F_RCFPTIDSRDY    V_RCFPTIDSRDY(1U)

#define S_EPDUHDRSRDY    18
#define V_EPDUHDRSRDY(x) ((x) << S_EPDUHDRSRDY)
#define F_EPDUHDRSRDY    V_EPDUHDRSRDY(1U)

#define S_TUNNELPKTREG    17
#define V_TUNNELPKTREG(x) ((x) << S_TUNNELPKTREG)
#define F_TUNNELPKTREG    V_TUNNELPKTREG(1U)

#define S_TXPKTCSUMSRDY    16
#define V_TXPKTCSUMSRDY(x) ((x) << S_TXPKTCSUMSRDY)
#define F_TXPKTCSUMSRDY    V_TXPKTCSUMSRDY(1U)

#define S_TABLEACCESSLATENCY    12
#define M_TABLEACCESSLATENCY    0xfU
#define V_TABLEACCESSLATENCY(x) ((x) << S_TABLEACCESSLATENCY)
#define G_TABLEACCESSLATENCY(x) (((x) >> S_TABLEACCESSLATENCY) & M_TABLEACCESSLATENCY)

#define S_MMGRDONE    11
#define V_MMGRDONE(x) ((x) << S_MMGRDONE)
#define F_MMGRDONE    V_MMGRDONE(1U)

#define S_SEENMMGRDONE    10
#define V_SEENMMGRDONE(x) ((x) << S_SEENMMGRDONE)
#define F_SEENMMGRDONE    V_SEENMMGRDONE(1U)

#define S_RXERRORSRDY    9
#define V_RXERRORSRDY(x) ((x) << S_RXERRORSRDY)
#define F_RXERRORSRDY    V_RXERRORSRDY(1U)

#define S_RCFOPTIONSTCPSRDY    8
#define V_RCFOPTIONSTCPSRDY(x) ((x) << S_RCFOPTIONSTCPSRDY)
#define F_RCFOPTIONSTCPSRDY    V_RCFOPTIONSTCPSRDY(1U)

#define S_ENGINESTATE    6
#define M_ENGINESTATE    0x3U
#define V_ENGINESTATE(x) ((x) << S_ENGINESTATE)
#define G_ENGINESTATE(x) (((x) >> S_ENGINESTATE) & M_ENGINESTATE)

#define S_TABLEACCESINCREMENT    5
#define V_TABLEACCESINCREMENT(x) ((x) << S_TABLEACCESINCREMENT)
#define F_TABLEACCESINCREMENT    V_TABLEACCESINCREMENT(1U)

#define S_TABLEACCESCOMPLETE    4
#define V_TABLEACCESCOMPLETE(x) ((x) << S_TABLEACCESCOMPLETE)
#define F_TABLEACCESCOMPLETE    V_TABLEACCESCOMPLETE(1U)

#define S_RCFOPCODEOUTUSABLE    3
#define V_RCFOPCODEOUTUSABLE(x) ((x) << S_RCFOPCODEOUTUSABLE)
#define F_RCFOPCODEOUTUSABLE    V_RCFOPCODEOUTUSABLE(1U)

#define S_RCFDATAOUTUSABLE    2
#define V_RCFDATAOUTUSABLE(x) ((x) << S_RCFDATAOUTUSABLE)
#define F_RCFDATAOUTUSABLE    V_RCFDATAOUTUSABLE(1U)

#define S_RCFDATAWAITAFTERRD    1
#define V_RCFDATAWAITAFTERRD(x) ((x) << S_RCFDATAWAITAFTERRD)
#define F_RCFDATAWAITAFTERRD    V_RCFDATAWAITAFTERRD(1U)

#define S_RCFDATACMRDY    0
#define V_RCFDATACMRDY(x) ((x) << S_RCFDATACMRDY)
#define F_RCFDATACMRDY    V_RCFDATACMRDY(1U)

#define A_TP_DBG_ENG_RES2 0x68

#define S_CPLCMDRAW    24
#define M_CPLCMDRAW    0xffU
#define V_CPLCMDRAW(x) ((x) << S_CPLCMDRAW)
#define G_CPLCMDRAW(x) (((x) >> S_CPLCMDRAW) & M_CPLCMDRAW)

#define S_RXMACPORT    20
#define M_RXMACPORT    0xfU
#define V_RXMACPORT(x) ((x) << S_RXMACPORT)
#define G_RXMACPORT(x) (((x) >> S_RXMACPORT) & M_RXMACPORT)

#define S_TXECHANNEL    18
#define M_TXECHANNEL    0x3U
#define V_TXECHANNEL(x) ((x) << S_TXECHANNEL)
#define G_TXECHANNEL(x) (((x) >> S_TXECHANNEL) & M_TXECHANNEL)

#define S_RXECHANNEL    16
#define M_RXECHANNEL    0x3U
#define V_RXECHANNEL(x) ((x) << S_RXECHANNEL)
#define G_RXECHANNEL(x) (((x) >> S_RXECHANNEL) & M_RXECHANNEL)

#define S_CDATAOUT    15
#define V_CDATAOUT(x) ((x) << S_CDATAOUT)
#define F_CDATAOUT    V_CDATAOUT(1U)

#define S_CREADPDU    14
#define V_CREADPDU(x) ((x) << S_CREADPDU)
#define F_CREADPDU    V_CREADPDU(1U)

#define S_EDATAOUT    13
#define V_EDATAOUT(x) ((x) << S_EDATAOUT)
#define F_EDATAOUT    V_EDATAOUT(1U)

#define S_EREADPDU    12
#define V_EREADPDU(x) ((x) << S_EREADPDU)
#define F_EREADPDU    V_EREADPDU(1U)

#define S_ETCPOPSRDY    11
#define V_ETCPOPSRDY(x) ((x) << S_ETCPOPSRDY)
#define F_ETCPOPSRDY    V_ETCPOPSRDY(1U)

#define S_CTCPOPSRDY    10
#define V_CTCPOPSRDY(x) ((x) << S_CTCPOPSRDY)
#define F_CTCPOPSRDY    V_CTCPOPSRDY(1U)

#define S_CPKTOUT    9
#define V_CPKTOUT(x) ((x) << S_CPKTOUT)
#define F_CPKTOUT    V_CPKTOUT(1U)

#define S_CMDBRSPSRDY    8
#define V_CMDBRSPSRDY(x) ((x) << S_CMDBRSPSRDY)
#define F_CMDBRSPSRDY    V_CMDBRSPSRDY(1U)

#define S_RXPSTRUCTSFULL    6
#define M_RXPSTRUCTSFULL    0x3U
#define V_RXPSTRUCTSFULL(x) ((x) << S_RXPSTRUCTSFULL)
#define G_RXPSTRUCTSFULL(x) (((x) >> S_RXPSTRUCTSFULL) & M_RXPSTRUCTSFULL)

#define S_RXPAGEPOOLFULL    4
#define M_RXPAGEPOOLFULL    0x3U
#define V_RXPAGEPOOLFULL(x) ((x) << S_RXPAGEPOOLFULL)
#define G_RXPAGEPOOLFULL(x) (((x) >> S_RXPAGEPOOLFULL) & M_RXPAGEPOOLFULL)

#define S_RCFREASONOUT    0
#define M_RCFREASONOUT    0xfU
#define V_RCFREASONOUT(x) ((x) << S_RCFREASONOUT)
#define G_RCFREASONOUT(x) (((x) >> S_RCFREASONOUT) & M_RCFREASONOUT)

#define A_TP_DBG_CORE_PCMD 0x69

#define S_CPCMDEOPCNT    30
#define M_CPCMDEOPCNT    0x3U
#define V_CPCMDEOPCNT(x) ((x) << S_CPCMDEOPCNT)
#define G_CPCMDEOPCNT(x) (((x) >> S_CPCMDEOPCNT) & M_CPCMDEOPCNT)

#define S_CPCMDLENSAVE    16
#define M_CPCMDLENSAVE    0x3fffU
#define V_CPCMDLENSAVE(x) ((x) << S_CPCMDLENSAVE)
#define G_CPCMDLENSAVE(x) (((x) >> S_CPCMDLENSAVE) & M_CPCMDLENSAVE)

#define S_EPCMDEOPCNT    14
#define M_EPCMDEOPCNT    0x3U
#define V_EPCMDEOPCNT(x) ((x) << S_EPCMDEOPCNT)
#define G_EPCMDEOPCNT(x) (((x) >> S_EPCMDEOPCNT) & M_EPCMDEOPCNT)

#define S_EPCMDLENSAVE    0
#define M_EPCMDLENSAVE    0x3fffU
#define V_EPCMDLENSAVE(x) ((x) << S_EPCMDLENSAVE)
#define G_EPCMDLENSAVE(x) (((x) >> S_EPCMDLENSAVE) & M_EPCMDLENSAVE)

#define A_TP_DBG_SCHED_TX 0x6a

#define S_TXCHNXOFF    28
#define M_TXCHNXOFF    0xfU
#define V_TXCHNXOFF(x) ((x) << S_TXCHNXOFF)
#define G_TXCHNXOFF(x) (((x) >> S_TXCHNXOFF) & M_TXCHNXOFF)

#define S_TXFIFOCNG    24
#define M_TXFIFOCNG    0xfU
#define V_TXFIFOCNG(x) ((x) << S_TXFIFOCNG)
#define G_TXFIFOCNG(x) (((x) >> S_TXFIFOCNG) & M_TXFIFOCNG)

#define S_TXPCMDCNG    20
#define M_TXPCMDCNG    0xfU
#define V_TXPCMDCNG(x) ((x) << S_TXPCMDCNG)
#define G_TXPCMDCNG(x) (((x) >> S_TXPCMDCNG) & M_TXPCMDCNG)

#define S_TXLPBKCNG    16
#define M_TXLPBKCNG    0xfU
#define V_TXLPBKCNG(x) ((x) << S_TXLPBKCNG)
#define G_TXLPBKCNG(x) (((x) >> S_TXLPBKCNG) & M_TXLPBKCNG)

#define S_TXHDRCNG    8
#define M_TXHDRCNG    0xffU
#define V_TXHDRCNG(x) ((x) << S_TXHDRCNG)
#define G_TXHDRCNG(x) (((x) >> S_TXHDRCNG) & M_TXHDRCNG)

#define S_TXMODXOFF    0
#define M_TXMODXOFF    0xffU
#define V_TXMODXOFF(x) ((x) << S_TXMODXOFF)
#define G_TXMODXOFF(x) (((x) >> S_TXMODXOFF) & M_TXMODXOFF)

#define A_TP_DBG_SCHED_RX 0x6b

#define S_RXCHNXOFF    28
#define M_RXCHNXOFF    0xfU
#define V_RXCHNXOFF(x) ((x) << S_RXCHNXOFF)
#define G_RXCHNXOFF(x) (((x) >> S_RXCHNXOFF) & M_RXCHNXOFF)

#define S_RXSGECNG    24
#define M_RXSGECNG    0xfU
#define V_RXSGECNG(x) ((x) << S_RXSGECNG)
#define G_RXSGECNG(x) (((x) >> S_RXSGECNG) & M_RXSGECNG)

#define S_RXFIFOCNG    22
#define M_RXFIFOCNG    0x3U
#define V_RXFIFOCNG(x) ((x) << S_RXFIFOCNG)
#define G_RXFIFOCNG(x) (((x) >> S_RXFIFOCNG) & M_RXFIFOCNG)

#define S_RXPCMDCNG    20
#define M_RXPCMDCNG    0x3U
#define V_RXPCMDCNG(x) ((x) << S_RXPCMDCNG)
#define G_RXPCMDCNG(x) (((x) >> S_RXPCMDCNG) & M_RXPCMDCNG)

#define S_RXLPBKCNG    16
#define M_RXLPBKCNG    0xfU
#define V_RXLPBKCNG(x) ((x) << S_RXLPBKCNG)
#define G_RXLPBKCNG(x) (((x) >> S_RXLPBKCNG) & M_RXLPBKCNG)

#define S_RXHDRCNG    8
#define M_RXHDRCNG    0xfU
#define V_RXHDRCNG(x) ((x) << S_RXHDRCNG)
#define G_RXHDRCNG(x) (((x) >> S_RXHDRCNG) & M_RXHDRCNG)

#define S_RXMODXOFF    0
#define M_RXMODXOFF    0x3U
#define V_RXMODXOFF(x) ((x) << S_RXMODXOFF)
#define G_RXMODXOFF(x) (((x) >> S_RXMODXOFF) & M_RXMODXOFF)

#define A_TP_DBG_ERROR_CNT 0x6c
#define A_TP_MIB_DEBUG 0x6f

#define S_SRC3    31
#define V_SRC3(x) ((x) << S_SRC3)
#define F_SRC3    V_SRC3(1U)

#define S_LINENUM3    24
#define M_LINENUM3    0x7fU
#define V_LINENUM3(x) ((x) << S_LINENUM3)
#define G_LINENUM3(x) (((x) >> S_LINENUM3) & M_LINENUM3)

#define S_SRC2    23
#define V_SRC2(x) ((x) << S_SRC2)
#define F_SRC2    V_SRC2(1U)

#define S_LINENUM2    16
#define M_LINENUM2    0x7fU
#define V_LINENUM2(x) ((x) << S_LINENUM2)
#define G_LINENUM2(x) (((x) >> S_LINENUM2) & M_LINENUM2)

#define S_SRC1    15
#define V_SRC1(x) ((x) << S_SRC1)
#define F_SRC1    V_SRC1(1U)

#define S_LINENUM1    8
#define M_LINENUM1    0x7fU
#define V_LINENUM1(x) ((x) << S_LINENUM1)
#define G_LINENUM1(x) (((x) >> S_LINENUM1) & M_LINENUM1)

#define S_SRC0    7
#define V_SRC0(x) ((x) << S_SRC0)
#define F_SRC0    V_SRC0(1U)

#define S_LINENUM0    0
#define M_LINENUM0    0x7fU
#define V_LINENUM0(x) ((x) << S_LINENUM0)
#define G_LINENUM0(x) (((x) >> S_LINENUM0) & M_LINENUM0)

#define A_TP_T5_TX_DROP_CNT_CH0 0x120
#define A_TP_T5_TX_DROP_CNT_CH1 0x121
#define A_TP_TX_DROP_CNT_CH2 0x122
#define A_TP_TX_DROP_CNT_CH3 0x123
#define A_TP_TX_DROP_CFG_CH0 0x12b

#define S_TIMERENABLED    31
#define V_TIMERENABLED(x) ((x) << S_TIMERENABLED)
#define F_TIMERENABLED    V_TIMERENABLED(1U)

#define S_TIMERERRORENABLE    30
#define V_TIMERERRORENABLE(x) ((x) << S_TIMERERRORENABLE)
#define F_TIMERERRORENABLE    V_TIMERERRORENABLE(1U)

#define S_TIMERTHRESHOLD    4
#define M_TIMERTHRESHOLD    0x3ffffffU
#define V_TIMERTHRESHOLD(x) ((x) << S_TIMERTHRESHOLD)
#define G_TIMERTHRESHOLD(x) (((x) >> S_TIMERTHRESHOLD) & M_TIMERTHRESHOLD)

#define S_PACKETDROPS    0
#define M_PACKETDROPS    0xfU
#define V_PACKETDROPS(x) ((x) << S_PACKETDROPS)
#define G_PACKETDROPS(x) (((x) >> S_PACKETDROPS) & M_PACKETDROPS)

#define A_TP_TX_DROP_CFG_CH1 0x12c
#define A_TP_TX_DROP_CNT_CH0 0x12d

#define S_TXDROPCNTCH0SENT    16
#define M_TXDROPCNTCH0SENT    0xffffU
#define V_TXDROPCNTCH0SENT(x) ((x) << S_TXDROPCNTCH0SENT)
#define G_TXDROPCNTCH0SENT(x) (((x) >> S_TXDROPCNTCH0SENT) & M_TXDROPCNTCH0SENT)

#define S_TXDROPCNTCH0RCVD    0
#define M_TXDROPCNTCH0RCVD    0xffffU
#define V_TXDROPCNTCH0RCVD(x) ((x) << S_TXDROPCNTCH0RCVD)
#define G_TXDROPCNTCH0RCVD(x) (((x) >> S_TXDROPCNTCH0RCVD) & M_TXDROPCNTCH0RCVD)

#define A_TP_TX_DROP_CNT_CH1 0x12e

#define S_TXDROPCNTCH1SENT    16
#define M_TXDROPCNTCH1SENT    0xffffU
#define V_TXDROPCNTCH1SENT(x) ((x) << S_TXDROPCNTCH1SENT)
#define G_TXDROPCNTCH1SENT(x) (((x) >> S_TXDROPCNTCH1SENT) & M_TXDROPCNTCH1SENT)

#define S_TXDROPCNTCH1RCVD    0
#define M_TXDROPCNTCH1RCVD    0xffffU
#define V_TXDROPCNTCH1RCVD(x) ((x) << S_TXDROPCNTCH1RCVD)
#define G_TXDROPCNTCH1RCVD(x) (((x) >> S_TXDROPCNTCH1RCVD) & M_TXDROPCNTCH1RCVD)

#define A_TP_TX_DROP_MODE 0x12f

#define S_TXDROPMODECH3    3
#define V_TXDROPMODECH3(x) ((x) << S_TXDROPMODECH3)
#define F_TXDROPMODECH3    V_TXDROPMODECH3(1U)

#define S_TXDROPMODECH2    2
#define V_TXDROPMODECH2(x) ((x) << S_TXDROPMODECH2)
#define F_TXDROPMODECH2    V_TXDROPMODECH2(1U)

#define S_TXDROPMODECH1    1
#define V_TXDROPMODECH1(x) ((x) << S_TXDROPMODECH1)
#define F_TXDROPMODECH1    V_TXDROPMODECH1(1U)

#define S_TXDROPMODECH0    0
#define V_TXDROPMODECH0(x) ((x) << S_TXDROPMODECH0)
#define F_TXDROPMODECH0    V_TXDROPMODECH0(1U)

#define A_TP_DBG_ESIDE_PKT0 0x130

#define S_ETXSOPCNT    28
#define M_ETXSOPCNT    0xfU
#define V_ETXSOPCNT(x) ((x) << S_ETXSOPCNT)
#define G_ETXSOPCNT(x) (((x) >> S_ETXSOPCNT) & M_ETXSOPCNT)

#define S_ETXEOPCNT    24
#define M_ETXEOPCNT    0xfU
#define V_ETXEOPCNT(x) ((x) << S_ETXEOPCNT)
#define G_ETXEOPCNT(x) (((x) >> S_ETXEOPCNT) & M_ETXEOPCNT)

#define S_ETXPLDSOPCNT    20
#define M_ETXPLDSOPCNT    0xfU
#define V_ETXPLDSOPCNT(x) ((x) << S_ETXPLDSOPCNT)
#define G_ETXPLDSOPCNT(x) (((x) >> S_ETXPLDSOPCNT) & M_ETXPLDSOPCNT)

#define S_ETXPLDEOPCNT    16
#define M_ETXPLDEOPCNT    0xfU
#define V_ETXPLDEOPCNT(x) ((x) << S_ETXPLDEOPCNT)
#define G_ETXPLDEOPCNT(x) (((x) >> S_ETXPLDEOPCNT) & M_ETXPLDEOPCNT)

#define S_ERXSOPCNT    12
#define M_ERXSOPCNT    0xfU
#define V_ERXSOPCNT(x) ((x) << S_ERXSOPCNT)
#define G_ERXSOPCNT(x) (((x) >> S_ERXSOPCNT) & M_ERXSOPCNT)

#define S_ERXEOPCNT    8
#define M_ERXEOPCNT    0xfU
#define V_ERXEOPCNT(x) ((x) << S_ERXEOPCNT)
#define G_ERXEOPCNT(x) (((x) >> S_ERXEOPCNT) & M_ERXEOPCNT)

#define S_ERXPLDSOPCNT    4
#define M_ERXPLDSOPCNT    0xfU
#define V_ERXPLDSOPCNT(x) ((x) << S_ERXPLDSOPCNT)
#define G_ERXPLDSOPCNT(x) (((x) >> S_ERXPLDSOPCNT) & M_ERXPLDSOPCNT)

#define S_ERXPLDEOPCNT    0
#define M_ERXPLDEOPCNT    0xfU
#define V_ERXPLDEOPCNT(x) ((x) << S_ERXPLDEOPCNT)
#define G_ERXPLDEOPCNT(x) (((x) >> S_ERXPLDEOPCNT) & M_ERXPLDEOPCNT)

#define A_TP_DBG_ESIDE_PKT1 0x131
#define A_TP_DBG_ESIDE_PKT2 0x132
#define A_TP_DBG_ESIDE_PKT3 0x133
#define A_TP_DBG_ESIDE_FIFO0 0x134

#define S_PLDRXCSUMVALID1    31
#define V_PLDRXCSUMVALID1(x) ((x) << S_PLDRXCSUMVALID1)
#define F_PLDRXCSUMVALID1    V_PLDRXCSUMVALID1(1U)

#define S_PLDRXZEROPSRDY1    30
#define V_PLDRXZEROPSRDY1(x) ((x) << S_PLDRXZEROPSRDY1)
#define F_PLDRXZEROPSRDY1    V_PLDRXZEROPSRDY1(1U)

#define S_PLDRXVALID1    29
#define V_PLDRXVALID1(x) ((x) << S_PLDRXVALID1)
#define F_PLDRXVALID1    V_PLDRXVALID1(1U)

#define S_TCPRXVALID1    28
#define V_TCPRXVALID1(x) ((x) << S_TCPRXVALID1)
#define F_TCPRXVALID1    V_TCPRXVALID1(1U)

#define S_IPRXVALID1    27
#define V_IPRXVALID1(x) ((x) << S_IPRXVALID1)
#define F_IPRXVALID1    V_IPRXVALID1(1U)

#define S_ETHRXVALID1    26
#define V_ETHRXVALID1(x) ((x) << S_ETHRXVALID1)
#define F_ETHRXVALID1    V_ETHRXVALID1(1U)

#define S_CPLRXVALID1    25
#define V_CPLRXVALID1(x) ((x) << S_CPLRXVALID1)
#define F_CPLRXVALID1    V_CPLRXVALID1(1U)

#define S_FSTATIC1    24
#define V_FSTATIC1(x) ((x) << S_FSTATIC1)
#define F_FSTATIC1    V_FSTATIC1(1U)

#define S_ERRORSRDY1    23
#define V_ERRORSRDY1(x) ((x) << S_ERRORSRDY1)
#define F_ERRORSRDY1    V_ERRORSRDY1(1U)

#define S_PLDTXSRDY1    22
#define V_PLDTXSRDY1(x) ((x) << S_PLDTXSRDY1)
#define F_PLDTXSRDY1    V_PLDTXSRDY1(1U)

#define S_DBVLD1    21
#define V_DBVLD1(x) ((x) << S_DBVLD1)
#define F_DBVLD1    V_DBVLD1(1U)

#define S_PLDTXVALID1    20
#define V_PLDTXVALID1(x) ((x) << S_PLDTXVALID1)
#define F_PLDTXVALID1    V_PLDTXVALID1(1U)

#define S_ETXVALID1    19
#define V_ETXVALID1(x) ((x) << S_ETXVALID1)
#define F_ETXVALID1    V_ETXVALID1(1U)

#define S_ETXFULL1    18
#define V_ETXFULL1(x) ((x) << S_ETXFULL1)
#define F_ETXFULL1    V_ETXFULL1(1U)

#define S_ERXVALID1    17
#define V_ERXVALID1(x) ((x) << S_ERXVALID1)
#define F_ERXVALID1    V_ERXVALID1(1U)

#define S_ERXFULL1    16
#define V_ERXFULL1(x) ((x) << S_ERXFULL1)
#define F_ERXFULL1    V_ERXFULL1(1U)

#define S_PLDRXCSUMVALID0    15
#define V_PLDRXCSUMVALID0(x) ((x) << S_PLDRXCSUMVALID0)
#define F_PLDRXCSUMVALID0    V_PLDRXCSUMVALID0(1U)

#define S_PLDRXZEROPSRDY0    14
#define V_PLDRXZEROPSRDY0(x) ((x) << S_PLDRXZEROPSRDY0)
#define F_PLDRXZEROPSRDY0    V_PLDRXZEROPSRDY0(1U)

#define S_PLDRXVALID0    13
#define V_PLDRXVALID0(x) ((x) << S_PLDRXVALID0)
#define F_PLDRXVALID0    V_PLDRXVALID0(1U)

#define S_TCPRXVALID0    12
#define V_TCPRXVALID0(x) ((x) << S_TCPRXVALID0)
#define F_TCPRXVALID0    V_TCPRXVALID0(1U)

#define S_IPRXVALID0    11
#define V_IPRXVALID0(x) ((x) << S_IPRXVALID0)
#define F_IPRXVALID0    V_IPRXVALID0(1U)

#define S_ETHRXVALID0    10
#define V_ETHRXVALID0(x) ((x) << S_ETHRXVALID0)
#define F_ETHRXVALID0    V_ETHRXVALID0(1U)

#define S_CPLRXVALID0    9
#define V_CPLRXVALID0(x) ((x) << S_CPLRXVALID0)
#define F_CPLRXVALID0    V_CPLRXVALID0(1U)

#define S_FSTATIC0    8
#define V_FSTATIC0(x) ((x) << S_FSTATIC0)
#define F_FSTATIC0    V_FSTATIC0(1U)

#define S_ERRORSRDY0    7
#define V_ERRORSRDY0(x) ((x) << S_ERRORSRDY0)
#define F_ERRORSRDY0    V_ERRORSRDY0(1U)

#define S_PLDTXSRDY0    6
#define V_PLDTXSRDY0(x) ((x) << S_PLDTXSRDY0)
#define F_PLDTXSRDY0    V_PLDTXSRDY0(1U)

#define S_DBVLD0    5
#define V_DBVLD0(x) ((x) << S_DBVLD0)
#define F_DBVLD0    V_DBVLD0(1U)

#define S_PLDTXVALID0    4
#define V_PLDTXVALID0(x) ((x) << S_PLDTXVALID0)
#define F_PLDTXVALID0    V_PLDTXVALID0(1U)

#define S_ETXVALID0    3
#define V_ETXVALID0(x) ((x) << S_ETXVALID0)
#define F_ETXVALID0    V_ETXVALID0(1U)

#define S_ETXFULL0    2
#define V_ETXFULL0(x) ((x) << S_ETXFULL0)
#define F_ETXFULL0    V_ETXFULL0(1U)

#define S_ERXVALID0    1
#define V_ERXVALID0(x) ((x) << S_ERXVALID0)
#define F_ERXVALID0    V_ERXVALID0(1U)

#define S_ERXFULL0    0
#define V_ERXFULL0(x) ((x) << S_ERXFULL0)
#define F_ERXFULL0    V_ERXFULL0(1U)

#define A_TP_DBG_ESIDE_FIFO1 0x135

#define S_PLDRXCSUMVALID3    31
#define V_PLDRXCSUMVALID3(x) ((x) << S_PLDRXCSUMVALID3)
#define F_PLDRXCSUMVALID3    V_PLDRXCSUMVALID3(1U)

#define S_PLDRXZEROPSRDY3    30
#define V_PLDRXZEROPSRDY3(x) ((x) << S_PLDRXZEROPSRDY3)
#define F_PLDRXZEROPSRDY3    V_PLDRXZEROPSRDY3(1U)

#define S_PLDRXVALID3    29
#define V_PLDRXVALID3(x) ((x) << S_PLDRXVALID3)
#define F_PLDRXVALID3    V_PLDRXVALID3(1U)

#define S_TCPRXVALID3    28
#define V_TCPRXVALID3(x) ((x) << S_TCPRXVALID3)
#define F_TCPRXVALID3    V_TCPRXVALID3(1U)

#define S_IPRXVALID3    27
#define V_IPRXVALID3(x) ((x) << S_IPRXVALID3)
#define F_IPRXVALID3    V_IPRXVALID3(1U)

#define S_ETHRXVALID3    26
#define V_ETHRXVALID3(x) ((x) << S_ETHRXVALID3)
#define F_ETHRXVALID3    V_ETHRXVALID3(1U)

#define S_CPLRXVALID3    25
#define V_CPLRXVALID3(x) ((x) << S_CPLRXVALID3)
#define F_CPLRXVALID3    V_CPLRXVALID3(1U)

#define S_FSTATIC3    24
#define V_FSTATIC3(x) ((x) << S_FSTATIC3)
#define F_FSTATIC3    V_FSTATIC3(1U)

#define S_ERRORSRDY3    23
#define V_ERRORSRDY3(x) ((x) << S_ERRORSRDY3)
#define F_ERRORSRDY3    V_ERRORSRDY3(1U)

#define S_PLDTXSRDY3    22
#define V_PLDTXSRDY3(x) ((x) << S_PLDTXSRDY3)
#define F_PLDTXSRDY3    V_PLDTXSRDY3(1U)

#define S_DBVLD3    21
#define V_DBVLD3(x) ((x) << S_DBVLD3)
#define F_DBVLD3    V_DBVLD3(1U)

#define S_PLDTXVALID3    20
#define V_PLDTXVALID3(x) ((x) << S_PLDTXVALID3)
#define F_PLDTXVALID3    V_PLDTXVALID3(1U)

#define S_ETXVALID3    19
#define V_ETXVALID3(x) ((x) << S_ETXVALID3)
#define F_ETXVALID3    V_ETXVALID3(1U)

#define S_ETXFULL3    18
#define V_ETXFULL3(x) ((x) << S_ETXFULL3)
#define F_ETXFULL3    V_ETXFULL3(1U)

#define S_ERXVALID3    17
#define V_ERXVALID3(x) ((x) << S_ERXVALID3)
#define F_ERXVALID3    V_ERXVALID3(1U)

#define S_ERXFULL3    16
#define V_ERXFULL3(x) ((x) << S_ERXFULL3)
#define F_ERXFULL3    V_ERXFULL3(1U)

#define S_PLDRXCSUMVALID2    15
#define V_PLDRXCSUMVALID2(x) ((x) << S_PLDRXCSUMVALID2)
#define F_PLDRXCSUMVALID2    V_PLDRXCSUMVALID2(1U)

#define S_PLDRXZEROPSRDY2    14
#define V_PLDRXZEROPSRDY2(x) ((x) << S_PLDRXZEROPSRDY2)
#define F_PLDRXZEROPSRDY2    V_PLDRXZEROPSRDY2(1U)

#define S_PLDRXVALID2    13
#define V_PLDRXVALID2(x) ((x) << S_PLDRXVALID2)
#define F_PLDRXVALID2    V_PLDRXVALID2(1U)

#define S_TCPRXVALID2    12
#define V_TCPRXVALID2(x) ((x) << S_TCPRXVALID2)
#define F_TCPRXVALID2    V_TCPRXVALID2(1U)

#define S_IPRXVALID2    11
#define V_IPRXVALID2(x) ((x) << S_IPRXVALID2)
#define F_IPRXVALID2    V_IPRXVALID2(1U)

#define S_ETHRXVALID2    10
#define V_ETHRXVALID2(x) ((x) << S_ETHRXVALID2)
#define F_ETHRXVALID2    V_ETHRXVALID2(1U)

#define S_CPLRXVALID2    9
#define V_CPLRXVALID2(x) ((x) << S_CPLRXVALID2)
#define F_CPLRXVALID2    V_CPLRXVALID2(1U)

#define S_FSTATIC2    8
#define V_FSTATIC2(x) ((x) << S_FSTATIC2)
#define F_FSTATIC2    V_FSTATIC2(1U)

#define S_ERRORSRDY2    7
#define V_ERRORSRDY2(x) ((x) << S_ERRORSRDY2)
#define F_ERRORSRDY2    V_ERRORSRDY2(1U)

#define S_PLDTXSRDY2    6
#define V_PLDTXSRDY2(x) ((x) << S_PLDTXSRDY2)
#define F_PLDTXSRDY2    V_PLDTXSRDY2(1U)

#define S_DBVLD2    5
#define V_DBVLD2(x) ((x) << S_DBVLD2)
#define F_DBVLD2    V_DBVLD2(1U)

#define S_PLDTXVALID2    4
#define V_PLDTXVALID2(x) ((x) << S_PLDTXVALID2)
#define F_PLDTXVALID2    V_PLDTXVALID2(1U)

#define S_ETXVALID2    3
#define V_ETXVALID2(x) ((x) << S_ETXVALID2)
#define F_ETXVALID2    V_ETXVALID2(1U)

#define S_ETXFULL2    2
#define V_ETXFULL2(x) ((x) << S_ETXFULL2)
#define F_ETXFULL2    V_ETXFULL2(1U)

#define S_ERXVALID2    1
#define V_ERXVALID2(x) ((x) << S_ERXVALID2)
#define F_ERXVALID2    V_ERXVALID2(1U)

#define S_ERXFULL2    0
#define V_ERXFULL2(x) ((x) << S_ERXFULL2)
#define F_ERXFULL2    V_ERXFULL2(1U)

#define A_TP_DBG_ESIDE_DISP0 0x136

#define S_RESRDY    31
#define V_RESRDY(x) ((x) << S_RESRDY)
#define F_RESRDY    V_RESRDY(1U)

#define S_STATE    28
#define M_STATE    0x7U
#define V_STATE(x) ((x) << S_STATE)
#define G_STATE(x) (((x) >> S_STATE) & M_STATE)

#define S_FIFOCPL5RXVALID    27
#define V_FIFOCPL5RXVALID(x) ((x) << S_FIFOCPL5RXVALID)
#define F_FIFOCPL5RXVALID    V_FIFOCPL5RXVALID(1U)

#define S_FIFOETHRXVALID    26
#define V_FIFOETHRXVALID(x) ((x) << S_FIFOETHRXVALID)
#define F_FIFOETHRXVALID    V_FIFOETHRXVALID(1U)

#define S_FIFOETHRXSOCP    25
#define V_FIFOETHRXSOCP(x) ((x) << S_FIFOETHRXSOCP)
#define F_FIFOETHRXSOCP    V_FIFOETHRXSOCP(1U)

#define S_FIFOPLDRXZEROP    24
#define V_FIFOPLDRXZEROP(x) ((x) << S_FIFOPLDRXZEROP)
#define F_FIFOPLDRXZEROP    V_FIFOPLDRXZEROP(1U)

#define S_PLDRXVALID    23
#define V_PLDRXVALID(x) ((x) << S_PLDRXVALID)
#define F_PLDRXVALID    V_PLDRXVALID(1U)

#define S_FIFOPLDRXZEROP_SRDY    22
#define V_FIFOPLDRXZEROP_SRDY(x) ((x) << S_FIFOPLDRXZEROP_SRDY)
#define F_FIFOPLDRXZEROP_SRDY    V_FIFOPLDRXZEROP_SRDY(1U)

#define S_FIFOIPRXVALID    21
#define V_FIFOIPRXVALID(x) ((x) << S_FIFOIPRXVALID)
#define F_FIFOIPRXVALID    V_FIFOIPRXVALID(1U)

#define S_FIFOTCPRXVALID    20
#define V_FIFOTCPRXVALID(x) ((x) << S_FIFOTCPRXVALID)
#define F_FIFOTCPRXVALID    V_FIFOTCPRXVALID(1U)

#define S_PLDRXCSUMVALID    19
#define V_PLDRXCSUMVALID(x) ((x) << S_PLDRXCSUMVALID)
#define F_PLDRXCSUMVALID    V_PLDRXCSUMVALID(1U)

#define S_FIFOIPCSUMSRDY    18
#define V_FIFOIPCSUMSRDY(x) ((x) << S_FIFOIPCSUMSRDY)
#define F_FIFOIPCSUMSRDY    V_FIFOIPCSUMSRDY(1U)

#define S_FIFOIPPSEUDOCSUMSRDY    17
#define V_FIFOIPPSEUDOCSUMSRDY(x) ((x) << S_FIFOIPPSEUDOCSUMSRDY)
#define F_FIFOIPPSEUDOCSUMSRDY    V_FIFOIPPSEUDOCSUMSRDY(1U)

#define S_FIFOTCPCSUMSRDY    16
#define V_FIFOTCPCSUMSRDY(x) ((x) << S_FIFOTCPCSUMSRDY)
#define F_FIFOTCPCSUMSRDY    V_FIFOTCPCSUMSRDY(1U)

#define S_ESTATIC4    12
#define M_ESTATIC4    0xfU
#define V_ESTATIC4(x) ((x) << S_ESTATIC4)
#define G_ESTATIC4(x) (((x) >> S_ESTATIC4) & M_ESTATIC4)

#define S_FIFOCPLSOCPCNT    10
#define M_FIFOCPLSOCPCNT    0x3U
#define V_FIFOCPLSOCPCNT(x) ((x) << S_FIFOCPLSOCPCNT)
#define G_FIFOCPLSOCPCNT(x) (((x) >> S_FIFOCPLSOCPCNT) & M_FIFOCPLSOCPCNT)

#define S_FIFOETHSOCPCNT    8
#define M_FIFOETHSOCPCNT    0x3U
#define V_FIFOETHSOCPCNT(x) ((x) << S_FIFOETHSOCPCNT)
#define G_FIFOETHSOCPCNT(x) (((x) >> S_FIFOETHSOCPCNT) & M_FIFOETHSOCPCNT)

#define S_FIFOIPSOCPCNT    6
#define M_FIFOIPSOCPCNT    0x3U
#define V_FIFOIPSOCPCNT(x) ((x) << S_FIFOIPSOCPCNT)
#define G_FIFOIPSOCPCNT(x) (((x) >> S_FIFOIPSOCPCNT) & M_FIFOIPSOCPCNT)

#define S_FIFOTCPSOCPCNT    4
#define M_FIFOTCPSOCPCNT    0x3U
#define V_FIFOTCPSOCPCNT(x) ((x) << S_FIFOTCPSOCPCNT)
#define G_FIFOTCPSOCPCNT(x) (((x) >> S_FIFOTCPSOCPCNT) & M_FIFOTCPSOCPCNT)

#define S_PLD_RXZEROP_CNT    2
#define M_PLD_RXZEROP_CNT    0x3U
#define V_PLD_RXZEROP_CNT(x) ((x) << S_PLD_RXZEROP_CNT)
#define G_PLD_RXZEROP_CNT(x) (((x) >> S_PLD_RXZEROP_CNT) & M_PLD_RXZEROP_CNT)

#define S_ESTATIC6    1
#define V_ESTATIC6(x) ((x) << S_ESTATIC6)
#define F_ESTATIC6    V_ESTATIC6(1U)

#define S_TXFULL    0
#define V_TXFULL(x) ((x) << S_TXFULL)
#define F_TXFULL    V_TXFULL(1U)

#define A_TP_DBG_ESIDE_DISP1 0x137
#define A_TP_MAC_MATCH_MAP0 0x138

#define S_MAPVALUEWR    16
#define M_MAPVALUEWR    0xffU
#define V_MAPVALUEWR(x) ((x) << S_MAPVALUEWR)
#define G_MAPVALUEWR(x) (((x) >> S_MAPVALUEWR) & M_MAPVALUEWR)

#define S_MAPINDEX    2
#define M_MAPINDEX    0x1ffU
#define V_MAPINDEX(x) ((x) << S_MAPINDEX)
#define G_MAPINDEX(x) (((x) >> S_MAPINDEX) & M_MAPINDEX)

#define S_MAPREAD    1
#define V_MAPREAD(x) ((x) << S_MAPREAD)
#define F_MAPREAD    V_MAPREAD(1U)

#define S_MAPWRITE    0
#define V_MAPWRITE(x) ((x) << S_MAPWRITE)
#define F_MAPWRITE    V_MAPWRITE(1U)

#define A_TP_MAC_MATCH_MAP1 0x139

#define S_MAPVALUERD    0
#define M_MAPVALUERD    0x1ffU
#define V_MAPVALUERD(x) ((x) << S_MAPVALUERD)
#define G_MAPVALUERD(x) (((x) >> S_MAPVALUERD) & M_MAPVALUERD)

#define A_TP_DBG_ESIDE_DISP2 0x13a
#define A_TP_DBG_ESIDE_DISP3 0x13b
#define A_TP_DBG_ESIDE_HDR0 0x13c

#define S_TCPSOPCNT    28
#define M_TCPSOPCNT    0xfU
#define V_TCPSOPCNT(x) ((x) << S_TCPSOPCNT)
#define G_TCPSOPCNT(x) (((x) >> S_TCPSOPCNT) & M_TCPSOPCNT)

#define S_TCPEOPCNT    24
#define M_TCPEOPCNT    0xfU
#define V_TCPEOPCNT(x) ((x) << S_TCPEOPCNT)
#define G_TCPEOPCNT(x) (((x) >> S_TCPEOPCNT) & M_TCPEOPCNT)

#define S_IPSOPCNT    20
#define M_IPSOPCNT    0xfU
#define V_IPSOPCNT(x) ((x) << S_IPSOPCNT)
#define G_IPSOPCNT(x) (((x) >> S_IPSOPCNT) & M_IPSOPCNT)

#define S_IPEOPCNT    16
#define M_IPEOPCNT    0xfU
#define V_IPEOPCNT(x) ((x) << S_IPEOPCNT)
#define G_IPEOPCNT(x) (((x) >> S_IPEOPCNT) & M_IPEOPCNT)

#define S_ETHSOPCNT    12
#define M_ETHSOPCNT    0xfU
#define V_ETHSOPCNT(x) ((x) << S_ETHSOPCNT)
#define G_ETHSOPCNT(x) (((x) >> S_ETHSOPCNT) & M_ETHSOPCNT)

#define S_ETHEOPCNT    8
#define M_ETHEOPCNT    0xfU
#define V_ETHEOPCNT(x) ((x) << S_ETHEOPCNT)
#define G_ETHEOPCNT(x) (((x) >> S_ETHEOPCNT) & M_ETHEOPCNT)

#define S_CPLSOPCNT    4
#define M_CPLSOPCNT    0xfU
#define V_CPLSOPCNT(x) ((x) << S_CPLSOPCNT)
#define G_CPLSOPCNT(x) (((x) >> S_CPLSOPCNT) & M_CPLSOPCNT)

#define S_CPLEOPCNT    0
#define M_CPLEOPCNT    0xfU
#define V_CPLEOPCNT(x) ((x) << S_CPLEOPCNT)
#define G_CPLEOPCNT(x) (((x) >> S_CPLEOPCNT) & M_CPLEOPCNT)

#define A_TP_DBG_ESIDE_HDR1 0x13d
#define A_TP_DBG_ESIDE_HDR2 0x13e
#define A_TP_DBG_ESIDE_HDR3 0x13f
#define A_TP_VLAN_PRI_MAP 0x140

#define S_FRAGMENTATION    9
#define V_FRAGMENTATION(x) ((x) << S_FRAGMENTATION)
#define F_FRAGMENTATION    V_FRAGMENTATION(1U)

#define S_MPSHITTYPE    8
#define V_MPSHITTYPE(x) ((x) << S_MPSHITTYPE)
#define F_MPSHITTYPE    V_MPSHITTYPE(1U)

#define S_MACMATCH    7
#define V_MACMATCH(x) ((x) << S_MACMATCH)
#define F_MACMATCH    V_MACMATCH(1U)

#define S_ETHERTYPE    6
#define V_ETHERTYPE(x) ((x) << S_ETHERTYPE)
#define F_ETHERTYPE    V_ETHERTYPE(1U)

#define S_PROTOCOL    5
#define V_PROTOCOL(x) ((x) << S_PROTOCOL)
#define F_PROTOCOL    V_PROTOCOL(1U)

#define S_TOS    4
#define V_TOS(x) ((x) << S_TOS)
#define F_TOS    V_TOS(1U)

#define S_VLAN    3
#define V_VLAN(x) ((x) << S_VLAN)
#define F_VLAN    V_VLAN(1U)

#define S_VNIC_ID    2
#define V_VNIC_ID(x) ((x) << S_VNIC_ID)
#define F_VNIC_ID    V_VNIC_ID(1U)

#define S_PORT    1
#define V_PORT(x) ((x) << S_PORT)
#define F_PORT    V_PORT(1U)

#define S_FCOE    0
#define V_FCOE(x) ((x) << S_FCOE)
#define F_FCOE    V_FCOE(1U)

#define S_FILTERMODE    15
#define V_FILTERMODE(x) ((x) << S_FILTERMODE)
#define F_FILTERMODE    V_FILTERMODE(1U)

#define S_FCOEMASK    14
#define V_FCOEMASK(x) ((x) << S_FCOEMASK)
#define F_FCOEMASK    V_FCOEMASK(1U)

#define S_SRVRSRAM    13
#define V_SRVRSRAM(x) ((x) << S_SRVRSRAM)
#define F_SRVRSRAM    V_SRVRSRAM(1U)

#define A_TP_INGRESS_CONFIG 0x141

#define S_OPAQUE_TYPE    16
#define M_OPAQUE_TYPE    0xffffU
#define V_OPAQUE_TYPE(x) ((x) << S_OPAQUE_TYPE)
#define G_OPAQUE_TYPE(x) (((x) >> S_OPAQUE_TYPE) & M_OPAQUE_TYPE)

#define S_OPAQUE_RM    15
#define V_OPAQUE_RM(x) ((x) << S_OPAQUE_RM)
#define F_OPAQUE_RM    V_OPAQUE_RM(1U)

#define S_OPAQUE_HDR_SIZE    14
#define V_OPAQUE_HDR_SIZE(x) ((x) << S_OPAQUE_HDR_SIZE)
#define F_OPAQUE_HDR_SIZE    V_OPAQUE_HDR_SIZE(1U)

#define S_OPAQUE_RM_MAC_IN_MAC    13
#define V_OPAQUE_RM_MAC_IN_MAC(x) ((x) << S_OPAQUE_RM_MAC_IN_MAC)
#define F_OPAQUE_RM_MAC_IN_MAC    V_OPAQUE_RM_MAC_IN_MAC(1U)

#define S_FCOE_TARGET    12
#define V_FCOE_TARGET(x) ((x) << S_FCOE_TARGET)
#define F_FCOE_TARGET    V_FCOE_TARGET(1U)

#define S_VNIC    11
#define V_VNIC(x) ((x) << S_VNIC)
#define F_VNIC    V_VNIC(1U)

#define S_CSUM_HAS_PSEUDO_HDR    10
#define V_CSUM_HAS_PSEUDO_HDR(x) ((x) << S_CSUM_HAS_PSEUDO_HDR)
#define F_CSUM_HAS_PSEUDO_HDR    V_CSUM_HAS_PSEUDO_HDR(1U)

#define S_RM_OVLAN    9
#define V_RM_OVLAN(x) ((x) << S_RM_OVLAN)
#define F_RM_OVLAN    V_RM_OVLAN(1U)

#define S_LOOKUPEVERYPKT    8
#define V_LOOKUPEVERYPKT(x) ((x) << S_LOOKUPEVERYPKT)
#define F_LOOKUPEVERYPKT    V_LOOKUPEVERYPKT(1U)

#define S_IPV6_EXT_HDR_SKIP    0
#define M_IPV6_EXT_HDR_SKIP    0xffU
#define V_IPV6_EXT_HDR_SKIP(x) ((x) << S_IPV6_EXT_HDR_SKIP)
#define G_IPV6_EXT_HDR_SKIP(x) (((x) >> S_IPV6_EXT_HDR_SKIP) & M_IPV6_EXT_HDR_SKIP)

#define S_FRAG_LEN_MOD8_COMPAT    12
#define V_FRAG_LEN_MOD8_COMPAT(x) ((x) << S_FRAG_LEN_MOD8_COMPAT)
#define F_FRAG_LEN_MOD8_COMPAT    V_FRAG_LEN_MOD8_COMPAT(1U)

#define A_TP_TX_DROP_CFG_CH2 0x142
#define A_TP_TX_DROP_CFG_CH3 0x143
#define A_TP_EGRESS_CONFIG 0x145

#define S_REWRITEFORCETOSIZE    0
#define V_REWRITEFORCETOSIZE(x) ((x) << S_REWRITEFORCETOSIZE)
#define F_REWRITEFORCETOSIZE    V_REWRITEFORCETOSIZE(1U)

#define A_TP_INGRESS_CONFIG2 0x145

#define S_IPV6_UDP_CSUM_COMPAT    31
#define V_IPV6_UDP_CSUM_COMPAT(x) ((x) << S_IPV6_UDP_CSUM_COMPAT)
#define F_IPV6_UDP_CSUM_COMPAT    V_IPV6_UDP_CSUM_COMPAT(1U)

#define S_VNTAGPLDENABLE    30
#define V_VNTAGPLDENABLE(x) ((x) << S_VNTAGPLDENABLE)
#define F_VNTAGPLDENABLE    V_VNTAGPLDENABLE(1U)

#define S_TCP_PLD_FILTER_OFFSET    20
#define M_TCP_PLD_FILTER_OFFSET    0x3ffU
#define V_TCP_PLD_FILTER_OFFSET(x) ((x) << S_TCP_PLD_FILTER_OFFSET)
#define G_TCP_PLD_FILTER_OFFSET(x) (((x) >> S_TCP_PLD_FILTER_OFFSET) & M_TCP_PLD_FILTER_OFFSET)

#define S_UDP_PLD_FILTER_OFFSET    10
#define M_UDP_PLD_FILTER_OFFSET    0x3ffU
#define V_UDP_PLD_FILTER_OFFSET(x) ((x) << S_UDP_PLD_FILTER_OFFSET)
#define G_UDP_PLD_FILTER_OFFSET(x) (((x) >> S_UDP_PLD_FILTER_OFFSET) & M_UDP_PLD_FILTER_OFFSET)

#define S_TNL_PLD_FILTER_OFFSET    0
#define M_TNL_PLD_FILTER_OFFSET    0x3ffU
#define V_TNL_PLD_FILTER_OFFSET(x) ((x) << S_TNL_PLD_FILTER_OFFSET)
#define G_TNL_PLD_FILTER_OFFSET(x) (((x) >> S_TNL_PLD_FILTER_OFFSET) & M_TNL_PLD_FILTER_OFFSET)

#define A_TP_EHDR_CONFIG_LO 0x146

#define S_CPLLIMIT    24
#define M_CPLLIMIT    0xffU
#define V_CPLLIMIT(x) ((x) << S_CPLLIMIT)
#define G_CPLLIMIT(x) (((x) >> S_CPLLIMIT) & M_CPLLIMIT)

#define S_ETHLIMIT    16
#define M_ETHLIMIT    0xffU
#define V_ETHLIMIT(x) ((x) << S_ETHLIMIT)
#define G_ETHLIMIT(x) (((x) >> S_ETHLIMIT) & M_ETHLIMIT)

#define S_IPLIMIT    8
#define M_IPLIMIT    0xffU
#define V_IPLIMIT(x) ((x) << S_IPLIMIT)
#define G_IPLIMIT(x) (((x) >> S_IPLIMIT) & M_IPLIMIT)

#define S_TCPLIMIT    0
#define M_TCPLIMIT    0xffU
#define V_TCPLIMIT(x) ((x) << S_TCPLIMIT)
#define G_TCPLIMIT(x) (((x) >> S_TCPLIMIT) & M_TCPLIMIT)

#define A_TP_EHDR_CONFIG_HI 0x147
#define A_TP_DBG_ESIDE_INT 0x148

#define S_ERXSOP2X    28
#define M_ERXSOP2X    0xfU
#define V_ERXSOP2X(x) ((x) << S_ERXSOP2X)
#define G_ERXSOP2X(x) (((x) >> S_ERXSOP2X) & M_ERXSOP2X)

#define S_ERXEOP2X    24
#define M_ERXEOP2X    0xfU
#define V_ERXEOP2X(x) ((x) << S_ERXEOP2X)
#define G_ERXEOP2X(x) (((x) >> S_ERXEOP2X) & M_ERXEOP2X)

#define S_ERXVALID2X    20
#define M_ERXVALID2X    0xfU
#define V_ERXVALID2X(x) ((x) << S_ERXVALID2X)
#define G_ERXVALID2X(x) (((x) >> S_ERXVALID2X) & M_ERXVALID2X)

#define S_ERXAFULL2X    16
#define M_ERXAFULL2X    0xfU
#define V_ERXAFULL2X(x) ((x) << S_ERXAFULL2X)
#define G_ERXAFULL2X(x) (((x) >> S_ERXAFULL2X) & M_ERXAFULL2X)

#define S_PLD2XTXVALID    12
#define M_PLD2XTXVALID    0xfU
#define V_PLD2XTXVALID(x) ((x) << S_PLD2XTXVALID)
#define G_PLD2XTXVALID(x) (((x) >> S_PLD2XTXVALID) & M_PLD2XTXVALID)

#define S_PLD2XTXAFULL    8
#define M_PLD2XTXAFULL    0xfU
#define V_PLD2XTXAFULL(x) ((x) << S_PLD2XTXAFULL)
#define G_PLD2XTXAFULL(x) (((x) >> S_PLD2XTXAFULL) & M_PLD2XTXAFULL)

#define S_ERRORSRDY    7
#define V_ERRORSRDY(x) ((x) << S_ERRORSRDY)
#define F_ERRORSRDY    V_ERRORSRDY(1U)

#define S_ERRORDRDY    6
#define V_ERRORDRDY(x) ((x) << S_ERRORDRDY)
#define F_ERRORDRDY    V_ERRORDRDY(1U)

#define S_TCPOPSRDY    5
#define V_TCPOPSRDY(x) ((x) << S_TCPOPSRDY)
#define F_TCPOPSRDY    V_TCPOPSRDY(1U)

#define S_TCPOPDRDY    4
#define V_TCPOPDRDY(x) ((x) << S_TCPOPDRDY)
#define F_TCPOPDRDY    V_TCPOPDRDY(1U)

#define S_PLDTXSRDY    3
#define V_PLDTXSRDY(x) ((x) << S_PLDTXSRDY)
#define F_PLDTXSRDY    V_PLDTXSRDY(1U)

#define S_PLDTXDRDY    2
#define V_PLDTXDRDY(x) ((x) << S_PLDTXDRDY)
#define F_PLDTXDRDY    V_PLDTXDRDY(1U)

#define S_TCPOPTTXVALID    1
#define V_TCPOPTTXVALID(x) ((x) << S_TCPOPTTXVALID)
#define F_TCPOPTTXVALID    V_TCPOPTTXVALID(1U)

#define S_TCPOPTTXFULL    0
#define V_TCPOPTTXFULL(x) ((x) << S_TCPOPTTXFULL)
#define F_TCPOPTTXFULL    V_TCPOPTTXFULL(1U)

#define A_TP_DBG_ESIDE_DEMUX 0x149

#define S_EALLDONE    28
#define M_EALLDONE    0xfU
#define V_EALLDONE(x) ((x) << S_EALLDONE)
#define G_EALLDONE(x) (((x) >> S_EALLDONE) & M_EALLDONE)

#define S_EFIFOPLDDONE    24
#define M_EFIFOPLDDONE    0xfU
#define V_EFIFOPLDDONE(x) ((x) << S_EFIFOPLDDONE)
#define G_EFIFOPLDDONE(x) (((x) >> S_EFIFOPLDDONE) & M_EFIFOPLDDONE)

#define S_EDBDONE    20
#define M_EDBDONE    0xfU
#define V_EDBDONE(x) ((x) << S_EDBDONE)
#define G_EDBDONE(x) (((x) >> S_EDBDONE) & M_EDBDONE)

#define S_EISSFIFODONE    16
#define M_EISSFIFODONE    0xfU
#define V_EISSFIFODONE(x) ((x) << S_EISSFIFODONE)
#define G_EISSFIFODONE(x) (((x) >> S_EISSFIFODONE) & M_EISSFIFODONE)

#define S_EACKERRFIFODONE    12
#define M_EACKERRFIFODONE    0xfU
#define V_EACKERRFIFODONE(x) ((x) << S_EACKERRFIFODONE)
#define G_EACKERRFIFODONE(x) (((x) >> S_EACKERRFIFODONE) & M_EACKERRFIFODONE)

#define S_EFIFOERRORDONE    8
#define M_EFIFOERRORDONE    0xfU
#define V_EFIFOERRORDONE(x) ((x) << S_EFIFOERRORDONE)
#define G_EFIFOERRORDONE(x) (((x) >> S_EFIFOERRORDONE) & M_EFIFOERRORDONE)

#define S_ERXPKTATTRFIFOFDONE    4
#define M_ERXPKTATTRFIFOFDONE    0xfU
#define V_ERXPKTATTRFIFOFDONE(x) ((x) << S_ERXPKTATTRFIFOFDONE)
#define G_ERXPKTATTRFIFOFDONE(x) (((x) >> S_ERXPKTATTRFIFOFDONE) & M_ERXPKTATTRFIFOFDONE)

#define S_ETCPOPDONE    0
#define M_ETCPOPDONE    0xfU
#define V_ETCPOPDONE(x) ((x) << S_ETCPOPDONE)
#define G_ETCPOPDONE(x) (((x) >> S_ETCPOPDONE) & M_ETCPOPDONE)

#define A_TP_DBG_ESIDE_IN0 0x14a

#define S_RXVALID    31
#define V_RXVALID(x) ((x) << S_RXVALID)
#define F_RXVALID    V_RXVALID(1U)

#define S_RXFULL    30
#define V_RXFULL(x) ((x) << S_RXFULL)
#define F_RXFULL    V_RXFULL(1U)

#define S_RXSOCP    29
#define V_RXSOCP(x) ((x) << S_RXSOCP)
#define F_RXSOCP    V_RXSOCP(1U)

#define S_RXEOP    28
#define V_RXEOP(x) ((x) << S_RXEOP)
#define F_RXEOP    V_RXEOP(1U)

#define S_RXVALID_I    27
#define V_RXVALID_I(x) ((x) << S_RXVALID_I)
#define F_RXVALID_I    V_RXVALID_I(1U)

#define S_RXFULL_I    26
#define V_RXFULL_I(x) ((x) << S_RXFULL_I)
#define F_RXFULL_I    V_RXFULL_I(1U)

#define S_RXSOCP_I    25
#define V_RXSOCP_I(x) ((x) << S_RXSOCP_I)
#define F_RXSOCP_I    V_RXSOCP_I(1U)

#define S_RXEOP_I    24
#define V_RXEOP_I(x) ((x) << S_RXEOP_I)
#define F_RXEOP_I    V_RXEOP_I(1U)

#define S_RXVALID_I2    23
#define V_RXVALID_I2(x) ((x) << S_RXVALID_I2)
#define F_RXVALID_I2    V_RXVALID_I2(1U)

#define S_RXFULL_I2    22
#define V_RXFULL_I2(x) ((x) << S_RXFULL_I2)
#define F_RXFULL_I2    V_RXFULL_I2(1U)

#define S_RXSOCP_I2    21
#define V_RXSOCP_I2(x) ((x) << S_RXSOCP_I2)
#define F_RXSOCP_I2    V_RXSOCP_I2(1U)

#define S_RXEOP_I2    20
#define V_RXEOP_I2(x) ((x) << S_RXEOP_I2)
#define F_RXEOP_I2    V_RXEOP_I2(1U)

#define S_CT_MPA_TXVALID_FIFO    19
#define V_CT_MPA_TXVALID_FIFO(x) ((x) << S_CT_MPA_TXVALID_FIFO)
#define F_CT_MPA_TXVALID_FIFO    V_CT_MPA_TXVALID_FIFO(1U)

#define S_CT_MPA_TXFULL_FIFO    18
#define V_CT_MPA_TXFULL_FIFO(x) ((x) << S_CT_MPA_TXFULL_FIFO)
#define F_CT_MPA_TXFULL_FIFO    V_CT_MPA_TXFULL_FIFO(1U)

#define S_CT_MPA_TXVALID    17
#define V_CT_MPA_TXVALID(x) ((x) << S_CT_MPA_TXVALID)
#define F_CT_MPA_TXVALID    V_CT_MPA_TXVALID(1U)

#define S_CT_MPA_TXFULL    16
#define V_CT_MPA_TXFULL(x) ((x) << S_CT_MPA_TXFULL)
#define F_CT_MPA_TXFULL    V_CT_MPA_TXFULL(1U)

#define S_RXVALID_BUF    15
#define V_RXVALID_BUF(x) ((x) << S_RXVALID_BUF)
#define F_RXVALID_BUF    V_RXVALID_BUF(1U)

#define S_RXFULL_BUF    14
#define V_RXFULL_BUF(x) ((x) << S_RXFULL_BUF)
#define F_RXFULL_BUF    V_RXFULL_BUF(1U)

#define S_PLD_TXVALID    13
#define V_PLD_TXVALID(x) ((x) << S_PLD_TXVALID)
#define F_PLD_TXVALID    V_PLD_TXVALID(1U)

#define S_PLD_TXFULL    12
#define V_PLD_TXFULL(x) ((x) << S_PLD_TXFULL)
#define F_PLD_TXFULL    V_PLD_TXFULL(1U)

#define S_ISS_FIFO_SRDY    11
#define V_ISS_FIFO_SRDY(x) ((x) << S_ISS_FIFO_SRDY)
#define F_ISS_FIFO_SRDY    V_ISS_FIFO_SRDY(1U)

#define S_ISS_FIFO_DRDY    10
#define V_ISS_FIFO_DRDY(x) ((x) << S_ISS_FIFO_DRDY)
#define F_ISS_FIFO_DRDY    V_ISS_FIFO_DRDY(1U)

#define S_CT_TCP_OP_ISS_SRDY    9
#define V_CT_TCP_OP_ISS_SRDY(x) ((x) << S_CT_TCP_OP_ISS_SRDY)
#define F_CT_TCP_OP_ISS_SRDY    V_CT_TCP_OP_ISS_SRDY(1U)

#define S_CT_TCP_OP_ISS_DRDY    8
#define V_CT_TCP_OP_ISS_DRDY(x) ((x) << S_CT_TCP_OP_ISS_DRDY)
#define F_CT_TCP_OP_ISS_DRDY    V_CT_TCP_OP_ISS_DRDY(1U)

#define S_P2CSUMERROR_SRDY    7
#define V_P2CSUMERROR_SRDY(x) ((x) << S_P2CSUMERROR_SRDY)
#define F_P2CSUMERROR_SRDY    V_P2CSUMERROR_SRDY(1U)

#define S_P2CSUMERROR_DRDY    6
#define V_P2CSUMERROR_DRDY(x) ((x) << S_P2CSUMERROR_DRDY)
#define F_P2CSUMERROR_DRDY    V_P2CSUMERROR_DRDY(1U)

#define S_FIFO_ERROR_SRDY    5
#define V_FIFO_ERROR_SRDY(x) ((x) << S_FIFO_ERROR_SRDY)
#define F_FIFO_ERROR_SRDY    V_FIFO_ERROR_SRDY(1U)

#define S_FIFO_ERROR_DRDY    4
#define V_FIFO_ERROR_DRDY(x) ((x) << S_FIFO_ERROR_DRDY)
#define F_FIFO_ERROR_DRDY    V_FIFO_ERROR_DRDY(1U)

#define S_PLD_SRDY    3
#define V_PLD_SRDY(x) ((x) << S_PLD_SRDY)
#define F_PLD_SRDY    V_PLD_SRDY(1U)

#define S_PLD_DRDY    2
#define V_PLD_DRDY(x) ((x) << S_PLD_DRDY)
#define F_PLD_DRDY    V_PLD_DRDY(1U)

#define S_RX_PKT_ATTR_SRDY    1
#define V_RX_PKT_ATTR_SRDY(x) ((x) << S_RX_PKT_ATTR_SRDY)
#define F_RX_PKT_ATTR_SRDY    V_RX_PKT_ATTR_SRDY(1U)

#define S_RX_PKT_ATTR_DRDY    0
#define V_RX_PKT_ATTR_DRDY(x) ((x) << S_RX_PKT_ATTR_DRDY)
#define F_RX_PKT_ATTR_DRDY    V_RX_PKT_ATTR_DRDY(1U)

#define S_RXRUNT    25
#define V_RXRUNT(x) ((x) << S_RXRUNT)
#define F_RXRUNT    V_RXRUNT(1U)

#define S_RXRUNTPARSER    24
#define V_RXRUNTPARSER(x) ((x) << S_RXRUNTPARSER)
#define F_RXRUNTPARSER    V_RXRUNTPARSER(1U)

#define S_ERROR_SRDY    5
#define V_ERROR_SRDY(x) ((x) << S_ERROR_SRDY)
#define F_ERROR_SRDY    V_ERROR_SRDY(1U)

#define S_ERROR_DRDY    4
#define V_ERROR_DRDY(x) ((x) << S_ERROR_DRDY)
#define F_ERROR_DRDY    V_ERROR_DRDY(1U)

#define A_TP_DBG_ESIDE_IN1 0x14b
#define A_TP_DBG_ESIDE_IN2 0x14c
#define A_TP_DBG_ESIDE_IN3 0x14d
#define A_TP_DBG_ESIDE_FRM 0x14e

#define S_ERX2XERROR    28
#define M_ERX2XERROR    0xfU
#define V_ERX2XERROR(x) ((x) << S_ERX2XERROR)
#define G_ERX2XERROR(x) (((x) >> S_ERX2XERROR) & M_ERX2XERROR)

#define S_EPLDTX2XERROR    24
#define M_EPLDTX2XERROR    0xfU
#define V_EPLDTX2XERROR(x) ((x) << S_EPLDTX2XERROR)
#define G_EPLDTX2XERROR(x) (((x) >> S_EPLDTX2XERROR) & M_EPLDTX2XERROR)

#define S_ETXERROR    20
#define M_ETXERROR    0xfU
#define V_ETXERROR(x) ((x) << S_ETXERROR)
#define G_ETXERROR(x) (((x) >> S_ETXERROR) & M_ETXERROR)

#define S_EPLDRXERROR    16
#define M_EPLDRXERROR    0xfU
#define V_EPLDRXERROR(x) ((x) << S_EPLDRXERROR)
#define G_EPLDRXERROR(x) (((x) >> S_EPLDRXERROR) & M_EPLDRXERROR)

#define S_ERXSIZEERROR3    12
#define M_ERXSIZEERROR3    0xfU
#define V_ERXSIZEERROR3(x) ((x) << S_ERXSIZEERROR3)
#define G_ERXSIZEERROR3(x) (((x) >> S_ERXSIZEERROR3) & M_ERXSIZEERROR3)

#define S_ERXSIZEERROR2    8
#define M_ERXSIZEERROR2    0xfU
#define V_ERXSIZEERROR2(x) ((x) << S_ERXSIZEERROR2)
#define G_ERXSIZEERROR2(x) (((x) >> S_ERXSIZEERROR2) & M_ERXSIZEERROR2)

#define S_ERXSIZEERROR1    4
#define M_ERXSIZEERROR1    0xfU
#define V_ERXSIZEERROR1(x) ((x) << S_ERXSIZEERROR1)
#define G_ERXSIZEERROR1(x) (((x) >> S_ERXSIZEERROR1) & M_ERXSIZEERROR1)

#define S_ERXSIZEERROR0    0
#define M_ERXSIZEERROR0    0xfU
#define V_ERXSIZEERROR0(x) ((x) << S_ERXSIZEERROR0)
#define G_ERXSIZEERROR0(x) (((x) >> S_ERXSIZEERROR0) & M_ERXSIZEERROR0)

#define A_TP_DBG_ESIDE_DRP 0x14f

#define S_RXDROP3    24
#define M_RXDROP3    0xffU
#define V_RXDROP3(x) ((x) << S_RXDROP3)
#define G_RXDROP3(x) (((x) >> S_RXDROP3) & M_RXDROP3)

#define S_RXDROP2    16
#define M_RXDROP2    0xffU
#define V_RXDROP2(x) ((x) << S_RXDROP2)
#define G_RXDROP2(x) (((x) >> S_RXDROP2) & M_RXDROP2)

#define S_RXDROP1    8
#define M_RXDROP1    0xffU
#define V_RXDROP1(x) ((x) << S_RXDROP1)
#define G_RXDROP1(x) (((x) >> S_RXDROP1) & M_RXDROP1)

#define S_RXDROP0    0
#define M_RXDROP0    0xffU
#define V_RXDROP0(x) ((x) << S_RXDROP0)
#define G_RXDROP0(x) (((x) >> S_RXDROP0) & M_RXDROP0)

#define A_TP_DBG_ESIDE_TX 0x150

#define S_ETXVALID    4
#define M_ETXVALID    0xfU
#define V_ETXVALID(x) ((x) << S_ETXVALID)
#define G_ETXVALID(x) (((x) >> S_ETXVALID) & M_ETXVALID)

#define S_ETXFULL    0
#define M_ETXFULL    0xfU
#define V_ETXFULL(x) ((x) << S_ETXFULL)
#define G_ETXFULL(x) (((x) >> S_ETXFULL) & M_ETXFULL)

#define A_TP_ESIDE_SVID_MASK 0x151
#define A_TP_ESIDE_DVID_MASK 0x152
#define A_TP_ESIDE_ALIGN_MASK 0x153

#define S_USE_LOOP_BIT    24
#define V_USE_LOOP_BIT(x) ((x) << S_USE_LOOP_BIT)
#define F_USE_LOOP_BIT    V_USE_LOOP_BIT(1U)

#define S_LOOP_OFFSET    16
#define M_LOOP_OFFSET    0xffU
#define V_LOOP_OFFSET(x) ((x) << S_LOOP_OFFSET)
#define G_LOOP_OFFSET(x) (((x) >> S_LOOP_OFFSET) & M_LOOP_OFFSET)

#define S_DVID_ID_OFFSET    8
#define M_DVID_ID_OFFSET    0xffU
#define V_DVID_ID_OFFSET(x) ((x) << S_DVID_ID_OFFSET)
#define G_DVID_ID_OFFSET(x) (((x) >> S_DVID_ID_OFFSET) & M_DVID_ID_OFFSET)

#define S_SVID_ID_OFFSET    0
#define M_SVID_ID_OFFSET    0xffU
#define V_SVID_ID_OFFSET(x) ((x) << S_SVID_ID_OFFSET)
#define G_SVID_ID_OFFSET(x) (((x) >> S_SVID_ID_OFFSET) & M_SVID_ID_OFFSET)

#define A_TP_DBG_ESIDE_OP 0x154

#define S_OPT_PARSER_FATAL_CHANNEL0    29
#define V_OPT_PARSER_FATAL_CHANNEL0(x) ((x) << S_OPT_PARSER_FATAL_CHANNEL0)
#define F_OPT_PARSER_FATAL_CHANNEL0    V_OPT_PARSER_FATAL_CHANNEL0(1U)

#define S_OPT_PARSER_BUSY_CHANNEL0    28
#define V_OPT_PARSER_BUSY_CHANNEL0(x) ((x) << S_OPT_PARSER_BUSY_CHANNEL0)
#define F_OPT_PARSER_BUSY_CHANNEL0    V_OPT_PARSER_BUSY_CHANNEL0(1U)

#define S_OPT_PARSER_ITCP_STATE_CHANNEL0    26
#define M_OPT_PARSER_ITCP_STATE_CHANNEL0    0x3U
#define V_OPT_PARSER_ITCP_STATE_CHANNEL0(x) ((x) << S_OPT_PARSER_ITCP_STATE_CHANNEL0)
#define G_OPT_PARSER_ITCP_STATE_CHANNEL0(x) (((x) >> S_OPT_PARSER_ITCP_STATE_CHANNEL0) & M_OPT_PARSER_ITCP_STATE_CHANNEL0)

#define S_OPT_PARSER_OTK_STATE_CHANNEL0    24
#define M_OPT_PARSER_OTK_STATE_CHANNEL0    0x3U
#define V_OPT_PARSER_OTK_STATE_CHANNEL0(x) ((x) << S_OPT_PARSER_OTK_STATE_CHANNEL0)
#define G_OPT_PARSER_OTK_STATE_CHANNEL0(x) (((x) >> S_OPT_PARSER_OTK_STATE_CHANNEL0) & M_OPT_PARSER_OTK_STATE_CHANNEL0)

#define S_OPT_PARSER_FATAL_CHANNEL1    21
#define V_OPT_PARSER_FATAL_CHANNEL1(x) ((x) << S_OPT_PARSER_FATAL_CHANNEL1)
#define F_OPT_PARSER_FATAL_CHANNEL1    V_OPT_PARSER_FATAL_CHANNEL1(1U)

#define S_OPT_PARSER_BUSY_CHANNEL1    20
#define V_OPT_PARSER_BUSY_CHANNEL1(x) ((x) << S_OPT_PARSER_BUSY_CHANNEL1)
#define F_OPT_PARSER_BUSY_CHANNEL1    V_OPT_PARSER_BUSY_CHANNEL1(1U)

#define S_OPT_PARSER_ITCP_STATE_CHANNEL1    18
#define M_OPT_PARSER_ITCP_STATE_CHANNEL1    0x3U
#define V_OPT_PARSER_ITCP_STATE_CHANNEL1(x) ((x) << S_OPT_PARSER_ITCP_STATE_CHANNEL1)
#define G_OPT_PARSER_ITCP_STATE_CHANNEL1(x) (((x) >> S_OPT_PARSER_ITCP_STATE_CHANNEL1) & M_OPT_PARSER_ITCP_STATE_CHANNEL1)

#define S_OPT_PARSER_OTK_STATE_CHANNEL1    16
#define M_OPT_PARSER_OTK_STATE_CHANNEL1    0x3U
#define V_OPT_PARSER_OTK_STATE_CHANNEL1(x) ((x) << S_OPT_PARSER_OTK_STATE_CHANNEL1)
#define G_OPT_PARSER_OTK_STATE_CHANNEL1(x) (((x) >> S_OPT_PARSER_OTK_STATE_CHANNEL1) & M_OPT_PARSER_OTK_STATE_CHANNEL1)

#define S_OPT_PARSER_FATAL_CHANNEL2    13
#define V_OPT_PARSER_FATAL_CHANNEL2(x) ((x) << S_OPT_PARSER_FATAL_CHANNEL2)
#define F_OPT_PARSER_FATAL_CHANNEL2    V_OPT_PARSER_FATAL_CHANNEL2(1U)

#define S_OPT_PARSER_BUSY_CHANNEL2    12
#define V_OPT_PARSER_BUSY_CHANNEL2(x) ((x) << S_OPT_PARSER_BUSY_CHANNEL2)
#define F_OPT_PARSER_BUSY_CHANNEL2    V_OPT_PARSER_BUSY_CHANNEL2(1U)

#define S_OPT_PARSER_ITCP_STATE_CHANNEL2    10
#define M_OPT_PARSER_ITCP_STATE_CHANNEL2    0x3U
#define V_OPT_PARSER_ITCP_STATE_CHANNEL2(x) ((x) << S_OPT_PARSER_ITCP_STATE_CHANNEL2)
#define G_OPT_PARSER_ITCP_STATE_CHANNEL2(x) (((x) >> S_OPT_PARSER_ITCP_STATE_CHANNEL2) & M_OPT_PARSER_ITCP_STATE_CHANNEL2)

#define S_OPT_PARSER_OTK_STATE_CHANNEL2    8
#define M_OPT_PARSER_OTK_STATE_CHANNEL2    0x3U
#define V_OPT_PARSER_OTK_STATE_CHANNEL2(x) ((x) << S_OPT_PARSER_OTK_STATE_CHANNEL2)
#define G_OPT_PARSER_OTK_STATE_CHANNEL2(x) (((x) >> S_OPT_PARSER_OTK_STATE_CHANNEL2) & M_OPT_PARSER_OTK_STATE_CHANNEL2)

#define S_OPT_PARSER_FATAL_CHANNEL3    5
#define V_OPT_PARSER_FATAL_CHANNEL3(x) ((x) << S_OPT_PARSER_FATAL_CHANNEL3)
#define F_OPT_PARSER_FATAL_CHANNEL3    V_OPT_PARSER_FATAL_CHANNEL3(1U)

#define S_OPT_PARSER_BUSY_CHANNEL3    4
#define V_OPT_PARSER_BUSY_CHANNEL3(x) ((x) << S_OPT_PARSER_BUSY_CHANNEL3)
#define F_OPT_PARSER_BUSY_CHANNEL3    V_OPT_PARSER_BUSY_CHANNEL3(1U)

#define S_OPT_PARSER_ITCP_STATE_CHANNEL3    2
#define M_OPT_PARSER_ITCP_STATE_CHANNEL3    0x3U
#define V_OPT_PARSER_ITCP_STATE_CHANNEL3(x) ((x) << S_OPT_PARSER_ITCP_STATE_CHANNEL3)
#define G_OPT_PARSER_ITCP_STATE_CHANNEL3(x) (((x) >> S_OPT_PARSER_ITCP_STATE_CHANNEL3) & M_OPT_PARSER_ITCP_STATE_CHANNEL3)

#define S_OPT_PARSER_OTK_STATE_CHANNEL3    0
#define M_OPT_PARSER_OTK_STATE_CHANNEL3    0x3U
#define V_OPT_PARSER_OTK_STATE_CHANNEL3(x) ((x) << S_OPT_PARSER_OTK_STATE_CHANNEL3)
#define G_OPT_PARSER_OTK_STATE_CHANNEL3(x) (((x) >> S_OPT_PARSER_OTK_STATE_CHANNEL3) & M_OPT_PARSER_OTK_STATE_CHANNEL3)

#define A_TP_DBG_ESIDE_OP_ALT 0x155

#define S_OPT_PARSER_PSTATE_FATAL_CHANNEL0    29
#define V_OPT_PARSER_PSTATE_FATAL_CHANNEL0(x) ((x) << S_OPT_PARSER_PSTATE_FATAL_CHANNEL0)
#define F_OPT_PARSER_PSTATE_FATAL_CHANNEL0    V_OPT_PARSER_PSTATE_FATAL_CHANNEL0(1U)

#define S_OPT_PARSER_PSTATE_ERRNO_CHANNEL0    24
#define M_OPT_PARSER_PSTATE_ERRNO_CHANNEL0    0x1fU
#define V_OPT_PARSER_PSTATE_ERRNO_CHANNEL0(x) ((x) << S_OPT_PARSER_PSTATE_ERRNO_CHANNEL0)
#define G_OPT_PARSER_PSTATE_ERRNO_CHANNEL0(x) (((x) >> S_OPT_PARSER_PSTATE_ERRNO_CHANNEL0) & M_OPT_PARSER_PSTATE_ERRNO_CHANNEL0)

#define S_OPT_PARSER_PSTATE_FATAL_CHANNEL1    21
#define V_OPT_PARSER_PSTATE_FATAL_CHANNEL1(x) ((x) << S_OPT_PARSER_PSTATE_FATAL_CHANNEL1)
#define F_OPT_PARSER_PSTATE_FATAL_CHANNEL1    V_OPT_PARSER_PSTATE_FATAL_CHANNEL1(1U)

#define S_OPT_PARSER_PSTATE_ERRNO_CHANNEL1    16
#define M_OPT_PARSER_PSTATE_ERRNO_CHANNEL1    0x1fU
#define V_OPT_PARSER_PSTATE_ERRNO_CHANNEL1(x) ((x) << S_OPT_PARSER_PSTATE_ERRNO_CHANNEL1)
#define G_OPT_PARSER_PSTATE_ERRNO_CHANNEL1(x) (((x) >> S_OPT_PARSER_PSTATE_ERRNO_CHANNEL1) & M_OPT_PARSER_PSTATE_ERRNO_CHANNEL1)

#define S_OPT_PARSER_PSTATE_FATAL_CHANNEL2    13
#define V_OPT_PARSER_PSTATE_FATAL_CHANNEL2(x) ((x) << S_OPT_PARSER_PSTATE_FATAL_CHANNEL2)
#define F_OPT_PARSER_PSTATE_FATAL_CHANNEL2    V_OPT_PARSER_PSTATE_FATAL_CHANNEL2(1U)

#define S_OPT_PARSER_PSTATE_ERRNO_CHANNEL2    8
#define M_OPT_PARSER_PSTATE_ERRNO_CHANNEL2    0x1fU
#define V_OPT_PARSER_PSTATE_ERRNO_CHANNEL2(x) ((x) << S_OPT_PARSER_PSTATE_ERRNO_CHANNEL2)
#define G_OPT_PARSER_PSTATE_ERRNO_CHANNEL2(x) (((x) >> S_OPT_PARSER_PSTATE_ERRNO_CHANNEL2) & M_OPT_PARSER_PSTATE_ERRNO_CHANNEL2)

#define S_OPT_PARSER_PSTATE_FATAL_CHANNEL3    5
#define V_OPT_PARSER_PSTATE_FATAL_CHANNEL3(x) ((x) << S_OPT_PARSER_PSTATE_FATAL_CHANNEL3)
#define F_OPT_PARSER_PSTATE_FATAL_CHANNEL3    V_OPT_PARSER_PSTATE_FATAL_CHANNEL3(1U)

#define S_OPT_PARSER_PSTATE_ERRNO_CHANNEL3    0
#define M_OPT_PARSER_PSTATE_ERRNO_CHANNEL3    0x1fU
#define V_OPT_PARSER_PSTATE_ERRNO_CHANNEL3(x) ((x) << S_OPT_PARSER_PSTATE_ERRNO_CHANNEL3)
#define G_OPT_PARSER_PSTATE_ERRNO_CHANNEL3(x) (((x) >> S_OPT_PARSER_PSTATE_ERRNO_CHANNEL3) & M_OPT_PARSER_PSTATE_ERRNO_CHANNEL3)

#define A_TP_DBG_ESIDE_OP_BUSY 0x156

#define S_OPT_PARSER_BUSY_VEC_CHANNEL3    24
#define M_OPT_PARSER_BUSY_VEC_CHANNEL3    0xffU
#define V_OPT_PARSER_BUSY_VEC_CHANNEL3(x) ((x) << S_OPT_PARSER_BUSY_VEC_CHANNEL3)
#define G_OPT_PARSER_BUSY_VEC_CHANNEL3(x) (((x) >> S_OPT_PARSER_BUSY_VEC_CHANNEL3) & M_OPT_PARSER_BUSY_VEC_CHANNEL3)

#define S_OPT_PARSER_BUSY_VEC_CHANNEL2    16
#define M_OPT_PARSER_BUSY_VEC_CHANNEL2    0xffU
#define V_OPT_PARSER_BUSY_VEC_CHANNEL2(x) ((x) << S_OPT_PARSER_BUSY_VEC_CHANNEL2)
#define G_OPT_PARSER_BUSY_VEC_CHANNEL2(x) (((x) >> S_OPT_PARSER_BUSY_VEC_CHANNEL2) & M_OPT_PARSER_BUSY_VEC_CHANNEL2)

#define S_OPT_PARSER_BUSY_VEC_CHANNEL1    8
#define M_OPT_PARSER_BUSY_VEC_CHANNEL1    0xffU
#define V_OPT_PARSER_BUSY_VEC_CHANNEL1(x) ((x) << S_OPT_PARSER_BUSY_VEC_CHANNEL1)
#define G_OPT_PARSER_BUSY_VEC_CHANNEL1(x) (((x) >> S_OPT_PARSER_BUSY_VEC_CHANNEL1) & M_OPT_PARSER_BUSY_VEC_CHANNEL1)

#define S_OPT_PARSER_BUSY_VEC_CHANNEL0    0
#define M_OPT_PARSER_BUSY_VEC_CHANNEL0    0xffU
#define V_OPT_PARSER_BUSY_VEC_CHANNEL0(x) ((x) << S_OPT_PARSER_BUSY_VEC_CHANNEL0)
#define G_OPT_PARSER_BUSY_VEC_CHANNEL0(x) (((x) >> S_OPT_PARSER_BUSY_VEC_CHANNEL0) & M_OPT_PARSER_BUSY_VEC_CHANNEL0)

#define A_TP_DBG_ESIDE_OP_COOKIE 0x157

#define S_OPT_PARSER_COOKIE_CHANNEL3    24
#define M_OPT_PARSER_COOKIE_CHANNEL3    0xffU
#define V_OPT_PARSER_COOKIE_CHANNEL3(x) ((x) << S_OPT_PARSER_COOKIE_CHANNEL3)
#define G_OPT_PARSER_COOKIE_CHANNEL3(x) (((x) >> S_OPT_PARSER_COOKIE_CHANNEL3) & M_OPT_PARSER_COOKIE_CHANNEL3)

#define S_OPT_PARSER_COOKIE_CHANNEL2    16
#define M_OPT_PARSER_COOKIE_CHANNEL2    0xffU
#define V_OPT_PARSER_COOKIE_CHANNEL2(x) ((x) << S_OPT_PARSER_COOKIE_CHANNEL2)
#define G_OPT_PARSER_COOKIE_CHANNEL2(x) (((x) >> S_OPT_PARSER_COOKIE_CHANNEL2) & M_OPT_PARSER_COOKIE_CHANNEL2)

#define S_OPT_PARSER_COOKIE_CHANNEL1    8
#define M_OPT_PARSER_COOKIE_CHANNEL1    0xffU
#define V_OPT_PARSER_COOKIE_CHANNEL1(x) ((x) << S_OPT_PARSER_COOKIE_CHANNEL1)
#define G_OPT_PARSER_COOKIE_CHANNEL1(x) (((x) >> S_OPT_PARSER_COOKIE_CHANNEL1) & M_OPT_PARSER_COOKIE_CHANNEL1)

#define S_OPT_PARSER_COOKIE_CHANNEL0    0
#define M_OPT_PARSER_COOKIE_CHANNEL0    0xffU
#define V_OPT_PARSER_COOKIE_CHANNEL0(x) ((x) << S_OPT_PARSER_COOKIE_CHANNEL0)
#define G_OPT_PARSER_COOKIE_CHANNEL0(x) (((x) >> S_OPT_PARSER_COOKIE_CHANNEL0) & M_OPT_PARSER_COOKIE_CHANNEL0)

#define A_TP_DBG_CSIDE_RX0 0x230

#define S_CRXSOPCNT    28
#define M_CRXSOPCNT    0xfU
#define V_CRXSOPCNT(x) ((x) << S_CRXSOPCNT)
#define G_CRXSOPCNT(x) (((x) >> S_CRXSOPCNT) & M_CRXSOPCNT)

#define S_CRXEOPCNT    24
#define M_CRXEOPCNT    0xfU
#define V_CRXEOPCNT(x) ((x) << S_CRXEOPCNT)
#define G_CRXEOPCNT(x) (((x) >> S_CRXEOPCNT) & M_CRXEOPCNT)

#define S_CRXPLDSOPCNT    20
#define M_CRXPLDSOPCNT    0xfU
#define V_CRXPLDSOPCNT(x) ((x) << S_CRXPLDSOPCNT)
#define G_CRXPLDSOPCNT(x) (((x) >> S_CRXPLDSOPCNT) & M_CRXPLDSOPCNT)

#define S_CRXPLDEOPCNT    16
#define M_CRXPLDEOPCNT    0xfU
#define V_CRXPLDEOPCNT(x) ((x) << S_CRXPLDEOPCNT)
#define G_CRXPLDEOPCNT(x) (((x) >> S_CRXPLDEOPCNT) & M_CRXPLDEOPCNT)

#define S_CRXARBSOPCNT    12
#define M_CRXARBSOPCNT    0xfU
#define V_CRXARBSOPCNT(x) ((x) << S_CRXARBSOPCNT)
#define G_CRXARBSOPCNT(x) (((x) >> S_CRXARBSOPCNT) & M_CRXARBSOPCNT)

#define S_CRXARBEOPCNT    8
#define M_CRXARBEOPCNT    0xfU
#define V_CRXARBEOPCNT(x) ((x) << S_CRXARBEOPCNT)
#define G_CRXARBEOPCNT(x) (((x) >> S_CRXARBEOPCNT) & M_CRXARBEOPCNT)

#define S_CRXCPLSOPCNT    4
#define M_CRXCPLSOPCNT    0xfU
#define V_CRXCPLSOPCNT(x) ((x) << S_CRXCPLSOPCNT)
#define G_CRXCPLSOPCNT(x) (((x) >> S_CRXCPLSOPCNT) & M_CRXCPLSOPCNT)

#define S_CRXCPLEOPCNT    0
#define M_CRXCPLEOPCNT    0xfU
#define V_CRXCPLEOPCNT(x) ((x) << S_CRXCPLEOPCNT)
#define G_CRXCPLEOPCNT(x) (((x) >> S_CRXCPLEOPCNT) & M_CRXCPLEOPCNT)

#define A_TP_DBG_CSIDE_RX1 0x231
#define A_TP_DBG_CSIDE_RX2 0x232
#define A_TP_DBG_CSIDE_RX3 0x233
#define A_TP_DBG_CSIDE_TX0 0x234

#define S_TXSOPCNT    28
#define M_TXSOPCNT    0xfU
#define V_TXSOPCNT(x) ((x) << S_TXSOPCNT)
#define G_TXSOPCNT(x) (((x) >> S_TXSOPCNT) & M_TXSOPCNT)

#define S_TXEOPCNT    24
#define M_TXEOPCNT    0xfU
#define V_TXEOPCNT(x) ((x) << S_TXEOPCNT)
#define G_TXEOPCNT(x) (((x) >> S_TXEOPCNT) & M_TXEOPCNT)

#define S_TXPLDSOPCNT    20
#define M_TXPLDSOPCNT    0xfU
#define V_TXPLDSOPCNT(x) ((x) << S_TXPLDSOPCNT)
#define G_TXPLDSOPCNT(x) (((x) >> S_TXPLDSOPCNT) & M_TXPLDSOPCNT)

#define S_TXPLDEOPCNT    16
#define M_TXPLDEOPCNT    0xfU
#define V_TXPLDEOPCNT(x) ((x) << S_TXPLDEOPCNT)
#define G_TXPLDEOPCNT(x) (((x) >> S_TXPLDEOPCNT) & M_TXPLDEOPCNT)

#define S_TXARBSOPCNT    12
#define M_TXARBSOPCNT    0xfU
#define V_TXARBSOPCNT(x) ((x) << S_TXARBSOPCNT)
#define G_TXARBSOPCNT(x) (((x) >> S_TXARBSOPCNT) & M_TXARBSOPCNT)

#define S_TXARBEOPCNT    8
#define M_TXARBEOPCNT    0xfU
#define V_TXARBEOPCNT(x) ((x) << S_TXARBEOPCNT)
#define G_TXARBEOPCNT(x) (((x) >> S_TXARBEOPCNT) & M_TXARBEOPCNT)

#define S_TXCPLSOPCNT    4
#define M_TXCPLSOPCNT    0xfU
#define V_TXCPLSOPCNT(x) ((x) << S_TXCPLSOPCNT)
#define G_TXCPLSOPCNT(x) (((x) >> S_TXCPLSOPCNT) & M_TXCPLSOPCNT)

#define S_TXCPLEOPCNT    0
#define M_TXCPLEOPCNT    0xfU
#define V_TXCPLEOPCNT(x) ((x) << S_TXCPLEOPCNT)
#define G_TXCPLEOPCNT(x) (((x) >> S_TXCPLEOPCNT) & M_TXCPLEOPCNT)

#define A_TP_DBG_CSIDE_TX1 0x235
#define A_TP_DBG_CSIDE_TX2 0x236
#define A_TP_DBG_CSIDE_TX3 0x237
#define A_TP_DBG_CSIDE_FIFO0 0x238

#define S_PLD_RXZEROP_SRDY1    31
#define V_PLD_RXZEROP_SRDY1(x) ((x) << S_PLD_RXZEROP_SRDY1)
#define F_PLD_RXZEROP_SRDY1    V_PLD_RXZEROP_SRDY1(1U)

#define S_PLD_RXZEROP_DRDY1    30
#define V_PLD_RXZEROP_DRDY1(x) ((x) << S_PLD_RXZEROP_DRDY1)
#define F_PLD_RXZEROP_DRDY1    V_PLD_RXZEROP_DRDY1(1U)

#define S_PLD_TXZEROP_SRDY1    29
#define V_PLD_TXZEROP_SRDY1(x) ((x) << S_PLD_TXZEROP_SRDY1)
#define F_PLD_TXZEROP_SRDY1    V_PLD_TXZEROP_SRDY1(1U)

#define S_PLD_TXZEROP_DRDY1    28
#define V_PLD_TXZEROP_DRDY1(x) ((x) << S_PLD_TXZEROP_DRDY1)
#define F_PLD_TXZEROP_DRDY1    V_PLD_TXZEROP_DRDY1(1U)

#define S_PLD_TX_SRDY1    27
#define V_PLD_TX_SRDY1(x) ((x) << S_PLD_TX_SRDY1)
#define F_PLD_TX_SRDY1    V_PLD_TX_SRDY1(1U)

#define S_PLD_TX_DRDY1    26
#define V_PLD_TX_DRDY1(x) ((x) << S_PLD_TX_DRDY1)
#define F_PLD_TX_DRDY1    V_PLD_TX_DRDY1(1U)

#define S_ERROR_SRDY1    25
#define V_ERROR_SRDY1(x) ((x) << S_ERROR_SRDY1)
#define F_ERROR_SRDY1    V_ERROR_SRDY1(1U)

#define S_ERROR_DRDY1    24
#define V_ERROR_DRDY1(x) ((x) << S_ERROR_DRDY1)
#define F_ERROR_DRDY1    V_ERROR_DRDY1(1U)

#define S_DB_VLD1    23
#define V_DB_VLD1(x) ((x) << S_DB_VLD1)
#define F_DB_VLD1    V_DB_VLD1(1U)

#define S_DB_GT1    22
#define V_DB_GT1(x) ((x) << S_DB_GT1)
#define F_DB_GT1    V_DB_GT1(1U)

#define S_TXVALID1    21
#define V_TXVALID1(x) ((x) << S_TXVALID1)
#define F_TXVALID1    V_TXVALID1(1U)

#define S_TXFULL1    20
#define V_TXFULL1(x) ((x) << S_TXFULL1)
#define F_TXFULL1    V_TXFULL1(1U)

#define S_PLD_TXVALID1    19
#define V_PLD_TXVALID1(x) ((x) << S_PLD_TXVALID1)
#define F_PLD_TXVALID1    V_PLD_TXVALID1(1U)

#define S_PLD_TXFULL1    18
#define V_PLD_TXFULL1(x) ((x) << S_PLD_TXFULL1)
#define F_PLD_TXFULL1    V_PLD_TXFULL1(1U)

#define S_CPL5_TXVALID1    17
#define V_CPL5_TXVALID1(x) ((x) << S_CPL5_TXVALID1)
#define F_CPL5_TXVALID1    V_CPL5_TXVALID1(1U)

#define S_CPL5_TXFULL1    16
#define V_CPL5_TXFULL1(x) ((x) << S_CPL5_TXFULL1)
#define F_CPL5_TXFULL1    V_CPL5_TXFULL1(1U)

#define S_PLD_RXZEROP_SRDY0    15
#define V_PLD_RXZEROP_SRDY0(x) ((x) << S_PLD_RXZEROP_SRDY0)
#define F_PLD_RXZEROP_SRDY0    V_PLD_RXZEROP_SRDY0(1U)

#define S_PLD_RXZEROP_DRDY0    14
#define V_PLD_RXZEROP_DRDY0(x) ((x) << S_PLD_RXZEROP_DRDY0)
#define F_PLD_RXZEROP_DRDY0    V_PLD_RXZEROP_DRDY0(1U)

#define S_PLD_TXZEROP_SRDY0    13
#define V_PLD_TXZEROP_SRDY0(x) ((x) << S_PLD_TXZEROP_SRDY0)
#define F_PLD_TXZEROP_SRDY0    V_PLD_TXZEROP_SRDY0(1U)

#define S_PLD_TXZEROP_DRDY0    12
#define V_PLD_TXZEROP_DRDY0(x) ((x) << S_PLD_TXZEROP_DRDY0)
#define F_PLD_TXZEROP_DRDY0    V_PLD_TXZEROP_DRDY0(1U)

#define S_PLD_TX_SRDY0    11
#define V_PLD_TX_SRDY0(x) ((x) << S_PLD_TX_SRDY0)
#define F_PLD_TX_SRDY0    V_PLD_TX_SRDY0(1U)

#define S_PLD_TX_DRDY0    10
#define V_PLD_TX_DRDY0(x) ((x) << S_PLD_TX_DRDY0)
#define F_PLD_TX_DRDY0    V_PLD_TX_DRDY0(1U)

#define S_ERROR_SRDY0    9
#define V_ERROR_SRDY0(x) ((x) << S_ERROR_SRDY0)
#define F_ERROR_SRDY0    V_ERROR_SRDY0(1U)

#define S_ERROR_DRDY0    8
#define V_ERROR_DRDY0(x) ((x) << S_ERROR_DRDY0)
#define F_ERROR_DRDY0    V_ERROR_DRDY0(1U)

#define S_DB_VLD0    7
#define V_DB_VLD0(x) ((x) << S_DB_VLD0)
#define F_DB_VLD0    V_DB_VLD0(1U)

#define S_DB_GT0    6
#define V_DB_GT0(x) ((x) << S_DB_GT0)
#define F_DB_GT0    V_DB_GT0(1U)

#define S_TXVALID0    5
#define V_TXVALID0(x) ((x) << S_TXVALID0)
#define F_TXVALID0    V_TXVALID0(1U)

#define S_TXFULL0    4
#define V_TXFULL0(x) ((x) << S_TXFULL0)
#define F_TXFULL0    V_TXFULL0(1U)

#define S_PLD_TXVALID0    3
#define V_PLD_TXVALID0(x) ((x) << S_PLD_TXVALID0)
#define F_PLD_TXVALID0    V_PLD_TXVALID0(1U)

#define S_PLD_TXFULL0    2
#define V_PLD_TXFULL0(x) ((x) << S_PLD_TXFULL0)
#define F_PLD_TXFULL0    V_PLD_TXFULL0(1U)

#define S_CPL5_TXVALID0    1
#define V_CPL5_TXVALID0(x) ((x) << S_CPL5_TXVALID0)
#define F_CPL5_TXVALID0    V_CPL5_TXVALID0(1U)

#define S_CPL5_TXFULL0    0
#define V_CPL5_TXFULL0(x) ((x) << S_CPL5_TXFULL0)
#define F_CPL5_TXFULL0    V_CPL5_TXFULL0(1U)

#define A_TP_DBG_CSIDE_FIFO1 0x239

#define S_PLD_RXZEROP_SRDY3    31
#define V_PLD_RXZEROP_SRDY3(x) ((x) << S_PLD_RXZEROP_SRDY3)
#define F_PLD_RXZEROP_SRDY3    V_PLD_RXZEROP_SRDY3(1U)

#define S_PLD_RXZEROP_DRDY3    30
#define V_PLD_RXZEROP_DRDY3(x) ((x) << S_PLD_RXZEROP_DRDY3)
#define F_PLD_RXZEROP_DRDY3    V_PLD_RXZEROP_DRDY3(1U)

#define S_PLD_TXZEROP_SRDY3    29
#define V_PLD_TXZEROP_SRDY3(x) ((x) << S_PLD_TXZEROP_SRDY3)
#define F_PLD_TXZEROP_SRDY3    V_PLD_TXZEROP_SRDY3(1U)

#define S_PLD_TXZEROP_DRDY3    28
#define V_PLD_TXZEROP_DRDY3(x) ((x) << S_PLD_TXZEROP_DRDY3)
#define F_PLD_TXZEROP_DRDY3    V_PLD_TXZEROP_DRDY3(1U)

#define S_PLD_TX_SRDY3    27
#define V_PLD_TX_SRDY3(x) ((x) << S_PLD_TX_SRDY3)
#define F_PLD_TX_SRDY3    V_PLD_TX_SRDY3(1U)

#define S_PLD_TX_DRDY3    26
#define V_PLD_TX_DRDY3(x) ((x) << S_PLD_TX_DRDY3)
#define F_PLD_TX_DRDY3    V_PLD_TX_DRDY3(1U)

#define S_ERROR_SRDY3    25
#define V_ERROR_SRDY3(x) ((x) << S_ERROR_SRDY3)
#define F_ERROR_SRDY3    V_ERROR_SRDY3(1U)

#define S_ERROR_DRDY3    24
#define V_ERROR_DRDY3(x) ((x) << S_ERROR_DRDY3)
#define F_ERROR_DRDY3    V_ERROR_DRDY3(1U)

#define S_DB_VLD3    23
#define V_DB_VLD3(x) ((x) << S_DB_VLD3)
#define F_DB_VLD3    V_DB_VLD3(1U)

#define S_DB_GT3    22
#define V_DB_GT3(x) ((x) << S_DB_GT3)
#define F_DB_GT3    V_DB_GT3(1U)

#define S_TXVALID3    21
#define V_TXVALID3(x) ((x) << S_TXVALID3)
#define F_TXVALID3    V_TXVALID3(1U)

#define S_TXFULL3    20
#define V_TXFULL3(x) ((x) << S_TXFULL3)
#define F_TXFULL3    V_TXFULL3(1U)

#define S_PLD_TXVALID3    19
#define V_PLD_TXVALID3(x) ((x) << S_PLD_TXVALID3)
#define F_PLD_TXVALID3    V_PLD_TXVALID3(1U)

#define S_PLD_TXFULL3    18
#define V_PLD_TXFULL3(x) ((x) << S_PLD_TXFULL3)
#define F_PLD_TXFULL3    V_PLD_TXFULL3(1U)

#define S_CPL5_TXVALID3    17
#define V_CPL5_TXVALID3(x) ((x) << S_CPL5_TXVALID3)
#define F_CPL5_TXVALID3    V_CPL5_TXVALID3(1U)

#define S_CPL5_TXFULL3    16
#define V_CPL5_TXFULL3(x) ((x) << S_CPL5_TXFULL3)
#define F_CPL5_TXFULL3    V_CPL5_TXFULL3(1U)

#define S_PLD_RXZEROP_SRDY2    15
#define V_PLD_RXZEROP_SRDY2(x) ((x) << S_PLD_RXZEROP_SRDY2)
#define F_PLD_RXZEROP_SRDY2    V_PLD_RXZEROP_SRDY2(1U)

#define S_PLD_RXZEROP_DRDY2    14
#define V_PLD_RXZEROP_DRDY2(x) ((x) << S_PLD_RXZEROP_DRDY2)
#define F_PLD_RXZEROP_DRDY2    V_PLD_RXZEROP_DRDY2(1U)

#define S_PLD_TXZEROP_SRDY2    13
#define V_PLD_TXZEROP_SRDY2(x) ((x) << S_PLD_TXZEROP_SRDY2)
#define F_PLD_TXZEROP_SRDY2    V_PLD_TXZEROP_SRDY2(1U)

#define S_PLD_TXZEROP_DRDY2    12
#define V_PLD_TXZEROP_DRDY2(x) ((x) << S_PLD_TXZEROP_DRDY2)
#define F_PLD_TXZEROP_DRDY2    V_PLD_TXZEROP_DRDY2(1U)

#define S_PLD_TX_SRDY2    11
#define V_PLD_TX_SRDY2(x) ((x) << S_PLD_TX_SRDY2)
#define F_PLD_TX_SRDY2    V_PLD_TX_SRDY2(1U)

#define S_PLD_TX_DRDY2    10
#define V_PLD_TX_DRDY2(x) ((x) << S_PLD_TX_DRDY2)
#define F_PLD_TX_DRDY2    V_PLD_TX_DRDY2(1U)

#define S_ERROR_SRDY2    9
#define V_ERROR_SRDY2(x) ((x) << S_ERROR_SRDY2)
#define F_ERROR_SRDY2    V_ERROR_SRDY2(1U)

#define S_ERROR_DRDY2    8
#define V_ERROR_DRDY2(x) ((x) << S_ERROR_DRDY2)
#define F_ERROR_DRDY2    V_ERROR_DRDY2(1U)

#define S_DB_VLD2    7
#define V_DB_VLD2(x) ((x) << S_DB_VLD2)
#define F_DB_VLD2    V_DB_VLD2(1U)

#define S_DB_GT2    6
#define V_DB_GT2(x) ((x) << S_DB_GT2)
#define F_DB_GT2    V_DB_GT2(1U)

#define S_TXVALID2    5
#define V_TXVALID2(x) ((x) << S_TXVALID2)
#define F_TXVALID2    V_TXVALID2(1U)

#define S_TXFULL2    4
#define V_TXFULL2(x) ((x) << S_TXFULL2)
#define F_TXFULL2    V_TXFULL2(1U)

#define S_PLD_TXVALID2    3
#define V_PLD_TXVALID2(x) ((x) << S_PLD_TXVALID2)
#define F_PLD_TXVALID2    V_PLD_TXVALID2(1U)

#define S_PLD_TXFULL2    2
#define V_PLD_TXFULL2(x) ((x) << S_PLD_TXFULL2)
#define F_PLD_TXFULL2    V_PLD_TXFULL2(1U)

#define S_CPL5_TXVALID2    1
#define V_CPL5_TXVALID2(x) ((x) << S_CPL5_TXVALID2)
#define F_CPL5_TXVALID2    V_CPL5_TXVALID2(1U)

#define S_CPL5_TXFULL2    0
#define V_CPL5_TXFULL2(x) ((x) << S_CPL5_TXFULL2)
#define F_CPL5_TXFULL2    V_CPL5_TXFULL2(1U)

#define A_TP_DBG_CSIDE_DISP0 0x23a

#define S_CPL5RXVALID    27
#define V_CPL5RXVALID(x) ((x) << S_CPL5RXVALID)
#define F_CPL5RXVALID    V_CPL5RXVALID(1U)

#define S_CSTATIC1    26
#define V_CSTATIC1(x) ((x) << S_CSTATIC1)
#define F_CSTATIC1    V_CSTATIC1(1U)

#define S_CSTATIC2    25
#define V_CSTATIC2(x) ((x) << S_CSTATIC2)
#define F_CSTATIC2    V_CSTATIC2(1U)

#define S_PLD_RXZEROP    24
#define V_PLD_RXZEROP(x) ((x) << S_PLD_RXZEROP)
#define F_PLD_RXZEROP    V_PLD_RXZEROP(1U)

#define S_DDP_IN_PROGRESS    23
#define V_DDP_IN_PROGRESS(x) ((x) << S_DDP_IN_PROGRESS)
#define F_DDP_IN_PROGRESS    V_DDP_IN_PROGRESS(1U)

#define S_PLD_RXZEROP_SRDY    22
#define V_PLD_RXZEROP_SRDY(x) ((x) << S_PLD_RXZEROP_SRDY)
#define F_PLD_RXZEROP_SRDY    V_PLD_RXZEROP_SRDY(1U)

#define S_CSTATIC3    21
#define V_CSTATIC3(x) ((x) << S_CSTATIC3)
#define F_CSTATIC3    V_CSTATIC3(1U)

#define S_DDP_DRDY    20
#define V_DDP_DRDY(x) ((x) << S_DDP_DRDY)
#define F_DDP_DRDY    V_DDP_DRDY(1U)

#define S_DDP_PRE_STATE    17
#define M_DDP_PRE_STATE    0x7U
#define V_DDP_PRE_STATE(x) ((x) << S_DDP_PRE_STATE)
#define G_DDP_PRE_STATE(x) (((x) >> S_DDP_PRE_STATE) & M_DDP_PRE_STATE)

#define S_DDP_SRDY    16
#define V_DDP_SRDY(x) ((x) << S_DDP_SRDY)
#define F_DDP_SRDY    V_DDP_SRDY(1U)

#define S_DDP_MSG_CODE    12
#define M_DDP_MSG_CODE    0xfU
#define V_DDP_MSG_CODE(x) ((x) << S_DDP_MSG_CODE)
#define G_DDP_MSG_CODE(x) (((x) >> S_DDP_MSG_CODE) & M_DDP_MSG_CODE)

#define S_CPL5_SOCP_CNT    10
#define M_CPL5_SOCP_CNT    0x3U
#define V_CPL5_SOCP_CNT(x) ((x) << S_CPL5_SOCP_CNT)
#define G_CPL5_SOCP_CNT(x) (((x) >> S_CPL5_SOCP_CNT) & M_CPL5_SOCP_CNT)

#define S_CSTATIC4    4
#define M_CSTATIC4    0x3fU
#define V_CSTATIC4(x) ((x) << S_CSTATIC4)
#define G_CSTATIC4(x) (((x) >> S_CSTATIC4) & M_CSTATIC4)

#define S_CMD_SEL    1
#define V_CMD_SEL(x) ((x) << S_CMD_SEL)
#define F_CMD_SEL    V_CMD_SEL(1U)

#define S_CPL5RXFULL    26
#define V_CPL5RXFULL(x) ((x) << S_CPL5RXFULL)
#define F_CPL5RXFULL    V_CPL5RXFULL(1U)

#define S_PLD2XRXVALID    23
#define V_PLD2XRXVALID(x) ((x) << S_PLD2XRXVALID)
#define F_PLD2XRXVALID    V_PLD2XRXVALID(1U)

#define S_DDPSTATE    16
#define M_DDPSTATE    0x1fU
#define V_DDPSTATE(x) ((x) << S_DDPSTATE)
#define G_DDPSTATE(x) (((x) >> S_DDPSTATE) & M_DDPSTATE)

#define S_DDPMSGCODE    12
#define M_DDPMSGCODE    0xfU
#define V_DDPMSGCODE(x) ((x) << S_DDPMSGCODE)
#define G_DDPMSGCODE(x) (((x) >> S_DDPMSGCODE) & M_DDPMSGCODE)

#define S_CPL5SOCPCNT    8
#define M_CPL5SOCPCNT    0xfU
#define V_CPL5SOCPCNT(x) ((x) << S_CPL5SOCPCNT)
#define G_CPL5SOCPCNT(x) (((x) >> S_CPL5SOCPCNT) & M_CPL5SOCPCNT)

#define S_PLDRXZEROPCNT    4
#define M_PLDRXZEROPCNT    0xfU
#define V_PLDRXZEROPCNT(x) ((x) << S_PLDRXZEROPCNT)
#define G_PLDRXZEROPCNT(x) (((x) >> S_PLDRXZEROPCNT) & M_PLDRXZEROPCNT)

#define S_TXFRMERR2    3
#define V_TXFRMERR2(x) ((x) << S_TXFRMERR2)
#define F_TXFRMERR2    V_TXFRMERR2(1U)

#define S_TXFRMERR1    2
#define V_TXFRMERR1(x) ((x) << S_TXFRMERR1)
#define F_TXFRMERR1    V_TXFRMERR1(1U)

#define S_TXVALID2X    1
#define V_TXVALID2X(x) ((x) << S_TXVALID2X)
#define F_TXVALID2X    V_TXVALID2X(1U)

#define S_TXFULL2X    0
#define V_TXFULL2X(x) ((x) << S_TXFULL2X)
#define F_TXFULL2X    V_TXFULL2X(1U)

#define A_TP_DBG_CSIDE_DISP1 0x23b
#define A_TP_DBG_CSIDE_DDP0 0x23c

#define S_DDPMSGLATEST7    28
#define M_DDPMSGLATEST7    0xfU
#define V_DDPMSGLATEST7(x) ((x) << S_DDPMSGLATEST7)
#define G_DDPMSGLATEST7(x) (((x) >> S_DDPMSGLATEST7) & M_DDPMSGLATEST7)

#define S_DDPMSGLATEST6    24
#define M_DDPMSGLATEST6    0xfU
#define V_DDPMSGLATEST6(x) ((x) << S_DDPMSGLATEST6)
#define G_DDPMSGLATEST6(x) (((x) >> S_DDPMSGLATEST6) & M_DDPMSGLATEST6)

#define S_DDPMSGLATEST5    20
#define M_DDPMSGLATEST5    0xfU
#define V_DDPMSGLATEST5(x) ((x) << S_DDPMSGLATEST5)
#define G_DDPMSGLATEST5(x) (((x) >> S_DDPMSGLATEST5) & M_DDPMSGLATEST5)

#define S_DDPMSGLATEST4    16
#define M_DDPMSGLATEST4    0xfU
#define V_DDPMSGLATEST4(x) ((x) << S_DDPMSGLATEST4)
#define G_DDPMSGLATEST4(x) (((x) >> S_DDPMSGLATEST4) & M_DDPMSGLATEST4)

#define S_DDPMSGLATEST3    12
#define M_DDPMSGLATEST3    0xfU
#define V_DDPMSGLATEST3(x) ((x) << S_DDPMSGLATEST3)
#define G_DDPMSGLATEST3(x) (((x) >> S_DDPMSGLATEST3) & M_DDPMSGLATEST3)

#define S_DDPMSGLATEST2    8
#define M_DDPMSGLATEST2    0xfU
#define V_DDPMSGLATEST2(x) ((x) << S_DDPMSGLATEST2)
#define G_DDPMSGLATEST2(x) (((x) >> S_DDPMSGLATEST2) & M_DDPMSGLATEST2)

#define S_DDPMSGLATEST1    4
#define M_DDPMSGLATEST1    0xfU
#define V_DDPMSGLATEST1(x) ((x) << S_DDPMSGLATEST1)
#define G_DDPMSGLATEST1(x) (((x) >> S_DDPMSGLATEST1) & M_DDPMSGLATEST1)

#define S_DDPMSGLATEST0    0
#define M_DDPMSGLATEST0    0xfU
#define V_DDPMSGLATEST0(x) ((x) << S_DDPMSGLATEST0)
#define G_DDPMSGLATEST0(x) (((x) >> S_DDPMSGLATEST0) & M_DDPMSGLATEST0)

#define A_TP_DBG_CSIDE_DDP1 0x23d
#define A_TP_DBG_CSIDE_FRM 0x23e

#define S_CRX2XERROR    28
#define M_CRX2XERROR    0xfU
#define V_CRX2XERROR(x) ((x) << S_CRX2XERROR)
#define G_CRX2XERROR(x) (((x) >> S_CRX2XERROR) & M_CRX2XERROR)

#define S_CPLDTX2XERROR    24
#define M_CPLDTX2XERROR    0xfU
#define V_CPLDTX2XERROR(x) ((x) << S_CPLDTX2XERROR)
#define G_CPLDTX2XERROR(x) (((x) >> S_CPLDTX2XERROR) & M_CPLDTX2XERROR)

#define S_CTXERROR    22
#define M_CTXERROR    0x3U
#define V_CTXERROR(x) ((x) << S_CTXERROR)
#define G_CTXERROR(x) (((x) >> S_CTXERROR) & M_CTXERROR)

#define S_CPLDRXERROR    20
#define M_CPLDRXERROR    0x3U
#define V_CPLDRXERROR(x) ((x) << S_CPLDRXERROR)
#define G_CPLDRXERROR(x) (((x) >> S_CPLDRXERROR) & M_CPLDRXERROR)

#define S_CPLRXERROR    18
#define M_CPLRXERROR    0x3U
#define V_CPLRXERROR(x) ((x) << S_CPLRXERROR)
#define G_CPLRXERROR(x) (((x) >> S_CPLRXERROR) & M_CPLRXERROR)

#define S_CPLTXERROR    16
#define M_CPLTXERROR    0x3U
#define V_CPLTXERROR(x) ((x) << S_CPLTXERROR)
#define G_CPLTXERROR(x) (((x) >> S_CPLTXERROR) & M_CPLTXERROR)

#define S_CPRSERROR    0
#define M_CPRSERROR    0xfU
#define V_CPRSERROR(x) ((x) << S_CPRSERROR)
#define G_CPRSERROR(x) (((x) >> S_CPRSERROR) & M_CPRSERROR)

#define A_TP_DBG_CSIDE_INT 0x23f

#define S_CRXVALID2X    28
#define M_CRXVALID2X    0xfU
#define V_CRXVALID2X(x) ((x) << S_CRXVALID2X)
#define G_CRXVALID2X(x) (((x) >> S_CRXVALID2X) & M_CRXVALID2X)

#define S_CRXAFULL2X    24
#define M_CRXAFULL2X    0xfU
#define V_CRXAFULL2X(x) ((x) << S_CRXAFULL2X)
#define G_CRXAFULL2X(x) (((x) >> S_CRXAFULL2X) & M_CRXAFULL2X)

#define S_CTXVALID2X    22
#define M_CTXVALID2X    0x3U
#define V_CTXVALID2X(x) ((x) << S_CTXVALID2X)
#define G_CTXVALID2X(x) (((x) >> S_CTXVALID2X) & M_CTXVALID2X)

#define S_CTXAFULL2X    20
#define M_CTXAFULL2X    0x3U
#define V_CTXAFULL2X(x) ((x) << S_CTXAFULL2X)
#define G_CTXAFULL2X(x) (((x) >> S_CTXAFULL2X) & M_CTXAFULL2X)

#define S_PLD2X_RXVALID    18
#define M_PLD2X_RXVALID    0x3U
#define V_PLD2X_RXVALID(x) ((x) << S_PLD2X_RXVALID)
#define G_PLD2X_RXVALID(x) (((x) >> S_PLD2X_RXVALID) & M_PLD2X_RXVALID)

#define S_PLD2X_RXAFULL    16
#define M_PLD2X_RXAFULL    0x3U
#define V_PLD2X_RXAFULL(x) ((x) << S_PLD2X_RXAFULL)
#define G_PLD2X_RXAFULL(x) (((x) >> S_PLD2X_RXAFULL) & M_PLD2X_RXAFULL)

#define S_CSIDE_DDP_VALID    14
#define M_CSIDE_DDP_VALID    0x3U
#define V_CSIDE_DDP_VALID(x) ((x) << S_CSIDE_DDP_VALID)
#define G_CSIDE_DDP_VALID(x) (((x) >> S_CSIDE_DDP_VALID) & M_CSIDE_DDP_VALID)

#define S_DDP_AFULL    12
#define M_DDP_AFULL    0x3U
#define V_DDP_AFULL(x) ((x) << S_DDP_AFULL)
#define G_DDP_AFULL(x) (((x) >> S_DDP_AFULL) & M_DDP_AFULL)

#define S_TRC_RXVALID    11
#define V_TRC_RXVALID(x) ((x) << S_TRC_RXVALID)
#define F_TRC_RXVALID    V_TRC_RXVALID(1U)

#define S_TRC_RXFULL    10
#define V_TRC_RXFULL(x) ((x) << S_TRC_RXFULL)
#define F_TRC_RXFULL    V_TRC_RXFULL(1U)

#define S_CPL5_TXVALID    9
#define V_CPL5_TXVALID(x) ((x) << S_CPL5_TXVALID)
#define F_CPL5_TXVALID    V_CPL5_TXVALID(1U)

#define S_CPL5_TXFULL    8
#define V_CPL5_TXFULL(x) ((x) << S_CPL5_TXFULL)
#define F_CPL5_TXFULL    V_CPL5_TXFULL(1U)

#define S_PLD2X_TXVALID    4
#define M_PLD2X_TXVALID    0xfU
#define V_PLD2X_TXVALID(x) ((x) << S_PLD2X_TXVALID)
#define G_PLD2X_TXVALID(x) (((x) >> S_PLD2X_TXVALID) & M_PLD2X_TXVALID)

#define S_PLD2X_TXAFULL    0
#define M_PLD2X_TXAFULL    0xfU
#define V_PLD2X_TXAFULL(x) ((x) << S_PLD2X_TXAFULL)
#define G_PLD2X_TXAFULL(x) (((x) >> S_PLD2X_TXAFULL) & M_PLD2X_TXAFULL)

#define A_TP_CHDR_CONFIG 0x240

#define S_CH1HIGH    24
#define M_CH1HIGH    0xffU
#define V_CH1HIGH(x) ((x) << S_CH1HIGH)
#define G_CH1HIGH(x) (((x) >> S_CH1HIGH) & M_CH1HIGH)

#define S_CH1LOW    16
#define M_CH1LOW    0xffU
#define V_CH1LOW(x) ((x) << S_CH1LOW)
#define G_CH1LOW(x) (((x) >> S_CH1LOW) & M_CH1LOW)

#define S_CH0HIGH    8
#define M_CH0HIGH    0xffU
#define V_CH0HIGH(x) ((x) << S_CH0HIGH)
#define G_CH0HIGH(x) (((x) >> S_CH0HIGH) & M_CH0HIGH)

#define S_CH0LOW    0
#define M_CH0LOW    0xffU
#define V_CH0LOW(x) ((x) << S_CH0LOW)
#define G_CH0LOW(x) (((x) >> S_CH0LOW) & M_CH0LOW)

#define A_TP_UTRN_CONFIG 0x241

#define S_CH2FIFOLIMIT    16
#define M_CH2FIFOLIMIT    0xffU
#define V_CH2FIFOLIMIT(x) ((x) << S_CH2FIFOLIMIT)
#define G_CH2FIFOLIMIT(x) (((x) >> S_CH2FIFOLIMIT) & M_CH2FIFOLIMIT)

#define S_CH1FIFOLIMIT    8
#define M_CH1FIFOLIMIT    0xffU
#define V_CH1FIFOLIMIT(x) ((x) << S_CH1FIFOLIMIT)
#define G_CH1FIFOLIMIT(x) (((x) >> S_CH1FIFOLIMIT) & M_CH1FIFOLIMIT)

#define S_CH0FIFOLIMIT    0
#define M_CH0FIFOLIMIT    0xffU
#define V_CH0FIFOLIMIT(x) ((x) << S_CH0FIFOLIMIT)
#define G_CH0FIFOLIMIT(x) (((x) >> S_CH0FIFOLIMIT) & M_CH0FIFOLIMIT)

#define A_TP_CDSP_CONFIG 0x242

#define S_WRITEZEROEN    4
#define V_WRITEZEROEN(x) ((x) << S_WRITEZEROEN)
#define F_WRITEZEROEN    V_WRITEZEROEN(1U)

#define S_WRITEZEROOP    0
#define M_WRITEZEROOP    0xfU
#define V_WRITEZEROOP(x) ((x) << S_WRITEZEROOP)
#define G_WRITEZEROOP(x) (((x) >> S_WRITEZEROOP) & M_WRITEZEROOP)

#define S_STARTSKIPPLD    7
#define V_STARTSKIPPLD(x) ((x) << S_STARTSKIPPLD)
#define F_STARTSKIPPLD    V_STARTSKIPPLD(1U)

#define S_ATOMICCMDEN    5
#define V_ATOMICCMDEN(x) ((x) << S_ATOMICCMDEN)
#define F_ATOMICCMDEN    V_ATOMICCMDEN(1U)

#define A_TP_CSPI_POWER 0x243

#define S_GATECHNTX3    11
#define V_GATECHNTX3(x) ((x) << S_GATECHNTX3)
#define F_GATECHNTX3    V_GATECHNTX3(1U)

#define S_GATECHNTX2    10
#define V_GATECHNTX2(x) ((x) << S_GATECHNTX2)
#define F_GATECHNTX2    V_GATECHNTX2(1U)

#define S_GATECHNTX1    9
#define V_GATECHNTX1(x) ((x) << S_GATECHNTX1)
#define F_GATECHNTX1    V_GATECHNTX1(1U)

#define S_GATECHNTX0    8
#define V_GATECHNTX0(x) ((x) << S_GATECHNTX0)
#define F_GATECHNTX0    V_GATECHNTX0(1U)

#define S_GATECHNRX1    7
#define V_GATECHNRX1(x) ((x) << S_GATECHNRX1)
#define F_GATECHNRX1    V_GATECHNRX1(1U)

#define S_GATECHNRX0    6
#define V_GATECHNRX0(x) ((x) << S_GATECHNRX0)
#define F_GATECHNRX0    V_GATECHNRX0(1U)

#define S_SLEEPRDYUTRN    4
#define V_SLEEPRDYUTRN(x) ((x) << S_SLEEPRDYUTRN)
#define F_SLEEPRDYUTRN    V_SLEEPRDYUTRN(1U)

#define S_SLEEPREQUTRN    0
#define V_SLEEPREQUTRN(x) ((x) << S_SLEEPREQUTRN)
#define F_SLEEPREQUTRN    V_SLEEPREQUTRN(1U)

#define A_TP_TRC_CONFIG 0x244

#define S_TRCRR    1
#define V_TRCRR(x) ((x) << S_TRCRR)
#define F_TRCRR    V_TRCRR(1U)

#define S_TRCCH    0
#define V_TRCCH(x) ((x) << S_TRCCH)
#define F_TRCCH    V_TRCCH(1U)

#define A_TP_TAG_CONFIG 0x245

#define S_ETAGTYPE    16
#define M_ETAGTYPE    0xffffU
#define V_ETAGTYPE(x) ((x) << S_ETAGTYPE)
#define G_ETAGTYPE(x) (((x) >> S_ETAGTYPE) & M_ETAGTYPE)

#define A_TP_DBG_CSIDE_PRS 0x246

#define S_CPRSSTATE3    24
#define M_CPRSSTATE3    0x7U
#define V_CPRSSTATE3(x) ((x) << S_CPRSSTATE3)
#define G_CPRSSTATE3(x) (((x) >> S_CPRSSTATE3) & M_CPRSSTATE3)

#define S_CPRSSTATE2    16
#define M_CPRSSTATE2    0x7U
#define V_CPRSSTATE2(x) ((x) << S_CPRSSTATE2)
#define G_CPRSSTATE2(x) (((x) >> S_CPRSSTATE2) & M_CPRSSTATE2)

#define S_CPRSSTATE1    8
#define M_CPRSSTATE1    0x7U
#define V_CPRSSTATE1(x) ((x) << S_CPRSSTATE1)
#define G_CPRSSTATE1(x) (((x) >> S_CPRSSTATE1) & M_CPRSSTATE1)

#define S_CPRSSTATE0    0
#define M_CPRSSTATE0    0x7U
#define V_CPRSSTATE0(x) ((x) << S_CPRSSTATE0)
#define G_CPRSSTATE0(x) (((x) >> S_CPRSSTATE0) & M_CPRSSTATE0)

#define S_C4TUPBUSY3    31
#define V_C4TUPBUSY3(x) ((x) << S_C4TUPBUSY3)
#define F_C4TUPBUSY3    V_C4TUPBUSY3(1U)

#define S_CDBVALID3    30
#define V_CDBVALID3(x) ((x) << S_CDBVALID3)
#define F_CDBVALID3    V_CDBVALID3(1U)

#define S_CRXVALID3    29
#define V_CRXVALID3(x) ((x) << S_CRXVALID3)
#define F_CRXVALID3    V_CRXVALID3(1U)

#define S_CRXFULL3    28
#define V_CRXFULL3(x) ((x) << S_CRXFULL3)
#define F_CRXFULL3    V_CRXFULL3(1U)

#define S_C4TUPBUSY2    23
#define V_C4TUPBUSY2(x) ((x) << S_C4TUPBUSY2)
#define F_C4TUPBUSY2    V_C4TUPBUSY2(1U)

#define S_CDBVALID2    22
#define V_CDBVALID2(x) ((x) << S_CDBVALID2)
#define F_CDBVALID2    V_CDBVALID2(1U)

#define S_CRXVALID2    21
#define V_CRXVALID2(x) ((x) << S_CRXVALID2)
#define F_CRXVALID2    V_CRXVALID2(1U)

#define S_CRXFULL2    20
#define V_CRXFULL2(x) ((x) << S_CRXFULL2)
#define F_CRXFULL2    V_CRXFULL2(1U)

#define S_C4TUPBUSY1    15
#define V_C4TUPBUSY1(x) ((x) << S_C4TUPBUSY1)
#define F_C4TUPBUSY1    V_C4TUPBUSY1(1U)

#define S_CDBVALID1    14
#define V_CDBVALID1(x) ((x) << S_CDBVALID1)
#define F_CDBVALID1    V_CDBVALID1(1U)

#define S_CRXVALID1    13
#define V_CRXVALID1(x) ((x) << S_CRXVALID1)
#define F_CRXVALID1    V_CRXVALID1(1U)

#define S_CRXFULL1    12
#define V_CRXFULL1(x) ((x) << S_CRXFULL1)
#define F_CRXFULL1    V_CRXFULL1(1U)

#define S_C4TUPBUSY0    7
#define V_C4TUPBUSY0(x) ((x) << S_C4TUPBUSY0)
#define F_C4TUPBUSY0    V_C4TUPBUSY0(1U)

#define S_CDBVALID0    6
#define V_CDBVALID0(x) ((x) << S_CDBVALID0)
#define F_CDBVALID0    V_CDBVALID0(1U)

#define S_CRXVALID0    5
#define V_CRXVALID0(x) ((x) << S_CRXVALID0)
#define F_CRXVALID0    V_CRXVALID0(1U)

#define S_CRXFULL0    4
#define V_CRXFULL0(x) ((x) << S_CRXFULL0)
#define F_CRXFULL0    V_CRXFULL0(1U)

#define A_TP_DBG_CSIDE_DEMUX 0x247

#define S_CALLDONE    28
#define M_CALLDONE    0xfU
#define V_CALLDONE(x) ((x) << S_CALLDONE)
#define G_CALLDONE(x) (((x) >> S_CALLDONE) & M_CALLDONE)

#define S_CTCPL5DONE    24
#define M_CTCPL5DONE    0xfU
#define V_CTCPL5DONE(x) ((x) << S_CTCPL5DONE)
#define G_CTCPL5DONE(x) (((x) >> S_CTCPL5DONE) & M_CTCPL5DONE)

#define S_CTXZEROPDONE    20
#define M_CTXZEROPDONE    0xfU
#define V_CTXZEROPDONE(x) ((x) << S_CTXZEROPDONE)
#define G_CTXZEROPDONE(x) (((x) >> S_CTXZEROPDONE) & M_CTXZEROPDONE)

#define S_CPLDDONE    16
#define M_CPLDDONE    0xfU
#define V_CPLDDONE(x) ((x) << S_CPLDDONE)
#define G_CPLDDONE(x) (((x) >> S_CPLDDONE) & M_CPLDDONE)

#define S_CTTCPOPDONE    12
#define M_CTTCPOPDONE    0xfU
#define V_CTTCPOPDONE(x) ((x) << S_CTTCPOPDONE)
#define G_CTTCPOPDONE(x) (((x) >> S_CTTCPOPDONE) & M_CTTCPOPDONE)

#define S_CDBDONE    8
#define M_CDBDONE    0xfU
#define V_CDBDONE(x) ((x) << S_CDBDONE)
#define G_CDBDONE(x) (((x) >> S_CDBDONE) & M_CDBDONE)

#define S_CISSFIFODONE    4
#define M_CISSFIFODONE    0xfU
#define V_CISSFIFODONE(x) ((x) << S_CISSFIFODONE)
#define G_CISSFIFODONE(x) (((x) >> S_CISSFIFODONE) & M_CISSFIFODONE)

#define S_CTXPKTCSUMDONE    0
#define M_CTXPKTCSUMDONE    0xfU
#define V_CTXPKTCSUMDONE(x) ((x) << S_CTXPKTCSUMDONE)
#define G_CTXPKTCSUMDONE(x) (((x) >> S_CTXPKTCSUMDONE) & M_CTXPKTCSUMDONE)

#define S_CARBVALID    28
#define M_CARBVALID    0xfU
#define V_CARBVALID(x) ((x) << S_CARBVALID)
#define G_CARBVALID(x) (((x) >> S_CARBVALID) & M_CARBVALID)

#define S_CCPL5DONE    24
#define M_CCPL5DONE    0xfU
#define V_CCPL5DONE(x) ((x) << S_CCPL5DONE)
#define G_CCPL5DONE(x) (((x) >> S_CCPL5DONE) & M_CCPL5DONE)

#define S_CTCPOPDONE    12
#define M_CTCPOPDONE    0xfU
#define V_CTCPOPDONE(x) ((x) << S_CTCPOPDONE)
#define G_CTCPOPDONE(x) (((x) >> S_CTCPOPDONE) & M_CTCPOPDONE)

#define A_TP_DBG_CSIDE_ARBIT 0x248

#define S_CPLVALID3    31
#define V_CPLVALID3(x) ((x) << S_CPLVALID3)
#define F_CPLVALID3    V_CPLVALID3(1U)

#define S_PLDVALID3    30
#define V_PLDVALID3(x) ((x) << S_PLDVALID3)
#define F_PLDVALID3    V_PLDVALID3(1U)

#define S_CRCVALID3    29
#define V_CRCVALID3(x) ((x) << S_CRCVALID3)
#define F_CRCVALID3    V_CRCVALID3(1U)

#define S_ISSVALID3    28
#define V_ISSVALID3(x) ((x) << S_ISSVALID3)
#define F_ISSVALID3    V_ISSVALID3(1U)

#define S_DBVALID3    27
#define V_DBVALID3(x) ((x) << S_DBVALID3)
#define F_DBVALID3    V_DBVALID3(1U)

#define S_CHKVALID3    26
#define V_CHKVALID3(x) ((x) << S_CHKVALID3)
#define F_CHKVALID3    V_CHKVALID3(1U)

#define S_ZRPVALID3    25
#define V_ZRPVALID3(x) ((x) << S_ZRPVALID3)
#define F_ZRPVALID3    V_ZRPVALID3(1U)

#define S_ERRVALID3    24
#define V_ERRVALID3(x) ((x) << S_ERRVALID3)
#define F_ERRVALID3    V_ERRVALID3(1U)

#define S_CPLVALID2    23
#define V_CPLVALID2(x) ((x) << S_CPLVALID2)
#define F_CPLVALID2    V_CPLVALID2(1U)

#define S_PLDVALID2    22
#define V_PLDVALID2(x) ((x) << S_PLDVALID2)
#define F_PLDVALID2    V_PLDVALID2(1U)

#define S_CRCVALID2    21
#define V_CRCVALID2(x) ((x) << S_CRCVALID2)
#define F_CRCVALID2    V_CRCVALID2(1U)

#define S_ISSVALID2    20
#define V_ISSVALID2(x) ((x) << S_ISSVALID2)
#define F_ISSVALID2    V_ISSVALID2(1U)

#define S_DBVALID2    19
#define V_DBVALID2(x) ((x) << S_DBVALID2)
#define F_DBVALID2    V_DBVALID2(1U)

#define S_CHKVALID2    18
#define V_CHKVALID2(x) ((x) << S_CHKVALID2)
#define F_CHKVALID2    V_CHKVALID2(1U)

#define S_ZRPVALID2    17
#define V_ZRPVALID2(x) ((x) << S_ZRPVALID2)
#define F_ZRPVALID2    V_ZRPVALID2(1U)

#define S_ERRVALID2    16
#define V_ERRVALID2(x) ((x) << S_ERRVALID2)
#define F_ERRVALID2    V_ERRVALID2(1U)

#define S_CPLVALID1    15
#define V_CPLVALID1(x) ((x) << S_CPLVALID1)
#define F_CPLVALID1    V_CPLVALID1(1U)

#define S_PLDVALID1    14
#define V_PLDVALID1(x) ((x) << S_PLDVALID1)
#define F_PLDVALID1    V_PLDVALID1(1U)

#define S_CRCVALID1    13
#define V_CRCVALID1(x) ((x) << S_CRCVALID1)
#define F_CRCVALID1    V_CRCVALID1(1U)

#define S_ISSVALID1    12
#define V_ISSVALID1(x) ((x) << S_ISSVALID1)
#define F_ISSVALID1    V_ISSVALID1(1U)

#define S_DBVALID1    11
#define V_DBVALID1(x) ((x) << S_DBVALID1)
#define F_DBVALID1    V_DBVALID1(1U)

#define S_CHKVALID1    10
#define V_CHKVALID1(x) ((x) << S_CHKVALID1)
#define F_CHKVALID1    V_CHKVALID1(1U)

#define S_ZRPVALID1    9
#define V_ZRPVALID1(x) ((x) << S_ZRPVALID1)
#define F_ZRPVALID1    V_ZRPVALID1(1U)

#define S_ERRVALID1    8
#define V_ERRVALID1(x) ((x) << S_ERRVALID1)
#define F_ERRVALID1    V_ERRVALID1(1U)

#define S_CPLVALID0    7
#define V_CPLVALID0(x) ((x) << S_CPLVALID0)
#define F_CPLVALID0    V_CPLVALID0(1U)

#define S_PLDVALID0    6
#define V_PLDVALID0(x) ((x) << S_PLDVALID0)
#define F_PLDVALID0    V_PLDVALID0(1U)

#define S_CRCVALID0    5
#define V_CRCVALID0(x) ((x) << S_CRCVALID0)
#define F_CRCVALID0    V_CRCVALID0(1U)

#define S_ISSVALID0    4
#define V_ISSVALID0(x) ((x) << S_ISSVALID0)
#define F_ISSVALID0    V_ISSVALID0(1U)

#define S_DBVALID0    3
#define V_DBVALID0(x) ((x) << S_DBVALID0)
#define F_DBVALID0    V_DBVALID0(1U)

#define S_CHKVALID0    2
#define V_CHKVALID0(x) ((x) << S_CHKVALID0)
#define F_CHKVALID0    V_CHKVALID0(1U)

#define S_ZRPVALID0    1
#define V_ZRPVALID0(x) ((x) << S_ZRPVALID0)
#define F_ZRPVALID0    V_ZRPVALID0(1U)

#define S_ERRVALID0    0
#define V_ERRVALID0(x) ((x) << S_ERRVALID0)
#define F_ERRVALID0    V_ERRVALID0(1U)

#define A_TP_FIFO_CONFIG 0x8c0

#define S_CH1_OUTPUT    27
#define M_CH1_OUTPUT    0x1fU
#define V_CH1_OUTPUT(x) ((x) << S_CH1_OUTPUT)
#define G_CH1_OUTPUT(x) (((x) >> S_CH1_OUTPUT) & M_CH1_OUTPUT)

#define S_CH2_OUTPUT    22
#define M_CH2_OUTPUT    0x1fU
#define V_CH2_OUTPUT(x) ((x) << S_CH2_OUTPUT)
#define G_CH2_OUTPUT(x) (((x) >> S_CH2_OUTPUT) & M_CH2_OUTPUT)

#define S_STROBE1    16
#define V_STROBE1(x) ((x) << S_STROBE1)
#define F_STROBE1    V_STROBE1(1U)

#define S_CH1_INPUT    11
#define M_CH1_INPUT    0x1fU
#define V_CH1_INPUT(x) ((x) << S_CH1_INPUT)
#define G_CH1_INPUT(x) (((x) >> S_CH1_INPUT) & M_CH1_INPUT)

#define S_CH2_INPUT    6
#define M_CH2_INPUT    0x1fU
#define V_CH2_INPUT(x) ((x) << S_CH2_INPUT)
#define G_CH2_INPUT(x) (((x) >> S_CH2_INPUT) & M_CH2_INPUT)

#define S_CH3_INPUT    1
#define M_CH3_INPUT    0x1fU
#define V_CH3_INPUT(x) ((x) << S_CH3_INPUT)
#define G_CH3_INPUT(x) (((x) >> S_CH3_INPUT) & M_CH3_INPUT)

#define S_STROBE0    0
#define V_STROBE0(x) ((x) << S_STROBE0)
#define F_STROBE0    V_STROBE0(1U)

#define A_TP_MIB_MAC_IN_ERR_0 0x0
#define A_TP_MIB_MAC_IN_ERR_1 0x1
#define A_TP_MIB_MAC_IN_ERR_2 0x2
#define A_TP_MIB_MAC_IN_ERR_3 0x3
#define A_TP_MIB_HDR_IN_ERR_0 0x4
#define A_TP_MIB_HDR_IN_ERR_1 0x5
#define A_TP_MIB_HDR_IN_ERR_2 0x6
#define A_TP_MIB_HDR_IN_ERR_3 0x7
#define A_TP_MIB_TCP_IN_ERR_0 0x8
#define A_TP_MIB_TCP_IN_ERR_1 0x9
#define A_TP_MIB_TCP_IN_ERR_2 0xa
#define A_TP_MIB_TCP_IN_ERR_3 0xb
#define A_TP_MIB_TCP_OUT_RST 0xc
#define A_TP_MIB_TCP_IN_SEG_HI 0x10
#define A_TP_MIB_TCP_IN_SEG_LO 0x11
#define A_TP_MIB_TCP_OUT_SEG_HI 0x12
#define A_TP_MIB_TCP_OUT_SEG_LO 0x13
#define A_TP_MIB_TCP_RXT_SEG_HI 0x14
#define A_TP_MIB_TCP_RXT_SEG_LO 0x15
#define A_TP_MIB_TNL_CNG_DROP_0 0x18
#define A_TP_MIB_TNL_CNG_DROP_1 0x19
#define A_TP_MIB_TNL_CNG_DROP_2 0x1a
#define A_TP_MIB_TNL_CNG_DROP_3 0x1b
#define A_TP_MIB_OFD_CHN_DROP_0 0x1c
#define A_TP_MIB_OFD_CHN_DROP_1 0x1d
#define A_TP_MIB_OFD_CHN_DROP_2 0x1e
#define A_TP_MIB_OFD_CHN_DROP_3 0x1f
#define A_TP_MIB_TNL_OUT_PKT_0 0x20
#define A_TP_MIB_TNL_OUT_PKT_1 0x21
#define A_TP_MIB_TNL_OUT_PKT_2 0x22
#define A_TP_MIB_TNL_OUT_PKT_3 0x23
#define A_TP_MIB_TNL_IN_PKT_0 0x24
#define A_TP_MIB_TNL_IN_PKT_1 0x25
#define A_TP_MIB_TNL_IN_PKT_2 0x26
#define A_TP_MIB_TNL_IN_PKT_3 0x27
#define A_TP_MIB_TCP_V6IN_ERR_0 0x28
#define A_TP_MIB_TCP_V6IN_ERR_1 0x29
#define A_TP_MIB_TCP_V6IN_ERR_2 0x2a
#define A_TP_MIB_TCP_V6IN_ERR_3 0x2b
#define A_TP_MIB_TCP_V6OUT_RST 0x2c
#define A_TP_MIB_TCP_V6IN_SEG_HI 0x30
#define A_TP_MIB_TCP_V6IN_SEG_LO 0x31
#define A_TP_MIB_TCP_V6OUT_SEG_HI 0x32
#define A_TP_MIB_TCP_V6OUT_SEG_LO 0x33
#define A_TP_MIB_TCP_V6RXT_SEG_HI 0x34
#define A_TP_MIB_TCP_V6RXT_SEG_LO 0x35
#define A_TP_MIB_OFD_ARP_DROP 0x36
#define A_TP_MIB_OFD_DFR_DROP 0x37
#define A_TP_MIB_CPL_IN_REQ_0 0x38
#define A_TP_MIB_CPL_IN_REQ_1 0x39
#define A_TP_MIB_CPL_IN_REQ_2 0x3a
#define A_TP_MIB_CPL_IN_REQ_3 0x3b
#define A_TP_MIB_CPL_OUT_RSP_0 0x3c
#define A_TP_MIB_CPL_OUT_RSP_1 0x3d
#define A_TP_MIB_CPL_OUT_RSP_2 0x3e
#define A_TP_MIB_CPL_OUT_RSP_3 0x3f
#define A_TP_MIB_TNL_LPBK_0 0x40
#define A_TP_MIB_TNL_LPBK_1 0x41
#define A_TP_MIB_TNL_LPBK_2 0x42
#define A_TP_MIB_TNL_LPBK_3 0x43
#define A_TP_MIB_TNL_DROP_0 0x44
#define A_TP_MIB_TNL_DROP_1 0x45
#define A_TP_MIB_TNL_DROP_2 0x46
#define A_TP_MIB_TNL_DROP_3 0x47
#define A_TP_MIB_FCOE_DDP_0 0x48
#define A_TP_MIB_FCOE_DDP_1 0x49
#define A_TP_MIB_FCOE_DDP_2 0x4a
#define A_TP_MIB_FCOE_DDP_3 0x4b
#define A_TP_MIB_FCOE_DROP_0 0x4c
#define A_TP_MIB_FCOE_DROP_1 0x4d
#define A_TP_MIB_FCOE_DROP_2 0x4e
#define A_TP_MIB_FCOE_DROP_3 0x4f
#define A_TP_MIB_FCOE_BYTE_0_HI 0x50
#define A_TP_MIB_FCOE_BYTE_0_LO 0x51
#define A_TP_MIB_FCOE_BYTE_1_HI 0x52
#define A_TP_MIB_FCOE_BYTE_1_LO 0x53
#define A_TP_MIB_FCOE_BYTE_2_HI 0x54
#define A_TP_MIB_FCOE_BYTE_2_LO 0x55
#define A_TP_MIB_FCOE_BYTE_3_HI 0x56
#define A_TP_MIB_FCOE_BYTE_3_LO 0x57
#define A_TP_MIB_OFD_VLN_DROP_0 0x58
#define A_TP_MIB_OFD_VLN_DROP_1 0x59
#define A_TP_MIB_OFD_VLN_DROP_2 0x5a
#define A_TP_MIB_OFD_VLN_DROP_3 0x5b
#define A_TP_MIB_USM_PKTS 0x5c
#define A_TP_MIB_USM_DROP 0x5d
#define A_TP_MIB_USM_BYTES_HI 0x5e
#define A_TP_MIB_USM_BYTES_LO 0x5f
#define A_TP_MIB_TID_DEL 0x60
#define A_TP_MIB_TID_INV 0x61
#define A_TP_MIB_TID_ACT 0x62
#define A_TP_MIB_TID_PAS 0x63
#define A_TP_MIB_RQE_DFR_PKT 0x64
#define A_TP_MIB_RQE_DFR_MOD 0x65
#define A_TP_MIB_CPL_OUT_ERR_0 0x68
#define A_TP_MIB_CPL_OUT_ERR_1 0x69
#define A_TP_MIB_CPL_OUT_ERR_2 0x6a
#define A_TP_MIB_CPL_OUT_ERR_3 0x6b
#define A_TP_MIB_ENG_LINE_0 0x6c
#define A_TP_MIB_ENG_LINE_1 0x6d
#define A_TP_MIB_ENG_LINE_2 0x6e
#define A_TP_MIB_ENG_LINE_3 0x6f

/* registers for module ULP_TX */
#define ULP_TX_BASE_ADDR 0x8dc0

#define A_ULP_TX_CONFIG 0x8dc0

#define S_STAG_MIX_ENABLE    2
#define V_STAG_MIX_ENABLE(x) ((x) << S_STAG_MIX_ENABLE)
#define F_STAG_MIX_ENABLE    V_STAG_MIX_ENABLE(1U)

#define S_STAGF_FIX_DISABLE    1
#define V_STAGF_FIX_DISABLE(x) ((x) << S_STAGF_FIX_DISABLE)
#define F_STAGF_FIX_DISABLE    V_STAGF_FIX_DISABLE(1U)

#define S_EXTRA_TAG_INSERTION_ENABLE    0
#define V_EXTRA_TAG_INSERTION_ENABLE(x) ((x) << S_EXTRA_TAG_INSERTION_ENABLE)
#define F_EXTRA_TAG_INSERTION_ENABLE    V_EXTRA_TAG_INSERTION_ENABLE(1U)

#define S_PHYS_ADDR_RESP_EN    6
#define V_PHYS_ADDR_RESP_EN(x) ((x) << S_PHYS_ADDR_RESP_EN)
#define F_PHYS_ADDR_RESP_EN    V_PHYS_ADDR_RESP_EN(1U)

#define S_ENDIANESS_CHANGE    5
#define V_ENDIANESS_CHANGE(x) ((x) << S_ENDIANESS_CHANGE)
#define F_ENDIANESS_CHANGE    V_ENDIANESS_CHANGE(1U)

#define S_ERR_RTAG_EN    4
#define V_ERR_RTAG_EN(x) ((x) << S_ERR_RTAG_EN)
#define F_ERR_RTAG_EN    V_ERR_RTAG_EN(1U)

#define S_TSO_ETHLEN_EN    3
#define V_TSO_ETHLEN_EN(x) ((x) << S_TSO_ETHLEN_EN)
#define F_TSO_ETHLEN_EN    V_TSO_ETHLEN_EN(1U)

#define S_EMSG_MORE_INFO    2
#define V_EMSG_MORE_INFO(x) ((x) << S_EMSG_MORE_INFO)
#define F_EMSG_MORE_INFO    V_EMSG_MORE_INFO(1U)

#define S_LOSDR    1
#define V_LOSDR(x) ((x) << S_LOSDR)
#define F_LOSDR    V_LOSDR(1U)

#define A_ULP_TX_PERR_INJECT 0x8dc4
#define A_ULP_TX_INT_ENABLE 0x8dc8

#define S_PBL_BOUND_ERR_CH3    31
#define V_PBL_BOUND_ERR_CH3(x) ((x) << S_PBL_BOUND_ERR_CH3)
#define F_PBL_BOUND_ERR_CH3    V_PBL_BOUND_ERR_CH3(1U)

#define S_PBL_BOUND_ERR_CH2    30
#define V_PBL_BOUND_ERR_CH2(x) ((x) << S_PBL_BOUND_ERR_CH2)
#define F_PBL_BOUND_ERR_CH2    V_PBL_BOUND_ERR_CH2(1U)

#define S_PBL_BOUND_ERR_CH1    29
#define V_PBL_BOUND_ERR_CH1(x) ((x) << S_PBL_BOUND_ERR_CH1)
#define F_PBL_BOUND_ERR_CH1    V_PBL_BOUND_ERR_CH1(1U)

#define S_PBL_BOUND_ERR_CH0    28
#define V_PBL_BOUND_ERR_CH0(x) ((x) << S_PBL_BOUND_ERR_CH0)
#define F_PBL_BOUND_ERR_CH0    V_PBL_BOUND_ERR_CH0(1U)

#define S_SGE2ULP_FIFO_PERR_SET3    27
#define V_SGE2ULP_FIFO_PERR_SET3(x) ((x) << S_SGE2ULP_FIFO_PERR_SET3)
#define F_SGE2ULP_FIFO_PERR_SET3    V_SGE2ULP_FIFO_PERR_SET3(1U)

#define S_SGE2ULP_FIFO_PERR_SET2    26
#define V_SGE2ULP_FIFO_PERR_SET2(x) ((x) << S_SGE2ULP_FIFO_PERR_SET2)
#define F_SGE2ULP_FIFO_PERR_SET2    V_SGE2ULP_FIFO_PERR_SET2(1U)

#define S_SGE2ULP_FIFO_PERR_SET1    25
#define V_SGE2ULP_FIFO_PERR_SET1(x) ((x) << S_SGE2ULP_FIFO_PERR_SET1)
#define F_SGE2ULP_FIFO_PERR_SET1    V_SGE2ULP_FIFO_PERR_SET1(1U)

#define S_SGE2ULP_FIFO_PERR_SET0    24
#define V_SGE2ULP_FIFO_PERR_SET0(x) ((x) << S_SGE2ULP_FIFO_PERR_SET0)
#define F_SGE2ULP_FIFO_PERR_SET0    V_SGE2ULP_FIFO_PERR_SET0(1U)

#define S_CIM2ULP_FIFO_PERR_SET3    23
#define V_CIM2ULP_FIFO_PERR_SET3(x) ((x) << S_CIM2ULP_FIFO_PERR_SET3)
#define F_CIM2ULP_FIFO_PERR_SET3    V_CIM2ULP_FIFO_PERR_SET3(1U)

#define S_CIM2ULP_FIFO_PERR_SET2    22
#define V_CIM2ULP_FIFO_PERR_SET2(x) ((x) << S_CIM2ULP_FIFO_PERR_SET2)
#define F_CIM2ULP_FIFO_PERR_SET2    V_CIM2ULP_FIFO_PERR_SET2(1U)

#define S_CIM2ULP_FIFO_PERR_SET1    21
#define V_CIM2ULP_FIFO_PERR_SET1(x) ((x) << S_CIM2ULP_FIFO_PERR_SET1)
#define F_CIM2ULP_FIFO_PERR_SET1    V_CIM2ULP_FIFO_PERR_SET1(1U)

#define S_CIM2ULP_FIFO_PERR_SET0    20
#define V_CIM2ULP_FIFO_PERR_SET0(x) ((x) << S_CIM2ULP_FIFO_PERR_SET0)
#define F_CIM2ULP_FIFO_PERR_SET0    V_CIM2ULP_FIFO_PERR_SET0(1U)

#define S_CQE_FIFO_PERR_SET3    19
#define V_CQE_FIFO_PERR_SET3(x) ((x) << S_CQE_FIFO_PERR_SET3)
#define F_CQE_FIFO_PERR_SET3    V_CQE_FIFO_PERR_SET3(1U)

#define S_CQE_FIFO_PERR_SET2    18
#define V_CQE_FIFO_PERR_SET2(x) ((x) << S_CQE_FIFO_PERR_SET2)
#define F_CQE_FIFO_PERR_SET2    V_CQE_FIFO_PERR_SET2(1U)

#define S_CQE_FIFO_PERR_SET1    17
#define V_CQE_FIFO_PERR_SET1(x) ((x) << S_CQE_FIFO_PERR_SET1)
#define F_CQE_FIFO_PERR_SET1    V_CQE_FIFO_PERR_SET1(1U)

#define S_CQE_FIFO_PERR_SET0    16
#define V_CQE_FIFO_PERR_SET0(x) ((x) << S_CQE_FIFO_PERR_SET0)
#define F_CQE_FIFO_PERR_SET0    V_CQE_FIFO_PERR_SET0(1U)

#define S_PBL_FIFO_PERR_SET3    15
#define V_PBL_FIFO_PERR_SET3(x) ((x) << S_PBL_FIFO_PERR_SET3)
#define F_PBL_FIFO_PERR_SET3    V_PBL_FIFO_PERR_SET3(1U)

#define S_PBL_FIFO_PERR_SET2    14
#define V_PBL_FIFO_PERR_SET2(x) ((x) << S_PBL_FIFO_PERR_SET2)
#define F_PBL_FIFO_PERR_SET2    V_PBL_FIFO_PERR_SET2(1U)

#define S_PBL_FIFO_PERR_SET1    13
#define V_PBL_FIFO_PERR_SET1(x) ((x) << S_PBL_FIFO_PERR_SET1)
#define F_PBL_FIFO_PERR_SET1    V_PBL_FIFO_PERR_SET1(1U)

#define S_PBL_FIFO_PERR_SET0    12
#define V_PBL_FIFO_PERR_SET0(x) ((x) << S_PBL_FIFO_PERR_SET0)
#define F_PBL_FIFO_PERR_SET0    V_PBL_FIFO_PERR_SET0(1U)

#define S_CMD_FIFO_PERR_SET3    11
#define V_CMD_FIFO_PERR_SET3(x) ((x) << S_CMD_FIFO_PERR_SET3)
#define F_CMD_FIFO_PERR_SET3    V_CMD_FIFO_PERR_SET3(1U)

#define S_CMD_FIFO_PERR_SET2    10
#define V_CMD_FIFO_PERR_SET2(x) ((x) << S_CMD_FIFO_PERR_SET2)
#define F_CMD_FIFO_PERR_SET2    V_CMD_FIFO_PERR_SET2(1U)

#define S_CMD_FIFO_PERR_SET1    9
#define V_CMD_FIFO_PERR_SET1(x) ((x) << S_CMD_FIFO_PERR_SET1)
#define F_CMD_FIFO_PERR_SET1    V_CMD_FIFO_PERR_SET1(1U)

#define S_CMD_FIFO_PERR_SET0    8
#define V_CMD_FIFO_PERR_SET0(x) ((x) << S_CMD_FIFO_PERR_SET0)
#define F_CMD_FIFO_PERR_SET0    V_CMD_FIFO_PERR_SET0(1U)

#define S_LSO_HDR_SRAM_PERR_SET3    7
#define V_LSO_HDR_SRAM_PERR_SET3(x) ((x) << S_LSO_HDR_SRAM_PERR_SET3)
#define F_LSO_HDR_SRAM_PERR_SET3    V_LSO_HDR_SRAM_PERR_SET3(1U)

#define S_LSO_HDR_SRAM_PERR_SET2    6
#define V_LSO_HDR_SRAM_PERR_SET2(x) ((x) << S_LSO_HDR_SRAM_PERR_SET2)
#define F_LSO_HDR_SRAM_PERR_SET2    V_LSO_HDR_SRAM_PERR_SET2(1U)

#define S_LSO_HDR_SRAM_PERR_SET1    5
#define V_LSO_HDR_SRAM_PERR_SET1(x) ((x) << S_LSO_HDR_SRAM_PERR_SET1)
#define F_LSO_HDR_SRAM_PERR_SET1    V_LSO_HDR_SRAM_PERR_SET1(1U)

#define S_LSO_HDR_SRAM_PERR_SET0    4
#define V_LSO_HDR_SRAM_PERR_SET0(x) ((x) << S_LSO_HDR_SRAM_PERR_SET0)
#define F_LSO_HDR_SRAM_PERR_SET0    V_LSO_HDR_SRAM_PERR_SET0(1U)

#define S_IMM_DATA_PERR_SET_CH3    3
#define V_IMM_DATA_PERR_SET_CH3(x) ((x) << S_IMM_DATA_PERR_SET_CH3)
#define F_IMM_DATA_PERR_SET_CH3    V_IMM_DATA_PERR_SET_CH3(1U)

#define S_IMM_DATA_PERR_SET_CH2    2
#define V_IMM_DATA_PERR_SET_CH2(x) ((x) << S_IMM_DATA_PERR_SET_CH2)
#define F_IMM_DATA_PERR_SET_CH2    V_IMM_DATA_PERR_SET_CH2(1U)

#define S_IMM_DATA_PERR_SET_CH1    1
#define V_IMM_DATA_PERR_SET_CH1(x) ((x) << S_IMM_DATA_PERR_SET_CH1)
#define F_IMM_DATA_PERR_SET_CH1    V_IMM_DATA_PERR_SET_CH1(1U)

#define S_IMM_DATA_PERR_SET_CH0    0
#define V_IMM_DATA_PERR_SET_CH0(x) ((x) << S_IMM_DATA_PERR_SET_CH0)
#define F_IMM_DATA_PERR_SET_CH0    V_IMM_DATA_PERR_SET_CH0(1U)

#define A_ULP_TX_INT_CAUSE 0x8dcc
#define A_ULP_TX_PERR_ENABLE 0x8dd0
#define A_ULP_TX_TPT_LLIMIT 0x8dd4
#define A_ULP_TX_TPT_ULIMIT 0x8dd8
#define A_ULP_TX_PBL_LLIMIT 0x8ddc
#define A_ULP_TX_PBL_ULIMIT 0x8de0
#define A_ULP_TX_CPL_ERR_OFFSET 0x8de4
#define A_ULP_TX_CPL_ERR_MASK_L 0x8de8
#define A_ULP_TX_CPL_ERR_MASK_H 0x8dec
#define A_ULP_TX_CPL_ERR_VALUE_L 0x8df0
#define A_ULP_TX_CPL_ERR_VALUE_H 0x8df4
#define A_ULP_TX_CPL_PACK_SIZE1 0x8df8

#define S_CH3SIZE1    24
#define M_CH3SIZE1    0xffU
#define V_CH3SIZE1(x) ((x) << S_CH3SIZE1)
#define G_CH3SIZE1(x) (((x) >> S_CH3SIZE1) & M_CH3SIZE1)

#define S_CH2SIZE1    16
#define M_CH2SIZE1    0xffU
#define V_CH2SIZE1(x) ((x) << S_CH2SIZE1)
#define G_CH2SIZE1(x) (((x) >> S_CH2SIZE1) & M_CH2SIZE1)

#define S_CH1SIZE1    8
#define M_CH1SIZE1    0xffU
#define V_CH1SIZE1(x) ((x) << S_CH1SIZE1)
#define G_CH1SIZE1(x) (((x) >> S_CH1SIZE1) & M_CH1SIZE1)

#define S_CH0SIZE1    0
#define M_CH0SIZE1    0xffU
#define V_CH0SIZE1(x) ((x) << S_CH0SIZE1)
#define G_CH0SIZE1(x) (((x) >> S_CH0SIZE1) & M_CH0SIZE1)

#define A_ULP_TX_CPL_PACK_SIZE2 0x8dfc

#define S_CH3SIZE2    24
#define M_CH3SIZE2    0xffU
#define V_CH3SIZE2(x) ((x) << S_CH3SIZE2)
#define G_CH3SIZE2(x) (((x) >> S_CH3SIZE2) & M_CH3SIZE2)

#define S_CH2SIZE2    16
#define M_CH2SIZE2    0xffU
#define V_CH2SIZE2(x) ((x) << S_CH2SIZE2)
#define G_CH2SIZE2(x) (((x) >> S_CH2SIZE2) & M_CH2SIZE2)

#define S_CH1SIZE2    8
#define M_CH1SIZE2    0xffU
#define V_CH1SIZE2(x) ((x) << S_CH1SIZE2)
#define G_CH1SIZE2(x) (((x) >> S_CH1SIZE2) & M_CH1SIZE2)

#define S_CH0SIZE2    0
#define M_CH0SIZE2    0xffU
#define V_CH0SIZE2(x) ((x) << S_CH0SIZE2)
#define G_CH0SIZE2(x) (((x) >> S_CH0SIZE2) & M_CH0SIZE2)

#define A_ULP_TX_ERR_MSG2CIM 0x8e00
#define A_ULP_TX_ERR_TABLE_BASE 0x8e04
#define A_ULP_TX_ERR_CNT_CH0 0x8e10

#define S_ERR_CNT0    0
#define M_ERR_CNT0    0xfffffU
#define V_ERR_CNT0(x) ((x) << S_ERR_CNT0)
#define G_ERR_CNT0(x) (((x) >> S_ERR_CNT0) & M_ERR_CNT0)

#define A_ULP_TX_ERR_CNT_CH1 0x8e14

#define S_ERR_CNT1    0
#define M_ERR_CNT1    0xfffffU
#define V_ERR_CNT1(x) ((x) << S_ERR_CNT1)
#define G_ERR_CNT1(x) (((x) >> S_ERR_CNT1) & M_ERR_CNT1)

#define A_ULP_TX_ERR_CNT_CH2 0x8e18

#define S_ERR_CNT2    0
#define M_ERR_CNT2    0xfffffU
#define V_ERR_CNT2(x) ((x) << S_ERR_CNT2)
#define G_ERR_CNT2(x) (((x) >> S_ERR_CNT2) & M_ERR_CNT2)

#define A_ULP_TX_ERR_CNT_CH3 0x8e1c

#define S_ERR_CNT3    0
#define M_ERR_CNT3    0xfffffU
#define V_ERR_CNT3(x) ((x) << S_ERR_CNT3)
#define G_ERR_CNT3(x) (((x) >> S_ERR_CNT3) & M_ERR_CNT3)

#define A_ULP_TX_FC_SOF 0x8e20

#define S_SOF_FS3    24
#define M_SOF_FS3    0xffU
#define V_SOF_FS3(x) ((x) << S_SOF_FS3)
#define G_SOF_FS3(x) (((x) >> S_SOF_FS3) & M_SOF_FS3)

#define S_SOF_FS2    16
#define M_SOF_FS2    0xffU
#define V_SOF_FS2(x) ((x) << S_SOF_FS2)
#define G_SOF_FS2(x) (((x) >> S_SOF_FS2) & M_SOF_FS2)

#define S_SOF_3    8
#define M_SOF_3    0xffU
#define V_SOF_3(x) ((x) << S_SOF_3)
#define G_SOF_3(x) (((x) >> S_SOF_3) & M_SOF_3)

#define S_SOF_2    0
#define M_SOF_2    0xffU
#define V_SOF_2(x) ((x) << S_SOF_2)
#define G_SOF_2(x) (((x) >> S_SOF_2) & M_SOF_2)

#define A_ULP_TX_FC_EOF 0x8e24

#define S_EOF_LS3    24
#define M_EOF_LS3    0xffU
#define V_EOF_LS3(x) ((x) << S_EOF_LS3)
#define G_EOF_LS3(x) (((x) >> S_EOF_LS3) & M_EOF_LS3)

#define S_EOF_LS2    16
#define M_EOF_LS2    0xffU
#define V_EOF_LS2(x) ((x) << S_EOF_LS2)
#define G_EOF_LS2(x) (((x) >> S_EOF_LS2) & M_EOF_LS2)

#define S_EOF_3    8
#define M_EOF_3    0xffU
#define V_EOF_3(x) ((x) << S_EOF_3)
#define G_EOF_3(x) (((x) >> S_EOF_3) & M_EOF_3)

#define S_EOF_2    0
#define M_EOF_2    0xffU
#define V_EOF_2(x) ((x) << S_EOF_2)
#define G_EOF_2(x) (((x) >> S_EOF_2) & M_EOF_2)

#define A_ULP_TX_CGEN_GLOBAL 0x8e28

#define S_ULP_TX_GLOBAL_CGEN    0
#define V_ULP_TX_GLOBAL_CGEN(x) ((x) << S_ULP_TX_GLOBAL_CGEN)
#define F_ULP_TX_GLOBAL_CGEN    V_ULP_TX_GLOBAL_CGEN(1U)

#define A_ULP_TX_CGEN 0x8e2c

#define S_ULP_TX_CGEN_STORAGE    8
#define M_ULP_TX_CGEN_STORAGE    0xfU
#define V_ULP_TX_CGEN_STORAGE(x) ((x) << S_ULP_TX_CGEN_STORAGE)
#define G_ULP_TX_CGEN_STORAGE(x) (((x) >> S_ULP_TX_CGEN_STORAGE) & M_ULP_TX_CGEN_STORAGE)

#define S_ULP_TX_CGEN_RDMA    4
#define M_ULP_TX_CGEN_RDMA    0xfU
#define V_ULP_TX_CGEN_RDMA(x) ((x) << S_ULP_TX_CGEN_RDMA)
#define G_ULP_TX_CGEN_RDMA(x) (((x) >> S_ULP_TX_CGEN_RDMA) & M_ULP_TX_CGEN_RDMA)

#define S_ULP_TX_CGEN_CHANNEL    0
#define M_ULP_TX_CGEN_CHANNEL    0xfU
#define V_ULP_TX_CGEN_CHANNEL(x) ((x) << S_ULP_TX_CGEN_CHANNEL)
#define G_ULP_TX_CGEN_CHANNEL(x) (((x) >> S_ULP_TX_CGEN_CHANNEL) & M_ULP_TX_CGEN_CHANNEL)

#define A_ULP_TX_ULP2TP_BIST_CMD 0x8e30
#define A_ULP_TX_MEM_CFG 0x8e30

#define S_WRREQ_SZ    0
#define M_WRREQ_SZ    0x7U
#define V_WRREQ_SZ(x) ((x) << S_WRREQ_SZ)
#define G_WRREQ_SZ(x) (((x) >> S_WRREQ_SZ) & M_WRREQ_SZ)

#define A_ULP_TX_ULP2TP_BIST_ERROR_CNT 0x8e34
#define A_ULP_TX_PERR_INJECT_2 0x8e34
#define A_ULP_TX_FPGA_CMD_CTRL 0x8e38
#define A_ULP_TX_T5_FPGA_CMD_CTRL 0x8e38

#define S_CHANNEL_SEL    12
#define M_CHANNEL_SEL    0x3U
#define V_CHANNEL_SEL(x) ((x) << S_CHANNEL_SEL)
#define G_CHANNEL_SEL(x) (((x) >> S_CHANNEL_SEL) & M_CHANNEL_SEL)

#define S_INTF_SEL    4
#define M_INTF_SEL    0xfU
#define V_INTF_SEL(x) ((x) << S_INTF_SEL)
#define G_INTF_SEL(x) (((x) >> S_INTF_SEL) & M_INTF_SEL)

#define S_NUM_FLITS    1
#define M_NUM_FLITS    0x7U
#define V_NUM_FLITS(x) ((x) << S_NUM_FLITS)
#define G_NUM_FLITS(x) (((x) >> S_NUM_FLITS) & M_NUM_FLITS)

#define S_CMD_GEN_EN    0
#define V_CMD_GEN_EN(x) ((x) << S_CMD_GEN_EN)
#define F_CMD_GEN_EN    V_CMD_GEN_EN(1U)

#define A_ULP_TX_FPGA_CMD_0 0x8e3c
#define A_ULP_TX_T5_FPGA_CMD_0 0x8e3c
#define A_ULP_TX_FPGA_CMD_1 0x8e40
#define A_ULP_TX_T5_FPGA_CMD_1 0x8e40
#define A_ULP_TX_FPGA_CMD_2 0x8e44
#define A_ULP_TX_T5_FPGA_CMD_2 0x8e44
#define A_ULP_TX_FPGA_CMD_3 0x8e48
#define A_ULP_TX_T5_FPGA_CMD_3 0x8e48
#define A_ULP_TX_FPGA_CMD_4 0x8e4c
#define A_ULP_TX_T5_FPGA_CMD_4 0x8e4c
#define A_ULP_TX_FPGA_CMD_5 0x8e50
#define A_ULP_TX_T5_FPGA_CMD_5 0x8e50
#define A_ULP_TX_FPGA_CMD_6 0x8e54
#define A_ULP_TX_T5_FPGA_CMD_6 0x8e54
#define A_ULP_TX_FPGA_CMD_7 0x8e58
#define A_ULP_TX_T5_FPGA_CMD_7 0x8e58
#define A_ULP_TX_FPGA_CMD_8 0x8e5c
#define A_ULP_TX_T5_FPGA_CMD_8 0x8e5c
#define A_ULP_TX_FPGA_CMD_9 0x8e60
#define A_ULP_TX_T5_FPGA_CMD_9 0x8e60
#define A_ULP_TX_FPGA_CMD_10 0x8e64
#define A_ULP_TX_T5_FPGA_CMD_10 0x8e64
#define A_ULP_TX_FPGA_CMD_11 0x8e68
#define A_ULP_TX_T5_FPGA_CMD_11 0x8e68
#define A_ULP_TX_FPGA_CMD_12 0x8e6c
#define A_ULP_TX_T5_FPGA_CMD_12 0x8e6c
#define A_ULP_TX_FPGA_CMD_13 0x8e70
#define A_ULP_TX_T5_FPGA_CMD_13 0x8e70
#define A_ULP_TX_FPGA_CMD_14 0x8e74
#define A_ULP_TX_T5_FPGA_CMD_14 0x8e74
#define A_ULP_TX_FPGA_CMD_15 0x8e78
#define A_ULP_TX_T5_FPGA_CMD_15 0x8e78
#define A_ULP_TX_INT_ENABLE_2 0x8e7c

#define S_SMARBT2ULP_DATA_PERR_SET    12
#define V_SMARBT2ULP_DATA_PERR_SET(x) ((x) << S_SMARBT2ULP_DATA_PERR_SET)
#define F_SMARBT2ULP_DATA_PERR_SET    V_SMARBT2ULP_DATA_PERR_SET(1U)

#define S_ULP2TP_DATA_PERR_SET    11
#define V_ULP2TP_DATA_PERR_SET(x) ((x) << S_ULP2TP_DATA_PERR_SET)
#define F_ULP2TP_DATA_PERR_SET    V_ULP2TP_DATA_PERR_SET(1U)

#define S_MA2ULP_DATA_PERR_SET    10
#define V_MA2ULP_DATA_PERR_SET(x) ((x) << S_MA2ULP_DATA_PERR_SET)
#define F_MA2ULP_DATA_PERR_SET    V_MA2ULP_DATA_PERR_SET(1U)

#define S_SGE2ULP_DATA_PERR_SET    9
#define V_SGE2ULP_DATA_PERR_SET(x) ((x) << S_SGE2ULP_DATA_PERR_SET)
#define F_SGE2ULP_DATA_PERR_SET    V_SGE2ULP_DATA_PERR_SET(1U)

#define S_CIM2ULP_DATA_PERR_SET    8
#define V_CIM2ULP_DATA_PERR_SET(x) ((x) << S_CIM2ULP_DATA_PERR_SET)
#define F_CIM2ULP_DATA_PERR_SET    V_CIM2ULP_DATA_PERR_SET(1U)

#define S_FSO_HDR_SRAM_PERR_SET3    7
#define V_FSO_HDR_SRAM_PERR_SET3(x) ((x) << S_FSO_HDR_SRAM_PERR_SET3)
#define F_FSO_HDR_SRAM_PERR_SET3    V_FSO_HDR_SRAM_PERR_SET3(1U)

#define S_FSO_HDR_SRAM_PERR_SET2    6
#define V_FSO_HDR_SRAM_PERR_SET2(x) ((x) << S_FSO_HDR_SRAM_PERR_SET2)
#define F_FSO_HDR_SRAM_PERR_SET2    V_FSO_HDR_SRAM_PERR_SET2(1U)

#define S_FSO_HDR_SRAM_PERR_SET1    5
#define V_FSO_HDR_SRAM_PERR_SET1(x) ((x) << S_FSO_HDR_SRAM_PERR_SET1)
#define F_FSO_HDR_SRAM_PERR_SET1    V_FSO_HDR_SRAM_PERR_SET1(1U)

#define S_FSO_HDR_SRAM_PERR_SET0    4
#define V_FSO_HDR_SRAM_PERR_SET0(x) ((x) << S_FSO_HDR_SRAM_PERR_SET0)
#define F_FSO_HDR_SRAM_PERR_SET0    V_FSO_HDR_SRAM_PERR_SET0(1U)

#define S_T10_PI_SRAM_PERR_SET3    3
#define V_T10_PI_SRAM_PERR_SET3(x) ((x) << S_T10_PI_SRAM_PERR_SET3)
#define F_T10_PI_SRAM_PERR_SET3    V_T10_PI_SRAM_PERR_SET3(1U)

#define S_T10_PI_SRAM_PERR_SET2    2
#define V_T10_PI_SRAM_PERR_SET2(x) ((x) << S_T10_PI_SRAM_PERR_SET2)
#define F_T10_PI_SRAM_PERR_SET2    V_T10_PI_SRAM_PERR_SET2(1U)

#define S_T10_PI_SRAM_PERR_SET1    1
#define V_T10_PI_SRAM_PERR_SET1(x) ((x) << S_T10_PI_SRAM_PERR_SET1)
#define F_T10_PI_SRAM_PERR_SET1    V_T10_PI_SRAM_PERR_SET1(1U)

#define S_T10_PI_SRAM_PERR_SET0    0
#define V_T10_PI_SRAM_PERR_SET0(x) ((x) << S_T10_PI_SRAM_PERR_SET0)
#define F_T10_PI_SRAM_PERR_SET0    V_T10_PI_SRAM_PERR_SET0(1U)

#define A_ULP_TX_INT_CAUSE_2 0x8e80
#define A_ULP_TX_PERR_ENABLE_2 0x8e84
#define A_ULP_TX_SE_CNT_ERR 0x8ea0

#define S_ERR_CH3    12
#define M_ERR_CH3    0xfU
#define V_ERR_CH3(x) ((x) << S_ERR_CH3)
#define G_ERR_CH3(x) (((x) >> S_ERR_CH3) & M_ERR_CH3)

#define S_ERR_CH2    8
#define M_ERR_CH2    0xfU
#define V_ERR_CH2(x) ((x) << S_ERR_CH2)
#define G_ERR_CH2(x) (((x) >> S_ERR_CH2) & M_ERR_CH2)

#define S_ERR_CH1    4
#define M_ERR_CH1    0xfU
#define V_ERR_CH1(x) ((x) << S_ERR_CH1)
#define G_ERR_CH1(x) (((x) >> S_ERR_CH1) & M_ERR_CH1)

#define S_ERR_CH0    0
#define M_ERR_CH0    0xfU
#define V_ERR_CH0(x) ((x) << S_ERR_CH0)
#define G_ERR_CH0(x) (((x) >> S_ERR_CH0) & M_ERR_CH0)

#define A_ULP_TX_T5_SE_CNT_ERR 0x8ea0
#define A_ULP_TX_SE_CNT_CLR 0x8ea4

#define S_CLR_DROP    16
#define M_CLR_DROP    0xfU
#define V_CLR_DROP(x) ((x) << S_CLR_DROP)
#define G_CLR_DROP(x) (((x) >> S_CLR_DROP) & M_CLR_DROP)

#define S_CLR_CH3    12
#define M_CLR_CH3    0xfU
#define V_CLR_CH3(x) ((x) << S_CLR_CH3)
#define G_CLR_CH3(x) (((x) >> S_CLR_CH3) & M_CLR_CH3)

#define S_CLR_CH2    8
#define M_CLR_CH2    0xfU
#define V_CLR_CH2(x) ((x) << S_CLR_CH2)
#define G_CLR_CH2(x) (((x) >> S_CLR_CH2) & M_CLR_CH2)

#define S_CLR_CH1    4
#define M_CLR_CH1    0xfU
#define V_CLR_CH1(x) ((x) << S_CLR_CH1)
#define G_CLR_CH1(x) (((x) >> S_CLR_CH1) & M_CLR_CH1)

#define S_CLR_CH0    0
#define M_CLR_CH0    0xfU
#define V_CLR_CH0(x) ((x) << S_CLR_CH0)
#define G_CLR_CH0(x) (((x) >> S_CLR_CH0) & M_CLR_CH0)

#define A_ULP_TX_T5_SE_CNT_CLR 0x8ea4
#define A_ULP_TX_SE_CNT_CH0 0x8ea8

#define S_SOP_CNT_ULP2TP    28
#define M_SOP_CNT_ULP2TP    0xfU
#define V_SOP_CNT_ULP2TP(x) ((x) << S_SOP_CNT_ULP2TP)
#define G_SOP_CNT_ULP2TP(x) (((x) >> S_SOP_CNT_ULP2TP) & M_SOP_CNT_ULP2TP)

#define S_EOP_CNT_ULP2TP    24
#define M_EOP_CNT_ULP2TP    0xfU
#define V_EOP_CNT_ULP2TP(x) ((x) << S_EOP_CNT_ULP2TP)
#define G_EOP_CNT_ULP2TP(x) (((x) >> S_EOP_CNT_ULP2TP) & M_EOP_CNT_ULP2TP)

#define S_SOP_CNT_LSO_IN    20
#define M_SOP_CNT_LSO_IN    0xfU
#define V_SOP_CNT_LSO_IN(x) ((x) << S_SOP_CNT_LSO_IN)
#define G_SOP_CNT_LSO_IN(x) (((x) >> S_SOP_CNT_LSO_IN) & M_SOP_CNT_LSO_IN)

#define S_EOP_CNT_LSO_IN    16
#define M_EOP_CNT_LSO_IN    0xfU
#define V_EOP_CNT_LSO_IN(x) ((x) << S_EOP_CNT_LSO_IN)
#define G_EOP_CNT_LSO_IN(x) (((x) >> S_EOP_CNT_LSO_IN) & M_EOP_CNT_LSO_IN)

#define S_SOP_CNT_ALG_IN    12
#define M_SOP_CNT_ALG_IN    0xfU
#define V_SOP_CNT_ALG_IN(x) ((x) << S_SOP_CNT_ALG_IN)
#define G_SOP_CNT_ALG_IN(x) (((x) >> S_SOP_CNT_ALG_IN) & M_SOP_CNT_ALG_IN)

#define S_EOP_CNT_ALG_IN    8
#define M_EOP_CNT_ALG_IN    0xfU
#define V_EOP_CNT_ALG_IN(x) ((x) << S_EOP_CNT_ALG_IN)
#define G_EOP_CNT_ALG_IN(x) (((x) >> S_EOP_CNT_ALG_IN) & M_EOP_CNT_ALG_IN)

#define S_SOP_CNT_CIM2ULP    4
#define M_SOP_CNT_CIM2ULP    0xfU
#define V_SOP_CNT_CIM2ULP(x) ((x) << S_SOP_CNT_CIM2ULP)
#define G_SOP_CNT_CIM2ULP(x) (((x) >> S_SOP_CNT_CIM2ULP) & M_SOP_CNT_CIM2ULP)

#define S_EOP_CNT_CIM2ULP    0
#define M_EOP_CNT_CIM2ULP    0xfU
#define V_EOP_CNT_CIM2ULP(x) ((x) << S_EOP_CNT_CIM2ULP)
#define G_EOP_CNT_CIM2ULP(x) (((x) >> S_EOP_CNT_CIM2ULP) & M_EOP_CNT_CIM2ULP)

#define A_ULP_TX_T5_SE_CNT_CH0 0x8ea8
#define A_ULP_TX_SE_CNT_CH1 0x8eac
#define A_ULP_TX_T5_SE_CNT_CH1 0x8eac
#define A_ULP_TX_SE_CNT_CH2 0x8eb0
#define A_ULP_TX_T5_SE_CNT_CH2 0x8eb0
#define A_ULP_TX_SE_CNT_CH3 0x8eb4
#define A_ULP_TX_T5_SE_CNT_CH3 0x8eb4
#define A_ULP_TX_DROP_CNT 0x8eb8

#define S_DROP_CH3    12
#define M_DROP_CH3    0xfU
#define V_DROP_CH3(x) ((x) << S_DROP_CH3)
#define G_DROP_CH3(x) (((x) >> S_DROP_CH3) & M_DROP_CH3)

#define S_DROP_CH2    8
#define M_DROP_CH2    0xfU
#define V_DROP_CH2(x) ((x) << S_DROP_CH2)
#define G_DROP_CH2(x) (((x) >> S_DROP_CH2) & M_DROP_CH2)

#define S_DROP_CH1    4
#define M_DROP_CH1    0xfU
#define V_DROP_CH1(x) ((x) << S_DROP_CH1)
#define G_DROP_CH1(x) (((x) >> S_DROP_CH1) & M_DROP_CH1)

#define S_DROP_CH0    0
#define M_DROP_CH0    0xfU
#define V_DROP_CH0(x) ((x) << S_DROP_CH0)
#define G_DROP_CH0(x) (((x) >> S_DROP_CH0) & M_DROP_CH0)

#define A_ULP_TX_T5_DROP_CNT 0x8eb8
#define A_ULP_TX_CSU_REVISION 0x8ebc
#define A_ULP_TX_LA_RDPTR_0 0x8ec0
#define A_ULP_TX_LA_RDDATA_0 0x8ec4
#define A_ULP_TX_LA_WRPTR_0 0x8ec8
#define A_ULP_TX_LA_RESERVED_0 0x8ecc
#define A_ULP_TX_LA_RDPTR_1 0x8ed0
#define A_ULP_TX_LA_RDDATA_1 0x8ed4
#define A_ULP_TX_LA_WRPTR_1 0x8ed8
#define A_ULP_TX_LA_RESERVED_1 0x8edc
#define A_ULP_TX_LA_RDPTR_2 0x8ee0
#define A_ULP_TX_LA_RDDATA_2 0x8ee4
#define A_ULP_TX_LA_WRPTR_2 0x8ee8
#define A_ULP_TX_LA_RESERVED_2 0x8eec
#define A_ULP_TX_LA_RDPTR_3 0x8ef0
#define A_ULP_TX_LA_RDDATA_3 0x8ef4
#define A_ULP_TX_LA_WRPTR_3 0x8ef8
#define A_ULP_TX_LA_RESERVED_3 0x8efc
#define A_ULP_TX_LA_RDPTR_4 0x8f00
#define A_ULP_TX_LA_RDDATA_4 0x8f04
#define A_ULP_TX_LA_WRPTR_4 0x8f08
#define A_ULP_TX_LA_RESERVED_4 0x8f0c
#define A_ULP_TX_LA_RDPTR_5 0x8f10
#define A_ULP_TX_LA_RDDATA_5 0x8f14
#define A_ULP_TX_LA_WRPTR_5 0x8f18
#define A_ULP_TX_LA_RESERVED_5 0x8f1c
#define A_ULP_TX_LA_RDPTR_6 0x8f20
#define A_ULP_TX_LA_RDDATA_6 0x8f24
#define A_ULP_TX_LA_WRPTR_6 0x8f28
#define A_ULP_TX_LA_RESERVED_6 0x8f2c
#define A_ULP_TX_LA_RDPTR_7 0x8f30
#define A_ULP_TX_LA_RDDATA_7 0x8f34
#define A_ULP_TX_LA_WRPTR_7 0x8f38
#define A_ULP_TX_LA_RESERVED_7 0x8f3c
#define A_ULP_TX_LA_RDPTR_8 0x8f40
#define A_ULP_TX_LA_RDDATA_8 0x8f44
#define A_ULP_TX_LA_WRPTR_8 0x8f48
#define A_ULP_TX_LA_RESERVED_8 0x8f4c
#define A_ULP_TX_LA_RDPTR_9 0x8f50
#define A_ULP_TX_LA_RDDATA_9 0x8f54
#define A_ULP_TX_LA_WRPTR_9 0x8f58
#define A_ULP_TX_LA_RESERVED_9 0x8f5c
#define A_ULP_TX_LA_RDPTR_10 0x8f60
#define A_ULP_TX_LA_RDDATA_10 0x8f64
#define A_ULP_TX_LA_WRPTR_10 0x8f68
#define A_ULP_TX_LA_RESERVED_10 0x8f6c
#define A_ULP_TX_ASIC_DEBUG_CTRL 0x8f70

#define S_LA_WR0    0
#define V_LA_WR0(x) ((x) << S_LA_WR0)
#define F_LA_WR0    V_LA_WR0(1U)

#define A_ULP_TX_ASIC_DEBUG_0 0x8f74
#define A_ULP_TX_ASIC_DEBUG_1 0x8f78
#define A_ULP_TX_ASIC_DEBUG_2 0x8f7c
#define A_ULP_TX_ASIC_DEBUG_3 0x8f80
#define A_ULP_TX_ASIC_DEBUG_4 0x8f84

/* registers for module PM_RX */
#define PM_RX_BASE_ADDR 0x8fc0

#define A_PM_RX_CFG 0x8fc0
#define A_PM_RX_MODE 0x8fc4

#define S_RX_USE_BUNDLE_LEN    4
#define V_RX_USE_BUNDLE_LEN(x) ((x) << S_RX_USE_BUNDLE_LEN)
#define F_RX_USE_BUNDLE_LEN    V_RX_USE_BUNDLE_LEN(1U)

#define S_STAT_TO_CH    3
#define V_STAT_TO_CH(x) ((x) << S_STAT_TO_CH)
#define F_STAT_TO_CH    V_STAT_TO_CH(1U)

#define S_STAT_FROM_CH    1
#define M_STAT_FROM_CH    0x3U
#define V_STAT_FROM_CH(x) ((x) << S_STAT_FROM_CH)
#define G_STAT_FROM_CH(x) (((x) >> S_STAT_FROM_CH) & M_STAT_FROM_CH)

#define S_PREFETCH_ENABLE    0
#define V_PREFETCH_ENABLE(x) ((x) << S_PREFETCH_ENABLE)
#define F_PREFETCH_ENABLE    V_PREFETCH_ENABLE(1U)

#define A_PM_RX_STAT_CONFIG 0x8fc8
#define A_PM_RX_STAT_COUNT 0x8fcc
#define A_PM_RX_STAT_LSB 0x8fd0
#define A_PM_RX_DBG_CTRL 0x8fd0

#define S_OSPIWRBUSY_T5    21
#define M_OSPIWRBUSY_T5    0x3U
#define V_OSPIWRBUSY_T5(x) ((x) << S_OSPIWRBUSY_T5)
#define G_OSPIWRBUSY_T5(x) (((x) >> S_OSPIWRBUSY_T5) & M_OSPIWRBUSY_T5)

#define S_ISPIWRBUSY    17
#define M_ISPIWRBUSY    0xfU
#define V_ISPIWRBUSY(x) ((x) << S_ISPIWRBUSY)
#define G_ISPIWRBUSY(x) (((x) >> S_ISPIWRBUSY) & M_ISPIWRBUSY)

#define S_PMDBGADDR    0
#define M_PMDBGADDR    0x1ffffU
#define V_PMDBGADDR(x) ((x) << S_PMDBGADDR)
#define G_PMDBGADDR(x) (((x) >> S_PMDBGADDR) & M_PMDBGADDR)

#define A_PM_RX_STAT_MSB 0x8fd4
#define A_PM_RX_DBG_DATA 0x8fd4
#define A_PM_RX_INT_ENABLE 0x8fd8

#define S_ZERO_E_CMD_ERROR    22
#define V_ZERO_E_CMD_ERROR(x) ((x) << S_ZERO_E_CMD_ERROR)
#define F_ZERO_E_CMD_ERROR    V_ZERO_E_CMD_ERROR(1U)

#define S_IESPI0_FIFO2X_RX_FRAMING_ERROR    21
#define V_IESPI0_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_IESPI0_FIFO2X_RX_FRAMING_ERROR)
#define F_IESPI0_FIFO2X_RX_FRAMING_ERROR    V_IESPI0_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_IESPI1_FIFO2X_RX_FRAMING_ERROR    20
#define V_IESPI1_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_IESPI1_FIFO2X_RX_FRAMING_ERROR)
#define F_IESPI1_FIFO2X_RX_FRAMING_ERROR    V_IESPI1_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_IESPI2_FIFO2X_RX_FRAMING_ERROR    19
#define V_IESPI2_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_IESPI2_FIFO2X_RX_FRAMING_ERROR)
#define F_IESPI2_FIFO2X_RX_FRAMING_ERROR    V_IESPI2_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_IESPI3_FIFO2X_RX_FRAMING_ERROR    18
#define V_IESPI3_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_IESPI3_FIFO2X_RX_FRAMING_ERROR)
#define F_IESPI3_FIFO2X_RX_FRAMING_ERROR    V_IESPI3_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_IESPI0_RX_FRAMING_ERROR    17
#define V_IESPI0_RX_FRAMING_ERROR(x) ((x) << S_IESPI0_RX_FRAMING_ERROR)
#define F_IESPI0_RX_FRAMING_ERROR    V_IESPI0_RX_FRAMING_ERROR(1U)

#define S_IESPI1_RX_FRAMING_ERROR    16
#define V_IESPI1_RX_FRAMING_ERROR(x) ((x) << S_IESPI1_RX_FRAMING_ERROR)
#define F_IESPI1_RX_FRAMING_ERROR    V_IESPI1_RX_FRAMING_ERROR(1U)

#define S_IESPI2_RX_FRAMING_ERROR    15
#define V_IESPI2_RX_FRAMING_ERROR(x) ((x) << S_IESPI2_RX_FRAMING_ERROR)
#define F_IESPI2_RX_FRAMING_ERROR    V_IESPI2_RX_FRAMING_ERROR(1U)

#define S_IESPI3_RX_FRAMING_ERROR    14
#define V_IESPI3_RX_FRAMING_ERROR(x) ((x) << S_IESPI3_RX_FRAMING_ERROR)
#define F_IESPI3_RX_FRAMING_ERROR    V_IESPI3_RX_FRAMING_ERROR(1U)

#define S_IESPI0_TX_FRAMING_ERROR    13
#define V_IESPI0_TX_FRAMING_ERROR(x) ((x) << S_IESPI0_TX_FRAMING_ERROR)
#define F_IESPI0_TX_FRAMING_ERROR    V_IESPI0_TX_FRAMING_ERROR(1U)

#define S_IESPI1_TX_FRAMING_ERROR    12
#define V_IESPI1_TX_FRAMING_ERROR(x) ((x) << S_IESPI1_TX_FRAMING_ERROR)
#define F_IESPI1_TX_FRAMING_ERROR    V_IESPI1_TX_FRAMING_ERROR(1U)

#define S_IESPI2_TX_FRAMING_ERROR    11
#define V_IESPI2_TX_FRAMING_ERROR(x) ((x) << S_IESPI2_TX_FRAMING_ERROR)
#define F_IESPI2_TX_FRAMING_ERROR    V_IESPI2_TX_FRAMING_ERROR(1U)

#define S_IESPI3_TX_FRAMING_ERROR    10
#define V_IESPI3_TX_FRAMING_ERROR(x) ((x) << S_IESPI3_TX_FRAMING_ERROR)
#define F_IESPI3_TX_FRAMING_ERROR    V_IESPI3_TX_FRAMING_ERROR(1U)

#define S_OCSPI0_RX_FRAMING_ERROR    9
#define V_OCSPI0_RX_FRAMING_ERROR(x) ((x) << S_OCSPI0_RX_FRAMING_ERROR)
#define F_OCSPI0_RX_FRAMING_ERROR    V_OCSPI0_RX_FRAMING_ERROR(1U)

#define S_OCSPI1_RX_FRAMING_ERROR    8
#define V_OCSPI1_RX_FRAMING_ERROR(x) ((x) << S_OCSPI1_RX_FRAMING_ERROR)
#define F_OCSPI1_RX_FRAMING_ERROR    V_OCSPI1_RX_FRAMING_ERROR(1U)

#define S_OCSPI0_TX_FRAMING_ERROR    7
#define V_OCSPI0_TX_FRAMING_ERROR(x) ((x) << S_OCSPI0_TX_FRAMING_ERROR)
#define F_OCSPI0_TX_FRAMING_ERROR    V_OCSPI0_TX_FRAMING_ERROR(1U)

#define S_OCSPI1_TX_FRAMING_ERROR    6
#define V_OCSPI1_TX_FRAMING_ERROR(x) ((x) << S_OCSPI1_TX_FRAMING_ERROR)
#define F_OCSPI1_TX_FRAMING_ERROR    V_OCSPI1_TX_FRAMING_ERROR(1U)

#define S_OCSPI0_OFIFO2X_TX_FRAMING_ERROR    5
#define V_OCSPI0_OFIFO2X_TX_FRAMING_ERROR(x) ((x) << S_OCSPI0_OFIFO2X_TX_FRAMING_ERROR)
#define F_OCSPI0_OFIFO2X_TX_FRAMING_ERROR    V_OCSPI0_OFIFO2X_TX_FRAMING_ERROR(1U)

#define S_OCSPI1_OFIFO2X_TX_FRAMING_ERROR    4
#define V_OCSPI1_OFIFO2X_TX_FRAMING_ERROR(x) ((x) << S_OCSPI1_OFIFO2X_TX_FRAMING_ERROR)
#define F_OCSPI1_OFIFO2X_TX_FRAMING_ERROR    V_OCSPI1_OFIFO2X_TX_FRAMING_ERROR(1U)

#define S_OCSPI_PAR_ERROR    3
#define V_OCSPI_PAR_ERROR(x) ((x) << S_OCSPI_PAR_ERROR)
#define F_OCSPI_PAR_ERROR    V_OCSPI_PAR_ERROR(1U)

#define S_DB_OPTIONS_PAR_ERROR    2
#define V_DB_OPTIONS_PAR_ERROR(x) ((x) << S_DB_OPTIONS_PAR_ERROR)
#define F_DB_OPTIONS_PAR_ERROR    V_DB_OPTIONS_PAR_ERROR(1U)

#define S_IESPI_PAR_ERROR    1
#define V_IESPI_PAR_ERROR(x) ((x) << S_IESPI_PAR_ERROR)
#define F_IESPI_PAR_ERROR    V_IESPI_PAR_ERROR(1U)

#define S_E_PCMD_PAR_ERROR    0
#define V_E_PCMD_PAR_ERROR(x) ((x) << S_E_PCMD_PAR_ERROR)
#define F_E_PCMD_PAR_ERROR    V_E_PCMD_PAR_ERROR(1U)

#define S_OSPI_OVERFLOW1    28
#define V_OSPI_OVERFLOW1(x) ((x) << S_OSPI_OVERFLOW1)
#define F_OSPI_OVERFLOW1    V_OSPI_OVERFLOW1(1U)

#define S_OSPI_OVERFLOW0    27
#define V_OSPI_OVERFLOW0(x) ((x) << S_OSPI_OVERFLOW0)
#define F_OSPI_OVERFLOW0    V_OSPI_OVERFLOW0(1U)

#define S_MA_INTF_SDC_ERR    26
#define V_MA_INTF_SDC_ERR(x) ((x) << S_MA_INTF_SDC_ERR)
#define F_MA_INTF_SDC_ERR    V_MA_INTF_SDC_ERR(1U)

#define S_BUNDLE_LEN_PARERR    25
#define V_BUNDLE_LEN_PARERR(x) ((x) << S_BUNDLE_LEN_PARERR)
#define F_BUNDLE_LEN_PARERR    V_BUNDLE_LEN_PARERR(1U)

#define S_BUNDLE_LEN_OVFL    24
#define V_BUNDLE_LEN_OVFL(x) ((x) << S_BUNDLE_LEN_OVFL)
#define F_BUNDLE_LEN_OVFL    V_BUNDLE_LEN_OVFL(1U)

#define S_SDC_ERR    23
#define V_SDC_ERR(x) ((x) << S_SDC_ERR)
#define F_SDC_ERR    V_SDC_ERR(1U)

#define A_PM_RX_INT_CAUSE 0x8fdc
#define A_PM_RX_ISPI_DBG_4B_DATA0 0x10000
#define A_PM_RX_ISPI_DBG_4B_DATA1 0x10001
#define A_PM_RX_ISPI_DBG_4B_DATA2 0x10002
#define A_PM_RX_ISPI_DBG_4B_DATA3 0x10003
#define A_PM_RX_ISPI_DBG_4B_DATA4 0x10004
#define A_PM_RX_ISPI_DBG_4B_DATA5 0x10005
#define A_PM_RX_ISPI_DBG_4B_DATA6 0x10006
#define A_PM_RX_ISPI_DBG_4B_DATA7 0x10007
#define A_PM_RX_ISPI_DBG_4B_DATA8 0x10008
#define A_PM_RX_OSPI_DBG_4B_DATA0 0x10009
#define A_PM_RX_OSPI_DBG_4B_DATA1 0x1000a
#define A_PM_RX_OSPI_DBG_4B_DATA2 0x1000b
#define A_PM_RX_OSPI_DBG_4B_DATA3 0x1000c
#define A_PM_RX_OSPI_DBG_4B_DATA4 0x1000d
#define A_PM_RX_OSPI_DBG_4B_DATA5 0x1000e
#define A_PM_RX_OSPI_DBG_4B_DATA6 0x1000f
#define A_PM_RX_OSPI_DBG_4B_DATA7 0x10010
#define A_PM_RX_OSPI_DBG_4B_DATA8 0x10011
#define A_PM_RX_OSPI_DBG_4B_DATA9 0x10012
#define A_PM_RX_DBG_STAT_MSB 0x10013
#define A_PM_RX_DBG_STAT_LSB 0x10014
#define A_PM_RX_DBG_RSVD_FLIT_CNT 0x10015

#define S_I_TO_O_PATH_RSVD_FLIT_BACKUP    12
#define M_I_TO_O_PATH_RSVD_FLIT_BACKUP    0xfU
#define V_I_TO_O_PATH_RSVD_FLIT_BACKUP(x) ((x) << S_I_TO_O_PATH_RSVD_FLIT_BACKUP)
#define G_I_TO_O_PATH_RSVD_FLIT_BACKUP(x) (((x) >> S_I_TO_O_PATH_RSVD_FLIT_BACKUP) & M_I_TO_O_PATH_RSVD_FLIT_BACKUP)

#define S_I_TO_O_PATH_RSVD_FLIT    8
#define M_I_TO_O_PATH_RSVD_FLIT    0xfU
#define V_I_TO_O_PATH_RSVD_FLIT(x) ((x) << S_I_TO_O_PATH_RSVD_FLIT)
#define G_I_TO_O_PATH_RSVD_FLIT(x) (((x) >> S_I_TO_O_PATH_RSVD_FLIT) & M_I_TO_O_PATH_RSVD_FLIT)

#define S_PRFCH_RSVD_FLIT    4
#define M_PRFCH_RSVD_FLIT    0xfU
#define V_PRFCH_RSVD_FLIT(x) ((x) << S_PRFCH_RSVD_FLIT)
#define G_PRFCH_RSVD_FLIT(x) (((x) >> S_PRFCH_RSVD_FLIT) & M_PRFCH_RSVD_FLIT)

#define S_OSPI_RSVD_FLIT    0
#define M_OSPI_RSVD_FLIT    0xfU
#define V_OSPI_RSVD_FLIT(x) ((x) << S_OSPI_RSVD_FLIT)
#define G_OSPI_RSVD_FLIT(x) (((x) >> S_OSPI_RSVD_FLIT) & M_OSPI_RSVD_FLIT)

#define A_PM_RX_SDC_EN 0x10016

#define S_SDC_EN    0
#define V_SDC_EN(x) ((x) << S_SDC_EN)
#define F_SDC_EN    V_SDC_EN(1U)

#define A_PM_RX_INOUT_FIFO_DBG_CHNL_SEL 0x10017

#define S_CHNL_3_SEL    3
#define V_CHNL_3_SEL(x) ((x) << S_CHNL_3_SEL)
#define F_CHNL_3_SEL    V_CHNL_3_SEL(1U)

#define S_CHNL_2_SEL    2
#define V_CHNL_2_SEL(x) ((x) << S_CHNL_2_SEL)
#define F_CHNL_2_SEL    V_CHNL_2_SEL(1U)

#define S_CHNL_1_SEL    1
#define V_CHNL_1_SEL(x) ((x) << S_CHNL_1_SEL)
#define F_CHNL_1_SEL    V_CHNL_1_SEL(1U)

#define S_CHNL_0_SEL    0
#define V_CHNL_0_SEL(x) ((x) << S_CHNL_0_SEL)
#define F_CHNL_0_SEL    V_CHNL_0_SEL(1U)

#define A_PM_RX_INOUT_FIFO_DBG_WR 0x10018

#define S_O_FIFO_WRITE    3
#define V_O_FIFO_WRITE(x) ((x) << S_O_FIFO_WRITE)
#define F_O_FIFO_WRITE    V_O_FIFO_WRITE(1U)

#define S_I_FIFO_WRITE    2
#define V_I_FIFO_WRITE(x) ((x) << S_I_FIFO_WRITE)
#define F_I_FIFO_WRITE    V_I_FIFO_WRITE(1U)

#define S_O_FIFO_READ    1
#define V_O_FIFO_READ(x) ((x) << S_O_FIFO_READ)
#define F_O_FIFO_READ    V_O_FIFO_READ(1U)

#define S_I_FIFO_READ    0
#define V_I_FIFO_READ(x) ((x) << S_I_FIFO_READ)
#define F_I_FIFO_READ    V_I_FIFO_READ(1U)

#define A_PM_RX_INPUT_FIFO_STR_FWD_EN 0x10019

#define S_ISPI_STR_FWD_EN    0
#define V_ISPI_STR_FWD_EN(x) ((x) << S_ISPI_STR_FWD_EN)
#define F_ISPI_STR_FWD_EN    V_ISPI_STR_FWD_EN(1U)

#define A_PM_RX_PRFTCH_ACROSS_BNDLE_EN 0x1001a

#define S_PRFTCH_ACROSS_BNDLE_EN    0
#define V_PRFTCH_ACROSS_BNDLE_EN(x) ((x) << S_PRFTCH_ACROSS_BNDLE_EN)
#define F_PRFTCH_ACROSS_BNDLE_EN    V_PRFTCH_ACROSS_BNDLE_EN(1U)

#define A_PM_RX_PRFTCH_WRR_ENABLE 0x1001b

#define S_PRFTCH_WRR_ENABLE    0
#define V_PRFTCH_WRR_ENABLE(x) ((x) << S_PRFTCH_WRR_ENABLE)
#define F_PRFTCH_WRR_ENABLE    V_PRFTCH_WRR_ENABLE(1U)

#define A_PM_RX_PRFTCH_WRR_MAX_DEFICIT_CNT 0x1001c

#define S_CHNL1_MAX_DEFICIT_CNT    16
#define M_CHNL1_MAX_DEFICIT_CNT    0xffffU
#define V_CHNL1_MAX_DEFICIT_CNT(x) ((x) << S_CHNL1_MAX_DEFICIT_CNT)
#define G_CHNL1_MAX_DEFICIT_CNT(x) (((x) >> S_CHNL1_MAX_DEFICIT_CNT) & M_CHNL1_MAX_DEFICIT_CNT)

#define S_CHNL0_MAX_DEFICIT_CNT    0
#define M_CHNL0_MAX_DEFICIT_CNT    0xffffU
#define V_CHNL0_MAX_DEFICIT_CNT(x) ((x) << S_CHNL0_MAX_DEFICIT_CNT)
#define G_CHNL0_MAX_DEFICIT_CNT(x) (((x) >> S_CHNL0_MAX_DEFICIT_CNT) & M_CHNL0_MAX_DEFICIT_CNT)

#define A_PM_RX_FEATURE_EN 0x1001d

#define S_PIO_CH_DEFICIT_CTL_EN_RX    0
#define V_PIO_CH_DEFICIT_CTL_EN_RX(x) ((x) << S_PIO_CH_DEFICIT_CTL_EN_RX)
#define F_PIO_CH_DEFICIT_CTL_EN_RX    V_PIO_CH_DEFICIT_CTL_EN_RX(1U)

#define A_PM_RX_CH0_OSPI_DEFICIT_THRSHLD 0x1001e

#define S_CH0_OSPI_DEFICIT_THRSHLD    0
#define M_CH0_OSPI_DEFICIT_THRSHLD    0xfffU
#define V_CH0_OSPI_DEFICIT_THRSHLD(x) ((x) << S_CH0_OSPI_DEFICIT_THRSHLD)
#define G_CH0_OSPI_DEFICIT_THRSHLD(x) (((x) >> S_CH0_OSPI_DEFICIT_THRSHLD) & M_CH0_OSPI_DEFICIT_THRSHLD)

#define A_PM_RX_CH1_OSPI_DEFICIT_THRSHLD 0x1001f

#define S_CH1_OSPI_DEFICIT_THRSHLD    0
#define M_CH1_OSPI_DEFICIT_THRSHLD    0xfffU
#define V_CH1_OSPI_DEFICIT_THRSHLD(x) ((x) << S_CH1_OSPI_DEFICIT_THRSHLD)
#define G_CH1_OSPI_DEFICIT_THRSHLD(x) (((x) >> S_CH1_OSPI_DEFICIT_THRSHLD) & M_CH1_OSPI_DEFICIT_THRSHLD)

#define A_PM_RX_INT_CAUSE_MASK_HALT 0x10020
#define A_PM_RX_DBG_STAT0 0x10021

#define S_RX_RD_I_BUSY    29
#define V_RX_RD_I_BUSY(x) ((x) << S_RX_RD_I_BUSY)
#define F_RX_RD_I_BUSY    V_RX_RD_I_BUSY(1U)

#define S_RX_WR_TO_O_BUSY    28
#define V_RX_WR_TO_O_BUSY(x) ((x) << S_RX_WR_TO_O_BUSY)
#define F_RX_WR_TO_O_BUSY    V_RX_WR_TO_O_BUSY(1U)

#define S_RX_M_TO_O_BUSY    27
#define V_RX_M_TO_O_BUSY(x) ((x) << S_RX_M_TO_O_BUSY)
#define F_RX_M_TO_O_BUSY    V_RX_M_TO_O_BUSY(1U)

#define S_RX_I_TO_M_BUSY    26
#define V_RX_I_TO_M_BUSY(x) ((x) << S_RX_I_TO_M_BUSY)
#define F_RX_I_TO_M_BUSY    V_RX_I_TO_M_BUSY(1U)

#define S_RX_PCMD_FB_ONLY    25
#define V_RX_PCMD_FB_ONLY(x) ((x) << S_RX_PCMD_FB_ONLY)
#define F_RX_PCMD_FB_ONLY    V_RX_PCMD_FB_ONLY(1U)

#define S_RX_PCMD_MEM    24
#define V_RX_PCMD_MEM(x) ((x) << S_RX_PCMD_MEM)
#define F_RX_PCMD_MEM    V_RX_PCMD_MEM(1U)

#define S_RX_PCMD_BYPASS    23
#define V_RX_PCMD_BYPASS(x) ((x) << S_RX_PCMD_BYPASS)
#define F_RX_PCMD_BYPASS    V_RX_PCMD_BYPASS(1U)

#define S_RX_PCMD_EOP    22
#define V_RX_PCMD_EOP(x) ((x) << S_RX_PCMD_EOP)
#define F_RX_PCMD_EOP    V_RX_PCMD_EOP(1U)

#define S_RX_DUMPLICATE_PCMD_EOP    21
#define V_RX_DUMPLICATE_PCMD_EOP(x) ((x) << S_RX_DUMPLICATE_PCMD_EOP)
#define F_RX_DUMPLICATE_PCMD_EOP    V_RX_DUMPLICATE_PCMD_EOP(1U)

#define S_RX_PCMD_EOB    20
#define V_RX_PCMD_EOB(x) ((x) << S_RX_PCMD_EOB)
#define F_RX_PCMD_EOB    V_RX_PCMD_EOB(1U)

#define S_RX_PCMD_FB    16
#define M_RX_PCMD_FB    0xfU
#define V_RX_PCMD_FB(x) ((x) << S_RX_PCMD_FB)
#define G_RX_PCMD_FB(x) (((x) >> S_RX_PCMD_FB) & M_RX_PCMD_FB)

#define S_RX_PCMD_LEN    0
#define M_RX_PCMD_LEN    0xffffU
#define V_RX_PCMD_LEN(x) ((x) << S_RX_PCMD_LEN)
#define G_RX_PCMD_LEN(x) (((x) >> S_RX_PCMD_LEN) & M_RX_PCMD_LEN)

#define A_PM_RX_DBG_STAT1 0x10022

#define S_RX_PCMD0_MEM    30
#define V_RX_PCMD0_MEM(x) ((x) << S_RX_PCMD0_MEM)
#define F_RX_PCMD0_MEM    V_RX_PCMD0_MEM(1U)

#define S_RX_FREE_OSPI_CNT0    18
#define M_RX_FREE_OSPI_CNT0    0xfffU
#define V_RX_FREE_OSPI_CNT0(x) ((x) << S_RX_FREE_OSPI_CNT0)
#define G_RX_FREE_OSPI_CNT0(x) (((x) >> S_RX_FREE_OSPI_CNT0) & M_RX_FREE_OSPI_CNT0)

#define S_RX_PCMD0_FLIT_LEN    6
#define M_RX_PCMD0_FLIT_LEN    0xfffU
#define V_RX_PCMD0_FLIT_LEN(x) ((x) << S_RX_PCMD0_FLIT_LEN)
#define G_RX_PCMD0_FLIT_LEN(x) (((x) >> S_RX_PCMD0_FLIT_LEN) & M_RX_PCMD0_FLIT_LEN)

#define S_RX_PCMD0_CMD    2
#define M_RX_PCMD0_CMD    0xfU
#define V_RX_PCMD0_CMD(x) ((x) << S_RX_PCMD0_CMD)
#define G_RX_PCMD0_CMD(x) (((x) >> S_RX_PCMD0_CMD) & M_RX_PCMD0_CMD)

#define S_RX_OFIFO_FULL0    1
#define V_RX_OFIFO_FULL0(x) ((x) << S_RX_OFIFO_FULL0)
#define F_RX_OFIFO_FULL0    V_RX_OFIFO_FULL0(1U)

#define S_RX_PCMD0_BYPASS    0
#define V_RX_PCMD0_BYPASS(x) ((x) << S_RX_PCMD0_BYPASS)
#define F_RX_PCMD0_BYPASS    V_RX_PCMD0_BYPASS(1U)

#define A_PM_RX_DBG_STAT2 0x10023

#define S_RX_PCMD1_MEM    30
#define V_RX_PCMD1_MEM(x) ((x) << S_RX_PCMD1_MEM)
#define F_RX_PCMD1_MEM    V_RX_PCMD1_MEM(1U)

#define S_RX_FREE_OSPI_CNT1    18
#define M_RX_FREE_OSPI_CNT1    0xfffU
#define V_RX_FREE_OSPI_CNT1(x) ((x) << S_RX_FREE_OSPI_CNT1)
#define G_RX_FREE_OSPI_CNT1(x) (((x) >> S_RX_FREE_OSPI_CNT1) & M_RX_FREE_OSPI_CNT1)

#define S_RX_PCMD1_FLIT_LEN    6
#define M_RX_PCMD1_FLIT_LEN    0xfffU
#define V_RX_PCMD1_FLIT_LEN(x) ((x) << S_RX_PCMD1_FLIT_LEN)
#define G_RX_PCMD1_FLIT_LEN(x) (((x) >> S_RX_PCMD1_FLIT_LEN) & M_RX_PCMD1_FLIT_LEN)

#define S_RX_PCMD1_CMD    2
#define M_RX_PCMD1_CMD    0xfU
#define V_RX_PCMD1_CMD(x) ((x) << S_RX_PCMD1_CMD)
#define G_RX_PCMD1_CMD(x) (((x) >> S_RX_PCMD1_CMD) & M_RX_PCMD1_CMD)

#define S_RX_OFIFO_FULL1    1
#define V_RX_OFIFO_FULL1(x) ((x) << S_RX_OFIFO_FULL1)
#define F_RX_OFIFO_FULL1    V_RX_OFIFO_FULL1(1U)

#define S_RX_PCMD1_BYPASS    0
#define V_RX_PCMD1_BYPASS(x) ((x) << S_RX_PCMD1_BYPASS)
#define F_RX_PCMD1_BYPASS    V_RX_PCMD1_BYPASS(1U)

#define A_PM_RX_DBG_STAT3 0x10024

#define S_RX_SET_PCMD_RES_RDY_RD    10
#define M_RX_SET_PCMD_RES_RDY_RD    0x3U
#define V_RX_SET_PCMD_RES_RDY_RD(x) ((x) << S_RX_SET_PCMD_RES_RDY_RD)
#define G_RX_SET_PCMD_RES_RDY_RD(x) (((x) >> S_RX_SET_PCMD_RES_RDY_RD) & M_RX_SET_PCMD_RES_RDY_RD)

#define S_RX_ISSUED_PREFETCH_RD_E_CLR    8
#define M_RX_ISSUED_PREFETCH_RD_E_CLR    0x3U
#define V_RX_ISSUED_PREFETCH_RD_E_CLR(x) ((x) << S_RX_ISSUED_PREFETCH_RD_E_CLR)
#define G_RX_ISSUED_PREFETCH_RD_E_CLR(x) (((x) >> S_RX_ISSUED_PREFETCH_RD_E_CLR) & M_RX_ISSUED_PREFETCH_RD_E_CLR)

#define S_RX_ISSUED_PREFETCH_RD    6
#define M_RX_ISSUED_PREFETCH_RD    0x3U
#define V_RX_ISSUED_PREFETCH_RD(x) ((x) << S_RX_ISSUED_PREFETCH_RD)
#define G_RX_ISSUED_PREFETCH_RD(x) (((x) >> S_RX_ISSUED_PREFETCH_RD) & M_RX_ISSUED_PREFETCH_RD)

#define S_RX_PCMD_RES_RDY    4
#define M_RX_PCMD_RES_RDY    0x3U
#define V_RX_PCMD_RES_RDY(x) ((x) << S_RX_PCMD_RES_RDY)
#define G_RX_PCMD_RES_RDY(x) (((x) >> S_RX_PCMD_RES_RDY) & M_RX_PCMD_RES_RDY)

#define S_RX_DB_VLD    3
#define V_RX_DB_VLD(x) ((x) << S_RX_DB_VLD)
#define F_RX_DB_VLD    V_RX_DB_VLD(1U)

#define S_RX_FIRST_BUNDLE    1
#define M_RX_FIRST_BUNDLE    0x3U
#define V_RX_FIRST_BUNDLE(x) ((x) << S_RX_FIRST_BUNDLE)
#define G_RX_FIRST_BUNDLE(x) (((x) >> S_RX_FIRST_BUNDLE) & M_RX_FIRST_BUNDLE)

#define S_RX_SDC_DRDY    0
#define V_RX_SDC_DRDY(x) ((x) << S_RX_SDC_DRDY)
#define F_RX_SDC_DRDY    V_RX_SDC_DRDY(1U)

#define A_PM_RX_DBG_STAT4 0x10025

#define S_RX_PCMD_VLD    26
#define V_RX_PCMD_VLD(x) ((x) << S_RX_PCMD_VLD)
#define F_RX_PCMD_VLD    V_RX_PCMD_VLD(1U)

#define S_RX_PCMD_TO_CH    25
#define V_RX_PCMD_TO_CH(x) ((x) << S_RX_PCMD_TO_CH)
#define F_RX_PCMD_TO_CH    V_RX_PCMD_TO_CH(1U)

#define S_RX_PCMD_FROM_CH    23
#define M_RX_PCMD_FROM_CH    0x3U
#define V_RX_PCMD_FROM_CH(x) ((x) << S_RX_PCMD_FROM_CH)
#define G_RX_PCMD_FROM_CH(x) (((x) >> S_RX_PCMD_FROM_CH) & M_RX_PCMD_FROM_CH)

#define S_RX_LINE    18
#define M_RX_LINE    0x1fU
#define V_RX_LINE(x) ((x) << S_RX_LINE)
#define G_RX_LINE(x) (((x) >> S_RX_LINE) & M_RX_LINE)

#define S_RX_IESPI_TXVALID    14
#define M_RX_IESPI_TXVALID    0xfU
#define V_RX_IESPI_TXVALID(x) ((x) << S_RX_IESPI_TXVALID)
#define G_RX_IESPI_TXVALID(x) (((x) >> S_RX_IESPI_TXVALID) & M_RX_IESPI_TXVALID)

#define S_RX_IESPI_TXFULL    10
#define M_RX_IESPI_TXFULL    0xfU
#define V_RX_IESPI_TXFULL(x) ((x) << S_RX_IESPI_TXFULL)
#define G_RX_IESPI_TXFULL(x) (((x) >> S_RX_IESPI_TXFULL) & M_RX_IESPI_TXFULL)

#define S_RX_PCMD_SRDY    8
#define M_RX_PCMD_SRDY    0x3U
#define V_RX_PCMD_SRDY(x) ((x) << S_RX_PCMD_SRDY)
#define G_RX_PCMD_SRDY(x) (((x) >> S_RX_PCMD_SRDY) & M_RX_PCMD_SRDY)

#define S_RX_PCMD_DRDY    6
#define M_RX_PCMD_DRDY    0x3U
#define V_RX_PCMD_DRDY(x) ((x) << S_RX_PCMD_DRDY)
#define G_RX_PCMD_DRDY(x) (((x) >> S_RX_PCMD_DRDY) & M_RX_PCMD_DRDY)

#define S_RX_PCMD_CMD    2
#define M_RX_PCMD_CMD    0xfU
#define V_RX_PCMD_CMD(x) ((x) << S_RX_PCMD_CMD)
#define G_RX_PCMD_CMD(x) (((x) >> S_RX_PCMD_CMD) & M_RX_PCMD_CMD)

#define S_DUPLICATE    0
#define M_DUPLICATE    0x3U
#define V_DUPLICATE(x) ((x) << S_DUPLICATE)
#define G_DUPLICATE(x) (((x) >> S_DUPLICATE) & M_DUPLICATE)

#define A_PM_RX_DBG_STAT5 0x10026

#define S_RX_ATLST_1_PCMD_CH1    29
#define V_RX_ATLST_1_PCMD_CH1(x) ((x) << S_RX_ATLST_1_PCMD_CH1)
#define F_RX_ATLST_1_PCMD_CH1    V_RX_ATLST_1_PCMD_CH1(1U)

#define S_RX_ATLST_1_PCMD_CH0    28
#define V_RX_ATLST_1_PCMD_CH0(x) ((x) << S_RX_ATLST_1_PCMD_CH0)
#define F_RX_ATLST_1_PCMD_CH0    V_RX_ATLST_1_PCMD_CH0(1U)

#define S_RX_ISPI_TXVALID    20
#define M_RX_ISPI_TXVALID    0xfU
#define V_RX_ISPI_TXVALID(x) ((x) << S_RX_ISPI_TXVALID)
#define G_RX_ISPI_TXVALID(x) (((x) >> S_RX_ISPI_TXVALID) & M_RX_ISPI_TXVALID)

#define S_RX_ISPI_FULL    16
#define M_RX_ISPI_FULL    0xfU
#define V_RX_ISPI_FULL(x) ((x) << S_RX_ISPI_FULL)
#define G_RX_ISPI_FULL(x) (((x) >> S_RX_ISPI_FULL) & M_RX_ISPI_FULL)

#define S_RX_OSPI_TXVALID    14
#define M_RX_OSPI_TXVALID    0x3U
#define V_RX_OSPI_TXVALID(x) ((x) << S_RX_OSPI_TXVALID)
#define G_RX_OSPI_TXVALID(x) (((x) >> S_RX_OSPI_TXVALID) & M_RX_OSPI_TXVALID)

#define S_RX_OSPI_FULL    12
#define M_RX_OSPI_FULL    0x3U
#define V_RX_OSPI_FULL(x) ((x) << S_RX_OSPI_FULL)
#define G_RX_OSPI_FULL(x) (((x) >> S_RX_OSPI_FULL) & M_RX_OSPI_FULL)

#define S_RX_E_RXVALID    8
#define M_RX_E_RXVALID    0xfU
#define V_RX_E_RXVALID(x) ((x) << S_RX_E_RXVALID)
#define G_RX_E_RXVALID(x) (((x) >> S_RX_E_RXVALID) & M_RX_E_RXVALID)

#define S_RX_E_RXAFULL    4
#define M_RX_E_RXAFULL    0xfU
#define V_RX_E_RXAFULL(x) ((x) << S_RX_E_RXAFULL)
#define G_RX_E_RXAFULL(x) (((x) >> S_RX_E_RXAFULL) & M_RX_E_RXAFULL)

#define S_RX_C_TXVALID    2
#define M_RX_C_TXVALID    0x3U
#define V_RX_C_TXVALID(x) ((x) << S_RX_C_TXVALID)
#define G_RX_C_TXVALID(x) (((x) >> S_RX_C_TXVALID) & M_RX_C_TXVALID)

#define S_RX_C_TXAFULL    0
#define M_RX_C_TXAFULL    0x3U
#define V_RX_C_TXAFULL(x) ((x) << S_RX_C_TXAFULL)
#define G_RX_C_TXAFULL(x) (((x) >> S_RX_C_TXAFULL) & M_RX_C_TXAFULL)

#define A_PM_RX_DBG_STAT6 0x10027

#define S_RX_M_INTRNL_FIFO_CNT    4
#define M_RX_M_INTRNL_FIFO_CNT    0x3U
#define V_RX_M_INTRNL_FIFO_CNT(x) ((x) << S_RX_M_INTRNL_FIFO_CNT)
#define G_RX_M_INTRNL_FIFO_CNT(x) (((x) >> S_RX_M_INTRNL_FIFO_CNT) & M_RX_M_INTRNL_FIFO_CNT)

#define S_RX_M_REQADDRRDY    3
#define V_RX_M_REQADDRRDY(x) ((x) << S_RX_M_REQADDRRDY)
#define F_RX_M_REQADDRRDY    V_RX_M_REQADDRRDY(1U)

#define S_RX_M_REQWRITE    2
#define V_RX_M_REQWRITE(x) ((x) << S_RX_M_REQWRITE)
#define F_RX_M_REQWRITE    V_RX_M_REQWRITE(1U)

#define S_RX_M_REQDATAVLD    1
#define V_RX_M_REQDATAVLD(x) ((x) << S_RX_M_REQDATAVLD)
#define F_RX_M_REQDATAVLD    V_RX_M_REQDATAVLD(1U)

#define S_RX_M_REQDATARDY    0
#define V_RX_M_REQDATARDY(x) ((x) << S_RX_M_REQDATARDY)
#define F_RX_M_REQDATARDY    V_RX_M_REQDATARDY(1U)

#define A_PM_RX_DBG_STAT7 0x10028

#define S_RX_PCMD1_FREE_CNT    7
#define M_RX_PCMD1_FREE_CNT    0x7fU
#define V_RX_PCMD1_FREE_CNT(x) ((x) << S_RX_PCMD1_FREE_CNT)
#define G_RX_PCMD1_FREE_CNT(x) (((x) >> S_RX_PCMD1_FREE_CNT) & M_RX_PCMD1_FREE_CNT)

#define S_RX_PCMD0_FREE_CNT    0
#define M_RX_PCMD0_FREE_CNT    0x7fU
#define V_RX_PCMD0_FREE_CNT(x) ((x) << S_RX_PCMD0_FREE_CNT)
#define G_RX_PCMD0_FREE_CNT(x) (((x) >> S_RX_PCMD0_FREE_CNT) & M_RX_PCMD0_FREE_CNT)

#define A_PM_RX_DBG_STAT8 0x10029

#define S_RX_IN_EOP_CNT3    28
#define M_RX_IN_EOP_CNT3    0xfU
#define V_RX_IN_EOP_CNT3(x) ((x) << S_RX_IN_EOP_CNT3)
#define G_RX_IN_EOP_CNT3(x) (((x) >> S_RX_IN_EOP_CNT3) & M_RX_IN_EOP_CNT3)

#define S_RX_IN_EOP_CNT2    24
#define M_RX_IN_EOP_CNT2    0xfU
#define V_RX_IN_EOP_CNT2(x) ((x) << S_RX_IN_EOP_CNT2)
#define G_RX_IN_EOP_CNT2(x) (((x) >> S_RX_IN_EOP_CNT2) & M_RX_IN_EOP_CNT2)

#define S_RX_IN_EOP_CNT1    20
#define M_RX_IN_EOP_CNT1    0xfU
#define V_RX_IN_EOP_CNT1(x) ((x) << S_RX_IN_EOP_CNT1)
#define G_RX_IN_EOP_CNT1(x) (((x) >> S_RX_IN_EOP_CNT1) & M_RX_IN_EOP_CNT1)

#define S_RX_IN_EOP_CNT0    16
#define M_RX_IN_EOP_CNT0    0xfU
#define V_RX_IN_EOP_CNT0(x) ((x) << S_RX_IN_EOP_CNT0)
#define G_RX_IN_EOP_CNT0(x) (((x) >> S_RX_IN_EOP_CNT0) & M_RX_IN_EOP_CNT0)

#define S_RX_IN_SOP_CNT3    12
#define M_RX_IN_SOP_CNT3    0xfU
#define V_RX_IN_SOP_CNT3(x) ((x) << S_RX_IN_SOP_CNT3)
#define G_RX_IN_SOP_CNT3(x) (((x) >> S_RX_IN_SOP_CNT3) & M_RX_IN_SOP_CNT3)

#define S_RX_IN_SOP_CNT2    8
#define M_RX_IN_SOP_CNT2    0xfU
#define V_RX_IN_SOP_CNT2(x) ((x) << S_RX_IN_SOP_CNT2)
#define G_RX_IN_SOP_CNT2(x) (((x) >> S_RX_IN_SOP_CNT2) & M_RX_IN_SOP_CNT2)

#define S_RX_IN_SOP_CNT1    4
#define M_RX_IN_SOP_CNT1    0xfU
#define V_RX_IN_SOP_CNT1(x) ((x) << S_RX_IN_SOP_CNT1)
#define G_RX_IN_SOP_CNT1(x) (((x) >> S_RX_IN_SOP_CNT1) & M_RX_IN_SOP_CNT1)

#define S_RX_IN_SOP_CNT0    0
#define M_RX_IN_SOP_CNT0    0xfU
#define V_RX_IN_SOP_CNT0(x) ((x) << S_RX_IN_SOP_CNT0)
#define G_RX_IN_SOP_CNT0(x) (((x) >> S_RX_IN_SOP_CNT0) & M_RX_IN_SOP_CNT0)

#define A_PM_RX_DBG_STAT9 0x1002a

#define S_RX_RSVD0    28
#define M_RX_RSVD0    0xfU
#define V_RX_RSVD0(x) ((x) << S_RX_RSVD0)
#define G_RX_RSVD0(x) (((x) >> S_RX_RSVD0) & M_RX_RSVD0)

#define S_RX_RSVD1    24
#define M_RX_RSVD1    0xfU
#define V_RX_RSVD1(x) ((x) << S_RX_RSVD1)
#define G_RX_RSVD1(x) (((x) >> S_RX_RSVD1) & M_RX_RSVD1)

#define S_RX_OUT_EOP_CNT1    20
#define M_RX_OUT_EOP_CNT1    0xfU
#define V_RX_OUT_EOP_CNT1(x) ((x) << S_RX_OUT_EOP_CNT1)
#define G_RX_OUT_EOP_CNT1(x) (((x) >> S_RX_OUT_EOP_CNT1) & M_RX_OUT_EOP_CNT1)

#define S_RX_OUT_EOP_CNT0    16
#define M_RX_OUT_EOP_CNT0    0xfU
#define V_RX_OUT_EOP_CNT0(x) ((x) << S_RX_OUT_EOP_CNT0)
#define G_RX_OUT_EOP_CNT0(x) (((x) >> S_RX_OUT_EOP_CNT0) & M_RX_OUT_EOP_CNT0)

#define S_RX_RSVD2    12
#define M_RX_RSVD2    0xfU
#define V_RX_RSVD2(x) ((x) << S_RX_RSVD2)
#define G_RX_RSVD2(x) (((x) >> S_RX_RSVD2) & M_RX_RSVD2)

#define S_RX_RSVD3    8
#define M_RX_RSVD3    0xfU
#define V_RX_RSVD3(x) ((x) << S_RX_RSVD3)
#define G_RX_RSVD3(x) (((x) >> S_RX_RSVD3) & M_RX_RSVD3)

#define S_RX_OUT_SOP_CNT1    4
#define M_RX_OUT_SOP_CNT1    0xfU
#define V_RX_OUT_SOP_CNT1(x) ((x) << S_RX_OUT_SOP_CNT1)
#define G_RX_OUT_SOP_CNT1(x) (((x) >> S_RX_OUT_SOP_CNT1) & M_RX_OUT_SOP_CNT1)

#define S_RX_OUT_SOP_CNT0    0
#define M_RX_OUT_SOP_CNT0    0xfU
#define V_RX_OUT_SOP_CNT0(x) ((x) << S_RX_OUT_SOP_CNT0)
#define G_RX_OUT_SOP_CNT0(x) (((x) >> S_RX_OUT_SOP_CNT0) & M_RX_OUT_SOP_CNT0)

#define A_PM_RX_DBG_STAT10 0x1002b

#define S_RX_CH_DEFICIT_BLOWED    24
#define V_RX_CH_DEFICIT_BLOWED(x) ((x) << S_RX_CH_DEFICIT_BLOWED)
#define F_RX_CH_DEFICIT_BLOWED    V_RX_CH_DEFICIT_BLOWED(1U)

#define S_RX_CH1_DEFICIT    12
#define M_RX_CH1_DEFICIT    0xfffU
#define V_RX_CH1_DEFICIT(x) ((x) << S_RX_CH1_DEFICIT)
#define G_RX_CH1_DEFICIT(x) (((x) >> S_RX_CH1_DEFICIT) & M_RX_CH1_DEFICIT)

#define S_RX_CH0_DEFICIT    0
#define M_RX_CH0_DEFICIT    0xfffU
#define V_RX_CH0_DEFICIT(x) ((x) << S_RX_CH0_DEFICIT)
#define G_RX_CH0_DEFICIT(x) (((x) >> S_RX_CH0_DEFICIT) & M_RX_CH0_DEFICIT)

#define A_PM_RX_DBG_STAT11 0x1002c

#define S_RX_BUNDLE_LEN_SRDY    30
#define M_RX_BUNDLE_LEN_SRDY    0x3U
#define V_RX_BUNDLE_LEN_SRDY(x) ((x) << S_RX_BUNDLE_LEN_SRDY)
#define G_RX_BUNDLE_LEN_SRDY(x) (((x) >> S_RX_BUNDLE_LEN_SRDY) & M_RX_BUNDLE_LEN_SRDY)

#define S_RX_RSVD11_1    28
#define M_RX_RSVD11_1    0x3U
#define V_RX_RSVD11_1(x) ((x) << S_RX_RSVD11_1)
#define G_RX_RSVD11_1(x) (((x) >> S_RX_RSVD11_1) & M_RX_RSVD11_1)

#define S_RX_BUNDLE_LEN1    16
#define M_RX_BUNDLE_LEN1    0xfffU
#define V_RX_BUNDLE_LEN1(x) ((x) << S_RX_BUNDLE_LEN1)
#define G_RX_BUNDLE_LEN1(x) (((x) >> S_RX_BUNDLE_LEN1) & M_RX_BUNDLE_LEN1)

#define S_RX_RSVD11    12
#define M_RX_RSVD11    0xfU
#define V_RX_RSVD11(x) ((x) << S_RX_RSVD11)
#define G_RX_RSVD11(x) (((x) >> S_RX_RSVD11) & M_RX_RSVD11)

#define S_RX_BUNDLE_LEN0    0
#define M_RX_BUNDLE_LEN0    0xfffU
#define V_RX_BUNDLE_LEN0(x) ((x) << S_RX_BUNDLE_LEN0)
#define G_RX_BUNDLE_LEN0(x) (((x) >> S_RX_BUNDLE_LEN0) & M_RX_BUNDLE_LEN0)

/* registers for module PM_TX */
#define PM_TX_BASE_ADDR 0x8fe0

#define A_PM_TX_CFG 0x8fe0

#define S_CH3_OUTPUT    17
#define M_CH3_OUTPUT    0x1fU
#define V_CH3_OUTPUT(x) ((x) << S_CH3_OUTPUT)
#define G_CH3_OUTPUT(x) (((x) >> S_CH3_OUTPUT) & M_CH3_OUTPUT)

#define A_PM_TX_MODE 0x8fe4

#define S_CONG_THRESH3    25
#define M_CONG_THRESH3    0x7fU
#define V_CONG_THRESH3(x) ((x) << S_CONG_THRESH3)
#define G_CONG_THRESH3(x) (((x) >> S_CONG_THRESH3) & M_CONG_THRESH3)

#define S_CONG_THRESH2    18
#define M_CONG_THRESH2    0x7fU
#define V_CONG_THRESH2(x) ((x) << S_CONG_THRESH2)
#define G_CONG_THRESH2(x) (((x) >> S_CONG_THRESH2) & M_CONG_THRESH2)

#define S_CONG_THRESH1    11
#define M_CONG_THRESH1    0x7fU
#define V_CONG_THRESH1(x) ((x) << S_CONG_THRESH1)
#define G_CONG_THRESH1(x) (((x) >> S_CONG_THRESH1) & M_CONG_THRESH1)

#define S_CONG_THRESH0    4
#define M_CONG_THRESH0    0x7fU
#define V_CONG_THRESH0(x) ((x) << S_CONG_THRESH0)
#define G_CONG_THRESH0(x) (((x) >> S_CONG_THRESH0) & M_CONG_THRESH0)

#define S_TX_USE_BUNDLE_LEN    3
#define V_TX_USE_BUNDLE_LEN(x) ((x) << S_TX_USE_BUNDLE_LEN)
#define F_TX_USE_BUNDLE_LEN    V_TX_USE_BUNDLE_LEN(1U)

#define S_STAT_CHANNEL    1
#define M_STAT_CHANNEL    0x3U
#define V_STAT_CHANNEL(x) ((x) << S_STAT_CHANNEL)
#define G_STAT_CHANNEL(x) (((x) >> S_STAT_CHANNEL) & M_STAT_CHANNEL)

#define A_PM_TX_STAT_CONFIG 0x8fe8
#define A_PM_TX_STAT_COUNT 0x8fec
#define A_PM_TX_STAT_LSB 0x8ff0
#define A_PM_TX_DBG_CTRL 0x8ff0

#define S_OSPIWRBUSY    21
#define M_OSPIWRBUSY    0xfU
#define V_OSPIWRBUSY(x) ((x) << S_OSPIWRBUSY)
#define G_OSPIWRBUSY(x) (((x) >> S_OSPIWRBUSY) & M_OSPIWRBUSY)

#define A_PM_TX_STAT_MSB 0x8ff4
#define A_PM_TX_DBG_DATA 0x8ff4
#define A_PM_TX_INT_ENABLE 0x8ff8

#define S_PCMD_LEN_OVFL0    31
#define V_PCMD_LEN_OVFL0(x) ((x) << S_PCMD_LEN_OVFL0)
#define F_PCMD_LEN_OVFL0    V_PCMD_LEN_OVFL0(1U)

#define S_PCMD_LEN_OVFL1    30
#define V_PCMD_LEN_OVFL1(x) ((x) << S_PCMD_LEN_OVFL1)
#define F_PCMD_LEN_OVFL1    V_PCMD_LEN_OVFL1(1U)

#define S_PCMD_LEN_OVFL2    29
#define V_PCMD_LEN_OVFL2(x) ((x) << S_PCMD_LEN_OVFL2)
#define F_PCMD_LEN_OVFL2    V_PCMD_LEN_OVFL2(1U)

#define S_ZERO_C_CMD_ERRO    28
#define V_ZERO_C_CMD_ERRO(x) ((x) << S_ZERO_C_CMD_ERRO)
#define F_ZERO_C_CMD_ERRO    V_ZERO_C_CMD_ERRO(1U)

#define S_ICSPI0_FIFO2X_RX_FRAMING_ERROR    27
#define V_ICSPI0_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_ICSPI0_FIFO2X_RX_FRAMING_ERROR)
#define F_ICSPI0_FIFO2X_RX_FRAMING_ERROR    V_ICSPI0_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_ICSPI1_FIFO2X_RX_FRAMING_ERROR    26
#define V_ICSPI1_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_ICSPI1_FIFO2X_RX_FRAMING_ERROR)
#define F_ICSPI1_FIFO2X_RX_FRAMING_ERROR    V_ICSPI1_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_ICSPI2_FIFO2X_RX_FRAMING_ERROR    25
#define V_ICSPI2_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_ICSPI2_FIFO2X_RX_FRAMING_ERROR)
#define F_ICSPI2_FIFO2X_RX_FRAMING_ERROR    V_ICSPI2_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_ICSPI3_FIFO2X_RX_FRAMING_ERROR    24
#define V_ICSPI3_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_ICSPI3_FIFO2X_RX_FRAMING_ERROR)
#define F_ICSPI3_FIFO2X_RX_FRAMING_ERROR    V_ICSPI3_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_ICSPI0_RX_FRAMING_ERROR    23
#define V_ICSPI0_RX_FRAMING_ERROR(x) ((x) << S_ICSPI0_RX_FRAMING_ERROR)
#define F_ICSPI0_RX_FRAMING_ERROR    V_ICSPI0_RX_FRAMING_ERROR(1U)

#define S_ICSPI1_RX_FRAMING_ERROR    22
#define V_ICSPI1_RX_FRAMING_ERROR(x) ((x) << S_ICSPI1_RX_FRAMING_ERROR)
#define F_ICSPI1_RX_FRAMING_ERROR    V_ICSPI1_RX_FRAMING_ERROR(1U)

#define S_ICSPI2_RX_FRAMING_ERROR    21
#define V_ICSPI2_RX_FRAMING_ERROR(x) ((x) << S_ICSPI2_RX_FRAMING_ERROR)
#define F_ICSPI2_RX_FRAMING_ERROR    V_ICSPI2_RX_FRAMING_ERROR(1U)

#define S_ICSPI3_RX_FRAMING_ERROR    20
#define V_ICSPI3_RX_FRAMING_ERROR(x) ((x) << S_ICSPI3_RX_FRAMING_ERROR)
#define F_ICSPI3_RX_FRAMING_ERROR    V_ICSPI3_RX_FRAMING_ERROR(1U)

#define S_ICSPI0_TX_FRAMING_ERROR    19
#define V_ICSPI0_TX_FRAMING_ERROR(x) ((x) << S_ICSPI0_TX_FRAMING_ERROR)
#define F_ICSPI0_TX_FRAMING_ERROR    V_ICSPI0_TX_FRAMING_ERROR(1U)

#define S_ICSPI1_TX_FRAMING_ERROR    18
#define V_ICSPI1_TX_FRAMING_ERROR(x) ((x) << S_ICSPI1_TX_FRAMING_ERROR)
#define F_ICSPI1_TX_FRAMING_ERROR    V_ICSPI1_TX_FRAMING_ERROR(1U)

#define S_ICSPI2_TX_FRAMING_ERROR    17
#define V_ICSPI2_TX_FRAMING_ERROR(x) ((x) << S_ICSPI2_TX_FRAMING_ERROR)
#define F_ICSPI2_TX_FRAMING_ERROR    V_ICSPI2_TX_FRAMING_ERROR(1U)

#define S_ICSPI3_TX_FRAMING_ERROR    16
#define V_ICSPI3_TX_FRAMING_ERROR(x) ((x) << S_ICSPI3_TX_FRAMING_ERROR)
#define F_ICSPI3_TX_FRAMING_ERROR    V_ICSPI3_TX_FRAMING_ERROR(1U)

#define S_OESPI0_RX_FRAMING_ERROR    15
#define V_OESPI0_RX_FRAMING_ERROR(x) ((x) << S_OESPI0_RX_FRAMING_ERROR)
#define F_OESPI0_RX_FRAMING_ERROR    V_OESPI0_RX_FRAMING_ERROR(1U)

#define S_OESPI1_RX_FRAMING_ERROR    14
#define V_OESPI1_RX_FRAMING_ERROR(x) ((x) << S_OESPI1_RX_FRAMING_ERROR)
#define F_OESPI1_RX_FRAMING_ERROR    V_OESPI1_RX_FRAMING_ERROR(1U)

#define S_OESPI2_RX_FRAMING_ERROR    13
#define V_OESPI2_RX_FRAMING_ERROR(x) ((x) << S_OESPI2_RX_FRAMING_ERROR)
#define F_OESPI2_RX_FRAMING_ERROR    V_OESPI2_RX_FRAMING_ERROR(1U)

#define S_OESPI3_RX_FRAMING_ERROR    12
#define V_OESPI3_RX_FRAMING_ERROR(x) ((x) << S_OESPI3_RX_FRAMING_ERROR)
#define F_OESPI3_RX_FRAMING_ERROR    V_OESPI3_RX_FRAMING_ERROR(1U)

#define S_OESPI0_TX_FRAMING_ERROR    11
#define V_OESPI0_TX_FRAMING_ERROR(x) ((x) << S_OESPI0_TX_FRAMING_ERROR)
#define F_OESPI0_TX_FRAMING_ERROR    V_OESPI0_TX_FRAMING_ERROR(1U)

#define S_OESPI1_TX_FRAMING_ERROR    10
#define V_OESPI1_TX_FRAMING_ERROR(x) ((x) << S_OESPI1_TX_FRAMING_ERROR)
#define F_OESPI1_TX_FRAMING_ERROR    V_OESPI1_TX_FRAMING_ERROR(1U)

#define S_OESPI2_TX_FRAMING_ERROR    9
#define V_OESPI2_TX_FRAMING_ERROR(x) ((x) << S_OESPI2_TX_FRAMING_ERROR)
#define F_OESPI2_TX_FRAMING_ERROR    V_OESPI2_TX_FRAMING_ERROR(1U)

#define S_OESPI3_TX_FRAMING_ERROR    8
#define V_OESPI3_TX_FRAMING_ERROR(x) ((x) << S_OESPI3_TX_FRAMING_ERROR)
#define F_OESPI3_TX_FRAMING_ERROR    V_OESPI3_TX_FRAMING_ERROR(1U)

#define S_OESPI0_OFIFO2X_TX_FRAMING_ERROR    7
#define V_OESPI0_OFIFO2X_TX_FRAMING_ERROR(x) ((x) << S_OESPI0_OFIFO2X_TX_FRAMING_ERROR)
#define F_OESPI0_OFIFO2X_TX_FRAMING_ERROR    V_OESPI0_OFIFO2X_TX_FRAMING_ERROR(1U)

#define S_OESPI1_OFIFO2X_TX_FRAMING_ERROR    6
#define V_OESPI1_OFIFO2X_TX_FRAMING_ERROR(x) ((x) << S_OESPI1_OFIFO2X_TX_FRAMING_ERROR)
#define F_OESPI1_OFIFO2X_TX_FRAMING_ERROR    V_OESPI1_OFIFO2X_TX_FRAMING_ERROR(1U)

#define S_OESPI2_OFIFO2X_TX_FRAMING_ERROR    5
#define V_OESPI2_OFIFO2X_TX_FRAMING_ERROR(x) ((x) << S_OESPI2_OFIFO2X_TX_FRAMING_ERROR)
#define F_OESPI2_OFIFO2X_TX_FRAMING_ERROR    V_OESPI2_OFIFO2X_TX_FRAMING_ERROR(1U)

#define S_OESPI3_OFIFO2X_TX_FRAMING_ERROR    4
#define V_OESPI3_OFIFO2X_TX_FRAMING_ERROR(x) ((x) << S_OESPI3_OFIFO2X_TX_FRAMING_ERROR)
#define F_OESPI3_OFIFO2X_TX_FRAMING_ERROR    V_OESPI3_OFIFO2X_TX_FRAMING_ERROR(1U)

#define S_OESPI_PAR_ERROR    3
#define V_OESPI_PAR_ERROR(x) ((x) << S_OESPI_PAR_ERROR)
#define F_OESPI_PAR_ERROR    V_OESPI_PAR_ERROR(1U)

#define S_ICSPI_PAR_ERROR    1
#define V_ICSPI_PAR_ERROR(x) ((x) << S_ICSPI_PAR_ERROR)
#define F_ICSPI_PAR_ERROR    V_ICSPI_PAR_ERROR(1U)

#define S_C_PCMD_PAR_ERROR    0
#define V_C_PCMD_PAR_ERROR(x) ((x) << S_C_PCMD_PAR_ERROR)
#define F_C_PCMD_PAR_ERROR    V_C_PCMD_PAR_ERROR(1U)

#define A_PM_TX_INT_CAUSE 0x8ffc

#define S_ZERO_C_CMD_ERROR    28
#define V_ZERO_C_CMD_ERROR(x) ((x) << S_ZERO_C_CMD_ERROR)
#define F_ZERO_C_CMD_ERROR    V_ZERO_C_CMD_ERROR(1U)

#define S_OSPI_OR_BUNDLE_LEN_PAR_ERR    3
#define V_OSPI_OR_BUNDLE_LEN_PAR_ERR(x) ((x) << S_OSPI_OR_BUNDLE_LEN_PAR_ERR)
#define F_OSPI_OR_BUNDLE_LEN_PAR_ERR    V_OSPI_OR_BUNDLE_LEN_PAR_ERR(1U)

#define A_PM_TX_ISPI_DBG_4B_DATA0 0x10000
#define A_PM_TX_ISPI_DBG_4B_DATA1 0x10001
#define A_PM_TX_ISPI_DBG_4B_DATA2 0x10002
#define A_PM_TX_ISPI_DBG_4B_DATA3 0x10003
#define A_PM_TX_ISPI_DBG_4B_DATA4 0x10004
#define A_PM_TX_ISPI_DBG_4B_DATA5 0x10005
#define A_PM_TX_ISPI_DBG_4B_DATA6 0x10006
#define A_PM_TX_ISPI_DBG_4B_DATA7 0x10007
#define A_PM_TX_ISPI_DBG_4B_DATA8 0x10008
#define A_PM_TX_OSPI_DBG_4B_DATA0 0x10009
#define A_PM_TX_OSPI_DBG_4B_DATA1 0x1000a
#define A_PM_TX_OSPI_DBG_4B_DATA2 0x1000b
#define A_PM_TX_OSPI_DBG_4B_DATA3 0x1000c
#define A_PM_TX_OSPI_DBG_4B_DATA4 0x1000d
#define A_PM_TX_OSPI_DBG_4B_DATA5 0x1000e
#define A_PM_TX_OSPI_DBG_4B_DATA6 0x1000f
#define A_PM_TX_OSPI_DBG_4B_DATA7 0x10010
#define A_PM_TX_OSPI_DBG_4B_DATA8 0x10011
#define A_PM_TX_OSPI_DBG_4B_DATA9 0x10012
#define A_PM_TX_OSPI_DBG_4B_DATA10 0x10013
#define A_PM_TX_OSPI_DBG_4B_DATA11 0x10014
#define A_PM_TX_OSPI_DBG_4B_DATA12 0x10015
#define A_PM_TX_OSPI_DBG_4B_DATA13 0x10016
#define A_PM_TX_OSPI_DBG_4B_DATA14 0x10017
#define A_PM_TX_OSPI_DBG_4B_DATA15 0x10018
#define A_PM_TX_OSPI_DBG_4B_DATA16 0x10019
#define A_PM_TX_DBG_STAT_MSB 0x1001a
#define A_PM_TX_DBG_STAT_LSB 0x1001b
#define A_PM_TX_DBG_RSVD_FLIT_CNT 0x1001c
#define A_PM_TX_SDC_EN 0x1001d
#define A_PM_TX_INOUT_FIFO_DBG_CHNL_SEL 0x1001e
#define A_PM_TX_INOUT_FIFO_DBG_WR 0x1001f
#define A_PM_TX_INPUT_FIFO_STR_FWD_EN 0x10020
#define A_PM_TX_FEATURE_EN 0x10021

#define S_PIO_CH_DEFICIT_CTL_EN    2
#define V_PIO_CH_DEFICIT_CTL_EN(x) ((x) << S_PIO_CH_DEFICIT_CTL_EN)
#define F_PIO_CH_DEFICIT_CTL_EN    V_PIO_CH_DEFICIT_CTL_EN(1U)

#define S_PIO_WRR_BASED_PRFTCH_EN    1
#define V_PIO_WRR_BASED_PRFTCH_EN(x) ((x) << S_PIO_WRR_BASED_PRFTCH_EN)
#define F_PIO_WRR_BASED_PRFTCH_EN    V_PIO_WRR_BASED_PRFTCH_EN(1U)

#define A_PM_TX_T5_PM_TX_INT_ENABLE 0x10022

#define S_OSPI_OVERFLOW3    7
#define V_OSPI_OVERFLOW3(x) ((x) << S_OSPI_OVERFLOW3)
#define F_OSPI_OVERFLOW3    V_OSPI_OVERFLOW3(1U)

#define S_OSPI_OVERFLOW2    6
#define V_OSPI_OVERFLOW2(x) ((x) << S_OSPI_OVERFLOW2)
#define F_OSPI_OVERFLOW2    V_OSPI_OVERFLOW2(1U)

#define S_M_INTFPERREN    3
#define V_M_INTFPERREN(x) ((x) << S_M_INTFPERREN)
#define F_M_INTFPERREN    V_M_INTFPERREN(1U)

#define S_BUNDLE_LEN_PARERR_EN    2
#define V_BUNDLE_LEN_PARERR_EN(x) ((x) << S_BUNDLE_LEN_PARERR_EN)
#define F_BUNDLE_LEN_PARERR_EN    V_BUNDLE_LEN_PARERR_EN(1U)

#define S_BUNDLE_LEN_OVFL_EN    1
#define V_BUNDLE_LEN_OVFL_EN(x) ((x) << S_BUNDLE_LEN_OVFL_EN)
#define F_BUNDLE_LEN_OVFL_EN    V_BUNDLE_LEN_OVFL_EN(1U)

#define S_SDC_ERR_EN    0
#define V_SDC_ERR_EN(x) ((x) << S_SDC_ERR_EN)
#define F_SDC_ERR_EN    V_SDC_ERR_EN(1U)

#define A_PM_TX_PRFTCH_WRR_WAIT_CNT_THRSHLD0 0x10023
#define A_PM_TX_PRFTCH_WRR_WAIT_CNT_THRSHLD1 0x10024
#define A_PM_TX_PRFTCH_WRR_WAIT_CNT_THRSHLD2 0x10025
#define A_PM_TX_PRFTCH_WRR_WAIT_CNT_THRSHLD3 0x10026
#define A_PM_TX_CH0_OSPI_DEFICIT_THRSHLD 0x10027
#define A_PM_TX_CH1_OSPI_DEFICIT_THRSHLD 0x10028
#define A_PM_TX_CH2_OSPI_DEFICIT_THRSHLD 0x10029

#define S_CH2_OSPI_DEFICIT_THRSHLD    0
#define M_CH2_OSPI_DEFICIT_THRSHLD    0xfffU
#define V_CH2_OSPI_DEFICIT_THRSHLD(x) ((x) << S_CH2_OSPI_DEFICIT_THRSHLD)
#define G_CH2_OSPI_DEFICIT_THRSHLD(x) (((x) >> S_CH2_OSPI_DEFICIT_THRSHLD) & M_CH2_OSPI_DEFICIT_THRSHLD)

#define A_PM_TX_CH3_OSPI_DEFICIT_THRSHLD 0x1002a

#define S_CH3_OSPI_DEFICIT_THRSHLD    0
#define M_CH3_OSPI_DEFICIT_THRSHLD    0xfffU
#define V_CH3_OSPI_DEFICIT_THRSHLD(x) ((x) << S_CH3_OSPI_DEFICIT_THRSHLD)
#define G_CH3_OSPI_DEFICIT_THRSHLD(x) (((x) >> S_CH3_OSPI_DEFICIT_THRSHLD) & M_CH3_OSPI_DEFICIT_THRSHLD)

#define A_PM_TX_INT_CAUSE_MASK_HALT 0x1002b
#define A_PM_TX_DBG_STAT0 0x1002c

#define S_RD_I_BUSY    28
#define V_RD_I_BUSY(x) ((x) << S_RD_I_BUSY)
#define F_RD_I_BUSY    V_RD_I_BUSY(1U)

#define S_WR_O_ONLY    27
#define V_WR_O_ONLY(x) ((x) << S_WR_O_ONLY)
#define F_WR_O_ONLY    V_WR_O_ONLY(1U)

#define S_M_TO_BUSY    26
#define V_M_TO_BUSY(x) ((x) << S_M_TO_BUSY)
#define F_M_TO_BUSY    V_M_TO_BUSY(1U)

#define S_I_TO_M_BUSY    25
#define V_I_TO_M_BUSY(x) ((x) << S_I_TO_M_BUSY)
#define F_I_TO_M_BUSY    V_I_TO_M_BUSY(1U)

#define S_PCMD_FB_ONLY    24
#define V_PCMD_FB_ONLY(x) ((x) << S_PCMD_FB_ONLY)
#define F_PCMD_FB_ONLY    V_PCMD_FB_ONLY(1U)

#define S_PCMD_MEM    23
#define V_PCMD_MEM(x) ((x) << S_PCMD_MEM)
#define F_PCMD_MEM    V_PCMD_MEM(1U)

#define S_PCMD_BYPASS    22
#define V_PCMD_BYPASS(x) ((x) << S_PCMD_BYPASS)
#define F_PCMD_BYPASS    V_PCMD_BYPASS(1U)

#define S_PCMD_EOP    21
#define V_PCMD_EOP(x) ((x) << S_PCMD_EOP)
#define F_PCMD_EOP    V_PCMD_EOP(1U)

#define S_PCMD_END_BUNDLE    20
#define V_PCMD_END_BUNDLE(x) ((x) << S_PCMD_END_BUNDLE)
#define F_PCMD_END_BUNDLE    V_PCMD_END_BUNDLE(1U)

#define S_PCMD_FB_CMD    16
#define M_PCMD_FB_CMD    0xfU
#define V_PCMD_FB_CMD(x) ((x) << S_PCMD_FB_CMD)
#define G_PCMD_FB_CMD(x) (((x) >> S_PCMD_FB_CMD) & M_PCMD_FB_CMD)

#define S_CUR_PCMD_LEN    0
#define M_CUR_PCMD_LEN    0xffffU
#define V_CUR_PCMD_LEN(x) ((x) << S_CUR_PCMD_LEN)
#define G_CUR_PCMD_LEN(x) (((x) >> S_CUR_PCMD_LEN) & M_CUR_PCMD_LEN)

#define A_PM_TX_DBG_STAT1 0x1002d

#define S_PCMD_MEM0    31
#define V_PCMD_MEM0(x) ((x) << S_PCMD_MEM0)
#define F_PCMD_MEM0    V_PCMD_MEM0(1U)

#define S_FREE_OESPI_CNT0    19
#define M_FREE_OESPI_CNT0    0xfffU
#define V_FREE_OESPI_CNT0(x) ((x) << S_FREE_OESPI_CNT0)
#define G_FREE_OESPI_CNT0(x) (((x) >> S_FREE_OESPI_CNT0) & M_FREE_OESPI_CNT0)

#define S_PCMD_FLIT_LEN0    7
#define M_PCMD_FLIT_LEN0    0xfffU
#define V_PCMD_FLIT_LEN0(x) ((x) << S_PCMD_FLIT_LEN0)
#define G_PCMD_FLIT_LEN0(x) (((x) >> S_PCMD_FLIT_LEN0) & M_PCMD_FLIT_LEN0)

#define S_PCMD_CMD0    3
#define M_PCMD_CMD0    0xfU
#define V_PCMD_CMD0(x) ((x) << S_PCMD_CMD0)
#define G_PCMD_CMD0(x) (((x) >> S_PCMD_CMD0) & M_PCMD_CMD0)

#define S_OFIFO_FULL0    2
#define V_OFIFO_FULL0(x) ((x) << S_OFIFO_FULL0)
#define F_OFIFO_FULL0    V_OFIFO_FULL0(1U)

#define S_GCSUM_DRDY0    1
#define V_GCSUM_DRDY0(x) ((x) << S_GCSUM_DRDY0)
#define F_GCSUM_DRDY0    V_GCSUM_DRDY0(1U)

#define S_BYPASS0    0
#define V_BYPASS0(x) ((x) << S_BYPASS0)
#define F_BYPASS0    V_BYPASS0(1U)

#define A_PM_TX_DBG_STAT2 0x1002e

#define S_PCMD_MEM1    31
#define V_PCMD_MEM1(x) ((x) << S_PCMD_MEM1)
#define F_PCMD_MEM1    V_PCMD_MEM1(1U)

#define S_FREE_OESPI_CNT1    19
#define M_FREE_OESPI_CNT1    0xfffU
#define V_FREE_OESPI_CNT1(x) ((x) << S_FREE_OESPI_CNT1)
#define G_FREE_OESPI_CNT1(x) (((x) >> S_FREE_OESPI_CNT1) & M_FREE_OESPI_CNT1)

#define S_PCMD_FLIT_LEN1    7
#define M_PCMD_FLIT_LEN1    0xfffU
#define V_PCMD_FLIT_LEN1(x) ((x) << S_PCMD_FLIT_LEN1)
#define G_PCMD_FLIT_LEN1(x) (((x) >> S_PCMD_FLIT_LEN1) & M_PCMD_FLIT_LEN1)

#define S_PCMD_CMD1    3
#define M_PCMD_CMD1    0xfU
#define V_PCMD_CMD1(x) ((x) << S_PCMD_CMD1)
#define G_PCMD_CMD1(x) (((x) >> S_PCMD_CMD1) & M_PCMD_CMD1)

#define S_OFIFO_FULL1    2
#define V_OFIFO_FULL1(x) ((x) << S_OFIFO_FULL1)
#define F_OFIFO_FULL1    V_OFIFO_FULL1(1U)

#define S_GCSUM_DRDY1    1
#define V_GCSUM_DRDY1(x) ((x) << S_GCSUM_DRDY1)
#define F_GCSUM_DRDY1    V_GCSUM_DRDY1(1U)

#define S_BYPASS1    0
#define V_BYPASS1(x) ((x) << S_BYPASS1)
#define F_BYPASS1    V_BYPASS1(1U)

#define A_PM_TX_DBG_STAT3 0x1002f

#define S_PCMD_MEM2    31
#define V_PCMD_MEM2(x) ((x) << S_PCMD_MEM2)
#define F_PCMD_MEM2    V_PCMD_MEM2(1U)

#define S_FREE_OESPI_CNT2    19
#define M_FREE_OESPI_CNT2    0xfffU
#define V_FREE_OESPI_CNT2(x) ((x) << S_FREE_OESPI_CNT2)
#define G_FREE_OESPI_CNT2(x) (((x) >> S_FREE_OESPI_CNT2) & M_FREE_OESPI_CNT2)

#define S_PCMD_FLIT_LEN2    7
#define M_PCMD_FLIT_LEN2    0xfffU
#define V_PCMD_FLIT_LEN2(x) ((x) << S_PCMD_FLIT_LEN2)
#define G_PCMD_FLIT_LEN2(x) (((x) >> S_PCMD_FLIT_LEN2) & M_PCMD_FLIT_LEN2)

#define S_PCMD_CMD2    3
#define M_PCMD_CMD2    0xfU
#define V_PCMD_CMD2(x) ((x) << S_PCMD_CMD2)
#define G_PCMD_CMD2(x) (((x) >> S_PCMD_CMD2) & M_PCMD_CMD2)

#define S_OFIFO_FULL2    2
#define V_OFIFO_FULL2(x) ((x) << S_OFIFO_FULL2)
#define F_OFIFO_FULL2    V_OFIFO_FULL2(1U)

#define S_GCSUM_DRDY2    1
#define V_GCSUM_DRDY2(x) ((x) << S_GCSUM_DRDY2)
#define F_GCSUM_DRDY2    V_GCSUM_DRDY2(1U)

#define S_BYPASS2    0
#define V_BYPASS2(x) ((x) << S_BYPASS2)
#define F_BYPASS2    V_BYPASS2(1U)

#define A_PM_TX_DBG_STAT4 0x10030

#define S_PCMD_MEM3    31
#define V_PCMD_MEM3(x) ((x) << S_PCMD_MEM3)
#define F_PCMD_MEM3    V_PCMD_MEM3(1U)

#define S_FREE_OESPI_CNT3    19
#define M_FREE_OESPI_CNT3    0xfffU
#define V_FREE_OESPI_CNT3(x) ((x) << S_FREE_OESPI_CNT3)
#define G_FREE_OESPI_CNT3(x) (((x) >> S_FREE_OESPI_CNT3) & M_FREE_OESPI_CNT3)

#define S_PCMD_FLIT_LEN3    7
#define M_PCMD_FLIT_LEN3    0xfffU
#define V_PCMD_FLIT_LEN3(x) ((x) << S_PCMD_FLIT_LEN3)
#define G_PCMD_FLIT_LEN3(x) (((x) >> S_PCMD_FLIT_LEN3) & M_PCMD_FLIT_LEN3)

#define S_PCMD_CMD3    3
#define M_PCMD_CMD3    0xfU
#define V_PCMD_CMD3(x) ((x) << S_PCMD_CMD3)
#define G_PCMD_CMD3(x) (((x) >> S_PCMD_CMD3) & M_PCMD_CMD3)

#define S_OFIFO_FULL3    2
#define V_OFIFO_FULL3(x) ((x) << S_OFIFO_FULL3)
#define F_OFIFO_FULL3    V_OFIFO_FULL3(1U)

#define S_GCSUM_DRDY3    1
#define V_GCSUM_DRDY3(x) ((x) << S_GCSUM_DRDY3)
#define F_GCSUM_DRDY3    V_GCSUM_DRDY3(1U)

#define S_BYPASS3    0
#define V_BYPASS3(x) ((x) << S_BYPASS3)
#define F_BYPASS3    V_BYPASS3(1U)

#define A_PM_TX_DBG_STAT5 0x10031

#define S_SET_PCMD_RES_RDY_RD    24
#define M_SET_PCMD_RES_RDY_RD    0xfU
#define V_SET_PCMD_RES_RDY_RD(x) ((x) << S_SET_PCMD_RES_RDY_RD)
#define G_SET_PCMD_RES_RDY_RD(x) (((x) >> S_SET_PCMD_RES_RDY_RD) & M_SET_PCMD_RES_RDY_RD)

#define S_ISSUED_PREF_RD_ER_CLR    20
#define M_ISSUED_PREF_RD_ER_CLR    0xfU
#define V_ISSUED_PREF_RD_ER_CLR(x) ((x) << S_ISSUED_PREF_RD_ER_CLR)
#define G_ISSUED_PREF_RD_ER_CLR(x) (((x) >> S_ISSUED_PREF_RD_ER_CLR) & M_ISSUED_PREF_RD_ER_CLR)

#define S_ISSUED_PREF_RD    16
#define M_ISSUED_PREF_RD    0xfU
#define V_ISSUED_PREF_RD(x) ((x) << S_ISSUED_PREF_RD)
#define G_ISSUED_PREF_RD(x) (((x) >> S_ISSUED_PREF_RD) & M_ISSUED_PREF_RD)

#define S_PCMD_RES_RDY    12
#define M_PCMD_RES_RDY    0xfU
#define V_PCMD_RES_RDY(x) ((x) << S_PCMD_RES_RDY)
#define G_PCMD_RES_RDY(x) (((x) >> S_PCMD_RES_RDY) & M_PCMD_RES_RDY)

#define S_DB_VLD    11
#define V_DB_VLD(x) ((x) << S_DB_VLD)
#define F_DB_VLD    V_DB_VLD(1U)

#define S_INJECT0_DRDY    10
#define V_INJECT0_DRDY(x) ((x) << S_INJECT0_DRDY)
#define F_INJECT0_DRDY    V_INJECT0_DRDY(1U)

#define S_INJECT1_DRDY    9
#define V_INJECT1_DRDY(x) ((x) << S_INJECT1_DRDY)
#define F_INJECT1_DRDY    V_INJECT1_DRDY(1U)

#define S_FIRST_BUNDLE    5
#define M_FIRST_BUNDLE    0xfU
#define V_FIRST_BUNDLE(x) ((x) << S_FIRST_BUNDLE)
#define G_FIRST_BUNDLE(x) (((x) >> S_FIRST_BUNDLE) & M_FIRST_BUNDLE)

#define S_GCSUM_MORE_THAN_2_LEFT    1
#define M_GCSUM_MORE_THAN_2_LEFT    0xfU
#define V_GCSUM_MORE_THAN_2_LEFT(x) ((x) << S_GCSUM_MORE_THAN_2_LEFT)
#define G_GCSUM_MORE_THAN_2_LEFT(x) (((x) >> S_GCSUM_MORE_THAN_2_LEFT) & M_GCSUM_MORE_THAN_2_LEFT)

#define S_SDC_DRDY    0
#define V_SDC_DRDY(x) ((x) << S_SDC_DRDY)
#define F_SDC_DRDY    V_SDC_DRDY(1U)

#define A_PM_TX_DBG_STAT6 0x10032

#define S_PCMD_VLD    31
#define V_PCMD_VLD(x) ((x) << S_PCMD_VLD)
#define F_PCMD_VLD    V_PCMD_VLD(1U)

#define S_PCMD_CH    29
#define M_PCMD_CH    0x3U
#define V_PCMD_CH(x) ((x) << S_PCMD_CH)
#define G_PCMD_CH(x) (((x) >> S_PCMD_CH) & M_PCMD_CH)

#define S_STATE_MACHINE_LOC    24
#define M_STATE_MACHINE_LOC    0x1fU
#define V_STATE_MACHINE_LOC(x) ((x) << S_STATE_MACHINE_LOC)
#define G_STATE_MACHINE_LOC(x) (((x) >> S_STATE_MACHINE_LOC) & M_STATE_MACHINE_LOC)

#define S_ICSPI_TXVALID    20
#define M_ICSPI_TXVALID    0xfU
#define V_ICSPI_TXVALID(x) ((x) << S_ICSPI_TXVALID)
#define G_ICSPI_TXVALID(x) (((x) >> S_ICSPI_TXVALID) & M_ICSPI_TXVALID)

#define S_ICSPI_TXFULL    16
#define M_ICSPI_TXFULL    0xfU
#define V_ICSPI_TXFULL(x) ((x) << S_ICSPI_TXFULL)
#define G_ICSPI_TXFULL(x) (((x) >> S_ICSPI_TXFULL) & M_ICSPI_TXFULL)

#define S_PCMD_SRDY    12
#define M_PCMD_SRDY    0xfU
#define V_PCMD_SRDY(x) ((x) << S_PCMD_SRDY)
#define G_PCMD_SRDY(x) (((x) >> S_PCMD_SRDY) & M_PCMD_SRDY)

#define S_PCMD_DRDY    8
#define M_PCMD_DRDY    0xfU
#define V_PCMD_DRDY(x) ((x) << S_PCMD_DRDY)
#define G_PCMD_DRDY(x) (((x) >> S_PCMD_DRDY) & M_PCMD_DRDY)

#define S_PCMD_CMD    4
#define M_PCMD_CMD    0xfU
#define V_PCMD_CMD(x) ((x) << S_PCMD_CMD)
#define G_PCMD_CMD(x) (((x) >> S_PCMD_CMD) & M_PCMD_CMD)

#define S_OEFIFO_FULL3    3
#define V_OEFIFO_FULL3(x) ((x) << S_OEFIFO_FULL3)
#define F_OEFIFO_FULL3    V_OEFIFO_FULL3(1U)

#define S_OEFIFO_FULL2    2
#define V_OEFIFO_FULL2(x) ((x) << S_OEFIFO_FULL2)
#define F_OEFIFO_FULL2    V_OEFIFO_FULL2(1U)

#define S_OEFIFO_FULL1    1
#define V_OEFIFO_FULL1(x) ((x) << S_OEFIFO_FULL1)
#define F_OEFIFO_FULL1    V_OEFIFO_FULL1(1U)

#define S_OEFIFO_FULL0    0
#define V_OEFIFO_FULL0(x) ((x) << S_OEFIFO_FULL0)
#define F_OEFIFO_FULL0    V_OEFIFO_FULL0(1U)

#define A_PM_TX_DBG_STAT7 0x10033

#define S_ICSPI_RXVALID    28
#define M_ICSPI_RXVALID    0xfU
#define V_ICSPI_RXVALID(x) ((x) << S_ICSPI_RXVALID)
#define G_ICSPI_RXVALID(x) (((x) >> S_ICSPI_RXVALID) & M_ICSPI_RXVALID)

#define S_ICSPI_RXFULL    24
#define M_ICSPI_RXFULL    0xfU
#define V_ICSPI_RXFULL(x) ((x) << S_ICSPI_RXFULL)
#define G_ICSPI_RXFULL(x) (((x) >> S_ICSPI_RXFULL) & M_ICSPI_RXFULL)

#define S_OESPI_VALID    20
#define M_OESPI_VALID    0xfU
#define V_OESPI_VALID(x) ((x) << S_OESPI_VALID)
#define G_OESPI_VALID(x) (((x) >> S_OESPI_VALID) & M_OESPI_VALID)

#define S_OESPI_FULL    16
#define M_OESPI_FULL    0xfU
#define V_OESPI_FULL(x) ((x) << S_OESPI_FULL)
#define G_OESPI_FULL(x) (((x) >> S_OESPI_FULL) & M_OESPI_FULL)

#define S_C_RXVALID    12
#define M_C_RXVALID    0xfU
#define V_C_RXVALID(x) ((x) << S_C_RXVALID)
#define G_C_RXVALID(x) (((x) >> S_C_RXVALID) & M_C_RXVALID)

#define S_C_RXAFULL    8
#define M_C_RXAFULL    0xfU
#define V_C_RXAFULL(x) ((x) << S_C_RXAFULL)
#define G_C_RXAFULL(x) (((x) >> S_C_RXAFULL) & M_C_RXAFULL)

#define S_E_TXVALID3    7
#define V_E_TXVALID3(x) ((x) << S_E_TXVALID3)
#define F_E_TXVALID3    V_E_TXVALID3(1U)

#define S_E_TXVALID2    6
#define V_E_TXVALID2(x) ((x) << S_E_TXVALID2)
#define F_E_TXVALID2    V_E_TXVALID2(1U)

#define S_E_TXVALID1    5
#define V_E_TXVALID1(x) ((x) << S_E_TXVALID1)
#define F_E_TXVALID1    V_E_TXVALID1(1U)

#define S_E_TXVALID0    4
#define V_E_TXVALID0(x) ((x) << S_E_TXVALID0)
#define F_E_TXVALID0    V_E_TXVALID0(1U)

#define S_E_TXFULL3    3
#define V_E_TXFULL3(x) ((x) << S_E_TXFULL3)
#define F_E_TXFULL3    V_E_TXFULL3(1U)

#define S_E_TXFULL2    2
#define V_E_TXFULL2(x) ((x) << S_E_TXFULL2)
#define F_E_TXFULL2    V_E_TXFULL2(1U)

#define S_E_TXFULL1    1
#define V_E_TXFULL1(x) ((x) << S_E_TXFULL1)
#define F_E_TXFULL1    V_E_TXFULL1(1U)

#define S_E_TXFULL0    0
#define V_E_TXFULL0(x) ((x) << S_E_TXFULL0)
#define F_E_TXFULL0    V_E_TXFULL0(1U)

#define A_PM_TX_DBG_STAT8 0x10034

#define S_MC_RSP_FIFO_CNT    24
#define M_MC_RSP_FIFO_CNT    0x3U
#define V_MC_RSP_FIFO_CNT(x) ((x) << S_MC_RSP_FIFO_CNT)
#define G_MC_RSP_FIFO_CNT(x) (((x) >> S_MC_RSP_FIFO_CNT) & M_MC_RSP_FIFO_CNT)

#define S_PCMD_FREE_CNT0    14
#define M_PCMD_FREE_CNT0    0x3ffU
#define V_PCMD_FREE_CNT0(x) ((x) << S_PCMD_FREE_CNT0)
#define G_PCMD_FREE_CNT0(x) (((x) >> S_PCMD_FREE_CNT0) & M_PCMD_FREE_CNT0)

#define S_PCMD_FREE_CNT1    4
#define M_PCMD_FREE_CNT1    0x3ffU
#define V_PCMD_FREE_CNT1(x) ((x) << S_PCMD_FREE_CNT1)
#define G_PCMD_FREE_CNT1(x) (((x) >> S_PCMD_FREE_CNT1) & M_PCMD_FREE_CNT1)

#define S_M_REQADDRRDY    3
#define V_M_REQADDRRDY(x) ((x) << S_M_REQADDRRDY)
#define F_M_REQADDRRDY    V_M_REQADDRRDY(1U)

#define S_M_REQWRITE    2
#define V_M_REQWRITE(x) ((x) << S_M_REQWRITE)
#define F_M_REQWRITE    V_M_REQWRITE(1U)

#define S_M_REQDATAVLD    1
#define V_M_REQDATAVLD(x) ((x) << S_M_REQDATAVLD)
#define F_M_REQDATAVLD    V_M_REQDATAVLD(1U)

#define S_M_REQDATARDY    0
#define V_M_REQDATARDY(x) ((x) << S_M_REQDATARDY)
#define F_M_REQDATARDY    V_M_REQDATARDY(1U)

#define A_PM_TX_DBG_STAT9 0x10035

#define S_PCMD_FREE_CNT2    10
#define M_PCMD_FREE_CNT2    0x3ffU
#define V_PCMD_FREE_CNT2(x) ((x) << S_PCMD_FREE_CNT2)
#define G_PCMD_FREE_CNT2(x) (((x) >> S_PCMD_FREE_CNT2) & M_PCMD_FREE_CNT2)

#define S_PCMD_FREE_CNT3    0
#define M_PCMD_FREE_CNT3    0x3ffU
#define V_PCMD_FREE_CNT3(x) ((x) << S_PCMD_FREE_CNT3)
#define G_PCMD_FREE_CNT3(x) (((x) >> S_PCMD_FREE_CNT3) & M_PCMD_FREE_CNT3)

#define A_PM_TX_DBG_STAT10 0x10036

#define S_IN_EOP_CNT3    28
#define M_IN_EOP_CNT3    0xfU
#define V_IN_EOP_CNT3(x) ((x) << S_IN_EOP_CNT3)
#define G_IN_EOP_CNT3(x) (((x) >> S_IN_EOP_CNT3) & M_IN_EOP_CNT3)

#define S_IN_EOP_CNT2    24
#define M_IN_EOP_CNT2    0xfU
#define V_IN_EOP_CNT2(x) ((x) << S_IN_EOP_CNT2)
#define G_IN_EOP_CNT2(x) (((x) >> S_IN_EOP_CNT2) & M_IN_EOP_CNT2)

#define S_IN_EOP_CNT1    20
#define M_IN_EOP_CNT1    0xfU
#define V_IN_EOP_CNT1(x) ((x) << S_IN_EOP_CNT1)
#define G_IN_EOP_CNT1(x) (((x) >> S_IN_EOP_CNT1) & M_IN_EOP_CNT1)

#define S_IN_EOP_CNT0    16
#define M_IN_EOP_CNT0    0xfU
#define V_IN_EOP_CNT0(x) ((x) << S_IN_EOP_CNT0)
#define G_IN_EOP_CNT0(x) (((x) >> S_IN_EOP_CNT0) & M_IN_EOP_CNT0)

#define S_IN_SOP_CNT3    12
#define M_IN_SOP_CNT3    0xfU
#define V_IN_SOP_CNT3(x) ((x) << S_IN_SOP_CNT3)
#define G_IN_SOP_CNT3(x) (((x) >> S_IN_SOP_CNT3) & M_IN_SOP_CNT3)

#define S_IN_SOP_CNT2    8
#define M_IN_SOP_CNT2    0xfU
#define V_IN_SOP_CNT2(x) ((x) << S_IN_SOP_CNT2)
#define G_IN_SOP_CNT2(x) (((x) >> S_IN_SOP_CNT2) & M_IN_SOP_CNT2)

#define S_IN_SOP_CNT1    4
#define M_IN_SOP_CNT1    0xfU
#define V_IN_SOP_CNT1(x) ((x) << S_IN_SOP_CNT1)
#define G_IN_SOP_CNT1(x) (((x) >> S_IN_SOP_CNT1) & M_IN_SOP_CNT1)

#define S_IN_SOP_CNT0    0
#define M_IN_SOP_CNT0    0xfU
#define V_IN_SOP_CNT0(x) ((x) << S_IN_SOP_CNT0)
#define G_IN_SOP_CNT0(x) (((x) >> S_IN_SOP_CNT0) & M_IN_SOP_CNT0)

#define A_PM_TX_DBG_STAT11 0x10037

#define S_OUT_EOP_CNT3    28
#define M_OUT_EOP_CNT3    0xfU
#define V_OUT_EOP_CNT3(x) ((x) << S_OUT_EOP_CNT3)
#define G_OUT_EOP_CNT3(x) (((x) >> S_OUT_EOP_CNT3) & M_OUT_EOP_CNT3)

#define S_OUT_EOP_CNT2    24
#define M_OUT_EOP_CNT2    0xfU
#define V_OUT_EOP_CNT2(x) ((x) << S_OUT_EOP_CNT2)
#define G_OUT_EOP_CNT2(x) (((x) >> S_OUT_EOP_CNT2) & M_OUT_EOP_CNT2)

#define S_OUT_EOP_CNT1    20
#define M_OUT_EOP_CNT1    0xfU
#define V_OUT_EOP_CNT1(x) ((x) << S_OUT_EOP_CNT1)
#define G_OUT_EOP_CNT1(x) (((x) >> S_OUT_EOP_CNT1) & M_OUT_EOP_CNT1)

#define S_OUT_EOP_CNT0    16
#define M_OUT_EOP_CNT0    0xfU
#define V_OUT_EOP_CNT0(x) ((x) << S_OUT_EOP_CNT0)
#define G_OUT_EOP_CNT0(x) (((x) >> S_OUT_EOP_CNT0) & M_OUT_EOP_CNT0)

#define S_OUT_SOP_CNT3    12
#define M_OUT_SOP_CNT3    0xfU
#define V_OUT_SOP_CNT3(x) ((x) << S_OUT_SOP_CNT3)
#define G_OUT_SOP_CNT3(x) (((x) >> S_OUT_SOP_CNT3) & M_OUT_SOP_CNT3)

#define S_OUT_SOP_CNT2    8
#define M_OUT_SOP_CNT2    0xfU
#define V_OUT_SOP_CNT2(x) ((x) << S_OUT_SOP_CNT2)
#define G_OUT_SOP_CNT2(x) (((x) >> S_OUT_SOP_CNT2) & M_OUT_SOP_CNT2)

#define S_OUT_SOP_CNT1    4
#define M_OUT_SOP_CNT1    0xfU
#define V_OUT_SOP_CNT1(x) ((x) << S_OUT_SOP_CNT1)
#define G_OUT_SOP_CNT1(x) (((x) >> S_OUT_SOP_CNT1) & M_OUT_SOP_CNT1)

#define S_OUT_SOP_CNT0    0
#define M_OUT_SOP_CNT0    0xfU
#define V_OUT_SOP_CNT0(x) ((x) << S_OUT_SOP_CNT0)
#define G_OUT_SOP_CNT0(x) (((x) >> S_OUT_SOP_CNT0) & M_OUT_SOP_CNT0)

#define A_PM_TX_DBG_STAT12 0x10038
#define A_PM_TX_DBG_STAT13 0x10039

#define S_CH_DEFICIT_BLOWED    31
#define V_CH_DEFICIT_BLOWED(x) ((x) << S_CH_DEFICIT_BLOWED)
#define F_CH_DEFICIT_BLOWED    V_CH_DEFICIT_BLOWED(1U)

#define S_CH1_DEFICIT    16
#define M_CH1_DEFICIT    0xfffU
#define V_CH1_DEFICIT(x) ((x) << S_CH1_DEFICIT)
#define G_CH1_DEFICIT(x) (((x) >> S_CH1_DEFICIT) & M_CH1_DEFICIT)

#define S_CH0_DEFICIT    0
#define M_CH0_DEFICIT    0xfffU
#define V_CH0_DEFICIT(x) ((x) << S_CH0_DEFICIT)
#define G_CH0_DEFICIT(x) (((x) >> S_CH0_DEFICIT) & M_CH0_DEFICIT)

#define A_PM_TX_DBG_STAT14 0x1003a

#define S_CH3_DEFICIT    16
#define M_CH3_DEFICIT    0xfffU
#define V_CH3_DEFICIT(x) ((x) << S_CH3_DEFICIT)
#define G_CH3_DEFICIT(x) (((x) >> S_CH3_DEFICIT) & M_CH3_DEFICIT)

#define S_CH2_DEFICIT    0
#define M_CH2_DEFICIT    0xfffU
#define V_CH2_DEFICIT(x) ((x) << S_CH2_DEFICIT)
#define G_CH2_DEFICIT(x) (((x) >> S_CH2_DEFICIT) & M_CH2_DEFICIT)

#define A_PM_TX_DBG_STAT15 0x1003b

#define S_BUNDLE_LEN_SRDY    28
#define M_BUNDLE_LEN_SRDY    0xfU
#define V_BUNDLE_LEN_SRDY(x) ((x) << S_BUNDLE_LEN_SRDY)
#define G_BUNDLE_LEN_SRDY(x) (((x) >> S_BUNDLE_LEN_SRDY) & M_BUNDLE_LEN_SRDY)

#define S_BUNDLE_LEN1    16
#define M_BUNDLE_LEN1    0xfffU
#define V_BUNDLE_LEN1(x) ((x) << S_BUNDLE_LEN1)
#define G_BUNDLE_LEN1(x) (((x) >> S_BUNDLE_LEN1) & M_BUNDLE_LEN1)

#define S_BUNDLE_LEN0    0
#define M_BUNDLE_LEN0    0xfffU
#define V_BUNDLE_LEN0(x) ((x) << S_BUNDLE_LEN0)
#define G_BUNDLE_LEN0(x) (((x) >> S_BUNDLE_LEN0) & M_BUNDLE_LEN0)

#define A_PM_TX_DBG_STAT16 0x1003c

#define S_BUNDLE_LEN3    16
#define M_BUNDLE_LEN3    0xfffU
#define V_BUNDLE_LEN3(x) ((x) << S_BUNDLE_LEN3)
#define G_BUNDLE_LEN3(x) (((x) >> S_BUNDLE_LEN3) & M_BUNDLE_LEN3)

#define S_BUNDLE_LEN2    0
#define M_BUNDLE_LEN2    0xfffU
#define V_BUNDLE_LEN2(x) ((x) << S_BUNDLE_LEN2)
#define G_BUNDLE_LEN2(x) (((x) >> S_BUNDLE_LEN2) & M_BUNDLE_LEN2)

/* registers for module MPS */
#define MPS_BASE_ADDR 0x9000

#define A_MPS_PORT_CTL 0x0

#define S_LPBKEN    31
#define V_LPBKEN(x) ((x) << S_LPBKEN)
#define F_LPBKEN    V_LPBKEN(1U)

#define S_PORTTXEN    30
#define V_PORTTXEN(x) ((x) << S_PORTTXEN)
#define F_PORTTXEN    V_PORTTXEN(1U)

#define S_PORTRXEN    29
#define V_PORTRXEN(x) ((x) << S_PORTRXEN)
#define F_PORTRXEN    V_PORTRXEN(1U)

#define S_PPPEN    28
#define V_PPPEN(x) ((x) << S_PPPEN)
#define F_PPPEN    V_PPPEN(1U)

#define S_FCSSTRIPEN    27
#define V_FCSSTRIPEN(x) ((x) << S_FCSSTRIPEN)
#define F_FCSSTRIPEN    V_FCSSTRIPEN(1U)

#define S_PPPANDPAUSE    26
#define V_PPPANDPAUSE(x) ((x) << S_PPPANDPAUSE)
#define F_PPPANDPAUSE    V_PPPANDPAUSE(1U)

#define S_PRIOPPPENMAP    16
#define M_PRIOPPPENMAP    0xffU
#define V_PRIOPPPENMAP(x) ((x) << S_PRIOPPPENMAP)
#define G_PRIOPPPENMAP(x) (((x) >> S_PRIOPPPENMAP) & M_PRIOPPPENMAP)

#define A_MPS_VF_CTL 0x0
#define A_MPS_PORT_PAUSE_CTL 0x4

#define S_TIMEUNIT    0
#define M_TIMEUNIT    0xffffU
#define V_TIMEUNIT(x) ((x) << S_TIMEUNIT)
#define G_TIMEUNIT(x) (((x) >> S_TIMEUNIT) & M_TIMEUNIT)

#define A_MPS_PORT_TX_PAUSE_CTL 0x8

#define S_REGSENDOFF    24
#define M_REGSENDOFF    0xffU
#define V_REGSENDOFF(x) ((x) << S_REGSENDOFF)
#define G_REGSENDOFF(x) (((x) >> S_REGSENDOFF) & M_REGSENDOFF)

#define S_REGSENDON    16
#define M_REGSENDON    0xffU
#define V_REGSENDON(x) ((x) << S_REGSENDON)
#define G_REGSENDON(x) (((x) >> S_REGSENDON) & M_REGSENDON)

#define S_SGESENDEN    8
#define M_SGESENDEN    0xffU
#define V_SGESENDEN(x) ((x) << S_SGESENDEN)
#define G_SGESENDEN(x) (((x) >> S_SGESENDEN) & M_SGESENDEN)

#define S_RXSENDEN    0
#define M_RXSENDEN    0xffU
#define V_RXSENDEN(x) ((x) << S_RXSENDEN)
#define G_RXSENDEN(x) (((x) >> S_RXSENDEN) & M_RXSENDEN)

#define A_MPS_PORT_TX_PAUSE_CTL2 0xc

#define S_XOFFDISABLE    0
#define V_XOFFDISABLE(x) ((x) << S_XOFFDISABLE)
#define F_XOFFDISABLE    V_XOFFDISABLE(1U)

#define A_MPS_PORT_RX_PAUSE_CTL 0x10

#define S_REGHALTON    8
#define M_REGHALTON    0xffU
#define V_REGHALTON(x) ((x) << S_REGHALTON)
#define G_REGHALTON(x) (((x) >> S_REGHALTON) & M_REGHALTON)

#define S_RXHALTEN    0
#define M_RXHALTEN    0xffU
#define V_RXHALTEN(x) ((x) << S_RXHALTEN)
#define G_RXHALTEN(x) (((x) >> S_RXHALTEN) & M_RXHALTEN)

#define A_MPS_PORT_TX_PAUSE_STATUS 0x14

#define S_REGSENDING    16
#define M_REGSENDING    0xffU
#define V_REGSENDING(x) ((x) << S_REGSENDING)
#define G_REGSENDING(x) (((x) >> S_REGSENDING) & M_REGSENDING)

#define S_SGESENDING    8
#define M_SGESENDING    0xffU
#define V_SGESENDING(x) ((x) << S_SGESENDING)
#define G_SGESENDING(x) (((x) >> S_SGESENDING) & M_SGESENDING)

#define S_RXSENDING    0
#define M_RXSENDING    0xffU
#define V_RXSENDING(x) ((x) << S_RXSENDING)
#define G_RXSENDING(x) (((x) >> S_RXSENDING) & M_RXSENDING)

#define A_MPS_PORT_RX_PAUSE_STATUS 0x18

#define S_REGHALTED    8
#define M_REGHALTED    0xffU
#define V_REGHALTED(x) ((x) << S_REGHALTED)
#define G_REGHALTED(x) (((x) >> S_REGHALTED) & M_REGHALTED)

#define S_RXHALTED    0
#define M_RXHALTED    0xffU
#define V_RXHALTED(x) ((x) << S_RXHALTED)
#define G_RXHALTED(x) (((x) >> S_RXHALTED) & M_RXHALTED)

#define A_MPS_PORT_TX_PAUSE_DEST_L 0x1c
#define A_MPS_PORT_TX_PAUSE_DEST_H 0x20

#define S_ADDR    0
#define M_ADDR    0xffffU
#define V_ADDR(x) ((x) << S_ADDR)
#define G_ADDR(x) (((x) >> S_ADDR) & M_ADDR)

#define A_MPS_PORT_TX_PAUSE_SOURCE_L 0x24
#define A_MPS_PORT_TX_PAUSE_SOURCE_H 0x28
#define A_MPS_PORT_PRTY_BUFFER_GROUP_MAP 0x2c

#define S_PRTY7    14
#define M_PRTY7    0x3U
#define V_PRTY7(x) ((x) << S_PRTY7)
#define G_PRTY7(x) (((x) >> S_PRTY7) & M_PRTY7)

#define S_PRTY6    12
#define M_PRTY6    0x3U
#define V_PRTY6(x) ((x) << S_PRTY6)
#define G_PRTY6(x) (((x) >> S_PRTY6) & M_PRTY6)

#define S_PRTY5    10
#define M_PRTY5    0x3U
#define V_PRTY5(x) ((x) << S_PRTY5)
#define G_PRTY5(x) (((x) >> S_PRTY5) & M_PRTY5)

#define S_PRTY4    8
#define M_PRTY4    0x3U
#define V_PRTY4(x) ((x) << S_PRTY4)
#define G_PRTY4(x) (((x) >> S_PRTY4) & M_PRTY4)

#define S_PRTY3    6
#define M_PRTY3    0x3U
#define V_PRTY3(x) ((x) << S_PRTY3)
#define G_PRTY3(x) (((x) >> S_PRTY3) & M_PRTY3)

#define S_PRTY2    4
#define M_PRTY2    0x3U
#define V_PRTY2(x) ((x) << S_PRTY2)
#define G_PRTY2(x) (((x) >> S_PRTY2) & M_PRTY2)

#define S_PRTY1    2
#define M_PRTY1    0x3U
#define V_PRTY1(x) ((x) << S_PRTY1)
#define G_PRTY1(x) (((x) >> S_PRTY1) & M_PRTY1)

#define S_PRTY0    0
#define M_PRTY0    0x3U
#define V_PRTY0(x) ((x) << S_PRTY0)
#define G_PRTY0(x) (((x) >> S_PRTY0) & M_PRTY0)

#define A_MPS_PORT_PRTY_BUFFER_GROUP_TH_MAP 0x30

#define S_TXPRTY7    28
#define M_TXPRTY7    0xfU
#define V_TXPRTY7(x) ((x) << S_TXPRTY7)
#define G_TXPRTY7(x) (((x) >> S_TXPRTY7) & M_TXPRTY7)

#define S_TXPRTY6    24
#define M_TXPRTY6    0xfU
#define V_TXPRTY6(x) ((x) << S_TXPRTY6)
#define G_TXPRTY6(x) (((x) >> S_TXPRTY6) & M_TXPRTY6)

#define S_TXPRTY5    20
#define M_TXPRTY5    0xfU
#define V_TXPRTY5(x) ((x) << S_TXPRTY5)
#define G_TXPRTY5(x) (((x) >> S_TXPRTY5) & M_TXPRTY5)

#define S_TXPRTY4    16
#define M_TXPRTY4    0xfU
#define V_TXPRTY4(x) ((x) << S_TXPRTY4)
#define G_TXPRTY4(x) (((x) >> S_TXPRTY4) & M_TXPRTY4)

#define S_TXPRTY3    12
#define M_TXPRTY3    0xfU
#define V_TXPRTY3(x) ((x) << S_TXPRTY3)
#define G_TXPRTY3(x) (((x) >> S_TXPRTY3) & M_TXPRTY3)

#define S_TXPRTY2    8
#define M_TXPRTY2    0xfU
#define V_TXPRTY2(x) ((x) << S_TXPRTY2)
#define G_TXPRTY2(x) (((x) >> S_TXPRTY2) & M_TXPRTY2)

#define S_TXPRTY1    4
#define M_TXPRTY1    0xfU
#define V_TXPRTY1(x) ((x) << S_TXPRTY1)
#define G_TXPRTY1(x) (((x) >> S_TXPRTY1) & M_TXPRTY1)

#define S_TXPRTY0    0
#define M_TXPRTY0    0xfU
#define V_TXPRTY0(x) ((x) << S_TXPRTY0)
#define G_TXPRTY0(x) (((x) >> S_TXPRTY0) & M_TXPRTY0)

#define A_MPS_VF_STAT_TX_VF_BCAST_BYTES_L 0x80
#define A_MPS_VF_STAT_TX_VF_BCAST_BYTES_H 0x84
#define A_MPS_VF_STAT_TX_VF_BCAST_FRAMES_L 0x88
#define A_MPS_VF_STAT_TX_VF_BCAST_FRAMES_H 0x8c
#define A_MPS_VF_STAT_TX_VF_MCAST_BYTES_L 0x90
#define A_MPS_VF_STAT_TX_VF_MCAST_BYTES_H 0x94
#define A_MPS_VF_STAT_TX_VF_MCAST_FRAMES_L 0x98
#define A_MPS_VF_STAT_TX_VF_MCAST_FRAMES_H 0x9c
#define A_MPS_VF_STAT_TX_VF_UCAST_BYTES_L 0xa0
#define A_MPS_VF_STAT_TX_VF_UCAST_BYTES_H 0xa4
#define A_MPS_VF_STAT_TX_VF_UCAST_FRAMES_L 0xa8
#define A_MPS_VF_STAT_TX_VF_UCAST_FRAMES_H 0xac
#define A_MPS_VF_STAT_TX_VF_DROP_FRAMES_L 0xb0
#define A_MPS_VF_STAT_TX_VF_DROP_FRAMES_H 0xb4
#define A_MPS_VF_STAT_TX_VF_OFFLOAD_BYTES_L 0xb8
#define A_MPS_VF_STAT_TX_VF_OFFLOAD_BYTES_H 0xbc
#define A_MPS_VF_STAT_TX_VF_OFFLOAD_FRAMES_L 0xc0
#define A_MPS_VF_STAT_TX_VF_OFFLOAD_FRAMES_H 0xc4
#define A_MPS_VF_STAT_RX_VF_BCAST_BYTES_L 0xc8
#define A_MPS_VF_STAT_RX_VF_BCAST_BYTES_H 0xcc
#define A_MPS_VF_STAT_RX_VF_BCAST_FRAMES_L 0xd0
#define A_MPS_VF_STAT_RX_VF_BCAST_FRAMES_H 0xd4
#define A_MPS_VF_STAT_RX_VF_MCAST_BYTES_L 0xd8
#define A_MPS_VF_STAT_RX_VF_MCAST_BYTES_H 0xdc
#define A_MPS_VF_STAT_RX_VF_MCAST_FRAMES_L 0xe0
#define A_MPS_VF_STAT_RX_VF_MCAST_FRAMES_H 0xe4
#define A_MPS_VF_STAT_RX_VF_UCAST_BYTES_L 0xe8
#define A_MPS_VF_STAT_RX_VF_UCAST_BYTES_H 0xec
#define A_MPS_VF_STAT_RX_VF_UCAST_FRAMES_L 0xf0
#define A_MPS_VF_STAT_RX_VF_UCAST_FRAMES_H 0xf4
#define A_MPS_VF_STAT_RX_VF_ERR_FRAMES_L 0xf8
#define A_MPS_VF_STAT_RX_VF_ERR_FRAMES_H 0xfc
#define A_MPS_PORT_RX_CTL 0x100

#define S_NO_RPLCT_M    20
#define V_NO_RPLCT_M(x) ((x) << S_NO_RPLCT_M)
#define F_NO_RPLCT_M    V_NO_RPLCT_M(1U)

#define S_RPLCT_SEL_L    18
#define M_RPLCT_SEL_L    0x3U
#define V_RPLCT_SEL_L(x) ((x) << S_RPLCT_SEL_L)
#define G_RPLCT_SEL_L(x) (((x) >> S_RPLCT_SEL_L) & M_RPLCT_SEL_L)

#define S_FLTR_VLAN_SEL    17
#define V_FLTR_VLAN_SEL(x) ((x) << S_FLTR_VLAN_SEL)
#define F_FLTR_VLAN_SEL    V_FLTR_VLAN_SEL(1U)

#define S_PRIO_VLAN_SEL    16
#define V_PRIO_VLAN_SEL(x) ((x) << S_PRIO_VLAN_SEL)
#define F_PRIO_VLAN_SEL    V_PRIO_VLAN_SEL(1U)

#define S_CHK_8023_LEN_M    15
#define V_CHK_8023_LEN_M(x) ((x) << S_CHK_8023_LEN_M)
#define F_CHK_8023_LEN_M    V_CHK_8023_LEN_M(1U)

#define S_CHK_8023_LEN_L    14
#define V_CHK_8023_LEN_L(x) ((x) << S_CHK_8023_LEN_L)
#define F_CHK_8023_LEN_L    V_CHK_8023_LEN_L(1U)

#define S_NIV_DROP    13
#define V_NIV_DROP(x) ((x) << S_NIV_DROP)
#define F_NIV_DROP    V_NIV_DROP(1U)

#define S_NOV_DROP    12
#define V_NOV_DROP(x) ((x) << S_NOV_DROP)
#define F_NOV_DROP    V_NOV_DROP(1U)

#define S_CLS_PRT    11
#define V_CLS_PRT(x) ((x) << S_CLS_PRT)
#define F_CLS_PRT    V_CLS_PRT(1U)

#define S_RX_QFC_EN    10
#define V_RX_QFC_EN(x) ((x) << S_RX_QFC_EN)
#define F_RX_QFC_EN    V_RX_QFC_EN(1U)

#define S_QFC_FWD_UP    9
#define V_QFC_FWD_UP(x) ((x) << S_QFC_FWD_UP)
#define F_QFC_FWD_UP    V_QFC_FWD_UP(1U)

#define S_PPP_FWD_UP    8
#define V_PPP_FWD_UP(x) ((x) << S_PPP_FWD_UP)
#define F_PPP_FWD_UP    V_PPP_FWD_UP(1U)

#define S_PAUSE_FWD_UP    7
#define V_PAUSE_FWD_UP(x) ((x) << S_PAUSE_FWD_UP)
#define F_PAUSE_FWD_UP    V_PAUSE_FWD_UP(1U)

#define S_LPBK_BP    6
#define V_LPBK_BP(x) ((x) << S_LPBK_BP)
#define F_LPBK_BP    V_LPBK_BP(1U)

#define S_PASS_NO_MATCH    5
#define V_PASS_NO_MATCH(x) ((x) << S_PASS_NO_MATCH)
#define F_PASS_NO_MATCH    V_PASS_NO_MATCH(1U)

#define S_IVLAN_EN    4
#define V_IVLAN_EN(x) ((x) << S_IVLAN_EN)
#define F_IVLAN_EN    V_IVLAN_EN(1U)

#define S_OVLAN_EN3    3
#define V_OVLAN_EN3(x) ((x) << S_OVLAN_EN3)
#define F_OVLAN_EN3    V_OVLAN_EN3(1U)

#define S_OVLAN_EN2    2
#define V_OVLAN_EN2(x) ((x) << S_OVLAN_EN2)
#define F_OVLAN_EN2    V_OVLAN_EN2(1U)

#define S_OVLAN_EN1    1
#define V_OVLAN_EN1(x) ((x) << S_OVLAN_EN1)
#define F_OVLAN_EN1    V_OVLAN_EN1(1U)

#define S_OVLAN_EN0    0
#define V_OVLAN_EN0(x) ((x) << S_OVLAN_EN0)
#define F_OVLAN_EN0    V_OVLAN_EN0(1U)

#define S_PTP_FWD_UP    21
#define V_PTP_FWD_UP(x) ((x) << S_PTP_FWD_UP)
#define F_PTP_FWD_UP    V_PTP_FWD_UP(1U)

#define A_MPS_PORT_RX_MTU 0x104
#define A_MPS_PORT_RX_PF_MAP 0x108
#define A_MPS_PORT_RX_VF_MAP0 0x10c
#define A_MPS_PORT_RX_VF_MAP1 0x110
#define A_MPS_PORT_RX_VF_MAP2 0x114
#define A_MPS_PORT_RX_VF_MAP3 0x118
#define A_MPS_PORT_RX_IVLAN 0x11c

#define S_IVLAN_ETYPE    0
#define M_IVLAN_ETYPE    0xffffU
#define V_IVLAN_ETYPE(x) ((x) << S_IVLAN_ETYPE)
#define G_IVLAN_ETYPE(x) (((x) >> S_IVLAN_ETYPE) & M_IVLAN_ETYPE)

#define A_MPS_PORT_RX_OVLAN0 0x120

#define S_OVLAN_MASK    16
#define M_OVLAN_MASK    0xffffU
#define V_OVLAN_MASK(x) ((x) << S_OVLAN_MASK)
#define G_OVLAN_MASK(x) (((x) >> S_OVLAN_MASK) & M_OVLAN_MASK)

#define S_OVLAN_ETYPE    0
#define M_OVLAN_ETYPE    0xffffU
#define V_OVLAN_ETYPE(x) ((x) << S_OVLAN_ETYPE)
#define G_OVLAN_ETYPE(x) (((x) >> S_OVLAN_ETYPE) & M_OVLAN_ETYPE)

#define A_MPS_PORT_RX_OVLAN1 0x124
#define A_MPS_PORT_RX_OVLAN2 0x128
#define A_MPS_PORT_RX_OVLAN3 0x12c
#define A_MPS_PORT_RX_RSS_HASH 0x130
#define A_MPS_PORT_RX_RSS_CONTROL 0x134

#define S_RSS_CTRL    16
#define M_RSS_CTRL    0xffU
#define V_RSS_CTRL(x) ((x) << S_RSS_CTRL)
#define G_RSS_CTRL(x) (((x) >> S_RSS_CTRL) & M_RSS_CTRL)

#define S_QUE_NUM    0
#define M_QUE_NUM    0xffffU
#define V_QUE_NUM(x) ((x) << S_QUE_NUM)
#define G_QUE_NUM(x) (((x) >> S_QUE_NUM) & M_QUE_NUM)

#define A_MPS_PORT_RX_CTL1 0x138

#define S_FIXED_PFVF_MAC    13
#define V_FIXED_PFVF_MAC(x) ((x) << S_FIXED_PFVF_MAC)
#define F_FIXED_PFVF_MAC    V_FIXED_PFVF_MAC(1U)

#define S_FIXED_PFVF_LPBK    12
#define V_FIXED_PFVF_LPBK(x) ((x) << S_FIXED_PFVF_LPBK)
#define F_FIXED_PFVF_LPBK    V_FIXED_PFVF_LPBK(1U)

#define S_FIXED_PFVF_LPBK_OV    11
#define V_FIXED_PFVF_LPBK_OV(x) ((x) << S_FIXED_PFVF_LPBK_OV)
#define F_FIXED_PFVF_LPBK_OV    V_FIXED_PFVF_LPBK_OV(1U)

#define S_FIXED_PF    8
#define M_FIXED_PF    0x7U
#define V_FIXED_PF(x) ((x) << S_FIXED_PF)
#define G_FIXED_PF(x) (((x) >> S_FIXED_PF) & M_FIXED_PF)

#define S_FIXED_VF_VLD    7
#define V_FIXED_VF_VLD(x) ((x) << S_FIXED_VF_VLD)
#define F_FIXED_VF_VLD    V_FIXED_VF_VLD(1U)

#define S_FIXED_VF    0
#define M_FIXED_VF    0x7fU
#define V_FIXED_VF(x) ((x) << S_FIXED_VF)
#define G_FIXED_VF(x) (((x) >> S_FIXED_VF) & M_FIXED_VF)

#define A_MPS_PORT_RX_SPARE 0x13c
#define A_MPS_PORT_RX_PTP_RSS_HASH 0x140
#define A_MPS_PORT_RX_PTP_RSS_CONTROL 0x144
#define A_MPS_PORT_TX_MAC_RELOAD_CH0 0x190

#define S_CREDIT    0
#define M_CREDIT    0xffffU
#define V_CREDIT(x) ((x) << S_CREDIT)
#define G_CREDIT(x) (((x) >> S_CREDIT) & M_CREDIT)

#define A_MPS_PORT_TX_MAC_RELOAD_CH1 0x194
#define A_MPS_PORT_TX_MAC_RELOAD_CH2 0x198
#define A_MPS_PORT_TX_MAC_RELOAD_CH3 0x19c
#define A_MPS_PORT_TX_MAC_RELOAD_CH4 0x1a0
#define A_MPS_PORT_TX_LPBK_RELOAD_CH0 0x1a8
#define A_MPS_PORT_TX_LPBK_RELOAD_CH1 0x1ac
#define A_MPS_PORT_TX_LPBK_RELOAD_CH2 0x1b0
#define A_MPS_PORT_TX_LPBK_RELOAD_CH3 0x1b4
#define A_MPS_PORT_TX_LPBK_RELOAD_CH4 0x1b8
#define A_MPS_PORT_TX_FIFO_CTL 0x1c4

#define S_FIFOTH    5
#define M_FIFOTH    0x1ffU
#define V_FIFOTH(x) ((x) << S_FIFOTH)
#define G_FIFOTH(x) (((x) >> S_FIFOTH) & M_FIFOTH)

#define S_FIFOEN    4
#define V_FIFOEN(x) ((x) << S_FIFOEN)
#define F_FIFOEN    V_FIFOEN(1U)

#define S_MAXPKTCNT    0
#define M_MAXPKTCNT    0xfU
#define V_MAXPKTCNT(x) ((x) << S_MAXPKTCNT)
#define G_MAXPKTCNT(x) (((x) >> S_MAXPKTCNT) & M_MAXPKTCNT)

#define A_MPS_PORT_FPGA_PAUSE_CTL 0x1c8

#define S_FPGAPAUSEEN    0
#define V_FPGAPAUSEEN(x) ((x) << S_FPGAPAUSEEN)
#define F_FPGAPAUSEEN    V_FPGAPAUSEEN(1U)

#define A_MPS_PORT_TX_PAUSE_PENDING_STATUS 0x1d0

#define S_OFF_PENDING    8
#define M_OFF_PENDING    0xffU
#define V_OFF_PENDING(x) ((x) << S_OFF_PENDING)
#define G_OFF_PENDING(x) (((x) >> S_OFF_PENDING) & M_OFF_PENDING)

#define S_ON_PENDING    0
#define M_ON_PENDING    0xffU
#define V_ON_PENDING(x) ((x) << S_ON_PENDING)
#define G_ON_PENDING(x) (((x) >> S_ON_PENDING) & M_ON_PENDING)

#define A_MPS_PORT_CLS_HASH_SRAM 0x200

#define S_VALID    20
#define V_VALID(x) ((x) << S_VALID)
#define F_VALID    V_VALID(1U)

#define S_HASHPORTMAP    16
#define M_HASHPORTMAP    0xfU
#define V_HASHPORTMAP(x) ((x) << S_HASHPORTMAP)
#define G_HASHPORTMAP(x) (((x) >> S_HASHPORTMAP) & M_HASHPORTMAP)

#define S_MULTILISTEN    15
#define V_MULTILISTEN(x) ((x) << S_MULTILISTEN)
#define F_MULTILISTEN    V_MULTILISTEN(1U)

#define S_PRIORITY    12
#define M_PRIORITY    0x7U
#define V_PRIORITY(x) ((x) << S_PRIORITY)
#define G_PRIORITY(x) (((x) >> S_PRIORITY) & M_PRIORITY)

#define S_REPLICATE    11
#define V_REPLICATE(x) ((x) << S_REPLICATE)
#define F_REPLICATE    V_REPLICATE(1U)

#define S_PF    8
#define M_PF    0x7U
#define V_PF(x) ((x) << S_PF)
#define G_PF(x) (((x) >> S_PF) & M_PF)

#define S_VF_VALID    7
#define V_VF_VALID(x) ((x) << S_VF_VALID)
#define F_VF_VALID    V_VF_VALID(1U)

#define S_VF    0
#define M_VF    0x7fU
#define V_VF(x) ((x) << S_VF)
#define G_VF(x) (((x) >> S_VF) & M_VF)

#define A_MPS_PF_CTL 0x2c0

#define S_TXEN    1
#define V_TXEN(x) ((x) << S_TXEN)
#define F_TXEN    V_TXEN(1U)

#define S_RXEN    0
#define V_RXEN(x) ((x) << S_RXEN)
#define F_RXEN    V_RXEN(1U)

#define A_MPS_PF_TX_QINQ_VLAN 0x2e0

#define S_PROTOCOLID    16
#define M_PROTOCOLID    0xffffU
#define V_PROTOCOLID(x) ((x) << S_PROTOCOLID)
#define G_PROTOCOLID(x) (((x) >> S_PROTOCOLID) & M_PROTOCOLID)

#define S_VLAN_PRIO    13
#define M_VLAN_PRIO    0x7U
#define V_VLAN_PRIO(x) ((x) << S_VLAN_PRIO)
#define G_VLAN_PRIO(x) (((x) >> S_VLAN_PRIO) & M_VLAN_PRIO)

#define S_CFI    12
#define V_CFI(x) ((x) << S_CFI)
#define F_CFI    V_CFI(1U)

#define S_TAG    0
#define M_TAG    0xfffU
#define V_TAG(x) ((x) << S_TAG)
#define G_TAG(x) (((x) >> S_TAG) & M_TAG)

#define A_MPS_PF_STAT_TX_PF_BCAST_BYTES_L 0x300
#define A_MPS_PF_STAT_TX_PF_BCAST_BYTES_H 0x304
#define A_MPS_PORT_CLS_HASH_CTL 0x304

#define S_UNICASTENABLE    31
#define V_UNICASTENABLE(x) ((x) << S_UNICASTENABLE)
#define F_UNICASTENABLE    V_UNICASTENABLE(1U)

#define A_MPS_PF_STAT_TX_PF_BCAST_FRAMES_L 0x308
#define A_MPS_PORT_CLS_PROMISCUOUS_CTL 0x308

#define S_PROMISCEN    31
#define V_PROMISCEN(x) ((x) << S_PROMISCEN)
#define F_PROMISCEN    V_PROMISCEN(1U)

#define A_MPS_PF_STAT_TX_PF_BCAST_FRAMES_H 0x30c
#define A_MPS_PORT_CLS_BMC_MAC_ADDR_L 0x30c
#define A_MPS_PF_STAT_TX_PF_MCAST_BYTES_L 0x310
#define A_MPS_PORT_CLS_BMC_MAC_ADDR_H 0x310

#define S_MATCHBOTH    17
#define V_MATCHBOTH(x) ((x) << S_MATCHBOTH)
#define F_MATCHBOTH    V_MATCHBOTH(1U)

#define S_BMC_VLD    16
#define V_BMC_VLD(x) ((x) << S_BMC_VLD)
#define F_BMC_VLD    V_BMC_VLD(1U)

#define A_MPS_PF_STAT_TX_PF_MCAST_BYTES_H 0x314
#define A_MPS_PORT_CLS_BMC_VLAN 0x314

#define S_BMC_VLAN_SEL    13
#define V_BMC_VLAN_SEL(x) ((x) << S_BMC_VLAN_SEL)
#define F_BMC_VLAN_SEL    V_BMC_VLAN_SEL(1U)

#define S_VLAN_VLD    12
#define V_VLAN_VLD(x) ((x) << S_VLAN_VLD)
#define F_VLAN_VLD    V_VLAN_VLD(1U)

#define A_MPS_PF_STAT_TX_PF_MCAST_FRAMES_L 0x318
#define A_MPS_PORT_CLS_CTL 0x318

#define S_PF_VLAN_SEL    0
#define V_PF_VLAN_SEL(x) ((x) << S_PF_VLAN_SEL)
#define F_PF_VLAN_SEL    V_PF_VLAN_SEL(1U)

#define S_LPBK_TCAM1_HIT_PRIORITY    14
#define V_LPBK_TCAM1_HIT_PRIORITY(x) ((x) << S_LPBK_TCAM1_HIT_PRIORITY)
#define F_LPBK_TCAM1_HIT_PRIORITY    V_LPBK_TCAM1_HIT_PRIORITY(1U)

#define S_LPBK_TCAM0_HIT_PRIORITY    13
#define V_LPBK_TCAM0_HIT_PRIORITY(x) ((x) << S_LPBK_TCAM0_HIT_PRIORITY)
#define F_LPBK_TCAM0_HIT_PRIORITY    V_LPBK_TCAM0_HIT_PRIORITY(1U)

#define S_LPBK_TCAM_PRIORITY    12
#define V_LPBK_TCAM_PRIORITY(x) ((x) << S_LPBK_TCAM_PRIORITY)
#define F_LPBK_TCAM_PRIORITY    V_LPBK_TCAM_PRIORITY(1U)

#define S_LPBK_SMAC_TCAM_SEL    10
#define M_LPBK_SMAC_TCAM_SEL    0x3U
#define V_LPBK_SMAC_TCAM_SEL(x) ((x) << S_LPBK_SMAC_TCAM_SEL)
#define G_LPBK_SMAC_TCAM_SEL(x) (((x) >> S_LPBK_SMAC_TCAM_SEL) & M_LPBK_SMAC_TCAM_SEL)

#define S_LPBK_DMAC_TCAM_SEL    8
#define M_LPBK_DMAC_TCAM_SEL    0x3U
#define V_LPBK_DMAC_TCAM_SEL(x) ((x) << S_LPBK_DMAC_TCAM_SEL)
#define G_LPBK_DMAC_TCAM_SEL(x) (((x) >> S_LPBK_DMAC_TCAM_SEL) & M_LPBK_DMAC_TCAM_SEL)

#define S_TCAM1_HIT_PRIORITY    7
#define V_TCAM1_HIT_PRIORITY(x) ((x) << S_TCAM1_HIT_PRIORITY)
#define F_TCAM1_HIT_PRIORITY    V_TCAM1_HIT_PRIORITY(1U)

#define S_TCAM0_HIT_PRIORITY    6
#define V_TCAM0_HIT_PRIORITY(x) ((x) << S_TCAM0_HIT_PRIORITY)
#define F_TCAM0_HIT_PRIORITY    V_TCAM0_HIT_PRIORITY(1U)

#define S_TCAM_PRIORITY    5
#define V_TCAM_PRIORITY(x) ((x) << S_TCAM_PRIORITY)
#define F_TCAM_PRIORITY    V_TCAM_PRIORITY(1U)

#define S_SMAC_TCAM_SEL    3
#define M_SMAC_TCAM_SEL    0x3U
#define V_SMAC_TCAM_SEL(x) ((x) << S_SMAC_TCAM_SEL)
#define G_SMAC_TCAM_SEL(x) (((x) >> S_SMAC_TCAM_SEL) & M_SMAC_TCAM_SEL)

#define S_DMAC_TCAM_SEL    1
#define M_DMAC_TCAM_SEL    0x3U
#define V_DMAC_TCAM_SEL(x) ((x) << S_DMAC_TCAM_SEL)
#define G_DMAC_TCAM_SEL(x) (((x) >> S_DMAC_TCAM_SEL) & M_DMAC_TCAM_SEL)

#define A_MPS_PF_STAT_TX_PF_MCAST_FRAMES_H 0x31c
#define A_MPS_PF_STAT_TX_PF_UCAST_BYTES_L 0x320
#define A_MPS_PF_STAT_TX_PF_UCAST_BYTES_H 0x324
#define A_MPS_PF_STAT_TX_PF_UCAST_FRAMES_L 0x328
#define A_MPS_PF_STAT_TX_PF_UCAST_FRAMES_H 0x32c
#define A_MPS_PF_STAT_TX_PF_OFFLOAD_BYTES_L 0x330
#define A_MPS_PF_STAT_TX_PF_OFFLOAD_BYTES_H 0x334
#define A_MPS_PF_STAT_TX_PF_OFFLOAD_FRAMES_L 0x338
#define A_MPS_PF_STAT_TX_PF_OFFLOAD_FRAMES_H 0x33c
#define A_MPS_PF_STAT_RX_PF_BYTES_L 0x340
#define A_MPS_PF_STAT_RX_PF_BYTES_H 0x344
#define A_MPS_PF_STAT_RX_PF_FRAMES_L 0x348
#define A_MPS_PF_STAT_RX_PF_FRAMES_H 0x34c
#define A_MPS_PF_STAT_RX_PF_BCAST_BYTES_L 0x350
#define A_MPS_PF_STAT_RX_PF_BCAST_BYTES_H 0x354
#define A_MPS_PF_STAT_RX_PF_BCAST_FRAMES_L 0x358
#define A_MPS_PF_STAT_RX_PF_BCAST_FRAMES_H 0x35c
#define A_MPS_PF_STAT_RX_PF_MCAST_BYTES_L 0x360
#define A_MPS_PF_STAT_RX_PF_MCAST_BYTES_H 0x364
#define A_MPS_PF_STAT_RX_PF_MCAST_FRAMES_L 0x368
#define A_MPS_PF_STAT_RX_PF_MCAST_FRAMES_H 0x36c
#define A_MPS_PF_STAT_RX_PF_UCAST_BYTES_L 0x370
#define A_MPS_PF_STAT_RX_PF_UCAST_BYTES_H 0x374
#define A_MPS_PF_STAT_RX_PF_UCAST_FRAMES_L 0x378
#define A_MPS_PF_STAT_RX_PF_UCAST_FRAMES_H 0x37c
#define A_MPS_PF_STAT_RX_PF_ERR_FRAMES_L 0x380
#define A_MPS_PF_STAT_RX_PF_ERR_FRAMES_H 0x384
#define A_MPS_PORT_STAT_TX_PORT_BYTES_L 0x400
#define A_MPS_PORT_STAT_TX_PORT_BYTES_H 0x404
#define A_MPS_PORT_STAT_TX_PORT_FRAMES_L 0x408
#define A_MPS_PORT_STAT_TX_PORT_FRAMES_H 0x40c
#define A_MPS_PORT_STAT_TX_PORT_BCAST_L 0x410
#define A_MPS_PORT_STAT_TX_PORT_BCAST_H 0x414
#define A_MPS_PORT_STAT_TX_PORT_MCAST_L 0x418
#define A_MPS_PORT_STAT_TX_PORT_MCAST_H 0x41c
#define A_MPS_PORT_STAT_TX_PORT_UCAST_L 0x420
#define A_MPS_PORT_STAT_TX_PORT_UCAST_H 0x424
#define A_MPS_PORT_STAT_TX_PORT_ERROR_L 0x428
#define A_MPS_PORT_STAT_TX_PORT_ERROR_H 0x42c
#define A_MPS_PORT_STAT_TX_PORT_64B_L 0x430
#define A_MPS_PORT_STAT_TX_PORT_64B_H 0x434
#define A_MPS_PORT_STAT_TX_PORT_65B_127B_L 0x438
#define A_MPS_PORT_STAT_TX_PORT_65B_127B_H 0x43c
#define A_MPS_PORT_STAT_TX_PORT_128B_255B_L 0x440
#define A_MPS_PORT_STAT_TX_PORT_128B_255B_H 0x444
#define A_MPS_PORT_STAT_TX_PORT_256B_511B_L 0x448
#define A_MPS_PORT_STAT_TX_PORT_256B_511B_H 0x44c
#define A_MPS_PORT_STAT_TX_PORT_512B_1023B_L 0x450
#define A_MPS_PORT_STAT_TX_PORT_512B_1023B_H 0x454
#define A_MPS_PORT_STAT_TX_PORT_1024B_1518B_L 0x458
#define A_MPS_PORT_STAT_TX_PORT_1024B_1518B_H 0x45c
#define A_MPS_PORT_STAT_TX_PORT_1519B_MAX_L 0x460
#define A_MPS_PORT_STAT_TX_PORT_1519B_MAX_H 0x464
#define A_MPS_PORT_STAT_TX_PORT_DROP_L 0x468
#define A_MPS_PORT_STAT_TX_PORT_DROP_H 0x46c
#define A_MPS_PORT_STAT_TX_PORT_PAUSE_L 0x470
#define A_MPS_PORT_STAT_TX_PORT_PAUSE_H 0x474
#define A_MPS_PORT_STAT_TX_PORT_PPP0_L 0x478
#define A_MPS_PORT_STAT_TX_PORT_PPP0_H 0x47c
#define A_MPS_PORT_STAT_TX_PORT_PPP1_L 0x480
#define A_MPS_PORT_STAT_TX_PORT_PPP1_H 0x484
#define A_MPS_PORT_STAT_TX_PORT_PPP2_L 0x488
#define A_MPS_PORT_STAT_TX_PORT_PPP2_H 0x48c
#define A_MPS_PORT_STAT_TX_PORT_PPP3_L 0x490
#define A_MPS_PORT_STAT_TX_PORT_PPP3_H 0x494
#define A_MPS_PORT_STAT_TX_PORT_PPP4_L 0x498
#define A_MPS_PORT_STAT_TX_PORT_PPP4_H 0x49c
#define A_MPS_PORT_STAT_TX_PORT_PPP5_L 0x4a0
#define A_MPS_PORT_STAT_TX_PORT_PPP5_H 0x4a4
#define A_MPS_PORT_STAT_TX_PORT_PPP6_L 0x4a8
#define A_MPS_PORT_STAT_TX_PORT_PPP6_H 0x4ac
#define A_MPS_PORT_STAT_TX_PORT_PPP7_L 0x4b0
#define A_MPS_PORT_STAT_TX_PORT_PPP7_H 0x4b4
#define A_MPS_PORT_STAT_LB_PORT_BYTES_L 0x4c0
#define A_MPS_PORT_STAT_LB_PORT_BYTES_H 0x4c4
#define A_MPS_PORT_STAT_LB_PORT_FRAMES_L 0x4c8
#define A_MPS_PORT_STAT_LB_PORT_FRAMES_H 0x4cc
#define A_MPS_PORT_STAT_LB_PORT_BCAST_L 0x4d0
#define A_MPS_PORT_STAT_LB_PORT_BCAST_H 0x4d4
#define A_MPS_PORT_STAT_LB_PORT_MCAST_L 0x4d8
#define A_MPS_PORT_STAT_LB_PORT_MCAST_H 0x4dc
#define A_MPS_PORT_STAT_LB_PORT_UCAST_L 0x4e0
#define A_MPS_PORT_STAT_LB_PORT_UCAST_H 0x4e4
#define A_MPS_PORT_STAT_LB_PORT_ERROR_L 0x4e8
#define A_MPS_PORT_STAT_LB_PORT_ERROR_H 0x4ec
#define A_MPS_PORT_STAT_LB_PORT_64B_L 0x4f0
#define A_MPS_PORT_STAT_LB_PORT_64B_H 0x4f4
#define A_MPS_PORT_STAT_LB_PORT_65B_127B_L 0x4f8
#define A_MPS_PORT_STAT_LB_PORT_65B_127B_H 0x4fc
#define A_MPS_PORT_STAT_LB_PORT_128B_255B_L 0x500
#define A_MPS_PORT_STAT_LB_PORT_128B_255B_H 0x504
#define A_MPS_PORT_STAT_LB_PORT_256B_511B_L 0x508
#define A_MPS_PORT_STAT_LB_PORT_256B_511B_H 0x50c
#define A_MPS_PORT_STAT_LB_PORT_512B_1023B_L 0x510
#define A_MPS_PORT_STAT_LB_PORT_512B_1023B_H 0x514
#define A_MPS_PORT_STAT_LB_PORT_1024B_1518B_L 0x518
#define A_MPS_PORT_STAT_LB_PORT_1024B_1518B_H 0x51c
#define A_MPS_PORT_STAT_LB_PORT_1519B_MAX_L 0x520
#define A_MPS_PORT_STAT_LB_PORT_1519B_MAX_H 0x524
#define A_MPS_PORT_STAT_LB_PORT_DROP_FRAMES 0x528
#define A_MPS_PORT_STAT_LB_PORT_DROP_FRAMES_L 0x528
#define A_MPS_PORT_STAT_LB_PORT_DROP_FRAMES_H 0x52c
#define A_MPS_PORT_STAT_RX_PORT_BYTES_L 0x540
#define A_MPS_PORT_STAT_RX_PORT_BYTES_H 0x544
#define A_MPS_PORT_STAT_RX_PORT_FRAMES_L 0x548
#define A_MPS_PORT_STAT_RX_PORT_FRAMES_H 0x54c
#define A_MPS_PORT_STAT_RX_PORT_BCAST_L 0x550
#define A_MPS_PORT_STAT_RX_PORT_BCAST_H 0x554
#define A_MPS_PORT_STAT_RX_PORT_MCAST_L 0x558
#define A_MPS_PORT_STAT_RX_PORT_MCAST_H 0x55c
#define A_MPS_PORT_STAT_RX_PORT_UCAST_L 0x560
#define A_MPS_PORT_STAT_RX_PORT_UCAST_H 0x564
#define A_MPS_PORT_STAT_RX_PORT_MTU_ERROR_L 0x568
#define A_MPS_PORT_STAT_RX_PORT_MTU_ERROR_H 0x56c
#define A_MPS_PORT_STAT_RX_PORT_MTU_CRC_ERROR_L 0x570
#define A_MPS_PORT_STAT_RX_PORT_MTU_CRC_ERROR_H 0x574
#define A_MPS_PORT_STAT_RX_PORT_CRC_ERROR_L 0x578
#define A_MPS_PORT_STAT_RX_PORT_CRC_ERROR_H 0x57c
#define A_MPS_PORT_STAT_RX_PORT_LEN_ERROR_L 0x580
#define A_MPS_PORT_STAT_RX_PORT_LEN_ERROR_H 0x584
#define A_MPS_PORT_STAT_RX_PORT_SYM_ERROR_L 0x588
#define A_MPS_PORT_STAT_RX_PORT_SYM_ERROR_H 0x58c
#define A_MPS_PORT_STAT_RX_PORT_64B_L 0x590
#define A_MPS_PORT_STAT_RX_PORT_64B_H 0x594
#define A_MPS_PORT_STAT_RX_PORT_65B_127B_L 0x598
#define A_MPS_PORT_STAT_RX_PORT_65B_127B_H 0x59c
#define A_MPS_PORT_STAT_RX_PORT_128B_255B_L 0x5a0
#define A_MPS_PORT_STAT_RX_PORT_128B_255B_H 0x5a4
#define A_MPS_PORT_STAT_RX_PORT_256B_511B_L 0x5a8
#define A_MPS_PORT_STAT_RX_PORT_256B_511B_H 0x5ac
#define A_MPS_PORT_STAT_RX_PORT_512B_1023B_L 0x5b0
#define A_MPS_PORT_STAT_RX_PORT_512B_1023B_H 0x5b4
#define A_MPS_PORT_STAT_RX_PORT_1024B_1518B_L 0x5b8
#define A_MPS_PORT_STAT_RX_PORT_1024B_1518B_H 0x5bc
#define A_MPS_PORT_STAT_RX_PORT_1519B_MAX_L 0x5c0
#define A_MPS_PORT_STAT_RX_PORT_1519B_MAX_H 0x5c4
#define A_MPS_PORT_STAT_RX_PORT_PAUSE_L 0x5c8
#define A_MPS_PORT_STAT_RX_PORT_PAUSE_H 0x5cc
#define A_MPS_PORT_STAT_RX_PORT_PPP0_L 0x5d0
#define A_MPS_PORT_STAT_RX_PORT_PPP0_H 0x5d4
#define A_MPS_PORT_STAT_RX_PORT_PPP1_L 0x5d8
#define A_MPS_PORT_STAT_RX_PORT_PPP1_H 0x5dc
#define A_MPS_PORT_STAT_RX_PORT_PPP2_L 0x5e0
#define A_MPS_PORT_STAT_RX_PORT_PPP2_H 0x5e4
#define A_MPS_PORT_STAT_RX_PORT_PPP3_L 0x5e8
#define A_MPS_PORT_STAT_RX_PORT_PPP3_H 0x5ec
#define A_MPS_PORT_STAT_RX_PORT_PPP4_L 0x5f0
#define A_MPS_PORT_STAT_RX_PORT_PPP4_H 0x5f4
#define A_MPS_PORT_STAT_RX_PORT_PPP5_L 0x5f8
#define A_MPS_PORT_STAT_RX_PORT_PPP5_H 0x5fc
#define A_MPS_PORT_STAT_RX_PORT_PPP6_L 0x600
#define A_MPS_PORT_STAT_RX_PORT_PPP6_H 0x604
#define A_MPS_PORT_STAT_RX_PORT_PPP7_L 0x608
#define A_MPS_PORT_STAT_RX_PORT_PPP7_H 0x60c
#define A_MPS_PORT_STAT_RX_PORT_LESS_64B_L 0x610
#define A_MPS_PORT_STAT_RX_PORT_LESS_64B_H 0x614
#define A_MPS_PORT_STAT_RX_PORT_MAC_ERROR_L 0x618
#define A_MPS_PORT_STAT_RX_PORT_MAC_ERROR_H 0x61c
#define A_MPS_CMN_CTL 0x9000

#define S_DETECT8023    3
#define V_DETECT8023(x) ((x) << S_DETECT8023)
#define F_DETECT8023    V_DETECT8023(1U)

#define S_VFDIRECTACCESS    2
#define V_VFDIRECTACCESS(x) ((x) << S_VFDIRECTACCESS)
#define F_VFDIRECTACCESS    V_VFDIRECTACCESS(1U)

#define S_NUMPORTS    0
#define M_NUMPORTS    0x3U
#define V_NUMPORTS(x) ((x) << S_NUMPORTS)
#define G_NUMPORTS(x) (((x) >> S_NUMPORTS) & M_NUMPORTS)

#define S_LPBKCRDTCTRL    4
#define V_LPBKCRDTCTRL(x) ((x) << S_LPBKCRDTCTRL)
#define F_LPBKCRDTCTRL    V_LPBKCRDTCTRL(1U)

#define A_MPS_INT_ENABLE 0x9004

#define S_STATINTENB    5
#define V_STATINTENB(x) ((x) << S_STATINTENB)
#define F_STATINTENB    V_STATINTENB(1U)

#define S_TXINTENB    4
#define V_TXINTENB(x) ((x) << S_TXINTENB)
#define F_TXINTENB    V_TXINTENB(1U)

#define S_RXINTENB    3
#define V_RXINTENB(x) ((x) << S_RXINTENB)
#define F_RXINTENB    V_RXINTENB(1U)

#define S_TRCINTENB    2
#define V_TRCINTENB(x) ((x) << S_TRCINTENB)
#define F_TRCINTENB    V_TRCINTENB(1U)

#define S_CLSINTENB    1
#define V_CLSINTENB(x) ((x) << S_CLSINTENB)
#define F_CLSINTENB    V_CLSINTENB(1U)

#define S_PLINTENB    0
#define V_PLINTENB(x) ((x) << S_PLINTENB)
#define F_PLINTENB    V_PLINTENB(1U)

#define A_MPS_INT_CAUSE 0x9008

#define S_STATINT    5
#define V_STATINT(x) ((x) << S_STATINT)
#define F_STATINT    V_STATINT(1U)

#define S_TXINT    4
#define V_TXINT(x) ((x) << S_TXINT)
#define F_TXINT    V_TXINT(1U)

#define S_RXINT    3
#define V_RXINT(x) ((x) << S_RXINT)
#define F_RXINT    V_RXINT(1U)

#define S_TRCINT    2
#define V_TRCINT(x) ((x) << S_TRCINT)
#define F_TRCINT    V_TRCINT(1U)

#define S_CLSINT    1
#define V_CLSINT(x) ((x) << S_CLSINT)
#define F_CLSINT    V_CLSINT(1U)

#define S_PLINT    0
#define V_PLINT(x) ((x) << S_PLINT)
#define F_PLINT    V_PLINT(1U)

#define A_MPS_CGEN_GLOBAL 0x900c

#define S_MPS_GLOBAL_CGEN    0
#define V_MPS_GLOBAL_CGEN(x) ((x) << S_MPS_GLOBAL_CGEN)
#define F_MPS_GLOBAL_CGEN    V_MPS_GLOBAL_CGEN(1U)

#define A_MPS_VF_TX_CTL_31_0 0x9010
#define A_MPS_VF_TX_CTL_63_32 0x9014
#define A_MPS_VF_TX_CTL_95_64 0x9018
#define A_MPS_VF_TX_CTL_127_96 0x901c
#define A_MPS_VF_RX_CTL_31_0 0x9020
#define A_MPS_VF_RX_CTL_63_32 0x9024
#define A_MPS_VF_RX_CTL_95_64 0x9028
#define A_MPS_VF_RX_CTL_127_96 0x902c
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP0 0x9030

#define S_VALUE    0
#define M_VALUE    0xffffU
#define V_VALUE(x) ((x) << S_VALUE)
#define G_VALUE(x) (((x) >> S_VALUE) & M_VALUE)

#define A_MPS_TX_PAUSE_DURATION_BUF_GRP1 0x9034
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP2 0x9038
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP3 0x903c
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP0 0x9040
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP1 0x9044
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP2 0x9048
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP3 0x904c
#define A_MPS_TP_CSIDE_MUX_CTL_P0 0x9050

#define S_WEIGHT    0
#define M_WEIGHT    0xfffU
#define V_WEIGHT(x) ((x) << S_WEIGHT)
#define G_WEIGHT(x) (((x) >> S_WEIGHT) & M_WEIGHT)

#define A_MPS_TP_CSIDE_MUX_CTL_P1 0x9054
#define A_MPS_WOL_CTL_MODE 0x9058

#define S_WOL_MODE    0
#define V_WOL_MODE(x) ((x) << S_WOL_MODE)
#define F_WOL_MODE    V_WOL_MODE(1U)

#define A_MPS_FPGA_DEBUG 0x9060

#define S_LPBK_EN    8
#define V_LPBK_EN(x) ((x) << S_LPBK_EN)
#define F_LPBK_EN    V_LPBK_EN(1U)

#define S_CH_MAP3    6
#define M_CH_MAP3    0x3U
#define V_CH_MAP3(x) ((x) << S_CH_MAP3)
#define G_CH_MAP3(x) (((x) >> S_CH_MAP3) & M_CH_MAP3)

#define S_CH_MAP2    4
#define M_CH_MAP2    0x3U
#define V_CH_MAP2(x) ((x) << S_CH_MAP2)
#define G_CH_MAP2(x) (((x) >> S_CH_MAP2) & M_CH_MAP2)

#define S_CH_MAP1    2
#define M_CH_MAP1    0x3U
#define V_CH_MAP1(x) ((x) << S_CH_MAP1)
#define G_CH_MAP1(x) (((x) >> S_CH_MAP1) & M_CH_MAP1)

#define S_CH_MAP0    0
#define M_CH_MAP0    0x3U
#define V_CH_MAP0(x) ((x) << S_CH_MAP0)
#define G_CH_MAP0(x) (((x) >> S_CH_MAP0) & M_CH_MAP0)

#define S_FPGA_PTP_PORT    9
#define M_FPGA_PTP_PORT    0x3U
#define V_FPGA_PTP_PORT(x) ((x) << S_FPGA_PTP_PORT)
#define G_FPGA_PTP_PORT(x) (((x) >> S_FPGA_PTP_PORT) & M_FPGA_PTP_PORT)

#define A_MPS_DEBUG_CTL 0x9068

#define S_DBGMODECTL_H    11
#define V_DBGMODECTL_H(x) ((x) << S_DBGMODECTL_H)
#define F_DBGMODECTL_H    V_DBGMODECTL_H(1U)

#define S_DBGSEL_H    6
#define M_DBGSEL_H    0x1fU
#define V_DBGSEL_H(x) ((x) << S_DBGSEL_H)
#define G_DBGSEL_H(x) (((x) >> S_DBGSEL_H) & M_DBGSEL_H)

#define S_DBGMODECTL_L    5
#define V_DBGMODECTL_L(x) ((x) << S_DBGMODECTL_L)
#define F_DBGMODECTL_L    V_DBGMODECTL_L(1U)

#define S_DBGSEL_L    0
#define M_DBGSEL_L    0x1fU
#define V_DBGSEL_L(x) ((x) << S_DBGSEL_L)
#define G_DBGSEL_L(x) (((x) >> S_DBGSEL_L) & M_DBGSEL_L)

#define A_MPS_DEBUG_DATA_REG_L 0x906c
#define A_MPS_DEBUG_DATA_REG_H 0x9070
#define A_MPS_TOP_SPARE 0x9074

#define S_TOPSPARE    8
#define M_TOPSPARE    0xffffffU
#define V_TOPSPARE(x) ((x) << S_TOPSPARE)
#define G_TOPSPARE(x) (((x) >> S_TOPSPARE) & M_TOPSPARE)

#define S_OVLANSELLPBK3    7
#define V_OVLANSELLPBK3(x) ((x) << S_OVLANSELLPBK3)
#define F_OVLANSELLPBK3    V_OVLANSELLPBK3(1U)

#define S_OVLANSELLPBK2    6
#define V_OVLANSELLPBK2(x) ((x) << S_OVLANSELLPBK2)
#define F_OVLANSELLPBK2    V_OVLANSELLPBK2(1U)

#define S_OVLANSELLPBK1    5
#define V_OVLANSELLPBK1(x) ((x) << S_OVLANSELLPBK1)
#define F_OVLANSELLPBK1    V_OVLANSELLPBK1(1U)

#define S_OVLANSELLPBK0    4
#define V_OVLANSELLPBK0(x) ((x) << S_OVLANSELLPBK0)
#define F_OVLANSELLPBK0    V_OVLANSELLPBK0(1U)

#define S_OVLANSELMAC3    3
#define V_OVLANSELMAC3(x) ((x) << S_OVLANSELMAC3)
#define F_OVLANSELMAC3    V_OVLANSELMAC3(1U)

#define S_OVLANSELMAC2    2
#define V_OVLANSELMAC2(x) ((x) << S_OVLANSELMAC2)
#define F_OVLANSELMAC2    V_OVLANSELMAC2(1U)

#define S_OVLANSELMAC1    1
#define V_OVLANSELMAC1(x) ((x) << S_OVLANSELMAC1)
#define F_OVLANSELMAC1    V_OVLANSELMAC1(1U)

#define S_OVLANSELMAC0    0
#define V_OVLANSELMAC0(x) ((x) << S_OVLANSELMAC0)
#define F_OVLANSELMAC0    V_OVLANSELMAC0(1U)

#define S_T5_TOPSPARE    8
#define M_T5_TOPSPARE    0xffffffU
#define V_T5_TOPSPARE(x) ((x) << S_T5_TOPSPARE)
#define G_T5_TOPSPARE(x) (((x) >> S_T5_TOPSPARE) & M_T5_TOPSPARE)

#define A_MPS_T5_BUILD_REVISION 0x9078
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH0 0x907c
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH1 0x9080
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH2 0x9084
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH3 0x9088
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH4 0x908c
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH5 0x9090
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH6 0x9094
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH7 0x9098
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH8 0x909c
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH9 0x90a0
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH10 0x90a4
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH11 0x90a8
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH12 0x90ac
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH13 0x90b0
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH14 0x90b4
#define A_MPS_TX_PAUSE_DURATION_BUF_GRP_TH15 0x90b8
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH0 0x90bc
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH1 0x90c0
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH2 0x90c4
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH3 0x90c8
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH4 0x90cc
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH5 0x90d0
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH6 0x90d4
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH7 0x90d8
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH8 0x90dc
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH9 0x90e0
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH10 0x90e4
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH11 0x90e8
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH12 0x90ec
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH13 0x90f0
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH14 0x90f4
#define A_MPS_TX_PAUSE_RETRANS_BUF_GRP_TH15 0x90f8
#define A_MPS_BUILD_REVISION 0x90fc
#define A_MPS_TX_PRTY_SEL 0x9400

#define S_CH4_PRTY    20
#define M_CH4_PRTY    0x7U
#define V_CH4_PRTY(x) ((x) << S_CH4_PRTY)
#define G_CH4_PRTY(x) (((x) >> S_CH4_PRTY) & M_CH4_PRTY)

#define S_CH3_PRTY    16
#define M_CH3_PRTY    0x7U
#define V_CH3_PRTY(x) ((x) << S_CH3_PRTY)
#define G_CH3_PRTY(x) (((x) >> S_CH3_PRTY) & M_CH3_PRTY)

#define S_CH2_PRTY    12
#define M_CH2_PRTY    0x7U
#define V_CH2_PRTY(x) ((x) << S_CH2_PRTY)
#define G_CH2_PRTY(x) (((x) >> S_CH2_PRTY) & M_CH2_PRTY)

#define S_CH1_PRTY    8
#define M_CH1_PRTY    0x7U
#define V_CH1_PRTY(x) ((x) << S_CH1_PRTY)
#define G_CH1_PRTY(x) (((x) >> S_CH1_PRTY) & M_CH1_PRTY)

#define S_CH0_PRTY    4
#define M_CH0_PRTY    0x7U
#define V_CH0_PRTY(x) ((x) << S_CH0_PRTY)
#define G_CH0_PRTY(x) (((x) >> S_CH0_PRTY) & M_CH0_PRTY)

#define S_TP_SOURCE    2
#define M_TP_SOURCE    0x3U
#define V_TP_SOURCE(x) ((x) << S_TP_SOURCE)
#define G_TP_SOURCE(x) (((x) >> S_TP_SOURCE) & M_TP_SOURCE)

#define S_NCSI_SOURCE    0
#define M_NCSI_SOURCE    0x3U
#define V_NCSI_SOURCE(x) ((x) << S_NCSI_SOURCE)
#define G_NCSI_SOURCE(x) (((x) >> S_NCSI_SOURCE) & M_NCSI_SOURCE)

#define A_MPS_TX_INT_ENABLE 0x9404

#define S_PORTERR    16
#define V_PORTERR(x) ((x) << S_PORTERR)
#define F_PORTERR    V_PORTERR(1U)

#define S_FRMERR    15
#define V_FRMERR(x) ((x) << S_FRMERR)
#define F_FRMERR    V_FRMERR(1U)

#define S_SECNTERR    14
#define V_SECNTERR(x) ((x) << S_SECNTERR)
#define F_SECNTERR    V_SECNTERR(1U)

#define S_BUBBLE    13
#define V_BUBBLE(x) ((x) << S_BUBBLE)
#define F_BUBBLE    V_BUBBLE(1U)

#define S_TXDESCFIFO    9
#define M_TXDESCFIFO    0xfU
#define V_TXDESCFIFO(x) ((x) << S_TXDESCFIFO)
#define G_TXDESCFIFO(x) (((x) >> S_TXDESCFIFO) & M_TXDESCFIFO)

#define S_TXDATAFIFO    5
#define M_TXDATAFIFO    0xfU
#define V_TXDATAFIFO(x) ((x) << S_TXDATAFIFO)
#define G_TXDATAFIFO(x) (((x) >> S_TXDATAFIFO) & M_TXDATAFIFO)

#define S_NCSIFIFO    4
#define V_NCSIFIFO(x) ((x) << S_NCSIFIFO)
#define F_NCSIFIFO    V_NCSIFIFO(1U)

#define S_TPFIFO    0
#define M_TPFIFO    0xfU
#define V_TPFIFO(x) ((x) << S_TPFIFO)
#define G_TPFIFO(x) (((x) >> S_TPFIFO) & M_TPFIFO)

#define A_MPS_TX_INT_CAUSE 0x9408
#define A_MPS_TX_PERR_ENABLE 0x9410
#define A_MPS_TX_PERR_INJECT 0x9414

#define S_MPSTXMEMSEL    1
#define M_MPSTXMEMSEL    0x1fU
#define V_MPSTXMEMSEL(x) ((x) << S_MPSTXMEMSEL)
#define G_MPSTXMEMSEL(x) (((x) >> S_MPSTXMEMSEL) & M_MPSTXMEMSEL)

#define A_MPS_TX_SE_CNT_TP01 0x9418
#define A_MPS_TX_SE_CNT_TP23 0x941c
#define A_MPS_TX_SE_CNT_MAC01 0x9420
#define A_MPS_TX_SE_CNT_MAC23 0x9424
#define A_MPS_TX_SECNT_SPI_BUBBLE_ERR 0x9428

#define S_BUBBLEERR    16
#define M_BUBBLEERR    0xffU
#define V_BUBBLEERR(x) ((x) << S_BUBBLEERR)
#define G_BUBBLEERR(x) (((x) >> S_BUBBLEERR) & M_BUBBLEERR)

#define S_SPI    8
#define M_SPI    0xffU
#define V_SPI(x) ((x) << S_SPI)
#define G_SPI(x) (((x) >> S_SPI) & M_SPI)

#define S_SECNT    0
#define M_SECNT    0xffU
#define V_SECNT(x) ((x) << S_SECNT)
#define G_SECNT(x) (((x) >> S_SECNT) & M_SECNT)

#define A_MPS_TX_SECNT_BUBBLE_CLR 0x942c

#define S_BUBBLECLR    8
#define M_BUBBLECLR    0xffU
#define V_BUBBLECLR(x) ((x) << S_BUBBLECLR)
#define G_BUBBLECLR(x) (((x) >> S_BUBBLECLR) & M_BUBBLECLR)

#define S_NCSISECNT    20
#define V_NCSISECNT(x) ((x) << S_NCSISECNT)
#define F_NCSISECNT    V_NCSISECNT(1U)

#define S_LPBKSECNT    16
#define M_LPBKSECNT    0xfU
#define V_LPBKSECNT(x) ((x) << S_LPBKSECNT)
#define G_LPBKSECNT(x) (((x) >> S_LPBKSECNT) & M_LPBKSECNT)

#define A_MPS_TX_PORT_ERR 0x9430

#define S_LPBKPT3    7
#define V_LPBKPT3(x) ((x) << S_LPBKPT3)
#define F_LPBKPT3    V_LPBKPT3(1U)

#define S_LPBKPT2    6
#define V_LPBKPT2(x) ((x) << S_LPBKPT2)
#define F_LPBKPT2    V_LPBKPT2(1U)

#define S_LPBKPT1    5
#define V_LPBKPT1(x) ((x) << S_LPBKPT1)
#define F_LPBKPT1    V_LPBKPT1(1U)

#define S_LPBKPT0    4
#define V_LPBKPT0(x) ((x) << S_LPBKPT0)
#define F_LPBKPT0    V_LPBKPT0(1U)

#define S_PT3    3
#define V_PT3(x) ((x) << S_PT3)
#define F_PT3    V_PT3(1U)

#define S_PT2    2
#define V_PT2(x) ((x) << S_PT2)
#define F_PT2    V_PT2(1U)

#define S_PT1    1
#define V_PT1(x) ((x) << S_PT1)
#define F_PT1    V_PT1(1U)

#define S_PT0    0
#define V_PT0(x) ((x) << S_PT0)
#define F_PT0    V_PT0(1U)

#define A_MPS_TX_LPBK_DROP_BP_CTL_CH0 0x9434

#define S_BPEN    1
#define V_BPEN(x) ((x) << S_BPEN)
#define F_BPEN    V_BPEN(1U)

#define S_DROPEN    0
#define V_DROPEN(x) ((x) << S_DROPEN)
#define F_DROPEN    V_DROPEN(1U)

#define A_MPS_TX_LPBK_DROP_BP_CTL_CH1 0x9438
#define A_MPS_TX_LPBK_DROP_BP_CTL_CH2 0x943c
#define A_MPS_TX_LPBK_DROP_BP_CTL_CH3 0x9440
#define A_MPS_TX_DEBUG_REG_TP2TX_10 0x9444

#define S_SOPCH1    31
#define V_SOPCH1(x) ((x) << S_SOPCH1)
#define F_SOPCH1    V_SOPCH1(1U)

#define S_EOPCH1    30
#define V_EOPCH1(x) ((x) << S_EOPCH1)
#define F_EOPCH1    V_EOPCH1(1U)

#define S_SIZECH1    27
#define M_SIZECH1    0x7U
#define V_SIZECH1(x) ((x) << S_SIZECH1)
#define G_SIZECH1(x) (((x) >> S_SIZECH1) & M_SIZECH1)

#define S_ERRCH1    26
#define V_ERRCH1(x) ((x) << S_ERRCH1)
#define F_ERRCH1    V_ERRCH1(1U)

#define S_FULLCH1    25
#define V_FULLCH1(x) ((x) << S_FULLCH1)
#define F_FULLCH1    V_FULLCH1(1U)

#define S_VALIDCH1    24
#define V_VALIDCH1(x) ((x) << S_VALIDCH1)
#define F_VALIDCH1    V_VALIDCH1(1U)

#define S_DATACH1    16
#define M_DATACH1    0xffU
#define V_DATACH1(x) ((x) << S_DATACH1)
#define G_DATACH1(x) (((x) >> S_DATACH1) & M_DATACH1)

#define S_SOPCH0    15
#define V_SOPCH0(x) ((x) << S_SOPCH0)
#define F_SOPCH0    V_SOPCH0(1U)

#define S_EOPCH0    14
#define V_EOPCH0(x) ((x) << S_EOPCH0)
#define F_EOPCH0    V_EOPCH0(1U)

#define S_SIZECH0    11
#define M_SIZECH0    0x7U
#define V_SIZECH0(x) ((x) << S_SIZECH0)
#define G_SIZECH0(x) (((x) >> S_SIZECH0) & M_SIZECH0)

#define S_ERRCH0    10
#define V_ERRCH0(x) ((x) << S_ERRCH0)
#define F_ERRCH0    V_ERRCH0(1U)

#define S_FULLCH0    9
#define V_FULLCH0(x) ((x) << S_FULLCH0)
#define F_FULLCH0    V_FULLCH0(1U)

#define S_VALIDCH0    8
#define V_VALIDCH0(x) ((x) << S_VALIDCH0)
#define F_VALIDCH0    V_VALIDCH0(1U)

#define S_DATACH0    0
#define M_DATACH0    0xffU
#define V_DATACH0(x) ((x) << S_DATACH0)
#define G_DATACH0(x) (((x) >> S_DATACH0) & M_DATACH0)

#define A_MPS_TX_DEBUG_REG_TP2TX_32 0x9448

#define S_SOPCH3    31
#define V_SOPCH3(x) ((x) << S_SOPCH3)
#define F_SOPCH3    V_SOPCH3(1U)

#define S_EOPCH3    30
#define V_EOPCH3(x) ((x) << S_EOPCH3)
#define F_EOPCH3    V_EOPCH3(1U)

#define S_SIZECH3    27
#define M_SIZECH3    0x7U
#define V_SIZECH3(x) ((x) << S_SIZECH3)
#define G_SIZECH3(x) (((x) >> S_SIZECH3) & M_SIZECH3)

#define S_ERRCH3    26
#define V_ERRCH3(x) ((x) << S_ERRCH3)
#define F_ERRCH3    V_ERRCH3(1U)

#define S_FULLCH3    25
#define V_FULLCH3(x) ((x) << S_FULLCH3)
#define F_FULLCH3    V_FULLCH3(1U)

#define S_VALIDCH3    24
#define V_VALIDCH3(x) ((x) << S_VALIDCH3)
#define F_VALIDCH3    V_VALIDCH3(1U)

#define S_DATACH3    16
#define M_DATACH3    0xffU
#define V_DATACH3(x) ((x) << S_DATACH3)
#define G_DATACH3(x) (((x) >> S_DATACH3) & M_DATACH3)

#define S_SOPCH2    15
#define V_SOPCH2(x) ((x) << S_SOPCH2)
#define F_SOPCH2    V_SOPCH2(1U)

#define S_EOPCH2    14
#define V_EOPCH2(x) ((x) << S_EOPCH2)
#define F_EOPCH2    V_EOPCH2(1U)

#define S_SIZECH2    11
#define M_SIZECH2    0x7U
#define V_SIZECH2(x) ((x) << S_SIZECH2)
#define G_SIZECH2(x) (((x) >> S_SIZECH2) & M_SIZECH2)

#define S_ERRCH2    10
#define V_ERRCH2(x) ((x) << S_ERRCH2)
#define F_ERRCH2    V_ERRCH2(1U)

#define S_FULLCH2    9
#define V_FULLCH2(x) ((x) << S_FULLCH2)
#define F_FULLCH2    V_FULLCH2(1U)

#define S_VALIDCH2    8
#define V_VALIDCH2(x) ((x) << S_VALIDCH2)
#define F_VALIDCH2    V_VALIDCH2(1U)

#define S_DATACH2    0
#define M_DATACH2    0xffU
#define V_DATACH2(x) ((x) << S_DATACH2)
#define G_DATACH2(x) (((x) >> S_DATACH2) & M_DATACH2)

#define A_MPS_TX_DEBUG_REG_TX2MAC_10 0x944c

#define S_SOPPT1    31
#define V_SOPPT1(x) ((x) << S_SOPPT1)
#define F_SOPPT1    V_SOPPT1(1U)

#define S_EOPPT1    30
#define V_EOPPT1(x) ((x) << S_EOPPT1)
#define F_EOPPT1    V_EOPPT1(1U)

#define S_SIZEPT1    27
#define M_SIZEPT1    0x7U
#define V_SIZEPT1(x) ((x) << S_SIZEPT1)
#define G_SIZEPT1(x) (((x) >> S_SIZEPT1) & M_SIZEPT1)

#define S_ERRPT1    26
#define V_ERRPT1(x) ((x) << S_ERRPT1)
#define F_ERRPT1    V_ERRPT1(1U)

#define S_FULLPT1    25
#define V_FULLPT1(x) ((x) << S_FULLPT1)
#define F_FULLPT1    V_FULLPT1(1U)

#define S_VALIDPT1    24
#define V_VALIDPT1(x) ((x) << S_VALIDPT1)
#define F_VALIDPT1    V_VALIDPT1(1U)

#define S_DATAPT1    16
#define M_DATAPT1    0xffU
#define V_DATAPT1(x) ((x) << S_DATAPT1)
#define G_DATAPT1(x) (((x) >> S_DATAPT1) & M_DATAPT1)

#define S_SOPPT0    15
#define V_SOPPT0(x) ((x) << S_SOPPT0)
#define F_SOPPT0    V_SOPPT0(1U)

#define S_EOPPT0    14
#define V_EOPPT0(x) ((x) << S_EOPPT0)
#define F_EOPPT0    V_EOPPT0(1U)

#define S_SIZEPT0    11
#define M_SIZEPT0    0x7U
#define V_SIZEPT0(x) ((x) << S_SIZEPT0)
#define G_SIZEPT0(x) (((x) >> S_SIZEPT0) & M_SIZEPT0)

#define S_ERRPT0    10
#define V_ERRPT0(x) ((x) << S_ERRPT0)
#define F_ERRPT0    V_ERRPT0(1U)

#define S_FULLPT0    9
#define V_FULLPT0(x) ((x) << S_FULLPT0)
#define F_FULLPT0    V_FULLPT0(1U)

#define S_VALIDPT0    8
#define V_VALIDPT0(x) ((x) << S_VALIDPT0)
#define F_VALIDPT0    V_VALIDPT0(1U)

#define S_DATAPT0    0
#define M_DATAPT0    0xffU
#define V_DATAPT0(x) ((x) << S_DATAPT0)
#define G_DATAPT0(x) (((x) >> S_DATAPT0) & M_DATAPT0)

#define A_MPS_TX_DEBUG_REG_TX2MAC_32 0x9450

#define S_SOPPT3    31
#define V_SOPPT3(x) ((x) << S_SOPPT3)
#define F_SOPPT3    V_SOPPT3(1U)

#define S_EOPPT3    30
#define V_EOPPT3(x) ((x) << S_EOPPT3)
#define F_EOPPT3    V_EOPPT3(1U)

#define S_SIZEPT3    27
#define M_SIZEPT3    0x7U
#define V_SIZEPT3(x) ((x) << S_SIZEPT3)
#define G_SIZEPT3(x) (((x) >> S_SIZEPT3) & M_SIZEPT3)

#define S_ERRPT3    26
#define V_ERRPT3(x) ((x) << S_ERRPT3)
#define F_ERRPT3    V_ERRPT3(1U)

#define S_FULLPT3    25
#define V_FULLPT3(x) ((x) << S_FULLPT3)
#define F_FULLPT3    V_FULLPT3(1U)

#define S_VALIDPT3    24
#define V_VALIDPT3(x) ((x) << S_VALIDPT3)
#define F_VALIDPT3    V_VALIDPT3(1U)

#define S_DATAPT3    16
#define M_DATAPT3    0xffU
#define V_DATAPT3(x) ((x) << S_DATAPT3)
#define G_DATAPT3(x) (((x) >> S_DATAPT3) & M_DATAPT3)

#define S_SOPPT2    15
#define V_SOPPT2(x) ((x) << S_SOPPT2)
#define F_SOPPT2    V_SOPPT2(1U)

#define S_EOPPT2    14
#define V_EOPPT2(x) ((x) << S_EOPPT2)
#define F_EOPPT2    V_EOPPT2(1U)

#define S_SIZEPT2    11
#define M_SIZEPT2    0x7U
#define V_SIZEPT2(x) ((x) << S_SIZEPT2)
#define G_SIZEPT2(x) (((x) >> S_SIZEPT2) & M_SIZEPT2)

#define S_ERRPT2    10
#define V_ERRPT2(x) ((x) << S_ERRPT2)
#define F_ERRPT2    V_ERRPT2(1U)

#define S_FULLPT2    9
#define V_FULLPT2(x) ((x) << S_FULLPT2)
#define F_FULLPT2    V_FULLPT2(1U)

#define S_VALIDPT2    8
#define V_VALIDPT2(x) ((x) << S_VALIDPT2)
#define F_VALIDPT2    V_VALIDPT2(1U)

#define S_DATAPT2    0
#define M_DATAPT2    0xffU
#define V_DATAPT2(x) ((x) << S_DATAPT2)
#define G_DATAPT2(x) (((x) >> S_DATAPT2) & M_DATAPT2)

#define A_MPS_TX_SGE_CH_PAUSE_IGNR 0x9454

#define S_SGEPAUSEIGNR    0
#define M_SGEPAUSEIGNR    0xfU
#define V_SGEPAUSEIGNR(x) ((x) << S_SGEPAUSEIGNR)
#define G_SGEPAUSEIGNR(x) (((x) >> S_SGEPAUSEIGNR) & M_SGEPAUSEIGNR)

#define A_MPS_T5_TX_SGE_CH_PAUSE_IGNR 0x9454

#define S_T5SGEPAUSEIGNR    0
#define M_T5SGEPAUSEIGNR    0xffffU
#define V_T5SGEPAUSEIGNR(x) ((x) << S_T5SGEPAUSEIGNR)
#define G_T5SGEPAUSEIGNR(x) (((x) >> S_T5SGEPAUSEIGNR) & M_T5SGEPAUSEIGNR)

#define A_MPS_TX_DEBUG_SUBPART_SEL 0x9458

#define S_SUBPRTH    11
#define M_SUBPRTH    0x1fU
#define V_SUBPRTH(x) ((x) << S_SUBPRTH)
#define G_SUBPRTH(x) (((x) >> S_SUBPRTH) & M_SUBPRTH)

#define S_PORTH    8
#define M_PORTH    0x7U
#define V_PORTH(x) ((x) << S_PORTH)
#define G_PORTH(x) (((x) >> S_PORTH) & M_PORTH)

#define S_SUBPRTL    3
#define M_SUBPRTL    0x1fU
#define V_SUBPRTL(x) ((x) << S_SUBPRTL)
#define G_SUBPRTL(x) (((x) >> S_SUBPRTL) & M_SUBPRTL)

#define S_PORTL    0
#define M_PORTL    0x7U
#define V_PORTL(x) ((x) << S_PORTL)
#define G_PORTL(x) (((x) >> S_PORTL) & M_PORTL)

#define A_MPS_TX_PAD_CTL 0x945c

#define S_LPBKPADENPT3    7
#define V_LPBKPADENPT3(x) ((x) << S_LPBKPADENPT3)
#define F_LPBKPADENPT3    V_LPBKPADENPT3(1U)

#define S_LPBKPADENPT2    6
#define V_LPBKPADENPT2(x) ((x) << S_LPBKPADENPT2)
#define F_LPBKPADENPT2    V_LPBKPADENPT2(1U)

#define S_LPBKPADENPT1    5
#define V_LPBKPADENPT1(x) ((x) << S_LPBKPADENPT1)
#define F_LPBKPADENPT1    V_LPBKPADENPT1(1U)

#define S_LPBKPADENPT0    4
#define V_LPBKPADENPT0(x) ((x) << S_LPBKPADENPT0)
#define F_LPBKPADENPT0    V_LPBKPADENPT0(1U)

#define S_MACPADENPT3    3
#define V_MACPADENPT3(x) ((x) << S_MACPADENPT3)
#define F_MACPADENPT3    V_MACPADENPT3(1U)

#define S_MACPADENPT2    2
#define V_MACPADENPT2(x) ((x) << S_MACPADENPT2)
#define F_MACPADENPT2    V_MACPADENPT2(1U)

#define S_MACPADENPT1    1
#define V_MACPADENPT1(x) ((x) << S_MACPADENPT1)
#define F_MACPADENPT1    V_MACPADENPT1(1U)

#define S_MACPADENPT0    0
#define V_MACPADENPT0(x) ((x) << S_MACPADENPT0)
#define F_MACPADENPT0    V_MACPADENPT0(1U)

#define A_MPS_TX_PFVF_PORT_DROP_TP 0x9460

#define S_TP2MPS_CH3    24
#define M_TP2MPS_CH3    0xffU
#define V_TP2MPS_CH3(x) ((x) << S_TP2MPS_CH3)
#define G_TP2MPS_CH3(x) (((x) >> S_TP2MPS_CH3) & M_TP2MPS_CH3)

#define S_TP2MPS_CH2    16
#define M_TP2MPS_CH2    0xffU
#define V_TP2MPS_CH2(x) ((x) << S_TP2MPS_CH2)
#define G_TP2MPS_CH2(x) (((x) >> S_TP2MPS_CH2) & M_TP2MPS_CH2)

#define S_TP2MPS_CH1    8
#define M_TP2MPS_CH1    0xffU
#define V_TP2MPS_CH1(x) ((x) << S_TP2MPS_CH1)
#define G_TP2MPS_CH1(x) (((x) >> S_TP2MPS_CH1) & M_TP2MPS_CH1)

#define S_TP2MPS_CH0    0
#define M_TP2MPS_CH0    0xffU
#define V_TP2MPS_CH0(x) ((x) << S_TP2MPS_CH0)
#define G_TP2MPS_CH0(x) (((x) >> S_TP2MPS_CH0) & M_TP2MPS_CH0)

#define A_MPS_TX_PFVF_PORT_DROP_NCSI 0x9464

#define S_NCSI_CH4    0
#define M_NCSI_CH4    0xffU
#define V_NCSI_CH4(x) ((x) << S_NCSI_CH4)
#define G_NCSI_CH4(x) (((x) >> S_NCSI_CH4) & M_NCSI_CH4)

#define A_MPS_TX_PFVF_PORT_DROP_CTL 0x9468

#define S_PFNOVFDROP    5
#define V_PFNOVFDROP(x) ((x) << S_PFNOVFDROP)
#define F_PFNOVFDROP    V_PFNOVFDROP(1U)

#define S_NCSI_CH4_CLR    4
#define V_NCSI_CH4_CLR(x) ((x) << S_NCSI_CH4_CLR)
#define F_NCSI_CH4_CLR    V_NCSI_CH4_CLR(1U)

#define S_TP2MPS_CH3_CLR    3
#define V_TP2MPS_CH3_CLR(x) ((x) << S_TP2MPS_CH3_CLR)
#define F_TP2MPS_CH3_CLR    V_TP2MPS_CH3_CLR(1U)

#define S_TP2MPS_CH2_CLR    2
#define V_TP2MPS_CH2_CLR(x) ((x) << S_TP2MPS_CH2_CLR)
#define F_TP2MPS_CH2_CLR    V_TP2MPS_CH2_CLR(1U)

#define S_TP2MPS_CH1_CLR    1
#define V_TP2MPS_CH1_CLR(x) ((x) << S_TP2MPS_CH1_CLR)
#define F_TP2MPS_CH1_CLR    V_TP2MPS_CH1_CLR(1U)

#define S_TP2MPS_CH0_CLR    0
#define V_TP2MPS_CH0_CLR(x) ((x) << S_TP2MPS_CH0_CLR)
#define F_TP2MPS_CH0_CLR    V_TP2MPS_CH0_CLR(1U)

#define A_MPS_TX_CGEN 0x946c

#define S_TXOUTLPBK3_CGEN    31
#define V_TXOUTLPBK3_CGEN(x) ((x) << S_TXOUTLPBK3_CGEN)
#define F_TXOUTLPBK3_CGEN    V_TXOUTLPBK3_CGEN(1U)

#define S_TXOUTLPBK2_CGEN    30
#define V_TXOUTLPBK2_CGEN(x) ((x) << S_TXOUTLPBK2_CGEN)
#define F_TXOUTLPBK2_CGEN    V_TXOUTLPBK2_CGEN(1U)

#define S_TXOUTLPBK1_CGEN    29
#define V_TXOUTLPBK1_CGEN(x) ((x) << S_TXOUTLPBK1_CGEN)
#define F_TXOUTLPBK1_CGEN    V_TXOUTLPBK1_CGEN(1U)

#define S_TXOUTLPBK0_CGEN    28
#define V_TXOUTLPBK0_CGEN(x) ((x) << S_TXOUTLPBK0_CGEN)
#define F_TXOUTLPBK0_CGEN    V_TXOUTLPBK0_CGEN(1U)

#define S_TXOUTMAC3_CGEN    27
#define V_TXOUTMAC3_CGEN(x) ((x) << S_TXOUTMAC3_CGEN)
#define F_TXOUTMAC3_CGEN    V_TXOUTMAC3_CGEN(1U)

#define S_TXOUTMAC2_CGEN    26
#define V_TXOUTMAC2_CGEN(x) ((x) << S_TXOUTMAC2_CGEN)
#define F_TXOUTMAC2_CGEN    V_TXOUTMAC2_CGEN(1U)

#define S_TXOUTMAC1_CGEN    25
#define V_TXOUTMAC1_CGEN(x) ((x) << S_TXOUTMAC1_CGEN)
#define F_TXOUTMAC1_CGEN    V_TXOUTMAC1_CGEN(1U)

#define S_TXOUTMAC0_CGEN    24
#define V_TXOUTMAC0_CGEN(x) ((x) << S_TXOUTMAC0_CGEN)
#define F_TXOUTMAC0_CGEN    V_TXOUTMAC0_CGEN(1U)

#define S_TXSCHLPBK3_CGEN    23
#define V_TXSCHLPBK3_CGEN(x) ((x) << S_TXSCHLPBK3_CGEN)
#define F_TXSCHLPBK3_CGEN    V_TXSCHLPBK3_CGEN(1U)

#define S_TXSCHLPBK2_CGEN    22
#define V_TXSCHLPBK2_CGEN(x) ((x) << S_TXSCHLPBK2_CGEN)
#define F_TXSCHLPBK2_CGEN    V_TXSCHLPBK2_CGEN(1U)

#define S_TXSCHLPBK1_CGEN    21
#define V_TXSCHLPBK1_CGEN(x) ((x) << S_TXSCHLPBK1_CGEN)
#define F_TXSCHLPBK1_CGEN    V_TXSCHLPBK1_CGEN(1U)

#define S_TXSCHLPBK0_CGEN    20
#define V_TXSCHLPBK0_CGEN(x) ((x) << S_TXSCHLPBK0_CGEN)
#define F_TXSCHLPBK0_CGEN    V_TXSCHLPBK0_CGEN(1U)

#define S_TXSCHMAC3_CGEN    19
#define V_TXSCHMAC3_CGEN(x) ((x) << S_TXSCHMAC3_CGEN)
#define F_TXSCHMAC3_CGEN    V_TXSCHMAC3_CGEN(1U)

#define S_TXSCHMAC2_CGEN    18
#define V_TXSCHMAC2_CGEN(x) ((x) << S_TXSCHMAC2_CGEN)
#define F_TXSCHMAC2_CGEN    V_TXSCHMAC2_CGEN(1U)

#define S_TXSCHMAC1_CGEN    17
#define V_TXSCHMAC1_CGEN(x) ((x) << S_TXSCHMAC1_CGEN)
#define F_TXSCHMAC1_CGEN    V_TXSCHMAC1_CGEN(1U)

#define S_TXSCHMAC0_CGEN    16
#define V_TXSCHMAC0_CGEN(x) ((x) << S_TXSCHMAC0_CGEN)
#define F_TXSCHMAC0_CGEN    V_TXSCHMAC0_CGEN(1U)

#define S_TXINCH4_CGEN    15
#define V_TXINCH4_CGEN(x) ((x) << S_TXINCH4_CGEN)
#define F_TXINCH4_CGEN    V_TXINCH4_CGEN(1U)

#define S_TXINCH3_CGEN    14
#define V_TXINCH3_CGEN(x) ((x) << S_TXINCH3_CGEN)
#define F_TXINCH3_CGEN    V_TXINCH3_CGEN(1U)

#define S_TXINCH2_CGEN    13
#define V_TXINCH2_CGEN(x) ((x) << S_TXINCH2_CGEN)
#define F_TXINCH2_CGEN    V_TXINCH2_CGEN(1U)

#define S_TXINCH1_CGEN    12
#define V_TXINCH1_CGEN(x) ((x) << S_TXINCH1_CGEN)
#define F_TXINCH1_CGEN    V_TXINCH1_CGEN(1U)

#define S_TXINCH0_CGEN    11
#define V_TXINCH0_CGEN(x) ((x) << S_TXINCH0_CGEN)
#define F_TXINCH0_CGEN    V_TXINCH0_CGEN(1U)

#define A_MPS_TX_CGEN_DYNAMIC 0x9470
#define A_MPS_STAT_CTL 0x9600

#define S_COUNTVFINPF    1
#define V_COUNTVFINPF(x) ((x) << S_COUNTVFINPF)
#define F_COUNTVFINPF    V_COUNTVFINPF(1U)

#define S_LPBKERRSTAT    0
#define V_LPBKERRSTAT(x) ((x) << S_LPBKERRSTAT)
#define F_LPBKERRSTAT    V_LPBKERRSTAT(1U)

#define S_STATSTOPCTRL    10
#define V_STATSTOPCTRL(x) ((x) << S_STATSTOPCTRL)
#define F_STATSTOPCTRL    V_STATSTOPCTRL(1U)

#define S_STOPSTAT    9
#define V_STOPSTAT(x) ((x) << S_STOPSTAT)
#define F_STOPSTAT    V_STOPSTAT(1U)

#define S_STATWRITECTRL    8
#define V_STATWRITECTRL(x) ((x) << S_STATWRITECTRL)
#define F_STATWRITECTRL    V_STATWRITECTRL(1U)

#define S_COUNTLBPF    7
#define V_COUNTLBPF(x) ((x) << S_COUNTLBPF)
#define F_COUNTLBPF    V_COUNTLBPF(1U)

#define S_COUNTLBVF    6
#define V_COUNTLBVF(x) ((x) << S_COUNTLBVF)
#define F_COUNTLBVF    V_COUNTLBVF(1U)

#define S_COUNTPAUSEMCRX    5
#define V_COUNTPAUSEMCRX(x) ((x) << S_COUNTPAUSEMCRX)
#define F_COUNTPAUSEMCRX    V_COUNTPAUSEMCRX(1U)

#define S_COUNTPAUSESTATRX    4
#define V_COUNTPAUSESTATRX(x) ((x) << S_COUNTPAUSESTATRX)
#define F_COUNTPAUSESTATRX    V_COUNTPAUSESTATRX(1U)

#define S_COUNTPAUSEMCTX    3
#define V_COUNTPAUSEMCTX(x) ((x) << S_COUNTPAUSEMCTX)
#define F_COUNTPAUSEMCTX    V_COUNTPAUSEMCTX(1U)

#define S_COUNTPAUSESTATTX    2
#define V_COUNTPAUSESTATTX(x) ((x) << S_COUNTPAUSESTATTX)
#define F_COUNTPAUSESTATTX    V_COUNTPAUSESTATTX(1U)

#define A_MPS_STAT_INT_ENABLE 0x9608

#define S_PLREADSYNCERR    0
#define V_PLREADSYNCERR(x) ((x) << S_PLREADSYNCERR)
#define F_PLREADSYNCERR    V_PLREADSYNCERR(1U)

#define A_MPS_STAT_INT_CAUSE 0x960c
#define A_MPS_STAT_PERR_INT_ENABLE_SRAM 0x9610

#define S_RXBG    20
#define V_RXBG(x) ((x) << S_RXBG)
#define F_RXBG    V_RXBG(1U)

#define S_RXVF    18
#define M_RXVF    0x3U
#define V_RXVF(x) ((x) << S_RXVF)
#define G_RXVF(x) (((x) >> S_RXVF) & M_RXVF)

#define S_TXVF    16
#define M_TXVF    0x3U
#define V_TXVF(x) ((x) << S_TXVF)
#define G_TXVF(x) (((x) >> S_TXVF) & M_TXVF)

#define S_RXPF    13
#define M_RXPF    0x7U
#define V_RXPF(x) ((x) << S_RXPF)
#define G_RXPF(x) (((x) >> S_RXPF) & M_RXPF)

#define S_TXPF    11
#define M_TXPF    0x3U
#define V_TXPF(x) ((x) << S_TXPF)
#define G_TXPF(x) (((x) >> S_TXPF) & M_TXPF)

#define S_RXPORT    7
#define M_RXPORT    0xfU
#define V_RXPORT(x) ((x) << S_RXPORT)
#define G_RXPORT(x) (((x) >> S_RXPORT) & M_RXPORT)

#define S_LBPORT    4
#define M_LBPORT    0x7U
#define V_LBPORT(x) ((x) << S_LBPORT)
#define G_LBPORT(x) (((x) >> S_LBPORT) & M_LBPORT)

#define S_TXPORT    0
#define M_TXPORT    0xfU
#define V_TXPORT(x) ((x) << S_TXPORT)
#define G_TXPORT(x) (((x) >> S_TXPORT) & M_TXPORT)

#define S_T5_RXBG    27
#define M_T5_RXBG    0x3U
#define V_T5_RXBG(x) ((x) << S_T5_RXBG)
#define G_T5_RXBG(x) (((x) >> S_T5_RXBG) & M_T5_RXBG)

#define S_T5_RXPF    22
#define M_T5_RXPF    0x1fU
#define V_T5_RXPF(x) ((x) << S_T5_RXPF)
#define G_T5_RXPF(x) (((x) >> S_T5_RXPF) & M_T5_RXPF)

#define S_T5_TXPF    18
#define M_T5_TXPF    0xfU
#define V_T5_TXPF(x) ((x) << S_T5_TXPF)
#define G_T5_TXPF(x) (((x) >> S_T5_TXPF) & M_T5_TXPF)

#define S_T5_RXPORT    11
#define M_T5_RXPORT    0x7fU
#define V_T5_RXPORT(x) ((x) << S_T5_RXPORT)
#define G_T5_RXPORT(x) (((x) >> S_T5_RXPORT) & M_T5_RXPORT)

#define S_T5_LBPORT    6
#define M_T5_LBPORT    0x1fU
#define V_T5_LBPORT(x) ((x) << S_T5_LBPORT)
#define G_T5_LBPORT(x) (((x) >> S_T5_LBPORT) & M_T5_LBPORT)

#define S_T5_TXPORT    0
#define M_T5_TXPORT    0x3fU
#define V_T5_TXPORT(x) ((x) << S_T5_TXPORT)
#define G_T5_TXPORT(x) (((x) >> S_T5_TXPORT) & M_T5_TXPORT)

#define A_MPS_STAT_PERR_INT_CAUSE_SRAM 0x9614
#define A_MPS_STAT_PERR_ENABLE_SRAM 0x9618
#define A_MPS_STAT_PERR_INT_ENABLE_TX_FIFO 0x961c

#define S_TX    12
#define M_TX    0xffU
#define V_TX(x) ((x) << S_TX)
#define G_TX(x) (((x) >> S_TX) & M_TX)

#define S_TXPAUSEFIFO    8
#define M_TXPAUSEFIFO    0xfU
#define V_TXPAUSEFIFO(x) ((x) << S_TXPAUSEFIFO)
#define G_TXPAUSEFIFO(x) (((x) >> S_TXPAUSEFIFO) & M_TXPAUSEFIFO)

#define S_DROP    0
#define M_DROP    0xffU
#define V_DROP(x) ((x) << S_DROP)
#define G_DROP(x) (((x) >> S_DROP) & M_DROP)

#define S_TXCH    20
#define M_TXCH    0xfU
#define V_TXCH(x) ((x) << S_TXCH)
#define G_TXCH(x) (((x) >> S_TXCH) & M_TXCH)

#define A_MPS_STAT_PERR_INT_CAUSE_TX_FIFO 0x9620
#define A_MPS_STAT_PERR_ENABLE_TX_FIFO 0x9624
#define A_MPS_STAT_PERR_INT_ENABLE_RX_FIFO 0x9628

#define S_PAUSEFIFO    20
#define M_PAUSEFIFO    0xfU
#define V_PAUSEFIFO(x) ((x) << S_PAUSEFIFO)
#define G_PAUSEFIFO(x) (((x) >> S_PAUSEFIFO) & M_PAUSEFIFO)

#define S_LPBK    16
#define M_LPBK    0xfU
#define V_LPBK(x) ((x) << S_LPBK)
#define G_LPBK(x) (((x) >> S_LPBK) & M_LPBK)

#define S_NQ    8
#define M_NQ    0xffU
#define V_NQ(x) ((x) << S_NQ)
#define G_NQ(x) (((x) >> S_NQ) & M_NQ)

#define S_PV    4
#define M_PV    0xfU
#define V_PV(x) ((x) << S_PV)
#define G_PV(x) (((x) >> S_PV) & M_PV)

#define S_MAC    0
#define M_MAC    0xfU
#define V_MAC(x) ((x) << S_MAC)
#define G_MAC(x) (((x) >> S_MAC) & M_MAC)

#define A_MPS_STAT_PERR_INT_CAUSE_RX_FIFO 0x962c
#define A_MPS_STAT_PERR_ENABLE_RX_FIFO 0x9630
#define A_MPS_STAT_PERR_INJECT 0x9634

#define S_STATMEMSEL    1
#define M_STATMEMSEL    0x7fU
#define V_STATMEMSEL(x) ((x) << S_STATMEMSEL)
#define G_STATMEMSEL(x) (((x) >> S_STATMEMSEL) & M_STATMEMSEL)

#define A_MPS_STAT_DEBUG_SUB_SEL 0x9638

#define S_STATSSUBPRTH    5
#define M_STATSSUBPRTH    0x1fU
#define V_STATSSUBPRTH(x) ((x) << S_STATSSUBPRTH)
#define G_STATSSUBPRTH(x) (((x) >> S_STATSSUBPRTH) & M_STATSSUBPRTH)

#define S_STATSSUBPRTL    0
#define M_STATSSUBPRTL    0x1fU
#define V_STATSSUBPRTL(x) ((x) << S_STATSSUBPRTL)
#define G_STATSSUBPRTL(x) (((x) >> S_STATSSUBPRTL) & M_STATSSUBPRTL)

#define S_STATSUBPRTH    5
#define M_STATSUBPRTH    0x1fU
#define V_STATSUBPRTH(x) ((x) << S_STATSUBPRTH)
#define G_STATSUBPRTH(x) (((x) >> S_STATSUBPRTH) & M_STATSUBPRTH)

#define A_MPS_STAT_RX_BG_0_MAC_DROP_FRAME_L 0x9640
#define A_MPS_STAT_RX_BG_0_MAC_DROP_FRAME_H 0x9644
#define A_MPS_STAT_RX_BG_1_MAC_DROP_FRAME_L 0x9648
#define A_MPS_STAT_RX_BG_1_MAC_DROP_FRAME_H 0x964c
#define A_MPS_STAT_RX_BG_2_MAC_DROP_FRAME_L 0x9650
#define A_MPS_STAT_RX_BG_2_MAC_DROP_FRAME_H 0x9654
#define A_MPS_STAT_RX_BG_3_MAC_DROP_FRAME_L 0x9658
#define A_MPS_STAT_RX_BG_3_MAC_DROP_FRAME_H 0x965c
#define A_MPS_STAT_RX_BG_0_LB_DROP_FRAME_L 0x9660
#define A_MPS_STAT_RX_BG_0_LB_DROP_FRAME_H 0x9664
#define A_MPS_STAT_RX_BG_1_LB_DROP_FRAME_L 0x9668
#define A_MPS_STAT_RX_BG_1_LB_DROP_FRAME_H 0x966c
#define A_MPS_STAT_RX_BG_2_LB_DROP_FRAME_L 0x9670
#define A_MPS_STAT_RX_BG_2_LB_DROP_FRAME_H 0x9674
#define A_MPS_STAT_RX_BG_3_LB_DROP_FRAME_L 0x9678
#define A_MPS_STAT_RX_BG_3_LB_DROP_FRAME_H 0x967c
#define A_MPS_STAT_RX_BG_0_MAC_TRUNC_FRAME_L 0x9680
#define A_MPS_STAT_RX_BG_0_MAC_TRUNC_FRAME_H 0x9684
#define A_MPS_STAT_RX_BG_1_MAC_TRUNC_FRAME_L 0x9688
#define A_MPS_STAT_RX_BG_1_MAC_TRUNC_FRAME_H 0x968c
#define A_MPS_STAT_RX_BG_2_MAC_TRUNC_FRAME_L 0x9690
#define A_MPS_STAT_RX_BG_2_MAC_TRUNC_FRAME_H 0x9694
#define A_MPS_STAT_RX_BG_3_MAC_TRUNC_FRAME_L 0x9698
#define A_MPS_STAT_RX_BG_3_MAC_TRUNC_FRAME_H 0x969c
#define A_MPS_STAT_RX_BG_0_LB_TRUNC_FRAME_L 0x96a0
#define A_MPS_STAT_RX_BG_0_LB_TRUNC_FRAME_H 0x96a4
#define A_MPS_STAT_RX_BG_1_LB_TRUNC_FRAME_L 0x96a8
#define A_MPS_STAT_RX_BG_1_LB_TRUNC_FRAME_H 0x96ac
#define A_MPS_STAT_RX_BG_2_LB_TRUNC_FRAME_L 0x96b0
#define A_MPS_STAT_RX_BG_2_LB_TRUNC_FRAME_H 0x96b4
#define A_MPS_STAT_RX_BG_3_LB_TRUNC_FRAME_L 0x96b8
#define A_MPS_STAT_RX_BG_3_LB_TRUNC_FRAME_H 0x96bc
#define A_MPS_STAT_PERR_INT_ENABLE_SRAM1 0x96c0

#define S_T5_RXVF    5
#define M_T5_RXVF    0x7U
#define V_T5_RXVF(x) ((x) << S_T5_RXVF)
#define G_T5_RXVF(x) (((x) >> S_T5_RXVF) & M_T5_RXVF)

#define S_T5_TXVF    0
#define M_T5_TXVF    0x1fU
#define V_T5_TXVF(x) ((x) << S_T5_TXVF)
#define G_T5_TXVF(x) (((x) >> S_T5_TXVF) & M_T5_TXVF)

#define A_MPS_STAT_PERR_INT_CAUSE_SRAM1 0x96c4
#define A_MPS_STAT_PERR_ENABLE_SRAM1 0x96c8
#define A_MPS_STAT_STOP_UPD_BG 0x96cc

#define S_BGRX    0
#define M_BGRX    0xfU
#define V_BGRX(x) ((x) << S_BGRX)
#define G_BGRX(x) (((x) >> S_BGRX) & M_BGRX)

#define A_MPS_STAT_STOP_UPD_PORT 0x96d0

#define S_PTLPBK    8
#define M_PTLPBK    0xfU
#define V_PTLPBK(x) ((x) << S_PTLPBK)
#define G_PTLPBK(x) (((x) >> S_PTLPBK) & M_PTLPBK)

#define S_PTTX    4
#define M_PTTX    0xfU
#define V_PTTX(x) ((x) << S_PTTX)
#define G_PTTX(x) (((x) >> S_PTTX) & M_PTTX)

#define S_PTRX    0
#define M_PTRX    0xfU
#define V_PTRX(x) ((x) << S_PTRX)
#define G_PTRX(x) (((x) >> S_PTRX) & M_PTRX)

#define A_MPS_STAT_STOP_UPD_PF 0x96d4

#define S_PFTX    8
#define M_PFTX    0xffU
#define V_PFTX(x) ((x) << S_PFTX)
#define G_PFTX(x) (((x) >> S_PFTX) & M_PFTX)

#define S_PFRX    0
#define M_PFRX    0xffU
#define V_PFRX(x) ((x) << S_PFRX)
#define G_PFRX(x) (((x) >> S_PFRX) & M_PFRX)

#define A_MPS_STAT_STOP_UPD_TX_VF_0_31 0x96d8
#define A_MPS_STAT_STOP_UPD_TX_VF_32_63 0x96dc
#define A_MPS_STAT_STOP_UPD_TX_VF_64_95 0x96e0
#define A_MPS_STAT_STOP_UPD_TX_VF_96_127 0x96e4
#define A_MPS_STAT_STOP_UPD_RX_VF_0_31 0x96e8
#define A_MPS_STAT_STOP_UPD_RX_VF_32_63 0x96ec
#define A_MPS_STAT_STOP_UPD_RX_VF_64_95 0x96f0
#define A_MPS_STAT_STOP_UPD_RX_VF_96_127 0x96f4
#define A_MPS_TRC_CFG 0x9800

#define S_TRCFIFOEMPTY    4
#define V_TRCFIFOEMPTY(x) ((x) << S_TRCFIFOEMPTY)
#define F_TRCFIFOEMPTY    V_TRCFIFOEMPTY(1U)

#define S_TRCIGNOREDROPINPUT    3
#define V_TRCIGNOREDROPINPUT(x) ((x) << S_TRCIGNOREDROPINPUT)
#define F_TRCIGNOREDROPINPUT    V_TRCIGNOREDROPINPUT(1U)

#define S_TRCKEEPDUPLICATES    2
#define V_TRCKEEPDUPLICATES(x) ((x) << S_TRCKEEPDUPLICATES)
#define F_TRCKEEPDUPLICATES    V_TRCKEEPDUPLICATES(1U)

#define S_TRCEN    1
#define V_TRCEN(x) ((x) << S_TRCEN)
#define F_TRCEN    V_TRCEN(1U)

#define S_TRCMULTIFILTER    0
#define V_TRCMULTIFILTER(x) ((x) << S_TRCMULTIFILTER)
#define F_TRCMULTIFILTER    V_TRCMULTIFILTER(1U)

#define S_TRCMULTIRSSFILTER    5
#define V_TRCMULTIRSSFILTER(x) ((x) << S_TRCMULTIRSSFILTER)
#define F_TRCMULTIRSSFILTER    V_TRCMULTIRSSFILTER(1U)

#define A_MPS_TRC_RSS_HASH 0x9804
#define A_MPS_TRC_FILTER0_RSS_HASH 0x9804
#define A_MPS_TRC_RSS_CONTROL 0x9808

#define S_RSSCONTROL    16
#define M_RSSCONTROL    0xffU
#define V_RSSCONTROL(x) ((x) << S_RSSCONTROL)
#define G_RSSCONTROL(x) (((x) >> S_RSSCONTROL) & M_RSSCONTROL)

#define S_QUEUENUMBER    0
#define M_QUEUENUMBER    0xffffU
#define V_QUEUENUMBER(x) ((x) << S_QUEUENUMBER)
#define G_QUEUENUMBER(x) (((x) >> S_QUEUENUMBER) & M_QUEUENUMBER)

#define A_MPS_TRC_FILTER0_RSS_CONTROL 0x9808
#define A_MPS_TRC_FILTER_MATCH_CTL_A 0x9810

#define S_TFINVERTMATCH    24
#define V_TFINVERTMATCH(x) ((x) << S_TFINVERTMATCH)
#define F_TFINVERTMATCH    V_TFINVERTMATCH(1U)

#define S_TFPKTTOOLARGE    23
#define V_TFPKTTOOLARGE(x) ((x) << S_TFPKTTOOLARGE)
#define F_TFPKTTOOLARGE    V_TFPKTTOOLARGE(1U)

#define S_TFEN    22
#define V_TFEN(x) ((x) << S_TFEN)
#define F_TFEN    V_TFEN(1U)

#define S_TFPORT    18
#define M_TFPORT    0xfU
#define V_TFPORT(x) ((x) << S_TFPORT)
#define G_TFPORT(x) (((x) >> S_TFPORT) & M_TFPORT)

#define S_TFDROP    17
#define V_TFDROP(x) ((x) << S_TFDROP)
#define F_TFDROP    V_TFDROP(1U)

#define S_TFSOPEOPERR    16
#define V_TFSOPEOPERR(x) ((x) << S_TFSOPEOPERR)
#define F_TFSOPEOPERR    V_TFSOPEOPERR(1U)

#define S_TFLENGTH    8
#define M_TFLENGTH    0x1fU
#define V_TFLENGTH(x) ((x) << S_TFLENGTH)
#define G_TFLENGTH(x) (((x) >> S_TFLENGTH) & M_TFLENGTH)

#define S_TFOFFSET    0
#define M_TFOFFSET    0x1fU
#define V_TFOFFSET(x) ((x) << S_TFOFFSET)
#define G_TFOFFSET(x) (((x) >> S_TFOFFSET) & M_TFOFFSET)

#define S_TFINSERTACTLEN    27
#define V_TFINSERTACTLEN(x) ((x) << S_TFINSERTACTLEN)
#define F_TFINSERTACTLEN    V_TFINSERTACTLEN(1U)

#define S_TFINSERTTIMER    26
#define V_TFINSERTTIMER(x) ((x) << S_TFINSERTTIMER)
#define F_TFINSERTTIMER    V_TFINSERTTIMER(1U)

#define S_T5_TFINVERTMATCH    25
#define V_T5_TFINVERTMATCH(x) ((x) << S_T5_TFINVERTMATCH)
#define F_T5_TFINVERTMATCH    V_T5_TFINVERTMATCH(1U)

#define S_T5_TFPKTTOOLARGE    24
#define V_T5_TFPKTTOOLARGE(x) ((x) << S_T5_TFPKTTOOLARGE)
#define F_T5_TFPKTTOOLARGE    V_T5_TFPKTTOOLARGE(1U)

#define S_T5_TFEN    23
#define V_T5_TFEN(x) ((x) << S_T5_TFEN)
#define F_T5_TFEN    V_T5_TFEN(1U)

#define S_T5_TFPORT    18
#define M_T5_TFPORT    0x1fU
#define V_T5_TFPORT(x) ((x) << S_T5_TFPORT)
#define G_T5_TFPORT(x) (((x) >> S_T5_TFPORT) & M_T5_TFPORT)

#define A_MPS_TRC_FILTER_MATCH_CTL_B 0x9820

#define S_TFMINPKTSIZE    16
#define M_TFMINPKTSIZE    0x1ffU
#define V_TFMINPKTSIZE(x) ((x) << S_TFMINPKTSIZE)
#define G_TFMINPKTSIZE(x) (((x) >> S_TFMINPKTSIZE) & M_TFMINPKTSIZE)

#define S_TFCAPTUREMAX    0
#define M_TFCAPTUREMAX    0x3fffU
#define V_TFCAPTUREMAX(x) ((x) << S_TFCAPTUREMAX)
#define G_TFCAPTUREMAX(x) (((x) >> S_TFCAPTUREMAX) & M_TFCAPTUREMAX)

#define A_MPS_TRC_FILTER_RUNT_CTL 0x9830

#define S_TFRUNTSIZE    0
#define M_TFRUNTSIZE    0x3fU
#define V_TFRUNTSIZE(x) ((x) << S_TFRUNTSIZE)
#define G_TFRUNTSIZE(x) (((x) >> S_TFRUNTSIZE) & M_TFRUNTSIZE)

#define A_MPS_TRC_FILTER_DROP 0x9840

#define S_TFDROPINPCOUNT    16
#define M_TFDROPINPCOUNT    0xffffU
#define V_TFDROPINPCOUNT(x) ((x) << S_TFDROPINPCOUNT)
#define G_TFDROPINPCOUNT(x) (((x) >> S_TFDROPINPCOUNT) & M_TFDROPINPCOUNT)

#define S_TFDROPBUFFERCOUNT    0
#define M_TFDROPBUFFERCOUNT    0xffffU
#define V_TFDROPBUFFERCOUNT(x) ((x) << S_TFDROPBUFFERCOUNT)
#define G_TFDROPBUFFERCOUNT(x) (((x) >> S_TFDROPBUFFERCOUNT) & M_TFDROPBUFFERCOUNT)

#define A_MPS_TRC_PERR_INJECT 0x9850

#define S_TRCMEMSEL    1
#define M_TRCMEMSEL    0xfU
#define V_TRCMEMSEL(x) ((x) << S_TRCMEMSEL)
#define G_TRCMEMSEL(x) (((x) >> S_TRCMEMSEL) & M_TRCMEMSEL)

#define A_MPS_TRC_PERR_ENABLE 0x9854

#define S_MISCPERR    8
#define V_MISCPERR(x) ((x) << S_MISCPERR)
#define F_MISCPERR    V_MISCPERR(1U)

#define S_PKTFIFO    4
#define M_PKTFIFO    0xfU
#define V_PKTFIFO(x) ((x) << S_PKTFIFO)
#define G_PKTFIFO(x) (((x) >> S_PKTFIFO) & M_PKTFIFO)

#define S_FILTMEM    0
#define M_FILTMEM    0xfU
#define V_FILTMEM(x) ((x) << S_FILTMEM)
#define G_FILTMEM(x) (((x) >> S_FILTMEM) & M_FILTMEM)

#define A_MPS_TRC_INT_ENABLE 0x9858

#define S_TRCPLERRENB    9
#define V_TRCPLERRENB(x) ((x) << S_TRCPLERRENB)
#define F_TRCPLERRENB    V_TRCPLERRENB(1U)

#define A_MPS_TRC_INT_CAUSE 0x985c
#define A_MPS_TRC_TIMESTAMP_L 0x9860
#define A_MPS_TRC_TIMESTAMP_H 0x9864
#define A_MPS_TRC_FILTER0_MATCH 0x9c00
#define A_MPS_TRC_FILTER0_DONT_CARE 0x9c80
#define A_MPS_TRC_FILTER1_MATCH 0x9d00
#define A_MPS_TRC_FILTER1_DONT_CARE 0x9d80
#define A_MPS_TRC_FILTER2_MATCH 0x9e00
#define A_MPS_TRC_FILTER2_DONT_CARE 0x9e80
#define A_MPS_TRC_FILTER3_MATCH 0x9f00
#define A_MPS_TRC_FILTER3_DONT_CARE 0x9f80
#define A_MPS_TRC_FILTER1_RSS_HASH 0x9ff0
#define A_MPS_TRC_FILTER1_RSS_CONTROL 0x9ff4
#define A_MPS_TRC_FILTER2_RSS_HASH 0x9ff8
#define A_MPS_TRC_FILTER2_RSS_CONTROL 0x9ffc
#define A_MPS_TRC_FILTER3_RSS_HASH 0xa000
#define A_MPS_TRC_FILTER3_RSS_CONTROL 0xa004
#define A_MPS_T5_TRC_RSS_HASH 0xa008
#define A_MPS_T5_TRC_RSS_CONTROL 0xa00c
#define A_MPS_TRC_VF_OFF_FILTER_0 0xa010

#define S_TRCMPS2TP_MACONLY    20
#define V_TRCMPS2TP_MACONLY(x) ((x) << S_TRCMPS2TP_MACONLY)
#define F_TRCMPS2TP_MACONLY    V_TRCMPS2TP_MACONLY(1U)

#define S_TRCALLMPS2TP    19
#define V_TRCALLMPS2TP(x) ((x) << S_TRCALLMPS2TP)
#define F_TRCALLMPS2TP    V_TRCALLMPS2TP(1U)

#define S_TRCALLTP2MPS    18
#define V_TRCALLTP2MPS(x) ((x) << S_TRCALLTP2MPS)
#define F_TRCALLTP2MPS    V_TRCALLTP2MPS(1U)

#define S_TRCALLVF    17
#define V_TRCALLVF(x) ((x) << S_TRCALLVF)
#define F_TRCALLVF    V_TRCALLVF(1U)

#define S_TRC_OFLD_EN    16
#define V_TRC_OFLD_EN(x) ((x) << S_TRC_OFLD_EN)
#define F_TRC_OFLD_EN    V_TRC_OFLD_EN(1U)

#define S_VFFILTEN    15
#define V_VFFILTEN(x) ((x) << S_VFFILTEN)
#define F_VFFILTEN    V_VFFILTEN(1U)

#define S_VFFILTMASK    8
#define M_VFFILTMASK    0x7fU
#define V_VFFILTMASK(x) ((x) << S_VFFILTMASK)
#define G_VFFILTMASK(x) (((x) >> S_VFFILTMASK) & M_VFFILTMASK)

#define S_VFFILTVALID    7
#define V_VFFILTVALID(x) ((x) << S_VFFILTVALID)
#define F_VFFILTVALID    V_VFFILTVALID(1U)

#define S_VFFILTDATA    0
#define M_VFFILTDATA    0x7fU
#define V_VFFILTDATA(x) ((x) << S_VFFILTDATA)
#define G_VFFILTDATA(x) (((x) >> S_VFFILTDATA) & M_VFFILTDATA)

#define A_MPS_TRC_VF_OFF_FILTER_1 0xa014
#define A_MPS_TRC_VF_OFF_FILTER_2 0xa018
#define A_MPS_TRC_VF_OFF_FILTER_3 0xa01c
#define A_MPS_TRC_CGEN 0xa020

#define S_MPSTRCCGEN    0
#define M_MPSTRCCGEN    0xfU
#define V_MPSTRCCGEN(x) ((x) << S_MPSTRCCGEN)
#define G_MPSTRCCGEN(x) (((x) >> S_MPSTRCCGEN) & M_MPSTRCCGEN)

#define A_MPS_CLS_CTL 0xd000

#define S_MEMWRITEFAULT    4
#define V_MEMWRITEFAULT(x) ((x) << S_MEMWRITEFAULT)
#define F_MEMWRITEFAULT    V_MEMWRITEFAULT(1U)

#define S_MEMWRITEWAITING    3
#define V_MEMWRITEWAITING(x) ((x) << S_MEMWRITEWAITING)
#define F_MEMWRITEWAITING    V_MEMWRITEWAITING(1U)

#define S_CIMNOPROMISCUOUS    2
#define V_CIMNOPROMISCUOUS(x) ((x) << S_CIMNOPROMISCUOUS)
#define F_CIMNOPROMISCUOUS    V_CIMNOPROMISCUOUS(1U)

#define S_HYPERVISORONLY    1
#define V_HYPERVISORONLY(x) ((x) << S_HYPERVISORONLY)
#define F_HYPERVISORONLY    V_HYPERVISORONLY(1U)

#define S_VLANCLSEN    0
#define V_VLANCLSEN(x) ((x) << S_VLANCLSEN)
#define F_VLANCLSEN    V_VLANCLSEN(1U)

#define A_MPS_CLS_ARB_WEIGHT 0xd004

#define S_PLWEIGHT    16
#define M_PLWEIGHT    0x1fU
#define V_PLWEIGHT(x) ((x) << S_PLWEIGHT)
#define G_PLWEIGHT(x) (((x) >> S_PLWEIGHT) & M_PLWEIGHT)

#define S_CIMWEIGHT    8
#define M_CIMWEIGHT    0x1fU
#define V_CIMWEIGHT(x) ((x) << S_CIMWEIGHT)
#define G_CIMWEIGHT(x) (((x) >> S_CIMWEIGHT) & M_CIMWEIGHT)

#define S_LPBKWEIGHT    0
#define M_LPBKWEIGHT    0x1fU
#define V_LPBKWEIGHT(x) ((x) << S_LPBKWEIGHT)
#define G_LPBKWEIGHT(x) (((x) >> S_LPBKWEIGHT) & M_LPBKWEIGHT)

#define A_MPS_CLS_BMC_MAC_ADDR_L 0xd010
#define A_MPS_CLS_BMC_MAC_ADDR_H 0xd014
#define A_MPS_CLS_BMC_VLAN 0xd018
#define A_MPS_CLS_PERR_INJECT 0xd01c

#define S_CLS_MEMSEL    1
#define M_CLS_MEMSEL    0x3U
#define V_CLS_MEMSEL(x) ((x) << S_CLS_MEMSEL)
#define G_CLS_MEMSEL(x) (((x) >> S_CLS_MEMSEL) & M_CLS_MEMSEL)

#define A_MPS_CLS_PERR_ENABLE 0xd020

#define S_HASHSRAM    2
#define V_HASHSRAM(x) ((x) << S_HASHSRAM)
#define F_HASHSRAM    V_HASHSRAM(1U)

#define S_MATCHTCAM    1
#define V_MATCHTCAM(x) ((x) << S_MATCHTCAM)
#define F_MATCHTCAM    V_MATCHTCAM(1U)

#define S_MATCHSRAM    0
#define V_MATCHSRAM(x) ((x) << S_MATCHSRAM)
#define F_MATCHSRAM    V_MATCHSRAM(1U)

#define A_MPS_CLS_INT_ENABLE 0xd024

#define S_PLERRENB    3
#define V_PLERRENB(x) ((x) << S_PLERRENB)
#define F_PLERRENB    V_PLERRENB(1U)

#define A_MPS_CLS_INT_CAUSE 0xd028
#define A_MPS_CLS_PL_TEST_DATA_L 0xd02c
#define A_MPS_CLS_PL_TEST_DATA_H 0xd030
#define A_MPS_CLS_PL_TEST_RES_DATA 0xd034

#define S_CLS_PRIORITY    24
#define M_CLS_PRIORITY    0x7U
#define V_CLS_PRIORITY(x) ((x) << S_CLS_PRIORITY)
#define G_CLS_PRIORITY(x) (((x) >> S_CLS_PRIORITY) & M_CLS_PRIORITY)

#define S_CLS_REPLICATE    23
#define V_CLS_REPLICATE(x) ((x) << S_CLS_REPLICATE)
#define F_CLS_REPLICATE    V_CLS_REPLICATE(1U)

#define S_CLS_INDEX    14
#define M_CLS_INDEX    0x1ffU
#define V_CLS_INDEX(x) ((x) << S_CLS_INDEX)
#define G_CLS_INDEX(x) (((x) >> S_CLS_INDEX) & M_CLS_INDEX)

#define S_CLS_VF    7
#define M_CLS_VF    0x7fU
#define V_CLS_VF(x) ((x) << S_CLS_VF)
#define G_CLS_VF(x) (((x) >> S_CLS_VF) & M_CLS_VF)

#define S_CLS_VF_VLD    6
#define V_CLS_VF_VLD(x) ((x) << S_CLS_VF_VLD)
#define F_CLS_VF_VLD    V_CLS_VF_VLD(1U)

#define S_CLS_PF    3
#define M_CLS_PF    0x7U
#define V_CLS_PF(x) ((x) << S_CLS_PF)
#define G_CLS_PF(x) (((x) >> S_CLS_PF) & M_CLS_PF)

#define S_CLS_MATCH    0
#define M_CLS_MATCH    0x7U
#define V_CLS_MATCH(x) ((x) << S_CLS_MATCH)
#define G_CLS_MATCH(x) (((x) >> S_CLS_MATCH) & M_CLS_MATCH)

#define A_MPS_CLS_PL_TEST_CTL 0xd038

#define S_PLTESTCTL    0
#define V_PLTESTCTL(x) ((x) << S_PLTESTCTL)
#define F_PLTESTCTL    V_PLTESTCTL(1U)

#define A_MPS_CLS_PORT_BMC_CTL 0xd03c

#define S_PRTBMCCTL    0
#define V_PRTBMCCTL(x) ((x) << S_PRTBMCCTL)
#define F_PRTBMCCTL    V_PRTBMCCTL(1U)

#define A_MPS_CLS_VLAN_TABLE 0xdfc0

#define S_VLAN_MASK    16
#define M_VLAN_MASK    0xfffU
#define V_VLAN_MASK(x) ((x) << S_VLAN_MASK)
#define G_VLAN_MASK(x) (((x) >> S_VLAN_MASK) & M_VLAN_MASK)

#define S_VLANPF    13
#define M_VLANPF    0x7U
#define V_VLANPF(x) ((x) << S_VLANPF)
#define G_VLANPF(x) (((x) >> S_VLANPF) & M_VLANPF)

#define S_VLAN_VALID    12
#define V_VLAN_VALID(x) ((x) << S_VLAN_VALID)
#define F_VLAN_VALID    V_VLAN_VALID(1U)

#define A_MPS_CLS_SRAM_L 0xe000

#define S_MULTILISTEN3    28
#define V_MULTILISTEN3(x) ((x) << S_MULTILISTEN3)
#define F_MULTILISTEN3    V_MULTILISTEN3(1U)

#define S_MULTILISTEN2    27
#define V_MULTILISTEN2(x) ((x) << S_MULTILISTEN2)
#define F_MULTILISTEN2    V_MULTILISTEN2(1U)

#define S_MULTILISTEN1    26
#define V_MULTILISTEN1(x) ((x) << S_MULTILISTEN1)
#define F_MULTILISTEN1    V_MULTILISTEN1(1U)

#define S_MULTILISTEN0    25
#define V_MULTILISTEN0(x) ((x) << S_MULTILISTEN0)
#define F_MULTILISTEN0    V_MULTILISTEN0(1U)

#define S_SRAM_PRIO3    22
#define M_SRAM_PRIO3    0x7U
#define V_SRAM_PRIO3(x) ((x) << S_SRAM_PRIO3)
#define G_SRAM_PRIO3(x) (((x) >> S_SRAM_PRIO3) & M_SRAM_PRIO3)

#define S_SRAM_PRIO2    19
#define M_SRAM_PRIO2    0x7U
#define V_SRAM_PRIO2(x) ((x) << S_SRAM_PRIO2)
#define G_SRAM_PRIO2(x) (((x) >> S_SRAM_PRIO2) & M_SRAM_PRIO2)

#define S_SRAM_PRIO1    16
#define M_SRAM_PRIO1    0x7U
#define V_SRAM_PRIO1(x) ((x) << S_SRAM_PRIO1)
#define G_SRAM_PRIO1(x) (((x) >> S_SRAM_PRIO1) & M_SRAM_PRIO1)

#define S_SRAM_PRIO0    13
#define M_SRAM_PRIO0    0x7U
#define V_SRAM_PRIO0(x) ((x) << S_SRAM_PRIO0)
#define G_SRAM_PRIO0(x) (((x) >> S_SRAM_PRIO0) & M_SRAM_PRIO0)

#define S_SRAM_VLD    12
#define V_SRAM_VLD(x) ((x) << S_SRAM_VLD)
#define F_SRAM_VLD    V_SRAM_VLD(1U)

#define A_MPS_T5_CLS_SRAM_L 0xe000
#define A_MPS_CLS_SRAM_H 0xe004

#define S_MACPARITY1    9
#define V_MACPARITY1(x) ((x) << S_MACPARITY1)
#define F_MACPARITY1    V_MACPARITY1(1U)

#define S_MACPARITY0    8
#define V_MACPARITY0(x) ((x) << S_MACPARITY0)
#define F_MACPARITY0    V_MACPARITY0(1U)

#define S_MACPARITYMASKSIZE    4
#define M_MACPARITYMASKSIZE    0xfU
#define V_MACPARITYMASKSIZE(x) ((x) << S_MACPARITYMASKSIZE)
#define G_MACPARITYMASKSIZE(x) (((x) >> S_MACPARITYMASKSIZE) & M_MACPARITYMASKSIZE)

#define S_PORTMAP    0
#define M_PORTMAP    0xfU
#define V_PORTMAP(x) ((x) << S_PORTMAP)
#define G_PORTMAP(x) (((x) >> S_PORTMAP) & M_PORTMAP)

#define A_MPS_T5_CLS_SRAM_H 0xe004
#define A_MPS_CLS_TCAM_Y_L 0xf000
#define A_MPS_CLS_TCAM_Y_H 0xf004

#define S_TCAMYH    0
#define M_TCAMYH    0xffffU
#define V_TCAMYH(x) ((x) << S_TCAMYH)
#define G_TCAMYH(x) (((x) >> S_TCAMYH) & M_TCAMYH)

#define A_MPS_CLS_TCAM_X_L 0xf008
#define A_MPS_CLS_TCAM_X_H 0xf00c

#define S_TCAMXH    0
#define M_TCAMXH    0xffffU
#define V_TCAMXH(x) ((x) << S_TCAMXH)
#define G_TCAMXH(x) (((x) >> S_TCAMXH) & M_TCAMXH)

#define A_MPS_RX_CTL 0x11000

#define S_FILT_VLAN_SEL    17
#define V_FILT_VLAN_SEL(x) ((x) << S_FILT_VLAN_SEL)
#define F_FILT_VLAN_SEL    V_FILT_VLAN_SEL(1U)

#define S_CBA_EN    16
#define V_CBA_EN(x) ((x) << S_CBA_EN)
#define F_CBA_EN    V_CBA_EN(1U)

#define S_BLK_SNDR    12
#define M_BLK_SNDR    0xfU
#define V_BLK_SNDR(x) ((x) << S_BLK_SNDR)
#define G_BLK_SNDR(x) (((x) >> S_BLK_SNDR) & M_BLK_SNDR)

#define S_CMPRS    8
#define M_CMPRS    0xfU
#define V_CMPRS(x) ((x) << S_CMPRS)
#define G_CMPRS(x) (((x) >> S_CMPRS) & M_CMPRS)

#define S_SNF    0
#define M_SNF    0xffU
#define V_SNF(x) ((x) << S_SNF)
#define G_SNF(x) (((x) >> S_SNF) & M_SNF)

#define A_MPS_RX_PORT_MUX_CTL 0x11004

#define S_CTL_P3    12
#define M_CTL_P3    0xfU
#define V_CTL_P3(x) ((x) << S_CTL_P3)
#define G_CTL_P3(x) (((x) >> S_CTL_P3) & M_CTL_P3)

#define S_CTL_P2    8
#define M_CTL_P2    0xfU
#define V_CTL_P2(x) ((x) << S_CTL_P2)
#define G_CTL_P2(x) (((x) >> S_CTL_P2) & M_CTL_P2)

#define S_CTL_P1    4
#define M_CTL_P1    0xfU
#define V_CTL_P1(x) ((x) << S_CTL_P1)
#define G_CTL_P1(x) (((x) >> S_CTL_P1) & M_CTL_P1)

#define S_CTL_P0    0
#define M_CTL_P0    0xfU
#define V_CTL_P0(x) ((x) << S_CTL_P0)
#define G_CTL_P0(x) (((x) >> S_CTL_P0) & M_CTL_P0)

#define A_MPS_RX_PG_FL 0x11008

#define S_RST    16
#define V_RST(x) ((x) << S_RST)
#define F_RST    V_RST(1U)

#define S_CNT    0
#define M_CNT    0xffffU
#define V_CNT(x) ((x) << S_CNT)
#define G_CNT(x) (((x) >> S_CNT) & M_CNT)

#define A_MPS_RX_PKT_FL 0x1100c
#define A_MPS_RX_PG_RSV0 0x11010

#define S_CLR_INTR    31
#define V_CLR_INTR(x) ((x) << S_CLR_INTR)
#define F_CLR_INTR    V_CLR_INTR(1U)

#define S_SET_INTR    30
#define V_SET_INTR(x) ((x) << S_SET_INTR)
#define F_SET_INTR    V_SET_INTR(1U)

#define S_USED    16
#define M_USED    0x7ffU
#define V_USED(x) ((x) << S_USED)
#define G_USED(x) (((x) >> S_USED) & M_USED)

#define S_ALLOC    0
#define M_ALLOC    0x7ffU
#define V_ALLOC(x) ((x) << S_ALLOC)
#define G_ALLOC(x) (((x) >> S_ALLOC) & M_ALLOC)

#define S_T5_USED    16
#define M_T5_USED    0xfffU
#define V_T5_USED(x) ((x) << S_T5_USED)
#define G_T5_USED(x) (((x) >> S_T5_USED) & M_T5_USED)

#define S_T5_ALLOC    0
#define M_T5_ALLOC    0xfffU
#define V_T5_ALLOC(x) ((x) << S_T5_ALLOC)
#define G_T5_ALLOC(x) (((x) >> S_T5_ALLOC) & M_T5_ALLOC)

#define A_MPS_RX_PG_RSV1 0x11014
#define A_MPS_RX_PG_RSV2 0x11018
#define A_MPS_RX_PG_RSV3 0x1101c
#define A_MPS_RX_PG_RSV4 0x11020
#define A_MPS_RX_PG_RSV5 0x11024
#define A_MPS_RX_PG_RSV6 0x11028
#define A_MPS_RX_PG_RSV7 0x1102c
#define A_MPS_RX_PG_SHR_BG0 0x11030

#define S_EN    31
#define V_EN(x) ((x) << S_EN)
#define F_EN    V_EN(1U)

#define S_SEL    30
#define V_SEL(x) ((x) << S_SEL)
#define F_SEL    V_SEL(1U)

#define S_MAX    16
#define M_MAX    0x7ffU
#define V_MAX(x) ((x) << S_MAX)
#define G_MAX(x) (((x) >> S_MAX) & M_MAX)

#define S_BORW    0
#define M_BORW    0x7ffU
#define V_BORW(x) ((x) << S_BORW)
#define G_BORW(x) (((x) >> S_BORW) & M_BORW)

#define S_T5_MAX    16
#define M_T5_MAX    0xfffU
#define V_T5_MAX(x) ((x) << S_T5_MAX)
#define G_T5_MAX(x) (((x) >> S_T5_MAX) & M_T5_MAX)

#define S_T5_BORW    0
#define M_T5_BORW    0xfffU
#define V_T5_BORW(x) ((x) << S_T5_BORW)
#define G_T5_BORW(x) (((x) >> S_T5_BORW) & M_T5_BORW)

#define A_MPS_RX_PG_SHR_BG1 0x11034
#define A_MPS_RX_PG_SHR_BG2 0x11038
#define A_MPS_RX_PG_SHR_BG3 0x1103c
#define A_MPS_RX_PG_SHR0 0x11040

#define S_QUOTA    16
#define M_QUOTA    0x7ffU
#define V_QUOTA(x) ((x) << S_QUOTA)
#define G_QUOTA(x) (((x) >> S_QUOTA) & M_QUOTA)

#define S_SHR_USED    0
#define M_SHR_USED    0x7ffU
#define V_SHR_USED(x) ((x) << S_SHR_USED)
#define G_SHR_USED(x) (((x) >> S_SHR_USED) & M_SHR_USED)

#define S_T5_QUOTA    16
#define M_T5_QUOTA    0xfffU
#define V_T5_QUOTA(x) ((x) << S_T5_QUOTA)
#define G_T5_QUOTA(x) (((x) >> S_T5_QUOTA) & M_T5_QUOTA)

#define S_T5_SHR_USED    0
#define M_T5_SHR_USED    0xfffU
#define V_T5_SHR_USED(x) ((x) << S_T5_SHR_USED)
#define G_T5_SHR_USED(x) (((x) >> S_T5_SHR_USED) & M_T5_SHR_USED)

#define A_MPS_RX_PG_SHR1 0x11044
#define A_MPS_RX_PG_HYST_BG0 0x11048

#define S_TH    0
#define M_TH    0x7ffU
#define V_TH(x) ((x) << S_TH)
#define G_TH(x) (((x) >> S_TH) & M_TH)

#define S_T5_TH    0
#define M_T5_TH    0xfffU
#define V_T5_TH(x) ((x) << S_T5_TH)
#define G_T5_TH(x) (((x) >> S_T5_TH) & M_T5_TH)

#define A_MPS_RX_PG_HYST_BG1 0x1104c
#define A_MPS_RX_PG_HYST_BG2 0x11050
#define A_MPS_RX_PG_HYST_BG3 0x11054
#define A_MPS_RX_OCH_CTL 0x11058

#define S_DROP_WT    27
#define M_DROP_WT    0x1fU
#define V_DROP_WT(x) ((x) << S_DROP_WT)
#define G_DROP_WT(x) (((x) >> S_DROP_WT) & M_DROP_WT)

#define S_TRUNC_WT    22
#define M_TRUNC_WT    0x1fU
#define V_TRUNC_WT(x) ((x) << S_TRUNC_WT)
#define G_TRUNC_WT(x) (((x) >> S_TRUNC_WT) & M_TRUNC_WT)

#define S_OCH_DRAIN    13
#define M_OCH_DRAIN    0x1fU
#define V_OCH_DRAIN(x) ((x) << S_OCH_DRAIN)
#define G_OCH_DRAIN(x) (((x) >> S_OCH_DRAIN) & M_OCH_DRAIN)

#define S_OCH_DROP    8
#define M_OCH_DROP    0x1fU
#define V_OCH_DROP(x) ((x) << S_OCH_DROP)
#define G_OCH_DROP(x) (((x) >> S_OCH_DROP) & M_OCH_DROP)

#define S_STOP    0
#define M_STOP    0x1fU
#define V_STOP(x) ((x) << S_STOP)
#define G_STOP(x) (((x) >> S_STOP) & M_STOP)

#define A_MPS_RX_LPBK_BP0 0x1105c

#define S_THRESH    0
#define M_THRESH    0x7ffU
#define V_THRESH(x) ((x) << S_THRESH)
#define G_THRESH(x) (((x) >> S_THRESH) & M_THRESH)

#define A_MPS_RX_LPBK_BP1 0x11060
#define A_MPS_RX_LPBK_BP2 0x11064
#define A_MPS_RX_LPBK_BP3 0x11068
#define A_MPS_RX_PORT_GAP 0x1106c

#define S_GAP    0
#define M_GAP    0xfffffU
#define V_GAP(x) ((x) << S_GAP)
#define G_GAP(x) (((x) >> S_GAP) & M_GAP)

#define A_MPS_RX_CHMN_CNT 0x11070
#define A_MPS_RX_PERR_INT_CAUSE 0x11074

#define S_FF    23
#define V_FF(x) ((x) << S_FF)
#define F_FF    V_FF(1U)

#define S_PGMO    22
#define V_PGMO(x) ((x) << S_PGMO)
#define F_PGMO    V_PGMO(1U)

#define S_PGME    21
#define V_PGME(x) ((x) << S_PGME)
#define F_PGME    V_PGME(1U)

#define S_CHMN    20
#define V_CHMN(x) ((x) << S_CHMN)
#define F_CHMN    V_CHMN(1U)

#define S_RPLC    19
#define V_RPLC(x) ((x) << S_RPLC)
#define F_RPLC    V_RPLC(1U)

#define S_ATRB    18
#define V_ATRB(x) ((x) << S_ATRB)
#define F_ATRB    V_ATRB(1U)

#define S_PSMX    17
#define V_PSMX(x) ((x) << S_PSMX)
#define F_PSMX    V_PSMX(1U)

#define S_PGLL    16
#define V_PGLL(x) ((x) << S_PGLL)
#define F_PGLL    V_PGLL(1U)

#define S_PGFL    15
#define V_PGFL(x) ((x) << S_PGFL)
#define F_PGFL    V_PGFL(1U)

#define S_PKTQ    14
#define V_PKTQ(x) ((x) << S_PKTQ)
#define F_PKTQ    V_PKTQ(1U)

#define S_PKFL    13
#define V_PKFL(x) ((x) << S_PKFL)
#define F_PKFL    V_PKFL(1U)

#define S_PPM3    12
#define V_PPM3(x) ((x) << S_PPM3)
#define F_PPM3    V_PPM3(1U)

#define S_PPM2    11
#define V_PPM2(x) ((x) << S_PPM2)
#define F_PPM2    V_PPM2(1U)

#define S_PPM1    10
#define V_PPM1(x) ((x) << S_PPM1)
#define F_PPM1    V_PPM1(1U)

#define S_PPM0    9
#define V_PPM0(x) ((x) << S_PPM0)
#define F_PPM0    V_PPM0(1U)

#define S_SPMX    8
#define V_SPMX(x) ((x) << S_SPMX)
#define F_SPMX    V_SPMX(1U)

#define S_CDL3    7
#define V_CDL3(x) ((x) << S_CDL3)
#define F_CDL3    V_CDL3(1U)

#define S_CDL2    6
#define V_CDL2(x) ((x) << S_CDL2)
#define F_CDL2    V_CDL2(1U)

#define S_CDL1    5
#define V_CDL1(x) ((x) << S_CDL1)
#define F_CDL1    V_CDL1(1U)

#define S_CDL0    4
#define V_CDL0(x) ((x) << S_CDL0)
#define F_CDL0    V_CDL0(1U)

#define S_CDM3    3
#define V_CDM3(x) ((x) << S_CDM3)
#define F_CDM3    V_CDM3(1U)

#define S_CDM2    2
#define V_CDM2(x) ((x) << S_CDM2)
#define F_CDM2    V_CDM2(1U)

#define S_CDM1    1
#define V_CDM1(x) ((x) << S_CDM1)
#define F_CDM1    V_CDM1(1U)

#define S_CDM0    0
#define V_CDM0(x) ((x) << S_CDM0)
#define F_CDM0    V_CDM0(1U)

#define A_MPS_RX_PERR_INT_ENABLE 0x11078
#define A_MPS_RX_PERR_ENABLE 0x1107c
#define A_MPS_RX_PERR_INJECT 0x11080
#define A_MPS_RX_FUNC_INT_CAUSE 0x11084

#define S_INT_ERR_INT    8
#define M_INT_ERR_INT    0x1fU
#define V_INT_ERR_INT(x) ((x) << S_INT_ERR_INT)
#define G_INT_ERR_INT(x) (((x) >> S_INT_ERR_INT) & M_INT_ERR_INT)

#define S_PG_TH_INT7    7
#define V_PG_TH_INT7(x) ((x) << S_PG_TH_INT7)
#define F_PG_TH_INT7    V_PG_TH_INT7(1U)

#define S_PG_TH_INT6    6
#define V_PG_TH_INT6(x) ((x) << S_PG_TH_INT6)
#define F_PG_TH_INT6    V_PG_TH_INT6(1U)

#define S_PG_TH_INT5    5
#define V_PG_TH_INT5(x) ((x) << S_PG_TH_INT5)
#define F_PG_TH_INT5    V_PG_TH_INT5(1U)

#define S_PG_TH_INT4    4
#define V_PG_TH_INT4(x) ((x) << S_PG_TH_INT4)
#define F_PG_TH_INT4    V_PG_TH_INT4(1U)

#define S_PG_TH_INT3    3
#define V_PG_TH_INT3(x) ((x) << S_PG_TH_INT3)
#define F_PG_TH_INT3    V_PG_TH_INT3(1U)

#define S_PG_TH_INT2    2
#define V_PG_TH_INT2(x) ((x) << S_PG_TH_INT2)
#define F_PG_TH_INT2    V_PG_TH_INT2(1U)

#define S_PG_TH_INT1    1
#define V_PG_TH_INT1(x) ((x) << S_PG_TH_INT1)
#define F_PG_TH_INT1    V_PG_TH_INT1(1U)

#define S_PG_TH_INT0    0
#define V_PG_TH_INT0(x) ((x) << S_PG_TH_INT0)
#define F_PG_TH_INT0    V_PG_TH_INT0(1U)

#define S_MTU_ERR_INT3    19
#define V_MTU_ERR_INT3(x) ((x) << S_MTU_ERR_INT3)
#define F_MTU_ERR_INT3    V_MTU_ERR_INT3(1U)

#define S_MTU_ERR_INT2    18
#define V_MTU_ERR_INT2(x) ((x) << S_MTU_ERR_INT2)
#define F_MTU_ERR_INT2    V_MTU_ERR_INT2(1U)

#define S_MTU_ERR_INT1    17
#define V_MTU_ERR_INT1(x) ((x) << S_MTU_ERR_INT1)
#define F_MTU_ERR_INT1    V_MTU_ERR_INT1(1U)

#define S_MTU_ERR_INT0    16
#define V_MTU_ERR_INT0(x) ((x) << S_MTU_ERR_INT0)
#define F_MTU_ERR_INT0    V_MTU_ERR_INT0(1U)

#define S_SE_CNT_ERR_INT    15
#define V_SE_CNT_ERR_INT(x) ((x) << S_SE_CNT_ERR_INT)
#define F_SE_CNT_ERR_INT    V_SE_CNT_ERR_INT(1U)

#define S_FRM_ERR_INT    14
#define V_FRM_ERR_INT(x) ((x) << S_FRM_ERR_INT)
#define F_FRM_ERR_INT    V_FRM_ERR_INT(1U)

#define S_LEN_ERR_INT    13
#define V_LEN_ERR_INT(x) ((x) << S_LEN_ERR_INT)
#define F_LEN_ERR_INT    V_LEN_ERR_INT(1U)

#define A_MPS_RX_FUNC_INT_ENABLE 0x11088
#define A_MPS_RX_PAUSE_GEN_TH_0 0x1108c

#define S_TH_HIGH    16
#define M_TH_HIGH    0xffffU
#define V_TH_HIGH(x) ((x) << S_TH_HIGH)
#define G_TH_HIGH(x) (((x) >> S_TH_HIGH) & M_TH_HIGH)

#define S_TH_LOW    0
#define M_TH_LOW    0xffffU
#define V_TH_LOW(x) ((x) << S_TH_LOW)
#define G_TH_LOW(x) (((x) >> S_TH_LOW) & M_TH_LOW)

#define A_MPS_RX_PAUSE_GEN_TH_1 0x11090
#define A_MPS_RX_PAUSE_GEN_TH_2 0x11094
#define A_MPS_RX_PAUSE_GEN_TH_3 0x11098
#define A_MPS_RX_PPP_ATRB 0x1109c

#define S_ETYPE    16
#define M_ETYPE    0xffffU
#define V_ETYPE(x) ((x) << S_ETYPE)
#define G_ETYPE(x) (((x) >> S_ETYPE) & M_ETYPE)

#define S_OPCODE    0
#define M_OPCODE    0xffffU
#define V_OPCODE(x) ((x) << S_OPCODE)
#define G_OPCODE(x) (((x) >> S_OPCODE) & M_OPCODE)

#define A_MPS_RX_QFC0_ATRB 0x110a0

#define S_DA    0
#define M_DA    0xffffU
#define V_DA(x) ((x) << S_DA)
#define G_DA(x) (((x) >> S_DA) & M_DA)

#define A_MPS_RX_QFC1_ATRB 0x110a4
#define A_MPS_RX_PT_ARB0 0x110a8

#define S_LPBK_WT    16
#define M_LPBK_WT    0x3fffU
#define V_LPBK_WT(x) ((x) << S_LPBK_WT)
#define G_LPBK_WT(x) (((x) >> S_LPBK_WT) & M_LPBK_WT)

#define S_MAC_WT    0
#define M_MAC_WT    0x3fffU
#define V_MAC_WT(x) ((x) << S_MAC_WT)
#define G_MAC_WT(x) (((x) >> S_MAC_WT) & M_MAC_WT)

#define A_MPS_RX_PT_ARB1 0x110ac
#define A_MPS_RX_PT_ARB2 0x110b0
#define A_MPS_RX_PT_ARB3 0x110b4
#define A_MPS_RX_PT_ARB4 0x110b8
#define A_MPS_PF_OUT_EN 0x110bc

#define S_OUTEN    0
#define M_OUTEN    0xffU
#define V_OUTEN(x) ((x) << S_OUTEN)
#define G_OUTEN(x) (((x) >> S_OUTEN) & M_OUTEN)

#define A_MPS_BMC_MTU 0x110c0

#define S_MTU    0
#define M_MTU    0x3fffU
#define V_MTU(x) ((x) << S_MTU)
#define G_MTU(x) (((x) >> S_MTU) & M_MTU)

#define A_MPS_BMC_PKT_CNT 0x110c4
#define A_MPS_BMC_BYTE_CNT 0x110c8
#define A_MPS_PFVF_ATRB_CTL 0x110cc

#define S_RD_WRN    31
#define V_RD_WRN(x) ((x) << S_RD_WRN)
#define F_RD_WRN    V_RD_WRN(1U)

#define S_PFVF    0
#define M_PFVF    0xffU
#define V_PFVF(x) ((x) << S_PFVF)
#define G_PFVF(x) (((x) >> S_PFVF) & M_PFVF)

#define A_MPS_PFVF_ATRB 0x110d0

#define S_ATTR_PF    28
#define M_ATTR_PF    0x7U
#define V_ATTR_PF(x) ((x) << S_ATTR_PF)
#define G_ATTR_PF(x) (((x) >> S_ATTR_PF) & M_ATTR_PF)

#define S_OFF    18
#define V_OFF(x) ((x) << S_OFF)
#define F_OFF    V_OFF(1U)

#define S_NV_DROP    17
#define V_NV_DROP(x) ((x) << S_NV_DROP)
#define F_NV_DROP    V_NV_DROP(1U)

#define S_ATTR_MODE    16
#define V_ATTR_MODE(x) ((x) << S_ATTR_MODE)
#define F_ATTR_MODE    V_ATTR_MODE(1U)

#define A_MPS_PFVF_ATRB_FLTR0 0x110d4

#define S_VLAN_EN    16
#define V_VLAN_EN(x) ((x) << S_VLAN_EN)
#define F_VLAN_EN    V_VLAN_EN(1U)

#define S_VLAN_ID    0
#define M_VLAN_ID    0xfffU
#define V_VLAN_ID(x) ((x) << S_VLAN_ID)
#define G_VLAN_ID(x) (((x) >> S_VLAN_ID) & M_VLAN_ID)

#define A_MPS_PFVF_ATRB_FLTR1 0x110d8
#define A_MPS_PFVF_ATRB_FLTR2 0x110dc
#define A_MPS_PFVF_ATRB_FLTR3 0x110e0
#define A_MPS_PFVF_ATRB_FLTR4 0x110e4
#define A_MPS_PFVF_ATRB_FLTR5 0x110e8
#define A_MPS_PFVF_ATRB_FLTR6 0x110ec
#define A_MPS_PFVF_ATRB_FLTR7 0x110f0
#define A_MPS_PFVF_ATRB_FLTR8 0x110f4
#define A_MPS_PFVF_ATRB_FLTR9 0x110f8
#define A_MPS_PFVF_ATRB_FLTR10 0x110fc
#define A_MPS_PFVF_ATRB_FLTR11 0x11100
#define A_MPS_PFVF_ATRB_FLTR12 0x11104
#define A_MPS_PFVF_ATRB_FLTR13 0x11108
#define A_MPS_PFVF_ATRB_FLTR14 0x1110c
#define A_MPS_PFVF_ATRB_FLTR15 0x11110
#define A_MPS_RPLC_MAP_CTL 0x11114

#define S_RPLC_MAP_ADDR    0
#define M_RPLC_MAP_ADDR    0x3ffU
#define V_RPLC_MAP_ADDR(x) ((x) << S_RPLC_MAP_ADDR)
#define G_RPLC_MAP_ADDR(x) (((x) >> S_RPLC_MAP_ADDR) & M_RPLC_MAP_ADDR)

#define A_MPS_PF_RPLCT_MAP 0x11118

#define S_PF_EN    0
#define M_PF_EN    0xffU
#define V_PF_EN(x) ((x) << S_PF_EN)
#define G_PF_EN(x) (((x) >> S_PF_EN) & M_PF_EN)

#define A_MPS_VF_RPLCT_MAP0 0x1111c
#define A_MPS_VF_RPLCT_MAP1 0x11120
#define A_MPS_VF_RPLCT_MAP2 0x11124
#define A_MPS_VF_RPLCT_MAP3 0x11128
#define A_MPS_MEM_DBG_CTL 0x1112c

#define S_PKD    17
#define V_PKD(x) ((x) << S_PKD)
#define F_PKD    V_PKD(1U)

#define S_PGD    16
#define V_PGD(x) ((x) << S_PGD)
#define F_PGD    V_PGD(1U)

#define A_MPS_PKD_MEM_DATA0 0x11130
#define A_MPS_PKD_MEM_DATA1 0x11134
#define A_MPS_PKD_MEM_DATA2 0x11138
#define A_MPS_PGD_MEM_DATA 0x1113c
#define A_MPS_RX_SE_CNT_ERR 0x11140

#define S_RX_SE_ERRMAP    0
#define M_RX_SE_ERRMAP    0xfffffU
#define V_RX_SE_ERRMAP(x) ((x) << S_RX_SE_ERRMAP)
#define G_RX_SE_ERRMAP(x) (((x) >> S_RX_SE_ERRMAP) & M_RX_SE_ERRMAP)

#define A_MPS_RX_SE_CNT_CLR 0x11144
#define A_MPS_RX_SE_CNT_IN0 0x11148

#define S_SOP_CNT_PM    24
#define M_SOP_CNT_PM    0xffU
#define V_SOP_CNT_PM(x) ((x) << S_SOP_CNT_PM)
#define G_SOP_CNT_PM(x) (((x) >> S_SOP_CNT_PM) & M_SOP_CNT_PM)

#define S_EOP_CNT_PM    16
#define M_EOP_CNT_PM    0xffU
#define V_EOP_CNT_PM(x) ((x) << S_EOP_CNT_PM)
#define G_EOP_CNT_PM(x) (((x) >> S_EOP_CNT_PM) & M_EOP_CNT_PM)

#define S_SOP_CNT_IN    8
#define M_SOP_CNT_IN    0xffU
#define V_SOP_CNT_IN(x) ((x) << S_SOP_CNT_IN)
#define G_SOP_CNT_IN(x) (((x) >> S_SOP_CNT_IN) & M_SOP_CNT_IN)

#define S_EOP_CNT_IN    0
#define M_EOP_CNT_IN    0xffU
#define V_EOP_CNT_IN(x) ((x) << S_EOP_CNT_IN)
#define G_EOP_CNT_IN(x) (((x) >> S_EOP_CNT_IN) & M_EOP_CNT_IN)

#define A_MPS_RX_SE_CNT_IN1 0x1114c
#define A_MPS_RX_SE_CNT_IN2 0x11150
#define A_MPS_RX_SE_CNT_IN3 0x11154
#define A_MPS_RX_SE_CNT_IN4 0x11158
#define A_MPS_RX_SE_CNT_IN5 0x1115c
#define A_MPS_RX_SE_CNT_IN6 0x11160
#define A_MPS_RX_SE_CNT_IN7 0x11164
#define A_MPS_RX_SE_CNT_OUT01 0x11168

#define S_SOP_CNT_1    24
#define M_SOP_CNT_1    0xffU
#define V_SOP_CNT_1(x) ((x) << S_SOP_CNT_1)
#define G_SOP_CNT_1(x) (((x) >> S_SOP_CNT_1) & M_SOP_CNT_1)

#define S_EOP_CNT_1    16
#define M_EOP_CNT_1    0xffU
#define V_EOP_CNT_1(x) ((x) << S_EOP_CNT_1)
#define G_EOP_CNT_1(x) (((x) >> S_EOP_CNT_1) & M_EOP_CNT_1)

#define S_SOP_CNT_0    8
#define M_SOP_CNT_0    0xffU
#define V_SOP_CNT_0(x) ((x) << S_SOP_CNT_0)
#define G_SOP_CNT_0(x) (((x) >> S_SOP_CNT_0) & M_SOP_CNT_0)

#define S_EOP_CNT_0    0
#define M_EOP_CNT_0    0xffU
#define V_EOP_CNT_0(x) ((x) << S_EOP_CNT_0)
#define G_EOP_CNT_0(x) (((x) >> S_EOP_CNT_0) & M_EOP_CNT_0)

#define A_MPS_RX_SE_CNT_OUT23 0x1116c

#define S_SOP_CNT_3    24
#define M_SOP_CNT_3    0xffU
#define V_SOP_CNT_3(x) ((x) << S_SOP_CNT_3)
#define G_SOP_CNT_3(x) (((x) >> S_SOP_CNT_3) & M_SOP_CNT_3)

#define S_EOP_CNT_3    16
#define M_EOP_CNT_3    0xffU
#define V_EOP_CNT_3(x) ((x) << S_EOP_CNT_3)
#define G_EOP_CNT_3(x) (((x) >> S_EOP_CNT_3) & M_EOP_CNT_3)

#define S_SOP_CNT_2    8
#define M_SOP_CNT_2    0xffU
#define V_SOP_CNT_2(x) ((x) << S_SOP_CNT_2)
#define G_SOP_CNT_2(x) (((x) >> S_SOP_CNT_2) & M_SOP_CNT_2)

#define S_EOP_CNT_2    0
#define M_EOP_CNT_2    0xffU
#define V_EOP_CNT_2(x) ((x) << S_EOP_CNT_2)
#define G_EOP_CNT_2(x) (((x) >> S_EOP_CNT_2) & M_EOP_CNT_2)

#define A_MPS_RX_SPI_ERR 0x11170

#define S_LENERR    21
#define M_LENERR    0xfU
#define V_LENERR(x) ((x) << S_LENERR)
#define G_LENERR(x) (((x) >> S_LENERR) & M_LENERR)

#define S_SPIERR    0
#define M_SPIERR    0x1fffffU
#define V_SPIERR(x) ((x) << S_SPIERR)
#define G_SPIERR(x) (((x) >> S_SPIERR) & M_SPIERR)

#define A_MPS_RX_IN_BUS_STATE 0x11174

#define S_ST3    24
#define M_ST3    0xffU
#define V_ST3(x) ((x) << S_ST3)
#define G_ST3(x) (((x) >> S_ST3) & M_ST3)

#define S_ST2    16
#define M_ST2    0xffU
#define V_ST2(x) ((x) << S_ST2)
#define G_ST2(x) (((x) >> S_ST2) & M_ST2)

#define S_ST1    8
#define M_ST1    0xffU
#define V_ST1(x) ((x) << S_ST1)
#define G_ST1(x) (((x) >> S_ST1) & M_ST1)

#define S_ST0    0
#define M_ST0    0xffU
#define V_ST0(x) ((x) << S_ST0)
#define G_ST0(x) (((x) >> S_ST0) & M_ST0)

#define A_MPS_RX_OUT_BUS_STATE 0x11178

#define S_ST_NCSI    23
#define M_ST_NCSI    0x1ffU
#define V_ST_NCSI(x) ((x) << S_ST_NCSI)
#define G_ST_NCSI(x) (((x) >> S_ST_NCSI) & M_ST_NCSI)

#define S_ST_TP    0
#define M_ST_TP    0x7fffffU
#define V_ST_TP(x) ((x) << S_ST_TP)
#define G_ST_TP(x) (((x) >> S_ST_TP) & M_ST_TP)

#define A_MPS_RX_DBG_CTL 0x1117c

#define S_OUT_DBG_CHNL    8
#define M_OUT_DBG_CHNL    0x7U
#define V_OUT_DBG_CHNL(x) ((x) << S_OUT_DBG_CHNL)
#define G_OUT_DBG_CHNL(x) (((x) >> S_OUT_DBG_CHNL) & M_OUT_DBG_CHNL)

#define S_DBG_PKD_QSEL    7
#define V_DBG_PKD_QSEL(x) ((x) << S_DBG_PKD_QSEL)
#define F_DBG_PKD_QSEL    V_DBG_PKD_QSEL(1U)

#define S_DBG_CDS_INV    6
#define V_DBG_CDS_INV(x) ((x) << S_DBG_CDS_INV)
#define F_DBG_CDS_INV    V_DBG_CDS_INV(1U)

#define S_IN_DBG_PORT    3
#define M_IN_DBG_PORT    0x7U
#define V_IN_DBG_PORT(x) ((x) << S_IN_DBG_PORT)
#define G_IN_DBG_PORT(x) (((x) >> S_IN_DBG_PORT) & M_IN_DBG_PORT)

#define S_IN_DBG_CHNL    0
#define M_IN_DBG_CHNL    0x7U
#define V_IN_DBG_CHNL(x) ((x) << S_IN_DBG_CHNL)
#define G_IN_DBG_CHNL(x) (((x) >> S_IN_DBG_CHNL) & M_IN_DBG_CHNL)

#define A_MPS_RX_CLS_DROP_CNT0 0x11180

#define S_LPBK_CNT0    16
#define M_LPBK_CNT0    0xffffU
#define V_LPBK_CNT0(x) ((x) << S_LPBK_CNT0)
#define G_LPBK_CNT0(x) (((x) >> S_LPBK_CNT0) & M_LPBK_CNT0)

#define S_MAC_CNT0    0
#define M_MAC_CNT0    0xffffU
#define V_MAC_CNT0(x) ((x) << S_MAC_CNT0)
#define G_MAC_CNT0(x) (((x) >> S_MAC_CNT0) & M_MAC_CNT0)

#define A_MPS_RX_CLS_DROP_CNT1 0x11184

#define S_LPBK_CNT1    16
#define M_LPBK_CNT1    0xffffU
#define V_LPBK_CNT1(x) ((x) << S_LPBK_CNT1)
#define G_LPBK_CNT1(x) (((x) >> S_LPBK_CNT1) & M_LPBK_CNT1)

#define S_MAC_CNT1    0
#define M_MAC_CNT1    0xffffU
#define V_MAC_CNT1(x) ((x) << S_MAC_CNT1)
#define G_MAC_CNT1(x) (((x) >> S_MAC_CNT1) & M_MAC_CNT1)

#define A_MPS_RX_CLS_DROP_CNT2 0x11188

#define S_LPBK_CNT2    16
#define M_LPBK_CNT2    0xffffU
#define V_LPBK_CNT2(x) ((x) << S_LPBK_CNT2)
#define G_LPBK_CNT2(x) (((x) >> S_LPBK_CNT2) & M_LPBK_CNT2)

#define S_MAC_CNT2    0
#define M_MAC_CNT2    0xffffU
#define V_MAC_CNT2(x) ((x) << S_MAC_CNT2)
#define G_MAC_CNT2(x) (((x) >> S_MAC_CNT2) & M_MAC_CNT2)

#define A_MPS_RX_CLS_DROP_CNT3 0x1118c

#define S_LPBK_CNT3    16
#define M_LPBK_CNT3    0xffffU
#define V_LPBK_CNT3(x) ((x) << S_LPBK_CNT3)
#define G_LPBK_CNT3(x) (((x) >> S_LPBK_CNT3) & M_LPBK_CNT3)

#define S_MAC_CNT3    0
#define M_MAC_CNT3    0xffffU
#define V_MAC_CNT3(x) ((x) << S_MAC_CNT3)
#define G_MAC_CNT3(x) (((x) >> S_MAC_CNT3) & M_MAC_CNT3)

#define A_MPS_RX_SPARE 0x11190
#define A_MPS_RX_PTP_ETYPE 0x11194

#define S_PETYPE2    16
#define M_PETYPE2    0xffffU
#define V_PETYPE2(x) ((x) << S_PETYPE2)
#define G_PETYPE2(x) (((x) >> S_PETYPE2) & M_PETYPE2)

#define S_PETYPE1    0
#define M_PETYPE1    0xffffU
#define V_PETYPE1(x) ((x) << S_PETYPE1)
#define G_PETYPE1(x) (((x) >> S_PETYPE1) & M_PETYPE1)

#define A_MPS_RX_PTP_TCP 0x11198

#define S_PTCPORT2    16
#define M_PTCPORT2    0xffffU
#define V_PTCPORT2(x) ((x) << S_PTCPORT2)
#define G_PTCPORT2(x) (((x) >> S_PTCPORT2) & M_PTCPORT2)

#define S_PTCPORT1    0
#define M_PTCPORT1    0xffffU
#define V_PTCPORT1(x) ((x) << S_PTCPORT1)
#define G_PTCPORT1(x) (((x) >> S_PTCPORT1) & M_PTCPORT1)

#define A_MPS_RX_PTP_UDP 0x1119c

#define S_PUDPORT2    16
#define M_PUDPORT2    0xffffU
#define V_PUDPORT2(x) ((x) << S_PUDPORT2)
#define G_PUDPORT2(x) (((x) >> S_PUDPORT2) & M_PUDPORT2)

#define S_PUDPORT1    0
#define M_PUDPORT1    0xffffU
#define V_PUDPORT1(x) ((x) << S_PUDPORT1)
#define G_PUDPORT1(x) (((x) >> S_PUDPORT1) & M_PUDPORT1)

#define A_MPS_RX_PTP_CTL 0x111a0

#define S_MIN_PTP_SPACE    24
#define M_MIN_PTP_SPACE    0x7fU
#define V_MIN_PTP_SPACE(x) ((x) << S_MIN_PTP_SPACE)
#define G_MIN_PTP_SPACE(x) (((x) >> S_MIN_PTP_SPACE) & M_MIN_PTP_SPACE)

#define S_PUDP2EN    20
#define M_PUDP2EN    0xfU
#define V_PUDP2EN(x) ((x) << S_PUDP2EN)
#define G_PUDP2EN(x) (((x) >> S_PUDP2EN) & M_PUDP2EN)

#define S_PUDP1EN    16
#define M_PUDP1EN    0xfU
#define V_PUDP1EN(x) ((x) << S_PUDP1EN)
#define G_PUDP1EN(x) (((x) >> S_PUDP1EN) & M_PUDP1EN)

#define S_PTCP2EN    12
#define M_PTCP2EN    0xfU
#define V_PTCP2EN(x) ((x) << S_PTCP2EN)
#define G_PTCP2EN(x) (((x) >> S_PTCP2EN) & M_PTCP2EN)

#define S_PTCP1EN    8
#define M_PTCP1EN    0xfU
#define V_PTCP1EN(x) ((x) << S_PTCP1EN)
#define G_PTCP1EN(x) (((x) >> S_PTCP1EN) & M_PTCP1EN)

#define S_PETYPE2EN    4
#define M_PETYPE2EN    0xfU
#define V_PETYPE2EN(x) ((x) << S_PETYPE2EN)
#define G_PETYPE2EN(x) (((x) >> S_PETYPE2EN) & M_PETYPE2EN)

#define S_PETYPE1EN    0
#define M_PETYPE1EN    0xfU
#define V_PETYPE1EN(x) ((x) << S_PETYPE1EN)
#define G_PETYPE1EN(x) (((x) >> S_PETYPE1EN) & M_PETYPE1EN)

#define A_MPS_RX_PAUSE_GEN_TH_0_0 0x111a4
#define A_MPS_RX_PAUSE_GEN_TH_0_1 0x111a8
#define A_MPS_RX_PAUSE_GEN_TH_0_2 0x111ac
#define A_MPS_RX_PAUSE_GEN_TH_0_3 0x111b0
#define A_MPS_RX_PAUSE_GEN_TH_1_0 0x111b4
#define A_MPS_RX_PAUSE_GEN_TH_1_1 0x111b8
#define A_MPS_RX_PAUSE_GEN_TH_1_2 0x111bc
#define A_MPS_RX_PAUSE_GEN_TH_1_3 0x111c0
#define A_MPS_RX_PAUSE_GEN_TH_2_0 0x111c4
#define A_MPS_RX_PAUSE_GEN_TH_2_1 0x111c8
#define A_MPS_RX_PAUSE_GEN_TH_2_2 0x111cc
#define A_MPS_RX_PAUSE_GEN_TH_2_3 0x111d0
#define A_MPS_RX_PAUSE_GEN_TH_3_0 0x111d4
#define A_MPS_RX_PAUSE_GEN_TH_3_1 0x111d8
#define A_MPS_RX_PAUSE_GEN_TH_3_2 0x111dc
#define A_MPS_RX_PAUSE_GEN_TH_3_3 0x111e0
#define A_MPS_RX_MAC_CLS_DROP_CNT0 0x111e4
#define A_MPS_RX_MAC_CLS_DROP_CNT1 0x111e8
#define A_MPS_RX_MAC_CLS_DROP_CNT2 0x111ec
#define A_MPS_RX_MAC_CLS_DROP_CNT3 0x111f0
#define A_MPS_RX_LPBK_CLS_DROP_CNT0 0x111f4
#define A_MPS_RX_LPBK_CLS_DROP_CNT1 0x111f8
#define A_MPS_RX_LPBK_CLS_DROP_CNT2 0x111fc
#define A_MPS_RX_LPBK_CLS_DROP_CNT3 0x11200
#define A_MPS_RX_CGEN 0x11204

#define S_MPS_RX_CGEN_NCSI    12
#define V_MPS_RX_CGEN_NCSI(x) ((x) << S_MPS_RX_CGEN_NCSI)
#define F_MPS_RX_CGEN_NCSI    V_MPS_RX_CGEN_NCSI(1U)

#define S_MPS_RX_CGEN_OUT    8
#define M_MPS_RX_CGEN_OUT    0xfU
#define V_MPS_RX_CGEN_OUT(x) ((x) << S_MPS_RX_CGEN_OUT)
#define G_MPS_RX_CGEN_OUT(x) (((x) >> S_MPS_RX_CGEN_OUT) & M_MPS_RX_CGEN_OUT)

#define S_MPS_RX_CGEN_LPBK_IN    4
#define M_MPS_RX_CGEN_LPBK_IN    0xfU
#define V_MPS_RX_CGEN_LPBK_IN(x) ((x) << S_MPS_RX_CGEN_LPBK_IN)
#define G_MPS_RX_CGEN_LPBK_IN(x) (((x) >> S_MPS_RX_CGEN_LPBK_IN) & M_MPS_RX_CGEN_LPBK_IN)

#define S_MPS_RX_CGEN_MAC_IN    0
#define M_MPS_RX_CGEN_MAC_IN    0xfU
#define V_MPS_RX_CGEN_MAC_IN(x) ((x) << S_MPS_RX_CGEN_MAC_IN)
#define G_MPS_RX_CGEN_MAC_IN(x) (((x) >> S_MPS_RX_CGEN_MAC_IN) & M_MPS_RX_CGEN_MAC_IN)

/* registers for module CPL_SWITCH */
#define CPL_SWITCH_BASE_ADDR 0x19040

#define A_CPL_SWITCH_CNTRL 0x19040

#define S_CPL_PKT_TID    8
#define M_CPL_PKT_TID    0xffffffU
#define V_CPL_PKT_TID(x) ((x) << S_CPL_PKT_TID)
#define G_CPL_PKT_TID(x) (((x) >> S_CPL_PKT_TID) & M_CPL_PKT_TID)

#define S_CIM_TRUNCATE_ENABLE    5
#define V_CIM_TRUNCATE_ENABLE(x) ((x) << S_CIM_TRUNCATE_ENABLE)
#define F_CIM_TRUNCATE_ENABLE    V_CIM_TRUNCATE_ENABLE(1U)

#define S_CIM_TO_UP_FULL_SIZE    4
#define V_CIM_TO_UP_FULL_SIZE(x) ((x) << S_CIM_TO_UP_FULL_SIZE)
#define F_CIM_TO_UP_FULL_SIZE    V_CIM_TO_UP_FULL_SIZE(1U)

#define S_CPU_NO_ENABLE    3
#define V_CPU_NO_ENABLE(x) ((x) << S_CPU_NO_ENABLE)
#define F_CPU_NO_ENABLE    V_CPU_NO_ENABLE(1U)

#define S_SWITCH_TABLE_ENABLE    2
#define V_SWITCH_TABLE_ENABLE(x) ((x) << S_SWITCH_TABLE_ENABLE)
#define F_SWITCH_TABLE_ENABLE    V_SWITCH_TABLE_ENABLE(1U)

#define S_SGE_ENABLE    1
#define V_SGE_ENABLE(x) ((x) << S_SGE_ENABLE)
#define F_SGE_ENABLE    V_SGE_ENABLE(1U)

#define S_CIM_ENABLE    0
#define V_CIM_ENABLE(x) ((x) << S_CIM_ENABLE)
#define F_CIM_ENABLE    V_CIM_ENABLE(1U)

#define S_CIM_SPLIT_ENABLE    6
#define V_CIM_SPLIT_ENABLE(x) ((x) << S_CIM_SPLIT_ENABLE)
#define F_CIM_SPLIT_ENABLE    V_CIM_SPLIT_ENABLE(1U)

#define A_CPL_SWITCH_TBL_IDX 0x19044

#define S_SWITCH_TBL_IDX    0
#define M_SWITCH_TBL_IDX    0xfU
#define V_SWITCH_TBL_IDX(x) ((x) << S_SWITCH_TBL_IDX)
#define G_SWITCH_TBL_IDX(x) (((x) >> S_SWITCH_TBL_IDX) & M_SWITCH_TBL_IDX)

#define A_CPL_SWITCH_TBL_DATA 0x19048
#define A_CPL_SWITCH_ZERO_ERROR 0x1904c

#define S_ZERO_CMD_CH1    8
#define M_ZERO_CMD_CH1    0xffU
#define V_ZERO_CMD_CH1(x) ((x) << S_ZERO_CMD_CH1)
#define G_ZERO_CMD_CH1(x) (((x) >> S_ZERO_CMD_CH1) & M_ZERO_CMD_CH1)

#define S_ZERO_CMD_CH0    0
#define M_ZERO_CMD_CH0    0xffU
#define V_ZERO_CMD_CH0(x) ((x) << S_ZERO_CMD_CH0)
#define G_ZERO_CMD_CH0(x) (((x) >> S_ZERO_CMD_CH0) & M_ZERO_CMD_CH0)

#define A_CPL_INTR_ENABLE 0x19050

#define S_CIM_OP_MAP_PERR    5
#define V_CIM_OP_MAP_PERR(x) ((x) << S_CIM_OP_MAP_PERR)
#define F_CIM_OP_MAP_PERR    V_CIM_OP_MAP_PERR(1U)

#define S_CIM_OVFL_ERROR    4
#define V_CIM_OVFL_ERROR(x) ((x) << S_CIM_OVFL_ERROR)
#define F_CIM_OVFL_ERROR    V_CIM_OVFL_ERROR(1U)

#define S_TP_FRAMING_ERROR    3
#define V_TP_FRAMING_ERROR(x) ((x) << S_TP_FRAMING_ERROR)
#define F_TP_FRAMING_ERROR    V_TP_FRAMING_ERROR(1U)

#define S_SGE_FRAMING_ERROR    2
#define V_SGE_FRAMING_ERROR(x) ((x) << S_SGE_FRAMING_ERROR)
#define F_SGE_FRAMING_ERROR    V_SGE_FRAMING_ERROR(1U)

#define S_CIM_FRAMING_ERROR    1
#define V_CIM_FRAMING_ERROR(x) ((x) << S_CIM_FRAMING_ERROR)
#define F_CIM_FRAMING_ERROR    V_CIM_FRAMING_ERROR(1U)

#define S_ZERO_SWITCH_ERROR    0
#define V_ZERO_SWITCH_ERROR(x) ((x) << S_ZERO_SWITCH_ERROR)
#define F_ZERO_SWITCH_ERROR    V_ZERO_SWITCH_ERROR(1U)

#define S_PERR_CPL_128TO128_1    7
#define V_PERR_CPL_128TO128_1(x) ((x) << S_PERR_CPL_128TO128_1)
#define F_PERR_CPL_128TO128_1    V_PERR_CPL_128TO128_1(1U)

#define S_PERR_CPL_128TO128_0    6
#define V_PERR_CPL_128TO128_0(x) ((x) << S_PERR_CPL_128TO128_0)
#define F_PERR_CPL_128TO128_0    V_PERR_CPL_128TO128_0(1U)

#define A_CPL_INTR_CAUSE 0x19054
#define A_CPL_MAP_TBL_IDX 0x19058

#define S_MAP_TBL_IDX    0
#define M_MAP_TBL_IDX    0xffU
#define V_MAP_TBL_IDX(x) ((x) << S_MAP_TBL_IDX)
#define G_MAP_TBL_IDX(x) (((x) >> S_MAP_TBL_IDX) & M_MAP_TBL_IDX)

#define S_CIM_SPLIT_OPCODE_PROGRAM    8
#define V_CIM_SPLIT_OPCODE_PROGRAM(x) ((x) << S_CIM_SPLIT_OPCODE_PROGRAM)
#define F_CIM_SPLIT_OPCODE_PROGRAM    V_CIM_SPLIT_OPCODE_PROGRAM(1U)

#define A_CPL_MAP_TBL_DATA 0x1905c

#define S_MAP_TBL_DATA    0
#define M_MAP_TBL_DATA    0xffU
#define V_MAP_TBL_DATA(x) ((x) << S_MAP_TBL_DATA)
#define G_MAP_TBL_DATA(x) (((x) >> S_MAP_TBL_DATA) & M_MAP_TBL_DATA)

/* registers for module SMB */
#define SMB_BASE_ADDR 0x19060

#define A_SMB_GLOBAL_TIME_CFG 0x19060

#define S_MACROCNTCFG    8
#define M_MACROCNTCFG    0x1fU
#define V_MACROCNTCFG(x) ((x) << S_MACROCNTCFG)
#define G_MACROCNTCFG(x) (((x) >> S_MACROCNTCFG) & M_MACROCNTCFG)

#define S_MICROCNTCFG    0
#define M_MICROCNTCFG    0xffU
#define V_MICROCNTCFG(x) ((x) << S_MICROCNTCFG)
#define G_MICROCNTCFG(x) (((x) >> S_MICROCNTCFG) & M_MICROCNTCFG)

#define A_SMB_MST_TIMEOUT_CFG 0x19064

#define S_MSTTIMEOUTCFG    0
#define M_MSTTIMEOUTCFG    0xffffffU
#define V_MSTTIMEOUTCFG(x) ((x) << S_MSTTIMEOUTCFG)
#define G_MSTTIMEOUTCFG(x) (((x) >> S_MSTTIMEOUTCFG) & M_MSTTIMEOUTCFG)

#define A_SMB_MST_CTL_CFG 0x19068

#define S_MSTFIFODBG    31
#define V_MSTFIFODBG(x) ((x) << S_MSTFIFODBG)
#define F_MSTFIFODBG    V_MSTFIFODBG(1U)

#define S_MSTFIFODBGCLR    30
#define V_MSTFIFODBGCLR(x) ((x) << S_MSTFIFODBGCLR)
#define F_MSTFIFODBGCLR    V_MSTFIFODBGCLR(1U)

#define S_MSTRXBYTECFG    12
#define M_MSTRXBYTECFG    0x3fU
#define V_MSTRXBYTECFG(x) ((x) << S_MSTRXBYTECFG)
#define G_MSTRXBYTECFG(x) (((x) >> S_MSTRXBYTECFG) & M_MSTRXBYTECFG)

#define S_MSTTXBYTECFG    6
#define M_MSTTXBYTECFG    0x3fU
#define V_MSTTXBYTECFG(x) ((x) << S_MSTTXBYTECFG)
#define G_MSTTXBYTECFG(x) (((x) >> S_MSTTXBYTECFG) & M_MSTTXBYTECFG)

#define S_MSTRESET    1
#define V_MSTRESET(x) ((x) << S_MSTRESET)
#define F_MSTRESET    V_MSTRESET(1U)

#define S_MSTCTLEN    0
#define V_MSTCTLEN(x) ((x) << S_MSTCTLEN)
#define F_MSTCTLEN    V_MSTCTLEN(1U)

#define A_SMB_MST_CTL_STS 0x1906c

#define S_MSTRXBYTECNT    12
#define M_MSTRXBYTECNT    0x3fU
#define V_MSTRXBYTECNT(x) ((x) << S_MSTRXBYTECNT)
#define G_MSTRXBYTECNT(x) (((x) >> S_MSTRXBYTECNT) & M_MSTRXBYTECNT)

#define S_MSTTXBYTECNT    6
#define M_MSTTXBYTECNT    0x3fU
#define V_MSTTXBYTECNT(x) ((x) << S_MSTTXBYTECNT)
#define G_MSTTXBYTECNT(x) (((x) >> S_MSTTXBYTECNT) & M_MSTTXBYTECNT)

#define S_MSTBUSYSTS    0
#define V_MSTBUSYSTS(x) ((x) << S_MSTBUSYSTS)
#define F_MSTBUSYSTS    V_MSTBUSYSTS(1U)

#define A_SMB_MST_TX_FIFO_RDWR 0x19070
#define A_SMB_MST_RX_FIFO_RDWR 0x19074
#define A_SMB_SLV_TIMEOUT_CFG 0x19078

#define S_SLVTIMEOUTCFG    0
#define M_SLVTIMEOUTCFG    0xffffffU
#define V_SLVTIMEOUTCFG(x) ((x) << S_SLVTIMEOUTCFG)
#define G_SLVTIMEOUTCFG(x) (((x) >> S_SLVTIMEOUTCFG) & M_SLVTIMEOUTCFG)

#define A_SMB_SLV_CTL_CFG 0x1907c

#define S_SLVFIFODBG    31
#define V_SLVFIFODBG(x) ((x) << S_SLVFIFODBG)
#define F_SLVFIFODBG    V_SLVFIFODBG(1U)

#define S_SLVFIFODBGCLR    30
#define V_SLVFIFODBGCLR(x) ((x) << S_SLVFIFODBGCLR)
#define F_SLVFIFODBGCLR    V_SLVFIFODBGCLR(1U)

#define S_SLVCRCOUTBITINV    21
#define V_SLVCRCOUTBITINV(x) ((x) << S_SLVCRCOUTBITINV)
#define F_SLVCRCOUTBITINV    V_SLVCRCOUTBITINV(1U)

#define S_SLVCRCOUTBITREV    20
#define V_SLVCRCOUTBITREV(x) ((x) << S_SLVCRCOUTBITREV)
#define F_SLVCRCOUTBITREV    V_SLVCRCOUTBITREV(1U)

#define S_SLVCRCINBITREV    19
#define V_SLVCRCINBITREV(x) ((x) << S_SLVCRCINBITREV)
#define F_SLVCRCINBITREV    V_SLVCRCINBITREV(1U)

#define S_SLVCRCPRESET    11
#define M_SLVCRCPRESET    0xffU
#define V_SLVCRCPRESET(x) ((x) << S_SLVCRCPRESET)
#define G_SLVCRCPRESET(x) (((x) >> S_SLVCRCPRESET) & M_SLVCRCPRESET)

#define S_SLVADDRCFG    4
#define M_SLVADDRCFG    0x7fU
#define V_SLVADDRCFG(x) ((x) << S_SLVADDRCFG)
#define G_SLVADDRCFG(x) (((x) >> S_SLVADDRCFG) & M_SLVADDRCFG)

#define S_SLVALRTSET    2
#define V_SLVALRTSET(x) ((x) << S_SLVALRTSET)
#define F_SLVALRTSET    V_SLVALRTSET(1U)

#define S_SLVRESET    1
#define V_SLVRESET(x) ((x) << S_SLVRESET)
#define F_SLVRESET    V_SLVRESET(1U)

#define S_SLVCTLEN    0
#define V_SLVCTLEN(x) ((x) << S_SLVCTLEN)
#define F_SLVCTLEN    V_SLVCTLEN(1U)

#define A_SMB_SLV_CTL_STS 0x19080

#define S_SLVFIFOTXCNT    12
#define M_SLVFIFOTXCNT    0x3fU
#define V_SLVFIFOTXCNT(x) ((x) << S_SLVFIFOTXCNT)
#define G_SLVFIFOTXCNT(x) (((x) >> S_SLVFIFOTXCNT) & M_SLVFIFOTXCNT)

#define S_SLVFIFOCNT    6
#define M_SLVFIFOCNT    0x3fU
#define V_SLVFIFOCNT(x) ((x) << S_SLVFIFOCNT)
#define G_SLVFIFOCNT(x) (((x) >> S_SLVFIFOCNT) & M_SLVFIFOCNT)

#define S_SLVALRTSTS    2
#define V_SLVALRTSTS(x) ((x) << S_SLVALRTSTS)
#define F_SLVALRTSTS    V_SLVALRTSTS(1U)

#define S_SLVBUSYSTS    0
#define V_SLVBUSYSTS(x) ((x) << S_SLVBUSYSTS)
#define F_SLVBUSYSTS    V_SLVBUSYSTS(1U)

#define A_SMB_SLV_FIFO_RDWR 0x19084
#define A_SMB_INT_ENABLE 0x1908c

#define S_MSTTXFIFOPAREN    21
#define V_MSTTXFIFOPAREN(x) ((x) << S_MSTTXFIFOPAREN)
#define F_MSTTXFIFOPAREN    V_MSTTXFIFOPAREN(1U)

#define S_MSTRXFIFOPAREN    20
#define V_MSTRXFIFOPAREN(x) ((x) << S_MSTRXFIFOPAREN)
#define F_MSTRXFIFOPAREN    V_MSTRXFIFOPAREN(1U)

#define S_SLVFIFOPAREN    19
#define V_SLVFIFOPAREN(x) ((x) << S_SLVFIFOPAREN)
#define F_SLVFIFOPAREN    V_SLVFIFOPAREN(1U)

#define S_SLVUNEXPBUSSTOPEN    18
#define V_SLVUNEXPBUSSTOPEN(x) ((x) << S_SLVUNEXPBUSSTOPEN)
#define F_SLVUNEXPBUSSTOPEN    V_SLVUNEXPBUSSTOPEN(1U)

#define S_SLVUNEXPBUSSTARTEN    17
#define V_SLVUNEXPBUSSTARTEN(x) ((x) << S_SLVUNEXPBUSSTARTEN)
#define F_SLVUNEXPBUSSTARTEN    V_SLVUNEXPBUSSTARTEN(1U)

#define S_SLVCOMMANDCODEINVEN    16
#define V_SLVCOMMANDCODEINVEN(x) ((x) << S_SLVCOMMANDCODEINVEN)
#define F_SLVCOMMANDCODEINVEN    V_SLVCOMMANDCODEINVEN(1U)

#define S_SLVBYTECNTERREN    15
#define V_SLVBYTECNTERREN(x) ((x) << S_SLVBYTECNTERREN)
#define F_SLVBYTECNTERREN    V_SLVBYTECNTERREN(1U)

#define S_SLVUNEXPACKMSTEN    14
#define V_SLVUNEXPACKMSTEN(x) ((x) << S_SLVUNEXPACKMSTEN)
#define F_SLVUNEXPACKMSTEN    V_SLVUNEXPACKMSTEN(1U)

#define S_SLVUNEXPNACKMSTEN    13
#define V_SLVUNEXPNACKMSTEN(x) ((x) << S_SLVUNEXPNACKMSTEN)
#define F_SLVUNEXPNACKMSTEN    V_SLVUNEXPNACKMSTEN(1U)

#define S_SLVNOBUSSTOPEN    12
#define V_SLVNOBUSSTOPEN(x) ((x) << S_SLVNOBUSSTOPEN)
#define F_SLVNOBUSSTOPEN    V_SLVNOBUSSTOPEN(1U)

#define S_SLVNOREPSTARTEN    11
#define V_SLVNOREPSTARTEN(x) ((x) << S_SLVNOREPSTARTEN)
#define F_SLVNOREPSTARTEN    V_SLVNOREPSTARTEN(1U)

#define S_SLVRXADDRINTEN    10
#define V_SLVRXADDRINTEN(x) ((x) << S_SLVRXADDRINTEN)
#define F_SLVRXADDRINTEN    V_SLVRXADDRINTEN(1U)

#define S_SLVRXPECERRINTEN    9
#define V_SLVRXPECERRINTEN(x) ((x) << S_SLVRXPECERRINTEN)
#define F_SLVRXPECERRINTEN    V_SLVRXPECERRINTEN(1U)

#define S_SLVPREPTOARPINTEN    8
#define V_SLVPREPTOARPINTEN(x) ((x) << S_SLVPREPTOARPINTEN)
#define F_SLVPREPTOARPINTEN    V_SLVPREPTOARPINTEN(1U)

#define S_SLVTIMEOUTINTEN    7
#define V_SLVTIMEOUTINTEN(x) ((x) << S_SLVTIMEOUTINTEN)
#define F_SLVTIMEOUTINTEN    V_SLVTIMEOUTINTEN(1U)

#define S_SLVERRINTEN    6
#define V_SLVERRINTEN(x) ((x) << S_SLVERRINTEN)
#define F_SLVERRINTEN    V_SLVERRINTEN(1U)

#define S_SLVDONEINTEN    5
#define V_SLVDONEINTEN(x) ((x) << S_SLVDONEINTEN)
#define F_SLVDONEINTEN    V_SLVDONEINTEN(1U)

#define S_SLVRXRDYINTEN    4
#define V_SLVRXRDYINTEN(x) ((x) << S_SLVRXRDYINTEN)
#define F_SLVRXRDYINTEN    V_SLVRXRDYINTEN(1U)

#define S_MSTTIMEOUTINTEN    3
#define V_MSTTIMEOUTINTEN(x) ((x) << S_MSTTIMEOUTINTEN)
#define F_MSTTIMEOUTINTEN    V_MSTTIMEOUTINTEN(1U)

#define S_MSTNACKINTEN    2
#define V_MSTNACKINTEN(x) ((x) << S_MSTNACKINTEN)
#define F_MSTNACKINTEN    V_MSTNACKINTEN(1U)

#define S_MSTLOSTARBINTEN    1
#define V_MSTLOSTARBINTEN(x) ((x) << S_MSTLOSTARBINTEN)
#define F_MSTLOSTARBINTEN    V_MSTLOSTARBINTEN(1U)

#define S_MSTDONEINTEN    0
#define V_MSTDONEINTEN(x) ((x) << S_MSTDONEINTEN)
#define F_MSTDONEINTEN    V_MSTDONEINTEN(1U)

#define A_SMB_INT_CAUSE 0x19090

#define S_MSTTXFIFOPARINT    21
#define V_MSTTXFIFOPARINT(x) ((x) << S_MSTTXFIFOPARINT)
#define F_MSTTXFIFOPARINT    V_MSTTXFIFOPARINT(1U)

#define S_MSTRXFIFOPARINT    20
#define V_MSTRXFIFOPARINT(x) ((x) << S_MSTRXFIFOPARINT)
#define F_MSTRXFIFOPARINT    V_MSTRXFIFOPARINT(1U)

#define S_SLVFIFOPARINT    19
#define V_SLVFIFOPARINT(x) ((x) << S_SLVFIFOPARINT)
#define F_SLVFIFOPARINT    V_SLVFIFOPARINT(1U)

#define S_SLVUNEXPBUSSTOPINT    18
#define V_SLVUNEXPBUSSTOPINT(x) ((x) << S_SLVUNEXPBUSSTOPINT)
#define F_SLVUNEXPBUSSTOPINT    V_SLVUNEXPBUSSTOPINT(1U)

#define S_SLVUNEXPBUSSTARTINT    17
#define V_SLVUNEXPBUSSTARTINT(x) ((x) << S_SLVUNEXPBUSSTARTINT)
#define F_SLVUNEXPBUSSTARTINT    V_SLVUNEXPBUSSTARTINT(1U)

#define S_SLVCOMMANDCODEINVINT    16
#define V_SLVCOMMANDCODEINVINT(x) ((x) << S_SLVCOMMANDCODEINVINT)
#define F_SLVCOMMANDCODEINVINT    V_SLVCOMMANDCODEINVINT(1U)

#define S_SLVBYTECNTERRINT    15
#define V_SLVBYTECNTERRINT(x) ((x) << S_SLVBYTECNTERRINT)
#define F_SLVBYTECNTERRINT    V_SLVBYTECNTERRINT(1U)

#define S_SLVUNEXPACKMSTINT    14
#define V_SLVUNEXPACKMSTINT(x) ((x) << S_SLVUNEXPACKMSTINT)
#define F_SLVUNEXPACKMSTINT    V_SLVUNEXPACKMSTINT(1U)

#define S_SLVUNEXPNACKMSTINT    13
#define V_SLVUNEXPNACKMSTINT(x) ((x) << S_SLVUNEXPNACKMSTINT)
#define F_SLVUNEXPNACKMSTINT    V_SLVUNEXPNACKMSTINT(1U)

#define S_SLVNOBUSSTOPINT    12
#define V_SLVNOBUSSTOPINT(x) ((x) << S_SLVNOBUSSTOPINT)
#define F_SLVNOBUSSTOPINT    V_SLVNOBUSSTOPINT(1U)

#define S_SLVNOREPSTARTINT    11
#define V_SLVNOREPSTARTINT(x) ((x) << S_SLVNOREPSTARTINT)
#define F_SLVNOREPSTARTINT    V_SLVNOREPSTARTINT(1U)

#define S_SLVRXADDRINT    10
#define V_SLVRXADDRINT(x) ((x) << S_SLVRXADDRINT)
#define F_SLVRXADDRINT    V_SLVRXADDRINT(1U)

#define S_SLVRXPECERRINT    9
#define V_SLVRXPECERRINT(x) ((x) << S_SLVRXPECERRINT)
#define F_SLVRXPECERRINT    V_SLVRXPECERRINT(1U)

#define S_SLVPREPTOARPINT    8
#define V_SLVPREPTOARPINT(x) ((x) << S_SLVPREPTOARPINT)
#define F_SLVPREPTOARPINT    V_SLVPREPTOARPINT(1U)

#define S_SLVTIMEOUTINT    7
#define V_SLVTIMEOUTINT(x) ((x) << S_SLVTIMEOUTINT)
#define F_SLVTIMEOUTINT    V_SLVTIMEOUTINT(1U)

#define S_SLVERRINT    6
#define V_SLVERRINT(x) ((x) << S_SLVERRINT)
#define F_SLVERRINT    V_SLVERRINT(1U)

#define S_SLVDONEINT    5
#define V_SLVDONEINT(x) ((x) << S_SLVDONEINT)
#define F_SLVDONEINT    V_SLVDONEINT(1U)

#define S_SLVRXRDYINT    4
#define V_SLVRXRDYINT(x) ((x) << S_SLVRXRDYINT)
#define F_SLVRXRDYINT    V_SLVRXRDYINT(1U)

#define S_MSTTIMEOUTINT    3
#define V_MSTTIMEOUTINT(x) ((x) << S_MSTTIMEOUTINT)
#define F_MSTTIMEOUTINT    V_MSTTIMEOUTINT(1U)

#define S_MSTNACKINT    2
#define V_MSTNACKINT(x) ((x) << S_MSTNACKINT)
#define F_MSTNACKINT    V_MSTNACKINT(1U)

#define S_MSTLOSTARBINT    1
#define V_MSTLOSTARBINT(x) ((x) << S_MSTLOSTARBINT)
#define F_MSTLOSTARBINT    V_MSTLOSTARBINT(1U)

#define S_MSTDONEINT    0
#define V_MSTDONEINT(x) ((x) << S_MSTDONEINT)
#define F_MSTDONEINT    V_MSTDONEINT(1U)

#define A_SMB_DEBUG_DATA 0x19094

#define S_DEBUGDATAH    16
#define M_DEBUGDATAH    0xffffU
#define V_DEBUGDATAH(x) ((x) << S_DEBUGDATAH)
#define G_DEBUGDATAH(x) (((x) >> S_DEBUGDATAH) & M_DEBUGDATAH)

#define S_DEBUGDATAL    0
#define M_DEBUGDATAL    0xffffU
#define V_DEBUGDATAL(x) ((x) << S_DEBUGDATAL)
#define G_DEBUGDATAL(x) (((x) >> S_DEBUGDATAL) & M_DEBUGDATAL)

#define A_SMB_PERR_EN 0x19098

#define S_MSTTXFIFOPERREN    2
#define V_MSTTXFIFOPERREN(x) ((x) << S_MSTTXFIFOPERREN)
#define F_MSTTXFIFOPERREN    V_MSTTXFIFOPERREN(1U)

#define S_MSTRXFIFOPERREN    1
#define V_MSTRXFIFOPERREN(x) ((x) << S_MSTRXFIFOPERREN)
#define F_MSTRXFIFOPERREN    V_MSTRXFIFOPERREN(1U)

#define S_SLVFIFOPERREN    0
#define V_SLVFIFOPERREN(x) ((x) << S_SLVFIFOPERREN)
#define F_SLVFIFOPERREN    V_SLVFIFOPERREN(1U)

#define S_MSTTXFIFO    21
#define V_MSTTXFIFO(x) ((x) << S_MSTTXFIFO)
#define F_MSTTXFIFO    V_MSTTXFIFO(1U)

#define S_MSTRXFIFO    19
#define V_MSTRXFIFO(x) ((x) << S_MSTRXFIFO)
#define F_MSTRXFIFO    V_MSTRXFIFO(1U)

#define S_SLVFIFO    18
#define V_SLVFIFO(x) ((x) << S_SLVFIFO)
#define F_SLVFIFO    V_SLVFIFO(1U)

#define A_SMB_PERR_INJ 0x1909c

#define S_MSTTXINJDATAERR    3
#define V_MSTTXINJDATAERR(x) ((x) << S_MSTTXINJDATAERR)
#define F_MSTTXINJDATAERR    V_MSTTXINJDATAERR(1U)

#define S_MSTRXINJDATAERR    2
#define V_MSTRXINJDATAERR(x) ((x) << S_MSTRXINJDATAERR)
#define F_MSTRXINJDATAERR    V_MSTRXINJDATAERR(1U)

#define S_SLVINJDATAERR    1
#define V_SLVINJDATAERR(x) ((x) << S_SLVINJDATAERR)
#define F_SLVINJDATAERR    V_SLVINJDATAERR(1U)

#define S_FIFOINJDATAERREN    0
#define V_FIFOINJDATAERREN(x) ((x) << S_FIFOINJDATAERREN)
#define F_FIFOINJDATAERREN    V_FIFOINJDATAERREN(1U)

#define A_SMB_SLV_ARP_CTL 0x190a0

#define S_ARPCOMMANDCODE    2
#define M_ARPCOMMANDCODE    0xffU
#define V_ARPCOMMANDCODE(x) ((x) << S_ARPCOMMANDCODE)
#define G_ARPCOMMANDCODE(x) (((x) >> S_ARPCOMMANDCODE) & M_ARPCOMMANDCODE)

#define S_ARPADDRRES    1
#define V_ARPADDRRES(x) ((x) << S_ARPADDRRES)
#define F_ARPADDRRES    V_ARPADDRRES(1U)

#define S_ARPADDRVAL    0
#define V_ARPADDRVAL(x) ((x) << S_ARPADDRVAL)
#define F_ARPADDRVAL    V_ARPADDRVAL(1U)

#define A_SMB_ARP_UDID0 0x190a4
#define A_SMB_ARP_UDID1 0x190a8

#define S_SUBSYSTEMVENDORID    16
#define M_SUBSYSTEMVENDORID    0xffffU
#define V_SUBSYSTEMVENDORID(x) ((x) << S_SUBSYSTEMVENDORID)
#define G_SUBSYSTEMVENDORID(x) (((x) >> S_SUBSYSTEMVENDORID) & M_SUBSYSTEMVENDORID)

#define S_SUBSYSTEMDEVICEID    0
#define M_SUBSYSTEMDEVICEID    0xffffU
#define V_SUBSYSTEMDEVICEID(x) ((x) << S_SUBSYSTEMDEVICEID)
#define G_SUBSYSTEMDEVICEID(x) (((x) >> S_SUBSYSTEMDEVICEID) & M_SUBSYSTEMDEVICEID)

#define A_SMB_ARP_UDID2 0x190ac

#define S_DEVICEID    16
#define M_DEVICEID    0xffffU
#define V_DEVICEID(x) ((x) << S_DEVICEID)
#define G_DEVICEID(x) (((x) >> S_DEVICEID) & M_DEVICEID)

#define S_INTERFACE    0
#define M_INTERFACE    0xffffU
#define V_INTERFACE(x) ((x) << S_INTERFACE)
#define G_INTERFACE(x) (((x) >> S_INTERFACE) & M_INTERFACE)

#define A_SMB_ARP_UDID3 0x190b0

#define S_DEVICECAP    24
#define M_DEVICECAP    0xffU
#define V_DEVICECAP(x) ((x) << S_DEVICECAP)
#define G_DEVICECAP(x) (((x) >> S_DEVICECAP) & M_DEVICECAP)

#define S_VERSIONID    16
#define M_VERSIONID    0xffU
#define V_VERSIONID(x) ((x) << S_VERSIONID)
#define G_VERSIONID(x) (((x) >> S_VERSIONID) & M_VERSIONID)

#define S_VENDORID    0
#define M_VENDORID    0xffffU
#define V_VENDORID(x) ((x) << S_VENDORID)
#define G_VENDORID(x) (((x) >> S_VENDORID) & M_VENDORID)

#define A_SMB_SLV_AUX_ADDR0 0x190b4

#define S_AUXADDR0VAL    6
#define V_AUXADDR0VAL(x) ((x) << S_AUXADDR0VAL)
#define F_AUXADDR0VAL    V_AUXADDR0VAL(1U)

#define S_AUXADDR0    0
#define M_AUXADDR0    0x3fU
#define V_AUXADDR0(x) ((x) << S_AUXADDR0)
#define G_AUXADDR0(x) (((x) >> S_AUXADDR0) & M_AUXADDR0)

#define A_SMB_SLV_AUX_ADDR1 0x190b8

#define S_AUXADDR1VAL    6
#define V_AUXADDR1VAL(x) ((x) << S_AUXADDR1VAL)
#define F_AUXADDR1VAL    V_AUXADDR1VAL(1U)

#define S_AUXADDR1    0
#define M_AUXADDR1    0x3fU
#define V_AUXADDR1(x) ((x) << S_AUXADDR1)
#define G_AUXADDR1(x) (((x) >> S_AUXADDR1) & M_AUXADDR1)

#define A_SMB_SLV_AUX_ADDR2 0x190bc

#define S_AUXADDR2VAL    6
#define V_AUXADDR2VAL(x) ((x) << S_AUXADDR2VAL)
#define F_AUXADDR2VAL    V_AUXADDR2VAL(1U)

#define S_AUXADDR2    0
#define M_AUXADDR2    0x3fU
#define V_AUXADDR2(x) ((x) << S_AUXADDR2)
#define G_AUXADDR2(x) (((x) >> S_AUXADDR2) & M_AUXADDR2)

#define A_SMB_SLV_AUX_ADDR3 0x190c0

#define S_AUXADDR3VAL    6
#define V_AUXADDR3VAL(x) ((x) << S_AUXADDR3VAL)
#define F_AUXADDR3VAL    V_AUXADDR3VAL(1U)

#define S_AUXADDR3    0
#define M_AUXADDR3    0x3fU
#define V_AUXADDR3(x) ((x) << S_AUXADDR3)
#define G_AUXADDR3(x) (((x) >> S_AUXADDR3) & M_AUXADDR3)

#define A_SMB_COMMAND_CODE0 0x190c4

#define S_SMBUSCOMMANDCODE0    0
#define M_SMBUSCOMMANDCODE0    0xffU
#define V_SMBUSCOMMANDCODE0(x) ((x) << S_SMBUSCOMMANDCODE0)
#define G_SMBUSCOMMANDCODE0(x) (((x) >> S_SMBUSCOMMANDCODE0) & M_SMBUSCOMMANDCODE0)

#define A_SMB_COMMAND_CODE1 0x190c8

#define S_SMBUSCOMMANDCODE1    0
#define M_SMBUSCOMMANDCODE1    0xffU
#define V_SMBUSCOMMANDCODE1(x) ((x) << S_SMBUSCOMMANDCODE1)
#define G_SMBUSCOMMANDCODE1(x) (((x) >> S_SMBUSCOMMANDCODE1) & M_SMBUSCOMMANDCODE1)

#define A_SMB_COMMAND_CODE2 0x190cc

#define S_SMBUSCOMMANDCODE2    0
#define M_SMBUSCOMMANDCODE2    0xffU
#define V_SMBUSCOMMANDCODE2(x) ((x) << S_SMBUSCOMMANDCODE2)
#define G_SMBUSCOMMANDCODE2(x) (((x) >> S_SMBUSCOMMANDCODE2) & M_SMBUSCOMMANDCODE2)

#define A_SMB_COMMAND_CODE3 0x190d0

#define S_SMBUSCOMMANDCODE3    0
#define M_SMBUSCOMMANDCODE3    0xffU
#define V_SMBUSCOMMANDCODE3(x) ((x) << S_SMBUSCOMMANDCODE3)
#define G_SMBUSCOMMANDCODE3(x) (((x) >> S_SMBUSCOMMANDCODE3) & M_SMBUSCOMMANDCODE3)

#define A_SMB_COMMAND_CODE4 0x190d4

#define S_SMBUSCOMMANDCODE4    0
#define M_SMBUSCOMMANDCODE4    0xffU
#define V_SMBUSCOMMANDCODE4(x) ((x) << S_SMBUSCOMMANDCODE4)
#define G_SMBUSCOMMANDCODE4(x) (((x) >> S_SMBUSCOMMANDCODE4) & M_SMBUSCOMMANDCODE4)

#define A_SMB_COMMAND_CODE5 0x190d8

#define S_SMBUSCOMMANDCODE5    0
#define M_SMBUSCOMMANDCODE5    0xffU
#define V_SMBUSCOMMANDCODE5(x) ((x) << S_SMBUSCOMMANDCODE5)
#define G_SMBUSCOMMANDCODE5(x) (((x) >> S_SMBUSCOMMANDCODE5) & M_SMBUSCOMMANDCODE5)

#define A_SMB_COMMAND_CODE6 0x190dc

#define S_SMBUSCOMMANDCODE6    0
#define M_SMBUSCOMMANDCODE6    0xffU
#define V_SMBUSCOMMANDCODE6(x) ((x) << S_SMBUSCOMMANDCODE6)
#define G_SMBUSCOMMANDCODE6(x) (((x) >> S_SMBUSCOMMANDCODE6) & M_SMBUSCOMMANDCODE6)

#define A_SMB_COMMAND_CODE7 0x190e0

#define S_SMBUSCOMMANDCODE7    0
#define M_SMBUSCOMMANDCODE7    0xffU
#define V_SMBUSCOMMANDCODE7(x) ((x) << S_SMBUSCOMMANDCODE7)
#define G_SMBUSCOMMANDCODE7(x) (((x) >> S_SMBUSCOMMANDCODE7) & M_SMBUSCOMMANDCODE7)

#define A_SMB_MICRO_CNT_CLK_CFG 0x190e4

#define S_MACROCNTCLKCFG    8
#define M_MACROCNTCLKCFG    0x1fU
#define V_MACROCNTCLKCFG(x) ((x) << S_MACROCNTCLKCFG)
#define G_MACROCNTCLKCFG(x) (((x) >> S_MACROCNTCLKCFG) & M_MACROCNTCLKCFG)

#define S_MICROCNTCLKCFG    0
#define M_MICROCNTCLKCFG    0xffU
#define V_MICROCNTCLKCFG(x) ((x) << S_MICROCNTCLKCFG)
#define G_MICROCNTCLKCFG(x) (((x) >> S_MICROCNTCLKCFG) & M_MICROCNTCLKCFG)

#define A_SMB_CTL_STATUS 0x190e8

#define S_MSTBUSBUSY    2
#define V_MSTBUSBUSY(x) ((x) << S_MSTBUSBUSY)
#define F_MSTBUSBUSY    V_MSTBUSBUSY(1U)

#define S_SLVBUSBUSY    1
#define V_SLVBUSBUSY(x) ((x) << S_SLVBUSBUSY)
#define F_SLVBUSBUSY    V_SLVBUSBUSY(1U)

#define S_BUSBUSY    0
#define V_BUSBUSY(x) ((x) << S_BUSBUSY)
#define F_BUSBUSY    V_BUSBUSY(1U)

/* registers for module I2CM */
#define I2CM_BASE_ADDR 0x190f0

#define A_I2CM_CFG 0x190f0

#define S_I2C_CLKDIV    0
#define M_I2C_CLKDIV    0xfffU
#define V_I2C_CLKDIV(x) ((x) << S_I2C_CLKDIV)
#define G_I2C_CLKDIV(x) (((x) >> S_I2C_CLKDIV) & M_I2C_CLKDIV)

#define S_I2C_CLKDIV16B    0
#define M_I2C_CLKDIV16B    0xffffU
#define V_I2C_CLKDIV16B(x) ((x) << S_I2C_CLKDIV16B)
#define G_I2C_CLKDIV16B(x) (((x) >> S_I2C_CLKDIV16B) & M_I2C_CLKDIV16B)

#define A_I2CM_DATA 0x190f4

#define S_I2C_DATA    0
#define M_I2C_DATA    0xffU
#define V_I2C_DATA(x) ((x) << S_I2C_DATA)
#define G_I2C_DATA(x) (((x) >> S_I2C_DATA) & M_I2C_DATA)

#define A_I2CM_OP 0x190f8

#define S_I2C_ACK    30
#define V_I2C_ACK(x) ((x) << S_I2C_ACK)
#define F_I2C_ACK    V_I2C_ACK(1U)

#define S_I2C_CONT    1
#define V_I2C_CONT(x) ((x) << S_I2C_CONT)
#define F_I2C_CONT    V_I2C_CONT(1U)

#define S_OP    0
#define V_OP(x) ((x) << S_OP)
#define F_OP    V_OP(1U)

/* registers for module MI */
#define MI_BASE_ADDR 0x19100

#define A_MI_CFG 0x19100

#define S_T4_ST    14
#define V_T4_ST(x) ((x) << S_T4_ST)
#define F_T4_ST    V_T4_ST(1U)

#define S_CLKDIV    5
#define M_CLKDIV    0xffU
#define V_CLKDIV(x) ((x) << S_CLKDIV)
#define G_CLKDIV(x) (((x) >> S_CLKDIV) & M_CLKDIV)

#define S_ST    3
#define M_ST    0x3U
#define V_ST(x) ((x) << S_ST)
#define G_ST(x) (((x) >> S_ST) & M_ST)

#define S_PREEN    2
#define V_PREEN(x) ((x) << S_PREEN)
#define F_PREEN    V_PREEN(1U)

#define S_MDIINV    1
#define V_MDIINV(x) ((x) << S_MDIINV)
#define F_MDIINV    V_MDIINV(1U)

#define S_MDIO_1P2V_SEL    0
#define V_MDIO_1P2V_SEL(x) ((x) << S_MDIO_1P2V_SEL)
#define F_MDIO_1P2V_SEL    V_MDIO_1P2V_SEL(1U)

#define A_MI_ADDR 0x19104

#define S_PHYADDR    5
#define M_PHYADDR    0x1fU
#define V_PHYADDR(x) ((x) << S_PHYADDR)
#define G_PHYADDR(x) (((x) >> S_PHYADDR) & M_PHYADDR)

#define S_REGADDR    0
#define M_REGADDR    0x1fU
#define V_REGADDR(x) ((x) << S_REGADDR)
#define G_REGADDR(x) (((x) >> S_REGADDR) & M_REGADDR)

#define A_MI_DATA 0x19108

#define S_MDIDATA    0
#define M_MDIDATA    0xffffU
#define V_MDIDATA(x) ((x) << S_MDIDATA)
#define G_MDIDATA(x) (((x) >> S_MDIDATA) & M_MDIDATA)

#define A_MI_OP 0x1910c

#define S_INC    2
#define V_INC(x) ((x) << S_INC)
#define F_INC    V_INC(1U)

#define S_MDIOP    0
#define M_MDIOP    0x3U
#define V_MDIOP(x) ((x) << S_MDIOP)
#define G_MDIOP(x) (((x) >> S_MDIOP) & M_MDIOP)

/* registers for module UART */
#define UART_BASE_ADDR 0x19110

#define A_UART_CONFIG 0x19110

#define S_STOPBITS    22
#define M_STOPBITS    0x3U
#define V_STOPBITS(x) ((x) << S_STOPBITS)
#define G_STOPBITS(x) (((x) >> S_STOPBITS) & M_STOPBITS)

#define S_PARITY    20
#define M_PARITY    0x3U
#define V_PARITY(x) ((x) << S_PARITY)
#define G_PARITY(x) (((x) >> S_PARITY) & M_PARITY)

#define S_DATABITS    16
#define M_DATABITS    0xfU
#define V_DATABITS(x) ((x) << S_DATABITS)
#define G_DATABITS(x) (((x) >> S_DATABITS) & M_DATABITS)

#define S_UART_CLKDIV    0
#define M_UART_CLKDIV    0xfffU
#define V_UART_CLKDIV(x) ((x) << S_UART_CLKDIV)
#define G_UART_CLKDIV(x) (((x) >> S_UART_CLKDIV) & M_UART_CLKDIV)

/* registers for module PMU */
#define PMU_BASE_ADDR 0x19120

#define A_PMU_PART_CG_PWRMODE 0x19120

#define S_TPPARTCGEN    14
#define V_TPPARTCGEN(x) ((x) << S_TPPARTCGEN)
#define F_TPPARTCGEN    V_TPPARTCGEN(1U)

#define S_PDPPARTCGEN    13
#define V_PDPPARTCGEN(x) ((x) << S_PDPPARTCGEN)
#define F_PDPPARTCGEN    V_PDPPARTCGEN(1U)

#define S_PCIEPARTCGEN    12
#define V_PCIEPARTCGEN(x) ((x) << S_PCIEPARTCGEN)
#define F_PCIEPARTCGEN    V_PCIEPARTCGEN(1U)

#define S_EDC1PARTCGEN    11
#define V_EDC1PARTCGEN(x) ((x) << S_EDC1PARTCGEN)
#define F_EDC1PARTCGEN    V_EDC1PARTCGEN(1U)

#define S_MCPARTCGEN    10
#define V_MCPARTCGEN(x) ((x) << S_MCPARTCGEN)
#define F_MCPARTCGEN    V_MCPARTCGEN(1U)

#define S_EDC0PARTCGEN    9
#define V_EDC0PARTCGEN(x) ((x) << S_EDC0PARTCGEN)
#define F_EDC0PARTCGEN    V_EDC0PARTCGEN(1U)

#define S_LEPARTCGEN    8
#define V_LEPARTCGEN(x) ((x) << S_LEPARTCGEN)
#define F_LEPARTCGEN    V_LEPARTCGEN(1U)

#define S_INITPOWERMODE    0
#define M_INITPOWERMODE    0x3U
#define V_INITPOWERMODE(x) ((x) << S_INITPOWERMODE)
#define G_INITPOWERMODE(x) (((x) >> S_INITPOWERMODE) & M_INITPOWERMODE)

#define S_SGE_PART_CGEN    19
#define V_SGE_PART_CGEN(x) ((x) << S_SGE_PART_CGEN)
#define F_SGE_PART_CGEN    V_SGE_PART_CGEN(1U)

#define S_PDP_PART_CGEN    18
#define V_PDP_PART_CGEN(x) ((x) << S_PDP_PART_CGEN)
#define F_PDP_PART_CGEN    V_PDP_PART_CGEN(1U)

#define S_TP_PART_CGEN    17
#define V_TP_PART_CGEN(x) ((x) << S_TP_PART_CGEN)
#define F_TP_PART_CGEN    V_TP_PART_CGEN(1U)

#define S_EDC0_PART_CGEN    16
#define V_EDC0_PART_CGEN(x) ((x) << S_EDC0_PART_CGEN)
#define F_EDC0_PART_CGEN    V_EDC0_PART_CGEN(1U)

#define S_EDC1_PART_CGEN    15
#define V_EDC1_PART_CGEN(x) ((x) << S_EDC1_PART_CGEN)
#define F_EDC1_PART_CGEN    V_EDC1_PART_CGEN(1U)

#define S_LE_PART_CGEN    14
#define V_LE_PART_CGEN(x) ((x) << S_LE_PART_CGEN)
#define F_LE_PART_CGEN    V_LE_PART_CGEN(1U)

#define S_MA_PART_CGEN    13
#define V_MA_PART_CGEN(x) ((x) << S_MA_PART_CGEN)
#define F_MA_PART_CGEN    V_MA_PART_CGEN(1U)

#define S_MC0_PART_CGEN    12
#define V_MC0_PART_CGEN(x) ((x) << S_MC0_PART_CGEN)
#define F_MC0_PART_CGEN    V_MC0_PART_CGEN(1U)

#define S_MC1_PART_CGEN    11
#define V_MC1_PART_CGEN(x) ((x) << S_MC1_PART_CGEN)
#define F_MC1_PART_CGEN    V_MC1_PART_CGEN(1U)

#define S_PCIE_PART_CGEN    10
#define V_PCIE_PART_CGEN(x) ((x) << S_PCIE_PART_CGEN)
#define F_PCIE_PART_CGEN    V_PCIE_PART_CGEN(1U)

#define A_PMU_SLEEPMODE_WAKEUP 0x19124

#define S_HWWAKEUPEN    5
#define V_HWWAKEUPEN(x) ((x) << S_HWWAKEUPEN)
#define F_HWWAKEUPEN    V_HWWAKEUPEN(1U)

#define S_PORT3SLEEPMODE    4
#define V_PORT3SLEEPMODE(x) ((x) << S_PORT3SLEEPMODE)
#define F_PORT3SLEEPMODE    V_PORT3SLEEPMODE(1U)

#define S_PORT2SLEEPMODE    3
#define V_PORT2SLEEPMODE(x) ((x) << S_PORT2SLEEPMODE)
#define F_PORT2SLEEPMODE    V_PORT2SLEEPMODE(1U)

#define S_PORT1SLEEPMODE    2
#define V_PORT1SLEEPMODE(x) ((x) << S_PORT1SLEEPMODE)
#define F_PORT1SLEEPMODE    V_PORT1SLEEPMODE(1U)

#define S_PORT0SLEEPMODE    1
#define V_PORT0SLEEPMODE(x) ((x) << S_PORT0SLEEPMODE)
#define F_PORT0SLEEPMODE    V_PORT0SLEEPMODE(1U)

#define S_WAKEUP    0
#define V_WAKEUP(x) ((x) << S_WAKEUP)
#define F_WAKEUP    V_WAKEUP(1U)

#define S_GLOBALDEEPSLEEPEN    6
#define V_GLOBALDEEPSLEEPEN(x) ((x) << S_GLOBALDEEPSLEEPEN)
#define F_GLOBALDEEPSLEEPEN    V_GLOBALDEEPSLEEPEN(1U)

/* registers for module ULP_RX */
#define ULP_RX_BASE_ADDR 0x19150

#define A_ULP_RX_CTL 0x19150

#define S_PCMD1THRESHOLD    24
#define M_PCMD1THRESHOLD    0xffU
#define V_PCMD1THRESHOLD(x) ((x) << S_PCMD1THRESHOLD)
#define G_PCMD1THRESHOLD(x) (((x) >> S_PCMD1THRESHOLD) & M_PCMD1THRESHOLD)

#define S_PCMD0THRESHOLD    16
#define M_PCMD0THRESHOLD    0xffU
#define V_PCMD0THRESHOLD(x) ((x) << S_PCMD0THRESHOLD)
#define G_PCMD0THRESHOLD(x) (((x) >> S_PCMD0THRESHOLD) & M_PCMD0THRESHOLD)

#define S_DISABLE_0B_STAG_ERR    14
#define V_DISABLE_0B_STAG_ERR(x) ((x) << S_DISABLE_0B_STAG_ERR)
#define F_DISABLE_0B_STAG_ERR    V_DISABLE_0B_STAG_ERR(1U)

#define S_RDMA_0B_WR_OPCODE    10
#define M_RDMA_0B_WR_OPCODE    0xfU
#define V_RDMA_0B_WR_OPCODE(x) ((x) << S_RDMA_0B_WR_OPCODE)
#define G_RDMA_0B_WR_OPCODE(x) (((x) >> S_RDMA_0B_WR_OPCODE) & M_RDMA_0B_WR_OPCODE)

#define S_RDMA_0B_WR_PASS    9
#define V_RDMA_0B_WR_PASS(x) ((x) << S_RDMA_0B_WR_PASS)
#define F_RDMA_0B_WR_PASS    V_RDMA_0B_WR_PASS(1U)

#define S_STAG_RQE    8
#define V_STAG_RQE(x) ((x) << S_STAG_RQE)
#define F_STAG_RQE    V_STAG_RQE(1U)

#define S_RDMA_STATE_EN    7
#define V_RDMA_STATE_EN(x) ((x) << S_RDMA_STATE_EN)
#define F_RDMA_STATE_EN    V_RDMA_STATE_EN(1U)

#define S_CRC1_EN    6
#define V_CRC1_EN(x) ((x) << S_CRC1_EN)
#define F_CRC1_EN    V_CRC1_EN(1U)

#define S_RDMA_0B_WR_CQE    5
#define V_RDMA_0B_WR_CQE(x) ((x) << S_RDMA_0B_WR_CQE)
#define F_RDMA_0B_WR_CQE    V_RDMA_0B_WR_CQE(1U)

#define S_PCIE_ATRB_EN    4
#define V_PCIE_ATRB_EN(x) ((x) << S_PCIE_ATRB_EN)
#define F_PCIE_ATRB_EN    V_PCIE_ATRB_EN(1U)

#define S_RDMA_PERMISSIVE_MODE    3
#define V_RDMA_PERMISSIVE_MODE(x) ((x) << S_RDMA_PERMISSIVE_MODE)
#define F_RDMA_PERMISSIVE_MODE    V_RDMA_PERMISSIVE_MODE(1U)

#define S_PAGEPODME    2
#define V_PAGEPODME(x) ((x) << S_PAGEPODME)
#define F_PAGEPODME    V_PAGEPODME(1U)

#define S_ISCSITAGTCB    1
#define V_ISCSITAGTCB(x) ((x) << S_ISCSITAGTCB)
#define F_ISCSITAGTCB    V_ISCSITAGTCB(1U)

#define S_TDDPTAGTCB    0
#define V_TDDPTAGTCB(x) ((x) << S_TDDPTAGTCB)
#define F_TDDPTAGTCB    V_TDDPTAGTCB(1U)

#define A_ULP_RX_INT_ENABLE 0x19154

#define S_ENABLE_CTX_1    24
#define V_ENABLE_CTX_1(x) ((x) << S_ENABLE_CTX_1)
#define F_ENABLE_CTX_1    V_ENABLE_CTX_1(1U)

#define S_ENABLE_CTX_0    23
#define V_ENABLE_CTX_0(x) ((x) << S_ENABLE_CTX_0)
#define F_ENABLE_CTX_0    V_ENABLE_CTX_0(1U)

#define S_ENABLE_FF    22
#define V_ENABLE_FF(x) ((x) << S_ENABLE_FF)
#define F_ENABLE_FF    V_ENABLE_FF(1U)

#define S_ENABLE_APF_1    21
#define V_ENABLE_APF_1(x) ((x) << S_ENABLE_APF_1)
#define F_ENABLE_APF_1    V_ENABLE_APF_1(1U)

#define S_ENABLE_APF_0    20
#define V_ENABLE_APF_0(x) ((x) << S_ENABLE_APF_0)
#define F_ENABLE_APF_0    V_ENABLE_APF_0(1U)

#define S_ENABLE_AF_1    19
#define V_ENABLE_AF_1(x) ((x) << S_ENABLE_AF_1)
#define F_ENABLE_AF_1    V_ENABLE_AF_1(1U)

#define S_ENABLE_AF_0    18
#define V_ENABLE_AF_0(x) ((x) << S_ENABLE_AF_0)
#define F_ENABLE_AF_0    V_ENABLE_AF_0(1U)

#define S_ENABLE_DDPDF_1    17
#define V_ENABLE_DDPDF_1(x) ((x) << S_ENABLE_DDPDF_1)
#define F_ENABLE_DDPDF_1    V_ENABLE_DDPDF_1(1U)

#define S_ENABLE_DDPMF_1    16
#define V_ENABLE_DDPMF_1(x) ((x) << S_ENABLE_DDPMF_1)
#define F_ENABLE_DDPMF_1    V_ENABLE_DDPMF_1(1U)

#define S_ENABLE_MEMRF_1    15
#define V_ENABLE_MEMRF_1(x) ((x) << S_ENABLE_MEMRF_1)
#define F_ENABLE_MEMRF_1    V_ENABLE_MEMRF_1(1U)

#define S_ENABLE_PRSDF_1    14
#define V_ENABLE_PRSDF_1(x) ((x) << S_ENABLE_PRSDF_1)
#define F_ENABLE_PRSDF_1    V_ENABLE_PRSDF_1(1U)

#define S_ENABLE_DDPDF_0    13
#define V_ENABLE_DDPDF_0(x) ((x) << S_ENABLE_DDPDF_0)
#define F_ENABLE_DDPDF_0    V_ENABLE_DDPDF_0(1U)

#define S_ENABLE_DDPMF_0    12
#define V_ENABLE_DDPMF_0(x) ((x) << S_ENABLE_DDPMF_0)
#define F_ENABLE_DDPMF_0    V_ENABLE_DDPMF_0(1U)

#define S_ENABLE_MEMRF_0    11
#define V_ENABLE_MEMRF_0(x) ((x) << S_ENABLE_MEMRF_0)
#define F_ENABLE_MEMRF_0    V_ENABLE_MEMRF_0(1U)

#define S_ENABLE_PRSDF_0    10
#define V_ENABLE_PRSDF_0(x) ((x) << S_ENABLE_PRSDF_0)
#define F_ENABLE_PRSDF_0    V_ENABLE_PRSDF_0(1U)

#define S_ENABLE_PCMDF_1    9
#define V_ENABLE_PCMDF_1(x) ((x) << S_ENABLE_PCMDF_1)
#define F_ENABLE_PCMDF_1    V_ENABLE_PCMDF_1(1U)

#define S_ENABLE_TPTCF_1    8
#define V_ENABLE_TPTCF_1(x) ((x) << S_ENABLE_TPTCF_1)
#define F_ENABLE_TPTCF_1    V_ENABLE_TPTCF_1(1U)

#define S_ENABLE_DDPCF_1    7
#define V_ENABLE_DDPCF_1(x) ((x) << S_ENABLE_DDPCF_1)
#define F_ENABLE_DDPCF_1    V_ENABLE_DDPCF_1(1U)

#define S_ENABLE_MPARF_1    6
#define V_ENABLE_MPARF_1(x) ((x) << S_ENABLE_MPARF_1)
#define F_ENABLE_MPARF_1    V_ENABLE_MPARF_1(1U)

#define S_ENABLE_MPARC_1    5
#define V_ENABLE_MPARC_1(x) ((x) << S_ENABLE_MPARC_1)
#define F_ENABLE_MPARC_1    V_ENABLE_MPARC_1(1U)

#define S_ENABLE_PCMDF_0    4
#define V_ENABLE_PCMDF_0(x) ((x) << S_ENABLE_PCMDF_0)
#define F_ENABLE_PCMDF_0    V_ENABLE_PCMDF_0(1U)

#define S_ENABLE_TPTCF_0    3
#define V_ENABLE_TPTCF_0(x) ((x) << S_ENABLE_TPTCF_0)
#define F_ENABLE_TPTCF_0    V_ENABLE_TPTCF_0(1U)

#define S_ENABLE_DDPCF_0    2
#define V_ENABLE_DDPCF_0(x) ((x) << S_ENABLE_DDPCF_0)
#define F_ENABLE_DDPCF_0    V_ENABLE_DDPCF_0(1U)

#define S_ENABLE_MPARF_0    1
#define V_ENABLE_MPARF_0(x) ((x) << S_ENABLE_MPARF_0)
#define F_ENABLE_MPARF_0    V_ENABLE_MPARF_0(1U)

#define S_ENABLE_MPARC_0    0
#define V_ENABLE_MPARC_0(x) ((x) << S_ENABLE_MPARC_0)
#define F_ENABLE_MPARC_0    V_ENABLE_MPARC_0(1U)

#define S_SE_CNT_MISMATCH_1    26
#define V_SE_CNT_MISMATCH_1(x) ((x) << S_SE_CNT_MISMATCH_1)
#define F_SE_CNT_MISMATCH_1    V_SE_CNT_MISMATCH_1(1U)

#define S_SE_CNT_MISMATCH_0    25
#define V_SE_CNT_MISMATCH_0(x) ((x) << S_SE_CNT_MISMATCH_0)
#define F_SE_CNT_MISMATCH_0    V_SE_CNT_MISMATCH_0(1U)

#define A_ULP_RX_INT_CAUSE 0x19158

#define S_CAUSE_CTX_1    24
#define V_CAUSE_CTX_1(x) ((x) << S_CAUSE_CTX_1)
#define F_CAUSE_CTX_1    V_CAUSE_CTX_1(1U)

#define S_CAUSE_CTX_0    23
#define V_CAUSE_CTX_0(x) ((x) << S_CAUSE_CTX_0)
#define F_CAUSE_CTX_0    V_CAUSE_CTX_0(1U)

#define S_CAUSE_FF    22
#define V_CAUSE_FF(x) ((x) << S_CAUSE_FF)
#define F_CAUSE_FF    V_CAUSE_FF(1U)

#define S_CAUSE_APF_1    21
#define V_CAUSE_APF_1(x) ((x) << S_CAUSE_APF_1)
#define F_CAUSE_APF_1    V_CAUSE_APF_1(1U)

#define S_CAUSE_APF_0    20
#define V_CAUSE_APF_0(x) ((x) << S_CAUSE_APF_0)
#define F_CAUSE_APF_0    V_CAUSE_APF_0(1U)

#define S_CAUSE_AF_1    19
#define V_CAUSE_AF_1(x) ((x) << S_CAUSE_AF_1)
#define F_CAUSE_AF_1    V_CAUSE_AF_1(1U)

#define S_CAUSE_AF_0    18
#define V_CAUSE_AF_0(x) ((x) << S_CAUSE_AF_0)
#define F_CAUSE_AF_0    V_CAUSE_AF_0(1U)

#define S_CAUSE_DDPDF_1    17
#define V_CAUSE_DDPDF_1(x) ((x) << S_CAUSE_DDPDF_1)
#define F_CAUSE_DDPDF_1    V_CAUSE_DDPDF_1(1U)

#define S_CAUSE_DDPMF_1    16
#define V_CAUSE_DDPMF_1(x) ((x) << S_CAUSE_DDPMF_1)
#define F_CAUSE_DDPMF_1    V_CAUSE_DDPMF_1(1U)

#define S_CAUSE_MEMRF_1    15
#define V_CAUSE_MEMRF_1(x) ((x) << S_CAUSE_MEMRF_1)
#define F_CAUSE_MEMRF_1    V_CAUSE_MEMRF_1(1U)

#define S_CAUSE_PRSDF_1    14
#define V_CAUSE_PRSDF_1(x) ((x) << S_CAUSE_PRSDF_1)
#define F_CAUSE_PRSDF_1    V_CAUSE_PRSDF_1(1U)

#define S_CAUSE_DDPDF_0    13
#define V_CAUSE_DDPDF_0(x) ((x) << S_CAUSE_DDPDF_0)
#define F_CAUSE_DDPDF_0    V_CAUSE_DDPDF_0(1U)

#define S_CAUSE_DDPMF_0    12
#define V_CAUSE_DDPMF_0(x) ((x) << S_CAUSE_DDPMF_0)
#define F_CAUSE_DDPMF_0    V_CAUSE_DDPMF_0(1U)

#define S_CAUSE_MEMRF_0    11
#define V_CAUSE_MEMRF_0(x) ((x) << S_CAUSE_MEMRF_0)
#define F_CAUSE_MEMRF_0    V_CAUSE_MEMRF_0(1U)

#define S_CAUSE_PRSDF_0    10
#define V_CAUSE_PRSDF_0(x) ((x) << S_CAUSE_PRSDF_0)
#define F_CAUSE_PRSDF_0    V_CAUSE_PRSDF_0(1U)

#define S_CAUSE_PCMDF_1    9
#define V_CAUSE_PCMDF_1(x) ((x) << S_CAUSE_PCMDF_1)
#define F_CAUSE_PCMDF_1    V_CAUSE_PCMDF_1(1U)

#define S_CAUSE_TPTCF_1    8
#define V_CAUSE_TPTCF_1(x) ((x) << S_CAUSE_TPTCF_1)
#define F_CAUSE_TPTCF_1    V_CAUSE_TPTCF_1(1U)

#define S_CAUSE_DDPCF_1    7
#define V_CAUSE_DDPCF_1(x) ((x) << S_CAUSE_DDPCF_1)
#define F_CAUSE_DDPCF_1    V_CAUSE_DDPCF_1(1U)

#define S_CAUSE_MPARF_1    6
#define V_CAUSE_MPARF_1(x) ((x) << S_CAUSE_MPARF_1)
#define F_CAUSE_MPARF_1    V_CAUSE_MPARF_1(1U)

#define S_CAUSE_MPARC_1    5
#define V_CAUSE_MPARC_1(x) ((x) << S_CAUSE_MPARC_1)
#define F_CAUSE_MPARC_1    V_CAUSE_MPARC_1(1U)

#define S_CAUSE_PCMDF_0    4
#define V_CAUSE_PCMDF_0(x) ((x) << S_CAUSE_PCMDF_0)
#define F_CAUSE_PCMDF_0    V_CAUSE_PCMDF_0(1U)

#define S_CAUSE_TPTCF_0    3
#define V_CAUSE_TPTCF_0(x) ((x) << S_CAUSE_TPTCF_0)
#define F_CAUSE_TPTCF_0    V_CAUSE_TPTCF_0(1U)

#define S_CAUSE_DDPCF_0    2
#define V_CAUSE_DDPCF_0(x) ((x) << S_CAUSE_DDPCF_0)
#define F_CAUSE_DDPCF_0    V_CAUSE_DDPCF_0(1U)

#define S_CAUSE_MPARF_0    1
#define V_CAUSE_MPARF_0(x) ((x) << S_CAUSE_MPARF_0)
#define F_CAUSE_MPARF_0    V_CAUSE_MPARF_0(1U)

#define S_CAUSE_MPARC_0    0
#define V_CAUSE_MPARC_0(x) ((x) << S_CAUSE_MPARC_0)
#define F_CAUSE_MPARC_0    V_CAUSE_MPARC_0(1U)

#define A_ULP_RX_ISCSI_LLIMIT 0x1915c

#define S_ISCSILLIMIT    6
#define M_ISCSILLIMIT    0x3ffffffU
#define V_ISCSILLIMIT(x) ((x) << S_ISCSILLIMIT)
#define G_ISCSILLIMIT(x) (((x) >> S_ISCSILLIMIT) & M_ISCSILLIMIT)

#define A_ULP_RX_ISCSI_ULIMIT 0x19160

#define S_ISCSIULIMIT    6
#define M_ISCSIULIMIT    0x3ffffffU
#define V_ISCSIULIMIT(x) ((x) << S_ISCSIULIMIT)
#define G_ISCSIULIMIT(x) (((x) >> S_ISCSIULIMIT) & M_ISCSIULIMIT)

#define A_ULP_RX_ISCSI_TAGMASK 0x19164

#define S_ISCSITAGMASK    6
#define M_ISCSITAGMASK    0x3ffffffU
#define V_ISCSITAGMASK(x) ((x) << S_ISCSITAGMASK)
#define G_ISCSITAGMASK(x) (((x) >> S_ISCSITAGMASK) & M_ISCSITAGMASK)

#define A_ULP_RX_ISCSI_PSZ 0x19168

#define S_HPZ3    24
#define M_HPZ3    0xfU
#define V_HPZ3(x) ((x) << S_HPZ3)
#define G_HPZ3(x) (((x) >> S_HPZ3) & M_HPZ3)

#define S_HPZ2    16
#define M_HPZ2    0xfU
#define V_HPZ2(x) ((x) << S_HPZ2)
#define G_HPZ2(x) (((x) >> S_HPZ2) & M_HPZ2)

#define S_HPZ1    8
#define M_HPZ1    0xfU
#define V_HPZ1(x) ((x) << S_HPZ1)
#define G_HPZ1(x) (((x) >> S_HPZ1) & M_HPZ1)

#define S_HPZ0    0
#define M_HPZ0    0xfU
#define V_HPZ0(x) ((x) << S_HPZ0)
#define G_HPZ0(x) (((x) >> S_HPZ0) & M_HPZ0)

#define A_ULP_RX_TDDP_LLIMIT 0x1916c

#define S_TDDPLLIMIT    6
#define M_TDDPLLIMIT    0x3ffffffU
#define V_TDDPLLIMIT(x) ((x) << S_TDDPLLIMIT)
#define G_TDDPLLIMIT(x) (((x) >> S_TDDPLLIMIT) & M_TDDPLLIMIT)

#define A_ULP_RX_TDDP_ULIMIT 0x19170

#define S_TDDPULIMIT    6
#define M_TDDPULIMIT    0x3ffffffU
#define V_TDDPULIMIT(x) ((x) << S_TDDPULIMIT)
#define G_TDDPULIMIT(x) (((x) >> S_TDDPULIMIT) & M_TDDPULIMIT)

#define A_ULP_RX_TDDP_TAGMASK 0x19174

#define S_TDDPTAGMASK    6
#define M_TDDPTAGMASK    0x3ffffffU
#define V_TDDPTAGMASK(x) ((x) << S_TDDPTAGMASK)
#define G_TDDPTAGMASK(x) (((x) >> S_TDDPTAGMASK) & M_TDDPTAGMASK)

#define A_ULP_RX_TDDP_PSZ 0x19178
#define A_ULP_RX_STAG_LLIMIT 0x1917c
#define A_ULP_RX_STAG_ULIMIT 0x19180
#define A_ULP_RX_RQ_LLIMIT 0x19184
#define A_ULP_RX_RQ_ULIMIT 0x19188
#define A_ULP_RX_PBL_LLIMIT 0x1918c
#define A_ULP_RX_PBL_ULIMIT 0x19190
#define A_ULP_RX_CTX_BASE 0x19194
#define A_ULP_RX_PERR_ENABLE 0x1919c

#define S_PERR_ENABLE_FF    22
#define V_PERR_ENABLE_FF(x) ((x) << S_PERR_ENABLE_FF)
#define F_PERR_ENABLE_FF    V_PERR_ENABLE_FF(1U)

#define S_PERR_ENABLE_APF_1    21
#define V_PERR_ENABLE_APF_1(x) ((x) << S_PERR_ENABLE_APF_1)
#define F_PERR_ENABLE_APF_1    V_PERR_ENABLE_APF_1(1U)

#define S_PERR_ENABLE_APF_0    20
#define V_PERR_ENABLE_APF_0(x) ((x) << S_PERR_ENABLE_APF_0)
#define F_PERR_ENABLE_APF_0    V_PERR_ENABLE_APF_0(1U)

#define S_PERR_ENABLE_AF_1    19
#define V_PERR_ENABLE_AF_1(x) ((x) << S_PERR_ENABLE_AF_1)
#define F_PERR_ENABLE_AF_1    V_PERR_ENABLE_AF_1(1U)

#define S_PERR_ENABLE_AF_0    18
#define V_PERR_ENABLE_AF_0(x) ((x) << S_PERR_ENABLE_AF_0)
#define F_PERR_ENABLE_AF_0    V_PERR_ENABLE_AF_0(1U)

#define S_PERR_ENABLE_DDPDF_1    17
#define V_PERR_ENABLE_DDPDF_1(x) ((x) << S_PERR_ENABLE_DDPDF_1)
#define F_PERR_ENABLE_DDPDF_1    V_PERR_ENABLE_DDPDF_1(1U)

#define S_PERR_ENABLE_DDPMF_1    16
#define V_PERR_ENABLE_DDPMF_1(x) ((x) << S_PERR_ENABLE_DDPMF_1)
#define F_PERR_ENABLE_DDPMF_1    V_PERR_ENABLE_DDPMF_1(1U)

#define S_PERR_ENABLE_MEMRF_1    15
#define V_PERR_ENABLE_MEMRF_1(x) ((x) << S_PERR_ENABLE_MEMRF_1)
#define F_PERR_ENABLE_MEMRF_1    V_PERR_ENABLE_MEMRF_1(1U)

#define S_PERR_ENABLE_PRSDF_1    14
#define V_PERR_ENABLE_PRSDF_1(x) ((x) << S_PERR_ENABLE_PRSDF_1)
#define F_PERR_ENABLE_PRSDF_1    V_PERR_ENABLE_PRSDF_1(1U)

#define S_PERR_ENABLE_DDPDF_0    13
#define V_PERR_ENABLE_DDPDF_0(x) ((x) << S_PERR_ENABLE_DDPDF_0)
#define F_PERR_ENABLE_DDPDF_0    V_PERR_ENABLE_DDPDF_0(1U)

#define S_PERR_ENABLE_DDPMF_0    12
#define V_PERR_ENABLE_DDPMF_0(x) ((x) << S_PERR_ENABLE_DDPMF_0)
#define F_PERR_ENABLE_DDPMF_0    V_PERR_ENABLE_DDPMF_0(1U)

#define S_PERR_ENABLE_MEMRF_0    11
#define V_PERR_ENABLE_MEMRF_0(x) ((x) << S_PERR_ENABLE_MEMRF_0)
#define F_PERR_ENABLE_MEMRF_0    V_PERR_ENABLE_MEMRF_0(1U)

#define S_PERR_ENABLE_PRSDF_0    10
#define V_PERR_ENABLE_PRSDF_0(x) ((x) << S_PERR_ENABLE_PRSDF_0)
#define F_PERR_ENABLE_PRSDF_0    V_PERR_ENABLE_PRSDF_0(1U)

#define S_PERR_ENABLE_PCMDF_1    9
#define V_PERR_ENABLE_PCMDF_1(x) ((x) << S_PERR_ENABLE_PCMDF_1)
#define F_PERR_ENABLE_PCMDF_1    V_PERR_ENABLE_PCMDF_1(1U)

#define S_PERR_ENABLE_TPTCF_1    8
#define V_PERR_ENABLE_TPTCF_1(x) ((x) << S_PERR_ENABLE_TPTCF_1)
#define F_PERR_ENABLE_TPTCF_1    V_PERR_ENABLE_TPTCF_1(1U)

#define S_PERR_ENABLE_DDPCF_1    7
#define V_PERR_ENABLE_DDPCF_1(x) ((x) << S_PERR_ENABLE_DDPCF_1)
#define F_PERR_ENABLE_DDPCF_1    V_PERR_ENABLE_DDPCF_1(1U)

#define S_PERR_ENABLE_MPARF_1    6
#define V_PERR_ENABLE_MPARF_1(x) ((x) << S_PERR_ENABLE_MPARF_1)
#define F_PERR_ENABLE_MPARF_1    V_PERR_ENABLE_MPARF_1(1U)

#define S_PERR_ENABLE_MPARC_1    5
#define V_PERR_ENABLE_MPARC_1(x) ((x) << S_PERR_ENABLE_MPARC_1)
#define F_PERR_ENABLE_MPARC_1    V_PERR_ENABLE_MPARC_1(1U)

#define S_PERR_ENABLE_PCMDF_0    4
#define V_PERR_ENABLE_PCMDF_0(x) ((x) << S_PERR_ENABLE_PCMDF_0)
#define F_PERR_ENABLE_PCMDF_0    V_PERR_ENABLE_PCMDF_0(1U)

#define S_PERR_ENABLE_TPTCF_0    3
#define V_PERR_ENABLE_TPTCF_0(x) ((x) << S_PERR_ENABLE_TPTCF_0)
#define F_PERR_ENABLE_TPTCF_0    V_PERR_ENABLE_TPTCF_0(1U)

#define S_PERR_ENABLE_DDPCF_0    2
#define V_PERR_ENABLE_DDPCF_0(x) ((x) << S_PERR_ENABLE_DDPCF_0)
#define F_PERR_ENABLE_DDPCF_0    V_PERR_ENABLE_DDPCF_0(1U)

#define S_PERR_ENABLE_MPARF_0    1
#define V_PERR_ENABLE_MPARF_0(x) ((x) << S_PERR_ENABLE_MPARF_0)
#define F_PERR_ENABLE_MPARF_0    V_PERR_ENABLE_MPARF_0(1U)

#define S_PERR_ENABLE_MPARC_0    0
#define V_PERR_ENABLE_MPARC_0(x) ((x) << S_PERR_ENABLE_MPARC_0)
#define F_PERR_ENABLE_MPARC_0    V_PERR_ENABLE_MPARC_0(1U)

#define S_PERR_SE_CNT_MISMATCH_1    26
#define V_PERR_SE_CNT_MISMATCH_1(x) ((x) << S_PERR_SE_CNT_MISMATCH_1)
#define F_PERR_SE_CNT_MISMATCH_1    V_PERR_SE_CNT_MISMATCH_1(1U)

#define S_PERR_SE_CNT_MISMATCH_0    25
#define V_PERR_SE_CNT_MISMATCH_0(x) ((x) << S_PERR_SE_CNT_MISMATCH_0)
#define F_PERR_SE_CNT_MISMATCH_0    V_PERR_SE_CNT_MISMATCH_0(1U)

#define S_PERR_RSVD0    24
#define V_PERR_RSVD0(x) ((x) << S_PERR_RSVD0)
#define F_PERR_RSVD0    V_PERR_RSVD0(1U)

#define S_PERR_RSVD1    23
#define V_PERR_RSVD1(x) ((x) << S_PERR_RSVD1)
#define F_PERR_RSVD1    V_PERR_RSVD1(1U)

#define A_ULP_RX_PERR_INJECT 0x191a0
#define A_ULP_RX_RQUDP_LLIMIT 0x191a4
#define A_ULP_RX_RQUDP_ULIMIT 0x191a8
#define A_ULP_RX_CTX_ACC_CH0 0x191ac

#define S_REQ    21
#define V_REQ(x) ((x) << S_REQ)
#define F_REQ    V_REQ(1U)

#define S_WB    20
#define V_WB(x) ((x) << S_WB)
#define F_WB    V_WB(1U)

#define S_ULPRX_TID    0
#define M_ULPRX_TID    0xfffffU
#define V_ULPRX_TID(x) ((x) << S_ULPRX_TID)
#define G_ULPRX_TID(x) (((x) >> S_ULPRX_TID) & M_ULPRX_TID)

#define A_ULP_RX_CTX_ACC_CH1 0x191b0
#define A_ULP_RX_SE_CNT_ERR 0x191d0
#define A_ULP_RX_SE_CNT_CLR 0x191d4

#define S_CLRCHAN0    4
#define M_CLRCHAN0    0xfU
#define V_CLRCHAN0(x) ((x) << S_CLRCHAN0)
#define G_CLRCHAN0(x) (((x) >> S_CLRCHAN0) & M_CLRCHAN0)

#define S_CLRCHAN1    0
#define M_CLRCHAN1    0xfU
#define V_CLRCHAN1(x) ((x) << S_CLRCHAN1)
#define G_CLRCHAN1(x) (((x) >> S_CLRCHAN1) & M_CLRCHAN1)

#define A_ULP_RX_SE_CNT_CH0 0x191d8

#define S_SOP_CNT_OUT0    28
#define M_SOP_CNT_OUT0    0xfU
#define V_SOP_CNT_OUT0(x) ((x) << S_SOP_CNT_OUT0)
#define G_SOP_CNT_OUT0(x) (((x) >> S_SOP_CNT_OUT0) & M_SOP_CNT_OUT0)

#define S_EOP_CNT_OUT0    24
#define M_EOP_CNT_OUT0    0xfU
#define V_EOP_CNT_OUT0(x) ((x) << S_EOP_CNT_OUT0)
#define G_EOP_CNT_OUT0(x) (((x) >> S_EOP_CNT_OUT0) & M_EOP_CNT_OUT0)

#define S_SOP_CNT_AL0    20
#define M_SOP_CNT_AL0    0xfU
#define V_SOP_CNT_AL0(x) ((x) << S_SOP_CNT_AL0)
#define G_SOP_CNT_AL0(x) (((x) >> S_SOP_CNT_AL0) & M_SOP_CNT_AL0)

#define S_EOP_CNT_AL0    16
#define M_EOP_CNT_AL0    0xfU
#define V_EOP_CNT_AL0(x) ((x) << S_EOP_CNT_AL0)
#define G_EOP_CNT_AL0(x) (((x) >> S_EOP_CNT_AL0) & M_EOP_CNT_AL0)

#define S_SOP_CNT_MR0    12
#define M_SOP_CNT_MR0    0xfU
#define V_SOP_CNT_MR0(x) ((x) << S_SOP_CNT_MR0)
#define G_SOP_CNT_MR0(x) (((x) >> S_SOP_CNT_MR0) & M_SOP_CNT_MR0)

#define S_EOP_CNT_MR0    8
#define M_EOP_CNT_MR0    0xfU
#define V_EOP_CNT_MR0(x) ((x) << S_EOP_CNT_MR0)
#define G_EOP_CNT_MR0(x) (((x) >> S_EOP_CNT_MR0) & M_EOP_CNT_MR0)

#define S_SOP_CNT_IN0    4
#define M_SOP_CNT_IN0    0xfU
#define V_SOP_CNT_IN0(x) ((x) << S_SOP_CNT_IN0)
#define G_SOP_CNT_IN0(x) (((x) >> S_SOP_CNT_IN0) & M_SOP_CNT_IN0)

#define S_EOP_CNT_IN0    0
#define M_EOP_CNT_IN0    0xfU
#define V_EOP_CNT_IN0(x) ((x) << S_EOP_CNT_IN0)
#define G_EOP_CNT_IN0(x) (((x) >> S_EOP_CNT_IN0) & M_EOP_CNT_IN0)

#define A_ULP_RX_SE_CNT_CH1 0x191dc

#define S_SOP_CNT_OUT1    28
#define M_SOP_CNT_OUT1    0xfU
#define V_SOP_CNT_OUT1(x) ((x) << S_SOP_CNT_OUT1)
#define G_SOP_CNT_OUT1(x) (((x) >> S_SOP_CNT_OUT1) & M_SOP_CNT_OUT1)

#define S_EOP_CNT_OUT1    24
#define M_EOP_CNT_OUT1    0xfU
#define V_EOP_CNT_OUT1(x) ((x) << S_EOP_CNT_OUT1)
#define G_EOP_CNT_OUT1(x) (((x) >> S_EOP_CNT_OUT1) & M_EOP_CNT_OUT1)

#define S_SOP_CNT_AL1    20
#define M_SOP_CNT_AL1    0xfU
#define V_SOP_CNT_AL1(x) ((x) << S_SOP_CNT_AL1)
#define G_SOP_CNT_AL1(x) (((x) >> S_SOP_CNT_AL1) & M_SOP_CNT_AL1)

#define S_EOP_CNT_AL1    16
#define M_EOP_CNT_AL1    0xfU
#define V_EOP_CNT_AL1(x) ((x) << S_EOP_CNT_AL1)
#define G_EOP_CNT_AL1(x) (((x) >> S_EOP_CNT_AL1) & M_EOP_CNT_AL1)

#define S_SOP_CNT_MR1    12
#define M_SOP_CNT_MR1    0xfU
#define V_SOP_CNT_MR1(x) ((x) << S_SOP_CNT_MR1)
#define G_SOP_CNT_MR1(x) (((x) >> S_SOP_CNT_MR1) & M_SOP_CNT_MR1)

#define S_EOP_CNT_MR1    8
#define M_EOP_CNT_MR1    0xfU
#define V_EOP_CNT_MR1(x) ((x) << S_EOP_CNT_MR1)
#define G_EOP_CNT_MR1(x) (((x) >> S_EOP_CNT_MR1) & M_EOP_CNT_MR1)

#define S_SOP_CNT_IN1    4
#define M_SOP_CNT_IN1    0xfU
#define V_SOP_CNT_IN1(x) ((x) << S_SOP_CNT_IN1)
#define G_SOP_CNT_IN1(x) (((x) >> S_SOP_CNT_IN1) & M_SOP_CNT_IN1)

#define S_EOP_CNT_IN1    0
#define M_EOP_CNT_IN1    0xfU
#define V_EOP_CNT_IN1(x) ((x) << S_EOP_CNT_IN1)
#define G_EOP_CNT_IN1(x) (((x) >> S_EOP_CNT_IN1) & M_EOP_CNT_IN1)

#define A_ULP_RX_DBG_CTL 0x191e0

#define S_EN_DBG_H    17
#define V_EN_DBG_H(x) ((x) << S_EN_DBG_H)
#define F_EN_DBG_H    V_EN_DBG_H(1U)

#define S_EN_DBG_L    16
#define V_EN_DBG_L(x) ((x) << S_EN_DBG_L)
#define F_EN_DBG_L    V_EN_DBG_L(1U)

#define S_SEL_H    8
#define M_SEL_H    0xffU
#define V_SEL_H(x) ((x) << S_SEL_H)
#define G_SEL_H(x) (((x) >> S_SEL_H) & M_SEL_H)

#define S_SEL_L    0
#define M_SEL_L    0xffU
#define V_SEL_L(x) ((x) << S_SEL_L)
#define G_SEL_L(x) (((x) >> S_SEL_L) & M_SEL_L)

#define A_ULP_RX_DBG_DATAH 0x191e4
#define A_ULP_RX_DBG_DATAL 0x191e8
#define A_ULP_RX_LA_CHNL 0x19238

#define S_CHNL_SEL    0
#define V_CHNL_SEL(x) ((x) << S_CHNL_SEL)
#define F_CHNL_SEL    V_CHNL_SEL(1U)

#define A_ULP_RX_LA_CTL 0x1923c

#define S_TRC_SEL    0
#define V_TRC_SEL(x) ((x) << S_TRC_SEL)
#define F_TRC_SEL    V_TRC_SEL(1U)

#define A_ULP_RX_LA_RDPTR 0x19240

#define S_RD_PTR    0
#define M_RD_PTR    0x1ffU
#define V_RD_PTR(x) ((x) << S_RD_PTR)
#define G_RD_PTR(x) (((x) >> S_RD_PTR) & M_RD_PTR)

#define A_ULP_RX_LA_RDDATA 0x19244
#define A_ULP_RX_LA_WRPTR 0x19248

#define S_WR_PTR    0
#define M_WR_PTR    0x1ffU
#define V_WR_PTR(x) ((x) << S_WR_PTR)
#define G_WR_PTR(x) (((x) >> S_WR_PTR) & M_WR_PTR)

#define A_ULP_RX_LA_RESERVED 0x1924c
#define A_ULP_RX_CQE_GEN_EN 0x19250

#define S_TERMIMATE_MSG    1
#define V_TERMIMATE_MSG(x) ((x) << S_TERMIMATE_MSG)
#define F_TERMIMATE_MSG    V_TERMIMATE_MSG(1U)

#define S_TERMINATE_WITH_ERR    0
#define V_TERMINATE_WITH_ERR(x) ((x) << S_TERMINATE_WITH_ERR)
#define F_TERMINATE_WITH_ERR    V_TERMINATE_WITH_ERR(1U)

#define A_ULP_RX_ATOMIC_OPCODES 0x19254

#define S_ATOMIC_REQ_QNO    22
#define M_ATOMIC_REQ_QNO    0x3U
#define V_ATOMIC_REQ_QNO(x) ((x) << S_ATOMIC_REQ_QNO)
#define G_ATOMIC_REQ_QNO(x) (((x) >> S_ATOMIC_REQ_QNO) & M_ATOMIC_REQ_QNO)

#define S_ATOMIC_RSP_QNO    20
#define M_ATOMIC_RSP_QNO    0x3U
#define V_ATOMIC_RSP_QNO(x) ((x) << S_ATOMIC_RSP_QNO)
#define G_ATOMIC_RSP_QNO(x) (((x) >> S_ATOMIC_RSP_QNO) & M_ATOMIC_RSP_QNO)

#define S_IMMEDIATE_QNO    18
#define M_IMMEDIATE_QNO    0x3U
#define V_IMMEDIATE_QNO(x) ((x) << S_IMMEDIATE_QNO)
#define G_IMMEDIATE_QNO(x) (((x) >> S_IMMEDIATE_QNO) & M_IMMEDIATE_QNO)

#define S_IMMEDIATE_WITH_SE_QNO    16
#define M_IMMEDIATE_WITH_SE_QNO    0x3U
#define V_IMMEDIATE_WITH_SE_QNO(x) ((x) << S_IMMEDIATE_WITH_SE_QNO)
#define G_IMMEDIATE_WITH_SE_QNO(x) (((x) >> S_IMMEDIATE_WITH_SE_QNO) & M_IMMEDIATE_WITH_SE_QNO)

#define S_ATOMIC_WR_OPCODE    12
#define M_ATOMIC_WR_OPCODE    0xfU
#define V_ATOMIC_WR_OPCODE(x) ((x) << S_ATOMIC_WR_OPCODE)
#define G_ATOMIC_WR_OPCODE(x) (((x) >> S_ATOMIC_WR_OPCODE) & M_ATOMIC_WR_OPCODE)

#define S_ATOMIC_RD_OPCODE    8
#define M_ATOMIC_RD_OPCODE    0xfU
#define V_ATOMIC_RD_OPCODE(x) ((x) << S_ATOMIC_RD_OPCODE)
#define G_ATOMIC_RD_OPCODE(x) (((x) >> S_ATOMIC_RD_OPCODE) & M_ATOMIC_RD_OPCODE)

#define S_IMMEDIATE_OPCODE    4
#define M_IMMEDIATE_OPCODE    0xfU
#define V_IMMEDIATE_OPCODE(x) ((x) << S_IMMEDIATE_OPCODE)
#define G_IMMEDIATE_OPCODE(x) (((x) >> S_IMMEDIATE_OPCODE) & M_IMMEDIATE_OPCODE)

#define S_IMMEDIATE_WITH_SE_OPCODE    0
#define M_IMMEDIATE_WITH_SE_OPCODE    0xfU
#define V_IMMEDIATE_WITH_SE_OPCODE(x) ((x) << S_IMMEDIATE_WITH_SE_OPCODE)
#define G_IMMEDIATE_WITH_SE_OPCODE(x) (((x) >> S_IMMEDIATE_WITH_SE_OPCODE) & M_IMMEDIATE_WITH_SE_OPCODE)

#define A_ULP_RX_T10_CRC_ENDIAN_SWITCHING 0x19258

#define S_EN_ORIG_DATA    0
#define V_EN_ORIG_DATA(x) ((x) << S_EN_ORIG_DATA)
#define F_EN_ORIG_DATA    V_EN_ORIG_DATA(1U)

#define A_ULP_RX_MISC_FEATURE_ENABLE 0x1925c

#define S_TERMINATE_STATUS_EN    4
#define V_TERMINATE_STATUS_EN(x) ((x) << S_TERMINATE_STATUS_EN)
#define F_TERMINATE_STATUS_EN    V_TERMINATE_STATUS_EN(1U)

#define S_MULTIPLE_PREF_ENABLE    3
#define V_MULTIPLE_PREF_ENABLE(x) ((x) << S_MULTIPLE_PREF_ENABLE)
#define F_MULTIPLE_PREF_ENABLE    V_MULTIPLE_PREF_ENABLE(1U)

#define S_UMUDP_PBL_PREF_ENABLE    2
#define V_UMUDP_PBL_PREF_ENABLE(x) ((x) << S_UMUDP_PBL_PREF_ENABLE)
#define F_UMUDP_PBL_PREF_ENABLE    V_UMUDP_PBL_PREF_ENABLE(1U)

#define S_RDMA_PBL_PREF_EN    1
#define V_RDMA_PBL_PREF_EN(x) ((x) << S_RDMA_PBL_PREF_EN)
#define F_RDMA_PBL_PREF_EN    V_RDMA_PBL_PREF_EN(1U)

#define S_SDC_CRC_PROT_EN    0
#define V_SDC_CRC_PROT_EN(x) ((x) << S_SDC_CRC_PROT_EN)
#define F_SDC_CRC_PROT_EN    V_SDC_CRC_PROT_EN(1U)

#define A_ULP_RX_CH0_CGEN 0x19260

#define S_BYPASS_CGEN    7
#define V_BYPASS_CGEN(x) ((x) << S_BYPASS_CGEN)
#define F_BYPASS_CGEN    V_BYPASS_CGEN(1U)

#define S_TDDP_CGEN    6
#define V_TDDP_CGEN(x) ((x) << S_TDDP_CGEN)
#define F_TDDP_CGEN    V_TDDP_CGEN(1U)

#define S_ISCSI_CGEN    5
#define V_ISCSI_CGEN(x) ((x) << S_ISCSI_CGEN)
#define F_ISCSI_CGEN    V_ISCSI_CGEN(1U)

#define S_RDMA_CGEN    4
#define V_RDMA_CGEN(x) ((x) << S_RDMA_CGEN)
#define F_RDMA_CGEN    V_RDMA_CGEN(1U)

#define S_CHANNEL_CGEN    3
#define V_CHANNEL_CGEN(x) ((x) << S_CHANNEL_CGEN)
#define F_CHANNEL_CGEN    V_CHANNEL_CGEN(1U)

#define S_ALL_DATAPATH_CGEN    2
#define V_ALL_DATAPATH_CGEN(x) ((x) << S_ALL_DATAPATH_CGEN)
#define F_ALL_DATAPATH_CGEN    V_ALL_DATAPATH_CGEN(1U)

#define S_T10DIFF_DATAPATH_CGEN    1
#define V_T10DIFF_DATAPATH_CGEN(x) ((x) << S_T10DIFF_DATAPATH_CGEN)
#define F_T10DIFF_DATAPATH_CGEN    V_T10DIFF_DATAPATH_CGEN(1U)

#define S_RDMA_DATAPATH_CGEN    0
#define V_RDMA_DATAPATH_CGEN(x) ((x) << S_RDMA_DATAPATH_CGEN)
#define F_RDMA_DATAPATH_CGEN    V_RDMA_DATAPATH_CGEN(1U)

#define A_ULP_RX_CH1_CGEN 0x19264
#define A_ULP_RX_RFE_DISABLE 0x19268

#define S_RQE_LIM_CHECK_RFE_DISABLE    0
#define V_RQE_LIM_CHECK_RFE_DISABLE(x) ((x) << S_RQE_LIM_CHECK_RFE_DISABLE)
#define F_RQE_LIM_CHECK_RFE_DISABLE    V_RQE_LIM_CHECK_RFE_DISABLE(1U)

#define A_ULP_RX_INT_ENABLE_2 0x1926c

#define S_ULPRX2MA_INTFPERR    8
#define V_ULPRX2MA_INTFPERR(x) ((x) << S_ULPRX2MA_INTFPERR)
#define F_ULPRX2MA_INTFPERR    V_ULPRX2MA_INTFPERR(1U)

#define S_ALN_SDC_ERR_1    7
#define V_ALN_SDC_ERR_1(x) ((x) << S_ALN_SDC_ERR_1)
#define F_ALN_SDC_ERR_1    V_ALN_SDC_ERR_1(1U)

#define S_ALN_SDC_ERR_0    6
#define V_ALN_SDC_ERR_0(x) ((x) << S_ALN_SDC_ERR_0)
#define F_ALN_SDC_ERR_0    V_ALN_SDC_ERR_0(1U)

#define S_PF_UNTAGGED_TPT_1    5
#define V_PF_UNTAGGED_TPT_1(x) ((x) << S_PF_UNTAGGED_TPT_1)
#define F_PF_UNTAGGED_TPT_1    V_PF_UNTAGGED_TPT_1(1U)

#define S_PF_UNTAGGED_TPT_0    4
#define V_PF_UNTAGGED_TPT_0(x) ((x) << S_PF_UNTAGGED_TPT_0)
#define F_PF_UNTAGGED_TPT_0    V_PF_UNTAGGED_TPT_0(1U)

#define S_PF_PBL_1    3
#define V_PF_PBL_1(x) ((x) << S_PF_PBL_1)
#define F_PF_PBL_1    V_PF_PBL_1(1U)

#define S_PF_PBL_0    2
#define V_PF_PBL_0(x) ((x) << S_PF_PBL_0)
#define F_PF_PBL_0    V_PF_PBL_0(1U)

#define S_DDP_HINT_1    1
#define V_DDP_HINT_1(x) ((x) << S_DDP_HINT_1)
#define F_DDP_HINT_1    V_DDP_HINT_1(1U)

#define S_DDP_HINT_0    0
#define V_DDP_HINT_0(x) ((x) << S_DDP_HINT_0)
#define F_DDP_HINT_0    V_DDP_HINT_0(1U)

#define A_ULP_RX_INT_CAUSE_2 0x19270
#define A_ULP_RX_PERR_ENABLE_2 0x19274

#define S_ENABLE_ULPRX2MA_INTFPERR    8
#define V_ENABLE_ULPRX2MA_INTFPERR(x) ((x) << S_ENABLE_ULPRX2MA_INTFPERR)
#define F_ENABLE_ULPRX2MA_INTFPERR    V_ENABLE_ULPRX2MA_INTFPERR(1U)

#define S_ENABLE_ALN_SDC_ERR_1    7
#define V_ENABLE_ALN_SDC_ERR_1(x) ((x) << S_ENABLE_ALN_SDC_ERR_1)
#define F_ENABLE_ALN_SDC_ERR_1    V_ENABLE_ALN_SDC_ERR_1(1U)

#define S_ENABLE_ALN_SDC_ERR_0    6
#define V_ENABLE_ALN_SDC_ERR_0(x) ((x) << S_ENABLE_ALN_SDC_ERR_0)
#define F_ENABLE_ALN_SDC_ERR_0    V_ENABLE_ALN_SDC_ERR_0(1U)

#define S_ENABLE_PF_UNTAGGED_TPT_1    5
#define V_ENABLE_PF_UNTAGGED_TPT_1(x) ((x) << S_ENABLE_PF_UNTAGGED_TPT_1)
#define F_ENABLE_PF_UNTAGGED_TPT_1    V_ENABLE_PF_UNTAGGED_TPT_1(1U)

#define S_ENABLE_PF_UNTAGGED_TPT_0    4
#define V_ENABLE_PF_UNTAGGED_TPT_0(x) ((x) << S_ENABLE_PF_UNTAGGED_TPT_0)
#define F_ENABLE_PF_UNTAGGED_TPT_0    V_ENABLE_PF_UNTAGGED_TPT_0(1U)

#define S_ENABLE_PF_PBL_1    3
#define V_ENABLE_PF_PBL_1(x) ((x) << S_ENABLE_PF_PBL_1)
#define F_ENABLE_PF_PBL_1    V_ENABLE_PF_PBL_1(1U)

#define S_ENABLE_PF_PBL_0    2
#define V_ENABLE_PF_PBL_0(x) ((x) << S_ENABLE_PF_PBL_0)
#define F_ENABLE_PF_PBL_0    V_ENABLE_PF_PBL_0(1U)

#define S_ENABLE_DDP_HINT_1    1
#define V_ENABLE_DDP_HINT_1(x) ((x) << S_ENABLE_DDP_HINT_1)
#define F_ENABLE_DDP_HINT_1    V_ENABLE_DDP_HINT_1(1U)

#define S_ENABLE_DDP_HINT_0    0
#define V_ENABLE_DDP_HINT_0(x) ((x) << S_ENABLE_DDP_HINT_0)
#define F_ENABLE_DDP_HINT_0    V_ENABLE_DDP_HINT_0(1U)

#define A_ULP_RX_RQE_PBL_MULTIPLE_OUTSTANDING_CNT 0x19278

#define S_PIO_RQE_PBL_MULTIPLE_CNT    0
#define M_PIO_RQE_PBL_MULTIPLE_CNT    0xfU
#define V_PIO_RQE_PBL_MULTIPLE_CNT(x) ((x) << S_PIO_RQE_PBL_MULTIPLE_CNT)
#define G_PIO_RQE_PBL_MULTIPLE_CNT(x) (((x) >> S_PIO_RQE_PBL_MULTIPLE_CNT) & M_PIO_RQE_PBL_MULTIPLE_CNT)

#define A_ULP_RX_ATOMIC_LEN 0x1927c

#define S_ATOMIC_RPL_LEN    16
#define M_ATOMIC_RPL_LEN    0xffU
#define V_ATOMIC_RPL_LEN(x) ((x) << S_ATOMIC_RPL_LEN)
#define G_ATOMIC_RPL_LEN(x) (((x) >> S_ATOMIC_RPL_LEN) & M_ATOMIC_RPL_LEN)

#define S_ATOMIC_REQ_LEN    8
#define M_ATOMIC_REQ_LEN    0xffU
#define V_ATOMIC_REQ_LEN(x) ((x) << S_ATOMIC_REQ_LEN)
#define G_ATOMIC_REQ_LEN(x) (((x) >> S_ATOMIC_REQ_LEN) & M_ATOMIC_REQ_LEN)

#define S_ATOMIC_IMMEDIATE_LEN    0
#define M_ATOMIC_IMMEDIATE_LEN    0xffU
#define V_ATOMIC_IMMEDIATE_LEN(x) ((x) << S_ATOMIC_IMMEDIATE_LEN)
#define G_ATOMIC_IMMEDIATE_LEN(x) (((x) >> S_ATOMIC_IMMEDIATE_LEN) & M_ATOMIC_IMMEDIATE_LEN)

#define A_ULP_RX_CGEN_GLOBAL 0x19280
#define A_ULP_RX_CTX_SKIP_MA_REQ 0x19284

#define S_CLEAR_CTX_ERR_CNT1    3
#define V_CLEAR_CTX_ERR_CNT1(x) ((x) << S_CLEAR_CTX_ERR_CNT1)
#define F_CLEAR_CTX_ERR_CNT1    V_CLEAR_CTX_ERR_CNT1(1U)

#define S_CLEAR_CTX_ERR_CNT0    2
#define V_CLEAR_CTX_ERR_CNT0(x) ((x) << S_CLEAR_CTX_ERR_CNT0)
#define F_CLEAR_CTX_ERR_CNT0    V_CLEAR_CTX_ERR_CNT0(1U)

#define S_SKIP_MA_REQ_EN1    1
#define V_SKIP_MA_REQ_EN1(x) ((x) << S_SKIP_MA_REQ_EN1)
#define F_SKIP_MA_REQ_EN1    V_SKIP_MA_REQ_EN1(1U)

#define S_SKIP_MA_REQ_EN0    0
#define V_SKIP_MA_REQ_EN0(x) ((x) << S_SKIP_MA_REQ_EN0)
#define F_SKIP_MA_REQ_EN0    V_SKIP_MA_REQ_EN0(1U)

#define A_ULP_RX_CHNL0_CTX_ERROR_COUNT_PER_TID 0x19288
#define A_ULP_RX_CHNL1_CTX_ERROR_COUNT_PER_TID 0x1928c
#define A_ULP_RX_MSN_CHECK_ENABLE 0x19290

#define S_RD_OR_TERM_MSN_CHECK_ENABLE    2
#define V_RD_OR_TERM_MSN_CHECK_ENABLE(x) ((x) << S_RD_OR_TERM_MSN_CHECK_ENABLE)
#define F_RD_OR_TERM_MSN_CHECK_ENABLE    V_RD_OR_TERM_MSN_CHECK_ENABLE(1U)

#define S_ATOMIC_OP_MSN_CHECK_ENABLE    1
#define V_ATOMIC_OP_MSN_CHECK_ENABLE(x) ((x) << S_ATOMIC_OP_MSN_CHECK_ENABLE)
#define F_ATOMIC_OP_MSN_CHECK_ENABLE    V_ATOMIC_OP_MSN_CHECK_ENABLE(1U)

#define S_SEND_MSN_CHECK_ENABLE    0
#define V_SEND_MSN_CHECK_ENABLE(x) ((x) << S_SEND_MSN_CHECK_ENABLE)
#define F_SEND_MSN_CHECK_ENABLE    V_SEND_MSN_CHECK_ENABLE(1U)

/* registers for module SF */
#define SF_BASE_ADDR 0x193f8

#define A_SF_DATA 0x193f8
#define A_SF_OP 0x193fc

#define S_SF_LOCK    4
#define V_SF_LOCK(x) ((x) << S_SF_LOCK)
#define F_SF_LOCK    V_SF_LOCK(1U)

#define S_CONT    3
#define V_CONT(x) ((x) << S_CONT)
#define F_CONT    V_CONT(1U)

#define S_BYTECNT    1
#define M_BYTECNT    0x3U
#define V_BYTECNT(x) ((x) << S_BYTECNT)
#define G_BYTECNT(x) (((x) >> S_BYTECNT) & M_BYTECNT)

/* registers for module PL */
#define PL_BASE_ADDR 0x19400

#define A_PL_VF_WHOAMI 0x0

#define S_PORTXMAP    24
#define M_PORTXMAP    0x7U
#define V_PORTXMAP(x) ((x) << S_PORTXMAP)
#define G_PORTXMAP(x) (((x) >> S_PORTXMAP) & M_PORTXMAP)

#define S_SOURCEBUS    16
#define M_SOURCEBUS    0x3U
#define V_SOURCEBUS(x) ((x) << S_SOURCEBUS)
#define G_SOURCEBUS(x) (((x) >> S_SOURCEBUS) & M_SOURCEBUS)

#define S_SOURCEPF    8
#define M_SOURCEPF    0x7U
#define V_SOURCEPF(x) ((x) << S_SOURCEPF)
#define G_SOURCEPF(x) (((x) >> S_SOURCEPF) & M_SOURCEPF)

#define S_ISVF    7
#define V_ISVF(x) ((x) << S_ISVF)
#define F_ISVF    V_ISVF(1U)

#define S_VFID    0
#define M_VFID    0x7fU
#define V_VFID(x) ((x) << S_VFID)
#define G_VFID(x) (((x) >> S_VFID) & M_VFID)

#define A_PL_VF_REV 0x4

#define S_CHIPID    4
#define M_CHIPID    0xfU
#define V_CHIPID(x) ((x) << S_CHIPID)
#define G_CHIPID(x) (((x) >> S_CHIPID) & M_CHIPID)

#define A_PL_VF_REVISION 0x8
#define A_PL_PF_INT_CAUSE 0x3c0

#define S_PFSW    3
#define V_PFSW(x) ((x) << S_PFSW)
#define F_PFSW    V_PFSW(1U)

#define S_PFSGE    2
#define V_PFSGE(x) ((x) << S_PFSGE)
#define F_PFSGE    V_PFSGE(1U)

#define S_PFCIM    1
#define V_PFCIM(x) ((x) << S_PFCIM)
#define F_PFCIM    V_PFCIM(1U)

#define S_PFMPS    0
#define V_PFMPS(x) ((x) << S_PFMPS)
#define F_PFMPS    V_PFMPS(1U)

#define A_PL_PF_INT_ENABLE 0x3c4
#define A_PL_PF_CTL 0x3c8

#define S_SWINT    0
#define V_SWINT(x) ((x) << S_SWINT)
#define F_SWINT    V_SWINT(1U)

#define A_PL_WHOAMI 0x19400
#define A_PL_PERR_CAUSE 0x19404

#define S_UART    28
#define V_UART(x) ((x) << S_UART)
#define F_UART    V_UART(1U)

#define S_ULP_TX    27
#define V_ULP_TX(x) ((x) << S_ULP_TX)
#define F_ULP_TX    V_ULP_TX(1U)

#define S_SGE    26
#define V_SGE(x) ((x) << S_SGE)
#define F_SGE    V_SGE(1U)

#define S_HMA    25
#define V_HMA(x) ((x) << S_HMA)
#define F_HMA    V_HMA(1U)

#define S_CPL_SWITCH    24
#define V_CPL_SWITCH(x) ((x) << S_CPL_SWITCH)
#define F_CPL_SWITCH    V_CPL_SWITCH(1U)

#define S_ULP_RX    23
#define V_ULP_RX(x) ((x) << S_ULP_RX)
#define F_ULP_RX    V_ULP_RX(1U)

#define S_PM_RX    22
#define V_PM_RX(x) ((x) << S_PM_RX)
#define F_PM_RX    V_PM_RX(1U)

#define S_PM_TX    21
#define V_PM_TX(x) ((x) << S_PM_TX)
#define F_PM_TX    V_PM_TX(1U)

#define S_MA    20
#define V_MA(x) ((x) << S_MA)
#define F_MA    V_MA(1U)

#define S_TP    19
#define V_TP(x) ((x) << S_TP)
#define F_TP    V_TP(1U)

#define S_LE    18
#define V_LE(x) ((x) << S_LE)
#define F_LE    V_LE(1U)

#define S_EDC1    17
#define V_EDC1(x) ((x) << S_EDC1)
#define F_EDC1    V_EDC1(1U)

#define S_EDC0    16
#define V_EDC0(x) ((x) << S_EDC0)
#define F_EDC0    V_EDC0(1U)

#define S_MC    15
#define V_MC(x) ((x) << S_MC)
#define F_MC    V_MC(1U)

#define S_PCIE    14
#define V_PCIE(x) ((x) << S_PCIE)
#define F_PCIE    V_PCIE(1U)

#define S_PMU    13
#define V_PMU(x) ((x) << S_PMU)
#define F_PMU    V_PMU(1U)

#define S_XGMAC_KR1    12
#define V_XGMAC_KR1(x) ((x) << S_XGMAC_KR1)
#define F_XGMAC_KR1    V_XGMAC_KR1(1U)

#define S_XGMAC_KR0    11
#define V_XGMAC_KR0(x) ((x) << S_XGMAC_KR0)
#define F_XGMAC_KR0    V_XGMAC_KR0(1U)

#define S_XGMAC1    10
#define V_XGMAC1(x) ((x) << S_XGMAC1)
#define F_XGMAC1    V_XGMAC1(1U)

#define S_XGMAC0    9
#define V_XGMAC0(x) ((x) << S_XGMAC0)
#define F_XGMAC0    V_XGMAC0(1U)

#define S_SMB    8
#define V_SMB(x) ((x) << S_SMB)
#define F_SMB    V_SMB(1U)

#define S_SF    7
#define V_SF(x) ((x) << S_SF)
#define F_SF    V_SF(1U)

#define S_PL    6
#define V_PL(x) ((x) << S_PL)
#define F_PL    V_PL(1U)

#define S_NCSI    5
#define V_NCSI(x) ((x) << S_NCSI)
#define F_NCSI    V_NCSI(1U)

#define S_MPS    4
#define V_MPS(x) ((x) << S_MPS)
#define F_MPS    V_MPS(1U)

#define S_MI    3
#define V_MI(x) ((x) << S_MI)
#define F_MI    V_MI(1U)

#define S_DBG    2
#define V_DBG(x) ((x) << S_DBG)
#define F_DBG    V_DBG(1U)

#define S_I2CM    1
#define V_I2CM(x) ((x) << S_I2CM)
#define F_I2CM    V_I2CM(1U)

#define S_CIM    0
#define V_CIM(x) ((x) << S_CIM)
#define F_CIM    V_CIM(1U)

#define S_MC1    31
#define V_MC1(x) ((x) << S_MC1)
#define F_MC1    V_MC1(1U)

#define S_MC0    15
#define V_MC0(x) ((x) << S_MC0)
#define F_MC0    V_MC0(1U)

#define S_ANYMAC    9
#define V_ANYMAC(x) ((x) << S_ANYMAC)
#define F_ANYMAC    V_ANYMAC(1U)

#define A_PL_PERR_ENABLE 0x19408
#define A_PL_INT_CAUSE 0x1940c

#define S_FLR    30
#define V_FLR(x) ((x) << S_FLR)
#define F_FLR    V_FLR(1U)

#define S_SW_CIM    29
#define V_SW_CIM(x) ((x) << S_SW_CIM)
#define F_SW_CIM    V_SW_CIM(1U)

#define S_MAC3    12
#define V_MAC3(x) ((x) << S_MAC3)
#define F_MAC3    V_MAC3(1U)

#define S_MAC2    11
#define V_MAC2(x) ((x) << S_MAC2)
#define F_MAC2    V_MAC2(1U)

#define S_MAC1    10
#define V_MAC1(x) ((x) << S_MAC1)
#define F_MAC1    V_MAC1(1U)

#define S_MAC0    9
#define V_MAC0(x) ((x) << S_MAC0)
#define F_MAC0    V_MAC0(1U)

#define A_PL_INT_ENABLE 0x19410
#define A_PL_INT_MAP0 0x19414

#define S_MAPNCSI    16
#define M_MAPNCSI    0x1ffU
#define V_MAPNCSI(x) ((x) << S_MAPNCSI)
#define G_MAPNCSI(x) (((x) >> S_MAPNCSI) & M_MAPNCSI)

#define S_MAPDEFAULT    0
#define M_MAPDEFAULT    0x1ffU
#define V_MAPDEFAULT(x) ((x) << S_MAPDEFAULT)
#define G_MAPDEFAULT(x) (((x) >> S_MAPDEFAULT) & M_MAPDEFAULT)

#define A_PL_INT_MAP1 0x19418

#define S_MAPXGMAC1    16
#define M_MAPXGMAC1    0x1ffU
#define V_MAPXGMAC1(x) ((x) << S_MAPXGMAC1)
#define G_MAPXGMAC1(x) (((x) >> S_MAPXGMAC1) & M_MAPXGMAC1)

#define S_MAPXGMAC0    0
#define M_MAPXGMAC0    0x1ffU
#define V_MAPXGMAC0(x) ((x) << S_MAPXGMAC0)
#define G_MAPXGMAC0(x) (((x) >> S_MAPXGMAC0) & M_MAPXGMAC0)

#define S_MAPMAC1    16
#define M_MAPMAC1    0x1ffU
#define V_MAPMAC1(x) ((x) << S_MAPMAC1)
#define G_MAPMAC1(x) (((x) >> S_MAPMAC1) & M_MAPMAC1)

#define S_MAPMAC0    0
#define M_MAPMAC0    0x1ffU
#define V_MAPMAC0(x) ((x) << S_MAPMAC0)
#define G_MAPMAC0(x) (((x) >> S_MAPMAC0) & M_MAPMAC0)

#define A_PL_INT_MAP2 0x1941c

#define S_MAPXGMAC_KR1    16
#define M_MAPXGMAC_KR1    0x1ffU
#define V_MAPXGMAC_KR1(x) ((x) << S_MAPXGMAC_KR1)
#define G_MAPXGMAC_KR1(x) (((x) >> S_MAPXGMAC_KR1) & M_MAPXGMAC_KR1)

#define S_MAPXGMAC_KR0    0
#define M_MAPXGMAC_KR0    0x1ffU
#define V_MAPXGMAC_KR0(x) ((x) << S_MAPXGMAC_KR0)
#define G_MAPXGMAC_KR0(x) (((x) >> S_MAPXGMAC_KR0) & M_MAPXGMAC_KR0)

#define S_MAPMAC3    16
#define M_MAPMAC3    0x1ffU
#define V_MAPMAC3(x) ((x) << S_MAPMAC3)
#define G_MAPMAC3(x) (((x) >> S_MAPMAC3) & M_MAPMAC3)

#define S_MAPMAC2    0
#define M_MAPMAC2    0x1ffU
#define V_MAPMAC2(x) ((x) << S_MAPMAC2)
#define G_MAPMAC2(x) (((x) >> S_MAPMAC2) & M_MAPMAC2)

#define A_PL_INT_MAP3 0x19420

#define S_MAPMI    16
#define M_MAPMI    0x1ffU
#define V_MAPMI(x) ((x) << S_MAPMI)
#define G_MAPMI(x) (((x) >> S_MAPMI) & M_MAPMI)

#define S_MAPSMB    0
#define M_MAPSMB    0x1ffU
#define V_MAPSMB(x) ((x) << S_MAPSMB)
#define G_MAPSMB(x) (((x) >> S_MAPSMB) & M_MAPSMB)

#define A_PL_INT_MAP4 0x19424

#define S_MAPDBG    16
#define M_MAPDBG    0x1ffU
#define V_MAPDBG(x) ((x) << S_MAPDBG)
#define G_MAPDBG(x) (((x) >> S_MAPDBG) & M_MAPDBG)

#define S_MAPI2CM    0
#define M_MAPI2CM    0x1ffU
#define V_MAPI2CM(x) ((x) << S_MAPI2CM)
#define G_MAPI2CM(x) (((x) >> S_MAPI2CM) & M_MAPI2CM)

#define A_PL_RST 0x19428

#define S_FATALPERREN    3
#define V_FATALPERREN(x) ((x) << S_FATALPERREN)
#define F_FATALPERREN    V_FATALPERREN(1U)

#define S_SWINTCIM    2
#define V_SWINTCIM(x) ((x) << S_SWINTCIM)
#define F_SWINTCIM    V_SWINTCIM(1U)

#define S_PIORST    1
#define V_PIORST(x) ((x) << S_PIORST)
#define F_PIORST    V_PIORST(1U)

#define S_PIORSTMODE    0
#define V_PIORSTMODE(x) ((x) << S_PIORSTMODE)
#define F_PIORSTMODE    V_PIORSTMODE(1U)

#define S_AUTOPCIEPAUSE    4
#define V_AUTOPCIEPAUSE(x) ((x) << S_AUTOPCIEPAUSE)
#define F_AUTOPCIEPAUSE    V_AUTOPCIEPAUSE(1U)

#define A_PL_PL_PERR_INJECT 0x1942c

#define S_PL_MEMSEL    1
#define V_PL_MEMSEL(x) ((x) << S_PL_MEMSEL)
#define F_PL_MEMSEL    V_PL_MEMSEL(1U)

#define A_PL_PL_INT_CAUSE 0x19430

#define S_PF_ENABLEERR    5
#define V_PF_ENABLEERR(x) ((x) << S_PF_ENABLEERR)
#define F_PF_ENABLEERR    V_PF_ENABLEERR(1U)

#define S_FATALPERR    4
#define V_FATALPERR(x) ((x) << S_FATALPERR)
#define F_FATALPERR    V_FATALPERR(1U)

#define S_INVALIDACCESS    3
#define V_INVALIDACCESS(x) ((x) << S_INVALIDACCESS)
#define F_INVALIDACCESS    V_INVALIDACCESS(1U)

#define S_TIMEOUT    2
#define V_TIMEOUT(x) ((x) << S_TIMEOUT)
#define F_TIMEOUT    V_TIMEOUT(1U)

#define S_PLERR    1
#define V_PLERR(x) ((x) << S_PLERR)
#define F_PLERR    V_PLERR(1U)

#define S_PERRVFID    0
#define V_PERRVFID(x) ((x) << S_PERRVFID)
#define F_PERRVFID    V_PERRVFID(1U)

#define S_PL_BUSPERR    6
#define V_PL_BUSPERR(x) ((x) << S_PL_BUSPERR)
#define F_PL_BUSPERR    V_PL_BUSPERR(1U)

#define A_PL_PL_INT_ENABLE 0x19434
#define A_PL_PL_PERR_ENABLE 0x19438
#define A_PL_REV 0x1943c

#define S_REV    0
#define M_REV    0xfU
#define V_REV(x) ((x) << S_REV)
#define G_REV(x) (((x) >> S_REV) & M_REV)

#define A_PL_PCIE_LINK 0x19440

#define S_LN0_AESTAT    26
#define M_LN0_AESTAT    0x7U
#define V_LN0_AESTAT(x) ((x) << S_LN0_AESTAT)
#define G_LN0_AESTAT(x) (((x) >> S_LN0_AESTAT) & M_LN0_AESTAT)

#define S_LN0_AECMD    23
#define M_LN0_AECMD    0x7U
#define V_LN0_AECMD(x) ((x) << S_LN0_AECMD)
#define G_LN0_AECMD(x) (((x) >> S_LN0_AECMD) & M_LN0_AECMD)

#define S_PCIE_SPEED    8
#define M_PCIE_SPEED    0x3U
#define V_PCIE_SPEED(x) ((x) << S_PCIE_SPEED)
#define G_PCIE_SPEED(x) (((x) >> S_PCIE_SPEED) & M_PCIE_SPEED)

#define S_LTSSM    0
#define M_LTSSM    0x3fU
#define V_LTSSM(x) ((x) << S_LTSSM)
#define G_LTSSM(x) (((x) >> S_LTSSM) & M_LTSSM)

#define A_PL_PCIE_CTL_STAT 0x19444

#define S_PCIE_STATUS    16
#define M_PCIE_STATUS    0xffffU
#define V_PCIE_STATUS(x) ((x) << S_PCIE_STATUS)
#define G_PCIE_STATUS(x) (((x) >> S_PCIE_STATUS) & M_PCIE_STATUS)

#define S_PCIE_CONTROL    0
#define M_PCIE_CONTROL    0xffffU
#define V_PCIE_CONTROL(x) ((x) << S_PCIE_CONTROL)
#define G_PCIE_CONTROL(x) (((x) >> S_PCIE_CONTROL) & M_PCIE_CONTROL)

#define A_PL_SEMAPHORE_CTL 0x1944c

#define S_LOCKSTATUS    16
#define M_LOCKSTATUS    0xffU
#define V_LOCKSTATUS(x) ((x) << S_LOCKSTATUS)
#define G_LOCKSTATUS(x) (((x) >> S_LOCKSTATUS) & M_LOCKSTATUS)

#define S_OWNEROVERRIDE    8
#define V_OWNEROVERRIDE(x) ((x) << S_OWNEROVERRIDE)
#define F_OWNEROVERRIDE    V_OWNEROVERRIDE(1U)

#define S_ENABLEPF    0
#define M_ENABLEPF    0xffU
#define V_ENABLEPF(x) ((x) << S_ENABLEPF)
#define G_ENABLEPF(x) (((x) >> S_ENABLEPF) & M_ENABLEPF)

#define A_PL_SEMAPHORE_LOCK 0x19450

#define S_SEMLOCK    31
#define V_SEMLOCK(x) ((x) << S_SEMLOCK)
#define F_SEMLOCK    V_SEMLOCK(1U)

#define S_SEMSRCBUS    3
#define M_SEMSRCBUS    0x3U
#define V_SEMSRCBUS(x) ((x) << S_SEMSRCBUS)
#define G_SEMSRCBUS(x) (((x) >> S_SEMSRCBUS) & M_SEMSRCBUS)

#define S_SEMSRCPF    0
#define M_SEMSRCPF    0x7U
#define V_SEMSRCPF(x) ((x) << S_SEMSRCPF)
#define G_SEMSRCPF(x) (((x) >> S_SEMSRCPF) & M_SEMSRCPF)

#define A_PL_PF_ENABLE 0x19470

#define S_PF_ENABLE    0
#define M_PF_ENABLE    0xffU
#define V_PF_ENABLE(x) ((x) << S_PF_ENABLE)
#define G_PF_ENABLE(x) (((x) >> S_PF_ENABLE) & M_PF_ENABLE)

#define A_PL_PORTX_MAP 0x19474

#define S_MAP7    28
#define M_MAP7    0x7U
#define V_MAP7(x) ((x) << S_MAP7)
#define G_MAP7(x) (((x) >> S_MAP7) & M_MAP7)

#define S_MAP6    24
#define M_MAP6    0x7U
#define V_MAP6(x) ((x) << S_MAP6)
#define G_MAP6(x) (((x) >> S_MAP6) & M_MAP6)

#define S_MAP5    20
#define M_MAP5    0x7U
#define V_MAP5(x) ((x) << S_MAP5)
#define G_MAP5(x) (((x) >> S_MAP5) & M_MAP5)

#define S_MAP4    16
#define M_MAP4    0x7U
#define V_MAP4(x) ((x) << S_MAP4)
#define G_MAP4(x) (((x) >> S_MAP4) & M_MAP4)

#define S_MAP3    12
#define M_MAP3    0x7U
#define V_MAP3(x) ((x) << S_MAP3)
#define G_MAP3(x) (((x) >> S_MAP3) & M_MAP3)

#define S_MAP2    8
#define M_MAP2    0x7U
#define V_MAP2(x) ((x) << S_MAP2)
#define G_MAP2(x) (((x) >> S_MAP2) & M_MAP2)

#define S_MAP1    4
#define M_MAP1    0x7U
#define V_MAP1(x) ((x) << S_MAP1)
#define G_MAP1(x) (((x) >> S_MAP1) & M_MAP1)

#define S_MAP0    0
#define M_MAP0    0x7U
#define V_MAP0(x) ((x) << S_MAP0)
#define G_MAP0(x) (((x) >> S_MAP0) & M_MAP0)

#define A_PL_VF_SLICE_L 0x19490

#define S_LIMITADDR    16
#define M_LIMITADDR    0x3ffU
#define V_LIMITADDR(x) ((x) << S_LIMITADDR)
#define G_LIMITADDR(x) (((x) >> S_LIMITADDR) & M_LIMITADDR)

#define S_SLICEBASEADDR    0
#define M_SLICEBASEADDR    0x3ffU
#define V_SLICEBASEADDR(x) ((x) << S_SLICEBASEADDR)
#define G_SLICEBASEADDR(x) (((x) >> S_SLICEBASEADDR) & M_SLICEBASEADDR)

#define A_PL_VF_SLICE_H 0x19494

#define S_MODINDX    16
#define M_MODINDX    0x7U
#define V_MODINDX(x) ((x) << S_MODINDX)
#define G_MODINDX(x) (((x) >> S_MODINDX) & M_MODINDX)

#define S_MODOFFSET    0
#define M_MODOFFSET    0x3ffU
#define V_MODOFFSET(x) ((x) << S_MODOFFSET)
#define G_MODOFFSET(x) (((x) >> S_MODOFFSET) & M_MODOFFSET)

#define A_PL_FLR_VF_STATUS 0x194d0
#define A_PL_FLR_PF_STATUS 0x194e0

#define S_FLR_PF    0
#define M_FLR_PF    0xffU
#define V_FLR_PF(x) ((x) << S_FLR_PF)
#define G_FLR_PF(x) (((x) >> S_FLR_PF) & M_FLR_PF)

#define A_PL_TIMEOUT_CTL 0x194f0

#define S_PL_TIMEOUT    0
#define M_PL_TIMEOUT    0xffffU
#define V_PL_TIMEOUT(x) ((x) << S_PL_TIMEOUT)
#define G_PL_TIMEOUT(x) (((x) >> S_PL_TIMEOUT) & M_PL_TIMEOUT)

#define S_PERRCAPTURE    16
#define V_PERRCAPTURE(x) ((x) << S_PERRCAPTURE)
#define F_PERRCAPTURE    V_PERRCAPTURE(1U)

#define A_PL_TIMEOUT_STATUS0 0x194f4

#define S_PL_TOADDR    2
#define M_PL_TOADDR    0xfffffffU
#define V_PL_TOADDR(x) ((x) << S_PL_TOADDR)
#define G_PL_TOADDR(x) (((x) >> S_PL_TOADDR) & M_PL_TOADDR)

#define A_PL_TIMEOUT_STATUS1 0x194f8

#define S_PL_TOVALID    31
#define V_PL_TOVALID(x) ((x) << S_PL_TOVALID)
#define F_PL_TOVALID    V_PL_TOVALID(1U)

#define S_WRITE    22
#define V_WRITE(x) ((x) << S_WRITE)
#define F_WRITE    V_WRITE(1U)

#define S_PL_TOBUS    20
#define M_PL_TOBUS    0x3U
#define V_PL_TOBUS(x) ((x) << S_PL_TOBUS)
#define G_PL_TOBUS(x) (((x) >> S_PL_TOBUS) & M_PL_TOBUS)

#define S_RGN    19
#define V_RGN(x) ((x) << S_RGN)
#define F_RGN    V_RGN(1U)

#define S_PL_TOPF    16
#define M_PL_TOPF    0x7U
#define V_PL_TOPF(x) ((x) << S_PL_TOPF)
#define G_PL_TOPF(x) (((x) >> S_PL_TOPF) & M_PL_TOPF)

#define S_PL_TORID    0
#define M_PL_TORID    0xffffU
#define V_PL_TORID(x) ((x) << S_PL_TORID)
#define G_PL_TORID(x) (((x) >> S_PL_TORID) & M_PL_TORID)

#define S_VALIDPERR    30
#define V_VALIDPERR(x) ((x) << S_VALIDPERR)
#define F_VALIDPERR    V_VALIDPERR(1U)

#define S_PL_TOVFID    0
#define M_PL_TOVFID    0xffU
#define V_PL_TOVFID(x) ((x) << S_PL_TOVFID)
#define G_PL_TOVFID(x) (((x) >> S_PL_TOVFID) & M_PL_TOVFID)

#define A_PL_VFID_MAP 0x19800

#define S_VFID_VLD    7
#define V_VFID_VLD(x) ((x) << S_VFID_VLD)
#define F_VFID_VLD    V_VFID_VLD(1U)

/* registers for module LE */
#define LE_BASE_ADDR 0x19c00

#define A_LE_BUF_CONFIG 0x19c00
#define A_LE_DB_CONFIG 0x19c04

#define S_TCAMCMDOVLAPEN    21
#define V_TCAMCMDOVLAPEN(x) ((x) << S_TCAMCMDOVLAPEN)
#define F_TCAMCMDOVLAPEN    V_TCAMCMDOVLAPEN(1U)

#define S_HASHEN    20
#define V_HASHEN(x) ((x) << S_HASHEN)
#define F_HASHEN    V_HASHEN(1U)

#define S_ASBOTHSRCHEN    18
#define V_ASBOTHSRCHEN(x) ((x) << S_ASBOTHSRCHEN)
#define F_ASBOTHSRCHEN    V_ASBOTHSRCHEN(1U)

#define S_ASLIPCOMPEN    17
#define V_ASLIPCOMPEN(x) ((x) << S_ASLIPCOMPEN)
#define F_ASLIPCOMPEN    V_ASLIPCOMPEN(1U)

#define S_BUILD    16
#define V_BUILD(x) ((x) << S_BUILD)
#define F_BUILD    V_BUILD(1U)

#define S_FILTEREN    11
#define V_FILTEREN(x) ((x) << S_FILTEREN)
#define F_FILTEREN    V_FILTEREN(1U)

#define S_SYNMODE    7
#define M_SYNMODE    0x3U
#define V_SYNMODE(x) ((x) << S_SYNMODE)
#define G_SYNMODE(x) (((x) >> S_SYNMODE) & M_SYNMODE)

#define S_LEBUSEN    5
#define V_LEBUSEN(x) ((x) << S_LEBUSEN)
#define F_LEBUSEN    V_LEBUSEN(1U)

#define S_ELOOKDUMEN    4
#define V_ELOOKDUMEN(x) ((x) << S_ELOOKDUMEN)
#define F_ELOOKDUMEN    V_ELOOKDUMEN(1U)

#define S_IPV4ONLYEN    3
#define V_IPV4ONLYEN(x) ((x) << S_IPV4ONLYEN)
#define F_IPV4ONLYEN    V_IPV4ONLYEN(1U)

#define S_MOSTCMDOEN    2
#define V_MOSTCMDOEN(x) ((x) << S_MOSTCMDOEN)
#define F_MOSTCMDOEN    V_MOSTCMDOEN(1U)

#define S_DELACTSYNOEN    1
#define V_DELACTSYNOEN(x) ((x) << S_DELACTSYNOEN)
#define F_DELACTSYNOEN    V_DELACTSYNOEN(1U)

#define S_CMDOVERLAPDIS    0
#define V_CMDOVERLAPDIS(x) ((x) << S_CMDOVERLAPDIS)
#define F_CMDOVERLAPDIS    V_CMDOVERLAPDIS(1U)

#define S_MASKCMDOLAPDIS    26
#define V_MASKCMDOLAPDIS(x) ((x) << S_MASKCMDOLAPDIS)
#define F_MASKCMDOLAPDIS    V_MASKCMDOLAPDIS(1U)

#define S_IPV4HASHSIZEEN    25
#define V_IPV4HASHSIZEEN(x) ((x) << S_IPV4HASHSIZEEN)
#define F_IPV4HASHSIZEEN    V_IPV4HASHSIZEEN(1U)

#define S_PROTOCOLMASKEN    24
#define V_PROTOCOLMASKEN(x) ((x) << S_PROTOCOLMASKEN)
#define F_PROTOCOLMASKEN    V_PROTOCOLMASKEN(1U)

#define S_TUPLESIZEEN    23
#define V_TUPLESIZEEN(x) ((x) << S_TUPLESIZEEN)
#define F_TUPLESIZEEN    V_TUPLESIZEEN(1U)

#define S_SRVRSRAMEN    22
#define V_SRVRSRAMEN(x) ((x) << S_SRVRSRAMEN)
#define F_SRVRSRAMEN    V_SRVRSRAMEN(1U)

#define S_ASBOTHSRCHENPR    19
#define V_ASBOTHSRCHENPR(x) ((x) << S_ASBOTHSRCHENPR)
#define F_ASBOTHSRCHENPR    V_ASBOTHSRCHENPR(1U)

#define S_POCLIPTID0    15
#define V_POCLIPTID0(x) ((x) << S_POCLIPTID0)
#define F_POCLIPTID0    V_POCLIPTID0(1U)

#define S_TCAMARBOFF    14
#define V_TCAMARBOFF(x) ((x) << S_TCAMARBOFF)
#define F_TCAMARBOFF    V_TCAMARBOFF(1U)

#define S_ACCNTFULLEN    13
#define V_ACCNTFULLEN(x) ((x) << S_ACCNTFULLEN)
#define F_ACCNTFULLEN    V_ACCNTFULLEN(1U)

#define S_FILTERRWNOCLIP    12
#define V_FILTERRWNOCLIP(x) ((x) << S_FILTERRWNOCLIP)
#define F_FILTERRWNOCLIP    V_FILTERRWNOCLIP(1U)

#define S_CRCHASH    10
#define V_CRCHASH(x) ((x) << S_CRCHASH)
#define F_CRCHASH    V_CRCHASH(1U)

#define S_COMPTID    9
#define V_COMPTID(x) ((x) << S_COMPTID)
#define F_COMPTID    V_COMPTID(1U)

#define S_SINGLETHREAD    6
#define V_SINGLETHREAD(x) ((x) << S_SINGLETHREAD)
#define F_SINGLETHREAD    V_SINGLETHREAD(1U)

#define A_LE_MISC 0x19c08

#define S_CMPUNVAIL    0
#define M_CMPUNVAIL    0xfU
#define V_CMPUNVAIL(x) ((x) << S_CMPUNVAIL)
#define G_CMPUNVAIL(x) (((x) >> S_CMPUNVAIL) & M_CMPUNVAIL)

#define S_SRAMDEEPSLEEP_STAT    11
#define V_SRAMDEEPSLEEP_STAT(x) ((x) << S_SRAMDEEPSLEEP_STAT)
#define F_SRAMDEEPSLEEP_STAT    V_SRAMDEEPSLEEP_STAT(1U)

#define S_TCAMDEEPSLEEP1_STAT    10
#define V_TCAMDEEPSLEEP1_STAT(x) ((x) << S_TCAMDEEPSLEEP1_STAT)
#define F_TCAMDEEPSLEEP1_STAT    V_TCAMDEEPSLEEP1_STAT(1U)

#define S_TCAMDEEPSLEEP0_STAT    9
#define V_TCAMDEEPSLEEP0_STAT(x) ((x) << S_TCAMDEEPSLEEP0_STAT)
#define F_TCAMDEEPSLEEP0_STAT    V_TCAMDEEPSLEEP0_STAT(1U)

#define S_SRAMDEEPSLEEP    8
#define V_SRAMDEEPSLEEP(x) ((x) << S_SRAMDEEPSLEEP)
#define F_SRAMDEEPSLEEP    V_SRAMDEEPSLEEP(1U)

#define S_TCAMDEEPSLEEP1    7
#define V_TCAMDEEPSLEEP1(x) ((x) << S_TCAMDEEPSLEEP1)
#define F_TCAMDEEPSLEEP1    V_TCAMDEEPSLEEP1(1U)

#define S_TCAMDEEPSLEEP0    6
#define V_TCAMDEEPSLEEP0(x) ((x) << S_TCAMDEEPSLEEP0)
#define F_TCAMDEEPSLEEP0    V_TCAMDEEPSLEEP0(1U)

#define S_SRVRAMCLKOFF    5
#define V_SRVRAMCLKOFF(x) ((x) << S_SRVRAMCLKOFF)
#define F_SRVRAMCLKOFF    V_SRVRAMCLKOFF(1U)

#define S_HASHCLKOFF    4
#define V_HASHCLKOFF(x) ((x) << S_HASHCLKOFF)
#define F_HASHCLKOFF    V_HASHCLKOFF(1U)

#define A_LE_DB_ROUTING_TABLE_INDEX 0x19c10

#define S_RTINDX    7
#define M_RTINDX    0x3fU
#define V_RTINDX(x) ((x) << S_RTINDX)
#define G_RTINDX(x) (((x) >> S_RTINDX) & M_RTINDX)

#define A_LE_DB_FILTER_TABLE_INDEX 0x19c14

#define S_FTINDX    7
#define M_FTINDX    0x3fU
#define V_FTINDX(x) ((x) << S_FTINDX)
#define G_FTINDX(x) (((x) >> S_FTINDX) & M_FTINDX)

#define A_LE_DB_SERVER_INDEX 0x19c18

#define S_SRINDX    7
#define M_SRINDX    0x3fU
#define V_SRINDX(x) ((x) << S_SRINDX)
#define G_SRINDX(x) (((x) >> S_SRINDX) & M_SRINDX)

#define A_LE_DB_CLIP_TABLE_INDEX 0x19c1c

#define S_CLIPTINDX    7
#define M_CLIPTINDX    0x3fU
#define V_CLIPTINDX(x) ((x) << S_CLIPTINDX)
#define G_CLIPTINDX(x) (((x) >> S_CLIPTINDX) & M_CLIPTINDX)

#define A_LE_DB_ACT_CNT_IPV4 0x19c20

#define S_ACTCNTIPV4    0
#define M_ACTCNTIPV4    0xfffffU
#define V_ACTCNTIPV4(x) ((x) << S_ACTCNTIPV4)
#define G_ACTCNTIPV4(x) (((x) >> S_ACTCNTIPV4) & M_ACTCNTIPV4)

#define A_LE_DB_ACT_CNT_IPV6 0x19c24

#define S_ACTCNTIPV6    0
#define M_ACTCNTIPV6    0xfffffU
#define V_ACTCNTIPV6(x) ((x) << S_ACTCNTIPV6)
#define G_ACTCNTIPV6(x) (((x) >> S_ACTCNTIPV6) & M_ACTCNTIPV6)

#define A_LE_DB_HASH_CONFIG 0x19c28

#define S_HASHTIDSIZE    16
#define M_HASHTIDSIZE    0x3fU
#define V_HASHTIDSIZE(x) ((x) << S_HASHTIDSIZE)
#define G_HASHTIDSIZE(x) (((x) >> S_HASHTIDSIZE) & M_HASHTIDSIZE)

#define S_HASHSIZE    0
#define M_HASHSIZE    0x3fU
#define V_HASHSIZE(x) ((x) << S_HASHSIZE)
#define G_HASHSIZE(x) (((x) >> S_HASHSIZE) & M_HASHSIZE)

#define A_LE_DB_HASH_TABLE_BASE 0x19c2c
#define A_LE_DB_HASH_TID_BASE 0x19c30
#define A_LE_DB_SIZE 0x19c34
#define A_LE_DB_INT_ENABLE 0x19c38

#define S_MSGSEL    27
#define M_MSGSEL    0x1fU
#define V_MSGSEL(x) ((x) << S_MSGSEL)
#define G_MSGSEL(x) (((x) >> S_MSGSEL) & M_MSGSEL)

#define S_REQQPARERR    16
#define V_REQQPARERR(x) ((x) << S_REQQPARERR)
#define F_REQQPARERR    V_REQQPARERR(1U)

#define S_UNKNOWNCMD    15
#define V_UNKNOWNCMD(x) ((x) << S_UNKNOWNCMD)
#define F_UNKNOWNCMD    V_UNKNOWNCMD(1U)

#define S_DROPFILTERHIT    13
#define V_DROPFILTERHIT(x) ((x) << S_DROPFILTERHIT)
#define F_DROPFILTERHIT    V_DROPFILTERHIT(1U)

#define S_FILTERHIT    12
#define V_FILTERHIT(x) ((x) << S_FILTERHIT)
#define F_FILTERHIT    V_FILTERHIT(1U)

#define S_SYNCOOKIEOFF    11
#define V_SYNCOOKIEOFF(x) ((x) << S_SYNCOOKIEOFF)
#define F_SYNCOOKIEOFF    V_SYNCOOKIEOFF(1U)

#define S_SYNCOOKIEBAD    10
#define V_SYNCOOKIEBAD(x) ((x) << S_SYNCOOKIEBAD)
#define F_SYNCOOKIEBAD    V_SYNCOOKIEBAD(1U)

#define S_SYNCOOKIE    9
#define V_SYNCOOKIE(x) ((x) << S_SYNCOOKIE)
#define F_SYNCOOKIE    V_SYNCOOKIE(1U)

#define S_NFASRCHFAIL    8
#define V_NFASRCHFAIL(x) ((x) << S_NFASRCHFAIL)
#define F_NFASRCHFAIL    V_NFASRCHFAIL(1U)

#define S_ACTRGNFULL    7
#define V_ACTRGNFULL(x) ((x) << S_ACTRGNFULL)
#define F_ACTRGNFULL    V_ACTRGNFULL(1U)

#define S_PARITYERR    6
#define V_PARITYERR(x) ((x) << S_PARITYERR)
#define F_PARITYERR    V_PARITYERR(1U)

#define S_LIPMISS    5
#define V_LIPMISS(x) ((x) << S_LIPMISS)
#define F_LIPMISS    V_LIPMISS(1U)

#define S_LIP0    4
#define V_LIP0(x) ((x) << S_LIP0)
#define F_LIP0    V_LIP0(1U)

#define S_MISS    3
#define V_MISS(x) ((x) << S_MISS)
#define F_MISS    V_MISS(1U)

#define S_ROUTINGHIT    2
#define V_ROUTINGHIT(x) ((x) << S_ROUTINGHIT)
#define F_ROUTINGHIT    V_ROUTINGHIT(1U)

#define S_ACTIVEHIT    1
#define V_ACTIVEHIT(x) ((x) << S_ACTIVEHIT)
#define F_ACTIVEHIT    V_ACTIVEHIT(1U)

#define S_SERVERHIT    0
#define V_SERVERHIT(x) ((x) << S_SERVERHIT)
#define F_SERVERHIT    V_SERVERHIT(1U)

#define S_ACTCNTIPV6TZERO    21
#define V_ACTCNTIPV6TZERO(x) ((x) << S_ACTCNTIPV6TZERO)
#define F_ACTCNTIPV6TZERO    V_ACTCNTIPV6TZERO(1U)

#define S_ACTCNTIPV4TZERO    20
#define V_ACTCNTIPV4TZERO(x) ((x) << S_ACTCNTIPV4TZERO)
#define F_ACTCNTIPV4TZERO    V_ACTCNTIPV4TZERO(1U)

#define S_ACTCNTIPV6ZERO    19
#define V_ACTCNTIPV6ZERO(x) ((x) << S_ACTCNTIPV6ZERO)
#define F_ACTCNTIPV6ZERO    V_ACTCNTIPV6ZERO(1U)

#define S_ACTCNTIPV4ZERO    18
#define V_ACTCNTIPV4ZERO(x) ((x) << S_ACTCNTIPV4ZERO)
#define F_ACTCNTIPV4ZERO    V_ACTCNTIPV4ZERO(1U)

#define S_MARSPPARERR    17
#define V_MARSPPARERR(x) ((x) << S_MARSPPARERR)
#define F_MARSPPARERR    V_MARSPPARERR(1U)

#define S_VFPARERR    14
#define V_VFPARERR(x) ((x) << S_VFPARERR)
#define F_VFPARERR    V_VFPARERR(1U)

#define A_LE_DB_INT_CAUSE 0x19c3c
#define A_LE_DB_INT_TID 0x19c40

#define S_INTTID    0
#define M_INTTID    0xfffffU
#define V_INTTID(x) ((x) << S_INTTID)
#define G_INTTID(x) (((x) >> S_INTTID) & M_INTTID)

#define A_LE_DB_INT_PTID 0x19c44

#define S_INTPTID    0
#define M_INTPTID    0xfffffU
#define V_INTPTID(x) ((x) << S_INTPTID)
#define G_INTPTID(x) (((x) >> S_INTPTID) & M_INTPTID)

#define A_LE_DB_INT_INDEX 0x19c48

#define S_INTINDEX    0
#define M_INTINDEX    0xfffffU
#define V_INTINDEX(x) ((x) << S_INTINDEX)
#define G_INTINDEX(x) (((x) >> S_INTINDEX) & M_INTINDEX)

#define A_LE_DB_INT_CMD 0x19c4c

#define S_INTCMD    0
#define M_INTCMD    0xfU
#define V_INTCMD(x) ((x) << S_INTCMD)
#define G_INTCMD(x) (((x) >> S_INTCMD) & M_INTCMD)

#define A_LE_DB_MASK_IPV4 0x19c50
#define A_LE_T5_DB_MASK_IPV4 0x19c50
#define A_LE_DB_ACT_CNT_IPV4_TCAM 0x19c94
#define A_LE_DB_ACT_CNT_IPV6_TCAM 0x19c98
#define A_LE_ACT_CNT_THRSH 0x19c9c

#define S_ACT_CNT_THRSH    0
#define M_ACT_CNT_THRSH    0x1fffffU
#define V_ACT_CNT_THRSH(x) ((x) << S_ACT_CNT_THRSH)
#define G_ACT_CNT_THRSH(x) (((x) >> S_ACT_CNT_THRSH) & M_ACT_CNT_THRSH)

#define A_LE_DB_MASK_IPV6 0x19ca0
#define A_LE_DB_REQ_RSP_CNT 0x19ce4

#define S_RSPCNTLE    16
#define M_RSPCNTLE    0xffffU
#define V_RSPCNTLE(x) ((x) << S_RSPCNTLE)
#define G_RSPCNTLE(x) (((x) >> S_RSPCNTLE) & M_RSPCNTLE)

#define S_REQCNTLE    0
#define M_REQCNTLE    0xffffU
#define V_REQCNTLE(x) ((x) << S_REQCNTLE)
#define G_REQCNTLE(x) (((x) >> S_REQCNTLE) & M_REQCNTLE)

#define A_LE_DB_DBGI_CONFIG 0x19cf0

#define S_DBGICMDPERR    31
#define V_DBGICMDPERR(x) ((x) << S_DBGICMDPERR)
#define F_DBGICMDPERR    V_DBGICMDPERR(1U)

#define S_DBGICMDRANGE    22
#define M_DBGICMDRANGE    0x7U
#define V_DBGICMDRANGE(x) ((x) << S_DBGICMDRANGE)
#define G_DBGICMDRANGE(x) (((x) >> S_DBGICMDRANGE) & M_DBGICMDRANGE)

#define S_DBGICMDMSKTYPE    21
#define V_DBGICMDMSKTYPE(x) ((x) << S_DBGICMDMSKTYPE)
#define F_DBGICMDMSKTYPE    V_DBGICMDMSKTYPE(1U)

#define S_DBGICMDSEARCH    20
#define V_DBGICMDSEARCH(x) ((x) << S_DBGICMDSEARCH)
#define F_DBGICMDSEARCH    V_DBGICMDSEARCH(1U)

#define S_DBGICMDREAD    19
#define V_DBGICMDREAD(x) ((x) << S_DBGICMDREAD)
#define F_DBGICMDREAD    V_DBGICMDREAD(1U)

#define S_DBGICMDLEARN    18
#define V_DBGICMDLEARN(x) ((x) << S_DBGICMDLEARN)
#define F_DBGICMDLEARN    V_DBGICMDLEARN(1U)

#define S_DBGICMDERASE    17
#define V_DBGICMDERASE(x) ((x) << S_DBGICMDERASE)
#define F_DBGICMDERASE    V_DBGICMDERASE(1U)

#define S_DBGICMDIPV6    16
#define V_DBGICMDIPV6(x) ((x) << S_DBGICMDIPV6)
#define F_DBGICMDIPV6    V_DBGICMDIPV6(1U)

#define S_DBGICMDTYPE    13
#define M_DBGICMDTYPE    0x7U
#define V_DBGICMDTYPE(x) ((x) << S_DBGICMDTYPE)
#define G_DBGICMDTYPE(x) (((x) >> S_DBGICMDTYPE) & M_DBGICMDTYPE)

#define S_DBGICMDACKERR    12
#define V_DBGICMDACKERR(x) ((x) << S_DBGICMDACKERR)
#define F_DBGICMDACKERR    V_DBGICMDACKERR(1U)

#define S_DBGICMDBUSY    3
#define V_DBGICMDBUSY(x) ((x) << S_DBGICMDBUSY)
#define F_DBGICMDBUSY    V_DBGICMDBUSY(1U)

#define S_DBGICMDSTRT    2
#define V_DBGICMDSTRT(x) ((x) << S_DBGICMDSTRT)
#define F_DBGICMDSTRT    V_DBGICMDSTRT(1U)

#define S_DBGICMDMODE    0
#define M_DBGICMDMODE    0x3U
#define V_DBGICMDMODE(x) ((x) << S_DBGICMDMODE)
#define G_DBGICMDMODE(x) (((x) >> S_DBGICMDMODE) & M_DBGICMDMODE)

#define A_LE_DB_DBGI_REQ_TCAM_CMD 0x19cf4

#define S_DBGICMD    20
#define M_DBGICMD    0xfU
#define V_DBGICMD(x) ((x) << S_DBGICMD)
#define G_DBGICMD(x) (((x) >> S_DBGICMD) & M_DBGICMD)

#define S_DBGITINDEX    0
#define M_DBGITINDEX    0xfffffU
#define V_DBGITINDEX(x) ((x) << S_DBGITINDEX)
#define G_DBGITINDEX(x) (((x) >> S_DBGITINDEX) & M_DBGITINDEX)

#define A_LE_PERR_ENABLE 0x19cf8

#define S_REQQUEUE    1
#define V_REQQUEUE(x) ((x) << S_REQQUEUE)
#define F_REQQUEUE    V_REQQUEUE(1U)

#define S_TCAM    0
#define V_TCAM(x) ((x) << S_TCAM)
#define F_TCAM    V_TCAM(1U)

#define S_MARSPPARERRLE    17
#define V_MARSPPARERRLE(x) ((x) << S_MARSPPARERRLE)
#define F_MARSPPARERRLE    V_MARSPPARERRLE(1U)

#define S_REQQUEUELE    16
#define V_REQQUEUELE(x) ((x) << S_REQQUEUELE)
#define F_REQQUEUELE    V_REQQUEUELE(1U)

#define S_VFPARERRLE    14
#define V_VFPARERRLE(x) ((x) << S_VFPARERRLE)
#define F_VFPARERRLE    V_VFPARERRLE(1U)

#define S_TCAMLE    6
#define V_TCAMLE(x) ((x) << S_TCAMLE)
#define F_TCAMLE    V_TCAMLE(1U)

#define A_LE_SPARE 0x19cfc
#define A_LE_DB_DBGI_REQ_DATA 0x19d00
#define A_LE_DB_DBGI_REQ_MASK 0x19d50
#define A_LE_DB_DBGI_RSP_STATUS 0x19d94

#define S_DBGIRSPINDEX    12
#define M_DBGIRSPINDEX    0xfffffU
#define V_DBGIRSPINDEX(x) ((x) << S_DBGIRSPINDEX)
#define G_DBGIRSPINDEX(x) (((x) >> S_DBGIRSPINDEX) & M_DBGIRSPINDEX)

#define S_DBGIRSPMSG    8
#define M_DBGIRSPMSG    0xfU
#define V_DBGIRSPMSG(x) ((x) << S_DBGIRSPMSG)
#define G_DBGIRSPMSG(x) (((x) >> S_DBGIRSPMSG) & M_DBGIRSPMSG)

#define S_DBGIRSPMSGVLD    7
#define V_DBGIRSPMSGVLD(x) ((x) << S_DBGIRSPMSGVLD)
#define F_DBGIRSPMSGVLD    V_DBGIRSPMSGVLD(1U)

#define S_DBGIRSPMHIT    2
#define V_DBGIRSPMHIT(x) ((x) << S_DBGIRSPMHIT)
#define F_DBGIRSPMHIT    V_DBGIRSPMHIT(1U)

#define S_DBGIRSPHIT    1
#define V_DBGIRSPHIT(x) ((x) << S_DBGIRSPHIT)
#define F_DBGIRSPHIT    V_DBGIRSPHIT(1U)

#define S_DBGIRSPVALID    0
#define V_DBGIRSPVALID(x) ((x) << S_DBGIRSPVALID)
#define F_DBGIRSPVALID    V_DBGIRSPVALID(1U)

#define A_LE_DB_DBGI_RSP_DATA 0x19da0
#define A_LE_DB_DBGI_RSP_LAST_CMD 0x19de4

#define S_LASTCMDB    16
#define M_LASTCMDB    0x7ffU
#define V_LASTCMDB(x) ((x) << S_LASTCMDB)
#define G_LASTCMDB(x) (((x) >> S_LASTCMDB) & M_LASTCMDB)

#define S_LASTCMDA    0
#define M_LASTCMDA    0x7ffU
#define V_LASTCMDA(x) ((x) << S_LASTCMDA)
#define G_LASTCMDA(x) (((x) >> S_LASTCMDA) & M_LASTCMDA)

#define A_LE_DB_DROP_FILTER_ENTRY 0x19de8

#define S_DROPFILTEREN    31
#define V_DROPFILTEREN(x) ((x) << S_DROPFILTEREN)
#define F_DROPFILTEREN    V_DROPFILTEREN(1U)

#define S_DROPFILTERCLEAR    17
#define V_DROPFILTERCLEAR(x) ((x) << S_DROPFILTERCLEAR)
#define F_DROPFILTERCLEAR    V_DROPFILTERCLEAR(1U)

#define S_DROPFILTERSET    16
#define V_DROPFILTERSET(x) ((x) << S_DROPFILTERSET)
#define F_DROPFILTERSET    V_DROPFILTERSET(1U)

#define S_DROPFILTERFIDX    0
#define M_DROPFILTERFIDX    0x1fffU
#define V_DROPFILTERFIDX(x) ((x) << S_DROPFILTERFIDX)
#define G_DROPFILTERFIDX(x) (((x) >> S_DROPFILTERFIDX) & M_DROPFILTERFIDX)

#define A_LE_DB_PTID_SVRBASE 0x19df0

#define S_SVRBASE_ADDR    2
#define M_SVRBASE_ADDR    0x3ffffU
#define V_SVRBASE_ADDR(x) ((x) << S_SVRBASE_ADDR)
#define G_SVRBASE_ADDR(x) (((x) >> S_SVRBASE_ADDR) & M_SVRBASE_ADDR)

#define A_LE_DB_FTID_FLTRBASE 0x19df4

#define S_FLTRBASE_ADDR    2
#define M_FLTRBASE_ADDR    0x3ffffU
#define V_FLTRBASE_ADDR(x) ((x) << S_FLTRBASE_ADDR)
#define G_FLTRBASE_ADDR(x) (((x) >> S_FLTRBASE_ADDR) & M_FLTRBASE_ADDR)

#define A_LE_DB_TID_HASHBASE 0x19df8

#define S_HASHBASE_ADDR    2
#define M_HASHBASE_ADDR    0xfffffU
#define V_HASHBASE_ADDR(x) ((x) << S_HASHBASE_ADDR)
#define G_HASHBASE_ADDR(x) (((x) >> S_HASHBASE_ADDR) & M_HASHBASE_ADDR)

#define A_LE_PERR_INJECT 0x19dfc

#define S_LEMEMSEL    1
#define M_LEMEMSEL    0x7U
#define V_LEMEMSEL(x) ((x) << S_LEMEMSEL)
#define G_LEMEMSEL(x) (((x) >> S_LEMEMSEL) & M_LEMEMSEL)

#define A_LE_DB_ACTIVE_MASK_IPV4 0x19e00
#define A_LE_T5_DB_ACTIVE_MASK_IPV4 0x19e00
#define A_LE_DB_ACTIVE_MASK_IPV6 0x19e50
#define A_LE_HASH_MASK_GEN_IPV4 0x19ea0
#define A_LE_HASH_MASK_GEN_IPV4T5 0x19ea0
#define A_LE_HASH_MASK_GEN_IPV6 0x19eb0
#define A_LE_HASH_MASK_GEN_IPV6T5 0x19eb4
#define A_LE_HASH_MASK_CMP_IPV4 0x19ee0
#define A_LE_HASH_MASK_CMP_IPV4T5 0x19ee4
#define A_LE_HASH_MASK_CMP_IPV6 0x19ef0
#define A_LE_HASH_MASK_CMP_IPV6T5 0x19ef8
#define A_LE_DEBUG_LA_CONFIG 0x19f20
#define A_LE_REQ_DEBUG_LA_DATA 0x19f24
#define A_LE_REQ_DEBUG_LA_WRPTR 0x19f28
#define A_LE_RSP_DEBUG_LA_DATA 0x19f2c
#define A_LE_RSP_DEBUG_LA_WRPTR 0x19f30
#define A_LE_DEBUG_LA_SELECTOR 0x19f34
#define A_LE_SRVR_SRAM_INIT 0x19f34

#define S_SRVRSRAMBASE    2
#define M_SRVRSRAMBASE    0xfffffU
#define V_SRVRSRAMBASE(x) ((x) << S_SRVRSRAMBASE)
#define G_SRVRSRAMBASE(x) (((x) >> S_SRVRSRAMBASE) & M_SRVRSRAMBASE)

#define S_SRVRINITBUSY    1
#define V_SRVRINITBUSY(x) ((x) << S_SRVRINITBUSY)
#define F_SRVRINITBUSY    V_SRVRINITBUSY(1U)

#define S_SRVRINIT    0
#define V_SRVRINIT(x) ((x) << S_SRVRINIT)
#define F_SRVRINIT    V_SRVRINIT(1U)

#define A_LE_DEBUG_LA_CAPTURED_DATA 0x19f38
#define A_LE_SRVR_VF_SRCH_TABLE 0x19f38

#define S_RDWR    21
#define V_RDWR(x) ((x) << S_RDWR)
#define F_RDWR    V_RDWR(1U)

#define S_VFINDEX    14
#define M_VFINDEX    0x7fU
#define V_VFINDEX(x) ((x) << S_VFINDEX)
#define G_VFINDEX(x) (((x) >> S_VFINDEX) & M_VFINDEX)

#define S_SRCHHADDR    7
#define M_SRCHHADDR    0x7fU
#define V_SRCHHADDR(x) ((x) << S_SRCHHADDR)
#define G_SRCHHADDR(x) (((x) >> S_SRCHHADDR) & M_SRCHHADDR)

#define S_SRCHLADDR    0
#define M_SRCHLADDR    0x7fU
#define V_SRCHLADDR(x) ((x) << S_SRCHLADDR)
#define G_SRCHLADDR(x) (((x) >> S_SRCHLADDR) & M_SRCHLADDR)

#define A_LE_MA_DEBUG_LA_DATA 0x19f3c
#define A_LE_RSP_DEBUG_LA_HASH_WRPTR 0x19f40
#define A_LE_DB_SECOND_ACTIVE_MASK_IPV4 0x19f40
#define A_LE_HASH_DEBUG_LA_DATA 0x19f44
#define A_LE_RSP_DEBUG_LA_TCAM_WRPTR 0x19f48
#define A_LE_TCAM_DEBUG_LA_DATA 0x19f4c
#define A_LE_DB_SECOND_GEN_HASH_MASK_IPV4 0x19f90
#define A_LE_DB_SECOND_CMP_HASH_MASK_IPV4 0x19fa4
#define A_LE_HASH_COLLISION 0x19fc4
#define A_LE_GLOBAL_COLLISION 0x19fc8
#define A_LE_FULL_CNT_COLLISION 0x19fcc
#define A_LE_DEBUG_LA_CONFIGT5 0x19fd0
#define A_LE_REQ_DEBUG_LA_DATAT5 0x19fd4
#define A_LE_REQ_DEBUG_LA_WRPTRT5 0x19fd8
#define A_LE_RSP_DEBUG_LA_DATAT5 0x19fdc
#define A_LE_RSP_DEBUG_LA_WRPTRT5 0x19fe0
#define A_LE_DEBUG_LA_SEL_DATA 0x19fe4

/* registers for module NCSI */
#define NCSI_BASE_ADDR 0x1a000

#define A_NCSI_PORT_CFGREG 0x1a000

#define S_WIREEN    28
#define M_WIREEN    0xfU
#define V_WIREEN(x) ((x) << S_WIREEN)
#define G_WIREEN(x) (((x) >> S_WIREEN) & M_WIREEN)

#define S_STRP_CRC    24
#define M_STRP_CRC    0xfU
#define V_STRP_CRC(x) ((x) << S_STRP_CRC)
#define G_STRP_CRC(x) (((x) >> S_STRP_CRC) & M_STRP_CRC)

#define S_RX_HALT    22
#define V_RX_HALT(x) ((x) << S_RX_HALT)
#define F_RX_HALT    V_RX_HALT(1U)

#define S_FLUSH_RX_FIFO    21
#define V_FLUSH_RX_FIFO(x) ((x) << S_FLUSH_RX_FIFO)
#define F_FLUSH_RX_FIFO    V_FLUSH_RX_FIFO(1U)

#define S_HW_ARB_EN    20
#define V_HW_ARB_EN(x) ((x) << S_HW_ARB_EN)
#define F_HW_ARB_EN    V_HW_ARB_EN(1U)

#define S_SOFT_PKG_SEL    19
#define V_SOFT_PKG_SEL(x) ((x) << S_SOFT_PKG_SEL)
#define F_SOFT_PKG_SEL    V_SOFT_PKG_SEL(1U)

#define S_ERR_DISCARD_EN    18
#define V_ERR_DISCARD_EN(x) ((x) << S_ERR_DISCARD_EN)
#define F_ERR_DISCARD_EN    V_ERR_DISCARD_EN(1U)

#define S_MAX_PKT_SIZE    4
#define M_MAX_PKT_SIZE    0x3fffU
#define V_MAX_PKT_SIZE(x) ((x) << S_MAX_PKT_SIZE)
#define G_MAX_PKT_SIZE(x) (((x) >> S_MAX_PKT_SIZE) & M_MAX_PKT_SIZE)

#define S_RX_BYTE_SWAP    3
#define V_RX_BYTE_SWAP(x) ((x) << S_RX_BYTE_SWAP)
#define F_RX_BYTE_SWAP    V_RX_BYTE_SWAP(1U)

#define S_TX_BYTE_SWAP    2
#define V_TX_BYTE_SWAP(x) ((x) << S_TX_BYTE_SWAP)
#define F_TX_BYTE_SWAP    V_TX_BYTE_SWAP(1U)

#define A_NCSI_RST_CTRL 0x1a004

#define S_MAC_REF_RST    2
#define V_MAC_REF_RST(x) ((x) << S_MAC_REF_RST)
#define F_MAC_REF_RST    V_MAC_REF_RST(1U)

#define S_MAC_RX_RST    1
#define V_MAC_RX_RST(x) ((x) << S_MAC_RX_RST)
#define F_MAC_RX_RST    V_MAC_RX_RST(1U)

#define S_MAC_TX_RST    0
#define V_MAC_TX_RST(x) ((x) << S_MAC_TX_RST)
#define F_MAC_TX_RST    V_MAC_TX_RST(1U)

#define A_NCSI_CH0_SADDR_LOW 0x1a010
#define A_NCSI_CH0_SADDR_HIGH 0x1a014

#define S_CHO_SADDR_EN    31
#define V_CHO_SADDR_EN(x) ((x) << S_CHO_SADDR_EN)
#define F_CHO_SADDR_EN    V_CHO_SADDR_EN(1U)

#define S_CH0_SADDR_HIGH    0
#define M_CH0_SADDR_HIGH    0xffffU
#define V_CH0_SADDR_HIGH(x) ((x) << S_CH0_SADDR_HIGH)
#define G_CH0_SADDR_HIGH(x) (((x) >> S_CH0_SADDR_HIGH) & M_CH0_SADDR_HIGH)

#define A_NCSI_CH1_SADDR_LOW 0x1a018
#define A_NCSI_CH1_SADDR_HIGH 0x1a01c

#define S_CH1_SADDR_EN    31
#define V_CH1_SADDR_EN(x) ((x) << S_CH1_SADDR_EN)
#define F_CH1_SADDR_EN    V_CH1_SADDR_EN(1U)

#define S_CH1_SADDR_HIGH    0
#define M_CH1_SADDR_HIGH    0xffffU
#define V_CH1_SADDR_HIGH(x) ((x) << S_CH1_SADDR_HIGH)
#define G_CH1_SADDR_HIGH(x) (((x) >> S_CH1_SADDR_HIGH) & M_CH1_SADDR_HIGH)

#define A_NCSI_CH2_SADDR_LOW 0x1a020
#define A_NCSI_CH2_SADDR_HIGH 0x1a024

#define S_CH2_SADDR_EN    31
#define V_CH2_SADDR_EN(x) ((x) << S_CH2_SADDR_EN)
#define F_CH2_SADDR_EN    V_CH2_SADDR_EN(1U)

#define S_CH2_SADDR_HIGH    0
#define M_CH2_SADDR_HIGH    0xffffU
#define V_CH2_SADDR_HIGH(x) ((x) << S_CH2_SADDR_HIGH)
#define G_CH2_SADDR_HIGH(x) (((x) >> S_CH2_SADDR_HIGH) & M_CH2_SADDR_HIGH)

#define A_NCSI_CH3_SADDR_LOW 0x1a028
#define A_NCSI_CH3_SADDR_HIGH 0x1a02c

#define S_CH3_SADDR_EN    31
#define V_CH3_SADDR_EN(x) ((x) << S_CH3_SADDR_EN)
#define F_CH3_SADDR_EN    V_CH3_SADDR_EN(1U)

#define S_CH3_SADDR_HIGH    0
#define M_CH3_SADDR_HIGH    0xffffU
#define V_CH3_SADDR_HIGH(x) ((x) << S_CH3_SADDR_HIGH)
#define G_CH3_SADDR_HIGH(x) (((x) >> S_CH3_SADDR_HIGH) & M_CH3_SADDR_HIGH)

#define A_NCSI_WORK_REQHDR_0 0x1a030
#define A_NCSI_WORK_REQHDR_1 0x1a034
#define A_NCSI_WORK_REQHDR_2 0x1a038
#define A_NCSI_WORK_REQHDR_3 0x1a03c
#define A_NCSI_MPS_HDR_LO 0x1a040
#define A_NCSI_MPS_HDR_HI 0x1a044
#define A_NCSI_CTL 0x1a048

#define S_STRIP_OVLAN    3
#define V_STRIP_OVLAN(x) ((x) << S_STRIP_OVLAN)
#define F_STRIP_OVLAN    V_STRIP_OVLAN(1U)

#define S_BMC_DROP_NON_BC    2
#define V_BMC_DROP_NON_BC(x) ((x) << S_BMC_DROP_NON_BC)
#define F_BMC_DROP_NON_BC    V_BMC_DROP_NON_BC(1U)

#define S_BMC_RX_FWD_ALL    1
#define V_BMC_RX_FWD_ALL(x) ((x) << S_BMC_RX_FWD_ALL)
#define F_BMC_RX_FWD_ALL    V_BMC_RX_FWD_ALL(1U)

#define S_FWD_BMC    0
#define V_FWD_BMC(x) ((x) << S_FWD_BMC)
#define F_FWD_BMC    V_FWD_BMC(1U)

#define A_NCSI_NCSI_ETYPE 0x1a04c

#define S_NCSI_ETHERTYPE    0
#define M_NCSI_ETHERTYPE    0xffffU
#define V_NCSI_ETHERTYPE(x) ((x) << S_NCSI_ETHERTYPE)
#define G_NCSI_ETHERTYPE(x) (((x) >> S_NCSI_ETHERTYPE) & M_NCSI_ETHERTYPE)

#define A_NCSI_RX_FIFO_CNT 0x1a050

#define S_NCSI_RXFIFO_CNT    0
#define M_NCSI_RXFIFO_CNT    0x7ffU
#define V_NCSI_RXFIFO_CNT(x) ((x) << S_NCSI_RXFIFO_CNT)
#define G_NCSI_RXFIFO_CNT(x) (((x) >> S_NCSI_RXFIFO_CNT) & M_NCSI_RXFIFO_CNT)

#define A_NCSI_RX_ERR_CNT 0x1a054
#define A_NCSI_RX_OF_CNT 0x1a058
#define A_NCSI_RX_MS_CNT 0x1a05c
#define A_NCSI_RX_IE_CNT 0x1a060
#define A_NCSI_MPS_DEMUX_CNT 0x1a064

#define S_MPS2CIM_CNT    16
#define M_MPS2CIM_CNT    0x1ffU
#define V_MPS2CIM_CNT(x) ((x) << S_MPS2CIM_CNT)
#define G_MPS2CIM_CNT(x) (((x) >> S_MPS2CIM_CNT) & M_MPS2CIM_CNT)

#define S_MPS2BMC_CNT    0
#define M_MPS2BMC_CNT    0x1ffU
#define V_MPS2BMC_CNT(x) ((x) << S_MPS2BMC_CNT)
#define G_MPS2BMC_CNT(x) (((x) >> S_MPS2BMC_CNT) & M_MPS2BMC_CNT)

#define A_NCSI_CIM_DEMUX_CNT 0x1a068

#define S_CIM2MPS_CNT    16
#define M_CIM2MPS_CNT    0x1ffU
#define V_CIM2MPS_CNT(x) ((x) << S_CIM2MPS_CNT)
#define G_CIM2MPS_CNT(x) (((x) >> S_CIM2MPS_CNT) & M_CIM2MPS_CNT)

#define S_CIM2BMC_CNT    0
#define M_CIM2BMC_CNT    0x1ffU
#define V_CIM2BMC_CNT(x) ((x) << S_CIM2BMC_CNT)
#define G_CIM2BMC_CNT(x) (((x) >> S_CIM2BMC_CNT) & M_CIM2BMC_CNT)

#define A_NCSI_TX_FIFO_CNT 0x1a06c

#define S_TX_FIFO_CNT    0
#define M_TX_FIFO_CNT    0x3ffU
#define V_TX_FIFO_CNT(x) ((x) << S_TX_FIFO_CNT)
#define G_TX_FIFO_CNT(x) (((x) >> S_TX_FIFO_CNT) & M_TX_FIFO_CNT)

#define A_NCSI_SE_CNT_CTL 0x1a0b0

#define S_SE_CNT_CLR    0
#define M_SE_CNT_CLR    0xfU
#define V_SE_CNT_CLR(x) ((x) << S_SE_CNT_CLR)
#define G_SE_CNT_CLR(x) (((x) >> S_SE_CNT_CLR) & M_SE_CNT_CLR)

#define A_NCSI_SE_CNT_MPS 0x1a0b4

#define S_NC2MPS_SOP_CNT    24
#define M_NC2MPS_SOP_CNT    0xffU
#define V_NC2MPS_SOP_CNT(x) ((x) << S_NC2MPS_SOP_CNT)
#define G_NC2MPS_SOP_CNT(x) (((x) >> S_NC2MPS_SOP_CNT) & M_NC2MPS_SOP_CNT)

#define S_NC2MPS_EOP_CNT    16
#define M_NC2MPS_EOP_CNT    0x3fU
#define V_NC2MPS_EOP_CNT(x) ((x) << S_NC2MPS_EOP_CNT)
#define G_NC2MPS_EOP_CNT(x) (((x) >> S_NC2MPS_EOP_CNT) & M_NC2MPS_EOP_CNT)

#define S_MPS2NC_SOP_CNT    8
#define M_MPS2NC_SOP_CNT    0xffU
#define V_MPS2NC_SOP_CNT(x) ((x) << S_MPS2NC_SOP_CNT)
#define G_MPS2NC_SOP_CNT(x) (((x) >> S_MPS2NC_SOP_CNT) & M_MPS2NC_SOP_CNT)

#define S_MPS2NC_EOP_CNT    0
#define M_MPS2NC_EOP_CNT    0xffU
#define V_MPS2NC_EOP_CNT(x) ((x) << S_MPS2NC_EOP_CNT)
#define G_MPS2NC_EOP_CNT(x) (((x) >> S_MPS2NC_EOP_CNT) & M_MPS2NC_EOP_CNT)

#define A_NCSI_SE_CNT_CIM 0x1a0b8

#define S_NC2CIM_SOP_CNT    24
#define M_NC2CIM_SOP_CNT    0xffU
#define V_NC2CIM_SOP_CNT(x) ((x) << S_NC2CIM_SOP_CNT)
#define G_NC2CIM_SOP_CNT(x) (((x) >> S_NC2CIM_SOP_CNT) & M_NC2CIM_SOP_CNT)

#define S_NC2CIM_EOP_CNT    16
#define M_NC2CIM_EOP_CNT    0x3fU
#define V_NC2CIM_EOP_CNT(x) ((x) << S_NC2CIM_EOP_CNT)
#define G_NC2CIM_EOP_CNT(x) (((x) >> S_NC2CIM_EOP_CNT) & M_NC2CIM_EOP_CNT)

#define S_CIM2NC_SOP_CNT    8
#define M_CIM2NC_SOP_CNT    0xffU
#define V_CIM2NC_SOP_CNT(x) ((x) << S_CIM2NC_SOP_CNT)
#define G_CIM2NC_SOP_CNT(x) (((x) >> S_CIM2NC_SOP_CNT) & M_CIM2NC_SOP_CNT)

#define S_CIM2NC_EOP_CNT    0
#define M_CIM2NC_EOP_CNT    0xffU
#define V_CIM2NC_EOP_CNT(x) ((x) << S_CIM2NC_EOP_CNT)
#define G_CIM2NC_EOP_CNT(x) (((x) >> S_CIM2NC_EOP_CNT) & M_CIM2NC_EOP_CNT)

#define A_NCSI_BUS_DEBUG 0x1a0bc

#define S_SOP_CNT_ERR    12
#define M_SOP_CNT_ERR    0xfU
#define V_SOP_CNT_ERR(x) ((x) << S_SOP_CNT_ERR)
#define G_SOP_CNT_ERR(x) (((x) >> S_SOP_CNT_ERR) & M_SOP_CNT_ERR)

#define S_BUS_STATE_MPS_OUT    6
#define M_BUS_STATE_MPS_OUT    0x3U
#define V_BUS_STATE_MPS_OUT(x) ((x) << S_BUS_STATE_MPS_OUT)
#define G_BUS_STATE_MPS_OUT(x) (((x) >> S_BUS_STATE_MPS_OUT) & M_BUS_STATE_MPS_OUT)

#define S_BUS_STATE_MPS_IN    4
#define M_BUS_STATE_MPS_IN    0x3U
#define V_BUS_STATE_MPS_IN(x) ((x) << S_BUS_STATE_MPS_IN)
#define G_BUS_STATE_MPS_IN(x) (((x) >> S_BUS_STATE_MPS_IN) & M_BUS_STATE_MPS_IN)

#define S_BUS_STATE_CIM_OUT    2
#define M_BUS_STATE_CIM_OUT    0x3U
#define V_BUS_STATE_CIM_OUT(x) ((x) << S_BUS_STATE_CIM_OUT)
#define G_BUS_STATE_CIM_OUT(x) (((x) >> S_BUS_STATE_CIM_OUT) & M_BUS_STATE_CIM_OUT)

#define S_BUS_STATE_CIM_IN    0
#define M_BUS_STATE_CIM_IN    0x3U
#define V_BUS_STATE_CIM_IN(x) ((x) << S_BUS_STATE_CIM_IN)
#define G_BUS_STATE_CIM_IN(x) (((x) >> S_BUS_STATE_CIM_IN) & M_BUS_STATE_CIM_IN)

#define A_NCSI_LA_RDPTR 0x1a0c0
#define A_NCSI_LA_RDDATA 0x1a0c4
#define A_NCSI_LA_WRPTR 0x1a0c8
#define A_NCSI_LA_RESERVED 0x1a0cc
#define A_NCSI_LA_CTL 0x1a0d0
#define A_NCSI_INT_ENABLE 0x1a0d4

#define S_CIM_DM_PRTY_ERR    8
#define V_CIM_DM_PRTY_ERR(x) ((x) << S_CIM_DM_PRTY_ERR)
#define F_CIM_DM_PRTY_ERR    V_CIM_DM_PRTY_ERR(1U)

#define S_MPS_DM_PRTY_ERR    7
#define V_MPS_DM_PRTY_ERR(x) ((x) << S_MPS_DM_PRTY_ERR)
#define F_MPS_DM_PRTY_ERR    V_MPS_DM_PRTY_ERR(1U)

#define S_TOKEN    6
#define V_TOKEN(x) ((x) << S_TOKEN)
#define F_TOKEN    V_TOKEN(1U)

#define S_ARB_DONE    5
#define V_ARB_DONE(x) ((x) << S_ARB_DONE)
#define F_ARB_DONE    V_ARB_DONE(1U)

#define S_ARB_STARTED    4
#define V_ARB_STARTED(x) ((x) << S_ARB_STARTED)
#define F_ARB_STARTED    V_ARB_STARTED(1U)

#define S_WOL    3
#define V_WOL(x) ((x) << S_WOL)
#define F_WOL    V_WOL(1U)

#define S_MACINT    2
#define V_MACINT(x) ((x) << S_MACINT)
#define F_MACINT    V_MACINT(1U)

#define S_TXFIFO_PRTY_ERR    1
#define V_TXFIFO_PRTY_ERR(x) ((x) << S_TXFIFO_PRTY_ERR)
#define F_TXFIFO_PRTY_ERR    V_TXFIFO_PRTY_ERR(1U)

#define S_RXFIFO_PRTY_ERR    0
#define V_RXFIFO_PRTY_ERR(x) ((x) << S_RXFIFO_PRTY_ERR)
#define F_RXFIFO_PRTY_ERR    V_RXFIFO_PRTY_ERR(1U)

#define A_NCSI_INT_CAUSE 0x1a0d8
#define A_NCSI_STATUS 0x1a0dc

#define S_MASTER    1
#define V_MASTER(x) ((x) << S_MASTER)
#define F_MASTER    V_MASTER(1U)

#define S_ARB_STATUS    0
#define V_ARB_STATUS(x) ((x) << S_ARB_STATUS)
#define F_ARB_STATUS    V_ARB_STATUS(1U)

#define A_NCSI_PAUSE_CTRL 0x1a0e0

#define S_FORCEPAUSE    0
#define V_FORCEPAUSE(x) ((x) << S_FORCEPAUSE)
#define F_FORCEPAUSE    V_FORCEPAUSE(1U)

#define A_NCSI_PAUSE_TIMEOUT 0x1a0e4
#define A_NCSI_PAUSE_WM 0x1a0ec

#define S_PAUSEHWM    16
#define M_PAUSEHWM    0x7ffU
#define V_PAUSEHWM(x) ((x) << S_PAUSEHWM)
#define G_PAUSEHWM(x) (((x) >> S_PAUSEHWM) & M_PAUSEHWM)

#define S_PAUSELWM    0
#define M_PAUSELWM    0x7ffU
#define V_PAUSELWM(x) ((x) << S_PAUSELWM)
#define G_PAUSELWM(x) (((x) >> S_PAUSELWM) & M_PAUSELWM)

#define A_NCSI_DEBUG 0x1a0f0

#define S_DEBUGSEL    0
#define M_DEBUGSEL    0x3fU
#define V_DEBUGSEL(x) ((x) << S_DEBUGSEL)
#define G_DEBUGSEL(x) (((x) >> S_DEBUGSEL) & M_DEBUGSEL)

#define S_TXFIFO_EMPTY    4
#define V_TXFIFO_EMPTY(x) ((x) << S_TXFIFO_EMPTY)
#define F_TXFIFO_EMPTY    V_TXFIFO_EMPTY(1U)

#define S_TXFIFO_FULL    3
#define V_TXFIFO_FULL(x) ((x) << S_TXFIFO_FULL)
#define F_TXFIFO_FULL    V_TXFIFO_FULL(1U)

#define S_PKG_ID    0
#define M_PKG_ID    0x7U
#define V_PKG_ID(x) ((x) << S_PKG_ID)
#define G_PKG_ID(x) (((x) >> S_PKG_ID) & M_PKG_ID)

#define A_NCSI_PERR_INJECT 0x1a0f4

#define S_MCSIMELSEL    1
#define V_MCSIMELSEL(x) ((x) << S_MCSIMELSEL)
#define F_MCSIMELSEL    V_MCSIMELSEL(1U)

#define A_NCSI_PERR_ENABLE 0x1a0f8
#define A_NCSI_MACB_NETWORK_CTRL 0x1a100

#define S_TXSNDZEROPAUSE    12
#define V_TXSNDZEROPAUSE(x) ((x) << S_TXSNDZEROPAUSE)
#define F_TXSNDZEROPAUSE    V_TXSNDZEROPAUSE(1U)

#define S_TXSNDPAUSE    11
#define V_TXSNDPAUSE(x) ((x) << S_TXSNDPAUSE)
#define F_TXSNDPAUSE    V_TXSNDPAUSE(1U)

#define S_TXSTOP    10
#define V_TXSTOP(x) ((x) << S_TXSTOP)
#define F_TXSTOP    V_TXSTOP(1U)

#define S_TXSTART    9
#define V_TXSTART(x) ((x) << S_TXSTART)
#define F_TXSTART    V_TXSTART(1U)

#define S_BACKPRESS    8
#define V_BACKPRESS(x) ((x) << S_BACKPRESS)
#define F_BACKPRESS    V_BACKPRESS(1U)

#define S_STATWREN    7
#define V_STATWREN(x) ((x) << S_STATWREN)
#define F_STATWREN    V_STATWREN(1U)

#define S_INCRSTAT    6
#define V_INCRSTAT(x) ((x) << S_INCRSTAT)
#define F_INCRSTAT    V_INCRSTAT(1U)

#define S_CLEARSTAT    5
#define V_CLEARSTAT(x) ((x) << S_CLEARSTAT)
#define F_CLEARSTAT    V_CLEARSTAT(1U)

#define S_ENMGMTPORT    4
#define V_ENMGMTPORT(x) ((x) << S_ENMGMTPORT)
#define F_ENMGMTPORT    V_ENMGMTPORT(1U)

#define S_NCSITXEN    3
#define V_NCSITXEN(x) ((x) << S_NCSITXEN)
#define F_NCSITXEN    V_NCSITXEN(1U)

#define S_NCSIRXEN    2
#define V_NCSIRXEN(x) ((x) << S_NCSIRXEN)
#define F_NCSIRXEN    V_NCSIRXEN(1U)

#define S_LOOPLOCAL    1
#define V_LOOPLOCAL(x) ((x) << S_LOOPLOCAL)
#define F_LOOPLOCAL    V_LOOPLOCAL(1U)

#define S_LOOPPHY    0
#define V_LOOPPHY(x) ((x) << S_LOOPPHY)
#define F_LOOPPHY    V_LOOPPHY(1U)

#define A_NCSI_MACB_NETWORK_CFG 0x1a104

#define S_PCLKDIV128    22
#define V_PCLKDIV128(x) ((x) << S_PCLKDIV128)
#define F_PCLKDIV128    V_PCLKDIV128(1U)

#define S_COPYPAUSE    21
#define V_COPYPAUSE(x) ((x) << S_COPYPAUSE)
#define F_COPYPAUSE    V_COPYPAUSE(1U)

#define S_NONSTDPREOK    20
#define V_NONSTDPREOK(x) ((x) << S_NONSTDPREOK)
#define F_NONSTDPREOK    V_NONSTDPREOK(1U)

#define S_NOFCS    19
#define V_NOFCS(x) ((x) << S_NOFCS)
#define F_NOFCS    V_NOFCS(1U)

#define S_RXENHALFDUP    18
#define V_RXENHALFDUP(x) ((x) << S_RXENHALFDUP)
#define F_RXENHALFDUP    V_RXENHALFDUP(1U)

#define S_NOCOPYFCS    17
#define V_NOCOPYFCS(x) ((x) << S_NOCOPYFCS)
#define F_NOCOPYFCS    V_NOCOPYFCS(1U)

#define S_LENCHKEN    16
#define V_LENCHKEN(x) ((x) << S_LENCHKEN)
#define F_LENCHKEN    V_LENCHKEN(1U)

#define S_RXBUFOFFSET    14
#define M_RXBUFOFFSET    0x3U
#define V_RXBUFOFFSET(x) ((x) << S_RXBUFOFFSET)
#define G_RXBUFOFFSET(x) (((x) >> S_RXBUFOFFSET) & M_RXBUFOFFSET)

#define S_PAUSEEN    13
#define V_PAUSEEN(x) ((x) << S_PAUSEEN)
#define F_PAUSEEN    V_PAUSEEN(1U)

#define S_RETRYTEST    12
#define V_RETRYTEST(x) ((x) << S_RETRYTEST)
#define F_RETRYTEST    V_RETRYTEST(1U)

#define S_PCLKDIV    10
#define M_PCLKDIV    0x3U
#define V_PCLKDIV(x) ((x) << S_PCLKDIV)
#define G_PCLKDIV(x) (((x) >> S_PCLKDIV) & M_PCLKDIV)

#define S_EXTCLASS    9
#define V_EXTCLASS(x) ((x) << S_EXTCLASS)
#define F_EXTCLASS    V_EXTCLASS(1U)

#define S_EN1536FRAME    8
#define V_EN1536FRAME(x) ((x) << S_EN1536FRAME)
#define F_EN1536FRAME    V_EN1536FRAME(1U)

#define S_UCASTHASHEN    7
#define V_UCASTHASHEN(x) ((x) << S_UCASTHASHEN)
#define F_UCASTHASHEN    V_UCASTHASHEN(1U)

#define S_MCASTHASHEN    6
#define V_MCASTHASHEN(x) ((x) << S_MCASTHASHEN)
#define F_MCASTHASHEN    V_MCASTHASHEN(1U)

#define S_RXBCASTDIS    5
#define V_RXBCASTDIS(x) ((x) << S_RXBCASTDIS)
#define F_RXBCASTDIS    V_RXBCASTDIS(1U)

#define S_NCSICOPYALLFRAMES    4
#define V_NCSICOPYALLFRAMES(x) ((x) << S_NCSICOPYALLFRAMES)
#define F_NCSICOPYALLFRAMES    V_NCSICOPYALLFRAMES(1U)

#define S_JUMBOEN    3
#define V_JUMBOEN(x) ((x) << S_JUMBOEN)
#define F_JUMBOEN    V_JUMBOEN(1U)

#define S_SEREN    2
#define V_SEREN(x) ((x) << S_SEREN)
#define F_SEREN    V_SEREN(1U)

#define S_FULLDUPLEX    1
#define V_FULLDUPLEX(x) ((x) << S_FULLDUPLEX)
#define F_FULLDUPLEX    V_FULLDUPLEX(1U)

#define S_SPEED    0
#define V_SPEED(x) ((x) << S_SPEED)
#define F_SPEED    V_SPEED(1U)

#define A_NCSI_MACB_NETWORK_STATUS 0x1a108

#define S_PHYMGMTSTATUS    2
#define V_PHYMGMTSTATUS(x) ((x) << S_PHYMGMTSTATUS)
#define F_PHYMGMTSTATUS    V_PHYMGMTSTATUS(1U)

#define S_MDISTATUS    1
#define V_MDISTATUS(x) ((x) << S_MDISTATUS)
#define F_MDISTATUS    V_MDISTATUS(1U)

#define S_LINKSTATUS    0
#define V_LINKSTATUS(x) ((x) << S_LINKSTATUS)
#define F_LINKSTATUS    V_LINKSTATUS(1U)

#define A_NCSI_MACB_TX_STATUS 0x1a114

#define S_UNDERRUNERR    6
#define V_UNDERRUNERR(x) ((x) << S_UNDERRUNERR)
#define F_UNDERRUNERR    V_UNDERRUNERR(1U)

#define S_TXCOMPLETE    5
#define V_TXCOMPLETE(x) ((x) << S_TXCOMPLETE)
#define F_TXCOMPLETE    V_TXCOMPLETE(1U)

#define S_BUFFEREXHAUSTED    4
#define V_BUFFEREXHAUSTED(x) ((x) << S_BUFFEREXHAUSTED)
#define F_BUFFEREXHAUSTED    V_BUFFEREXHAUSTED(1U)

#define S_TXPROGRESS    3
#define V_TXPROGRESS(x) ((x) << S_TXPROGRESS)
#define F_TXPROGRESS    V_TXPROGRESS(1U)

#define S_RETRYLIMIT    2
#define V_RETRYLIMIT(x) ((x) << S_RETRYLIMIT)
#define F_RETRYLIMIT    V_RETRYLIMIT(1U)

#define S_COLEVENT    1
#define V_COLEVENT(x) ((x) << S_COLEVENT)
#define F_COLEVENT    V_COLEVENT(1U)

#define S_USEDBITREAD    0
#define V_USEDBITREAD(x) ((x) << S_USEDBITREAD)
#define F_USEDBITREAD    V_USEDBITREAD(1U)

#define A_NCSI_MACB_RX_BUF_QPTR 0x1a118

#define S_RXBUFQPTR    2
#define M_RXBUFQPTR    0x3fffffffU
#define V_RXBUFQPTR(x) ((x) << S_RXBUFQPTR)
#define G_RXBUFQPTR(x) (((x) >> S_RXBUFQPTR) & M_RXBUFQPTR)

#define A_NCSI_MACB_TX_BUF_QPTR 0x1a11c

#define S_TXBUFQPTR    2
#define M_TXBUFQPTR    0x3fffffffU
#define V_TXBUFQPTR(x) ((x) << S_TXBUFQPTR)
#define G_TXBUFQPTR(x) (((x) >> S_TXBUFQPTR) & M_TXBUFQPTR)

#define A_NCSI_MACB_RX_STATUS 0x1a120

#define S_RXOVERRUNERR    2
#define V_RXOVERRUNERR(x) ((x) << S_RXOVERRUNERR)
#define F_RXOVERRUNERR    V_RXOVERRUNERR(1U)

#define S_MACB_FRAMERCVD    1
#define V_MACB_FRAMERCVD(x) ((x) << S_MACB_FRAMERCVD)
#define F_MACB_FRAMERCVD    V_MACB_FRAMERCVD(1U)

#define S_NORXBUF    0
#define V_NORXBUF(x) ((x) << S_NORXBUF)
#define F_NORXBUF    V_NORXBUF(1U)

#define A_NCSI_MACB_INT_STATUS 0x1a124

#define S_PAUSETIMEZERO    13
#define V_PAUSETIMEZERO(x) ((x) << S_PAUSETIMEZERO)
#define F_PAUSETIMEZERO    V_PAUSETIMEZERO(1U)

#define S_PAUSERCVD    12
#define V_PAUSERCVD(x) ((x) << S_PAUSERCVD)
#define F_PAUSERCVD    V_PAUSERCVD(1U)

#define S_HRESPNOTOK    11
#define V_HRESPNOTOK(x) ((x) << S_HRESPNOTOK)
#define F_HRESPNOTOK    V_HRESPNOTOK(1U)

#define S_RXOVERRUN    10
#define V_RXOVERRUN(x) ((x) << S_RXOVERRUN)
#define F_RXOVERRUN    V_RXOVERRUN(1U)

#define S_LINKCHANGE    9
#define V_LINKCHANGE(x) ((x) << S_LINKCHANGE)
#define F_LINKCHANGE    V_LINKCHANGE(1U)

#define S_INT_TXCOMPLETE    7
#define V_INT_TXCOMPLETE(x) ((x) << S_INT_TXCOMPLETE)
#define F_INT_TXCOMPLETE    V_INT_TXCOMPLETE(1U)

#define S_TXBUFERR    6
#define V_TXBUFERR(x) ((x) << S_TXBUFERR)
#define F_TXBUFERR    V_TXBUFERR(1U)

#define S_RETRYLIMITERR    5
#define V_RETRYLIMITERR(x) ((x) << S_RETRYLIMITERR)
#define F_RETRYLIMITERR    V_RETRYLIMITERR(1U)

#define S_TXBUFUNDERRUN    4
#define V_TXBUFUNDERRUN(x) ((x) << S_TXBUFUNDERRUN)
#define F_TXBUFUNDERRUN    V_TXBUFUNDERRUN(1U)

#define S_TXUSEDBITREAD    3
#define V_TXUSEDBITREAD(x) ((x) << S_TXUSEDBITREAD)
#define F_TXUSEDBITREAD    V_TXUSEDBITREAD(1U)

#define S_RXUSEDBITREAD    2
#define V_RXUSEDBITREAD(x) ((x) << S_RXUSEDBITREAD)
#define F_RXUSEDBITREAD    V_RXUSEDBITREAD(1U)

#define S_RXCOMPLETE    1
#define V_RXCOMPLETE(x) ((x) << S_RXCOMPLETE)
#define F_RXCOMPLETE    V_RXCOMPLETE(1U)

#define S_MGMTFRAMESENT    0
#define V_MGMTFRAMESENT(x) ((x) << S_MGMTFRAMESENT)
#define F_MGMTFRAMESENT    V_MGMTFRAMESENT(1U)

#define A_NCSI_MACB_INT_EN 0x1a128
#define A_NCSI_MACB_INT_DIS 0x1a12c
#define A_NCSI_MACB_INT_MASK 0x1a130
#define A_NCSI_MACB_PAUSE_TIME 0x1a138

#define S_PAUSETIME    0
#define M_PAUSETIME    0xffffU
#define V_PAUSETIME(x) ((x) << S_PAUSETIME)
#define G_PAUSETIME(x) (((x) >> S_PAUSETIME) & M_PAUSETIME)

#define A_NCSI_MACB_PAUSE_FRAMES_RCVD 0x1a13c

#define S_PAUSEFRRCVD    0
#define M_PAUSEFRRCVD    0xffffU
#define V_PAUSEFRRCVD(x) ((x) << S_PAUSEFRRCVD)
#define G_PAUSEFRRCVD(x) (((x) >> S_PAUSEFRRCVD) & M_PAUSEFRRCVD)

#define A_NCSI_MACB_TX_FRAMES_OK 0x1a140

#define S_TXFRAMESOK    0
#define M_TXFRAMESOK    0xffffffU
#define V_TXFRAMESOK(x) ((x) << S_TXFRAMESOK)
#define G_TXFRAMESOK(x) (((x) >> S_TXFRAMESOK) & M_TXFRAMESOK)

#define A_NCSI_MACB_SINGLE_COL_FRAMES 0x1a144

#define S_SINGLECOLTXFRAMES    0
#define M_SINGLECOLTXFRAMES    0xffffU
#define V_SINGLECOLTXFRAMES(x) ((x) << S_SINGLECOLTXFRAMES)
#define G_SINGLECOLTXFRAMES(x) (((x) >> S_SINGLECOLTXFRAMES) & M_SINGLECOLTXFRAMES)

#define A_NCSI_MACB_MUL_COL_FRAMES 0x1a148

#define S_MULCOLTXFRAMES    0
#define M_MULCOLTXFRAMES    0xffffU
#define V_MULCOLTXFRAMES(x) ((x) << S_MULCOLTXFRAMES)
#define G_MULCOLTXFRAMES(x) (((x) >> S_MULCOLTXFRAMES) & M_MULCOLTXFRAMES)

#define A_NCSI_MACB_RX_FRAMES_OK 0x1a14c

#define S_RXFRAMESOK    0
#define M_RXFRAMESOK    0xffffffU
#define V_RXFRAMESOK(x) ((x) << S_RXFRAMESOK)
#define G_RXFRAMESOK(x) (((x) >> S_RXFRAMESOK) & M_RXFRAMESOK)

#define A_NCSI_MACB_FCS_ERR 0x1a150

#define S_RXFCSERR    0
#define M_RXFCSERR    0xffU
#define V_RXFCSERR(x) ((x) << S_RXFCSERR)
#define G_RXFCSERR(x) (((x) >> S_RXFCSERR) & M_RXFCSERR)

#define A_NCSI_MACB_ALIGN_ERR 0x1a154

#define S_RXALIGNERR    0
#define M_RXALIGNERR    0xffU
#define V_RXALIGNERR(x) ((x) << S_RXALIGNERR)
#define G_RXALIGNERR(x) (((x) >> S_RXALIGNERR) & M_RXALIGNERR)

#define A_NCSI_MACB_DEF_TX_FRAMES 0x1a158

#define S_TXDEFERREDFRAMES    0
#define M_TXDEFERREDFRAMES    0xffffU
#define V_TXDEFERREDFRAMES(x) ((x) << S_TXDEFERREDFRAMES)
#define G_TXDEFERREDFRAMES(x) (((x) >> S_TXDEFERREDFRAMES) & M_TXDEFERREDFRAMES)

#define A_NCSI_MACB_LATE_COL 0x1a15c

#define S_LATECOLLISIONS    0
#define M_LATECOLLISIONS    0xffffU
#define V_LATECOLLISIONS(x) ((x) << S_LATECOLLISIONS)
#define G_LATECOLLISIONS(x) (((x) >> S_LATECOLLISIONS) & M_LATECOLLISIONS)

#define A_NCSI_MACB_EXCESSIVE_COL 0x1a160

#define S_EXCESSIVECOLLISIONS    0
#define M_EXCESSIVECOLLISIONS    0xffU
#define V_EXCESSIVECOLLISIONS(x) ((x) << S_EXCESSIVECOLLISIONS)
#define G_EXCESSIVECOLLISIONS(x) (((x) >> S_EXCESSIVECOLLISIONS) & M_EXCESSIVECOLLISIONS)

#define A_NCSI_MACB_TX_UNDERRUN_ERR 0x1a164

#define S_TXUNDERRUNERR    0
#define M_TXUNDERRUNERR    0xffU
#define V_TXUNDERRUNERR(x) ((x) << S_TXUNDERRUNERR)
#define G_TXUNDERRUNERR(x) (((x) >> S_TXUNDERRUNERR) & M_TXUNDERRUNERR)

#define A_NCSI_MACB_CARRIER_SENSE_ERR 0x1a168

#define S_CARRIERSENSEERRS    0
#define M_CARRIERSENSEERRS    0xffU
#define V_CARRIERSENSEERRS(x) ((x) << S_CARRIERSENSEERRS)
#define G_CARRIERSENSEERRS(x) (((x) >> S_CARRIERSENSEERRS) & M_CARRIERSENSEERRS)

#define A_NCSI_MACB_RX_RESOURCE_ERR 0x1a16c

#define S_RXRESOURCEERR    0
#define M_RXRESOURCEERR    0xffffU
#define V_RXRESOURCEERR(x) ((x) << S_RXRESOURCEERR)
#define G_RXRESOURCEERR(x) (((x) >> S_RXRESOURCEERR) & M_RXRESOURCEERR)

#define A_NCSI_MACB_RX_OVERRUN_ERR 0x1a170

#define S_RXOVERRUNERRCNT    0
#define M_RXOVERRUNERRCNT    0xffU
#define V_RXOVERRUNERRCNT(x) ((x) << S_RXOVERRUNERRCNT)
#define G_RXOVERRUNERRCNT(x) (((x) >> S_RXOVERRUNERRCNT) & M_RXOVERRUNERRCNT)

#define A_NCSI_MACB_RX_SYMBOL_ERR 0x1a174

#define S_RXSYMBOLERR    0
#define M_RXSYMBOLERR    0xffU
#define V_RXSYMBOLERR(x) ((x) << S_RXSYMBOLERR)
#define G_RXSYMBOLERR(x) (((x) >> S_RXSYMBOLERR) & M_RXSYMBOLERR)

#define A_NCSI_MACB_RX_OVERSIZE_FRAME 0x1a178

#define S_RXOVERSIZEERR    0
#define M_RXOVERSIZEERR    0xffU
#define V_RXOVERSIZEERR(x) ((x) << S_RXOVERSIZEERR)
#define G_RXOVERSIZEERR(x) (((x) >> S_RXOVERSIZEERR) & M_RXOVERSIZEERR)

#define A_NCSI_MACB_RX_JABBER_ERR 0x1a17c

#define S_RXJABBERERR    0
#define M_RXJABBERERR    0xffU
#define V_RXJABBERERR(x) ((x) << S_RXJABBERERR)
#define G_RXJABBERERR(x) (((x) >> S_RXJABBERERR) & M_RXJABBERERR)

#define A_NCSI_MACB_RX_UNDERSIZE_FRAME 0x1a180

#define S_RXUNDERSIZEFR    0
#define M_RXUNDERSIZEFR    0xffU
#define V_RXUNDERSIZEFR(x) ((x) << S_RXUNDERSIZEFR)
#define G_RXUNDERSIZEFR(x) (((x) >> S_RXUNDERSIZEFR) & M_RXUNDERSIZEFR)

#define A_NCSI_MACB_SQE_TEST_ERR 0x1a184

#define S_SQETESTERR    0
#define M_SQETESTERR    0xffU
#define V_SQETESTERR(x) ((x) << S_SQETESTERR)
#define G_SQETESTERR(x) (((x) >> S_SQETESTERR) & M_SQETESTERR)

#define A_NCSI_MACB_LENGTH_ERR 0x1a188

#define S_LENGTHERR    0
#define M_LENGTHERR    0xffU
#define V_LENGTHERR(x) ((x) << S_LENGTHERR)
#define G_LENGTHERR(x) (((x) >> S_LENGTHERR) & M_LENGTHERR)

#define A_NCSI_MACB_TX_PAUSE_FRAMES 0x1a18c

#define S_TXPAUSEFRAMES    0
#define M_TXPAUSEFRAMES    0xffffU
#define V_TXPAUSEFRAMES(x) ((x) << S_TXPAUSEFRAMES)
#define G_TXPAUSEFRAMES(x) (((x) >> S_TXPAUSEFRAMES) & M_TXPAUSEFRAMES)

#define A_NCSI_MACB_HASH_LOW 0x1a190
#define A_NCSI_MACB_HASH_HIGH 0x1a194
#define A_NCSI_MACB_SPECIFIC_1_LOW 0x1a198
#define A_NCSI_MACB_SPECIFIC_1_HIGH 0x1a19c

#define S_MATCHHIGH    0
#define M_MATCHHIGH    0xffffU
#define V_MATCHHIGH(x) ((x) << S_MATCHHIGH)
#define G_MATCHHIGH(x) (((x) >> S_MATCHHIGH) & M_MATCHHIGH)

#define A_NCSI_MACB_SPECIFIC_2_LOW 0x1a1a0
#define A_NCSI_MACB_SPECIFIC_2_HIGH 0x1a1a4
#define A_NCSI_MACB_SPECIFIC_3_LOW 0x1a1a8
#define A_NCSI_MACB_SPECIFIC_3_HIGH 0x1a1ac
#define A_NCSI_MACB_SPECIFIC_4_LOW 0x1a1b0
#define A_NCSI_MACB_SPECIFIC_4_HIGH 0x1a1b4
#define A_NCSI_MACB_TYPE_ID 0x1a1b8

#define S_TYPEID    0
#define M_TYPEID    0xffffU
#define V_TYPEID(x) ((x) << S_TYPEID)
#define G_TYPEID(x) (((x) >> S_TYPEID) & M_TYPEID)

#define A_NCSI_MACB_TX_PAUSE_QUANTUM 0x1a1bc

#define S_TXPAUSEQUANTUM    0
#define M_TXPAUSEQUANTUM    0xffffU
#define V_TXPAUSEQUANTUM(x) ((x) << S_TXPAUSEQUANTUM)
#define G_TXPAUSEQUANTUM(x) (((x) >> S_TXPAUSEQUANTUM) & M_TXPAUSEQUANTUM)

#define A_NCSI_MACB_USER_IO 0x1a1c0

#define S_USERPROGINPUT    16
#define M_USERPROGINPUT    0xffffU
#define V_USERPROGINPUT(x) ((x) << S_USERPROGINPUT)
#define G_USERPROGINPUT(x) (((x) >> S_USERPROGINPUT) & M_USERPROGINPUT)

#define S_USERPROGOUTPUT    0
#define M_USERPROGOUTPUT    0xffffU
#define V_USERPROGOUTPUT(x) ((x) << S_USERPROGOUTPUT)
#define G_USERPROGOUTPUT(x) (((x) >> S_USERPROGOUTPUT) & M_USERPROGOUTPUT)

#define A_NCSI_MACB_WOL_CFG 0x1a1c4

#define S_MCHASHEN    19
#define V_MCHASHEN(x) ((x) << S_MCHASHEN)
#define F_MCHASHEN    V_MCHASHEN(1U)

#define S_SPECIFIC1EN    18
#define V_SPECIFIC1EN(x) ((x) << S_SPECIFIC1EN)
#define F_SPECIFIC1EN    V_SPECIFIC1EN(1U)

#define S_ARPEN    17
#define V_ARPEN(x) ((x) << S_ARPEN)
#define F_ARPEN    V_ARPEN(1U)

#define S_MAGICPKTEN    16
#define V_MAGICPKTEN(x) ((x) << S_MAGICPKTEN)
#define F_MAGICPKTEN    V_MAGICPKTEN(1U)

#define S_ARPIPADDR    0
#define M_ARPIPADDR    0xffffU
#define V_ARPIPADDR(x) ((x) << S_ARPIPADDR)
#define G_ARPIPADDR(x) (((x) >> S_ARPIPADDR) & M_ARPIPADDR)

#define A_NCSI_MACB_REV_STATUS 0x1a1fc

#define S_PARTREF    16
#define M_PARTREF    0xffffU
#define V_PARTREF(x) ((x) << S_PARTREF)
#define G_PARTREF(x) (((x) >> S_PARTREF) & M_PARTREF)

#define S_DESREV    0
#define M_DESREV    0xffffU
#define V_DESREV(x) ((x) << S_DESREV)
#define G_DESREV(x) (((x) >> S_DESREV) & M_DESREV)

/* registers for module XGMAC */
#define XGMAC_BASE_ADDR 0x0

#define A_XGMAC_PORT_CFG 0x1000

#define S_XGMII_CLK_SEL    29
#define M_XGMII_CLK_SEL    0x7U
#define V_XGMII_CLK_SEL(x) ((x) << S_XGMII_CLK_SEL)
#define G_XGMII_CLK_SEL(x) (((x) >> S_XGMII_CLK_SEL) & M_XGMII_CLK_SEL)

#define S_SINKTX    27
#define V_SINKTX(x) ((x) << S_SINKTX)
#define F_SINKTX    V_SINKTX(1U)

#define S_SINKTXONLINKDOWN    26
#define V_SINKTXONLINKDOWN(x) ((x) << S_SINKTXONLINKDOWN)
#define F_SINKTXONLINKDOWN    V_SINKTXONLINKDOWN(1U)

#define S_XG2G_SPEED_MODE    25
#define V_XG2G_SPEED_MODE(x) ((x) << S_XG2G_SPEED_MODE)
#define F_XG2G_SPEED_MODE    V_XG2G_SPEED_MODE(1U)

#define S_LOOPNOFWD    24
#define V_LOOPNOFWD(x) ((x) << S_LOOPNOFWD)
#define F_LOOPNOFWD    V_LOOPNOFWD(1U)

#define S_XGM_TX_PAUSE_SIZE    23
#define V_XGM_TX_PAUSE_SIZE(x) ((x) << S_XGM_TX_PAUSE_SIZE)
#define F_XGM_TX_PAUSE_SIZE    V_XGM_TX_PAUSE_SIZE(1U)

#define S_XGM_TX_PAUSE_FRAME    22
#define V_XGM_TX_PAUSE_FRAME(x) ((x) << S_XGM_TX_PAUSE_FRAME)
#define F_XGM_TX_PAUSE_FRAME    V_XGM_TX_PAUSE_FRAME(1U)

#define S_XGM_TX_DISABLE_PRE    21
#define V_XGM_TX_DISABLE_PRE(x) ((x) << S_XGM_TX_DISABLE_PRE)
#define F_XGM_TX_DISABLE_PRE    V_XGM_TX_DISABLE_PRE(1U)

#define S_XGM_TX_DISABLE_CRC    20
#define V_XGM_TX_DISABLE_CRC(x) ((x) << S_XGM_TX_DISABLE_CRC)
#define F_XGM_TX_DISABLE_CRC    V_XGM_TX_DISABLE_CRC(1U)

#define S_SMUX_RX_LOOP    19
#define V_SMUX_RX_LOOP(x) ((x) << S_SMUX_RX_LOOP)
#define F_SMUX_RX_LOOP    V_SMUX_RX_LOOP(1U)

#define S_RX_LANE_SWAP    18
#define V_RX_LANE_SWAP(x) ((x) << S_RX_LANE_SWAP)
#define F_RX_LANE_SWAP    V_RX_LANE_SWAP(1U)

#define S_TX_LANE_SWAP    17
#define V_TX_LANE_SWAP(x) ((x) << S_TX_LANE_SWAP)
#define F_TX_LANE_SWAP    V_TX_LANE_SWAP(1U)

#define S_SIGNAL_DET    14
#define V_SIGNAL_DET(x) ((x) << S_SIGNAL_DET)
#define F_SIGNAL_DET    V_SIGNAL_DET(1U)

#define S_PMUX_RX_LOOP    13
#define V_PMUX_RX_LOOP(x) ((x) << S_PMUX_RX_LOOP)
#define F_PMUX_RX_LOOP    V_PMUX_RX_LOOP(1U)

#define S_PMUX_TX_LOOP    12
#define V_PMUX_TX_LOOP(x) ((x) << S_PMUX_TX_LOOP)
#define F_PMUX_TX_LOOP    V_PMUX_TX_LOOP(1U)

#define S_XGM_RX_SEL    10
#define M_XGM_RX_SEL    0x3U
#define V_XGM_RX_SEL(x) ((x) << S_XGM_RX_SEL)
#define G_XGM_RX_SEL(x) (((x) >> S_XGM_RX_SEL) & M_XGM_RX_SEL)

#define S_PCS_TX_SEL    8
#define M_PCS_TX_SEL    0x3U
#define V_PCS_TX_SEL(x) ((x) << S_PCS_TX_SEL)
#define G_PCS_TX_SEL(x) (((x) >> S_PCS_TX_SEL) & M_PCS_TX_SEL)

#define S_XAUI20_REM_PRE    5
#define V_XAUI20_REM_PRE(x) ((x) << S_XAUI20_REM_PRE)
#define F_XAUI20_REM_PRE    V_XAUI20_REM_PRE(1U)

#define S_XAUI20_XGMII_SEL    4
#define V_XAUI20_XGMII_SEL(x) ((x) << S_XAUI20_XGMII_SEL)
#define F_XAUI20_XGMII_SEL    V_XAUI20_XGMII_SEL(1U)

#define S_PORT_SEL    0
#define V_PORT_SEL(x) ((x) << S_PORT_SEL)
#define F_PORT_SEL    V_PORT_SEL(1U)

#define A_XGMAC_PORT_RESET_CTRL 0x1004

#define S_AUXEXT_RESET    10
#define V_AUXEXT_RESET(x) ((x) << S_AUXEXT_RESET)
#define F_AUXEXT_RESET    V_AUXEXT_RESET(1U)

#define S_TXFIFO_RESET    9
#define V_TXFIFO_RESET(x) ((x) << S_TXFIFO_RESET)
#define F_TXFIFO_RESET    V_TXFIFO_RESET(1U)

#define S_RXFIFO_RESET    8
#define V_RXFIFO_RESET(x) ((x) << S_RXFIFO_RESET)
#define F_RXFIFO_RESET    V_RXFIFO_RESET(1U)

#define S_BEAN_RESET    7
#define V_BEAN_RESET(x) ((x) << S_BEAN_RESET)
#define F_BEAN_RESET    V_BEAN_RESET(1U)

#define S_XAUI_RESET    6
#define V_XAUI_RESET(x) ((x) << S_XAUI_RESET)
#define F_XAUI_RESET    V_XAUI_RESET(1U)

#define S_AE_RESET    5
#define V_AE_RESET(x) ((x) << S_AE_RESET)
#define F_AE_RESET    V_AE_RESET(1U)

#define S_XGM_RESET    4
#define V_XGM_RESET(x) ((x) << S_XGM_RESET)
#define F_XGM_RESET    V_XGM_RESET(1U)

#define S_XG2G_RESET    3
#define V_XG2G_RESET(x) ((x) << S_XG2G_RESET)
#define F_XG2G_RESET    V_XG2G_RESET(1U)

#define S_WOL_RESET    2
#define V_WOL_RESET(x) ((x) << S_WOL_RESET)
#define F_WOL_RESET    V_WOL_RESET(1U)

#define S_XFI_PCS_RESET    1
#define V_XFI_PCS_RESET(x) ((x) << S_XFI_PCS_RESET)
#define F_XFI_PCS_RESET    V_XFI_PCS_RESET(1U)

#define S_HSS_RESET    0
#define V_HSS_RESET(x) ((x) << S_HSS_RESET)
#define F_HSS_RESET    V_HSS_RESET(1U)

#define A_XGMAC_PORT_LED_CFG 0x1008

#define S_LED1_CFG    5
#define M_LED1_CFG    0x7U
#define V_LED1_CFG(x) ((x) << S_LED1_CFG)
#define G_LED1_CFG(x) (((x) >> S_LED1_CFG) & M_LED1_CFG)

#define S_LED1_POLARITY_INV    4
#define V_LED1_POLARITY_INV(x) ((x) << S_LED1_POLARITY_INV)
#define F_LED1_POLARITY_INV    V_LED1_POLARITY_INV(1U)

#define S_LED0_CFG    1
#define M_LED0_CFG    0x7U
#define V_LED0_CFG(x) ((x) << S_LED0_CFG)
#define G_LED0_CFG(x) (((x) >> S_LED0_CFG) & M_LED0_CFG)

#define S_LED0_POLARITY_INV    0
#define V_LED0_POLARITY_INV(x) ((x) << S_LED0_POLARITY_INV)
#define F_LED0_POLARITY_INV    V_LED0_POLARITY_INV(1U)

#define A_XGMAC_PORT_LED_COUNTHI 0x100c

#define S_LED_COUNT_HI    0
#define M_LED_COUNT_HI    0x1ffffffU
#define V_LED_COUNT_HI(x) ((x) << S_LED_COUNT_HI)
#define G_LED_COUNT_HI(x) (((x) >> S_LED_COUNT_HI) & M_LED_COUNT_HI)

#define A_XGMAC_PORT_LED_COUNTLO 0x1010

#define S_LED_COUNT_LO    0
#define M_LED_COUNT_LO    0x1ffffffU
#define V_LED_COUNT_LO(x) ((x) << S_LED_COUNT_LO)
#define G_LED_COUNT_LO(x) (((x) >> S_LED_COUNT_LO) & M_LED_COUNT_LO)

#define A_XGMAC_PORT_DEBUG_CFG 0x1014

#define S_TESTCLK_SEL    0
#define M_TESTCLK_SEL    0xfU
#define V_TESTCLK_SEL(x) ((x) << S_TESTCLK_SEL)
#define G_TESTCLK_SEL(x) (((x) >> S_TESTCLK_SEL) & M_TESTCLK_SEL)

#define A_XGMAC_PORT_CFG2 0x1018

#define S_RX_POLARITY_INV    28
#define M_RX_POLARITY_INV    0xfU
#define V_RX_POLARITY_INV(x) ((x) << S_RX_POLARITY_INV)
#define G_RX_POLARITY_INV(x) (((x) >> S_RX_POLARITY_INV) & M_RX_POLARITY_INV)

#define S_TX_POLARITY_INV    24
#define M_TX_POLARITY_INV    0xfU
#define V_TX_POLARITY_INV(x) ((x) << S_TX_POLARITY_INV)
#define G_TX_POLARITY_INV(x) (((x) >> S_TX_POLARITY_INV) & M_TX_POLARITY_INV)

#define S_INSTANCENUM    22
#define M_INSTANCENUM    0x3U
#define V_INSTANCENUM(x) ((x) << S_INSTANCENUM)
#define G_INSTANCENUM(x) (((x) >> S_INSTANCENUM) & M_INSTANCENUM)

#define S_STOPONPERR    21
#define V_STOPONPERR(x) ((x) << S_STOPONPERR)
#define F_STOPONPERR    V_STOPONPERR(1U)

#define S_MACTXEN    20
#define V_MACTXEN(x) ((x) << S_MACTXEN)
#define F_MACTXEN    V_MACTXEN(1U)

#define S_MACRXEN    19
#define V_MACRXEN(x) ((x) << S_MACRXEN)
#define F_MACRXEN    V_MACRXEN(1U)

#define S_PATEN    18
#define V_PATEN(x) ((x) << S_PATEN)
#define F_PATEN    V_PATEN(1U)

#define S_MAGICEN    17
#define V_MAGICEN(x) ((x) << S_MAGICEN)
#define F_MAGICEN    V_MAGICEN(1U)

#define S_TX_IPG    4
#define M_TX_IPG    0x1fffU
#define V_TX_IPG(x) ((x) << S_TX_IPG)
#define G_TX_IPG(x) (((x) >> S_TX_IPG) & M_TX_IPG)

#define S_AEC_PMA_TX_READY    1
#define V_AEC_PMA_TX_READY(x) ((x) << S_AEC_PMA_TX_READY)
#define F_AEC_PMA_TX_READY    V_AEC_PMA_TX_READY(1U)

#define S_AEC_PMA_RX_READY    0
#define V_AEC_PMA_RX_READY(x) ((x) << S_AEC_PMA_RX_READY)
#define F_AEC_PMA_RX_READY    V_AEC_PMA_RX_READY(1U)

#define A_XGMAC_PORT_PKT_COUNT 0x101c

#define S_TX_SOP_COUNT    24
#define M_TX_SOP_COUNT    0xffU
#define V_TX_SOP_COUNT(x) ((x) << S_TX_SOP_COUNT)
#define G_TX_SOP_COUNT(x) (((x) >> S_TX_SOP_COUNT) & M_TX_SOP_COUNT)

#define S_TX_EOP_COUNT    16
#define M_TX_EOP_COUNT    0xffU
#define V_TX_EOP_COUNT(x) ((x) << S_TX_EOP_COUNT)
#define G_TX_EOP_COUNT(x) (((x) >> S_TX_EOP_COUNT) & M_TX_EOP_COUNT)

#define S_RX_SOP_COUNT    8
#define M_RX_SOP_COUNT    0xffU
#define V_RX_SOP_COUNT(x) ((x) << S_RX_SOP_COUNT)
#define G_RX_SOP_COUNT(x) (((x) >> S_RX_SOP_COUNT) & M_RX_SOP_COUNT)

#define S_RX_EOP_COUNT    0
#define M_RX_EOP_COUNT    0xffU
#define V_RX_EOP_COUNT(x) ((x) << S_RX_EOP_COUNT)
#define G_RX_EOP_COUNT(x) (((x) >> S_RX_EOP_COUNT) & M_RX_EOP_COUNT)

#define A_XGMAC_PORT_PERR_INJECT 0x1020

#define S_XGMMEMSEL    1
#define V_XGMMEMSEL(x) ((x) << S_XGMMEMSEL)
#define F_XGMMEMSEL    V_XGMMEMSEL(1U)

#define A_XGMAC_PORT_MAGIC_MACID_LO 0x1024
#define A_XGMAC_PORT_MAGIC_MACID_HI 0x1028

#define S_MAC_WOL_DA    0
#define M_MAC_WOL_DA    0xffffU
#define V_MAC_WOL_DA(x) ((x) << S_MAC_WOL_DA)
#define G_MAC_WOL_DA(x) (((x) >> S_MAC_WOL_DA) & M_MAC_WOL_DA)

#define A_XGMAC_PORT_BUILD_REVISION 0x102c
#define A_XGMAC_PORT_XGMII_SE_COUNT 0x1030

#define S_TXSOP    24
#define M_TXSOP    0xffU
#define V_TXSOP(x) ((x) << S_TXSOP)
#define G_TXSOP(x) (((x) >> S_TXSOP) & M_TXSOP)

#define S_TXEOP    16
#define M_TXEOP    0xffU
#define V_TXEOP(x) ((x) << S_TXEOP)
#define G_TXEOP(x) (((x) >> S_TXEOP) & M_TXEOP)

#define S_RXSOP    8
#define M_RXSOP    0xffU
#define V_RXSOP(x) ((x) << S_RXSOP)
#define G_RXSOP(x) (((x) >> S_RXSOP) & M_RXSOP)

#define A_XGMAC_PORT_LINK_STATUS 0x1034

#define S_REMFLT    3
#define V_REMFLT(x) ((x) << S_REMFLT)
#define F_REMFLT    V_REMFLT(1U)

#define S_LOCFLT    2
#define V_LOCFLT(x) ((x) << S_LOCFLT)
#define F_LOCFLT    V_LOCFLT(1U)

#define S_LINKUP    1
#define V_LINKUP(x) ((x) << S_LINKUP)
#define F_LINKUP    V_LINKUP(1U)

#define S_LINKDN    0
#define V_LINKDN(x) ((x) << S_LINKDN)
#define F_LINKDN    V_LINKDN(1U)

#define A_XGMAC_PORT_CHECKIN 0x1038

#define S_PREAMBLE    1
#define V_PREAMBLE(x) ((x) << S_PREAMBLE)
#define F_PREAMBLE    V_PREAMBLE(1U)

#define S_CHECKIN    0
#define V_CHECKIN(x) ((x) << S_CHECKIN)
#define F_CHECKIN    V_CHECKIN(1U)

#define A_XGMAC_PORT_FAULT_TEST 0x103c

#define S_FLTTYPE    1
#define V_FLTTYPE(x) ((x) << S_FLTTYPE)
#define F_FLTTYPE    V_FLTTYPE(1U)

#define S_FLTCTRL    0
#define V_FLTCTRL(x) ((x) << S_FLTCTRL)
#define F_FLTCTRL    V_FLTCTRL(1U)

#define A_XGMAC_PORT_SPARE 0x1040
#define A_XGMAC_PORT_HSS_SIGDET_STATUS 0x1044

#define S_SIGNALDETECT    0
#define M_SIGNALDETECT    0xfU
#define V_SIGNALDETECT(x) ((x) << S_SIGNALDETECT)
#define G_SIGNALDETECT(x) (((x) >> S_SIGNALDETECT) & M_SIGNALDETECT)

#define A_XGMAC_PORT_EXT_LOS_STATUS 0x1048
#define A_XGMAC_PORT_EXT_LOS_CTRL 0x104c

#define S_CTRL    0
#define M_CTRL    0xfU
#define V_CTRL(x) ((x) << S_CTRL)
#define G_CTRL(x) (((x) >> S_CTRL) & M_CTRL)

#define A_XGMAC_PORT_FPGA_PAUSE_CTL 0x1050

#define S_CTL    31
#define V_CTL(x) ((x) << S_CTL)
#define F_CTL    V_CTL(1U)

#define S_HWM    13
#define M_HWM    0x1fffU
#define V_HWM(x) ((x) << S_HWM)
#define G_HWM(x) (((x) >> S_HWM) & M_HWM)

#define S_LWM    0
#define M_LWM    0x1fffU
#define V_LWM(x) ((x) << S_LWM)
#define G_LWM(x) (((x) >> S_LWM) & M_LWM)

#define A_XGMAC_PORT_FPGA_ERRPKT_CNT 0x1054
#define A_XGMAC_PORT_LA_TX_0 0x1058
#define A_XGMAC_PORT_LA_RX_0 0x105c
#define A_XGMAC_PORT_FPGA_LA_CTL 0x1060

#define S_RXRST    5
#define V_RXRST(x) ((x) << S_RXRST)
#define F_RXRST    V_RXRST(1U)

#define S_TXRST    4
#define V_TXRST(x) ((x) << S_TXRST)
#define F_TXRST    V_TXRST(1U)

#define S_XGMII    3
#define V_XGMII(x) ((x) << S_XGMII)
#define F_XGMII    V_XGMII(1U)

#define S_LAPAUSE    2
#define V_LAPAUSE(x) ((x) << S_LAPAUSE)
#define F_LAPAUSE    V_LAPAUSE(1U)

#define S_STOPERR    1
#define V_STOPERR(x) ((x) << S_STOPERR)
#define F_STOPERR    V_STOPERR(1U)

#define S_LASTOP    0
#define V_LASTOP(x) ((x) << S_LASTOP)
#define F_LASTOP    V_LASTOP(1U)

#define A_XGMAC_PORT_EPIO_DATA0 0x10c0
#define A_XGMAC_PORT_EPIO_DATA1 0x10c4
#define A_XGMAC_PORT_EPIO_DATA2 0x10c8
#define A_XGMAC_PORT_EPIO_DATA3 0x10cc
#define A_XGMAC_PORT_EPIO_OP 0x10d0

#define S_EPIOWR    8
#define V_EPIOWR(x) ((x) << S_EPIOWR)
#define F_EPIOWR    V_EPIOWR(1U)

#define S_ADDRESS    0
#define M_ADDRESS    0xffU
#define V_ADDRESS(x) ((x) << S_ADDRESS)
#define G_ADDRESS(x) (((x) >> S_ADDRESS) & M_ADDRESS)

#define A_XGMAC_PORT_WOL_STATUS 0x10d4

#define S_MAGICDETECTED    31
#define V_MAGICDETECTED(x) ((x) << S_MAGICDETECTED)
#define F_MAGICDETECTED    V_MAGICDETECTED(1U)

#define S_PATDETECTED    30
#define V_PATDETECTED(x) ((x) << S_PATDETECTED)
#define F_PATDETECTED    V_PATDETECTED(1U)

#define S_CLEARMAGIC    4
#define V_CLEARMAGIC(x) ((x) << S_CLEARMAGIC)
#define F_CLEARMAGIC    V_CLEARMAGIC(1U)

#define S_CLEARMATCH    3
#define V_CLEARMATCH(x) ((x) << S_CLEARMATCH)
#define F_CLEARMATCH    V_CLEARMATCH(1U)

#define S_MATCHEDFILTER    0
#define M_MATCHEDFILTER    0x7U
#define V_MATCHEDFILTER(x) ((x) << S_MATCHEDFILTER)
#define G_MATCHEDFILTER(x) (((x) >> S_MATCHEDFILTER) & M_MATCHEDFILTER)

#define A_XGMAC_PORT_INT_EN 0x10d8

#define S_EXT_LOS    28
#define V_EXT_LOS(x) ((x) << S_EXT_LOS)
#define F_EXT_LOS    V_EXT_LOS(1U)

#define S_INCMPTBL_LINK    27
#define V_INCMPTBL_LINK(x) ((x) << S_INCMPTBL_LINK)
#define F_INCMPTBL_LINK    V_INCMPTBL_LINK(1U)

#define S_PATDETWAKE    26
#define V_PATDETWAKE(x) ((x) << S_PATDETWAKE)
#define F_PATDETWAKE    V_PATDETWAKE(1U)

#define S_MAGICWAKE    25
#define V_MAGICWAKE(x) ((x) << S_MAGICWAKE)
#define F_MAGICWAKE    V_MAGICWAKE(1U)

#define S_SIGDETCHG    24
#define V_SIGDETCHG(x) ((x) << S_SIGDETCHG)
#define F_SIGDETCHG    V_SIGDETCHG(1U)

#define S_PCSR_FEC_CORR    23
#define V_PCSR_FEC_CORR(x) ((x) << S_PCSR_FEC_CORR)
#define F_PCSR_FEC_CORR    V_PCSR_FEC_CORR(1U)

#define S_AE_TRAIN_LOCAL    22
#define V_AE_TRAIN_LOCAL(x) ((x) << S_AE_TRAIN_LOCAL)
#define F_AE_TRAIN_LOCAL    V_AE_TRAIN_LOCAL(1U)

#define S_HSSPLL_LOCK    21
#define V_HSSPLL_LOCK(x) ((x) << S_HSSPLL_LOCK)
#define F_HSSPLL_LOCK    V_HSSPLL_LOCK(1U)

#define S_HSSPRT_READY    20
#define V_HSSPRT_READY(x) ((x) << S_HSSPRT_READY)
#define F_HSSPRT_READY    V_HSSPRT_READY(1U)

#define S_AUTONEG_DONE    19
#define V_AUTONEG_DONE(x) ((x) << S_AUTONEG_DONE)
#define F_AUTONEG_DONE    V_AUTONEG_DONE(1U)

#define S_PCSR_HI_BER    18
#define V_PCSR_HI_BER(x) ((x) << S_PCSR_HI_BER)
#define F_PCSR_HI_BER    V_PCSR_HI_BER(1U)

#define S_PCSR_FEC_ERROR    17
#define V_PCSR_FEC_ERROR(x) ((x) << S_PCSR_FEC_ERROR)
#define F_PCSR_FEC_ERROR    V_PCSR_FEC_ERROR(1U)

#define S_PCSR_LINK_FAIL    16
#define V_PCSR_LINK_FAIL(x) ((x) << S_PCSR_LINK_FAIL)
#define F_PCSR_LINK_FAIL    V_PCSR_LINK_FAIL(1U)

#define S_XAUI_DEC_ERROR    15
#define V_XAUI_DEC_ERROR(x) ((x) << S_XAUI_DEC_ERROR)
#define F_XAUI_DEC_ERROR    V_XAUI_DEC_ERROR(1U)

#define S_XAUI_LINK_FAIL    14
#define V_XAUI_LINK_FAIL(x) ((x) << S_XAUI_LINK_FAIL)
#define F_XAUI_LINK_FAIL    V_XAUI_LINK_FAIL(1U)

#define S_PCS_CTC_ERROR    13
#define V_PCS_CTC_ERROR(x) ((x) << S_PCS_CTC_ERROR)
#define F_PCS_CTC_ERROR    V_PCS_CTC_ERROR(1U)

#define S_PCS_LINK_GOOD    12
#define V_PCS_LINK_GOOD(x) ((x) << S_PCS_LINK_GOOD)
#define F_PCS_LINK_GOOD    V_PCS_LINK_GOOD(1U)

#define S_PCS_LINK_FAIL    11
#define V_PCS_LINK_FAIL(x) ((x) << S_PCS_LINK_FAIL)
#define F_PCS_LINK_FAIL    V_PCS_LINK_FAIL(1U)

#define S_RXFIFOOVERFLOW    10
#define V_RXFIFOOVERFLOW(x) ((x) << S_RXFIFOOVERFLOW)
#define F_RXFIFOOVERFLOW    V_RXFIFOOVERFLOW(1U)

#define S_HSSPRBSERR    9
#define V_HSSPRBSERR(x) ((x) << S_HSSPRBSERR)
#define F_HSSPRBSERR    V_HSSPRBSERR(1U)

#define S_HSSEYEQUAL    8
#define V_HSSEYEQUAL(x) ((x) << S_HSSEYEQUAL)
#define F_HSSEYEQUAL    V_HSSEYEQUAL(1U)

#define S_REMOTEFAULT    7
#define V_REMOTEFAULT(x) ((x) << S_REMOTEFAULT)
#define F_REMOTEFAULT    V_REMOTEFAULT(1U)

#define S_LOCALFAULT    6
#define V_LOCALFAULT(x) ((x) << S_LOCALFAULT)
#define F_LOCALFAULT    V_LOCALFAULT(1U)

#define S_MAC_LINK_DOWN    5
#define V_MAC_LINK_DOWN(x) ((x) << S_MAC_LINK_DOWN)
#define F_MAC_LINK_DOWN    V_MAC_LINK_DOWN(1U)

#define S_MAC_LINK_UP    4
#define V_MAC_LINK_UP(x) ((x) << S_MAC_LINK_UP)
#define F_MAC_LINK_UP    V_MAC_LINK_UP(1U)

#define S_BEAN_INT    3
#define V_BEAN_INT(x) ((x) << S_BEAN_INT)
#define F_BEAN_INT    V_BEAN_INT(1U)

#define S_XGM_INT    2
#define V_XGM_INT(x) ((x) << S_XGM_INT)
#define F_XGM_INT    V_XGM_INT(1U)

#define A_XGMAC_PORT_INT_CAUSE 0x10dc
#define A_XGMAC_PORT_HSS_CFG0 0x10e0

#define S_TXDTS    31
#define V_TXDTS(x) ((x) << S_TXDTS)
#define F_TXDTS    V_TXDTS(1U)

#define S_TXCTS    30
#define V_TXCTS(x) ((x) << S_TXCTS)
#define F_TXCTS    V_TXCTS(1U)

#define S_TXBTS    29
#define V_TXBTS(x) ((x) << S_TXBTS)
#define F_TXBTS    V_TXBTS(1U)

#define S_TXATS    28
#define V_TXATS(x) ((x) << S_TXATS)
#define F_TXATS    V_TXATS(1U)

#define S_TXDOBS    27
#define V_TXDOBS(x) ((x) << S_TXDOBS)
#define F_TXDOBS    V_TXDOBS(1U)

#define S_TXCOBS    26
#define V_TXCOBS(x) ((x) << S_TXCOBS)
#define F_TXCOBS    V_TXCOBS(1U)

#define S_TXBOBS    25
#define V_TXBOBS(x) ((x) << S_TXBOBS)
#define F_TXBOBS    V_TXBOBS(1U)

#define S_TXAOBS    24
#define V_TXAOBS(x) ((x) << S_TXAOBS)
#define F_TXAOBS    V_TXAOBS(1U)

#define S_HSSREFCLKSEL    20
#define V_HSSREFCLKSEL(x) ((x) << S_HSSREFCLKSEL)
#define F_HSSREFCLKSEL    V_HSSREFCLKSEL(1U)

#define S_HSSAVDHI    17
#define V_HSSAVDHI(x) ((x) << S_HSSAVDHI)
#define F_HSSAVDHI    V_HSSAVDHI(1U)

#define S_HSSRXTS    16
#define V_HSSRXTS(x) ((x) << S_HSSRXTS)
#define F_HSSRXTS    V_HSSRXTS(1U)

#define S_HSSTXACMODE    15
#define V_HSSTXACMODE(x) ((x) << S_HSSTXACMODE)
#define F_HSSTXACMODE    V_HSSTXACMODE(1U)

#define S_HSSRXACMODE    14
#define V_HSSRXACMODE(x) ((x) << S_HSSRXACMODE)
#define F_HSSRXACMODE    V_HSSRXACMODE(1U)

#define S_HSSRESYNC    13
#define V_HSSRESYNC(x) ((x) << S_HSSRESYNC)
#define F_HSSRESYNC    V_HSSRESYNC(1U)

#define S_HSSRECCAL    12
#define V_HSSRECCAL(x) ((x) << S_HSSRECCAL)
#define F_HSSRECCAL    V_HSSRECCAL(1U)

#define S_HSSPDWNPLL    11
#define V_HSSPDWNPLL(x) ((x) << S_HSSPDWNPLL)
#define F_HSSPDWNPLL    V_HSSPDWNPLL(1U)

#define S_HSSDIVSEL    9
#define M_HSSDIVSEL    0x3U
#define V_HSSDIVSEL(x) ((x) << S_HSSDIVSEL)
#define G_HSSDIVSEL(x) (((x) >> S_HSSDIVSEL) & M_HSSDIVSEL)

#define S_HSSREFDIV    8
#define V_HSSREFDIV(x) ((x) << S_HSSREFDIV)
#define F_HSSREFDIV    V_HSSREFDIV(1U)

#define S_HSSPLLBYP    7
#define V_HSSPLLBYP(x) ((x) << S_HSSPLLBYP)
#define F_HSSPLLBYP    V_HSSPLLBYP(1U)

#define S_HSSLOFREQPLL    6
#define V_HSSLOFREQPLL(x) ((x) << S_HSSLOFREQPLL)
#define F_HSSLOFREQPLL    V_HSSLOFREQPLL(1U)

#define S_HSSLOFREQ2PLL    5
#define V_HSSLOFREQ2PLL(x) ((x) << S_HSSLOFREQ2PLL)
#define F_HSSLOFREQ2PLL    V_HSSLOFREQ2PLL(1U)

#define S_HSSEXTC16SEL    4
#define V_HSSEXTC16SEL(x) ((x) << S_HSSEXTC16SEL)
#define F_HSSEXTC16SEL    V_HSSEXTC16SEL(1U)

#define S_HSSRSTCONFIG    1
#define M_HSSRSTCONFIG    0x7U
#define V_HSSRSTCONFIG(x) ((x) << S_HSSRSTCONFIG)
#define G_HSSRSTCONFIG(x) (((x) >> S_HSSRSTCONFIG) & M_HSSRSTCONFIG)

#define S_HSSPRBSEN    0
#define V_HSSPRBSEN(x) ((x) << S_HSSPRBSEN)
#define F_HSSPRBSEN    V_HSSPRBSEN(1U)

#define A_XGMAC_PORT_HSS_CFG1 0x10e4

#define S_RXDPRBSRST    28
#define V_RXDPRBSRST(x) ((x) << S_RXDPRBSRST)
#define F_RXDPRBSRST    V_RXDPRBSRST(1U)

#define S_RXDPRBSEN    27
#define V_RXDPRBSEN(x) ((x) << S_RXDPRBSEN)
#define F_RXDPRBSEN    V_RXDPRBSEN(1U)

#define S_RXDPRBSFRCERR    26
#define V_RXDPRBSFRCERR(x) ((x) << S_RXDPRBSFRCERR)
#define F_RXDPRBSFRCERR    V_RXDPRBSFRCERR(1U)

#define S_TXDPRBSRST    25
#define V_TXDPRBSRST(x) ((x) << S_TXDPRBSRST)
#define F_TXDPRBSRST    V_TXDPRBSRST(1U)

#define S_TXDPRBSEN    24
#define V_TXDPRBSEN(x) ((x) << S_TXDPRBSEN)
#define F_TXDPRBSEN    V_TXDPRBSEN(1U)

#define S_RXCPRBSRST    20
#define V_RXCPRBSRST(x) ((x) << S_RXCPRBSRST)
#define F_RXCPRBSRST    V_RXCPRBSRST(1U)

#define S_RXCPRBSEN    19
#define V_RXCPRBSEN(x) ((x) << S_RXCPRBSEN)
#define F_RXCPRBSEN    V_RXCPRBSEN(1U)

#define S_RXCPRBSFRCERR    18
#define V_RXCPRBSFRCERR(x) ((x) << S_RXCPRBSFRCERR)
#define F_RXCPRBSFRCERR    V_RXCPRBSFRCERR(1U)

#define S_TXCPRBSRST    17
#define V_TXCPRBSRST(x) ((x) << S_TXCPRBSRST)
#define F_TXCPRBSRST    V_TXCPRBSRST(1U)

#define S_TXCPRBSEN    16
#define V_TXCPRBSEN(x) ((x) << S_TXCPRBSEN)
#define F_TXCPRBSEN    V_TXCPRBSEN(1U)

#define S_RXBPRBSRST    12
#define V_RXBPRBSRST(x) ((x) << S_RXBPRBSRST)
#define F_RXBPRBSRST    V_RXBPRBSRST(1U)

#define S_RXBPRBSEN    11
#define V_RXBPRBSEN(x) ((x) << S_RXBPRBSEN)
#define F_RXBPRBSEN    V_RXBPRBSEN(1U)

#define S_RXBPRBSFRCERR    10
#define V_RXBPRBSFRCERR(x) ((x) << S_RXBPRBSFRCERR)
#define F_RXBPRBSFRCERR    V_RXBPRBSFRCERR(1U)

#define S_TXBPRBSRST    9
#define V_TXBPRBSRST(x) ((x) << S_TXBPRBSRST)
#define F_TXBPRBSRST    V_TXBPRBSRST(1U)

#define S_TXBPRBSEN    8
#define V_TXBPRBSEN(x) ((x) << S_TXBPRBSEN)
#define F_TXBPRBSEN    V_TXBPRBSEN(1U)

#define S_RXAPRBSRST    4
#define V_RXAPRBSRST(x) ((x) << S_RXAPRBSRST)
#define F_RXAPRBSRST    V_RXAPRBSRST(1U)

#define S_RXAPRBSEN    3
#define V_RXAPRBSEN(x) ((x) << S_RXAPRBSEN)
#define F_RXAPRBSEN    V_RXAPRBSEN(1U)

#define S_RXAPRBSFRCERR    2
#define V_RXAPRBSFRCERR(x) ((x) << S_RXAPRBSFRCERR)
#define F_RXAPRBSFRCERR    V_RXAPRBSFRCERR(1U)

#define S_TXAPRBSRST    1
#define V_TXAPRBSRST(x) ((x) << S_TXAPRBSRST)
#define F_TXAPRBSRST    V_TXAPRBSRST(1U)

#define S_TXAPRBSEN    0
#define V_TXAPRBSEN(x) ((x) << S_TXAPRBSEN)
#define F_TXAPRBSEN    V_TXAPRBSEN(1U)

#define A_XGMAC_PORT_HSS_CFG2 0x10e8

#define S_RXDDATASYNC    23
#define V_RXDDATASYNC(x) ((x) << S_RXDDATASYNC)
#define F_RXDDATASYNC    V_RXDDATASYNC(1U)

#define S_RXCDATASYNC    22
#define V_RXCDATASYNC(x) ((x) << S_RXCDATASYNC)
#define F_RXCDATASYNC    V_RXCDATASYNC(1U)

#define S_RXBDATASYNC    21
#define V_RXBDATASYNC(x) ((x) << S_RXBDATASYNC)
#define F_RXBDATASYNC    V_RXBDATASYNC(1U)

#define S_RXADATASYNC    20
#define V_RXADATASYNC(x) ((x) << S_RXADATASYNC)
#define F_RXADATASYNC    V_RXADATASYNC(1U)

#define S_RXDEARLYIN    19
#define V_RXDEARLYIN(x) ((x) << S_RXDEARLYIN)
#define F_RXDEARLYIN    V_RXDEARLYIN(1U)

#define S_RXDLATEIN    18
#define V_RXDLATEIN(x) ((x) << S_RXDLATEIN)
#define F_RXDLATEIN    V_RXDLATEIN(1U)

#define S_RXDPHSLOCK    17
#define V_RXDPHSLOCK(x) ((x) << S_RXDPHSLOCK)
#define F_RXDPHSLOCK    V_RXDPHSLOCK(1U)

#define S_RXDPHSDNIN    16
#define V_RXDPHSDNIN(x) ((x) << S_RXDPHSDNIN)
#define F_RXDPHSDNIN    V_RXDPHSDNIN(1U)

#define S_RXDPHSUPIN    15
#define V_RXDPHSUPIN(x) ((x) << S_RXDPHSUPIN)
#define F_RXDPHSUPIN    V_RXDPHSUPIN(1U)

#define S_RXCEARLYIN    14
#define V_RXCEARLYIN(x) ((x) << S_RXCEARLYIN)
#define F_RXCEARLYIN    V_RXCEARLYIN(1U)

#define S_RXCLATEIN    13
#define V_RXCLATEIN(x) ((x) << S_RXCLATEIN)
#define F_RXCLATEIN    V_RXCLATEIN(1U)

#define S_RXCPHSLOCK    12
#define V_RXCPHSLOCK(x) ((x) << S_RXCPHSLOCK)
#define F_RXCPHSLOCK    V_RXCPHSLOCK(1U)

#define S_RXCPHSDNIN    11
#define V_RXCPHSDNIN(x) ((x) << S_RXCPHSDNIN)
#define F_RXCPHSDNIN    V_RXCPHSDNIN(1U)

#define S_RXCPHSUPIN    10
#define V_RXCPHSUPIN(x) ((x) << S_RXCPHSUPIN)
#define F_RXCPHSUPIN    V_RXCPHSUPIN(1U)

#define S_RXBEARLYIN    9
#define V_RXBEARLYIN(x) ((x) << S_RXBEARLYIN)
#define F_RXBEARLYIN    V_RXBEARLYIN(1U)

#define S_RXBLATEIN    8
#define V_RXBLATEIN(x) ((x) << S_RXBLATEIN)
#define F_RXBLATEIN    V_RXBLATEIN(1U)

#define S_RXBPHSLOCK    7
#define V_RXBPHSLOCK(x) ((x) << S_RXBPHSLOCK)
#define F_RXBPHSLOCK    V_RXBPHSLOCK(1U)

#define S_RXBPHSDNIN    6
#define V_RXBPHSDNIN(x) ((x) << S_RXBPHSDNIN)
#define F_RXBPHSDNIN    V_RXBPHSDNIN(1U)

#define S_RXBPHSUPIN    5
#define V_RXBPHSUPIN(x) ((x) << S_RXBPHSUPIN)
#define F_RXBPHSUPIN    V_RXBPHSUPIN(1U)

#define S_RXAEARLYIN    4
#define V_RXAEARLYIN(x) ((x) << S_RXAEARLYIN)
#define F_RXAEARLYIN    V_RXAEARLYIN(1U)

#define S_RXALATEIN    3
#define V_RXALATEIN(x) ((x) << S_RXALATEIN)
#define F_RXALATEIN    V_RXALATEIN(1U)

#define S_RXAPHSLOCK    2
#define V_RXAPHSLOCK(x) ((x) << S_RXAPHSLOCK)
#define F_RXAPHSLOCK    V_RXAPHSLOCK(1U)

#define S_RXAPHSDNIN    1
#define V_RXAPHSDNIN(x) ((x) << S_RXAPHSDNIN)
#define F_RXAPHSDNIN    V_RXAPHSDNIN(1U)

#define S_RXAPHSUPIN    0
#define V_RXAPHSUPIN(x) ((x) << S_RXAPHSUPIN)
#define F_RXAPHSUPIN    V_RXAPHSUPIN(1U)

#define A_XGMAC_PORT_HSS_STATUS 0x10ec

#define S_RXDPRBSSYNC    15
#define V_RXDPRBSSYNC(x) ((x) << S_RXDPRBSSYNC)
#define F_RXDPRBSSYNC    V_RXDPRBSSYNC(1U)

#define S_RXCPRBSSYNC    14
#define V_RXCPRBSSYNC(x) ((x) << S_RXCPRBSSYNC)
#define F_RXCPRBSSYNC    V_RXCPRBSSYNC(1U)

#define S_RXBPRBSSYNC    13
#define V_RXBPRBSSYNC(x) ((x) << S_RXBPRBSSYNC)
#define F_RXBPRBSSYNC    V_RXBPRBSSYNC(1U)

#define S_RXAPRBSSYNC    12
#define V_RXAPRBSSYNC(x) ((x) << S_RXAPRBSSYNC)
#define F_RXAPRBSSYNC    V_RXAPRBSSYNC(1U)

#define S_RXDPRBSERR    11
#define V_RXDPRBSERR(x) ((x) << S_RXDPRBSERR)
#define F_RXDPRBSERR    V_RXDPRBSERR(1U)

#define S_RXCPRBSERR    10
#define V_RXCPRBSERR(x) ((x) << S_RXCPRBSERR)
#define F_RXCPRBSERR    V_RXCPRBSERR(1U)

#define S_RXBPRBSERR    9
#define V_RXBPRBSERR(x) ((x) << S_RXBPRBSERR)
#define F_RXBPRBSERR    V_RXBPRBSERR(1U)

#define S_RXAPRBSERR    8
#define V_RXAPRBSERR(x) ((x) << S_RXAPRBSERR)
#define F_RXAPRBSERR    V_RXAPRBSERR(1U)

#define S_RXDSIGDET    7
#define V_RXDSIGDET(x) ((x) << S_RXDSIGDET)
#define F_RXDSIGDET    V_RXDSIGDET(1U)

#define S_RXCSIGDET    6
#define V_RXCSIGDET(x) ((x) << S_RXCSIGDET)
#define F_RXCSIGDET    V_RXCSIGDET(1U)

#define S_RXBSIGDET    5
#define V_RXBSIGDET(x) ((x) << S_RXBSIGDET)
#define F_RXBSIGDET    V_RXBSIGDET(1U)

#define S_RXASIGDET    4
#define V_RXASIGDET(x) ((x) << S_RXASIGDET)
#define F_RXASIGDET    V_RXASIGDET(1U)

#define S_HSSPLLLOCK    1
#define V_HSSPLLLOCK(x) ((x) << S_HSSPLLLOCK)
#define F_HSSPLLLOCK    V_HSSPLLLOCK(1U)

#define S_HSSPRTREADY    0
#define V_HSSPRTREADY(x) ((x) << S_HSSPRTREADY)
#define F_HSSPRTREADY    V_HSSPRTREADY(1U)

#define A_XGMAC_PORT_XGM_TX_CTRL 0x1200

#define S_SENDPAUSE    2
#define V_SENDPAUSE(x) ((x) << S_SENDPAUSE)
#define F_SENDPAUSE    V_SENDPAUSE(1U)

#define S_SENDZEROPAUSE    1
#define V_SENDZEROPAUSE(x) ((x) << S_SENDZEROPAUSE)
#define F_SENDZEROPAUSE    V_SENDZEROPAUSE(1U)

#define S_XGM_TXEN    0
#define V_XGM_TXEN(x) ((x) << S_XGM_TXEN)
#define F_XGM_TXEN    V_XGM_TXEN(1U)

#define A_XGMAC_PORT_XGM_TX_CFG 0x1204

#define S_CRCCAL    8
#define M_CRCCAL    0x3U
#define V_CRCCAL(x) ((x) << S_CRCCAL)
#define G_CRCCAL(x) (((x) >> S_CRCCAL) & M_CRCCAL)

#define S_DISDEFIDLECNT    7
#define V_DISDEFIDLECNT(x) ((x) << S_DISDEFIDLECNT)
#define F_DISDEFIDLECNT    V_DISDEFIDLECNT(1U)

#define S_DECAVGTXIPG    6
#define V_DECAVGTXIPG(x) ((x) << S_DECAVGTXIPG)
#define F_DECAVGTXIPG    V_DECAVGTXIPG(1U)

#define S_UNIDIRTXEN    5
#define V_UNIDIRTXEN(x) ((x) << S_UNIDIRTXEN)
#define F_UNIDIRTXEN    V_UNIDIRTXEN(1U)

#define S_CFGCLKSPEED    2
#define M_CFGCLKSPEED    0x7U
#define V_CFGCLKSPEED(x) ((x) << S_CFGCLKSPEED)
#define G_CFGCLKSPEED(x) (((x) >> S_CFGCLKSPEED) & M_CFGCLKSPEED)

#define S_STRETCHMODE    1
#define V_STRETCHMODE(x) ((x) << S_STRETCHMODE)
#define F_STRETCHMODE    V_STRETCHMODE(1U)

#define S_TXPAUSEEN    0
#define V_TXPAUSEEN(x) ((x) << S_TXPAUSEEN)
#define F_TXPAUSEEN    V_TXPAUSEEN(1U)

#define A_XGMAC_PORT_XGM_TX_PAUSE_QUANTA 0x1208

#define S_TXPAUSEQUANTA    0
#define M_TXPAUSEQUANTA    0xffffU
#define V_TXPAUSEQUANTA(x) ((x) << S_TXPAUSEQUANTA)
#define G_TXPAUSEQUANTA(x) (((x) >> S_TXPAUSEQUANTA) & M_TXPAUSEQUANTA)

#define A_XGMAC_PORT_XGM_RX_CTRL 0x120c
#define A_XGMAC_PORT_XGM_RX_CFG 0x1210

#define S_RXCRCCAL    16
#define M_RXCRCCAL    0x3U
#define V_RXCRCCAL(x) ((x) << S_RXCRCCAL)
#define G_RXCRCCAL(x) (((x) >> S_RXCRCCAL) & M_RXCRCCAL)

#define S_STATLOCALFAULT    15
#define V_STATLOCALFAULT(x) ((x) << S_STATLOCALFAULT)
#define F_STATLOCALFAULT    V_STATLOCALFAULT(1U)

#define S_STATREMOTEFAULT    14
#define V_STATREMOTEFAULT(x) ((x) << S_STATREMOTEFAULT)
#define F_STATREMOTEFAULT    V_STATREMOTEFAULT(1U)

#define S_LENERRFRAMEDIS    13
#define V_LENERRFRAMEDIS(x) ((x) << S_LENERRFRAMEDIS)
#define F_LENERRFRAMEDIS    V_LENERRFRAMEDIS(1U)

#define S_CON802_3PREAMBLE    12
#define V_CON802_3PREAMBLE(x) ((x) << S_CON802_3PREAMBLE)
#define F_CON802_3PREAMBLE    V_CON802_3PREAMBLE(1U)

#define S_ENNON802_3PREAMBLE    11
#define V_ENNON802_3PREAMBLE(x) ((x) << S_ENNON802_3PREAMBLE)
#define F_ENNON802_3PREAMBLE    V_ENNON802_3PREAMBLE(1U)

#define S_COPYPREAMBLE    10
#define V_COPYPREAMBLE(x) ((x) << S_COPYPREAMBLE)
#define F_COPYPREAMBLE    V_COPYPREAMBLE(1U)

#define S_DISPAUSEFRAMES    9
#define V_DISPAUSEFRAMES(x) ((x) << S_DISPAUSEFRAMES)
#define F_DISPAUSEFRAMES    V_DISPAUSEFRAMES(1U)

#define S_EN1536BFRAMES    8
#define V_EN1536BFRAMES(x) ((x) << S_EN1536BFRAMES)
#define F_EN1536BFRAMES    V_EN1536BFRAMES(1U)

#define S_ENJUMBO    7
#define V_ENJUMBO(x) ((x) << S_ENJUMBO)
#define F_ENJUMBO    V_ENJUMBO(1U)

#define S_RMFCS    6
#define V_RMFCS(x) ((x) << S_RMFCS)
#define F_RMFCS    V_RMFCS(1U)

#define S_DISNONVLAN    5
#define V_DISNONVLAN(x) ((x) << S_DISNONVLAN)
#define F_DISNONVLAN    V_DISNONVLAN(1U)

#define S_ENEXTMATCH    4
#define V_ENEXTMATCH(x) ((x) << S_ENEXTMATCH)
#define F_ENEXTMATCH    V_ENEXTMATCH(1U)

#define S_ENHASHUCAST    3
#define V_ENHASHUCAST(x) ((x) << S_ENHASHUCAST)
#define F_ENHASHUCAST    V_ENHASHUCAST(1U)

#define S_ENHASHMCAST    2
#define V_ENHASHMCAST(x) ((x) << S_ENHASHMCAST)
#define F_ENHASHMCAST    V_ENHASHMCAST(1U)

#define S_DISBCAST    1
#define V_DISBCAST(x) ((x) << S_DISBCAST)
#define F_DISBCAST    V_DISBCAST(1U)

#define S_COPYALLFRAMES    0
#define V_COPYALLFRAMES(x) ((x) << S_COPYALLFRAMES)
#define F_COPYALLFRAMES    V_COPYALLFRAMES(1U)

#define A_XGMAC_PORT_XGM_RX_HASH_LOW 0x1214
#define A_XGMAC_PORT_XGM_RX_HASH_HIGH 0x1218
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_LOW_1 0x121c
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_HIGH_1 0x1220

#define S_ADDRESS_HIGH    0
#define M_ADDRESS_HIGH    0xffffU
#define V_ADDRESS_HIGH(x) ((x) << S_ADDRESS_HIGH)
#define G_ADDRESS_HIGH(x) (((x) >> S_ADDRESS_HIGH) & M_ADDRESS_HIGH)

#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_LOW_2 0x1224
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_HIGH_2 0x1228
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_LOW_3 0x122c
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_HIGH_3 0x1230
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_LOW_4 0x1234
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_HIGH_4 0x1238
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_LOW_5 0x123c
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_HIGH_5 0x1240
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_LOW_6 0x1244
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_HIGH_6 0x1248
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_LOW_7 0x124c
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_HIGH_7 0x1250
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_LOW_8 0x1254
#define A_XGMAC_PORT_XGM_RX_EXACT_MATCH_HIGH_8 0x1258
#define A_XGMAC_PORT_XGM_RX_TYPE_MATCH_1 0x125c

#define S_ENTYPEMATCH    31
#define V_ENTYPEMATCH(x) ((x) << S_ENTYPEMATCH)
#define F_ENTYPEMATCH    V_ENTYPEMATCH(1U)

#define S_TYPE    0
#define M_TYPE    0xffffU
#define V_TYPE(x) ((x) << S_TYPE)
#define G_TYPE(x) (((x) >> S_TYPE) & M_TYPE)

#define A_XGMAC_PORT_XGM_RX_TYPE_MATCH_2 0x1260
#define A_XGMAC_PORT_XGM_RX_TYPE_MATCH_3 0x1264
#define A_XGMAC_PORT_XGM_RX_TYPE_MATCH_4 0x1268
#define A_XGMAC_PORT_XGM_INT_STATUS 0x126c

#define S_XGMIIEXTINT    10
#define V_XGMIIEXTINT(x) ((x) << S_XGMIIEXTINT)
#define F_XGMIIEXTINT    V_XGMIIEXTINT(1U)

#define S_LINKFAULTCHANGE    9
#define V_LINKFAULTCHANGE(x) ((x) << S_LINKFAULTCHANGE)
#define F_LINKFAULTCHANGE    V_LINKFAULTCHANGE(1U)

#define S_PHYFRAMECOMPLETE    8
#define V_PHYFRAMECOMPLETE(x) ((x) << S_PHYFRAMECOMPLETE)
#define F_PHYFRAMECOMPLETE    V_PHYFRAMECOMPLETE(1U)

#define S_PAUSEFRAMETXMT    7
#define V_PAUSEFRAMETXMT(x) ((x) << S_PAUSEFRAMETXMT)
#define F_PAUSEFRAMETXMT    V_PAUSEFRAMETXMT(1U)

#define S_PAUSECNTRTIMEOUT    6
#define V_PAUSECNTRTIMEOUT(x) ((x) << S_PAUSECNTRTIMEOUT)
#define F_PAUSECNTRTIMEOUT    V_PAUSECNTRTIMEOUT(1U)

#define S_NON0PAUSERCVD    5
#define V_NON0PAUSERCVD(x) ((x) << S_NON0PAUSERCVD)
#define F_NON0PAUSERCVD    V_NON0PAUSERCVD(1U)

#define S_STATOFLOW    4
#define V_STATOFLOW(x) ((x) << S_STATOFLOW)
#define F_STATOFLOW    V_STATOFLOW(1U)

#define S_TXERRFIFO    3
#define V_TXERRFIFO(x) ((x) << S_TXERRFIFO)
#define F_TXERRFIFO    V_TXERRFIFO(1U)

#define S_TXUFLOW    2
#define V_TXUFLOW(x) ((x) << S_TXUFLOW)
#define F_TXUFLOW    V_TXUFLOW(1U)

#define S_FRAMETXMT    1
#define V_FRAMETXMT(x) ((x) << S_FRAMETXMT)
#define F_FRAMETXMT    V_FRAMETXMT(1U)

#define S_FRAMERCVD    0
#define V_FRAMERCVD(x) ((x) << S_FRAMERCVD)
#define F_FRAMERCVD    V_FRAMERCVD(1U)

#define A_XGMAC_PORT_XGM_INT_MASK 0x1270
#define A_XGMAC_PORT_XGM_INT_EN 0x1274
#define A_XGMAC_PORT_XGM_INT_DISABLE 0x1278
#define A_XGMAC_PORT_XGM_TX_PAUSE_TIMER 0x127c

#define S_CURPAUSETIMER    0
#define M_CURPAUSETIMER    0xffffU
#define V_CURPAUSETIMER(x) ((x) << S_CURPAUSETIMER)
#define G_CURPAUSETIMER(x) (((x) >> S_CURPAUSETIMER) & M_CURPAUSETIMER)

#define A_XGMAC_PORT_XGM_STAT_CTRL 0x1280

#define S_READSNPSHOT    4
#define V_READSNPSHOT(x) ((x) << S_READSNPSHOT)
#define F_READSNPSHOT    V_READSNPSHOT(1U)

#define S_TAKESNPSHOT    3
#define V_TAKESNPSHOT(x) ((x) << S_TAKESNPSHOT)
#define F_TAKESNPSHOT    V_TAKESNPSHOT(1U)

#define S_CLRSTATS    2
#define V_CLRSTATS(x) ((x) << S_CLRSTATS)
#define F_CLRSTATS    V_CLRSTATS(1U)

#define S_INCRSTATS    1
#define V_INCRSTATS(x) ((x) << S_INCRSTATS)
#define F_INCRSTATS    V_INCRSTATS(1U)

#define S_ENTESTMODEWR    0
#define V_ENTESTMODEWR(x) ((x) << S_ENTESTMODEWR)
#define F_ENTESTMODEWR    V_ENTESTMODEWR(1U)

#define A_XGMAC_PORT_XGM_MDIO_CTRL 0x1284

#define S_FRAMETYPE    30
#define M_FRAMETYPE    0x3U
#define V_FRAMETYPE(x) ((x) << S_FRAMETYPE)
#define G_FRAMETYPE(x) (((x) >> S_FRAMETYPE) & M_FRAMETYPE)

#define S_OPERATION    28
#define M_OPERATION    0x3U
#define V_OPERATION(x) ((x) << S_OPERATION)
#define G_OPERATION(x) (((x) >> S_OPERATION) & M_OPERATION)

#define S_PORTADDR    23
#define M_PORTADDR    0x1fU
#define V_PORTADDR(x) ((x) << S_PORTADDR)
#define G_PORTADDR(x) (((x) >> S_PORTADDR) & M_PORTADDR)

#define S_DEVADDR    18
#define M_DEVADDR    0x1fU
#define V_DEVADDR(x) ((x) << S_DEVADDR)
#define G_DEVADDR(x) (((x) >> S_DEVADDR) & M_DEVADDR)

#define S_RESRV    16
#define M_RESRV    0x3U
#define V_RESRV(x) ((x) << S_RESRV)
#define G_RESRV(x) (((x) >> S_RESRV) & M_RESRV)

#define S_DATA    0
#define M_DATA    0xffffU
#define V_DATA(x) ((x) << S_DATA)
#define G_DATA(x) (((x) >> S_DATA) & M_DATA)

#define A_XGMAC_PORT_XGM_MODULE_ID 0x12fc

#define S_MODULEID    16
#define M_MODULEID    0xffffU
#define V_MODULEID(x) ((x) << S_MODULEID)
#define G_MODULEID(x) (((x) >> S_MODULEID) & M_MODULEID)

#define S_MODULEREV    0
#define M_MODULEREV    0xffffU
#define V_MODULEREV(x) ((x) << S_MODULEREV)
#define G_MODULEREV(x) (((x) >> S_MODULEREV) & M_MODULEREV)

#define A_XGMAC_PORT_XGM_STAT_TX_BYTE_LOW 0x1300
#define A_XGMAC_PORT_XGM_STAT_TX_BYTE_HIGH 0x1304

#define S_TXBYTES_HIGH    0
#define M_TXBYTES_HIGH    0x1fffU
#define V_TXBYTES_HIGH(x) ((x) << S_TXBYTES_HIGH)
#define G_TXBYTES_HIGH(x) (((x) >> S_TXBYTES_HIGH) & M_TXBYTES_HIGH)

#define A_XGMAC_PORT_XGM_STAT_TX_FRAME_LOW 0x1308
#define A_XGMAC_PORT_XGM_STAT_TX_FRAME_HIGH 0x130c

#define S_TXFRAMES_HIGH    0
#define M_TXFRAMES_HIGH    0xfU
#define V_TXFRAMES_HIGH(x) ((x) << S_TXFRAMES_HIGH)
#define G_TXFRAMES_HIGH(x) (((x) >> S_TXFRAMES_HIGH) & M_TXFRAMES_HIGH)

#define A_XGMAC_PORT_XGM_STAT_TX_BCAST 0x1310
#define A_XGMAC_PORT_XGM_STAT_TX_MCAST 0x1314
#define A_XGMAC_PORT_XGM_STAT_TX_PAUSE 0x1318
#define A_XGMAC_PORT_XGM_STAT_TX_64B_FRAMES 0x131c
#define A_XGMAC_PORT_XGM_STAT_TX_65_127B_FRAMES 0x1320
#define A_XGMAC_PORT_XGM_STAT_TX_128_255B_FRAMES 0x1324
#define A_XGMAC_PORT_XGM_STAT_TX_256_511B_FRAMES 0x1328
#define A_XGMAC_PORT_XGM_STAT_TX_512_1023B_FRAMES 0x132c
#define A_XGMAC_PORT_XGM_STAT_TX_1024_1518B_FRAMES 0x1330
#define A_XGMAC_PORT_XGM_STAT_TX_1519_MAXB_FRAMES 0x1334
#define A_XGMAC_PO