/*-
 * Copyright 2007 Advanced Micro Devices, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * IN NO EVENT SHALL THE COPYRIGHT OWNER(S) AND/OR ITS SUPPLIERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/8/sys/dev/drm/r600_microcode.h 189499 2009-03-07 21:36:57Z rnoland $");

static const int ME_JUMP_TABLE_START = 1764;
static const int ME_JUMP_TABLE_END   = 1792;

#define PFP_UCODE_SIZE 576
#define PM4_UCODE_SIZE 1792
#define R700_PFP_UCODE_SIZE 848
#define R700_PM4_UCODE_SIZE 1360

static const u32 R600_cp_microcode[][3]={
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0000ffff, 0x00284621, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000000, 0x00e00000, 0x000 },
    { 0x00010000, 0xc0294620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x614 },
    { 0x00000000, 0x00600000, 0x5b2 },
    { 0x00000000, 0x00600000, 0x5c5 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000f00, 0x00281622, 0x000 },
    { 0x00000008, 0x00211625, 0x000 },
    { 0x00000020, 0x00203625, 0x000 },
    { 0x8d000000, 0x00204411, 0x000 },
    { 0x00000004, 0x002f0225, 0x000 },
    { 0x00000000, 0x0ce00000, 0x018 },
    { 0x00412000, 0x00404811, 0x019 },
    { 0x00422000, 0x00204811, 0x000 },
    { 0x8e000000, 0x00204411, 0x000 },
    { 0x00000031, 0x00204a2d, 0x000 },
    { 0x90000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x0000000c, 0x00211622, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000019, 0x00211a22, 0x000 },
    { 0x00000004, 0x00281a26, 0x000 },
    { 0x00000000, 0x002914c5, 0x000 },
    { 0x00000021, 0x00203625, 0x000 },
    { 0x00000000, 0x003a1402, 0x000 },
    { 0x00000016, 0x00211625, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x0000001d, 0x00200e2d, 0x000 },
    { 0xfffffffc, 0x00280e23, 0x000 },
    { 0x00000000, 0x002914a3, 0x000 },
    { 0x0000001d, 0x00203625, 0x000 },
    { 0x00008000, 0x00280e22, 0x000 },
    { 0x00000007, 0x00220e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x20000000, 0x00280e22, 0x000 },
    { 0x00000006, 0x00210e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x00000000, 0x00220222, 0x000 },
    { 0x00000000, 0x14e00000, 0x038 },
    { 0x00000000, 0x2ee00000, 0x035 },
    { 0x00000000, 0x2ce00000, 0x037 },
    { 0x00000000, 0x00400e2d, 0x039 },
    { 0x00000008, 0x00200e2d, 0x000 },
    { 0x00000009, 0x0040122d, 0x046 },
    { 0x00000001, 0x00400e2d, 0x039 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x03e },
    { 0x00000008, 0x00401c11, 0x041 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x0000000f, 0x00281e27, 0x000 },
    { 0x00000003, 0x00221e27, 0x000 },
    { 0x7fc00000, 0x00281a23, 0x000 },
    { 0x00000014, 0x00211a26, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000008, 0x00221a26, 0x000 },
    { 0x00000000, 0x00290cc7, 0x000 },
    { 0x00000030, 0x00203624, 0x000 },
    { 0x00007f00, 0x00281221, 0x000 },
    { 0x00001400, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x04b },
    { 0x00000001, 0x00290e23, 0x000 },
    { 0x00000010, 0x00203623, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfff80000, 0x00294a23, 0x000 },
    { 0x00000000, 0x003a2c02, 0x000 },
    { 0x00000002, 0x00220e2b, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x00000011, 0x00203623, 0x000 },
    { 0x00001fff, 0x00294a23, 0x000 },
    { 0x00000030, 0x00204a2d, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000032, 0x00200e2d, 0x000 },
    { 0x060a0200, 0x00294a23, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14e00000, 0x061 },
    { 0x00000000, 0x2ee00000, 0x05f },
    { 0x00000000, 0x2ce00000, 0x05e },
    { 0x00000000, 0x00400e2d, 0x062 },
    { 0x00000001, 0x00400e2d, 0x062 },
    { 0x0000000a, 0x00200e2d, 0x000 },
    { 0x0000000b, 0x0040122d, 0x06a },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x7fc00000, 0x00281623, 0x000 },
    { 0x00000014, 0x00211625, 0x000 },
    { 0x00000001, 0x00331625, 0x000 },
    { 0x80000000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00290ca3, 0x000 },
    { 0x3ffffc00, 0x00290e23, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x06d },
    { 0x00000100, 0x00401c11, 0x070 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x000000f0, 0x00281e27, 0x000 },
    { 0x00000004, 0x00221e27, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0xfffff0ff, 0x00281a30, 0x000 },
    { 0x0000a028, 0x00204411, 0x000 },
    { 0x00000000, 0x002948e6, 0x000 },
    { 0x0000a018, 0x00204411, 0x000 },
    { 0x3fffffff, 0x00284a23, 0x000 },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x0000002d, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a3, 0x000 },
    { 0x00000000, 0x0cc00000, 0x080 },
    { 0x0000002e, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a4, 0x000 },
    { 0x00000000, 0x0cc00000, 0x081 },
    { 0x00000000, 0x00400000, 0x087 },
    { 0x0000002d, 0x00203623, 0x000 },
    { 0x0000002e, 0x00203624, 0x000 },
    { 0x0000001d, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x087 },
    { 0x00000000, 0x00600000, 0x5ed },
    { 0x00000000, 0x00600000, 0x5e1 },
    { 0x00000002, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x08a },
    { 0x00000018, 0xc0403620, 0x090 },
    { 0x00000000, 0x2ee00000, 0x08e },
    { 0x00000000, 0x2ce00000, 0x08d },
    { 0x00000002, 0x00400e2d, 0x08f },
    { 0x00000003, 0x00400e2d, 0x08f },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000018, 0x00203623, 0x000 },
    { 0x00000003, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x095 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x09d },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x2ee00000, 0x09b },
    { 0x00000000, 0x2ce00000, 0x09a },
    { 0x00000002, 0x00400e2d, 0x09c },
    { 0x00000003, 0x00400e2d, 0x09c },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x003f0000, 0x00280e23, 0x000 },
    { 0x00000010, 0x00210e23, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x0000001e, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0a4 },
    { 0x0000001c, 0xc0203620, 0x000 },
    { 0x0000001f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0a7 },
    { 0x0000001b, 0xc0203620, 0x000 },
    { 0x00000008, 0x00210e2b, 0x000 },
    { 0x0000007f, 0x00280e23, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0db },
    { 0x00000000, 0x27000000, 0x000 },
    { 0x00000000, 0x00600000, 0x28c },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000000c, 0x00221e30, 0x000 },
    { 0x99800000, 0x00204411, 0x000 },
    { 0x00000004, 0x0020122d, 0x000 },
    { 0x00000008, 0x00221224, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00291ce4, 0x000 },
    { 0x00000000, 0x00604807, 0x128 },
    { 0x9b000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x9c000000, 0x00204411, 0x000 },
    { 0x00000000, 0x0033146f, 0x000 },
    { 0x00000001, 0x00333e23, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0x00203c05, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e007, 0x00204411, 0x000 },
    { 0x0000000f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0c5 },
    { 0x00f8ff08, 0x00204811, 0x000 },
    { 0x98000000, 0x00404811, 0x0d6 },
    { 0x000000f0, 0x00280e22, 0x000 },
    { 0x000000a0, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x0d4 },
    { 0x00000013, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0cf },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0ce },
    { 0x00003f00, 0x00400c11, 0x0d0 },
    { 0x00001f00, 0x00400c11, 0x0d0 },
    { 0x00000f00, 0x00200c11, 0x000 },
    { 0x00380009, 0x00294a23, 0x000 },
    { 0x3f000000, 0x00280e2b, 0x000 },
    { 0x00000002, 0x00220e23, 0x000 },
    { 0x00000007, 0x00494a23, 0x0d6 },
    { 0x00380f09, 0x00204811, 0x000 },
    { 0x68000007, 0x00204811, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000a202, 0x00204411, 0x000 },
    { 0x00ff0000, 0x00284a22, 0x000 },
    { 0x00000030, 0x00200e2d, 0x000 },
    { 0x0000002e, 0x0020122d, 0x000 },
    { 0x00000000, 0x002f0083, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0e3 },
    { 0x00000000, 0x00600000, 0x5e7 },
    { 0x00000000, 0x00400000, 0x0e4 },
    { 0x00000000, 0x00600000, 0x5ea },
    { 0x00000007, 0x0020222d, 0x000 },
    { 0x00000005, 0x00220e22, 0x000 },
    { 0x00100000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x000000ef, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x0000001d, 0x00200e2d, 0x000 },
    { 0x00000003, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x0f1 },
    { 0x0000000b, 0x00210228, 0x000 },
    { 0x00000000, 0x14c00000, 0x0f1 },
    { 0x00000400, 0x00292228, 0x000 },
    { 0x0000001a, 0x00203628, 0x000 },
    { 0x0000001c, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x0f6 },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000001e, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x104 },
    { 0x0000a30f, 0x00204411, 0x000 },
    { 0x00000013, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x0fd },
    { 0xffffffff, 0x00404811, 0x104 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x100 },
    { 0x0000ffff, 0x00404811, 0x104 },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x103 },
    { 0x000000ff, 0x00404811, 0x104 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0002c400, 0x00204411, 0x000 },
    { 0x0000001f, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x10b },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000019, 0x00203623, 0x000 },
    { 0x00000018, 0x40224a20, 0x000 },
    { 0x00000010, 0xc0424a20, 0x10d },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000019, 0x00203623, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000000a, 0x00201011, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x114 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00531224, 0x110 },
    { 0xffbfffff, 0x00283a2e, 0x000 },
    { 0x0000001b, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x127 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0x00000018, 0x00220e30, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e00e, 0x00204411, 0x000 },
    { 0x07f8ff08, 0x00204811, 0x000 },
    { 0x00000000, 0x00294a23, 0x000 },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00800000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204806, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x614 },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x613 },
    { 0x00000004, 0x00404c11, 0x12e },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x2fe },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x19f },
    { 0x00000000, 0x00600000, 0x151 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40280620, 0x000 },
    { 0x00000010, 0xc0210a20, 0x000 },
    { 0x00000000, 0x00341461, 0x000 },
    { 0x00000000, 0x00741882, 0x2a4 },
    { 0x0001a1fd, 0x00604411, 0x2c9 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x138 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x2fe },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x19f },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x151 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0681a20, 0x2a4 },
    { 0x0001a1fd, 0x00604411, 0x2c9 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x149 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000001, 0x00300a2f, 0x000 },
    { 0x00000001, 0x00210a22, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600000, 0x17c },
    { 0x00000000, 0x00600000, 0x18d },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00202c08, 0x000 },
    { 0x00000000, 0x00202411, 0x000 },
    { 0x00000000, 0x00202811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000002, 0x00221e29, 0x000 },
    { 0x00000000, 0x007048eb, 0x189 },
    { 0x00000000, 0x00600000, 0x2a4 },
    { 0x00000001, 0x40330620, 0x000 },
    { 0x00000000, 0xc0302409, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x28c },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x173 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000001, 0x00530621, 0x16f },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0604800, 0x184 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000013, 0x0020062d, 0x000 },
    { 0x00000000, 0x0078042a, 0x2e4 },
    { 0x00000000, 0x00202809, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x165 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000210, 0x00600411, 0x2fe },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x181 },
    { 0x0000001b, 0xc0203620, 0x000 },
    { 0x0000001c, 0xc0203620, 0x000 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x46000000, 0x00600811, 0x19f },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x188 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00804811, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40281620, 0x000 },
    { 0x00000010, 0xc0811a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000008, 0x00221e30, 0x000 },
    { 0x00000032, 0x00201a2d, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfffbff09, 0x00204811, 0x000 },
    { 0x00000011, 0x0020222d, 0x000 },
    { 0x00001fff, 0x00294a28, 0x000 },
    { 0x00000006, 0x0020222d, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000100, 0x00201811, 0x000 },
    { 0x00000008, 0x00621e28, 0x128 },
    { 0x00000008, 0x00822228, 0x000 },
    { 0x0002c000, 0x00204411, 0x000 },
    { 0x0000001b, 0x00600e2d, 0x1aa },
    { 0x0000001c, 0x00600e2d, 0x1aa },
    { 0x0000c008, 0x00204411, 0x000 },
    { 0x0000001d, 0x00200e2d, 0x000 },
    { 0x00000000, 0x14c00000, 0x1a6 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x39000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00804802, 0x000 },
    { 0x00000020, 0x00202e2d, 0x000 },
    { 0x00000000, 0x003b0d63, 0x000 },
    { 0x00000008, 0x00224a23, 0x000 },
    { 0x00000010, 0x00224a23, 0x000 },
    { 0x00000018, 0x00224a23, 0x000 },
    { 0x00000000, 0x00804803, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x2fe },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x19f },
    { 0x00000007, 0x0021062f, 0x000 },
    { 0x00000019, 0x00200a2d, 0x000 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000ffff, 0x40282220, 0x000 },
    { 0x0000000f, 0x00262228, 0x000 },
    { 0x00000010, 0x40212620, 0x000 },
    { 0x0000000f, 0x00262629, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1cd },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000081, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000080, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1c9 },
    { 0x00000000, 0x00600000, 0x1d6 },
    { 0x00000001, 0x00531e27, 0x1c5 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000001f, 0x00280a22, 0x000 },
    { 0x0000001f, 0x00282a2a, 0x000 },
    { 0x00000001, 0x00530621, 0x1be },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000002, 0x00304a2f, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000001, 0x00301e2f, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x1d6 },
    { 0x00000001, 0x00531e27, 0x1d2 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x0000000f, 0x00260e23, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000000f, 0x00261224, 0x000 },
    { 0x00000000, 0x00201411, 0x000 },
    { 0x00000000, 0x00601811, 0x2a4 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022b, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1e5 },
    { 0x00000010, 0x00221628, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a29, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x0020480a, 0x000 },
    { 0x00000000, 0x00202c11, 0x000 },
    { 0x00000010, 0x00221623, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a24, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x00731503, 0x1f2 },
    { 0x00000000, 0x00201805, 0x000 },
    { 0x00000000, 0x00731524, 0x1f2 },
    { 0x00000000, 0x002d14c5, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00000000, 0x00202003, 0x000 },
    { 0x00000000, 0x00802404, 0x000 },
    { 0x0000000f, 0x00210225, 0x000 },
    { 0x00000000, 0x14c00000, 0x613 },
    { 0x00000000, 0x002b1405, 0x000 },
    { 0x00000001, 0x00901625, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x2fe },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x19f },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00294a22, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a21, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000ffff, 0x40281220, 0x000 },
    { 0x00000010, 0xc0211a20, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211620, 0x000 },
    { 0x00000000, 0x00741465, 0x2a4 },
    { 0x0001a1fd, 0x00604411, 0x2c9 },
    { 0x00000001, 0x00330621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0cc00000, 0x206 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x1ff },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x5c5 },
    { 0x00000000, 0x0040040f, 0x200 },
    { 0x00000000, 0x00600000, 0x5b2 },
    { 0x00000000, 0x00600000, 0x5c5 },
    { 0x00000210, 0x00600411, 0x2fe },
    { 0x00000000, 0x00600000, 0x18d },
    { 0x00000000, 0x00600000, 0x189 },
    { 0x00000000, 0x00600000, 0x2a4 },
    { 0x00000000, 0x00600000, 0x28c },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x21f },
    { 0x00000000, 0xc0404800, 0x21c },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x00600411, 0x2e4 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x5b2 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000018, 0x40210a20, 0x000 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x235 },
    { 0x0000001a, 0x0020222d, 0x000 },
    { 0x00080101, 0x00292228, 0x000 },
    { 0x0000001a, 0x00203628, 0x000 },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x23a },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000010, 0x00600411, 0x2fe },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x19f },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00000000, 0x00600000, 0x265 },
    { 0x0000001d, 0x00201e2d, 0x000 },
    { 0x00000001, 0x00211e27, 0x000 },
    { 0x00000000, 0x14e00000, 0x253 },
    { 0x00000018, 0x00201e2d, 0x000 },
    { 0x0000ffff, 0x00281e27, 0x000 },
    { 0x00000000, 0x00341c27, 0x000 },
    { 0x00000000, 0x12c00000, 0x248 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e5, 0x000 },
    { 0x00000000, 0x08c00000, 0x24b },
    { 0x00000000, 0x00201407, 0x000 },
    { 0x00000018, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00211e27, 0x000 },
    { 0x00000000, 0x00341c47, 0x000 },
    { 0x00000000, 0x12c00000, 0x250 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x08c00000, 0x253 },
    { 0x00000000, 0x00201807, 0x000 },
    { 0x00000000, 0x00600000, 0x2aa },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000000, 0x00342023, 0x000 },
    { 0x00000000, 0x12c00000, 0x25b },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x25a },
    { 0x00000016, 0x00404811, 0x25f },
    { 0x00000018, 0x00404811, 0x25f },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x25e },
    { 0x00000017, 0x00404811, 0x25f },
    { 0x00000019, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00604411, 0x2d2 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x23f },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000010, 0x40210620, 0x000 },
    { 0x0000ffff, 0xc0280a20, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0881a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x614 },
    { 0x00000000, 0x00600000, 0x5b2 },
    { 0x00000000, 0xc0600000, 0x28c },
    { 0x00000005, 0x00200a2d, 0x000 },
    { 0x00000008, 0x00220a22, 0x000 },
    { 0x00000034, 0x00201a2d, 0x000 },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00007000, 0x00281e27, 0x000 },
    { 0x00000000, 0x00311ce6, 0x000 },
    { 0x00000033, 0x00201a2d, 0x000 },
    { 0x0000000c, 0x00221a26, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x06e00000, 0x27b },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000034, 0x00203623, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00691ce2, 0x128 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x286 },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000024, 0x00403627, 0x000 },
    { 0x0000000c, 0xc0220a20, 0x000 },
    { 0x00000032, 0x00203622, 0x000 },
    { 0x00000031, 0xc0403620, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000009, 0x00204811, 0x000 },
    { 0xa1000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000029, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce3, 0x000 },
    { 0x00000029, 0x00203627, 0x000 },
    { 0x0000002a, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce4, 0x000 },
    { 0x0000002a, 0x00203627, 0x000 },
    { 0x0000002b, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a3, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x0000002b, 0x00203627, 0x000 },
    { 0x0000002c, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x0000002c, 0x00803627, 0x000 },
    { 0x00000029, 0x00203623, 0x000 },
    { 0x0000002a, 0x00203624, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x0000002b, 0x00203627, 0x000 },
    { 0x00000000, 0x00311cc4, 0x000 },
    { 0x0000002c, 0x00803627, 0x000 },
    { 0x00000022, 0x00203627, 0x000 },
    { 0x00000023, 0x00203628, 0x000 },
    { 0x0000001d, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14c00000, 0x2c5 },
    { 0x00000000, 0x00400000, 0x2c2 },
    { 0x00000022, 0x00203627, 0x000 },
    { 0x00000023, 0x00203628, 0x000 },
    { 0x0000001d, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2c2 },
    { 0x00000003, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2c5 },
    { 0x0000002b, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e1, 0x000 },
    { 0x00000000, 0x02c00000, 0x2c5 },
    { 0x00000029, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a1, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2c5 },
    { 0x0000002c, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e2, 0x000 },
    { 0x00000000, 0x02c00000, 0x2c5 },
    { 0x0000002a, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2c5 },
    { 0x00000000, 0x00600000, 0x5ed },
    { 0x00000000, 0x00600000, 0x29e },
    { 0x00000000, 0x00400000, 0x2c7 },
    { 0x00000000, 0x00600000, 0x29e },
    { 0x00000000, 0x00600000, 0x5e4 },
    { 0x00000000, 0x00400000, 0x2c7 },
    { 0x00000000, 0x00600000, 0x290 },
    { 0x00000000, 0x00400000, 0x2c7 },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000023, 0x0080222d, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca1, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x003808c5, 0x000 },
    { 0x00000000, 0x00300841, 0x000 },
    { 0x00000001, 0x00220a22, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x0000001d, 0x0020222d, 0x000 },
    { 0x00000000, 0x14c00000, 0x301 },
    { 0xffffffef, 0x00280621, 0x000 },
    { 0x0000001a, 0x0020222d, 0x000 },
    { 0x0000f8e0, 0x00204411, 0x000 },
    { 0x00000000, 0x00294901, 0x000 },
    { 0x00000000, 0x00894901, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00804811, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x97000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00002257, 0x00204411, 0x000 },
    { 0x00000003, 0xc0484a20, 0x000 },
    { 0x0000225d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x5c5 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x00000001, 0x40304a20, 0x000 },
    { 0x00000002, 0xc0304a20, 0x000 },
    { 0x00000001, 0x00530a22, 0x334 },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000017, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x614 },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x33d },
    { 0x00000014, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x351 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000016, 0x00604811, 0x35e },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x355 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00404811, 0x349 },
    { 0x00000028, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x349 },
    { 0x00002104, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x00000035, 0x00203626, 0x000 },
    { 0x00000049, 0x00201811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000000, 0x002f0226, 0x000 },
    { 0x00000000, 0x0cc00000, 0x360 },
    { 0x00000035, 0x00801a2d, 0x000 },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x00000015, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x376 },
    { 0x0000001e, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x380 },
    { 0x00000020, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x38c },
    { 0x0000000f, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x398 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x398 },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x39a },
    { 0x00000016, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x39f },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x08000000, 0x00290a22, 0x000 },
    { 0x00000003, 0x40210e20, 0x000 },
    { 0x0000000c, 0xc0211220, 0x000 },
    { 0x00080000, 0x00281224, 0x000 },
    { 0x00000014, 0xc0221620, 0x000 },
    { 0x00000000, 0x002914a4, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x002948a2, 0x000 },
    { 0x0000a1fe, 0x00204411, 0x000 },
    { 0x00000000, 0x00404803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000015, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x614 },
    { 0x00000015, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x382 },
    { 0x0000210e, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x614 },
    { 0x00000003, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x38e },
    { 0x00002108, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00404811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000006, 0x00404811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000016, 0x00604811, 0x35e },
    { 0x00000016, 0x00404811, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x0000001d, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x3b9 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000017, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x614 },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x3ab },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0xbabecafe, 0x00204811, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000004, 0x00404811, 0x000 },
    { 0x00002170, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000a, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3be },
    { 0x8c000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00003fff, 0x40280a20, 0x000 },
    { 0x80000000, 0x40280e20, 0x000 },
    { 0x40000000, 0xc0281220, 0x000 },
    { 0x00040000, 0x00694622, 0x614 },
    { 0x00000000, 0x00201410, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3cc },
    { 0x00000000, 0xc0401800, 0x3cf },
    { 0x00003fff, 0xc0281a20, 0x000 },
    { 0x00040000, 0x00694626, 0x614 },
    { 0x00000000, 0x00201810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3d2 },
    { 0x00000000, 0xc0401c00, 0x3d5 },
    { 0x00003fff, 0xc0281e20, 0x000 },
    { 0x00040000, 0x00694627, 0x614 },
    { 0x00000000, 0x00201c10, 0x000 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0x002820c5, 0x000 },
    { 0x00000000, 0x004948e8, 0x000 },
    { 0xa5800000, 0x00200811, 0x000 },
    { 0x00002000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x3fd },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x0000001f, 0xc0210220, 0x000 },
    { 0x00000000, 0x14c00000, 0x3e2 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000ffff, 0xc0481220, 0x3ea },
    { 0xa7800000, 0x00200811, 0x000 },
    { 0x0000a000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x3fd },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00304883, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x83000000, 0x00604411, 0x3fd },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xa9800000, 0x00200811, 0x000 },
    { 0x0000c000, 0x00400c11, 0x3e5 },
    { 0xab800000, 0x00200811, 0x000 },
    { 0x0000f8e0, 0x00400c11, 0x3e5 },
    { 0xad800000, 0x00200811, 0x000 },
    { 0x0000f880, 0x00400c11, 0x3e5 },
    { 0xb3800000, 0x00200811, 0x000 },
    { 0x0000f3fc, 0x00400c11, 0x3e5 },
    { 0xaf800000, 0x00200811, 0x000 },
    { 0x0000e000, 0x00400c11, 0x3e5 },
    { 0xb1800000, 0x00200811, 0x000 },
    { 0x0000f000, 0x00400c11, 0x3e5 },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00002148, 0x00204811, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00182000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0018a000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0018c000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0018f8e0, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0018f880, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0018e000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0018f000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0018f3fc, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x86000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x85000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x614 },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00404c02, 0x42e },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x00000000, 0xc0201400, 0x000 },
    { 0x00000000, 0xc0201800, 0x000 },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x43c },
    { 0x00000000, 0xc0202000, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x00000010, 0x00280a23, 0x000 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x444 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0x00694624, 0x614 },
    { 0x00000000, 0x00400000, 0x44d },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00000000, 0x1ac00000, 0x449 },
    { 0x9e000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x44c },
    { 0x00000000, 0x002824f0, 0x000 },
    { 0x00000007, 0x00280a23, 0x000 },
    { 0x00000001, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x454 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x04e00000, 0x46d },
    { 0x00000000, 0x00400000, 0x47a },
    { 0x00000002, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x459 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x02e00000, 0x46d },
    { 0x00000000, 0x00400000, 0x47a },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x45e },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ce00000, 0x46d },
    { 0x00000000, 0x00400000, 0x47a },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x463 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ae00000, 0x46d },
    { 0x00000000, 0x00400000, 0x47a },
    { 0x00000005, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x468 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x06e00000, 0x46d },
    { 0x00000000, 0x00400000, 0x47a },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x46d },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x08e00000, 0x46d },
    { 0x00000000, 0x00400000, 0x47a },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x000 },
    { 0x00000008, 0x00210a23, 0x000 },
    { 0x00000000, 0x14c00000, 0x477 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x480 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x00404c08, 0x43c },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000011, 0x40211220, 0x000 },
    { 0x00000012, 0x40211620, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00210225, 0x000 },
    { 0x00000000, 0x14e00000, 0x48a },
    { 0x00040000, 0xc0494a20, 0x48b },
    { 0xfffbffff, 0xc0284a20, 0x000 },
    { 0x00000000, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x497 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000c, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x493 },
    { 0xa0000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000004, 0x00204811, 0x000 },
    { 0x0000216b, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000216c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00400000, 0x491 },
    { 0x00000000, 0xc0210a20, 0x000 },
    { 0x00000000, 0x14c00000, 0x4ae },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1ac00000, 0x4a9 },
    { 0x9e000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x4ac },
    { 0x00000000, 0x00400000, 0x4b2 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0xc0294620, 0x000 },
    { 0x00000000, 0xc0600000, 0x614 },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x4b9 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0404810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x614 },
    { 0x00000000, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x4bb },
    { 0x00002180, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000003, 0x00333e2f, 0x000 },
    { 0x00000001, 0x00210221, 0x000 },
    { 0x00000000, 0x14e00000, 0x4eb },
    { 0x00000035, 0x00200a2d, 0x000 },
    { 0x00040000, 0x18e00c11, 0x4da },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xd8c04800, 0x4ce },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000036, 0x0020122d, 0x000 },
    { 0x00000000, 0x00290c83, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000011, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00400000, 0x491 },
    { 0x00000035, 0xc0203620, 0x000 },
    { 0x00000036, 0xc0403620, 0x000 },
    { 0x0000304a, 0x00204411, 0x000 },
    { 0xe0000000, 0xc0484a20, 0x000 },
    { 0x0000000f, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x4f2 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0xd9000000, 0x000 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000002, 0x00204811, 0x000 },
    { 0x000000ff, 0x00280e30, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x4f6 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x14c00000, 0x50b },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000024, 0x00203623, 0x000 },
    { 0x00000034, 0x00203623, 0x000 },
    { 0x00000032, 0x00203623, 0x000 },
    { 0x00000031, 0x00203623, 0x000 },
    { 0x0000001d, 0x00203623, 0x000 },
    { 0x0000002d, 0x00203623, 0x000 },
    { 0x0000002e, 0x00203623, 0x000 },
    { 0x0000001b, 0x00203623, 0x000 },
    { 0x0000001c, 0x00203623, 0x000 },
    { 0xffffe000, 0x00200c11, 0x000 },
    { 0x00000029, 0x00203623, 0x000 },
    { 0x0000002a, 0x00203623, 0x000 },
    { 0x00001fff, 0x00200c11, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x0000002c, 0x00203623, 0x000 },
    { 0xf1ffffff, 0x00283a2e, 0x000 },
    { 0x0000001a, 0xc0220e20, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000033, 0x40203620, 0x000 },
    { 0x87000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x9d000000, 0x00204411, 0x000 },
    { 0x0000001f, 0x40214a20, 0x000 },
    { 0x96000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x0000001f, 0x00211624, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000003, 0x00281e23, 0x000 },
    { 0x00000008, 0x00222223, 0x000 },
    { 0xfffff000, 0x00282228, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x00000027, 0x00203628, 0x000 },
    { 0x00000018, 0x00211e23, 0x000 },
    { 0x00000028, 0x00203627, 0x000 },
    { 0x00000002, 0x00221624, 0x000 },
    { 0x00000000, 0x003014a8, 0x000 },
    { 0x00000026, 0x00203625, 0x000 },
    { 0x00000003, 0x00211a24, 0x000 },
    { 0x10000000, 0x00281a26, 0x000 },
    { 0xefffffff, 0x00283a2e, 0x000 },
    { 0x00000000, 0x004938ce, 0x602 },
    { 0x00000001, 0x40280a20, 0x000 },
    { 0x00000006, 0x40280e20, 0x000 },
    { 0x00000300, 0xc0281220, 0x000 },
    { 0x00000008, 0x00211224, 0x000 },
    { 0x00000000, 0xc0201620, 0x000 },
    { 0x00000000, 0xc0201a20, 0x000 },
    { 0x00000000, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x541 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x614 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00020000, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x549 },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x55b },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x549 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x614 },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x55b },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x54d },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00000000, 0xc0400000, 0x55b },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x559 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1ac00000, 0x554 },
    { 0x9e000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x557 },
    { 0x00000000, 0x00401c10, 0x55b },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x0ee00000, 0x55d },
    { 0x00000000, 0x00600000, 0x5a4 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56d },
    { 0x0000a2b7, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2b6, 0x00604411, 0x614 },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x0000a2c4, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x56b },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000001, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x57d },
    { 0x0000a2bb, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2ba, 0x00604411, 0x614 },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x0000a2c5, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x57b },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000002, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x58d },
    { 0x0000a2bf, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2be, 0x00604411, 0x614 },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x0000a2c6, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x58b },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x0000a2c3, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2c2, 0x00604411, 0x614 },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x0000a2c7, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x599 },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x85000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x0000304a, 0x00204411, 0x000 },
    { 0x01000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00400000, 0x59f },
    { 0xa4000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0xc0600000, 0x5a4 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x88000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0xff000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000002, 0x00804811, 0x000 },
    { 0x00000000, 0x0ee00000, 0x5b7 },
    { 0x00001000, 0x00200811, 0x000 },
    { 0x00000034, 0x00203622, 0x000 },
    { 0x00000000, 0x00600000, 0x5bb },
    { 0x00000000, 0x00600000, 0x5a4 },
    { 0x98000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00804811, 0x000 },
    { 0x00000000, 0xc0600000, 0x5bb },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000022, 0x00204811, 0x000 },
    { 0x89000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0xff000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000002, 0x00804811, 0x000 },
    { 0x0000217a, 0xc0204411, 0x000 },
    { 0x00000000, 0x00404811, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0xff000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000002, 0x00804811, 0x000 },
    { 0x00000000, 0x00600000, 0x5e1 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0xc0204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000016, 0x00604811, 0x35e },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x09800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x614 },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000004, 0x00404c11, 0x5dc },
    { 0x0000001d, 0x00201e2d, 0x000 },
    { 0x00000004, 0x00291e27, 0x000 },
    { 0x0000001d, 0x00803627, 0x000 },
    { 0x0000001d, 0x00201e2d, 0x000 },
    { 0xfffffffb, 0x00281e27, 0x000 },
    { 0x0000001d, 0x00803627, 0x000 },
    { 0x0000001d, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00291e27, 0x000 },
    { 0x0000001d, 0x00803627, 0x000 },
    { 0x0000001d, 0x00201e2d, 0x000 },
    { 0xfffffff7, 0x00281e27, 0x000 },
    { 0x0000001d, 0x00803627, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000016, 0x00604811, 0x35e },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x01800000, 0x00204811, 0x000 },
    { 0x00ffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004217f, 0x00604411, 0x614 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x613 },
    { 0x00000010, 0x00404c11, 0x5f9 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x38c00000, 0x000 },
    { 0x00000025, 0x00200a2d, 0x000 },
    { 0x00000026, 0x00200e2d, 0x000 },
    { 0x00000027, 0x0020122d, 0x000 },
    { 0x00000028, 0x0020162d, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000004, 0x00301224, 0x000 },
    { 0x00000000, 0x002f0064, 0x000 },
    { 0x00000000, 0x0cc00000, 0x612 },
    { 0x00000003, 0x00281a22, 0x000 },
    { 0x00000008, 0x00221222, 0x000 },
    { 0xfffff000, 0x00281224, 0x000 },
    { 0x00000000, 0x002910c4, 0x000 },
    { 0x00000027, 0x00403624, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x614 },
    { 0x9f000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x617 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x2fe },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x19f },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0xc0204411, 0x000 },
    { 0x00000029, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x0000002c, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000002a, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000002b, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00404811, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x013304ef, 0x059b0239, 0x000 },
    { 0x01b00159, 0x0425059b, 0x000 },
    { 0x021201f6, 0x02390142, 0x000 },
    { 0x0210022e, 0x0289022a, 0x000 },
    { 0x03c2059b, 0x059b059b, 0x000 },
    { 0x05cd05ce, 0x0308059b, 0x000 },
    { 0x059b05a0, 0x03090329, 0x000 },
    { 0x0313026b, 0x032b031d, 0x000 },
    { 0x059b059b, 0x059b059b, 0x000 },
    { 0x059b052c, 0x059b059b, 0x000 },
    { 0x03a5059b, 0x04a2032d, 0x000 },
    { 0x04810433, 0x0423059b, 0x000 },
    { 0x04bb04ed, 0x042704c8, 0x000 },
    { 0x043304f4, 0x033a0365, 0x000 },
    { 0x059b059b, 0x059b059b, 0x000 },
    { 0x059b059b, 0x059b059b, 0x000 },
    { 0x059b059b, 0x05b905a2, 0x000 },
    { 0x059b059b, 0x0007059b, 0x000 },
    { 0x059b059b, 0x059b059b, 0x000 },
    { 0x059b059b, 0x059b059b, 0x000 },
    { 0x03e303d8, 0x03f303f1, 0x000 },
    { 0x03f903f5, 0x03f703fb, 0x000 },
    { 0x04070403, 0x040f040b, 0x000 },
    { 0x04170413, 0x041f041b, 0x000 },
    { 0x059b059b, 0x059b059b, 0x000 },
    { 0x059b059b, 0x059b059b, 0x000 },
    { 0x059b059b, 0x059b059b, 0x000 },
    { 0x00020600, 0x06190006, 0x000 },
};

static const u32 R600_pfp_microcode[]={
0xd40071,
0xd40072,
0xca0400,
0xa00000,
0x7e828b,
0x800003,
0xca0400,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xc41838,
0xca2400,
0xca2800,
0x9581a8,
0xc41c3a,
0xc3c000,
0xca0800,
0xca0c00,
0x7c744b,
0xc20005,
0x99c000,
0xc41c3a,
0x7c744c,
0xc0fff0,
0x042c04,
0x309002,
0x7d2500,
0x351402,
0x7d350b,
0x255403,
0x7cd580,
0x259c03,
0x95c004,
0xd5001b,
0x7eddc1,
0x7d9d80,
0xd6801b,
0xd5801b,
0xd4401e,
0xd5401e,
0xd6401e,
0xd6801e,
0xd4801e,
0xd4c01e,
0x9783d4,
0xd5c01e,
0xca0800,
0x80001b,
0xca0c00,
0xe4011e,
0xd4001e,
0x80000d,
0xc41838,
0xe4013e,
0xd4001e,
0x80000d,
0xc41838,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca1800,
0xd4401e,
0xd5801e,
0x800054,
0xd40073,
0xd4401e,
0xca0800,
0xca0c00,
0xca1000,
0xd48019,
0xd4c018,
0xd50017,
0xd4801e,
0xd4c01e,
0xd5001e,
0xe2001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0xd48060,
0xd4401e,
0x800002,
0xd4801e,
0xca0800,
0xd48061,
0xd4401e,
0x800002,
0xd4801e,
0xca0800,
0xca0c00,
0xd4401e,
0xd48016,
0xd4c016,
0xd4801e,
0x8001b9,
0xd4c01e,
0xc6083e,
0xca0c00,
0xca1000,
0x948004,
0xca1400,
0xe420f3,
0xd42013,
0xd56065,
0xd4e01c,
0xd5201c,
0xd5601c,
0x800002,
0x062001,
0xc6083e,
0xca0c00,
0xca1000,
0x9483f7,
0xca1400,
0xe420f3,
0x80007a,
0xd42013,
0xc6083e,
0xca0c00,
0xca1000,
0x9883ef,
0xca1400,
0xd40064,
0x80008e,
0x000000,
0xc41432,
0xc6183e,
0xc4082f,
0x954005,
0xc40c30,
0xd4401e,
0x800002,
0xee001e,
0x9583f5,
0xc41031,
0xd44033,
0xd52065,
0xd4a01c,
0xd4e01c,
0xd5201c,
0xd40073,
0xe4015e,
0xd4001e,
0x8001b9,
0x062001,
0x0a2001,
0xd60074,
0xc40836,
0xc61040,
0x988007,
0xcc3835,
0x95010f,
0xd4001f,
0xd46062,
0x800002,
0xd42062,
0xcc1433,
0x8401bc,
0xd40070,
0xd5401e,
0x800002,
0xee001e,
0xca0c00,
0xca1000,
0xd4c01a,
0x8401bc,
0xd5001a,
0xcc0443,
0x35101f,
0x2c9401,
0x7d098b,
0x984005,
0x7d15cb,
0xd4001a,
0x8001b9,
0xd4006d,
0x344401,
0xcc0c44,
0x98403a,
0xcc2c46,
0x958004,
0xcc0445,
0x8001b9,
0xd4001a,
0xd4c01a,
0x282801,
0x8400f3,
0xcc1003,
0x98801b,
0x04380c,
0x8400f3,
0xcc1003,
0x988017,
0x043808,
0x8400f3,
0xcc1003,
0x988013,
0x043804,
0x8400f3,
0xcc1003,
0x988014,
0xcc1047,
0x9a8009,
0xcc1448,
0x9840da,
0xd4006d,
0xcc1844,
0xd5001a,
0xd5401a,
0x8000cc,
0xd5801a,
0x96c0d3,
0xd4006d,
0x8001b9,
0xd4006e,
0x9ac003,
0xd4006d,
0xd4006e,
0x800002,
0xec007f,
0x9ac0ca,
0xd4006d,
0x8001b9,
0xd4006e,
0xcc1403,
0xcc1803,
0xcc1c03,
0x7d9103,
0x7dd583,
0x7d190c,
0x35cc1f,
0x35701f,
0x7cf0cb,
0x7cd08b,
0x880000,
0x7e8e8b,
0x95c004,
0xd4006e,
0x8001b9,
0xd4001a,
0xd4c01a,
0xcc0803,
0xcc0c03,
0xcc1003,
0xcc1403,
0xcc1803,
0xcc1c03,
0xcc2403,
0xcc2803,
0x35c41f,
0x36b01f,
0x7c704b,
0x34f01f,
0x7c704b,
0x35701f,
0x7c704b,
0x7d8881,
0x7dccc1,
0x7e5101,
0x7e9541,
0x7c9082,
0x7cd4c2,
0x7c848b,
0x9ac003,
0x7c8c8b,
0x2c8801,
0x98809c,
0xd4006d,
0x98409a,
0xd4006e,
0xcc0847,
0xcc0c48,
0xcc1044,
0xd4801a,
0xd4c01a,
0x800104,
0xd5001a,
0xcc0832,
0xd40032,
0x9482d8,
0xca0c00,
0xd4401e,
0x800002,
0xd4001e,
0xe4011e,
0xd4001e,
0xca0800,
0xca0c00,
0xca1000,
0xd4401e,
0xca1400,
0xd4801e,
0xd4c01e,
0xd5001e,
0xd5401e,
0xd54034,
0x800002,
0xee001e,
0x280404,
0xe2001a,
0xe2001a,
0xd4401a,
0xca3800,
0xcc0803,
0xcc0c03,
0xcc0c03,
0xcc0c03,
0x9882bc,
0x000000,
0x8401bc,
0xd7806f,
0x800002,
0xee001f,
0xca0400,
0xc2ff00,
0xcc0834,
0xc13fff,
0x7c74cb,
0x7cc90b,
0x7d010f,
0x9902af,
0x7c738b,
0x8401bc,
0xd7806f,
0x800002,
0xee001f,
0xca0800,
0x281900,
0x7d898b,
0x958014,
0x281404,
0xca0c00,
0xca1000,
0xca1c00,
0xca2400,
0xe2001f,
0xd4c01a,
0xd5001a,
0xd5401a,
0xcc1803,
0xcc2c03,
0xcc2c03,
0xcc2c03,
0x7da58b,
0x7d9c47,
0x984296,
0x000000,
0x800164,
0xd4c01a,
0xd4401e,
0xd4801e,
0x800002,
0xee001e,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0x248c06,
0x0ccc06,
0x98c006,
0xcc1049,
0x990004,
0xd40071,
0xe4011e,
0xd4001e,
0xd4401e,
0xd4801e,
0x800002,
0xee001e,
0xca0800,
0xca0c00,
0x34d018,
0x251001,
0x95001f,
0xc17fff,
0xca1000,
0xca1400,
0xca1800,
0xd4801d,
0xd4c01d,
0x7db18b,
0xc14202,
0xc2c001,
0xd5801d,
0x34dc0e,
0x7d5d4c,
0x7f734c,
0xd7401e,
0xd5001e,
0xd5401e,
0xc14200,
0xc2c000,
0x099c01,
0x31dc10,
0x7f5f4c,
0x7f734c,
0x7d8380,
0xd5806f,
0xd58066,
0xd7401e,
0xec005e,
0xc82402,
0x8001b9,
0xd60074,
0xd4401e,
0xd4801e,
0xd4c01e,
0x800002,
0xee001e,
0x800002,
0xee001f,
0xd4001f,
0x800002,
0xd4001f,
0xd4001f,
0x880000,
0xd4001f,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x010174,
0x02017b,
0x030090,
0x040080,
0x050005,
0x060040,
0x070033,
0x08012f,
0x090047,
0x0a0037,
0x1001b7,
0x1700a4,
0x22013d,
0x23014c,
0x2000b5,
0x240128,
0x27004e,
0x28006b,
0x2a0061,
0x2b0053,
0x2f0066,
0x320088,
0x340182,
0x3c0159,
0x3f0073,
0x41018f,
0x440131,
0x550176,
0x56017d,
0x60000c,
0x610035,
0x620039,
0x630039,
0x640039,
0x650039,
0x660039,
0x670039,
0x68003b,
0x690042,
0x6a0049,
0x6b0049,
0x6c0049,
0x6d0049,
0x6e0049,
0x6f0049,
0x7301b7,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
0x000007,
};

static const u32 RV610_cp_microcode[][3]={
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0000ffff, 0x00284621, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000000, 0x00e00000, 0x000 },
    { 0x00010000, 0xc0294620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x00000000, 0x00600000, 0x631 },
    { 0x00000000, 0x00600000, 0x645 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000f00, 0x00281622, 0x000 },
    { 0x00000008, 0x00211625, 0x000 },
    { 0x00000018, 0x00203625, 0x000 },
    { 0x8d000000, 0x00204411, 0x000 },
    { 0x00000004, 0x002f0225, 0x000 },
    { 0x00000000, 0x0ce00000, 0x018 },
    { 0x00412000, 0x00404811, 0x019 },
    { 0x00422000, 0x00204811, 0x000 },
    { 0x8e000000, 0x00204411, 0x000 },
    { 0x00000028, 0x00204a2d, 0x000 },
    { 0x90000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x0000000c, 0x00211622, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000019, 0x00211a22, 0x000 },
    { 0x00000004, 0x00281a26, 0x000 },
    { 0x00000000, 0x002914c5, 0x000 },
    { 0x00000019, 0x00203625, 0x000 },
    { 0x00000000, 0x003a1402, 0x000 },
    { 0x00000016, 0x00211625, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0xfffffffc, 0x00280e23, 0x000 },
    { 0x00000000, 0x002914a3, 0x000 },
    { 0x00000017, 0x00203625, 0x000 },
    { 0x00008000, 0x00280e22, 0x000 },
    { 0x00000007, 0x00220e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x20000000, 0x00280e22, 0x000 },
    { 0x00000006, 0x00210e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x00000000, 0x00220222, 0x000 },
    { 0x00000000, 0x14e00000, 0x038 },
    { 0x00000000, 0x2ee00000, 0x035 },
    { 0x00000000, 0x2ce00000, 0x037 },
    { 0x00000000, 0x00400e2d, 0x039 },
    { 0x00000008, 0x00200e2d, 0x000 },
    { 0x00000009, 0x0040122d, 0x046 },
    { 0x00000001, 0x00400e2d, 0x039 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x03e },
    { 0x00000008, 0x00401c11, 0x041 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x0000000f, 0x00281e27, 0x000 },
    { 0x00000003, 0x00221e27, 0x000 },
    { 0x7fc00000, 0x00281a23, 0x000 },
    { 0x00000014, 0x00211a26, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000008, 0x00221a26, 0x000 },
    { 0x00000000, 0x00290cc7, 0x000 },
    { 0x00000027, 0x00203624, 0x000 },
    { 0x00007f00, 0x00281221, 0x000 },
    { 0x00001400, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x04b },
    { 0x00000001, 0x00290e23, 0x000 },
    { 0x0000000e, 0x00203623, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfff80000, 0x00294a23, 0x000 },
    { 0x00000000, 0x003a2c02, 0x000 },
    { 0x00000002, 0x00220e2b, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x0000000f, 0x00203623, 0x000 },
    { 0x00001fff, 0x00294a23, 0x000 },
    { 0x00000027, 0x00204a2d, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000029, 0x00200e2d, 0x000 },
    { 0x060a0200, 0x00294a23, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14e00000, 0x061 },
    { 0x00000000, 0x2ee00000, 0x05f },
    { 0x00000000, 0x2ce00000, 0x05e },
    { 0x00000000, 0x00400e2d, 0x062 },
    { 0x00000001, 0x00400e2d, 0x062 },
    { 0x0000000a, 0x00200e2d, 0x000 },
    { 0x0000000b, 0x0040122d, 0x06a },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x7fc00000, 0x00281623, 0x000 },
    { 0x00000014, 0x00211625, 0x000 },
    { 0x00000001, 0x00331625, 0x000 },
    { 0x80000000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00290ca3, 0x000 },
    { 0x3ffffc00, 0x00290e23, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x06d },
    { 0x00000100, 0x00401c11, 0x070 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x000000f0, 0x00281e27, 0x000 },
    { 0x00000004, 0x00221e27, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0xfffff0ff, 0x00281a30, 0x000 },
    { 0x0000a028, 0x00204411, 0x000 },
    { 0x00000000, 0x002948e6, 0x000 },
    { 0x0000a018, 0x00204411, 0x000 },
    { 0x3fffffff, 0x00284a23, 0x000 },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000030, 0x0020162d, 0x000 },
    { 0x00000002, 0x00291625, 0x000 },
    { 0x00000030, 0x00203625, 0x000 },
    { 0x00000025, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a3, 0x000 },
    { 0x00000000, 0x0cc00000, 0x083 },
    { 0x00000026, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a4, 0x000 },
    { 0x00000000, 0x0cc00000, 0x084 },
    { 0x00000000, 0x00400000, 0x08a },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203624, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x08a },
    { 0x00000000, 0x00600000, 0x668 },
    { 0x00000000, 0x00600000, 0x65c },
    { 0x00000002, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x08d },
    { 0x00000012, 0xc0403620, 0x093 },
    { 0x00000000, 0x2ee00000, 0x091 },
    { 0x00000000, 0x2ce00000, 0x090 },
    { 0x00000002, 0x00400e2d, 0x092 },
    { 0x00000003, 0x00400e2d, 0x092 },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000012, 0x00203623, 0x000 },
    { 0x00000003, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x098 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x0a0 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x2ee00000, 0x09e },
    { 0x00000000, 0x2ce00000, 0x09d },
    { 0x00000002, 0x00400e2d, 0x09f },
    { 0x00000003, 0x00400e2d, 0x09f },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x003f0000, 0x00280e23, 0x000 },
    { 0x00000010, 0x00210e23, 0x000 },
    { 0x00000011, 0x00203623, 0x000 },
    { 0x0000001e, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0a7 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x0000001f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0aa },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000008, 0x00210e2b, 0x000 },
    { 0x0000007f, 0x00280e23, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0e1 },
    { 0x00000000, 0x27000000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ae00000, 0x0b3 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000000c, 0x00221e30, 0x000 },
    { 0x99800000, 0x00204411, 0x000 },
    { 0x00000004, 0x0020122d, 0x000 },
    { 0x00000008, 0x00221224, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00291ce4, 0x000 },
    { 0x00000000, 0x00604807, 0x12f },
    { 0x9b000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x9c000000, 0x00204411, 0x000 },
    { 0x00000000, 0x0033146f, 0x000 },
    { 0x00000001, 0x00333e23, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0x00203c05, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e007, 0x00204411, 0x000 },
    { 0x0000000f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0cb },
    { 0x00f8ff08, 0x00204811, 0x000 },
    { 0x98000000, 0x00404811, 0x0dc },
    { 0x000000f0, 0x00280e22, 0x000 },
    { 0x000000a0, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x0da },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d5 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d4 },
    { 0x00003f00, 0x00400c11, 0x0d6 },
    { 0x00001f00, 0x00400c11, 0x0d6 },
    { 0x00000f00, 0x00200c11, 0x000 },
    { 0x00380009, 0x00294a23, 0x000 },
    { 0x3f000000, 0x00280e2b, 0x000 },
    { 0x00000002, 0x00220e23, 0x000 },
    { 0x00000007, 0x00494a23, 0x0dc },
    { 0x00380f09, 0x00204811, 0x000 },
    { 0x68000007, 0x00204811, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000a202, 0x00204411, 0x000 },
    { 0x00ff0000, 0x00280e22, 0x000 },
    { 0x00000080, 0x00294a23, 0x000 },
    { 0x00000027, 0x00200e2d, 0x000 },
    { 0x00000026, 0x0020122d, 0x000 },
    { 0x00000000, 0x002f0083, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0ea },
    { 0x00000000, 0x00600000, 0x662 },
    { 0x00000000, 0x00400000, 0x0eb },
    { 0x00000000, 0x00600000, 0x665 },
    { 0x00000007, 0x0020222d, 0x000 },
    { 0x00000005, 0x00220e22, 0x000 },
    { 0x00100000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x000000ef, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000003, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x0f8 },
    { 0x0000000b, 0x00210228, 0x000 },
    { 0x00000000, 0x14c00000, 0x0f8 },
    { 0x00000400, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000001c, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x0fd },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000001e, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x10b },
    { 0x0000a30f, 0x00204411, 0x000 },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x104 },
    { 0xffffffff, 0x00404811, 0x10b },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x107 },
    { 0x0000ffff, 0x00404811, 0x10b },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x10a },
    { 0x000000ff, 0x00404811, 0x10b },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0002c400, 0x00204411, 0x000 },
    { 0x0000001f, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x112 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000018, 0x40224a20, 0x000 },
    { 0x00000010, 0xc0424a20, 0x114 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000000a, 0x00201011, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x11b },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00531224, 0x117 },
    { 0xffbfffff, 0x00283a2e, 0x000 },
    { 0x0000001b, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x12e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0x00000018, 0x00220e30, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e00e, 0x00204411, 0x000 },
    { 0x07f8ff08, 0x00204811, 0x000 },
    { 0x00000000, 0x00294a23, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00800000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204806, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68d },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x68c },
    { 0x00000004, 0x00404c11, 0x135 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000001c, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x13c },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40280620, 0x000 },
    { 0x00000010, 0xc0210a20, 0x000 },
    { 0x00000000, 0x00341461, 0x000 },
    { 0x00000000, 0x00741882, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x147 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0681a20, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x158 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000001, 0x00300a2f, 0x000 },
    { 0x00000001, 0x00210a22, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600000, 0x18f },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00202c08, 0x000 },
    { 0x00000000, 0x00202411, 0x000 },
    { 0x00000000, 0x00202811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000002, 0x00221e29, 0x000 },
    { 0x00000000, 0x007048eb, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000001, 0x40330620, 0x000 },
    { 0x00000000, 0xc0302409, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ae00000, 0x181 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x186 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x186 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000001, 0x00530621, 0x182 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0604800, 0x197 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000011, 0x0020062d, 0x000 },
    { 0x00000000, 0x0078042a, 0x2fb },
    { 0x00000000, 0x00202809, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x174 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x194 },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x46000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x19b },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00804811, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40281620, 0x000 },
    { 0x00000010, 0xc0811a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000008, 0x00221e30, 0x000 },
    { 0x00000029, 0x00201a2d, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfffbff09, 0x00204811, 0x000 },
    { 0x0000000f, 0x0020222d, 0x000 },
    { 0x00001fff, 0x00294a28, 0x000 },
    { 0x00000006, 0x0020222d, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000100, 0x00201811, 0x000 },
    { 0x00000008, 0x00621e28, 0x12f },
    { 0x00000008, 0x00822228, 0x000 },
    { 0x0002c000, 0x00204411, 0x000 },
    { 0x00000015, 0x00600e2d, 0x1bd },
    { 0x00000016, 0x00600e2d, 0x1bd },
    { 0x0000c008, 0x00204411, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000000, 0x14c00000, 0x1b9 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x39000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00804802, 0x000 },
    { 0x00000018, 0x00202e2d, 0x000 },
    { 0x00000000, 0x003b0d63, 0x000 },
    { 0x00000008, 0x00224a23, 0x000 },
    { 0x00000010, 0x00224a23, 0x000 },
    { 0x00000018, 0x00224a23, 0x000 },
    { 0x00000000, 0x00804803, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000007, 0x0021062f, 0x000 },
    { 0x00000013, 0x00200a2d, 0x000 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000ffff, 0x40282220, 0x000 },
    { 0x0000000f, 0x00262228, 0x000 },
    { 0x00000010, 0x40212620, 0x000 },
    { 0x0000000f, 0x00262629, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1e0 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000081, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000080, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1dc },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1d8 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000001f, 0x00280a22, 0x000 },
    { 0x0000001f, 0x00282a2a, 0x000 },
    { 0x00000001, 0x00530621, 0x1d1 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000002, 0x00304a2f, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000001, 0x00301e2f, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1e5 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x0000000f, 0x00260e23, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000000f, 0x00261224, 0x000 },
    { 0x00000000, 0x00201411, 0x000 },
    { 0x00000000, 0x00601811, 0x2bb },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022b, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1f8 },
    { 0x00000010, 0x00221628, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a29, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x0020480a, 0x000 },
    { 0x00000000, 0x00202c11, 0x000 },
    { 0x00000010, 0x00221623, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a24, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x00731503, 0x205 },
    { 0x00000000, 0x00201805, 0x000 },
    { 0x00000000, 0x00731524, 0x205 },
    { 0x00000000, 0x002d14c5, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00000000, 0x00202003, 0x000 },
    { 0x00000000, 0x00802404, 0x000 },
    { 0x0000000f, 0x00210225, 0x000 },
    { 0x00000000, 0x14c00000, 0x68c },
    { 0x00000000, 0x002b1405, 0x000 },
    { 0x00000001, 0x00901625, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00294a22, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a21, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000ffff, 0x40281220, 0x000 },
    { 0x00000010, 0xc0211a20, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211620, 0x000 },
    { 0x00000000, 0x00741465, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00000001, 0x00330621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0cc00000, 0x219 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x212 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x645 },
    { 0x00000000, 0x0040040f, 0x213 },
    { 0x00000000, 0x00600000, 0x631 },
    { 0x00000000, 0x00600000, 0x645 },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00000000, 0x00600000, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ae00000, 0x232 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x236 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x236 },
    { 0x00000000, 0xc0404800, 0x233 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x00600411, 0x2fb },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x631 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000018, 0x40210a20, 0x000 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x24c },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x00080101, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x251 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000010, 0x00600411, 0x315 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00000000, 0x00600000, 0x27c },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000001, 0x00211e27, 0x000 },
    { 0x00000000, 0x14e00000, 0x26a },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x0000ffff, 0x00281e27, 0x000 },
    { 0x00000000, 0x00341c27, 0x000 },
    { 0x00000000, 0x12c00000, 0x25f },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e5, 0x000 },
    { 0x00000000, 0x08c00000, 0x262 },
    { 0x00000000, 0x00201407, 0x000 },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00211e27, 0x000 },
    { 0x00000000, 0x00341c47, 0x000 },
    { 0x00000000, 0x12c00000, 0x267 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x08c00000, 0x26a },
    { 0x00000000, 0x00201807, 0x000 },
    { 0x00000000, 0x00600000, 0x2c1 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000000, 0x00342023, 0x000 },
    { 0x00000000, 0x12c00000, 0x272 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x271 },
    { 0x00000016, 0x00404811, 0x276 },
    { 0x00000018, 0x00404811, 0x276 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x275 },
    { 0x00000017, 0x00404811, 0x276 },
    { 0x00000019, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00604411, 0x2e9 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x256 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000010, 0x40210620, 0x000 },
    { 0x0000ffff, 0xc0280a20, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0881a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x00000000, 0x00600000, 0x631 },
    { 0x00000000, 0xc0600000, 0x2a3 },
    { 0x00000005, 0x00200a2d, 0x000 },
    { 0x00000008, 0x00220a22, 0x000 },
    { 0x0000002b, 0x00201a2d, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00007000, 0x00281e27, 0x000 },
    { 0x00000000, 0x00311ce6, 0x000 },
    { 0x0000002a, 0x00201a2d, 0x000 },
    { 0x0000000c, 0x00221a26, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x06e00000, 0x292 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00691ce2, 0x12f },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x29d },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000001c, 0x00403627, 0x000 },
    { 0x0000000c, 0xc0220a20, 0x000 },
    { 0x00000029, 0x00203622, 0x000 },
    { 0x00000028, 0xc0403620, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000009, 0x00204811, 0x000 },
    { 0xa1000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce3, 0x000 },
    { 0x00000021, 0x00203627, 0x000 },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce4, 0x000 },
    { 0x00000022, 0x00203627, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a3, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203624, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000000, 0x00311cc4, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14c00000, 0x2dc },
    { 0x00000000, 0x00400000, 0x2d9 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2d9 },
    { 0x00000003, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2dc },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e1, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a1, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e2, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000000, 0x00600000, 0x668 },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00600000, 0x65f },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2a7 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x0000001a, 0x00201e2d, 0x000 },
    { 0x0000001b, 0x0080222d, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca1, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x003808c5, 0x000 },
    { 0x00000000, 0x00300841, 0x000 },
    { 0x00000001, 0x00220a22, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000017, 0x0020222d, 0x000 },
    { 0x00000000, 0x14c00000, 0x318 },
    { 0xffffffef, 0x00280621, 0x000 },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x0000f8e0, 0x00204411, 0x000 },
    { 0x00000000, 0x00294901, 0x000 },
    { 0x00000000, 0x00894901, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00804811, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x97000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00002257, 0x00204411, 0x000 },
    { 0x00000003, 0xc0484a20, 0x000 },
    { 0x0000225d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x645 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x00000001, 0x40304a20, 0x000 },
    { 0x00000002, 0xc0304a20, 0x000 },
    { 0x00000001, 0x00530a22, 0x34b },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x354 },
    { 0x00000014, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x364 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00604802, 0x36e },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x36a },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x35f },
    { 0x00000028, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5c0 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x35f },
    { 0x0000002c, 0x00203626, 0x000 },
    { 0x00000049, 0x00201811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000000, 0x002f0226, 0x000 },
    { 0x00000000, 0x0cc00000, 0x370 },
    { 0x0000002c, 0x00801a2d, 0x000 },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x00000015, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x386 },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3b1 },
    { 0x00000016, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3b5 },
    { 0x00000020, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x39c },
    { 0x0000000f, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3a8 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3a8 },
    { 0x0000001e, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x390 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x08000000, 0x00290a22, 0x000 },
    { 0x00000003, 0x40210e20, 0x000 },
    { 0x0000000c, 0xc0211220, 0x000 },
    { 0x00080000, 0x00281224, 0x000 },
    { 0x00000014, 0xc0221620, 0x000 },
    { 0x00000000, 0x002914a4, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x002948a2, 0x000 },
    { 0x0000a1fe, 0x00204411, 0x000 },
    { 0x00000000, 0x00404803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000015, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x392 },
    { 0x0000210e, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000017, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000003, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x39e },
    { 0x00002108, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x80000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000010, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3ae },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000006, 0x00404811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x0000001d, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x3ce },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x3c0 },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0xbabecafe, 0x00204811, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000004, 0x00404811, 0x000 },
    { 0x00002170, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000a, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3d3 },
    { 0x8c000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00003fff, 0x40280a20, 0x000 },
    { 0x80000000, 0x40280e20, 0x000 },
    { 0x40000000, 0xc0281220, 0x000 },
    { 0x00040000, 0x00694622, 0x68d },
    { 0x00000000, 0x00201410, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3e1 },
    { 0x00000000, 0xc0401800, 0x3e4 },
    { 0x00003fff, 0xc0281a20, 0x000 },
    { 0x00040000, 0x00694626, 0x68d },
    { 0x00000000, 0x00201810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3e7 },
    { 0x00000000, 0xc0401c00, 0x3ea },
    { 0x00003fff, 0xc0281e20, 0x000 },
    { 0x00040000, 0x00694627, 0x68d },
    { 0x00000000, 0x00201c10, 0x000 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0x002820c5, 0x000 },
    { 0x00000000, 0x004948e8, 0x000 },
    { 0xa5800000, 0x00200811, 0x000 },
    { 0x00002000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x0000001f, 0xc0210220, 0x000 },
    { 0x00000000, 0x14c00000, 0x3f7 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000ffff, 0xc0481220, 0x3ff },
    { 0xa7800000, 0x00200811, 0x000 },
    { 0x0000a000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00304883, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xa9800000, 0x00200811, 0x000 },
    { 0x0000c000, 0x00400c11, 0x3fa },
    { 0xab800000, 0x00200811, 0x000 },
    { 0x0000f8e0, 0x00400c11, 0x3fa },
    { 0xad800000, 0x00200811, 0x000 },
    { 0x0000f880, 0x00400c11, 0x3fa },
    { 0xb3800000, 0x00200811, 0x000 },
    { 0x0000f3fc, 0x00400c11, 0x3fa },
    { 0xaf800000, 0x00200811, 0x000 },
    { 0x0000e000, 0x00400c11, 0x3fa },
    { 0xb1800000, 0x00200811, 0x000 },
    { 0x0000f000, 0x00400c11, 0x3fa },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00002148, 0x00204811, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x01182000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0218a000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0318c000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0418f8e0, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0518f880, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0618e000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0718f000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0818f3fc, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000030, 0x00200a2d, 0x000 },
    { 0x00000000, 0xc0290c40, 0x000 },
    { 0x00000030, 0x00203623, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x86000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x85000000, 0xc0204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00000018, 0x40210220, 0x000 },
    { 0x00000000, 0x14c00000, 0x445 },
    { 0x00800000, 0xc0494a20, 0x446 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68d },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00404c02, 0x44b },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x00000000, 0xc0201400, 0x000 },
    { 0x00000000, 0xc0201800, 0x000 },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x459 },
    { 0x00000000, 0xc0202000, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x00000010, 0x00280a23, 0x000 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x461 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0x00694624, 0x68d },
    { 0x00000000, 0x00400000, 0x466 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00604805, 0x692 },
    { 0x00000000, 0x002824f0, 0x000 },
    { 0x00000007, 0x00280a23, 0x000 },
    { 0x00000001, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x46d },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x04e00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00000002, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x472 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x02e00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x477 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ce00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x47c },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ae00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00000005, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x481 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x06e00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x486 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x08e00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x000 },
    { 0x00000008, 0x00210a23, 0x000 },
    { 0x00000000, 0x14c00000, 0x490 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x499 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x00404c08, 0x459 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000011, 0x40211220, 0x000 },
    { 0x00000012, 0x40211620, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00210225, 0x000 },
    { 0x00000000, 0x14e00000, 0x4a3 },
    { 0x00040000, 0xc0494a20, 0x4a4 },
    { 0xfffbffff, 0xc0284a20, 0x000 },
    { 0x00000000, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x4b0 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000c, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x4ac },
    { 0xa0000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000004, 0x00204811, 0x000 },
    { 0x0000216b, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000216c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00400000, 0x4aa },
    { 0x00000000, 0xc0210a20, 0x000 },
    { 0x00000000, 0x14c00000, 0x4c3 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x692 },
    { 0x00000000, 0x00400000, 0x4c7 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0xc0294620, 0x000 },
    { 0x00000000, 0xc0600000, 0x68d },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x4ce },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0404810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000000, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x4d0 },
    { 0x00002180, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000003, 0x00333e2f, 0x000 },
    { 0x00000001, 0x00210221, 0x000 },
    { 0x00000000, 0x14e00000, 0x500 },
    { 0x0000002c, 0x00200a2d, 0x000 },
    { 0x00040000, 0x18e00c11, 0x4ef },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xd8c04800, 0x4e3 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000002d, 0x0020122d, 0x000 },
    { 0x00000000, 0x00290c83, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000011, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00400000, 0x4aa },
    { 0x0000002c, 0xc0203620, 0x000 },
    { 0x0000002d, 0xc0403620, 0x000 },
    { 0x0000000f, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x505 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0xd9000000, 0x000 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xb5000000, 0x00204411, 0x000 },
    { 0x00002000, 0x00204811, 0x000 },
    { 0xb6000000, 0x00204411, 0x000 },
    { 0x0000a000, 0x00204811, 0x000 },
    { 0xb7000000, 0x00204411, 0x000 },
    { 0x0000c000, 0x00204811, 0x000 },
    { 0xb8000000, 0x00204411, 0x000 },
    { 0x0000f8e0, 0x00204811, 0x000 },
    { 0xb9000000, 0x00204411, 0x000 },
    { 0x0000f880, 0x00204811, 0x000 },
    { 0xba000000, 0x00204411, 0x000 },
    { 0x0000e000, 0x00204811, 0x000 },
    { 0xbb000000, 0x00204411, 0x000 },
    { 0x0000f000, 0x00204811, 0x000 },
    { 0xbc000000, 0x00204411, 0x000 },
    { 0x0000f3fc, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000002, 0x00204811, 0x000 },
    { 0x000000ff, 0x00280e30, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x519 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x14c00000, 0x52e },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000001c, 0x00203623, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000029, 0x00203623, 0x000 },
    { 0x00000028, 0x00203623, 0x000 },
    { 0x00000017, 0x00203623, 0x000 },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203623, 0x000 },
    { 0x00000015, 0x00203623, 0x000 },
    { 0x00000016, 0x00203623, 0x000 },
    { 0xffffe000, 0x00200c11, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203623, 0x000 },
    { 0x00001fff, 0x00200c11, 0x000 },
    { 0x00000023, 0x00203623, 0x000 },
    { 0x00000024, 0x00203623, 0x000 },
    { 0xf1ffffff, 0x00283a2e, 0x000 },
    { 0x0000001a, 0xc0220e20, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000002a, 0x40203620, 0x000 },
    { 0x87000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000030, 0x00203623, 0x000 },
    { 0x9d000000, 0x00204411, 0x000 },
    { 0x0000001f, 0x40214a20, 0x000 },
    { 0x96000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x0000001f, 0x00211624, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x0000001d, 0x00203623, 0x000 },
    { 0x00000003, 0x00281e23, 0x000 },
    { 0x00000008, 0x00222223, 0x000 },
    { 0xfffff000, 0x00282228, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x0000001f, 0x00203628, 0x000 },
    { 0x00000018, 0x00211e23, 0x000 },
    { 0x00000020, 0x00203627, 0x000 },
    { 0x00000002, 0x00221624, 0x000 },
    { 0x00000000, 0x003014a8, 0x000 },
    { 0x0000001e, 0x00203625, 0x000 },
    { 0x00000003, 0x00211a24, 0x000 },
    { 0x10000000, 0x00281a26, 0x000 },
    { 0xefffffff, 0x00283a2e, 0x000 },
    { 0x00000000, 0x004938ce, 0x67b },
    { 0x00000001, 0x40280a20, 0x000 },
    { 0x00000006, 0x40280e20, 0x000 },
    { 0x00000300, 0xc0281220, 0x000 },
    { 0x00000008, 0x00211224, 0x000 },
    { 0x00000000, 0xc0201620, 0x000 },
    { 0x00000000, 0xc0201a20, 0x000 },
    { 0x00000000, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x566 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x68d },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00020000, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56e },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x57c },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x68d },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x57c },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x572 },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00000000, 0xc0400000, 0x57c },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x57a },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x692 },
    { 0x00000000, 0x00401c10, 0x57c },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x0ee00000, 0x57e },
    { 0x00000000, 0x00600000, 0x5c9 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x58f },
    { 0x0000a2b7, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2b6, 0x00604411, 0x68d },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0000a2c4, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x58d },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000001, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5a0 },
    { 0x0000a2bb, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2ba, 0x00604411, 0x68d },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0000a2c5, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x59e },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000002, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5b1 },
    { 0x0000a2bf, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2be, 0x00604411, 0x68d },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0000a2c6, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5af },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x0000a2c3, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2c2, 0x00604411, 0x68d },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0000a2c7, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5be },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x85000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x0000304a, 0x00204411, 0x000 },
    { 0x01000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00400000, 0x5c4 },
    { 0xa4000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0xc0600000, 0x5c9 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000002c, 0x00203621, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0230, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5d0 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000030, 0x00403621, 0x5e3 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00007e00, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x5e3 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a092, 0x00604411, 0x68d },
    { 0x00000031, 0x00203630, 0x000 },
    { 0x0004a093, 0x00604411, 0x68d },
    { 0x00000032, 0x00203630, 0x000 },
    { 0x0004a2b6, 0x00604411, 0x68d },
    { 0x00000033, 0x00203630, 0x000 },
    { 0x0004a2ba, 0x00604411, 0x68d },
    { 0x00000034, 0x00203630, 0x000 },
    { 0x0004a2be, 0x00604411, 0x68d },
    { 0x00000035, 0x00203630, 0x000 },
    { 0x0004a2c2, 0x00604411, 0x68d },
    { 0x00000036, 0x00203630, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x88000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000001, 0x002f0230, 0x000 },
    { 0x00000000, 0x0ce00000, 0x62c },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x62c },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00007e00, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x605 },
    { 0x0000a092, 0x00204411, 0x000 },
    { 0x00000031, 0x00204a2d, 0x000 },
    { 0x0000a093, 0x00204411, 0x000 },
    { 0x00000032, 0x00204a2d, 0x000 },
    { 0x0000a2b6, 0x00204411, 0x000 },
    { 0x00000033, 0x00204a2d, 0x000 },
    { 0x0000a2ba, 0x00204411, 0x000 },
    { 0x00000034, 0x00204a2d, 0x000 },
    { 0x0000a2be, 0x00204411, 0x000 },
    { 0x00000035, 0x00204a2d, 0x000 },
    { 0x0000a2c2, 0x00204411, 0x000 },
    { 0x00000036, 0x00204a2d, 0x000 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x000001ff, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x62b },
    { 0x00000000, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x60e },
    { 0x0004a003, 0x00604411, 0x68d },
    { 0x0000a003, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000001, 0x00210621, 0x000 },
    { 0x00000000, 0x14c00000, 0x613 },
    { 0x0004a010, 0x00604411, 0x68d },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000001, 0x00210621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x62b },
    { 0x0004a011, 0x00604411, 0x68d },
    { 0x0000a011, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a012, 0x00604411, 0x68d },
    { 0x0000a012, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a013, 0x00604411, 0x68d },
    { 0x0000a013, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a014, 0x00604411, 0x68d },
    { 0x0000a014, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a015, 0x00604411, 0x68d },
    { 0x0000a015, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a016, 0x00604411, 0x68d },
    { 0x0000a016, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a017, 0x00604411, 0x68d },
    { 0x0000a017, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0000002c, 0x0080062d, 0x000 },
    { 0xff000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000002, 0x00804811, 0x000 },
    { 0x00000000, 0x0ee00000, 0x63d },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00000002, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x63b },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x00001000, 0x00200811, 0x000 },
    { 0x0000002b, 0x00203622, 0x000 },
    { 0x00000000, 0x00600000, 0x641 },
    { 0x00000000, 0x00600000, 0x5c9 },
    { 0x98000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00804811, 0x000 },
    { 0x00000000, 0xc0600000, 0x641 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000022, 0x00204811, 0x000 },
    { 0x89000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00404811, 0x62d },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404811, 0x62d },
    { 0x00000000, 0x00600000, 0x65c },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0xc0204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x09800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68d },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000004, 0x00404c11, 0x656 },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000004, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffffb, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffff7, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x01800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004217f, 0x00604411, 0x68d },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x68c },
    { 0x00000010, 0x00404c11, 0x672 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x38c00000, 0x000 },
    { 0x0000001d, 0x00200a2d, 0x000 },
    { 0x0000001e, 0x00200e2d, 0x000 },
    { 0x0000001f, 0x0020122d, 0x000 },
    { 0x00000020, 0x0020162d, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000004, 0x00301224, 0x000 },
    { 0x00000000, 0x002f0064, 0x000 },
    { 0x00000000, 0x0cc00000, 0x68b },
    { 0x00000003, 0x00281a22, 0x000 },
    { 0x00000008, 0x00221222, 0x000 },
    { 0xfffff000, 0x00281224, 0x000 },
    { 0x00000000, 0x002910c4, 0x000 },
    { 0x0000001f, 0x00403624, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x68d },
    { 0x9f000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x690 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x692 },
    { 0x9e000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x695 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0xc0204411, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000024, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000022, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00404811, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x01420502, 0x05c00250, 0x000 },
    { 0x01c30168, 0x043f05c0, 0x000 },
    { 0x02250209, 0x02500151, 0x000 },
    { 0x02230245, 0x02a00241, 0x000 },
    { 0x03d705c0, 0x05c005c0, 0x000 },
    { 0x0649064a, 0x031f05c0, 0x000 },
    { 0x05c005c5, 0x03200340, 0x000 },
    { 0x032a0282, 0x03420334, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x05c00551, 0x05c005c0, 0x000 },
    { 0x03ba05c0, 0x04bb0344, 0x000 },
    { 0x049a0450, 0x043d05c0, 0x000 },
    { 0x04d005c0, 0x044104dd, 0x000 },
    { 0x04500507, 0x03510375, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x05c005c0, 0x063f05c7, 0x000 },
    { 0x05c005c0, 0x000705c0, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x03f803ed, 0x04080406, 0x000 },
    { 0x040e040a, 0x040c0410, 0x000 },
    { 0x041c0418, 0x04240420, 0x000 },
    { 0x042c0428, 0x04340430, 0x000 },
    { 0x05c005c0, 0x043805c0, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x00020679, 0x06970006, 0x000 },
};

static const u32 RV610_pfp_microcode[]={
0xca0400,
0xa00000,
0x7e828b,
0x7c038b,
0x8001b8,
0x7c038b,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xc41838,
0xca2400,
0xca2800,
0x9581a8,
0xc41c3a,
0xc3c000,
0xca0800,
0xca0c00,
0x7c744b,
0xc20005,
0x99c000,
0xc41c3a,
0x7c744c,
0xc0fff0,
0x042c04,
0x309002,
0x7d2500,
0x351402,
0x7d350b,
0x255403,
0x7cd580,
0x259c03,
0x95c004,
0xd5001b,
0x7eddc1,
0x7d9d80,
0xd6801b,
0xd5801b,
0xd4401e,
0xd5401e,
0xd6401e,
0xd6801e,
0xd4801e,
0xd4c01e,
0x9783d3,
0xd5c01e,
0xca0800,
0x80001a,
0xca0c00,
0xe4011e,
0xd4001e,
0x80000c,
0xc41838,
0xe4013e,
0xd4001e,
0x80000c,
0xc41838,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca1800,
0xd4401e,
0xd5801e,
0x800053,
0xd40075,
0xd4401e,
0xca0800,
0xca0c00,
0xca1000,
0xd48019,
0xd4c018,
0xd50017,
0xd4801e,
0xd4c01e,
0xd5001e,
0xe2001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0xd48060,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xd48061,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xca0c00,
0xd4401e,
0xd48016,
0xd4c016,
0xd4801e,
0x8001b8,
0xd4c01e,
0xc60843,
0xca0c00,
0xca1000,
0x948004,
0xca1400,
0xe420f3,
0xd42013,
0xd56065,
0xd4e01c,
0xd5201c,
0xd5601c,
0x800000,
0x062001,
0xc60843,
0xca0c00,
0xca1000,
0x9483f7,
0xca1400,
0xe420f3,
0x800079,
0xd42013,
0xc60843,
0xca0c00,
0xca1000,
0x9883ef,
0xca1400,
0xd40064,
0x80008d,
0x000000,
0xc41432,
0xc61843,
0xc4082f,
0x954005,
0xc40c30,
0xd4401e,
0x800000,
0xee001e,
0x9583f5,
0xc41031,
0xd44033,
0xd52065,
0xd4a01c,
0xd4e01c,
0xd5201c,
0xe4015e,
0xd4001e,
0x800000,
0x062001,
0xca1800,
0x0a2001,
0xd60076,
0xc40836,
0x988007,
0xc61045,
0x950110,
0xd4001f,
0xd46062,
0x800000,
0xd42062,
0xcc3835,
0xcc1433,
0x8401bb,
0xd40072,
0xd5401e,
0x800000,
0xee001e,
0xe2001a,
0x8401bb,
0xe2001a,
0xcc104b,
0xcc0447,
0x2c9401,
0x7d098b,
0x984005,
0x7d15cb,
0xd4001a,
0x8001b8,
0xd4006d,
0x344401,
0xcc0c48,
0x98403a,
0xcc2c4a,
0x958004,
0xcc0449,
0x8001b8,
0xd4001a,
0xd4c01a,
0x282801,
0x8400f0,
0xcc1003,
0x98801b,
0x04380c,
0x8400f0,
0xcc1003,
0x988017,
0x043808,
0x8400f0,
0xcc1003,
0x988013,
0x043804,
0x8400f0,
0xcc1003,
0x988014,
0xcc104c,
0x9a8009,
0xcc144d,
0x9840dc,
0xd4006d,
0xcc1848,
0xd5001a,
0xd5401a,
0x8000c9,
0xd5801a,
0x96c0d5,
0xd4006d,
0x8001b8,
0xd4006e,
0x9ac003,
0xd4006d,
0xd4006e,
0x800000,
0xec007f,
0x9ac0cc,
0xd4006d,
0x8001b8,
0xd4006e,
0xcc1403,
0xcc1803,
0xcc1c03,
0x7d9103,
0x7dd583,
0x7d190c,
0x35cc1f,
0x35701f,
0x7cf0cb,
0x7cd08b,
0x880000,
0x7e8e8b,
0x95c004,
0xd4006e,
0x8001b8,
0xd4001a,
0xd4c01a,
0xcc0803,
0xcc0c03,
0xcc1003,
0xcc1403,
0xcc1803,
0xcc1c03,
0xcc2403,
0xcc2803,
0x35c41f,
0x36b01f,
0x7c704b,
0x34f01f,
0x7c704b,
0x35701f,
0x7c704b,
0x7d8881,
0x7dccc1,
0x7e5101,
0x7e9541,
0x7c9082,
0x7cd4c2,
0x7c848b,
0x9ac003,
0x7c8c8b,
0x2c8801,
0x98809e,
0xd4006d,
0x98409c,
0xd4006e,
0xcc084c,
0xcc0c4d,
0xcc1048,
0xd4801a,
0xd4c01a,
0x800101,
0xd5001a,
0xcc0832,
0xd40032,
0x9482d9,
0xca0c00,
0xd4401e,
0x800000,
0xd4001e,
0xe4011e,
0xd4001e,
0xca0800,
0xca0c00,
0xca1000,
0xd4401e,
0xca1400,
0xd4801e,
0xd4c01e,
0xd5001e,
0xd5401e,
0xd54034,
0x800000,
0xee001e,
0x280404,
0xe2001a,
0xe2001a,
0xd4401a,
0xca3800,
0xcc0803,
0xcc0c03,
0xcc0c03,
0xcc0c03,
0x9882bd,
0x000000,
0x8401bb,
0xd7a06f,
0x800000,
0xee001f,
0xca0400,
0xc2ff00,
0xcc0834,
0xc13fff,
0x7c74cb,
0x7cc90b,
0x7d010f,
0x9902b0,
0x7c738b,
0x8401bb,
0xd7a06f,
0x800000,
0xee001f,
0xca0800,
0x281900,
0x7d898b,
0x958014,
0x281404,
0xca0c00,
0xca1000,
0xca1c00,
0xca2400,
0xe2001f,
0xd4c01a,
0xd5001a,
0xd5401a,
0xcc1803,
0xcc2c03,
0xcc2c03,
0xcc2c03,
0x7da58b,
0x7d9c47,
0x984297,
0x000000,
0x800161,
0xd4c01a,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0x248c06,
0x0ccc06,
0x98c006,
0xcc104e,
0x990004,
0xd40073,
0xe4011e,
0xd4001e,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xca0800,
0xca0c00,
0x34d018,
0x251001,
0x950021,
0xc17fff,
0xca1000,
0xca1400,
0xca1800,
0xd4801d,
0xd4c01d,
0x7db18b,
0xc14202,
0xc2c001,
0xd5801d,
0x34dc0e,
0x7d5d4c,
0x7f734c,
0xd7401e,
0xd5001e,
0xd5401e,
0xc14200,
0xc2c000,
0x099c01,
0x31dc10,
0x7f5f4c,
0x7f734c,
0x042802,
0x7d8380,
0xd5a86f,
0xd58066,
0xd7401e,
0xec005e,
0xc82402,
0xc82402,
0x8001b8,
0xd60076,
0xd4401e,
0xd4801e,
0xd4c01e,
0x800000,
0xee001e,
0x800000,
0xee001f,
0xd4001f,
0x800000,
0xd4001f,
0xd4001f,
0x880000,
0xd4001f,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x010171,
0x020178,
0x03008f,
0x04007f,
0x050003,
0x06003f,
0x070032,
0x08012c,
0x090046,
0x0a0036,
0x1001b6,
0x1700a2,
0x22013a,
0x230149,
0x2000b4,
0x240125,
0x27004d,
0x28006a,
0x2a0060,
0x2b0052,
0x2f0065,
0x320087,
0x34017f,
0x3c0156,
0x3f0072,
0x41018c,
0x44012e,
0x550173,
0x56017a,
0x60000b,
0x610034,
0x620038,
0x630038,
0x640038,
0x650038,
0x660038,
0x670038,
0x68003a,
0x690041,
0x6a0048,
0x6b0048,
0x6c0048,
0x6d0048,
0x6e0048,
0x6f0048,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
};

static const u32 RV620_cp_microcode[][3]={
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0000ffff, 0x00284621, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000000, 0x00e00000, 0x000 },
    { 0x00010000, 0xc0294620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x00000000, 0x00600000, 0x631 },
    { 0x00000000, 0x00600000, 0x645 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000f00, 0x00281622, 0x000 },
    { 0x00000008, 0x00211625, 0x000 },
    { 0x00000018, 0x00203625, 0x000 },
    { 0x8d000000, 0x00204411, 0x000 },
    { 0x00000004, 0x002f0225, 0x000 },
    { 0x00000000, 0x0ce00000, 0x018 },
    { 0x00412000, 0x00404811, 0x019 },
    { 0x00422000, 0x00204811, 0x000 },
    { 0x8e000000, 0x00204411, 0x000 },
    { 0x00000028, 0x00204a2d, 0x000 },
    { 0x90000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x0000000c, 0x00211622, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000019, 0x00211a22, 0x000 },
    { 0x00000004, 0x00281a26, 0x000 },
    { 0x00000000, 0x002914c5, 0x000 },
    { 0x00000019, 0x00203625, 0x000 },
    { 0x00000000, 0x003a1402, 0x000 },
    { 0x00000016, 0x00211625, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0xfffffffc, 0x00280e23, 0x000 },
    { 0x00000000, 0x002914a3, 0x000 },
    { 0x00000017, 0x00203625, 0x000 },
    { 0x00008000, 0x00280e22, 0x000 },
    { 0x00000007, 0x00220e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x20000000, 0x00280e22, 0x000 },
    { 0x00000006, 0x00210e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x00000000, 0x00220222, 0x000 },
    { 0x00000000, 0x14e00000, 0x038 },
    { 0x00000000, 0x2ee00000, 0x035 },
    { 0x00000000, 0x2ce00000, 0x037 },
    { 0x00000000, 0x00400e2d, 0x039 },
    { 0x00000008, 0x00200e2d, 0x000 },
    { 0x00000009, 0x0040122d, 0x046 },
    { 0x00000001, 0x00400e2d, 0x039 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x03e },
    { 0x00000008, 0x00401c11, 0x041 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x0000000f, 0x00281e27, 0x000 },
    { 0x00000003, 0x00221e27, 0x000 },
    { 0x7fc00000, 0x00281a23, 0x000 },
    { 0x00000014, 0x00211a26, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000008, 0x00221a26, 0x000 },
    { 0x00000000, 0x00290cc7, 0x000 },
    { 0x00000027, 0x00203624, 0x000 },
    { 0x00007f00, 0x00281221, 0x000 },
    { 0x00001400, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x04b },
    { 0x00000001, 0x00290e23, 0x000 },
    { 0x0000000e, 0x00203623, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfff80000, 0x00294a23, 0x000 },
    { 0x00000000, 0x003a2c02, 0x000 },
    { 0x00000002, 0x00220e2b, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x0000000f, 0x00203623, 0x000 },
    { 0x00001fff, 0x00294a23, 0x000 },
    { 0x00000027, 0x00204a2d, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000029, 0x00200e2d, 0x000 },
    { 0x060a0200, 0x00294a23, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14e00000, 0x061 },
    { 0x00000000, 0x2ee00000, 0x05f },
    { 0x00000000, 0x2ce00000, 0x05e },
    { 0x00000000, 0x00400e2d, 0x062 },
    { 0x00000001, 0x00400e2d, 0x062 },
    { 0x0000000a, 0x00200e2d, 0x000 },
    { 0x0000000b, 0x0040122d, 0x06a },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x7fc00000, 0x00281623, 0x000 },
    { 0x00000014, 0x00211625, 0x000 },
    { 0x00000001, 0x00331625, 0x000 },
    { 0x80000000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00290ca3, 0x000 },
    { 0x3ffffc00, 0x00290e23, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x06d },
    { 0x00000100, 0x00401c11, 0x070 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x000000f0, 0x00281e27, 0x000 },
    { 0x00000004, 0x00221e27, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0xfffff0ff, 0x00281a30, 0x000 },
    { 0x0000a028, 0x00204411, 0x000 },
    { 0x00000000, 0x002948e6, 0x000 },
    { 0x0000a018, 0x00204411, 0x000 },
    { 0x3fffffff, 0x00284a23, 0x000 },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000030, 0x0020162d, 0x000 },
    { 0x00000002, 0x00291625, 0x000 },
    { 0x00000030, 0x00203625, 0x000 },
    { 0x00000025, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a3, 0x000 },
    { 0x00000000, 0x0cc00000, 0x083 },
    { 0x00000026, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a4, 0x000 },
    { 0x00000000, 0x0cc00000, 0x084 },
    { 0x00000000, 0x00400000, 0x08a },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203624, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x08a },
    { 0x00000000, 0x00600000, 0x668 },
    { 0x00000000, 0x00600000, 0x65c },
    { 0x00000002, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x08d },
    { 0x00000012, 0xc0403620, 0x093 },
    { 0x00000000, 0x2ee00000, 0x091 },
    { 0x00000000, 0x2ce00000, 0x090 },
    { 0x00000002, 0x00400e2d, 0x092 },
    { 0x00000003, 0x00400e2d, 0x092 },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000012, 0x00203623, 0x000 },
    { 0x00000003, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x098 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x0a0 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x2ee00000, 0x09e },
    { 0x00000000, 0x2ce00000, 0x09d },
    { 0x00000002, 0x00400e2d, 0x09f },
    { 0x00000003, 0x00400e2d, 0x09f },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x003f0000, 0x00280e23, 0x000 },
    { 0x00000010, 0x00210e23, 0x000 },
    { 0x00000011, 0x00203623, 0x000 },
    { 0x0000001e, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0a7 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x0000001f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0aa },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000008, 0x00210e2b, 0x000 },
    { 0x0000007f, 0x00280e23, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0e1 },
    { 0x00000000, 0x27000000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ae00000, 0x0b3 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000000c, 0x00221e30, 0x000 },
    { 0x99800000, 0x00204411, 0x000 },
    { 0x00000004, 0x0020122d, 0x000 },
    { 0x00000008, 0x00221224, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00291ce4, 0x000 },
    { 0x00000000, 0x00604807, 0x12f },
    { 0x9b000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x9c000000, 0x00204411, 0x000 },
    { 0x00000000, 0x0033146f, 0x000 },
    { 0x00000001, 0x00333e23, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0x00203c05, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e007, 0x00204411, 0x000 },
    { 0x0000000f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0cb },
    { 0x00f8ff08, 0x00204811, 0x000 },
    { 0x98000000, 0x00404811, 0x0dc },
    { 0x000000f0, 0x00280e22, 0x000 },
    { 0x000000a0, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x0da },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d5 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d4 },
    { 0x00003f00, 0x00400c11, 0x0d6 },
    { 0x00001f00, 0x00400c11, 0x0d6 },
    { 0x00000f00, 0x00200c11, 0x000 },
    { 0x00380009, 0x00294a23, 0x000 },
    { 0x3f000000, 0x00280e2b, 0x000 },
    { 0x00000002, 0x00220e23, 0x000 },
    { 0x00000007, 0x00494a23, 0x0dc },
    { 0x00380f09, 0x00204811, 0x000 },
    { 0x68000007, 0x00204811, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000a202, 0x00204411, 0x000 },
    { 0x00ff0000, 0x00280e22, 0x000 },
    { 0x00000080, 0x00294a23, 0x000 },
    { 0x00000027, 0x00200e2d, 0x000 },
    { 0x00000026, 0x0020122d, 0x000 },
    { 0x00000000, 0x002f0083, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0ea },
    { 0x00000000, 0x00600000, 0x662 },
    { 0x00000000, 0x00400000, 0x0eb },
    { 0x00000000, 0x00600000, 0x665 },
    { 0x00000007, 0x0020222d, 0x000 },
    { 0x00000005, 0x00220e22, 0x000 },
    { 0x00100000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x000000ef, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000003, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x0f8 },
    { 0x0000000b, 0x00210228, 0x000 },
    { 0x00000000, 0x14c00000, 0x0f8 },
    { 0x00000400, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000001c, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x0fd },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000001e, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x10b },
    { 0x0000a30f, 0x00204411, 0x000 },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x104 },
    { 0xffffffff, 0x00404811, 0x10b },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x107 },
    { 0x0000ffff, 0x00404811, 0x10b },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x10a },
    { 0x000000ff, 0x00404811, 0x10b },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0002c400, 0x00204411, 0x000 },
    { 0x0000001f, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x112 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000018, 0x40224a20, 0x000 },
    { 0x00000010, 0xc0424a20, 0x114 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000000a, 0x00201011, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x11b },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00531224, 0x117 },
    { 0xffbfffff, 0x00283a2e, 0x000 },
    { 0x0000001b, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x12e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0x00000018, 0x00220e30, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e00e, 0x00204411, 0x000 },
    { 0x07f8ff08, 0x00204811, 0x000 },
    { 0x00000000, 0x00294a23, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00800000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204806, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68d },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x68c },
    { 0x00000004, 0x00404c11, 0x135 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000001c, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x13c },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40280620, 0x000 },
    { 0x00000010, 0xc0210a20, 0x000 },
    { 0x00000000, 0x00341461, 0x000 },
    { 0x00000000, 0x00741882, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x147 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0681a20, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x158 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000001, 0x00300a2f, 0x000 },
    { 0x00000001, 0x00210a22, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600000, 0x18f },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00202c08, 0x000 },
    { 0x00000000, 0x00202411, 0x000 },
    { 0x00000000, 0x00202811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000002, 0x00221e29, 0x000 },
    { 0x00000000, 0x007048eb, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000001, 0x40330620, 0x000 },
    { 0x00000000, 0xc0302409, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ae00000, 0x181 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x186 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x186 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000001, 0x00530621, 0x182 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0604800, 0x197 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000011, 0x0020062d, 0x000 },
    { 0x00000000, 0x0078042a, 0x2fb },
    { 0x00000000, 0x00202809, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x174 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x194 },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x46000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x19b },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00804811, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40281620, 0x000 },
    { 0x00000010, 0xc0811a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000008, 0x00221e30, 0x000 },
    { 0x00000029, 0x00201a2d, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfffbff09, 0x00204811, 0x000 },
    { 0x0000000f, 0x0020222d, 0x000 },
    { 0x00001fff, 0x00294a28, 0x000 },
    { 0x00000006, 0x0020222d, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000100, 0x00201811, 0x000 },
    { 0x00000008, 0x00621e28, 0x12f },
    { 0x00000008, 0x00822228, 0x000 },
    { 0x0002c000, 0x00204411, 0x000 },
    { 0x00000015, 0x00600e2d, 0x1bd },
    { 0x00000016, 0x00600e2d, 0x1bd },
    { 0x0000c008, 0x00204411, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000000, 0x14c00000, 0x1b9 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x39000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00804802, 0x000 },
    { 0x00000018, 0x00202e2d, 0x000 },
    { 0x00000000, 0x003b0d63, 0x000 },
    { 0x00000008, 0x00224a23, 0x000 },
    { 0x00000010, 0x00224a23, 0x000 },
    { 0x00000018, 0x00224a23, 0x000 },
    { 0x00000000, 0x00804803, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000007, 0x0021062f, 0x000 },
    { 0x00000013, 0x00200a2d, 0x000 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000ffff, 0x40282220, 0x000 },
    { 0x0000000f, 0x00262228, 0x000 },
    { 0x00000010, 0x40212620, 0x000 },
    { 0x0000000f, 0x00262629, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1e0 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000081, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000080, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1dc },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1d8 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000001f, 0x00280a22, 0x000 },
    { 0x0000001f, 0x00282a2a, 0x000 },
    { 0x00000001, 0x00530621, 0x1d1 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000002, 0x00304a2f, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000001, 0x00301e2f, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1e5 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x0000000f, 0x00260e23, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000000f, 0x00261224, 0x000 },
    { 0x00000000, 0x00201411, 0x000 },
    { 0x00000000, 0x00601811, 0x2bb },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022b, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1f8 },
    { 0x00000010, 0x00221628, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a29, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x0020480a, 0x000 },
    { 0x00000000, 0x00202c11, 0x000 },
    { 0x00000010, 0x00221623, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a24, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x00731503, 0x205 },
    { 0x00000000, 0x00201805, 0x000 },
    { 0x00000000, 0x00731524, 0x205 },
    { 0x00000000, 0x002d14c5, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00000000, 0x00202003, 0x000 },
    { 0x00000000, 0x00802404, 0x000 },
    { 0x0000000f, 0x00210225, 0x000 },
    { 0x00000000, 0x14c00000, 0x68c },
    { 0x00000000, 0x002b1405, 0x000 },
    { 0x00000001, 0x00901625, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00294a22, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a21, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000ffff, 0x40281220, 0x000 },
    { 0x00000010, 0xc0211a20, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211620, 0x000 },
    { 0x00000000, 0x00741465, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00000001, 0x00330621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0cc00000, 0x219 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x212 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x645 },
    { 0x00000000, 0x0040040f, 0x213 },
    { 0x00000000, 0x00600000, 0x631 },
    { 0x00000000, 0x00600000, 0x645 },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00000000, 0x00600000, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ae00000, 0x232 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x236 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x236 },
    { 0x00000000, 0xc0404800, 0x233 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x00600411, 0x2fb },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x631 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000018, 0x40210a20, 0x000 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x24c },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x00080101, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x251 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000010, 0x00600411, 0x315 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00000000, 0x00600000, 0x27c },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000001, 0x00211e27, 0x000 },
    { 0x00000000, 0x14e00000, 0x26a },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x0000ffff, 0x00281e27, 0x000 },
    { 0x00000000, 0x00341c27, 0x000 },
    { 0x00000000, 0x12c00000, 0x25f },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e5, 0x000 },
    { 0x00000000, 0x08c00000, 0x262 },
    { 0x00000000, 0x00201407, 0x000 },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00211e27, 0x000 },
    { 0x00000000, 0x00341c47, 0x000 },
    { 0x00000000, 0x12c00000, 0x267 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x08c00000, 0x26a },
    { 0x00000000, 0x00201807, 0x000 },
    { 0x00000000, 0x00600000, 0x2c1 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000000, 0x00342023, 0x000 },
    { 0x00000000, 0x12c00000, 0x272 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x271 },
    { 0x00000016, 0x00404811, 0x276 },
    { 0x00000018, 0x00404811, 0x276 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x275 },
    { 0x00000017, 0x00404811, 0x276 },
    { 0x00000019, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00604411, 0x2e9 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x256 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000010, 0x40210620, 0x000 },
    { 0x0000ffff, 0xc0280a20, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0881a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x00000000, 0x00600000, 0x631 },
    { 0x00000000, 0xc0600000, 0x2a3 },
    { 0x00000005, 0x00200a2d, 0x000 },
    { 0x00000008, 0x00220a22, 0x000 },
    { 0x0000002b, 0x00201a2d, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00007000, 0x00281e27, 0x000 },
    { 0x00000000, 0x00311ce6, 0x000 },
    { 0x0000002a, 0x00201a2d, 0x000 },
    { 0x0000000c, 0x00221a26, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x06e00000, 0x292 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00691ce2, 0x12f },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x29d },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000001c, 0x00403627, 0x000 },
    { 0x0000000c, 0xc0220a20, 0x000 },
    { 0x00000029, 0x00203622, 0x000 },
    { 0x00000028, 0xc0403620, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000009, 0x00204811, 0x000 },
    { 0xa1000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce3, 0x000 },
    { 0x00000021, 0x00203627, 0x000 },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce4, 0x000 },
    { 0x00000022, 0x00203627, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a3, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203624, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000000, 0x00311cc4, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14c00000, 0x2dc },
    { 0x00000000, 0x00400000, 0x2d9 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2d9 },
    { 0x00000003, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2dc },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e1, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a1, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e2, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000000, 0x00600000, 0x668 },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00600000, 0x65f },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2a7 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x0000001a, 0x00201e2d, 0x000 },
    { 0x0000001b, 0x0080222d, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca1, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x003808c5, 0x000 },
    { 0x00000000, 0x00300841, 0x000 },
    { 0x00000001, 0x00220a22, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000017, 0x0020222d, 0x000 },
    { 0x00000000, 0x14c00000, 0x318 },
    { 0xffffffef, 0x00280621, 0x000 },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x0000f8e0, 0x00204411, 0x000 },
    { 0x00000000, 0x00294901, 0x000 },
    { 0x00000000, 0x00894901, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00804811, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x97000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00002257, 0x00204411, 0x000 },
    { 0x00000003, 0xc0484a20, 0x000 },
    { 0x0000225d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x645 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x00000001, 0x40304a20, 0x000 },
    { 0x00000002, 0xc0304a20, 0x000 },
    { 0x00000001, 0x00530a22, 0x34b },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x354 },
    { 0x00000014, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x364 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00604802, 0x36e },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x36a },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x35f },
    { 0x00000028, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5c0 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x35f },
    { 0x0000002c, 0x00203626, 0x000 },
    { 0x00000049, 0x00201811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000000, 0x002f0226, 0x000 },
    { 0x00000000, 0x0cc00000, 0x370 },
    { 0x0000002c, 0x00801a2d, 0x000 },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x00000015, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x386 },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3b1 },
    { 0x00000016, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3b5 },
    { 0x00000020, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x39c },
    { 0x0000000f, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3a8 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3a8 },
    { 0x0000001e, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x390 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x08000000, 0x00290a22, 0x000 },
    { 0x00000003, 0x40210e20, 0x000 },
    { 0x0000000c, 0xc0211220, 0x000 },
    { 0x00080000, 0x00281224, 0x000 },
    { 0x00000014, 0xc0221620, 0x000 },
    { 0x00000000, 0x002914a4, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x002948a2, 0x000 },
    { 0x0000a1fe, 0x00204411, 0x000 },
    { 0x00000000, 0x00404803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000015, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x392 },
    { 0x0000210e, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000017, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000003, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x39e },
    { 0x00002108, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x80000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000010, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3ae },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000006, 0x00404811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x0000001d, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x3ce },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x3c0 },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0xbabecafe, 0x00204811, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000004, 0x00404811, 0x000 },
    { 0x00002170, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000a, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3d3 },
    { 0x8c000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00003fff, 0x40280a20, 0x000 },
    { 0x80000000, 0x40280e20, 0x000 },
    { 0x40000000, 0xc0281220, 0x000 },
    { 0x00040000, 0x00694622, 0x68d },
    { 0x00000000, 0x00201410, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3e1 },
    { 0x00000000, 0xc0401800, 0x3e4 },
    { 0x00003fff, 0xc0281a20, 0x000 },
    { 0x00040000, 0x00694626, 0x68d },
    { 0x00000000, 0x00201810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3e7 },
    { 0x00000000, 0xc0401c00, 0x3ea },
    { 0x00003fff, 0xc0281e20, 0x000 },
    { 0x00040000, 0x00694627, 0x68d },
    { 0x00000000, 0x00201c10, 0x000 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0x002820c5, 0x000 },
    { 0x00000000, 0x004948e8, 0x000 },
    { 0xa5800000, 0x00200811, 0x000 },
    { 0x00002000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x0000001f, 0xc0210220, 0x000 },
    { 0x00000000, 0x14c00000, 0x3f7 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000ffff, 0xc0481220, 0x3ff },
    { 0xa7800000, 0x00200811, 0x000 },
    { 0x0000a000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00304883, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xa9800000, 0x00200811, 0x000 },
    { 0x0000c000, 0x00400c11, 0x3fa },
    { 0xab800000, 0x00200811, 0x000 },
    { 0x0000f8e0, 0x00400c11, 0x3fa },
    { 0xad800000, 0x00200811, 0x000 },
    { 0x0000f880, 0x00400c11, 0x3fa },
    { 0xb3800000, 0x00200811, 0x000 },
    { 0x0000f3fc, 0x00400c11, 0x3fa },
    { 0xaf800000, 0x00200811, 0x000 },
    { 0x0000e000, 0x00400c11, 0x3fa },
    { 0xb1800000, 0x00200811, 0x000 },
    { 0x0000f000, 0x00400c11, 0x3fa },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00002148, 0x00204811, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x01182000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0218a000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0318c000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0418f8e0, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0518f880, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0618e000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0718f000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0818f3fc, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000030, 0x00200a2d, 0x000 },
    { 0x00000000, 0xc0290c40, 0x000 },
    { 0x00000030, 0x00203623, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x86000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x85000000, 0xc0204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00000018, 0x40210220, 0x000 },
    { 0x00000000, 0x14c00000, 0x445 },
    { 0x00800000, 0xc0494a20, 0x446 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68d },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00404c02, 0x44b },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x00000000, 0xc0201400, 0x000 },
    { 0x00000000, 0xc0201800, 0x000 },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x459 },
    { 0x00000000, 0xc0202000, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x00000010, 0x00280a23, 0x000 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x461 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0x00694624, 0x68d },
    { 0x00000000, 0x00400000, 0x466 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00604805, 0x692 },
    { 0x00000000, 0x002824f0, 0x000 },
    { 0x00000007, 0x00280a23, 0x000 },
    { 0x00000001, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x46d },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x04e00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00000002, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x472 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x02e00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x477 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ce00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x47c },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ae00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00000005, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x481 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x06e00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x486 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x08e00000, 0x486 },
    { 0x00000000, 0x00400000, 0x493 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x000 },
    { 0x00000008, 0x00210a23, 0x000 },
    { 0x00000000, 0x14c00000, 0x490 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x499 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x00404c08, 0x459 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000011, 0x40211220, 0x000 },
    { 0x00000012, 0x40211620, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00210225, 0x000 },
    { 0x00000000, 0x14e00000, 0x4a3 },
    { 0x00040000, 0xc0494a20, 0x4a4 },
    { 0xfffbffff, 0xc0284a20, 0x000 },
    { 0x00000000, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x4b0 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000c, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x4ac },
    { 0xa0000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000004, 0x00204811, 0x000 },
    { 0x0000216b, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000216c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00400000, 0x4aa },
    { 0x00000000, 0xc0210a20, 0x000 },
    { 0x00000000, 0x14c00000, 0x4c3 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x692 },
    { 0x00000000, 0x00400000, 0x4c7 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0xc0294620, 0x000 },
    { 0x00000000, 0xc0600000, 0x68d },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x4ce },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0404810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68d },
    { 0x00000000, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x4d0 },
    { 0x00002180, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000003, 0x00333e2f, 0x000 },
    { 0x00000001, 0x00210221, 0x000 },
    { 0x00000000, 0x14e00000, 0x500 },
    { 0x0000002c, 0x00200a2d, 0x000 },
    { 0x00040000, 0x18e00c11, 0x4ef },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xd8c04800, 0x4e3 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000002d, 0x0020122d, 0x000 },
    { 0x00000000, 0x00290c83, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000011, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00400000, 0x4aa },
    { 0x0000002c, 0xc0203620, 0x000 },
    { 0x0000002d, 0xc0403620, 0x000 },
    { 0x0000000f, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x505 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0xd9000000, 0x000 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xb5000000, 0x00204411, 0x000 },
    { 0x00002000, 0x00204811, 0x000 },
    { 0xb6000000, 0x00204411, 0x000 },
    { 0x0000a000, 0x00204811, 0x000 },
    { 0xb7000000, 0x00204411, 0x000 },
    { 0x0000c000, 0x00204811, 0x000 },
    { 0xb8000000, 0x00204411, 0x000 },
    { 0x0000f8e0, 0x00204811, 0x000 },
    { 0xb9000000, 0x00204411, 0x000 },
    { 0x0000f880, 0x00204811, 0x000 },
    { 0xba000000, 0x00204411, 0x000 },
    { 0x0000e000, 0x00204811, 0x000 },
    { 0xbb000000, 0x00204411, 0x000 },
    { 0x0000f000, 0x00204811, 0x000 },
    { 0xbc000000, 0x00204411, 0x000 },
    { 0x0000f3fc, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000002, 0x00204811, 0x000 },
    { 0x000000ff, 0x00280e30, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x519 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x14c00000, 0x52e },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000001c, 0x00203623, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000029, 0x00203623, 0x000 },
    { 0x00000028, 0x00203623, 0x000 },
    { 0x00000017, 0x00203623, 0x000 },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203623, 0x000 },
    { 0x00000015, 0x00203623, 0x000 },
    { 0x00000016, 0x00203623, 0x000 },
    { 0xffffe000, 0x00200c11, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203623, 0x000 },
    { 0x00001fff, 0x00200c11, 0x000 },
    { 0x00000023, 0x00203623, 0x000 },
    { 0x00000024, 0x00203623, 0x000 },
    { 0xf1ffffff, 0x00283a2e, 0x000 },
    { 0x0000001a, 0xc0220e20, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000002a, 0x40203620, 0x000 },
    { 0x87000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000030, 0x00203623, 0x000 },
    { 0x9d000000, 0x00204411, 0x000 },
    { 0x0000001f, 0x40214a20, 0x000 },
    { 0x96000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x0000001f, 0x00211624, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x0000001d, 0x00203623, 0x000 },
    { 0x00000003, 0x00281e23, 0x000 },
    { 0x00000008, 0x00222223, 0x000 },
    { 0xfffff000, 0x00282228, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x0000001f, 0x00203628, 0x000 },
    { 0x00000018, 0x00211e23, 0x000 },
    { 0x00000020, 0x00203627, 0x000 },
    { 0x00000002, 0x00221624, 0x000 },
    { 0x00000000, 0x003014a8, 0x000 },
    { 0x0000001e, 0x00203625, 0x000 },
    { 0x00000003, 0x00211a24, 0x000 },
    { 0x10000000, 0x00281a26, 0x000 },
    { 0xefffffff, 0x00283a2e, 0x000 },
    { 0x00000000, 0x004938ce, 0x67b },
    { 0x00000001, 0x40280a20, 0x000 },
    { 0x00000006, 0x40280e20, 0x000 },
    { 0x00000300, 0xc0281220, 0x000 },
    { 0x00000008, 0x00211224, 0x000 },
    { 0x00000000, 0xc0201620, 0x000 },
    { 0x00000000, 0xc0201a20, 0x000 },
    { 0x00000000, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x566 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x68d },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00020000, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56e },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x57c },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x68d },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x57c },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x572 },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00000000, 0xc0400000, 0x57c },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x57a },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x692 },
    { 0x00000000, 0x00401c10, 0x57c },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x0ee00000, 0x57e },
    { 0x00000000, 0x00600000, 0x5c9 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x58f },
    { 0x0000a2b7, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2b6, 0x00604411, 0x68d },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0000a2c4, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x58d },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000001, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5a0 },
    { 0x0000a2bb, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2ba, 0x00604411, 0x68d },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0000a2c5, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x59e },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000002, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5b1 },
    { 0x0000a2bf, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2be, 0x00604411, 0x68d },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0000a2c6, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5af },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x0000a2c3, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2c2, 0x00604411, 0x68d },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0000a2c7, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5be },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x85000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x0000304a, 0x00204411, 0x000 },
    { 0x01000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00400000, 0x5c4 },
    { 0xa4000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0xc0600000, 0x5c9 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000002c, 0x00203621, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0230, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5d0 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000030, 0x00403621, 0x5e3 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00007e00, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x5e3 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a092, 0x00604411, 0x68d },
    { 0x00000031, 0x00203630, 0x000 },
    { 0x0004a093, 0x00604411, 0x68d },
    { 0x00000032, 0x00203630, 0x000 },
    { 0x0004a2b6, 0x00604411, 0x68d },
    { 0x00000033, 0x00203630, 0x000 },
    { 0x0004a2ba, 0x00604411, 0x68d },
    { 0x00000034, 0x00203630, 0x000 },
    { 0x0004a2be, 0x00604411, 0x68d },
    { 0x00000035, 0x00203630, 0x000 },
    { 0x0004a2c2, 0x00604411, 0x68d },
    { 0x00000036, 0x00203630, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x88000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000001, 0x002f0230, 0x000 },
    { 0x00000000, 0x0ce00000, 0x62c },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x62c },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00007e00, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x605 },
    { 0x0000a092, 0x00204411, 0x000 },
    { 0x00000031, 0x00204a2d, 0x000 },
    { 0x0000a093, 0x00204411, 0x000 },
    { 0x00000032, 0x00204a2d, 0x000 },
    { 0x0000a2b6, 0x00204411, 0x000 },
    { 0x00000033, 0x00204a2d, 0x000 },
    { 0x0000a2ba, 0x00204411, 0x000 },
    { 0x00000034, 0x00204a2d, 0x000 },
    { 0x0000a2be, 0x00204411, 0x000 },
    { 0x00000035, 0x00204a2d, 0x000 },
    { 0x0000a2c2, 0x00204411, 0x000 },
    { 0x00000036, 0x00204a2d, 0x000 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x000001ff, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x62b },
    { 0x00000000, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x60e },
    { 0x0004a003, 0x00604411, 0x68d },
    { 0x0000a003, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000001, 0x00210621, 0x000 },
    { 0x00000000, 0x14c00000, 0x613 },
    { 0x0004a010, 0x00604411, 0x68d },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000001, 0x00210621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x62b },
    { 0x0004a011, 0x00604411, 0x68d },
    { 0x0000a011, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a012, 0x00604411, 0x68d },
    { 0x0000a012, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a013, 0x00604411, 0x68d },
    { 0x0000a013, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a014, 0x00604411, 0x68d },
    { 0x0000a014, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a015, 0x00604411, 0x68d },
    { 0x0000a015, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a016, 0x00604411, 0x68d },
    { 0x0000a016, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a017, 0x00604411, 0x68d },
    { 0x0000a017, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x0000002c, 0x0080062d, 0x000 },
    { 0xff000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000002, 0x00804811, 0x000 },
    { 0x00000000, 0x0ee00000, 0x63d },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00000002, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x63b },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68d },
    { 0x00001000, 0x00200811, 0x000 },
    { 0x0000002b, 0x00203622, 0x000 },
    { 0x00000000, 0x00600000, 0x641 },
    { 0x00000000, 0x00600000, 0x5c9 },
    { 0x98000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00804811, 0x000 },
    { 0x00000000, 0xc0600000, 0x641 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000022, 0x00204811, 0x000 },
    { 0x89000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00404811, 0x62d },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404811, 0x62d },
    { 0x00000000, 0x00600000, 0x65c },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0xc0204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x09800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68d },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000004, 0x00404c11, 0x656 },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000004, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffffb, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffff7, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x01800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004217f, 0x00604411, 0x68d },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x68c },
    { 0x00000010, 0x00404c11, 0x672 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x38c00000, 0x000 },
    { 0x0000001d, 0x00200a2d, 0x000 },
    { 0x0000001e, 0x00200e2d, 0x000 },
    { 0x0000001f, 0x0020122d, 0x000 },
    { 0x00000020, 0x0020162d, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000004, 0x00301224, 0x000 },
    { 0x00000000, 0x002f0064, 0x000 },
    { 0x00000000, 0x0cc00000, 0x68b },
    { 0x00000003, 0x00281a22, 0x000 },
    { 0x00000008, 0x00221222, 0x000 },
    { 0xfffff000, 0x00281224, 0x000 },
    { 0x00000000, 0x002910c4, 0x000 },
    { 0x0000001f, 0x00403624, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x68d },
    { 0x9f000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x690 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x692 },
    { 0x9e000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x695 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0xc0204411, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000024, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000022, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00404811, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x01420502, 0x05c00250, 0x000 },
    { 0x01c30168, 0x043f05c0, 0x000 },
    { 0x02250209, 0x02500151, 0x000 },
    { 0x02230245, 0x02a00241, 0x000 },
    { 0x03d705c0, 0x05c005c0, 0x000 },
    { 0x0649064a, 0x031f05c0, 0x000 },
    { 0x05c005c5, 0x03200340, 0x000 },
    { 0x032a0282, 0x03420334, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x05c00551, 0x05c005c0, 0x000 },
    { 0x03ba05c0, 0x04bb0344, 0x000 },
    { 0x049a0450, 0x043d05c0, 0x000 },
    { 0x04d005c0, 0x044104dd, 0x000 },
    { 0x04500507, 0x03510375, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x05c005c0, 0x063f05c7, 0x000 },
    { 0x05c005c0, 0x000705c0, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x03f803ed, 0x04080406, 0x000 },
    { 0x040e040a, 0x040c0410, 0x000 },
    { 0x041c0418, 0x04240420, 0x000 },
    { 0x042c0428, 0x04340430, 0x000 },
    { 0x05c005c0, 0x043805c0, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x05c005c0, 0x05c005c0, 0x000 },
    { 0x00020679, 0x06970006, 0x000 },
};

static const u32 RV620_pfp_microcode[]={
0xca0400,
0xa00000,
0x7e828b,
0x7c038b,
0x8001b8,
0x7c038b,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xc41838,
0xca2400,
0xca2800,
0x9581a8,
0xc41c3a,
0xc3c000,
0xca0800,
0xca0c00,
0x7c744b,
0xc20005,
0x99c000,
0xc41c3a,
0x7c744c,
0xc0fff0,
0x042c04,
0x309002,
0x7d2500,
0x351402,
0x7d350b,
0x255403,
0x7cd580,
0x259c03,
0x95c004,
0xd5001b,
0x7eddc1,
0x7d9d80,
0xd6801b,
0xd5801b,
0xd4401e,
0xd5401e,
0xd6401e,
0xd6801e,
0xd4801e,
0xd4c01e,
0x9783d3,
0xd5c01e,
0xca0800,
0x80001a,
0xca0c00,
0xe4011e,
0xd4001e,
0x80000c,
0xc41838,
0xe4013e,
0xd4001e,
0x80000c,
0xc41838,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca1800,
0xd4401e,
0xd5801e,
0x800053,
0xd40075,
0xd4401e,
0xca0800,
0xca0c00,
0xca1000,
0xd48019,
0xd4c018,
0xd50017,
0xd4801e,
0xd4c01e,
0xd5001e,
0xe2001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0xd48060,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xd48061,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xca0c00,
0xd4401e,
0xd48016,
0xd4c016,
0xd4801e,
0x8001b8,
0xd4c01e,
0xc60843,
0xca0c00,
0xca1000,
0x948004,
0xca1400,
0xe420f3,
0xd42013,
0xd56065,
0xd4e01c,
0xd5201c,
0xd5601c,
0x800000,
0x062001,
0xc60843,
0xca0c00,
0xca1000,
0x9483f7,
0xca1400,
0xe420f3,
0x800079,
0xd42013,
0xc60843,
0xca0c00,
0xca1000,
0x9883ef,
0xca1400,
0xd40064,
0x80008d,
0x000000,
0xc41432,
0xc61843,
0xc4082f,
0x954005,
0xc40c30,
0xd4401e,
0x800000,
0xee001e,
0x9583f5,
0xc41031,
0xd44033,
0xd52065,
0xd4a01c,
0xd4e01c,
0xd5201c,
0xe4015e,
0xd4001e,
0x800000,
0x062001,
0xca1800,
0x0a2001,
0xd60076,
0xc40836,
0x988007,
0xc61045,
0x950110,
0xd4001f,
0xd46062,
0x800000,
0xd42062,
0xcc3835,
0xcc1433,
0x8401bb,
0xd40072,
0xd5401e,
0x800000,
0xee001e,
0xe2001a,
0x8401bb,
0xe2001a,
0xcc104b,
0xcc0447,
0x2c9401,
0x7d098b,
0x984005,
0x7d15cb,
0xd4001a,
0x8001b8,
0xd4006d,
0x344401,
0xcc0c48,
0x98403a,
0xcc2c4a,
0x958004,
0xcc0449,
0x8001b8,
0xd4001a,
0xd4c01a,
0x282801,
0x8400f0,
0xcc1003,
0x98801b,
0x04380c,
0x8400f0,
0xcc1003,
0x988017,
0x043808,
0x8400f0,
0xcc1003,
0x988013,
0x043804,
0x8400f0,
0xcc1003,
0x988014,
0xcc104c,
0x9a8009,
0xcc144d,
0x9840dc,
0xd4006d,
0xcc1848,
0xd5001a,
0xd5401a,
0x8000c9,
0xd5801a,
0x96c0d5,
0xd4006d,
0x8001b8,
0xd4006e,
0x9ac003,
0xd4006d,
0xd4006e,
0x800000,
0xec007f,
0x9ac0cc,
0xd4006d,
0x8001b8,
0xd4006e,
0xcc1403,
0xcc1803,
0xcc1c03,
0x7d9103,
0x7dd583,
0x7d190c,
0x35cc1f,
0x35701f,
0x7cf0cb,
0x7cd08b,
0x880000,
0x7e8e8b,
0x95c004,
0xd4006e,
0x8001b8,
0xd4001a,
0xd4c01a,
0xcc0803,
0xcc0c03,
0xcc1003,
0xcc1403,
0xcc1803,
0xcc1c03,
0xcc2403,
0xcc2803,
0x35c41f,
0x36b01f,
0x7c704b,
0x34f01f,
0x7c704b,
0x35701f,
0x7c704b,
0x7d8881,
0x7dccc1,
0x7e5101,
0x7e9541,
0x7c9082,
0x7cd4c2,
0x7c848b,
0x9ac003,
0x7c8c8b,
0x2c8801,
0x98809e,
0xd4006d,
0x98409c,
0xd4006e,
0xcc084c,
0xcc0c4d,
0xcc1048,
0xd4801a,
0xd4c01a,
0x800101,
0xd5001a,
0xcc0832,
0xd40032,
0x9482d9,
0xca0c00,
0xd4401e,
0x800000,
0xd4001e,
0xe4011e,
0xd4001e,
0xca0800,
0xca0c00,
0xca1000,
0xd4401e,
0xca1400,
0xd4801e,
0xd4c01e,
0xd5001e,
0xd5401e,
0xd54034,
0x800000,
0xee001e,
0x280404,
0xe2001a,
0xe2001a,
0xd4401a,
0xca3800,
0xcc0803,
0xcc0c03,
0xcc0c03,
0xcc0c03,
0x9882bd,
0x000000,
0x8401bb,
0xd7a06f,
0x800000,
0xee001f,
0xca0400,
0xc2ff00,
0xcc0834,
0xc13fff,
0x7c74cb,
0x7cc90b,
0x7d010f,
0x9902b0,
0x7c738b,
0x8401bb,
0xd7a06f,
0x800000,
0xee001f,
0xca0800,
0x281900,
0x7d898b,
0x958014,
0x281404,
0xca0c00,
0xca1000,
0xca1c00,
0xca2400,
0xe2001f,
0xd4c01a,
0xd5001a,
0xd5401a,
0xcc1803,
0xcc2c03,
0xcc2c03,
0xcc2c03,
0x7da58b,
0x7d9c47,
0x984297,
0x000000,
0x800161,
0xd4c01a,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0x248c06,
0x0ccc06,
0x98c006,
0xcc104e,
0x990004,
0xd40073,
0xe4011e,
0xd4001e,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xca0800,
0xca0c00,
0x34d018,
0x251001,
0x950021,
0xc17fff,
0xca1000,
0xca1400,
0xca1800,
0xd4801d,
0xd4c01d,
0x7db18b,
0xc14202,
0xc2c001,
0xd5801d,
0x34dc0e,
0x7d5d4c,
0x7f734c,
0xd7401e,
0xd5001e,
0xd5401e,
0xc14200,
0xc2c000,
0x099c01,
0x31dc10,
0x7f5f4c,
0x7f734c,
0x042802,
0x7d8380,
0xd5a86f,
0xd58066,
0xd7401e,
0xec005e,
0xc82402,
0xc82402,
0x8001b8,
0xd60076,
0xd4401e,
0xd4801e,
0xd4c01e,
0x800000,
0xee001e,
0x800000,
0xee001f,
0xd4001f,
0x800000,
0xd4001f,
0xd4001f,
0x880000,
0xd4001f,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x010171,
0x020178,
0x03008f,
0x04007f,
0x050003,
0x06003f,
0x070032,
0x08012c,
0x090046,
0x0a0036,
0x1001b6,
0x1700a2,
0x22013a,
0x230149,
0x2000b4,
0x240125,
0x27004d,
0x28006a,
0x2a0060,
0x2b0052,
0x2f0065,
0x320087,
0x34017f,
0x3c0156,
0x3f0072,
0x41018c,
0x44012e,
0x550173,
0x56017a,
0x60000b,
0x610034,
0x620038,
0x630038,
0x640038,
0x650038,
0x660038,
0x670038,
0x68003a,
0x690041,
0x6a0048,
0x6b0048,
0x6c0048,
0x6d0048,
0x6e0048,
0x6f0048,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
};

static const u32 RV630_cp_microcode[][3]={
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0000ffff, 0x00284621, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000000, 0x00e00000, 0x000 },
    { 0x00010000, 0xc0294620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x00000000, 0x00600000, 0x62e },
    { 0x00000000, 0x00600000, 0x642 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000f00, 0x00281622, 0x000 },
    { 0x00000008, 0x00211625, 0x000 },
    { 0x00000018, 0x00203625, 0x000 },
    { 0x8d000000, 0x00204411, 0x000 },
    { 0x00000004, 0x002f0225, 0x000 },
    { 0x00000000, 0x0ce00000, 0x018 },
    { 0x00412000, 0x00404811, 0x019 },
    { 0x00422000, 0x00204811, 0x000 },
    { 0x8e000000, 0x00204411, 0x000 },
    { 0x00000028, 0x00204a2d, 0x000 },
    { 0x90000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x0000000c, 0x00211622, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000019, 0x00211a22, 0x000 },
    { 0x00000004, 0x00281a26, 0x000 },
    { 0x00000000, 0x002914c5, 0x000 },
    { 0x00000019, 0x00203625, 0x000 },
    { 0x00000000, 0x003a1402, 0x000 },
    { 0x00000016, 0x00211625, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0xfffffffc, 0x00280e23, 0x000 },
    { 0x00000000, 0x002914a3, 0x000 },
    { 0x00000017, 0x00203625, 0x000 },
    { 0x00008000, 0x00280e22, 0x000 },
    { 0x00000007, 0x00220e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x20000000, 0x00280e22, 0x000 },
    { 0x00000006, 0x00210e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x00000000, 0x00220222, 0x000 },
    { 0x00000000, 0x14e00000, 0x038 },
    { 0x00000000, 0x2ee00000, 0x035 },
    { 0x00000000, 0x2ce00000, 0x037 },
    { 0x00000000, 0x00400e2d, 0x039 },
    { 0x00000008, 0x00200e2d, 0x000 },
    { 0x00000009, 0x0040122d, 0x046 },
    { 0x00000001, 0x00400e2d, 0x039 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x03e },
    { 0x00000008, 0x00401c11, 0x041 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x0000000f, 0x00281e27, 0x000 },
    { 0x00000003, 0x00221e27, 0x000 },
    { 0x7fc00000, 0x00281a23, 0x000 },
    { 0x00000014, 0x00211a26, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000008, 0x00221a26, 0x000 },
    { 0x00000000, 0x00290cc7, 0x000 },
    { 0x00000027, 0x00203624, 0x000 },
    { 0x00007f00, 0x00281221, 0x000 },
    { 0x00001400, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x04b },
    { 0x00000001, 0x00290e23, 0x000 },
    { 0x0000000e, 0x00203623, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfff80000, 0x00294a23, 0x000 },
    { 0x00000000, 0x003a2c02, 0x000 },
    { 0x00000002, 0x00220e2b, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x0000000f, 0x00203623, 0x000 },
    { 0x00001fff, 0x00294a23, 0x000 },
    { 0x00000027, 0x00204a2d, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000029, 0x00200e2d, 0x000 },
    { 0x060a0200, 0x00294a23, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14e00000, 0x061 },
    { 0x00000000, 0x2ee00000, 0x05f },
    { 0x00000000, 0x2ce00000, 0x05e },
    { 0x00000000, 0x00400e2d, 0x062 },
    { 0x00000001, 0x00400e2d, 0x062 },
    { 0x0000000a, 0x00200e2d, 0x000 },
    { 0x0000000b, 0x0040122d, 0x06a },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x7fc00000, 0x00281623, 0x000 },
    { 0x00000014, 0x00211625, 0x000 },
    { 0x00000001, 0x00331625, 0x000 },
    { 0x80000000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00290ca3, 0x000 },
    { 0x3ffffc00, 0x00290e23, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x06d },
    { 0x00000100, 0x00401c11, 0x070 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x000000f0, 0x00281e27, 0x000 },
    { 0x00000004, 0x00221e27, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0xfffff0ff, 0x00281a30, 0x000 },
    { 0x0000a028, 0x00204411, 0x000 },
    { 0x00000000, 0x002948e6, 0x000 },
    { 0x0000a018, 0x00204411, 0x000 },
    { 0x3fffffff, 0x00284a23, 0x000 },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000030, 0x0020162d, 0x000 },
    { 0x00000002, 0x00291625, 0x000 },
    { 0x00000030, 0x00203625, 0x000 },
    { 0x00000025, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a3, 0x000 },
    { 0x00000000, 0x0cc00000, 0x083 },
    { 0x00000026, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a4, 0x000 },
    { 0x00000000, 0x0cc00000, 0x084 },
    { 0x00000000, 0x00400000, 0x08a },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203624, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x08a },
    { 0x00000000, 0x00600000, 0x665 },
    { 0x00000000, 0x00600000, 0x659 },
    { 0x00000002, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x08d },
    { 0x00000012, 0xc0403620, 0x093 },
    { 0x00000000, 0x2ee00000, 0x091 },
    { 0x00000000, 0x2ce00000, 0x090 },
    { 0x00000002, 0x00400e2d, 0x092 },
    { 0x00000003, 0x00400e2d, 0x092 },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000012, 0x00203623, 0x000 },
    { 0x00000003, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x098 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x0a0 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x2ee00000, 0x09e },
    { 0x00000000, 0x2ce00000, 0x09d },
    { 0x00000002, 0x00400e2d, 0x09f },
    { 0x00000003, 0x00400e2d, 0x09f },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x003f0000, 0x00280e23, 0x000 },
    { 0x00000010, 0x00210e23, 0x000 },
    { 0x00000011, 0x00203623, 0x000 },
    { 0x0000001e, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0a7 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x0000001f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0aa },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000008, 0x00210e2b, 0x000 },
    { 0x0000007f, 0x00280e23, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0e1 },
    { 0x00000000, 0x27000000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ae00000, 0x0b3 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000000c, 0x00221e30, 0x000 },
    { 0x99800000, 0x00204411, 0x000 },
    { 0x00000004, 0x0020122d, 0x000 },
    { 0x00000008, 0x00221224, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00291ce4, 0x000 },
    { 0x00000000, 0x00604807, 0x12f },
    { 0x9b000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x9c000000, 0x00204411, 0x000 },
    { 0x00000000, 0x0033146f, 0x000 },
    { 0x00000001, 0x00333e23, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0x00203c05, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e007, 0x00204411, 0x000 },
    { 0x0000000f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0cb },
    { 0x00f8ff08, 0x00204811, 0x000 },
    { 0x98000000, 0x00404811, 0x0dc },
    { 0x000000f0, 0x00280e22, 0x000 },
    { 0x000000a0, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x0da },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d5 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d4 },
    { 0x00003f00, 0x00400c11, 0x0d6 },
    { 0x00001f00, 0x00400c11, 0x0d6 },
    { 0x00000f00, 0x00200c11, 0x000 },
    { 0x00380009, 0x00294a23, 0x000 },
    { 0x3f000000, 0x00280e2b, 0x000 },
    { 0x00000002, 0x00220e23, 0x000 },
    { 0x00000007, 0x00494a23, 0x0dc },
    { 0x00380f09, 0x00204811, 0x000 },
    { 0x68000007, 0x00204811, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000a202, 0x00204411, 0x000 },
    { 0x00ff0000, 0x00280e22, 0x000 },
    { 0x00000080, 0x00294a23, 0x000 },
    { 0x00000027, 0x00200e2d, 0x000 },
    { 0x00000026, 0x0020122d, 0x000 },
    { 0x00000000, 0x002f0083, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0ea },
    { 0x00000000, 0x00600000, 0x65f },
    { 0x00000000, 0x00400000, 0x0eb },
    { 0x00000000, 0x00600000, 0x662 },
    { 0x00000007, 0x0020222d, 0x000 },
    { 0x00000005, 0x00220e22, 0x000 },
    { 0x00100000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x000000ef, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000003, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x0f8 },
    { 0x0000000b, 0x00210228, 0x000 },
    { 0x00000000, 0x14c00000, 0x0f8 },
    { 0x00000400, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000001c, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x0fd },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000001e, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x10b },
    { 0x0000a30f, 0x00204411, 0x000 },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x104 },
    { 0xffffffff, 0x00404811, 0x10b },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x107 },
    { 0x0000ffff, 0x00404811, 0x10b },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x10a },
    { 0x000000ff, 0x00404811, 0x10b },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0002c400, 0x00204411, 0x000 },
    { 0x0000001f, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x112 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000018, 0x40224a20, 0x000 },
    { 0x00000010, 0xc0424a20, 0x114 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000000a, 0x00201011, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x11b },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00531224, 0x117 },
    { 0xffbfffff, 0x00283a2e, 0x000 },
    { 0x0000001b, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x12e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0x00000018, 0x00220e30, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e00e, 0x00204411, 0x000 },
    { 0x07f8ff08, 0x00204811, 0x000 },
    { 0x00000000, 0x00294a23, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00800000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204806, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68a },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x689 },
    { 0x00000004, 0x00404c11, 0x135 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000001c, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x13c },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40280620, 0x000 },
    { 0x00000010, 0xc0210a20, 0x000 },
    { 0x00000000, 0x00341461, 0x000 },
    { 0x00000000, 0x00741882, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x147 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0681a20, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x158 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000001, 0x00300a2f, 0x000 },
    { 0x00000001, 0x00210a22, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600000, 0x18f },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00202c08, 0x000 },
    { 0x00000000, 0x00202411, 0x000 },
    { 0x00000000, 0x00202811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000002, 0x00221e29, 0x000 },
    { 0x00000000, 0x007048eb, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000001, 0x40330620, 0x000 },
    { 0x00000000, 0xc0302409, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ae00000, 0x181 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x186 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x186 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000001, 0x00530621, 0x182 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0604800, 0x197 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000011, 0x0020062d, 0x000 },
    { 0x00000000, 0x0078042a, 0x2fb },
    { 0x00000000, 0x00202809, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x174 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x194 },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x46000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x19b },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00804811, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40281620, 0x000 },
    { 0x00000010, 0xc0811a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000008, 0x00221e30, 0x000 },
    { 0x00000029, 0x00201a2d, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfffbff09, 0x00204811, 0x000 },
    { 0x0000000f, 0x0020222d, 0x000 },
    { 0x00001fff, 0x00294a28, 0x000 },
    { 0x00000006, 0x0020222d, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000100, 0x00201811, 0x000 },
    { 0x00000008, 0x00621e28, 0x12f },
    { 0x00000008, 0x00822228, 0x000 },
    { 0x0002c000, 0x00204411, 0x000 },
    { 0x00000015, 0x00600e2d, 0x1bd },
    { 0x00000016, 0x00600e2d, 0x1bd },
    { 0x0000c008, 0x00204411, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000000, 0x14c00000, 0x1b9 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x39000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00804802, 0x000 },
    { 0x00000018, 0x00202e2d, 0x000 },
    { 0x00000000, 0x003b0d63, 0x000 },
    { 0x00000008, 0x00224a23, 0x000 },
    { 0x00000010, 0x00224a23, 0x000 },
    { 0x00000018, 0x00224a23, 0x000 },
    { 0x00000000, 0x00804803, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000007, 0x0021062f, 0x000 },
    { 0x00000013, 0x00200a2d, 0x000 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000ffff, 0x40282220, 0x000 },
    { 0x0000000f, 0x00262228, 0x000 },
    { 0x00000010, 0x40212620, 0x000 },
    { 0x0000000f, 0x00262629, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1e0 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000081, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000080, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1dc },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1d8 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000001f, 0x00280a22, 0x000 },
    { 0x0000001f, 0x00282a2a, 0x000 },
    { 0x00000001, 0x00530621, 0x1d1 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000002, 0x00304a2f, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000001, 0x00301e2f, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1e5 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x0000000f, 0x00260e23, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000000f, 0x00261224, 0x000 },
    { 0x00000000, 0x00201411, 0x000 },
    { 0x00000000, 0x00601811, 0x2bb },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022b, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1f8 },
    { 0x00000010, 0x00221628, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a29, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x0020480a, 0x000 },
    { 0x00000000, 0x00202c11, 0x000 },
    { 0x00000010, 0x00221623, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a24, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x00731503, 0x205 },
    { 0x00000000, 0x00201805, 0x000 },
    { 0x00000000, 0x00731524, 0x205 },
    { 0x00000000, 0x002d14c5, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00000000, 0x00202003, 0x000 },
    { 0x00000000, 0x00802404, 0x000 },
    { 0x0000000f, 0x00210225, 0x000 },
    { 0x00000000, 0x14c00000, 0x689 },
    { 0x00000000, 0x002b1405, 0x000 },
    { 0x00000001, 0x00901625, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00294a22, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a21, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000ffff, 0x40281220, 0x000 },
    { 0x00000010, 0xc0211a20, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211620, 0x000 },
    { 0x00000000, 0x00741465, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00000001, 0x00330621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0cc00000, 0x219 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x212 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x642 },
    { 0x00000000, 0x0040040f, 0x213 },
    { 0x00000000, 0x00600000, 0x62e },
    { 0x00000000, 0x00600000, 0x642 },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00000000, 0x00600000, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ae00000, 0x232 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x236 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x236 },
    { 0x00000000, 0xc0404800, 0x233 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x00600411, 0x2fb },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x62e },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000018, 0x40210a20, 0x000 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x24c },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x00080101, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x251 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000010, 0x00600411, 0x315 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00000000, 0x00600000, 0x27c },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000001, 0x00211e27, 0x000 },
    { 0x00000000, 0x14e00000, 0x26a },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x0000ffff, 0x00281e27, 0x000 },
    { 0x00000000, 0x00341c27, 0x000 },
    { 0x00000000, 0x12c00000, 0x25f },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e5, 0x000 },
    { 0x00000000, 0x08c00000, 0x262 },
    { 0x00000000, 0x00201407, 0x000 },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00211e27, 0x000 },
    { 0x00000000, 0x00341c47, 0x000 },
    { 0x00000000, 0x12c00000, 0x267 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x08c00000, 0x26a },
    { 0x00000000, 0x00201807, 0x000 },
    { 0x00000000, 0x00600000, 0x2c1 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000000, 0x00342023, 0x000 },
    { 0x00000000, 0x12c00000, 0x272 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x271 },
    { 0x00000016, 0x00404811, 0x276 },
    { 0x00000018, 0x00404811, 0x276 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x275 },
    { 0x00000017, 0x00404811, 0x276 },
    { 0x00000019, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00604411, 0x2e9 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x256 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000010, 0x40210620, 0x000 },
    { 0x0000ffff, 0xc0280a20, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0881a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x00000000, 0x00600000, 0x62e },
    { 0x00000000, 0xc0600000, 0x2a3 },
    { 0x00000005, 0x00200a2d, 0x000 },
    { 0x00000008, 0x00220a22, 0x000 },
    { 0x0000002b, 0x00201a2d, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00007000, 0x00281e27, 0x000 },
    { 0x00000000, 0x00311ce6, 0x000 },
    { 0x0000002a, 0x00201a2d, 0x000 },
    { 0x0000000c, 0x00221a26, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x06e00000, 0x292 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00691ce2, 0x12f },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x29d },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000001c, 0x00403627, 0x000 },
    { 0x0000000c, 0xc0220a20, 0x000 },
    { 0x00000029, 0x00203622, 0x000 },
    { 0x00000028, 0xc0403620, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000009, 0x00204811, 0x000 },
    { 0xa1000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce3, 0x000 },
    { 0x00000021, 0x00203627, 0x000 },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce4, 0x000 },
    { 0x00000022, 0x00203627, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a3, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203624, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000000, 0x00311cc4, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14c00000, 0x2dc },
    { 0x00000000, 0x00400000, 0x2d9 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2d9 },
    { 0x00000003, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2dc },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e1, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a1, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e2, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000000, 0x00600000, 0x665 },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00600000, 0x65c },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2a7 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x0000001a, 0x00201e2d, 0x000 },
    { 0x0000001b, 0x0080222d, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca1, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x003808c5, 0x000 },
    { 0x00000000, 0x00300841, 0x000 },
    { 0x00000001, 0x00220a22, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000017, 0x0020222d, 0x000 },
    { 0x00000000, 0x14c00000, 0x318 },
    { 0xffffffef, 0x00280621, 0x000 },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x0000f8e0, 0x00204411, 0x000 },
    { 0x00000000, 0x00294901, 0x000 },
    { 0x00000000, 0x00894901, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00804811, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x97000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00002257, 0x00204411, 0x000 },
    { 0x00000003, 0xc0484a20, 0x000 },
    { 0x0000225d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x642 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x00000001, 0x40304a20, 0x000 },
    { 0x00000002, 0xc0304a20, 0x000 },
    { 0x00000001, 0x00530a22, 0x34b },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x354 },
    { 0x00000014, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x364 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00604802, 0x36e },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x36a },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x35f },
    { 0x00000028, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5bd },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x35f },
    { 0x0000002c, 0x00203626, 0x000 },
    { 0x00000049, 0x00201811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000000, 0x002f0226, 0x000 },
    { 0x00000000, 0x0cc00000, 0x370 },
    { 0x0000002c, 0x00801a2d, 0x000 },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x00000015, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x386 },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3b1 },
    { 0x00000016, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3b5 },
    { 0x00000020, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x39c },
    { 0x0000000f, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3a8 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3a8 },
    { 0x0000001e, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x390 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x08000000, 0x00290a22, 0x000 },
    { 0x00000003, 0x40210e20, 0x000 },
    { 0x0000000c, 0xc0211220, 0x000 },
    { 0x00080000, 0x00281224, 0x000 },
    { 0x00000014, 0xc0221620, 0x000 },
    { 0x00000000, 0x002914a4, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x002948a2, 0x000 },
    { 0x0000a1fe, 0x00204411, 0x000 },
    { 0x00000000, 0x00404803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000015, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x392 },
    { 0x0000210e, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000017, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000003, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x39e },
    { 0x00002108, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x80000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000010, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3ae },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000006, 0x00404811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x0000001d, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x3ce },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x3c0 },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0xbabecafe, 0x00204811, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000004, 0x00404811, 0x000 },
    { 0x00002170, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000a, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3d3 },
    { 0x8c000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00003fff, 0x40280a20, 0x000 },
    { 0x80000000, 0x40280e20, 0x000 },
    { 0x40000000, 0xc0281220, 0x000 },
    { 0x00040000, 0x00694622, 0x68a },
    { 0x00000000, 0x00201410, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3e1 },
    { 0x00000000, 0xc0401800, 0x3e4 },
    { 0x00003fff, 0xc0281a20, 0x000 },
    { 0x00040000, 0x00694626, 0x68a },
    { 0x00000000, 0x00201810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3e7 },
    { 0x00000000, 0xc0401c00, 0x3ea },
    { 0x00003fff, 0xc0281e20, 0x000 },
    { 0x00040000, 0x00694627, 0x68a },
    { 0x00000000, 0x00201c10, 0x000 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0x002820c5, 0x000 },
    { 0x00000000, 0x004948e8, 0x000 },
    { 0xa5800000, 0x00200811, 0x000 },
    { 0x00002000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x0000001f, 0xc0210220, 0x000 },
    { 0x00000000, 0x14c00000, 0x3f7 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000ffff, 0xc0481220, 0x3ff },
    { 0xa7800000, 0x00200811, 0x000 },
    { 0x0000a000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00304883, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xa9800000, 0x00200811, 0x000 },
    { 0x0000c000, 0x00400c11, 0x3fa },
    { 0xab800000, 0x00200811, 0x000 },
    { 0x0000f8e0, 0x00400c11, 0x3fa },
    { 0xad800000, 0x00200811, 0x000 },
    { 0x0000f880, 0x00400c11, 0x3fa },
    { 0xb3800000, 0x00200811, 0x000 },
    { 0x0000f3fc, 0x00400c11, 0x3fa },
    { 0xaf800000, 0x00200811, 0x000 },
    { 0x0000e000, 0x00400c11, 0x3fa },
    { 0xb1800000, 0x00200811, 0x000 },
    { 0x0000f000, 0x00400c11, 0x3fa },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00002148, 0x00204811, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x01182000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0218a000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0318c000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0418f8e0, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0518f880, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0618e000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0718f000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0818f3fc, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000030, 0x00200a2d, 0x000 },
    { 0x00000000, 0xc0290c40, 0x000 },
    { 0x00000030, 0x00203623, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x86000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x85000000, 0xc0204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68a },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00404c02, 0x448 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x00000000, 0xc0201400, 0x000 },
    { 0x00000000, 0xc0201800, 0x000 },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x456 },
    { 0x00000000, 0xc0202000, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x00000010, 0x00280a23, 0x000 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x45e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0x00694624, 0x68a },
    { 0x00000000, 0x00400000, 0x463 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00604805, 0x68f },
    { 0x00000000, 0x002824f0, 0x000 },
    { 0x00000007, 0x00280a23, 0x000 },
    { 0x00000001, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x46a },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x04e00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00000002, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x46f },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x02e00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x474 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ce00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x479 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ae00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00000005, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x47e },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x06e00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x483 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x08e00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x000 },
    { 0x00000008, 0x00210a23, 0x000 },
    { 0x00000000, 0x14c00000, 0x48d },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x496 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x00404c08, 0x456 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000011, 0x40211220, 0x000 },
    { 0x00000012, 0x40211620, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00210225, 0x000 },
    { 0x00000000, 0x14e00000, 0x4a0 },
    { 0x00040000, 0xc0494a20, 0x4a1 },
    { 0xfffbffff, 0xc0284a20, 0x000 },
    { 0x00000000, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x4ad },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000c, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x4a9 },
    { 0xa0000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000004, 0x00204811, 0x000 },
    { 0x0000216b, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000216c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00400000, 0x4a7 },
    { 0x00000000, 0xc0210a20, 0x000 },
    { 0x00000000, 0x14c00000, 0x4c0 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x68f },
    { 0x00000000, 0x00400000, 0x4c4 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0xc0294620, 0x000 },
    { 0x00000000, 0xc0600000, 0x68a },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x4cb },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0404810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000000, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x4cd },
    { 0x00002180, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000003, 0x00333e2f, 0x000 },
    { 0x00000001, 0x00210221, 0x000 },
    { 0x00000000, 0x14e00000, 0x4fd },
    { 0x0000002c, 0x00200a2d, 0x000 },
    { 0x00040000, 0x18e00c11, 0x4ec },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xd8c04800, 0x4e0 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000002d, 0x0020122d, 0x000 },
    { 0x00000000, 0x00290c83, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000011, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00400000, 0x4a7 },
    { 0x0000002c, 0xc0203620, 0x000 },
    { 0x0000002d, 0xc0403620, 0x000 },
    { 0x0000000f, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x502 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0xd9000000, 0x000 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xb5000000, 0x00204411, 0x000 },
    { 0x00002000, 0x00204811, 0x000 },
    { 0xb6000000, 0x00204411, 0x000 },
    { 0x0000a000, 0x00204811, 0x000 },
    { 0xb7000000, 0x00204411, 0x000 },
    { 0x0000c000, 0x00204811, 0x000 },
    { 0xb8000000, 0x00204411, 0x000 },
    { 0x0000f8e0, 0x00204811, 0x000 },
    { 0xb9000000, 0x00204411, 0x000 },
    { 0x0000f880, 0x00204811, 0x000 },
    { 0xba000000, 0x00204411, 0x000 },
    { 0x0000e000, 0x00204811, 0x000 },
    { 0xbb000000, 0x00204411, 0x000 },
    { 0x0000f000, 0x00204811, 0x000 },
    { 0xbc000000, 0x00204411, 0x000 },
    { 0x0000f3fc, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000002, 0x00204811, 0x000 },
    { 0x000000ff, 0x00280e30, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x516 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x14c00000, 0x52b },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000001c, 0x00203623, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000029, 0x00203623, 0x000 },
    { 0x00000028, 0x00203623, 0x000 },
    { 0x00000017, 0x00203623, 0x000 },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203623, 0x000 },
    { 0x00000015, 0x00203623, 0x000 },
    { 0x00000016, 0x00203623, 0x000 },
    { 0xffffe000, 0x00200c11, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203623, 0x000 },
    { 0x00001fff, 0x00200c11, 0x000 },
    { 0x00000023, 0x00203623, 0x000 },
    { 0x00000024, 0x00203623, 0x000 },
    { 0xf1ffffff, 0x00283a2e, 0x000 },
    { 0x0000001a, 0xc0220e20, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000002a, 0x40203620, 0x000 },
    { 0x87000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000030, 0x00203623, 0x000 },
    { 0x9d000000, 0x00204411, 0x000 },
    { 0x0000001f, 0x40214a20, 0x000 },
    { 0x96000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x0000001f, 0x00211624, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x0000001d, 0x00203623, 0x000 },
    { 0x00000003, 0x00281e23, 0x000 },
    { 0x00000008, 0x00222223, 0x000 },
    { 0xfffff000, 0x00282228, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x0000001f, 0x00203628, 0x000 },
    { 0x00000018, 0x00211e23, 0x000 },
    { 0x00000020, 0x00203627, 0x000 },
    { 0x00000002, 0x00221624, 0x000 },
    { 0x00000000, 0x003014a8, 0x000 },
    { 0x0000001e, 0x00203625, 0x000 },
    { 0x00000003, 0x00211a24, 0x000 },
    { 0x10000000, 0x00281a26, 0x000 },
    { 0xefffffff, 0x00283a2e, 0x000 },
    { 0x00000000, 0x004938ce, 0x678 },
    { 0x00000001, 0x40280a20, 0x000 },
    { 0x00000006, 0x40280e20, 0x000 },
    { 0x00000300, 0xc0281220, 0x000 },
    { 0x00000008, 0x00211224, 0x000 },
    { 0x00000000, 0xc0201620, 0x000 },
    { 0x00000000, 0xc0201a20, 0x000 },
    { 0x00000000, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x563 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x68a },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00020000, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56b },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x579 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56b },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x68a },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x579 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56f },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00000000, 0xc0400000, 0x579 },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x577 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x68f },
    { 0x00000000, 0x00401c10, 0x579 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x0ee00000, 0x57b },
    { 0x00000000, 0x00600000, 0x5c6 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x58c },
    { 0x0000a2b7, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2b6, 0x00604411, 0x68a },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0000a2c4, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x58a },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000001, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x59d },
    { 0x0000a2bb, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2ba, 0x00604411, 0x68a },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0000a2c5, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x59b },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000002, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5ae },
    { 0x0000a2bf, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2be, 0x00604411, 0x68a },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0000a2c6, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5ac },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x0000a2c3, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2c2, 0x00604411, 0x68a },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0000a2c7, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5bb },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x85000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x0000304a, 0x00204411, 0x000 },
    { 0x01000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00400000, 0x5c1 },
    { 0xa4000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0xc0600000, 0x5c6 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000002c, 0x00203621, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0230, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5cd },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000030, 0x00403621, 0x5e0 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00007e00, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x5e0 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a092, 0x00604411, 0x68a },
    { 0x00000031, 0x00203630, 0x000 },
    { 0x0004a093, 0x00604411, 0x68a },
    { 0x00000032, 0x00203630, 0x000 },
    { 0x0004a2b6, 0x00604411, 0x68a },
    { 0x00000033, 0x00203630, 0x000 },
    { 0x0004a2ba, 0x00604411, 0x68a },
    { 0x00000034, 0x00203630, 0x000 },
    { 0x0004a2be, 0x00604411, 0x68a },
    { 0x00000035, 0x00203630, 0x000 },
    { 0x0004a2c2, 0x00604411, 0x68a },
    { 0x00000036, 0x00203630, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x88000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000001, 0x002f0230, 0x000 },
    { 0x00000000, 0x0ce00000, 0x629 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x629 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00007e00, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x602 },
    { 0x0000a092, 0x00204411, 0x000 },
    { 0x00000031, 0x00204a2d, 0x000 },
    { 0x0000a093, 0x00204411, 0x000 },
    { 0x00000032, 0x00204a2d, 0x000 },
    { 0x0000a2b6, 0x00204411, 0x000 },
    { 0x00000033, 0x00204a2d, 0x000 },
    { 0x0000a2ba, 0x00204411, 0x000 },
    { 0x00000034, 0x00204a2d, 0x000 },
    { 0x0000a2be, 0x00204411, 0x000 },
    { 0x00000035, 0x00204a2d, 0x000 },
    { 0x0000a2c2, 0x00204411, 0x000 },
    { 0x00000036, 0x00204a2d, 0x000 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x000001ff, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x628 },
    { 0x00000000, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x60b },
    { 0x0004a003, 0x00604411, 0x68a },
    { 0x0000a003, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000001, 0x00210621, 0x000 },
    { 0x00000000, 0x14c00000, 0x610 },
    { 0x0004a010, 0x00604411, 0x68a },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000001, 0x00210621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x628 },
    { 0x0004a011, 0x00604411, 0x68a },
    { 0x0000a011, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a012, 0x00604411, 0x68a },
    { 0x0000a012, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a013, 0x00604411, 0x68a },
    { 0x0000a013, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a014, 0x00604411, 0x68a },
    { 0x0000a014, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a015, 0x00604411, 0x68a },
    { 0x0000a015, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a016, 0x00604411, 0x68a },
    { 0x0000a016, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a017, 0x00604411, 0x68a },
    { 0x0000a017, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0000002c, 0x0080062d, 0x000 },
    { 0xff000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000002, 0x00804811, 0x000 },
    { 0x00000000, 0x0ee00000, 0x63a },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00000002, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x638 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x00001000, 0x00200811, 0x000 },
    { 0x0000002b, 0x00203622, 0x000 },
    { 0x00000000, 0x00600000, 0x63e },
    { 0x00000000, 0x00600000, 0x5c6 },
    { 0x98000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00804811, 0x000 },
    { 0x00000000, 0xc0600000, 0x63e },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000022, 0x00204811, 0x000 },
    { 0x89000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00404811, 0x62a },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404811, 0x62a },
    { 0x00000000, 0x00600000, 0x659 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0xc0204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x09800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68a },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000004, 0x00404c11, 0x653 },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000004, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffffb, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffff7, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x01800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004217f, 0x00604411, 0x68a },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x689 },
    { 0x00000010, 0x00404c11, 0x66f },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x38c00000, 0x000 },
    { 0x0000001d, 0x00200a2d, 0x000 },
    { 0x0000001e, 0x00200e2d, 0x000 },
    { 0x0000001f, 0x0020122d, 0x000 },
    { 0x00000020, 0x0020162d, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000004, 0x00301224, 0x000 },
    { 0x00000000, 0x002f0064, 0x000 },
    { 0x00000000, 0x0cc00000, 0x688 },
    { 0x00000003, 0x00281a22, 0x000 },
    { 0x00000008, 0x00221222, 0x000 },
    { 0xfffff000, 0x00281224, 0x000 },
    { 0x00000000, 0x002910c4, 0x000 },
    { 0x0000001f, 0x00403624, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x68a },
    { 0x9f000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x68d },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x68f },
    { 0x9e000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x692 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0xc0204411, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000024, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000022, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00404811, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x014204ff, 0x05bd0250, 0x000 },
    { 0x01c30168, 0x043f05bd, 0x000 },
    { 0x02250209, 0x02500151, 0x000 },
    { 0x02230245, 0x02a00241, 0x000 },
    { 0x03d705bd, 0x05bd05bd, 0x000 },
    { 0x06460647, 0x031f05bd, 0x000 },
    { 0x05bd05c2, 0x03200340, 0x000 },
    { 0x032a0282, 0x03420334, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x05bd054e, 0x05bd05bd, 0x000 },
    { 0x03ba05bd, 0x04b80344, 0x000 },
    { 0x0497044d, 0x043d05bd, 0x000 },
    { 0x04cd05bd, 0x044104da, 0x000 },
    { 0x044d0504, 0x03510375, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x05bd05bd, 0x063c05c4, 0x000 },
    { 0x05bd05bd, 0x000705bd, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x03f803ed, 0x04080406, 0x000 },
    { 0x040e040a, 0x040c0410, 0x000 },
    { 0x041c0418, 0x04240420, 0x000 },
    { 0x042c0428, 0x04340430, 0x000 },
    { 0x05bd05bd, 0x043805bd, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x00020676, 0x06940006, 0x000 },
};

static const u32 RV630_pfp_microcode[]={
0xca0400,
0xa00000,
0x7e828b,
0x7c038b,
0x8001b8,
0x7c038b,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xc41838,
0xca2400,
0xca2800,
0x9581a8,
0xc41c3a,
0xc3c000,
0xca0800,
0xca0c00,
0x7c744b,
0xc20005,
0x99c000,
0xc41c3a,
0x7c744c,
0xc0fff0,
0x042c04,
0x309002,
0x7d2500,
0x351402,
0x7d350b,
0x255403,
0x7cd580,
0x259c03,
0x95c004,
0xd5001b,
0x7eddc1,
0x7d9d80,
0xd6801b,
0xd5801b,
0xd4401e,
0xd5401e,
0xd6401e,
0xd6801e,
0xd4801e,
0xd4c01e,
0x9783d3,
0xd5c01e,
0xca0800,
0x80001a,
0xca0c00,
0xe4011e,
0xd4001e,
0x80000c,
0xc41838,
0xe4013e,
0xd4001e,
0x80000c,
0xc41838,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca1800,
0xd4401e,
0xd5801e,
0x800053,
0xd40075,
0xd4401e,
0xca0800,
0xca0c00,
0xca1000,
0xd48019,
0xd4c018,
0xd50017,
0xd4801e,
0xd4c01e,
0xd5001e,
0xe2001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0xd48060,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xd48061,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xca0c00,
0xd4401e,
0xd48016,
0xd4c016,
0xd4801e,
0x8001b8,
0xd4c01e,
0xc60843,
0xca0c00,
0xca1000,
0x948004,
0xca1400,
0xe420f3,
0xd42013,
0xd56065,
0xd4e01c,
0xd5201c,
0xd5601c,
0x800000,
0x062001,
0xc60843,
0xca0c00,
0xca1000,
0x9483f7,
0xca1400,
0xe420f3,
0x800079,
0xd42013,
0xc60843,
0xca0c00,
0xca1000,
0x9883ef,
0xca1400,
0xd40064,
0x80008d,
0x000000,
0xc41432,
0xc61843,
0xc4082f,
0x954005,
0xc40c30,
0xd4401e,
0x800000,
0xee001e,
0x9583f5,
0xc41031,
0xd44033,
0xd52065,
0xd4a01c,
0xd4e01c,
0xd5201c,
0xe4015e,
0xd4001e,
0x800000,
0x062001,
0xca1800,
0x0a2001,
0xd60076,
0xc40836,
0x988007,
0xc61045,
0x950110,
0xd4001f,
0xd46062,
0x800000,
0xd42062,
0xcc3835,
0xcc1433,
0x8401bb,
0xd40072,
0xd5401e,
0x800000,
0xee001e,
0xe2001a,
0x8401bb,
0xe2001a,
0xcc104b,
0xcc0447,
0x2c9401,
0x7d098b,
0x984005,
0x7d15cb,
0xd4001a,
0x8001b8,
0xd4006d,
0x344401,
0xcc0c48,
0x98403a,
0xcc2c4a,
0x958004,
0xcc0449,
0x8001b8,
0xd4001a,
0xd4c01a,
0x282801,
0x8400f0,
0xcc1003,
0x98801b,
0x04380c,
0x8400f0,
0xcc1003,
0x988017,
0x043808,
0x8400f0,
0xcc1003,
0x988013,
0x043804,
0x8400f0,
0xcc1003,
0x988014,
0xcc104c,
0x9a8009,
0xcc144d,
0x9840dc,
0xd4006d,
0xcc1848,
0xd5001a,
0xd5401a,
0x8000c9,
0xd5801a,
0x96c0d5,
0xd4006d,
0x8001b8,
0xd4006e,
0x9ac003,
0xd4006d,
0xd4006e,
0x800000,
0xec007f,
0x9ac0cc,
0xd4006d,
0x8001b8,
0xd4006e,
0xcc1403,
0xcc1803,
0xcc1c03,
0x7d9103,
0x7dd583,
0x7d190c,
0x35cc1f,
0x35701f,
0x7cf0cb,
0x7cd08b,
0x880000,
0x7e8e8b,
0x95c004,
0xd4006e,
0x8001b8,
0xd4001a,
0xd4c01a,
0xcc0803,
0xcc0c03,
0xcc1003,
0xcc1403,
0xcc1803,
0xcc1c03,
0xcc2403,
0xcc2803,
0x35c41f,
0x36b01f,
0x7c704b,
0x34f01f,
0x7c704b,
0x35701f,
0x7c704b,
0x7d8881,
0x7dccc1,
0x7e5101,
0x7e9541,
0x7c9082,
0x7cd4c2,
0x7c848b,
0x9ac003,
0x7c8c8b,
0x2c8801,
0x98809e,
0xd4006d,
0x98409c,
0xd4006e,
0xcc084c,
0xcc0c4d,
0xcc1048,
0xd4801a,
0xd4c01a,
0x800101,
0xd5001a,
0xcc0832,
0xd40032,
0x9482d9,
0xca0c00,
0xd4401e,
0x800000,
0xd4001e,
0xe4011e,
0xd4001e,
0xca0800,
0xca0c00,
0xca1000,
0xd4401e,
0xca1400,
0xd4801e,
0xd4c01e,
0xd5001e,
0xd5401e,
0xd54034,
0x800000,
0xee001e,
0x280404,
0xe2001a,
0xe2001a,
0xd4401a,
0xca3800,
0xcc0803,
0xcc0c03,
0xcc0c03,
0xcc0c03,
0x9882bd,
0x000000,
0x8401bb,
0xd7a06f,
0x800000,
0xee001f,
0xca0400,
0xc2ff00,
0xcc0834,
0xc13fff,
0x7c74cb,
0x7cc90b,
0x7d010f,
0x9902b0,
0x7c738b,
0x8401bb,
0xd7a06f,
0x800000,
0xee001f,
0xca0800,
0x281900,
0x7d898b,
0x958014,
0x281404,
0xca0c00,
0xca1000,
0xca1c00,
0xca2400,
0xe2001f,
0xd4c01a,
0xd5001a,
0xd5401a,
0xcc1803,
0xcc2c03,
0xcc2c03,
0xcc2c03,
0x7da58b,
0x7d9c47,
0x984297,
0x000000,
0x800161,
0xd4c01a,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0x248c06,
0x0ccc06,
0x98c006,
0xcc104e,
0x990004,
0xd40073,
0xe4011e,
0xd4001e,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xca0800,
0xca0c00,
0x34d018,
0x251001,
0x950021,
0xc17fff,
0xca1000,
0xca1400,
0xca1800,
0xd4801d,
0xd4c01d,
0x7db18b,
0xc14202,
0xc2c001,
0xd5801d,
0x34dc0e,
0x7d5d4c,
0x7f734c,
0xd7401e,
0xd5001e,
0xd5401e,
0xc14200,
0xc2c000,
0x099c01,
0x31dc10,
0x7f5f4c,
0x7f734c,
0x042802,
0x7d8380,
0xd5a86f,
0xd58066,
0xd7401e,
0xec005e,
0xc82402,
0xc82402,
0x8001b8,
0xd60076,
0xd4401e,
0xd4801e,
0xd4c01e,
0x800000,
0xee001e,
0x800000,
0xee001f,
0xd4001f,
0x800000,
0xd4001f,
0xd4001f,
0x880000,
0xd4001f,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x010171,
0x020178,
0x03008f,
0x04007f,
0x050003,
0x06003f,
0x070032,
0x08012c,
0x090046,
0x0a0036,
0x1001b6,
0x1700a2,
0x22013a,
0x230149,
0x2000b4,
0x240125,
0x27004d,
0x28006a,
0x2a0060,
0x2b0052,
0x2f0065,
0x320087,
0x34017f,
0x3c0156,
0x3f0072,
0x41018c,
0x44012e,
0x550173,
0x56017a,
0x60000b,
0x610034,
0x620038,
0x630038,
0x640038,
0x650038,
0x660038,
0x670038,
0x68003a,
0x690041,
0x6a0048,
0x6b0048,
0x6c0048,
0x6d0048,
0x6e0048,
0x6f0048,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
};

static const u32 RV635_cp_microcode[][3]={
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0000ffff, 0x00284621, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000000, 0x00e00000, 0x000 },
    { 0x00010000, 0xc0294620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x00000000, 0x00600000, 0x62e },
    { 0x00000000, 0x00600000, 0x642 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000f00, 0x00281622, 0x000 },
    { 0x00000008, 0x00211625, 0x000 },
    { 0x00000018, 0x00203625, 0x000 },
    { 0x8d000000, 0x00204411, 0x000 },
    { 0x00000004, 0x002f0225, 0x000 },
    { 0x00000000, 0x0ce00000, 0x018 },
    { 0x00412000, 0x00404811, 0x019 },
    { 0x00422000, 0x00204811, 0x000 },
    { 0x8e000000, 0x00204411, 0x000 },
    { 0x00000028, 0x00204a2d, 0x000 },
    { 0x90000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x0000000c, 0x00211622, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000019, 0x00211a22, 0x000 },
    { 0x00000004, 0x00281a26, 0x000 },
    { 0x00000000, 0x002914c5, 0x000 },
    { 0x00000019, 0x00203625, 0x000 },
    { 0x00000000, 0x003a1402, 0x000 },
    { 0x00000016, 0x00211625, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0xfffffffc, 0x00280e23, 0x000 },
    { 0x00000000, 0x002914a3, 0x000 },
    { 0x00000017, 0x00203625, 0x000 },
    { 0x00008000, 0x00280e22, 0x000 },
    { 0x00000007, 0x00220e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x20000000, 0x00280e22, 0x000 },
    { 0x00000006, 0x00210e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x00000000, 0x00220222, 0x000 },
    { 0x00000000, 0x14e00000, 0x038 },
    { 0x00000000, 0x2ee00000, 0x035 },
    { 0x00000000, 0x2ce00000, 0x037 },
    { 0x00000000, 0x00400e2d, 0x039 },
    { 0x00000008, 0x00200e2d, 0x000 },
    { 0x00000009, 0x0040122d, 0x046 },
    { 0x00000001, 0x00400e2d, 0x039 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x03e },
    { 0x00000008, 0x00401c11, 0x041 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x0000000f, 0x00281e27, 0x000 },
    { 0x00000003, 0x00221e27, 0x000 },
    { 0x7fc00000, 0x00281a23, 0x000 },
    { 0x00000014, 0x00211a26, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000008, 0x00221a26, 0x000 },
    { 0x00000000, 0x00290cc7, 0x000 },
    { 0x00000027, 0x00203624, 0x000 },
    { 0x00007f00, 0x00281221, 0x000 },
    { 0x00001400, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x04b },
    { 0x00000001, 0x00290e23, 0x000 },
    { 0x0000000e, 0x00203623, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfff80000, 0x00294a23, 0x000 },
    { 0x00000000, 0x003a2c02, 0x000 },
    { 0x00000002, 0x00220e2b, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x0000000f, 0x00203623, 0x000 },
    { 0x00001fff, 0x00294a23, 0x000 },
    { 0x00000027, 0x00204a2d, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000029, 0x00200e2d, 0x000 },
    { 0x060a0200, 0x00294a23, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14e00000, 0x061 },
    { 0x00000000, 0x2ee00000, 0x05f },
    { 0x00000000, 0x2ce00000, 0x05e },
    { 0x00000000, 0x00400e2d, 0x062 },
    { 0x00000001, 0x00400e2d, 0x062 },
    { 0x0000000a, 0x00200e2d, 0x000 },
    { 0x0000000b, 0x0040122d, 0x06a },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x7fc00000, 0x00281623, 0x000 },
    { 0x00000014, 0x00211625, 0x000 },
    { 0x00000001, 0x00331625, 0x000 },
    { 0x80000000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00290ca3, 0x000 },
    { 0x3ffffc00, 0x00290e23, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x06d },
    { 0x00000100, 0x00401c11, 0x070 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x000000f0, 0x00281e27, 0x000 },
    { 0x00000004, 0x00221e27, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0xfffff0ff, 0x00281a30, 0x000 },
    { 0x0000a028, 0x00204411, 0x000 },
    { 0x00000000, 0x002948e6, 0x000 },
    { 0x0000a018, 0x00204411, 0x000 },
    { 0x3fffffff, 0x00284a23, 0x000 },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000030, 0x0020162d, 0x000 },
    { 0x00000002, 0x00291625, 0x000 },
    { 0x00000030, 0x00203625, 0x000 },
    { 0x00000025, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a3, 0x000 },
    { 0x00000000, 0x0cc00000, 0x083 },
    { 0x00000026, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a4, 0x000 },
    { 0x00000000, 0x0cc00000, 0x084 },
    { 0x00000000, 0x00400000, 0x08a },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203624, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x08a },
    { 0x00000000, 0x00600000, 0x665 },
    { 0x00000000, 0x00600000, 0x659 },
    { 0x00000002, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x08d },
    { 0x00000012, 0xc0403620, 0x093 },
    { 0x00000000, 0x2ee00000, 0x091 },
    { 0x00000000, 0x2ce00000, 0x090 },
    { 0x00000002, 0x00400e2d, 0x092 },
    { 0x00000003, 0x00400e2d, 0x092 },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000012, 0x00203623, 0x000 },
    { 0x00000003, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x098 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x0a0 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x2ee00000, 0x09e },
    { 0x00000000, 0x2ce00000, 0x09d },
    { 0x00000002, 0x00400e2d, 0x09f },
    { 0x00000003, 0x00400e2d, 0x09f },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x003f0000, 0x00280e23, 0x000 },
    { 0x00000010, 0x00210e23, 0x000 },
    { 0x00000011, 0x00203623, 0x000 },
    { 0x0000001e, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0a7 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x0000001f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0aa },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000008, 0x00210e2b, 0x000 },
    { 0x0000007f, 0x00280e23, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0e1 },
    { 0x00000000, 0x27000000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ae00000, 0x0b3 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000000c, 0x00221e30, 0x000 },
    { 0x99800000, 0x00204411, 0x000 },
    { 0x00000004, 0x0020122d, 0x000 },
    { 0x00000008, 0x00221224, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00291ce4, 0x000 },
    { 0x00000000, 0x00604807, 0x12f },
    { 0x9b000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x9c000000, 0x00204411, 0x000 },
    { 0x00000000, 0x0033146f, 0x000 },
    { 0x00000001, 0x00333e23, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0x00203c05, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e007, 0x00204411, 0x000 },
    { 0x0000000f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0cb },
    { 0x00f8ff08, 0x00204811, 0x000 },
    { 0x98000000, 0x00404811, 0x0dc },
    { 0x000000f0, 0x00280e22, 0x000 },
    { 0x000000a0, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x0da },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d5 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d4 },
    { 0x00003f00, 0x00400c11, 0x0d6 },
    { 0x00001f00, 0x00400c11, 0x0d6 },
    { 0x00000f00, 0x00200c11, 0x000 },
    { 0x00380009, 0x00294a23, 0x000 },
    { 0x3f000000, 0x00280e2b, 0x000 },
    { 0x00000002, 0x00220e23, 0x000 },
    { 0x00000007, 0x00494a23, 0x0dc },
    { 0x00380f09, 0x00204811, 0x000 },
    { 0x68000007, 0x00204811, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000a202, 0x00204411, 0x000 },
    { 0x00ff0000, 0x00280e22, 0x000 },
    { 0x00000080, 0x00294a23, 0x000 },
    { 0x00000027, 0x00200e2d, 0x000 },
    { 0x00000026, 0x0020122d, 0x000 },
    { 0x00000000, 0x002f0083, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0ea },
    { 0x00000000, 0x00600000, 0x65f },
    { 0x00000000, 0x00400000, 0x0eb },
    { 0x00000000, 0x00600000, 0x662 },
    { 0x00000007, 0x0020222d, 0x000 },
    { 0x00000005, 0x00220e22, 0x000 },
    { 0x00100000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x000000ef, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000003, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x0f8 },
    { 0x0000000b, 0x00210228, 0x000 },
    { 0x00000000, 0x14c00000, 0x0f8 },
    { 0x00000400, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000001c, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x0fd },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000001e, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x10b },
    { 0x0000a30f, 0x00204411, 0x000 },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x104 },
    { 0xffffffff, 0x00404811, 0x10b },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x107 },
    { 0x0000ffff, 0x00404811, 0x10b },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x10a },
    { 0x000000ff, 0x00404811, 0x10b },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0002c400, 0x00204411, 0x000 },
    { 0x0000001f, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x112 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000018, 0x40224a20, 0x000 },
    { 0x00000010, 0xc0424a20, 0x114 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000000a, 0x00201011, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x11b },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00531224, 0x117 },
    { 0xffbfffff, 0x00283a2e, 0x000 },
    { 0x0000001b, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x12e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0x00000018, 0x00220e30, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e00e, 0x00204411, 0x000 },
    { 0x07f8ff08, 0x00204811, 0x000 },
    { 0x00000000, 0x00294a23, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00800000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204806, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68a },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x689 },
    { 0x00000004, 0x00404c11, 0x135 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000001c, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x13c },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40280620, 0x000 },
    { 0x00000010, 0xc0210a20, 0x000 },
    { 0x00000000, 0x00341461, 0x000 },
    { 0x00000000, 0x00741882, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x147 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0681a20, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x158 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000001, 0x00300a2f, 0x000 },
    { 0x00000001, 0x00210a22, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600000, 0x18f },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00202c08, 0x000 },
    { 0x00000000, 0x00202411, 0x000 },
    { 0x00000000, 0x00202811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000002, 0x00221e29, 0x000 },
    { 0x00000000, 0x007048eb, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000001, 0x40330620, 0x000 },
    { 0x00000000, 0xc0302409, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ae00000, 0x181 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x186 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x186 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000001, 0x00530621, 0x182 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0604800, 0x197 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000011, 0x0020062d, 0x000 },
    { 0x00000000, 0x0078042a, 0x2fb },
    { 0x00000000, 0x00202809, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x174 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x194 },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x46000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x19b },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00804811, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40281620, 0x000 },
    { 0x00000010, 0xc0811a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000008, 0x00221e30, 0x000 },
    { 0x00000029, 0x00201a2d, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfffbff09, 0x00204811, 0x000 },
    { 0x0000000f, 0x0020222d, 0x000 },
    { 0x00001fff, 0x00294a28, 0x000 },
    { 0x00000006, 0x0020222d, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000100, 0x00201811, 0x000 },
    { 0x00000008, 0x00621e28, 0x12f },
    { 0x00000008, 0x00822228, 0x000 },
    { 0x0002c000, 0x00204411, 0x000 },
    { 0x00000015, 0x00600e2d, 0x1bd },
    { 0x00000016, 0x00600e2d, 0x1bd },
    { 0x0000c008, 0x00204411, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000000, 0x14c00000, 0x1b9 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x39000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00804802, 0x000 },
    { 0x00000018, 0x00202e2d, 0x000 },
    { 0x00000000, 0x003b0d63, 0x000 },
    { 0x00000008, 0x00224a23, 0x000 },
    { 0x00000010, 0x00224a23, 0x000 },
    { 0x00000018, 0x00224a23, 0x000 },
    { 0x00000000, 0x00804803, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000007, 0x0021062f, 0x000 },
    { 0x00000013, 0x00200a2d, 0x000 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000ffff, 0x40282220, 0x000 },
    { 0x0000000f, 0x00262228, 0x000 },
    { 0x00000010, 0x40212620, 0x000 },
    { 0x0000000f, 0x00262629, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1e0 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000081, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000080, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1dc },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1d8 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000001f, 0x00280a22, 0x000 },
    { 0x0000001f, 0x00282a2a, 0x000 },
    { 0x00000001, 0x00530621, 0x1d1 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000002, 0x00304a2f, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000001, 0x00301e2f, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1e5 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x0000000f, 0x00260e23, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000000f, 0x00261224, 0x000 },
    { 0x00000000, 0x00201411, 0x000 },
    { 0x00000000, 0x00601811, 0x2bb },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022b, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1f8 },
    { 0x00000010, 0x00221628, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a29, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x0020480a, 0x000 },
    { 0x00000000, 0x00202c11, 0x000 },
    { 0x00000010, 0x00221623, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a24, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x00731503, 0x205 },
    { 0x00000000, 0x00201805, 0x000 },
    { 0x00000000, 0x00731524, 0x205 },
    { 0x00000000, 0x002d14c5, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00000000, 0x00202003, 0x000 },
    { 0x00000000, 0x00802404, 0x000 },
    { 0x0000000f, 0x00210225, 0x000 },
    { 0x00000000, 0x14c00000, 0x689 },
    { 0x00000000, 0x002b1405, 0x000 },
    { 0x00000001, 0x00901625, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00294a22, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a21, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000ffff, 0x40281220, 0x000 },
    { 0x00000010, 0xc0211a20, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211620, 0x000 },
    { 0x00000000, 0x00741465, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00000001, 0x00330621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0cc00000, 0x219 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x212 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x642 },
    { 0x00000000, 0x0040040f, 0x213 },
    { 0x00000000, 0x00600000, 0x62e },
    { 0x00000000, 0x00600000, 0x642 },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00000000, 0x00600000, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ae00000, 0x232 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x236 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x236 },
    { 0x00000000, 0xc0404800, 0x233 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x00600411, 0x2fb },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x62e },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000018, 0x40210a20, 0x000 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x24c },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x00080101, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x251 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000010, 0x00600411, 0x315 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00000000, 0x00600000, 0x27c },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000001, 0x00211e27, 0x000 },
    { 0x00000000, 0x14e00000, 0x26a },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x0000ffff, 0x00281e27, 0x000 },
    { 0x00000000, 0x00341c27, 0x000 },
    { 0x00000000, 0x12c00000, 0x25f },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e5, 0x000 },
    { 0x00000000, 0x08c00000, 0x262 },
    { 0x00000000, 0x00201407, 0x000 },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00211e27, 0x000 },
    { 0x00000000, 0x00341c47, 0x000 },
    { 0x00000000, 0x12c00000, 0x267 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x08c00000, 0x26a },
    { 0x00000000, 0x00201807, 0x000 },
    { 0x00000000, 0x00600000, 0x2c1 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000000, 0x00342023, 0x000 },
    { 0x00000000, 0x12c00000, 0x272 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x271 },
    { 0x00000016, 0x00404811, 0x276 },
    { 0x00000018, 0x00404811, 0x276 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x275 },
    { 0x00000017, 0x00404811, 0x276 },
    { 0x00000019, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00604411, 0x2e9 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x256 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000010, 0x40210620, 0x000 },
    { 0x0000ffff, 0xc0280a20, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0881a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x00000000, 0x00600000, 0x62e },
    { 0x00000000, 0xc0600000, 0x2a3 },
    { 0x00000005, 0x00200a2d, 0x000 },
    { 0x00000008, 0x00220a22, 0x000 },
    { 0x0000002b, 0x00201a2d, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00007000, 0x00281e27, 0x000 },
    { 0x00000000, 0x00311ce6, 0x000 },
    { 0x0000002a, 0x00201a2d, 0x000 },
    { 0x0000000c, 0x00221a26, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x06e00000, 0x292 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00691ce2, 0x12f },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x29d },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000001c, 0x00403627, 0x000 },
    { 0x0000000c, 0xc0220a20, 0x000 },
    { 0x00000029, 0x00203622, 0x000 },
    { 0x00000028, 0xc0403620, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000009, 0x00204811, 0x000 },
    { 0xa1000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce3, 0x000 },
    { 0x00000021, 0x00203627, 0x000 },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce4, 0x000 },
    { 0x00000022, 0x00203627, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a3, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203624, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000000, 0x00311cc4, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14c00000, 0x2dc },
    { 0x00000000, 0x00400000, 0x2d9 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2d9 },
    { 0x00000003, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2dc },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e1, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a1, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e2, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000000, 0x00600000, 0x665 },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00600000, 0x65c },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2a7 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x0000001a, 0x00201e2d, 0x000 },
    { 0x0000001b, 0x0080222d, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca1, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x003808c5, 0x000 },
    { 0x00000000, 0x00300841, 0x000 },
    { 0x00000001, 0x00220a22, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000017, 0x0020222d, 0x000 },
    { 0x00000000, 0x14c00000, 0x318 },
    { 0xffffffef, 0x00280621, 0x000 },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x0000f8e0, 0x00204411, 0x000 },
    { 0x00000000, 0x00294901, 0x000 },
    { 0x00000000, 0x00894901, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00804811, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x97000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00002257, 0x00204411, 0x000 },
    { 0x00000003, 0xc0484a20, 0x000 },
    { 0x0000225d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x642 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x00000001, 0x40304a20, 0x000 },
    { 0x00000002, 0xc0304a20, 0x000 },
    { 0x00000001, 0x00530a22, 0x34b },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x354 },
    { 0x00000014, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x364 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00604802, 0x36e },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x36a },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x35f },
    { 0x00000028, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5bd },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x35f },
    { 0x0000002c, 0x00203626, 0x000 },
    { 0x00000049, 0x00201811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000000, 0x002f0226, 0x000 },
    { 0x00000000, 0x0cc00000, 0x370 },
    { 0x0000002c, 0x00801a2d, 0x000 },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x00000015, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x386 },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3b1 },
    { 0x00000016, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3b5 },
    { 0x00000020, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x39c },
    { 0x0000000f, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3a8 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3a8 },
    { 0x0000001e, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x390 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x08000000, 0x00290a22, 0x000 },
    { 0x00000003, 0x40210e20, 0x000 },
    { 0x0000000c, 0xc0211220, 0x000 },
    { 0x00080000, 0x00281224, 0x000 },
    { 0x00000014, 0xc0221620, 0x000 },
    { 0x00000000, 0x002914a4, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x002948a2, 0x000 },
    { 0x0000a1fe, 0x00204411, 0x000 },
    { 0x00000000, 0x00404803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000015, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x392 },
    { 0x0000210e, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000017, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000003, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x39e },
    { 0x00002108, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x80000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000010, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3ae },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000006, 0x00404811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x0000001d, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x3ce },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x3c0 },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0xbabecafe, 0x00204811, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000004, 0x00404811, 0x000 },
    { 0x00002170, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000a, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3d3 },
    { 0x8c000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00003fff, 0x40280a20, 0x000 },
    { 0x80000000, 0x40280e20, 0x000 },
    { 0x40000000, 0xc0281220, 0x000 },
    { 0x00040000, 0x00694622, 0x68a },
    { 0x00000000, 0x00201410, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3e1 },
    { 0x00000000, 0xc0401800, 0x3e4 },
    { 0x00003fff, 0xc0281a20, 0x000 },
    { 0x00040000, 0x00694626, 0x68a },
    { 0x00000000, 0x00201810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3e7 },
    { 0x00000000, 0xc0401c00, 0x3ea },
    { 0x00003fff, 0xc0281e20, 0x000 },
    { 0x00040000, 0x00694627, 0x68a },
    { 0x00000000, 0x00201c10, 0x000 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0x002820c5, 0x000 },
    { 0x00000000, 0x004948e8, 0x000 },
    { 0xa5800000, 0x00200811, 0x000 },
    { 0x00002000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x0000001f, 0xc0210220, 0x000 },
    { 0x00000000, 0x14c00000, 0x3f7 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000ffff, 0xc0481220, 0x3ff },
    { 0xa7800000, 0x00200811, 0x000 },
    { 0x0000a000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00304883, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xa9800000, 0x00200811, 0x000 },
    { 0x0000c000, 0x00400c11, 0x3fa },
    { 0xab800000, 0x00200811, 0x000 },
    { 0x0000f8e0, 0x00400c11, 0x3fa },
    { 0xad800000, 0x00200811, 0x000 },
    { 0x0000f880, 0x00400c11, 0x3fa },
    { 0xb3800000, 0x00200811, 0x000 },
    { 0x0000f3fc, 0x00400c11, 0x3fa },
    { 0xaf800000, 0x00200811, 0x000 },
    { 0x0000e000, 0x00400c11, 0x3fa },
    { 0xb1800000, 0x00200811, 0x000 },
    { 0x0000f000, 0x00400c11, 0x3fa },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00002148, 0x00204811, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x01182000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0218a000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0318c000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0418f8e0, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0518f880, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0618e000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0718f000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0818f3fc, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000030, 0x00200a2d, 0x000 },
    { 0x00000000, 0xc0290c40, 0x000 },
    { 0x00000030, 0x00203623, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x86000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x85000000, 0xc0204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68a },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00404c02, 0x448 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x00000000, 0xc0201400, 0x000 },
    { 0x00000000, 0xc0201800, 0x000 },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x456 },
    { 0x00000000, 0xc0202000, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x00000010, 0x00280a23, 0x000 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x45e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0x00694624, 0x68a },
    { 0x00000000, 0x00400000, 0x463 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00604805, 0x68f },
    { 0x00000000, 0x002824f0, 0x000 },
    { 0x00000007, 0x00280a23, 0x000 },
    { 0x00000001, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x46a },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x04e00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00000002, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x46f },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x02e00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x474 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ce00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x479 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ae00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00000005, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x47e },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x06e00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x483 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x08e00000, 0x483 },
    { 0x00000000, 0x00400000, 0x490 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x000 },
    { 0x00000008, 0x00210a23, 0x000 },
    { 0x00000000, 0x14c00000, 0x48d },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x496 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x00404c08, 0x456 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000011, 0x40211220, 0x000 },
    { 0x00000012, 0x40211620, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00210225, 0x000 },
    { 0x00000000, 0x14e00000, 0x4a0 },
    { 0x00040000, 0xc0494a20, 0x4a1 },
    { 0xfffbffff, 0xc0284a20, 0x000 },
    { 0x00000000, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x4ad },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000c, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x4a9 },
    { 0xa0000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000004, 0x00204811, 0x000 },
    { 0x0000216b, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000216c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00400000, 0x4a7 },
    { 0x00000000, 0xc0210a20, 0x000 },
    { 0x00000000, 0x14c00000, 0x4c0 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x68f },
    { 0x00000000, 0x00400000, 0x4c4 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0xc0294620, 0x000 },
    { 0x00000000, 0xc0600000, 0x68a },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x4cb },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0404810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x68a },
    { 0x00000000, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x4cd },
    { 0x00002180, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000003, 0x00333e2f, 0x000 },
    { 0x00000001, 0x00210221, 0x000 },
    { 0x00000000, 0x14e00000, 0x4fd },
    { 0x0000002c, 0x00200a2d, 0x000 },
    { 0x00040000, 0x18e00c11, 0x4ec },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xd8c04800, 0x4e0 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000002d, 0x0020122d, 0x000 },
    { 0x00000000, 0x00290c83, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000011, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00400000, 0x4a7 },
    { 0x0000002c, 0xc0203620, 0x000 },
    { 0x0000002d, 0xc0403620, 0x000 },
    { 0x0000000f, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x502 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0xd9000000, 0x000 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xb5000000, 0x00204411, 0x000 },
    { 0x00002000, 0x00204811, 0x000 },
    { 0xb6000000, 0x00204411, 0x000 },
    { 0x0000a000, 0x00204811, 0x000 },
    { 0xb7000000, 0x00204411, 0x000 },
    { 0x0000c000, 0x00204811, 0x000 },
    { 0xb8000000, 0x00204411, 0x000 },
    { 0x0000f8e0, 0x00204811, 0x000 },
    { 0xb9000000, 0x00204411, 0x000 },
    { 0x0000f880, 0x00204811, 0x000 },
    { 0xba000000, 0x00204411, 0x000 },
    { 0x0000e000, 0x00204811, 0x000 },
    { 0xbb000000, 0x00204411, 0x000 },
    { 0x0000f000, 0x00204811, 0x000 },
    { 0xbc000000, 0x00204411, 0x000 },
    { 0x0000f3fc, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000002, 0x00204811, 0x000 },
    { 0x000000ff, 0x00280e30, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x516 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x14c00000, 0x52b },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000001c, 0x00203623, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000029, 0x00203623, 0x000 },
    { 0x00000028, 0x00203623, 0x000 },
    { 0x00000017, 0x00203623, 0x000 },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203623, 0x000 },
    { 0x00000015, 0x00203623, 0x000 },
    { 0x00000016, 0x00203623, 0x000 },
    { 0xffffe000, 0x00200c11, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203623, 0x000 },
    { 0x00001fff, 0x00200c11, 0x000 },
    { 0x00000023, 0x00203623, 0x000 },
    { 0x00000024, 0x00203623, 0x000 },
    { 0xf1ffffff, 0x00283a2e, 0x000 },
    { 0x0000001a, 0xc0220e20, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000002a, 0x40203620, 0x000 },
    { 0x87000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000030, 0x00203623, 0x000 },
    { 0x9d000000, 0x00204411, 0x000 },
    { 0x0000001f, 0x40214a20, 0x000 },
    { 0x96000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x0000001f, 0x00211624, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x0000001d, 0x00203623, 0x000 },
    { 0x00000003, 0x00281e23, 0x000 },
    { 0x00000008, 0x00222223, 0x000 },
    { 0xfffff000, 0x00282228, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x0000001f, 0x00203628, 0x000 },
    { 0x00000018, 0x00211e23, 0x000 },
    { 0x00000020, 0x00203627, 0x000 },
    { 0x00000002, 0x00221624, 0x000 },
    { 0x00000000, 0x003014a8, 0x000 },
    { 0x0000001e, 0x00203625, 0x000 },
    { 0x00000003, 0x00211a24, 0x000 },
    { 0x10000000, 0x00281a26, 0x000 },
    { 0xefffffff, 0x00283a2e, 0x000 },
    { 0x00000000, 0x004938ce, 0x678 },
    { 0x00000001, 0x40280a20, 0x000 },
    { 0x00000006, 0x40280e20, 0x000 },
    { 0x00000300, 0xc0281220, 0x000 },
    { 0x00000008, 0x00211224, 0x000 },
    { 0x00000000, 0xc0201620, 0x000 },
    { 0x00000000, 0xc0201a20, 0x000 },
    { 0x00000000, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x563 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x68a },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00020000, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56b },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x579 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56b },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x68a },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x579 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56f },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00000000, 0xc0400000, 0x579 },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x577 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x68f },
    { 0x00000000, 0x00401c10, 0x579 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x0ee00000, 0x57b },
    { 0x00000000, 0x00600000, 0x5c6 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x58c },
    { 0x0000a2b7, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2b6, 0x00604411, 0x68a },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0000a2c4, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x58a },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000001, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x59d },
    { 0x0000a2bb, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2ba, 0x00604411, 0x68a },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0000a2c5, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x59b },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000002, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5ae },
    { 0x0000a2bf, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2be, 0x00604411, 0x68a },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0000a2c6, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5ac },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x0000a2c3, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2c2, 0x00604411, 0x68a },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0000a2c7, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5bb },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x85000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x0000304a, 0x00204411, 0x000 },
    { 0x01000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00400000, 0x5c1 },
    { 0xa4000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0xc0600000, 0x5c6 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000002c, 0x00203621, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0230, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5cd },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000030, 0x00403621, 0x5e0 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00007e00, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x5e0 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a092, 0x00604411, 0x68a },
    { 0x00000031, 0x00203630, 0x000 },
    { 0x0004a093, 0x00604411, 0x68a },
    { 0x00000032, 0x00203630, 0x000 },
    { 0x0004a2b6, 0x00604411, 0x68a },
    { 0x00000033, 0x00203630, 0x000 },
    { 0x0004a2ba, 0x00604411, 0x68a },
    { 0x00000034, 0x00203630, 0x000 },
    { 0x0004a2be, 0x00604411, 0x68a },
    { 0x00000035, 0x00203630, 0x000 },
    { 0x0004a2c2, 0x00604411, 0x68a },
    { 0x00000036, 0x00203630, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x88000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000001, 0x002f0230, 0x000 },
    { 0x00000000, 0x0ce00000, 0x629 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x629 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00007e00, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x602 },
    { 0x0000a092, 0x00204411, 0x000 },
    { 0x00000031, 0x00204a2d, 0x000 },
    { 0x0000a093, 0x00204411, 0x000 },
    { 0x00000032, 0x00204a2d, 0x000 },
    { 0x0000a2b6, 0x00204411, 0x000 },
    { 0x00000033, 0x00204a2d, 0x000 },
    { 0x0000a2ba, 0x00204411, 0x000 },
    { 0x00000034, 0x00204a2d, 0x000 },
    { 0x0000a2be, 0x00204411, 0x000 },
    { 0x00000035, 0x00204a2d, 0x000 },
    { 0x0000a2c2, 0x00204411, 0x000 },
    { 0x00000036, 0x00204a2d, 0x000 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x000001ff, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x628 },
    { 0x00000000, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x60b },
    { 0x0004a003, 0x00604411, 0x68a },
    { 0x0000a003, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000001, 0x00210621, 0x000 },
    { 0x00000000, 0x14c00000, 0x610 },
    { 0x0004a010, 0x00604411, 0x68a },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000001, 0x00210621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x628 },
    { 0x0004a011, 0x00604411, 0x68a },
    { 0x0000a011, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a012, 0x00604411, 0x68a },
    { 0x0000a012, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a013, 0x00604411, 0x68a },
    { 0x0000a013, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a014, 0x00604411, 0x68a },
    { 0x0000a014, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a015, 0x00604411, 0x68a },
    { 0x0000a015, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a016, 0x00604411, 0x68a },
    { 0x0000a016, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a017, 0x00604411, 0x68a },
    { 0x0000a017, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x0000002c, 0x0080062d, 0x000 },
    { 0xff000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000002, 0x00804811, 0x000 },
    { 0x00000000, 0x0ee00000, 0x63a },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00000002, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x638 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x68a },
    { 0x00001000, 0x00200811, 0x000 },
    { 0x0000002b, 0x00203622, 0x000 },
    { 0x00000000, 0x00600000, 0x63e },
    { 0x00000000, 0x00600000, 0x5c6 },
    { 0x98000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00804811, 0x000 },
    { 0x00000000, 0xc0600000, 0x63e },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000022, 0x00204811, 0x000 },
    { 0x89000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00404811, 0x62a },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404811, 0x62a },
    { 0x00000000, 0x00600000, 0x659 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0xc0204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x09800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x68a },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000004, 0x00404c11, 0x653 },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000004, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffffb, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffff7, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36e },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x01800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004217f, 0x00604411, 0x68a },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x689 },
    { 0x00000010, 0x00404c11, 0x66f },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x38c00000, 0x000 },
    { 0x0000001d, 0x00200a2d, 0x000 },
    { 0x0000001e, 0x00200e2d, 0x000 },
    { 0x0000001f, 0x0020122d, 0x000 },
    { 0x00000020, 0x0020162d, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000004, 0x00301224, 0x000 },
    { 0x00000000, 0x002f0064, 0x000 },
    { 0x00000000, 0x0cc00000, 0x688 },
    { 0x00000003, 0x00281a22, 0x000 },
    { 0x00000008, 0x00221222, 0x000 },
    { 0xfffff000, 0x00281224, 0x000 },
    { 0x00000000, 0x002910c4, 0x000 },
    { 0x0000001f, 0x00403624, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x68a },
    { 0x9f000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x68d },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x68f },
    { 0x9e000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x692 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0xc0204411, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000024, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000022, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00404811, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x014204ff, 0x05bd0250, 0x000 },
    { 0x01c30168, 0x043f05bd, 0x000 },
    { 0x02250209, 0x02500151, 0x000 },
    { 0x02230245, 0x02a00241, 0x000 },
    { 0x03d705bd, 0x05bd05bd, 0x000 },
    { 0x06460647, 0x031f05bd, 0x000 },
    { 0x05bd05c2, 0x03200340, 0x000 },
    { 0x032a0282, 0x03420334, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x05bd054e, 0x05bd05bd, 0x000 },
    { 0x03ba05bd, 0x04b80344, 0x000 },
    { 0x0497044d, 0x043d05bd, 0x000 },
    { 0x04cd05bd, 0x044104da, 0x000 },
    { 0x044d0504, 0x03510375, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x05bd05bd, 0x063c05c4, 0x000 },
    { 0x05bd05bd, 0x000705bd, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x03f803ed, 0x04080406, 0x000 },
    { 0x040e040a, 0x040c0410, 0x000 },
    { 0x041c0418, 0x04240420, 0x000 },
    { 0x042c0428, 0x04340430, 0x000 },
    { 0x05bd05bd, 0x043805bd, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x05bd05bd, 0x05bd05bd, 0x000 },
    { 0x00020676, 0x06940006, 0x000 },
};

static const u32 RV635_pfp_microcode[]={
0xca0400,
0xa00000,
0x7e828b,
0x7c038b,
0x8001b8,
0x7c038b,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xc41838,
0xca2400,
0xca2800,
0x9581a8,
0xc41c3a,
0xc3c000,
0xca0800,
0xca0c00,
0x7c744b,
0xc20005,
0x99c000,
0xc41c3a,
0x7c744c,
0xc0fff0,
0x042c04,
0x309002,
0x7d2500,
0x351402,
0x7d350b,
0x255403,
0x7cd580,
0x259c03,
0x95c004,
0xd5001b,
0x7eddc1,
0x7d9d80,
0xd6801b,
0xd5801b,
0xd4401e,
0xd5401e,
0xd6401e,
0xd6801e,
0xd4801e,
0xd4c01e,
0x9783d3,
0xd5c01e,
0xca0800,
0x80001a,
0xca0c00,
0xe4011e,
0xd4001e,
0x80000c,
0xc41838,
0xe4013e,
0xd4001e,
0x80000c,
0xc41838,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca1800,
0xd4401e,
0xd5801e,
0x800053,
0xd40075,
0xd4401e,
0xca0800,
0xca0c00,
0xca1000,
0xd48019,
0xd4c018,
0xd50017,
0xd4801e,
0xd4c01e,
0xd5001e,
0xe2001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0xd48060,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xd48061,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xca0c00,
0xd4401e,
0xd48016,
0xd4c016,
0xd4801e,
0x8001b8,
0xd4c01e,
0xc60843,
0xca0c00,
0xca1000,
0x948004,
0xca1400,
0xe420f3,
0xd42013,
0xd56065,
0xd4e01c,
0xd5201c,
0xd5601c,
0x800000,
0x062001,
0xc60843,
0xca0c00,
0xca1000,
0x9483f7,
0xca1400,
0xe420f3,
0x800079,
0xd42013,
0xc60843,
0xca0c00,
0xca1000,
0x9883ef,
0xca1400,
0xd40064,
0x80008d,
0x000000,
0xc41432,
0xc61843,
0xc4082f,
0x954005,
0xc40c30,
0xd4401e,
0x800000,
0xee001e,
0x9583f5,
0xc41031,
0xd44033,
0xd52065,
0xd4a01c,
0xd4e01c,
0xd5201c,
0xe4015e,
0xd4001e,
0x800000,
0x062001,
0xca1800,
0x0a2001,
0xd60076,
0xc40836,
0x988007,
0xc61045,
0x950110,
0xd4001f,
0xd46062,
0x800000,
0xd42062,
0xcc3835,
0xcc1433,
0x8401bb,
0xd40072,
0xd5401e,
0x800000,
0xee001e,
0xe2001a,
0x8401bb,
0xe2001a,
0xcc104b,
0xcc0447,
0x2c9401,
0x7d098b,
0x984005,
0x7d15cb,
0xd4001a,
0x8001b8,
0xd4006d,
0x344401,
0xcc0c48,
0x98403a,
0xcc2c4a,
0x958004,
0xcc0449,
0x8001b8,
0xd4001a,
0xd4c01a,
0x282801,
0x8400f0,
0xcc1003,
0x98801b,
0x04380c,
0x8400f0,
0xcc1003,
0x988017,
0x043808,
0x8400f0,
0xcc1003,
0x988013,
0x043804,
0x8400f0,
0xcc1003,
0x988014,
0xcc104c,
0x9a8009,
0xcc144d,
0x9840dc,
0xd4006d,
0xcc1848,
0xd5001a,
0xd5401a,
0x8000c9,
0xd5801a,
0x96c0d5,
0xd4006d,
0x8001b8,
0xd4006e,
0x9ac003,
0xd4006d,
0xd4006e,
0x800000,
0xec007f,
0x9ac0cc,
0xd4006d,
0x8001b8,
0xd4006e,
0xcc1403,
0xcc1803,
0xcc1c03,
0x7d9103,
0x7dd583,
0x7d190c,
0x35cc1f,
0x35701f,
0x7cf0cb,
0x7cd08b,
0x880000,
0x7e8e8b,
0x95c004,
0xd4006e,
0x8001b8,
0xd4001a,
0xd4c01a,
0xcc0803,
0xcc0c03,
0xcc1003,
0xcc1403,
0xcc1803,
0xcc1c03,
0xcc2403,
0xcc2803,
0x35c41f,
0x36b01f,
0x7c704b,
0x34f01f,
0x7c704b,
0x35701f,
0x7c704b,
0x7d8881,
0x7dccc1,
0x7e5101,
0x7e9541,
0x7c9082,
0x7cd4c2,
0x7c848b,
0x9ac003,
0x7c8c8b,
0x2c8801,
0x98809e,
0xd4006d,
0x98409c,
0xd4006e,
0xcc084c,
0xcc0c4d,
0xcc1048,
0xd4801a,
0xd4c01a,
0x800101,
0xd5001a,
0xcc0832,
0xd40032,
0x9482d9,
0xca0c00,
0xd4401e,
0x800000,
0xd4001e,
0xe4011e,
0xd4001e,
0xca0800,
0xca0c00,
0xca1000,
0xd4401e,
0xca1400,
0xd4801e,
0xd4c01e,
0xd5001e,
0xd5401e,
0xd54034,
0x800000,
0xee001e,
0x280404,
0xe2001a,
0xe2001a,
0xd4401a,
0xca3800,
0xcc0803,
0xcc0c03,
0xcc0c03,
0xcc0c03,
0x9882bd,
0x000000,
0x8401bb,
0xd7a06f,
0x800000,
0xee001f,
0xca0400,
0xc2ff00,
0xcc0834,
0xc13fff,
0x7c74cb,
0x7cc90b,
0x7d010f,
0x9902b0,
0x7c738b,
0x8401bb,
0xd7a06f,
0x800000,
0xee001f,
0xca0800,
0x281900,
0x7d898b,
0x958014,
0x281404,
0xca0c00,
0xca1000,
0xca1c00,
0xca2400,
0xe2001f,
0xd4c01a,
0xd5001a,
0xd5401a,
0xcc1803,
0xcc2c03,
0xcc2c03,
0xcc2c03,
0x7da58b,
0x7d9c47,
0x984297,
0x000000,
0x800161,
0xd4c01a,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0x248c06,
0x0ccc06,
0x98c006,
0xcc104e,
0x990004,
0xd40073,
0xe4011e,
0xd4001e,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xca0800,
0xca0c00,
0x34d018,
0x251001,
0x950021,
0xc17fff,
0xca1000,
0xca1400,
0xca1800,
0xd4801d,
0xd4c01d,
0x7db18b,
0xc14202,
0xc2c001,
0xd5801d,
0x34dc0e,
0x7d5d4c,
0x7f734c,
0xd7401e,
0xd5001e,
0xd5401e,
0xc14200,
0xc2c000,
0x099c01,
0x31dc10,
0x7f5f4c,
0x7f734c,
0x042802,
0x7d8380,
0xd5a86f,
0xd58066,
0xd7401e,
0xec005e,
0xc82402,
0xc82402,
0x8001b8,
0xd60076,
0xd4401e,
0xd4801e,
0xd4c01e,
0x800000,
0xee001e,
0x800000,
0xee001f,
0xd4001f,
0x800000,
0xd4001f,
0xd4001f,
0x880000,
0xd4001f,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x010171,
0x020178,
0x03008f,
0x04007f,
0x050003,
0x06003f,
0x070032,
0x08012c,
0x090046,
0x0a0036,
0x1001b6,
0x1700a2,
0x22013a,
0x230149,
0x2000b4,
0x240125,
0x27004d,
0x28006a,
0x2a0060,
0x2b0052,
0x2f0065,
0x320087,
0x34017f,
0x3c0156,
0x3f0072,
0x41018c,
0x44012e,
0x550173,
0x56017a,
0x60000b,
0x610034,
0x620038,
0x630038,
0x640038,
0x650038,
0x660038,
0x670038,
0x68003a,
0x690041,
0x6a0048,
0x6b0048,
0x6c0048,
0x6d0048,
0x6e0048,
0x6f0048,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
};

static const u32 RV670_cp_microcode[][3]={
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0000ffff, 0x00284621, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000000, 0x00e00000, 0x000 },
    { 0x00010000, 0xc0294620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x67c },
    { 0x00000000, 0x00600000, 0x624 },
    { 0x00000000, 0x00600000, 0x638 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000f00, 0x00281622, 0x000 },
    { 0x00000008, 0x00211625, 0x000 },
    { 0x00000018, 0x00203625, 0x000 },
    { 0x8d000000, 0x00204411, 0x000 },
    { 0x00000004, 0x002f0225, 0x000 },
    { 0x00000000, 0x0ce00000, 0x018 },
    { 0x00412000, 0x00404811, 0x019 },
    { 0x00422000, 0x00204811, 0x000 },
    { 0x8e000000, 0x00204411, 0x000 },
    { 0x00000028, 0x00204a2d, 0x000 },
    { 0x90000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x0000000c, 0x00211622, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000019, 0x00211a22, 0x000 },
    { 0x00000004, 0x00281a26, 0x000 },
    { 0x00000000, 0x002914c5, 0x000 },
    { 0x00000019, 0x00203625, 0x000 },
    { 0x00000000, 0x003a1402, 0x000 },
    { 0x00000016, 0x00211625, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0xfffffffc, 0x00280e23, 0x000 },
    { 0x00000000, 0x002914a3, 0x000 },
    { 0x00000017, 0x00203625, 0x000 },
    { 0x00008000, 0x00280e22, 0x000 },
    { 0x00000007, 0x00220e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x20000000, 0x00280e22, 0x000 },
    { 0x00000006, 0x00210e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x00000000, 0x00220222, 0x000 },
    { 0x00000000, 0x14e00000, 0x038 },
    { 0x00000000, 0x2ee00000, 0x035 },
    { 0x00000000, 0x2ce00000, 0x037 },
    { 0x00000000, 0x00400e2d, 0x039 },
    { 0x00000008, 0x00200e2d, 0x000 },
    { 0x00000009, 0x0040122d, 0x046 },
    { 0x00000001, 0x00400e2d, 0x039 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x03e },
    { 0x00000008, 0x00401c11, 0x041 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x0000000f, 0x00281e27, 0x000 },
    { 0x00000003, 0x00221e27, 0x000 },
    { 0x7fc00000, 0x00281a23, 0x000 },
    { 0x00000014, 0x00211a26, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000008, 0x00221a26, 0x000 },
    { 0x00000000, 0x00290cc7, 0x000 },
    { 0x00000027, 0x00203624, 0x000 },
    { 0x00007f00, 0x00281221, 0x000 },
    { 0x00001400, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x04b },
    { 0x00000001, 0x00290e23, 0x000 },
    { 0x0000000e, 0x00203623, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfff80000, 0x00294a23, 0x000 },
    { 0x00000000, 0x003a2c02, 0x000 },
    { 0x00000002, 0x00220e2b, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x0000000f, 0x00203623, 0x000 },
    { 0x00001fff, 0x00294a23, 0x000 },
    { 0x00000027, 0x00204a2d, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000029, 0x00200e2d, 0x000 },
    { 0x060a0200, 0x00294a23, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14e00000, 0x061 },
    { 0x00000000, 0x2ee00000, 0x05f },
    { 0x00000000, 0x2ce00000, 0x05e },
    { 0x00000000, 0x00400e2d, 0x062 },
    { 0x00000001, 0x00400e2d, 0x062 },
    { 0x0000000a, 0x00200e2d, 0x000 },
    { 0x0000000b, 0x0040122d, 0x06a },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x7fc00000, 0x00281623, 0x000 },
    { 0x00000014, 0x00211625, 0x000 },
    { 0x00000001, 0x00331625, 0x000 },
    { 0x80000000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00290ca3, 0x000 },
    { 0x3ffffc00, 0x00290e23, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x06d },
    { 0x00000100, 0x00401c11, 0x070 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x000000f0, 0x00281e27, 0x000 },
    { 0x00000004, 0x00221e27, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0xfffff0ff, 0x00281a30, 0x000 },
    { 0x0000a028, 0x00204411, 0x000 },
    { 0x00000000, 0x002948e6, 0x000 },
    { 0x0000a018, 0x00204411, 0x000 },
    { 0x3fffffff, 0x00284a23, 0x000 },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000030, 0x0020162d, 0x000 },
    { 0x00000002, 0x00291625, 0x000 },
    { 0x00000030, 0x00203625, 0x000 },
    { 0x00000025, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a3, 0x000 },
    { 0x00000000, 0x0cc00000, 0x083 },
    { 0x00000026, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a4, 0x000 },
    { 0x00000000, 0x0cc00000, 0x084 },
    { 0x00000000, 0x00400000, 0x08a },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203624, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x08a },
    { 0x00000000, 0x00600000, 0x659 },
    { 0x00000000, 0x00600000, 0x64d },
    { 0x00000002, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x08d },
    { 0x00000012, 0xc0403620, 0x093 },
    { 0x00000000, 0x2ee00000, 0x091 },
    { 0x00000000, 0x2ce00000, 0x090 },
    { 0x00000002, 0x00400e2d, 0x092 },
    { 0x00000003, 0x00400e2d, 0x092 },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000012, 0x00203623, 0x000 },
    { 0x00000003, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x098 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x0a0 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x2ee00000, 0x09e },
    { 0x00000000, 0x2ce00000, 0x09d },
    { 0x00000002, 0x00400e2d, 0x09f },
    { 0x00000003, 0x00400e2d, 0x09f },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x003f0000, 0x00280e23, 0x000 },
    { 0x00000010, 0x00210e23, 0x000 },
    { 0x00000011, 0x00203623, 0x000 },
    { 0x0000001e, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0a7 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x0000001f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0aa },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000008, 0x00210e2b, 0x000 },
    { 0x0000007f, 0x00280e23, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0e1 },
    { 0x00000000, 0x27000000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ae00000, 0x0b3 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000000c, 0x00221e30, 0x000 },
    { 0x99800000, 0x00204411, 0x000 },
    { 0x00000004, 0x0020122d, 0x000 },
    { 0x00000008, 0x00221224, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00291ce4, 0x000 },
    { 0x00000000, 0x00604807, 0x12f },
    { 0x9b000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x9c000000, 0x00204411, 0x000 },
    { 0x00000000, 0x0033146f, 0x000 },
    { 0x00000001, 0x00333e23, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0x00203c05, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e007, 0x00204411, 0x000 },
    { 0x0000000f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0cb },
    { 0x00f8ff08, 0x00204811, 0x000 },
    { 0x98000000, 0x00404811, 0x0dc },
    { 0x000000f0, 0x00280e22, 0x000 },
    { 0x000000a0, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x0da },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d5 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d4 },
    { 0x00003f00, 0x00400c11, 0x0d6 },
    { 0x00001f00, 0x00400c11, 0x0d6 },
    { 0x00000f00, 0x00200c11, 0x000 },
    { 0x00380009, 0x00294a23, 0x000 },
    { 0x3f000000, 0x00280e2b, 0x000 },
    { 0x00000002, 0x00220e23, 0x000 },
    { 0x00000007, 0x00494a23, 0x0dc },
    { 0x00380f09, 0x00204811, 0x000 },
    { 0x68000007, 0x00204811, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000a202, 0x00204411, 0x000 },
    { 0x00ff0000, 0x00280e22, 0x000 },
    { 0x00000080, 0x00294a23, 0x000 },
    { 0x00000027, 0x00200e2d, 0x000 },
    { 0x00000026, 0x0020122d, 0x000 },
    { 0x00000000, 0x002f0083, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0ea },
    { 0x00000000, 0x00600000, 0x653 },
    { 0x00000000, 0x00400000, 0x0eb },
    { 0x00000000, 0x00600000, 0x656 },
    { 0x00000007, 0x0020222d, 0x000 },
    { 0x00000005, 0x00220e22, 0x000 },
    { 0x00100000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x000000ef, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000003, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x0f8 },
    { 0x0000000b, 0x00210228, 0x000 },
    { 0x00000000, 0x14c00000, 0x0f8 },
    { 0x00000400, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000001c, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x0fd },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000001e, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x10b },
    { 0x0000a30f, 0x00204411, 0x000 },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x104 },
    { 0xffffffff, 0x00404811, 0x10b },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x107 },
    { 0x0000ffff, 0x00404811, 0x10b },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x10a },
    { 0x000000ff, 0x00404811, 0x10b },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0002c400, 0x00204411, 0x000 },
    { 0x0000001f, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x112 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000018, 0x40224a20, 0x000 },
    { 0x00000010, 0xc0424a20, 0x114 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000000a, 0x00201011, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x11b },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00531224, 0x117 },
    { 0xffbfffff, 0x00283a2e, 0x000 },
    { 0x0000001b, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x12e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0x00000018, 0x00220e30, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e00e, 0x00204411, 0x000 },
    { 0x07f8ff08, 0x00204811, 0x000 },
    { 0x00000000, 0x00294a23, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00800000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204806, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x67c },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x67b },
    { 0x00000004, 0x00404c11, 0x135 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000001c, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x67c },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x13c },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40280620, 0x000 },
    { 0x00000010, 0xc0210a20, 0x000 },
    { 0x00000000, 0x00341461, 0x000 },
    { 0x00000000, 0x00741882, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x147 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0681a20, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x158 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000001, 0x00300a2f, 0x000 },
    { 0x00000001, 0x00210a22, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600000, 0x18f },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00202c08, 0x000 },
    { 0x00000000, 0x00202411, 0x000 },
    { 0x00000000, 0x00202811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000002, 0x00221e29, 0x000 },
    { 0x00000000, 0x007048eb, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000001, 0x40330620, 0x000 },
    { 0x00000000, 0xc0302409, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ae00000, 0x181 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x186 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x186 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000001, 0x00530621, 0x182 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0604800, 0x197 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000011, 0x0020062d, 0x000 },
    { 0x00000000, 0x0078042a, 0x2fb },
    { 0x00000000, 0x00202809, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x174 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x194 },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x46000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x19b },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00804811, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40281620, 0x000 },
    { 0x00000010, 0xc0811a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000008, 0x00221e30, 0x000 },
    { 0x00000029, 0x00201a2d, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfffbff09, 0x00204811, 0x000 },
    { 0x0000000f, 0x0020222d, 0x000 },
    { 0x00001fff, 0x00294a28, 0x000 },
    { 0x00000006, 0x0020222d, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000100, 0x00201811, 0x000 },
    { 0x00000008, 0x00621e28, 0x12f },
    { 0x00000008, 0x00822228, 0x000 },
    { 0x0002c000, 0x00204411, 0x000 },
    { 0x00000015, 0x00600e2d, 0x1bd },
    { 0x00000016, 0x00600e2d, 0x1bd },
    { 0x0000c008, 0x00204411, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000000, 0x14c00000, 0x1b9 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x39000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00804802, 0x000 },
    { 0x00000018, 0x00202e2d, 0x000 },
    { 0x00000000, 0x003b0d63, 0x000 },
    { 0x00000008, 0x00224a23, 0x000 },
    { 0x00000010, 0x00224a23, 0x000 },
    { 0x00000018, 0x00224a23, 0x000 },
    { 0x00000000, 0x00804803, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000007, 0x0021062f, 0x000 },
    { 0x00000013, 0x00200a2d, 0x000 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000ffff, 0x40282220, 0x000 },
    { 0x0000000f, 0x00262228, 0x000 },
    { 0x00000010, 0x40212620, 0x000 },
    { 0x0000000f, 0x00262629, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1e0 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000081, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000080, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1dc },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1d8 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000001f, 0x00280a22, 0x000 },
    { 0x0000001f, 0x00282a2a, 0x000 },
    { 0x00000001, 0x00530621, 0x1d1 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000002, 0x00304a2f, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000001, 0x00301e2f, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1e5 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x0000000f, 0x00260e23, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000000f, 0x00261224, 0x000 },
    { 0x00000000, 0x00201411, 0x000 },
    { 0x00000000, 0x00601811, 0x2bb },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022b, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1f8 },
    { 0x00000010, 0x00221628, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a29, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x0020480a, 0x000 },
    { 0x00000000, 0x00202c11, 0x000 },
    { 0x00000010, 0x00221623, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a24, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x00731503, 0x205 },
    { 0x00000000, 0x00201805, 0x000 },
    { 0x00000000, 0x00731524, 0x205 },
    { 0x00000000, 0x002d14c5, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00000000, 0x00202003, 0x000 },
    { 0x00000000, 0x00802404, 0x000 },
    { 0x0000000f, 0x00210225, 0x000 },
    { 0x00000000, 0x14c00000, 0x67b },
    { 0x00000000, 0x002b1405, 0x000 },
    { 0x00000001, 0x00901625, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00294a22, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a21, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000ffff, 0x40281220, 0x000 },
    { 0x00000010, 0xc0211a20, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211620, 0x000 },
    { 0x00000000, 0x00741465, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00000001, 0x00330621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0cc00000, 0x219 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x212 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x638 },
    { 0x00000000, 0x0040040f, 0x213 },
    { 0x00000000, 0x00600000, 0x624 },
    { 0x00000000, 0x00600000, 0x638 },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00000000, 0x00600000, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ae00000, 0x232 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x236 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x236 },
    { 0x00000000, 0xc0404800, 0x233 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x00600411, 0x2fb },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x624 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000018, 0x40210a20, 0x000 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x24c },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x00080101, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x251 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000010, 0x00600411, 0x315 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00000000, 0x00600000, 0x27c },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000001, 0x00211e27, 0x000 },
    { 0x00000000, 0x14e00000, 0x26a },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x0000ffff, 0x00281e27, 0x000 },
    { 0x00000000, 0x00341c27, 0x000 },
    { 0x00000000, 0x12c00000, 0x25f },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e5, 0x000 },
    { 0x00000000, 0x08c00000, 0x262 },
    { 0x00000000, 0x00201407, 0x000 },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00211e27, 0x000 },
    { 0x00000000, 0x00341c47, 0x000 },
    { 0x00000000, 0x12c00000, 0x267 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x08c00000, 0x26a },
    { 0x00000000, 0x00201807, 0x000 },
    { 0x00000000, 0x00600000, 0x2c1 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000000, 0x00342023, 0x000 },
    { 0x00000000, 0x12c00000, 0x272 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x271 },
    { 0x00000016, 0x00404811, 0x276 },
    { 0x00000018, 0x00404811, 0x276 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x275 },
    { 0x00000017, 0x00404811, 0x276 },
    { 0x00000019, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00604411, 0x2e9 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x256 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000010, 0x40210620, 0x000 },
    { 0x0000ffff, 0xc0280a20, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0881a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x67c },
    { 0x00000000, 0x00600000, 0x624 },
    { 0x00000000, 0xc0600000, 0x2a3 },
    { 0x00000005, 0x00200a2d, 0x000 },
    { 0x00000008, 0x00220a22, 0x000 },
    { 0x0000002b, 0x00201a2d, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00007000, 0x00281e27, 0x000 },
    { 0x00000000, 0x00311ce6, 0x000 },
    { 0x0000002a, 0x00201a2d, 0x000 },
    { 0x0000000c, 0x00221a26, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x06e00000, 0x292 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00691ce2, 0x12f },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x29d },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000001c, 0x00403627, 0x000 },
    { 0x0000000c, 0xc0220a20, 0x000 },
    { 0x00000029, 0x00203622, 0x000 },
    { 0x00000028, 0xc0403620, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000009, 0x00204811, 0x000 },
    { 0xa1000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce3, 0x000 },
    { 0x00000021, 0x00203627, 0x000 },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce4, 0x000 },
    { 0x00000022, 0x00203627, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a3, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203624, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000000, 0x00311cc4, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14c00000, 0x2dc },
    { 0x00000000, 0x00400000, 0x2d9 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2d9 },
    { 0x00000003, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2dc },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e1, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a1, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e2, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000000, 0x00600000, 0x659 },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00600000, 0x650 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2a7 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x0000001a, 0x00201e2d, 0x000 },
    { 0x0000001b, 0x0080222d, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca1, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x003808c5, 0x000 },
    { 0x00000000, 0x00300841, 0x000 },
    { 0x00000001, 0x00220a22, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000017, 0x0020222d, 0x000 },
    { 0x00000000, 0x14c00000, 0x318 },
    { 0xffffffef, 0x00280621, 0x000 },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x0000f8e0, 0x00204411, 0x000 },
    { 0x00000000, 0x00294901, 0x000 },
    { 0x00000000, 0x00894901, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00804811, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x97000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00002257, 0x00204411, 0x000 },
    { 0x00000003, 0xc0484a20, 0x000 },
    { 0x0000225d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x638 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x00000001, 0x40304a20, 0x000 },
    { 0x00000002, 0xc0304a20, 0x000 },
    { 0x00000001, 0x00530a22, 0x34b },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x67c },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x354 },
    { 0x00000014, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x362 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00604802, 0x36a },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x366 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x35d },
    { 0x00000028, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5b3 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x35d },
    { 0x0000002c, 0x00203626, 0x000 },
    { 0x00000049, 0x00201811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000000, 0x002f0226, 0x000 },
    { 0x00000000, 0x0cc00000, 0x36c },
    { 0x0000002c, 0x00801a2d, 0x000 },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x00000015, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x382 },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3ad },
    { 0x00000016, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3af },
    { 0x00000020, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x398 },
    { 0x0000000f, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3a4 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3a4 },
    { 0x0000001e, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x38c },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x08000000, 0x00290a22, 0x000 },
    { 0x00000003, 0x40210e20, 0x000 },
    { 0x0000000c, 0xc0211220, 0x000 },
    { 0x00080000, 0x00281224, 0x000 },
    { 0x00000014, 0xc0221620, 0x000 },
    { 0x00000000, 0x002914a4, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x002948a2, 0x000 },
    { 0x0000a1fe, 0x00204411, 0x000 },
    { 0x00000000, 0x00404803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x67c },
    { 0x00000015, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x38e },
    { 0x0000210e, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000017, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x67c },
    { 0x00000003, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x39a },
    { 0x00002108, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x80000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000010, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3aa },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000006, 0x00404811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36a },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x0000001d, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x3c4 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x67c },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x3b8 },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0xbabecafe, 0x00204811, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000004, 0x00404811, 0x000 },
    { 0x00002170, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000a, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3c9 },
    { 0x8c000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00003fff, 0x40280a20, 0x000 },
    { 0x80000000, 0x40280e20, 0x000 },
    { 0x40000000, 0xc0281220, 0x000 },
    { 0x00040000, 0x00694622, 0x67c },
    { 0x00000000, 0x00201410, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3d7 },
    { 0x00000000, 0xc0401800, 0x3da },
    { 0x00003fff, 0xc0281a20, 0x000 },
    { 0x00040000, 0x00694626, 0x67c },
    { 0x00000000, 0x00201810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3dd },
    { 0x00000000, 0xc0401c00, 0x3e0 },
    { 0x00003fff, 0xc0281e20, 0x000 },
    { 0x00040000, 0x00694627, 0x67c },
    { 0x00000000, 0x00201c10, 0x000 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0x002820c5, 0x000 },
    { 0x00000000, 0x004948e8, 0x000 },
    { 0xa5800000, 0x00200811, 0x000 },
    { 0x00002000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x408 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x0000001f, 0xc0210220, 0x000 },
    { 0x00000000, 0x14c00000, 0x3ed },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000ffff, 0xc0481220, 0x3f5 },
    { 0xa7800000, 0x00200811, 0x000 },
    { 0x0000a000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x408 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00304883, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x83000000, 0x00604411, 0x408 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xa9800000, 0x00200811, 0x000 },
    { 0x0000c000, 0x00400c11, 0x3f0 },
    { 0xab800000, 0x00200811, 0x000 },
    { 0x0000f8e0, 0x00400c11, 0x3f0 },
    { 0xad800000, 0x00200811, 0x000 },
    { 0x0000f880, 0x00400c11, 0x3f0 },
    { 0xb3800000, 0x00200811, 0x000 },
    { 0x0000f3fc, 0x00400c11, 0x3f0 },
    { 0xaf800000, 0x00200811, 0x000 },
    { 0x0000e000, 0x00400c11, 0x3f0 },
    { 0xb1800000, 0x00200811, 0x000 },
    { 0x0000f000, 0x00400c11, 0x3f0 },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00002148, 0x00204811, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x01182000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0218a000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0318c000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0418f8e0, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0518f880, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0618e000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0718f000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0818f3fc, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000030, 0x00200a2d, 0x000 },
    { 0x00000000, 0xc0290c40, 0x000 },
    { 0x00000030, 0x00203623, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x86000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x85000000, 0xc0204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x67c },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00404c02, 0x43e },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x00000000, 0xc0201400, 0x000 },
    { 0x00000000, 0xc0201800, 0x000 },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x44c },
    { 0x00000000, 0xc0202000, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x00000010, 0x00280a23, 0x000 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x454 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0x00694624, 0x67c },
    { 0x00000000, 0x00400000, 0x459 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00604805, 0x681 },
    { 0x00000000, 0x002824f0, 0x000 },
    { 0x00000007, 0x00280a23, 0x000 },
    { 0x00000001, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x460 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x04e00000, 0x479 },
    { 0x00000000, 0x00400000, 0x486 },
    { 0x00000002, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x465 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x02e00000, 0x479 },
    { 0x00000000, 0x00400000, 0x486 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x46a },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ce00000, 0x479 },
    { 0x00000000, 0x00400000, 0x486 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x46f },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ae00000, 0x479 },
    { 0x00000000, 0x00400000, 0x486 },
    { 0x00000005, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x474 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x06e00000, 0x479 },
    { 0x00000000, 0x00400000, 0x486 },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x479 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x08e00000, 0x479 },
    { 0x00000000, 0x00400000, 0x486 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x000 },
    { 0x00000008, 0x00210a23, 0x000 },
    { 0x00000000, 0x14c00000, 0x483 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x48c },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x00404c08, 0x44c },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000011, 0x40211220, 0x000 },
    { 0x00000012, 0x40211620, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00210225, 0x000 },
    { 0x00000000, 0x14e00000, 0x496 },
    { 0x00040000, 0xc0494a20, 0x497 },
    { 0xfffbffff, 0xc0284a20, 0x000 },
    { 0x00000000, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x4a3 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000c, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x49f },
    { 0xa0000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000004, 0x00204811, 0x000 },
    { 0x0000216b, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000216c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00400000, 0x49d },
    { 0x00000000, 0xc0210a20, 0x000 },
    { 0x00000000, 0x14c00000, 0x4b6 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x681 },
    { 0x00000000, 0x00400000, 0x4ba },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0xc0294620, 0x000 },
    { 0x00000000, 0xc0600000, 0x67c },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x4c1 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0404810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x67c },
    { 0x00000000, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x4c3 },
    { 0x00002180, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000003, 0x00333e2f, 0x000 },
    { 0x00000001, 0x00210221, 0x000 },
    { 0x00000000, 0x14e00000, 0x4f3 },
    { 0x0000002c, 0x00200a2d, 0x000 },
    { 0x00040000, 0x18e00c11, 0x4e2 },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xd8c04800, 0x4d6 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000002d, 0x0020122d, 0x000 },
    { 0x00000000, 0x00290c83, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000011, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00400000, 0x49d },
    { 0x0000002c, 0xc0203620, 0x000 },
    { 0x0000002d, 0xc0403620, 0x000 },
    { 0x0000000f, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x4f8 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0xd9000000, 0x000 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xb5000000, 0x00204411, 0x000 },
    { 0x00002000, 0x00204811, 0x000 },
    { 0xb6000000, 0x00204411, 0x000 },
    { 0x0000a000, 0x00204811, 0x000 },
    { 0xb7000000, 0x00204411, 0x000 },
    { 0x0000c000, 0x00204811, 0x000 },
    { 0xb8000000, 0x00204411, 0x000 },
    { 0x0000f8e0, 0x00204811, 0x000 },
    { 0xb9000000, 0x00204411, 0x000 },
    { 0x0000f880, 0x00204811, 0x000 },
    { 0xba000000, 0x00204411, 0x000 },
    { 0x0000e000, 0x00204811, 0x000 },
    { 0xbb000000, 0x00204411, 0x000 },
    { 0x0000f000, 0x00204811, 0x000 },
    { 0xbc000000, 0x00204411, 0x000 },
    { 0x0000f3fc, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000002, 0x00204811, 0x000 },
    { 0x000000ff, 0x00280e30, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x50c },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x14c00000, 0x521 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000001c, 0x00203623, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000029, 0x00203623, 0x000 },
    { 0x00000028, 0x00203623, 0x000 },
    { 0x00000017, 0x00203623, 0x000 },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203623, 0x000 },
    { 0x00000015, 0x00203623, 0x000 },
    { 0x00000016, 0x00203623, 0x000 },
    { 0xffffe000, 0x00200c11, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203623, 0x000 },
    { 0x00001fff, 0x00200c11, 0x000 },
    { 0x00000023, 0x00203623, 0x000 },
    { 0x00000024, 0x00203623, 0x000 },
    { 0xf1ffffff, 0x00283a2e, 0x000 },
    { 0x0000001a, 0xc0220e20, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000002a, 0x40203620, 0x000 },
    { 0x87000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000030, 0x00203623, 0x000 },
    { 0x9d000000, 0x00204411, 0x000 },
    { 0x0000001f, 0x40214a20, 0x000 },
    { 0x96000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x0000001f, 0x00211624, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x0000001d, 0x00203623, 0x000 },
    { 0x00000003, 0x00281e23, 0x000 },
    { 0x00000008, 0x00222223, 0x000 },
    { 0xfffff000, 0x00282228, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x0000001f, 0x00203628, 0x000 },
    { 0x00000018, 0x00211e23, 0x000 },
    { 0x00000020, 0x00203627, 0x000 },
    { 0x00000002, 0x00221624, 0x000 },
    { 0x00000000, 0x003014a8, 0x000 },
    { 0x0000001e, 0x00203625, 0x000 },
    { 0x00000003, 0x00211a24, 0x000 },
    { 0x10000000, 0x00281a26, 0x000 },
    { 0xefffffff, 0x00283a2e, 0x000 },
    { 0x00000000, 0x004938ce, 0x66a },
    { 0x00000001, 0x40280a20, 0x000 },
    { 0x00000006, 0x40280e20, 0x000 },
    { 0x00000300, 0xc0281220, 0x000 },
    { 0x00000008, 0x00211224, 0x000 },
    { 0x00000000, 0xc0201620, 0x000 },
    { 0x00000000, 0xc0201a20, 0x000 },
    { 0x00000000, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x559 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x67c },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00020000, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x561 },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x56f },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x561 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x67c },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x56f },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x565 },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00000000, 0xc0400000, 0x56f },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x56d },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x681 },
    { 0x00000000, 0x00401c10, 0x56f },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x0ee00000, 0x571 },
    { 0x00000000, 0x00600000, 0x5bc },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x582 },
    { 0x0000a2b7, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2b6, 0x00604411, 0x67c },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x67c },
    { 0x0000a2c4, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x580 },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000001, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x593 },
    { 0x0000a2bb, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2ba, 0x00604411, 0x67c },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x67c },
    { 0x0000a2c5, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x591 },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000002, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5a4 },
    { 0x0000a2bf, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2be, 0x00604411, 0x67c },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x67c },
    { 0x0000a2c6, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5a2 },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x0000a2c3, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a2c2, 0x00604411, 0x67c },
    { 0x0000001a, 0x00212230, 0x000 },
    { 0x00000006, 0x00222630, 0x000 },
    { 0x00042004, 0x00604411, 0x67c },
    { 0x0000a2c7, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5b1 },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x85000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x0000304a, 0x00204411, 0x000 },
    { 0x01000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00400000, 0x5b7 },
    { 0xa4000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0xc0600000, 0x5bc },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000002c, 0x00203621, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0230, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5c3 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000030, 0x00403621, 0x5d6 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00007e00, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x5d6 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004a092, 0x00604411, 0x67c },
    { 0x00000031, 0x00203630, 0x000 },
    { 0x0004a093, 0x00604411, 0x67c },
    { 0x00000032, 0x00203630, 0x000 },
    { 0x0004a2b6, 0x00604411, 0x67c },
    { 0x00000033, 0x00203630, 0x000 },
    { 0x0004a2ba, 0x00604411, 0x67c },
    { 0x00000034, 0x00203630, 0x000 },
    { 0x0004a2be, 0x00604411, 0x67c },
    { 0x00000035, 0x00203630, 0x000 },
    { 0x0004a2c2, 0x00604411, 0x67c },
    { 0x00000036, 0x00203630, 0x000 },
    { 0x00042004, 0x00604411, 0x67c },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x88000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000001, 0x002f0230, 0x000 },
    { 0x00000000, 0x0ce00000, 0x61f },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x61f },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00007e00, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x5f8 },
    { 0x0000a092, 0x00204411, 0x000 },
    { 0x00000031, 0x00204a2d, 0x000 },
    { 0x0000a093, 0x00204411, 0x000 },
    { 0x00000032, 0x00204a2d, 0x000 },
    { 0x0000a2b6, 0x00204411, 0x000 },
    { 0x00000033, 0x00204a2d, 0x000 },
    { 0x0000a2ba, 0x00204411, 0x000 },
    { 0x00000034, 0x00204a2d, 0x000 },
    { 0x0000a2be, 0x00204411, 0x000 },
    { 0x00000035, 0x00204a2d, 0x000 },
    { 0x0000a2c2, 0x00204411, 0x000 },
    { 0x00000036, 0x00204a2d, 0x000 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x000001ff, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x61e },
    { 0x00000000, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x601 },
    { 0x0004a003, 0x00604411, 0x67c },
    { 0x0000a003, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000001, 0x00210621, 0x000 },
    { 0x00000000, 0x14c00000, 0x606 },
    { 0x0004a010, 0x00604411, 0x67c },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00000001, 0x00210621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x61e },
    { 0x0004a011, 0x00604411, 0x67c },
    { 0x0000a011, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a012, 0x00604411, 0x67c },
    { 0x0000a012, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a013, 0x00604411, 0x67c },
    { 0x0000a013, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a014, 0x00604411, 0x67c },
    { 0x0000a014, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a015, 0x00604411, 0x67c },
    { 0x0000a015, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a016, 0x00604411, 0x67c },
    { 0x0000a016, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x0004a017, 0x00604411, 0x67c },
    { 0x0000a017, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x00042004, 0x00604411, 0x67c },
    { 0x0000002c, 0x0080062d, 0x000 },
    { 0xff000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000002, 0x00804811, 0x000 },
    { 0x00000000, 0x0ee00000, 0x630 },
    { 0x00000030, 0x0020062d, 0x000 },
    { 0x00000002, 0x00280621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x62e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x67c },
    { 0x00001000, 0x00200811, 0x000 },
    { 0x0000002b, 0x00203622, 0x000 },
    { 0x00000000, 0x00600000, 0x634 },
    { 0x00000000, 0x00600000, 0x5bc },
    { 0x98000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00804811, 0x000 },
    { 0x00000000, 0xc0600000, 0x634 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000022, 0x00204811, 0x000 },
    { 0x89000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00404811, 0x620 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404811, 0x620 },
    { 0x00000000, 0x00600000, 0x64d },
    { 0x0001a2a4, 0xc0204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36a },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x09800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x67c },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000004, 0x00404c11, 0x647 },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000004, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffffb, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffff7, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x36a },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x01800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004217f, 0x00604411, 0x67c },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x67b },
    { 0x00000010, 0x00404c11, 0x661 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x38c00000, 0x000 },
    { 0x0000001d, 0x00200a2d, 0x000 },
    { 0x0000001e, 0x00200e2d, 0x000 },
    { 0x0000001f, 0x0020122d, 0x000 },
    { 0x00000020, 0x0020162d, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000004, 0x00301224, 0x000 },
    { 0x00000000, 0x002f0064, 0x000 },
    { 0x00000000, 0x0cc00000, 0x67a },
    { 0x00000003, 0x00281a22, 0x000 },
    { 0x00000008, 0x00221222, 0x000 },
    { 0xfffff000, 0x00281224, 0x000 },
    { 0x00000000, 0x002910c4, 0x000 },
    { 0x0000001f, 0x00403624, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x67c },
    { 0x9f000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x67f },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x681 },
    { 0x9e000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x684 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0xc0204411, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000024, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000022, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00404811, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x014204f5, 0x05b30250, 0x000 },
    { 0x01c30168, 0x043505b3, 0x000 },
    { 0x02250209, 0x02500151, 0x000 },
    { 0x02230245, 0x02a00241, 0x000 },
    { 0x03cd05b3, 0x05b305b3, 0x000 },
    { 0x063c063d, 0x031f05b3, 0x000 },
    { 0x05b305b8, 0x03200340, 0x000 },
    { 0x032a0282, 0x03420334, 0x000 },
    { 0x05b305b3, 0x05b305b3, 0x000 },
    { 0x05b30544, 0x05b305b3, 0x000 },
    { 0x03b205b3, 0x04ae0344, 0x000 },
    { 0x048d0443, 0x043305b3, 0x000 },
    { 0x04c305b3, 0x043704d0, 0x000 },
    { 0x044304fa, 0x03510371, 0x000 },
    { 0x05b305b3, 0x05b305b3, 0x000 },
    { 0x05b305b3, 0x05b305b3, 0x000 },
    { 0x05b305b3, 0x063205ba, 0x000 },
    { 0x05b305b3, 0x000705b3, 0x000 },
    { 0x05b305b3, 0x05b305b3, 0x000 },
    { 0x05b305b3, 0x05b305b3, 0x000 },
    { 0x03ee03e3, 0x03fe03fc, 0x000 },
    { 0x04040400, 0x04020406, 0x000 },
    { 0x0412040e, 0x041a0416, 0x000 },
    { 0x0422041e, 0x042a0426, 0x000 },
    { 0x05b305b3, 0x042e05b3, 0x000 },
    { 0x05b305b3, 0x05b305b3, 0x000 },
    { 0x05b305b3, 0x05b305b3, 0x000 },
    { 0x00020668, 0x06860006, 0x000 },
};

static const u32 RV670_pfp_microcode[]={
0xca0400,
0xa00000,
0x7e828b,
0x7c038b,
0x8001b8,
0x7c038b,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xc41838,
0xca2400,
0xca2800,
0x9581a8,
0xc41c3a,
0xc3c000,
0xca0800,
0xca0c00,
0x7c744b,
0xc20005,
0x99c000,
0xc41c3a,
0x7c744c,
0xc0fff0,
0x042c04,
0x309002,
0x7d2500,
0x351402,
0x7d350b,
0x255403,
0x7cd580,
0x259c03,
0x95c004,
0xd5001b,
0x7eddc1,
0x7d9d80,
0xd6801b,
0xd5801b,
0xd4401e,
0xd5401e,
0xd6401e,
0xd6801e,
0xd4801e,
0xd4c01e,
0x9783d3,
0xd5c01e,
0xca0800,
0x80001a,
0xca0c00,
0xe4011e,
0xd4001e,
0x80000c,
0xc41838,
0xe4013e,
0xd4001e,
0x80000c,
0xc41838,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca1800,
0xd4401e,
0xd5801e,
0x800053,
0xd40075,
0xd4401e,
0xca0800,
0xca0c00,
0xca1000,
0xd48019,
0xd4c018,
0xd50017,
0xd4801e,
0xd4c01e,
0xd5001e,
0xe2001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0xd48060,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xd48061,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xca0c00,
0xd4401e,
0xd48016,
0xd4c016,
0xd4801e,
0x8001b8,
0xd4c01e,
0xc60843,
0xca0c00,
0xca1000,
0x948004,
0xca1400,
0xe420f3,
0xd42013,
0xd56065,
0xd4e01c,
0xd5201c,
0xd5601c,
0x800000,
0x062001,
0xc60843,
0xca0c00,
0xca1000,
0x9483f7,
0xca1400,
0xe420f3,
0x800079,
0xd42013,
0xc60843,
0xca0c00,
0xca1000,
0x9883ef,
0xca1400,
0xd40064,
0x80008d,
0x000000,
0xc41432,
0xc61843,
0xc4082f,
0x954005,
0xc40c30,
0xd4401e,
0x800000,
0xee001e,
0x9583f5,
0xc41031,
0xd44033,
0xd52065,
0xd4a01c,
0xd4e01c,
0xd5201c,
0xe4015e,
0xd4001e,
0x800000,
0x062001,
0xca1800,
0x0a2001,
0xd60076,
0xc40836,
0x988007,
0xc61045,
0x950110,
0xd4001f,
0xd46062,
0x800000,
0xd42062,
0xcc3835,
0xcc1433,
0x8401bb,
0xd40072,
0xd5401e,
0x800000,
0xee001e,
0xe2001a,
0x8401bb,
0xe2001a,
0xcc104b,
0xcc0447,
0x2c9401,
0x7d098b,
0x984005,
0x7d15cb,
0xd4001a,
0x8001b8,
0xd4006d,
0x344401,
0xcc0c48,
0x98403a,
0xcc2c4a,
0x958004,
0xcc0449,
0x8001b8,
0xd4001a,
0xd4c01a,
0x282801,
0x8400f0,
0xcc1003,
0x98801b,
0x04380c,
0x8400f0,
0xcc1003,
0x988017,
0x043808,
0x8400f0,
0xcc1003,
0x988013,
0x043804,
0x8400f0,
0xcc1003,
0x988014,
0xcc104c,
0x9a8009,
0xcc144d,
0x9840dc,
0xd4006d,
0xcc1848,
0xd5001a,
0xd5401a,
0x8000c9,
0xd5801a,
0x96c0d5,
0xd4006d,
0x8001b8,
0xd4006e,
0x9ac003,
0xd4006d,
0xd4006e,
0x800000,
0xec007f,
0x9ac0cc,
0xd4006d,
0x8001b8,
0xd4006e,
0xcc1403,
0xcc1803,
0xcc1c03,
0x7d9103,
0x7dd583,
0x7d190c,
0x35cc1f,
0x35701f,
0x7cf0cb,
0x7cd08b,
0x880000,
0x7e8e8b,
0x95c004,
0xd4006e,
0x8001b8,
0xd4001a,
0xd4c01a,
0xcc0803,
0xcc0c03,
0xcc1003,
0xcc1403,
0xcc1803,
0xcc1c03,
0xcc2403,
0xcc2803,
0x35c41f,
0x36b01f,
0x7c704b,
0x34f01f,
0x7c704b,
0x35701f,
0x7c704b,
0x7d8881,
0x7dccc1,
0x7e5101,
0x7e9541,
0x7c9082,
0x7cd4c2,
0x7c848b,
0x9ac003,
0x7c8c8b,
0x2c8801,
0x98809e,
0xd4006d,
0x98409c,
0xd4006e,
0xcc084c,
0xcc0c4d,
0xcc1048,
0xd4801a,
0xd4c01a,
0x800101,
0xd5001a,
0xcc0832,
0xd40032,
0x9482d9,
0xca0c00,
0xd4401e,
0x800000,
0xd4001e,
0xe4011e,
0xd4001e,
0xca0800,
0xca0c00,
0xca1000,
0xd4401e,
0xca1400,
0xd4801e,
0xd4c01e,
0xd5001e,
0xd5401e,
0xd54034,
0x800000,
0xee001e,
0x280404,
0xe2001a,
0xe2001a,
0xd4401a,
0xca3800,
0xcc0803,
0xcc0c03,
0xcc0c03,
0xcc0c03,
0x9882bd,
0x000000,
0x8401bb,
0xd7a06f,
0x800000,
0xee001f,
0xca0400,
0xc2ff00,
0xcc0834,
0xc13fff,
0x7c74cb,
0x7cc90b,
0x7d010f,
0x9902b0,
0x7c738b,
0x8401bb,
0xd7a06f,
0x800000,
0xee001f,
0xca0800,
0x281900,
0x7d898b,
0x958014,
0x281404,
0xca0c00,
0xca1000,
0xca1c00,
0xca2400,
0xe2001f,
0xd4c01a,
0xd5001a,
0xd5401a,
0xcc1803,
0xcc2c03,
0xcc2c03,
0xcc2c03,
0x7da58b,
0x7d9c47,
0x984297,
0x000000,
0x800161,
0xd4c01a,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0x248c06,
0x0ccc06,
0x98c006,
0xcc104e,
0x990004,
0xd40073,
0xe4011e,
0xd4001e,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xca0800,
0xca0c00,
0x34d018,
0x251001,
0x950021,
0xc17fff,
0xca1000,
0xca1400,
0xca1800,
0xd4801d,
0xd4c01d,
0x7db18b,
0xc14202,
0xc2c001,
0xd5801d,
0x34dc0e,
0x7d5d4c,
0x7f734c,
0xd7401e,
0xd5001e,
0xd5401e,
0xc14200,
0xc2c000,
0x099c01,
0x31dc10,
0x7f5f4c,
0x7f734c,
0x042802,
0x7d8380,
0xd5a86f,
0xd58066,
0xd7401e,
0xec005e,
0xc82402,
0xc82402,
0x8001b8,
0xd60076,
0xd4401e,
0xd4801e,
0xd4c01e,
0x800000,
0xee001e,
0x800000,
0xee001f,
0xd4001f,
0x800000,
0xd4001f,
0xd4001f,
0x880000,
0xd4001f,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x010171,
0x020178,
0x03008f,
0x04007f,
0x050003,
0x06003f,
0x070032,
0x08012c,
0x090046,
0x0a0036,
0x1001b6,
0x1700a2,
0x22013a,
0x230149,
0x2000b4,
0x240125,
0x27004d,
0x28006a,
0x2a0060,
0x2b0052,
0x2f0065,
0x320087,
0x34017f,
0x3c0156,
0x3f0072,
0x41018c,
0x44012e,
0x550173,
0x56017a,
0x60000b,
0x610034,
0x620038,
0x630038,
0x640038,
0x650038,
0x660038,
0x670038,
0x68003a,
0x690041,
0x6a0048,
0x6b0048,
0x6c0048,
0x6d0048,
0x6e0048,
0x6f0048,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
};

static const u32 RS780_cp_microcode[][3]={
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0000ffff, 0x00284621, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000000, 0x00e00000, 0x000 },
    { 0x00010000, 0xc0294620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x622 },
    { 0x00000000, 0x00600000, 0x5d1 },
    { 0x00000000, 0x00600000, 0x5de },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000f00, 0x00281622, 0x000 },
    { 0x00000008, 0x00211625, 0x000 },
    { 0x00000018, 0x00203625, 0x000 },
    { 0x8d000000, 0x00204411, 0x000 },
    { 0x00000004, 0x002f0225, 0x000 },
    { 0x00000000, 0x0ce00000, 0x018 },
    { 0x00412000, 0x00404811, 0x019 },
    { 0x00422000, 0x00204811, 0x000 },
    { 0x8e000000, 0x00204411, 0x000 },
    { 0x00000028, 0x00204a2d, 0x000 },
    { 0x90000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x0000000c, 0x00211622, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000019, 0x00211a22, 0x000 },
    { 0x00000004, 0x00281a26, 0x000 },
    { 0x00000000, 0x002914c5, 0x000 },
    { 0x00000019, 0x00203625, 0x000 },
    { 0x00000000, 0x003a1402, 0x000 },
    { 0x00000016, 0x00211625, 0x000 },
    { 0x00000003, 0x00281625, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0xfffffffc, 0x00280e23, 0x000 },
    { 0x00000000, 0x002914a3, 0x000 },
    { 0x00000017, 0x00203625, 0x000 },
    { 0x00008000, 0x00280e22, 0x000 },
    { 0x00000007, 0x00220e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x20000000, 0x00280e22, 0x000 },
    { 0x00000006, 0x00210e23, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x00000000, 0x00220222, 0x000 },
    { 0x00000000, 0x14e00000, 0x038 },
    { 0x00000000, 0x2ee00000, 0x035 },
    { 0x00000000, 0x2ce00000, 0x037 },
    { 0x00000000, 0x00400e2d, 0x039 },
    { 0x00000008, 0x00200e2d, 0x000 },
    { 0x00000009, 0x0040122d, 0x046 },
    { 0x00000001, 0x00400e2d, 0x039 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x03e },
    { 0x00000008, 0x00401c11, 0x041 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x0000000f, 0x00281e27, 0x000 },
    { 0x00000003, 0x00221e27, 0x000 },
    { 0x7fc00000, 0x00281a23, 0x000 },
    { 0x00000014, 0x00211a26, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000008, 0x00221a26, 0x000 },
    { 0x00000000, 0x00290cc7, 0x000 },
    { 0x00000027, 0x00203624, 0x000 },
    { 0x00007f00, 0x00281221, 0x000 },
    { 0x00001400, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x04b },
    { 0x00000001, 0x00290e23, 0x000 },
    { 0x0000000e, 0x00203623, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfff80000, 0x00294a23, 0x000 },
    { 0x00000000, 0x003a2c02, 0x000 },
    { 0x00000002, 0x00220e2b, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x0000000f, 0x00203623, 0x000 },
    { 0x00001fff, 0x00294a23, 0x000 },
    { 0x00000027, 0x00204a2d, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000029, 0x00200e2d, 0x000 },
    { 0x060a0200, 0x00294a23, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14e00000, 0x061 },
    { 0x00000000, 0x2ee00000, 0x05f },
    { 0x00000000, 0x2ce00000, 0x05e },
    { 0x00000000, 0x00400e2d, 0x062 },
    { 0x00000001, 0x00400e2d, 0x062 },
    { 0x0000000a, 0x00200e2d, 0x000 },
    { 0x0000000b, 0x0040122d, 0x06a },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x003ffffc, 0x00281223, 0x000 },
    { 0x00000002, 0x00221224, 0x000 },
    { 0x7fc00000, 0x00281623, 0x000 },
    { 0x00000014, 0x00211625, 0x000 },
    { 0x00000001, 0x00331625, 0x000 },
    { 0x80000000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00290ca3, 0x000 },
    { 0x3ffffc00, 0x00290e23, 0x000 },
    { 0x0000001f, 0x00211e23, 0x000 },
    { 0x00000000, 0x14e00000, 0x06d },
    { 0x00000100, 0x00401c11, 0x070 },
    { 0x0000000d, 0x00201e2d, 0x000 },
    { 0x000000f0, 0x00281e27, 0x000 },
    { 0x00000004, 0x00221e27, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0xfffff0ff, 0x00281a30, 0x000 },
    { 0x0000a028, 0x00204411, 0x000 },
    { 0x00000000, 0x002948e6, 0x000 },
    { 0x0000a018, 0x00204411, 0x000 },
    { 0x3fffffff, 0x00284a23, 0x000 },
    { 0x0000a010, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000030, 0x0020162d, 0x000 },
    { 0x00000002, 0x00291625, 0x000 },
    { 0x00000030, 0x00203625, 0x000 },
    { 0x00000025, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a3, 0x000 },
    { 0x00000000, 0x0cc00000, 0x083 },
    { 0x00000026, 0x0020162d, 0x000 },
    { 0x00000000, 0x002f00a4, 0x000 },
    { 0x00000000, 0x0cc00000, 0x084 },
    { 0x00000000, 0x00400000, 0x08a },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203624, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x08a },
    { 0x00000000, 0x00600000, 0x5ff },
    { 0x00000000, 0x00600000, 0x5f3 },
    { 0x00000002, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x08d },
    { 0x00000012, 0xc0403620, 0x093 },
    { 0x00000000, 0x2ee00000, 0x091 },
    { 0x00000000, 0x2ce00000, 0x090 },
    { 0x00000002, 0x00400e2d, 0x092 },
    { 0x00000003, 0x00400e2d, 0x092 },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000012, 0x00203623, 0x000 },
    { 0x00000003, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x098 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x0a0 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x2ee00000, 0x09e },
    { 0x00000000, 0x2ce00000, 0x09d },
    { 0x00000002, 0x00400e2d, 0x09f },
    { 0x00000003, 0x00400e2d, 0x09f },
    { 0x0000000c, 0x00200e2d, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x003f0000, 0x00280e23, 0x000 },
    { 0x00000010, 0x00210e23, 0x000 },
    { 0x00000011, 0x00203623, 0x000 },
    { 0x0000001e, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0a7 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x0000001f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0aa },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000008, 0x00210e2b, 0x000 },
    { 0x0000007f, 0x00280e23, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0e1 },
    { 0x00000000, 0x27000000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ae00000, 0x0b3 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000000c, 0x00221e30, 0x000 },
    { 0x99800000, 0x00204411, 0x000 },
    { 0x00000004, 0x0020122d, 0x000 },
    { 0x00000008, 0x00221224, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00291ce4, 0x000 },
    { 0x00000000, 0x00604807, 0x12f },
    { 0x9b000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x9c000000, 0x00204411, 0x000 },
    { 0x00000000, 0x0033146f, 0x000 },
    { 0x00000001, 0x00333e23, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0x00203c05, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e007, 0x00204411, 0x000 },
    { 0x0000000f, 0x0021022b, 0x000 },
    { 0x00000000, 0x14c00000, 0x0cb },
    { 0x00f8ff08, 0x00204811, 0x000 },
    { 0x98000000, 0x00404811, 0x0dc },
    { 0x000000f0, 0x00280e22, 0x000 },
    { 0x000000a0, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x0da },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d5 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0d4 },
    { 0x00003f00, 0x00400c11, 0x0d6 },
    { 0x00001f00, 0x00400c11, 0x0d6 },
    { 0x00000f00, 0x00200c11, 0x000 },
    { 0x00380009, 0x00294a23, 0x000 },
    { 0x3f000000, 0x00280e2b, 0x000 },
    { 0x00000002, 0x00220e23, 0x000 },
    { 0x00000007, 0x00494a23, 0x0dc },
    { 0x00380f09, 0x00204811, 0x000 },
    { 0x68000007, 0x00204811, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000a202, 0x00204411, 0x000 },
    { 0x00ff0000, 0x00280e22, 0x000 },
    { 0x00000080, 0x00294a23, 0x000 },
    { 0x00000027, 0x00200e2d, 0x000 },
    { 0x00000026, 0x0020122d, 0x000 },
    { 0x00000000, 0x002f0083, 0x000 },
    { 0x00000000, 0x0ce00000, 0x0ea },
    { 0x00000000, 0x00600000, 0x5f9 },
    { 0x00000000, 0x00400000, 0x0eb },
    { 0x00000000, 0x00600000, 0x5fc },
    { 0x00000007, 0x0020222d, 0x000 },
    { 0x00000005, 0x00220e22, 0x000 },
    { 0x00100000, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000000, 0x003a0c02, 0x000 },
    { 0x000000ef, 0x00280e23, 0x000 },
    { 0x00000000, 0x00292068, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000003, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x0f8 },
    { 0x0000000b, 0x00210228, 0x000 },
    { 0x00000000, 0x14c00000, 0x0f8 },
    { 0x00000400, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000001c, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x0fd },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000001e, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x10b },
    { 0x0000a30f, 0x00204411, 0x000 },
    { 0x00000011, 0x00200e2d, 0x000 },
    { 0x00000001, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x104 },
    { 0xffffffff, 0x00404811, 0x10b },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x107 },
    { 0x0000ffff, 0x00404811, 0x10b },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x10a },
    { 0x000000ff, 0x00404811, 0x10b },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0002c400, 0x00204411, 0x000 },
    { 0x0000001f, 0x00210e22, 0x000 },
    { 0x00000000, 0x14c00000, 0x112 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000018, 0x40224a20, 0x000 },
    { 0x00000010, 0xc0424a20, 0x114 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x00000013, 0x00203623, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000000a, 0x00201011, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x11b },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00531224, 0x117 },
    { 0xffbfffff, 0x00283a2e, 0x000 },
    { 0x0000001b, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x12e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000d, 0x00204811, 0x000 },
    { 0x00000018, 0x00220e30, 0x000 },
    { 0xfc000000, 0x00280e23, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x00000000, 0x00201010, 0x000 },
    { 0x0000e00e, 0x00204411, 0x000 },
    { 0x07f8ff08, 0x00204811, 0x000 },
    { 0x00000000, 0x00294a23, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a24, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00800000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204806, 0x000 },
    { 0x00000008, 0x00214a27, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x622 },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x621 },
    { 0x00000004, 0x00404c11, 0x135 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000001c, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x622 },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x13c },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40280620, 0x000 },
    { 0x00000010, 0xc0210a20, 0x000 },
    { 0x00000000, 0x00341461, 0x000 },
    { 0x00000000, 0x00741882, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x147 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x160 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0681a20, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x158 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000001, 0x00300a2f, 0x000 },
    { 0x00000001, 0x00210a22, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600000, 0x18f },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00202c08, 0x000 },
    { 0x00000000, 0x00202411, 0x000 },
    { 0x00000000, 0x00202811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000002, 0x00221e29, 0x000 },
    { 0x00000000, 0x007048eb, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000001, 0x40330620, 0x000 },
    { 0x00000000, 0xc0302409, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ae00000, 0x181 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x186 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x186 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000001, 0x00530621, 0x182 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0604800, 0x197 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000011, 0x0020062d, 0x000 },
    { 0x00000000, 0x0078042a, 0x2fb },
    { 0x00000000, 0x00202809, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x174 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x194 },
    { 0x00000015, 0xc0203620, 0x000 },
    { 0x00000016, 0xc0203620, 0x000 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x46000000, 0x00600811, 0x1b2 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x19b },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00804811, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000ffff, 0x40281620, 0x000 },
    { 0x00000010, 0xc0811a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x00000008, 0x00221e30, 0x000 },
    { 0x00000029, 0x00201a2d, 0x000 },
    { 0x0000e000, 0x00204411, 0x000 },
    { 0xfffbff09, 0x00204811, 0x000 },
    { 0x0000000f, 0x0020222d, 0x000 },
    { 0x00001fff, 0x00294a28, 0x000 },
    { 0x00000006, 0x0020222d, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000100, 0x00201811, 0x000 },
    { 0x00000008, 0x00621e28, 0x12f },
    { 0x00000008, 0x00822228, 0x000 },
    { 0x0002c000, 0x00204411, 0x000 },
    { 0x00000015, 0x00600e2d, 0x1bd },
    { 0x00000016, 0x00600e2d, 0x1bd },
    { 0x0000c008, 0x00204411, 0x000 },
    { 0x00000017, 0x00200e2d, 0x000 },
    { 0x00000000, 0x14c00000, 0x1b9 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x39000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00804802, 0x000 },
    { 0x00000018, 0x00202e2d, 0x000 },
    { 0x00000000, 0x003b0d63, 0x000 },
    { 0x00000008, 0x00224a23, 0x000 },
    { 0x00000010, 0x00224a23, 0x000 },
    { 0x00000018, 0x00224a23, 0x000 },
    { 0x00000000, 0x00804803, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00000007, 0x0021062f, 0x000 },
    { 0x00000013, 0x00200a2d, 0x000 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000ffff, 0x40282220, 0x000 },
    { 0x0000000f, 0x00262228, 0x000 },
    { 0x00000010, 0x40212620, 0x000 },
    { 0x0000000f, 0x00262629, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1e0 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000081, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000080, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1dc },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1d8 },
    { 0x00000001, 0x00202c11, 0x000 },
    { 0x0000001f, 0x00280a22, 0x000 },
    { 0x0000001f, 0x00282a2a, 0x000 },
    { 0x00000001, 0x00530621, 0x1d1 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000002, 0x00304a2f, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000001, 0x00301e2f, 0x000 },
    { 0x00000000, 0x002f0227, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00600000, 0x1e9 },
    { 0x00000001, 0x00531e27, 0x1e5 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x0000000f, 0x00260e23, 0x000 },
    { 0x00000010, 0xc0211220, 0x000 },
    { 0x0000000f, 0x00261224, 0x000 },
    { 0x00000000, 0x00201411, 0x000 },
    { 0x00000000, 0x00601811, 0x2bb },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022b, 0x000 },
    { 0x00000000, 0x0ce00000, 0x1f8 },
    { 0x00000010, 0x00221628, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a29, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x0020480a, 0x000 },
    { 0x00000000, 0x00202c11, 0x000 },
    { 0x00000010, 0x00221623, 0x000 },
    { 0xffff0000, 0x00281625, 0x000 },
    { 0x0000ffff, 0x00281a24, 0x000 },
    { 0x00000000, 0x002948c5, 0x000 },
    { 0x00000000, 0x00731503, 0x205 },
    { 0x00000000, 0x00201805, 0x000 },
    { 0x00000000, 0x00731524, 0x205 },
    { 0x00000000, 0x002d14c5, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00202802, 0x000 },
    { 0x00000000, 0x00202003, 0x000 },
    { 0x00000000, 0x00802404, 0x000 },
    { 0x0000000f, 0x00210225, 0x000 },
    { 0x00000000, 0x14c00000, 0x621 },
    { 0x00000000, 0x002b1405, 0x000 },
    { 0x00000001, 0x00901625, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001a, 0x00294a22, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a21, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000ffff, 0x40281220, 0x000 },
    { 0x00000010, 0xc0211a20, 0x000 },
    { 0x0000ffff, 0x40280e20, 0x000 },
    { 0x00000010, 0xc0211620, 0x000 },
    { 0x00000000, 0x00741465, 0x2bb },
    { 0x0001a1fd, 0x00604411, 0x2e0 },
    { 0x00000001, 0x00330621, 0x000 },
    { 0x00000000, 0x002f0221, 0x000 },
    { 0x00000000, 0x0cc00000, 0x219 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x212 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x5de },
    { 0x00000000, 0x0040040f, 0x213 },
    { 0x00000000, 0x00600000, 0x5d1 },
    { 0x00000000, 0x00600000, 0x5de },
    { 0x00000210, 0x00600411, 0x315 },
    { 0x00000000, 0x00600000, 0x1a0 },
    { 0x00000000, 0x00600000, 0x19c },
    { 0x00000000, 0x00600000, 0x2bb },
    { 0x00000000, 0x00600000, 0x2a3 },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204808, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ae00000, 0x232 },
    { 0x00000000, 0x00600000, 0x13a },
    { 0x00000000, 0x00400000, 0x236 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x236 },
    { 0x00000000, 0xc0404800, 0x233 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x00600411, 0x2fb },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000000, 0x00600000, 0x5d1 },
    { 0x0000a00c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000018, 0x40210a20, 0x000 },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x24c },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x00080101, 0x00292228, 0x000 },
    { 0x00000014, 0x00203628, 0x000 },
    { 0x0000a30c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x251 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000010, 0x00600411, 0x315 },
    { 0x3f800000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00000000, 0x00600000, 0x27c },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000001, 0x00211e27, 0x000 },
    { 0x00000000, 0x14e00000, 0x26a },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x0000ffff, 0x00281e27, 0x000 },
    { 0x00000000, 0x00341c27, 0x000 },
    { 0x00000000, 0x12c00000, 0x25f },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e5, 0x000 },
    { 0x00000000, 0x08c00000, 0x262 },
    { 0x00000000, 0x00201407, 0x000 },
    { 0x00000012, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00211e27, 0x000 },
    { 0x00000000, 0x00341c47, 0x000 },
    { 0x00000000, 0x12c00000, 0x267 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x08c00000, 0x26a },
    { 0x00000000, 0x00201807, 0x000 },
    { 0x00000000, 0x00600000, 0x2c1 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x00000000, 0x00342023, 0x000 },
    { 0x00000000, 0x12c00000, 0x272 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x271 },
    { 0x00000016, 0x00404811, 0x276 },
    { 0x00000018, 0x00404811, 0x276 },
    { 0x00000000, 0x00342044, 0x000 },
    { 0x00000000, 0x12c00000, 0x275 },
    { 0x00000017, 0x00404811, 0x276 },
    { 0x00000019, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0x00604411, 0x2e9 },
    { 0x00003fff, 0x002f022f, 0x000 },
    { 0x00000000, 0x0cc00000, 0x256 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x00000010, 0x40210620, 0x000 },
    { 0x0000ffff, 0xc0280a20, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x00000010, 0x40211620, 0x000 },
    { 0x0000ffff, 0xc0881a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00042004, 0x00604411, 0x622 },
    { 0x00000000, 0x00600000, 0x5d1 },
    { 0x00000000, 0xc0600000, 0x2a3 },
    { 0x00000005, 0x00200a2d, 0x000 },
    { 0x00000008, 0x00220a22, 0x000 },
    { 0x0000002b, 0x00201a2d, 0x000 },
    { 0x0000001c, 0x00201e2d, 0x000 },
    { 0x00007000, 0x00281e27, 0x000 },
    { 0x00000000, 0x00311ce6, 0x000 },
    { 0x0000002a, 0x00201a2d, 0x000 },
    { 0x0000000c, 0x00221a26, 0x000 },
    { 0x00000000, 0x002f00e6, 0x000 },
    { 0x00000000, 0x06e00000, 0x292 },
    { 0x00000000, 0x00201c11, 0x000 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000010, 0x00201811, 0x000 },
    { 0x00000000, 0x00691ce2, 0x12f },
    { 0x93800000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x95000000, 0x00204411, 0x000 },
    { 0x00000000, 0x002f022f, 0x000 },
    { 0x00000000, 0x0ce00000, 0x29d },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x92000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000001c, 0x00403627, 0x000 },
    { 0x0000000c, 0xc0220a20, 0x000 },
    { 0x00000029, 0x00203622, 0x000 },
    { 0x00000028, 0xc0403620, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000009, 0x00204811, 0x000 },
    { 0xa1000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00804811, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce3, 0x000 },
    { 0x00000021, 0x00203627, 0x000 },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002c1ce4, 0x000 },
    { 0x00000022, 0x00203627, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a3, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x00000000, 0x002d1d07, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203624, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000023, 0x00203627, 0x000 },
    { 0x00000000, 0x00311cc4, 0x000 },
    { 0x00000024, 0x00803627, 0x000 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14c00000, 0x2dc },
    { 0x00000000, 0x00400000, 0x2d9 },
    { 0x0000001a, 0x00203627, 0x000 },
    { 0x0000001b, 0x00203628, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000002, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2d9 },
    { 0x00000003, 0x00210227, 0x000 },
    { 0x00000000, 0x14e00000, 0x2dc },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e1, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120a1, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000024, 0x00201e2d, 0x000 },
    { 0x00000000, 0x002e00e2, 0x000 },
    { 0x00000000, 0x02c00000, 0x2dc },
    { 0x00000022, 0x00201e2d, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x00000000, 0x002e00e8, 0x000 },
    { 0x00000000, 0x06c00000, 0x2dc },
    { 0x00000000, 0x00600000, 0x5ff },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2b5 },
    { 0x00000000, 0x00600000, 0x5f6 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x00000000, 0x00600000, 0x2a7 },
    { 0x00000000, 0x00400000, 0x2de },
    { 0x0000001a, 0x00201e2d, 0x000 },
    { 0x0000001b, 0x0080222d, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000000, 0x00311ca1, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294847, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e21, 0x000 },
    { 0x00000000, 0x003120c2, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00311ca3, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294887, 0x000 },
    { 0x00000001, 0x00220a21, 0x000 },
    { 0x00000000, 0x003008a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000010, 0x00221e23, 0x000 },
    { 0x00000000, 0x003120c4, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x003808c5, 0x000 },
    { 0x00000000, 0x00300841, 0x000 },
    { 0x00000001, 0x00220a22, 0x000 },
    { 0x00000000, 0x003308a2, 0x000 },
    { 0x00000010, 0x00221e22, 0x000 },
    { 0x00000010, 0x00212222, 0x000 },
    { 0x00000000, 0x00894907, 0x000 },
    { 0x00000017, 0x0020222d, 0x000 },
    { 0x00000000, 0x14c00000, 0x318 },
    { 0xffffffef, 0x00280621, 0x000 },
    { 0x00000014, 0x0020222d, 0x000 },
    { 0x0000f8e0, 0x00204411, 0x000 },
    { 0x00000000, 0x00294901, 0x000 },
    { 0x00000000, 0x00894901, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x060a0200, 0x00804811, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x97000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0204811, 0x000 },
    { 0x8a000000, 0xc0204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00002257, 0x00204411, 0x000 },
    { 0x00000003, 0xc0484a20, 0x000 },
    { 0x0000225d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0x00600000, 0x5de },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00384a22, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0001a1fd, 0x00204411, 0x000 },
    { 0x00000000, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x00000001, 0x40304a20, 0x000 },
    { 0x00000002, 0xc0304a20, 0x000 },
    { 0x00000001, 0x00530a22, 0x355 },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x622 },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x35e },
    { 0x00000014, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x36c },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00604802, 0x374 },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x370 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x367 },
    { 0x00000028, 0x002f0222, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5ba },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x367 },
    { 0x0000002c, 0x00203626, 0x000 },
    { 0x00000049, 0x00201811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000001, 0x00331a26, 0x000 },
    { 0x00000000, 0x002f0226, 0x000 },
    { 0x00000000, 0x0cc00000, 0x376 },
    { 0x0000002c, 0x00801a2d, 0x000 },
    { 0x0000003f, 0xc0280a20, 0x000 },
    { 0x00000015, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x38c },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3b7 },
    { 0x00000016, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3b9 },
    { 0x00000020, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3a2 },
    { 0x0000000f, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3ae },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x3ae },
    { 0x0000001e, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x396 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x08000000, 0x00290a22, 0x000 },
    { 0x00000003, 0x40210e20, 0x000 },
    { 0x0000000c, 0xc0211220, 0x000 },
    { 0x00080000, 0x00281224, 0x000 },
    { 0x00000014, 0xc0221620, 0x000 },
    { 0x00000000, 0x002914a4, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x002948a2, 0x000 },
    { 0x0000a1fe, 0x00204411, 0x000 },
    { 0x00000000, 0x00404803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000016, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x622 },
    { 0x00000015, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x398 },
    { 0x0000210e, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000017, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x622 },
    { 0x00000003, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x3a4 },
    { 0x00002108, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404802, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x80000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000010, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3b4 },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000006, 0x00404811, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x374 },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x0000001d, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x3ce },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x00000018, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x622 },
    { 0x00000011, 0x00210230, 0x000 },
    { 0x00000000, 0x14e00000, 0x3c2 },
    { 0x00002100, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0xbabecafe, 0x00204811, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000004, 0x00404811, 0x000 },
    { 0x00002170, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000a, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x3d3 },
    { 0x8c000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00003fff, 0x40280a20, 0x000 },
    { 0x80000000, 0x40280e20, 0x000 },
    { 0x40000000, 0xc0281220, 0x000 },
    { 0x00040000, 0x00694622, 0x622 },
    { 0x00000000, 0x00201410, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3e1 },
    { 0x00000000, 0xc0401800, 0x3e4 },
    { 0x00003fff, 0xc0281a20, 0x000 },
    { 0x00040000, 0x00694626, 0x622 },
    { 0x00000000, 0x00201810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x3e7 },
    { 0x00000000, 0xc0401c00, 0x3ea },
    { 0x00003fff, 0xc0281e20, 0x000 },
    { 0x00040000, 0x00694627, 0x622 },
    { 0x00000000, 0x00201c10, 0x000 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0x002820c5, 0x000 },
    { 0x00000000, 0x004948e8, 0x000 },
    { 0xa5800000, 0x00200811, 0x000 },
    { 0x00002000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x40204800, 0x000 },
    { 0x0000001f, 0xc0210220, 0x000 },
    { 0x00000000, 0x14c00000, 0x3f7 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00008000, 0x00204811, 0x000 },
    { 0x0000ffff, 0xc0481220, 0x3ff },
    { 0xa7800000, 0x00200811, 0x000 },
    { 0x0000a000, 0x00200c11, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0x00204402, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000ffff, 0xc0281220, 0x000 },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00304883, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x83000000, 0x00604411, 0x412 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xa9800000, 0x00200811, 0x000 },
    { 0x0000c000, 0x00400c11, 0x3fa },
    { 0xab800000, 0x00200811, 0x000 },
    { 0x0000f8e0, 0x00400c11, 0x3fa },
    { 0xad800000, 0x00200811, 0x000 },
    { 0x0000f880, 0x00400c11, 0x3fa },
    { 0xb3800000, 0x00200811, 0x000 },
    { 0x0000f3fc, 0x00400c11, 0x3fa },
    { 0xaf800000, 0x00200811, 0x000 },
    { 0x0000e000, 0x00400c11, 0x3fa },
    { 0xb1800000, 0x00200811, 0x000 },
    { 0x0000f000, 0x00400c11, 0x3fa },
    { 0x83000000, 0x00204411, 0x000 },
    { 0x00002148, 0x00204811, 0x000 },
    { 0x84000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x1d000000, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x01182000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0218a000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0318c000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0418f8e0, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0518f880, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0618e000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0718f000, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x0818f3fc, 0xc0304620, 0x000 },
    { 0x00000000, 0xd9004800, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x00000033, 0xc0300a20, 0x000 },
    { 0x00000000, 0xc0403440, 0x000 },
    { 0x00000030, 0x00200a2d, 0x000 },
    { 0x00000000, 0xc0290c40, 0x000 },
    { 0x00000030, 0x00203623, 0x000 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x00a0000a, 0x000 },
    { 0x86000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x85000000, 0xc0204411, 0x000 },
    { 0x00000000, 0x00404801, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x00000018, 0x40210220, 0x000 },
    { 0x00000000, 0x14c00000, 0x447 },
    { 0x00800000, 0xc0494a20, 0x448 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x06e00000, 0x450 },
    { 0x00000004, 0x00200811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x622 },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00404c02, 0x450 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x00000000, 0xc0201400, 0x000 },
    { 0x00000000, 0xc0201800, 0x000 },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x461 },
    { 0x00000000, 0xc0202000, 0x000 },
    { 0x00000004, 0x002f0228, 0x000 },
    { 0x00000000, 0x06e00000, 0x461 },
    { 0x00000004, 0x00202011, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x00000010, 0x00280a23, 0x000 },
    { 0x00000010, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ce00000, 0x469 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0x00694624, 0x622 },
    { 0x00000000, 0x00400000, 0x46e },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00604805, 0x627 },
    { 0x00000000, 0x002824f0, 0x000 },
    { 0x00000007, 0x00280a23, 0x000 },
    { 0x00000001, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x475 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x04e00000, 0x48e },
    { 0x00000000, 0x00400000, 0x49b },
    { 0x00000002, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x47a },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x02e00000, 0x48e },
    { 0x00000000, 0x00400000, 0x49b },
    { 0x00000003, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x47f },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ce00000, 0x48e },
    { 0x00000000, 0x00400000, 0x49b },
    { 0x00000004, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x484 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x0ae00000, 0x48e },
    { 0x00000000, 0x00400000, 0x49b },
    { 0x00000005, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x489 },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x06e00000, 0x48e },
    { 0x00000000, 0x00400000, 0x49b },
    { 0x00000006, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x48e },
    { 0x00000000, 0x002f00c9, 0x000 },
    { 0x00000000, 0x08e00000, 0x48e },
    { 0x00000000, 0x00400000, 0x49b },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x000 },
    { 0x00000008, 0x00210a23, 0x000 },
    { 0x00000000, 0x14c00000, 0x498 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00007f00, 0x00280a21, 0x000 },
    { 0x00004500, 0x002f0222, 0x000 },
    { 0x00000000, 0x0ae00000, 0x4a1 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x00404c08, 0x461 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000010, 0x40210e20, 0x000 },
    { 0x00000011, 0x40211220, 0x000 },
    { 0x00000012, 0x40211620, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00210225, 0x000 },
    { 0x00000000, 0x14e00000, 0x4ab },
    { 0x00040000, 0xc0494a20, 0x4ac },
    { 0xfffbffff, 0xc0284a20, 0x000 },
    { 0x00000000, 0x00210223, 0x000 },
    { 0x00000000, 0x14e00000, 0x4b8 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x0000000c, 0x00204811, 0x000 },
    { 0x00000000, 0x00200010, 0x000 },
    { 0x00000000, 0x14c00000, 0x4b4 },
    { 0xa0000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000004, 0x00204811, 0x000 },
    { 0x0000216b, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000216c, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204810, 0x000 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0ce00000, 0x000 },
    { 0x00000000, 0x00400000, 0x4b2 },
    { 0x00000000, 0xc0210a20, 0x000 },
    { 0x00000000, 0x14c00000, 0x4cb },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x627 },
    { 0x00000000, 0x00400000, 0x4cf },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00040000, 0xc0294620, 0x000 },
    { 0x00000000, 0xc0600000, 0x622 },
    { 0x00000001, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x4d6 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00404811, 0x000 },
    { 0x00000000, 0xc0204400, 0x000 },
    { 0x00000000, 0xc0404810, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x000021f8, 0x00204411, 0x000 },
    { 0x0000000e, 0x00204811, 0x000 },
    { 0x000421f9, 0x00604411, 0x622 },
    { 0x00000000, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x4d8 },
    { 0x00002180, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000003, 0x00333e2f, 0x000 },
    { 0x00000001, 0x00210221, 0x000 },
    { 0x00000000, 0x14e00000, 0x508 },
    { 0x0000002c, 0x00200a2d, 0x000 },
    { 0x00040000, 0x18e00c11, 0x4f7 },
    { 0x00000001, 0x00333e2f, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xd8c04800, 0x4eb },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000002d, 0x0020122d, 0x000 },
    { 0x00000000, 0x00290c83, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204802, 0x000 },
    { 0x00000000, 0x00204803, 0x000 },
    { 0x00000008, 0x00300a22, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000011, 0x00210224, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000000, 0x00400000, 0x4b2 },
    { 0x0000002c, 0xc0203620, 0x000 },
    { 0x0000002d, 0xc0403620, 0x000 },
    { 0x0000000f, 0x00210221, 0x000 },
    { 0x00000000, 0x14c00000, 0x50d },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00000000, 0xd9000000, 0x000 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0xb5000000, 0x00204411, 0x000 },
    { 0x00002000, 0x00204811, 0x000 },
    { 0xb6000000, 0x00204411, 0x000 },
    { 0x0000a000, 0x00204811, 0x000 },
    { 0xb7000000, 0x00204411, 0x000 },
    { 0x0000c000, 0x00204811, 0x000 },
    { 0xb8000000, 0x00204411, 0x000 },
    { 0x0000f8e0, 0x00204811, 0x000 },
    { 0xb9000000, 0x00204411, 0x000 },
    { 0x0000f880, 0x00204811, 0x000 },
    { 0xba000000, 0x00204411, 0x000 },
    { 0x0000e000, 0x00204811, 0x000 },
    { 0xbb000000, 0x00204411, 0x000 },
    { 0x0000f000, 0x00204811, 0x000 },
    { 0xbc000000, 0x00204411, 0x000 },
    { 0x0000f3fc, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000002, 0x00204811, 0x000 },
    { 0x000000ff, 0x00280e30, 0x000 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x521 },
    { 0x00000000, 0xc0200800, 0x000 },
    { 0x00000000, 0x14c00000, 0x536 },
    { 0x00000000, 0x00200c11, 0x000 },
    { 0x0000001c, 0x00203623, 0x000 },
    { 0x0000002b, 0x00203623, 0x000 },
    { 0x00000029, 0x00203623, 0x000 },
    { 0x00000028, 0x00203623, 0x000 },
    { 0x00000017, 0x00203623, 0x000 },
    { 0x00000025, 0x00203623, 0x000 },
    { 0x00000026, 0x00203623, 0x000 },
    { 0x00000015, 0x00203623, 0x000 },
    { 0x00000016, 0x00203623, 0x000 },
    { 0xffffe000, 0x00200c11, 0x000 },
    { 0x00000021, 0x00203623, 0x000 },
    { 0x00000022, 0x00203623, 0x000 },
    { 0x00001fff, 0x00200c11, 0x000 },
    { 0x00000023, 0x00203623, 0x000 },
    { 0x00000024, 0x00203623, 0x000 },
    { 0xf1ffffff, 0x00283a2e, 0x000 },
    { 0x0000001a, 0xc0220e20, 0x000 },
    { 0x00000000, 0x0029386e, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000006, 0x00204811, 0x000 },
    { 0x0000002a, 0x40203620, 0x000 },
    { 0x87000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0x9d000000, 0x00204411, 0x000 },
    { 0x0000001f, 0x40214a20, 0x000 },
    { 0x96000000, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0200c00, 0x000 },
    { 0x00000000, 0xc0201000, 0x000 },
    { 0x0000001f, 0x00211624, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x0000001d, 0x00203623, 0x000 },
    { 0x00000003, 0x00281e23, 0x000 },
    { 0x00000008, 0x00222223, 0x000 },
    { 0xfffff000, 0x00282228, 0x000 },
    { 0x00000000, 0x002920e8, 0x000 },
    { 0x0000001f, 0x00203628, 0x000 },
    { 0x00000018, 0x00211e23, 0x000 },
    { 0x00000020, 0x00203627, 0x000 },
    { 0x00000002, 0x00221624, 0x000 },
    { 0x00000000, 0x003014a8, 0x000 },
    { 0x0000001e, 0x00203625, 0x000 },
    { 0x00000003, 0x00211a24, 0x000 },
    { 0x10000000, 0x00281a26, 0x000 },
    { 0xefffffff, 0x00283a2e, 0x000 },
    { 0x00000000, 0x004938ce, 0x610 },
    { 0x00000001, 0x40280a20, 0x000 },
    { 0x00000006, 0x40280e20, 0x000 },
    { 0x00000300, 0xc0281220, 0x000 },
    { 0x00000008, 0x00211224, 0x000 },
    { 0x00000000, 0xc0201620, 0x000 },
    { 0x00000000, 0xc0201a20, 0x000 },
    { 0x00000000, 0x00210222, 0x000 },
    { 0x00000000, 0x14c00000, 0x56c },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x622 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00020000, 0x00294a26, 0x000 },
    { 0x00000000, 0x00204810, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x574 },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x582 },
    { 0x00000002, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x574 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00002258, 0x00300a24, 0x000 },
    { 0x00040000, 0x00694622, 0x622 },
    { 0x00000000, 0xc0201c10, 0x000 },
    { 0x00000000, 0xc0400000, 0x582 },
    { 0x00000000, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x578 },
    { 0x00000000, 0xc0201c00, 0x000 },
    { 0x00000000, 0xc0400000, 0x582 },
    { 0x00000004, 0x002f0223, 0x000 },
    { 0x00000000, 0x0cc00000, 0x580 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x0000216d, 0x00204411, 0x000 },
    { 0x00000000, 0xc0204800, 0x000 },
    { 0x00000000, 0xc0604800, 0x627 },
    { 0x00000000, 0x00401c10, 0x582 },
    { 0x00000000, 0xc0200000, 0x000 },
    { 0x00000000, 0xc0400000, 0x000 },
    { 0x00000000, 0x0ee00000, 0x584 },
    { 0x00000000, 0x00600000, 0x5c3 },
    { 0x00000000, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x592 },
    { 0x0000a2b7, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x00000033, 0x0020262d, 0x000 },
    { 0x0000001a, 0x00212229, 0x000 },
    { 0x00000006, 0x00222629, 0x000 },
    { 0x0000a2c4, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x590 },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d1, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000001, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5a0 },
    { 0x0000a2bb, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x00000034, 0x0020262d, 0x000 },
    { 0x0000001a, 0x00212229, 0x000 },
    { 0x00000006, 0x00222629, 0x000 },
    { 0x0000a2c5, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x59e },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d2, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x00000002, 0x002f0224, 0x000 },
    { 0x00000000, 0x0cc00000, 0x5ae },
    { 0x0000a2bf, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x00000035, 0x0020262d, 0x000 },
    { 0x0000001a, 0x00212229, 0x000 },
    { 0x00000006, 0x00222629, 0x000 },
    { 0x0000a2c6, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5ac },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d3, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x0000a2c3, 0x00204411, 0x000 },
    { 0x00000000, 0x00204807, 0x000 },
    { 0x00000036, 0x0020262d, 0x000 },
    { 0x0000001a, 0x00212229, 0x000 },
    { 0x00000006, 0x00222629, 0x000 },
    { 0x0000a2c7, 0x00204411, 0x000 },
    { 0x00000000, 0x003048e9, 0x000 },
    { 0x00000000, 0x00e00000, 0x5b8 },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000000, 0x00404808, 0x000 },
    { 0x0000a2d4, 0x00204411, 0x000 },
    { 0x00000001, 0x00504a28, 0x000 },
    { 0x85000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0x0000304a, 0x00204411, 0x000 },
    { 0x01000000, 0x00204811, 0x000 },
    { 0x00000000, 0x00400000, 0x5be },
    { 0xa4000000, 0xc0204411, 0x000 },
    { 0x00000000, 0xc0404800, 0x000 },
    { 0x00000000, 0xc0600000, 0x5c3 },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x0000003f, 0x00204811, 0x000 },
    { 0x00000005, 0x00204811, 0x000 },
    { 0x0000a1f4, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x88000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0xff000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x00000002, 0x00804811, 0x000 },
    { 0x00000000, 0x0ee00000, 0x5d6 },
    { 0x00001000, 0x00200811, 0x000 },
    { 0x0000002b, 0x00203622, 0x000 },
    { 0x00000000, 0x00600000, 0x5da },
    { 0x00000000, 0x00600000, 0x5c3 },
    { 0x98000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00804811, 0x000 },
    { 0x00000000, 0xc0600000, 0x5da },
    { 0x00000000, 0xc0400400, 0x001 },
    { 0x0000a2a4, 0x00204411, 0x000 },
    { 0x00000022, 0x00204811, 0x000 },
    { 0x89000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00404811, 0x5cd },
    { 0x97000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x8a000000, 0x00204411, 0x000 },
    { 0x00000000, 0x00404811, 0x5cd },
    { 0x00000000, 0x00600000, 0x5f3 },
    { 0x0001a2a4, 0xc0204411, 0x000 },
    { 0x00000016, 0x00604811, 0x374 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x09800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x0004217f, 0x00604411, 0x622 },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x000 },
    { 0x00000004, 0x00404c11, 0x5ed },
    { 0x00000000, 0x00400000, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000004, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffffb, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0x00000008, 0x00291e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x00000017, 0x00201e2d, 0x000 },
    { 0xfffffff7, 0x00281e27, 0x000 },
    { 0x00000017, 0x00803627, 0x000 },
    { 0x0001a2a4, 0x00204411, 0x000 },
    { 0x00000016, 0x00604811, 0x374 },
    { 0x00002010, 0x00204411, 0x000 },
    { 0x00010000, 0x00204811, 0x000 },
    { 0x0000217c, 0x00204411, 0x000 },
    { 0x01800000, 0x00204811, 0x000 },
    { 0xffffffff, 0x00204811, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000000, 0x17000000, 0x000 },
    { 0x81000000, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0004217f, 0x00604411, 0x622 },
    { 0x0000001f, 0x00210230, 0x000 },
    { 0x00000000, 0x14c00000, 0x621 },
    { 0x00000010, 0x00404c11, 0x607 },
    { 0x00000000, 0xc0200400, 0x000 },
    { 0x00000000, 0x38c00000, 0x000 },
    { 0x0000001d, 0x00200a2d, 0x000 },
    { 0x0000001e, 0x00200e2d, 0x000 },
    { 0x0000001f, 0x0020122d, 0x000 },
    { 0x00000020, 0x0020162d, 0x000 },
    { 0x00002169, 0x00204411, 0x000 },
    { 0x00000000, 0x00204804, 0x000 },
    { 0x00000000, 0x00204805, 0x000 },
    { 0x00000000, 0x00204801, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000004, 0x00301224, 0x000 },
    { 0x00000000, 0x002f0064, 0x000 },
    { 0x00000000, 0x0cc00000, 0x620 },
    { 0x00000003, 0x00281a22, 0x000 },
    { 0x00000008, 0x00221222, 0x000 },
    { 0xfffff000, 0x00281224, 0x000 },
    { 0x00000000, 0x002910c4, 0x000 },
    { 0x0000001f, 0x00403624, 0x000 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x622 },
    { 0x9f000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x625 },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x1ac00000, 0x627 },
    { 0x9e000000, 0x00204411, 0x000 },
    { 0xcafebabe, 0x00204811, 0x000 },
    { 0x00000000, 0x1ae00000, 0x62a },
    { 0x00000000, 0x00800000, 0x000 },
    { 0x00000000, 0x00600000, 0x00b },
    { 0x00001000, 0x00600411, 0x315 },
    { 0x00000000, 0x00200411, 0x000 },
    { 0x00000000, 0x00600811, 0x1b2 },
    { 0x0000225c, 0x00204411, 0x000 },
    { 0x00000003, 0x00204811, 0x000 },
    { 0x00002256, 0x00204411, 0x000 },
    { 0x0000001b, 0x00204811, 0x000 },
    { 0x0000a1fc, 0x00204411, 0x000 },
    { 0x00000001, 0x00204811, 0x000 },
    { 0x0001a1fd, 0xc0204411, 0x000 },
    { 0x00000021, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000024, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000022, 0x0020222d, 0x000 },
    { 0x0000ffff, 0x00282228, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00204811, 0x000 },
    { 0x00000023, 0x00201e2d, 0x000 },
    { 0x00000010, 0x00221e27, 0x000 },
    { 0x00000000, 0x00294907, 0x000 },
    { 0x00000000, 0x00404811, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x00000000, 0x00000000, 0x000 },
    { 0x0142050a, 0x05ba0250, 0x000 },
    { 0x01c30168, 0x044105ba, 0x000 },
    { 0x02250209, 0x02500151, 0x000 },
    { 0x02230245, 0x02a00241, 0x000 },
    { 0x03d705ba, 0x05ba05ba, 0x000 },
    { 0x05e205e3, 0x031f05ba, 0x000 },
    { 0x032005bf, 0x0320034a, 0x000 },
    { 0x03340282, 0x034c033e, 0x000 },
    { 0x05ba05ba, 0x05ba05ba, 0x000 },
    { 0x05ba0557, 0x05ba032a, 0x000 },
    { 0x03bc05ba, 0x04c3034e, 0x000 },
    { 0x04a20455, 0x043f05ba, 0x000 },
    { 0x04d805ba, 0x044304e5, 0x000 },
    { 0x0455050f, 0x035b037b, 0x000 },
    { 0x05ba05ba, 0x05ba05ba, 0x000 },
    { 0x05ba05ba, 0x05ba05ba, 0x000 },
    { 0x05ba05ba, 0x05d805c1, 0x000 },
    { 0x05ba05ba, 0x000705ba, 0x000 },
    { 0x05ba05ba, 0x05ba05ba, 0x000 },
    { 0x05ba05ba, 0x05ba05ba, 0x000 },
    { 0x03f803ed, 0x04080406, 0x000 },
    { 0x040e040a, 0x040c0410, 0x000 },
    { 0x041c0418, 0x04240420, 0x000 },
    { 0x042c0428, 0x04340430, 0x000 },
    { 0x05ba05ba, 0x043a0438, 0x000 },
    { 0x05ba05ba, 0x05ba05ba, 0x000 },
    { 0x05ba05ba, 0x05ba05ba, 0x000 },
    { 0x0002060e, 0x062c0006, 0x000 },
};

static const u32 RS780_pfp_microcode[]={
0xca0400,
0xa00000,
0x7e828b,
0x7c038b,
0x8001db,
0x7c038b,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xc41838,
0xca2400,
0xca2800,
0x9581cb,
0xc41c3a,
0xc3c000,
0xca0800,
0xca0c00,
0x7c744b,
0xc20005,
0x99c000,
0xc41c3a,
0x7c744c,
0xc0ffe0,
0x042c08,
0x309002,
0x7d2500,
0x351402,
0x7d350b,
0x255407,
0x7cd580,
0x259c07,
0x95c004,
0xd5001b,
0x7eddc1,
0x7d9d80,
0xd6801b,
0xd5801b,
0xd4401e,
0xd5401e,
0xd6401e,
0xd6801e,
0xd4801e,
0xd4c01e,
0x9783d3,
0xd5c01e,
0xca0800,
0x80001a,
0xca0c00,
0xe4011e,
0xd4001e,
0x80000c,
0xc41838,
0xe4013e,
0xd4001e,
0x80000c,
0xc41838,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0xca0c00,
0x8001db,
0xd48024,
0xca0800,
0x7c00c0,
0xc81425,
0xc81824,
0x7c9488,
0x7c9880,
0xc20003,
0xd40075,
0x7c744c,
0x800064,
0xd4401e,
0xca1800,
0xd4401e,
0xd5801e,
0x800062,
0xd40075,
0xd4401e,
0xca0800,
0xca0c00,
0xca1000,
0xd48019,
0xd4c018,
0xd50017,
0xd4801e,
0xd4c01e,
0xd5001e,
0xe2001e,
0xca0400,
0xa00000,
0x7e828b,
0xd40075,
0xd4401e,
0xca0800,
0xca0c00,
0xca1000,
0xd48019,
0xd4c018,
0xd50017,
0xd4801e,
0xd4c01e,
0xd5001e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0x248c01,
0xd48060,
0x94c003,
0x041001,
0x041002,
0xd50025,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xd48061,
0xd4401e,
0x800000,
0xd4801e,
0xca0800,
0xca0c00,
0xd4401e,
0xd48016,
0xd4c016,
0xd4801e,
0x8001db,
0xd4c01e,
0xc60843,
0xca0c00,
0xca1000,
0x948004,
0xca1400,
0xe420f3,
0xd42013,
0xd56065,
0xd4e01c,
0xd5201c,
0xd5601c,
0x800000,
0x062001,
0xc60843,
0xca0c00,
0xca1000,
0x9483f7,
0xca1400,
0xe420f3,
0x80009c,
0xd42013,
0xc60843,
0xca0c00,
0xca1000,
0x9883ef,
0xca1400,
0xd40064,
0x8000b0,
0x000000,
0xc41432,
0xc61843,
0xc4082f,
0x954005,
0xc40c30,
0xd4401e,
0x800000,
0xee001e,
0x9583f5,
0xc41031,
0xd44033,
0xd52065,
0xd4a01c,
0xd4e01c,
0xd5201c,
0xe4015e,
0xd4001e,
0x800000,
0x062001,
0xca1800,
0x0a2001,
0xd60076,
0xc40836,
0x988007,
0xc61045,
0x950110,
0xd4001f,
0xd46062,
0x800000,
0xd42062,
0xcc3835,
0xcc1433,
0x8401de,
0xd40072,
0xd5401e,
0x800000,
0xee001e,
0xe2001a,
0x8401de,
0xe2001a,
0xcc104b,
0xcc0447,
0x2c9401,
0x7d098b,
0x984005,
0x7d15cb,
0xd4001a,
0x8001db,
0xd4006d,
0x344401,
0xcc0c48,
0x98403a,
0xcc2c4a,
0x958004,
0xcc0449,
0x8001db,
0xd4001a,
0xd4c01a,
0x282801,
0x840113,
0xcc1003,
0x98801b,
0x04380c,
0x840113,
0xcc1003,
0x988017,
0x043808,
0x840113,
0xcc1003,
0x988013,
0x043804,
0x840113,
0xcc1003,
0x988014,
0xcc104c,
0x9a8009,
0xcc144d,
0x9840dc,
0xd4006d,
0xcc1848,
0xd5001a,
0xd5401a,
0x8000ec,
0xd5801a,
0x96c0d5,
0xd4006d,
0x8001db,
0xd4006e,
0x9ac003,
0xd4006d,
0xd4006e,
0x800000,
0xec007f,
0x9ac0cc,
0xd4006d,
0x8001db,
0xd4006e,
0xcc1403,
0xcc1803,
0xcc1c03,
0x7d9103,
0x7dd583,
0x7d190c,
0x35cc1f,
0x35701f,
0x7cf0cb,
0x7cd08b,
0x880000,
0x7e8e8b,
0x95c004,
0xd4006e,
0x8001db,
0xd4001a,
0xd4c01a,
0xcc0803,
0xcc0c03,
0xcc1003,
0xcc1403,
0xcc1803,
0xcc1c03,
0xcc2403,
0xcc2803,
0x35c41f,
0x36b01f,
0x7c704b,
0x34f01f,
0x7c704b,
0x35701f,
0x7c704b,
0x7d8881,
0x7dccc1,
0x7e5101,
0x7e9541,
0x7c9082,
0x7cd4c2,
0x7c848b,
0x9ac003,
0x7c8c8b,
0x2c8801,
0x98809e,
0xd4006d,
0x98409c,
0xd4006e,
0xcc084c,
0xcc0c4d,
0xcc1048,
0xd4801a,
0xd4c01a,
0x800124,
0xd5001a,
0xcc0832,
0xd40032,
0x9482b6,
0xca0c00,
0xd4401e,
0x800000,
0xd4001e,
0xe4011e,
0xd4001e,
0xca0800,
0xca0c00,
0xca1000,
0xd4401e,
0xca1400,
0xd4801e,
0xd4c01e,
0xd5001e,
0xd5401e,
0xd54034,
0x800000,
0xee001e,
0x280404,
0xe2001a,
0xe2001a,
0xd4401a,
0xca3800,
0xcc0803,
0xcc0c03,
0xcc0c03,
0xcc0c03,
0x98829a,
0x000000,
0x8401de,
0xd7a06f,
0x800000,
0xee001f,
0xca0400,
0xc2ff00,
0xcc0834,
0xc13fff,
0x7c74cb,
0x7cc90b,
0x7d010f,
0x99028d,
0x7c738b,
0x8401de,
0xd7a06f,
0x800000,
0xee001f,
0xca0800,
0x281900,
0x7d898b,
0x958014,
0x281404,
0xca0c00,
0xca1000,
0xca1c00,
0xca2400,
0xe2001f,
0xd4c01a,
0xd5001a,
0xd5401a,
0xcc1803,
0xcc2c03,
0xcc2c03,
0xcc2c03,
0x7da58b,
0x7d9c47,
0x984274,
0x000000,
0x800184,
0xd4c01a,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xe4011e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xe4013e,
0xd4001e,
0xd4401e,
0xee001e,
0xca0400,
0xa00000,
0x7e828b,
0xca0800,
0x248c06,
0x0ccc06,
0x98c006,
0xcc104e,
0x990004,
0xd40073,
0xe4011e,
0xd4001e,
0xd4401e,
0xd4801e,
0x800000,
0xee001e,
0xca0800,
0xca0c00,
0x34d018,
0x251001,
0x950021,
0xc17fff,
0xca1000,
0xca1400,
0xca1800,
0xd4801d,
0xd4c01d,
0x7db18b,
0xc14202,
0xc2c001,
0xd5801d,
0x34dc0e,
0x7d5d4c,
0x7f734c,
0xd7401e,
0xd5001e,
0xd5401e,
0xc14200,
0xc2c000,
0x099c01,
0x31dc10,
0x7f5f4c,
0x7f734c,
0x042802,
0x7d8380,
0xd5a86f,
0xd58066,
0xd7401e,
0xec005e,
0xc82402,
0xc82402,
0x8001db,
0xd60076,
0xd4401e,
0xd4801e,
0xd4c01e,
0x800000,
0xee001e,
0x800000,
0xee001f,
0xd4001f,
0x800000,
0xd4001f,
0xd4001f,
0x880000,
0xd4001f,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x000000,
0x010194,
0x02019b,
0x0300b2,
0x0400a2,
0x050003,
0x06003f,
0x070032,
0x08014f,
0x090046,
0x0a0036,
0x1001d9,
0x1700c5,
0x22015d,
0x23016c,
0x2000d7,
0x240148,
0x26004d,
0x27005c,
0x28008d,
0x290051,
0x2a007e,
0x2b0061,
0x2f0088,
0x3200aa,
0x3401a2,
0x36006f,
0x3c0179,
0x3f0095,
0x4101af,
0x440151,
0x550196,
0x56019d,
0x60000b,
0x610034,
0x620038,
0x630038,
0x640038,
0x650038,
0x660038,
0x670038,
0x68003a,
0x690041,
0x6a0048,
0x6b0048,
0x6c0048,
0x6d0048,
0x6e0048,
0x6f0048,
0x7301d9,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
0x000006,
};

static const u32 RV770_cp_microcode[]={
0xcc0003ea,
0x7c408000,
0xa0000000,
0xcc800062,
0x80000001,
0xd040007f,
0x80000001,
0xcc400041,
0x7c40c000,
0xc0160004,
0x30d03fff,
0x7d15000c,
0xcc110000,
0x28d8001e,
0x31980001,
0x28dc001f,
0xc8200004,
0x95c00006,
0x7c424000,
0xcc000062,
0x7e56800c,
0xcc290000,
0xc8240004,
0x7e26000b,
0x95800006,
0x7c42c000,
0xcc000062,
0x7ed7000c,
0xcc310000,
0xc82c0004,
0x7e2e000c,
0xcc000062,
0x31103fff,
0x80000001,
0xce110000,
0x7c40c000,
0x80000001,
0xcc400040,
0x80000001,
0xcc412257,
0x7c418000,
0xcc400045,
0xcc400048,
0xcc41225c,
0xcc41a1fc,
0x7c408000,
0xa0000000,
0xcc800062,
0xcc400045,
0xcc400048,
0x7c40c000,
0xcc41225c,
0xcc41a1fc,
0x7c408000,
0xa0000000,
0xcc800062,
0xcc000045,
0xcc000048,
0xcc41225c,
0xcc41a1fc,
0x7c408000,
0xa0000000,
0xcc800062,
0x040ca1fd,
0xc0120001,
0xcc000045,
0xcc000048,
0x7cd0c00c,
0xcc41225c,
0xcc41a1fc,
0xd04d0000,
0x7c408000,
0xa0000000,
0xcc800062,
0x80000001,
0xcc41225d,
0x7c408000,
0x7c40c000,
0xc02a0002,
0x7c410000,
0x7d29000c,
0x30940001,
0x30980006,
0x309c0300,
0x29dc0008,
0x7c420000,
0x7c424000,
0x9540000f,
0xc02e0004,
0x05f02258,
0x7f2f000c,
0xcc310000,
0xc8280004,
0xccc12169,
0xcd01216a,
0xce81216b,
0x0db40002,
0xcc01216c,
0x9740000e,
0x0db40000,
0x8000007b,
0xc834000a,
0x0db40002,
0x97400009,
0x0db40000,
0xc02e0004,
0x05f02258,
0x7f2f000c,
0xcc310000,
0xc8280004,
0x8000007b,
0xc834000a,
0x97400004,
0x7e028000,
0x8000007b,
0xc834000a,
0x0db40004,
0x9740ff8c,
0x00000000,
0xce01216d,
0xce41216e,
0xc8280003,
0xc834000a,
0x9b400004,
0x043c0005,
0x8400026d,
0xcc000062,
0x0df40000,
0x9740000b,
0xc82c03e6,
0xce81a2b7,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c4,
0x80000001,
0xcfc1a2d1,
0x0df40001,
0x9740000b,
0xc82c03e7,
0xce81a2bb,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c5,
0x80000001,
0xcfc1a2d2,
0x0df40002,
0x9740000b,
0xc82c03e8,
0xce81a2bf,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c6,
0x80000001,
0xcfc1a2d3,
0xc82c03e9,
0xce81a2c3,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c7,
0x80000001,
0xcfc1a2d4,
0x80000001,
0xcc400042,
0x7c40c000,
0x7c410000,
0x2914001d,
0x31540001,
0x9940000d,
0x31181000,
0xc81c0011,
0x09dc0001,
0x95c0ffff,
0xc81c0011,
0xccc12100,
0xcd012101,
0xccc12102,
0xcd012103,
0x04180004,
0x8000039f,
0xcd81a2a4,
0xc02a0004,
0x95800008,
0x36a821a3,
0xcc290000,
0xc8280004,
0xc81c0011,
0x0de40040,
0x9640ffff,
0xc81c0011,
0xccc12170,
0xcd012171,
0xc8200012,
0x96000000,
0xc8200012,
0x8000039f,
0xcc000064,
0x7c40c000,
0x7c410000,
0xcc000045,
0xcc000048,
0x40d40003,
0xcd41225c,
0xcd01a1fc,
0xc01a0001,
0x041ca1fd,
0x7dd9c00c,
0x7c420000,
0x08cc0001,
0x06240001,
0x06280002,
0xce1d0000,
0xce5d0000,
0x98c0fffa,
0xce9d0000,
0x7c408000,
0xa0000000,
0xcc800062,
0x7c40c000,
0x30d00001,
0x28cc0001,
0x7c414000,
0x95000006,
0x7c418000,
0xcd41216d,
0xcd81216e,
0x800000f3,
0xc81c0003,
0xc0220004,
0x7e16000c,
0xcc210000,
0xc81c0004,
0x7c424000,
0x98c00004,
0x7c428000,
0x80000001,
0xcde50000,
0xce412169,
0xce81216a,
0xcdc1216b,
0x80000001,
0xcc01216c,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0x7c41c000,
0x28a40008,
0x326400ff,
0x0e68003c,
0x9680000a,
0x7c020000,
0x7c420000,
0x1e300003,
0xcc00006a,
0x9b000003,
0x42200005,
0x04200040,
0x80000110,
0x7c024000,
0x7e024000,
0x9a400000,
0x0a640001,
0x30ec0010,
0x9ac0000a,
0xcc000062,
0xc02a0004,
0xc82c0021,
0x7e92800c,
0xcc000041,
0xcc290000,
0xcec00021,
0x80000120,
0xc8300004,
0xcd01216d,
0xcd41216e,
0xc8300003,
0x7f1f000b,
0x30f40007,
0x27780001,
0x9740002a,
0x07b80125,
0x9f800000,
0x00000000,
0x80000135,
0x7f1b8004,
0x80000139,
0x7f1b8005,
0x8000013d,
0x7f1b8002,
0x80000141,
0x7f1b8003,
0x80000145,
0x7f1b8007,
0x80000149,
0x7f1b8006,
0x8000014e,
0x28a40008,
0x9b800019,
0x28a40008,
0x8000015e,
0x326400ff,
0x9b800015,
0x28a40008,
0x8000015e,
0x326400ff,
0x9b800011,
0x28a40008,
0x8000015e,
0x326400ff,
0x9b80000d,
0x28a40008,
0x8000015e,
0x326400ff,
0x9b800009,
0x28a40008,
0x8000015e,
0x326400ff,
0x9b800005,
0x28a40008,
0x8000015e,
0x326400ff,
0x28a40008,
0x326400ff,
0x0e68003c,
0x9a80feb1,
0x28ec0008,
0x7c434000,
0x7c438000,
0x7c43c000,
0x96c00007,
0xcc000062,
0xcf412169,
0xcf81216a,
0xcfc1216b,
0x80000001,
0xcc01216c,
0x80000001,
0xcff50000,
0xcc00006b,
0x840003a2,
0x0e68003c,
0x9a800004,
0xc8280015,
0x80000001,
0xd040007f,
0x9680ffab,
0x7e024000,
0x8400023b,
0xc00e0002,
0xcc000041,
0x80000239,
0xccc1304a,
0x7c40c000,
0x7c410000,
0xc01e0001,
0x29240012,
0xc0220002,
0x96400005,
0xc0260004,
0xc027fffb,
0x7d25000b,
0xc0260000,
0x7dd2800b,
0x7e12c00b,
0x7d25000c,
0x7c414000,
0x7c418000,
0xccc12169,
0x9a80000a,
0xcd01216a,
0xcd41216b,
0x96c0fe82,
0xcd81216c,
0xc8300018,
0x97000000,
0xc8300018,
0x80000001,
0xcc000018,
0x840003a2,
0xcc00007f,
0xc8140013,
0xc8180014,
0xcd41216b,
0x96c0fe76,
0xcd81216c,
0x80000182,
0xc8300018,
0xc80c0008,
0x98c00000,
0xc80c0008,
0x7c410000,
0x95000002,
0x00000000,
0x7c414000,
0xc8200009,
0xcc400043,
0xce01a1f4,
0xcc400044,
0xc00e8000,
0x7c424000,
0x7c428000,
0x2aac001f,
0x96c0fe63,
0xc035f000,
0xce4003e2,
0x32780003,
0x267c0008,
0x7ff7c00b,
0x7ffbc00c,
0x2a780018,
0xcfc003e3,
0xcf8003e4,
0x26b00002,
0x7f3f0000,
0xcf0003e5,
0x8000031f,
0x7c80c000,
0x7c40c000,
0x28d00008,
0x3110000f,
0x9500000f,
0x25280001,
0x06a801b3,
0x9e800000,
0x00000000,
0x800001d4,
0xc0120800,
0x800001e2,
0xc814000f,
0x800001e9,
0xc8140010,
0x800001f0,
0xccc1a2a4,
0x800001f9,
0xc8140011,
0x30d0003f,
0x0d280015,
0x9a800012,
0x0d28001e,
0x9a80001e,
0x0d280020,
0x9a800023,
0x0d24000f,
0x0d280010,
0x7e6a800c,
0x9a800026,
0x0d200004,
0x0d240014,
0x0d280028,
0x7e62400c,
0x7ea6800c,
0x9a80002a,
0xc8140011,
0x80000001,
0xccc1a2a4,
0xc0120800,
0x7c414000,
0x7d0cc00c,
0xc0120008,
0x29580003,
0x295c000c,
0x7c420000,
0x7dd1c00b,
0x26200014,
0x7e1e400c,
0x7e4e800c,
0xce81a2a4,
0x80000001,
0xcd81a1fe,
0xc814000f,
0x0410210e,
0x95400000,
0xc814000f,
0xd0510000,
0x80000001,
0xccc1a2a4,
0xc8140010,
0x04102108,
0x95400000,
0xc8140010,
0xd0510000,
0x80000001,
0xccc1a2a4,
0xccc1a2a4,
0x04100001,
0xcd000019,
0x840003a2,
0xcc00007f,
0xc8100019,
0x99000000,
0xc8100019,
0x80000002,
0x7c408000,
0x04102100,
0x09540001,
0x9540ffff,
0xc8140011,
0xd0510000,
0x8000039f,
0xccc1a2a4,
0x7c40c000,
0xcc40000d,
0x94c0fdff,
0xcc40000e,
0x7c410000,
0x95000005,
0x08cc0001,
0xc8140005,
0x99400014,
0x00000000,
0x98c0fffb,
0x7c410000,
0x80000002,
0x7d008000,
0xc8140005,
0x7c40c000,
0x9940000c,
0xc818000c,
0x7c410000,
0x9580fdee,
0xc820000e,
0xc81c000d,
0x66200020,
0x7e1e002c,
0x25240002,
0x7e624020,
0x80000001,
0xcce60000,
0x7c410000,
0xcc00006c,
0xcc00006d,
0xc818001f,
0xc81c001e,
0x65980020,
0x7dd9c02c,
0x7cd4c00c,
0xccde0000,
0x45dc0004,
0xc8280017,
0x9680000f,
0xc00e0001,
0x28680008,
0x2aac0016,
0x32a800ff,
0x0eb00049,
0x7f2f000b,
0x97000006,
0x00000000,
0xc8140005,
0x7c40c000,
0x80000223,
0x7c410000,
0x80000226,
0xd040007f,
0x8400023b,
0xcc000041,
0xccc1304a,
0x94000000,
0xc83c001a,
0x043c0005,
0xcfc1a2a4,
0xc0361f90,
0xc0387fff,
0x7c03c010,
0x7f7b400c,
0xcf41217c,
0xcfc1217d,
0xcc01217e,
0xc03a0004,
0x0434217f,
0x7f7b400c,
0xcc350000,
0xc83c0004,
0x2bfc001f,
0x04380020,
0x97c00005,
0xcc000062,
0x9b800000,
0x0bb80001,
0x80000247,
0xcc000071,
0xcc01a1f4,
0x04380016,
0xc0360002,
0xcf81a2a4,
0x88000000,
0xcf412010,
0x7c40c000,
0x28d0001c,
0x95000005,
0x04d40001,
0xcd400065,
0x80000001,
0xcd400068,
0x09540002,
0x80000001,
0xcd400066,
0x8400026c,
0xc81803ea,
0x7c40c000,
0x9980fd9d,
0xc8140016,
0x08d00001,
0x9940002b,
0xcd000068,
0x7c408000,
0xa0000000,
0xcc800062,
0x043c0005,
0xcfc1a2a4,
0xcc01a1f4,
0x840003a2,
0xcc000046,
0x88000000,
0xcc00007f,
0x8400027e,
0xc81803ea,
0x7c40c000,
0x9980fd8b,
0xc8140016,
0x08d00001,
0x99400019,
0xcd000068,
0x7c408000,
0xa0000000,
0xcc800062,
0x043c0022,
0xcfc1a2a4,
0x840003a2,
0xcc000047,
0x88000000,
0xcc00007f,
0xc8100016,
0x9900000d,
0xcc400067,
0x80000002,
0x7c408000,
0xc81803ea,
0x9980fd77,
0x7c40c000,
0x94c00003,
0xc8100016,
0x99000004,
0xccc00068,
0x80000002,
0x7c408000,
0x8400023b,
0xc0148000,
0xcc000041,
0xcd41304a,
0xc0148000,
0x99000000,
0xc8100016,
0x80000002,
0x7c408000,
0xc0120001,
0x7c51400c,
0x80000001,
0xd0550000,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0x291c001f,
0xccc0004a,
0xcd00004b,
0x95c00003,
0xc01c8000,
0xcdc12010,
0xdd830000,
0x055c2000,
0xcc000062,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc0004c,
0xcd00004d,
0xdd830000,
0x055ca000,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc0004e,
0xcd00004f,
0xdd830000,
0x055cc000,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00050,
0xcd000051,
0xdd830000,
0x055cf8e0,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00052,
0xcd000053,
0xdd830000,
0x055cf880,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00054,
0xcd000055,
0xdd830000,
0x055ce000,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00056,
0xcd000057,
0xdd830000,
0x055cf000,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00058,
0xcd000059,
0xdd830000,
0x055cf3fc,
0x80000001,
0xd81f4100,
0xd0432000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043a000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043c000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f8e0,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f880,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043e000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f3fc,
0x7c408000,
0xa0000000,
0xcc800062,
0xc81403e0,
0xcc430000,
0xcc430000,
0xcc430000,
0x7d45c000,
0xcdc30000,
0xd0430000,
0x7c408000,
0xa0000000,
0xcc800062,
0x7c40c000,
0xc81003e2,
0xc81403e5,
0xc81803e3,
0xc81c03e4,
0xcd812169,
0xcdc1216a,
0xccc1216b,
0xcc01216c,
0x04200004,
0x7da18000,
0x7d964002,
0x9640fcd7,
0xcd8003e3,
0x31280003,
0xc02df000,
0x25180008,
0x7dad800b,
0x7da9800c,
0x80000001,
0xcd8003e3,
0x308cffff,
0xd04d0000,
0x7c408000,
0xa0000000,
0xcc800062,
0x7c40c000,
0x7c410000,
0x29240018,
0x32640001,
0x9a400013,
0xc8140020,
0x15580002,
0x9580ffff,
0xc8140020,
0xcc00006e,
0xccc12180,
0xcd01218d,
0xcc412181,
0x2914001f,
0x34588000,
0xcd81218c,
0x9540fcb9,
0xcc412182,
0xc8140020,
0x9940ffff,
0xc8140020,
0x80000002,
0x7c408000,
0x7c414000,
0x7c418000,
0x7c41c000,
0x65b40020,
0x7f57402c,
0xd4378100,
0x47740004,
0xd4378100,
0x47740004,
0xd4378100,
0x47740004,
0x09dc0004,
0xd4378100,
0x99c0fff8,
0x47740004,
0x2924001f,
0xc0380019,
0x9640fca1,
0xc03e0004,
0xcf8121f8,
0x37e021f9,
0xcc210000,
0xc8200004,
0x2a200018,
0x32200001,
0x9a00fffb,
0xcf8121f8,
0x80000002,
0x7c408000,
0x7c40c000,
0x28d00018,
0x31100001,
0xc0160080,
0x95000003,
0xc02a0004,
0x7cd4c00c,
0xccc1217c,
0xcc41217d,
0xcc41217e,
0x7c418000,
0x1db00003,
0x36a0217f,
0x9b000003,
0x419c0005,
0x041c0040,
0x99c00000,
0x09dc0001,
0xcc210000,
0xc8240004,
0x2a6c001f,
0x419c0005,
0x9ac0fffa,
0xcc800062,
0x80000002,
0x7c408000,
0x7c40c000,
0x04d403e6,
0x80000001,
0xcc540000,
0x8000039f,
0xcc4003ea,
0xc01c8000,
0x044ca000,
0xcdc12010,
0x7c410000,
0xc8140009,
0x04180000,
0x041c0008,
0xcd800071,
0x09dc0001,
0x05980001,
0xcd0d0000,
0x99c0fffc,
0xcc800062,
0x8000039f,
0xcd400071,
0xc00e0100,
0xcc000041,
0xccc1304a,
0xc83c007f,
0xcc00007f,
0x80000001,
0xcc00007f,
0xcc00007f,
0x88000000,
0xcc00007f,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00010333,
0x00100004,
0x00170006,
0x00210008,
0x00270028,
0x00280023,
0x00290029,
0x002a0026,
0x002b0029,
0x002d0038,
0x002e003f,
0x002f004a,
0x0034004c,
0x00360030,
0x003900af,
0x003a00d0,
0x003b00e5,
0x003c00fd,
0x003d016c,
0x003f00ad,
0x00410338,
0x0043036c,
0x0044018f,
0x004500fd,
0x004601ad,
0x004701ad,
0x00480200,
0x0049020e,
0x004a0257,
0x004b0284,
0x00520261,
0x00530273,
0x00540289,
0x0057029b,
0x0060029f,
0x006102ae,
0x006202b8,
0x006302c2,
0x006402cc,
0x006502d6,
0x006602e0,
0x006702ea,
0x006802f4,
0x006902f8,
0x006a02fc,
0x006b0300,
0x006c0304,
0x006d0308,
0x006e030c,
0x006f0310,
0x00700314,
0x00720386,
0x0074038c,
0x0079038a,
0x007c031e,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
0x000f039b,
};

static const u32 RV770_pfp_microcode[]={
0x7c408000,
0xa0000000,
0x7e82800b,
0x80000000,
0xdc030000,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xc818000e,
0x31980001,
0x7c424000,
0x95800252,
0x7c428000,
0xc81c001c,
0xc037c000,
0x7c40c000,
0x7c410000,
0x7cb4800b,
0xc0360003,
0x99c00000,
0xc81c001c,
0x7cb4800c,
0x24d40002,
0x7d654000,
0xcd400043,
0xce800043,
0xcd000043,
0xcc800040,
0xce400040,
0xce800040,
0xccc00040,
0xdc3a0000,
0x9780ffde,
0xcd000040,
0x7c40c000,
0x80000018,
0x7c410000,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xc818000e,
0x8000000c,
0x31980002,
0xd40003c0,
0xd4000fc0,
0xd4000fa2,
0xc818000e,
0x288c0008,
0x30cc000f,
0x34100001,
0x7d0d0008,
0x8000000c,
0x7d91800b,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xd40003c0,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xcc4003f9,
0x80000261,
0xcc4003f8,
0xc82003f8,
0xc81c03f9,
0xc81803fb,
0xc037ffff,
0x7c414000,
0xcf41a29e,
0x66200020,
0x7de1c02c,
0x7d58c008,
0x7cdcc020,
0x68d00020,
0xc0360003,
0xcc000054,
0x7cb4800c,
0x8000006a,
0xcc800040,
0x7c418000,
0xcd81a29e,
0xcc800040,
0xcd800040,
0x80000068,
0xcc000054,
0xc019ffff,
0xcc800040,
0xcd81a29e,
0x7c40c000,
0x7c410000,
0x7c414000,
0xccc1a1fa,
0xcd01a1f9,
0xcd41a29d,
0xccc00040,
0xcd000040,
0xcd400040,
0xcc400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xcc000054,
0xcc800040,
0x7c40c000,
0x7c410000,
0x7c414000,
0xccc1a1fa,
0xcd01a1f9,
0xcd41a29d,
0xccc00040,
0xcd000040,
0xcd400040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0x7c40c000,
0x30d00001,
0xccc1a29f,
0x95000003,
0x04140001,
0x04140002,
0xcd4003fb,
0xcc800040,
0x80000000,
0xccc00040,
0x7c40c000,
0xcc800040,
0xccc1a2a2,
0x80000000,
0xccc00040,
0x7c40c000,
0x28d4001f,
0xcc800040,
0x95400003,
0x7c410000,
0xccc00057,
0x2918001f,
0xccc00040,
0x95800003,
0xcd000040,
0xcd000058,
0x80000261,
0xcc00007f,
0xc8200017,
0xc8300022,
0x9a000006,
0x0e280001,
0xc824001e,
0x0a640001,
0xd4001240,
0xce400040,
0xc036c000,
0x96800007,
0x37747900,
0x041c0001,
0xcf400040,
0xcdc00040,
0xcf0003fa,
0x7c030000,
0xca0c0010,
0x7c410000,
0x94c00004,
0x7c414000,
0xd42002c4,
0xcde00044,
0x9b00000b,
0x7c418000,
0xcc00004b,
0xcda00049,
0xcd200041,
0xcd600041,
0xcda00041,
0x06200001,
0xce000056,
0x80000261,
0xcc00007f,
0xc8280020,
0xc82c0021,
0xcc000063,
0x7eea4001,
0x65740020,
0x7f53402c,
0x269c0002,
0x7df5c020,
0x69f80020,
0xce80004b,
0xce600049,
0xcde00041,
0xcfa00041,
0xce600041,
0x271c0002,
0x7df5c020,
0x69f80020,
0x7db24001,
0xcf00004b,
0xce600049,
0xcde00041,
0xcfa00041,
0x800000bd,
0xce600041,
0xc8200017,
0xc8300022,
0x9a000006,
0x0e280001,
0xc824001e,
0x0a640001,
0xd4001240,
0xce400040,
0xca0c0010,
0x7c410000,
0x94c0000b,
0xc036c000,
0x96800007,
0x37747900,
0x041c0001,
0xcf400040,
0xcdc00040,
0xcf0003fa,
0x7c030000,
0x800000b6,
0x7c414000,
0xcc000048,
0x800000ef,
0x00000000,
0xc8200017,
0xc81c0023,
0x0e240002,
0x99c00015,
0x7c418000,
0x0a200001,
0xce000056,
0xd4000440,
0xcc000040,
0xc036c000,
0xca140013,
0x96400007,
0x37747900,
0xcf400040,
0xcc000040,
0xc83003fa,
0x80000104,
0xcf000022,
0xcc000022,
0x9540015d,
0xcc00007f,
0xcca00046,
0x80000000,
0xcc200046,
0x80000261,
0xcc000064,
0xc8200017,
0xc810001f,
0x96000005,
0x09100001,
0xd4000440,
0xcd000040,
0xcd000022,
0xcc800040,
0xd0400040,
0xc80c0025,
0x94c0feeb,
0xc8100008,
0xcd000040,
0xd4000fc0,
0x80000000,
0xd4000fa2,
0x7c40c000,
0x7c410000,
0xccc003fd,
0xcd0003fc,
0xccc00042,
0xcd000042,
0x2914001f,
0x29180010,
0x31980007,
0x3b5c0001,
0x7d76000b,
0x99800005,
0x7d5e400b,
0xcc000042,
0x80000261,
0xcc00004d,
0x29980001,
0x292c0008,
0x9980003d,
0x32ec0001,
0x96000004,
0x2930000c,
0x80000261,
0xcc000042,
0x04140010,
0xcd400042,
0x33300001,
0x34280001,
0x8400015e,
0xc8140003,
0x9b40001b,
0x0438000c,
0x8400015e,
0xc8140003,
0x9b400017,
0x04380008,
0x8400015e,
0xc8140003,
0x9b400013,
0x04380004,
0x8400015e,
0xc8140003,
0x9b400015,
0xc80c03fd,
0x9a800009,
0xc81003fc,
0x9b000118,
0xcc00004d,
0x04140010,
0xccc00042,
0xcd000042,
0x80000136,
0xcd400042,
0x96c00111,
0xcc00004d,
0x80000261,
0xcc00004e,
0x9ac00003,
0xcc00004d,
0xcc00004e,
0xdf830000,
0x80000000,
0xd80301ff,
0x9ac00107,
0xcc00004d,
0x80000261,
0xcc00004e,
0xc8180003,
0xc81c0003,
0xc8200003,
0x7d5d4003,
0x7da1c003,
0x7d5d400c,
0x2a10001f,
0x299c001f,
0x7d1d000b,
0x7d17400b,
0x88000000,
0x7e92800b,
0x96400004,
0xcc00004e,
0x80000261,
0xcc000042,
0x04380008,
0xcf800042,
0xc8080003,
0xc80c0003,
0xc8100003,
0xc8140003,
0xc8180003,
0xc81c0003,
0xc8240003,
0xc8280003,
0x29fc001f,
0x2ab0001f,
0x7ff3c00b,
0x28f0001f,
0x7ff3c00b,
0x2970001f,
0x7ff3c00b,
0x7d888001,
0x7dccc001,
0x7e510001,
0x7e954001,
0x7c908002,
0x7cd4c002,
0x7cbc800b,
0x9ac00003,
0x7c8f400b,
0x38b40001,
0x9b4000d8,
0xcc00004d,
0x9bc000d6,
0xcc00004e,
0xc80c03fd,
0xc81003fc,
0xccc00042,
0x8000016f,
0xcd000042,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xcc400040,
0xcc400040,
0xcc400040,
0x7c40c000,
0xccc00040,
0xccc0000d,
0x80000000,
0xd0400040,
0x7c40c000,
0x7c410000,
0x65140020,
0x7d4d402c,
0x24580002,
0x7d598020,
0x7c41c000,
0xcd800042,
0x69980020,
0xcd800042,
0xcdc00042,
0xc023c000,
0x05e40002,
0x7ca0800b,
0x26640010,
0x7ca4800c,
0xcc800040,
0xcdc00040,
0xccc00040,
0x95c0000e,
0xcd000040,
0x09dc0001,
0xc8280003,
0x96800008,
0xce800040,
0xc834001d,
0x97400000,
0xc834001d,
0x26a80008,
0x84000264,
0xcc2b0000,
0x99c0fff7,
0x09dc0001,
0xdc3a0000,
0x97800004,
0x7c418000,
0x800001a3,
0x25980002,
0xa0000000,
0x7d808000,
0xc818001d,
0x7c40c000,
0x64d00008,
0x95800000,
0xc818001d,
0xcc130000,
0xcc800040,
0xccc00040,
0x80000000,
0xcc400040,
0xc810001f,
0x7c40c000,
0xcc800040,
0x7cd1400c,
0xcd400040,
0x05180001,
0x80000000,
0xcd800022,
0x7c40c000,
0x64500020,
0x84000264,
0xcc000061,
0x7cd0c02c,
0xc8200017,
0xc8d60000,
0x99400008,
0x7c438000,
0xdf830000,
0xcfa0004f,
0x84000264,
0xcc000062,
0x80000000,
0xd040007f,
0x80000261,
0xcc000062,
0x84000264,
0xcc000061,
0xc8200017,
0x7c40c000,
0xc036ff00,
0xc810000d,
0xc0303fff,
0x7cf5400b,
0x7d51800b,
0x7d81800f,
0x99800008,
0x7cf3800b,
0xdf830000,
0xcfa0004f,
0x84000264,
0xcc000062,
0x80000000,
0xd040007f,
0x80000261,
0xcc000062,
0x84000264,
0x7c40c000,
0x28dc0008,
0x95c00019,
0x30dc0010,
0x7c410000,
0x99c00004,
0x64540020,
0x80000209,
0xc91d0000,
0x7d15002c,
0xc91e0000,
0x7c420000,
0x7c424000,
0x7c418000,
0x7de5c00b,
0x7de28007,
0x9a80000e,
0x41ac0005,
0x9ac00000,
0x0aec0001,
0x30dc0010,
0x99c00004,
0x00000000,
0x8000020c,
0xc91d0000,
0x8000020c,
0xc91e0000,
0xcc800040,
0xccc00040,
0xd0400040,
0xc80c0025,
0x94c0fde3,
0xc8100008,
0xcd000040,
0xd4000fc0,
0x80000000,
0xd4000fa2,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xd40003c0,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0x7c40c000,
0x30d00006,
0x0d100006,
0x99000007,
0xc8140015,
0x99400005,
0xcc000052,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xccc00040,
0x80000000,
0xd0400040,
0x7c40c000,
0xcc4d0000,
0xdc3a0000,
0x9780fdbc,
0x04cc0001,
0x80000243,
0xcc4d0000,
0x7c40c000,
0x7c410000,
0x29240018,
0x32640001,
0x9640000f,
0xcc800040,
0x7c414000,
0x7c418000,
0x7c41c000,
0xccc00043,
0xcd000043,
0x31dc7fff,
0xcdc00043,
0xccc00040,
0xcd000040,
0xcd400040,
0xcd800040,
0x80000000,
0xcdc00040,
0xccc00040,
0xcd000040,
0x80000000,
0xd0400040,
0x80000000,
0xd040007f,
0xcc00007f,
0x80000000,
0xcc00007f,
0xcc00007f,
0x88000000,
0xcc00007f,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00030223,
0x0004022b,
0x000500a0,
0x00020003,
0x0006003c,
0x00070027,
0x00080192,
0x00090044,
0x000a002d,
0x0010025f,
0x001700f1,
0x002201d8,
0x002301e9,
0x0026004c,
0x0027005f,
0x0020011b,
0x00280093,
0x0029004f,
0x002a0084,
0x002b0065,
0x002f008e,
0x003200d9,
0x00340233,
0x00360075,
0x0039010b,
0x003c01fd,
0x003f00a0,
0x00410248,
0x00440195,
0x0048019e,
0x004901c6,
0x004a01d0,
0x00550226,
0x0056022e,
0x0060000a,
0x0061002a,
0x00620030,
0x00630030,
0x00640030,
0x00650030,
0x00660030,
0x00670030,
0x00680037,
0x0069003f,
0x006a0047,
0x006b0047,
0x006c0047,
0x006d0047,
0x006e0047,
0x006f0047,
0x00700047,
0x0073025f,
0x007b0241,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
};

static const u32 RV730_pfp_microcode[]={
0x7c408000,
0xa0000000,
0x7e82800b,
0x80000000,
0xdc030000,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xc818000e,
0x31980001,
0x7c424000,
0x9580023a,
0x7c428000,
0xc81c001c,
0xc037c000,
0x7c40c000,
0x7c410000,
0x7cb4800b,
0xc0360003,
0x99c00000,
0xc81c001c,
0x7cb4800c,
0x24d40002,
0x7d654000,
0xcd400043,
0xce800043,
0xcd000043,
0xcc800040,
0xce400040,
0xce800040,
0xccc00040,
0xdc3a0000,
0x9780ffde,
0xcd000040,
0x7c40c000,
0x80000018,
0x7c410000,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xc818000e,
0x8000000c,
0x31980002,
0xd40003c0,
0xd4000fc0,
0xd4000fa2,
0xc818000e,
0x288c0008,
0x30cc000f,
0x34100001,
0x7d0d0008,
0x8000000c,
0x7d91800b,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xd40003c0,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xcc4003f9,
0x80000249,
0xcc4003f8,
0xc037ffff,
0x7c414000,
0xcf41a29e,
0xc82003f8,
0xc81c03f9,
0x66200020,
0xc81803fb,
0x7de1c02c,
0x7d58c008,
0x7cdcc020,
0x69100020,
0xc0360003,
0xcc000054,
0x7cb4800c,
0x80000069,
0xcc800040,
0x7c418000,
0xcd81a29e,
0xcc800040,
0x80000067,
0xcd800040,
0xc019ffff,
0xcc800040,
0xcd81a29e,
0x7c40c000,
0x7c410000,
0x7c414000,
0xccc1a1fa,
0xcd01a1f9,
0xcd41a29d,
0xccc00040,
0xcd000040,
0xcd400040,
0xcc400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xcc000054,
0xcc800040,
0x7c40c000,
0x7c410000,
0x7c414000,
0xccc1a1fa,
0xcd01a1f9,
0xcd41a29d,
0xccc00040,
0xcd000040,
0xcd400040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0x7c40c000,
0x30d00001,
0xccc1a29f,
0x95000003,
0x04140001,
0x04140002,
0xcd4003fb,
0xcc800040,
0x80000000,
0xccc00040,
0x7c40c000,
0xcc800040,
0xccc1a2a2,
0x80000000,
0xccc00040,
0x7c40c000,
0x28d4001f,
0xcc800040,
0x95400003,
0x7c410000,
0xccc00057,
0x2918001f,
0xccc00040,
0x95800003,
0xcd000040,
0xcd000058,
0x80000249,
0xcc00007f,
0xc8200017,
0xc8300022,
0x9a000006,
0x0e280001,
0xc824001e,
0x0a640001,
0xd4001240,
0xce400040,
0xc036c000,
0x96800007,
0x37747900,
0x041c0001,
0xcf400040,
0xcdc00040,
0xcf0003fa,
0x7c030000,
0xca0c0010,
0x7c410000,
0x94c00004,
0x7c414000,
0xd42002c4,
0xcde00044,
0x9b00000b,
0x7c418000,
0xcc00004b,
0xcda00049,
0xcd200041,
0xcd600041,
0xcda00041,
0x06200001,
0xce000056,
0x80000249,
0xcc00007f,
0xc8280020,
0xc82c0021,
0xcc000063,
0x7eea4001,
0x65740020,
0x7f53402c,
0x269c0002,
0x7df5c020,
0x69f80020,
0xce80004b,
0xce600049,
0xcde00041,
0xcfa00041,
0xce600041,
0x271c0002,
0x7df5c020,
0x69f80020,
0x7db24001,
0xcf00004b,
0xce600049,
0xcde00041,
0xcfa00041,
0x800000bc,
0xce600041,
0xc8200017,
0xc8300022,
0x9a000006,
0x0e280001,
0xc824001e,
0x0a640001,
0xd4001240,
0xce400040,
0xca0c0010,
0x7c410000,
0x94c0000b,
0xc036c000,
0x96800007,
0x37747900,
0x041c0001,
0xcf400040,
0xcdc00040,
0xcf0003fa,
0x7c030000,
0x800000b5,
0x7c414000,
0xcc000048,
0x800000ee,
0x00000000,
0xc8200017,
0xc81c0023,
0x0e240002,
0x99c00015,
0x7c418000,
0x0a200001,
0xce000056,
0xd4000440,
0xcc000040,
0xc036c000,
0xca140013,
0x96400007,
0x37747900,
0xcf400040,
0xcc000040,
0xc83003fa,
0x80000103,
0xcf000022,
0xcc000022,
0x95400146,
0xcc00007f,
0xcca00046,
0x80000000,
0xcc200046,
0x80000249,
0xcc000064,
0xc8200017,
0xc810001f,
0x96000005,
0x09100001,
0xd4000440,
0xcd000040,
0xcd000022,
0xcc800040,
0xd0400040,
0xc80c0025,
0x94c0feec,
0xc8100008,
0xcd000040,
0xd4000fc0,
0x80000000,
0xd4000fa2,
0x7c40c000,
0x7c410000,
0xccc003fd,
0xcd0003fc,
0xccc00042,
0xcd000042,
0x2914001f,
0x29180010,
0x31980007,
0x3b5c0001,
0x7d76000b,
0x99800005,
0x7d5e400b,
0xcc000042,
0x80000249,
0xcc00004d,
0x29980001,
0x292c0008,
0x9980003d,
0x32ec0001,
0x96000004,
0x2930000c,
0x80000249,
0xcc000042,
0x04140010,
0xcd400042,
0x33300001,
0x34280001,
0x8400015d,
0xc8140003,
0x9b40001b,
0x0438000c,
0x8400015d,
0xc8140003,
0x9b400017,
0x04380008,
0x8400015d,
0xc8140003,
0x9b400013,
0x04380004,
0x8400015d,
0xc8140003,
0x9b400015,
0xc80c03fd,
0x9a800009,
0xc81003fc,
0x9b000101,
0xcc00004d,
0x04140010,
0xccc00042,
0xcd000042,
0x80000135,
0xcd400042,
0x96c000fa,
0xcc00004d,
0x80000249,
0xcc00004e,
0x9ac00003,
0xcc00004d,
0xcc00004e,
0xdf830000,
0x80000000,
0xd80301ff,
0x9ac000f0,
0xcc00004d,
0x80000249,
0xcc00004e,
0xc8180003,
0xc81c0003,
0xc8200003,
0x7d5d4003,
0x7da1c003,
0x7d5d400c,
0x2a10001f,
0x299c001f,
0x7d1d000b,
0x7d17400b,
0x88000000,
0x7e92800b,
0x96400004,
0xcc00004e,
0x80000249,
0xcc000042,
0x04380008,
0xcf800042,
0xc8080003,
0xc80c0003,
0xc8100003,
0xc8140003,
0xc8180003,
0xc81c0003,
0xc8240003,
0xc8280003,
0x29fc001f,
0x2ab0001f,
0x7ff3c00b,
0x28f0001f,
0x7ff3c00b,
0x2970001f,
0x7ff3c00b,
0x7d888001,
0x7dccc001,
0x7e510001,
0x7e954001,
0x7c908002,
0x7cd4c002,
0x7cbc800b,
0x9ac00003,
0x7c8f400b,
0x38b40001,
0x9b4000c1,
0xcc00004d,
0x9bc000bf,
0xcc00004e,
0xc80c03fd,
0xc81003fc,
0xccc00042,
0x8000016e,
0xcd000042,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xcc400040,
0xcc400040,
0xcc400040,
0x7c40c000,
0xccc00040,
0xccc0000d,
0x80000000,
0xd0400040,
0x7c40c000,
0x7c410000,
0x65140020,
0x7d4d402c,
0x24580002,
0x7d598020,
0x7c41c000,
0xcd800042,
0x69980020,
0xcd800042,
0xcdc00042,
0xc023c000,
0x05e40002,
0x7ca0800b,
0x26640010,
0x7ca4800c,
0xcc800040,
0xcdc00040,
0xccc00040,
0x95c0000e,
0xcd000040,
0x09dc0001,
0xc8280003,
0x96800008,
0xce800040,
0xc834001d,
0x97400000,
0xc834001d,
0x26a80008,
0x8400024c,
0xcc2b0000,
0x99c0fff7,
0x09dc0001,
0xdc3a0000,
0x97800004,
0x7c418000,
0x800001a2,
0x25980002,
0xa0000000,
0x7d808000,
0xc818001d,
0x7c40c000,
0x64d00008,
0x95800000,
0xc818001d,
0xcc130000,
0xcc800040,
0xccc00040,
0x80000000,
0xcc400040,
0xc810001f,
0x7c40c000,
0xcc800040,
0x7cd1400c,
0xcd400040,
0x05180001,
0x80000000,
0xcd800022,
0x7c40c000,
0x64500020,
0x8400024c,
0xcc000061,
0x7cd0c02c,
0xc8200017,
0xc8d60000,
0x99400008,
0x7c438000,
0xdf830000,
0xcfa0004f,
0x8400024c,
0xcc000062,
0x80000000,
0xd040007f,
0x80000249,
0xcc000062,
0x8400024c,
0xcc000061,
0xc8200017,
0x7c40c000,
0xc036ff00,
0xc810000d,
0xc0303fff,
0x7cf5400b,
0x7d51800b,
0x7d81800f,
0x99800008,
0x7cf3800b,
0xdf830000,
0xcfa0004f,
0x8400024c,
0xcc000062,
0x80000000,
0xd040007f,
0x80000249,
0xcc000062,
0x8400024c,
0x7c40c000,
0x28dc0008,
0x95c00019,
0x30dc0010,
0x7c410000,
0x99c00004,
0x64540020,
0x80000208,
0xc91d0000,
0x7d15002c,
0xc91e0000,
0x7c420000,
0x7c424000,
0x7c418000,
0x7de5c00b,
0x7de28007,
0x9a80000e,
0x41ac0005,
0x9ac00000,
0x0aec0001,
0x30dc0010,
0x99c00004,
0x00000000,
0x8000020b,
0xc91d0000,
0x8000020b,
0xc91e0000,
0xcc800040,
0xccc00040,
0xd0400040,
0xc80c0025,
0x94c0fde4,
0xc8100008,
0xcd000040,
0xd4000fc0,
0x80000000,
0xd4000fa2,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xd40003c0,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0x7c40c000,
0x30d00006,
0x0d100006,
0x99000007,
0xc8140015,
0x99400005,
0xcc000052,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xccc00040,
0x80000000,
0xd0400040,
0x7c40c000,
0xcc4d0000,
0xdc3a0000,
0x9780fdbd,
0x04cc0001,
0x80000242,
0xcc4d0000,
0x80000000,
0xd040007f,
0xcc00007f,
0x80000000,
0xcc00007f,
0xcc00007f,
0x88000000,
0xcc00007f,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00030222,
0x0004022a,
0x0005009f,
0x00020003,
0x0006003c,
0x00070027,
0x00080191,
0x00090044,
0x000a002d,
0x00100247,
0x001700f0,
0x002201d7,
0x002301e8,
0x0026004c,
0x0027005f,
0x0020011a,
0x00280092,
0x0029004f,
0x002a0083,
0x002b0064,
0x002f008d,
0x003200d8,
0x00340232,
0x00360074,
0x0039010a,
0x003c01fc,
0x003f009f,
0x00410005,
0x00440194,
0x0048019d,
0x004901c5,
0x004a01cf,
0x00550225,
0x0056022d,
0x0060000a,
0x0061002a,
0x00620030,
0x00630030,
0x00640030,
0x00650030,
0x00660030,
0x00670030,
0x00680037,
0x0069003f,
0x006a0047,
0x006b0047,
0x006c0047,
0x006d0047,
0x006e0047,
0x006f0047,
0x00700047,
0x00730247,
0x007b0240,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
};

static const u32 RV730_cp_microcode[]={
0xcc0003ea,
0x7c408000,
0xa0000000,
0xcc800062,
0x80000001,
0xd040007f,
0x80000001,
0xcc400041,
0x7c40c000,
0xc0160004,
0x30d03fff,
0x7d15000c,
0xcc110000,
0x28d8001e,
0x31980001,
0x28dc001f,
0xc8200004,
0x95c00006,
0x7c424000,
0xcc000062,
0x7e56800c,
0xcc290000,
0xc8240004,
0x7e26000b,
0x95800006,
0x7c42c000,
0xcc000062,
0x7ed7000c,
0xcc310000,
0xc82c0004,
0x7e2e000c,
0xcc000062,
0x31103fff,
0x80000001,
0xce110000,
0x7c40c000,
0x80000001,
0xcc400040,
0x80000001,
0xcc412257,
0x7c418000,
0xcc400045,
0xcc400048,
0xcc41225c,
0xcc41a1fc,
0x7c408000,
0xa0000000,
0xcc800062,
0xcc400045,
0xcc400048,
0x7c40c000,
0xcc41225c,
0xcc41a1fc,
0x7c408000,
0xa0000000,
0xcc800062,
0xcc000045,
0xcc000048,
0xcc41225c,
0xcc41a1fc,
0x7c408000,
0xa0000000,
0xcc800062,
0x040ca1fd,
0xc0120001,
0xcc000045,
0xcc000048,
0x7cd0c00c,
0xcc41225c,
0xcc41a1fc,
0xd04d0000,
0x7c408000,
0xa0000000,
0xcc800062,
0x80000001,
0xcc41225d,
0x7c408000,
0x7c40c000,
0xc02a0002,
0x7c410000,
0x7d29000c,
0x30940001,
0x30980006,
0x309c0300,
0x29dc0008,
0x7c420000,
0x7c424000,
0x9540000f,
0xc02e0004,
0x05f02258,
0x7f2f000c,
0xcc310000,
0xc8280004,
0xccc12169,
0xcd01216a,
0xce81216b,
0x0db40002,
0xcc01216c,
0x9740000e,
0x0db40000,
0x8000007b,
0xc834000a,
0x0db40002,
0x97400009,
0x0db40000,
0xc02e0004,
0x05f02258,
0x7f2f000c,
0xcc310000,
0xc8280004,
0x8000007b,
0xc834000a,
0x97400004,
0x7e028000,
0x8000007b,
0xc834000a,
0x0db40004,
0x9740ff8c,
0x00000000,
0xce01216d,
0xce41216e,
0xc8280003,
0xc834000a,
0x9b400004,
0x043c0005,
0x8400026b,
0xcc000062,
0x0df40000,
0x9740000b,
0xc82c03e6,
0xce81a2b7,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c4,
0x80000001,
0xcfc1a2d1,
0x0df40001,
0x9740000b,
0xc82c03e7,
0xce81a2bb,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c5,
0x80000001,
0xcfc1a2d2,
0x0df40002,
0x9740000b,
0xc82c03e8,
0xce81a2bf,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c6,
0x80000001,
0xcfc1a2d3,
0xc82c03e9,
0xce81a2c3,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c7,
0x80000001,
0xcfc1a2d4,
0x80000001,
0xcc400042,
0x7c40c000,
0x7c410000,
0x2914001d,
0x31540001,
0x9940000c,
0x31181000,
0xc81c0011,
0x95c00000,
0xc81c0011,
0xccc12100,
0xcd012101,
0xccc12102,
0xcd012103,
0x04180004,
0x8000037c,
0xcd81a2a4,
0xc02a0004,
0x95800008,
0x36a821a3,
0xcc290000,
0xc8280004,
0xc81c0011,
0x0de40040,
0x9640ffff,
0xc81c0011,
0xccc12170,
0xcd012171,
0xc8200012,
0x96000000,
0xc8200012,
0x8000037c,
0xcc000064,
0x7c40c000,
0x7c410000,
0xcc000045,
0xcc000048,
0x40d40003,
0xcd41225c,
0xcd01a1fc,
0xc01a0001,
0x041ca1fd,
0x7dd9c00c,
0x7c420000,
0x08cc0001,
0x06240001,
0x06280002,
0xce1d0000,
0xce5d0000,
0x98c0fffa,
0xce9d0000,
0x7c408000,
0xa0000000,
0xcc800062,
0x7c40c000,
0x30d00001,
0x28cc0001,
0x7c414000,
0x95000006,
0x7c418000,
0xcd41216d,
0xcd81216e,
0x800000f2,
0xc81c0003,
0xc0220004,
0x7e16000c,
0xcc210000,
0xc81c0004,
0x7c424000,
0x98c00004,
0x7c428000,
0x80000001,
0xcde50000,
0xce412169,
0xce81216a,
0xcdc1216b,
0x80000001,
0xcc01216c,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0x7c41c000,
0x28a40008,
0x326400ff,
0x0e68003c,
0x9680000a,
0x7c020000,
0x7c420000,
0x1e300003,
0xcc00006a,
0x9b000003,
0x42200005,
0x04200040,
0x8000010f,
0x7c024000,
0x7e024000,
0x9a400000,
0x0a640001,
0x30ec0010,
0x9ac0000a,
0xcc000062,
0xc02a0004,
0xc82c0021,
0x7e92800c,
0xcc000041,
0xcc290000,
0xcec00021,
0x8000011f,
0xc8300004,
0xcd01216d,
0xcd41216e,
0xc8300003,
0x7f1f000b,
0x30f40007,
0x27780001,
0x9740002a,
0x07b80124,
0x9f800000,
0x00000000,
0x80000134,
0x7f1b8004,
0x80000138,
0x7f1b8005,
0x8000013c,
0x7f1b8002,
0x80000140,
0x7f1b8003,
0x80000144,
0x7f1b8007,
0x80000148,
0x7f1b8006,
0x8000014d,
0x28a40008,
0x9b800019,
0x28a40008,
0x8000015d,
0x326400ff,
0x9b800015,
0x28a40008,
0x8000015d,
0x326400ff,
0x9b800011,
0x28a40008,
0x8000015d,
0x326400ff,
0x9b80000d,
0x28a40008,
0x8000015d,
0x326400ff,
0x9b800009,
0x28a40008,
0x8000015d,
0x326400ff,
0x9b800005,
0x28a40008,
0x8000015d,
0x326400ff,
0x28a40008,
0x326400ff,
0x0e68003c,
0x9a80feb2,
0x28ec0008,
0x7c434000,
0x7c438000,
0x7c43c000,
0x96c00007,
0xcc000062,
0xcf412169,
0xcf81216a,
0xcfc1216b,
0x80000001,
0xcc01216c,
0x80000001,
0xcff50000,
0xcc00006b,
0x8400037f,
0x0e68003c,
0x9a800004,
0xc8280015,
0x80000001,
0xd040007f,
0x9680ffab,
0x7e024000,
0x84000239,
0xc00e0002,
0xcc000041,
0x80000237,
0xccc1304a,
0x7c40c000,
0x7c410000,
0xc01e0001,
0x29240012,
0xc0220002,
0x96400005,
0xc0260004,
0xc027fffb,
0x7d25000b,
0xc0260000,
0x7dd2800b,
0x7e12c00b,
0x7d25000c,
0x7c414000,
0x7c418000,
0xccc12169,
0x9a80000a,
0xcd01216a,
0xcd41216b,
0x96c0fe83,
0xcd81216c,
0xc8300018,
0x97000000,
0xc8300018,
0x80000001,
0xcc000018,
0x8400037f,
0xcc00007f,
0xc8140013,
0xc8180014,
0xcd41216b,
0x96c0fe77,
0xcd81216c,
0x80000181,
0xc8300018,
0xc80c0008,
0x98c00000,
0xc80c0008,
0x7c410000,
0x95000002,
0x00000000,
0x7c414000,
0xc8200009,
0xcc400043,
0xce01a1f4,
0xcc400044,
0xc00e8000,
0x7c424000,
0x7c428000,
0x2aac001f,
0x96c0fe64,
0xc035f000,
0xce4003e2,
0x32780003,
0x267c0008,
0x7ff7c00b,
0x7ffbc00c,
0x2a780018,
0xcfc003e3,
0xcf8003e4,
0x26b00002,
0x7f3f0000,
0xcf0003e5,
0x8000031d,
0x7c80c000,
0x7c40c000,
0x28d00008,
0x3110000f,
0x9500000f,
0x25280001,
0x06a801b2,
0x9e800000,
0x00000000,
0x800001d3,
0xc0120800,
0x800001e1,
0xc814000f,
0x800001e8,
0xc8140010,
0x800001ef,
0xccc1a2a4,
0x800001f8,
0xc8140011,
0x30d0003f,
0x0d280015,
0x9a800012,
0x0d28001e,
0x9a80001e,
0x0d280020,
0x9a800023,
0x0d24000f,
0x0d280010,
0x7e6a800c,
0x9a800026,
0x0d200004,
0x0d240014,
0x0d280028,
0x7e62400c,
0x7ea6800c,
0x9a80002a,
0xc8140011,
0x80000001,
0xccc1a2a4,
0xc0120800,
0x7c414000,
0x7d0cc00c,
0xc0120008,
0x29580003,
0x295c000c,
0x7c420000,
0x7dd1c00b,
0x26200014,
0x7e1e400c,
0x7e4e800c,
0xce81a2a4,
0x80000001,
0xcd81a1fe,
0xc814000f,
0x0410210e,
0x95400000,
0xc814000f,
0xd0510000,
0x80000001,
0xccc1a2a4,
0xc8140010,
0x04102108,
0x95400000,
0xc8140010,
0xd0510000,
0x80000001,
0xccc1a2a4,
0xccc1a2a4,
0x04100001,
0xcd000019,
0x8400037f,
0xcc00007f,
0xc8100019,
0x99000000,
0xc8100019,
0x80000002,
0x7c408000,
0x04102100,
0x95400000,
0xc8140011,
0xd0510000,
0x8000037c,
0xccc1a2a4,
0x7c40c000,
0xcc40000d,
0x94c0fe01,
0xcc40000e,
0x7c410000,
0x95000005,
0x08cc0001,
0xc8140005,
0x99400014,
0x00000000,
0x98c0fffb,
0x7c410000,
0x80000002,
0x7d008000,
0xc8140005,
0x7c40c000,
0x9940000c,
0xc818000c,
0x7c410000,
0x9580fdf0,
0xc820000e,
0xc81c000d,
0x66200020,
0x7e1e002c,
0x25240002,
0x7e624020,
0x80000001,
0xcce60000,
0x7c410000,
0xcc00006c,
0xcc00006d,
0xc818001f,
0xc81c001e,
0x65980020,
0x7dd9c02c,
0x7cd4c00c,
0xccde0000,
0x45dc0004,
0xc8280017,
0x9680000f,
0xc00e0001,
0x28680008,
0x2aac0016,
0x32a800ff,
0x0eb00049,
0x7f2f000b,
0x97000006,
0x00000000,
0xc8140005,
0x7c40c000,
0x80000221,
0x7c410000,
0x80000224,
0xd040007f,
0x84000239,
0xcc000041,
0xccc1304a,
0x94000000,
0xc83c001a,
0x043c0005,
0xcfc1a2a4,
0xc0361f90,
0xc0387fff,
0x7c03c010,
0x7f7b400c,
0xcf41217c,
0xcfc1217d,
0xcc01217e,
0xc03a0004,
0x0434217f,
0x7f7b400c,
0xcc350000,
0xc83c0004,
0x2bfc001f,
0x04380020,
0x97c00005,
0xcc000062,
0x9b800000,
0x0bb80001,
0x80000245,
0xcc000071,
0xcc01a1f4,
0x04380016,
0xc0360002,
0xcf81a2a4,
0x88000000,
0xcf412010,
0x7c40c000,
0x28d0001c,
0x95000005,
0x04d40001,
0xcd400065,
0x80000001,
0xcd400068,
0x09540002,
0x80000001,
0xcd400066,
0x8400026a,
0xc81803ea,
0x7c40c000,
0x9980fd9f,
0xc8140016,
0x08d00001,
0x9940002b,
0xcd000068,
0x7c408000,
0xa0000000,
0xcc800062,
0x043c0005,
0xcfc1a2a4,
0xcc01a1f4,
0x8400037f,
0xcc000046,
0x88000000,
0xcc00007f,
0x8400027c,
0xc81803ea,
0x7c40c000,
0x9980fd8d,
0xc8140016,
0x08d00001,
0x99400019,
0xcd000068,
0x7c408000,
0xa0000000,
0xcc800062,
0x043c0022,
0xcfc1a2a4,
0x8400037f,
0xcc000047,
0x88000000,
0xcc00007f,
0xc8100016,
0x9900000d,
0xcc400067,
0x80000002,
0x7c408000,
0xc81803ea,
0x9980fd79,
0x7c40c000,
0x94c00003,
0xc8100016,
0x99000004,
0xccc00068,
0x80000002,
0x7c408000,
0x84000239,
0xc0148000,
0xcc000041,
0xcd41304a,
0xc0148000,
0x99000000,
0xc8100016,
0x80000002,
0x7c408000,
0xc0120001,
0x7c51400c,
0x80000001,
0xd0550000,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0x291c001f,
0xccc0004a,
0xcd00004b,
0x95c00003,
0xc01c8000,
0xcdc12010,
0xdd830000,
0x055c2000,
0xcc000062,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc0004c,
0xcd00004d,
0xdd830000,
0x055ca000,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc0004e,
0xcd00004f,
0xdd830000,
0x055cc000,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00050,
0xcd000051,
0xdd830000,
0x055cf8e0,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00052,
0xcd000053,
0xdd830000,
0x055cf880,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00054,
0xcd000055,
0xdd830000,
0x055ce000,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00056,
0xcd000057,
0xdd830000,
0x055cf000,
0x80000001,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00058,
0xcd000059,
0xdd830000,
0x055cf3fc,
0x80000001,
0xd81f4100,
0xd0432000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043a000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043c000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f8e0,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f880,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043e000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f3fc,
0x7c408000,
0xa0000000,
0xcc800062,
0xc81403e0,
0xcc430000,
0xcc430000,
0xcc430000,
0x7d45c000,
0xcdc30000,
0xd0430000,
0x7c408000,
0xa0000000,
0xcc800062,
0x7c40c000,
0xc81003e2,
0xc81403e5,
0xc81803e3,
0xc81c03e4,
0xcd812169,
0xcdc1216a,
0xccc1216b,
0xcc01216c,
0x04200004,
0x7da18000,
0x7d964002,
0x9640fcd9,
0xcd8003e3,
0x31280003,
0xc02df000,
0x25180008,
0x7dad800b,
0x7da9800c,
0x80000001,
0xcd8003e3,
0x308cffff,
0xd04d0000,
0x7c408000,
0xa0000000,
0xcc800062,
0xc8140020,
0x15580002,
0x9580ffff,
0xc8140020,
0xcc00006e,
0xcc412180,
0x7c40c000,
0xccc1218d,
0xcc412181,
0x28d0001f,
0x34588000,
0xcd81218c,
0x9500fcbf,
0xcc412182,
0xc8140020,
0x9940ffff,
0xc8140020,
0x80000002,
0x7c408000,
0x7c40c000,
0x28d00018,
0x31100001,
0xc0160080,
0x95000003,
0xc02a0004,
0x7cd4c00c,
0xccc1217c,
0xcc41217d,
0xcc41217e,
0x7c418000,
0x1db00003,
0x36a0217f,
0x9b000003,
0x419c0005,
0x041c0040,
0x99c00000,
0x09dc0001,
0xcc210000,
0xc8240004,
0x2a6c001f,
0x419c0005,
0x9ac0fffa,
0xcc800062,
0x80000002,
0x7c408000,
0x7c40c000,
0x04d403e6,
0x80000001,
0xcc540000,
0x8000037c,
0xcc4003ea,
0xc01c8000,
0x044ca000,
0xcdc12010,
0x7c410000,
0xc8140009,
0x04180000,
0x041c0008,
0xcd800071,
0x09dc0001,
0x05980001,
0xcd0d0000,
0x99c0fffc,
0xcc800062,
0x8000037c,
0xcd400071,
0xc00e0100,
0xcc000041,
0xccc1304a,
0xc83c007f,
0xcc00007f,
0x80000001,
0xcc00007f,
0xcc00007f,
0x88000000,
0xcc00007f,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00010331,
0x00100004,
0x00170006,
0x00210008,
0x00270028,
0x00280023,
0x00290029,
0x002a0026,
0x002b0029,
0x002d0038,
0x002e003f,
0x002f004a,
0x0034004c,
0x00360030,
0x003900af,
0x003a00cf,
0x003b00e4,
0x003c00fc,
0x003d016b,
0x003f00ad,
0x00410336,
0x00430349,
0x0044018e,
0x004500fc,
0x004601ac,
0x004701ac,
0x004801fe,
0x0049020c,
0x004a0255,
0x004b0282,
0x0052025f,
0x00530271,
0x00540287,
0x00570299,
0x0060029d,
0x006102ac,
0x006202b6,
0x006302c0,
0x006402ca,
0x006502d4,
0x006602de,
0x006702e8,
0x006802f2,
0x006902f6,
0x006a02fa,
0x006b02fe,
0x006c0302,
0x006d0306,
0x006e030a,
0x006f030e,
0x00700312,
0x00720363,
0x00740369,
0x00790367,
0x007c031c,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
0x000f0378,
};

static const u32 RV710_pfp_microcode[]={
0x7c408000,
0xa0000000,
0x7e82800b,
0x80000000,
0xdc030000,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xc818000e,
0x31980001,
0x7c424000,
0x9580023a,
0x7c428000,
0xc81c001c,
0xc037c000,
0x7c40c000,
0x7c410000,
0x7cb4800b,
0xc0360003,
0x99c00000,
0xc81c001c,
0x7cb4800c,
0x24d40002,
0x7d654000,
0xcd400043,
0xce800043,
0xcd000043,
0xcc800040,
0xce400040,
0xce800040,
0xccc00040,
0xdc3a0000,
0x9780ffde,
0xcd000040,
0x7c40c000,
0x80000018,
0x7c410000,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xc818000e,
0x8000000c,
0x31980002,
0xd40003c0,
0xd4000fc0,
0xd4000fa2,
0xc818000e,
0x288c0008,
0x30cc000f,
0x34100001,
0x7d0d0008,
0x8000000c,
0x7d91800b,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xd40003c0,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xcc4003f9,
0x80000249,
0xcc4003f8,
0xc037ffff,
0x7c414000,
0xcf41a29e,
0xc82003f8,
0xc81c03f9,
0x66200020,
0xc81803fb,
0x7de1c02c,
0x7d58c008,
0x7cdcc020,
0x69100020,
0xc0360003,
0xcc000054,
0x7cb4800c,
0x80000069,
0xcc800040,
0x7c418000,
0xcd81a29e,
0xcc800040,
0x80000067,
0xcd800040,
0xc019ffff,
0xcc800040,
0xcd81a29e,
0x7c40c000,
0x7c410000,
0x7c414000,
0xccc1a1fa,
0xcd01a1f9,
0xcd41a29d,
0xccc00040,
0xcd000040,
0xcd400040,
0xcc400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xcc000054,
0xcc800040,
0x7c40c000,
0x7c410000,
0x7c414000,
0xccc1a1fa,
0xcd01a1f9,
0xcd41a29d,
0xccc00040,
0xcd000040,
0xcd400040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0x7c40c000,
0x30d00001,
0xccc1a29f,
0x95000003,
0x04140001,
0x04140002,
0xcd4003fb,
0xcc800040,
0x80000000,
0xccc00040,
0x7c40c000,
0xcc800040,
0xccc1a2a2,
0x80000000,
0xccc00040,
0x7c40c000,
0x28d4001f,
0xcc800040,
0x95400003,
0x7c410000,
0xccc00057,
0x2918001f,
0xccc00040,
0x95800003,
0xcd000040,
0xcd000058,
0x80000249,
0xcc00007f,
0xc8200017,
0xc8300022,
0x9a000006,
0x0e280001,
0xc824001e,
0x0a640001,
0xd4001240,
0xce400040,
0xc036c000,
0x96800007,
0x37747900,
0x041c0001,
0xcf400040,
0xcdc00040,
0xcf0003fa,
0x7c030000,
0xca0c0010,
0x7c410000,
0x94c00004,
0x7c414000,
0xd42002c4,
0xcde00044,
0x9b00000b,
0x7c418000,
0xcc00004b,
0xcda00049,
0xcd200041,
0xcd600041,
0xcda00041,
0x06200001,
0xce000056,
0x80000249,
0xcc00007f,
0xc8280020,
0xc82c0021,
0xcc000063,
0x7eea4001,
0x65740020,
0x7f53402c,
0x269c0002,
0x7df5c020,
0x69f80020,
0xce80004b,
0xce600049,
0xcde00041,
0xcfa00041,
0xce600041,
0x271c0002,
0x7df5c020,
0x69f80020,
0x7db24001,
0xcf00004b,
0xce600049,
0xcde00041,
0xcfa00041,
0x800000bc,
0xce600041,
0xc8200017,
0xc8300022,
0x9a000006,
0x0e280001,
0xc824001e,
0x0a640001,
0xd4001240,
0xce400040,
0xca0c0010,
0x7c410000,
0x94c0000b,
0xc036c000,
0x96800007,
0x37747900,
0x041c0001,
0xcf400040,
0xcdc00040,
0xcf0003fa,
0x7c030000,
0x800000b5,
0x7c414000,
0xcc000048,
0x800000ee,
0x00000000,
0xc8200017,
0xc81c0023,
0x0e240002,
0x99c00015,
0x7c418000,
0x0a200001,
0xce000056,
0xd4000440,
0xcc000040,
0xc036c000,
0xca140013,
0x96400007,
0x37747900,
0xcf400040,
0xcc000040,
0xc83003fa,
0x80000103,
0xcf000022,
0xcc000022,
0x95400146,
0xcc00007f,
0xcca00046,
0x80000000,
0xcc200046,
0x80000249,
0xcc000064,
0xc8200017,
0xc810001f,
0x96000005,
0x09100001,
0xd4000440,
0xcd000040,
0xcd000022,
0xcc800040,
0xd0400040,
0xc80c0025,
0x94c0feec,
0xc8100008,
0xcd000040,
0xd4000fc0,
0x80000000,
0xd4000fa2,
0x7c40c000,
0x7c410000,
0xccc003fd,
0xcd0003fc,
0xccc00042,
0xcd000042,
0x2914001f,
0x29180010,
0x31980007,
0x3b5c0001,
0x7d76000b,
0x99800005,
0x7d5e400b,
0xcc000042,
0x80000249,
0xcc00004d,
0x29980001,
0x292c0008,
0x9980003d,
0x32ec0001,
0x96000004,
0x2930000c,
0x80000249,
0xcc000042,
0x04140010,
0xcd400042,
0x33300001,
0x34280001,
0x8400015d,
0xc8140003,
0x9b40001b,
0x0438000c,
0x8400015d,
0xc8140003,
0x9b400017,
0x04380008,
0x8400015d,
0xc8140003,
0x9b400013,
0x04380004,
0x8400015d,
0xc8140003,
0x9b400015,
0xc80c03fd,
0x9a800009,
0xc81003fc,
0x9b000101,
0xcc00004d,
0x04140010,
0xccc00042,
0xcd000042,
0x80000135,
0xcd400042,
0x96c000fa,
0xcc00004d,
0x80000249,
0xcc00004e,
0x9ac00003,
0xcc00004d,
0xcc00004e,
0xdf830000,
0x80000000,
0xd80301ff,
0x9ac000f0,
0xcc00004d,
0x80000249,
0xcc00004e,
0xc8180003,
0xc81c0003,
0xc8200003,
0x7d5d4003,
0x7da1c003,
0x7d5d400c,
0x2a10001f,
0x299c001f,
0x7d1d000b,
0x7d17400b,
0x88000000,
0x7e92800b,
0x96400004,
0xcc00004e,
0x80000249,
0xcc000042,
0x04380008,
0xcf800042,
0xc8080003,
0xc80c0003,
0xc8100003,
0xc8140003,
0xc8180003,
0xc81c0003,
0xc8240003,
0xc8280003,
0x29fc001f,
0x2ab0001f,
0x7ff3c00b,
0x28f0001f,
0x7ff3c00b,
0x2970001f,
0x7ff3c00b,
0x7d888001,
0x7dccc001,
0x7e510001,
0x7e954001,
0x7c908002,
0x7cd4c002,
0x7cbc800b,
0x9ac00003,
0x7c8f400b,
0x38b40001,
0x9b4000c1,
0xcc00004d,
0x9bc000bf,
0xcc00004e,
0xc80c03fd,
0xc81003fc,
0xccc00042,
0x8000016e,
0xcd000042,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xcc400040,
0xcc400040,
0xcc400040,
0x7c40c000,
0xccc00040,
0xccc0000d,
0x80000000,
0xd0400040,
0x7c40c000,
0x7c410000,
0x65140020,
0x7d4d402c,
0x24580002,
0x7d598020,
0x7c41c000,
0xcd800042,
0x69980020,
0xcd800042,
0xcdc00042,
0xc023c000,
0x05e40002,
0x7ca0800b,
0x26640010,
0x7ca4800c,
0xcc800040,
0xcdc00040,
0xccc00040,
0x95c0000e,
0xcd000040,
0x09dc0001,
0xc8280003,
0x96800008,
0xce800040,
0xc834001d,
0x97400000,
0xc834001d,
0x26a80008,
0x8400024c,
0xcc2b0000,
0x99c0fff7,
0x09dc0001,
0xdc3a0000,
0x97800004,
0x7c418000,
0x800001a2,
0x25980002,
0xa0000000,
0x7d808000,
0xc818001d,
0x7c40c000,
0x64d00008,
0x95800000,
0xc818001d,
0xcc130000,
0xcc800040,
0xccc00040,
0x80000000,
0xcc400040,
0xc810001f,
0x7c40c000,
0xcc800040,
0x7cd1400c,
0xcd400040,
0x05180001,
0x80000000,
0xcd800022,
0x7c40c000,
0x64500020,
0x8400024c,
0xcc000061,
0x7cd0c02c,
0xc8200017,
0xc8d60000,
0x99400008,
0x7c438000,
0xdf830000,
0xcfa0004f,
0x8400024c,
0xcc000062,
0x80000000,
0xd040007f,
0x80000249,
0xcc000062,
0x8400024c,
0xcc000061,
0xc8200017,
0x7c40c000,
0xc036ff00,
0xc810000d,
0xc0303fff,
0x7cf5400b,
0x7d51800b,
0x7d81800f,
0x99800008,
0x7cf3800b,
0xdf830000,
0xcfa0004f,
0x8400024c,
0xcc000062,
0x80000000,
0xd040007f,
0x80000249,
0xcc000062,
0x8400024c,
0x7c40c000,
0x28dc0008,
0x95c00019,
0x30dc0010,
0x7c410000,
0x99c00004,
0x64540020,
0x80000208,
0xc91d0000,
0x7d15002c,
0xc91e0000,
0x7c420000,
0x7c424000,
0x7c418000,
0x7de5c00b,
0x7de28007,
0x9a80000e,
0x41ac0005,
0x9ac00000,
0x0aec0001,
0x30dc0010,
0x99c00004,
0x00000000,
0x8000020b,
0xc91d0000,
0x8000020b,
0xc91e0000,
0xcc800040,
0xccc00040,
0xd0400040,
0xc80c0025,
0x94c0fde4,
0xc8100008,
0xcd000040,
0xd4000fc0,
0x80000000,
0xd4000fa2,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0xd40003c0,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xd0400040,
0x7c408000,
0xa0000000,
0x7e82800b,
0x7c40c000,
0x30d00006,
0x0d100006,
0x99000007,
0xc8140015,
0x99400005,
0xcc000052,
0xd4000340,
0xd4000fc0,
0xd4000fa2,
0xcc800040,
0xccc00040,
0x80000000,
0xd0400040,
0x7c40c000,
0xcc4d0000,
0xdc3a0000,
0x9780fdbd,
0x04cc0001,
0x80000242,
0xcc4d0000,
0x80000000,
0xd040007f,
0xcc00007f,
0x80000000,
0xcc00007f,
0xcc00007f,
0x88000000,
0xcc00007f,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00030222,
0x0004022a,
0x0005009f,
0x00020003,
0x0006003c,
0x00070027,
0x00080191,
0x00090044,
0x000a002d,
0x00100247,
0x001700f0,
0x002201d7,
0x002301e8,
0x0026004c,
0x0027005f,
0x0020011a,
0x00280092,
0x0029004f,
0x002a0083,
0x002b0064,
0x002f008d,
0x003200d8,
0x00340232,
0x00360074,
0x0039010a,
0x003c01fc,
0x003f009f,
0x00410005,
0x00440194,
0x0048019d,
0x004901c5,
0x004a01cf,
0x00550225,
0x0056022d,
0x0060000a,
0x0061002a,
0x00620030,
0x00630030,
0x00640030,
0x00650030,
0x00660030,
0x00670030,
0x00680037,
0x0069003f,
0x006a0047,
0x006b0047,
0x006c0047,
0x006d0047,
0x006e0047,
0x006f0047,
0x00700047,
0x00730247,
0x007b0240,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
0x00000005,
};

static const u32 RV710_cp_microcode[]={
0xcc0003ea,
0x04080003,
0xcc800043,
0x7c408000,
0xa0000000,
0xcc800062,
0x80000003,
0xd040007f,
0x80000003,
0xcc400041,
0x7c40c000,
0xc0160004,
0x30d03fff,
0x7d15000c,
0xcc110000,
0x28d8001e,
0x31980001,
0x28dc001f,
0xc8200004,
0x95c00006,
0x7c424000,
0xcc000062,
0x7e56800c,
0xcc290000,
0xc8240004,
0x7e26000b,
0x95800006,
0x7c42c000,
0xcc000062,
0x7ed7000c,
0xcc310000,
0xc82c0004,
0x7e2e000c,
0xcc000062,
0x31103fff,
0x80000003,
0xce110000,
0x7c40c000,
0x80000003,
0xcc400040,
0x80000003,
0xcc412257,
0x7c418000,
0xcc400045,
0xcc400048,
0xcc41225c,
0xcc41a1fc,
0x7c408000,
0xa0000000,
0xcc800062,
0xcc400045,
0xcc400048,
0x7c40c000,
0xcc41225c,
0xcc41a1fc,
0x7c408000,
0xa0000000,
0xcc800062,
0xcc000045,
0xcc000048,
0xcc41225c,
0xcc41a1fc,
0x7c408000,
0xa0000000,
0xcc800062,
0x040ca1fd,
0xc0120001,
0xcc000045,
0xcc000048,
0x7cd0c00c,
0xcc41225c,
0xcc41a1fc,
0xd04d0000,
0x7c408000,
0xa0000000,
0xcc800062,
0x80000003,
0xcc41225d,
0x7c408000,
0x7c40c000,
0xc02a0002,
0x7c410000,
0x7d29000c,
0x30940001,
0x30980006,
0x309c0300,
0x29dc0008,
0x7c420000,
0x7c424000,
0x9540000f,
0xc02e0004,
0x05f02258,
0x7f2f000c,
0xcc310000,
0xc8280004,
0xccc12169,
0xcd01216a,
0xce81216b,
0x0db40002,
0xcc01216c,
0x9740000e,
0x0db40000,
0x8000007d,
0xc834000a,
0x0db40002,
0x97400009,
0x0db40000,
0xc02e0004,
0x05f02258,
0x7f2f000c,
0xcc310000,
0xc8280004,
0x8000007d,
0xc834000a,
0x97400004,
0x7e028000,
0x8000007d,
0xc834000a,
0x0db40004,
0x9740ff8c,
0x00000000,
0xce01216d,
0xce41216e,
0xc8280003,
0xc834000a,
0x9b400004,
0x043c0005,
0x8400026d,
0xcc000062,
0x0df40000,
0x9740000b,
0xc82c03e6,
0xce81a2b7,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c4,
0x80000003,
0xcfc1a2d1,
0x0df40001,
0x9740000b,
0xc82c03e7,
0xce81a2bb,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c5,
0x80000003,
0xcfc1a2d2,
0x0df40002,
0x9740000b,
0xc82c03e8,
0xce81a2bf,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c6,
0x80000003,
0xcfc1a2d3,
0xc82c03e9,
0xce81a2c3,
0xc0300006,
0x7ef34028,
0xc0300020,
0x7f6b8020,
0x7fb3c029,
0xcf81a2c7,
0x80000003,
0xcfc1a2d4,
0x80000003,
0xcc400042,
0x7c40c000,
0x7c410000,
0x2914001d,
0x31540001,
0x9940000c,
0x31181000,
0xc81c0011,
0x95c00000,
0xc81c0011,
0xccc12100,
0xcd012101,
0xccc12102,
0xcd012103,
0x04180004,
0x8000037e,
0xcd81a2a4,
0xc02a0004,
0x95800008,
0x36a821a3,
0xcc290000,
0xc8280004,
0xc81c0011,
0x0de40040,
0x9640ffff,
0xc81c0011,
0xccc12170,
0xcd012171,
0xc8200012,
0x96000000,
0xc8200012,
0x8000037e,
0xcc000064,
0x7c40c000,
0x7c410000,
0xcc000045,
0xcc000048,
0x40d40003,
0xcd41225c,
0xcd01a1fc,
0xc01a0001,
0x041ca1fd,
0x7dd9c00c,
0x7c420000,
0x08cc0001,
0x06240001,
0x06280002,
0xce1d0000,
0xce5d0000,
0x98c0fffa,
0xce9d0000,
0x7c408000,
0xa0000000,
0xcc800062,
0x7c40c000,
0x30d00001,
0x28cc0001,
0x7c414000,
0x95000006,
0x7c418000,
0xcd41216d,
0xcd81216e,
0x800000f4,
0xc81c0003,
0xc0220004,
0x7e16000c,
0xcc210000,
0xc81c0004,
0x7c424000,
0x98c00004,
0x7c428000,
0x80000003,
0xcde50000,
0xce412169,
0xce81216a,
0xcdc1216b,
0x80000003,
0xcc01216c,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0x7c41c000,
0x28a40008,
0x326400ff,
0x0e68003c,
0x9680000a,
0x7c020000,
0x7c420000,
0x1e300003,
0xcc00006a,
0x9b000003,
0x42200005,
0x04200040,
0x80000111,
0x7c024000,
0x7e024000,
0x9a400000,
0x0a640001,
0x30ec0010,
0x9ac0000a,
0xcc000062,
0xc02a0004,
0xc82c0021,
0x7e92800c,
0xcc000041,
0xcc290000,
0xcec00021,
0x80000121,
0xc8300004,
0xcd01216d,
0xcd41216e,
0xc8300003,
0x7f1f000b,
0x30f40007,
0x27780001,
0x9740002a,
0x07b80126,
0x9f800000,
0x00000000,
0x80000136,
0x7f1b8004,
0x8000013a,
0x7f1b8005,
0x8000013e,
0x7f1b8002,
0x80000142,
0x7f1b8003,
0x80000146,
0x7f1b8007,
0x8000014a,
0x7f1b8006,
0x8000014f,
0x28a40008,
0x9b800019,
0x28a40008,
0x8000015f,
0x326400ff,
0x9b800015,
0x28a40008,
0x8000015f,
0x326400ff,
0x9b800011,
0x28a40008,
0x8000015f,
0x326400ff,
0x9b80000d,
0x28a40008,
0x8000015f,
0x326400ff,
0x9b800009,
0x28a40008,
0x8000015f,
0x326400ff,
0x9b800005,
0x28a40008,
0x8000015f,
0x326400ff,
0x28a40008,
0x326400ff,
0x0e68003c,
0x9a80feb2,
0x28ec0008,
0x7c434000,
0x7c438000,
0x7c43c000,
0x96c00007,
0xcc000062,
0xcf412169,
0xcf81216a,
0xcfc1216b,
0x80000003,
0xcc01216c,
0x80000003,
0xcff50000,
0xcc00006b,
0x84000381,
0x0e68003c,
0x9a800004,
0xc8280015,
0x80000003,
0xd040007f,
0x9680ffab,
0x7e024000,
0x8400023b,
0xc00e0002,
0xcc000041,
0x80000239,
0xccc1304a,
0x7c40c000,
0x7c410000,
0xc01e0001,
0x29240012,
0xc0220002,
0x96400005,
0xc0260004,
0xc027fffb,
0x7d25000b,
0xc0260000,
0x7dd2800b,
0x7e12c00b,
0x7d25000c,
0x7c414000,
0x7c418000,
0xccc12169,
0x9a80000a,
0xcd01216a,
0xcd41216b,
0x96c0fe83,
0xcd81216c,
0xc8300018,
0x97000000,
0xc8300018,
0x80000003,
0xcc000018,
0x84000381,
0xcc00007f,
0xc8140013,
0xc8180014,
0xcd41216b,
0x96c0fe77,
0xcd81216c,
0x80000183,
0xc8300018,
0xc80c0008,
0x98c00000,
0xc80c0008,
0x7c410000,
0x95000002,
0x00000000,
0x7c414000,
0xc8200009,
0xcc400043,
0xce01a1f4,
0xcc400044,
0xc00e8000,
0x7c424000,
0x7c428000,
0x2aac001f,
0x96c0fe64,
0xc035f000,
0xce4003e2,
0x32780003,
0x267c0008,
0x7ff7c00b,
0x7ffbc00c,
0x2a780018,
0xcfc003e3,
0xcf8003e4,
0x26b00002,
0x7f3f0000,
0xcf0003e5,
0x8000031f,
0x7c80c000,
0x7c40c000,
0x28d00008,
0x3110000f,
0x9500000f,
0x25280001,
0x06a801b4,
0x9e800000,
0x00000000,
0x800001d5,
0xc0120800,
0x800001e3,
0xc814000f,
0x800001ea,
0xc8140010,
0x800001f1,
0xccc1a2a4,
0x800001fa,
0xc8140011,
0x30d0003f,
0x0d280015,
0x9a800012,
0x0d28001e,
0x9a80001e,
0x0d280020,
0x9a800023,
0x0d24000f,
0x0d280010,
0x7e6a800c,
0x9a800026,
0x0d200004,
0x0d240014,
0x0d280028,
0x7e62400c,
0x7ea6800c,
0x9a80002a,
0xc8140011,
0x80000003,
0xccc1a2a4,
0xc0120800,
0x7c414000,
0x7d0cc00c,
0xc0120008,
0x29580003,
0x295c000c,
0x7c420000,
0x7dd1c00b,
0x26200014,
0x7e1e400c,
0x7e4e800c,
0xce81a2a4,
0x80000003,
0xcd81a1fe,
0xc814000f,
0x0410210e,
0x95400000,
0xc814000f,
0xd0510000,
0x80000003,
0xccc1a2a4,
0xc8140010,
0x04102108,
0x95400000,
0xc8140010,
0xd0510000,
0x80000003,
0xccc1a2a4,
0xccc1a2a4,
0x04100001,
0xcd000019,
0x84000381,
0xcc00007f,
0xc8100019,
0x99000000,
0xc8100019,
0x80000004,
0x7c408000,
0x04102100,
0x95400000,
0xc8140011,
0xd0510000,
0x8000037e,
0xccc1a2a4,
0x7c40c000,
0xcc40000d,
0x94c0fe01,
0xcc40000e,
0x7c410000,
0x95000005,
0x08cc0001,
0xc8140005,
0x99400014,
0x00000000,
0x98c0fffb,
0x7c410000,
0x80000004,
0x7d008000,
0xc8140005,
0x7c40c000,
0x9940000c,
0xc818000c,
0x7c410000,
0x9580fdf0,
0xc820000e,
0xc81c000d,
0x66200020,
0x7e1e002c,
0x25240002,
0x7e624020,
0x80000003,
0xcce60000,
0x7c410000,
0xcc00006c,
0xcc00006d,
0xc818001f,
0xc81c001e,
0x65980020,
0x7dd9c02c,
0x7cd4c00c,
0xccde0000,
0x45dc0004,
0xc8280017,
0x9680000f,
0xc00e0001,
0x28680008,
0x2aac0016,
0x32a800ff,
0x0eb00049,
0x7f2f000b,
0x97000006,
0x00000000,
0xc8140005,
0x7c40c000,
0x80000223,
0x7c410000,
0x80000226,
0xd040007f,
0x8400023b,
0xcc000041,
0xccc1304a,
0x94000000,
0xc83c001a,
0x043c0005,
0xcfc1a2a4,
0xc0361f90,
0xc0387fff,
0x7c03c010,
0x7f7b400c,
0xcf41217c,
0xcfc1217d,
0xcc01217e,
0xc03a0004,
0x0434217f,
0x7f7b400c,
0xcc350000,
0xc83c0004,
0x2bfc001f,
0x04380020,
0x97c00005,
0xcc000062,
0x9b800000,
0x0bb80001,
0x80000247,
0xcc000071,
0xcc01a1f4,
0x04380016,
0xc0360002,
0xcf81a2a4,
0x88000000,
0xcf412010,
0x7c40c000,
0x28d0001c,
0x95000005,
0x04d40001,
0xcd400065,
0x80000003,
0xcd400068,
0x09540002,
0x80000003,
0xcd400066,
0x8400026c,
0xc81803ea,
0x7c40c000,
0x9980fd9f,
0xc8140016,
0x08d00001,
0x9940002b,
0xcd000068,
0x7c408000,
0xa0000000,
0xcc800062,
0x043c0005,
0xcfc1a2a4,
0xcc01a1f4,
0x84000381,
0xcc000046,
0x88000000,
0xcc00007f,
0x8400027e,
0xc81803ea,
0x7c40c000,
0x9980fd8d,
0xc8140016,
0x08d00001,
0x99400019,
0xcd000068,
0x7c408000,
0xa0000000,
0xcc800062,
0x043c0022,
0xcfc1a2a4,
0x84000381,
0xcc000047,
0x88000000,
0xcc00007f,
0xc8100016,
0x9900000d,
0xcc400067,
0x80000004,
0x7c408000,
0xc81803ea,
0x9980fd79,
0x7c40c000,
0x94c00003,
0xc8100016,
0x99000004,
0xccc00068,
0x80000004,
0x7c408000,
0x8400023b,
0xc0148000,
0xcc000041,
0xcd41304a,
0xc0148000,
0x99000000,
0xc8100016,
0x80000004,
0x7c408000,
0xc0120001,
0x7c51400c,
0x80000003,
0xd0550000,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0x291c001f,
0xccc0004a,
0xcd00004b,
0x95c00003,
0xc01c8000,
0xcdc12010,
0xdd830000,
0x055c2000,
0xcc000062,
0x80000003,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc0004c,
0xcd00004d,
0xdd830000,
0x055ca000,
0x80000003,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc0004e,
0xcd00004f,
0xdd830000,
0x055cc000,
0x80000003,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00050,
0xcd000051,
0xdd830000,
0x055cf8e0,
0x80000003,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00052,
0xcd000053,
0xdd830000,
0x055cf880,
0x80000003,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00054,
0xcd000055,
0xdd830000,
0x055ce000,
0x80000003,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00056,
0xcd000057,
0xdd830000,
0x055cf000,
0x80000003,
0xd81f4100,
0x7c40c000,
0x7c410000,
0x7c414000,
0x7c418000,
0xccc00058,
0xcd000059,
0xdd830000,
0x055cf3fc,
0x80000003,
0xd81f4100,
0xd0432000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043a000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043c000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f8e0,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f880,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043e000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f000,
0x7c408000,
0xa0000000,
0xcc800062,
0xd043f3fc,
0x7c408000,
0xa0000000,
0xcc800062,
0xc81403e0,
0xcc430000,
0xcc430000,
0xcc430000,
0x7d45c000,
0xcdc30000,
0xd0430000,
0x7c408000,
0xa0000000,
0xcc800062,
0x7c40c000,
0xc81003e2,
0xc81403e5,
0xc81803e3,
0xc81c03e4,
0xcd812169,
0xcdc1216a,
0xccc1216b,
0xcc01216c,
0x04200004,
0x7da18000,
0x7d964002,
0x9640fcd9,
0xcd8003e3,
0x31280003,
0xc02df000,
0x25180008,
0x7dad800b,
0x7da9800c,
0x80000003,
0xcd8003e3,
0x308cffff,
0xd04d0000,
0x7c408000,
0xa0000000,
0xcc800062,
0xc8140020,
0x15580002,
0x9580ffff,
0xc8140020,
0xcc00006e,
0xcc412180,
0x7c40c000,
0xccc1218d,
0xcc412181,
0x28d0001f,
0x34588000,
0xcd81218c,
0x9500fcbf,
0xcc412182,
0xc8140020,
0x9940ffff,
0xc8140020,
0x80000004,
0x7c408000,
0x7c40c000,
0x28d00018,
0x31100001,
0xc0160080,
0x95000003,
0xc02a0004,
0x7cd4c00c,
0xccc1217c,
0xcc41217d,
0xcc41217e,
0x7c418000,
0x1db00003,
0x36a0217f,
0x9b000003,
0x419c0005,
0x041c0040,
0x99c00000,
0x09dc0001,
0xcc210000,
0xc8240004,
0x2a6c001f,
0x419c0005,
0x9ac0fffa,
0xcc800062,
0x80000004,
0x7c408000,
0x7c40c000,
0x04d403e6,
0x80000003,
0xcc540000,
0x8000037e,
0xcc4003ea,
0xc01c8000,
0x044ca000,
0xcdc12010,
0x7c410000,
0xc8140009,
0x04180000,
0x041c0008,
0xcd800071,
0x09dc0001,
0x05980001,
0xcd0d0000,
0x99c0fffc,
0xcc800062,
0x8000037e,
0xcd400071,
0xc00e0100,
0xcc000041,
0xccc1304a,
0xc83c007f,
0xcc00007f,
0x80000003,
0xcc00007f,
0xcc00007f,
0x88000000,
0xcc00007f,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00010333,
0x00100006,
0x00170008,
0x0021000a,
0x0027002a,
0x00280025,
0x0029002b,
0x002a0028,
0x002b002b,
0x002d003a,
0x002e0041,
0x002f004c,
0x0034004e,
0x00360032,
0x003900b1,
0x003a00d1,
0x003b00e6,
0x003c00fe,
0x003d016d,
0x003f00af,
0x00410338,
0x0043034b,
0x00440190,
0x004500fe,
0x004601ae,
0x004701ae,
0x00480200,
0x0049020e,
0x004a0257,
0x004b0284,
0x00520261,
0x00530273,
0x00540289,
0x0057029b,
0x0060029f,
0x006102ae,
0x006202b8,
0x006302c2,
0x006402cc,
0x006502d6,
0x006602e0,
0x006702ea,
0x006802f4,
0x006902f8,
0x006a02fc,
0x006b0300,
0x006c0304,
0x006d0308,
0x006e030c,
0x006f0310,
0x00700314,
0x00720365,
0x0074036b,
0x00790369,
0x007c031e,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
0x000f037a,
};
