/*-
 * Copyright (c) 2002-2007 Neterion, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/9/tools/tools/nxge/xge_log.h 173139 2007-10-29 14:19:32Z rwatson $
 */

#ifndef XGE_CMN_H
#include "xge_cmn.h"
#endif

#define XGE_STR_MAX_LEN_REGS     26
#define XGE_STR_MAX_LEN_STATS    32
#define XGE_STR_MAX_LEN_PCICONF  20
#define XGE_STR_MAX_LEN_DEVCONF  32

#define XGE_FORMAT_REGS          "%s%*s\t0x%.8llX\t0x%.16llX"
#define XGE_FORMAT_PCICONF       "%s%*s\t0x%.4llX\t0x%.4llX"
#define XGE_FORMAT_STATS         "%s%*s\t%d"
#define XGE_FORMAT_DEVCONF       "%s%*s\t%d"

FILE *fdAll;

int spaceCount = 0;
char line[68]  =                                                               \
	"===================================================================";

#define XGE_PRINT_HEADER(fd, maxSize, pOffset) {                               \
	XGE_PRINT_LINE(fd);                                                    \
	spaceCount = (maxSize) - 9;                                            \
	if((pOffset) == 1) {                                                   \
	    XGE_PRINT(fd, "PARAMETER%*s\tOFFSET\tVALUE", spaceCount, " ");     \
	}                                                                      \
	else {                                                                 \
	    XGE_PRINT(fd, "PARAMETER%*s\tVALUE", spaceCount, " ");             \
	}                                                                      \
	XGE_PRINT_LINE(fd);                                                    \
}

#define XGE_PRINT_READ_HEADER(fd, maxSize, pOffset) {                          \
	XGE_PRINT_LINE(fd);                                                    \
	spaceCount = (maxSize) - 9;                                            \
	if((pOffset) == 1) {                                                   \
	    XGE_PRINT(fd, "OFFSET\t\tVALUE", spaceCount, " ");                 \
	}                                                                      \
	else {                                                                 \
	    XGE_PRINT(fd, "VALUE", spaceCount, " ");                           \
	}                                                                      \
	XGE_PRINT_LINE(fd);                                                    \
}

#define XGE_PRINT_HEADER_REGS(fd)                                              \
	XGE_PRINT_HEADER(fd, XGE_STR_MAX_LEN_REGS, 1);
#define XGE_PRINT_READ_HEADER_REGS(fd)                                         \
	XGE_PRINT_READ_HEADER(fd, XGE_STR_MAX_LEN_REGS, 1);
#define XGE_PRINT_HEADER_PCICONF(fd)                                           \
	XGE_PRINT_HEADER(fd, XGE_STR_MAX_LEN_PCICONF, 1);
#define XGE_PRINT_HEADER_DEVCONF(fd)                                           \
	XGE_PRINT_HEADER(fd, XGE_STR_MAX_LEN_DEVCONF, 0);
#define XGE_PRINT_HEADER_STATS(fd)                                             \
	XGE_PRINT_HEADER(fd, XGE_STR_MAX_LEN_STATS, 0);

#define XGE_PRINT_REGS(fd, parameter, offset, value) {                         \
	spaceCount = XGE_STR_MAX_LEN_REGS - strlen(parameter);                 \
	XGE_PRINT(fd, XGE_FORMAT_REGS, (parameter), (spaceCount), " ",         \
	    (offset), (value));                                                \
}

#define XGE_PRINT_PCICONF(fd, parameter, offset, value) {                      \
	spaceCount = XGE_STR_MAX_LEN_PCICONF - strlen(parameter);              \
	XGE_PRINT(fd, XGE_FORMAT_PCICONF, (parameter), (spaceCount), " ",      \
	    (offset), (value));                                                \
}

#define XGE_PRINT_DEVCONF(fd, parameter, value) {                              \
	spaceCount = XGE_STR_MAX_LEN_DEVCONF - strlen(parameter);              \
	XGE_PRINT(fd, XGE_FORMAT_DEVCONF, (parameter), (spaceCount), " ",      \
	    (value));                                                          \
}

#define XGE_PRINT_STATS(fd, parameter, value) {                                \
	spaceCount = XGE_STR_MAX_LEN_STATS - strlen(parameter);                \
	XGE_PRINT(fd, XGE_FORMAT_STATS, (parameter), (spaceCount), " ",        \
	    (value));                                                          \
}

xge_pci_bar0_t regInfo[] = {
	{"GENERAL_INT_STATUS",          0x0000, 0, 0},
	{"GENERAL_INT_MASK",            0x0008, 0, 0},
	{"SW_RESET",                    0x0100, 0, 0},
	{"ADAPTER_STATUS",              0x0108, 0, 0},
	{"ADAPTER_CONTROL",             0x0110, 0, 0},
	{"SERR_SOURCE",                 0x0118, 0, 0},
	{"PCI_MODE",                    0x0120, 0, 1},
	{"RIC_STATUS",                  0x0160, 0, 1},
	{"MBIST_STATUS",                0x0558, 0, 1},
	{"PIC_INT_STATUS",              0x0800, 0, 0},
	{"PIC_INT_MASK",                0x0808, 0, 0},
	{"TxPIC_INT_REG",               0x0810, 0, 0},
	{"TxPIC_INT_MASK",              0x0818, 0, 0},
	{"TxPIC_INT_ALARM",             0x0820, 0, 0},
	{"RxPIC_INT_REG",               0x0828, 0, 0},
	{"RxPIC_INT_MASK",              0x0830, 0, 0},
	{"RxPIC_INT_ALARM",             0x0838, 0, 0},
	{"FLSH_INT_REG",                0x0840, 0, 0},
	{"FLSH_INT_MASK",               0x0848, 0, 0},
	{"FLSH_INT_ALARM",              0x0850, 0, 0},
	{"MDIO_INT_REG",                0x0858, 0, 0},
	{"MDIO_INT_MASK",               0x0860, 0, 0},
	{"MDIO_INT_ALARM",              0x0868, 0, 0},
	{"IIC_INT_REG",                 0x0870, 0, 0},
	{"IIC_INT_MASK",                0x0878, 0, 0},
	{"IIC_INT_ALARM",               0x0880, 0, 0},
	{"MSI_PENDING_REG",             0x0888, 0, 1},
	{"GPIO_INT_REG",                0x0890, 0, 0},
	{"GPIO_INT_MASK",               0x0898, 0, 0},
	{"GPIO_INT_ALARM",              0x08A0, 0, 0},
	{"MISC_INT_REG",                0x0890, 0, 1},
	{"MISC_INT_MASK",               0x0898, 0, 1},
	{"MISC_INT_ALARM",              0x08A0, 0, 1},
	{"MSI_TRIGGERED_REG",           0x08A8, 0, 1},
	{"XFP_GPIO_INT_REG",            0x08B0, 0, 1},
	{"XFP_GPIO_INT_MASK",           0x08B8, 0, 1},
	{"XFP_GPIO_ALARM",              0x08C0, 0, 1},
	{"TX_TRAFFIC_INT",              0x08E0, 0, 0},
	{"TX_TRAFFIC_INT_MASK",         0x08E8, 0, 0},
	{"RX_TRAFFIC_INT",              0x08F0, 0, 0},
	{"RX_TRAFFIC_INT_MASK",         0x08F8, 0, 0},
	{"PIC_CONTROL",                 0x0900, 0, 0},
	{"SWAPPER_CTRL",                0x0908, 0, 0},
	{"PIF_RD_SWAPPER_Fb",           0x0910, 0, 0},
	{"SCHEDULED_INT_CTRL",          0x0918, 0, 0},
	{"TxReqTimeOut",                0x0920, 0, 0},
	{"STATSReqTimeOut",             0x0928, 0, 0},
	{"Read_Retry_Delay",            0x0930, 0, 0},
	{"Read_Retry_Acceleration",     0x0938, 0, 0},
	{"Write_Retry_Delay",           0x0940, 0, 0},
	{"Write_Retry_Acceleration",    0x0948, 0, 0},
	{"XMSI_Control",                0x0950, 0, 0},
	{"XMSI_Access",                 0x0958, 0, 0},
	{"XMSI_Address",                0x0960, 0, 0},
	{"XMSI_Data",                   0x0968, 0, 0},
	{"Rx_MAT",                      0x0970, 0, 0},
	{"Tx_MAT0_7",                   0x0980, 0, 0},
	{"Tx_MAT8_15",                  0x0988, 0, 0},
	{"Tx_MAT16_23",                 0x0990, 0, 0},
	{"Tx_MAT24_31",                 0x0998, 0, 0},
	{"Tx_MAT32_39",                 0x09A0, 0, 0},
	{"Tx_MAT40_47",                 0x09A8, 0, 0},
	{"Tx_MAT48_55",                 0x09B0, 0, 0},
	{"Tx_MAT56_63",                 0x09B8, 0, 0},
	{"XMSI_MASK_REG",               0x09C0, 0, 1},
	{"STAT_BYTE_CNT",               0x09C8, 0, 1},
	{"STAT_CFG",                    0x09D0, 0, 0},
	{"STAT_ADDR",                   0x09D8, 0, 0},
	{"MDIO_CONTROL",                0x09E0, 0, 0},
	{"DTX_CONTROL",                 0x09E8, 0, 0},
	{"I2C_CONTROL",                 0x09F0, 0, 0},
	{"GPIO_CONTROL",                0x09F8, 0, 0},
	{"BEACON_CONTROL",              0x09F8, 0, 1},
	{"HOST_SCRATCH",                0x0A00, 0, 0},
	{"MISC_CONTROL",                0x0A00, 0, 1},
	{"XFP_CONTROL",                 0x0A08, 0, 1},
	{"GPIO_CONTROL",                0x0A10, 0, 1},
	{"TxFIFO_DW_MASK",              0x0A18, 0, 1},
	{"SPLIT_TABLE_LINE_NO",         0x0A20, 0, 1},
	{"SC_TIMEOUT",                  0x0A28, 0, 1},
	{"PIC_CONTROL_2",               0x0A30, 0, 1},
	{"INI_DPERR_CTRL",              0x0A38, 0, 1},
	{"WREQ_SPLIT_MASK",             0x0A40, 0, 1},
	{"QW_PER_RXD",                  0x0A48, 0, 1},
	{"PIC_STATUS",                  0x0B00, 0, 1},
	{"TXP_STATUS",                  0x0B08, 0, 1},
	{"TXP_ERR_CONTEXT",             0x0B10, 0, 1},
	{"SPDM_BIR_OFFSET",             0x0B18, 0, 1},
	{"SPDM_OVERWRITE",              0x0B20, 0, 1},
	{"CFG_ADDR_ON_DPERR",           0x0B28, 0, 1},
	{"PIF_ADDR_ON_DPERR",           0x0B30, 0, 1},
	{"TAGS_IN_USE",                 0x0B38, 0, 1},
	{"RD_REQ_TYPES",                0x0B40, 0, 1},
	{"SPLIT_TABLE_LINE",            0x0B48, 0, 1},
	{"UNXP_SPLIT_ADD_PH",           0x0B50, 0, 1},
	{"UNEXP_SPLIT_ATTR_PH",         0x0B58, 0, 1},
	{"SPLIT_MESSAGE",               0x0B60, 0, 1},
	{"SPDM_STRUCTURE",              0x0B68, 0, 1},
	{"TXDW_PTR_CNT_0",              0x0B70, 0, 1},
	{"TXDW_PTR_CNT_1",              0x0B78, 0, 1},
	{"TXDW_PTR_CNT_2",              0x0B80, 0, 1},
	{"TXDW_PTR_CNT_3",              0x0B88, 0, 1},
	{"TXDW_PTR_CNT_4",              0x0B90, 0, 1},
	{"TXDW_PTR_CNT_5",              0x0B98, 0, 1},
	{"TXDW_PTR_CNT_6",              0x0BA0, 0, 1},
	{"TXDW_PTR_CNT_7",              0x0BA8, 0, 1},
	{"RXDW_CNT_RING_0",             0x0BB0, 0, 1},
	{"RXDW_CNT_RING_1",             0x0BB8, 0, 1},
	{"RXDW_CNT_RING_2",             0x0BC0, 0, 1},
	{"RXDW_CNT_RING_3",             0x0BC8, 0, 1},
	{"RXDW_CNT_RING_4",             0x0BD0, 0, 1},
	{"RXDW_CNT_RING_5",             0x0BD8, 0, 1},
	{"RXDW_CNT_RING_6",             0x0BE0, 0, 1},
	{"RXDW_CNT_RING_7",             0x0BE8, 0, 1},
	{"TXDMA_INT_STATUS",            0x1000, 0, 0},
	{"TXDMA_INT_MASK",              0x1008, 0, 0},
	{"PFC_ERR_REG",                 0x1010, 0, 0},
	{"PFC_ERR_MASK",                0x1018, 0, 0},
	{"PFC_ERR_ALARM",               0x1020, 0, 0},
	{"TDA_ERR_REG",                 0x1028, 0, 0},
	{"TDA_ERR_MASK",                0x1030, 0, 0},
	{"TDA_ERR_ALARM",               0x1038, 0, 0},
	{"PCC_ERR_REG",                 0x1040, 0, 0},
	{"PCC_ERR_MASK",                0x1048, 0, 0},
	{"PCC_ERR_ALARM",               0x1050, 0, 0},
	{"TTI_ERR_REG",                 0x1058, 0, 0},
	{"TTI_ERR_MASK",                0x1060, 0, 0},
	{"TTI_ERR_ALARM",               0x1068, 0, 0},
	{"LSO_ERR_REG",                 0x1070, 0, 0},
	{"LSO_ERR_MASK",                0x1078, 0, 0},
	{"LSO_ERR_ALARM",               0x1080, 0, 0},
	{"TPA_ERR_REG",                 0x1088, 0, 0},
	{"TPA_ERR_MASK",                0x1090, 0, 0},
	{"TPA_ERR_ALARM",               0x1098, 0, 0},
	{"SM_ERR_REG",                  0x10A0, 0, 0},
	{"SM_ERR_MASK",                 0x10A8, 0, 0},
	{"SM_ERR_ALARM",                0x10B0, 0, 0},
	{"TX_FIFO_PARTITION_0",         0x1108, 0, 0},
	{"TX_FIFO_PARTITION_1",         0x1110, 0, 0},
	{"TX_FIFO_PARTITION_2",         0x1118, 0, 0},
	{"TX_FIFO_PARTITION_3",         0x1120, 0, 0},
	{"TX_W_ROUND_ROBIN_0",          0x1128, 0, 0},
	{"TX_W_ROUND_ROBIN_1",          0x1130, 0, 0},
	{"TX_W_ROUND_ROBIN_2",          0x1138, 0, 0},
	{"TX_W_ROUND_ROBIN_3",          0x1140, 0, 0},
	{"TX_W_ROUND_ROBIN_4",          0x1148, 0, 0},
	{"TTI_COMMAND_MEM",             0x1150, 0, 0},
	{"TTI_DATA1_MEM",               0x1158, 0, 0},
	{"TTI_DATA2_MEM",               0x1160, 0, 0},
	{"TX_PA_CFG",                   0x1168, 0, 0},
	{"PCC_ENABLE",                  0x1170, 0, 0},
	{"PFC_MONITOR_0",               0x1178, 0, 1},
	{"PFC_MONITOR_1",               0x1180, 0, 1},
	{"PFC_MONITOR_2",               0x1188, 0, 1},
	{"PFC_MONITOR_3",               0x1190, 0, 1},
	{"TXD_OWNERSHIP_CTRL",          0x1198, 0, 1},
	{"PFC_READ_CNTRL",              0x11A0, 0, 1},
	{"PFC_READ_DATA",               0x11A8, 0, 1},
	{"RXDMA_INT_STATUS",            0x1800, 0, 0},
	{"RXDMA_INT_MASK",              0x1808, 0, 0},
	{"RDA_ERR_REG",                 0x1810, 0, 0},
	{"RDA_ERR_MASK",                0x1818, 0, 0},
	{"RDA_ERR_ALARM",               0x1820, 0, 0},
	{"RC_ERR_REG",                  0x1828, 0, 0},
	{"RC_ERR_MASK",                 0x1830, 0, 0},
	{"RC_ERR_ALARM",                0x1838, 0, 0},
	{"PRC_PCIX_ERR_REG",            0x1840, 0, 0},
	{"PRC_PCIX_ERR_MASK",           0x1848, 0, 0},
	{"PRC_PCIX_ERR_ALARM",          0x1850, 0, 0},
	{"RPA_ERR_REG",                 0x1858, 0, 0},
	{"RPA_ERR_MASK",                0x1860, 0, 0},
	{"RPA_ERR_ALARM",               0x1868, 0, 0},
	{"RTI_ERR_REG",                 0x1870, 0, 0},
	{"RTI_ERR_MASK",                0x1878, 0, 0},
	{"RTI_ERR_ALARM",               0x1880, 0, 0},
	{"RX_QUEUE_PRIORITY",           0x1900, 0, 0},
	{"RX_W_ROUND_ROBIN_0",          0x1908, 0, 0},
	{"RX_W_ROUND_ROBIN_1",          0x1910, 0, 0},
	{"RX_W_ROUND_ROBIN_2",          0x1918, 0, 0},
	{"RX_W_ROUND_ROBIN_3",          0x1920, 0, 0},
	{"RX_W_ROUND_ROBIN_4",          0x1928, 0, 0},
	{"PRC_RXD0_0",                  0x1930, 0, 0},
	{"PRC_RXD0_1",                  0x1938, 0, 0},
	{"PRC_RXD0_2",                  0x1940, 0, 0},
	{"PRC_RXD0_3",                  0x1948, 0, 0},
	{"PRC_RXD0_4",                  0x1950, 0, 0},
	{"PRC_RXD0_5",                  0x1958, 0, 0},
	{"PRC_RXD0_6",                  0x1960, 0, 0},
	{"PRC_RXD0_7",                  0x1968, 0, 0},
	{"PRC_CTRL_0",                  0x1970, 0, 0},
	{"PRC_CTRL_1",                  0x1978, 0, 0},
	{"PRC_CTRL_2",                  0x1980, 0, 0},
	{"PRC_CTRL_3",                  0x1988, 0, 0},
	{"PRC_CTRL_4",                  0x1990, 0, 0},
	{"PRC_CTRL_5",                  0x1998, 0, 0},
	{"PRC_CTRL_6",                  0x19A0, 0, 0},
	{"PRC_CTRL_7",                  0x19A8, 0, 0},
	{"PRC_ALARM_ACTION",            0x19B0, 0, 0},
	{"RTI_COMMAND_MEM",             0x19B8, 0, 0},
	{"RTI_DATA1_MEM",               0x19C0, 0, 0},
	{"RTI_DATA2_MEM",               0x19C8, 0, 0},
	{"RX_PA_CFG",                   0x19D0, 0, 0},
	{"RING_BUMP_COUNTER1",          0x19E0, 0, 1},
	{"RING_BUMP_COUNTER2",          0x19E8, 0, 1},
	{"MAC_INT_STATUS",              0x2000, 0, 0},
	{"MAC_INT_MASK",                0x2008, 0, 0},
	{"MAC_TMAC_ERR_REG",            0x2010, 0, 0},
	{"MAC_TMAC_ERR_MASK",           0x2018, 0, 0},
	{"MAC_TMAC_ERR_ALARM",          0x2020, 0, 0},
	{"MAC_RMAC_ERR_REG",            0x2028, 0, 0},
	{"MAC_RMAC_ERR_MASK",           0x2030, 0, 0},
	{"MAC_RMAC_ERR_ALARM",          0x2038, 0, 0},
	{"MAC_CFG",                     0x2100, 0, 0},
	{"TMAC_AVG_IPG",                0x2108, 0, 0},
	{"RMAC_MAX_PYLD_LEN",           0x2110, 0, 0},
	{"RMAC_ERR_CFG",                0x2118, 0, 0},
	{"RMAC_CFG_KEY",                0x2120, 0, 0},
	{"RMAC_ADDR_CMD_MEM",           0x2128, 0, 0},
	{"RMAC_ADDR_DATA0_MEM",         0x2130, 0, 0},
	{"RMAC_ADDR_DATA1_MEM",         0x2138, 0, 0},
	{"TMAC_IPG_CFG",                0x2148, 0, 0},
	{"RMAC_PAUSE_CFG",              0x2150, 0, 0},
	{"RMAC_RED_CFG",                0x2158, 0, 0},
	{"RMAC_RED_RATE_Q0Q3",          0x2160, 0, 0},
	{"RMAC_RED_RATE_Q4Q7",          0x2168, 0, 0},
	{"MAC_LINK_UTIL",               0x2170, 0, 0},
	{"RMAC_INVALID_IPG",            0x2178, 0, 0},
	{"RTS_FRM_LEN_0",               0x2180, 0, 0},
	{"RTS_FRM_LEN_1",               0x2188, 0, 0},
	{"RTS_FRM_LEN_2",               0x2190, 0, 0},
	{"RTS_FRM_LEN_3",               0x2198, 0, 0},
	{"RTS_FRM_LEN_4",               0x21A0, 0, 0},
	{"RTS_FRM_LEN_5",               0x21A8, 0, 0},
	{"RTS_FRM_LEN_6",               0x21B0, 0, 0},
	{"RTS_FRM_LEN_7",               0x21B8, 0, 0},
	{"RTS_QOS_STEERING",            0x21C0, 0, 0},
	{"RTS_DIX_MAP_0",               0x21C8, 0, 0},
	{"RTS_DIX_MAP_1",               0x21D0, 0, 0},
	{"RTS_DIX_MAP_2",               0x21D8, 0, 0},
	{"RTS_DIX_MAP_3",               0x21E0, 0, 0},
	{"RTS_Q_ALTERNATES",            0x21E8, 0, 0},
	{"RTS_DEFAULT_Q",               0x21F0, 0, 1},
	{"RTS_CTRL",                    0x21F8, 0, 0},
	{"RTS_PN_CAM_CTRL",             0x2200, 0, 0},
	{"RTS_PN_CAM_DATA",             0x2208, 0, 0},
	{"RTS_DS_MEM_CTRL",             0x2210, 0, 0},
	{"RTS_DS_MEM_DATA",             0x2218, 0, 0},
	{"RTS_VID_MEM_CTRL",            0x2308, 0, 1},
	{"RTS_VID_MEM_DATA",            0x2310, 0, 1},
	{"RTS_P0_P3_MAP",               0x2318, 0, 1},
	{"RTS_P4_P7_MAP",               0x2320, 0, 1},
	{"RTS_P8_P11_MAP",              0x2328, 0, 1},
	{"RTS_P12_P15_MAP",             0x2330, 0, 1},
	{"RTS_DA_CFG",                  0x2338, 0, 1},
	{"RTS_RTH_CFG",                 0x2380, 0, 1},
	{"RTS_RTH_MAP_MEM_CTRL",        0x2388, 0, 1},
	{"RTS_RTH_MAP_MEM_DATA",        0x2390, 0, 1},
	{"RTS_RTH_SPDM_MEM_CTRL",       0x2398, 0, 1},
	{"RTS_RTH_SPDM_MEM_DATA",       0x23A0, 0, 1},
	{"RTS_RTH_JHASH_CFG",           0x23A8, 0, 1},
	{"RTS_RTH_JHASH_MASK_0",        0x23B0, 0, 1},
	{"RTS_RTH_JHASH_MASK_1",        0x23B8, 0, 1},
	{"RTS_RTH_JHASH_MASK_2",        0x23C0, 0, 1},
	{"RTS_RTH_JHASH_MASK_3",        0x23C8, 0, 1},
	{"RTS_RTH_JHASH_MASK_4",        0x23D0, 0, 1},
	{"RTS_RTH_JHASH_MASK_5",        0x23D8, 0, 1},
	{"RTS_RTH_STATUS",              0x23E0, 0, 1},
	{"RMAC_RED_FINE_Q0Q3",          0x2400, 0, 1},
	{"RMAC_RED_FINE_Q4Q7",          0x2408, 0, 1},
	{"RMAC_PTHRESH_CROSS",          0x2410, 0, 1},
	{"RMAC_RTHRESH_CROSS",          0x2418, 0, 1},
	{"RMAC_PNUM_RANGE_0",           0x2420, 0, 1},
	{"RMAC_PNUM_RANGE_1",           0x2428, 0, 1},
	{"RMAC_PNUM_RANGE_2",           0x2430, 0, 1},
	{"RMAC_PNUM_RANGE_3",           0x2438, 0, 1},
	{"RMAC_PNUM_RANGE_4",           0x2440, 0, 1},
	{"RMAC_PNUM_RANGE_5",           0x2448, 0, 1},
	{"RMAC_PNUM_RANGE_6",           0x2450, 0, 1},
	{"RMAC_PNUM_RANGE_7",           0x2458, 0, 1},
	{"RMAC_PNUM_RANGE_8",           0x2460, 0, 1},
	{"RMAC_PNUM_RANGE_9",           0x2468, 0, 1},
	{"RMAC_PNUM_RANGE_10",          0x2470, 0, 1},
	{"RMAC_PNUM_RANGE_11",          0x2478, 0, 1},
	{"RMAC_PNUM_RANGE_12",          0x2480, 0, 1},
	{"RMAC_PNUM_RANGE_13",          0x2488, 0, 1},
	{"RMAC_PNUM_RANGE_14",          0x2490, 0, 1},
	{"RMAC_PNUM_RANGE_15",          0x2498, 0, 1},
	{"RMAC_PNUM_RANGE_16",          0x24A0, 0, 1},
	{"RMAC_PNUM_RANGE_17",          0x24A8, 0, 1},
	{"RMAC_PNUM_RANGE_18",          0x24B0, 0, 1},
	{"RMAC_PNUM_RANGE_19",          0x24B8, 0, 1},
	{"RMAC_PNUM_RANGE_20",          0x24C0, 0, 1},
	{"RMAC_PNUM_RANGE_21",          0x24C8, 0, 1},
	{"RMAC_PNUM_RANGE_22",          0x24D0, 0, 1},
	{"RMAC_PNUM_RANGE_23",          0x24D8, 0, 1},
	{"RMAC_PNUM_RANGE_24",          0x24E0, 0, 1},
	{"RMAC_PNUM_RANGE_25",          0x24E8, 0, 1},
	{"RMAC_PNUM_RANGE_26",          0x24F0, 0, 1},
	{"RMAC_PNUM_RANGE_27",          0x24F8, 0, 1},
	{"RMAC_PNUM_RANGE_28",          0x2500, 0, 1},
	{"RMAC_PNUM_RANGE_29",          0x2508, 0, 1},
	{"RMAC_PNUM_RANGE_30",          0x2510, 0, 1},
	{"RMAC_PNUM_RANGE_31",          0x2518, 0, 1},
	{"RMAC_MP_CRC_0",               0x2520, 0, 1},
	{"RMAC_MP_MASK_A_0",            0x2528, 0, 1},
	{"RMAC_MP_MASK_B_0",            0x2530, 0, 1},
	{"RMAC_MP_CRC_1",               0x2538, 0, 1},
	{"RMAC_MP_MASK_A_1",            0x2540, 0, 1},
	{"RMAC_MP_MASK_B_1",            0x2548, 0, 1},
	{"RMAC_MP_CRC_2",               0x2550, 0, 1},
	{"RMAC_MP_MASK_A_2",            0x2558, 0, 1},
	{"RMAC_MP_MASK_B_2",            0x2560, 0, 1},
	{"RMAC_MP_CRC_3",               0x2568, 0, 1},
	{"RMAC_MP_MASK_A_3",            0x2570, 0, 1},
	{"RMAC_MP_MASK_B_3",            0x2578, 0, 1},
	{"RMAC_MP_CRC_4",               0x2580, 0, 1},
	{"RMAC_MP_MASK_A_4",            0x2588, 0, 1},
	{"RMAC_MP_MASK_B_4",            0x2590, 0, 1},
	{"RMAC_MP_CRC_5",               0x2598, 0, 1},
	{"RMAC_MP_MASK_A_5",            0x25A0, 0, 1},
	{"RMAC_MP_MASK_B_5",            0x25A8, 0, 1},
	{"RMAC_MP_CRC_6",               0x25B0, 0, 1},
	{"RMAC_MP_MASK_A_6",            0x25B8, 0, 1},
	{"RMAC_MP_MASK_B_6",            0x25C0, 0, 1},
	{"RMAC_MP_CRC_7",               0x25C8, 0, 1},
	{"RMAC_MP_MASK_A_7",            0x25D0, 0, 1},
	{"RMAC_MP_MASK_B_7",            0x25D8, 0, 1},
	{"MAC_CTRL",                    0x25E0, 0, 1},
	{"ACTIVITY_CONTROL",            0x25E8, 0, 1},
	{"MC_INT_STATUS",               0x2800, 0, 0},
	{"MC_INT_MASK",                 0x2808, 0, 0},
	{"MC_ERR_REG",                  0x2810, 0, 0},
	{"MC_ERR_MASK",                 0x2818, 0, 0},
	{"MC_ERR_ALARM",                0x2820, 0, 0},
	{"RX_QUEUE_CFG",                0x2900, 0, 0},
	{"MC_RLDRAM_MRS",               0x2908, 0, 0},
	{"MC_RLDRAM_INTERLEAVE",        0x2910, 0, 0},
	{"MC_PAUSE_THRESH_Q0Q3",        0x2918, 0, 0},
	{"MC_PAUSE_THRESH_Q4Q7",        0x2920, 0, 0},
	{"MC_RED_THRESH_Q0",            0x2928, 0, 0},
	{"MC_RED_THRESH_Q1",            0x2930, 0, 0},
	{"MC_RED_THRESH_Q2",            0x2938, 0, 0},
	{"MC_RED_THRESH_Q3",            0x2940, 0, 0},
	{"MC_RED_THRESH_Q4",            0x2948, 0, 0},
	{"MC_RED_THRESH_Q5",            0x2950, 0, 0},
	{"MC_RED_THRESH_Q6",            0x2958, 0, 0},
	{"MC_RED_THRESH_Q7",            0x2960, 0, 0},
	{"MC_RLDRAM_REF_PER",           0x2A00, 0, 0},
	{"MC_RLDRAM_TEST_CTRL",         0x2A20, 0, 0},
	{"MC_RLDRAM_TEST_ADD",          0x2A40, 0, 0},
	{"MC_RLDRAM_TEST_D0",           0x2A60, 0, 0},
	{"MC_RLDRAM_TEST_D1",           0x2A80, 0, 0},
	{"MC_RLDRAM_TEST_D2",           0x2B00, 0, 0},
	{"MC_RLDRAM_TEST_READ_D0",      0x2C00, 0, 1},
	{"MC_RLDRAM_TEST_RAED_D1",      0x2C20, 0, 1},
	{"MC_RLDRAM_TEST_READ_D2",      0x2C40, 0, 1},
	{"MC_RLDRAM_TEST_ADD_BKG",      0x2C60, 0, 1},
	{"MC_RLDRAM_TEST_D0_BKG",       0x2C80, 0, 1},
	{"MC_RLDRAM_TEST_D1_BKG",       0x2D00, 0, 1},
	{"MC_RLDRAM_TEST_D2_BKG",       0x2D20, 0, 1},
	{"MC_RLDRAM_TEST_READ_D0_BKG",  0x2D40, 0, 1},
	{"MC_RLDRAM_TEST_READ_D1_BKG",  0x2D60, 0, 1},
	{"MC_RLDRAM_TEST_READ_D2_BKG",  0x2D80, 0, 1},
	{"MC_RLDRAM_GENERATION",        0x2E00, 0, 1},
	{"MC_DRIVER",                   0x2E20, 0, 1},
	{"XGXS_INT_STATUS",             0x3000, 0, 0},
	{"XGXS_INT_MASK",               0x3008, 0, 0},
	{"XGXS_TXGXS_ERR_REG",          0x3010, 0, 0},
	{"XGXS_TXGXS_ERR_MASK",         0x3018, 0, 0},
	{"XGXS_TXGXS_ERR_ALARM",        0x3020, 0, 0},
	{"XGXS_RXGXS_ERR_REG",          0x3028, 0, 0},
	{"XGXS_RXGXS_ERR_MASK",         0x3030, 0, 0},
	{"XGXS_RXGXS_ERR_ALARM",        0x3038, 0, 0},
	{"SPI_ERR_REG",                 0x3040, 0, 1},
	{"SPI_ERR_MASK",                0x3048, 0, 1},
	{"SPI_ERR_ALARM",               0x3050, 0, 1},
	{"XGXS_CFG",                    0x3100, 0, 0},
	{"XGXS_STATUS",                 0x3108, 0, 0},
	{"XGXS_CFG_KEY",                0x3110, 0, 0},
	{"XGXS_EFIFO_CFG",              0x3118, 0, 0},
	{"RXGXS_BER_0",                 0x3120, 0, 0},
	{"RXGXS_BER_1",                 0x3128, 0, 0},
	{"SPI_CONTROL",                 0x3130, 0, 1},
	{"SPI_DATA",                    0x3138, 0, 1},
	{"SPI_WRITE_PROTECT",           0x3140, 0, 1},
	{"XGXS_CFG_1",                  0x3180, 0, 1}
};

xge_stats_hw_info_t statsInfo[] =
{
	/* Tx MAC statistics counters */
	{"tmac_frms",                      0x0000, 0x0004, 4, 0},
	{"tmac_data_octets",               0x0004, 0x0000, 4, 0},
	{"tmac_drop_frms",                 0x0008, 0x0008, 8, 0},
	{"tmac_mcst_frms",                 0x0010, 0x0014, 4, 0},
	{"tmac_bcst_frms",                 0x0014, 0x0010, 4, 0},
	{"tmac_pause_ctrl_frms",           0x0018, 0x0018, 8, 0},
	{"tmac_ttl_octets",                0x0020, 0x0024, 4, 0},
	{"tmac_ucst_frms",                 0x0024, 0x0020, 4, 0},
	{"tmac_nucst_frms",                0x0028, 0x002C, 4, 0},
	{"tmac_any_err_frms",              0x002C, 0x0028, 4, 0},
	{"tmac_ttl_less_fb_octets",        0x0030, 0x0030, 8, 0},
	{"tmac_vld_ip_octets",             0x0038, 0x0038, 8, 0},
	{"tmac_vld_ip",                    0x0040, 0x0044, 4, 0},
	{"tmac_drop_ip",                   0x0044, 0x0040, 4, 0},
	{"tmac_icmp",                      0x0048, 0x004C, 4, 0},
	{"tmac_rst_tcp",                   0x004C, 0x0048, 4, 0},
	{"tmac_tcp",                       0x0050, 0x0050, 8, 0},
	{"tmac_udp",                       0x0058, 0x005C, 4, 0},
	{"reserved_0",                     0x005C, 0x0058, 4, 0},

	/* Rx MAC Statistics counters. */
	{"rmac_vld_frms",                  0x0060, 0x0064, 4, 0},
	{"rmac_data_octets",               0x006C, 0x0060, 4, 0},
	{"rmac_fcs_err_frms",              0x0068, 0x0068, 8, 0},
	{"rmac_drop_frms",                 0x0070, 0x0070, 8, 0},
	{"rmac_vld_mcst_frms",             0x0078, 0x007C, 4, 0},
	{"rmac_vld_bcst_frms",             0x007C, 0x0078, 4, 0},
	{"rmac_in_rng_len_err_frms",       0x0080, 0x0084, 4, 0},
	{"rmac_out_rng_len_err_frms",      0x0084, 0x0080, 4, 0},
	{"rmac_long_frms",                 0x0088, 0x0088, 8, 0},
	{"rmac_pause_ctrl_frms",           0x0090, 0x0090, 8, 0},
	{"rmac_unsup_ctrl_frms",           0x0098, 0x0098, 8, 0},
	{"rmac_ttl_octets",                0x00A0, 0x00A4, 4, 0},
	{"rmac_accepted_ucst_frms",        0x00A4, 0x00A0, 4, 0},
	{"rmac_accepted_nucst_frms",       0x00A8, 0x00AC, 4, 0},
	{"rmac_discarded_frms",            0x00AC, 0x00A8, 4, 0},
	{"rmac_drop_events",               0x00B0, 0x00B4, 4, 0},
	{"reserved_1",                     0x00B4, 0x00B0, 4, 0},
	{"rmac_ttl_less_fb_octets",        0x00B8, 0x00B8, 8, 0},
	{"rmac_ttl_frms",                  0x00C0, 0x00C0, 8, 0},
	{"reserved_2",                     0x00C8, 0x00C8, 8, 0},
	{"reserved_3",                     0x00D0, 0x00D4, 4, 0},
	{"rmac_usized_frms",               0x00D4, 0x00D0, 4, 0},
	{"rmac_osized_frms",               0x00D8, 0x00DC, 4, 0},
	{"rmac_frag_frms",                 0x00DC, 0x00D8, 4, 0},
	{"rmac_jabber_frms",               0x00E0, 0x00E4, 4, 0},
	{"reserved_4",                     0x00E4, 0x00E0, 4, 0},
	{"rmac_ttl_64_frms",               0x00E8, 0x00E8, 8, 0},
	{"rmac_ttl_65_127_frms",           0x00F0, 0x00F0, 8, 0},
	{"reserved_5",                     0x00F8, 0x00F8, 8, 0},
	{"rmac_ttl_128_255_frms",          0x0100, 0x0100, 8, 0},
	{"rmac_ttl_256_511_frms",          0x0108, 0x0108, 8, 0},
	{"reserved_6",                     0x0110, 0x0110, 8, 0},
	{"rmac_ttl_512_1023_frms",         0x0118, 0x0118, 8, 0},
	{"rmac_ttl_1024_1518_frms",        0x0120, 0x0120, 8, 0},
	{"reserved_7",                     0x0128, 0x012C, 4, 0},
	{"rmac_ip",                        0x012C, 0x0128, 4, 0},
	{"rmac_ip_octets",                 0x0130, 0x0130, 8, 0},
	{"rmac_hdr_err_ip",                0x0138, 0x013C, 4, 0},
	{"rmac_drop_ip",                   0x013C, 0x0138, 4, 0},
	{"rmac_icmp",                      0x0140, 0x0144, 4, 0},
	{"reserved_8",                     0x0144, 0x0140, 4, 0},
	{"rmac_tcp",                       0x0148, 0x0148, 8, 0},
	{"rmac_udp",                       0x0150, 0x0154, 4, 0},
	{"rmac_err_drp_udp",               0x0154, 0x0150, 4, 0},
	{"rmac_xgmii_err_sym",             0x0158, 0x0158, 8, 0},
	{"rmac_frms_q0",                   0x0160, 0x0160, 8, 0},
	{"rmac_frms_q1",                   0x0168, 0x0168, 8, 0},
	{"rmac_frms_q2",                   0x0170, 0x0170, 8, 0},
	{"rmac_frms_q3",                   0x0178, 0x0178, 8, 0},
	{"rmac_frms_q4",                   0x0180, 0x0180, 8, 0},
	{"rmac_frms_q5",                   0x0188, 0x0188, 8, 0},
	{"rmac_frms_q6",                   0x0190, 0x0190, 8, 0},
	{"rmac_frms_q7",                   0x0198, 0x0198, 8, 0},
	{"rmac_full_q0",                   0x01A0, 0x01A6, 2, 0},
	{"rmac_full_q1",                   0x01A2, 0x01A4, 2, 0},
	{"rmac_full_q2",                   0x01A4, 0x01A2, 2, 0},
	{"rmac_full_q3",                   0x01A6, 0x01A0, 2, 0},
	{"rmac_full_q4",                   0x01A8, 0x01AE, 2, 0},
	{"rmac_full_q5",                   0x01AA, 0x01AC, 2, 0},
	{"rmac_full_q6",                   0x01AB, 0x01AA, 2, 0},
	{"rmac_full_q7",                   0x01AC, 0x01A8, 2, 0},
	{"rmac_pause_cnt",                 0x01B0, 0x01B4, 4, 0},
	{"reserved_9",                     0x01B4, 0x01B0, 4, 0},
	{"rmac_xgmii_data_err_cnt",        0x01B8, 0x01B8, 8, 0},
	{"rmac_xgmii_ctrl_err_cnt",        0x01C0, 0x01C0, 8, 0},
	{"rmac_accepted_ip",               0x01C8, 0x01CC, 4, 0},
	{"rmac_err_tcp",                   0x01CC, 0x01C8, 4, 0},

	/* PCI/PCI-X Read transaction statistics. */
	{"rd_req_cnt",                     0x01D0, 0x01D4, 4, 0},
	{"new_rd_req_cnt",                 0x01D4, 0x01D0, 4, 0},
	{"new_rd_req_rtry_cnt",            0x01D8, 0x01DC, 4, 0},
	{"rd_rtry_cnt",                    0x01DC, 0x01D8, 4, 0},
	{"wr_rtry_rd_ack_cnt",             0x01E0, 0x01E4, 4, 0},

	/* PCI/PCI-X write transaction statistics. */
	{"wr_req_cnt",                     0x01E4, 0x01E0, 4, 0},
	{"new_wr_req_cnt",                 0x01E8, 0x01EC, 4, 0},
	{"new_wr_req_rtry_cnt",            0x01EC, 0x01E8, 4, 0},
	{"wr_rtry_cnt",                    0x01F0, 0x01F4, 4, 0},
	{"wr_disc_cnt",                    0x01F4, 0x01F0, 4, 0},
	{"rd_rtry_wr_ack_cnt",             0x01F8, 0x01FC, 4, 0},

	/* DMA Transaction statistics. */
	{"txp_wr_cnt",                     0x01FC, 0x01F8, 4, 0},
	{"txd_rd_cnt",                     0x0200, 0x0204, 4, 0},
	{"txd_wr_cnt",                     0x0204, 0x0200, 4, 0},
	{"rxd_rd_cnt",                     0x0208, 0x020C, 4, 0},
	{"rxd_wr_cnt",                     0x020C, 0x0208, 4, 0},
	{"txf_rd_cnt",                     0x0210, 0x0214, 4, 0},
	{"rxf_wr_cnt",                     0x0214, 0x0210, 4, 0},

	/* Enhanced Herc statistics */
	{"tmac_frms_oflow",                0x0218, 0x021C, 4, 0},
	{"tmac_data_octets_oflow",         0x021C, 0x0218, 4, 0},
	{"tmac_mcst_frms_oflow",           0x0220, 0x0224, 4, 0},
	{"tmac_bcst_frms_oflow",           0x0224, 0x0220, 4, 0},
	{"tmac_ttl_octets_oflow",          0x0228, 0x022C, 4, 0},
	{"tmac_ucst_frms_oflow",           0x022C, 0x0228, 4, 0},
	{"tmac_nucst_frms_oflow",          0x0230, 0x0234, 4, 0},
	{"tmac_any_err_frms_oflow",        0x0234, 0x0230, 4, 0},
	{"tmac_vlan_frms",                 0x0238, 0x0238, 8, 0},
	{"tmac_vld_ip_oflow",              0x0240, 0x0244, 4, 0},
	{"tmac_drop_ip_oflow",             0x0244, 0x0240, 4, 0},
	{"tmac_icmp_oflow",                0x0248, 0x024C, 4, 0},
	{"tmac_rst_tcp_oflow",             0x024C, 0x0248, 4, 0},
	{"tmac_udp_oflow",                 0x0250, 0x0254, 4, 0},
	{"tpa_unknown_protocol",           0x0254, 0x0250, 4, 0},
	{"tpa_parse_failure",              0x0258, 0x025C, 4, 0},
	{"reserved_10",                    0x025C, 0x0258, 4, 0},
	{"rmac_vld_frms_oflow",            0x0260, 0x0264, 4, 0},
	{"rmac_data_octets_oflow",         0x0264, 0x0260, 4, 0},
	{"rmac_vld_mcst_frms_oflow",       0x0268, 0x026C, 4, 0},
	{"rmac_vld_bcst_frms_oflow",       0x026C, 0x0268, 4, 0},
	{"rmac_ttl_octets_oflow",          0x0270, 0x0274, 4, 0},
	{"rmac_accepted_ucst_frms_oflow",  0x0274, 0x0270, 4, 0},
	{"rmac_accepted_nucst_frms_oflow", 0x0278, 0x027C, 4, 0},
	{"rmac_discarded_frms_oflow",      0x027C, 0x0278, 4, 0},
	{"rmac_drop_events_oflow",         0x0280, 0x0284, 4, 0},
	{"rmac_usized_frms_oflow",         0x0284, 0x0280, 4, 0},
	{"rmac_osized_frms_oflow",         0x0288, 0x028C, 4, 0},
	{"rmac_frag_frms_oflow",           0x028C, 0x0288, 4, 0},
	{"rmac_jabber_frms_oflow",         0x0290, 0x0294, 4, 0},
	{"rmac_ip_oflow",                  0x0294, 0x0290, 4, 0},
	{"rmac_drop_ip_oflow",             0x0298, 0x029C, 4, 0},
	{"rmac_icmp_oflow",                0x029C, 0x0298, 4, 0},
	{"rmac_udp_oflow",                 0x02A0, 0x02A4, 4, 0},
	{"rmac_err_drp_udp_oflow",         0x02A4, 0x02A0, 4, 0},
	{"rmac_pause_cnt_oflow",           0x02A8, 0x02AC, 4, 0},
	{"reserved_11",                    0x02AC, 0x02A8, 4, 0},
	{"rmac_ttl_1519_4095_frms",        0x02B0, 0x02B0, 8, 0},
	{"rmac_ttl_4096_8191_frms",        0x02B8, 0x02B8, 8, 0},
	{"rmac_ttl_8192_max_frms",         0x02C0, 0x02C0, 8, 0},
	{"rmac_ttl_gt_max_frms",           0x02C8, 0x02C8, 8, 0},
	{"rmac_osized_alt_frms",           0x02D0, 0x02D0, 8, 0},
	{"rmac_jabber_alt_frms",           0x02D8, 0x02D8, 8, 0},
	{"rmac_gt_max_alt_frms",           0x02E0, 0x02E0, 8, 0},
	{"rmac_vlan_frms",                 0x02E8, 0x02E8, 8, 0},
	{"rmac_fcs_discard",               0x02F0, 0x02F4, 4, 0},
	{"rmac_len_discard",               0x02F4, 0x02F0, 4, 0},
	{"rmac_da_discard",                0x02F8, 0x02FC, 4, 0},
	{"rmac_pf_discard",                0x02FC, 0x02F8, 4, 0},
	{"rmac_rts_discard",               0x0300, 0x0304, 4, 0},
	{"rmac_wol_discard",               0x0304, 0x0300, 4, 0},
	{"rmac_red_discard",               0x0308, 0x030C, 4, 0},
	{"rmac_ingm_full_discard",         0x030C, 0x0308, 4, 0},
	{"rmac_accepted_ip_oflow",         0x0310, 0x0314, 4, 0},
	{"reserved_12",                    0x0314, 0x0310, 4, 0},
	{"link_fault_cnt",                 0x0318, 0x031C, 4, 0},
	{"reserved_13",                    0x031C, 0x0318, 4, 0}
};

xge_pci_config_t pciconfInfo[] = {
	{"device_id",            0x0002, 0x0002, 0},
	{"vendor_id",            0x0000, 0x0000, 0},
	{"status",               0x0006, 0x0006, 0},
	{"command",              0x0004, 0x0004, 0},
	{"pciClass",             0x000B, 0x0009, 0},
	{"revision",             0x0008, 0x0008, 0},
	{"bist",                 0x000F, 0x000F, 0},
	{"header_type",          0x000E, 0x000E, 0},
	{"latency_timer",        0x000D, 0x000D, 0},
	{"cache_line_size",      0x000C, 0x000C, 0},
	{"base_addr0_lo",        0x0010, 0x0010, 0},
	{"base_addr0_hi",        0x0014, 0x0014, 0},
	{"base_addr1_lo",        0x0018, 0x0018, 0},
	{"base_addr1_hi",        0x001C, 0x001C, 0},
	{"not_Implemented1",     0x0020, 0x0020, 0},
	{"not_Implemented2",     0x0024, 0x0024, 0},
	{"cardbus_cis_pointer",  0x0028, 0x0028, 0},
	{"subsystem_id",         0x002E, 0x002E, 0},
	{"subsystem_vendor_id",  0x002C, 0x002C, 0},
	{"rom_base",             0x0030, 0x0030, 0},
	{"rsvd_35",              0x0035, 0x0035, 0},
	{"capabilities_pointer", 0x0034, 0x0034, 0},
	{"rsvd_38",              0x0038, 0x0038, 0},
	{"max_latency",          0x003F, 0x003F, 0},
	{"min_grant",            0x003E, 0x003E, 0},
	{"interrupt_pin",        0x003D, 0x003D, 0},
	{"interrupt_line",       0x003C, 0x003C, 0},
	{"msi_control",          0x0042, 0x0042, 0},
	{"msi_next_ptr",         0x0041, 0x0041, 0},
	{"msi_cap_id",           0x0040, 0x0040, 0},
	{"msi_lower_address",    0x0044, 0x0044, 0},
	{"msi_higher_address",   0x0048, 0x0048, 0},
	{"msi_unused",           0x004E, 0x004E, 0},
	{"msi_data",             0x004C, 0x004C, 0},
	{"vpd_addr",             0x0052, 0x0052, 0},
	{"vpd_next_cap",         0x0051, 0x0051, 0},
	{"vpd_cap_id",           0x0050, 0x0050, 0},
	{"vpd_data",             0x0054, 0x0054, 0},
	{"rsvd_b0",              0x0058, 0x0058, 0},
	{"pcix_command",         0x0062, 0x0062, 0},
	{"pcix_next_cap",        0x0061, 0x0061, 0},
	{"pcix_cap",             0x0060, 0x0060, 0},
	{"pcix_status",          0x0064, 0x0064, 0}
};

xge_device_config_t devconfInfo[] =
{
	{"mtu",                             0},
	{"isr_polling_cnt",                 0},
	{"latency_timer",                   0},
	{"napi_weight",                     0},
	{"max_splits_trans",                0},
	{"mmrb_count",                      0},
	{"shared_splits",                   0},
	{"stats_refresh_time_sec",          0},
	{"pci_freq_mherz",                  0},
	{"intr_mode",                       0},
	{"sched_timer_us",                  0},
	{"sched_timer_one_shot",            0},

	{"ring_memblock_size",              0},
	{"ring_scatter_mode",               0},
	{"ring_strip_vlan_tag",             0},

	{"ring_queue0_max",                    0},
	{"ring_queue0_initial",                0},
	{"ring_queue0_buffer_mode",            0},
	{"ring_queue0_dram_size_mb",           0},
	{"ring_queue0_intr_vector",            0},
	{"ring_queue0_backoff_interval_us",    0},
	{"ring_queue0_max_frm_len",            0},
	{"ring_queue0_priority",               0},
	{"ring_queue0_no_snoop_bits",          0},
	{"ring_queue0_indicate_max_pkts",      0},
	{"ring_queue0_configured",             0},
	{"ring_queue0_rts_mac_en",             0},
	{"ring_queue0_rth_en",                 0},
	{"ring_queue0_rts_port_en",            0},
	{"ring_queue0_rts_port0_num",          0},
	{"ring_queue0_rts_port0_udp",          0},
	{"ring_queue0_rts_port0_src",          0},
	{"ring_queue0_rts_port1_num",          0},
	{"ring_queue0_rts_port1_udp",          0},
	{"ring_queue0_rts_port1_src",          0},
	{"ring_queue0_rts_port2_num",          0},
	{"ring_queue0_rts_port2_udp",          0},
	{"ring_queue0_rts_port2_src",          0},
	{"ring_queue0_rts_port3_num",          0},
	{"ring_queue0_rts_port3_udp",          0},
	{"ring_queue0_rts_port3_src",          0},
	{"ring_queue0_rts_port4_num",          0},
	{"ring_queue0_rts_port4_udp",          0},
	{"ring_queue0_rts_port4_src",          0},
	{"ring_queue0_rts_port5_num",          0},
	{"ring_queue0_rts_port5_udp",          0},
	{"ring_queue0_rts_port5_src",          0},
	{"ring_queue0_rts_port6_num",          0},
	{"ring_queue0_rts_port6_udp",          0},
	{"ring_queue0_rts_port6_src",          0},
	{"ring_queue0_rts_port7_num",          0},
	{"ring_queue0_rts_port7_udp",          0},
	{"ring_queue0_rts_port7_src",          0},
	{"ring_queue0_rts_port8_num",          0},
	{"ring_queue0_rts_port8_udp",          0},
	{"ring_queue0_rts_port8_src",          0},
	{"ring_queue0_rts_port9_num",          0},
	{"ring_queue0_rts_port9_udp",          0},
	{"ring_queue0_rts_port9_src",          0},
	{"ring_queue0_rts_port10_num",         0},
	{"ring_queue0_rts_port10_udp",         0},
	{"ring_queue0_rts_port10_src",         0},
	{"ring_queue0_rts_port11_num",         0},
	{"ring_queue0_rts_port11_udp",         0},
	{"ring_queue0_rts_port11_src",         0},
	{"ring_queue0_rts_port12_num",         0},
	{"ring_queue0_rts_port12_udp",         0},
	{"ring_queue0_rts_port12_src",         0},
	{"ring_queue0_rts_port13_num",         0},
	{"ring_queue0_rts_port13_udp",         0},
	{"ring_queue0_rts_port13_src",         0},
	{"ring_queue0_rts_port14_num",         0},
	{"ring_queue0_rts_port14_udp",         0},
	{"ring_queue0_rts_port14_src",         0},
	{"ring_queue0_rts_port15_num",         0},
	{"ring_queue0_rts_port15_udp",         0},
	{"ring_queue0_rts_port15_src",         0},
	{"ring_queue0_rts_port16_num",         0},
	{"ring_queue0_rts_port16_udp",         0},
	{"ring_queue0_rts_port16_src",         0},
	{"ring_queue0_rts_port17_num",         0},
	{"ring_queue0_rts_port17_udp",         0},
	{"ring_queue0_rts_port17_src",         0},
	{"ring_queue0_rts_port18_num",         0},
	{"ring_queue0_rts_port18_udp",         0},
	{"ring_queue0_rts_port18_src",         0},
	{"ring_queue0_rts_port19_num",         0},
	{"ring_queue0_rts_port19_udp",         0},
	{"ring_queue0_rts_port19_src",         0},
	{"ring_queue0_rts_port20_num",         0},
	{"ring_queue0_rts_port20_udp",         0},
	{"ring_queue0_rts_port20_src",         0},
	{"ring_queue0_rts_port21_num",         0},
	{"ring_queue0_rts_port21_udp",         0},
	{"ring_queue0_rts_port21_src",         0},
	{"ring_queue0_rts_port22_num",         0},
	{"ring_queue0_rts_port22_udp",         0},
	{"ring_queue0_rts_port22_src",         0},
	{"ring_queue0_rts_port23_num",         0},
	{"ring_queue0_rts_port23_udp",         0},
	{"ring_queue0_rts_port23_src",         0},
	{"ring_queue0_rts_port24_num",         0},
	{"ring_queue0_rts_port24_udp",         0},
	{"ring_queue0_rts_port24_src",         0},
	{"ring_queue0_rts_port25_num",         0},
	{"ring_queue0_rts_port25_udp",         0},
	{"ring_queue0_rts_port25_src",         0},
	{"ring_queue0_rts_port26_num",         0},
	{"ring_queue0_rts_port26_udp",         0},
	{"ring_queue0_rts_port26_src",         0},
	{"ring_queue0_rts_port27_num",         0},
	{"ring_queue0_rts_port27_udp",         0},
	{"ring_queue0_rts_port27_src",         0},
	{"ring_queue0_rts_port28_num",         0},
	{"ring_queue0_rts_port28_udp",         0},
	{"ring_queue0_rts_port28_src",         0},
	{"ring_queue0_rts_port29_num",         0},
	{"ring_queue0_rts_port29_udp",         0},
	{"ring_queue0_rts_port29_src",         0},
	{"ring_queue0_rts_port30_num",         0},
	{"ring_queue0_rts_port30_udp",         0},
	{"ring_queue0_rts_port30_src",         0},
	{"ring_queue0_rts_port31_num",         0},
	{"ring_queue0_rts_port31_udp",         0},
	{"ring_queue0_rts_port31_src",         0},
	{"ring_queue0_rti_urange_a",           0},
	{"ring_queue0_rti_ufc_a",              0},
	{"ring_queue0_rti_urange_b",           0},
	{"ring_queue0_rti_ufc_b",              0},
	{"ring_queue0_rti_urange_c",           0},
	{"ring_queue0_rti_ufc_c",              0},
	{"ring_queue0_rti_ufc_d",              0},
	{"ring_queue0_rti_timer_ac_en",        0},
	{"ring_queue0_rti_timer_val_us",       0},

	{"ring_queue1_max",                    0},
	{"ring_queue1_initial",                0},
	{"ring_queue1_buffer_mode",            0},
	{"ring_queue1_dram_size_mb",           0},
	{"ring_queue1_intr_vector",            0},
	{"ring_queue1_backoff_interval_us",    0},
	{"ring_queue1_max_frm_len",            0},
	{"ring_queue1_priority",               0},
	{"ring_queue1_no_snoop_bits",          0},
	{"ring_queue1_indicate_max_pkts",      0},
	{"ring_queue1_configured",             0},
	{"ring_queue1_rts_mac_en",             0},
	{"ring_queue1_rth_en",                 0},
	{"ring_queue1_rts_port_en",            0},
	{"ring_queue1_rts_port0_num",          0},
	{"ring_queue1_rts_port0_udp",          0},
	{"ring_queue1_rts_port0_src",          0},
	{"ring_queue1_rts_port1_num",          0},
	{"ring_queue1_rts_port1_udp",          0},
	{"ring_queue1_rts_port1_src",          0},
	{"ring_queue1_rts_port2_num",          0},
	{"ring_queue1_rts_port2_udp",          0},
	{"ring_queue1_rts_port2_src",          0},
	{"ring_queue1_rts_port3_num",          0},
	{"ring_queue1_rts_port3_udp",          0},
	{"ring_queue1_rts_port3_src",          0},
	{"ring_queue1_rts_port4_num",          0},
	{"ring_queue1_rts_port4_udp",          0},
	{"ring_queue1_rts_port4_src",          0},
	{"ring_queue1_rts_port5_num",          0},
	{"ring_queue1_rts_port5_udp",          0},
	{"ring_queue1_rts_port5_src",          0},
	{"ring_queue1_rts_port6_num",          0},
	{"ring_queue1_rts_port6_udp",          0},
	{"ring_queue1_rts_port6_src",          0},
	{"ring_queue1_rts_port7_num",          0},
	{"ring_queue1_rts_port7_udp",          0},
	{"ring_queue1_rts_port7_src",          0},
	{"ring_queue1_rts_port8_num",          0},
	{"ring_queue1_rts_port8_udp",          0},
	{"ring_queue1_rts_port8_src",          0},
	{"ring_queue1_rts_port9_num",          0},
	{"ring_queue1_rts_port9_udp",          0},
	{"ring_queue1_rts_port9_src",          0},
	{"ring_queue1_rts_port10_num",         0},
	{"ring_queue1_rts_port10_udp",         0},
	{"ring_queue1_rts_port10_src",         0},
	{"ring_queue1_rts_port11_num",         0},
	{"ring_queue1_rts_port11_udp",         0},
	{"ring_queue1_rts_port11_src",         0},
	{"ring_queue1_rts_port12_num",         0},
	{"ring_queue1_rts_port12_udp",         0},
	{"ring_queue1_rts_port12_src",         0},
	{"ring_queue1_rts_port13_num",         0},
	{"ring_queue1_rts_port13_udp",         0},
	{"ring_queue1_rts_port13_src",         0},
	{"ring_queue1_rts_port14_num",         0},
	{"ring_queue1_rts_port14_udp",         0},
	{"ring_queue1_rts_port14_src",         0},
	{"ring_queue1_rts_port15_num",         0},
	{"ring_queue1_rts_port15_udp",         0},
	{"ring_queue1_rts_port15_src",         0},
	{"ring_queue1_rts_port16_num",         0},
	{"ring_queue1_rts_port16_udp",         0},
	{"ring_queue1_rts_port16_src",         0},
	{"ring_queue1_rts_port17_num",         0},
	{"ring_queue1_rts_port17_udp",         0},
	{"ring_queue1_rts_port17_src",         0},
	{"ring_queue1_rts_port18_num",         0},
	{"ring_queue1_rts_port18_udp",         0},
	{"ring_queue1_rts_port18_src",         0},
	{"ring_queue1_rts_port19_num",         0},
	{"ring_queue1_rts_port19_udp",         0},
	{"ring_queue1_rts_port19_src",         0},
	{"ring_queue1_rts_port20_num",         0},
	{"ring_queue1_rts_port20_udp",         0},
	{"ring_queue1_rts_port20_src",         0},
	{"ring_queue1_rts_port21_num",         0},
	{"ring_queue1_rts_port21_udp",         0},
	{"ring_queue1_rts_port21_src",         0},
	{"ring_queue1_rts_port22_num",         0},
	{"ring_queue1_rts_port22_udp",         0},
	{"ring_queue1_rts_port22_src",         0},
	{"ring_queue1_rts_port23_num",         0},
	{"ring_queue1_rts_port23_udp",         0},
	{"ring_queue1_rts_port23_src",         0},
	{"ring_queue1_rts_port24_num",         0},
	{"ring_queue1_rts_port24_udp",         0},
	{"ring_queue1_rts_port24_src",         0},
	{"ring_queue1_rts_port25_num",         0},
	{"ring_queue1_rts_port25_udp",         0},
	{"ring_queue1_rts_port25_src",         0},
	{"ring_queue1_rts_port26_num",         0},
	{"ring_queue1_rts_port26_udp",         0},
	{"ring_queue1_rts_port26_src",         0},
	{"ring_queue1_rts_port27_num",         0},
	{"ring_queue1_rts_port27_udp",         0},
	{"ring_queue1_rts_port27_src",         0},
	{"ring_queue1_rts_port28_num",         0},
	{"ring_queue1_rts_port28_udp",         0},
	{"ring_queue1_rts_port28_src",         0},
	{"ring_queue1_rts_port29_num",         0},
	{"ring_queue1_rts_port29_udp",         0},
	{"ring_queue1_rts_port29_src",         0},
	{"ring_queue1_rts_port30_num",         0},
	{"ring_queue1_rts_port30_udp",         0},
	{"ring_queue1_rts_port30_src",         0},
	{"ring_queue1_rts_port31_num",         0},
	{"ring_queue1_rts_port31_udp",         0},
	{"ring_queue1_rts_port31_src",         0},
	{"ring_queue1_rti_urange_a",           0},
	{"ring_queue1_rti_ufc_a",              0},
	{"ring_queue1_rti_urange_b",           0},
	{"ring_queue1_rti_ufc_b",              0},
	{"ring_queue1_rti_urange_c",           0},
	{"ring_queue1_rti_ufc_c",              0},
	{"ring_queue1_rti_ufc_d",              0},
	{"ring_queue1_rti_timer_ac_en",        0},
	{"ring_queue1_rti_timer_val_us",       0},

	{"ring_queue2_max",                    0},
	{"ring_queue2_initial",                0},
	{"ring_queue2_buffer_mode",            0},
	{"ring_queue2_dram_size_mb",           0},
	{"ring_queue2_intr_vector",            0},
	{"ring_queue2_backoff_interval_us",    0},
	{"ring_queue2_max_frm_len",            0},
	{"ring_queue2_priority",               0},
	{"ring_queue2_no_snoop_bits",          0},
	{"ring_queue2_indicate_max_pkts",      0},
	{"ring_queue2_configured",             0},
	{"ring_queue2_rts_mac_en",             0},
	{"ring_queue2_rth_en",                 0},
	{"ring_queue2_rts_port_en",            0},
	{"ring_queue2_rts_port0_num",          0},
	{"ring_queue2_rts_port0_udp",          0},
	{"ring_queue2_rts_port0_src",          0},
	{"ring_queue2_rts_port1_num",          0},
	{"ring_queue2_rts_port1_udp",          0},
	{"ring_queue2_rts_port1_src",          0},
	{"ring_queue2_rts_port2_num",          0},
	{"ring_queue2_rts_port2_udp",          0},
	{"ring_queue2_rts_port2_src",          0},
	{"ring_queue2_rts_port3_num",          0},
	{"ring_queue2_rts_port3_udp",          0},
	{"ring_queue2_rts_port3_src",          0},
	{"ring_queue2_rts_port4_num",          0},
	{"ring_queue2_rts_port4_udp",          0},
	{"ring_queue2_rts_port4_src",          0},
	{"ring_queue2_rts_port5_num",          0},
	{"ring_queue2_rts_port5_udp",          0},
	{"ring_queue2_rts_port5_src",          0},
	{"ring_queue2_rts_port6_num",          0},
	{"ring_queue2_rts_port6_udp",          0},
	{"ring_queue2_rts_port6_src",          0},
	{"ring_queue2_rts_port7_num",          0},
	{"ring_queue2_rts_port7_udp",          0},
	{"ring_queue2_rts_port7_src",          0},
	{"ring_queue2_rts_port8_num",          0},
	{"ring_queue2_rts_port8_udp",          0},
	{"ring_queue2_rts_port8_src",          0},
	{"ring_queue2_rts_port9_num",          0},
	{"ring_queue2_rts_port9_udp",          0},
	{"ring_queue2_rts_port9_src",          0},
	{"ring_queue2_rts_port10_num",         0},
	{"ring_queue2_rts_port10_udp",         0},
	{"ring_queue2_rts_port10_src",         0},
	{"ring_queue2_rts_port11_num",         0},
	{"ring_queue2_rts_port11_udp",         0},
	{"ring_queue2_rts_port11_src",         0},
	{"ring_queue2_rts_port12_num",         0},
	{"ring_queue2_rts_port12_udp",         0},
	{"ring_queue2_rts_port12_src",         0},
	{"ring_queue2_rts_port13_num",         0},
	{"ring_queue2_rts_port13_udp",         0},
	{"ring_queue2_rts_port13_src",         0},
	{"ring_queue2_rts_port14_num",         0},
	{"ring_queue2_rts_port14_udp",         0},
	{"ring_queue2_rts_port14_src",         0},
	{"ring_queue2_rts_port15_num",         0},
	{"ring_queue2_rts_port15_udp",         0},
	{"ring_queue2_rts_port15_src",         0},
	{"ring_queue2_rts_port16_num",         0},
	{"ring_queue2_rts_port16_udp",         0},
	{"ring_queue2_rts_port16_src",         0},
	{"ring_queue2_rts_port17_num",         0},
	{"ring_queue2_rts_port17_udp",         0},
	{"ring_queue2_rts_port17_src",         0},
	{"ring_queue2_rts_port18_num",         0},
	{"ring_queue2_rts_port18_udp",         0},
	{"ring_queue2_rts_port18_src",         0},
	{"ring_queue2_rts_port19_num",         0},
	{"ring_queue2_rts_port19_udp",         0},
	{"ring_queue2_rts_port19_src",         0},
	{"ring_queue2_rts_port20_num",         0},
	{"ring_queue2_rts_port20_udp",         0},
	{"ring_queue2_rts_port20_src",         0},
	{"ring_queue2_rts_port21_num",         0},
	{"ring_queue2_rts_port21_udp",         0},
	{"ring_queue2_rts_port21_src",         0},
	{"ring_queue2_rts_port22_num",         0},
	{"ring_queue2_rts_port22_udp",         0},
	{"ring_queue2_rts_port22_src",         0},
	{"ring_queue2_rts_port23_num",         0},
	{"ring_queue2_rts_port23_udp",         0},
	{"ring_queue2_rts_port23_src",         0},
	{"ring_queue2_rts_port24_num",         0},
	{"ring_queue2_rts_port24_udp",         0},
	{"ring_queue2_rts_port24_src",         0},
	{"ring_queue2_rts_port25_num",         0},
	{"ring_queue2_rts_port25_udp",         0},
	{"ring_queue2_rts_port25_src",         0},
	{"ring_queue2_rts_port26_num",         0},
	{"ring_queue2_rts_port26_udp",         0},
	{"ring_queue2_rts_port26_src",         0},
	{"ring_queue2_rts_port27_num",         0},
	{"ring_queue2_rts_port27_udp",         0},
	{"ring_queue2_rts_port27_src",         0},
	{"ring_queue2_rts_port28_num",         0},
	{"ring_queue2_rts_port28_udp",         0},
	{"ring_queue2_rts_port28_src",         0},
	{"ring_queue2_rts_port29_num",         0},
	{"ring_queue2_rts_port29_udp",         0},
	{"ring_queue2_rts_port29_src",         0},
	{"ring_queue2_rts_port30_num",         0},
	{"ring_queue2_rts_port30_udp",         0},
	{"ring_queue2_rts_port30_src",         0},
	{"ring_queue2_rts_port31_num",         0},
	{"ring_queue2_rts_port31_udp",         0},
	{"ring_queue2_rts_port31_src",         0},
	{"ring_queue2_rti_urange_a",           0},
	{"ring_queue2_rti_ufc_a",              0},
	{"ring_queue2_rti_urange_b",           0},
	{"ring_queue2_rti_ufc_b",              0},
	{"ring_queue2_rti_urange_c",           0},
	{"ring_queue2_rti_ufc_c",              0},
	{"ring_queue2_rti_ufc_d",              0},
	{"ring_queue2_rti_timer_ac_en",        0},
	{"ring_queue2_rti_timer_val_us",       0},

	{"ring_queue3_max",                    0},
	{"ring_queue3_initial",                0},
	{"ring_queue3_buffer_mode",            0},
	{"ring_queue3_dram_size_mb",           0},
	{"ring_queue3_intr_vector",            0},
	{"ring_queue3_backoff_interval_us",    0},
	{"ring_queue3_max_frm_len",            0},
	{"ring_queue3_priority",               0},
	{"ring_queue3_no_snoop_bits",          0},
	{"ring_queue3_indicate_max_pkts",      0},
	{"ring_queue3_configured",             0},
	{"ring_queue3_rts_mac_en",             0},
	{"ring_queue3_rth_en",                 0},
	{"ring_queue3_rts_port_en",            0},
	{"ring_queue3_rts_port0_num",          0},
	{"ring_queue3_rts_port0_udp",          0},
	{"ring_queue3_rts_port0_src",          0},
	{"ring_queue3_rts_port1_num",          0},
	{"ring_queue3_rts_port1_udp",          0},
	{"ring_queue3_rts_port1_src",          0},
	{"ring_queue3_rts_port2_num",          0},
	{"ring_queue3_rts_port2_udp",          0},
	{"ring_queue3_rts_port2_src",          0},
	{"ring_queue3_rts_port3_num",          0},
	{"ring_queue3_rts_port3_udp",          0},
	{"ring_queue3_rts_port3_src",          0},
	{"ring_queue3_rts_port4_num",          0},
	{"ring_queue3_rts_port4_udp",          0},
	{"ring_queue3_rts_port4_src",          0},
	{"ring_queue3_rts_port5_num",          0},
	{"ring_queue3_rts_port5_udp",          0},
	{"ring_queue3_rts_port5_src",          0},
	{"ring_queue3_rts_port6_num",          0},
	{"ring_queue3_rts_port6_udp",          0},
	{"ring_queue3_rts_port6_src",          0},
	{"ring_queue3_rts_port7_num",          0},
	{"ring_queue3_rts_port7_udp",          0},
	{"ring_queue3_rts_port7_src",          0},
	{"ring_queue3_rts_port8_num",          0},
	{"ring_queue3_rts_port8_udp",          0},
	{"ring_queue3_rts_port8_src",          0},
	{"ring_queue3_rts_port9_num",          0},
	{"ring_queue3_rts_port9_udp",          0},
	{"ring_queue3_rts_port9_src",          0},
	{"ring_queue3_rts_port10_num",         0},
	{"ring_queue3_rts_port10_udp",         0},
	{"ring_queue3_rts_port10_src",         0},
	{"ring_queue3_rts_port11_num",         0},
	{"ring_queue3_rts_port11_udp",         0},
	{"ring_queue3_rts_port11_src",         0},
	{"ring_queue3_rts_port12_num",         0},
	{"ring_queue3_rts_port12_udp",         0},
	{"ring_queue3_rts_port12_src",         0},
	{"ring_queue3_rts_port13_num",         0},
	{"ring_queue3_rts_port13_udp",         0},
	{"ring_queue3_rts_port13_src",         0},
	{"ring_queue3_rts_port14_num",         0},
	{"ring_queue3_rts_port14_udp",         0},
	{"ring_queue3_rts_port14_src",         0},
	{"ring_queue3_rts_port15_num",         0},
	{"ring_queue3_rts_port15_udp",         0},
	{"ring_queue3_rts_port15_src",         0},
	{"ring_queue3_rts_port16_num",         0},
	{"ring_queue3_rts_port16_udp",         0},
	{"ring_queue3_rts_port16_src",         0},
	{"ring_queue3_rts_port17_num",         0},
	{"ring_queue3_rts_port17_udp",         0},
	{"ring_queue3_rts_port17_src",         0},
	{"ring_queue3_rts_port18_num",         0},
	{"ring_queue3_rts_port18_udp",         0},
	{"ring_queue3_rts_port18_src",         0},
	{"ring_queue3_rts_port19_num",         0},
	{"ring_queue3_rts_port19_udp",         0},
	{"ring_queue3_rts_port19_src",         0},
	{"ring_queue3_rts_port20_num",         0},
	{"ring_queue3_rts_port20_udp",         0},
	{"ring_queue3_rts_port20_src",         0},
	{"ring_queue3_rts_port21_num",         0},
	{"ring_queue3_rts_port21_udp",         0},
	{"ring_queue3_rts_port21_src",         0},
	{"ring_queue3_rts_port22_num",         0},
	{"ring_queue3_rts_port22_udp",         0},
	{"ring_queue3_rts_port22_src",         0},
	{"ring_queue3_rts_port23_num",         0},
	{"ring_queue3_rts_port23_udp",         0},
	{"ring_queue3_rts_port23_src",         0},
	{"ring_queue3_rts_port24_num",         0},
	{"ring_queue3_rts_port24_udp",         0},
	{"ring_queue3_rts_port24_src",         0},
	{"ring_queue3_rts_port25_num",         0},
	{"ring_queue3_rts_port25_udp",         0},
	{"ring_queue3_rts_port25_src",         0},
	{"ring_queue3_rts_port26_num",         0},
	{"ring_queue3_rts_port26_udp",         0},
	{"ring_queue3_rts_port26_src",         0},
	{"ring_queue3_rts_port27_num",         0},
	{"ring_queue3_rts_port27_udp",         0},
	{"ring_queue3_rts_port27_src",         0},
	{"ring_queue3_rts_port28_num",         0},
	{"ring_queue3_rts_port28_udp",         0},
	{"ring_queue3_rts_port28_src",         0},
	{"ring_queue3_rts_port29_num",         0},
	{"ring_queue3_rts_port29_udp",         0},
	{"ring_queue3_rts_port29_src",         0},
	{"ring_queue3_rts_port30_num",         0},
	{"ring_queue3_rts_port30_udp",         0},
	{"ring_queue3_rts_port30_src",         0},
	{"ring_queue3_rts_port31_num",         0},
	{"ring_queue3_rts_port31_udp",         0},
	{"ring_queue3_rts_port31_src",         0},
	{"ring_queue3_rti_urange_a",           0},
	{"ring_queue3_rti_ufc_a",              0},
	{"ring_queue3_rti_urange_b",           0},
	{"ring_queue3_rti_ufc_b",              0},
	{"ring_queue3_rti_urange_c",           0},
	{"ring_queue3_rti_ufc_c",              0},
	{"ring_queue3_rti_ufc_d",              0},
	{"ring_queue3_rti_timer_ac_en",        0},
	{"ring_queue3_rti_timer_val_us",       0},

	{"ring_queue4_max",                    0},
	{"ring_queue4_initial",                0},
	{"ring_queue4_buffer_mode",            0},
	{"ring_queue4_dram_size_mb",           0},
	{"ring_queue4_intr_vector",            0},
	{"ring_queue4_backoff_interval_us",    0},
	{"ring_queue4_max_frm_len",            0},
	{"ring_queue4_priority",               0},
	{"ring_queue4_no_snoop_bits",          0},
	{"ring_queue4_indicate_max_pkts",      0},
	{"ring_queue4_configured",             0},
	{"ring_queue4_rts_mac_en",             0},
	{"ring_queue4_rth_en",                 0},
	{"ring_queue4_rts_port_en",            0},
	{"ring_queue4_rts_port0_num",          0},
	{"ring_queue4_rts_port0_udp",          0},
	{"ring_queue4_rts_port0_src",          0},
	{"ring_queue4_rts_port1_num",          0},
	{"ring_queue4_rts_port1_udp",          0},
	{"ring_queue4_rts_port1_src",          0},
	{"ring_queue4_rts_port2_num",          0},
	{"ring_queue4_rts_port2_udp",          0},
	{"ring_queue4_rts_port2_src",          0},
	{"ring_queue4_rts_port3_num",          0},
	{"ring_queue4_rts_port3_udp",          0},
	{"ring_queue4_rts_port3_src",          0},
	{"ring_queue4_rts_port4_num",          0},
	{"ring_queue4_rts_port4_udp",          0},
	{"ring_queue4_rts_port4_src",          0},
	{"ring_queue4_rts_port5_num",          0},
	{"ring_queue4_rts_port5_udp",          0},
	{"ring_queue4_rts_port5_src",          0},
	{"ring_queue4_rts_port6_num",          0},
	{"ring_queue4_rts_port6_udp",          0},
	{"ring_queue4_rts_port6_src",          0},
	{"ring_queue4_rts_port7_num",          0},
	{"ring_queue4_rts_port7_udp",          0},
	{"ring_queue4_rts_port7_src",          0},
	{"ring_queue4_rts_port8_num",          0},
	{"ring_queue4_rts_port8_udp",          0},
	{"ring_queue4_rts_port8_src",          0},
	{"ring_queue4_rts_port9_num",          0},
	{"ring_queue4_rts_port9_udp",          0},
	{"ring_queue4_rts_port9_src",          0},
	{"ring_queue4_rts_port10_num",         0},
	{"ring_queue4_rts_port10_udp",         0},
	{"ring_queue4_rts_port10_src",         0},
	{"ring_queue4_rts_port11_num",         0},
	{"ring_queue4_rts_port11_udp",         0},
	{"ring_queue4_rts_port11_src",         0},
	{"ring_queue4_rts_port12_num",         0},
	{"ring_queue4_rts_port12_udp",         0},
	{"ring_queue4_rts_port12_src",         0},
	{"ring_queue4_rts_port13_num",         0},
	{"ring_queue4_rts_port13_udp",         0},
	{"ring_queue4_rts_port13_src",         0},
	{"ring_queue4_rts_port14_num",         0},
	{"ring_queue4_rts_port14_udp",         0},
	{"ring_queue4_rts_port14_src",         0},
	{"ring_queue4_rts_port15_num",         0},
	{"ring_queue4_rts_port15_udp",         0},
	{"ring_queue4_rts_port15_src",         0},
	{"ring_queue4_rts_port16_num",         0},
	{"ring_queue4_rts_port16_udp",         0},
	{"ring_queue4_rts_port16_src",         0},
	{"ring_queue4_rts_port17_num",         0},
	{"ring_queue4_rts_port17_udp",         0},
	{"ring_queue4_rts_port17_src",         0},
	{"ring_queue4_rts_port18_num",         0},
	{"ring_queue4_rts_port18_udp",         0},
	{"ring_queue4_rts_port18_src",         0},
	{"ring_queue4_rts_port19_num",         0},
	{"ring_queue4_rts_port19_udp",         0},
	{"ring_queue4_rts_port19_src",         0},
	{"ring_queue4_rts_port20_num",         0},
	{"ring_queue4_rts_port20_udp",         0},
	{"ring_queue4_rts_port20_src",         0},
	{"ring_queue4_rts_port21_num",         0},
	{"ring_queue4_rts_port21_udp",         0},
	{"ring_queue4_rts_port21_src",         0},
	{"ring_queue4_rts_port22_num",         0},
	{"ring_queue4_rts_port22_udp",         0},
	{"ring_queue4_rts_port22_src",         0},
	{"ring_queue4_rts_port23_num",         0},
	{"ring_queue4_rts_port23_udp",         0},
	{"ring_queue4_rts_port23_src",         0},
	{"ring_queue4_rts_port24_num",         0},
	{"ring_queue4_rts_port24_udp",         0},
	{"ring_queue4_rts_port24_src",         0},
	{"ring_queue4_rts_port25_num",         0},
	{"ring_queue4_rts_port25_udp",         0},
	{"ring_queue4_rts_port25_src",         0},
	{"ring_queue4_rts_port26_num",         0},
	{"ring_queue4_rts_port26_udp",         0},
	{"ring_queue4_rts_port26_src",         0},
	{"ring_queue4_rts_port27_num",         0},
	{"ring_queue4_rts_port27_udp",         0},
	{"ring_queue4_rts_port27_src",         0},
	{"ring_queue4_rts_port28_num",         0},
	{"ring_queue4_rts_port28_udp",         0},
	{"ring_queue4_rts_port28_src",         0},
	{"ring_queue4_rts_port29_num",         0},
	{"ring_queue4_rts_port29_udp",         0},
	{"ring_queue4_rts_port29_src",         0},
	{"ring_queue4_rts_port30_num",         0},
	{"ring_queue4_rts_port30_udp",         0},
	{"ring_queue4_rts_port30_src",         0},
	{"ring_queue4_rts_port31_num",         0},
	{"ring_queue4_rts_port31_udp",         0},
	{"ring_queue4_rts_port31_src",         0},
	{"ring_queue4_rti_urange_a",           0},
	{"ring_queue4_rti_ufc_a",              0},
	{"ring_queue4_rti_urange_b",           0},
	{"ring_queue4_rti_ufc_b",              0},
	{"ring_queue4_rti_urange_c",           0},
	{"ring_queue4_rti_ufc_c",              0},
	{"ring_queue4_rti_ufc_d",              0},
	{"ring_queue4_rti_timer_ac_en",        0},
	{"ring_queue4_rti_timer_val_us",       0},

	{"ring_queue5_max",                    0},
	{"ring_queue5_initial",                0},
	{"ring_queue5_buffer_mode",            0},
	{"ring_queue5_dram_size_mb",           0},
	{"ring_queue5_intr_vector",            0},
	{"ring_queue5_backoff_interval_us",    0},
	{"ring_queue5_max_frm_len",            0},
	{"ring_queue5_priority",               0},
	{"ring_queue5_no_snoop_bits",          0},
	{"ring_queue5_indicate_max_pkts",      0},
	{"ring_queue5_configured",             0},
	{"ring_queue5_rts_mac_en",             0},
	{"ring_queue5_rth_en",                 0},
	{"ring_queue5_rts_port_en",            0},
	{"ring_queue5_rts_port0_num",          0},
	{"ring_queue5_rts_port0_udp",          0},
	{"ring_queue5_rts_port0_src",          0},
	{"ring_queue5_rts_port1_num",          0},
	{"ring_queue5_rts_port1_udp",          0},
	{"ring_queue5_rts_port1_src",          0},
	{"ring_queue5_rts_port2_num",          0},
	{"ring_queue5_rts_port2_udp",          0},
	{"ring_queue5_rts_port2_src",          0},
	{"ring_queue5_rts_port3_num",          0},
	{"ring_queue5_rts_port3_udp",          0},
	{"ring_queue5_rts_port3_src",          0},
	{"ring_queue5_rts_port4_num",          0},
	{"ring_queue5_rts_port4_udp",          0},
	{"ring_queue5_rts_port4_src",          0},
	{"ring_queue5_rts_port5_num",          0},
	{"ring_queue5_rts_port5_udp",          0},
	{"ring_queue5_rts_port5_src",          0},
	{"ring_queue5_rts_port6_num",          0},
	{"ring_queue5_rts_port6_udp",          0},
	{"ring_queue5_rts_port6_src",          0},
	{"ring_queue5_rts_port7_num",          0},
	{"ring_queue5_rts_port7_udp",          0},
	{"ring_queue5_rts_port7_src",          0},
	{"ring_queue5_rts_port8_num",          0},
	{"ring_queue5_rts_port8_udp",          0},
	{"ring_queue5_rts_port8_src",          0},
	{"ring_queue5_rts_port9_num",          0},
	{"ring_queue5_rts_port9_udp",          0},
	{"ring_queue5_rts_port9_src",          0},
	{"ring_queue5_rts_port10_num",         0},
	{"ring_queue5_rts_port10_udp",         0},
	{"ring_queue5_rts_port10_src",         0},
	{"ring_queue5_rts_port11_num",         0},
	{"ring_queue5_rts_port11_udp",         0},
	{"ring_queue5_rts_port11_src",         0},
	{"ring_queue5_rts_port12_num",         0},
	{"ring_queue5_rts_port12_udp",         0},
	{"ring_queue5_rts_port12_src",         0},
	{"ring_queue5_rts_port13_num",         0},
	{"ring_queue5_rts_port13_udp",         0},
	{"ring_queue5_rts_port13_src",         0},
	{"ring_queue5_rts_port14_num",         0},
	{"ring_queue5_rts_port14_udp",         0},
	{"ring_queue5_rts_port14_src",         0},
	{"ring_queue5_rts_port15_num",         0},
	{"ring_queue5_rts_port15_udp",         0},
	{"ring_queue5_rts_port15_src",         0},
	{"ring_queue5_rts_port16_num",         0},
	{"ring_queue5_rts_port16_udp",         0},
	{"ring_queue5_rts_port16_src",         0},
	{"ring_queue5_rts_port17_num",         0},
	{"ring_queue5_rts_port17_udp",         0},
	{"ring_queue5_rts_port17_src",         0},
	{"ring_queue5_rts_port18_num",         0},
	{"ring_queue5_rts_port18_udp",         0},
	{"ring_queue5_rts_port18_src",         0},
	{"ring_queue5_rts_port19_num",         0},
	{"ring_queue5_rts_port19_udp",         0},
	{"ring_queue5_rts_port19_src",         0},
	{"ring_queue5_rts_port20_num",         0},
	{"ring_queue5_rts_port20_udp",         0},
	{"ring_queue5_rts_port20_src",         0},
	{"ring_queue5_rts_port21_num",         0},
	{"ring_queue5_rts_port21_udp",         0},
	{"ring_queue5_rts_port21_src",         0},
	{"ring_queue5_rts_port22_num",         0},
	{"ring_queue5_rts_port22_udp",         0},
	{"ring_queue5_rts_port22_src",         0},
	{"ring_queue5_rts_port23_num",         0},
	{"ring_queue5_rts_port23_udp",         0},
	{"ring_queue5_rts_port23_src",         0},
	{"ring_queue5_rts_port24_num",         0},
	{"ring_queue5_rts_port24_udp",         0},
	{"ring_queue5_rts_port24_src",         0},
	{"ring_queue5_rts_port25_num",         0},
	{"ring_queue5_rts_port25_udp",         0},
	{"ring_queue5_rts_port25_src",         0},
	{"ring_queue5_rts_port26_num",         0},
	{"ring_queue5_rts_port26_udp",         0},
	{"ring_queue5_rts_port26_src",         0},
	{"ring_queue5_rts_port27_num",         0},
	{"ring_queue5_rts_port27_udp",         0},
	{"ring_queue5_rts_port27_src",         0},
	{"ring_queue5_rts_port28_num",         0},
	{"ring_queue5_rts_port28_udp",         0},
	{"ring_queue5_rts_port28_src",         0},
	{"ring_queue5_rts_port29_num",         0},
	{"ring_queue5_rts_port29_udp",         0},
	{"ring_queue5_rts_port29_src",         0},
	{"ring_queue5_rts_port30_num",         0},
	{"ring_queue5_rts_port30_udp",         0},
	{"ring_queue5_rts_port30_src",         0},
	{"ring_queue5_rts_port31_num",         0},
	{"ring_queue5_rts_port31_udp",         0},
	{"ring_queue5_rts_port31_src",         0},
	{"ring_queue5_rti_urange_a",           0},
	{"ring_queue5_rti_ufc_a",              0},
	{"ring_queue5_rti_urange_b",           0},
	{"ring_queue5_rti_ufc_b",              0},
	{"ring_queue5_rti_urange_c",           0},
	{"ring_queue5_rti_ufc_c",              0},
	{"ring_queue5_rti_ufc_d",              0},
	{"ring_queue5_rti_timer_ac_en",        0},
	{"ring_queue5_rti_timer_val_us",       0},

	{"ring_queue6_max",                    0},
	{"ring_queue6_initial",                0},
	{"ring_queue6_buffer_mode",            0},
	{"ring_queue6_dram_size_mb",           0},
	{"ring_queue6_intr_vector",            0},
	{"ring_queue6_backoff_interval_us",    0},
	{"ring_queue6_max_frm_len",            0},
	{"ring_queue6_priority",               0},
	{"ring_queue6_no_snoop_bits",          0},
	{"ring_queue6_indicate_max_pkts",      0},
	{"ring_queue6_configured",             0},
	{"ring_queue6_rts_mac_en",             0},
	{"ring_queue6_rth_en",                 0},
	{"ring_queue6_rts_port_en",            0},
	{"ring_queue6_rts_port0_num",          0},
	{"ring_queue6_rts_port0_udp",          0},
	{"ring_queue6_rts_port0_src",          0},
	{"ring_queue6_rts_port1_num",          0},
	{"ring_queue6_rts_port1_udp",          0},
	{"ring_queue6_rts_port1_src",          0},
	{"ring_queue6_rts_port2_num",          0},
	{"ring_queue6_rts_port2_udp",          0},
	{"ring_queue6_rts_port2_src",          0},
	{"ring_queue6_rts_port3_num",          0},
	{"ring_queue6_rts_port3_udp",          0},
	{"ring_queue6_rts_port3_src",          0},
	{"ring_queue6_rts_port4_num",          0},
	{"ring_queue6_rts_port4_udp",          0},
	{"ring_queue6_rts_port4_src",          0},
	{"ring_queue6_rts_port5_num",          0},
	{"ring_queue6_rts_port5_udp",          0},
	{"ring_queue6_rts_port5_src",          0},
	{"ring_queue6_rts_port6_num",          0},
	{"ring_queue6_rts_port6_udp",          0},
	{"ring_queue6_rts_port6_src",          0},
	{"ring_queue6_rts_port7_num",          0},
	{"ring_queue6_rts_port7_udp",          0},
	{"ring_queue6_rts_port7_src",          0},
	{"ring_queue6_rts_port8_num",          0},
	{"ring_queue6_rts_port8_udp",          0},
	{"ring_queue6_rts_port8_src",          0},
	{"ring_queue6_rts_port9_num",          0},
	{"ring_queue6_rts_port9_udp",          0},
	{"ring_queue6_rts_port9_src",          0},
	{"ring_queue6_rts_port10_num",         0},
	{"ring_queue6_rts_port10_udp",         0},
	{"ring_queue6_rts_port10_src",         0},
	{"ring_queue6_rts_port11_num",         0},
	{"ring_queue6_rts_port11_udp",         0},
	{"ring_queue6_rts_port11_src",         0},
	{"ring_queue6_rts_port12_num",         0},
	{"ring_queue6_rts_port12_udp",         0},
	{"ring_queue6_rts_port12_src",         0},
	{"ring_queue6_rts_port13_num",         0},
	{"ring_queue6_rts_port13_udp",         0},
	{"ring_queue6_rts_port13_src",         0},
	{"ring_queue6_rts_port14_num",         0},
	{"ring_queue6_rts_port14_udp",         0},
	{"ring_queue6_rts_port14_src",         0},
	{"ring_queue6_rts_port15_num",         0},
	{"ring_queue6_rts_port15_udp",         0},
	{"ring_queue6_rts_port15_src",         0},
	{"ring_queue6_rts_port16_num",         0},
	{"ring_queue6_rts_port16_udp",         0},
	{"ring_queue6_rts_port16_src",         0},
	{"ring_queue6_rts_port17_num",         0},
	{"ring_queue6_rts_port17_udp",         0},
	{"ring_queue6_rts_port17_src",         0},
	{"ring_queue6_rts_port18_num",         0},
	{"ring_queue6_rts_port18_udp",         0},
	{"ring_queue6_rts_port18_src",         0},
	{"ring_queue6_rts_port19_num",         0},
	{"ring_queue6_rts_port19_udp",         0},
	{"ring_queue6_rts_port19_src",         0},
	{"ring_queue6_rts_port20_num",         0},
	{"ring_queue6_rts_port20_udp",         0},
	{"ring_queue6_rts_port20_src",         0},
	{"ring_queue6_rts_port21_num",         0},
	{"ring_queue6_rts_port21_udp",         0},
	{"ring_queue6_rts_port21_src",         0},
	{"ring_queue6_rts_port22_num",         0},
	{"ring_queue6_rts_port22_udp",         0},
	{"ring_queue6_rts_port22_src",         0},
	{"ring_queue6_rts_port23_num",         0},
	{"ring_queue6_rts_port23_udp",         0},
	{"ring_queue6_rts_port23_src",         0},
	{"ring_queue6_rts_port24_num",         0},
	{"ring_queue6_rts_port24_udp",         0},
	{"ring_queue6_rts_port24_src",         0},
	{"ring_queue6_rts_port25_num",         0},
	{"ring_queue6_rts_port25_udp",         0},
	{"ring_queue6_rts_port25_src",         0},
	{"ring_queue6_rts_port26_num",         0},
	{"ring_queue6_rts_port26_udp",         0},
	{"ring_queue6_rts_port26_src",         0},
	{"ring_queue6_rts_port27_num",         0},
	{"ring_queue6_rts_port27_udp",         0},
	{"ring_queue6_rts_port27_src",         0},
	{"ring_queue6_rts_port28_num",         0},
	{"ring_queue6_rts_port28_udp",         0},
	{"ring_queue6_rts_port28_src",         0},
	{"ring_queue6_rts_port29_num",         0},
	{"ring_queue6_rts_port29_udp",         0},
	{"ring_queue6_rts_port29_src",         0},
	{"ring_queue6_rts_port30_num",         0},
	{"ring_queue6_rts_port30_udp",         0},
	{"ring_queue6_rts_port30_src",         0},
	{"ring_queue6_rts_port31_num",         0},
	{"ring_queue6_rts_port31_udp",         0},
	{"ring_queue6_rts_port31_src",         0},
	{"ring_queue6_rti_urange_a",           0},
	{"ring_queue6_rti_ufc_a",              0},
	{"ring_queue6_rti_urange_b",           0},
	{"ring_queue6_rti_ufc_b",              0},
	{"ring_queue6_rti_urange_c",           0},
	{"ring_queue6_rti_ufc_c",              0},
	{"ring_queue6_rti_ufc_d",              0},
	{"ring_queue6_rti_timer_ac_en",        0},
	{"ring_queue6_rti_timer_val_us",       0},

	{"ring_queue7_max",                    0},
	{"ring_queue7_initial",                0},
	{"ring_queue7_buffer_mode",            0},
	{"ring_queue7_dram_size_mb",           0},
	{"ring_queue7_intr_vector",            0},
	{"ring_queue7_backoff_interval_us",    0},
	{"ring_queue7_max_frm_len",            0},
	{"ring_queue7_priority",               0},
	{"ring_queue7_no_snoop_bits",          0},
	{"ring_queue7_indicate_max_pkts",      0},
	{"ring_queue7_configured",             0},
	{"ring_queue7_rts_mac_en",             0},
	{"ring_queue7_rth_en",                 0},
	{"ring_queue7_rts_port_en",            0},
	{"ring_queue7_rts_port0_num",          0},
	{"ring_queue7_rts_port0_udp",          0},
	{"ring_queue7_rts_port0_src",          0},
	{"ring_queue7_rts_port1_num",          0},
	{"ring_queue7_rts_port1_udp",          0},
	{"ring_queue7_rts_port1_src",          0},
	{"ring_queue7_rts_port2_num",          0},
	{"ring_queue7_rts_port2_udp",          0},
	{"ring_queue7_rts_port2_src",          0},
	{"ring_queue7_rts_port3_num",          0},
	{"ring_queue7_rts_port3_udp",          0},
	{"ring_queue7_rts_port3_src",          0},
	{"ring_queue7_rts_port4_num",          0},
	{"ring_queue7_rts_port4_udp",          0},
	{"ring_queue7_rts_port4_src",          0},
	{"ring_queue7_rts_port5_num",          0},
	{"ring_queue7_rts_port5_udp",          0},
	{"ring_queue7_rts_port5_src",          0},
	{"ring_queue7_rts_port6_num",          0},
	{"ring_queue7_rts_port6_udp",          0},
	{"ring_queue7_rts_port6_src",          0},
	{"ring_queue7_rts_port7_num",          0},
	{"ring_queue7_rts_port7_udp",          0},
	{"ring_queue7_rts_port7_src",          0},
	{"ring_queue7_rts_port8_num",          0},
	{"ring_queue7_rts_port8_udp",          0},
	{"ring_queue7_rts_port8_src",          0},
	{"ring_queue7_rts_port9_num",          0},
	{"ring_queue7_rts_port9_udp",          0},
	{"ring_queue7_rts_port9_src",          0},
	{"ring_queue7_rts_port10_num",         0},
	{"ring_queue7_rts_port10_udp",         0},
	{"ring_queue7_rts_port10_src",         0},
	{"ring_queue7_rts_port11_num",         0},
	{"ring_queue7_rts_port11_udp",         0},
	{"ring_queue7_rts_port11_src",         0},
	{"ring_queue7_rts_port12_num",         0},
	{"ring_queue7_rts_port12_udp",         0},
	{"ring_queue7_rts_port12_src",         0},
	{"ring_queue7_rts_port13_num",         0},
	{"ring_queue7_rts_port13_udp",         0},
	{"ring_queue7_rts_port13_src",         0},
	{"ring_queue7_rts_port14_num",         0},
	{"ring_queue7_rts_port14_udp",         0},
	{"ring_queue7_rts_port14_src",         0},
	{"ring_queue7_rts_port15_num",         0},
	{"ring_queue7_rts_port15_udp",         0},
	{"ring_queue7_rts_port15_src",         0},
	{"ring_queue7_rts_port16_num",         0},
	{"ring_queue7_rts_port16_udp",         0},
	{"ring_queue7_rts_port16_src",         0},
	{"ring_queue7_rts_port17_num",         0},
	{"ring_queue7_rts_port17_udp",         0},
	{"ring_queue7_rts_port17_src",         0},
	{"ring_queue7_rts_port18_num",         0},
	{"ring_queue7_rts_port18_udp",         0},
	{"ring_queue7_rts_port18_src",         0},
	{"ring_queue7_rts_port19_num",         0},
	{"ring_queue7_rts_port19_udp",         0},
	{"ring_queue7_rts_port19_src",         0},
	{"ring_queue7_rts_port20_num",         0},
	{"ring_queue7_rts_port20_udp",         0},
	{"ring_queue7_rts_port20_src",         0},
	{"ring_queue7_rts_port21_num",         0},
	{"ring_queue7_rts_port21_udp",         0},
	{"ring_queue7_rts_port21_src",         0},
	{"ring_queue7_rts_port22_num",         0},
	{"ring_queue7_rts_port22_udp",         0},
	{"ring_queue7_rts_port22_src",         0},
	{"ring_queue7_rts_port23_num",         0},
	{"ring_queue7_rts_port23_udp",         0},
	{"ring_queue7_rts_port23_src",         0},
	{"ring_queue7_rts_port24_num",         0},
	{"ring_queue7_rts_port24_udp",         0},
	{"ring_queue7_rts_port24_src",         0},
	{"ring_queue7_rts_port25_num",         0},
	{"ring_queue7_rts_port25_udp",         0},
	{"ring_queue7_rts_port25_src",         0},
	{"ring_queue7_rts_port26_num",         0},
	{"ring_queue7_rts_port26_udp",         0},
	{"ring_queue7_rts_port26_src",         0},
	{"ring_queue7_rts_port27_num",         0},
	{"ring_queue7_rts_port27_udp",         0},
	{"ring_queue7_rts_port27_src",         0},
	{"ring_queue7_rts_port28_num",         0},
	{"ring_queue7_rts_port28_udp",         0},
	{"ring_queue7_rts_port28_src",         0},
	{"ring_queue7_rts_port29_num",         0},
	{"ring_queue7_rts_port29_udp",         0},
	{"ring_queue7_rts_port29_src",         0},
	{"ring_queue7_rts_port30_num",         0},
	{"ring_queue7_rts_port30_udp",         0},
	{"ring_queue7_rts_port30_src",         0},
	{"ring_queue7_rts_port31_num",         0},
	{"ring_queue7_rts_port31_udp",         0},
	{"ring_queue7_rts_port31_src",         0},
	{"ring_queue7_rti_urange_a",           0},
	{"ring_queue7_rti_ufc_a",              0},
	{"ring_queue7_rti_urange_b",           0},
	{"ring_queue7_rti_ufc_b",              0},
	{"ring_queue7_rti_urange_c",           0},
	{"ring_queue7_rti_ufc_c",              0},
	{"ring_queue7_rti_ufc_d",              0},
	{"ring_queue7_rti_timer_ac_en",        0},
	{"ring_queue7_rti_timer_val_us",       0},

	{"mac_media",                       0},
	{"mac_tmac_util_period",            0},
	{"mac_rmac_util_period",            0},
	{"mac_rmac_bcast_en",               0},
	{"mac_rmac_pause_gen_en",           0},
	{"mac_rmac_pause_rcv_en",           0},
	{"mac_rmac_pause_time",             0},
	{"mac_mc_pause_threshold_q0q3",     0},
	{"mac_mc_pause_threshold_q4q7",     0},

	{"fifo_max_frags",                  0},
	{"fifo_reserve_threshold",          0},
	{"fifo_memblock_size",              0},
	{"fifo_alignment_size",             0},
	{"fifo_max_aligned_frags",          0},

	{"fifo_queue0_max",                 0},
	{"fifo_queue0_initial",             0},
	{"fifo_queue0_intr",                0},
	{"fifo_queue0_intr_vector",         0},
	{"fifo_queue0_no_snoop_bits",       0},
	{"fifo_queue0_priority",            0},
	{"fifo_queue0_configured",          0},

	{"fifo_queue0_tti0_enabled",         0},
	{"fifo_queue0_tti0_urange_a",        0},
	{"fifo_queue0_tti0_ufc_a",           0},
	{"fifo_queue0_tti0_urange_b",        0},
	{"fifo_queue0_tti0_ufc_b",           0},
	{"fifo_queue0_tti0_urange_c",        0},
	{"fifo_queue0_tti0_ufc_c",           0},
	{"fifo_queue0_tti0_ufc_d",           0},
	{"fifo_queue0_tti0_timer_val_us",    0},
	{"fifo_queue0_tti0_timer_ac_en",     0},
	{"fifo_queue0_tti0_timer_ci_en",     0},

	{"fifo_queue0_tti1_enabled",         0},
	{"fifo_queue0_tti1_urange_a",        0},
	{"fifo_queue0_tti1_ufc_a",           0},
	{"fifo_queue0_tti1_urange_b",        0},
	{"fifo_queue0_tti1_ufc_b",           0},
	{"fifo_queue0_tti1_urange_c",        0},
	{"fifo_queue0_tti1_ufc_c",           0},
	{"fifo_queue0_tti1_ufc_d",           0},
	{"fifo_queue0_tti1_timer_val_us",    0},
	{"fifo_queue0_tti1_timer_ac_en",     0},
	{"fifo_queue0_tti1_timer_ci_en",     0},

	{"fifo_queue0_tti2_enabled",         0},
	{"fifo_queue0_tti2_urange_a",        0},
	{"fifo_queue0_tti2_ufc_a",           0},
	{"fifo_queue0_tti2_urange_b",        0},
	{"fifo_queue0_tti2_ufc_b",           0},
	{"fifo_queue0_tti2_urange_c",        0},
	{"fifo_queue0_tti2_ufc_c",           0},
	{"fifo_queue0_tti2_ufc_d",           0},
	{"fifo_queue0_tti2_timer_val_us",    0},
	{"fifo_queue0_tti2_timer_ac_en",     0},
	{"fifo_queue0_tti2_timer_ci_en",     0},

	{"fifo_queue0_tti3_enabled",         0},
	{"fifo_queue0_tti3_urange_a",        0},
	{"fifo_queue0_tti3_ufc_a",           0},
	{"fifo_queue0_tti3_urange_b",        0},
	{"fifo_queue0_tti3_ufc_b",           0},
	{"fifo_queue0_tti3_urange_c",        0},
	{"fifo_queue0_tti3_ufc_c",           0},
	{"fifo_queue0_tti3_ufc_d",           0},
	{"fifo_queue0_tti3_timer_val_us",    0},
	{"fifo_queue0_tti3_timer_ac_en",     0},
	{"fifo_queue0_tti3_timer_ci_en",     0},

	{"fifo_queue0_tti4_enabled",         0},
	{"fifo_queue0_tti4_urange_a",        0},
	{"fifo_queue0_tti4_ufc_a",           0},
	{"fifo_queue0_tti4_urange_b",        0},
	{"fifo_queue0_tti4_ufc_b",           0},
	{"fifo_queue0_tti4_urange_c",        0},
	{"fifo_queue0_tti4_ufc_c",           0},
	{"fifo_queue0_tti4_ufc_d",           0},
	{"fifo_queue0_tti4_timer_val_us",    0},
	{"fifo_queue0_tti4_timer_ac_en",     0},
	{"fifo_queue0_tti4_timer_ci_en",     0},

	{"fifo_queue0_tti5_enabled",         0},
	{"fifo_queue0_tti5_urange_a",        0},
	{"fifo_queue0_tti5_ufc_a",           0},
	{"fifo_queue0_tti5_urange_b",        0},
	{"fifo_queue0_tti5_ufc_b",           0},
	{"fifo_queue0_tti5_urange_c",        0},
	{"fifo_queue0_tti5_ufc_c",           0},
	{"fifo_queue0_tti5_ufc_d",           0},
	{"fifo_queue0_tti5_timer_val_us",    0},
	{"fifo_queue0_tti5_timer_ac_en",     0},
	{"fifo_queue0_tti5_timer_ci_en",     0},

	{"fifo_queue0_tti6_enabled",         0},
	{"fifo_queue0_tti6_urange_a",        0},
	{"fifo_queue0_tti6_ufc_a",           0},
	{"fifo_queue0_tti6_urange_b",        0},
	{"fifo_queue0_tti6_ufc_b",           0},
	{"fifo_queue0_tti6_urange_c",        0},
	{"fifo_queue0_tti6_ufc_c",           0},
	{"fifo_queue0_tti6_ufc_d",           0},
	{"fifo_queue0_tti6_timer_val_us",    0},
	{"fifo_queue0_tti6_timer_ac_en",     0},
	{"fifo_queue0_tti6_timer_ci_en",     0},

	{"fifo_queue1_max",                  0},
	{"fifo_queue1_initial",              0},
	{"fifo_queue1_intr",                 0},
	{"fifo_queue1_intr_vector",          0},
	{"fifo_queue1_no_snoop_bits",        0},
	{"fifo_queue1_priority",             0},
	{"fifo_queue1_configured",           0},

	{"fifo_queue1_tti0_enabled",         0},
	{"fifo_queue1_tti0_urange_a",        0},
	{"fifo_queue1_tti0_ufc_a",           0},
	{"fifo_queue1_tti0_urange_b",        0},
	{"fifo_queue1_tti0_ufc_b",           0},
	{"fifo_queue1_tti0_urange_c",        0},
	{"fifo_queue1_tti0_ufc_c",           0},
	{"fifo_queue1_tti0_ufc_d",           0},
	{"fifo_queue1_tti0_timer_val_us",    0},
	{"fifo_queue1_tti0_timer_ac_en",     0},
	{"fifo_queue1_tti0_timer_ci_en",     0},

	{"fifo_queue1_tti1_enabled",         0},
	{"fifo_queue1_tti1_urange_a",        0},
	{"fifo_queue1_tti1_ufc_a",           0},
	{"fifo_queue1_tti1_urange_b",        0},
	{"fifo_queue1_tti1_ufc_b",           0},
	{"fifo_queue1_tti1_urange_c",        0},
	{"fifo_queue1_tti1_ufc_c",           0},
	{"fifo_queue1_tti1_ufc_d",           0},
	{"fifo_queue1_tti1_timer_val_us",    0},
	{"fifo_queue1_tti1_timer_ac_en",     0},
	{"fifo_queue1_tti1_timer_ci_en",     0},

	{"fifo_queue1_tti2_enabled",         0},
	{"fifo_queue1_tti2_urange_a",        0},
	{"fifo_queue1_tti2_ufc_a",           0},
	{"fifo_queue1_tti2_urange_b",        0},
	{"fifo_queue1_tti2_ufc_b",           0},
	{"fifo_queue1_tti2_urange_c",        0},
	{"fifo_queue1_tti2_ufc_c",           0},
	{"fifo_queue1_tti2_ufc_d",           0},
	{"fifo_queue1_tti2_timer_val_us",    0},
	{"fifo_queue1_tti2_timer_ac_en",     0},
	{"fifo_queue1_tti2_timer_ci_en",     0},

	{"fifo_queue1_tti3_enabled",         0},
	{"fifo_queue1_tti3_urange_a",        0},
	{"fifo_queue1_tti3_ufc_a",           0},
	{"fifo_queue1_tti3_urange_b",        0},
	{"fifo_queue1_tti3_ufc_b",           0},
	{"fifo_queue1_tti3_urange_c",        0},
	{"fifo_queue1_tti3_ufc_c",           0},
	{"fifo_queue1_tti3_ufc_d",           0},
	{"fifo_queue1_tti3_timer_val_us",    0},
	{"fifo_queue1_tti3_timer_ac_en",     0},
	{"fifo_queue1_tti3_timer_ci_en",     0},

	{"fifo_queue1_tti4_enabled",         0},
	{"fifo_queue1_tti4_urange_a",        0},
	{"fifo_queue1_tti4_ufc_a",           0},
	{"fifo_queue1_tti4_urange_b",        0},
	{"fifo_queue1_tti4_ufc_b",           0},
	{"fifo_queue1_tti4_urange_c",        0},
	{"fifo_queue1_tti4_ufc_c",           0},
	{"fifo_queue1_tti4_ufc_d",           0},
	{"fifo_queue1_tti4_timer_val_us",    0},
	{"fifo_queue1_tti4_timer_ac_en",     0},
	{"fifo_queue1_tti4_timer_ci_en",     0},

	{"fifo_queue1_tti5_enabled",         0},
	{"fifo_queue1_tti5_urange_a",        0},
	{"fifo_queue1_tti5_ufc_a",           0},
	{"fifo_queue1_tti5_urange_b",        0},
	{"fifo_queue1_tti5_ufc_b",           0},
	{"fifo_queue1_tti5_urange_c",        0},
	{"fifo_queue1_tti5_ufc_c",           0},
	{"fifo_queue1_tti5_ufc_d",           0},
	{"fifo_queue1_tti5_timer_val_us",    0},
	{"fifo_queue1_tti5_timer_ac_en",     0},
	{"fifo_queue1_tti5_timer_ci_en",     0},

	{"fifo_queue1_tti6_enabled",         0},
	{"fifo_queue1_tti6_urange_a",        0},
	{"fifo_queue1_tti6_ufc_a",           0},
	{"fifo_queue1_tti6_urange_b",        0},
	{"fifo_queue1_tti6_ufc_b",           0},
	{"fifo_queue1_tti6_urange_c",        0},
	{"fifo_queue1_tti6_ufc_c",           0},
	{"fifo_queue1_tti6_ufc_d",           0},
	{"fifo_queue1_tti6_timer_val_us",    0},
	{"fifo_queue1_tti6_timer_ac_en",     0},
	{"fifo_queue1_tti6_timer_ci_en",     0},

	{"fifo_queue2_max",                  0},
	{"fifo_queue2_initial",              0},
	{"fifo_queue2_intr",                 0},
	{"fifo_queue2_intr_vector",          0},
	{"fifo_queue2_no_snoop_bits",        0},
	{"fifo_queue2_priority",             0},
	{"fifo_queue2_configured",           0},

	{"fifo_queue2_tti0_enabled",         0},
	{"fifo_queue2_tti0_urange_a",        0},
	{"fifo_queue2_tti0_ufc_a",           0},
	{"fifo_queue2_tti0_urange_b",        0},
	{"fifo_queue2_tti0_ufc_b",           0},
	{"fifo_queue2_tti0_urange_c",        0},
	{"fifo_queue2_tti0_ufc_c",           0},
	{"fifo_queue2_tti0_ufc_d",           0},
	{"fifo_queue2_tti0_timer_val_us",    0},
	{"fifo_queue2_tti0_timer_ac_en",     0},
	{"fifo_queue2_tti0_timer_ci_en",     0},

	{"fifo_queue2_tti1_enabled",         0},
	{"fifo_queue2_tti1_urange_a",        0},
	{"fifo_queue2_tti1_ufc_a",           0},
	{"fifo_queue2_tti1_urange_b",        0},
	{"fifo_queue2_tti1_ufc_b",           0},
	{"fifo_queue2_tti1_urange_c",        0},
	{"fifo_queue2_tti1_ufc_c",           0},
	{"fifo_queue2_tti1_ufc_d",           0},
	{"fifo_queue2_tti1_timer_val_us",    0},
	{"fifo_queue2_tti1_timer_ac_en",     0},
	{"fifo_queue2_tti1_timer_ci_en",     0},

	{"fifo_queue2_tti2_enabled",         0},
	{"fifo_queue2_tti2_urange_a",        0},
	{"fifo_queue2_tti2_ufc_a",           0},
	{"fifo_queue2_tti2_urange_b",        0},
	{"fifo_queue2_tti2_ufc_b",           0},
	{"fifo_queue2_tti2_urange_c",        0},
	{"fifo_queue2_tti2_ufc_c",           0},
	{"fifo_queue2_tti2_ufc_d",           0},
	{"fifo_queue2_tti2_timer_val_us",    0},
	{"fifo_queue2_tti2_timer_ac_en",     0},
	{"fifo_queue2_tti2_timer_ci_en",     0},

	{"fifo_queue2_tti3_enabled",         0},
	{"fifo_queue2_tti3_urange_a",        0},
	{"fifo_queue2_tti3_ufc_a",           0},
	{"fifo_queue2_tti3_urange_b",        0},
	{"fifo_queue2_tti3_ufc_b",           0},
	{"fifo_queue2_tti3_urange_c",        0},
	{"fifo_queue2_tti3_ufc_c",           0},
	{"fifo_queue2_tti3_ufc_d",           0},
	{"fifo_queue2_tti3_timer_val_us",    0},
	{"fifo_queue2_tti3_timer_ac_en",     0},
	{"fifo_queue2_tti3_timer_ci_en",     0},

	{"fifo_queue2_tti4_enabled",         0},
	{"fifo_queue2_tti4_urange_a",        0},
	{"fifo_queue2_tti4_ufc_a",           0},
	{"fifo_queue2_tti4_urange_b",        0},
	{"fifo_queue2_tti4_ufc_b",           0},
	{"fifo_queue2_tti4_urange_c",        0},
	{"fifo_queue2_tti4_ufc_c",           0},
	{"fifo_queue2_tti4_ufc_d",           0},
	{"fifo_queue2_tti4_timer_val_us",    0},
	{"fifo_queue2_tti4_timer_ac_en",     0},
	{"fifo_queue2_tti4_timer_ci_en",     0},

	{"fifo_queue2_tti5_enabled",         0},
	{"fifo_queue2_tti5_urange_a",        0},
	{"fifo_queue2_tti5_ufc_a",           0},
	{"fifo_queue2_tti5_urange_b",        0},
	{"fifo_queue2_tti5_ufc_b",           0},
	{"fifo_queue2_tti5_urange_c",        0},
	{"fifo_queue2_tti5_ufc_c",           0},
	{"fifo_queue2_tti5_ufc_d",           0},
	{"fifo_queue2_tti5_timer_val_us",    0},
	{"fifo_queue2_tti5_timer_ac_en",     0},
	{"fifo_queue2_tti5_timer_ci_en",     0},

	{"fifo_queue2_tti6_enabled",         0},
	{"fifo_queue2_tti6_urange_a",        0},
	{"fifo_queue2_tti6_ufc_a",           0},
	{"fifo_queue2_tti6_urange_b",        0},
	{"fifo_queue2_tti6_ufc_b",           0},
	{"fifo_queue2_tti6_urange_c",        0},
	{"fifo_queue2_tti6_ufc_c",           0},
	{"fifo_queue2_tti6_ufc_d",           0},
	{"fifo_queue2_tti6_timer_val_us",    0},
	{"fifo_queue2_tti6_timer_ac_en",     0},
	{"fifo_queue2_tti6_timer_ci_en",     0},

	{"fifo_queue3_max",                  0},
	{"fifo_queue3_initial",              0},
	{"fifo_queue3_intr",                 0},
	{"fifo_queue3_intr_vector",          0},
	{"fifo_queue3_no_snoop_bits",        0},
	{"fifo_queue3_priority",             0},
	{"fifo_queue3_configured",           0},

	{"fifo_queue3_tti0_enabled",         0},
	{"fifo_queue3_tti0_urange_a",        0},
	{"fifo_queue3_tti0_ufc_a",           0},
	{"fifo_queue3_tti0_urange_b",        0},
	{"fifo_queue3_tti0_ufc_b",           0},
	{"fifo_queue3_tti0_urange_c",        0},
	{"fifo_queue3_tti0_ufc_c",           0},
	{"fifo_queue3_tti0_ufc_d",           0},
	{"fifo_queue3_tti0_timer_val_us",    0},
	{"fifo_queue3_tti0_timer_ac_en",     0},
	{"fifo_queue3_tti0_timer_ci_en",     0},

	{"fifo_queue3_tti1_enabled",         0},
	{"fifo_queue3_tti1_urange_a",        0},
	{"fifo_queue3_tti1_ufc_a",           0},
	{"fifo_queue3_tti1_urange_b",        0},
	{"fifo_queue3_tti1_ufc_b",           0},
	{"fifo_queue3_tti1_urange_c",        0},
	{"fifo_queue3_tti1_ufc_c",           0},
	{"fifo_queue3_tti1_ufc_d",           0},
	{"fifo_queue3_tti1_timer_val_us",    0},
	{"fifo_queue3_tti1_timer_ac_en",     0},
	{"fifo_queue3_tti1_timer_ci_en",     0},

	{"fifo_queue3_tti2_enabled",         0},
	{"fifo_queue3_tti2_urange_a",        0},
	{"fifo_queue3_tti2_ufc_a",           0},
	{"fifo_queue3_tti2_urange_b",        0},
	{"fifo_queue3_tti2_ufc_b",           0},
	{"fifo_queue3_tti2_urange_c",        0},
	{"fifo_queue3_tti2_ufc_c",           0},
	{"fifo_queue3_tti2_ufc_d",           0},
	{"fifo_queue3_tti2_timer_val_us",    0},
	{"fifo_queue3_tti2_timer_ac_en",     0},
	{"fifo_queue3_tti2_timer_ci_en",     0},

	{"fifo_queue3_tti3_enabled",         0},
	{"fifo_queue3_tti3_urange_a",        0},
	{"fifo_queue3_tti3_ufc_a",           0},
	{"fifo_queue3_tti3_urange_b",        0},
	{"fifo_queue3_tti3_ufc_b",           0},
	{"fifo_queue3_tti3_urange_c",        0},
	{"fifo_queue3_tti3_ufc_c",           0},
	{"fifo_queue3_tti3_ufc_d",           0},
	{"fifo_queue3_tti3_timer_val_us",    0},
	{"fifo_queue3_tti3_timer_ac_en",     0},
	{"fifo_queue3_tti3_timer_ci_en",     0},

	{"fifo_queue3_tti4_enabled",         0},
	{"fifo_queue3_tti4_urange_a",        0},
	{"fifo_queue3_tti4_ufc_a",           0},
	{"fifo_queue3_tti4_urange_b",        0},
	{"fifo_queue3_tti4_ufc_b",           0},
	{"fifo_queue3_tti4_urange_c",        0},
	{"fifo_queue3_tti4_ufc_c",           0},
	{"fifo_queue3_tti4_ufc_d",           0},
	{"fifo_queue3_tti4_timer_val_us",    0},
	{"fifo_queue3_tti4_timer_ac_en",     0},
	{"fifo_queue3_tti4_timer_ci_en",     0},

	{"fifo_queue3_tti5_enabled",         0},
	{"fifo_queue3_tti5_urange_a",        0},
	{"fifo_queue3_tti5_ufc_a",           0},
	{"fifo_queue3_tti5_urange_b",        0},
	{"fifo_queue3_tti5_ufc_b",           0},
	{"fifo_queue3_tti5_urange_c",        0},
	{"fifo_queue3_tti5_ufc_c",           0},
	{"fifo_queue3_tti5_ufc_d",           0},
	{"fifo_queue3_tti5_timer_val_us",    0},
	{"fifo_queue3_tti5_timer_ac_en",     0},
	{"fifo_queue3_tti5_timer_ci_en",     0},

	{"fifo_queue3_tti6_enabled",         0},
	{"fifo_queue3_tti6_urange_a",        0},
	{"fifo_queue3_tti6_ufc_a",           0},
	{"fifo_queue3_tti6_urange_b",        0},
	{"fifo_queue3_tti6_ufc_b",           0},
	{"fifo_queue3_tti6_urange_c",        0},
	{"fifo_queue3_tti6_ufc_c",           0},
	{"fifo_queue3_tti6_ufc_d",           0},
	{"fifo_queue3_tti6_timer_val_us",    0},
	{"fifo_queue3_tti6_timer_ac_en",     0},
	{"fifo_queue3_tti6_timer_ci_en",     0},

	{"fifo_queue4_max",                  0},
	{"fifo_queue4_initial",              0},
	{"fifo_queue4_intr",                 0},
	{"fifo_queue4_intr_vector",          0},
	{"fifo_queue4_no_snoop_bits",        0},
	{"fifo_queue4_priority",             0},
	{"fifo_queue4_configured",           0},

	{"fifo_queue4_tti0_enabled",         0},
	{"fifo_queue4_tti0_urange_a",        0},
	{"fifo_queue4_tti0_ufc_a",           0},
	{"fifo_queue4_tti0_urange_b",        0},
	{"fifo_queue4_tti0_ufc_b",           0},
	{"fifo_queue4_tti0_urange_c",        0},
	{"fifo_queue4_tti0_ufc_c",           0},
	{"fifo_queue4_tti0_ufc_d",           0},
	{"fifo_queue4_tti0_timer_val_us",    0},
	{"fifo_queue4_tti0_timer_ac_en",     0},
	{"fifo_queue4_tti0_timer_ci_en",     0},

	{"fifo_queue4_tti1_enabled",         0},
	{"fifo_queue4_tti1_urange_a",        0},
	{"fifo_queue4_tti1_ufc_a",           0},
	{"fifo_queue4_tti1_urange_b",        0},
	{"fifo_queue4_tti1_ufc_b",           0},
	{"fifo_queue4_tti1_urange_c",        0},
	{"fifo_queue4_tti1_ufc_c",           0},
	{"fifo_queue4_tti1_ufc_d",           0},
	{"fifo_queue4_tti1_timer_val_us",    0},
	{"fifo_queue4_tti1_timer_ac_en",     0},
	{"fifo_queue4_tti1_timer_ci_en",     0},

	{"fifo_queue4_tti2_enabled",         0},
	{"fifo_queue4_tti2_urange_a",        0},
	{"fifo_queue4_tti2_ufc_a",           0},
	{"fifo_queue4_tti2_urange_b",        0},
	{"fifo_queue4_tti2_ufc_b",           0},
	{"fifo_queue4_tti2_urange_c",        0},
	{"fifo_queue4_tti2_ufc_c",           0},
	{"fifo_queue4_tti2_ufc_d",           0},
	{"fifo_queue4_tti2_timer_val_us",    0},
	{"fifo_queue4_tti2_timer_ac_en",     0},
	{"fifo_queue4_tti2_timer_ci_en",     0},

	{"fifo_queue4_tti3_enabled",         0},
	{"fifo_queue4_tti3_urange_a",        0},
	{"fifo_queue4_tti3_ufc_a",           0},
	{"fifo_queue4_tti3_urange_b",        0},
	{"fifo_queue4_tti3_ufc_b",           0},
	{"fifo_queue4_tti3_urange_c",        0},
	{"fifo_queue4_tti3_ufc_c",           0},
	{"fifo_queue4_tti3_ufc_d",           0},
	{"fifo_queue4_tti3_timer_val_us",    0},
	{"fifo_queue4_tti3_timer_ac_en",     0},
	{"fifo_queue4_tti3_timer_ci_en",     0},

	{"fifo_queue4_tti4_enabled",         0},
	{"fifo_queue4_tti4_urange_a",        0},
	{"fifo_queue4_tti4_ufc_a",           0},
	{"fifo_queue4_tti4_urange_b",        0},
	{"fifo_queue4_tti4_ufc_b",           0},
	{"fifo_queue4_tti4_urange_c",        0},
	{"fifo_queue4_tti4_ufc_c",           0},
	{"fifo_queue4_tti4_ufc_d",           0},
	{"fifo_queue4_tti4_timer_val_us",    0},
	{"fifo_queue4_tti4_timer_ac_en",     0},
	{"fifo_queue4_tti4_timer_ci_en",     0},

	{"fifo_queue4_tti5_enabled",         0},
	{"fifo_queue4_tti5_urange_a",        0},
	{"fifo_queue4_tti5_ufc_a",           0},
	{"fifo_queue4_tti5_urange_b",        0},
	{"fifo_queue4_tti5_ufc_b",           0},
	{"fifo_queue4_tti5_urange_c",        0},
	{"fifo_queue4_tti5_ufc_c",           0},
	{"fifo_queue4_tti5_ufc_d",           0},
	{"fifo_queue4_tti5_timer_val_us",    0},
	{"fifo_queue4_tti5_timer_ac_en",     0},
	{"fifo_queue4_tti5_timer_ci_en",     0},

	{"fifo_queue4_tti6_enabled",         0},
	{"fifo_queue4_tti6_urange_a",        0},
	{"fifo_queue4_tti6_ufc_a",           0},
	{"fifo_queue4_tti6_urange_b",        0},
	{"fifo_queue4_tti6_ufc_b",           0},
	{"fifo_queue4_tti6_urange_c",        0},
	{"fifo_queue4_tti6_ufc_c",           0},
	{"fifo_queue4_tti6_ufc_d",           0},
	{"fifo_queue4_tti6_timer_val_us",    0},
	{"fifo_queue4_tti6_timer_ac_en",     0},
	{"fifo_queue4_tti6_timer_ci_en",     0},

	{"fifo_queue5_max",                  0},
	{"fifo_queue5_initial",              0},
	{"fifo_queue5_intr",                 0},
	{"fifo_queue5_intr_vector",          0},
	{"fifo_queue5_no_snoop_bits",        0},
	{"fifo_queue5_priority",             0},
	{"fifo_queue5_configured",           0},

	{"fifo_queue5_tti0_enabled",         0},
	{"fifo_queue5_tti0_urange_a",        0},
	{"fifo_queue5_tti0_ufc_a",           0},
	{"fifo_queue5_tti0_urange_b",        0},
	{"fifo_queue5_tti0_ufc_b",           0},
	{"fifo_queue5_tti0_urange_c",        0},
	{"fifo_queue5_tti0_ufc_c",           0},
	{"fifo_queue5_tti0_ufc_d",           0},
	{"fifo_queue5_tti0_timer_val_us",    0},
	{"fifo_queue5_tti0_timer_ac_en",     0},
	{"fifo_queue5_tti0_timer_ci_en",     0},

	{"fifo_queue5_tti1_enabled",         0},
	{"fifo_queue5_tti1_urange_a",        0},
	{"fifo_queue5_tti1_ufc_a",           0},
	{"fifo_queue5_tti1_urange_b",        0},
	{"fifo_queue5_tti1_ufc_b",           0},
	{"fifo_queue5_tti1_urange_c",        0},
	{"fifo_queue5_tti1_ufc_c",           0},
	{"fifo_queue5_tti1_ufc_d",           0},
	{"fifo_queue5_tti1_timer_val_us",    0},
	{"fifo_queue5_tti1_timer_ac_en",     0},
	{"fifo_queue5_tti1_timer_ci_en",     0},

	{"fifo_queue5_tti2_enabled",         0},
	{"fifo_queue5_tti2_urange_a",        0},
	{"fifo_queue5_tti2_ufc_a",           0},
	{"fifo_queue5_tti2_urange_b",        0},
	{"fifo_queue5_tti2_ufc_b",           0},
	{"fifo_queue5_tti2_urange_c",        0},
	{"fifo_queue5_tti2_ufc_c",           0},
	{"fifo_queue5_tti2_ufc_d",           0},
	{"fifo_queue5_tti2_timer_val_us",    0},
	{"fifo_queue5_tti2_timer_ac_en",     0},
	{"fifo_queue5_tti2_timer_ci_en",     0},

	{"fifo_queue5_tti3_enabled",         0},
	{"fifo_queue5_tti3_urange_a",        0},
	{"fifo_queue5_tti3_ufc_a",           0},
	{"fifo_queue5_tti3_urange_b",        0},
	{"fifo_queue5_tti3_ufc_b",           0},
	{"fifo_queue5_tti3_urange_c",        0},
	{"fifo_queue5_tti3_ufc_c",           0},
	{"fifo_queue5_tti3_ufc_d",           0},
	{"fifo_queue5_tti3_timer_val_us",    0},
	{"fifo_queue5_tti3_timer_ac_en",     0},
	{"fifo_queue5_tti3_timer_ci_en",     0},

	{"fifo_queue5_tti4_enabled",         0},
	{"fifo_queue5_tti4_urange_a",        0},
	{"fifo_queue5_tti4_ufc_a",           0},
	{"fifo_queue5_tti4_urange_b",        0},
	{"fifo_queue5_tti4_fc_b",            0},
	{"fifo_queue5_tti4_urange_c",        0},
	{"fifo_queue5_tti4_ufc_c",           0},
	{"fifo_queue5_tti4_ufc_d",           0},
	{"fifo_queue5_tti4_timer_val_us",    0},
	{"fifo_queue5_tti4_timer_ac_en",     0},
	{"fifo_queue5_tti4_timer_ci_en",     0},

	{"fifo_queue5_tti5_enabled",         0},
	{"fifo_queue5_tti5_urange_a",        0},
	{"fifo_queue5_tti5_ufc_a",           0},
	{"fifo_queue5_tti5_urange_b",        0},
	{"fifo_queue5_tti5_ufc_b",           0},
	{"fifo_queue5_tti5_urange_c",        0},
	{"fifo_queue5_tti5_ufc_c",           0},
	{"fifo_queue5_tti5_ufc_d",           0},
	{"fifo_queue5_tti5_timer_val_us",    0},
	{"fifo_queue5_tti5_timer_ac_en",     0},
	{"fifo_queue5_tti5_timer_ci_en",     0},

	{"fifo_queue5_tti6_enabled",         0},
	{"fifo_queue5_tti6_urange_a",        0},
	{"fifo_queue5_tti6_ufc_a",           0},
	{"fifo_queue5_tti6_urange_b",        0},
	{"fifo_queue5_tti6_ufc_b",           0},
	{"fifo_queue5_tti6_urange_c",        0},
	{"fifo_queue5_tti6_ufc_c",           0},
	{"fifo_queue5_tti6_ufc_d",           0},
	{"fifo_queue5_tti6_timer_val_us",    0},
	{"fifo_queue5_tti6_timer_ac_en",     0},
	{"fifo_queue5_tti6_timer_ci_en",     0},

	{"fifo_queue6_max",                  0},
	{"fifo_queue6_initial",              0},
	{"fifo_queue6_intr",                 0},
	{"fifo_queue6_intr_vector",          0},
	{"fifo_queue6_no_snoop_bits",        0},
	{"fifo_queue6_priority",             0},
	{"fifo_queue6_configured",           0},

	{"fifo_queue6_tti0_enabled",         0},
	{"fifo_queue6_tti0_urange_a",        0},
	{"fifo_queue6_tti0_ufc_a",           0},
	{"fifo_queue6_tti0_urange_b",        0},
	{"fifo_queue6_tti0_ufc_b",           0},
	{"fifo_queue6_tti0_urange_c",        0},
	{"fifo_queue6_tti0_ufc_c",           0},
	{"fifo_queue6_tti0_ufc_d",           0},
	{"fifo_queue6_tti0_timer_val_us",    0},
	{"fifo_queue6_tti0_timer_ac_en",     0},
	{"fifo_queue6_tti0_timer_ci_en",     0},

	{"fifo_queue6_tti1_enabled",         0},
	{"fifo_queue6_tti1_urange_a",        0},
	{"fifo_queue6_tti1_ufc_a",           0},
	{"fifo_queue6_tti1_urange_b",        0},
	{"fifo_queue6_tti1_ufc_b",           0},
	{"fifo_queue6_tti1_urange_c",        0},
	{"fifo_queue6_tti1_ufc_c",           0},
	{"fifo_queue6_tti1_ufc_d",           0},
	{"fifo_queue6_tti1_timer_val_us",    0},
	{"fifo_queue6_tti1_timer_ac_en",     0},
	{"fifo_queue6_tti1_timer_ci_en",     0},

	{"fifo_queue6_tti2_enabled",         0},
	{"fifo_queue6_tti2_urange_a",        0},
	{"fifo_queue6_tti2_ufc_a",           0},
	{"fifo_queue6_tti2_urange_b",        0},
	{"fifo_queue6_tti2_ufc_b",           0},
	{"fifo_queue6_tti2_urange_c",        0},
	{"fifo_queue6_tti2_ufc_c",           0},
	{"fifo_queue6_tti2_ufc_d",           0},
	{"fifo_queue6_tti2_timer_val_us",    0},
	{"fifo_queue6_tti2_timer_ac_en",     0},
	{"fifo_queue6_tti2_timer_ci_en",     0},

	{"fifo_queue6_tti3_enabled",         0},
	{"fifo_queue6_tti3_urange_a",        0},
	{"fifo_queue6_tti3_ufc_a",           0},
	{"fifo_queue6_tti3_urange_b",        0},
	{"fifo_queue6_tti3_ufc_b",           0},
	{"fifo_queue6_tti3_urange_c",        0},
	{"fifo_queue6_tti3_ufc_c",           0},
	{"fifo_queue6_tti3_ufc_d",           0},
	{"fifo_queue6_tti3_timer_val_us",    0},
	{"fifo_queue6_tti3_timer_ac_en",     0},
	{"fifo_queue6_tti3_timer_ci_en",     0},

	{"fifo_queue6_tti4_enabled",         0},
	{"fifo_queue6_tti4_urange_a",        0},
	{"fifo_queue6_tti4_ufc_a",           0},
	{"fifo_queue6_tti4_urange_b",        0},
	{"fifo_queue6_tti4_ufc_b",           0},
	{"fifo_queue6_tti4_urange_c",        0},
	{"fifo_queue6_tti4_ufc_c",           0},
	{"fifo_queue6_tti4_ufc_d",           0},
	{"fifo_queue6_tti4_timer_val_us",    0},
	{"fifo_queue6_tti4_timer_ac_en",     0},
	{"fifo_queue6_tti4_timer_ci_en",     0},

	{"fifo_queue6_tti5_enabled",         0},
	{"fifo_queue6_tti5_urange_a",        0},
	{"fifo_queue6_tti5_ufc_a",           0},
	{"fifo_queue6_tti5_urange_b",        0},
	{"fifo_queue6_tti5_ufc_b",           0},
	{"fifo_queue6_tti5_urange_c",        0},
	{"fifo_queue6_tti5_ufc_c",           0},
	{"fifo_queue6_tti5_ufc_d",           0},
	{"fifo_queue6_tti5_timer_val_us",    0},
	{"fifo_queue6_tti5_timer_ac_en",     0},
	{"fifo_queue6_tti5_timer_ci_en",     0},

	{"fifo_queue6_tti6_enabled",         0},
	{"fifo_queue6_tti6_urange_a",        0},
	{"fifo_queue6_tti6_ufc_a",           0},
	{"fifo_queue6_tti6_urange_b",        0},
	{"fifo_queue6_tti6_ufc_b",           0},
	{"fifo_queue6_tti6_urange_c",        0},
	{"fifo_queue6_tti6_ufc_c",           0},
	{"fifo_queue6_tti6_ufc_d",           0},
	{"fifo_queue6_tti6_timer_val_us",    0},
	{"fifo_queue6_tti6_timer_ac_en",     0},
	{"fifo_queue6_tti6_timer_ci_en",     0},

	{"fifo_queue7_max",                  0},
	{"fifo_queue7_initial",              0},
	{"fifo_queue7_intr",                 0},
	{"fifo_queue7_intr_vector",          0},
	{"fifo_queue7_no_snoop_bits",        0},
	{"fifo_queue7_priority",             0},
	{"fifo_queue7_configured",           0},

	{"fifo_queue7_tti0_enabled",         0},
	{"fifo_queue7_tti0_urange_a",        0},
	{"fifo_queue7_tti0_ufc_a",           0},
	{"fifo_queue7_tti0_urange_b",        0},
	{"fifo_queue7_tti0_ufc_b",           0},
	{"fifo_queue7_tti0_urange_c",        0},
	{"fifo_queue7_tti0_ufc_c",           0},
	{"fifo_queue7_tti0_ufc_d",           0},
	{"fifo_queue7_tti0_timer_val_us",    0},
	{"fifo_queue7_tti0_timer_ac_en",     0},
	{"fifo_queue7_tti0_timer_ci_en",     0},

	{"fifo_queue7_tti1_enabled",         0},
	{"fifo_queue7_tti1_urange_a",        0},
	{"fifo_queue7_tti1_ufc_a",           0},
	{"fifo_queue7_tti1_urange_b",        0},
	{"fifo_queue7_tti1_ufc_b",           0},
	{"fifo_queue7_tti1_urange_c",        0},
	{"fifo_queue7_tti1_ufc_c",           0},
	{"fifo_queue7_tti1_ufc_d",           0},
	{"fifo_queue7_tti1_timer_val_us",    0},
	{"fifo_queue7_tti1_timer_ac_en",     0},
	{"fifo_queue7_tti1_timer_ci_en",     0},

	{"fifo_queue7_tti2_enabled",         0},
	{"fifo_queue7_tti2_urange_a",        0},
	{"fifo_queue7_tti2_ufc_a",           0},
	{"fifo_queue7_tti2_urange_b",        0},
	{"fifo_queue7_tti2_ufc_b",           0},
	{"fifo_queue7_tti2_urange_c",        0},
	{"fifo_queue7_tti2_ufc_c",           0},
	{"fifo_queue7_tti2_ufc_d",           0},
	{"fifo_queue7_tti2_timer_val_us",    0},
	{"fifo_queue7_tti2_timer_ac_en",     0},
	{"fifo_queue7_tti2_timer_ci_en",     0},

	{"fifo_queue7_tti3_enabled",         0},
	{"fifo_queue7_tti3_urange_a",        0},
	{"fifo_queue7_tti3_ufc_a",           0},
	{"fifo_queue7_tti3_urange_b",        0},
	{"fifo_queue7_tti3_ufc_b",           0},
	{"fifo_queue7_tti3_urange_c",        0},
	{"fifo_queue7_tti3_ufc_c",           0},
	{"fifo_queue7_tti3_ufc_d",           0},
	{"fifo_queue7_tti3_timer_val_us",    0},
	{"fifo_queue7_tti3_timer_ac_en",     0},
	{"fifo_queue7_tti3_timer_ci_en",     0},

	{"fifo_queue7_tti4_enabled",         0},
	{"fifo_queue7_tti4_urange_a",        0},
	{"fifo_queue7_tti4_ufc_a",           0},
	{"fifo_queue7_tti4_urange_b",        0},
	{"fifo_queue7_tti4_ufc_b",           0},
	{"fifo_queue7_tti4_urange_c",        0},
	{"fifo_queue7_tti4_ufc_c",           0},
	{"fifo_queue7_tti4_ufc_d",           0},
	{"fifo_queue7_tti4_timer_val_us",    0},
	{"fifo_queue7_tti4_timer_ac_en",     0},
	{"fifo_queue7_tti4_timer_ci_en",     0},

	{"fifo_queue7_tti5_enabled",         0},
	{"fifo_queue7_tti5_urange_a",        0},
	{"fifo_queue7_tti5_ufc_a",           0},
	{"fifo_queue7_tti5_urange_b",        0},
	{"fifo_queue7_tti5_ufc_b",           0},
	{"fifo_queue7_tti5_urange_c",        0},
	{"fifo_queue7_tti5_ufc_c",           0},
	{"fifo_queue7_tti5_ufc_d",           0},
	{"fifo_queue7_tti5_timer_val_us",    0},
	{"fifo_queue7_tti5_timer_ac_en",     0},
	{"fifo_queue7_tti5_timer_ci_en",     0},

	{"fifo_queue7_tti6_enabled",         0},
	{"fifo_queue7_tti6_urange_a",        0},
	{"fifo_queue7_tti6_ufc_a",           0},
	{"fifo_queue7_tti6_urange_b",        0},
	{"fifo_queue7_tti6_ufc_b",           0},
	{"fifo_queue7_tti6_urange_c",        0},
	{"fifo_queue7_tti6_ufc_c",           0},
	{"fifo_queue7_tti6_ufc_d",           0},
	{"fifo_queue7_tti6_timer_val_us",    0},
	{"fifo_queue7_tti6_timer_ac_en",     0},
	{"fifo_queue7_tti6_timer_ci_en",     0},

	{"dump_on_serr",                     0},
	{"dump_on_eccerr",                   0},
	{"dump_on_parityerr",                0},
	{"rth_en",                           0},
	{"rth_bucket_size",                  0},
	{"rth_spdm_en",                      0},
	{"rth_spdm_use_l4",                  0},
	{"rxufca_intr_thres",                0},
	{"rxufca_lo_lim",                    0},
	{"rxufca_hi_lim",                    0},
	{"rxufca_lbolt_period",              0},
	{"link_valid_cnt",                   0},
	{"link_retry_cnt",                   0},
	{"link_stability_period",            0},
	{"device_poll_millis",               0},
	{"no_isr_events",                    0},
	{"lro_sg_size",                      0},
	{"lro_frm_len",                      0},
	{"bimodal_interrupts",               0},
	{"bimodal_timer_lo_us",              0},
	{"bimodal_timer_hi_us",              0},
	{"rts_mac_en",                       0},
	{"rts_qos_en",                       0},
	{"rts_port_en",                      0},
};

xge_stats_intr_info_t intrInfo[] = {
	{"rx_traffic_intr_cnt",              0},
	{"tx_traffic_intr_cnt",              0},
	{"txpic_intr_cnt",                   0},
	{"txdma_intr_cnt",                   0},
	{"txmac_intr_cnt",                   0},
	{"txxgxs_intr_cnt",                  0},
	{"rxpic_intr_cnt",                   0},
	{"rxdma_intr_cnt",                   0},
	{"rxmac_intr_cnt",                   0},
	{"rxxgxs_intr_cnt",                  0},
	{"mc_intr_cnt",                      0},
	{"not_traffic_intr_cnt",             0},
	{"not_xge_intr_cnt",                 0},
	{"traffic_intr_cnt",                 0},
	{"total_intr_cnt",                   0},
	{"soft_reset_cnt",                   0},
	{"rxufca_hi_adjust_cnt",             0},
	{"rxufca_lo_adjust_cnt",             0},
	{"bimodal_hi_adjust_cnt",            0},
	{"bimodal_lo_adjust_cnt",            0},
#ifdef CONFIG_LRO
	{"tot_frms_lroised",                 0},
	{"tot_lro_sessions",                 0},
	{"lro_frm_len_exceed_cnt",           0},
	{"lro_sg_exceed_cnt",                0},
	{"lro_out_of_seq_pkt_cnt",           0},
	{"lro_dup_pkt_cnt",                  0}
#endif
};

xge_stats_tcode_info_t tcodeInfo[] = {
	{"sm_err_cnt",                     0, 4, 0},
	{"single_ecc_err_cnt",             0, 4, 0},
	{"double_ecc_err_cnt",             0, 4, 0},
	{"ecc_err_cnt",                    0, 4, 0},
	{"parity_err_cnt",                 0, 4, 0},
	{"serr_cnt",                       0, 4, 0},
	{"rxd_t_code_transfer_ok",         0, 4, 1},
	{"rxd_t_code_parity",              0, 4, 0},
	{"rxd_t_code_abort",               0, 4, 0},
	{"rxd_t_code_parity_abort",        0, 4, 0},
	{"rxd_t_code_rda_failure",         0, 4, 0},
	{"rxd_t_code_unknown_proto",       0, 4, 0},
	{"rxd_t_code_bad_fcs",             0, 4, 0},
	{"rxd_t_code_buff_size",           0, 4, 0},
	{"rxd_t_code_bad_ecc",             0, 4, 0},
	{"rxd_t_code_unused_9",            0, 4, 1},
	{"rxd_t_code_unused_a",            0, 4, 1},
	{"rxd_t_code_unused_b",            0, 4, 1},
	{"rxd_t_code_unused_c",            0, 4, 1},
	{"rxd_t_code_unused_d",            0, 4, 1},
	{"rxd_t_code_unused_e",            0, 4, 1},
	{"rxd_t_code_unknown",             0, 4, 0},
	{"txd_t_code_transfer_ok",         0, 4, 1},
	{"txd_t_code_unused_1",            0, 4, 1},
	{"txd_t_code_abort_buffer",        0, 4, 0},
	{"txd_t_code_abort_dtor",          0, 4, 0},
	{"txd_t_code_unused_4",            0, 4, 1},
	{"txd_t_code_unused_5",            0, 4, 1},
	{"txd_t_code_unused_6",            0, 4, 1},
	{"txd_t_code_parity",              0, 4, 0},
	{"txd_t_code_unused_8",            0, 4, 1},
	{"txd_t_code_unused_9",            0, 4, 1},
	{"txd_t_code_loss_of_link",        0, 4, 0},
	{"txd_t_code_unused_a",            0, 4, 1},
	{"txd_t_code_unused_b",            0, 4, 1},
	{"txd_t_code_unused_c",            0, 4, 1},
	{"txd_t_code_unused_d",            0, 4, 1},
	{"txd_t_code_general_err",         0, 4, 0},
	{"alarm_transceiver_temp_high",    0, 4, 0},
	{"alarm_transceiver_temp_low",     0, 4, 0},
	{"alarm_laser_bias_current_high",  0, 4, 0},
	{"alarm_laser_bias_current_low",   0, 4, 0},
	{"alarm_laser_output_power_high",  0, 4, 0},
	{"alarm_laser_output_power_low",   0, 4, 0},
	{"warn_transceiver_temp_high",     0, 4, 0},
	{"warn_transceiver_temp_low",      0, 4, 0},
	{"warn_laser_bias_current_high",   0, 4, 0},
	{"warn_laser_bias_current_low",    0, 4, 0},
	{"warn_laser_output_power_high",   0, 4, 0},
	{"warn_laser_output_power_low",    0, 4, 0},
	{"excess_temp",                    0, 2, 0},
	{"excess_bias_current",            0, 2, 0},
	{"excess_laser_output",            0, 2, 0},
	{"tick_period",                    0, 2, 0}
};

xge_stats_driver_info_t driverInfo[] = {
	{"isr_filter",           0},
	{"isr_line",             0},
	{"isr_msi",              0},
	{"tx_calls",             0},
	{"tx_completions",       0},
	{"tx_desc_compl",        0},
	{"tx_tcode",             0},
	{"tx_defrag",            0},
	{"tx_no_txd",            0},
	{"tx_map_fail",          0},
	{"tx_max_frags",         0},
	{"tx_tso",               0},
	{"tx_posted",            0},
	{"tx_again",             0},
	{"rx_completions",       0},
	{"rx_desc_compl",        0},
	{"rx_tcode",             0},
	{"rx_no_buf",            0},
	{"rx_map_fail",          0},
	{"lro_uncapable",        0},
	{"lro_begin",            0},
	{"lro_end1",             0},
	{"lro_end2",             0},
	{"lro_end3",             0},
	{"lro_append",           0},
	{"lro_session_exceeded", 0},
	{"lro_close",            0}
};
