
/*
 * Ekiga -- A VoIP and Video-Conferencing application
 * Copyright (C) 2000-2008 Damien Sandras

 * This program is free software; you can  redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version. This program is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Ekiga is licensed under the GPL license and as a special exception, you
 * have permission to link or otherwise combine this program with the
 * programs OPAL, OpenH323 and PWLIB, and distribute the combination, without
 * applying the requirements of the GNU GPL to the OPAL, OpenH323 and PWLIB
 * programs, as long as you do follow the requirements of the GNU GPL for all
 * the rest of the software thus combined.
 */


/*
 *                         loudmouth-dialect.h  -  description
 *                         ------------------------------------------
 *   begin                : written in 2008 by Julien Puydt
 *   copyright            : (c) 2008 by Julien Puydt
 *   description          : declaration of the loudmouth dialect
 *
 */

#ifndef __LOUDMOUTH_DIALECT_H__
#define __LOUDMOUTH_DIALECT_H__

#include "dialect-impl.h"
#include "loudmouth-chat-simple.h"

namespace LM
{
  class Dialect:
    public Ekiga::DialectImpl<SimpleChat>
  {
  public:

    Dialect (Ekiga::ServiceCore& core_);

    ~Dialect ();

    bool populate_menu (Ekiga::MenuBuilder& builder);

    /* specific */

    void push_message (PresentityPtr,
		       const std::string msg);

    void open_chat (PresentityPtr presentity);

  private:

    Ekiga::ServiceCore& core;
  };

  typedef boost::shared_ptr<Dialect> DialectPtr;
};

#endif
