/* ai-profile.c generated by valac 0.11.7, the Vala compiler
 * generated from ai-profile.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_AI_PROFILE (ai_profile_get_type ())
#define AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AI_PROFILE, AIProfile))
#define AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AI_PROFILE, AIProfileClass))
#define IS_AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AI_PROFILE))
#define IS_AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AI_PROFILE))
#define AI_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AI_PROFILE, AIProfileClass))

typedef struct _AIProfile AIProfile;
typedef struct _AIProfileClass AIProfileClass;
typedef struct _AIProfilePrivate AIProfilePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecAIProfile ParamSpecAIProfile;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define __g_list_free__ai_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__ai_profile_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _ai_profile_unref0(var) ((var == NULL) ? NULL : (var = (ai_profile_unref (var), NULL)))

struct _AIProfile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AIProfilePrivate * priv;
	gchar* name;
	gchar* protocol;
	gchar* binary;
	gchar* path;
	gchar* args;
	gchar** easy_options;
	gint easy_options_length1;
	gchar** normal_options;
	gint normal_options_length1;
	gchar** hard_options;
	gint hard_options_length1;
};

struct _AIProfileClass {
	GTypeClass parent_class;
	void (*finalize) (AIProfile *self);
};

struct _ParamSpecAIProfile {
	GParamSpec parent_instance;
};


static gpointer ai_profile_parent_class = NULL;

gpointer ai_profile_ref (gpointer instance);
void ai_profile_unref (gpointer instance);
GParamSpec* param_spec_ai_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ai_profile (GValue* value, gpointer v_object);
void value_take_ai_profile (GValue* value, gpointer v_object);
gpointer value_get_ai_profile (const GValue* value);
GType ai_profile_get_type (void) G_GNUC_CONST;
enum  {
	AI_PROFILE_DUMMY_PROPERTY
};
AIProfile* ai_profile_new (void);
AIProfile* ai_profile_construct (GType object_type);
static void ai_profile_finalize (AIProfile* obj);
GList* load_ai_profiles (const gchar* filename);
static void _ai_profile_unref0_ (gpointer var);
static void _g_list_free__ai_profile_unref0_ (GList* self);
gchar** load_options (GKeyFile* file, const gchar* name, const gchar* difficulty, int* result_length1, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


AIProfile* ai_profile_construct (GType object_type) {
	AIProfile* self = NULL;
	self = (AIProfile*) g_type_create_instance (object_type);
	return self;
}


AIProfile* ai_profile_new (void) {
	return ai_profile_construct (TYPE_AI_PROFILE);
}


static void value_ai_profile_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_ai_profile_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		ai_profile_unref (value->data[0].v_pointer);
	}
}


static void value_ai_profile_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ai_profile_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_ai_profile_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_ai_profile_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AIProfile* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ai_profile_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_ai_profile_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AIProfile** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ai_profile_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_ai_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAIProfile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AI_PROFILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_ai_profile (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AI_PROFILE), NULL);
	return value->data[0].v_pointer;
}


void value_set_ai_profile (GValue* value, gpointer v_object) {
	AIProfile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AI_PROFILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AI_PROFILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ai_profile_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ai_profile_unref (old);
	}
}


void value_take_ai_profile (GValue* value, gpointer v_object) {
	AIProfile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AI_PROFILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AI_PROFILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ai_profile_unref (old);
	}
}


static void ai_profile_class_init (AIProfileClass * klass) {
	ai_profile_parent_class = g_type_class_peek_parent (klass);
	AI_PROFILE_CLASS (klass)->finalize = ai_profile_finalize;
}


static void ai_profile_instance_init (AIProfile * self) {
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	self->args = _tmp0_;
	self->ref_count = 1;
}


static void ai_profile_finalize (AIProfile* obj) {
	AIProfile * self;
	self = AI_PROFILE (obj);
	_g_free0 (self->name);
	_g_free0 (self->protocol);
	_g_free0 (self->binary);
	_g_free0 (self->path);
	_g_free0 (self->args);
	self->easy_options = (_vala_array_free (self->easy_options, self->easy_options_length1, (GDestroyNotify) g_free), NULL);
	self->normal_options = (_vala_array_free (self->normal_options, self->normal_options_length1, (GDestroyNotify) g_free), NULL);
	self->hard_options = (_vala_array_free (self->hard_options, self->hard_options_length1, (GDestroyNotify) g_free), NULL);
}


GType ai_profile_get_type (void) {
	static volatile gsize ai_profile_type_id__volatile = 0;
	if (g_once_init_enter (&ai_profile_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ai_profile_init, value_ai_profile_free_value, value_ai_profile_copy_value, value_ai_profile_peek_pointer, "p", value_ai_profile_collect_value, "p", value_ai_profile_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AIProfileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ai_profile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AIProfile), 0, (GInstanceInitFunc) ai_profile_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ai_profile_type_id;
		ai_profile_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AIProfile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ai_profile_type_id__volatile, ai_profile_type_id);
	}
	return ai_profile_type_id__volatile;
}


gpointer ai_profile_ref (gpointer instance) {
	AIProfile* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void ai_profile_unref (gpointer instance) {
	AIProfile* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AI_PROFILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _ai_profile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (ai_profile_unref (var), NULL));
}


static void _g_list_free__ai_profile_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _ai_profile_unref0_, NULL);
	g_list_free (self);
}


static gpointer _ai_profile_ref0 (gpointer self) {
	return self ? ai_profile_ref (self) : NULL;
}


GList* load_ai_profiles (const gchar* filename) {
	GList* result = NULL;
	GList* profiles;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* file;
	gsize _tmp1_;
	gchar** _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	profiles = NULL;
	_tmp0_ = g_key_file_new ();
	file = _tmp0_;
	g_key_file_load_from_file (file, filename, G_KEY_FILE_NONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch7_g_key_file_error;
		}
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch7_g_file_error;
		}
		_g_key_file_free0 (file);
		__g_list_free__ai_profile_unref0_0 (profiles);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	goto __finally7;
	__catch7_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("ai-profile.vala:24: Failed to load AI profiles: %s", e->message);
		result = profiles;
		_g_error_free0 (e);
		_g_key_file_free0 (file);
		return result;
	}
	goto __finally7;
	__catch7_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("ai-profile.vala:29: Failed to load AI profiles: %s", e->message);
		result = profiles;
		_g_error_free0 (e);
		_g_key_file_free0 (file);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (file);
		__g_list_free__ai_profile_unref0_0 (profiles);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = g_key_file_get_groups (file, &_tmp1_);
	{
		gchar** name_collection;
		int name_collection_length1;
		int name_it;
		name_collection = _tmp2_;
		name_collection_length1 = _tmp1_;
		for (name_it = 0; name_it < _tmp1_; name_it = name_it + 1) {
			gchar* _tmp3_;
			gchar* name;
			_tmp3_ = g_strdup (name_collection[name_it]);
			name = _tmp3_;
			{
				AIProfile* _tmp4_ = NULL;
				AIProfile* profile;
				gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				gint _tmp14_;
				gchar** _tmp15_ = NULL;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gint __tmp16__size_;
				gint _tmp17_;
				gchar** _tmp18_ = NULL;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gint __tmp19__size_;
				gint _tmp20_;
				gchar** _tmp21_ = NULL;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint __tmp22__size_;
				gchar* _tmp23_ = NULL;
				gchar* path;
				g_debug ("ai-profile.vala:35: Loading AI profile %s", name);
				_tmp4_ = ai_profile_new ();
				profile = _tmp4_;
				_tmp5_ = g_strdup (name);
				_g_free0 (profile->name);
				profile->name = _tmp5_;
				_tmp6_ = g_key_file_get_value (file, name, "protocol", &_inner_error_);
				_tmp7_ = _tmp6_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_KEY_FILE_ERROR) {
						goto __catch8_g_key_file_error;
					}
					_ai_profile_unref0 (profile);
					_g_free0 (name);
					name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_key_file_free0 (file);
					__g_list_free__ai_profile_unref0_0 (profiles);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (profile->protocol);
				profile->protocol = _tmp7_;
				_tmp8_ = g_key_file_get_value (file, name, "binary", &_inner_error_);
				_tmp9_ = _tmp8_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_KEY_FILE_ERROR) {
						goto __catch8_g_key_file_error;
					}
					_ai_profile_unref0 (profile);
					_g_free0 (name);
					name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_key_file_free0 (file);
					__g_list_free__ai_profile_unref0_0 (profiles);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (profile->binary);
				profile->binary = _tmp9_;
				_tmp10_ = g_key_file_has_key (file, name, "args", &_inner_error_);
				_tmp11_ = _tmp10_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_KEY_FILE_ERROR) {
						goto __catch8_g_key_file_error;
					}
					_ai_profile_unref0 (profile);
					_g_free0 (name);
					name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_key_file_free0 (file);
					__g_list_free__ai_profile_unref0_0 (profiles);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				if (_tmp11_) {
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp12_ = g_key_file_get_value (file, name, "args", &_inner_error_);
					_tmp13_ = _tmp12_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch8_g_key_file_error;
						}
						_ai_profile_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_free0 (file);
						__g_list_free__ai_profile_unref0_0 (profiles);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_free0 (profile->args);
					profile->args = _tmp13_;
				}
				_tmp15_ = load_options (file, name, "easy", &_tmp14_, &_inner_error_);
				_tmp16_ = _tmp15_;
				_tmp16__length1 = _tmp14_;
				__tmp16__size_ = _tmp14_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_KEY_FILE_ERROR) {
						goto __catch8_g_key_file_error;
					}
					_ai_profile_unref0 (profile);
					_g_free0 (name);
					name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_key_file_free0 (file);
					__g_list_free__ai_profile_unref0_0 (profiles);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				profile->easy_options = (_vala_array_free (profile->easy_options, profile->easy_options_length1, (GDestroyNotify) g_free), NULL);
				profile->easy_options = _tmp16_;
				profile->easy_options_length1 = _tmp16__length1;
				_tmp18_ = load_options (file, name, "normal", &_tmp17_, &_inner_error_);
				_tmp19_ = _tmp18_;
				_tmp19__length1 = _tmp17_;
				__tmp19__size_ = _tmp17_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_KEY_FILE_ERROR) {
						goto __catch8_g_key_file_error;
					}
					_ai_profile_unref0 (profile);
					_g_free0 (name);
					name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_key_file_free0 (file);
					__g_list_free__ai_profile_unref0_0 (profiles);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				profile->normal_options = (_vala_array_free (profile->normal_options, profile->normal_options_length1, (GDestroyNotify) g_free), NULL);
				profile->normal_options = _tmp19_;
				profile->normal_options_length1 = _tmp19__length1;
				_tmp21_ = load_options (file, name, "hard", &_tmp20_, &_inner_error_);
				_tmp22_ = _tmp21_;
				_tmp22__length1 = _tmp20_;
				__tmp22__size_ = _tmp20_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_KEY_FILE_ERROR) {
						goto __catch8_g_key_file_error;
					}
					_ai_profile_unref0 (profile);
					_g_free0 (name);
					name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_key_file_free0 (file);
					__g_list_free__ai_profile_unref0_0 (profiles);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				profile->hard_options = (_vala_array_free (profile->hard_options, profile->hard_options_length1, (GDestroyNotify) g_free), NULL);
				profile->hard_options = _tmp22_;
				profile->hard_options_length1 = _tmp22__length1;
				goto __finally8;
				__catch8_g_key_file_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
					_ai_profile_unref0 (profile);
					_g_free0 (name);
					continue;
				}
				__finally8:
				if (_inner_error_ != NULL) {
					_ai_profile_unref0 (profile);
					_g_free0 (name);
					name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_key_file_free0 (file);
					__g_list_free__ai_profile_unref0_0 (profiles);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp23_ = g_find_program_in_path (profile->binary);
				path = _tmp23_;
				if (path != NULL) {
					gchar* _tmp24_;
					AIProfile* _tmp25_;
					_tmp24_ = g_strdup (path);
					_g_free0 (profile->path);
					profile->path = _tmp24_;
					_tmp25_ = _ai_profile_ref0 (profile);
					profiles = g_list_append (profiles, _tmp25_);
				}
				_g_free0 (path);
				_ai_profile_unref0 (profile);
				_g_free0 (name);
			}
		}
		name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = profiles;
	_g_key_file_free0 (file);
	return result;
}


gchar** load_options (GKeyFile* file, const gchar* name, const gchar* difficulty, int* result_length1, GError** error) {
	gchar** result = NULL;
	gint count;
	gchar** _tmp5_ = NULL;
	gchar** options;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (difficulty != NULL, NULL);
	count = 0;
	while (TRUE) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp0_ = g_strdup_printf ("option-%s-%d", difficulty, count);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_key_file_has_key (file, name, _tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (!_tmp4_) {
			break;
		}
		count++;
	}
	_tmp5_ = g_new0 (gchar*, count + 1);
	options = _tmp5_;
	options_length1 = count;
	_options_size_ = count;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				if (!_tmp6_) {
					i++;
				}
				_tmp6_ = FALSE;
				if (!(i < count)) {
					break;
				}
				_tmp7_ = g_strdup_printf ("option-%s-%d", difficulty, i);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_key_file_get_value (file, name, _tmp8_, &_inner_error_);
				_tmp10_ = _tmp9_;
				_g_free0 (_tmp8_);
				_tmp11_ = _tmp10_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_KEY_FILE_ERROR) {
						g_propagate_error (error, _inner_error_);
						options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp12_ = _tmp11_;
				_g_free0 (options[i]);
				options[i] = _tmp12_;
			}
		}
	}
	_tmp13_ = options;
	*result_length1 = options_length1;
	result = _tmp13_;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



