/* contacts-list-pane.c generated by valac 0.13.0.32-acab5, the Vala compiler
 * generated from contacts-list-pane.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <pango/pangocairo.h>


#define CONTACTS_TYPE_CELL_RENDERER_SHAPE (contacts_cell_renderer_shape_get_type ())
#define CONTACTS_CELL_RENDERER_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CELL_RENDERER_SHAPE, ContactsCellRendererShape))
#define CONTACTS_CELL_RENDERER_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CELL_RENDERER_SHAPE, ContactsCellRendererShapeClass))
#define CONTACTS_IS_CELL_RENDERER_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CELL_RENDERER_SHAPE))
#define CONTACTS_IS_CELL_RENDERER_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CELL_RENDERER_SHAPE))
#define CONTACTS_CELL_RENDERER_SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CELL_RENDERER_SHAPE, ContactsCellRendererShapeClass))

typedef struct _ContactsCellRendererShape ContactsCellRendererShape;
typedef struct _ContactsCellRendererShapeClass ContactsCellRendererShapeClass;
typedef struct _ContactsCellRendererShapePrivate ContactsCellRendererShapePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

#define CONTACTS_TYPE_LIST_PANE (contacts_list_pane_get_type ())
#define CONTACTS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPane))
#define CONTACTS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))
#define CONTACTS_IS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_IS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_LIST_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))

typedef struct _ContactsListPane ContactsListPane;
typedef struct _ContactsListPaneClass ContactsListPaneClass;
typedef struct _ContactsListPanePrivate ContactsListPanePrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _contacts_store_unref0(var) ((var == NULL) ? NULL : (var = (contacts_store_unref (var), NULL)))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _ContactsContactPrivate ContactsContactPrivate;

struct _ContactsCellRendererShape {
	GtkCellRenderer parent_instance;
	ContactsCellRendererShapePrivate * priv;
};

struct _ContactsCellRendererShapeClass {
	GtkCellRendererClass parent_class;
};

struct _ContactsCellRendererShapePrivate {
	GtkWidget* current_widget;
	gchar* _name;
	FolksPresenceType _presence;
	gchar* _message;
	gboolean _is_phone;
	gint _wrap_width;
};

struct _ContactsListPane {
	GtkFrame parent_instance;
	ContactsListPanePrivate * priv;
	GtkEntry* filter_entry;
};

struct _ContactsListPaneClass {
	GtkFrameClass parent_class;
};

struct _ContactsListPanePrivate {
	ContactsStore* contacts_store;
	GtkTreeView* contacts_tree_view;
	guint filter_entry_changed_id;
	ContactsCellRendererShape* shape;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};


static gpointer contacts_cell_renderer_shape_parent_class = NULL;
static gpointer contacts_list_pane_parent_class = NULL;

GType contacts_cell_renderer_shape_get_type (void) G_GNUC_CONST;
#define CONTACTS_CELL_RENDERER_SHAPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_CELL_RENDERER_SHAPE, ContactsCellRendererShapePrivate))
enum  {
	CONTACTS_CELL_RENDERER_SHAPE_DUMMY_PROPERTY,
	CONTACTS_CELL_RENDERER_SHAPE_NAME,
	CONTACTS_CELL_RENDERER_SHAPE_PRESENCE,
	CONTACTS_CELL_RENDERER_SHAPE_MESSAGE,
	CONTACTS_CELL_RENDERER_SHAPE_IS_PHONE,
	CONTACTS_CELL_RENDERER_SHAPE_WRAP_WIDTH
};
#define CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE 14
static GdkPixbuf* contacts_cell_renderer_shape_create_symbolic_pixbuf (ContactsCellRendererShape* self, GtkWidget* widget, const gchar* icon_name, gint size);
gchar* contacts_contact_presence_to_class (FolksPresenceType presence);
FolksPresenceType contacts_cell_renderer_shape_get_presence (ContactsCellRendererShape* self);
static PangoLayout* contacts_cell_renderer_shape_get_layout (ContactsCellRendererShape* self, GtkWidget* widget, GdkRectangle* cell_area, GtkCellRendererState flags);
const gchar* contacts_cell_renderer_shape_get_name (ContactsCellRendererShape* self);
gchar* contacts_contact_presence_to_icon (FolksPresenceType presence);
static gpointer _g_strdup_pango_attr_data_copy_func (gconstpointer data);
static void _g_free0_ (gpointer var);
const gchar* contacts_cell_renderer_shape_get_message (ContactsCellRendererShape* self);
gchar* contacts_contact_presence_to_string (FolksPresenceType presence);
gboolean contacts_cell_renderer_shape_get_is_phone (ContactsCellRendererShape* self);
gint contacts_cell_renderer_shape_get_wrap_width (ContactsCellRendererShape* self);
static void contacts_cell_renderer_shape_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height);
static void contacts_cell_renderer_shape_do_get_size (ContactsCellRendererShape* self, GtkWidget* widget, GdkRectangle* cell_area, PangoLayout* _layout, gint* x_offset, gint* y_offset, gint* width, gint* height);
static void contacts_cell_renderer_shape_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags);
static void contacts_cell_renderer_shape_real_get_preferred_width (GtkCellRenderer* base, GtkWidget* widget, gint* min_width, gint* nat_width);
static void contacts_cell_renderer_shape_real_get_preferred_height_for_width (GtkCellRenderer* base, GtkWidget* widget, gint width, gint* minimum_height, gint* natural_height);
static void contacts_cell_renderer_shape_real_get_preferred_height (GtkCellRenderer* base, GtkWidget* widget, gint* minimum_size, gint* natural_size);
void contacts_cell_renderer_shape_render_shape (ContactsCellRendererShape* self, cairo_t* cr, PangoAttrShape* attr, gboolean do_path);
ContactsCellRendererShape* contacts_cell_renderer_shape_new (void);
ContactsCellRendererShape* contacts_cell_renderer_shape_construct (GType object_type);
void contacts_cell_renderer_shape_set_name (ContactsCellRendererShape* self, const gchar* value);
void contacts_cell_renderer_shape_set_presence (ContactsCellRendererShape* self, FolksPresenceType value);
void contacts_cell_renderer_shape_set_message (ContactsCellRendererShape* self, const gchar* value);
void contacts_cell_renderer_shape_set_is_phone (ContactsCellRendererShape* self, gboolean value);
void contacts_cell_renderer_shape_set_wrap_width (ContactsCellRendererShape* self, gint value);
static void contacts_cell_renderer_shape_finalize (GObject* obj);
static void _vala_contacts_cell_renderer_shape_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_contacts_cell_renderer_shape_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType contacts_list_pane_get_type (void) G_GNUC_CONST;
gpointer contacts_store_ref (gpointer instance);
void contacts_store_unref (gpointer instance);
GParamSpec* contacts_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void contacts_value_set_store (GValue* value, gpointer v_object);
void contacts_value_take_store (GValue* value, gpointer v_object);
gpointer contacts_value_get_store (const GValue* value);
GType contacts_store_get_type (void) G_GNUC_CONST;
#define CONTACTS_LIST_PANE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_LIST_PANE, ContactsListPanePrivate))
enum  {
	CONTACTS_LIST_PANE_DUMMY_PROPERTY
};
static void contacts_list_pane_setup_contacts_view (ContactsListPane* self, GtkTreeView* tree_view);
static void contacts_list_pane_contacts_selection_changed (ContactsListPane* self, GtkTreeSelection* selection);
static void _contacts_list_pane_contacts_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void _lambda8_ (GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter, ContactsListPane* self);
GType contacts_contact_get_type (void) G_GNUC_CONST;
gboolean contacts_store_is_first (ContactsStore* self, GtkTreeIter* iter);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void __lambda8__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void _lambda9_ (GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter, ContactsListPane* self);
GdkPixbuf* contacts_contact_get_avatar (ContactsContact* self);
static void __lambda9__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void _contacts_cell_renderer_shape_render_shape_pango_cairo_shape_renderer_func (cairo_t* cr, PangoAttrShape* attr, gboolean do_path, gpointer self);
static void _lambda10_ (GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter, ContactsListPane* self);
static void __lambda10__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void contacts_list_pane_refilter (ContactsListPane* self);
void contacts_store_set_filter_values (ContactsStore* self, gchar** values, int values_length1);
static gboolean contacts_list_pane_filter_entry_changed_timeout (ContactsListPane* self);
static void contacts_list_pane_filter_entry_changed (ContactsListPane* self, GtkEditable* editable);
static gboolean _contacts_list_pane_filter_entry_changed_timeout_gsource_func (gpointer self);
static void contacts_list_pane_filter_entry_clear (ContactsListPane* self, GtkEntryIconPosition position);
ContactsListPane* contacts_list_pane_new (ContactsStore* contacts_store);
ContactsListPane* contacts_list_pane_construct (GType object_type, ContactsStore* contacts_store);
static void _contacts_list_pane_filter_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _contacts_list_pane_filter_entry_clear_gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void _lambda11_ (GtkToolButton* button, ContactsListPane* self);
static void __lambda11__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
GtkTreeModel* contacts_store_get_model (ContactsStore* self);
static void contacts_list_pane_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GdkPixbuf* contacts_cell_renderer_shape_create_symbolic_pixbuf (ContactsCellRendererShape* self, GtkWidget* widget, const gchar* icon_name, gint size) {
	GdkPixbuf* result = NULL;
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_;
	GdkScreen* screen;
	GtkIconTheme* _tmp2_ = NULL;
	GtkIconTheme* _tmp3_;
	GtkIconTheme* icon_theme;
	GtkIconInfo* _tmp4_ = NULL;
	GtkIconInfo* info;
	GtkStyleContext* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* context;
	gboolean is_symbolic = FALSE;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GdkPixbuf* pixbuf;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = gtk_widget_get_screen (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp2_ = gtk_icon_theme_get_for_screen (screen);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	icon_theme = _tmp3_;
	_tmp4_ = gtk_icon_theme_lookup_icon (icon_theme, icon_name, size, GTK_ICON_LOOKUP_USE_BUILTIN);
	info = _tmp4_;
	if (info == NULL) {
		result = NULL;
		_gtk_icon_info_free0 (info);
		_g_object_unref0 (icon_theme);
		_g_object_unref0 (screen);
		return result;
	}
	_tmp5_ = gtk_widget_get_style_context (widget);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	context = _tmp6_;
	gtk_style_context_save (context);
	_tmp7_ = contacts_contact_presence_to_class (self->priv->_presence);
	_tmp8_ = _tmp7_;
	gtk_style_context_add_class (context, _tmp8_);
	_g_free0 (_tmp8_);
	pixbuf = NULL;
	{
		gboolean _tmp9_;
		GdkPixbuf* _tmp10_ = NULL;
		GdkPixbuf* _tmp11_;
		_tmp10_ = gtk_icon_info_load_symbolic_for_context (info, context, &_tmp9_, &_inner_error_);
		is_symbolic = _tmp9_;
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp11_;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (context);
		_gtk_icon_info_free0 (info);
		_g_object_unref0 (icon_theme);
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	gtk_style_context_restore (context);
	if (!is_symbolic) {
		_g_object_unref0 (pixbuf);
		pixbuf = NULL;
	}
	result = pixbuf;
	_g_object_unref0 (context);
	_gtk_icon_info_free0 (info);
	_g_object_unref0 (icon_theme);
	_g_object_unref0 (screen);
	return result;
}


static gpointer _g_strdup_pango_attr_data_copy_func (gconstpointer data) {
	gpointer result;
	result = g_strdup (data);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static PangoLayout* contacts_cell_renderer_shape_get_layout (ContactsCellRendererShape* self, GtkWidget* widget, GdkRectangle* cell_area, GtkCellRendererState flags) {
	PangoLayout* result = NULL;
	PangoLayout* layout = NULL;
	gint xpad = 0;
	gchar* _tmp0_;
	gchar* str;
	PangoAttrList* _tmp1_ = NULL;
	PangoAttrList* attr_list;
	PangoAttribute* _tmp2_ = NULL;
	PangoAttribute* a;
	gint _tmp3_;
	PangoAttribute* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* iconname;
	PangoLayout* _tmp24_ = NULL;
	gint _tmp25_;
	PangoAlignment align = 0;
	GtkTextDirection _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = g_strdup (self->priv->_name);
	str = _tmp0_;
	_tmp1_ = pango_attr_list_new ();
	attr_list = _tmp1_;
	_tmp2_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	a = _tmp2_;
	a->start_index = (guint) 0;
	_tmp3_ = strlen (str);
	a->end_index = a->start_index + _tmp3_;
	_tmp4_ = a;
	a = NULL;
	pango_attr_list_insert (attr_list, _tmp4_);
	_tmp5_ = contacts_contact_presence_to_icon (self->priv->_presence);
	iconname = _tmp5_;
	if (iconname != NULL) {
		gchar* _tmp6_;
		PangoRectangle _tmp7_ = {0};
		PangoRectangle r;
		gchar* _tmp8_;
		PangoAttrShape* _tmp9_ = NULL;
		gint _tmp10_;
		PangoAttribute* _tmp11_;
		_tmp6_ = g_strconcat (str, "\xE2\x80\xA8*", NULL);
		_g_free0 (str);
		str = _tmp6_;
		_tmp7_.x = 0;
		_tmp7_.y = (((-CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE) * 1024) * 9) / 10;
		_tmp7_.width = CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE * 1024;
		_tmp7_.height = CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE * 1024;
		r = _tmp7_;
		_tmp8_ = g_strdup (iconname);
		_tmp9_ = (PangoAttrShape*) pango_attr_shape_new_with_data (&r, &r, _tmp8_, _g_strdup_pango_attr_data_copy_func, _g_free0_);
		_pango_attribute_destroy0 (a);
		a = (PangoAttribute*) _tmp9_;
		_tmp10_ = strlen (str);
		a->start_index = (guint) (_tmp10_ - 1);
		a->end_index = a->start_index + 1;
		_tmp11_ = a;
		a = NULL;
		pango_attr_list_insert (attr_list, _tmp11_);
		if (self->priv->_message != NULL) {
			gchar* _tmp12_;
			gchar* m;
			gint _tmp13_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp12_ = g_strdup (self->priv->_message);
			m = _tmp12_;
			_tmp13_ = strlen (m);
			if (_tmp13_ == 0) {
				gchar* _tmp14_ = NULL;
				_tmp14_ = contacts_contact_presence_to_string (self->priv->_presence);
				_g_free0 (m);
				m = _tmp14_;
			}
			_tmp15_ = g_strconcat (" ", m, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (str, _tmp16_, NULL);
			_g_free0 (str);
			str = _tmp17_;
			_g_free0 (_tmp16_);
			if (self->priv->_is_phone) {
				gint _tmp20_;
				gchar* _tmp21_;
				gint _tmp22_;
				PangoAttribute* _tmp23_;
				if ((flags & GTK_CELL_RENDERER_SELECTED) != 0) {
					PangoAttribute* _tmp18_ = NULL;
					_tmp18_ = pango_attr_foreground_new ((guint16) (0xffff - 0x8e8e), (guint16) (0xffff - 0x9191), (guint16) (0xffff - 0x9292));
					_pango_attribute_destroy0 (a);
					a = _tmp18_;
				} else {
					PangoAttribute* _tmp19_ = NULL;
					_tmp19_ = pango_attr_foreground_new ((guint16) 0x8e8e, (guint16) 0x9191, (guint16) 0x9292);
					_pango_attribute_destroy0 (a);
					a = _tmp19_;
				}
				_tmp20_ = strlen (str);
				a->start_index = (guint) _tmp20_;
				_tmp21_ = g_strconcat (str, " (via phone)", NULL);
				_g_free0 (str);
				str = _tmp21_;
				_tmp22_ = strlen (str);
				a->end_index = (guint) _tmp22_;
				_tmp23_ = a;
				a = NULL;
				pango_attr_list_insert (attr_list, _tmp23_);
			}
			_g_free0 (m);
		}
	}
	_tmp24_ = gtk_widget_create_pango_layout (widget, str);
	_g_object_unref0 (layout);
	layout = _tmp24_;
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp25_, NULL);
	xpad = _tmp25_;
	pango_layout_set_attributes (layout, attr_list);
	pango_layout_set_ellipsize (layout, PANGO_ELLIPSIZE_END);
	if (self->priv->_wrap_width != (-1)) {
		PangoRectangle rect = {0};
		gint width = 0;
		gint text_width = 0;
		PangoRectangle _tmp26_ = {0};
		gint _tmp27_;
		pango_layout_get_extents (layout, NULL, &_tmp26_);
		rect = _tmp26_;
		text_width = rect.width;
		if (cell_area != NULL) {
			width = ((*cell_area).width - (xpad * 2)) * PANGO_SCALE;
		} else {
			width = self->priv->_wrap_width * PANGO_SCALE;
		}
		_tmp27_ = MIN (width, text_width);
		width = _tmp27_;
		pango_layout_set_width (layout, width);
	} else {
		pango_layout_set_width (layout, -1);
	}
	pango_layout_set_wrap (layout, PANGO_WRAP_CHAR);
	pango_layout_set_height (layout, -2);
	_tmp28_ = gtk_widget_get_direction (widget);
	if (_tmp28_ == GTK_TEXT_DIR_RTL) {
		align = PANGO_ALIGN_RIGHT;
	} else {
		align = PANGO_ALIGN_LEFT;
	}
	pango_layout_set_alignment (layout, align);
	result = layout;
	_g_free0 (iconname);
	_pango_attribute_destroy0 (a);
	_pango_attr_list_unref0 (attr_list);
	_g_free0 (str);
	return result;
}


static void contacts_cell_renderer_shape_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height) {
	ContactsCellRendererShape * self;
	gint _x_offset = 0;
	gint _y_offset = 0;
	gint _width = 0;
	gint _height = 0;
	self = (ContactsCellRendererShape*) base;
	g_return_if_fail (widget != NULL);
	if (x_offset) {
		*x_offset = _x_offset;
	}
	if (y_offset) {
		*y_offset = _y_offset;
	}
	if (width) {
		*width = _width;
	}
	if (height) {
		*height = _height;
	}
}


static void contacts_cell_renderer_shape_do_get_size (ContactsCellRendererShape* self, GtkWidget* widget, GdkRectangle* cell_area, PangoLayout* _layout, gint* x_offset, gint* y_offset, gint* width, gint* height) {
	gint _x_offset = 0;
	gint _y_offset = 0;
	gint _width = 0;
	gint _height = 0;
	PangoRectangle rect = {0};
	gint xpad = 0;
	gint ypad = 0;
	gint _tmp0_;
	gint _tmp1_;
	PangoLayout* layout = NULL;
	PangoRectangle _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, &_tmp1_);
	xpad = _tmp0_;
	ypad = _tmp1_;
	if (_layout == NULL) {
		PangoLayout* _tmp2_ = NULL;
		_tmp2_ = contacts_cell_renderer_shape_get_layout (self, widget, NULL, 0);
		_g_object_unref0 (layout);
		layout = _tmp2_;
	} else {
		PangoLayout* _tmp3_;
		_tmp3_ = _g_object_ref0 (_layout);
		_g_object_unref0 (layout);
		layout = _tmp3_;
	}
	pango_layout_get_pixel_extents (layout, NULL, &_tmp4_);
	rect = _tmp4_;
	if (cell_area != NULL) {
		gint _tmp5_;
		gint _tmp6_;
		GtkTextDirection _tmp7_;
		gint _tmp8_;
		_tmp5_ = MIN (rect.height, (*cell_area).height - (2 * ypad));
		rect.height = _tmp5_;
		_tmp6_ = MIN (rect.width, (*cell_area).width - (2 * xpad));
		rect.width = _tmp6_;
		_tmp7_ = gtk_widget_get_direction (widget);
		if (_tmp7_ == GTK_TEXT_DIR_RTL) {
			_x_offset = (*cell_area).width - (rect.width + (2 * xpad));
		} else {
			_x_offset = 0;
		}
		_tmp8_ = MAX (_x_offset, 0);
		_x_offset = _tmp8_;
		_y_offset = 0;
	} else {
		_x_offset = 0;
		_y_offset = 0;
	}
	_height = (ypad * 2) + rect.height;
	_width = (xpad * 2) + rect.width;
	_g_object_unref0 (layout);
	if (x_offset) {
		*x_offset = _x_offset;
	}
	if (y_offset) {
		*y_offset = _y_offset;
	}
	if (width) {
		*width = _width;
	}
	if (height) {
		*height = _height;
	}
}


static void contacts_cell_renderer_shape_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags) {
	ContactsCellRendererShape * self;
	GtkStyleContext* context = NULL;
	PangoLayout* layout = NULL;
	gint x_offset;
	gint y_offset;
	gint xpad = 0;
	gint ypad = 0;
	PangoRectangle rect = {0};
	GtkWidget* _tmp0_;
	PangoLayout* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	GtkStyleContext* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	PangoRectangle _tmp8_ = {0};
	self = (ContactsCellRendererShape*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	x_offset = 0;
	y_offset = 0;
	_tmp0_ = _g_object_ref0 (widget);
	_g_object_unref0 (self->priv->current_widget);
	self->priv->current_widget = _tmp0_;
	_tmp1_ = contacts_cell_renderer_shape_get_layout (self, widget, cell_area, flags);
	_g_object_unref0 (layout);
	layout = _tmp1_;
	contacts_cell_renderer_shape_do_get_size (self, widget, cell_area, layout, &_tmp2_, &_tmp3_, NULL, NULL);
	x_offset = _tmp2_;
	y_offset = _tmp3_;
	_tmp4_ = gtk_widget_get_style_context (widget);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (context);
	context = _tmp5_;
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp6_, &_tmp7_);
	xpad = _tmp6_;
	ypad = _tmp7_;
	pango_layout_set_width (layout, (((*cell_area).width - x_offset) - (2 * xpad)) * PANGO_SCALE);
	pango_layout_get_pixel_extents (layout, NULL, &_tmp8_);
	rect = _tmp8_;
	x_offset = x_offset - rect.x;
	cairo_save (cr);
	gdk_cairo_rectangle (cr, cell_area);
	cairo_clip (cr);
	gtk_render_layout (context, cr, (gdouble) (((*cell_area).x + x_offset) + xpad), (gdouble) (((*cell_area).y + y_offset) + ypad), layout);
	cairo_restore (cr);
	_g_object_unref0 (layout);
	_g_object_unref0 (context);
}


static void contacts_cell_renderer_shape_real_get_preferred_width (GtkCellRenderer* base, GtkWidget* widget, gint* min_width, gint* nat_width) {
	ContactsCellRendererShape * self;
	gint _min_width = 0;
	gint _nat_width = 0;
	PangoRectangle rect = {0};
	gint text_width = 0;
	gint xpad = 0;
	gint _tmp0_;
	PangoLayout* _tmp1_ = NULL;
	PangoLayout* layout;
	PangoRectangle _tmp2_ = {0};
	gint _tmp3_;
	gint _tmp4_;
	self = (ContactsCellRendererShape*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, NULL);
	xpad = _tmp0_;
	_tmp1_ = contacts_cell_renderer_shape_get_layout (self, widget, NULL, 0);
	layout = _tmp1_;
	pango_layout_set_width (layout, -1);
	pango_layout_get_extents (layout, NULL, &_tmp2_);
	rect = _tmp2_;
	text_width = rect.width;
	_tmp3_ = MIN (text_width / PANGO_SCALE, self->priv->_wrap_width);
	_min_width = ((xpad * 2) + rect.x) + _tmp3_;
	_nat_width = (xpad * 2) + (text_width / PANGO_SCALE);
	_tmp4_ = MAX (_nat_width, _min_width);
	_nat_width = _tmp4_;
	_g_object_unref0 (layout);
	if (min_width) {
		*min_width = _min_width;
	}
	if (nat_width) {
		*nat_width = _nat_width;
	}
}


static void contacts_cell_renderer_shape_real_get_preferred_height_for_width (GtkCellRenderer* base, GtkWidget* widget, gint width, gint* minimum_height, gint* natural_height) {
	ContactsCellRendererShape * self;
	gint _minimum_height = 0;
	gint _natural_height = 0;
	PangoLayout* layout = NULL;
	gint text_height = 0;
	gint xpad = 0;
	gint ypad = 0;
	gint _tmp0_;
	gint _tmp1_;
	PangoLayout* _tmp2_ = NULL;
	gint _tmp3_;
	self = (ContactsCellRendererShape*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, &_tmp1_);
	xpad = _tmp0_;
	ypad = _tmp1_;
	_tmp2_ = contacts_cell_renderer_shape_get_layout (self, widget, NULL, 0);
	_g_object_unref0 (layout);
	layout = _tmp2_;
	pango_layout_set_width (layout, (width - (xpad * 2)) * PANGO_SCALE);
	pango_layout_get_pixel_size (layout, NULL, &_tmp3_);
	text_height = _tmp3_;
	_minimum_height = text_height + (ypad * 2);
	_natural_height = text_height + (ypad * 2);
	_g_object_unref0 (layout);
	if (minimum_height) {
		*minimum_height = _minimum_height;
	}
	if (natural_height) {
		*natural_height = _natural_height;
	}
}


static void contacts_cell_renderer_shape_real_get_preferred_height (GtkCellRenderer* base, GtkWidget* widget, gint* minimum_size, gint* natural_size) {
	ContactsCellRendererShape * self;
	gint _minimum_size = 0;
	gint _natural_size = 0;
	gint min_width = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (ContactsCellRendererShape*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_preferred_width ((GtkCellRenderer*) self, widget, &_tmp0_, NULL);
	min_width = _tmp0_;
	gtk_cell_renderer_get_preferred_height_for_width ((GtkCellRenderer*) self, widget, min_width, &_tmp1_, &_tmp2_);
	_minimum_size = _tmp1_;
	_natural_size = _tmp2_;
	if (minimum_size) {
		*minimum_size = _minimum_size;
	}
	if (natural_size) {
		*natural_size = _natural_size;
	}
}


void contacts_cell_renderer_shape_render_shape (ContactsCellRendererShape* self, cairo_t* cr, PangoAttrShape* attr, gboolean do_path) {
	PangoAttrShape* sattr;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* pixbuf;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (attr != NULL);
	sattr = (PangoAttrShape*) attr;
	_tmp0_ = contacts_cell_renderer_shape_create_symbolic_pixbuf (self, self->priv->current_widget, (const gchar*) sattr->data, CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE);
	pixbuf = _tmp0_;
	if (pixbuf != NULL) {
		gdouble x = 0.0;
		gdouble y = 0.0;
		gdouble _tmp1_;
		gdouble _tmp2_;
		cairo_get_current_point (cr, &_tmp1_, &_tmp2_);
		x = _tmp1_;
		y = _tmp2_;
		gdk_cairo_set_source_pixbuf (cr, pixbuf, x, y - (CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE * 0.9));
		cairo_paint (cr);
	}
	_g_object_unref0 (pixbuf);
}


ContactsCellRendererShape* contacts_cell_renderer_shape_construct (GType object_type) {
	ContactsCellRendererShape * self = NULL;
	self = (ContactsCellRendererShape*) g_object_new (object_type, NULL);
	return self;
}


ContactsCellRendererShape* contacts_cell_renderer_shape_new (void) {
	return contacts_cell_renderer_shape_construct (CONTACTS_TYPE_CELL_RENDERER_SHAPE);
}


const gchar* contacts_cell_renderer_shape_get_name (ContactsCellRendererShape* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void contacts_cell_renderer_shape_set_name (ContactsCellRendererShape* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	g_object_notify ((GObject *) self, "name");
}


FolksPresenceType contacts_cell_renderer_shape_get_presence (ContactsCellRendererShape* self) {
	FolksPresenceType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_presence;
	return result;
}


void contacts_cell_renderer_shape_set_presence (ContactsCellRendererShape* self, FolksPresenceType value) {
	g_return_if_fail (self != NULL);
	self->priv->_presence = value;
	g_object_notify ((GObject *) self, "presence");
}


const gchar* contacts_cell_renderer_shape_get_message (ContactsCellRendererShape* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_message;
	return result;
}


void contacts_cell_renderer_shape_set_message (ContactsCellRendererShape* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_message);
	self->priv->_message = _tmp0_;
	g_object_notify ((GObject *) self, "message");
}


gboolean contacts_cell_renderer_shape_get_is_phone (ContactsCellRendererShape* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_phone;
	return result;
}


void contacts_cell_renderer_shape_set_is_phone (ContactsCellRendererShape* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_phone = value;
	g_object_notify ((GObject *) self, "is-phone");
}


gint contacts_cell_renderer_shape_get_wrap_width (ContactsCellRendererShape* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_wrap_width;
	return result;
}


void contacts_cell_renderer_shape_set_wrap_width (ContactsCellRendererShape* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_wrap_width = value;
	g_object_notify ((GObject *) self, "wrap-width");
}


static void contacts_cell_renderer_shape_class_init (ContactsCellRendererShapeClass * klass) {
	contacts_cell_renderer_shape_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsCellRendererShapePrivate));
	GTK_CELL_RENDERER_CLASS (klass)->get_size = contacts_cell_renderer_shape_real_get_size;
	GTK_CELL_RENDERER_CLASS (klass)->render = contacts_cell_renderer_shape_real_render;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_width = contacts_cell_renderer_shape_real_get_preferred_width;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_height_for_width = contacts_cell_renderer_shape_real_get_preferred_height_for_width;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_height = contacts_cell_renderer_shape_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_cell_renderer_shape_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_cell_renderer_shape_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_cell_renderer_shape_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CELL_RENDERER_SHAPE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CELL_RENDERER_SHAPE_PRESENCE, g_param_spec_enum ("presence", "presence", "presence", FOLKS_TYPE_PRESENCE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CELL_RENDERER_SHAPE_MESSAGE, g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CELL_RENDERER_SHAPE_IS_PHONE, g_param_spec_boolean ("is-phone", "is-phone", "is-phone", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CELL_RENDERER_SHAPE_WRAP_WIDTH, g_param_spec_int ("wrap-width", "wrap-width", "wrap-width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void contacts_cell_renderer_shape_instance_init (ContactsCellRendererShape * self) {
	self->priv = CONTACTS_CELL_RENDERER_SHAPE_GET_PRIVATE (self);
	self->priv->_wrap_width = -1;
}


static void contacts_cell_renderer_shape_finalize (GObject* obj) {
	ContactsCellRendererShape * self;
	self = CONTACTS_CELL_RENDERER_SHAPE (obj);
	_g_object_unref0 (self->priv->current_widget);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_message);
	G_OBJECT_CLASS (contacts_cell_renderer_shape_parent_class)->finalize (obj);
}


GType contacts_cell_renderer_shape_get_type (void) {
	static volatile gsize contacts_cell_renderer_shape_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_cell_renderer_shape_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsCellRendererShapeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_cell_renderer_shape_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsCellRendererShape), 0, (GInstanceInitFunc) contacts_cell_renderer_shape_instance_init, NULL };
		GType contacts_cell_renderer_shape_type_id;
		contacts_cell_renderer_shape_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER, "ContactsCellRendererShape", &g_define_type_info, 0);
		g_once_init_leave (&contacts_cell_renderer_shape_type_id__volatile, contacts_cell_renderer_shape_type_id);
	}
	return contacts_cell_renderer_shape_type_id__volatile;
}


static void _vala_contacts_cell_renderer_shape_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsCellRendererShape * self;
	self = CONTACTS_CELL_RENDERER_SHAPE (object);
	switch (property_id) {
		case CONTACTS_CELL_RENDERER_SHAPE_NAME:
		g_value_set_string (value, contacts_cell_renderer_shape_get_name (self));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_PRESENCE:
		g_value_set_enum (value, contacts_cell_renderer_shape_get_presence (self));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_MESSAGE:
		g_value_set_string (value, contacts_cell_renderer_shape_get_message (self));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_IS_PHONE:
		g_value_set_boolean (value, contacts_cell_renderer_shape_get_is_phone (self));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_WRAP_WIDTH:
		g_value_set_int (value, contacts_cell_renderer_shape_get_wrap_width (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_contacts_cell_renderer_shape_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ContactsCellRendererShape * self;
	self = CONTACTS_CELL_RENDERER_SHAPE (object);
	switch (property_id) {
		case CONTACTS_CELL_RENDERER_SHAPE_NAME:
		contacts_cell_renderer_shape_set_name (self, g_value_get_string (value));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_PRESENCE:
		contacts_cell_renderer_shape_set_presence (self, g_value_get_enum (value));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_MESSAGE:
		contacts_cell_renderer_shape_set_message (self, g_value_get_string (value));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_IS_PHONE:
		contacts_cell_renderer_shape_set_is_phone (self, g_value_get_boolean (value));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_WRAP_WIDTH:
		contacts_cell_renderer_shape_set_wrap_width (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _contacts_list_pane_contacts_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	contacts_list_pane_contacts_selection_changed (self, _sender);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


static void _lambda8_ (GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter, ContactsListPane* self) {
	ContactsContact* contact = NULL;
	gchar* _tmp0_;
	gchar* letter;
	gboolean _tmp1_;
	g_return_if_fail (column != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	gtk_tree_model_get (model, iter, 0, &contact, -1);
	_tmp0_ = g_strdup ("");
	letter = _tmp0_;
	_tmp1_ = contacts_store_is_first (self->priv->contacts_store, iter);
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gunichar _tmp3_;
		gunichar _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp2_ = contacts_contact_get_display_name (contact);
		_tmp3_ = string_get_char (_tmp2_, (glong) 0);
		_tmp4_ = g_unichar_totitle (_tmp3_);
		_tmp5_ = g_unichar_to_string (_tmp4_);
		_g_free0 (letter);
		letter = _tmp5_;
	}
	g_object_set ((GObject*) cell, "text", letter, NULL);
	_g_free0 (letter);
	_g_object_unref0 (contact);
}


static void __lambda8__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	_lambda8_ (cell_layout, cell, tree_model, iter, self);
}


static void _lambda9_ (GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter, ContactsListPane* self) {
	ContactsContact* contact = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	g_return_if_fail (column != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	gtk_tree_model_get (model, iter, 0, &contact, -1);
	_tmp0_ = contacts_contact_get_avatar (contact);
	g_object_set ((GObject*) cell, "pixbuf", _tmp0_, NULL);
	_g_object_unref0 (contact);
}


static void __lambda9__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	_lambda9_ (cell_layout, cell, tree_model, iter, self);
}


static void _contacts_cell_renderer_shape_render_shape_pango_cairo_shape_renderer_func (cairo_t* cr, PangoAttrShape* attr, gboolean do_path, gpointer self) {
	contacts_cell_renderer_shape_render_shape (self, cr, attr, do_path);
}


static void _lambda10_ (GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter, ContactsListPane* self) {
	ContactsContact* contact = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (column != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	gtk_tree_model_get (model, iter, 0, &contact, -1);
	_tmp0_ = contacts_contact_get_display_name (contact);
	g_object_set ((GObject*) cell, "wrap_width", 230, "name", _tmp0_, "presence", contact->presence_type, "message", contact->presence_message, "is_phone", contact->is_phone, NULL);
	_g_object_unref0 (contact);
}


static void __lambda10__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	_lambda10_ (cell_layout, cell, tree_model, iter, self);
}


static void contacts_list_pane_setup_contacts_view (ContactsListPane* self, GtkTreeView* tree_view) {
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* selection;
	GtkTreeViewColumn* _tmp2_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererText* _tmp3_ = NULL;
	GtkCellRendererText* text;
	GtkCellRendererPixbuf* _tmp4_ = NULL;
	GtkCellRendererPixbuf* icon;
	GtkTreeViewColumn* _tmp5_ = NULL;
	ContactsCellRendererShape* _tmp6_ = NULL;
	PangoContext* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree_view != NULL);
	gtk_tree_view_set_headers_visible (tree_view, FALSE);
	_tmp0_ = gtk_tree_view_get_selection (tree_view);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selection = _tmp1_;
	gtk_tree_selection_set_mode (selection, GTK_SELECTION_BROWSE);
	g_signal_connect_object (selection, "changed", (GCallback) _contacts_list_pane_contacts_selection_changed_gtk_tree_selection_changed, self, 0);
	_tmp2_ = gtk_tree_view_column_new ();
	column = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text = g_object_ref_sink (_tmp3_);
	gtk_cell_renderer_set_alignment ((GtkCellRenderer*) text, (gfloat) 0, (gfloat) 0);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text, TRUE);
	g_object_set ((GObject*) text, "weight", PANGO_WEIGHT_BOLD, "scale", 1.28, "width", 24, NULL);
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) column, (GtkCellRenderer*) text, __lambda8__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp4_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	icon = g_object_ref_sink (_tmp4_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) icon, FALSE);
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) column, (GtkCellRenderer*) icon, __lambda9__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	gtk_tree_view_append_column (tree_view, column);
	_tmp5_ = gtk_tree_view_column_new ();
	_g_object_unref0 (column);
	column = g_object_ref_sink (_tmp5_);
	_tmp6_ = contacts_cell_renderer_shape_new ();
	_g_object_unref0 (self->priv->shape);
	self->priv->shape = g_object_ref_sink (_tmp6_);
	_tmp7_ = gtk_widget_get_pango_context ((GtkWidget*) tree_view);
	pango_cairo_context_set_shape_renderer (_tmp7_, _contacts_cell_renderer_shape_render_shape_pango_cairo_shape_renderer_func, g_object_ref (self->priv->shape), g_object_unref);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) self->priv->shape, FALSE);
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) column, (GtkCellRenderer*) self->priv->shape, __lambda10__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	gtk_tree_view_append_column (tree_view, column);
	_g_object_unref0 (icon);
	_g_object_unref0 (text);
	_g_object_unref0 (column);
	_g_object_unref0 (selection);
}


static void contacts_list_pane_refilter (ContactsListPane* self) {
	gchar** values = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* str;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_entry_get_text (self->filter_entry);
	_tmp1_ = g_strdup (_tmp0_);
	str = _tmp1_;
	_tmp2_ = strlen (str);
	if (_tmp2_ == 0) {
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		values = NULL;
		values_length1 = 0;
		_values_size_ = values_length1;
	} else {
		gchar* _tmp3_ = NULL;
		gchar** _tmp4_;
		gchar** _tmp5_ = NULL;
		_tmp3_ = g_utf8_casefold (str, (gssize) (-1));
		_g_free0 (str);
		str = _tmp3_;
		_tmp5_ = _tmp4_ = g_strsplit (str, " ", 0);
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		values = _tmp5_;
		values_length1 = _vala_array_length (_tmp4_);
		_values_size_ = values_length1;
	}
	contacts_store_set_filter_values (self->priv->contacts_store, values, values_length1);
	_g_free0 (str);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean contacts_list_pane_filter_entry_changed_timeout (ContactsListPane* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->filter_entry_changed_id = (guint) 0;
	contacts_list_pane_refilter (self);
	result = FALSE;
	return result;
}


static gboolean _contacts_list_pane_filter_entry_changed_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = contacts_list_pane_filter_entry_changed_timeout (self);
	return result;
}


static void contacts_list_pane_filter_entry_changed (ContactsListPane* self, GtkEditable* editable) {
	guint _tmp0_;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	if (self->priv->filter_entry_changed_id != 0) {
		g_source_remove (self->priv->filter_entry_changed_id);
	}
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, _contacts_list_pane_filter_entry_changed_timeout_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->filter_entry_changed_id = _tmp0_;
	_tmp1_ = gtk_entry_get_text (self->filter_entry);
	if (g_strcmp0 (_tmp1_, "") == 0) {
		gtk_entry_set_icon_from_icon_name (self->filter_entry, GTK_ENTRY_ICON_SECONDARY, "edit-find-symbolic");
	} else {
		gtk_entry_set_icon_from_icon_name (self->filter_entry, GTK_ENTRY_ICON_SECONDARY, "edit-clear-symbolic");
	}
}


static void contacts_list_pane_filter_entry_clear (ContactsListPane* self, GtkEntryIconPosition position) {
	g_return_if_fail (self != NULL);
	gtk_entry_set_text (self->filter_entry, "");
}


static void contacts_list_pane_contacts_selection_changed (ContactsListPane* self, GtkTreeSelection* selection) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	ContactsContact* contact;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTreeModel* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	contact = NULL;
	_tmp2_ = gtk_tree_selection_get_selected (selection, &_tmp0_, &_tmp1_);
	_g_object_unref0 (model);
	_tmp3_ = _g_object_ref0 (_tmp0_);
	model = _tmp3_;
	iter = _tmp1_;
	if (_tmp2_) {
		gtk_tree_model_get (model, &iter, 0, &contact, -1);
	}
	g_signal_emit_by_name (self, "selection-changed", contact);
	_g_object_unref0 (contact);
	_g_object_unref0 (model);
}


static gpointer _contacts_store_ref0 (gpointer self) {
	return self ? contacts_store_ref (self) : NULL;
}


static void _contacts_list_pane_filter_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	contacts_list_pane_filter_entry_changed (self, _sender);
}


static void _contacts_list_pane_filter_entry_clear_gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	contacts_list_pane_filter_entry_clear (self, p0);
}


static void _lambda11_ (GtkToolButton* button, ContactsListPane* self) {
	g_return_if_fail (button != NULL);
	g_signal_emit_by_name (self, "create-new");
}


static void __lambda11__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	_lambda11_ (_sender, self);
}


ContactsListPane* contacts_list_pane_construct (GType object_type, ContactsStore* contacts_store) {
	ContactsListPane * self = NULL;
	ContactsStore* _tmp0_;
	GtkToolbar* _tmp1_ = NULL;
	GtkToolbar* toolbar;
	GtkStyleContext* _tmp2_ = NULL;
	GtkSeparatorToolItem* _tmp3_ = NULL;
	GtkSeparatorToolItem* separator;
	GtkEntry* _tmp4_ = NULL;
	GtkToolItem* _tmp5_ = NULL;
	GtkToolItem* search_entry_item;
	GtkSeparatorToolItem* _tmp6_ = NULL;
	GtkToolButton* _tmp7_ = NULL;
	GtkToolButton* add_button;
	GtkStyleContext* _tmp8_ = NULL;
	GtkScrolledWindow* _tmp9_ = NULL;
	GtkScrolledWindow* scrolled;
	GtkStyleContext* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* grid;
	GtkTreeModel* _tmp12_ = NULL;
	GtkTreeView* _tmp13_ = NULL;
	g_return_val_if_fail (contacts_store != NULL, NULL);
	self = (ContactsListPane*) g_object_new (object_type, NULL);
	_tmp0_ = _contacts_store_ref0 (contacts_store);
	_contacts_store_unref0 (self->priv->contacts_store);
	self->priv->contacts_store = _tmp0_;
	_tmp1_ = (GtkToolbar*) gtk_toolbar_new ();
	toolbar = g_object_ref_sink (_tmp1_);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) toolbar);
	gtk_style_context_add_class (_tmp2_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	gtk_toolbar_set_icon_size (toolbar, GTK_ICON_SIZE_MENU);
	gtk_widget_set_vexpand ((GtkWidget*) toolbar, FALSE);
	_tmp3_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	separator = g_object_ref_sink (_tmp3_);
	gtk_separator_tool_item_set_draw (separator, FALSE);
	gtk_container_add ((GtkContainer*) toolbar, (GtkWidget*) separator);
	_tmp4_ = (GtkEntry*) gtk_entry_new ();
	_g_object_unref0 (self->filter_entry);
	self->filter_entry = g_object_ref_sink (_tmp4_);
	gtk_entry_set_icon_from_icon_name (self->filter_entry, GTK_ENTRY_ICON_SECONDARY, "edit-find-symbolic");
	g_signal_connect_object ((GtkEditable*) self->filter_entry, "changed", (GCallback) _contacts_list_pane_filter_entry_changed_gtk_editable_changed, self, 0);
	g_signal_connect_object (self->filter_entry, "icon-press", (GCallback) _contacts_list_pane_filter_entry_clear_gtk_entry_icon_press, self, 0);
	_tmp5_ = gtk_tool_item_new ();
	search_entry_item = g_object_ref_sink (_tmp5_);
	gtk_tool_item_set_is_important (search_entry_item, FALSE);
	gtk_tool_item_set_expand (search_entry_item, TRUE);
	gtk_container_add ((GtkContainer*) search_entry_item, (GtkWidget*) self->filter_entry);
	gtk_container_add ((GtkContainer*) toolbar, (GtkWidget*) search_entry_item);
	_tmp6_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	_g_object_unref0 (separator);
	separator = g_object_ref_sink (_tmp6_);
	gtk_separator_tool_item_set_draw (separator, FALSE);
	gtk_container_add ((GtkContainer*) toolbar, (GtkWidget*) separator);
	_tmp7_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	add_button = g_object_ref_sink (_tmp7_);
	gtk_tool_button_set_icon_name (add_button, "list-add-symbolic");
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) add_button);
	gtk_style_context_add_class (_tmp8_, GTK_STYLE_CLASS_RAISED);
	gtk_tool_item_set_is_important ((GtkToolItem*) add_button, FALSE);
	gtk_widget_set_size_request ((GtkWidget*) add_button, 34, -1);
	gtk_container_add ((GtkContainer*) toolbar, (GtkWidget*) add_button);
	g_signal_connect_object (add_button, "clicked", (GCallback) __lambda11__gtk_tool_button_clicked, self, 0);
	_tmp9_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	scrolled = g_object_ref_sink (_tmp9_);
	gtk_scrolled_window_set_min_content_width (scrolled, 310);
	gtk_scrolled_window_set_policy (scrolled, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_vexpand ((GtkWidget*) scrolled, TRUE);
	gtk_scrolled_window_set_shadow_type (scrolled, GTK_SHADOW_NONE);
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) scrolled);
	gtk_style_context_set_junction_sides (_tmp10_, (GTK_JUNCTION_RIGHT | GTK_JUNCTION_LEFT) | GTK_JUNCTION_TOP);
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
	grid = g_object_ref_sink (_tmp11_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	gtk_grid_attach (grid, (GtkWidget*) toolbar, 0, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) scrolled, 0, 1, 1, 1);
	_tmp12_ = contacts_store_get_model (contacts_store);
	_tmp13_ = (GtkTreeView*) gtk_tree_view_new_with_model (_tmp12_);
	_g_object_unref0 (self->priv->contacts_tree_view);
	self->priv->contacts_tree_view = g_object_ref_sink (_tmp13_);
	contacts_list_pane_setup_contacts_view (self, self->priv->contacts_tree_view);
	gtk_container_add ((GtkContainer*) scrolled, (GtkWidget*) self->priv->contacts_tree_view);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (grid);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (add_button);
	_g_object_unref0 (search_entry_item);
	_g_object_unref0 (separator);
	_g_object_unref0 (toolbar);
	return self;
}


ContactsListPane* contacts_list_pane_new (ContactsStore* contacts_store) {
	return contacts_list_pane_construct (CONTACTS_TYPE_LIST_PANE, contacts_store);
}


static void contacts_list_pane_class_init (ContactsListPaneClass * klass) {
	contacts_list_pane_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsListPanePrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_list_pane_finalize;
	g_signal_new ("selection_changed", CONTACTS_TYPE_LIST_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	g_signal_new ("create_new", CONTACTS_TYPE_LIST_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void contacts_list_pane_instance_init (ContactsListPane * self) {
	self->priv = CONTACTS_LIST_PANE_GET_PRIVATE (self);
}


static void contacts_list_pane_finalize (GObject* obj) {
	ContactsListPane * self;
	self = CONTACTS_LIST_PANE (obj);
	_contacts_store_unref0 (self->priv->contacts_store);
	_g_object_unref0 (self->priv->contacts_tree_view);
	_g_object_unref0 (self->filter_entry);
	_g_object_unref0 (self->priv->shape);
	G_OBJECT_CLASS (contacts_list_pane_parent_class)->finalize (obj);
}


GType contacts_list_pane_get_type (void) {
	static volatile gsize contacts_list_pane_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_list_pane_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsListPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_list_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsListPane), 0, (GInstanceInitFunc) contacts_list_pane_instance_init, NULL };
		GType contacts_list_pane_type_id;
		contacts_list_pane_type_id = g_type_register_static (GTK_TYPE_FRAME, "ContactsListPane", &g_define_type_info, 0);
		g_once_init_leave (&contacts_list_pane_type_id__volatile, contacts_list_pane_type_id);
	}
	return contacts_list_pane_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



