/* rygel-http-get.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-get.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;

#define RYGEL_TYPE_HTTP_PLAYLIST_HANDLER (rygel_http_playlist_handler_get_type ())
#define RYGEL_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandler))
#define RYGEL_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_HTTP_PLAYLIST_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))

typedef struct _RygelHTTPPlaylistHandler RygelHTTPPlaylistHandler;
typedef struct _RygelHTTPPlaylistHandlerClass RygelHTTPPlaylistHandlerClass;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHttpGetHandleData RygelHttpGetHandleData;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
typedef struct _RygelHttpGetFindItemData RygelHttpGetFindItemData;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHttpGetHandleItemRequestData RygelHttpGetHandleItemRequestData;

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPGetPrivate {
	gint thumbnail_index;
	gint subtitle_index;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHttpGetHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	gchar* header;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	SoupMessage* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	SoupMessage* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	RygelHTTPItemURI* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	RygelTranscoder* transcoder;
	RygelHTTPServer* _tmp26_;
	RygelHTTPItemURI* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	RygelTranscoder* _tmp30_;
	RygelTranscoder* _tmp31_;
	GCancellable* _tmp32_;
	GCancellable* _tmp33_;
	RygelHTTPTranscodeHandler* _tmp34_;
	gboolean _tmp35_;
	RygelHTTPItemURI* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	RygelHTTPItemURI* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	RygelHTTPItemURI* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	GCancellable* _tmp47_;
	GCancellable* _tmp48_;
	RygelHTTPPlaylistHandler* _tmp49_;
	RygelHTTPGetHandler* _tmp50_;
	GCancellable* _tmp51_;
	GCancellable* _tmp52_;
	RygelHTTPIdentityHandler* _tmp53_;
	GError * _inner_error_;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	RygelDataSource* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelHttpGetFindItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	RygelMediaObject* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	RygelClientHacks* _tmp9_;
	RygelClientHacks* _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelHTTPItemURI* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	RygelMediaObject* _tmp15_;
	RygelMusicItem* music;
	RygelMediaObject* _tmp16_;
	RygelMusicItem* _tmp17_;
	RygelMusicItem* _tmp18_;
	RygelThumbnail* _tmp19_;
	RygelThumbnail* _tmp20_;
	RygelThumbnail* _tmp21_;
	RygelMediaObject* _tmp22_;
	RygelVisualItem* visual;
	RygelMediaObject* _tmp23_;
	RygelVisualItem* _tmp24_;
	RygelHTTPItemURI* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	RygelVisualItem* _tmp28_;
	GeeArrayList* _tmp29_;
	GeeArrayList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	RygelVisualItem* _tmp33_;
	GeeArrayList* _tmp34_;
	GeeArrayList* _tmp35_;
	RygelHTTPItemURI* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gpointer _tmp39_;
	RygelMediaObject* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	GError* _tmp43_;
	gboolean _tmp44_;
	RygelHTTPItemURI* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	RygelMediaObject* _tmp48_;
	gboolean _tmp49_;
	RygelVideoItem* video;
	RygelMediaObject* _tmp50_;
	RygelVideoItem* _tmp51_;
	RygelHTTPItemURI* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	RygelVideoItem* _tmp55_;
	GeeArrayList* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	RygelVideoItem* _tmp59_;
	GeeArrayList* _tmp60_;
	RygelHTTPItemURI* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gpointer _tmp64_;
	RygelMediaObject* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	GError* _tmp68_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHttpGetHandleItemRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	gboolean need_time_seek;
	gboolean _tmp0_;
	gboolean requested_time_seek;
	gboolean _tmp1_;
	gboolean need_byte_seek;
	gboolean _tmp2_;
	gboolean requested_byte_seek;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GError* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	RygelHTTPTimeSeek* _tmp19_;
	RygelHTTPTimeSeek* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	RygelHTTPByteSeek* _tmp25_;
	RygelHTTPByteSeek* _tmp26_;
	GError* _error_;
	SoupServer* _tmp27_;
	SoupMessage* _tmp28_;
	GError* _tmp29_;
	GError* _tmp30_;
	GError* _tmp31_;
	GError* _tmp32_;
	RygelHTTPGetHandler* _tmp33_;
	SoupMessage* _tmp34_;
	SoupMessageHeaders* _tmp35_;
	const gchar* _tmp36_;
	SoupMessage* _tmp37_;
	SoupMessage* _tmp38_;
	RygelHTTPGetHandler* _tmp39_;
	gboolean _tmp40_;
	SoupMessage* _tmp41_;
	SoupMessageHeaders* _tmp42_;
	SoupMessage* _tmp43_;
	SoupMessageHeaders* _tmp44_;
	SoupMessage* _tmp45_;
	SoupMessageHeaders* _tmp46_;
	SoupMessage* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gboolean _tmp51_;
	SoupServer* _tmp52_;
	SoupMessage* _tmp53_;
	RygelHTTPResponse* response;
	RygelHTTPGetHandler* _tmp54_;
	RygelHTTPResponse* _tmp55_;
	RygelHTTPResponse* _tmp56_;
	GError * _inner_error_;
};


static gpointer rygel_http_get_parent_class = NULL;

GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET, RygelHTTPGetPrivate))
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_TRANSFER_MODE_HEADER "transferMode.dlna.org"
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
static void rygel_http_get_real_handle_data_free (gpointer _data);
static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* _data_);
GQuark rygel_http_request_error_quark (void);
const gchar* rygel_http_item_uri_get_transcode_target (RygelHTTPItemURI* self);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
const gchar* rygel_http_item_uri_get_playlist_format (RygelHTTPItemURI* self);
gboolean rygel_http_playlist_handler_is_supported (const gchar* playlist_format);
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_new (const gchar* playlist_format, GCancellable* cancellable);
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_construct (GType object_type, const gchar* playlist_format, GCancellable* cancellable);
GType rygel_http_playlist_handler_get_type (void) G_GNUC_CONST;
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
static void rygel_http_get_ensure_correct_mode (RygelHTTPGet* self, GError** error);
static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error);
static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_get_real_find_item_data_free (gpointer _data);
static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* _data_);
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
void rygel_client_hacks_apply (RygelClientHacks* self, RygelMediaObject* object);
gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_music_item_get_album_art (RygelMusicItem* self);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self);
GType rygel_video_item_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
static void rygel_http_get_handle_item_request_data_free (gpointer _data);
static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* _data_);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request);
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_error_quark (void);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
gboolean rygel_http_get_handler_knows_size (RygelHTTPGetHandler* self, RygelHTTPGet* request);
static void __lambda16_ (RygelHTTPGet* self, const gchar* name, const gchar* value);
static void ___lambda16__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
static void rygel_http_get_finalize (GObject* obj);


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPGet * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp0_ = http_server;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp1_ = server;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp2_ = msg;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	self = (RygelHTTPGet*) rygel_http_request_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	self->priv->thumbnail_index = -1;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	self->priv->subtitle_index = -1;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	return self;
#line 773 "rygel-http-get.c"
}


RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, http_server, server, msg);
#line 780 "rygel-http-get.c"
}


static void rygel_http_get_real_handle_data_free (gpointer _data) {
	RygelHttpGetHandleData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_slice_free (RygelHttpGetHandleData, _data_);
#line 791 "rygel-http-get.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	return self ? g_object_ref (self) : NULL;
#line 798 "rygel-http-get.c"
}


static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetHandleData* _data_;
	RygelHTTPGet* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	self = (RygelHTTPGet*) base;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_ = g_slice_new0 (RygelHttpGetHandleData);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_handle);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_handle_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_get_real_handle_co (_data_);
#line 820 "rygel-http-get.c"
}


static void rygel_http_get_real_handle_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return;
#line 830 "rygel-http-get.c"
	}
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 834 "rygel-http-get.c"
}


static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleData* _data_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_ = _user_data_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_source_object_ = source_object;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_res_ = _res_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_get_real_handle_co (_data_);
#line 848 "rygel-http-get.c"
}


static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* _data_) {
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	switch (_data_->_state_) {
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		case 0:
#line 857 "rygel-http-get.c"
		goto _state_0;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		case 1:
#line 861 "rygel-http-get.c"
		goto _state_1;
		default:
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_assert_not_reached ();
#line 866 "rygel-http-get.c"
	}
	_state_0:
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp0_ = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp1_ = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp1_ = _data_->_tmp0_->request_headers;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp2_ = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp2_ = soup_message_headers_get_one (_data_->_tmp1_, "getcontentFeatures.dlna.org");
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp3_ = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->header = _data_->_tmp3_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp6_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp7_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_object_get (_data_->_tmp6_, "method", &_data_->_tmp7_, NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp8_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp9_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp10_ = FALSE;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp10_ = g_strcmp0 (_data_->_tmp9_, "HEAD") != 0;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_g_free0 (_data_->_tmp9_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp10_) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp11_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp11_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp12_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_get (_data_->_tmp11_, "method", &_data_->_tmp12_, NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp13_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp13_ = _data_->_tmp12_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp14_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp5_ = g_strcmp0 (_data_->_tmp14_, "GET") != 0;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_g_free0 (_data_->_tmp14_);
#line 931 "rygel-http-get.c"
	} else {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp5_ = FALSE;
#line 935 "rygel-http-get.c"
	}
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp15_ = FALSE;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp15_ = _data_->_tmp5_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp15_) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp4_ = TRUE;
#line 945 "rygel-http-get.c"
	} else {
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp17_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp17_ = _data_->header;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_tmp17_ != NULL) {
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp18_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp18_ = _data_->header;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp16_ = g_strcmp0 (_data_->_tmp18_, "1") != 0;
#line 959 "rygel-http-get.c"
		} else {
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp16_ = FALSE;
#line 963 "rygel-http-get.c"
		}
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp19_ = FALSE;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp19_ = _data_->_tmp16_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp4_ = _data_->_tmp19_;
#line 971 "rygel-http-get.c"
	}
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp20_ = FALSE;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp20_ = _data_->_tmp4_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp20_) {
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp21_ = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp21_ = _ ("Invalid Request");
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp22_ = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp22_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _data_->_tmp21_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_inner_error_ = _data_->_tmp22_;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_g_free0 (_data_->header);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 999 "rygel-http-get.c"
		} else {
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1003 "rygel-http-get.c"
		}
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 1009 "rygel-http-get.c"
	}
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp23_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp23_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp24_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp24_ = rygel_http_item_uri_get_transcode_target (_data_->_tmp23_);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp25_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp25_ = _data_->_tmp24_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp25_ != NULL) {
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp26_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp26_ = ((RygelHTTPRequest*) _data_->self)->http_server;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp27_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp27_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp28_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp28_ = rygel_http_item_uri_get_transcode_target (_data_->_tmp27_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp29_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp29_ = _data_->_tmp28_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp30_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp30_ = rygel_transcode_manager_get_transcoder ((RygelTranscodeManager*) _data_->_tmp26_, _data_->_tmp29_, &_data_->_inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->transcoder = _data_->_tmp30_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_inner_error_ != NULL) {
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_error_free (_data_->_inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_g_free0 (_data_->header);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			if (_data_->_state_ == 0) {
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1059 "rygel-http-get.c"
			} else {
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1063 "rygel-http-get.c"
			}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_object_unref (_data_->_async_result);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			return FALSE;
#line 1069 "rygel-http-get.c"
		}
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp31_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp31_ = _data_->transcoder;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp32_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp32_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp33_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp33_ = _data_->_tmp32_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp34_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp34_ = rygel_http_transcode_handler_new (_data_->_tmp31_, _data_->_tmp33_);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_g_object_unref0 (_data_->self->handler);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp34_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_g_object_unref0 (_data_->transcoder);
#line 1093 "rygel-http-get.c"
	}
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp36_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp36_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp37_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp37_ = rygel_http_item_uri_get_playlist_format (_data_->_tmp36_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp38_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp38_ = _data_->_tmp37_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp38_ != NULL) {
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp39_ = NULL;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp39_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp40_ = NULL;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp40_ = rygel_http_item_uri_get_playlist_format (_data_->_tmp39_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp41_ = NULL;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp41_ = _data_->_tmp40_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp42_ = FALSE;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp42_ = rygel_http_playlist_handler_is_supported (_data_->_tmp41_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp35_ = _data_->_tmp42_;
#line 1127 "rygel-http-get.c"
	} else {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp35_ = FALSE;
#line 1131 "rygel-http-get.c"
	}
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp43_ = FALSE;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp43_ = _data_->_tmp35_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp43_) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp44_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp44_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp45_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp45_ = rygel_http_item_uri_get_playlist_format (_data_->_tmp44_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp46_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp46_ = _data_->_tmp45_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp47_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp47_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp48_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp48_ = _data_->_tmp47_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp49_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp49_ = rygel_http_playlist_handler_new (_data_->_tmp46_, _data_->_tmp48_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_g_object_unref0 (_data_->self->handler);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp49_;
#line 1167 "rygel-http-get.c"
	}
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp50_ = NULL;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp50_ = _data_->self->handler;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp50_ == NULL) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp51_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp51_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp52_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp52_ = _data_->_tmp51_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp53_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp53_ = rygel_http_identity_handler_new (_data_->_tmp52_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_g_object_unref0 (_data_->self->handler);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp53_;
#line 1191 "rygel-http-get.c"
	}
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_get_ensure_correct_mode (_data_->self, &_data_->_inner_error_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_g_free0 (_data_->header);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1207 "rygel-http-get.c"
		} else {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1211 "rygel-http-get.c"
		}
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 1217 "rygel-http-get.c"
	}
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_state_ = 1;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_get_handle_item_request (_data_->self, rygel_http_get_handle_ready, _data_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	return FALSE;
#line 1225 "rygel-http-get.c"
	_state_1:
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_get_handle_item_request_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_g_free0 (_data_->header);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1241 "rygel-http-get.c"
		} else {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1245 "rygel-http-get.c"
		}
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 1251 "rygel-http-get.c"
	}
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_g_free0 (_data_->header);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_state_ == 0) {
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1259 "rygel-http-get.c"
	} else {
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1263 "rygel-http-get.c"
	}
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_object_unref (_data_->_async_result);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	return FALSE;
#line 1269 "rygel-http-get.c"
}


static void rygel_http_get_real_find_item_data_free (gpointer _data) {
	RygelHttpGetFindItemData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_slice_free (RygelHttpGetFindItemData, _data_);
#line 1280 "rygel-http-get.c"
}


static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetFindItemData* _data_;
	RygelHTTPGet* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	self = (RygelHTTPGet*) base;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_ = g_slice_new0 (RygelHttpGetFindItemData);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_find_item);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_find_item_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_get_real_find_item_co (_data_);
#line 1302 "rygel-http-get.c"
}


static void rygel_http_get_real_find_item_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetFindItemData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return;
#line 1312 "rygel-http-get.c"
	}
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1316 "rygel-http-get.c"
}


static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetFindItemData* _data_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_ = _user_data_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_source_object_ = source_object;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_res_ = _res_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_get_real_find_item_co (_data_);
#line 1330 "rygel-http-get.c"
}


static gpointer _rygel_icon_info_ref0 (gpointer self) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	return self ? rygel_icon_info_ref (self) : NULL;
#line 1337 "rygel-http-get.c"
}


static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* _data_) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	switch (_data_->_state_) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		case 0:
#line 1346 "rygel-http-get.c"
		goto _state_0;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		case 1:
#line 1350 "rygel-http-get.c"
		goto _state_1;
		default:
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_assert_not_reached ();
#line 1355 "rygel-http-get.c"
	}
	_state_0:
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_state_ = 1;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest), rygel_http_get_find_item_ready, _data_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	return FALSE;
#line 1364 "rygel-http-get.c"
	_state_1:
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest), _data_->_res_, &_data_->_inner_error_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1378 "rygel-http-get.c"
		} else {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1382 "rygel-http-get.c"
		}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 1388 "rygel-http-get.c"
	}
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp0_ = NULL;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1400 "rygel-http-get.c"
		} else {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1404 "rygel-http-get.c"
		}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 1410 "rygel-http-get.c"
	}
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp1_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp1_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp2_ = FALSE;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp2_ = rygel_media_item_get_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp1_) : NULL);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp3_ = FALSE;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp4_ = FALSE;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp4_ = G_UNLIKELY (_data_->_tmp3_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp4_) {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp5_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp5_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp6_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp6_ = rygel_media_object_get_id (_data_->_tmp5_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp7_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp8_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp8_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "Item '%s' is empty", _data_->_tmp7_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1456 "rygel-http-get.c"
		} else {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1460 "rygel-http-get.c"
		}
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 1466 "rygel-http-get.c"
	}
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp9_ = NULL;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp9_ = ((RygelHTTPRequest*) _data_->self)->hack;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp9_ != NULL) {
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp10_ = NULL;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp10_ = ((RygelHTTPRequest*) _data_->self)->hack;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp11_ = NULL;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp11_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		rygel_client_hacks_apply (_data_->_tmp10_, _data_->_tmp11_);
#line 1484 "rygel-http-get.c"
	}
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp12_ = NULL;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp12_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp13_ = 0;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp13_ = rygel_http_item_uri_get_thumbnail_index (_data_->_tmp12_);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp14_ = 0;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp14_ = _data_->_tmp13_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp14_ >= 0) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp15_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp15_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp15_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp16_ = NULL;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp16_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp17_ = NULL;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp16_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _data_->_tmp16_) : NULL);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->music = _data_->_tmp17_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp18_ = NULL;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp18_ = _data_->music;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp19_ = NULL;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp19_ = rygel_music_item_get_album_art (_data_->_tmp18_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp20_ = NULL;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp20_ = _data_->_tmp19_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp21_ = NULL;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp21_ = _rygel_icon_info_ref0 (_data_->_tmp20_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_rygel_icon_info_unref0 (_data_->self->thumbnail);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->self->thumbnail = _data_->_tmp21_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_g_object_unref0 (_data_->music);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			if (_data_->_state_ == 0) {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1542 "rygel-http-get.c"
			} else {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1546 "rygel-http-get.c"
			}
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_object_unref (_data_->_async_result);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			return FALSE;
#line 1552 "rygel-http-get.c"
		} else {
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp22_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp22_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp22_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp23_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp23_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp24_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp23_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _data_->_tmp23_) : NULL);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->visual = _data_->_tmp24_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp25_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp25_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp26_ = 0;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp26_ = rygel_http_item_uri_get_thumbnail_index (_data_->_tmp25_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp27_ = 0;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp27_ = _data_->_tmp26_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp28_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp28_ = _data_->visual;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp29_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp29_ = rygel_visual_item_get_thumbnails (_data_->_tmp28_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp30_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp30_ = _data_->_tmp29_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp31_ = 0;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp31_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp30_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp32_ = 0;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp32_ = _data_->_tmp31_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				if (_data_->_tmp27_ < _data_->_tmp32_) {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp33_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp33_ = _data_->visual;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp34_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp34_ = rygel_visual_item_get_thumbnails (_data_->_tmp33_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp35_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp35_ = _data_->_tmp34_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp36_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp36_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp37_ = 0;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp37_ = rygel_http_item_uri_get_thumbnail_index (_data_->_tmp36_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp38_ = 0;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp38_ = _data_->_tmp37_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp39_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp35_, _data_->_tmp38_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_rygel_icon_info_unref0 (_data_->self->thumbnail);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_data_->self->thumbnail = (RygelThumbnail*) _data_->_tmp39_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_g_object_unref0 (_data_->visual);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					if (_data_->_state_ == 0) {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1642 "rygel-http-get.c"
					} else {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 1646 "rygel-http-get.c"
					}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					g_object_unref (_data_->_async_result);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					return FALSE;
#line 1652 "rygel-http-get.c"
				}
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_g_object_unref0 (_data_->visual);
#line 1656 "rygel-http-get.c"
			}
		}
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp40_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp40_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp41_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp41_ = rygel_media_object_get_id (_data_->_tmp40_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp42_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp42_ = _data_->_tmp41_;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp43_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp43_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No Thumbnail available for item '%s", _data_->_tmp42_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_inner_error_ = _data_->_tmp43_;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1685 "rygel-http-get.c"
		} else {
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1689 "rygel-http-get.c"
		}
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 1695 "rygel-http-get.c"
	}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp45_ = NULL;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp45_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp46_ = 0;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp46_ = rygel_http_item_uri_get_subtitle_index (_data_->_tmp45_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp47_ = 0;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp47_ = _data_->_tmp46_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp47_ >= 0) {
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp48_ = NULL;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp48_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp44_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp48_, RYGEL_TYPE_VIDEO_ITEM);
#line 1717 "rygel-http-get.c"
	} else {
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp44_ = FALSE;
#line 1721 "rygel-http-get.c"
	}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp49_ = FALSE;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp49_ = _data_->_tmp44_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp49_) {
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp50_ = NULL;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp50_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp51_ = NULL;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp50_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _data_->_tmp50_) : NULL);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->video = _data_->_tmp51_;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp52_ = NULL;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp52_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp53_ = 0;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp53_ = rygel_http_item_uri_get_subtitle_index (_data_->_tmp52_);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp54_ = 0;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp54_ = _data_->_tmp53_;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp55_ = NULL;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp55_ = _data_->video;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp56_ = NULL;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp56_ = _data_->_tmp55_->subtitles;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp57_ = 0;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp57_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp56_);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp58_ = 0;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp58_ = _data_->_tmp57_;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_tmp54_ < _data_->_tmp58_) {
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp59_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp59_ = _data_->video;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp60_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp60_ = _data_->_tmp59_->subtitles;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp61_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp61_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp62_ = 0;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp62_ = rygel_http_item_uri_get_subtitle_index (_data_->_tmp61_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp63_ = 0;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp63_ = _data_->_tmp62_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp64_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp64_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp60_, _data_->_tmp63_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_rygel_subtitle_unref0 (_data_->self->subtitle);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->self->subtitle = (RygelSubtitle*) _data_->_tmp64_;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_g_object_unref0 (_data_->video);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			if (_data_->_state_ == 0) {
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1803 "rygel-http-get.c"
			} else {
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1807 "rygel-http-get.c"
			}
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_object_unref (_data_->_async_result);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			return FALSE;
#line 1813 "rygel-http-get.c"
		}
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp65_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp65_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp66_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp66_ = rygel_media_object_get_id (_data_->_tmp65_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp67_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp67_ = _data_->_tmp66_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp68_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp68_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No subtitles available for item '%s", _data_->_tmp67_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_inner_error_ = _data_->_tmp68_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_g_object_unref0 (_data_->video);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1843 "rygel-http-get.c"
		} else {
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1847 "rygel-http-get.c"
		}
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 1853 "rygel-http-get.c"
	}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_state_ == 0) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1859 "rygel-http-get.c"
	} else {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1863 "rygel-http-get.c"
	}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_object_unref (_data_->_async_result);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	return FALSE;
#line 1869 "rygel-http-get.c"
}


static void rygel_http_get_handle_item_request_data_free (gpointer _data) {
	RygelHttpGetHandleItemRequestData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_slice_free (RygelHttpGetHandleItemRequestData, _data_);
#line 1880 "rygel-http-get.c"
}


static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* _data_;
	RygelHTTPGet* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_ = g_slice_new0 (RygelHttpGetHandleItemRequestData);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_handle_item_request);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_handle_item_request_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_get_handle_item_request_co (_data_);
#line 1899 "rygel-http-get.c"
}


static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleItemRequestData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return;
#line 1909 "rygel-http-get.c"
	}
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1913 "rygel-http-get.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	return self ? g_error_copy (self) : NULL;
#line 1920 "rygel-http-get.c"
}


static void __lambda16_ (RygelHTTPGet* self, const gchar* name, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_return_if_fail (name != NULL);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_return_if_fail (value != NULL);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp0_ = name;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp1_ = value;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_debug ("rygel-http-get.vala:186: %s : %s", _tmp0_, _tmp1_);
#line 1937 "rygel-http-get.c"
}


static void ___lambda16__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self) {
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	__lambda16_ (self, name, value);
#line 1944 "rygel-http-get.c"
}


static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* _data_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_ = _user_data_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_source_object_ = source_object;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_res_ = _res_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_get_handle_item_request_co (_data_);
#line 1958 "rygel-http-get.c"
}


static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* _data_) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	switch (_data_->_state_) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		case 0:
#line 1967 "rygel-http-get.c"
		goto _state_0;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		case 1:
#line 1971 "rygel-http-get.c"
		goto _state_1;
		default:
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_assert_not_reached ();
#line 1976 "rygel-http-get.c"
	}
	_state_0:
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp0_ = FALSE;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp0_ = rygel_http_time_seek_needed (_data_->self);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->need_time_seek = _data_->_tmp0_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp1_ = FALSE;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp1_ = rygel_http_time_seek_requested (_data_->self);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->requested_time_seek = _data_->_tmp1_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp2_ = FALSE;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp2_ = rygel_http_byte_seek_needed (_data_->self);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->need_byte_seek = _data_->_tmp2_;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp3_ = FALSE;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp3_ = rygel_http_byte_seek_requested (_data_->self);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->requested_byte_seek = _data_->_tmp3_;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp6_ = FALSE;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp6_ = _data_->requested_time_seek;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp6_) {
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp7_ = FALSE;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp7_ = _data_->need_time_seek;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp5_ = !_data_->_tmp7_;
#line 2015 "rygel-http-get.c"
	} else {
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp5_ = FALSE;
#line 2019 "rygel-http-get.c"
	}
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp8_ = FALSE;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp8_ = _data_->_tmp5_;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp8_) {
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp4_ = TRUE;
#line 2029 "rygel-http-get.c"
	} else {
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp10_ = FALSE;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp10_ = _data_->requested_byte_seek;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_tmp10_) {
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp11_ = FALSE;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp11_ = _data_->need_byte_seek;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp9_ = !_data_->_tmp11_;
#line 2043 "rygel-http-get.c"
		} else {
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp9_ = FALSE;
#line 2047 "rygel-http-get.c"
		}
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp12_ = FALSE;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp12_ = _data_->_tmp9_;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp4_ = _data_->_tmp12_;
#line 2055 "rygel-http-get.c"
	}
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp13_ = FALSE;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp13_ = _data_->_tmp4_;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp13_) {
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp14_ = NULL;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp14_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "Invalid seek request");
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_inner_error_ = _data_->_tmp14_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2077 "rygel-http-get.c"
		} else {
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2081 "rygel-http-get.c"
		}
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 2087 "rygel-http-get.c"
	}
	{
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp16_ = FALSE;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp16_ = _data_->need_time_seek;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_tmp16_) {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp17_ = FALSE;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp17_ = _data_->requested_time_seek;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp15_ = _data_->_tmp17_;
#line 2102 "rygel-http-get.c"
		} else {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp15_ = FALSE;
#line 2106 "rygel-http-get.c"
		}
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp18_ = FALSE;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp18_ = _data_->_tmp15_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_tmp18_) {
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp20_ = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp20_ = rygel_http_time_seek_new (_data_->self, &_data_->_inner_error_);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp19_ = _data_->_tmp20_;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			if (_data_->_inner_error_ != NULL) {
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 2124 "rygel-http-get.c"
					goto __catch30_rygel_http_seek_error;
				}
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				g_clear_error (&_data_->_inner_error_);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				return FALSE;
#line 2133 "rygel-http-get.c"
			}
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_g_object_unref0 (_data_->self->seek);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->self->seek = (RygelHTTPSeek*) _data_->_tmp19_;
#line 2139 "rygel-http-get.c"
		} else {
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp22_ = FALSE;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp22_ = _data_->need_byte_seek;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			if (_data_->_tmp22_) {
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp23_ = FALSE;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp23_ = _data_->requested_byte_seek;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp21_ = _data_->_tmp23_;
#line 2153 "rygel-http-get.c"
			} else {
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp21_ = FALSE;
#line 2157 "rygel-http-get.c"
			}
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp24_ = FALSE;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp24_ = _data_->_tmp21_;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			if (_data_->_tmp24_) {
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp26_ = NULL;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp26_ = rygel_http_byte_seek_new (_data_->self, &_data_->_inner_error_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp25_ = _data_->_tmp26_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				if (_data_->_inner_error_ != NULL) {
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 2175 "rygel-http-get.c"
						goto __catch30_rygel_http_seek_error;
					}
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					g_clear_error (&_data_->_inner_error_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					return FALSE;
#line 2184 "rygel-http-get.c"
				}
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_g_object_unref0 (_data_->self->seek);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->self->seek = (RygelHTTPSeek*) _data_->_tmp25_;
#line 2190 "rygel-http-get.c"
			}
		}
	}
	goto __finally30;
	__catch30_rygel_http_seek_error:
	{
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_inner_error_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp27_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp27_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp28_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp28_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		soup_server_unpause_message (_data_->_tmp27_, _data_->_tmp28_);
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp29_ = NULL;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp29_ = _data_->_error_;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (g_error_matches (_data_->_tmp29_, RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE)) {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_BAD_REQUEST);
#line 2219 "rygel-http-get.c"
		} else {
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp30_ = NULL;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_data_->_tmp30_ = _data_->_error_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			if (g_error_matches (_data_->_tmp30_, RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE)) {
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
#line 2229 "rygel-http-get.c"
			} else {
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp31_ = NULL;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp31_ = _data_->_error_;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp32_ = NULL;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_tmp32_ = _g_error_copy0 (_data_->_tmp31_);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_data_->_inner_error_ = _data_->_tmp32_;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_g_error_free0 (_data_->_error_);
#line 2243 "rygel-http-get.c"
				goto __finally30;
			}
		}
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_g_error_free0 (_data_->_error_);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2253 "rygel-http-get.c"
		} else {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2257 "rygel-http-get.c"
		}
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 2263 "rygel-http-get.c"
	}
	__finally30:
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2276 "rygel-http-get.c"
		} else {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2280 "rygel-http-get.c"
		}
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 2286 "rygel-http-get.c"
	}
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp33_ = NULL;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp33_ = _data_->self->handler;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_get_handler_add_response_headers (_data_->_tmp33_, _data_->self, &_data_->_inner_error_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2304 "rygel-http-get.c"
		} else {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2308 "rygel-http-get.c"
		}
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 2314 "rygel-http-get.c"
	}
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp34_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp34_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp35_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp35_ = _data_->_tmp34_->request_headers;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp36_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp36_ = soup_message_headers_get_one (_data_->_tmp35_, "Range");
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp36_ != NULL) {
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp37_ = NULL;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp37_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		soup_message_set_status (_data_->_tmp37_, (guint) SOUP_STATUS_PARTIAL_CONTENT);
#line 2336 "rygel-http-get.c"
	} else {
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp38_ = NULL;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp38_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		soup_message_set_status (_data_->_tmp38_, (guint) SOUP_STATUS_OK);
#line 2344 "rygel-http-get.c"
	}
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp39_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp39_ = _data_->self->handler;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp40_ = FALSE;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp40_ = rygel_http_get_handler_knows_size (_data_->_tmp39_, _data_->self);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp40_) {
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp41_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp41_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp42_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp42_ = _data_->_tmp41_->response_headers;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		soup_message_headers_set_encoding (_data_->_tmp42_, SOUP_ENCODING_CONTENT_LENGTH);
#line 2366 "rygel-http-get.c"
	} else {
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp43_ = NULL;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp43_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp44_ = NULL;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp44_ = _data_->_tmp43_->response_headers;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		soup_message_headers_set_encoding (_data_->_tmp44_, SOUP_ENCODING_EOF);
#line 2378 "rygel-http-get.c"
	}
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_debug ("rygel-http-get.vala:184: Following HTTP headers appended to response:");
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp45_ = NULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp45_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp46_ = NULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp46_ = _data_->_tmp45_->response_headers;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	soup_message_headers_foreach (_data_->_tmp46_, ___lambda16__soup_message_headers_foreach_func, _data_->self);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp47_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp47_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp48_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_object_get (_data_->_tmp47_, "method", &_data_->_tmp48_, NULL);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp49_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp49_ = _data_->_tmp48_;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp50_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp50_ = _data_->_tmp49_;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp51_ = FALSE;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp51_ = g_strcmp0 (_data_->_tmp50_, "HEAD") == 0;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_g_free0 (_data_->_tmp50_);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_tmp51_) {
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp52_ = NULL;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp52_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp53_ = NULL;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_data_->_tmp53_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		soup_server_unpause_message (_data_->_tmp52_, _data_->_tmp53_);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2430 "rygel-http-get.c"
		} else {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2434 "rygel-http-get.c"
		}
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 2440 "rygel-http-get.c"
	}
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp54_ = NULL;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp54_ = _data_->self->handler;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp55_ = NULL;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp55_ = rygel_http_get_handler_render_body (_data_->_tmp54_, _data_->self, &_data_->_inner_error_);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->response = _data_->_tmp55_;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2462 "rygel-http-get.c"
		} else {
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2466 "rygel-http-get.c"
		}
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		return FALSE;
#line 2472 "rygel-http-get.c"
	}
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp56_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_tmp56_ = _data_->response;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_data_->_state_ = 1;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp56_, rygel_http_get_handle_item_request_ready, _data_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	return FALSE;
#line 2484 "rygel-http-get.c"
	_state_1:
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp56_, _data_->_res_);
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_NONE);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_g_object_unref0 (_data_->response);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_data_->_state_ == 0) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2496 "rygel-http-get.c"
	} else {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2500 "rygel-http-get.c"
	}
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_object_unref (_data_->_async_result);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	return FALSE;
#line 2506 "rygel-http-get.c"
}


static void rygel_http_get_ensure_correct_mode (RygelHTTPGet* self, GError** error) {
	gchar* mode = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean correct = FALSE;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	static GQuark _tmp6_label0 = 0;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	static GQuark _tmp6_label1 = 0;
#line 2524 "rygel-http-get.c"
	gboolean _tmp40_ = FALSE;
	GError * _inner_error_ = NULL;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_return_if_fail (self != NULL);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp2_ = soup_message_headers_get_one (_tmp1_, RYGEL_HTTP_GET_TRANSFER_MODE_HEADER);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	mode = _tmp3_;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	correct = TRUE;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp4_ = mode;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp5_ = _tmp4_;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("Streaming")))) {
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		switch (0) {
#line 2551 "rygel-http-get.c"
			default:
			{
				gboolean _tmp8_ = FALSE;
				RygelHTTPGetHandler* _tmp9_ = NULL;
				gboolean _tmp21_ = FALSE;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_tmp9_ = self->handler;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, RYGEL_TYPE_HTTP_PLAYLIST_HANDLER)) {
#line 2561 "rygel-http-get.c"
					gboolean _tmp10_ = FALSE;
					RygelHTTPGetHandler* _tmp11_ = NULL;
					gboolean _tmp20_ = FALSE;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp11_ = self->handler;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_HTTP_TRANSCODE_HANDLER)) {
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp10_ = TRUE;
#line 2571 "rygel-http-get.c"
					} else {
						gboolean _tmp12_ = FALSE;
						gboolean _tmp13_ = FALSE;
						RygelMediaObject* _tmp14_ = NULL;
						gboolean _tmp15_ = FALSE;
						gboolean _tmp17_ = FALSE;
						gboolean _tmp19_ = FALSE;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp14_ = ((RygelHTTPRequest*) self)->object;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp15_ = rygel_media_item_streamable (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp14_) : NULL);
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						if (_tmp15_) {
#line 2585 "rygel-http-get.c"
							RygelSubtitle* _tmp16_ = NULL;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
							_tmp16_ = self->subtitle;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
							_tmp13_ = _tmp16_ == NULL;
#line 2591 "rygel-http-get.c"
						} else {
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
							_tmp13_ = FALSE;
#line 2595 "rygel-http-get.c"
						}
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp17_ = _tmp13_;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						if (_tmp17_) {
#line 2601 "rygel-http-get.c"
							RygelThumbnail* _tmp18_ = NULL;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
							_tmp18_ = self->thumbnail;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
							_tmp12_ = _tmp18_ == NULL;
#line 2607 "rygel-http-get.c"
						} else {
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
							_tmp12_ = FALSE;
#line 2611 "rygel-http-get.c"
						}
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp19_ = _tmp12_;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp10_ = _tmp19_;
#line 2617 "rygel-http-get.c"
					}
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp20_ = _tmp10_;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp8_ = _tmp20_;
#line 2623 "rygel-http-get.c"
				} else {
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp8_ = FALSE;
#line 2627 "rygel-http-get.c"
				}
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_tmp21_ = _tmp8_;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				correct = _tmp21_;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				break;
#line 2635 "rygel-http-get.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("Interactive")))) {
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		switch (0) {
#line 2641 "rygel-http-get.c"
			default:
			{
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				RygelHTTPGetHandler* _tmp24_ = NULL;
				gboolean _tmp37_ = FALSE;
				gboolean _tmp39_ = FALSE;
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_tmp24_ = self->handler;
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, RYGEL_TYPE_HTTP_IDENTITY_HANDLER)) {
#line 2653 "rygel-http-get.c"
					gboolean _tmp25_ = FALSE;
					gboolean _tmp26_ = FALSE;
					RygelMediaObject* _tmp27_ = NULL;
					gboolean _tmp28_ = FALSE;
					gboolean _tmp31_ = FALSE;
					gboolean _tmp36_ = FALSE;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp27_ = ((RygelHTTPRequest*) self)->object;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp28_ = rygel_media_item_is_live_stream (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp27_) : NULL);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					if (!_tmp28_) {
#line 2666 "rygel-http-get.c"
						RygelMediaObject* _tmp29_ = NULL;
						gboolean _tmp30_ = FALSE;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp29_ = ((RygelHTTPRequest*) self)->object;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp30_ = rygel_media_item_streamable (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp29_) : NULL);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp26_ = !_tmp30_;
#line 2675 "rygel-http-get.c"
					} else {
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp26_ = FALSE;
#line 2679 "rygel-http-get.c"
					}
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp31_ = _tmp26_;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					if (_tmp31_) {
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp25_ = TRUE;
#line 2687 "rygel-http-get.c"
					} else {
						gboolean _tmp32_ = FALSE;
						RygelSubtitle* _tmp33_ = NULL;
						gboolean _tmp35_ = FALSE;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp33_ = self->subtitle;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						if (_tmp33_ != NULL) {
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
							_tmp32_ = TRUE;
#line 2698 "rygel-http-get.c"
						} else {
							RygelThumbnail* _tmp34_ = NULL;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
							_tmp34_ = self->thumbnail;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
							_tmp32_ = _tmp34_ != NULL;
#line 2705 "rygel-http-get.c"
						}
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp35_ = _tmp32_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
						_tmp25_ = _tmp35_;
#line 2711 "rygel-http-get.c"
					}
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp36_ = _tmp25_;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp23_ = _tmp36_;
#line 2717 "rygel-http-get.c"
				} else {
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp23_ = FALSE;
#line 2721 "rygel-http-get.c"
				}
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_tmp37_ = _tmp23_;
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				if (_tmp37_) {
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp22_ = TRUE;
#line 2729 "rygel-http-get.c"
				} else {
					RygelHTTPGetHandler* _tmp38_ = NULL;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp38_ = self->handler;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
					_tmp22_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, RYGEL_TYPE_HTTP_PLAYLIST_HANDLER);
#line 2736 "rygel-http-get.c"
				}
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				_tmp39_ = _tmp22_;
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				correct = _tmp39_;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
				break;
#line 2744 "rygel-http-get.c"
			}
		}
	}
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_tmp40_ = correct;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	if (!_tmp40_) {
#line 2752 "rygel-http-get.c"
		const gchar* _tmp41_ = NULL;
		RygelMediaObject* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		GError* _tmp45_ = NULL;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_tmp41_ = mode;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_tmp42_ = ((RygelHTTPRequest*) self)->object;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_tmp43_ = rygel_media_object_get_id (_tmp42_);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_tmp44_ = _tmp43_;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_tmp45_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "%s mode not supported for '%s'", _tmp41_, _tmp44_);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		_inner_error_ = _tmp45_;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_propagate_error (error, _inner_error_);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_g_free0 (mode);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			return;
#line 2778 "rygel-http-get.c"
		} else {
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			_g_free0 (mode);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			g_clear_error (&_inner_error_);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
			return;
#line 2788 "rygel-http-get.c"
		}
	}
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_g_free0 (mode);
#line 2793 "rygel-http-get.c"
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPGetPrivate));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle = rygel_http_get_real_handle;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle_finish = rygel_http_get_real_handle_finish;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item = rygel_http_get_real_find_item;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item_finish = rygel_http_get_real_find_item_finish;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
#line 2812 "rygel-http-get.c"
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	self->priv = RYGEL_HTTP_GET_GET_PRIVATE (self);
#line 2819 "rygel-http-get.c"
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET, RygelHTTPGet);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_rygel_icon_info_unref0 (self->thumbnail);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_rygel_subtitle_unref0 (self->subtitle);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_g_object_unref0 (self->seek);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	_g_object_unref0 (self->handler);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get.vala"
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
#line 2837 "rygel-http-get.c"
}


/**
 * Responsible for handling HTTP GET & HEAD client requests.
 */
GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}



