/* rygel-mediathek-asx-playlist-parser.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-mediathek-asx-playlist-parser.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Jens Georg
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libgupnp/gupnp.h>
#include <libxml/xpath.h>


#define RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER (rygel_mediathek_playlist_parser_get_type ())
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParser))
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParserClass))
#define RYGEL_MEDIATHEK_IS_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_IS_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParserClass))

typedef struct _RygelMediathekPlaylistParser RygelMediathekPlaylistParser;
typedef struct _RygelMediathekPlaylistParserClass RygelMediathekPlaylistParserClass;
typedef struct _RygelMediathekPlaylistParserPrivate RygelMediathekPlaylistParserPrivate;

#define RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER (rygel_mediathek_asx_playlist_parser_get_type ())
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, RygelMediathekAsxPlaylistParser))
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, RygelMediathekAsxPlaylistParserClass))
#define RYGEL_MEDIATHEK_IS_ASX_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_IS_ASX_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, RygelMediathekAsxPlaylistParserClass))

typedef struct _RygelMediathekAsxPlaylistParser RygelMediathekAsxPlaylistParser;
typedef struct _RygelMediathekAsxPlaylistParserClass RygelMediathekAsxPlaylistParserClass;
typedef struct _RygelMediathekAsxPlaylistParserPrivate RygelMediathekAsxPlaylistParserPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))

typedef enum  {
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR,
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_NETWORK_ERROR
} RygelMediathekVideoItemError;
#define RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR rygel_mediathek_video_item_error_quark ()
struct _RygelMediathekPlaylistParser {
	GObject parent_instance;
	RygelMediathekPlaylistParserPrivate * priv;
};

struct _RygelMediathekPlaylistParserClass {
	GObjectClass parent_class;
	GeeList* (*parse_playlist) (RygelMediathekPlaylistParser* self, const gchar* data, gint length, GError** error);
};

struct _RygelMediathekAsxPlaylistParser {
	RygelMediathekPlaylistParser parent_instance;
	RygelMediathekAsxPlaylistParserPrivate * priv;
};

struct _RygelMediathekAsxPlaylistParserClass {
	RygelMediathekPlaylistParserClass parent_class;
};

struct _RygelMediathekAsxPlaylistParserPrivate {
	GRegex* normalizer;
};


static gpointer rygel_mediathek_asx_playlist_parser_parent_class = NULL;

GType rygel_mediathek_playlist_parser_get_type (void) G_GNUC_CONST;
GQuark rygel_mediathek_video_item_error_quark (void);
GType rygel_mediathek_asx_playlist_parser_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, RygelMediathekAsxPlaylistParserPrivate))
enum  {
	RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER_DUMMY_PROPERTY
};
RygelMediathekAsxPlaylistParser* rygel_mediathek_asx_playlist_parser_new (SoupSession* session);
RygelMediathekAsxPlaylistParser* rygel_mediathek_asx_playlist_parser_construct (GType object_type, SoupSession* session);
static GeeList* rygel_mediathek_asx_playlist_parser_real_parse_playlist (RygelMediathekPlaylistParser* base, const gchar* data, gint length, GError** error);
void xmlXPathFreeObject (xmlXPathObject* object);
static void rygel_mediathek_asx_playlist_parser_finalize (GObject* obj);


RygelMediathekAsxPlaylistParser* rygel_mediathek_asx_playlist_parser_construct (GType object_type, SoupSession* session) {
	RygelMediathekAsxPlaylistParser * self = NULL;
	SoupSession* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 39 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	g_return_val_if_fail (session != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	_tmp0_ = session;
#line 40 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	self = (RygelMediathekAsxPlaylistParser*) g_object_new (object_type, "session", _tmp0_, "playlist-suffix", ".asx", "mime-type", "video/x-ms-wmv", NULL);
#line 121 "rygel-mediathek-asx-playlist-parser.c"
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
#line 44 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp2_ = g_regex_new ("(<[/]?)([a-zA-Z:]+)", 0, 0, &_inner_error_);
#line 44 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp1_ = _tmp2_;
#line 44 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		if (_inner_error_ != NULL) {
#line 44 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 133 "rygel-mediathek-asx-playlist-parser.c"
				goto __catch0_g_regex_error;
			}
#line 44 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 44 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			g_clear_error (&_inner_error_);
#line 44 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			return NULL;
#line 142 "rygel-mediathek-asx-playlist-parser.c"
		}
#line 44 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_g_regex_unref0 (self->priv->normalizer);
#line 44 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		self->priv->normalizer = _tmp1_;
#line 148 "rygel-mediathek-asx-playlist-parser.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* _error_ = NULL;
#line 43 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_error_ = _inner_error_;
#line 43 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_inner_error_ = NULL;
#line 43 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_g_error_free0 (_error_);
#line 160 "rygel-mediathek-asx-playlist-parser.c"
	}
	__finally0:
#line 43 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	if (_inner_error_ != NULL) {
#line 43 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 43 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		g_clear_error (&_inner_error_);
#line 43 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		return NULL;
#line 171 "rygel-mediathek-asx-playlist-parser.c"
	}
#line 39 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	return self;
#line 175 "rygel-mediathek-asx-playlist-parser.c"
}


RygelMediathekAsxPlaylistParser* rygel_mediathek_asx_playlist_parser_new (SoupSession* session) {
#line 39 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	return rygel_mediathek_asx_playlist_parser_construct (RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, session);
#line 182 "rygel-mediathek-asx-playlist-parser.c"
}


/**
     * Get and parse the ASX file.
     *
     * This will fetch the ASX file using the soup session configured on
     * configure time.As ASX seems to be a bit inconsistent with regard to tag
     * case, all the tags are converted to lowercase. A XPath query is then used
     * to extract all of the href attributes for every entry in the file.
     *
     * @param uri network location of the ASX file
     * @return a list of uris found in this file
     */
static GeeList* rygel_mediathek_asx_playlist_parser_real_parse_playlist (RygelMediathekPlaylistParser* base, const gchar* data, gint length, GError** error) {
	RygelMediathekAsxPlaylistParser * self;
	GeeList* result = NULL;
	GeeArrayList* uris = NULL;
	GError * _inner_error_ = NULL;
#line 59 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	self = (RygelMediathekAsxPlaylistParser*) base;
#line 59 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	g_return_val_if_fail (data != NULL, NULL);
#line 62 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	uris = NULL;
#line 208 "rygel-mediathek-asx-playlist-parser.c"
	{
		gchar* normalized_content = NULL;
		GRegex* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gchar* _tmp3_ = NULL;
		xmlDoc* doc = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		xmlDoc* _tmp8_ = NULL;
		xmlDoc* _tmp9_ = NULL;
		GUPnPXMLDoc* doc_guard = NULL;
		xmlDoc* _tmp11_ = NULL;
		GUPnPXMLDoc* _tmp12_ = NULL;
		xmlXPathContext* context = NULL;
		GUPnPXMLDoc* _tmp13_ = NULL;
		xmlDoc* _tmp14_ = NULL;
		xmlXPathContext* _tmp15_ = NULL;
		xmlXPathObject* xpath_object = NULL;
		xmlXPathContext* _tmp16_ = NULL;
		xmlXPathObject* _tmp17_ = NULL;
		xmlXPathObject* _tmp18_ = NULL;
		xmlXPathObjectType _tmp19_ = 0;
		GeeArrayList* _tmp22_ = NULL;
		xmlXPathObject* _tmp38_ = NULL;
#line 66 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp0_ = self->priv->normalizer;
#line 66 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp1_ = data;
#line 66 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp2_ = length;
#line 66 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp3_ = g_regex_replace (_tmp0_, _tmp1_, (gssize) _tmp2_, 0, "\\1\\L\\2\\E", 0, &_inner_error_);
#line 66 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		normalized_content = _tmp3_;
#line 66 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		if (_inner_error_ != NULL) {
#line 66 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 250 "rygel-mediathek-asx-playlist-parser.c"
				goto __catch1_g_regex_error;
			}
#line 66 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_g_object_unref0 (uris);
#line 66 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 66 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			g_clear_error (&_inner_error_);
#line 66 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			return NULL;
#line 261 "rygel-mediathek-asx-playlist-parser.c"
		}
#line 72 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp4_ = normalized_content;
#line 72 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp5_ = normalized_content;
#line 72 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp6_ = strlen (_tmp5_);
#line 72 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp7_ = _tmp6_;
#line 72 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp8_ = xmlParseMemory (_tmp4_, (gint) _tmp7_);
#line 72 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		doc = _tmp8_;
#line 74 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp9_ = doc;
#line 74 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		if (_tmp9_ == NULL) {
#line 279 "rygel-mediathek-asx-playlist-parser.c"
			GError* _tmp10_ = NULL;
#line 75 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_tmp10_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "Could not parse playlist");
#line 75 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_inner_error_ = _tmp10_;
#line 75 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_g_free0 (normalized_content);
#line 75 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 289 "rygel-mediathek-asx-playlist-parser.c"
				goto __catch1_g_regex_error;
			}
			goto __finally1;
		}
#line 79 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp11_ = doc;
#line 79 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp12_ = gupnp_xml_doc_new (_tmp11_);
#line 79 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		doc_guard = _tmp12_;
#line 80 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp13_ = doc_guard;
#line 80 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp14_ = _tmp13_->doc;
#line 80 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp15_ = xmlXPathNewContext (_tmp14_);
#line 80 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		context = _tmp15_;
#line 82 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp16_ = context;
#line 82 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp17_ = xmlXPathEval ("/asx/entry/ref/@href", _tmp16_);
#line 82 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		xpath_object = _tmp17_;
#line 84 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp18_ = xpath_object;
#line 84 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp19_ = _tmp18_->type;
#line 84 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		if (_tmp19_ != XPATH_NODESET) {
#line 320 "rygel-mediathek-asx-playlist-parser.c"
			xmlXPathObject* _tmp20_ = NULL;
			GError* _tmp21_ = NULL;
#line 85 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_tmp20_ = xpath_object;
#line 85 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			xmlXPathFreeObject (_tmp20_);
#line 86 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_tmp21_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "No uris found in playlist");
#line 86 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_inner_error_ = _tmp21_;
#line 86 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_xmlXPathFreeContext0 (context);
#line 86 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_g_object_unref0 (doc_guard);
#line 86 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_g_free0 (normalized_content);
#line 86 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 339 "rygel-mediathek-asx-playlist-parser.c"
				goto __catch1_g_regex_error;
			}
			goto __finally1;
		}
#line 90 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp22_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_g_object_unref0 (uris);
#line 90 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		uris = _tmp22_;
#line 350 "rygel-mediathek-asx-playlist-parser.c"
		{
			gint i = 0;
#line 91 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			i = 0;
#line 355 "rygel-mediathek-asx-playlist-parser.c"
			{
				gboolean _tmp23_ = FALSE;
#line 91 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
				_tmp23_ = TRUE;
#line 91 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
				while (TRUE) {
#line 362 "rygel-mediathek-asx-playlist-parser.c"
					gboolean _tmp24_ = FALSE;
					gint _tmp26_ = 0;
					xmlXPathObject* _tmp27_ = NULL;
					xmlNodeSet* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					xmlNode* item = NULL;
					xmlXPathObject* _tmp30_ = NULL;
					xmlNodeSet* _tmp31_ = NULL;
					gint _tmp32_ = 0;
					xmlNode* _tmp33_ = NULL;
					GeeArrayList* _tmp34_ = NULL;
					xmlNode* _tmp35_ = NULL;
					xmlNode* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
#line 91 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp24_ = _tmp23_;
#line 91 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					if (!_tmp24_) {
#line 381 "rygel-mediathek-asx-playlist-parser.c"
						gint _tmp25_ = 0;
#line 93 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
						_tmp25_ = i;
#line 93 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
						i = _tmp25_ + 1;
#line 387 "rygel-mediathek-asx-playlist-parser.c"
					}
#line 91 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp23_ = FALSE;
#line 92 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp26_ = i;
#line 92 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp27_ = xpath_object;
#line 92 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp28_ = _tmp27_->nodesetval;
#line 92 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp29_ = xmlXPathNodeSetGetLength (_tmp28_);
#line 92 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					if (!(_tmp26_ < _tmp29_)) {
#line 92 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
						break;
#line 403 "rygel-mediathek-asx-playlist-parser.c"
					}
#line 94 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp30_ = xpath_object;
#line 94 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp31_ = _tmp30_->nodesetval;
#line 94 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp32_ = i;
#line 94 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp33_ = xmlXPathNodeSetItem (_tmp31_, _tmp32_);
#line 94 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					item = _tmp33_;
#line 95 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp34_ = uris;
#line 95 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp35_ = item;
#line 95 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp36_ = _tmp35_->children;
#line 95 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					_tmp37_ = _tmp36_->content;
#line 95 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp37_);
#line 425 "rygel-mediathek-asx-playlist-parser.c"
				}
			}
		}
#line 98 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp38_ = xpath_object;
#line 98 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		xmlXPathFreeObject (_tmp38_);
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_xmlXPathFreeContext0 (context);
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_g_object_unref0 (doc_guard);
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_g_free0 (normalized_content);
#line 439 "rygel-mediathek-asx-playlist-parser.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* _error_ = NULL;
		GError* _tmp39_ = NULL;
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_error_ = _inner_error_;
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_inner_error_ = NULL;
#line 100 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_tmp39_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "Failed to normalize");
#line 100 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_inner_error_ = _tmp39_;
#line 100 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		_g_error_free0 (_error_);
#line 456 "rygel-mediathek-asx-playlist-parser.c"
		goto __finally1;
	}
	__finally1:
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	if (_inner_error_ != NULL) {
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			g_propagate_error (error, _inner_error_);
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_g_object_unref0 (uris);
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			return NULL;
#line 470 "rygel-mediathek-asx-playlist-parser.c"
		} else {
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			_g_object_unref0 (uris);
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			g_clear_error (&_inner_error_);
#line 64 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
			return NULL;
#line 480 "rygel-mediathek-asx-playlist-parser.c"
		}
	}
#line 103 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	result = (GeeList*) uris;
#line 103 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	return result;
#line 487 "rygel-mediathek-asx-playlist-parser.c"
}


static void rygel_mediathek_asx_playlist_parser_class_init (RygelMediathekAsxPlaylistParserClass * klass) {
#line 36 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	rygel_mediathek_asx_playlist_parser_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	g_type_class_add_private (klass, sizeof (RygelMediathekAsxPlaylistParserPrivate));
#line 36 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	RYGEL_MEDIATHEK_PLAYLIST_PARSER_CLASS (klass)->parse_playlist = rygel_mediathek_asx_playlist_parser_real_parse_playlist;
#line 36 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_mediathek_asx_playlist_parser_finalize;
#line 500 "rygel-mediathek-asx-playlist-parser.c"
}


static void rygel_mediathek_asx_playlist_parser_instance_init (RygelMediathekAsxPlaylistParser * self) {
#line 36 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	self->priv = RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER_GET_PRIVATE (self);
#line 507 "rygel-mediathek-asx-playlist-parser.c"
}


static void rygel_mediathek_asx_playlist_parser_finalize (GObject* obj) {
	RygelMediathekAsxPlaylistParser * self;
#line 36 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, RygelMediathekAsxPlaylistParser);
#line 37 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	_g_regex_unref0 (self->priv->normalizer);
#line 36 "/home/jens/Source/rygel/src/plugins/mediathek/rygel-mediathek-asx-playlist-parser.vala"
	G_OBJECT_CLASS (rygel_mediathek_asx_playlist_parser_parent_class)->finalize (obj);
#line 519 "rygel-mediathek-asx-playlist-parser.c"
}


/**
 * This class is a simple ASX playlist parser
 *
 * It does nothing but extracting all href tags from an ASX
 * and ignore all of the other information that may be in it
 *
 * This parser is //only// intended to work with the simple
 * ASX files presented by the ZDF Mediathek streaming server
 */
GType rygel_mediathek_asx_playlist_parser_get_type (void) {
	static volatile gsize rygel_mediathek_asx_playlist_parser_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mediathek_asx_playlist_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediathekAsxPlaylistParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mediathek_asx_playlist_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediathekAsxPlaylistParser), 0, (GInstanceInitFunc) rygel_mediathek_asx_playlist_parser_instance_init, NULL };
		GType rygel_mediathek_asx_playlist_parser_type_id;
		rygel_mediathek_asx_playlist_parser_type_id = g_type_register_static (RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, "RygelMediathekAsxPlaylistParser", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mediathek_asx_playlist_parser_type_id__volatile, rygel_mediathek_asx_playlist_parser_type_id);
	}
	return rygel_mediathek_asx_playlist_parser_type_id__volatile;
}



