/* rygel-cmdline-config.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-cmdline-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gee.h>


#define RYGEL_TYPE_CMDLINE_CONFIG (rygel_cmdline_config_get_type ())
#define RYGEL_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig))
#define RYGEL_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))
#define RYGEL_IS_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_IS_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_CMDLINE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))

typedef struct _RygelCmdlineConfig RygelCmdlineConfig;
typedef struct _RygelCmdlineConfigClass RygelCmdlineConfigClass;
typedef struct _RygelCmdlineConfigPrivate RygelCmdlineConfigPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

typedef enum  {
	RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY
} RygelCmdlineConfigError;
#define RYGEL_CMDLINE_CONFIG_ERROR rygel_cmdline_config_error_quark ()
struct _RygelCmdlineConfig {
	GObject parent_instance;
	RygelCmdlineConfigPrivate * priv;
};

struct _RygelCmdlineConfigClass {
	GObjectClass parent_class;
};


static gpointer rygel_cmdline_config_parent_class = NULL;
static gchar** rygel_cmdline_config_ifaces;
static gchar** rygel_cmdline_config_ifaces = NULL;
static gint rygel_cmdline_config_port;
static gint rygel_cmdline_config_port = 0;
static gboolean rygel_cmdline_config_no_upnp;
static gboolean rygel_cmdline_config_no_upnp = FALSE;
static gboolean rygel_cmdline_config_no_transcoding;
static gboolean rygel_cmdline_config_no_transcoding = FALSE;
static gboolean rygel_cmdline_config_disallow_upload;
static gboolean rygel_cmdline_config_disallow_upload = FALSE;
static gboolean rygel_cmdline_config_disallow_deletion;
static gboolean rygel_cmdline_config_disallow_deletion = FALSE;
static gchar* rygel_cmdline_config_log_levels;
static gchar* rygel_cmdline_config_log_levels = NULL;
static gchar* rygel_cmdline_config_plugin_path;
static gchar* rygel_cmdline_config_plugin_path = NULL;
static gchar* rygel_cmdline_config_engine_path;
static gchar* rygel_cmdline_config_engine_path = NULL;
static gboolean rygel_cmdline_config_version;
static gboolean rygel_cmdline_config_version = FALSE;
static gchar* rygel_cmdline_config_config_file;
static gchar* rygel_cmdline_config_config_file = NULL;
static gboolean rygel_cmdline_config_shutdown;
static gboolean rygel_cmdline_config_shutdown = FALSE;
static gchar** rygel_cmdline_config_disabled_plugins;
static gchar** rygel_cmdline_config_disabled_plugins = NULL;
static gchar** rygel_cmdline_config_plugin_titles;
static gchar** rygel_cmdline_config_plugin_titles = NULL;
static gchar** rygel_cmdline_config_plugin_options;
static gchar** rygel_cmdline_config_plugin_options = NULL;
static RygelCmdlineConfig* rygel_cmdline_config_config;
static RygelCmdlineConfig* rygel_cmdline_config_config = NULL;
static RygelConfigurationIface* rygel_cmdline_config_rygel_configuration_parent_iface = NULL;

GQuark rygel_cmdline_config_error_quark (void);
GType rygel_cmdline_config_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CMDLINE_CONFIG_DUMMY_PROPERTY
};
RygelCmdlineConfig* rygel_cmdline_config_get_default (void);
RygelCmdlineConfig* rygel_cmdline_config_new (void);
RygelCmdlineConfig* rygel_cmdline_config_construct (GType object_type);
void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error);
static gboolean rygel_cmdline_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_interface (RygelConfiguration* base, GError** error);
static gchar** rygel_cmdline_config_real_get_interfaces (RygelConfiguration* base, GError** error);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gint rygel_cmdline_config_real_get_port (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_transcoding (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_allow_upload (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_allow_deletion (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_log_levels (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_engine_path (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_media_engine (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_cmdline_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error);
gchar* rygel_cmdline_config_get_config_file (RygelCmdlineConfig* self, GError** error);
static gchar* rygel_cmdline_config_real_get_video_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_music_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_picture_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static GeeArrayList* rygel_cmdline_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gint rygel_cmdline_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_cmdline_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gboolean rygel_cmdline_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static void rygel_cmdline_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry RYGEL_CMDLINE_CONFIG_OPTIONS[16] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_version, "Display version number", NULL}, {"network-interface", 'n', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_ifaces, "Network Interfaces", "INTERFACE"}, {"port", 'p', 0, G_OPTION_ARG_INT, &rygel_cmdline_config_port, "Port", "PORT"}, {"disable-transcoding", 't', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_transcoding, "Disable transcoding", NULL}, {"disallow-upload", 'U', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_disallow_upload, "Disallow upload", NULL}, {"disallow-deletion", 'D', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_disallow_deletion, "Disallow deletion", NULL}, {"log-level", 'g', 0, G_OPTION_ARG_STRING, &rygel_cmdline_config_log_levels, "Comma-separated list of domain:level pairs. See rygel(1) for details"}, {"plugin-path", 'u', 0, G_OPTION_ARG_STRING, &rygel_cmdline_config_plugin_path, "Plugin Path", "PLUGIN_PATH"}, {"engine-path", 'e', 0, G_OPTION_ARG_STRING, &rygel_cmdline_config_engine_path, "Engine Path", "ENGINE_PATH"}, {"disable-plugin", 'd', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_disabled_plugins, "Disable plugin", "PluginName"}, {"title", 'i', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_plugin_titles, "Set plugin titles", "PluginName:TITLE"}, {"plugin-option", 'o', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_plugin_options, "Set plugin options", "PluginName:OPTION:VALUE1[,VALUE2,..]"}, {"disable-upnp", 'P', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_upnp, "Disable UPnP (streaming-only)", NULL}, {"config", 'c', 0, G_OPTION_ARG_FILENAME, &rygel_cmdline_config_config_file, "Use configuration file instead of user configuration", "FILE"}, {"shutdown", 's', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_shutdown, "Shutdown remote Rygel reference", NULL}, {NULL}};

GQuark rygel_cmdline_config_error_quark (void) {
	return g_quark_from_static_string ("rygel_cmdline_config_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return self ? g_object_ref (self) : NULL;
#line 154 "rygel-cmdline-config.c"
}


RygelCmdlineConfig* rygel_cmdline_config_get_default (void) {
	RygelCmdlineConfig* result = NULL;
	RygelCmdlineConfig* _tmp0_ = NULL;
	RygelCmdlineConfig* _tmp2_ = NULL;
	RygelCmdlineConfig* _tmp3_ = NULL;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_config;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp0_ == NULL) {
#line 167 "rygel-cmdline-config.c"
		RygelCmdlineConfig* _tmp1_ = NULL;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = rygel_cmdline_config_new ();
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_g_object_unref0 (rygel_cmdline_config_config);
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		rygel_cmdline_config_config = _tmp1_;
#line 175 "rygel-cmdline-config.c"
	}
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp2_ = rygel_cmdline_config_config;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	result = _tmp3_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 185 "rygel-cmdline-config.c"
}


void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error) {
	gchar* parameter_string = NULL;
	gchar* _tmp0_ = NULL;
	GOptionContext* opt_context = NULL;
	const gchar* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionContext* _tmp4_ = NULL;
	GOptionContext* _tmp5_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GError * _inner_error_ = NULL;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = g_strdup ("- " PACKAGE_NAME);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	parameter_string = _tmp0_;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp1_ = parameter_string;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp2_ = g_option_context_new (_tmp1_);
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	opt_context = _tmp2_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp3_ = opt_context;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_option_context_set_help_enabled (_tmp3_, TRUE);
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp4_ = opt_context;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_option_context_set_ignore_unknown_options (_tmp4_, TRUE);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp5_ = opt_context;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_option_context_add_main_entries (_tmp5_, RYGEL_CMDLINE_CONFIG_OPTIONS, NULL);
#line 223 "rygel-cmdline-config.c"
	{
		GOptionContext* _tmp6_ = NULL;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp6_ = opt_context;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_option_context_parse (_tmp6_, args_length1, args, &_inner_error_);
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		if (_inner_error_ != NULL) {
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			if (g_error_matches (_inner_error_, G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE)) {
#line 234 "rygel-cmdline-config.c"
				goto __catch12_g_option_error_bad_value;
			}
			goto __finally12;
		}
	}
	goto __finally12;
	__catch12_g_option_error_bad_value:
	{
		GError* err = NULL;
		FILE* _tmp7_ = NULL;
		GOptionContext* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		err = _inner_error_;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = NULL;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp7_ = stdout;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp8_ = opt_context;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp9_ = g_option_context_get_help (_tmp8_, TRUE, NULL);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp10_ = _tmp9_;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		fprintf (_tmp7_, "%s", _tmp10_);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_g_free0 (_tmp10_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp11_ = g_error_new_literal (RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY, "");
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp11_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_g_error_free0 (err);
#line 271 "rygel-cmdline-config.c"
		goto __finally12;
	}
	__finally12:
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_inner_error_ != NULL) {
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			g_propagate_error (error, _inner_error_);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_option_context_free0 (opt_context);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_free0 (parameter_string);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			return;
#line 287 "rygel-cmdline-config.c"
		} else {
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_option_context_free0 (opt_context);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_free0 (parameter_string);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			g_clear_error (&_inner_error_);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			return;
#line 299 "rygel-cmdline-config.c"
		}
	}
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp12_ = rygel_cmdline_config_version;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp12_) {
#line 306 "rygel-cmdline-config.c"
		FILE* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp13_ = stdout;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		fprintf (_tmp13_, "%s\n", PACKAGE_STRING);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp14_ = g_error_new_literal (RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY, "");
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp14_;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			g_propagate_error (error, _inner_error_);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_option_context_free0 (opt_context);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_free0 (parameter_string);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			return;
#line 327 "rygel-cmdline-config.c"
		} else {
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_option_context_free0 (opt_context);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_free0 (parameter_string);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			g_clear_error (&_inner_error_);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			return;
#line 339 "rygel-cmdline-config.c"
		}
	}
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp15_ = rygel_cmdline_config_shutdown;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp15_) {
#line 346 "rygel-cmdline-config.c"
		GError* _tmp22_ = NULL;
		{
			const gchar* _tmp16_ = NULL;
			RygelDBusInterface* rygel = NULL;
			RygelDBusInterface* _tmp17_ = NULL;
			RygelDBusInterface* _tmp18_ = NULL;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp16_ = _ ("Shutting down remote Rygel instance\n");
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			g_print ("%s", _tmp16_);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp17_ = g_initable_new (RYGEL_TYPE_DBUS_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_DBUS_INTERFACE_SERVICE_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_DBUS_INTERFACE_OBJECT_PATH, "g-interface-name", "org.gnome.Rygel1", NULL);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			rygel = (RygelDBusInterface*) _tmp17_;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			if (_inner_error_ != NULL) {
#line 363 "rygel-cmdline-config.c"
				goto __catch13_g_error;
			}
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp18_ = rygel;
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			rygel_dbus_interface_shutdown (_tmp18_, &_inner_error_);
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			if (_inner_error_ != NULL) {
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_object_unref0 (rygel);
#line 374 "rygel-cmdline-config.c"
				goto __catch13_g_error;
			}
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_object_unref0 (rygel);
#line 379 "rygel-cmdline-config.c"
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp19_ = NULL;
			GError* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_error_ = _inner_error_;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_inner_error_ = NULL;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp19_ = _ ("Failed to shut-down other rygel instance: %s");
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp20_ = _error_;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp21_ = _tmp20_->message;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			g_warning (_tmp19_, _tmp21_);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_error_free0 (_error_);
#line 402 "rygel-cmdline-config.c"
		}
		__finally13:
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		if (_inner_error_ != NULL) {
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				g_propagate_error (error, _inner_error_);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_option_context_free0 (opt_context);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_free0 (parameter_string);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				return;
#line 417 "rygel-cmdline-config.c"
			} else {
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_option_context_free0 (opt_context);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_free0 (parameter_string);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				g_clear_error (&_inner_error_);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				return;
#line 429 "rygel-cmdline-config.c"
			}
		}
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp22_ = g_error_new_literal (RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY, "");
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp22_;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			g_propagate_error (error, _inner_error_);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_option_context_free0 (opt_context);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_free0 (parameter_string);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			return;
#line 446 "rygel-cmdline-config.c"
		} else {
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_option_context_free0 (opt_context);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_g_free0 (parameter_string);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			g_clear_error (&_inner_error_);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			return;
#line 458 "rygel-cmdline-config.c"
		}
	}
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_g_option_context_free0 (opt_context);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_g_free0 (parameter_string);
#line 465 "rygel-cmdline-config.c"
}


static gboolean rygel_cmdline_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_no_upnp;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (!_tmp0_) {
#line 480 "rygel-cmdline-config.c"
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = _ ("No value available");
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp2_;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return FALSE;
#line 493 "rygel-cmdline-config.c"
	} else {
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result = FALSE;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return result;
#line 499 "rygel-cmdline-config.c"
	}
}


static gchar* rygel_cmdline_config_real_get_interface (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_ifaces;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_ifaces);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp0_ == NULL) {
#line 522 "rygel-cmdline-config.c"
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = _ ("No value available");
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp2_;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return NULL;
#line 535 "rygel-cmdline-config.c"
	}
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp3_ = rygel_cmdline_config_ifaces;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp3__length1 = _vala_array_length (rygel_cmdline_config_ifaces);
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp4_ = _tmp3_[0];
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	result = _tmp5_;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 549 "rygel-cmdline-config.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	result = g_new0 (gchar*, length + 1);
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	for (i = 0; i < length; i++) {
#line 560 "rygel-cmdline-config.c"
		gchar* _tmp0_ = NULL;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp0_ = g_strdup (self[i]);
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result[i] = _tmp0_;
#line 566 "rygel-cmdline-config.c"
	}
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 570 "rygel-cmdline-config.c"
}


static gchar** rygel_cmdline_config_real_get_interfaces (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GError * _inner_error_ = NULL;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_ifaces;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_ifaces);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp0_ == NULL) {
#line 592 "rygel-cmdline-config.c"
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = _ ("No value available");
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp2_;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return NULL;
#line 605 "rygel-cmdline-config.c"
	}
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp3_ = rygel_cmdline_config_ifaces;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp3__length1 = _vala_array_length (rygel_cmdline_config_ifaces);
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp4__length1 = _tmp3__length1;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	result = _tmp4_;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 619 "rygel-cmdline-config.c"
}


static gint rygel_cmdline_config_real_get_port (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 183 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_port;
#line 183 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp0_ <= 0) {
#line 635 "rygel-cmdline-config.c"
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = _ ("No value available");
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp2_;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return 0;
#line 648 "rygel-cmdline-config.c"
	}
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp3_ = rygel_cmdline_config_port;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	result = _tmp3_;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 656 "rygel-cmdline-config.c"
}


static gboolean rygel_cmdline_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_no_transcoding;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (!_tmp0_) {
#line 671 "rygel-cmdline-config.c"
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = _ ("No value available");
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp2_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return FALSE;
#line 684 "rygel-cmdline-config.c"
	} else {
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result = FALSE;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return result;
#line 690 "rygel-cmdline-config.c"
	}
}


static gboolean rygel_cmdline_config_real_get_allow_upload (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 199 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_disallow_upload;
#line 199 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (!_tmp0_) {
#line 706 "rygel-cmdline-config.c"
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = _ ("No value available");
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp2_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return FALSE;
#line 719 "rygel-cmdline-config.c"
	} else {
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result = FALSE;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return result;
#line 725 "rygel-cmdline-config.c"
	}
}


static gboolean rygel_cmdline_config_real_get_allow_deletion (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_disallow_deletion;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (!_tmp0_) {
#line 741 "rygel-cmdline-config.c"
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = _ ("No value available");
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp2_;
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return FALSE;
#line 754 "rygel-cmdline-config.c"
	} else {
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result = FALSE;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return result;
#line 760 "rygel-cmdline-config.c"
	}
}


static gchar* rygel_cmdline_config_real_get_log_levels (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_log_levels;
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp0_ == NULL) {
#line 778 "rygel-cmdline-config.c"
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = _ ("No value available");
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp2_;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return NULL;
#line 791 "rygel-cmdline-config.c"
	}
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp3_ = rygel_cmdline_config_log_levels;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	result = _tmp4_;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 801 "rygel-cmdline-config.c"
}


static gchar* rygel_cmdline_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_plugin_path;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp0_ == NULL) {
#line 818 "rygel-cmdline-config.c"
		GError* _tmp1_ = NULL;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp1_;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return NULL;
#line 828 "rygel-cmdline-config.c"
	}
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp2_ = rygel_cmdline_config_plugin_path;
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	result = _tmp3_;
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 838 "rygel-cmdline-config.c"
}


static gchar* rygel_cmdline_config_real_get_engine_path (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_engine_path;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp0_ == NULL) {
#line 855 "rygel-cmdline-config.c"
		GError* _tmp1_ = NULL;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp1_;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return NULL;
#line 865 "rygel-cmdline-config.c"
	}
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp2_ = rygel_cmdline_config_plugin_path;
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	result = _tmp3_;
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 875 "rygel-cmdline-config.c"
}


static gchar* rygel_cmdline_config_real_get_media_engine (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	GError* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_inner_error_ = _tmp0_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_propagate_error (error, _inner_error_);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return NULL;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 896 "rygel-cmdline-config.c"
}


static gboolean rygel_cmdline_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean disabled = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
#line 243 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 243 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	disabled = FALSE;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_disabled_plugins;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_disabled_plugins);
#line 918 "rygel-cmdline-config.c"
	{
		gchar** plugin_collection = NULL;
		gint plugin_collection_length1 = 0;
		gint _plugin_collection_size_ = 0;
		gint plugin_it = 0;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		plugin_collection = _tmp0_;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		plugin_collection_length1 = _tmp0__length1;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		for (plugin_it = 0; plugin_it < _tmp0__length1; plugin_it = plugin_it + 1) {
#line 930 "rygel-cmdline-config.c"
			gchar* _tmp1_ = NULL;
			gchar* plugin = NULL;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp1_ = g_strdup (plugin_collection[plugin_it]);
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			plugin = _tmp1_;
#line 937 "rygel-cmdline-config.c"
			{
				const gchar* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
#line 246 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp2_ = plugin;
#line 246 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp3_ = section;
#line 246 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
#line 247 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					disabled = TRUE;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_g_free0 (plugin);
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					break;
#line 953 "rygel-cmdline-config.c"
				}
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_free0 (plugin);
#line 957 "rygel-cmdline-config.c"
			}
		}
	}
#line 252 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp4_ = disabled;
#line 252 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp4_) {
#line 253 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result = FALSE;
#line 253 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return result;
#line 969 "rygel-cmdline-config.c"
	} else {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp5_ = _ ("No value available");
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp6_;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return FALSE;
#line 983 "rygel-cmdline-config.c"
	}
}


static gchar* rygel_cmdline_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	gchar* title = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	title = NULL;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_plugin_titles;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_titles);
#line 1006 "rygel-cmdline-config.c"
	{
		gchar** plugin_title_collection = NULL;
		gint plugin_title_collection_length1 = 0;
		gint _plugin_title_collection_size_ = 0;
		gint plugin_title_it = 0;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		plugin_title_collection = _tmp0_;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		plugin_title_collection_length1 = _tmp0__length1;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		for (plugin_title_it = 0; plugin_title_it < _tmp0__length1; plugin_title_it = plugin_title_it + 1) {
#line 1018 "rygel-cmdline-config.c"
			gchar* _tmp1_ = NULL;
			gchar* plugin_title = NULL;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp1_ = g_strdup (plugin_title_collection[plugin_title_it]);
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			plugin_title = _tmp1_;
#line 1025 "rygel-cmdline-config.c"
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				const gchar* _tmp8_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp15_ = FALSE;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp2_ = plugin_title;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 2);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = _tmp4_;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens_length1 = _vala_array_length (_tmp3_);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tokens_size_ = tokens_length1;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp7_ = tokens;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp7__length1 = tokens_length1;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp8_ = _tmp7_[0];
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp8_ != NULL) {
#line 1058 "rygel-cmdline-config.c"
					gchar** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					const gchar* _tmp10_ = NULL;
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp9_ = tokens;
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp9__length1 = tokens_length1;
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp10_ = _tmp9_[1];
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = _tmp10_ != NULL;
#line 1070 "rygel-cmdline-config.c"
				} else {
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = FALSE;
#line 1074 "rygel-cmdline-config.c"
				}
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp11_ = _tmp6_;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp11_) {
#line 1080 "rygel-cmdline-config.c"
					gchar** _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					const gchar* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp12_ = tokens;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp12__length1 = tokens_length1;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp13_ = _tmp12_[0];
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp14_ = section;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = g_strcmp0 (_tmp13_, _tmp14_) == 0;
#line 1095 "rygel-cmdline-config.c"
				} else {
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = FALSE;
#line 1099 "rygel-cmdline-config.c"
				}
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp15_ = _tmp5_;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp15_) {
#line 1105 "rygel-cmdline-config.c"
					gchar** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					const gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp16_ = tokens;
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp16__length1 = tokens_length1;
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp17_ = _tmp16_[1];
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp18_ = g_strdup (_tmp17_);
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_g_free0 (title);
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					title = _tmp18_;
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_g_free0 (plugin_title);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					break;
#line 1128 "rygel-cmdline-config.c"
				}
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_free0 (plugin_title);
#line 1134 "rygel-cmdline-config.c"
			}
		}
	}
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp19_ = title;
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp19_ != NULL) {
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result = title;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return result;
#line 1146 "rygel-cmdline-config.c"
	} else {
		const gchar* _tmp20_ = NULL;
		GError* _tmp21_ = NULL;
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp20_ = _ ("No value available");
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp21_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp20_);
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp21_;
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_g_free0 (title);
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return NULL;
#line 1162 "rygel-cmdline-config.c"
	}
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_g_free0 (title);
#line 1166 "rygel-cmdline-config.c"
}


gchar* rygel_cmdline_config_get_config_file (RygelCmdlineConfig* self, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_config_file;
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp0_ == NULL) {
#line 1182 "rygel-cmdline-config.c"
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp1_ = _ ("No value available");
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp2_;
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return NULL;
#line 1195 "rygel-cmdline-config.c"
	}
#line 283 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp3_ = rygel_cmdline_config_config_file;
#line 283 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 283 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	result = _tmp4_;
#line 283 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 1205 "rygel-cmdline-config.c"
}


static gchar* rygel_cmdline_config_real_get_video_upload_folder (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GError* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = _ ("No value available");
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_inner_error_ = _tmp1_;
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_propagate_error (error, _inner_error_);
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return NULL;
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 1229 "rygel-cmdline-config.c"
}


static gchar* rygel_cmdline_config_real_get_music_upload_folder (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GError* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 290 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = _ ("No value available");
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_inner_error_ = _tmp1_;
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_propagate_error (error, _inner_error_);
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return NULL;
#line 290 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 1253 "rygel-cmdline-config.c"
}


static gchar* rygel_cmdline_config_real_get_picture_upload_folder (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GError* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 294 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = _ ("No value available");
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_inner_error_ = _tmp1_;
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_propagate_error (error, _inner_error_);
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return NULL;
#line 294 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return result;
#line 1277 "rygel-cmdline-config.c"
}


static gchar* rygel_cmdline_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	gchar* value = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 300 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 300 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 300 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 302 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	value = NULL;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_plugin_options;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
#line 1301 "rygel-cmdline-config.c"
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		option_collection = _tmp0_;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		option_collection_length1 = _tmp0__length1;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		for (option_it = 0; option_it < _tmp0__length1; option_it = option_it + 1) {
#line 1313 "rygel-cmdline-config.c"
			gchar* _tmp1_ = NULL;
			gchar* option = NULL;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp1_ = g_strdup (option_collection[option_it]);
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			option = _tmp1_;
#line 1320 "rygel-cmdline-config.c"
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp24_ = FALSE;
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp2_ = option;
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 3);
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = _tmp4_;
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens_length1 = _vala_array_length (_tmp3_);
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tokens_size_ = tokens_length1;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp9_ = tokens;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp9__length1 = tokens_length1;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp10_ = _tmp9_[0];
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp10_ != NULL) {
#line 1357 "rygel-cmdline-config.c"
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp11_ = tokens;
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp11__length1 = tokens_length1;
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp12_ = _tmp11_[1];
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp8_ = _tmp12_ != NULL;
#line 1369 "rygel-cmdline-config.c"
				} else {
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp8_ = FALSE;
#line 1373 "rygel-cmdline-config.c"
				}
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp13_ = _tmp8_;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp13_) {
#line 1379 "rygel-cmdline-config.c"
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					const gchar* _tmp15_ = NULL;
#line 307 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp14_ = tokens;
#line 307 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp14__length1 = tokens_length1;
#line 307 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp15_ = _tmp14_[2];
#line 307 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp7_ = _tmp15_ != NULL;
#line 1391 "rygel-cmdline-config.c"
				} else {
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp7_ = FALSE;
#line 1395 "rygel-cmdline-config.c"
				}
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp16_ = _tmp7_;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp16_) {
#line 1401 "rygel-cmdline-config.c"
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
#line 308 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp17_ = tokens;
#line 308 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp17__length1 = tokens_length1;
#line 308 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp18_ = _tmp17_[0];
#line 308 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp19_ = section;
#line 308 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = g_strcmp0 (_tmp18_, _tmp19_) == 0;
#line 1416 "rygel-cmdline-config.c"
				} else {
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = FALSE;
#line 1420 "rygel-cmdline-config.c"
				}
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp20_ = _tmp6_;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp20_) {
#line 1426 "rygel-cmdline-config.c"
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
#line 309 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp21_ = tokens;
#line 309 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp21__length1 = tokens_length1;
#line 309 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp22_ = _tmp21_[1];
#line 309 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp23_ = key;
#line 309 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = g_strcmp0 (_tmp22_, _tmp23_) == 0;
#line 1441 "rygel-cmdline-config.c"
				} else {
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = FALSE;
#line 1445 "rygel-cmdline-config.c"
				}
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp24_ = _tmp5_;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp24_) {
#line 1451 "rygel-cmdline-config.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					const gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp25_ = tokens;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp25__length1 = tokens_length1;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp26_ = _tmp25_[2];
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp27_ = g_strdup (_tmp26_);
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_g_free0 (value);
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					value = _tmp27_;
#line 311 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 311 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_g_free0 (option);
#line 311 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					break;
#line 1474 "rygel-cmdline-config.c"
				}
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_free0 (option);
#line 1480 "rygel-cmdline-config.c"
			}
		}
	}
#line 315 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp28_ = value;
#line 315 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp28_ != NULL) {
#line 316 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result = value;
#line 316 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return result;
#line 1492 "rygel-cmdline-config.c"
	} else {
		const gchar* _tmp29_ = NULL;
		GError* _tmp30_ = NULL;
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp29_ = _ ("No value available");
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp30_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp29_);
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp30_;
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_g_free0 (value);
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return NULL;
#line 1508 "rygel-cmdline-config.c"
	}
#line 300 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_g_free0 (value);
#line 1512 "rygel-cmdline-config.c"
}


static GeeArrayList* rygel_cmdline_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* value = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GeeArrayList* _tmp33_ = NULL;
	GError * _inner_error_ = NULL;
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	value = NULL;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_plugin_options;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
#line 1536 "rygel-cmdline-config.c"
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		option_collection = _tmp0_;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		option_collection_length1 = _tmp0__length1;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		for (option_it = 0; option_it < _tmp0__length1; option_it = option_it + 1) {
#line 1548 "rygel-cmdline-config.c"
			gchar* _tmp1_ = NULL;
			gchar* option = NULL;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp1_ = g_strdup (option_collection[option_it]);
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			option = _tmp1_;
#line 1555 "rygel-cmdline-config.c"
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp24_ = FALSE;
#line 327 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp2_ = option;
#line 327 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 3);
#line 327 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = _tmp4_;
#line 327 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens_length1 = _vala_array_length (_tmp3_);
#line 327 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tokens_size_ = tokens_length1;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp9_ = tokens;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp9__length1 = tokens_length1;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp10_ = _tmp9_[0];
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp10_ != NULL) {
#line 1592 "rygel-cmdline-config.c"
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp11_ = tokens;
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp11__length1 = tokens_length1;
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp12_ = _tmp11_[1];
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp8_ = _tmp12_ != NULL;
#line 1604 "rygel-cmdline-config.c"
				} else {
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp8_ = FALSE;
#line 1608 "rygel-cmdline-config.c"
				}
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp13_ = _tmp8_;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp13_) {
#line 1614 "rygel-cmdline-config.c"
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					const gchar* _tmp15_ = NULL;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp14_ = tokens;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp14__length1 = tokens_length1;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp15_ = _tmp14_[2];
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp7_ = _tmp15_ != NULL;
#line 1626 "rygel-cmdline-config.c"
				} else {
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp7_ = FALSE;
#line 1630 "rygel-cmdline-config.c"
				}
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp16_ = _tmp7_;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp16_) {
#line 1636 "rygel-cmdline-config.c"
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp17_ = tokens;
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp17__length1 = tokens_length1;
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp18_ = _tmp17_[0];
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp19_ = section;
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = g_strcmp0 (_tmp18_, _tmp19_) == 0;
#line 1651 "rygel-cmdline-config.c"
				} else {
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = FALSE;
#line 1655 "rygel-cmdline-config.c"
				}
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp20_ = _tmp6_;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp20_) {
#line 1661 "rygel-cmdline-config.c"
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp21_ = tokens;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp21__length1 = tokens_length1;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp22_ = _tmp21_[1];
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp23_ = key;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = g_strcmp0 (_tmp22_, _tmp23_) == 0;
#line 1676 "rygel-cmdline-config.c"
				} else {
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = FALSE;
#line 1680 "rygel-cmdline-config.c"
				}
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp24_ = _tmp5_;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp24_) {
#line 1686 "rygel-cmdline-config.c"
					GeeArrayList* _tmp25_ = NULL;
					gchar** _tmp26_ = NULL;
					gint _tmp26__length1 = 0;
					const gchar* _tmp27_ = NULL;
					gchar** _tmp28_ = NULL;
					gchar** _tmp29_ = NULL;
#line 333 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp25_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 333 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_g_object_unref0 (value);
#line 333 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					value = _tmp25_;
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp26_ = tokens;
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp26__length1 = tokens_length1;
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp27_ = _tmp26_[2];
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, ",", -1);
#line 1707 "rygel-cmdline-config.c"
					{
						gchar** val_token_collection = NULL;
						gint val_token_collection_length1 = 0;
						gint _val_token_collection_size_ = 0;
						gint val_token_it = 0;
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						val_token_collection = _tmp29_;
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						val_token_collection_length1 = _vala_array_length (_tmp28_);
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						for (val_token_it = 0; val_token_it < _vala_array_length (_tmp28_); val_token_it = val_token_it + 1) {
#line 1719 "rygel-cmdline-config.c"
							gchar* _tmp30_ = NULL;
							gchar* val_token = NULL;
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
							_tmp30_ = g_strdup (val_token_collection[val_token_it]);
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
							val_token = _tmp30_;
#line 1726 "rygel-cmdline-config.c"
							{
								GeeArrayList* _tmp31_ = NULL;
								const gchar* _tmp32_ = NULL;
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
								_tmp31_ = value;
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
								_tmp32_ = val_token;
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, _tmp32_);
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
								_g_free0 (val_token);
#line 1738 "rygel-cmdline-config.c"
							}
						}
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						val_token_collection = (_vala_array_free (val_token_collection, val_token_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1743 "rygel-cmdline-config.c"
					}
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_g_free0 (option);
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					break;
#line 1751 "rygel-cmdline-config.c"
				}
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_free0 (option);
#line 1757 "rygel-cmdline-config.c"
			}
		}
	}
#line 341 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp33_ = value;
#line 341 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp33_ != NULL) {
#line 342 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result = value;
#line 342 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return result;
#line 1769 "rygel-cmdline-config.c"
	} else {
		const gchar* _tmp34_ = NULL;
		GError* _tmp35_ = NULL;
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp34_ = _ ("No value available");
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp35_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp34_);
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp35_;
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_g_object_unref0 (value);
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return NULL;
#line 1785 "rygel-cmdline-config.c"
	}
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_g_object_unref0 (value);
#line 1789 "rygel-cmdline-config.c"
}


static gint rygel_cmdline_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error) {
	RygelCmdlineConfig * self;
	gint result = 0;
	gint value = 0;
	gboolean value_set = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp34_ = FALSE;
	GError * _inner_error_ = NULL;
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, 0);
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 353 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	value = 0;
#line 354 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	value_set = FALSE;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_plugin_options;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
#line 1816 "rygel-cmdline-config.c"
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		option_collection = _tmp0_;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		option_collection_length1 = _tmp0__length1;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		for (option_it = 0; option_it < _tmp0__length1; option_it = option_it + 1) {
#line 1828 "rygel-cmdline-config.c"
			gchar* _tmp1_ = NULL;
			gchar* option = NULL;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp1_ = g_strdup (option_collection[option_it]);
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			option = _tmp1_;
#line 1835 "rygel-cmdline-config.c"
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp24_ = FALSE;
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp2_ = option;
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 3);
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = _tmp4_;
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens_length1 = _vala_array_length (_tmp3_);
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tokens_size_ = tokens_length1;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp9_ = tokens;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp9__length1 = tokens_length1;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp10_ = _tmp9_[0];
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp10_ != NULL) {
#line 1872 "rygel-cmdline-config.c"
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
#line 358 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp11_ = tokens;
#line 358 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp11__length1 = tokens_length1;
#line 358 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp12_ = _tmp11_[1];
#line 358 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp8_ = _tmp12_ != NULL;
#line 1884 "rygel-cmdline-config.c"
				} else {
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp8_ = FALSE;
#line 1888 "rygel-cmdline-config.c"
				}
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp13_ = _tmp8_;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp13_) {
#line 1894 "rygel-cmdline-config.c"
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					const gchar* _tmp15_ = NULL;
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp14_ = tokens;
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp14__length1 = tokens_length1;
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp15_ = _tmp14_[2];
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp7_ = _tmp15_ != NULL;
#line 1906 "rygel-cmdline-config.c"
				} else {
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp7_ = FALSE;
#line 1910 "rygel-cmdline-config.c"
				}
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp16_ = _tmp7_;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp16_) {
#line 1916 "rygel-cmdline-config.c"
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
#line 360 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp17_ = tokens;
#line 360 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp17__length1 = tokens_length1;
#line 360 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp18_ = _tmp17_[0];
#line 360 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp19_ = section;
#line 360 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = g_strcmp0 (_tmp18_, _tmp19_) == 0;
#line 1931 "rygel-cmdline-config.c"
				} else {
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = FALSE;
#line 1935 "rygel-cmdline-config.c"
				}
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp20_ = _tmp6_;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp20_) {
#line 1941 "rygel-cmdline-config.c"
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp21_ = tokens;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp21__length1 = tokens_length1;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp22_ = _tmp21_[1];
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp23_ = key;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = g_strcmp0 (_tmp22_, _tmp23_) == 0;
#line 1956 "rygel-cmdline-config.c"
				} else {
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = FALSE;
#line 1960 "rygel-cmdline-config.c"
				}
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp24_ = _tmp5_;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp24_) {
#line 1966 "rygel-cmdline-config.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					const gchar* _tmp26_ = NULL;
					gint _tmp27_ = 0;
					gboolean _tmp28_ = FALSE;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					gboolean _tmp33_ = FALSE;
#line 362 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp25_ = tokens;
#line 362 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp25__length1 = tokens_length1;
#line 362 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp26_ = _tmp25_[2];
#line 362 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp27_ = atoi (_tmp26_);
#line 362 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					value = _tmp27_;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp29_ = value;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp30_ = min;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					if (_tmp29_ >= _tmp30_) {
#line 1991 "rygel-cmdline-config.c"
						gint _tmp31_ = 0;
						gint _tmp32_ = 0;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						_tmp31_ = value;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						_tmp32_ = max;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						_tmp28_ = _tmp31_ <= _tmp32_;
#line 2000 "rygel-cmdline-config.c"
					} else {
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						_tmp28_ = FALSE;
#line 2004 "rygel-cmdline-config.c"
					}
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp33_ = _tmp28_;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					if (_tmp33_) {
#line 364 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						value_set = TRUE;
#line 2012 "rygel-cmdline-config.c"
					}
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_g_free0 (option);
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					break;
#line 2020 "rygel-cmdline-config.c"
				}
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_free0 (option);
#line 2026 "rygel-cmdline-config.c"
			}
		}
	}
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp34_ = value_set;
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp34_) {
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result = value;
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return result;
#line 2038 "rygel-cmdline-config.c"
	} else {
		const gchar* _tmp35_ = NULL;
		GError* _tmp36_ = NULL;
#line 373 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp35_ = _ ("No value available");
#line 373 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp36_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp35_);
#line 373 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp36_;
#line 373 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 373 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return 0;
#line 2052 "rygel-cmdline-config.c"
	}
}


static GeeArrayList* rygel_cmdline_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* value = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GeeArrayList* _tmp34_ = NULL;
	GError * _inner_error_ = NULL;
#line 377 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 377 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 377 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 380 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	value = NULL;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_plugin_options;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
#line 2077 "rygel-cmdline-config.c"
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		option_collection = _tmp0_;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		option_collection_length1 = _tmp0__length1;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		for (option_it = 0; option_it < _tmp0__length1; option_it = option_it + 1) {
#line 2089 "rygel-cmdline-config.c"
			gchar* _tmp1_ = NULL;
			gchar* option = NULL;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp1_ = g_strdup (option_collection[option_it]);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			option = _tmp1_;
#line 2096 "rygel-cmdline-config.c"
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp24_ = FALSE;
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp2_ = option;
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 3);
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = _tmp4_;
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens_length1 = _vala_array_length (_tmp3_);
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tokens_size_ = tokens_length1;
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp9_ = tokens;
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp9__length1 = tokens_length1;
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp10_ = _tmp9_[0];
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp10_ != NULL) {
#line 2133 "rygel-cmdline-config.c"
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
#line 384 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp11_ = tokens;
#line 384 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp11__length1 = tokens_length1;
#line 384 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp12_ = _tmp11_[1];
#line 384 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp8_ = _tmp12_ != NULL;
#line 2145 "rygel-cmdline-config.c"
				} else {
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp8_ = FALSE;
#line 2149 "rygel-cmdline-config.c"
				}
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp13_ = _tmp8_;
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp13_) {
#line 2155 "rygel-cmdline-config.c"
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					const gchar* _tmp15_ = NULL;
#line 385 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp14_ = tokens;
#line 385 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp14__length1 = tokens_length1;
#line 385 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp15_ = _tmp14_[2];
#line 385 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp7_ = _tmp15_ != NULL;
#line 2167 "rygel-cmdline-config.c"
				} else {
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp7_ = FALSE;
#line 2171 "rygel-cmdline-config.c"
				}
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp16_ = _tmp7_;
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp16_) {
#line 2177 "rygel-cmdline-config.c"
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
#line 386 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp17_ = tokens;
#line 386 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp17__length1 = tokens_length1;
#line 386 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp18_ = _tmp17_[0];
#line 386 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp19_ = section;
#line 386 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = g_strcmp0 (_tmp18_, _tmp19_) == 0;
#line 2192 "rygel-cmdline-config.c"
				} else {
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = FALSE;
#line 2196 "rygel-cmdline-config.c"
				}
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp20_ = _tmp6_;
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp20_) {
#line 2202 "rygel-cmdline-config.c"
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp21_ = tokens;
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp21__length1 = tokens_length1;
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp22_ = _tmp21_[1];
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp23_ = key;
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = g_strcmp0 (_tmp22_, _tmp23_) == 0;
#line 2217 "rygel-cmdline-config.c"
				} else {
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = FALSE;
#line 2221 "rygel-cmdline-config.c"
				}
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp24_ = _tmp5_;
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp24_) {
#line 2227 "rygel-cmdline-config.c"
					GeeArrayList* _tmp25_ = NULL;
					gchar** _tmp26_ = NULL;
					gint _tmp26__length1 = 0;
					const gchar* _tmp27_ = NULL;
					gchar** _tmp28_ = NULL;
					gchar** _tmp29_ = NULL;
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp25_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_g_object_unref0 (value);
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					value = _tmp25_;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp26_ = tokens;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp26__length1 = tokens_length1;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp27_ = _tmp26_[2];
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, ",", -1);
#line 2248 "rygel-cmdline-config.c"
					{
						gchar** val_token_collection = NULL;
						gint val_token_collection_length1 = 0;
						gint _val_token_collection_size_ = 0;
						gint val_token_it = 0;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						val_token_collection = _tmp29_;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						val_token_collection_length1 = _vala_array_length (_tmp28_);
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						for (val_token_it = 0; val_token_it < _vala_array_length (_tmp28_); val_token_it = val_token_it + 1) {
#line 2260 "rygel-cmdline-config.c"
							gchar* _tmp30_ = NULL;
							gchar* val_token = NULL;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
							_tmp30_ = g_strdup (val_token_collection[val_token_it]);
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
							val_token = _tmp30_;
#line 2267 "rygel-cmdline-config.c"
							{
								GeeArrayList* _tmp31_ = NULL;
								const gchar* _tmp32_ = NULL;
								gint _tmp33_ = 0;
#line 390 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
								_tmp31_ = value;
#line 390 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
								_tmp32_ = val_token;
#line 390 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
								_tmp33_ = atoi (_tmp32_);
#line 390 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, (gpointer) ((gintptr) _tmp33_));
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
								_g_free0 (val_token);
#line 2282 "rygel-cmdline-config.c"
							}
						}
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
						val_token_collection = (_vala_array_free (val_token_collection, val_token_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2287 "rygel-cmdline-config.c"
					}
#line 392 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 392 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_g_free0 (option);
#line 392 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					break;
#line 2295 "rygel-cmdline-config.c"
				}
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_free0 (option);
#line 2301 "rygel-cmdline-config.c"
			}
		}
	}
#line 396 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp34_ = value;
#line 396 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp34_ != NULL) {
#line 397 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result = value;
#line 397 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return result;
#line 2313 "rygel-cmdline-config.c"
	} else {
		const gchar* _tmp35_ = NULL;
		GError* _tmp36_ = NULL;
#line 399 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp35_ = _ ("No value available");
#line 399 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp36_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp35_);
#line 399 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp36_;
#line 399 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 399 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_g_object_unref0 (value);
#line 399 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return NULL;
#line 2329 "rygel-cmdline-config.c"
	}
#line 377 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_g_object_unref0 (value);
#line 2333 "rygel-cmdline-config.c"
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
#line 44 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 45 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 45 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (g_strcmp0 (_tmp0_, "true") == 0) {
#line 46 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = TRUE;
#line 46 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2350 "rygel-cmdline-config.c"
	} else {
#line 48 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = FALSE;
#line 48 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2356 "rygel-cmdline-config.c"
	}
}


static gboolean rygel_cmdline_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean value = FALSE;
	gboolean value_set = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp28_ = FALSE;
	GError * _inner_error_ = NULL;
#line 403 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) base;
#line 403 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 403 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 406 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	value = FALSE;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	value_set = FALSE;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0_ = rygel_cmdline_config_plugin_options;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
#line 2384 "rygel-cmdline-config.c"
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		option_collection = _tmp0_;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		option_collection_length1 = _tmp0__length1;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		for (option_it = 0; option_it < _tmp0__length1; option_it = option_it + 1) {
#line 2396 "rygel-cmdline-config.c"
			gchar* _tmp1_ = NULL;
			gchar* option = NULL;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			_tmp1_ = g_strdup (option_collection[option_it]);
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
			option = _tmp1_;
#line 2403 "rygel-cmdline-config.c"
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp24_ = FALSE;
#line 409 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp2_ = option;
#line 409 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 3);
#line 409 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = _tmp4_;
#line 409 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens_length1 = _vala_array_length (_tmp3_);
#line 409 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tokens_size_ = tokens_length1;
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp9_ = tokens;
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp9__length1 = tokens_length1;
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp10_ = _tmp9_[0];
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp10_ != NULL) {
#line 2440 "rygel-cmdline-config.c"
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp11_ = tokens;
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp11__length1 = tokens_length1;
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp12_ = _tmp11_[1];
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp8_ = _tmp12_ != NULL;
#line 2452 "rygel-cmdline-config.c"
				} else {
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp8_ = FALSE;
#line 2456 "rygel-cmdline-config.c"
				}
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp13_ = _tmp8_;
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp13_) {
#line 2462 "rygel-cmdline-config.c"
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					const gchar* _tmp15_ = NULL;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp14_ = tokens;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp14__length1 = tokens_length1;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp15_ = _tmp14_[2];
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp7_ = _tmp15_ != NULL;
#line 2474 "rygel-cmdline-config.c"
				} else {
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp7_ = FALSE;
#line 2478 "rygel-cmdline-config.c"
				}
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp16_ = _tmp7_;
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp16_) {
#line 2484 "rygel-cmdline-config.c"
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
#line 413 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp17_ = tokens;
#line 413 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp17__length1 = tokens_length1;
#line 413 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp18_ = _tmp17_[0];
#line 413 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp19_ = section;
#line 413 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = g_strcmp0 (_tmp18_, _tmp19_) == 0;
#line 2499 "rygel-cmdline-config.c"
				} else {
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp6_ = FALSE;
#line 2503 "rygel-cmdline-config.c"
				}
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp20_ = _tmp6_;
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp20_) {
#line 2509 "rygel-cmdline-config.c"
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
#line 414 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp21_ = tokens;
#line 414 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp21__length1 = tokens_length1;
#line 414 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp22_ = _tmp21_[1];
#line 414 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp23_ = key;
#line 414 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = g_strcmp0 (_tmp22_, _tmp23_) == 0;
#line 2524 "rygel-cmdline-config.c"
				} else {
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp5_ = FALSE;
#line 2528 "rygel-cmdline-config.c"
				}
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_tmp24_ = _tmp5_;
#line 410 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				if (_tmp24_) {
#line 2534 "rygel-cmdline-config.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					const gchar* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
#line 415 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp25_ = tokens;
#line 415 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp25__length1 = tokens_length1;
#line 415 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp26_ = _tmp25_[2];
#line 415 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_tmp27_ = bool_parse (_tmp26_);
#line 415 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					value = _tmp27_;
#line 416 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					value_set = TRUE;
#line 417 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 417 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					_g_free0 (option);
#line 417 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
					break;
#line 2557 "rygel-cmdline-config.c"
				}
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
				_g_free0 (option);
#line 2563 "rygel-cmdline-config.c"
			}
		}
	}
#line 421 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	_tmp28_ = value_set;
#line 421 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	if (_tmp28_) {
#line 422 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		result = value;
#line 422 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return result;
#line 2575 "rygel-cmdline-config.c"
	} else {
		const gchar* _tmp29_ = NULL;
		GError* _tmp30_ = NULL;
#line 424 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp29_ = _ ("No value available");
#line 424 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_tmp30_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp29_);
#line 424 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		_inner_error_ = _tmp30_;
#line 424 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		g_propagate_error (error, _inner_error_);
#line 424 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
		return FALSE;
#line 2589 "rygel-cmdline-config.c"
	}
}


RygelCmdlineConfig* rygel_cmdline_config_construct (GType object_type) {
	RygelCmdlineConfig * self = NULL;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) g_object_new (object_type, NULL);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return self;
#line 2600 "rygel-cmdline-config.c"
}


RygelCmdlineConfig* rygel_cmdline_config_new (void) {
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	return rygel_cmdline_config_construct (RYGEL_TYPE_CMDLINE_CONFIG);
#line 2607 "rygel-cmdline-config.c"
}


static void rygel_cmdline_config_class_init (RygelCmdlineConfigClass * klass) {
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	rygel_cmdline_config_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_cmdline_config_finalize;
#line 2616 "rygel-cmdline-config.c"
}


static void rygel_cmdline_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	rygel_cmdline_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_upnp_enabled = (gboolean (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_upnp_enabled;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_interface = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_interface;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_interfaces = (gchar** (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_interfaces;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_port = (gint (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_port;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_transcoding = (gboolean (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_transcoding;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_allow_upload = (gboolean (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_allow_upload;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_allow_deletion = (gboolean (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_allow_deletion;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_log_levels = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_log_levels;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_plugin_path = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_plugin_path;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_engine_path = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_engine_path;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_media_engine = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_media_engine;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_enabled = (gboolean (*)(RygelConfiguration*, const gchar*, GError**)) rygel_cmdline_config_real_get_enabled;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_title = (gchar* (*)(RygelConfiguration*, const gchar*, GError**)) rygel_cmdline_config_real_get_title;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_video_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_video_upload_folder;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_music_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_music_upload_folder;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_picture_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_picture_upload_folder;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_string = (gchar* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_string;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_string_list = (GeeArrayList* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_string_list;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_int = (gint (*)(RygelConfiguration*, const gchar*, const gchar*, gint, gint, GError**)) rygel_cmdline_config_real_get_int;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_int_list = (GeeArrayList* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_int_list;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	iface->get_bool = (gboolean (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_bool;
#line 2665 "rygel-cmdline-config.c"
}


static void rygel_cmdline_config_instance_init (RygelCmdlineConfig * self) {
}


static void rygel_cmdline_config_finalize (GObject* obj) {
	RygelCmdlineConfig * self;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-cmdline-config.vala"
	G_OBJECT_CLASS (rygel_cmdline_config_parent_class)->finalize (obj);
#line 2679 "rygel-cmdline-config.c"
}


/**
 * Manages configuration from Commandline arguments.
 */
GType rygel_cmdline_config_get_type (void) {
	static volatile gsize rygel_cmdline_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_cmdline_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelCmdlineConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_cmdline_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelCmdlineConfig), 0, (GInstanceInitFunc) rygel_cmdline_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_cmdline_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_cmdline_config_type_id;
		rygel_cmdline_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelCmdlineConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_cmdline_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_cmdline_config_type_id__volatile, rygel_cmdline_config_type_id);
	}
	return rygel_cmdline_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



