/* rygel-http-time-seek-test.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-time-seek-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
typedef struct _RygelHTTPTranscodeHandlerPrivate RygelHTTPTranscodeHandlerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_TIME_SEEK_TEST (rygel_http_time_seek_test_get_type ())
#define RYGEL_HTTP_TIME_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTest))
#define RYGEL_HTTP_TIME_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST))
#define RYGEL_IS_HTTP_TIME_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_TEST))
#define RYGEL_HTTP_TIME_SEEK_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestClass))

typedef struct _RygelHTTPTimeSeekTest RygelHTTPTimeSeekTest;
typedef struct _RygelHTTPTimeSeekTestClass RygelHTTPTimeSeekTestClass;
typedef struct _RygelHTTPTimeSeekTestPrivate RygelHTTPTimeSeekTestPrivate;

#define RYGEL_HTTP_TIME_SEEK_TEST_TYPE_TEST_TYPE (rygel_http_time_seek_test_test_type_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPTranscodeHandler {
	GObject parent_instance;
	RygelHTTPTranscodeHandlerPrivate * priv;
};

struct _RygelHTTPTranscodeHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gint64 size;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaObject* object;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPTranscodeHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPTimeSeekTest {
	GObject parent_instance;
	RygelHTTPTimeSeekTestPrivate * priv;
};

struct _RygelHTTPTimeSeekTestClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING,
	RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING,
	RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING
} RygelHTTPTimeSeekTestTestType;

struct _RygelHTTPTimeSeekTestPrivate {
	GRegex* range_regex;
	RygelHTTPTimeSeekTestTestType test_type;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()

static gpointer rygel_http_transcode_handler_parent_class = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_audio_item_parent_class = NULL;
static gpointer rygel_client_hacks_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_time_seek_test_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TRANSCODE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (void);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
static void rygel_media_object_finalize (GObject* obj);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
RygelMediaItem* rygel_media_item_construct (GType object_type);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY
};
RygelAudioItem* rygel_audio_item_new (void);
RygelAudioItem* rygel_audio_item_construct (GType object_type);
static void rygel_audio_item_finalize (GObject* obj);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CLIENT_HACKS_DUMMY_PROPERTY
};
RygelClientHacks* rygel_client_hacks_create (SoupMessage* msg, GError** error);
RygelClientHacks* rygel_client_hacks_new (void);
RygelClientHacks* rygel_client_hacks_construct (GType object_type);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_ITEM_URI "http://DoesntMatterWhatThisIs"
RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop);
RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_strings (const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_strings (GType object_type, const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_add_string_headers (RygelHTTPGet* self, const gchar* start, const gchar* stop);
static void rygel_http_get_finalize (GObject* obj);
GType rygel_http_time_seek_test_get_type (void) G_GNUC_CONST;
static GType rygel_http_time_seek_test_test_type_get_type (void) G_GNUC_UNUSED;
#define RYGEL_HTTP_TIME_SEEK_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestPrivate))
enum  {
	RYGEL_HTTP_TIME_SEEK_TEST_DUMMY_PROPERTY
};
gint rygel_http_time_seek_test_main (gchar** args, int args_length1);
static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_new (void);
static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_construct (GType object_type);
GQuark rygel_http_seek_error_quark (void);
void rygel_http_time_seek_test_run (RygelHTTPTimeSeekTest* self, GError** error);
static void rygel_http_time_seek_test_test_no_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_start_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_stop_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_start_stop_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_seek (RygelHTTPTimeSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
static void rygel_http_time_seek_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type) {
	RygelHTTPTranscodeHandler * self = NULL;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPTranscodeHandler*) g_object_new (object_type, NULL);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 415 "rygel-http-time-seek-test.c"
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (void) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_transcode_handler_construct (RYGEL_TYPE_HTTP_TRANSCODE_HANDLER);
#line 422 "rygel-http-time-seek-test.c"
}


static void rygel_http_transcode_handler_class_init (RygelHTTPTranscodeHandlerClass * klass) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_transcode_handler_parent_class = g_type_class_peek_parent (klass);
#line 429 "rygel-http-time-seek-test.c"
}


static void rygel_http_transcode_handler_instance_init (RygelHTTPTranscodeHandler * self) {
}


GType rygel_http_transcode_handler_get_type (void) {
	static volatile gsize rygel_http_transcode_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_transcode_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTranscodeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_transcode_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTranscodeHandler), 0, (GInstanceInitFunc) rygel_http_transcode_handler_instance_init, NULL };
		GType rygel_http_transcode_handler_type_id;
		rygel_http_transcode_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPTranscodeHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_transcode_handler_type_id__volatile, rygel_http_transcode_handler_type_id);
	}
	return rygel_http_transcode_handler_type_id__volatile;
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 455 "rygel-http-time-seek-test.c"
}


RygelMediaObject* rygel_media_object_new (void) {
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
#line 462 "rygel-http-time-seek-test.c"
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
#line 471 "rygel-http-time-seek-test.c"
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->size = (gint64) (-1);
#line 478 "rygel-http-time-seek-test.c"
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
#line 488 "rygel-http-time-seek-test.c"
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer * self = NULL;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 510 "rygel-http-time-seek-test.c"
}


RygelMediaContainer* rygel_media_container_new (void) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
#line 517 "rygel-http-time-seek-test.c"
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
#line 524 "rygel-http-time-seek-test.c"
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 39 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	result = TRUE;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return result;
#line 552 "rygel-http-time-seek-test.c"
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem * self = NULL;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 562 "rygel-http-time-seek-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 37 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 569 "rygel-http-time-seek-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelAudioItem* rygel_audio_item_construct (GType object_type) {
	RygelAudioItem * self = NULL;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelAudioItem*) rygel_media_item_construct (object_type);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 595 "rygel-http-time-seek-test.c"
}


RygelAudioItem* rygel_audio_item_new (void) {
#line 43 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM);
#line 602 "rygel-http-time-seek-test.c"
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
#line 43 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
#line 611 "rygel-http-time-seek-test.c"
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->duration = (gint64) 2048;
#line 618 "rygel-http-time-seek-test.c"
}


static void rygel_audio_item_finalize (GObject* obj) {
	RygelAudioItem * self;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
#line 628 "rygel-http-time-seek-test.c"
}


GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


RygelClientHacks* rygel_client_hacks_create (SoupMessage* msg, GError** error) {
	RygelClientHacks* result = NULL;
	RygelClientHacks* _tmp0_ = NULL;
#line 48 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = rygel_client_hacks_new ();
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	result = _tmp0_;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return result;
#line 655 "rygel-http-time-seek-test.c"
}


gboolean rygel_client_hacks_force_seek (RygelClientHacks* self) {
	gboolean result = FALSE;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	result = FALSE;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return result;
#line 667 "rygel-http-time-seek-test.c"
}


RygelClientHacks* rygel_client_hacks_construct (GType object_type) {
	RygelClientHacks * self = NULL;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelClientHacks*) g_object_new (object_type, NULL);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 677 "rygel-http-time-seek-test.c"
}


RygelClientHacks* rygel_client_hacks_new (void) {
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_client_hacks_construct (RYGEL_TYPE_CLIENT_HACKS);
#line 684 "rygel-http-time-seek-test.c"
}


static void rygel_client_hacks_class_init (RygelClientHacksClass * klass) {
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_client_hacks_parent_class = g_type_class_peek_parent (klass);
#line 691 "rygel-http-time-seek-test.c"
}


static void rygel_client_hacks_instance_init (RygelClientHacks * self) {
}


GType rygel_client_hacks_get_type (void) {
	static volatile gsize rygel_client_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_client_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelClientHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_client_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelClientHacks), 0, (GInstanceInitFunc) rygel_client_hacks_instance_init, NULL };
		GType rygel_client_hacks_type_id;
		rygel_client_hacks_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelClientHacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_client_hacks_type_id__volatile, rygel_client_hacks_type_id);
	}
	return rygel_client_hacks_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail * self = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelThumbnail*) g_object_new (object_type, NULL);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 717 "rygel-http-time-seek-test.c"
}


RygelThumbnail* rygel_thumbnail_new (void) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 724 "rygel-http-time-seek-test.c"
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 731 "rygel-http-time-seek-test.c"
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle * self = NULL;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 757 "rygel-http-time-seek-test.c"
}


RygelSubtitle* rygel_subtitle_new (void) {
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 764 "rygel-http-time-seek-test.c"
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
#line 771 "rygel-http-time-seek-test.c"
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 74 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 794 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_ = NULL;
	RygelAudioItem* _tmp1_ = NULL;
	RygelHTTPTranscodeHandler* _tmp2_ = NULL;
	RygelThumbnail* _tmp3_ = NULL;
	RygelThumbnail* _tmp4_ = NULL;
	RygelSubtitle* _tmp5_ = NULL;
	RygelSubtitle* _tmp6_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = soup_message_new ("HTTP", RYGEL_HTTP_GET_ITEM_URI);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->msg);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->msg = _tmp0_;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = rygel_audio_item_new ();
#line 72 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->object);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->object = (RygelMediaObject*) _tmp1_;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = rygel_http_transcode_handler_new ();
#line 73 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->handler);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->handler = _tmp2_;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = thumbnail;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->thumbnail);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->thumbnail = _tmp4_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp5_ = subtitle;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->subtitle);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->subtitle = _tmp6_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 845 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 70 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, thumbnail, subtitle);
#line 852 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = thumbnail;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = subtitle;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 83 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = start;
#line 83 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_get_add_headers (self, _tmp2_, (gint64) (-1));
#line 78 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 873 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 78 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_get_construct_seek_start (RYGEL_TYPE_HTTP_GET, start, thumbnail, subtitle);
#line 880 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = thumbnail;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = subtitle;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 91 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = stop;
#line 91 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_get_add_headers (self, (gint64) 0, _tmp2_);
#line 86 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 901 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 86 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_get_construct_seek_stop (RYGEL_TYPE_HTTP_GET, stop, thumbnail, subtitle);
#line 908 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = thumbnail;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = subtitle;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = start;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = stop;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_get_add_headers (self, _tmp2_, _tmp3_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 932 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 94 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_get_construct_seek_start_stop (RYGEL_TYPE_HTTP_GET, start, stop, thumbnail, subtitle);
#line 939 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_strings (GType object_type, const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_val_if_fail (start != NULL, NULL);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_val_if_fail (stop != NULL, NULL);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = thumbnail;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = subtitle;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = start;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = stop;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_get_add_string_headers (self, _tmp2_, _tmp3_);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 967 "rygel-http-time-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_strings (const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_get_construct_seek_strings (RYGEL_TYPE_HTTP_GET, start, stop, thumbnail, subtitle);
#line 974 "rygel-http-time-seek-test.c"
}


static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop) {
	gint64 _tmp0_ = 0LL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* stop_str = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* range = NULL;
	gint64 _tmp8_ = 0LL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	SoupMessage* _tmp17_ = NULL;
	SoupMessageHeaders* _tmp18_ = NULL;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = start;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (_tmp0_ >= ((gint64) 0));
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = stop;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_tmp2_ > ((gint64) 0)) {
#line 1007 "rygel-http-time-seek-test.c"
		gint64 _tmp3_ = 0LL;
		gchar* _tmp4_ = NULL;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp3_ = stop;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_free0 (_tmp1_);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp1_ = _tmp4_;
#line 1018 "rygel-http-time-seek-test.c"
	} else {
		gchar* _tmp5_ = NULL;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp5_ = g_strdup ("");
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_free0 (_tmp1_);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp1_ = _tmp5_;
#line 1027 "rygel-http-time-seek-test.c"
	}
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp6_ = _tmp1_;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	stop_str = _tmp7_;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp8_ = start;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp10_ = _tmp9_;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp11_ = g_strconcat ("npt=", _tmp10_, NULL);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp12_ = _tmp11_;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp13_ = g_strconcat (_tmp12_, "-", NULL);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp14_ = _tmp13_;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp15_ = g_strconcat (_tmp14_, stop_str, NULL);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp16_ = _tmp15_;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp14_);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp12_);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp10_);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	range = _tmp16_;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp17_ = self->msg;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp18_ = _tmp17_->request_headers;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	soup_message_headers_append (_tmp18_, "TimeSeekRange.dlna.org", range);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (range);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (stop_str);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp1_);
#line 1073 "rygel-http-time-seek-test.c"
}


static void rygel_http_get_add_string_headers (RygelHTTPGet* self, const gchar* start, const gchar* stop) {
	gchar* range = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	SoupMessage* _tmp8_ = NULL;
	SoupMessageHeaders* _tmp9_ = NULL;
#line 118 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (start != NULL);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (stop != NULL);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = start;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = g_strconcat ("npt=", _tmp0_, NULL);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = _tmp1_;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = g_strconcat (_tmp2_, "-", NULL);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4_ = _tmp3_;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp5_ = stop;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp7_ = _tmp6_;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp4_);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (_tmp2_);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	range = _tmp7_;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp8_ = self->msg;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp9_ = _tmp8_->request_headers;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	soup_message_headers_append (_tmp9_, "TimeSeekRange.dlna.org", range);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (range);
#line 1125 "rygel-http-time-seek-test.c"
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
#line 1134 "rygel-http-time-seek-test.c"
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET, RygelHTTPGet);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->msg);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->object);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->thumbnail);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->subtitle);
#line 68 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (self->handler);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
#line 1158 "rygel-http-time-seek-test.c"
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


static GType rygel_http_time_seek_test_test_type_get_type (void) {
	static volatile gsize rygel_http_time_seek_test_test_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_test_test_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING, "RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING", "test-seconds-parsing"}, {RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING, "RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING", "test-hhmmss-parsing"}, {RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING, "RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING", "test-mixed-parsing"}, {0, NULL, NULL}};
		GType rygel_http_time_seek_test_test_type_type_id;
		rygel_http_time_seek_test_test_type_type_id = g_enum_register_static ("RygelHTTPTimeSeekTestTestType", values);
		g_once_init_leave (&rygel_http_time_seek_test_test_type_type_id__volatile, rygel_http_time_seek_test_test_type_type_id);
	}
	return rygel_http_time_seek_test_test_type_type_id__volatile;
}


gint rygel_http_time_seek_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPTimeSeekTest* test = NULL;
		RygelHTTPTimeSeekTest* _tmp0_ = NULL;
		RygelHTTPTimeSeekTest* _tmp1_ = NULL;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp0_ = rygel_http_time_seek_test_new ();
#line 136 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		test = _tmp0_;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp1_ = test;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		rygel_http_time_seek_test_run (_tmp1_, &_inner_error_);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_ != NULL) {
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (test);
#line 1205 "rygel-http-time-seek-test.c"
			goto __catch0_g_error;
		}
#line 135 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_object_unref0 (test);
#line 1210 "rygel-http-time-seek-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_error_ = _inner_error_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_inner_error_ = NULL;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp2_ = _error_;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp3_ = _tmp2_->message;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		g_critical ("rygel-http-time-seek-test.vala:144: %s", _tmp3_);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		result = -1;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_error_free0 (_error_);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		return result;
#line 1234 "rygel-http-time-seek-test.c"
	}
	__finally0:
#line 135 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 135 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		g_clear_error (&_inner_error_);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		return 0;
#line 1245 "rygel-http-time-seek-test.c"
	}
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	result = 0;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return result;
#line 1251 "rygel-http-time-seek-test.c"
}


int main (int argc, char ** argv) {
#line 134 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_type_init ();
#line 134 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_time_seek_test_main (argv, argc);
#line 1260 "rygel-http-time-seek-test.c"
}


void rygel_http_time_seek_test_run (RygelHTTPTimeSeekTest* self, GError** error) {
	RygelThumbnail** thumbnails = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelThumbnail** _tmp1_ = NULL;
	gint thumbnails_length1 = 0;
	gint _thumbnails_size_ = 0;
	RygelSubtitle** subtitles = NULL;
	RygelSubtitle* _tmp2_ = NULL;
	RygelSubtitle** _tmp3_ = NULL;
	gint subtitles_length1 = 0;
	gint _subtitles_size_ = 0;
	RygelThumbnail** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GError * _inner_error_ = NULL;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = rygel_thumbnail_new ();
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = g_new0 (RygelThumbnail*, 2 + 1);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_[0] = NULL;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_[1] = _tmp0_;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	thumbnails = _tmp1_;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	thumbnails_length1 = 2;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_thumbnails_size_ = thumbnails_length1;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = rygel_subtitle_new ();
#line 154 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = g_new0 (RygelSubtitle*, 2 + 1);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_[0] = NULL;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_[1] = _tmp2_;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	subtitles = _tmp3_;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	subtitles_length1 = 2;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_subtitles_size_ = subtitles_length1;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4_ = thumbnails;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4__length1 = thumbnails_length1;
#line 1312 "rygel-http-time-seek-test.c"
	{
		RygelThumbnail** thumbnail_collection = NULL;
		gint thumbnail_collection_length1 = 0;
		gint _thumbnail_collection_size_ = 0;
		gint thumbnail_it = 0;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		thumbnail_collection = _tmp4_;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		thumbnail_collection_length1 = _tmp4__length1;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		for (thumbnail_it = 0; thumbnail_it < _tmp4__length1; thumbnail_it = thumbnail_it + 1) {
#line 1324 "rygel-http-time-seek-test.c"
			RygelThumbnail* _tmp5_ = NULL;
			RygelThumbnail* thumbnail = NULL;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp5_ = _g_object_ref0 (thumbnail_collection[thumbnail_it]);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			thumbnail = _tmp5_;
#line 1331 "rygel-http-time-seek-test.c"
			{
				RygelSubtitle** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
				_tmp6_ = subtitles;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
				_tmp6__length1 = subtitles_length1;
#line 1339 "rygel-http-time-seek-test.c"
				{
					RygelSubtitle** subtitle_collection = NULL;
					gint subtitle_collection_length1 = 0;
					gint _subtitle_collection_size_ = 0;
					gint subtitle_it = 0;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
					subtitle_collection = _tmp6_;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
					subtitle_collection_length1 = _tmp6__length1;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
					for (subtitle_it = 0; subtitle_it < _tmp6__length1; subtitle_it = subtitle_it + 1) {
#line 1351 "rygel-http-time-seek-test.c"
						RygelSubtitle* _tmp7_ = NULL;
						RygelSubtitle* subtitle = NULL;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
						_tmp7_ = _g_object_ref0 (subtitle_collection[subtitle_it]);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
						subtitle = _tmp7_;
#line 1358 "rygel-http-time-seek-test.c"
						{
							RygelThumbnail* _tmp8_ = NULL;
							RygelSubtitle* _tmp9_ = NULL;
							RygelThumbnail* _tmp10_ = NULL;
							RygelSubtitle* _tmp11_ = NULL;
							RygelThumbnail* _tmp12_ = NULL;
							RygelSubtitle* _tmp13_ = NULL;
							RygelThumbnail* _tmp14_ = NULL;
							RygelSubtitle* _tmp15_ = NULL;
							RygelThumbnail* _tmp16_ = NULL;
							RygelSubtitle* _tmp17_ = NULL;
							RygelThumbnail* _tmp18_ = NULL;
							RygelSubtitle* _tmp19_ = NULL;
							RygelThumbnail* _tmp20_ = NULL;
							RygelSubtitle* _tmp21_ = NULL;
							RygelThumbnail* _tmp22_ = NULL;
							RygelSubtitle* _tmp23_ = NULL;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							self->priv->test_type = RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp8_ = thumbnail;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp9_ = subtitle;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_no_seek (self, _tmp8_, _tmp9_, &_inner_error_);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1400 "rygel-http-time-seek-test.c"
								} else {
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1416 "rygel-http-time-seek-test.c"
								}
							}
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp10_ = thumbnail;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp11_ = subtitle;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_only_seek (self, _tmp10_, _tmp11_, &_inner_error_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1441 "rygel-http-time-seek-test.c"
								} else {
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1457 "rygel-http-time-seek-test.c"
								}
							}
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp12_ = thumbnail;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp13_ = subtitle;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_stop_only_seek (self, _tmp12_, _tmp13_, &_inner_error_);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1482 "rygel-http-time-seek-test.c"
								} else {
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1498 "rygel-http-time-seek-test.c"
								}
							}
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp14_ = thumbnail;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp15_ = subtitle;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_stop_seek (self, _tmp14_, _tmp15_, &_inner_error_);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1523 "rygel-http-time-seek-test.c"
								} else {
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1539 "rygel-http-time-seek-test.c"
								}
							}
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							self->priv->test_type = RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING;
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp16_ = thumbnail;
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp17_ = subtitle;
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_only_seek (self, _tmp16_, _tmp17_, &_inner_error_);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1566 "rygel-http-time-seek-test.c"
								} else {
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1582 "rygel-http-time-seek-test.c"
								}
							}
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp18_ = thumbnail;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp19_ = subtitle;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_stop_only_seek (self, _tmp18_, _tmp19_, &_inner_error_);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1607 "rygel-http-time-seek-test.c"
								} else {
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1623 "rygel-http-time-seek-test.c"
								}
							}
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp20_ = thumbnail;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp21_ = subtitle;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_stop_seek (self, _tmp20_, _tmp21_, &_inner_error_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1648 "rygel-http-time-seek-test.c"
								} else {
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1664 "rygel-http-time-seek-test.c"
								}
							}
#line 167 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							self->priv->test_type = RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp22_ = thumbnail;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_tmp23_ = subtitle;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_stop_seek (self, _tmp22_, _tmp23_, &_inner_error_);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1691 "rygel-http-time-seek-test.c"
								} else {
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
									return;
#line 1707 "rygel-http-time-seek-test.c"
								}
							}
#line 157 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
							_g_object_unref0 (subtitle);
#line 1712 "rygel-http-time-seek-test.c"
						}
					}
				}
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
				_g_object_unref0 (thumbnail);
#line 1718 "rygel-http-time-seek-test.c"
			}
		}
	}
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1726 "rygel-http-time-seek-test.c"
}


static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_construct (GType object_type) {
	RygelHTTPTimeSeekTest * self = NULL;
	gchar* expression = NULL;
	gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = (RygelHTTPTimeSeekTest*) g_object_new (object_type, NULL);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = g_strdup ("npt=[0-9]+\\.[0-9][0-9][0-9]-" "[0-9]+\\.[0-9][0-9][0-9]/" "[0-9]+\\.[0-9][0-9][0-9]");
#line 174 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	expression = _tmp0_;
#line 1741 "rygel-http-time-seek-test.c"
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp2_ = g_regex_new (expression, G_REGEX_CASELESS, 0, &_inner_error_);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_tmp1_ = _tmp2_;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_ != NULL) {
#line 179 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1753 "rygel-http-time-seek-test.c"
				goto __catch1_g_regex_error;
			}
#line 179 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_free0 (expression);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return NULL;
#line 1764 "rygel-http-time-seek-test.c"
		}
#line 179 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_regex_unref0 (self->priv->range_regex);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		self->priv->range_regex = _tmp1_;
#line 1770 "rygel-http-time-seek-test.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* _error_ = NULL;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_error_ = _inner_error_;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_inner_error_ = NULL;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		g_assert_not_reached ();
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_error_free0 (_error_);
#line 1784 "rygel-http-time-seek-test.c"
	}
	__finally1:
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		_g_free0 (expression);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		g_clear_error (&_inner_error_);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		return NULL;
#line 1797 "rygel-http-time-seek-test.c"
	}
#line 173 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (expression);
#line 173 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return self;
#line 1803 "rygel-http-time-seek-test.c"
}


static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_new (void) {
#line 173 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	return rygel_http_time_seek_test_construct (RYGEL_TYPE_HTTP_TIME_SEEK_TEST);
#line 1810 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_test_no_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	RygelHTTPGet* _tmp2_ = NULL;
	RygelAudioItem* audio_item = NULL;
	RygelMediaObject* _tmp3_ = NULL;
	RygelAudioItem* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	GError * _inner_error_ = NULL;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = thumbnail;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = subtitle;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = rygel_http_get_new (_tmp0_, _tmp1_);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	request = _tmp2_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = request->object;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp3_) : NULL);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	audio_item = _tmp4_;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp5_ = audio_item->duration;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, request, (gint64) 0, (_tmp5_ * G_TIME_SPAN_SECOND) - G_TIME_SPAN_MILLISECOND, &_inner_error_);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (audio_item);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1856 "rygel-http-time-seek-test.c"
		} else {
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (audio_item);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1868 "rygel-http-time-seek-test.c"
		}
	}
#line 186 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (audio_item);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (request);
#line 1875 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_test_start_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request = NULL;
	RygelHTTPTimeSeekTestTestType _tmp0_ = 0;
	RygelAudioItem* audio_item = NULL;
	RygelHTTPGet* _tmp7_ = NULL;
	RygelMediaObject* _tmp8_ = NULL;
	RygelAudioItem* _tmp9_ = NULL;
	RygelHTTPGet* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	GError * _inner_error_ = NULL;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 198 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	request = NULL;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = self->priv->test_type;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	switch (_tmp0_) {
#line 200 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING:
#line 1899 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp1_ = NULL;
			RygelSubtitle* _tmp2_ = NULL;
			RygelHTTPGet* _tmp3_ = NULL;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp1_ = thumbnail;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp2_ = subtitle;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp3_ = rygel_http_get_new_seek_start ((gint64) 128, _tmp1_, _tmp2_);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp3_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 1916 "rygel-http-time-seek-test.c"
		}
#line 200 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING:
#line 1920 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp4_ = NULL;
			RygelSubtitle* _tmp5_ = NULL;
			RygelHTTPGet* _tmp6_ = NULL;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp4_ = thumbnail;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp5_ = subtitle;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp6_ = rygel_http_get_new_seek_strings ("00:02:08.000", "", _tmp4_, _tmp5_);
#line 207 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 207 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp6_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 1937 "rygel-http-time-seek-test.c"
		}
		default:
#line 200 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		break;
#line 1942 "rygel-http-time-seek-test.c"
	}
#line 212 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp7_ = request;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp8_ = _tmp7_->object;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp8_) : NULL);
#line 212 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	audio_item = _tmp9_;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp10_ = request;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp11_ = audio_item->duration;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, _tmp10_, (gint64) (128 * G_TIME_SPAN_SECOND), (_tmp11_ * G_TIME_SPAN_SECOND) - G_TIME_SPAN_MILLISECOND, &_inner_error_);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (audio_item);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1970 "rygel-http-time-seek-test.c"
		} else {
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (audio_item);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 1982 "rygel-http-time-seek-test.c"
		}
	}
#line 195 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (audio_item);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (request);
#line 1989 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_test_stop_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request = NULL;
	RygelHTTPTimeSeekTestTestType _tmp0_ = 0;
	RygelHTTPGet* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	request = NULL;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = self->priv->test_type;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	switch (_tmp0_) {
#line 223 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING:
#line 2008 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp1_ = NULL;
			RygelSubtitle* _tmp2_ = NULL;
			RygelHTTPGet* _tmp3_ = NULL;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp1_ = thumbnail;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp2_ = subtitle;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp3_ = rygel_http_get_new_seek_stop ((gint64) 128, _tmp1_, _tmp2_);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp3_;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 2025 "rygel-http-time-seek-test.c"
		}
#line 223 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING:
#line 2029 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp4_ = NULL;
			RygelSubtitle* _tmp5_ = NULL;
			RygelHTTPGet* _tmp6_ = NULL;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp4_ = thumbnail;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp5_ = subtitle;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp6_ = rygel_http_get_new_seek_strings ("00:00:00.000", "00:02:08.000", _tmp4_, _tmp5_);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp6_;
#line 235 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 2046 "rygel-http-time-seek-test.c"
		}
		default:
#line 223 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		break;
#line 2051 "rygel-http-time-seek-test.c"
	}
#line 238 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp7_ = request;
#line 238 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, _tmp7_, (gint64) 0, (gint64) (128 * G_TIME_SPAN_SECOND), &_inner_error_);
#line 238 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 238 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 238 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 238 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 238 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 2067 "rygel-http-time-seek-test.c"
		} else {
#line 238 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 238 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 238 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 238 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 2077 "rygel-http-time-seek-test.c"
		}
	}
#line 218 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (request);
#line 2082 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_test_start_stop_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request = NULL;
	RygelHTTPTimeSeekTestTestType _tmp0_ = 0;
	RygelHTTPGet* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 241 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 244 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	request = NULL;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = self->priv->test_type;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	switch (_tmp0_) {
#line 246 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING:
#line 2101 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp1_ = NULL;
			RygelSubtitle* _tmp2_ = NULL;
			RygelHTTPGet* _tmp3_ = NULL;
#line 248 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp1_ = thumbnail;
#line 248 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp2_ = subtitle;
#line 248 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp3_ = rygel_http_get_new_seek_start_stop ((gint64) 128, (gint64) 256, _tmp1_, _tmp2_);
#line 248 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 248 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp3_;
#line 253 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 2118 "rygel-http-time-seek-test.c"
		}
#line 246 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING:
#line 2122 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp4_ = NULL;
			RygelSubtitle* _tmp5_ = NULL;
			RygelHTTPGet* _tmp6_ = NULL;
#line 256 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp4_ = thumbnail;
#line 256 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp5_ = subtitle;
#line 256 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp6_ = rygel_http_get_new_seek_strings ("00:02:08.000", "00:04:16.000", _tmp4_, _tmp5_);
#line 256 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 256 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp6_;
#line 261 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 2139 "rygel-http-time-seek-test.c"
		}
#line 246 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING:
#line 2143 "rygel-http-time-seek-test.c"
		{
			RygelThumbnail* _tmp7_ = NULL;
			RygelSubtitle* _tmp8_ = NULL;
			RygelHTTPGet* _tmp9_ = NULL;
#line 264 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp7_ = thumbnail;
#line 264 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp8_ = subtitle;
#line 264 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_tmp9_ = rygel_http_get_new_seek_strings ("00:02:08.000", "256.000", _tmp7_, _tmp8_);
#line 264 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 264 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			request = _tmp9_;
#line 269 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			break;
#line 2160 "rygel-http-time-seek-test.c"
		}
		default:
#line 246 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		break;
#line 2165 "rygel-http-time-seek-test.c"
	}
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp10_ = request;
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, _tmp10_, (gint64) (128 * G_TIME_SPAN_SECOND), (gint64) (256 * G_TIME_SPAN_SECOND), &_inner_error_);
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 2181 "rygel-http-time-seek-test.c"
		} else {
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			_g_object_unref0 (request);
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 273 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 2191 "rygel-http-time-seek-test.c"
		}
	}
#line 241 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (request);
#line 2196 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_test_seek (RygelHTTPTimeSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error) {
	RygelHTTPGet* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelHTTPTimeSeek* seek = NULL;
	RygelHTTPGet* _tmp2_ = NULL;
	RygelHTTPTimeSeek* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	gint64 _tmp12_ = 0LL;
	gint64 _tmp13_ = 0LL;
	gint64 _tmp14_ = 0LL;
	gint64 _tmp15_ = 0LL;
	RygelAudioItem* audio_item = NULL;
	RygelHTTPGet* _tmp16_ = NULL;
	RygelMediaObject* _tmp17_ = NULL;
	RygelAudioItem* _tmp18_ = NULL;
	gint64 _tmp19_ = 0LL;
	gint64 _tmp20_ = 0LL;
	RygelAudioItem* _tmp21_ = NULL;
	gint64 _tmp22_ = 0LL;
	gchar* header = NULL;
	RygelHTTPGet* _tmp23_ = NULL;
	SoupMessage* _tmp24_ = NULL;
	SoupMessageHeaders* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GRegex* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	RygelHTTPGet* _tmp32_ = NULL;
	GError * _inner_error_ = NULL;
#line 276 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 276 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_return_if_fail (request != NULL);
#line 279 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp0_ = request;
#line 279 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp1_ = rygel_http_time_seek_needed (_tmp0_);
#line 279 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_vala_assert (_tmp1_, "HTTPTimeSeek.needed (request)");
#line 281 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp2_ = request;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp3_ = rygel_http_time_seek_new (_tmp2_, &_inner_error_);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	seek = _tmp3_;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 281 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 281 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 2262 "rygel-http-time-seek-test.c"
		} else {
#line 281 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
			return;
#line 2270 "rygel-http-time-seek-test.c"
		}
	}
#line 282 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_seek_add_response_headers ((RygelHTTPSeek*) seek);
#line 284 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_vala_assert (seek != NULL, "seek != null");
#line 285 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp4_ = rygel_http_seek_get_start ((RygelHTTPSeek*) seek);
#line 285 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp5_ = _tmp4_;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp6_ = start;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_vala_assert (_tmp5_ == _tmp6_, "seek.start == start");
#line 286 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp7_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) seek);
#line 286 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp8_ = _tmp7_;
#line 286 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp9_ = stop;
#line 286 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_vala_assert (_tmp8_ == (_tmp9_ - 1), "seek.stop == stop - 1");
#line 287 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp10_ = rygel_http_seek_get_length ((RygelHTTPSeek*) seek);
#line 287 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp11_ = _tmp10_;
#line 287 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp12_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) seek);
#line 287 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp13_ = _tmp12_;
#line 287 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp14_ = rygel_http_seek_get_start ((RygelHTTPSeek*) seek);
#line 287 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp15_ = _tmp14_;
#line 287 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_vala_assert (_tmp11_ == ((_tmp13_ + G_TIME_SPAN_MILLISECOND) - _tmp15_), "seek.length == seek.stop + TimeSpan.MILLISECOND - seek.start");
#line 289 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp16_ = request;
#line 289 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp17_ = _tmp16_->object;
#line 289 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp17_) : NULL);
#line 289 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	audio_item = _tmp18_;
#line 290 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp19_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
#line 290 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp20_ = _tmp19_;
#line 290 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp21_ = audio_item;
#line 290 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp22_ = _tmp21_->duration;
#line 290 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_vala_assert (_tmp20_ == (_tmp22_ * G_TIME_SPAN_SECOND), "seek.total_length == audio_item.duration * TimeSpan.SECOND");
#line 292 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp23_ = request;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp24_ = _tmp23_->msg;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp25_ = _tmp24_->response_headers;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp26_ = soup_message_headers_get_one (_tmp25_, "TimeSeekRange.dlna.org");
#line 292 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp27_ = g_strdup (_tmp26_);
#line 292 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	header = _tmp27_;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp28_ = header;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_vala_assert (_tmp28_ != NULL, "header != null");
#line 295 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp29_ = self->priv->range_regex;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp30_ = header;
#line 295 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp31_ = g_regex_match (_tmp29_, _tmp30_, 0, NULL);
#line 295 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_vala_assert (_tmp31_, "this.range_regex.match (header)");
#line 302 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_tmp32_ = request;
#line 302 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_time_seek_requested (_tmp32_);
#line 276 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_free0 (header);
#line 276 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (audio_item);
#line 276 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_object_unref0 (seek);
#line 2359 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_class_init (RygelHTTPTimeSeekTestClass * klass) {
#line 124 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_parent_class = g_type_class_peek_parent (klass);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPTimeSeekTestPrivate));
#line 124 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_test_finalize;
#line 2370 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_instance_init (RygelHTTPTimeSeekTest * self) {
#line 124 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self->priv = RYGEL_HTTP_TIME_SEEK_TEST_GET_PRIVATE (self);
#line 2377 "rygel-http-time-seek-test.c"
}


static void rygel_http_time_seek_test_finalize (GObject* obj) {
	RygelHTTPTimeSeekTest * self;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTest);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	_g_regex_unref0 (self->priv->range_regex);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-time-seek-test.vala"
	G_OBJECT_CLASS (rygel_http_time_seek_test_parent_class)->finalize (obj);
#line 2389 "rygel-http-time-seek-test.c"
}


GType rygel_http_time_seek_test_get_type (void) {
	static volatile gsize rygel_http_time_seek_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekTest), 0, (GInstanceInitFunc) rygel_http_time_seek_test_instance_init, NULL };
		GType rygel_http_time_seek_test_type_id;
		rygel_http_time_seek_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPTimeSeekTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_test_type_id__volatile, rygel_http_time_seek_test_type_id);
	}
	return rygel_http_time_seek_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



