/* rygel-searchable-container.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-searchable-container.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define TYPE_MEDIA_OBJECT (media_object_get_type ())
#define MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT, MediaObject))
#define MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECT, MediaObjectClass))
#define IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT))
#define IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECT))
#define MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECT, MediaObjectClass))

typedef struct _MediaObject MediaObject;
typedef struct _MediaObjectClass MediaObjectClass;

#define TYPE_MEDIA_CONTAINER (media_container_get_type ())
#define MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER, MediaContainer))
#define MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_CONTAINER, MediaContainerClass))
#define IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER))
#define IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_CONTAINER))
#define MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_CONTAINER, MediaContainerClass))

typedef struct _MediaContainer MediaContainer;
typedef struct _MediaContainerClass MediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define TYPE_SEARCH_EXPRESSION (search_expression_get_type ())
#define SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_EXPRESSION, SearchExpression))
#define SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))
#define IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_EXPRESSION))
#define IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_EXPRESSION))
#define SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))

typedef struct _SearchExpression SearchExpression;
typedef struct _SearchExpressionClass SearchExpressionClass;

#define TYPE_MEDIA_OBJECTS (media_objects_get_type ())
#define MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECTS, MediaObjects))
#define MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECTS, MediaObjectsClass))
#define IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECTS))
#define IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECTS))
#define MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECTS, MediaObjectsClass))

typedef struct _MediaObjects MediaObjects;
typedef struct _MediaObjectsClass MediaObjectsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MediaObjectPrivate MediaObjectPrivate;
typedef struct _MediaContainerPrivate MediaContainerPrivate;
typedef struct _RygelSearchableContainerSimpleSearchData RygelSearchableContainerSimpleSearchData;

#define TYPE_RELATIONAL_EXPRESSION (relational_expression_get_type ())
#define RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpression))
#define RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))
#define IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RELATIONAL_EXPRESSION))
#define IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RELATIONAL_EXPRESSION))
#define RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))

typedef struct _RelationalExpression RelationalExpression;
typedef struct _RelationalExpressionClass RelationalExpressionClass;
typedef struct _SearchExpressionPrivate SearchExpressionPrivate;
typedef struct _RygelSearchableContainerFindObjectData RygelSearchableContainerFindObjectData;
typedef struct _RygelSearchableContainerSearchInChildrenData RygelSearchableContainerSearchInChildrenData;

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	MediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _MediaObject {
	GObject parent_instance;
	MediaObjectPrivate * priv;
};

struct _MediaObjectClass {
	GObjectClass parent_class;
};

struct _MediaContainer {
	MediaObject parent_instance;
	MediaContainerPrivate * priv;
	gchar* sort_criteria;
	gint child_count;
	gboolean create_mode_enabled;
};

struct _MediaContainerClass {
	MediaObjectClass parent_class;
};

struct _RygelSearchableContainerSimpleSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	SearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	MediaObjects* result;
	MediaObjects* _result_;
	MediaObjects* _tmp0_;
	gint count;
	gint _tmp1_;
	SearchExpression* _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	MediaObjects* children;
	gint _tmp6_;
	const gchar* _tmp7_;
	GCancellable* _tmp8_;
	MediaObjects* _tmp9_;
	guint limit;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	MediaObjects* _child_list;
	MediaObjects* _tmp13_;
	MediaObjects* _tmp14_;
	gint _child_size;
	MediaObjects* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _child_index;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	MediaObject* child;
	MediaObjects* _tmp21_;
	gint _tmp22_;
	gpointer _tmp23_;
	gboolean _tmp24_;
	SearchExpression* _tmp25_;
	SearchExpression* _tmp26_;
	MediaObject* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	MediaObjects* _tmp30_;
	MediaObject* _tmp31_;
	gboolean _tmp32_;
	guint _tmp33_;
	MediaObjects* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	guint _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	guint _tmp40_;
	MediaObjects* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	guint _tmp44_;
	gboolean _tmp45_;
	guint _tmp46_;
	guint _tmp47_;
	guint _tmp48_;
	MediaObjects* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	guint child_limit;
	guint _tmp52_;
	MediaObjects* child_results;
	SearchExpression* _tmp53_;
	MediaObjects* _tmp54_;
	guint _tmp55_;
	const gchar* _tmp56_;
	GCancellable* _tmp57_;
	MediaObjects* _tmp58_;
	MediaObjects* _tmp59_;
	MediaObjects* _tmp60_;
	guint _tmp61_;
	MediaObjects* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	guint _tmp65_;
	MediaObjects* _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	MediaObjects* _tmp69_;
	gboolean _tmp70_;
	MediaObjects* _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	gboolean _tmp74_;
	guint _tmp75_;
	guint _tmp76_;
	gboolean _tmp77_;
	gboolean _tmp78_;
	guint stop;
	gboolean _tmp79_;
	guint _tmp80_;
	guint _tmp81_;
	guint _tmp82_;
	MediaObjects* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	gboolean _tmp86_;
	guint _tmp87_;
	guint _tmp88_;
	MediaObjects* _tmp89_;
	gint _tmp90_;
	gint _tmp91_;
	MediaObjects* _tmp92_;
	guint _tmp93_;
	guint _tmp94_;
	GeeList* _tmp95_;
	MediaObjects* _tmp96_;
	GError * _inner_error_;
};

struct _SearchExpression {
	GObject parent_instance;
	SearchExpressionPrivate * priv;
	gchar* operand1;
	gchar* operand2;
	gchar* op;
};

struct _SearchExpressionClass {
	GObjectClass parent_class;
};

struct _RygelSearchableContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	gchar* id;
	GCancellable* cancellable;
	MediaObject* result;
	RelationalExpression* expression;
	RelationalExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	guint total_matches;
	MediaObjects* results;
	GCancellable* _tmp5_;
	guint _tmp6_;
	MediaObjects* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	GError * _inner_error_;
};

struct _RygelSearchableContainerSearchInChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	SearchExpression* expression;
	MediaObjects* children;
	guint limit;
	gchar* sort_criteria;
	GCancellable* cancellable;
	MediaObjects* result;
	MediaObjects* _result_;
	MediaObjects* _tmp0_;
	MediaObjects* _child_list;
	MediaObjects* _tmp1_;
	MediaObjects* _tmp2_;
	gint _child_size;
	MediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _child_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	MediaObject* child;
	MediaObjects* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	MediaObject* _tmp12_;
	RygelSearchableContainer* container;
	MediaObject* _tmp13_;
	RygelSearchableContainer* _tmp14_;
	guint tmp;
	MediaObjects* child_result;
	RygelSearchableContainer* _tmp15_;
	SearchExpression* _tmp16_;
	guint _tmp17_;
	const gchar* _tmp18_;
	GCancellable* _tmp19_;
	guint _tmp20_;
	MediaObjects* _tmp21_;
	MediaObjects* _tmp22_;
	MediaObjects* _tmp23_;
	gboolean _tmp24_;
	guint _tmp25_;
	MediaObjects* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	guint _tmp29_;
	gboolean _tmp30_;
	GError * _inner_error_;
};



GType media_object_get_type (void) G_GNUC_CONST;
GType media_container_get_type (void) G_GNUC_CONST;
GType search_expression_get_type (void) G_GNUC_CONST;
GType media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_searchable_container_simple_search_data_free (gpointer _data);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_);
MediaObjects* media_objects_new (void);
MediaObjects* media_objects_construct (GType object_type);
void media_container_check_search_expression (MediaContainer* self, SearchExpression* expression);
gint media_container_get_all_child_count (MediaContainer* self);
void media_container_get_children (MediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* media_container_get_children_finish (MediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean search_expression_satisfied_by (SearchExpression* self, MediaObject* object);
static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, SearchExpression* expression, MediaObjects* children, guint limit, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static MediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_find_object_data_free (gpointer _data);
void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_);
GType relational_expression_get_type (void) G_GNUC_CONST;
RelationalExpression* relational_expression_new (void);
RelationalExpression* relational_expression_construct (GType object_type);
#define SEARCH_CRITERIA_OP_EQ "="
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_searchable_container_search_in_children_data_free (gpointer _data);
static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_);
static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);


void rygel_searchable_container_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search (self, expression, offset, max_count, sort_criteria, cancellable, _callback_, _user_data_);
#line 394 "rygel-searchable-container.c"
}


MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search_finish (self, _res_, total_matches, error);
#line 401 "rygel-searchable-container.c"
}


static void rygel_searchable_container_simple_search_data_free (gpointer _data) {
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _data;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSimpleSearchData, _data_);
#line 420 "rygel-searchable-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 427 "rygel-searchable-container.c"
}


void rygel_searchable_container_simple_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
	RygelSearchableContainer* _tmp0_ = NULL;
	SearchExpression* _tmp1_ = NULL;
	SearchExpression* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSimpleSearchData);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_searchable_container_simple_search);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_simple_search_data_free);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp3_ = offset;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->offset = _tmp3_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp4_ = max_count;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->max_count = _tmp4_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp5_ = sort_criteria;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->sort_criteria = _tmp6_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp7_ = cancellable;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->cancellable = _tmp8_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 486 "rygel-searchable-container.c"
}


MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	MediaObjects* result;
	RygelSearchableContainerSimpleSearchData* _data_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return NULL;
#line 497 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (total_matches) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		*total_matches = _data_->total_matches;
#line 505 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	result = _data_->result;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return result;
#line 513 "rygel-searchable-container.c"
}


/**
     * Utility method that retrieves all children and recursively searches for
     * all media objects that satisfy the given search expression in this
     * container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offset zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * @return A list of media objects.
     */
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 543 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_) {
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 0:
#line 552 "rygel-searchable-container.c"
		goto _state_0;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 1:
#line 556 "rygel-searchable-container.c"
		goto _state_1;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 2:
#line 560 "rygel-searchable-container.c"
		goto _state_2;
		default:
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 565 "rygel-searchable-container.c"
	}
	_state_0:
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = NULL;
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = media_objects_new ();
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp1_ = 0;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp1_ = ((MediaContainer*) _data_->self)->child_count;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->count = _data_->_tmp1_;
#line 90 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp2_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp2_ = _data_->expression;
#line 90 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	media_container_check_search_expression ((MediaContainer*) _data_->self, _data_->_tmp2_);
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp3_ = FALSE;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp3_ = ((MediaContainer*) _data_->self)->create_mode_enabled;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp3_) {
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp4_ = 0;
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp4_ = media_container_get_all_child_count ((MediaContainer*) _data_->self);
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp5_ = 0;
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 93 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->count = _data_->_tmp5_;
#line 602 "rygel-searchable-container.c"
	}
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp6_ = 0;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp6_ = _data_->count;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp7_ = NULL;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp7_ = _data_->sort_criteria;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp8_ = NULL;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp8_ = _data_->cancellable;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	media_container_get_children ((MediaContainer*) _data_->self, (guint) 0, (guint) _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, rygel_searchable_container_simple_search_ready, _data_);
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 622 "rygel-searchable-container.c"
	_state_1:
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp9_ = NULL;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp9_ = media_container_get_children_finish ((MediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error_);
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->children = _data_->_tmp9_;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 642 "rygel-searchable-container.c"
		} else {
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 646 "rygel-searchable-container.c"
		}
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 652 "rygel-searchable-container.c"
	}
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp10_ = 0U;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp10_ = _data_->max_count;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp10_ > ((guint) 0)) {
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp11_ = 0U;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp11_ = _data_->offset;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp12_ = 0U;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp12_ = _data_->max_count;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->limit = _data_->_tmp11_ + _data_->_tmp12_;
#line 670 "rygel-searchable-container.c"
	} else {
#line 107 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->limit = (guint) 0;
#line 674 "rygel-searchable-container.c"
	}
	{
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp13_ = NULL;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp13_ = _data_->children;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp14_ = NULL;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp14_;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp15_ = NULL;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp15_ = _data_->_child_list;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp16_ = 0;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp16_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp15_);
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp17_ = 0;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp17_ = _data_->_tmp16_;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp17_;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		while (TRUE) {
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp18_ = 0;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp18_ = _data_->_child_index;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp18_ + 1;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp19_ = 0;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp19_ = _data_->_child_index;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp20_ = 0;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp20_ = _data_->_child_size;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (!(_data_->_tmp19_ < _data_->_tmp20_)) {
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 723 "rygel-searchable-container.c"
			}
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp21_ = NULL;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp21_ = _data_->_child_list;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp22_ = 0;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp22_ = _data_->_child_index;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp23_ = NULL;
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp21_, _data_->_tmp22_);
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->child = (MediaObject*) _data_->_tmp23_;
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp25_ = NULL;
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp25_ = _data_->expression;
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp25_ == NULL) {
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp24_ = TRUE;
#line 747 "rygel-searchable-container.c"
			} else {
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp26_ = NULL;
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp26_ = _data_->expression;
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp27_ = NULL;
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp27_ = _data_->child;
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp28_ = FALSE;
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp28_ = search_expression_satisfied_by (_data_->_tmp26_, _data_->_tmp27_);
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp24_ = _data_->_tmp28_;
#line 763 "rygel-searchable-container.c"
			}
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp29_ = FALSE;
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp29_ = _data_->_tmp24_;
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp29_) {
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp30_ = NULL;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp30_ = _data_->_result_;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp31_ = NULL;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp31_ = _data_->child;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp30_, _data_->_tmp31_);
#line 781 "rygel-searchable-container.c"
			}
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp33_ = 0U;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp33_ = _data_->limit;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp33_ > ((guint) 0)) {
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp34_ = NULL;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp34_ = _data_->_result_;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp35_ = 0;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp35_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp34_);
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp36_ = 0;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp36_ = _data_->_tmp35_;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp37_ = 0U;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp37_ = _data_->limit;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp32_ = ((guint) _data_->_tmp36_) >= _data_->_tmp37_;
#line 807 "rygel-searchable-container.c"
			} else {
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp32_ = FALSE;
#line 811 "rygel-searchable-container.c"
			}
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp38_ = FALSE;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp38_ = _data_->_tmp32_;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp38_) {
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 823 "rygel-searchable-container.c"
			}
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 827 "rygel-searchable-container.c"
		}
#line 111 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 831 "rygel-searchable-container.c"
	}
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp40_ = 0U;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp40_ = _data_->limit;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp40_ == ((guint) 0)) {
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp39_ = TRUE;
#line 841 "rygel-searchable-container.c"
	} else {
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp41_ = NULL;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp41_ = _data_->_result_;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp42_ = 0;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp42_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp41_);
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp43_ = 0;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp43_ = _data_->_tmp42_;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp44_ = 0U;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp44_ = _data_->limit;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp39_ = ((guint) _data_->_tmp43_) < _data_->_tmp44_;
#line 861 "rygel-searchable-container.c"
	}
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp45_ = FALSE;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp45_ = _data_->_tmp39_;
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp45_) {
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp47_ = 0U;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp47_ = _data_->limit;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp47_ == ((guint) 0)) {
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp46_ = (guint) 0;
#line 877 "rygel-searchable-container.c"
		} else {
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp48_ = 0U;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp48_ = _data_->limit;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp49_ = NULL;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp49_ = _data_->_result_;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp50_ = 0;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp50_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp49_);
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp51_ = 0;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp51_ = _data_->_tmp50_;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp46_ = _data_->_tmp48_ - _data_->_tmp51_;
#line 897 "rygel-searchable-container.c"
		}
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp52_ = 0U;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp52_ = _data_->_tmp46_;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->child_limit = _data_->_tmp52_;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp53_ = NULL;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp53_ = _data_->expression;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp54_ = NULL;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp54_ = _data_->children;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp55_ = 0U;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp55_ = _data_->child_limit;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp56_ = NULL;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp56_ = _data_->sort_criteria;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp57_ = NULL;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp57_ = _data_->cancellable;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_state_ = 2;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		rygel_searchable_container_search_in_children (_data_->self, _data_->_tmp53_, _data_->_tmp54_, _data_->_tmp55_, _data_->_tmp56_, _data_->_tmp57_, rygel_searchable_container_simple_search_ready, _data_);
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 931 "rygel-searchable-container.c"
		_state_2:
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp58_ = NULL;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp58_ = rygel_searchable_container_search_in_children_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->child_results = _data_->_tmp58_;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_error_free (_data_->_inner_error_);
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->children);
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->_result_);
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_state_ == 0) {
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 953 "rygel-searchable-container.c"
			} else {
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 957 "rygel-searchable-container.c"
			}
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_object_unref (_data_->_async_result);
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			return FALSE;
#line 963 "rygel-searchable-container.c"
		}
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp59_ = NULL;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp59_ = _data_->_result_;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp60_ = NULL;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp60_ = _data_->child_results;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		gee_array_list_add_all ((GeeArrayList*) _data_->_tmp59_, (GeeCollection*) _data_->_tmp60_);
#line 121 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->child_results);
#line 977 "rygel-searchable-container.c"
	}
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp61_ = 0U;
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp61_ = _data_->max_count;
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp61_ > ((guint) 0)) {
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->total_matches = (guint) 0;
#line 987 "rygel-searchable-container.c"
	} else {
#line 137 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp62_ = NULL;
#line 137 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp62_ = _data_->_result_;
#line 137 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp63_ = 0;
#line 137 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp63_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp62_);
#line 137 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp64_ = 0;
#line 137 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp64_ = _data_->_tmp63_;
#line 137 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->total_matches = (guint) _data_->_tmp64_;
#line 1003 "rygel-searchable-container.c"
	}
#line 140 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp65_ = 0U;
#line 140 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp65_ = _data_->offset;
#line 140 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp66_ = NULL;
#line 140 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp66_ = _data_->_result_;
#line 140 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp67_ = 0;
#line 140 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp67_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp66_);
#line 140 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp68_ = 0;
#line 140 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp68_ = _data_->_tmp67_;
#line 140 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp65_ >= ((guint) _data_->_tmp68_)) {
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp69_ = NULL;
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp69_ = media_objects_new ();
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = _data_->_tmp69_;
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1037 "rygel-searchable-container.c"
		} else {
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1041 "rygel-searchable-container.c"
		}
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1047 "rygel-searchable-container.c"
	}
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp71_ = NULL;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp71_ = _data_->_result_;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp72_ = 0;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp72_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp71_);
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp73_ = 0;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp73_ = _data_->_tmp72_;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp73_ > 0) {
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp75_ = 0U;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp75_ = _data_->max_count;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp75_ > ((guint) 0)) {
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp74_ = TRUE;
#line 1071 "rygel-searchable-container.c"
		} else {
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp76_ = 0U;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp76_ = _data_->offset;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp74_ = _data_->_tmp76_ > ((guint) 0);
#line 1079 "rygel-searchable-container.c"
		}
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp77_ = FALSE;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp77_ = _data_->_tmp74_;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp70_ = _data_->_tmp77_;
#line 1087 "rygel-searchable-container.c"
	} else {
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp70_ = FALSE;
#line 1091 "rygel-searchable-container.c"
	}
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp78_ = FALSE;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp78_ = _data_->_tmp70_;
#line 145 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp78_) {
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp80_ = 0U;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp80_ = _data_->max_count;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp80_ != ((guint) 0)) {
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp81_ = 0U;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp81_ = _data_->offset;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp82_ = 0U;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp82_ = _data_->max_count;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp83_ = NULL;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp83_ = _data_->_result_;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp84_ = 0;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp84_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp83_);
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp85_ = 0;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp85_ = _data_->_tmp84_;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp79_ = (_data_->_tmp81_ + _data_->_tmp82_) <= ((guint) _data_->_tmp85_);
#line 1127 "rygel-searchable-container.c"
		} else {
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp79_ = FALSE;
#line 1131 "rygel-searchable-container.c"
		}
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp86_ = FALSE;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp86_ = _data_->_tmp79_;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp86_) {
#line 149 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp87_ = 0U;
#line 149 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp87_ = _data_->offset;
#line 149 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp88_ = 0U;
#line 149 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp88_ = _data_->max_count;
#line 149 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->stop = _data_->_tmp87_ + _data_->_tmp88_;
#line 1149 "rygel-searchable-container.c"
		} else {
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp89_ = NULL;
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp89_ = _data_->_result_;
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp90_ = 0;
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp90_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp89_);
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp91_ = 0;
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp91_ = _data_->_tmp90_;
#line 151 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->stop = (guint) _data_->_tmp91_;
#line 1165 "rygel-searchable-container.c"
		}
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp92_ = NULL;
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp92_ = _data_->_result_;
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp93_ = 0U;
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp93_ = _data_->offset;
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp94_ = 0U;
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp94_ = _data_->stop;
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp95_ = NULL;
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp95_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp92_, (gint) _data_->_tmp93_, (gint) _data_->_tmp94_);
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp96_ = NULL;
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp96_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp95_, TYPE_MEDIA_OBJECTS) ? ((MediaObjects*) _data_->_tmp95_) : NULL;
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp96_ == NULL) {
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->_tmp95_);
#line 1191 "rygel-searchable-container.c"
		}
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = _data_->_tmp96_;
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1203 "rygel-searchable-container.c"
		} else {
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1207 "rygel-searchable-container.c"
		}
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 154 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1213 "rygel-searchable-container.c"
	}
#line 157 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = _data_->_result_;
#line 157 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 157 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 157 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1223 "rygel-searchable-container.c"
	} else {
#line 157 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1227 "rygel-searchable-container.c"
	}
#line 157 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 157 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1241 "rygel-searchable-container.c"
	} else {
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1245 "rygel-searchable-container.c"
	}
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1251 "rygel-searchable-container.c"
}


static void rygel_searchable_container_find_object_data_free (gpointer _data) {
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _data;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->id);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerFindObjectData, _data_);
#line 1268 "rygel-searchable-container.c"
}


void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
	RygelSearchableContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerFindObjectData);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_searchable_container_find_object);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_find_object_data_free);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp1_ = id;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->id);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->id = _tmp2_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp3_ = cancellable;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->cancellable = _tmp4_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1307 "rygel-searchable-container.c"
}


MediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	MediaObject* result;
	RygelSearchableContainerFindObjectData* _data_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return NULL;
#line 1318 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	result = _data_->result;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return result;
#line 1328 "rygel-searchable-container.c"
}


/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * @return the found media object.
     */
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1352 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_) {
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 0:
#line 1361 "rygel-searchable-container.c"
		goto _state_0;
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 1:
#line 1365 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1370 "rygel-searchable-container.c"
	}
	_state_0:
#line 173 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = NULL;
#line 173 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = relational_expression_new ();
#line 173 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->expression = _data_->_tmp0_;
#line 174 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp1_ = NULL;
#line 174 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp1_ = g_strdup (SEARCH_CRITERIA_OP_EQ);
#line 174 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (((SearchExpression*) _data_->expression)->op);
#line 174 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	((SearchExpression*) _data_->expression)->op = _data_->_tmp1_;
#line 175 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp2_ = NULL;
#line 175 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp2_ = g_strdup ("@id");
#line 175 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (((SearchExpression*) _data_->expression)->operand1);
#line 175 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	((SearchExpression*) _data_->expression)->operand1 = _data_->_tmp2_;
#line 176 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp3_ = NULL;
#line 176 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp3_ = _data_->id;
#line 176 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp4_ = NULL;
#line 176 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 176 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (((SearchExpression*) _data_->expression)->operand2);
#line 176 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	((SearchExpression*) _data_->expression)->operand2 = _data_->_tmp4_;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp5_ = NULL;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp5_ = _data_->cancellable;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp6_ = 0U;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_search (_data_->self, (SearchExpression*) _data_->expression, (guint) 0, (guint) 1, "", _data_->_tmp5_, rygel_searchable_container_find_object_ready, _data_);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1419 "rygel-searchable-container.c"
	_state_1:
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp7_ = NULL;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp7_ = rygel_searchable_container_search_finish (_data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->total_matches = _data_->_tmp6_;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->results = _data_->_tmp7_;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->expression);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1441 "rygel-searchable-container.c"
		} else {
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1445 "rygel-searchable-container.c"
		}
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1451 "rygel-searchable-container.c"
	}
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp8_ = 0;
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->results);
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp9_ = 0;
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp9_ > 0) {
#line 186 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp10_ = NULL;
#line 186 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->results, 0);
#line 186 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = (MediaObject*) _data_->_tmp10_;
#line 186 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 186 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->expression);
#line 186 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 186 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1477 "rygel-searchable-container.c"
		} else {
#line 186 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1481 "rygel-searchable-container.c"
		}
#line 186 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 186 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1487 "rygel-searchable-container.c"
	} else {
#line 188 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = NULL;
#line 188 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 188 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->expression);
#line 188 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 188 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1499 "rygel-searchable-container.c"
		} else {
#line 188 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1503 "rygel-searchable-container.c"
		}
#line 188 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 188 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1509 "rygel-searchable-container.c"
	}
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->results);
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1519 "rygel-searchable-container.c"
	} else {
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1523 "rygel-searchable-container.c"
	}
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1529 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_data_free (gpointer _data) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _data;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSearchInChildrenData, _data_);
#line 1550 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, SearchExpression* expression, MediaObjects* children, guint limit, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	RygelSearchableContainer* _tmp0_ = NULL;
	SearchExpression* _tmp1_ = NULL;
	SearchExpression* _tmp2_ = NULL;
	MediaObjects* _tmp3_ = NULL;
	MediaObjects* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSearchInChildrenData);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_searchable_container_search_in_children);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_search_in_children_data_free);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp3_ = children;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->children = _tmp4_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp5_ = limit;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->limit = _tmp5_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp6_ = sort_criteria;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->sort_criteria = _tmp7_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp8_ = cancellable;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->cancellable = _tmp9_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1614 "rygel-searchable-container.c"
}


static MediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	MediaObjects* result;
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return NULL;
#line 1625 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	result = _data_->result;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return result;
#line 1635 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1649 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_) {
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 0:
#line 1658 "rygel-searchable-container.c"
		goto _state_0;
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 1:
#line 1662 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1667 "rygel-searchable-container.c"
	}
	_state_0:
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = NULL;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = media_objects_new ();
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 1676 "rygel-searchable-container.c"
	{
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp1_ = NULL;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp1_ = _data_->children;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp2_ = NULL;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp2_;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp3_ = NULL;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp3_ = _data_->_child_list;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp4_ = 0;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp5_ = 0;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp5_;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		while (TRUE) {
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp6_ = 0;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp6_ = _data_->_child_index;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp6_ + 1;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp7_ = 0;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp7_ = _data_->_child_index;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp8_ = 0;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp8_ = _data_->_child_size;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 1724 "rygel-searchable-container.c"
			}
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp9_ = NULL;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp9_ = _data_->_child_list;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp10_ = 0;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp10_ = _data_->_child_index;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp11_ = NULL;
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->child = (MediaObject*) _data_->_tmp11_;
#line 202 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp12_ = NULL;
#line 202 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp12_ = _data_->child;
#line 202 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp12_, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp13_ = NULL;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp13_ = _data_->child;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp14_ = NULL;
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp13_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp13_) : NULL);
#line 203 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->container = _data_->_tmp14_;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp15_ = NULL;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp15_ = _data_->container;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp16_ = NULL;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp16_ = _data_->expression;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp17_ = 0U;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp17_ = _data_->limit;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp18_ = NULL;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp18_ = _data_->sort_criteria;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp19_ = NULL;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp19_ = _data_->cancellable;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp20_ = 0U;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_state_ = 1;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				rygel_searchable_container_search (_data_->_tmp15_, _data_->_tmp16_, (guint) 0, _data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_, rygel_searchable_container_search_in_children_ready, _data_);
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				return FALSE;
#line 1784 "rygel-searchable-container.c"
				_state_1:
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp21_ = NULL;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp21_ = rygel_searchable_container_search_finish (_data_->_tmp15_, _data_->_res_, &_data_->_tmp20_, &_data_->_inner_error_);
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->tmp = _data_->_tmp20_;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->child_result = _data_->_tmp21_;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				if (_data_->_inner_error_ != NULL) {
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					g_error_free (_data_->_inner_error_);
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->container);
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->child);
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_child_list);
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_result_);
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					if (_data_->_state_ == 0) {
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1812 "rygel-searchable-container.c"
					} else {
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 1816 "rygel-searchable-container.c"
					}
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					g_object_unref (_data_->_async_result);
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					return FALSE;
#line 1822 "rygel-searchable-container.c"
				}
#line 213 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp22_ = NULL;
#line 213 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp22_ = _data_->_result_;
#line 213 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp23_ = NULL;
#line 213 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp23_ = _data_->child_result;
#line 213 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				gee_array_list_add_all ((GeeArrayList*) _data_->_tmp22_, (GeeCollection*) _data_->_tmp23_);
#line 202 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child_result);
#line 202 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->container);
#line 1838 "rygel-searchable-container.c"
			}
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp25_ = 0U;
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp25_ = _data_->limit;
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp25_ > ((guint) 0)) {
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp26_ = NULL;
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp26_ = _data_->_result_;
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp27_ = 0;
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp26_);
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp28_ = 0;
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp28_ = _data_->_tmp27_;
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp29_ = 0U;
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp29_ = _data_->limit;
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp24_ = ((guint) _data_->_tmp28_) >= _data_->_tmp29_;
#line 1864 "rygel-searchable-container.c"
			} else {
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp24_ = FALSE;
#line 1868 "rygel-searchable-container.c"
			}
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp30_ = FALSE;
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp30_ = _data_->_tmp24_;
#line 216 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp30_) {
#line 217 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 217 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 1880 "rygel-searchable-container.c"
			}
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 1884 "rygel-searchable-container.c"
		}
#line 201 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 1888 "rygel-searchable-container.c"
	}
#line 221 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = _data_->_result_;
#line 221 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 221 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1896 "rygel-searchable-container.c"
	} else {
#line 221 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1900 "rygel-searchable-container.c"
	}
#line 221 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 221 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1912 "rygel-searchable-container.c"
	} else {
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1916 "rygel-searchable-container.c"
	}
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1922 "rygel-searchable-container.c"
}


void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container) {
#line 224 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_return_if_fail (didl_container != NULL);
#line 1929 "rygel-searchable-container.c"
	{
		GeeArrayList* _search_class_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _search_class_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _search_class_index = 0;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp0_ = rygel_searchable_container_get_search_classes (self);
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp1_ = _tmp0_;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_search_class_list = _tmp2_;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp3_ = _search_class_list;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp5_ = _tmp4_;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_search_class_size = _tmp5_;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_search_class_index = -1;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		while (TRUE) {
#line 1960 "rygel-searchable-container.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gchar* search_class = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			GUPnPDIDLLiteContainer* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp6_ = _search_class_index;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_search_class_index = _tmp6_ + 1;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp7_ = _search_class_index;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp8_ = _search_class_size;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 1982 "rygel-searchable-container.c"
			}
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp9_ = _search_class_list;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp10_ = _search_class_index;
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			search_class = (gchar*) _tmp11_;
#line 227 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp12_ = didl_container;
#line 227 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp13_ = search_class;
#line 227 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			gupnp_didl_lite_container_add_search_class (_tmp12_, _tmp13_);
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_free0 (search_class);
#line 2000 "rygel-searchable-container.c"
		}
#line 226 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_search_class_list);
#line 2004 "rygel-searchable-container.c"
	}
}


GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self) {
#line 42 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->get_search_classes (self);
#line 2014 "rygel-searchable-container.c"
}


void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value) {
#line 42 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->set_search_classes (self, value);
#line 2023 "rygel-searchable-container.c"
}


static void rygel_searchable_container_base_init (RygelSearchableContainerIface * iface) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	static gboolean initialized = FALSE;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (!initialized) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		initialized = TRUE;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2036 "rygel-searchable-container.c"
	}
}


/**
 * The base class for searchable containers.
 *
 * Classes that implement this interface can, for instance:
 *
 *  # Allow backends to implement a UPnP Search call using native searching (such as SQL or SPARQL queries).
 *  # Implement searching via the naïve default implementation provided by rygel_searchable_container_simple_search(), which does a recursive tree walk.
 *
 * The search_classes property lists what information this container may be searched
 * for. It is mapped to upnp:searchClass (with includeDerived assumed to be false),
 */
GType rygel_searchable_container_get_type (void) {
	static volatile gsize rygel_searchable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_searchable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchableContainerIface), (GBaseInitFunc) rygel_searchable_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_searchable_container_type_id;
		rygel_searchable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelSearchableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_searchable_container_type_id, TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_searchable_container_type_id__volatile, rygel_searchable_container_type_id);
	}
	return rygel_searchable_container_type_id__volatile;
}



