/* gitg-repository.c generated by valac 0.23.1.3-23cc3-dirty, the Vala compiler
 * generated from gitg-repository.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
typedef struct _GitgRepositoryPrivate GitgRepositoryPrivate;

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())

#define GITG_TYPE_STAGE (gitg_stage_get_type ())
#define GITG_STAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_STAGE, GitgStage))
#define GITG_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_STAGE, GitgStageClass))
#define GITG_IS_STAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_STAGE))
#define GITG_IS_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_STAGE))
#define GITG_STAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_STAGE, GitgStageClass))

typedef struct _GitgStage GitgStage;
typedef struct _GitgStageClass GitgStageClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GitgRepository {
	GgitRepository parent_instance;
	GitgRepositoryPrivate * priv;
};

struct _GitgRepositoryClass {
	GgitRepositoryClass parent_class;
};

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};

struct _GitgRepositoryPrivate {
	GHashTable* d_refs;
	GitgStage* d_stage;
};


static gpointer gitg_repository_parent_class = NULL;

GType gitg_repository_get_type (void) G_GNUC_CONST;
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
GType gitg_stage_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_REPOSITORY, GitgRepositoryPrivate))
enum  {
	GITG_REPOSITORY_DUMMY_PROPERTY,
	GITG_REPOSITORY_NAME,
	GITG_REPOSITORY_STAGE
};
GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error);
GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error);
static void gitg_repository_ensure_refs_add (GitgRepository* self, GgitOId* id, GitgRef* r);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static void gitg_repository_ensure_refs (GitgRepository* self);
static guint _ggit_oid_hash_ghash_func (gconstpointer key);
static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _vala_GgitOId_free (GgitOId* self);
static void __vala_GgitOId_free0_ (gpointer var);
static void __g_slist_free__g_object_unref0_0_ (gpointer var);
static gint ___lambda20_ (GitgRepository* self, const gchar* name);
GitgRef* gitg_repository_lookup_reference (GitgRepository* self, const gchar* name, GError** error);
gpointer gitg_repository_lookup (GitgRepository* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GgitOId* id, GError** error);
static gint ____lambda20__ggit_references_name_callback (const gchar* name, gpointer self);
GSList* gitg_repository_refs_for_id (GitgRepository* self, GgitOId* id);
GitgRef* gitg_repository_create_reference (GitgRepository* self, const gchar* name, GgitOId* oid, GError** error);
GitgRef* gitg_repository_create_symbolic_reference (GitgRepository* self, const gchar* name, const gchar* target, GError** error);
GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error);
gchar* gitg_repository_get_name (GitgRepository* self);
GFile* ggit_repository_get_workdir (GgitRepository* self);
GFile* ggit_repository_get_location (GgitRepository* self);
GitgStage* gitg_repository_get_stage (GitgRepository* self);
GitgStage* gitg_stage_new (GitgRepository* repository);
GitgStage* gitg_stage_construct (GType object_type, GitgRepository* repository);
static void gitg_repository_finalize (GObject* obj);
static void _vala_gitg_repository_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error) {
	GitgRepository * self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 37 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 39 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = location;
#line 39 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = workdir;
#line 39 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	self = (GitgRepository*) g_object_new (object_type, "location", _tmp0_, "workdir", _tmp1_, NULL);
#line 42 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_initable_init (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_INITABLE, GInitable), NULL, &_inner_error_);
#line 42 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_inner_error_ != NULL) {
#line 42 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 42 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (self);
#line 42 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 178 "gitg-repository.c"
	}
#line 37 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return self;
#line 182 "gitg-repository.c"
}


GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error) {
#line 37 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return gitg_repository_construct (GITG_TYPE_REPOSITORY, location, workdir, error);
#line 189 "gitg-repository.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return self ? g_object_ref (self) : NULL;
#line 196 "gitg-repository.c"
}


static GgitOId* _vala_GgitOId_copy (GgitOId* self) {
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return g_boxed_copy (ggit_oid_get_type (), self);
#line 203 "gitg-repository.c"
}


static gpointer __vala_GgitOId_copy0 (gpointer self) {
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return self ? _vala_GgitOId_copy (self) : NULL;
#line 210 "gitg-repository.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 217 "gitg-repository.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_slist_free (self);
#line 226 "gitg-repository.c"
}


static void gitg_repository_ensure_refs_add (GitgRepository* self, GgitOId* id, GitgRef* r) {
	GgitOId* _tmp0_ = NULL;
	GSList* refs = NULL;
	GHashTable* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_if_fail (r != NULL);
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = id;
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp0_ == NULL) {
#line 49 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return;
#line 247 "gitg-repository.c"
	}
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = self->priv->d_refs;
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = id;
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = g_hash_table_lookup_extended (_tmp1_, _tmp2_, NULL, &_tmp3_);
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	refs = _tmp3_;
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_) {
#line 259 "gitg-repository.c"
		GitgRef* _tmp5_ = NULL;
		GitgRef* _tmp6_ = NULL;
#line 56 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp5_ = r;
#line 56 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 56 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		refs = g_slist_append (refs, _tmp6_);
#line 268 "gitg-repository.c"
	} else {
		GSList* nrefs = NULL;
		GitgRef* _tmp7_ = NULL;
		GitgRef* _tmp8_ = NULL;
		GHashTable* _tmp9_ = NULL;
		GgitOId* _tmp10_ = NULL;
		GgitOId* _tmp11_ = NULL;
		GSList* _tmp12_ = NULL;
#line 60 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		nrefs = NULL;
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp7_ = r;
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		nrefs = g_slist_append (nrefs, _tmp8_);
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp9_ = self->priv->d_refs;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp10_ = id;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp11_ = __vala_GgitOId_copy0 (_tmp10_);
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp12_ = nrefs;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		nrefs = NULL;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_hash_table_insert (_tmp9_, _tmp11_, _tmp12_);
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		__g_slist_free__g_object_unref0_0 (nrefs);
#line 299 "gitg-repository.c"
	}
}


static guint _ggit_oid_hash_ghash_func (gconstpointer key) {
	guint result;
	result = ggit_oid_hash (key);
#line 74 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 309 "gitg-repository.c"
}


static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = ggit_oid_equal (a, (GgitOId*) b);
#line 74 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 318 "gitg-repository.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 74 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 325 "gitg-repository.c"
}


static void __vala_GgitOId_free0_ (gpointer var) {
#line 74 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	(var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL));
#line 332 "gitg-repository.c"
}


static void __g_slist_free__g_object_unref0_0_ (gpointer var) {
#line 74 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	(var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL));
#line 339 "gitg-repository.c"
}


static gint ___lambda20_ (GitgRepository* self, const gchar* name) {
	gint result = 0;
	GitgRef* r = NULL;
	GitgRef* _tmp3_ = NULL;
	GgitOId* id = NULL;
	GitgRef* _tmp4_ = NULL;
	GgitOId* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GgitOId* _tmp7_ = NULL;
	GitgRef* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 79 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, 0);
#line 356 "gitg-repository.c"
	{
		GitgRef* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		GitgRef* _tmp2_ = NULL;
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp1_ = name;
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp2_ = gitg_repository_lookup_reference (self, _tmp1_, &_inner_error_);
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp0_ = _tmp2_;
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		if (_inner_error_ != NULL) {
#line 369 "gitg-repository.c"
			goto __catch2_g_error;
		}
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		r = _tmp0_;
#line 376 "gitg-repository.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_inner_error_ = NULL;
#line 86 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		result = 0;
#line 86 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 86 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return result;
#line 391 "gitg-repository.c"
	}
	__finally2:
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_inner_error_ != NULL) {
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return 0;
#line 404 "gitg-repository.c"
	}
#line 88 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = r;
#line 88 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp3_ == NULL) {
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		result = 0;
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return result;
#line 416 "gitg-repository.c"
	}
#line 93 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = r;
#line 93 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp5_ = ggit_ref_get_target ((GgitRef*) _tmp4_);
#line 93 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	id = _tmp5_;
#line 95 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp6_ = id;
#line 95 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp6_ == NULL) {
#line 97 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		result = 0;
#line 97 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		__vala_GgitOId_free0 (id);
#line 97 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 97 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return result;
#line 436 "gitg-repository.c"
	}
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp7_ = id;
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp8_ = r;
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	gitg_repository_ensure_refs_add (self, _tmp7_, _tmp8_);
#line 444 "gitg-repository.c"
	{
		GgitTag* tag = NULL;
		GgitOId* _tmp9_ = NULL;
		gpointer _tmp10_ = NULL;
		GgitTag* _tmp11_ = NULL;
		GgitOId* _tmp12_ = NULL;
		GgitOId* _tmp13_ = NULL;
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp9_ = id;
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp10_ = gitg_repository_lookup (self, ggit_tag_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp9_, &_inner_error_);
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		tag = (GgitTag*) _tmp10_;
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		if (_inner_error_ != NULL) {
#line 460 "gitg-repository.c"
			goto __catch3_g_error;
		}
#line 109 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp11_ = tag;
#line 109 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp12_ = ggit_tag_get_target_id (_tmp11_);
#line 109 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		__vala_GgitOId_free0 (id);
#line 109 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		id = _tmp12_;
#line 111 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp13_ = id;
#line 111 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		if (_tmp13_ != NULL) {
#line 475 "gitg-repository.c"
			GgitOId* _tmp14_ = NULL;
			GitgRef* _tmp15_ = NULL;
#line 113 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp14_ = id;
#line 113 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
			_tmp15_ = r;
#line 113 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
			gitg_repository_ensure_refs_add (self, _tmp14_, _tmp15_);
#line 484 "gitg-repository.c"
		}
#line 104 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (tag);
#line 488 "gitg-repository.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
#line 104 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 104 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_inner_error_ = NULL;
#line 497 "gitg-repository.c"
	}
	__finally3:
#line 104 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_inner_error_ != NULL) {
#line 104 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		__vala_GgitOId_free0 (id);
#line 104 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (r);
#line 104 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 104 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 104 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return 0;
#line 512 "gitg-repository.c"
	}
#line 117 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	result = 0;
#line 117 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	__vala_GgitOId_free0 (id);
#line 117 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (r);
#line 117 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 522 "gitg-repository.c"
}


static gint ____lambda20__ggit_references_name_callback (const gchar* name, gpointer self) {
	gint result;
	result = ___lambda20_ ((GitgRepository*) self, name);
#line 79 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 531 "gitg-repository.c"
}


static void gitg_repository_ensure_refs (GitgRepository* self) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 67 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = self->priv->d_refs;
#line 69 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp0_ != NULL) {
#line 71 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return;
#line 547 "gitg-repository.c"
	}
#line 74 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = g_hash_table_new_full (_ggit_oid_hash_ghash_func, _ggit_oid_equal_gequal_func, __vala_GgitOId_free0_, __g_slist_free__g_object_unref0_0_);
#line 74 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_g_hash_table_unref0 (self->priv->d_refs);
#line 74 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	self->priv->d_refs = _tmp1_;
#line 555 "gitg-repository.c"
	{
#line 79 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		ggit_repository_references_foreach_name ((GgitRepository*) self, ____lambda20__ggit_references_name_callback, self, &_inner_error_);
#line 79 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		if (_inner_error_ != NULL) {
#line 561 "gitg-repository.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 77 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 77 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_inner_error_ = NULL;
#line 572 "gitg-repository.c"
	}
	__finally1:
#line 77 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_inner_error_ != NULL) {
#line 77 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 77 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_clear_error (&_inner_error_);
#line 77 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return;
#line 583 "gitg-repository.c"
	}
}


GSList* gitg_repository_refs_for_id (GitgRepository* self, GgitOId* id) {
	GSList* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 125 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	gitg_repository_ensure_refs (self);
#line 127 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = self->priv->d_refs;
#line 127 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = id;
#line 127 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 127 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	result = (GSList*) _tmp2_;
#line 127 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 609 "gitg-repository.c"
}


gpointer gitg_repository_lookup (GitgRepository* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GgitOId* id, GError** error) {
	gpointer result = NULL;
	GgitObject* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitObject* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 130 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 130 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = id;
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = ggit_repository_lookup (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, t_type, &_inner_error_);
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp2_;
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_inner_error_ != NULL) {
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 635 "gitg-repository.c"
	}
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	result = (gpointer) _tmp0_;
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 641 "gitg-repository.c"
}


GitgRef* gitg_repository_lookup_reference (GitgRepository* self, const gchar* name, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GgitRef* _tmp2_ = NULL;
	GitgRef* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 136 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 136 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = name;
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = ggit_repository_lookup_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, &_inner_error_);
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp2_;
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_inner_error_ != NULL) {
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 668 "gitg-repository.c"
	}
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GITG_TYPE_REF) ? ((GitgRef*) _tmp0_) : NULL;
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp3_ == NULL) {
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 676 "gitg-repository.c"
	}
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp3_;
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 682 "gitg-repository.c"
}


GitgRef* gitg_repository_create_reference (GitgRepository* self, const gchar* name, GgitOId* oid, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitRef* _tmp3_ = NULL;
	GitgRef* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 141 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 141 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (oid != NULL, NULL);
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = name;
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = oid;
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = ggit_repository_create_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, _tmp2_, &_inner_error_);
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp3_;
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_inner_error_ != NULL) {
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 714 "gitg-repository.c"
	}
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GITG_TYPE_REF) ? ((GitgRef*) _tmp0_) : NULL;
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_ == NULL) {
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 722 "gitg-repository.c"
	}
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp4_;
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 728 "gitg-repository.c"
}


GitgRef* gitg_repository_create_symbolic_reference (GitgRepository* self, const gchar* name, const gchar* target, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GgitRef* _tmp3_ = NULL;
	GitgRef* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 146 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 146 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 146 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = name;
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = target;
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = ggit_repository_create_symbolic_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), _tmp1_, _tmp2_, &_inner_error_);
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp3_;
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_inner_error_ != NULL) {
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 760 "gitg-repository.c"
	}
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GITG_TYPE_REF) ? ((GitgRef*) _tmp0_) : NULL;
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_ == NULL) {
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 768 "gitg-repository.c"
	}
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp4_;
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 774 "gitg-repository.c"
}


GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error) {
	GitgRef* result = NULL;
	GgitRef* _tmp0_ = NULL;
	GgitRef* _tmp1_ = NULL;
	GitgRef* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 151 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp1_ = ggit_repository_get_head (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), &_inner_error_);
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = _tmp1_;
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_inner_error_ != NULL) {
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_propagate_error (error, _inner_error_);
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		return NULL;
#line 796 "gitg-repository.c"
	}
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GITG_TYPE_REF) ? ((GitgRef*) _tmp0_) : NULL;
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp2_ == NULL) {
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 804 "gitg-repository.c"
	}
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp2_;
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 810 "gitg-repository.c"
}


gchar* gitg_repository_get_name (GitgRepository* self) {
	gchar* result;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GFile* f = NULL;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
#line 30 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_object_get ((GgitRepository*) self, "workdir", &_tmp1_, NULL);
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = _tmp1_;
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = _tmp2_;
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp3_);
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp4_) {
#line 840 "gitg-repository.c"
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_object_get ((GgitRepository*) self, "workdir", &_tmp5_, NULL);
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp6_ = _tmp5_;
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp0_ = _tmp6_;
#line 851 "gitg-repository.c"
	} else {
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp7_ = ggit_repository_get_location ((GgitRepository*) self);
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp8_ = _tmp7_;
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp0_ = _tmp8_;
#line 863 "gitg-repository.c"
	}
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp9_ = _tmp0_;
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	f = _tmp10_;
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp12_ = f;
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp12_ != NULL) {
#line 875 "gitg-repository.c"
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp13_ = f;
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp14_ = g_file_get_basename (_tmp13_);
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (_tmp11_);
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp11_ = _tmp14_;
#line 886 "gitg-repository.c"
	} else {
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_free0 (_tmp11_);
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp11_ = NULL;
#line 892 "gitg-repository.c"
	}
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp11_;
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (f);
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (_tmp0_);
#line 33 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 902 "gitg-repository.c"
}


GitgStage* gitg_repository_get_stage (GitgRepository* self) {
	GitgStage* result;
	GitgStage* _tmp0_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GitgStage* _tmp3_ = NULL;
#line 158 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp0_ = self->priv->d_stage;
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	if (_tmp0_ == NULL) {
#line 917 "gitg-repository.c"
		GitgStage* _tmp1_ = NULL;
#line 162 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_tmp1_ = gitg_stage_new (self);
#line 162 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		_g_object_unref0 (self->priv->d_stage);
#line 162 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		self->priv->d_stage = _tmp1_;
#line 925 "gitg-repository.c"
	}
#line 165 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp2_ = self->priv->d_stage;
#line 165 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 165 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	result = _tmp3_;
#line 165 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	return result;
#line 935 "gitg-repository.c"
}


static void gitg_repository_class_init (GitgRepositoryClass * klass) {
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	gitg_repository_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryPrivate));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_get_property;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_finalize;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_STAGE, g_param_spec_object ("stage", "stage", "stage", GITG_TYPE_STAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 952 "gitg-repository.c"
}


static void gitg_repository_instance_init (GitgRepository * self) {
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	self->priv = GITG_REPOSITORY_GET_PRIVATE (self);
#line 959 "gitg-repository.c"
}


static void gitg_repository_finalize (GObject* obj) {
	GitgRepository * self;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY, GitgRepository);
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_g_hash_table_unref0 (self->priv->d_refs);
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	_g_object_unref0 (self->priv->d_stage);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	G_OBJECT_CLASS (gitg_repository_parent_class)->finalize (obj);
#line 973 "gitg-repository.c"
}


GType gitg_repository_get_type (void) {
	static volatile gsize gitg_repository_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepository), 0, (GInstanceInitFunc) gitg_repository_instance_init, NULL };
		GType gitg_repository_type_id;
		gitg_repository_type_id = g_type_register_static (ggit_repository_get_type (), "GitgRepository", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_type_id__volatile, gitg_repository_type_id);
	}
	return gitg_repository_type_id__volatile;
}


static void _vala_gitg_repository_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepository * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY, GitgRepository);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
	switch (property_id) {
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		case GITG_REPOSITORY_NAME:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_value_take_string (value, gitg_repository_get_name (self));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		case GITG_REPOSITORY_STAGE:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		g_value_take_object (value, gitg_repository_get_stage (self));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		break;
#line 1006 "gitg-repository.c"
		default:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository.vala"
		break;
#line 1012 "gitg-repository.c"
	}
}



