/* iagno.c generated by valac 0.23.2.2-bd1e, the Vala compiler
 * generated from iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <locale.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PLAYER (player_get_type ())
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

struct _IagnoPrivate {
	GSettings* settings;
	gboolean is_fullscreen;
	gboolean is_maximized;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	GtkHeaderBar* headerbar;
	GameView* view;
	GtkButton* new_game_button;
	GtkLabel* dark_label;
	GtkLabel* dark_score_label;
	GtkLabel* light_label;
	GtkLabel* light_score_label;
	ComputerPlayer* light_computer;
	ComputerPlayer* dark_computer;
	guint computer_timer;
	Game* game;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;


static gpointer iagno_parent_class = NULL;
static gboolean iagno_fast_mode;
static gboolean iagno_fast_mode = FALSE;
static gboolean iagno_show_version;
static gboolean iagno_show_version = FALSE;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
GType computer_player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static void iagno_new_game_cb (Iagno* self);
static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_undo_move_cb (Iagno* self);
static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_preferences_cb (Iagno* self);
static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_quit_cb (Iagno* self);
static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_real_startup (GApplication* base);
Iagno* iagno_new (void);
Iagno* iagno_construct (GType object_type);
static void iagno_real_activate (GApplication* base);
static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event);
static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event);
static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
void game_view_set_game (GameView* self, Game* value);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
static void iagno_start_game (Iagno* self);
static void iagno_real_shutdown (GApplication* base);
static void iagno_cancel_pending_computer_moves (Iagno* self);
Game* game_new (gint width, gint height);
Game* game_construct (GType object_type, gint width, gint height);
static void iagno_game_move_cb (Iagno* self, Game* g);
static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self);
static void iagno_game_complete_cb (Iagno* self);
static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self);
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void iagno_update_ui (Iagno* self);
static gboolean iagno_computer_move_cb (Iagno* self);
static gboolean _iagno_computer_move_cb_gsource_func (gpointer self);
gboolean game_can_undo (Game* self);
GType player_get_type (void) G_GNUC_CONST;
Player game_get_current_color (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
gboolean game_can_move (Game* self, Player color);
static void iagno_show_preferences_dialog (Iagno* self);
static void iagno_play_sound (Iagno* self, const gchar* name);
void game_pass (Game* self);
gint game_get_n_tiles (Game* self);
void computer_player_move (ComputerPlayer* self);
gint game_place_tile (Game* self, gint x, gint y);
static void iagno_dark_level_changed_cb (Iagno* self, GtkComboBox* combo);
static void iagno_light_level_changed_cb (Iagno* self, GtkComboBox* combo);
static void iagno_sound_select (Iagno* self, GtkToggleButton* widget);
static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id);
static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event);
static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget);
void game_view_redraw (GameView* self);
static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void _iagno_dark_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _iagno_light_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
gint iagno_main (gchar** args, int args_length1);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry IAGNO_app_actions[6] = {{"new-game", _iagno_new_game_cb_gsimple_action_activate_callback}, {"undo-move", _iagno_undo_move_cb_gsimple_action_activate_callback}, {"preferences", _iagno_preferences_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _iagno_quit_cb_gsimple_action_activate_callback}};
static const GOptionEntry IAGNO_options[3] = {{"fast-mode", 'f', 0, G_OPTION_ARG_NONE, &iagno_fast_mode, "Reduce delay before AI moves", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, &iagno_show_version, "Show release version", NULL}, {NULL}};

static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_new_game_cb ((Iagno*) self);
}


static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_undo_move_cb ((Iagno*) self);
}


static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_preferences_cb ((Iagno*) self);
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_help_cb ((Iagno*) self);
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_about_cb ((Iagno*) self);
}


static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_quit_cb ((Iagno*) self);
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
	self = (Iagno*) base;
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
}


Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Iagno* iagno_new (void) {
	return iagno_construct (TYPE_IAGNO);
}


static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = iagno_window_configure_event_cb ((Iagno*) self, event);
	return result;
}


static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = iagno_window_state_event_cb ((Iagno*) self, event);
	return result;
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
	iagno_player_move_cb ((Iagno*) self, x, y);
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GtkWindow* _tmp0_ = NULL;
	GSettings* _tmp2_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkApplicationWindow* _tmp10_ = NULL;
	GtkWindow* _tmp11_ = NULL;
	GtkWindow* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkWindow* _tmp14_ = NULL;
	GtkWindow* _tmp15_ = NULL;
	GtkWindow* _tmp16_ = NULL;
	GtkWindow* _tmp17_ = NULL;
	GSettings* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GSettings* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GSettings* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GtkImage* image = NULL;
	GtkImage* _tmp28_ = NULL;
	GtkImage* _tmp29_ = NULL;
	GtkTextDirection _tmp30_ = 0;
	GtkButton* undo_button = NULL;
	GtkButton* _tmp33_ = NULL;
	GtkButton* _tmp34_ = NULL;
	GtkImage* _tmp35_ = NULL;
	GtkButton* _tmp36_ = NULL;
	GtkButton* _tmp37_ = NULL;
	GtkButton* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	GtkButton* _tmp40_ = NULL;
	GtkHeaderBar* _tmp41_ = NULL;
	GtkHeaderBar* _tmp42_ = NULL;
	GtkHeaderBar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	GtkHeaderBar* _tmp45_ = NULL;
	GtkButton* _tmp46_ = NULL;
	GtkHeaderBar* _tmp47_ = NULL;
	GtkWindow* _tmp48_ = NULL;
	GtkHeaderBar* _tmp49_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp50_ = NULL;
	GtkBox* _tmp51_ = NULL;
	GtkWindow* _tmp52_ = NULL;
	GtkBox* _tmp53_ = NULL;
	GameView* _tmp54_ = NULL;
	GameView* _tmp55_ = NULL;
	Game* _tmp56_ = NULL;
	GameView* _tmp57_ = NULL;
	gchar* tile_set = NULL;
	GSettings* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	GameView* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	GameView* _tmp64_ = NULL;
	GtkBox* _tmp65_ = NULL;
	GameView* _tmp66_ = NULL;
	GtkBox* side_box = NULL;
	GtkBox* _tmp67_ = NULL;
	GtkBox* _tmp68_ = NULL;
	GtkBox* _tmp69_ = NULL;
	GtkBox* _tmp70_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp71_ = NULL;
	GtkGrid* _tmp72_ = NULL;
	GtkGrid* _tmp73_ = NULL;
	GtkGrid* _tmp74_ = NULL;
	GtkGrid* _tmp75_ = NULL;
	GtkBox* _tmp76_ = NULL;
	GtkGrid* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	GtkLabel* _tmp79_ = NULL;
	GtkLabel* _tmp80_ = NULL;
	GtkGrid* _tmp81_ = NULL;
	GtkLabel* _tmp82_ = NULL;
	GtkLabel* _tmp83_ = NULL;
	GtkLabel* _tmp84_ = NULL;
	GtkGrid* _tmp85_ = NULL;
	GtkLabel* _tmp86_ = NULL;
	const gchar* _tmp87_ = NULL;
	GtkLabel* _tmp88_ = NULL;
	GtkLabel* _tmp89_ = NULL;
	GtkGrid* _tmp90_ = NULL;
	GtkLabel* _tmp91_ = NULL;
	GtkLabel* _tmp92_ = NULL;
	GtkLabel* _tmp93_ = NULL;
	GtkGrid* _tmp94_ = NULL;
	GtkLabel* _tmp95_ = NULL;
	GtkButton* _tmp96_ = NULL;
	GtkButton* _tmp97_ = NULL;
	GtkButton* _tmp98_ = NULL;
	GtkButton* _tmp99_ = NULL;
	GtkButton* _tmp100_ = NULL;
	GtkButton* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	GtkBox* _tmp103_ = NULL;
	GtkButton* _tmp104_ = NULL;
	GtkWindow* _tmp105_ = NULL;
	GError * _inner_error_ = NULL;
	self = (Iagno*) base;
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = self->priv->window;
		gtk_widget_show ((GtkWidget*) _tmp1_);
		return;
	}
	_tmp2_ = g_settings_new ("org.gnome.iagno");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = gtk_builder_new ();
	builder = _tmp3_;
	{
		GtkBuilder* _tmp4_ = NULL;
		_tmp4_ = builder;
		gtk_builder_add_from_file (_tmp4_, DATA_DIRECTORY "/iagno.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "Could not load UI: %s\n", _tmp7_);
		_g_error_free0 (e);
		_g_object_unref0 (builder);
		return;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "iagno-menu");
	gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp9_) : NULL);
	_tmp10_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = (GtkWindow*) _tmp10_;
	_tmp11_ = self->priv->window;
	gtk_container_set_border_width ((GtkContainer*) _tmp11_, (guint) 25);
	_tmp12_ = self->priv->window;
	_tmp13_ = _ ("Iagno");
	gtk_window_set_title (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->window;
	gtk_window_set_icon_name (_tmp14_, "iagno");
	_tmp15_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp15_, "configure-event", (GCallback) _iagno_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp16_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp16_, "window-state-event", (GCallback) _iagno_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp17_ = self->priv->window;
	_tmp18_ = self->priv->settings;
	_tmp19_ = g_settings_get_int (_tmp18_, "window-width");
	_tmp20_ = self->priv->settings;
	_tmp21_ = g_settings_get_int (_tmp20_, "window-height");
	gtk_window_set_default_size (_tmp17_, _tmp19_, _tmp21_);
	_tmp22_ = self->priv->settings;
	_tmp23_ = g_settings_get_boolean (_tmp22_, "window-is-fullscreen");
	if (_tmp23_) {
		GtkWindow* _tmp24_ = NULL;
		_tmp24_ = self->priv->window;
		gtk_window_fullscreen (_tmp24_);
	} else {
		GSettings* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		_tmp25_ = self->priv->settings;
		_tmp26_ = g_settings_get_boolean (_tmp25_, "window-is-maximized");
		if (_tmp26_) {
			GtkWindow* _tmp27_ = NULL;
			_tmp27_ = self->priv->window;
			gtk_window_maximize (_tmp27_);
		}
	}
	_tmp28_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp28_);
	image = _tmp28_;
	_tmp29_ = image;
	g_object_set (_tmp29_, "icon-size", (gint) GTK_ICON_SIZE_BUTTON, NULL);
	_tmp30_ = gtk_widget_get_default_direction ();
	if (_tmp30_ == GTK_TEXT_DIR_RTL) {
		GtkImage* _tmp31_ = NULL;
		_tmp31_ = image;
		g_object_set (_tmp31_, "icon-name", "edit-undo-rtl-symbolic", NULL);
	} else {
		GtkImage* _tmp32_ = NULL;
		_tmp32_ = image;
		g_object_set (_tmp32_, "icon-name", "edit-undo-symbolic", NULL);
	}
	_tmp33_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp33_);
	undo_button = _tmp33_;
	_tmp34_ = undo_button;
	_tmp35_ = image;
	gtk_button_set_image (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = undo_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp36_, GTK_ALIGN_CENTER);
	_tmp37_ = undo_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp37_, "app.undo-move");
	_tmp38_ = undo_button;
	_tmp39_ = _ ("Undo your most recent move");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp38_, _tmp39_);
	_tmp40_ = undo_button;
	gtk_widget_show ((GtkWidget*) _tmp40_);
	_tmp41_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp41_;
	_tmp42_ = self->priv->headerbar;
	gtk_header_bar_set_show_close_button (_tmp42_, TRUE);
	_tmp43_ = self->priv->headerbar;
	_tmp44_ = _ ("Iagno");
	gtk_header_bar_set_title (_tmp43_, _tmp44_);
	_tmp45_ = self->priv->headerbar;
	_tmp46_ = undo_button;
	gtk_header_bar_pack_start (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = self->priv->headerbar;
	gtk_widget_show ((GtkWidget*) _tmp47_);
	_tmp48_ = self->priv->window;
	_tmp49_ = self->priv->headerbar;
	gtk_window_set_titlebar (_tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp50_);
	hbox = _tmp50_;
	_tmp51_ = hbox;
	gtk_widget_show ((GtkWidget*) _tmp51_);
	_tmp52_ = self->priv->window;
	_tmp53_ = hbox;
	gtk_container_add ((GtkContainer*) _tmp52_, (GtkWidget*) _tmp53_);
	_tmp54_ = game_view_new ();
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp54_;
	_tmp55_ = self->priv->view;
	_tmp56_ = self->priv->game;
	game_view_set_game (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->view;
	g_signal_connect_object (_tmp57_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
	_tmp58_ = self->priv->settings;
	_tmp59_ = g_settings_get_string (_tmp58_, "tileset");
	tile_set = _tmp59_;
	_tmp60_ = self->priv->view;
	_tmp61_ = tile_set;
	_tmp62_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp61_, NULL);
	_tmp63_ = _tmp62_;
	game_view_set_theme (_tmp60_, _tmp63_);
	_g_free0 (_tmp63_);
	_tmp64_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp64_);
	_tmp65_ = hbox;
	_tmp66_ = self->priv->view;
	gtk_box_pack_start (_tmp65_, (GtkWidget*) _tmp66_, FALSE, TRUE, (guint) 0);
	_tmp67_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp67_);
	side_box = _tmp67_;
	_tmp68_ = side_box;
	gtk_widget_show ((GtkWidget*) _tmp68_);
	_tmp69_ = hbox;
	_tmp70_ = side_box;
	gtk_box_pack_start (_tmp69_, (GtkWidget*) _tmp70_, TRUE, TRUE, (guint) 20);
	_tmp71_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp71_);
	grid = _tmp71_;
	_tmp72_ = grid;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp72_, TRUE);
	_tmp73_ = grid;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp73_, TRUE);
	_tmp74_ = grid;
	gtk_grid_set_column_spacing (_tmp74_, (guint) 8);
	_tmp75_ = grid;
	gtk_widget_show ((GtkWidget*) _tmp75_);
	_tmp76_ = side_box;
	_tmp77_ = grid;
	gtk_box_pack_start (_tmp76_, (GtkWidget*) _tmp77_, FALSE, TRUE, (guint) 0);
	_tmp78_ = _ ("Dark:");
	_tmp79_ = (GtkLabel*) gtk_label_new (_tmp78_);
	g_object_ref_sink (_tmp79_);
	_g_object_unref0 (self->priv->dark_label);
	self->priv->dark_label = _tmp79_;
	_tmp80_ = self->priv->dark_label;
	gtk_widget_show ((GtkWidget*) _tmp80_);
	_tmp81_ = grid;
	_tmp82_ = self->priv->dark_label;
	gtk_grid_attach (_tmp81_, (GtkWidget*) _tmp82_, 1, 0, 1, 1);
	_tmp83_ = (GtkLabel*) gtk_label_new ("00");
	g_object_ref_sink (_tmp83_);
	_g_object_unref0 (self->priv->dark_score_label);
	self->priv->dark_score_label = _tmp83_;
	_tmp84_ = self->priv->dark_score_label;
	gtk_widget_show ((GtkWidget*) _tmp84_);
	_tmp85_ = grid;
	_tmp86_ = self->priv->dark_score_label;
	gtk_grid_attach (_tmp85_, (GtkWidget*) _tmp86_, 2, 0, 1, 1);
	_tmp87_ = _ ("Light:");
	_tmp88_ = (GtkLabel*) gtk_label_new (_tmp87_);
	g_object_ref_sink (_tmp88_);
	_g_object_unref0 (self->priv->light_label);
	self->priv->light_label = _tmp88_;
	_tmp89_ = self->priv->light_label;
	gtk_widget_show ((GtkWidget*) _tmp89_);
	_tmp90_ = grid;
	_tmp91_ = self->priv->light_label;
	gtk_grid_attach (_tmp90_, (GtkWidget*) _tmp91_, 1, 1, 1, 1);
	_tmp92_ = (GtkLabel*) gtk_label_new ("00");
	g_object_ref_sink (_tmp92_);
	_g_object_unref0 (self->priv->light_score_label);
	self->priv->light_score_label = _tmp92_;
	_tmp93_ = self->priv->light_score_label;
	gtk_widget_show ((GtkWidget*) _tmp93_);
	_tmp94_ = grid;
	_tmp95_ = self->priv->light_score_label;
	gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 2, 1, 1, 1);
	_tmp96_ = (GtkButton*) gtk_button_new_from_icon_name ("view-refresh-symbolic", GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp96_);
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = _tmp96_;
	_tmp97_ = self->priv->new_game_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp97_, GTK_ALIGN_CENTER);
	_tmp98_ = self->priv->new_game_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp98_, GTK_ALIGN_CENTER);
	_tmp99_ = self->priv->new_game_button;
	gtk_button_set_relief (_tmp99_, GTK_RELIEF_NONE);
	_tmp100_ = self->priv->new_game_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp100_, "app.new-game");
	_tmp101_ = self->priv->new_game_button;
	_tmp102_ = _ ("Start a new game");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp101_, _tmp102_);
	_tmp103_ = side_box;
	_tmp104_ = self->priv->new_game_button;
	gtk_box_pack_end (_tmp103_, (GtkWidget*) _tmp104_, FALSE, FALSE, (guint) 0);
	iagno_start_game (self);
	_tmp105_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp105_);
	_g_object_unref0 (grid);
	_g_object_unref0 (side_box);
	_g_free0 (tile_set);
	_g_object_unref0 (hbox);
	_g_object_unref0 (undo_button);
	_g_object_unref0 (image);
	_g_object_unref0 (builder);
}


static void iagno_real_shutdown (GApplication* base) {
	Iagno * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	self = (Iagno*) base;
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->is_fullscreen;
	g_settings_set_boolean (_tmp6_, "window-is-fullscreen", _tmp7_);
}


static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->is_maximized;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->is_fullscreen;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		GdkEventConfigure* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->width;
		self->priv->window_width = _tmp4_;
		_tmp5_ = event;
		_tmp6_ = _tmp5_->height;
		self->priv->window_height = _tmp6_;
	}
	result = FALSE;
	return result;
}


static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = event;
	_tmp5_ = _tmp4_->changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->new_window_state;
		self->priv->is_fullscreen = (_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
	}
	result = FALSE;
	return result;
}


static void iagno_quit_cb (Iagno* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void iagno_new_game_cb (Iagno* self) {
	g_return_if_fail (self != NULL);
	iagno_start_game (self);
}


static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self) {
	iagno_game_move_cb ((Iagno*) self, _sender);
}


static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self) {
	iagno_game_complete_cb ((Iagno*) self);
}


static gboolean _iagno_computer_move_cb_gsource_func (gpointer self) {
	gboolean result;
	result = iagno_computer_move_cb ((Iagno*) self);
	return result;
}


static void iagno_start_game (Iagno* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	GameView* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	gint dark_level = 0;
	GSettings* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint light_level = 0;
	GSettings* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	ComputerPlayer* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	iagno_cancel_pending_computer_moves (self);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_ = NULL;
		_tmp1_ = self->priv->game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = game_new (8, 8);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp2_;
	_tmp3_ = self->priv->game;
	g_signal_connect_object (_tmp3_, "move", (GCallback) _iagno_game_move_cb_game_move, self, 0);
	_tmp4_ = self->priv->game;
	g_signal_connect_object (_tmp4_, "complete", (GCallback) _iagno_game_complete_cb_game_complete, self, 0);
	_tmp5_ = self->priv->view;
	_tmp6_ = self->priv->game;
	game_view_set_game (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->new_game_button;
	gtk_widget_hide ((GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = g_settings_get_int (_tmp8_, "black-level");
	dark_level = _tmp9_;
	_tmp10_ = dark_level;
	if (_tmp10_ > 0) {
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		ComputerPlayer* _tmp13_ = NULL;
		_tmp11_ = self->priv->game;
		_tmp12_ = dark_level;
		_tmp13_ = computer_player_new (_tmp11_, _tmp12_);
		_g_object_unref0 (self->priv->dark_computer);
		self->priv->dark_computer = _tmp13_;
	} else {
		_g_object_unref0 (self->priv->dark_computer);
		self->priv->dark_computer = NULL;
	}
	_tmp14_ = self->priv->settings;
	_tmp15_ = g_settings_get_int (_tmp14_, "white-level");
	light_level = _tmp15_;
	_tmp16_ = light_level;
	if (_tmp16_ > 0) {
		Game* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		ComputerPlayer* _tmp19_ = NULL;
		_tmp17_ = self->priv->game;
		_tmp18_ = light_level;
		_tmp19_ = computer_player_new (_tmp17_, _tmp18_);
		_g_object_unref0 (self->priv->light_computer);
		self->priv->light_computer = _tmp19_;
	} else {
		_g_object_unref0 (self->priv->light_computer);
		self->priv->light_computer = NULL;
	}
	iagno_update_ui (self);
	_tmp20_ = self->priv->dark_computer;
	if (_tmp20_ != NULL) {
		guint _tmp21_ = 0U;
		_tmp21_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->computer_timer = _tmp21_;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void iagno_update_ui (Iagno* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	GSimpleAction* undo_action = NULL;
	GAction* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	ComputerPlayer* _tmp4_ = NULL;
	Game* _tmp10_ = NULL;
	Player _tmp11_ = 0;
	Player _tmp12_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "undo-move");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	undo_action = _tmp2_;
	_tmp4_ = self->priv->light_computer;
	if (_tmp4_ != NULL) {
		ComputerPlayer* _tmp5_ = NULL;
		_tmp5_ = self->priv->dark_computer;
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GSimpleAction* _tmp6_ = NULL;
		_tmp6_ = undo_action;
		g_simple_action_set_enabled (_tmp6_, FALSE);
	} else {
		GSimpleAction* _tmp7_ = NULL;
		Game* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp7_ = undo_action;
		_tmp8_ = self->priv->game;
		_tmp9_ = game_can_undo (_tmp8_);
		g_simple_action_set_enabled (_tmp7_, _tmp9_);
	}
	_tmp10_ = self->priv->game;
	_tmp11_ = game_get_current_color (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == PLAYER_DARK) {
		GtkLabel* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		GtkLabel* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		GtkLabel* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		Game* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		GtkLabel* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		Game* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		_tmp13_ = self->priv->dark_label;
		_tmp14_ = _ ("Dark:");
		_tmp15_ = g_strconcat ("<span font_weight='bold'>", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "</span>", NULL);
		_tmp18_ = _tmp17_;
		gtk_label_set_markup (_tmp13_, _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_tmp19_ = self->priv->light_label;
		_tmp20_ = _ ("Light:");
		_tmp21_ = g_strconcat ("<span font_weight='normal'>", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, "</span>", NULL);
		_tmp24_ = _tmp23_;
		gtk_label_set_markup (_tmp19_, _tmp24_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_tmp25_ = self->priv->dark_score_label;
		_tmp26_ = _ ("%.2d");
		_tmp27_ = self->priv->game;
		_tmp28_ = game_get_n_dark_tiles (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strdup_printf (_tmp26_, _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat ("<span font_weight='bold'>", _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat (_tmp33_, "</span>", NULL);
		_tmp35_ = _tmp34_;
		gtk_label_set_markup (_tmp25_, _tmp35_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_tmp36_ = self->priv->light_score_label;
		_tmp37_ = _ ("%.2d");
		_tmp38_ = self->priv->game;
		_tmp39_ = game_get_n_light_tiles (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strdup_printf (_tmp37_, _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strconcat ("<span font_weight='normal'>", _tmp42_, NULL);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strconcat (_tmp44_, "</span>", NULL);
		_tmp46_ = _tmp45_;
		gtk_label_set_markup (_tmp36_, _tmp46_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp42_);
	} else {
		Game* _tmp47_ = NULL;
		Player _tmp48_ = 0;
		Player _tmp49_ = 0;
		_tmp47_ = self->priv->game;
		_tmp48_ = game_get_current_color (_tmp47_);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == PLAYER_LIGHT) {
			GtkLabel* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			GtkLabel* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_ = NULL;
			GtkLabel* _tmp62_ = NULL;
			const gchar* _tmp63_ = NULL;
			Game* _tmp64_ = NULL;
			gint _tmp65_ = 0;
			gint _tmp66_ = 0;
			gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_ = NULL;
			gchar* _tmp72_ = NULL;
			GtkLabel* _tmp73_ = NULL;
			const gchar* _tmp74_ = NULL;
			Game* _tmp75_ = NULL;
			gint _tmp76_ = 0;
			gint _tmp77_ = 0;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_ = NULL;
			gchar* _tmp82_ = NULL;
			gchar* _tmp83_ = NULL;
			_tmp50_ = self->priv->dark_label;
			_tmp51_ = _ ("Dark:");
			_tmp52_ = g_strconcat ("<span font_weight='normal'>", _tmp51_, NULL);
			_tmp53_ = _tmp52_;
			_tmp54_ = g_strconcat (_tmp53_, "</span>", NULL);
			_tmp55_ = _tmp54_;
			gtk_label_set_markup (_tmp50_, _tmp55_);
			_g_free0 (_tmp55_);
			_g_free0 (_tmp53_);
			_tmp56_ = self->priv->light_label;
			_tmp57_ = _ ("Light:");
			_tmp58_ = g_strconcat ("<span font_weight='bold'>", _tmp57_, NULL);
			_tmp59_ = _tmp58_;
			_tmp60_ = g_strconcat (_tmp59_, "</span>", NULL);
			_tmp61_ = _tmp60_;
			gtk_label_set_markup (_tmp56_, _tmp61_);
			_g_free0 (_tmp61_);
			_g_free0 (_tmp59_);
			_tmp62_ = self->priv->dark_score_label;
			_tmp63_ = _ ("%.2d");
			_tmp64_ = self->priv->game;
			_tmp65_ = game_get_n_dark_tiles (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf (_tmp63_, _tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = g_strconcat ("<span font_weight='normal'>", _tmp68_, NULL);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strconcat (_tmp70_, "</span>", NULL);
			_tmp72_ = _tmp71_;
			gtk_label_set_markup (_tmp62_, _tmp72_);
			_g_free0 (_tmp72_);
			_g_free0 (_tmp70_);
			_g_free0 (_tmp68_);
			_tmp73_ = self->priv->light_score_label;
			_tmp74_ = _ ("%.2d");
			_tmp75_ = self->priv->game;
			_tmp76_ = game_get_n_light_tiles (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = g_strdup_printf (_tmp74_, _tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = g_strconcat ("<span font_weight='bold'>", _tmp79_, NULL);
			_tmp81_ = _tmp80_;
			_tmp82_ = g_strconcat (_tmp81_, "</span>", NULL);
			_tmp83_ = _tmp82_;
			gtk_label_set_markup (_tmp73_, _tmp83_);
			_g_free0 (_tmp83_);
			_g_free0 (_tmp81_);
			_g_free0 (_tmp79_);
		}
	}
	_g_object_unref0 (undo_action);
}


static void iagno_undo_move_cb (Iagno* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	GtkButton* _tmp19_ = NULL;
	Game* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	iagno_cancel_pending_computer_moves (self);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == PLAYER_DARK) {
		ComputerPlayer* _tmp5_ = NULL;
		_tmp5_ = self->priv->dark_computer;
		_tmp1_ = _tmp5_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		Game* _tmp7_ = NULL;
		Player _tmp8_ = 0;
		Player _tmp9_ = 0;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_current_color (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == PLAYER_LIGHT) {
			ComputerPlayer* _tmp10_ = NULL;
			_tmp10_ = self->priv->light_computer;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		Game* _tmp11_ = NULL;
		_tmp11_ = self->priv->game;
		game_undo (_tmp11_, 1);
	} else {
		Game* _tmp12_ = NULL;
		_tmp12_ = self->priv->game;
		game_undo (_tmp12_, 2);
	}
	while (TRUE) {
		Game* _tmp13_ = NULL;
		Game* _tmp14_ = NULL;
		Player _tmp15_ = 0;
		Player _tmp16_ = 0;
		gboolean _tmp17_ = FALSE;
		Game* _tmp18_ = NULL;
		_tmp13_ = self->priv->game;
		_tmp14_ = self->priv->game;
		_tmp15_ = game_get_current_color (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = game_can_move (_tmp13_, _tmp16_);
		if (!(!_tmp17_)) {
			break;
		}
		_tmp18_ = self->priv->game;
		game_undo (_tmp18_, 2);
	}
	_tmp19_ = self->priv->new_game_button;
	gtk_widget_hide ((GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->game;
	iagno_game_move_cb (self, _tmp20_);
}


static void iagno_about_cb (Iagno* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GtkWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Ian Peters");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_new0 (gchar*, 3 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp2_[2] = NULL;
	authors = _tmp2_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Tiffany Antopolski");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp4_[1] = NULL;
	documenters = _tmp4_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp5_ = self->priv->window;
	_tmp6_ = _ ("Iagno");
	_tmp7_ = _ ("A disk flipping game derived from Reversi\n" \
"\n" \
"Iagno is a part of GNOME Games.");
	_tmp8_ = _ ("translator-credits");
	gtk_show_about_dialog (_tmp5_, "name", _tmp6_, "version", VERSION, "copyright", "Copyright © 1998–2008 Ian Peters\n" \
"Copyright © 2013–2014 Michael Catanzaro", "license-type", GTK_LICENSE_GPL_2_0, "comments", _tmp7_, "authors", authors, "documenters", documenters, "translator-credits", _tmp8_, "logo-icon-name", "iagno", "website", "https://wiki.gnome.org/Apps/Iagno", NULL, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void iagno_preferences_cb (Iagno* self) {
	g_return_if_fail (self != NULL);
	iagno_show_preferences_dialog (self);
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("iagno.vala:331: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void iagno_game_move_cb (Iagno* self, Game* g) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	Game* _tmp17_ = NULL;
	Player _tmp18_ = 0;
	Player _tmp19_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = g;
	_tmp1_ = self->priv->game;
	g_return_if_fail (_tmp0_ == _tmp1_);
	iagno_play_sound (self, "flip-piece");
	_tmp2_ = self->priv->game;
	_tmp3_ = self->priv->game;
	_tmp4_ = game_get_current_color (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_can_move (_tmp2_, _tmp5_);
	if (!_tmp6_) {
		Game* _tmp7_ = NULL;
		Game* _tmp8_ = NULL;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
		_tmp7_ = self->priv->game;
		game_pass (_tmp7_);
		_tmp8_ = self->priv->game;
		_tmp9_ = game_get_current_color (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == PLAYER_DARK) {
			GtkHeaderBar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			_tmp11_ = self->priv->headerbar;
			_tmp12_ = _ ("Light must pass, Dark’s move");
			gtk_header_bar_set_subtitle (_tmp11_, _tmp12_);
		} else {
			GtkHeaderBar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			_tmp13_ = self->priv->headerbar;
			_tmp14_ = _ ("Dark must pass, Light’s move");
			gtk_header_bar_set_subtitle (_tmp13_, _tmp14_);
		}
		return;
	}
	iagno_update_ui (self);
	_tmp17_ = self->priv->game;
	_tmp18_ = game_get_current_color (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == PLAYER_LIGHT) {
		ComputerPlayer* _tmp20_ = NULL;
		_tmp20_ = self->priv->light_computer;
		_tmp16_ = _tmp20_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		gboolean _tmp21_ = FALSE;
		Game* _tmp22_ = NULL;
		Player _tmp23_ = 0;
		Player _tmp24_ = 0;
		_tmp22_ = self->priv->game;
		_tmp23_ = game_get_current_color (_tmp22_);
		_tmp24_ = _tmp23_;
		if (_tmp24_ == PLAYER_DARK) {
			ComputerPlayer* _tmp25_ = NULL;
			_tmp25_ = self->priv->dark_computer;
			_tmp21_ = _tmp25_ != NULL;
		} else {
			_tmp21_ = FALSE;
		}
		_tmp15_ = _tmp21_;
	}
	if (_tmp15_) {
		gboolean _tmp26_ = FALSE;
		Game* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		_tmp27_ = self->priv->game;
		_tmp28_ = game_get_n_tiles (_tmp27_);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == 63) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp30_ = FALSE;
			_tmp30_ = iagno_fast_mode;
			_tmp26_ = _tmp30_;
		}
		if (_tmp26_) {
			guint _tmp31_ = 0U;
			_tmp31_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 400, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->computer_timer = _tmp31_;
		} else {
			guint _tmp32_ = 0U;
			_tmp32_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->computer_timer = _tmp32_;
		}
	}
}


static gboolean iagno_computer_move_cb (Iagno* self) {
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Player _tmp1_ = 0;
	Player _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	iagno_cancel_pending_computer_moves (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_current_color (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == PLAYER_LIGHT) {
		ComputerPlayer* _tmp3_ = NULL;
		_tmp3_ = self->priv->light_computer;
		computer_player_move (_tmp3_);
	} else {
		ComputerPlayer* _tmp4_ = NULL;
		_tmp4_ = self->priv->dark_computer;
		computer_player_move (_tmp4_);
	}
	result = FALSE;
	return result;
}


static void iagno_cancel_pending_computer_moves (Iagno* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->computer_timer;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->computer_timer;
		g_source_remove (_tmp1_);
		self->priv->computer_timer = (guint) 0;
	}
}


static void iagno_game_complete_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkButton* _tmp24_ = NULL;
	g_return_if_fail (self != NULL);
	iagno_update_ui (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_n_light_tiles (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->game;
	_tmp4_ = game_get_n_dark_tiles (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ > _tmp5_) {
		GtkHeaderBar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = self->priv->headerbar;
		_tmp7_ = _ ("Light wins!");
		gtk_header_bar_set_subtitle (_tmp6_, _tmp7_);
	} else {
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp8_ = self->priv->game;
		_tmp9_ = game_get_n_dark_tiles (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->game;
		_tmp12_ = game_get_n_light_tiles (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp10_ > _tmp13_) {
			GtkHeaderBar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp14_ = self->priv->headerbar;
			_tmp15_ = _ ("Dark wins!");
			gtk_header_bar_set_subtitle (_tmp14_, _tmp15_);
		} else {
			Game* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			Game* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			_tmp16_ = self->priv->game;
			_tmp17_ = game_get_n_light_tiles (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = self->priv->game;
			_tmp20_ = game_get_n_dark_tiles (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp18_ == _tmp21_) {
				GtkHeaderBar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				_tmp22_ = self->priv->headerbar;
				_tmp23_ = _ ("The game is draw.");
				gtk_header_bar_set_subtitle (_tmp22_, _tmp23_);
			} else {
				g_assert_not_reached ();
			}
		}
	}
	iagno_play_sound (self, "gameover");
	_tmp24_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp24_);
}


static void iagno_play_sound (Iagno* self, const gchar* name) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GameView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->view;
	_tmp3_ = name;
	_tmp4_ = name;
	_tmp5_ = g_strdup_printf ("%s.ogg", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_build_filename (SOUND_DIRECTORY, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	ca_gtk_play_for_widget ((GtkWidget*) _tmp2_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp3_, CA_PROP_MEDIA_FILENAME, _tmp8_, NULL);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gboolean _tmp6_ = FALSE;
	Game* _tmp7_ = NULL;
	Player _tmp8_ = 0;
	Player _tmp9_ = 0;
	Game* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_current_color (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == PLAYER_LIGHT) {
		GSettings* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = self->priv->settings;
		_tmp5_ = g_settings_get_int (_tmp4_, "white-level");
		_tmp0_ = _tmp5_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = self->priv->game;
	_tmp8_ = game_get_current_color (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == PLAYER_DARK) {
		GSettings* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp10_ = self->priv->settings;
		_tmp11_ = g_settings_get_int (_tmp10_, "black-level");
		_tmp6_ = _tmp11_ > 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		return;
	}
	_tmp12_ = self->priv->game;
	_tmp13_ = x;
	_tmp14_ = y;
	_tmp15_ = game_place_tile (_tmp12_, _tmp13_, _tmp14_);
	if (_tmp15_ == 0) {
		GtkHeaderBar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp16_ = self->priv->headerbar;
		_tmp17_ = _ ("You can’t move there!");
		gtk_header_bar_set_subtitle (_tmp16_, _tmp17_);
	}
}


static void iagno_dark_level_changed_cb (Iagno* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint level = 0;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &level, -1);
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "black-level", level);
}


static void iagno_light_level_changed_cb (Iagno* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint level = 0;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &level, -1);
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "white-level", level);
}


static void iagno_sound_select (Iagno* self, GtkToggleButton* widget) {
	gboolean play_sounds = FALSE;
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	play_sounds = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_set_boolean (_tmp2_, "sound", play_sounds);
}


static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_widget_hide (_tmp0_);
}


static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = widget;
	gtk_widget_hide (_tmp0_);
	result = TRUE;
	return result;
}


static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gchar* tile_set = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	GSettings* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GameView* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GameView* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = widget;
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp6_ = model;
	_tmp7_ = iter;
	gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &tile_set, -1);
	_tmp8_ = self->priv->settings;
	_tmp9_ = tile_set;
	g_settings_set_string (_tmp8_, "tileset", _tmp9_);
	_tmp10_ = self->priv->view;
	_tmp11_ = tile_set;
	_tmp12_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	game_view_set_theme (_tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->view;
	game_view_redraw (_tmp14_);
	_g_free0 (tile_set);
	_g_object_unref0 (model);
}


static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	iagno_propbox_response_cb ((Iagno*) self, _sender, response_id);
}


static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = iagno_propbox_close_cb ((Iagno*) self, _sender, event);
	return result;
}


static void _iagno_dark_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_dark_level_changed_cb ((Iagno*) self, _sender);
}


static void _iagno_light_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_light_level_changed_cb ((Iagno*) self, _sender);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_theme_changed_cb ((Iagno*) self, _sender);
}


static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_sound_select ((Iagno*) self, _sender);
}


static void iagno_show_preferences_dialog (Iagno* self) {
	GtkDialog* propbox = NULL;
	const gchar* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkBox* box = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkBox* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkDialog* _tmp11_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkGrid* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkGrid* _tmp17_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkGrid* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkComboBox* combo = NULL;
	GtkComboBox* _tmp24_ = NULL;
	GtkComboBox* _tmp25_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp26_ = NULL;
	GtkComboBox* _tmp27_ = NULL;
	GtkCellRendererText* _tmp28_ = NULL;
	GtkComboBox* _tmp29_ = NULL;
	GtkCellRendererText* _tmp30_ = NULL;
	GtkListStore* model = NULL;
	GtkListStore* _tmp31_ = NULL;
	GtkComboBox* _tmp32_ = NULL;
	GtkListStore* _tmp33_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp34_ = NULL;
	GtkTreeIter _tmp35_ = {0};
	GtkListStore* _tmp36_ = NULL;
	GtkTreeIter _tmp37_ = {0};
	const gchar* _tmp38_ = NULL;
	GSettings* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	GtkListStore* _tmp43_ = NULL;
	GtkTreeIter _tmp44_ = {0};
	GtkListStore* _tmp45_ = NULL;
	GtkTreeIter _tmp46_ = {0};
	const gchar* _tmp47_ = NULL;
	GSettings* _tmp48_ = NULL;
	gint _tmp49_ = 0;
	GtkListStore* _tmp52_ = NULL;
	GtkTreeIter _tmp53_ = {0};
	GtkListStore* _tmp54_ = NULL;
	GtkTreeIter _tmp55_ = {0};
	const gchar* _tmp56_ = NULL;
	GSettings* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	GtkListStore* _tmp61_ = NULL;
	GtkTreeIter _tmp62_ = {0};
	GtkListStore* _tmp63_ = NULL;
	GtkTreeIter _tmp64_ = {0};
	const gchar* _tmp65_ = NULL;
	GSettings* _tmp66_ = NULL;
	gint _tmp67_ = 0;
	GtkGrid* _tmp70_ = NULL;
	GtkComboBox* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	GtkLabel* _tmp73_ = NULL;
	GtkLabel* _tmp74_ = NULL;
	GtkLabel* _tmp75_ = NULL;
	GtkGrid* _tmp76_ = NULL;
	GtkLabel* _tmp77_ = NULL;
	GtkComboBox* _tmp78_ = NULL;
	GtkComboBox* _tmp79_ = NULL;
	GtkCellRendererText* _tmp80_ = NULL;
	GtkComboBox* _tmp81_ = NULL;
	GtkCellRendererText* _tmp82_ = NULL;
	GtkComboBox* _tmp83_ = NULL;
	GtkCellRendererText* _tmp84_ = NULL;
	GtkListStore* _tmp85_ = NULL;
	GtkComboBox* _tmp86_ = NULL;
	GtkListStore* _tmp87_ = NULL;
	GtkListStore* _tmp88_ = NULL;
	GtkTreeIter _tmp89_ = {0};
	GtkListStore* _tmp90_ = NULL;
	GtkTreeIter _tmp91_ = {0};
	const gchar* _tmp92_ = NULL;
	GSettings* _tmp93_ = NULL;
	gint _tmp94_ = 0;
	GtkListStore* _tmp97_ = NULL;
	GtkTreeIter _tmp98_ = {0};
	GtkListStore* _tmp99_ = NULL;
	GtkTreeIter _tmp100_ = {0};
	const gchar* _tmp101_ = NULL;
	GSettings* _tmp102_ = NULL;
	gint _tmp103_ = 0;
	GtkListStore* _tmp106_ = NULL;
	GtkTreeIter _tmp107_ = {0};
	GtkListStore* _tmp108_ = NULL;
	GtkTreeIter _tmp109_ = {0};
	const gchar* _tmp110_ = NULL;
	GSettings* _tmp111_ = NULL;
	gint _tmp112_ = 0;
	GtkListStore* _tmp115_ = NULL;
	GtkTreeIter _tmp116_ = {0};
	GtkListStore* _tmp117_ = NULL;
	GtkTreeIter _tmp118_ = {0};
	const gchar* _tmp119_ = NULL;
	GSettings* _tmp120_ = NULL;
	gint _tmp121_ = 0;
	GtkGrid* _tmp124_ = NULL;
	GtkComboBox* _tmp125_ = NULL;
	const gchar* _tmp126_ = NULL;
	GtkLabel* _tmp127_ = NULL;
	GtkLabel* _tmp128_ = NULL;
	GtkLabel* _tmp129_ = NULL;
	GtkGrid* _tmp130_ = NULL;
	GtkLabel* _tmp131_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkComboBox* _tmp132_ = NULL;
	GtkCellRendererText* _tmp133_ = NULL;
	GtkComboBox* _tmp134_ = NULL;
	GtkCellRendererText* _tmp135_ = NULL;
	GtkComboBox* _tmp136_ = NULL;
	GtkCellRendererText* _tmp137_ = NULL;
	GtkListStore* _tmp138_ = NULL;
	GtkComboBox* _tmp139_ = NULL;
	GtkListStore* _tmp140_ = NULL;
	GDir* dir = NULL;
	GList* dirlist = NULL;
	GList* _tmp156_ = NULL;
	GtkLabel* _tmp181_ = NULL;
	GtkComboBox* _tmp182_ = NULL;
	GtkComboBox* _tmp183_ = NULL;
	GtkGrid* _tmp184_ = NULL;
	GtkComboBox* _tmp185_ = NULL;
	GtkCheckButton* enable_sounds_button = NULL;
	const gchar* _tmp186_ = NULL;
	GtkCheckButton* _tmp187_ = NULL;
	GSettings* _tmp188_ = NULL;
	gboolean _tmp189_ = FALSE;
	GtkGrid* _tmp190_ = NULL;
	GtkDialog* _tmp191_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Iagno Preferences");
	_tmp1_ = self->priv->window;
	_tmp2_ = _ ("_Close");
	_tmp3_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, _tmp1_, 0, _tmp2_, GTK_RESPONSE_CLOSE, NULL, NULL);
	g_object_ref_sink (_tmp3_);
	propbox = _tmp3_;
	_tmp4_ = propbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp4_, (guint) 5);
	_tmp5_ = propbox;
	_tmp6_ = (GtkBox*) gtk_dialog_get_content_area (_tmp5_);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_BOX, GtkBox));
	box = _tmp7_;
	_tmp8_ = box;
	gtk_box_set_spacing (_tmp8_, 2);
	_tmp9_ = propbox;
	gtk_window_set_resizable ((GtkWindow*) _tmp9_, FALSE);
	_tmp10_ = propbox;
	g_signal_connect_object (_tmp10_, "response", (GCallback) _iagno_propbox_response_cb_gtk_dialog_response, self, 0);
	_tmp11_ = propbox;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "delete-event", (GCallback) _iagno_propbox_close_cb_gtk_widget_delete_event, self, 0);
	_tmp12_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp12_);
	grid = _tmp12_;
	_tmp13_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp13_, (guint) 6);
	_tmp14_ = grid;
	gtk_grid_set_row_spacing (_tmp14_, (guint) 6);
	_tmp15_ = grid;
	gtk_grid_set_column_spacing (_tmp15_, (guint) 18);
	_tmp16_ = box;
	_tmp17_ = grid;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = _ ("Dark Player:");
	_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
	g_object_ref_sink (_tmp19_);
	label = _tmp19_;
	_tmp20_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp20_, 0.0f, 0.5f);
	_tmp21_ = label;
	g_object_set ((GtkWidget*) _tmp21_, "expand", TRUE, NULL);
	_tmp22_ = grid;
	_tmp23_ = label;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 0, 0, 1, 1);
	_tmp24_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp24_);
	combo = _tmp24_;
	_tmp25_ = combo;
	g_signal_connect_object (_tmp25_, "changed", (GCallback) _iagno_dark_level_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp26_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp26_);
	renderer = _tmp26_;
	_tmp27_ = combo;
	_tmp28_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp27_, (GtkCellRenderer*) _tmp28_, TRUE);
	_tmp29_ = combo;
	_tmp30_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp29_, (GtkCellRenderer*) _tmp30_, "text", 0);
	_tmp31_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	model = _tmp31_;
	_tmp32_ = combo;
	_tmp33_ = model;
	gtk_combo_box_set_model (_tmp32_, (GtkTreeModel*) _tmp33_);
	_tmp34_ = model;
	gtk_list_store_append (_tmp34_, &_tmp35_);
	iter = _tmp35_;
	_tmp36_ = model;
	_tmp37_ = iter;
	_tmp38_ = _ ("Human");
	gtk_list_store_set (_tmp36_, &_tmp37_, 0, _tmp38_, 1, 0, -1);
	_tmp39_ = self->priv->settings;
	_tmp40_ = g_settings_get_int (_tmp39_, "black-level");
	if (_tmp40_ == 0) {
		GtkComboBox* _tmp41_ = NULL;
		GtkTreeIter _tmp42_ = {0};
		_tmp41_ = combo;
		_tmp42_ = iter;
		gtk_combo_box_set_active_iter (_tmp41_, &_tmp42_);
	}
	_tmp43_ = model;
	gtk_list_store_append (_tmp43_, &_tmp44_);
	iter = _tmp44_;
	_tmp45_ = model;
	_tmp46_ = iter;
	_tmp47_ = _ ("Level one");
	gtk_list_store_set (_tmp45_, &_tmp46_, 0, _tmp47_, 1, 1, -1);
	_tmp48_ = self->priv->settings;
	_tmp49_ = g_settings_get_int (_tmp48_, "black-level");
	if (_tmp49_ == 1) {
		GtkComboBox* _tmp50_ = NULL;
		GtkTreeIter _tmp51_ = {0};
		_tmp50_ = combo;
		_tmp51_ = iter;
		gtk_combo_box_set_active_iter (_tmp50_, &_tmp51_);
	}
	_tmp52_ = model;
	gtk_list_store_append (_tmp52_, &_tmp53_);
	iter = _tmp53_;
	_tmp54_ = model;
	_tmp55_ = iter;
	_tmp56_ = _ ("Level two");
	gtk_list_store_set (_tmp54_, &_tmp55_, 0, _tmp56_, 1, 2, -1);
	_tmp57_ = self->priv->settings;
	_tmp58_ = g_settings_get_int (_tmp57_, "black-level");
	if (_tmp58_ == 2) {
		GtkComboBox* _tmp59_ = NULL;
		GtkTreeIter _tmp60_ = {0};
		_tmp59_ = combo;
		_tmp60_ = iter;
		gtk_combo_box_set_active_iter (_tmp59_, &_tmp60_);
	}
	_tmp61_ = model;
	gtk_list_store_append (_tmp61_, &_tmp62_);
	iter = _tmp62_;
	_tmp63_ = model;
	_tmp64_ = iter;
	_tmp65_ = _ ("Level three");
	gtk_list_store_set (_tmp63_, &_tmp64_, 0, _tmp65_, 1, 3, -1);
	_tmp66_ = self->priv->settings;
	_tmp67_ = g_settings_get_int (_tmp66_, "black-level");
	if (_tmp67_ == 3) {
		GtkComboBox* _tmp68_ = NULL;
		GtkTreeIter _tmp69_ = {0};
		_tmp68_ = combo;
		_tmp69_ = iter;
		gtk_combo_box_set_active_iter (_tmp68_, &_tmp69_);
	}
	_tmp70_ = grid;
	_tmp71_ = combo;
	gtk_grid_attach (_tmp70_, (GtkWidget*) _tmp71_, 1, 0, 1, 1);
	_tmp72_ = _ ("Light Player:");
	_tmp73_ = (GtkLabel*) gtk_label_new (_tmp72_);
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (label);
	label = _tmp73_;
	_tmp74_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp74_, 0.0f, 0.5f);
	_tmp75_ = label;
	g_object_set ((GtkWidget*) _tmp75_, "expand", TRUE, NULL);
	_tmp76_ = grid;
	_tmp77_ = label;
	gtk_grid_attach (_tmp76_, (GtkWidget*) _tmp77_, 0, 1, 1, 1);
	_tmp78_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp78_);
	_g_object_unref0 (combo);
	combo = _tmp78_;
	_tmp79_ = combo;
	g_signal_connect_object (_tmp79_, "changed", (GCallback) _iagno_light_level_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp80_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp80_);
	_g_object_unref0 (renderer);
	renderer = _tmp80_;
	_tmp81_ = combo;
	_tmp82_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp81_, (GtkCellRenderer*) _tmp82_, TRUE);
	_tmp83_ = combo;
	_tmp84_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp83_, (GtkCellRenderer*) _tmp84_, "text", 0);
	_tmp85_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (model);
	model = _tmp85_;
	_tmp86_ = combo;
	_tmp87_ = model;
	gtk_combo_box_set_model (_tmp86_, (GtkTreeModel*) _tmp87_);
	_tmp88_ = model;
	gtk_list_store_append (_tmp88_, &_tmp89_);
	iter = _tmp89_;
	_tmp90_ = model;
	_tmp91_ = iter;
	_tmp92_ = _ ("Human");
	gtk_list_store_set (_tmp90_, &_tmp91_, 0, _tmp92_, 1, 0, -1);
	_tmp93_ = self->priv->settings;
	_tmp94_ = g_settings_get_int (_tmp93_, "white-level");
	if (_tmp94_ == 0) {
		GtkComboBox* _tmp95_ = NULL;
		GtkTreeIter _tmp96_ = {0};
		_tmp95_ = combo;
		_tmp96_ = iter;
		gtk_combo_box_set_active_iter (_tmp95_, &_tmp96_);
	}
	_tmp97_ = model;
	gtk_list_store_append (_tmp97_, &_tmp98_);
	iter = _tmp98_;
	_tmp99_ = model;
	_tmp100_ = iter;
	_tmp101_ = _ ("Level one");
	gtk_list_store_set (_tmp99_, &_tmp100_, 0, _tmp101_, 1, 1, -1);
	_tmp102_ = self->priv->settings;
	_tmp103_ = g_settings_get_int (_tmp102_, "white-level");
	if (_tmp103_ == 1) {
		GtkComboBox* _tmp104_ = NULL;
		GtkTreeIter _tmp105_ = {0};
		_tmp104_ = combo;
		_tmp105_ = iter;
		gtk_combo_box_set_active_iter (_tmp104_, &_tmp105_);
	}
	_tmp106_ = model;
	gtk_list_store_append (_tmp106_, &_tmp107_);
	iter = _tmp107_;
	_tmp108_ = model;
	_tmp109_ = iter;
	_tmp110_ = _ ("Level two");
	gtk_list_store_set (_tmp108_, &_tmp109_, 0, _tmp110_, 1, 2, -1);
	_tmp111_ = self->priv->settings;
	_tmp112_ = g_settings_get_int (_tmp111_, "white-level");
	if (_tmp112_ == 2) {
		GtkComboBox* _tmp113_ = NULL;
		GtkTreeIter _tmp114_ = {0};
		_tmp113_ = combo;
		_tmp114_ = iter;
		gtk_combo_box_set_active_iter (_tmp113_, &_tmp114_);
	}
	_tmp115_ = model;
	gtk_list_store_append (_tmp115_, &_tmp116_);
	iter = _tmp116_;
	_tmp117_ = model;
	_tmp118_ = iter;
	_tmp119_ = _ ("Level three");
	gtk_list_store_set (_tmp117_, &_tmp118_, 0, _tmp119_, 1, 3, -1);
	_tmp120_ = self->priv->settings;
	_tmp121_ = g_settings_get_int (_tmp120_, "white-level");
	if (_tmp121_ == 3) {
		GtkComboBox* _tmp122_ = NULL;
		GtkTreeIter _tmp123_ = {0};
		_tmp122_ = combo;
		_tmp123_ = iter;
		gtk_combo_box_set_active_iter (_tmp122_, &_tmp123_);
	}
	_tmp124_ = grid;
	_tmp125_ = combo;
	gtk_grid_attach (_tmp124_, (GtkWidget*) _tmp125_, 1, 1, 1, 1);
	_tmp126_ = _ ("_Tile set:");
	_tmp127_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp126_);
	g_object_ref_sink (_tmp127_);
	_g_object_unref0 (label);
	label = _tmp127_;
	_tmp128_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp128_, 0.0f, 0.5f);
	_tmp129_ = label;
	g_object_set ((GtkWidget*) _tmp129_, "expand", TRUE, NULL);
	_tmp130_ = grid;
	_tmp131_ = label;
	gtk_grid_attach (_tmp130_, (GtkWidget*) _tmp131_, 0, 2, 1, 1);
	_tmp132_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp132_);
	theme_combo = _tmp132_;
	_tmp133_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp133_);
	_g_object_unref0 (renderer);
	renderer = _tmp133_;
	_tmp134_ = theme_combo;
	_tmp135_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp134_, (GtkCellRenderer*) _tmp135_, TRUE);
	_tmp136_ = theme_combo;
	_tmp137_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp136_, (GtkCellRenderer*) _tmp137_, "text", 0);
	_tmp138_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (model);
	model = _tmp138_;
	_tmp139_ = theme_combo;
	_tmp140_ = model;
	gtk_combo_box_set_model (_tmp139_, (GtkTreeModel*) _tmp140_);
	dirlist = NULL;
	{
		GDir* _tmp141_ = NULL;
		gchar* _tmp142_ = NULL;
		gchar* _tmp143_ = NULL;
		GDir* _tmp144_ = NULL;
		GDir* _tmp145_ = NULL;
		GDir* _tmp146_ = NULL;
		_tmp142_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
		_tmp143_ = _tmp142_;
		_tmp144_ = g_dir_open (_tmp143_, (guint) 0, &_inner_error_);
		_tmp145_ = _tmp144_;
		_g_free0 (_tmp143_);
		_tmp141_ = _tmp145_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			__g_list_free__g_free0_0 (dirlist);
			_g_dir_close0 (dir);
			_g_object_unref0 (theme_combo);
			_g_object_unref0 (model);
			_g_object_unref0 (renderer);
			_g_object_unref0 (combo);
			_g_object_unref0 (label);
			_g_object_unref0 (grid);
			_g_object_unref0 (box);
			_g_object_unref0 (propbox);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp146_ = _tmp141_;
		_tmp141_ = NULL;
		_g_dir_close0 (dir);
		dir = _tmp146_;
		while (TRUE) {
			gchar* filename = NULL;
			GDir* _tmp147_ = NULL;
			const gchar* _tmp148_ = NULL;
			gchar* _tmp149_ = NULL;
			const gchar* _tmp150_ = NULL;
			const gchar* _tmp151_ = NULL;
			gchar* _tmp152_ = NULL;
			GCompareFunc _tmp153_ = NULL;
			_tmp147_ = dir;
			_tmp148_ = g_dir_read_name (_tmp147_);
			_tmp149_ = g_strdup (_tmp148_);
			filename = _tmp149_;
			_tmp150_ = filename;
			if (_tmp150_ == NULL) {
				_g_free0 (filename);
				break;
			}
			_tmp151_ = filename;
			_tmp152_ = g_strdup (_tmp151_);
			_tmp153_ = g_strcmp0;
			dirlist = g_list_insert_sorted (dirlist, _tmp152_, _tmp153_);
			_g_free0 (filename);
		}
		_g_dir_close0 (_tmp141_);
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp154_ = NULL;
		const gchar* _tmp155_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp154_ = e;
		_tmp155_ = _tmp154_->message;
		g_warning ("iagno.vala:600: Failed to load themes: %s", _tmp155_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		__g_list_free__g_free0_0 (dirlist);
		_g_dir_close0 (dir);
		_g_object_unref0 (theme_combo);
		_g_object_unref0 (model);
		_g_object_unref0 (renderer);
		_g_object_unref0 (combo);
		_g_object_unref0 (label);
		_g_object_unref0 (grid);
		_g_object_unref0 (box);
		_g_object_unref0 (propbox);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp156_ = dirlist;
	{
		GList* filename_collection = NULL;
		GList* filename_it = NULL;
		filename_collection = _tmp156_;
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
			gchar* _tmp157_ = NULL;
			gchar* filename = NULL;
			_tmp157_ = g_strdup ((const gchar*) filename_it->data);
			filename = _tmp157_;
			{
				GtkListStore* _tmp158_ = NULL;
				GtkTreeIter _tmp159_ = {0};
				gchar* label_text = NULL;
				const gchar* _tmp160_ = NULL;
				gchar* _tmp161_ = NULL;
				const gchar* _tmp162_ = NULL;
				gchar* _tmp163_ = NULL;
				gint extension_index = 0;
				const gchar* _tmp164_ = NULL;
				gint _tmp165_ = 0;
				gint _tmp166_ = 0;
				GtkListStore* _tmp170_ = NULL;
				GtkTreeIter _tmp171_ = {0};
				const gchar* _tmp172_ = NULL;
				const gchar* _tmp173_ = NULL;
				const gchar* _tmp174_ = NULL;
				GSettings* _tmp175_ = NULL;
				gchar* _tmp176_ = NULL;
				gchar* _tmp177_ = NULL;
				gboolean _tmp178_ = FALSE;
				_tmp158_ = model;
				gtk_list_store_append (_tmp158_, &_tmp159_);
				iter = _tmp159_;
				_tmp160_ = filename;
				_tmp161_ = g_strdup (_tmp160_);
				label_text = _tmp161_;
				_tmp162_ = label_text;
				_tmp163_ = string_replace (_tmp162_, "_", " ");
				_g_free0 (label_text);
				label_text = _tmp163_;
				_tmp164_ = label_text;
				_tmp165_ = string_last_index_of_char (_tmp164_, (gunichar) '.', 0);
				extension_index = _tmp165_;
				_tmp166_ = extension_index;
				if (_tmp166_ > 0) {
					const gchar* _tmp167_ = NULL;
					gint _tmp168_ = 0;
					gchar* _tmp169_ = NULL;
					_tmp167_ = label_text;
					_tmp168_ = extension_index;
					_tmp169_ = string_substring (_tmp167_, (glong) 0, (glong) _tmp168_);
					_g_free0 (label_text);
					label_text = _tmp169_;
				}
				_tmp170_ = model;
				_tmp171_ = iter;
				_tmp172_ = label_text;
				_tmp173_ = filename;
				gtk_list_store_set (_tmp170_, &_tmp171_, 0, _tmp172_, 1, _tmp173_, -1);
				_tmp174_ = filename;
				_tmp175_ = self->priv->settings;
				_tmp176_ = g_settings_get_string (_tmp175_, "tileset");
				_tmp177_ = _tmp176_;
				_tmp178_ = g_strcmp0 (_tmp174_, _tmp177_) == 0;
				_g_free0 (_tmp177_);
				if (_tmp178_) {
					GtkComboBox* _tmp179_ = NULL;
					GtkTreeIter _tmp180_ = {0};
					_tmp179_ = theme_combo;
					_tmp180_ = iter;
					gtk_combo_box_set_active_iter (_tmp179_, &_tmp180_);
				}
				_g_free0 (label_text);
				_g_free0 (filename);
			}
		}
	}
	_tmp181_ = label;
	_tmp182_ = theme_combo;
	gtk_label_set_mnemonic_widget (_tmp181_, (GtkWidget*) _tmp182_);
	_tmp183_ = theme_combo;
	g_signal_connect_object (_tmp183_, "changed", (GCallback) _iagno_theme_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp184_ = grid;
	_tmp185_ = theme_combo;
	gtk_grid_attach (_tmp184_, (GtkWidget*) _tmp185_, 1, 2, 1, 1);
	_tmp186_ = _ ("E_nable sounds");
	_tmp187_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp186_);
	g_object_ref_sink (_tmp187_);
	enable_sounds_button = _tmp187_;
	_tmp188_ = self->priv->settings;
	_tmp189_ = g_settings_get_boolean (_tmp188_, "sound");
	gtk_toggle_button_set_active ((GtkToggleButton*) enable_sounds_button, _tmp189_);
	g_signal_connect_object ((GtkToggleButton*) enable_sounds_button, "toggled", (GCallback) _iagno_sound_select_gtk_toggle_button_toggled, self, 0);
	_tmp190_ = grid;
	gtk_grid_attach (_tmp190_, (GtkWidget*) enable_sounds_button, 0, 3, 2, 1);
	_tmp191_ = propbox;
	gtk_widget_show_all ((GtkWidget*) _tmp191_);
	_g_object_unref0 (enable_sounds_button);
	__g_list_free__g_free0_0 (dirlist);
	_g_dir_close0 (dir);
	_g_object_unref0 (theme_combo);
	_g_object_unref0 (model);
	_g_object_unref0 (renderer);
	_g_object_unref0 (combo);
	_g_object_unref0 (label);
	_g_object_unref0 (grid);
	_g_object_unref0 (box);
	_g_object_unref0 (propbox);
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionGroup* _tmp3_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp10_ = NULL;
	Iagno* app = NULL;
	Iagno* _tmp11_ = NULL;
	gint _result_ = 0;
	Iagno* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (NULL);
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_add_main_entries (_tmp1_, IAGNO_options, GETTEXT_PACKAGE);
	_tmp2_ = context;
	_tmp3_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_ = NULL;
		_tmp4_ = context;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp8_ = iagno_show_version;
	if (_tmp8_) {
		FILE* _tmp9_ = NULL;
		_tmp9_ = stderr;
		fprintf (_tmp9_, "iagno %s\n", VERSION);
		result = EXIT_SUCCESS;
		_g_option_context_free0 (context);
		return result;
	}
	_tmp10_ = _ ("Iagno");
	g_set_application_name (_tmp10_);
	gtk_window_set_default_icon_name ("iagno");
	_tmp11_ = iagno_new ();
	app = _tmp11_;
	_tmp12_ = app;
	_tmp13_ = g_application_run ((GApplication*) _tmp12_, 0, NULL);
	_result_ = _tmp13_;
	result = _result_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return iagno_main (argv, argc);
}


static void iagno_class_init (IagnoClass * klass) {
	iagno_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
	G_APPLICATION_CLASS (klass)->startup = iagno_real_startup;
	G_APPLICATION_CLASS (klass)->activate = iagno_real_activate;
	G_APPLICATION_CLASS (klass)->shutdown = iagno_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
}


static void iagno_instance_init (Iagno * self) {
	self->priv = IAGNO_GET_PRIVATE (self);
	self->priv->light_computer = NULL;
	self->priv->dark_computer = NULL;
	self->priv->computer_timer = (guint) 0;
	self->priv->game = NULL;
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->dark_label);
	_g_object_unref0 (self->priv->dark_score_label);
	_g_object_unref0 (self->priv->light_label);
	_g_object_unref0 (self->priv->light_score_label);
	_g_object_unref0 (self->priv->light_computer);
	_g_object_unref0 (self->priv->dark_computer);
	_g_object_unref0 (self->priv->game);
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



