/* chess-engine-uci.c generated by valac 0.23.3.25-02b39, the Vala compiler
 * generated from chess-engine-uci.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _ChessEngineUCIPrivate ChessEngineUCIPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*undo) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
};

struct _ChessEngineUCI {
	ChessEngine parent_instance;
	ChessEngineUCIPrivate * priv;
};

struct _ChessEngineUCIClass {
	ChessEngineClass parent_class;
};

struct _ChessEngineUCIPrivate {
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* moves;
	gchar** options;
	gint options_length1;
	gint _options_size_;
	gchar* go_options;
	gboolean waiting_for_move;
};


static gpointer chess_engine_uci_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_UCI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIPrivate))
enum  {
	CHESS_ENGINE_UCI_DUMMY_PROPERTY
};
ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds);
static gchar** _vala_array_dup23 (gchar** self, int length);
static void chess_engine_uci_start_cb (ChessEngineUCI* self);
static void _chess_engine_uci_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
static void chess_engine_uci_real_start_game (ChessEngine* base);
static void chess_engine_uci_real_request_move (ChessEngine* base);
static void chess_engine_uci_real_report_move (ChessEngine* base, ChessMove* move);
gchar* chess_move_get_engine (ChessMove* self);
static void chess_engine_uci_real_undo (ChessEngine* base);
static void chess_engine_uci_real_process_input (ChessEngine* base, gchar* data, int data_length1);
static void chess_engine_uci_configure (ChessEngineUCI* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static gchar* _vala_array_dup24 (gchar* self, int length);
static gchar** _vala_array_dup25 (gchar** self, int length);
static void chess_engine_uci_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar** _vala_array_dup23 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == (-1)) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp59_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != (-1)) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == (-1)) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp57_ = NULL;
				void* _tmp58_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				_tmp53_ = _tmp56_;
				if (_tmp53_ == NULL) {
					_tmp53_ = "";
				}
				_tmp57_ = ptr;
				_tmp58_ = g_stpcpy (_tmp57_, _tmp53_);
				ptr = _tmp58_;
			}
		}
		_tmp59_ = res;
		res = NULL;
		result = (gchar*) _tmp59_;
		return result;
	} else {
		gchar* _tmp60_ = NULL;
		_tmp60_ = g_strdup ("");
		result = _tmp60_;
		return result;
	}
}


static void _chess_engine_uci_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self) {
	chess_engine_uci_start_cb ((ChessEngineUCI*) self);
}


ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1) {
	ChessEngineUCI * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	guint _tmp2_ = 0U;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (binary != NULL, NULL);
	_tmp0_ = binary;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = delay_seconds;
	self = (ChessEngineUCI*) chess_engine_construct (object_type, _tmp0_, _tmp1_, _tmp1__length1, _tmp2_);
	_tmp3_ = options;
	_tmp3__length1 = options_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup23 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->options = _tmp4_;
	self->priv->options_length1 = _tmp4__length1;
	self->priv->_options_size_ = self->priv->options_length1;
	_tmp5_ = go_options;
	_tmp5__length1 = go_options_length1;
	_tmp6_ = _vala_g_strjoinv (" ", _tmp5_, _tmp5__length1);
	_g_free0 (self->priv->go_options);
	self->priv->go_options = _tmp6_;
	_tmp7_ = g_new0 (gchar, 0);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = _tmp7_;
	self->priv->buffer_length1 = 0;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	_tmp8_ = g_strdup ("");
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp8_;
	g_signal_connect_object ((ChessEngine*) self, "starting", (GCallback) _chess_engine_uci_start_cb_chess_engine_starting, self, 0);
	return self;
}


ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1) {
	return chess_engine_uci_construct (TYPE_CHESS_ENGINE_UCI, binary, args, args_length1, delay_seconds, options, options_length1, go_options, go_options_length1);
}


static void chess_engine_uci_start_cb (ChessEngineUCI* self) {
	g_return_if_fail (self != NULL);
	chess_engine_write_line ((ChessEngine*) self, "uci");
}


static void chess_engine_uci_real_start_game (ChessEngine* base) {
	ChessEngineUCI * self;
	self = (ChessEngineUCI*) base;
	chess_engine_write_line ((ChessEngine*) self, "ucinewgame");
}


static void chess_engine_uci_real_request_move (ChessEngine* base) {
	ChessEngineUCI * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	self = (ChessEngineUCI*) base;
	_tmp0_ = self->priv->moves;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = self->priv->moves;
		_tmp2_ = g_strconcat ("position startpos moves", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		chess_engine_write_line ((ChessEngine*) self, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		chess_engine_write_line ((ChessEngine*) self, "position startpos");
	}
	self->priv->waiting_for_move = TRUE;
	_tmp4_ = self->priv->go_options;
	_tmp5_ = g_strdup_printf ("go wtime 30000 btime 30000 %s", _tmp4_);
	_tmp6_ = _tmp5_;
	chess_engine_write_line ((ChessEngine*) self, _tmp6_);
	_g_free0 (_tmp6_);
}


static void chess_engine_uci_real_report_move (ChessEngine* base, ChessMove* move) {
	ChessEngineUCI * self;
	const gchar* _tmp0_ = NULL;
	ChessMove* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	self = (ChessEngineUCI*) base;
	g_return_if_fail (move != NULL);
	_tmp0_ = self->priv->moves;
	_tmp1_ = move;
	_tmp2_ = chess_move_get_engine (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (" ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp0_, _tmp5_, NULL);
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void chess_engine_uci_real_undo (ChessEngine* base) {
	ChessEngineUCI * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	self = (ChessEngineUCI*) base;
	_tmp0_ = self->priv->waiting_for_move;
	if (_tmp0_) {
		chess_engine_write_line ((ChessEngine*) self, "stop");
	}
	self->priv->waiting_for_move = FALSE;
	_tmp1_ = self->priv->moves;
	_tmp2_ = self->priv->moves;
	_tmp3_ = string_last_index_of (_tmp2_, " ", 0);
	_tmp4_ = string_slice (_tmp1_, (glong) 0, (glong) _tmp3_);
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp4_;
}


static gchar* _vala_array_dup24 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static void chess_engine_uci_real_process_input (ChessEngine* base, gchar* data, int data_length1) {
	ChessEngineUCI * self;
	gint current = 0;
	gchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	self = (ChessEngineUCI*) base;
	_tmp0_ = self->priv->buffer;
	_tmp0__length1 = self->priv->buffer_length1;
	current = _tmp0__length1;
	_tmp1_ = self->priv->buffer;
	_tmp1__length1 = self->priv->buffer_length1;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	_tmp3_ = (gint) (_tmp1__length1 + _tmp2__length1);
	self->priv->buffer = g_renew (gchar, self->priv->buffer, (gint) (_tmp1__length1 + _tmp2__length1));
	(_tmp3_ > self->priv->buffer_length1) ? memset (self->priv->buffer + self->priv->buffer_length1, 0, sizeof (gchar) * (_tmp3_ - self->priv->buffer_length1)) : NULL;
	self->priv->buffer_length1 = _tmp3_;
	self->priv->_buffer_size_ = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				gchar* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gchar* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gchar* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				gchar _tmp13_ = '\0';
				gchar _tmp14_ = '\0';
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = data;
				_tmp7__length1 = data_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->priv->buffer;
				_tmp8__length1 = self->priv->buffer_length1;
				_tmp9_ = current;
				_tmp10_ = i;
				_tmp11_ = data;
				_tmp11__length1 = data_length1;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				_tmp8_[_tmp9_ + _tmp10_] = _tmp13_;
				_tmp14_ = _tmp8_[_tmp9_ + _tmp10_];
			}
		}
	}
	while (TRUE) {
		gint offset = 0;
		gint _tmp23_ = 0;
		gchar* _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		gchar* _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gint _tmp26_ = 0;
		gchar _tmp27_ = '\0';
		gchar* line = NULL;
		gchar* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar** tokens = NULL;
		const gchar* _tmp31_ = NULL;
		gchar** _tmp32_ = NULL;
		gchar** _tmp33_ = NULL;
		gint tokens_length1 = 0;
		gint _tokens_size_ = 0;
		gchar** _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		gchar* _tmp50_ = NULL;
		gint _tmp50__length1 = 0;
		gint _tmp51_ = 0;
		gchar* _tmp52_ = NULL;
		gint _tmp52__length1 = 0;
		gchar* _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
		{
			gboolean _tmp15_ = FALSE;
			offset = 0;
			_tmp15_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_ = FALSE;
				gint _tmp18_ = 0;
				gchar* _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				if (!_tmp15_) {
					gint _tmp16_ = 0;
					_tmp16_ = offset;
					offset = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp18_ = offset;
				_tmp19_ = self->priv->buffer;
				_tmp19__length1 = self->priv->buffer_length1;
				if (_tmp18_ < _tmp19__length1) {
					gchar* _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					gint _tmp21_ = 0;
					gchar _tmp22_ = '\0';
					_tmp20_ = self->priv->buffer;
					_tmp20__length1 = self->priv->buffer_length1;
					_tmp21_ = offset;
					_tmp22_ = _tmp20_[_tmp21_];
					_tmp17_ = _tmp22_ != '\n';
				} else {
					_tmp17_ = FALSE;
				}
				if (!_tmp17_) {
					break;
				}
			}
		}
		_tmp23_ = offset;
		_tmp24_ = self->priv->buffer;
		_tmp24__length1 = self->priv->buffer_length1;
		if (_tmp23_ >= _tmp24__length1) {
			return;
		}
		_tmp25_ = self->priv->buffer;
		_tmp25__length1 = self->priv->buffer_length1;
		_tmp26_ = offset;
		_tmp25_[_tmp26_] = '\0';
		_tmp27_ = _tmp25_[_tmp26_];
		_tmp28_ = self->priv->buffer;
		_tmp28__length1 = self->priv->buffer_length1;
		_tmp29_ = g_strdup ((const gchar*) _tmp28_);
		line = _tmp29_;
		_tmp30_ = line;
		g_debug ("chess-engine-uci.vala:84: Read from engine: '%s'", _tmp30_);
		_tmp31_ = line;
		_tmp33_ = _tmp32_ = g_strsplit (_tmp31_, " ", 0);
		tokens = _tmp33_;
		tokens_length1 = _vala_array_length (_tmp32_);
		_tokens_size_ = tokens_length1;
		_tmp34_ = tokens;
		_tmp34__length1 = tokens_length1;
		if (_tmp34__length1 > 0) {
			gchar** _tmp35_ = NULL;
			gint _tmp35__length1 = 0;
			const gchar* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			GQuark _tmp39_ = 0U;
			static GQuark _tmp38_label0 = 0;
			static GQuark _tmp38_label1 = 0;
			static GQuark _tmp38_label2 = 0;
			_tmp35_ = tokens;
			_tmp35__length1 = tokens_length1;
			_tmp36_ = _tmp35_[0];
			_tmp37_ = _tmp36_;
			_tmp39_ = (NULL == _tmp37_) ? 0 : g_quark_from_string (_tmp37_);
			if (_tmp39_ == ((0 != _tmp38_label0) ? _tmp38_label0 : (_tmp38_label0 = g_quark_from_static_string ("uciok")))) {
				switch (0) {
					default:
					{
						gchar** _tmp40_ = NULL;
						gint _tmp40__length1 = 0;
						_tmp40_ = tokens;
						_tmp40__length1 = tokens_length1;
						if (_tmp40__length1 != 1) {
							const gchar* _tmp41_ = NULL;
							_tmp41_ = line;
							g_warning ("chess-engine-uci.vala:93: Unexpected arguments on uciok: %s", _tmp41_);
						}
						chess_engine_uci_configure (self);
						break;
					}
				}
			} else if (_tmp39_ == ((0 != _tmp38_label1) ? _tmp38_label1 : (_tmp38_label1 = g_quark_from_static_string ("readyok")))) {
				switch (0) {
					default:
					{
						gchar** _tmp42_ = NULL;
						gint _tmp42__length1 = 0;
						_tmp42_ = tokens;
						_tmp42__length1 = tokens_length1;
						if (_tmp42__length1 != 1) {
							const gchar* _tmp43_ = NULL;
							_tmp43_ = line;
							g_warning ("chess-engine-uci.vala:100: Unexpected arguments on readyok: %s", _tmp43_);
						}
						chess_engine_set_ready ((ChessEngine*) self, TRUE);
						break;
					}
				}
			} else if (_tmp39_ == ((0 != _tmp38_label2) ? _tmp38_label2 : (_tmp38_label2 = g_quark_from_static_string ("bestmove")))) {
				switch (0) {
					default:
					{
						gchar** _tmp44_ = NULL;
						gint _tmp44__length1 = 0;
						gchar** _tmp46_ = NULL;
						gint _tmp46__length1 = 0;
						const gchar* _tmp47_ = NULL;
						gchar** _tmp48_ = NULL;
						gint _tmp48__length1 = 0;
						const gchar* _tmp49_ = NULL;
						_tmp44_ = tokens;
						_tmp44__length1 = tokens_length1;
						if (_tmp44__length1 < 2) {
							const gchar* _tmp45_ = NULL;
							_tmp45_ = line;
							g_warning ("chess-engine-uci.vala:107: No move with bestmove: %s", _tmp45_);
						}
						_tmp46_ = tokens;
						_tmp46__length1 = tokens_length1;
						_tmp47_ = _tmp46_[1];
						g_debug ("chess-engine-uci.vala:108: Engine moves %s", _tmp47_);
						self->priv->waiting_for_move = FALSE;
						_tmp48_ = tokens;
						_tmp48__length1 = tokens_length1;
						_tmp49_ = _tmp48_[1];
						g_signal_emit_by_name ((ChessEngine*) self, "moved", _tmp49_);
						break;
					}
				}
			}
		}
		_tmp50_ = self->priv->buffer;
		_tmp50__length1 = self->priv->buffer_length1;
		_tmp51_ = offset;
		_tmp52_ = self->priv->buffer;
		_tmp52__length1 = self->priv->buffer_length1;
		_tmp53_ = ((_tmp50_ + (_tmp51_ + 1)) != NULL) ? _vala_array_dup24 (_tmp50_ + (_tmp51_ + 1), _tmp52__length1 - (_tmp51_ + 1)) : ((gpointer) (_tmp50_ + (_tmp51_ + 1)));
		_tmp53__length1 = _tmp52__length1 - (_tmp51_ + 1);
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
		self->priv->buffer = _tmp53_;
		self->priv->buffer_length1 = _tmp53__length1;
		self->priv->_buffer_size_ = self->priv->buffer_length1;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
	}
}


static gchar** _vala_array_dup25 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void chess_engine_uci_configure (ChessEngineUCI* self) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->options;
	_tmp0__length1 = self->priv->options_length1;
	{
		gchar** o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp0_;
		o_collection_length1 = _tmp0__length1;
		for (o_it = 0; o_it < _tmp0__length1; o_it = o_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* o = NULL;
			_tmp1_ = g_strdup (o_collection[o_it]);
			o = _tmp1_;
			{
				gchar** line = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint line_length1 = 0;
				gint _line_size_ = 0;
				gchar* option_value = NULL;
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gchar* option_name = NULL;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				_tmp2_ = o;
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
				line = _tmp4_;
				line_length1 = _vala_array_length (_tmp3_);
				_line_size_ = line_length1;
				_tmp5_ = line;
				_tmp5__length1 = line_length1;
				_tmp6_ = line;
				_tmp6__length1 = line_length1;
				_tmp7_ = _tmp5_[_tmp6__length1 - 1];
				_tmp8_ = g_strdup (_tmp7_);
				option_value = _tmp8_;
				_tmp9_ = line;
				_tmp9__length1 = line_length1;
				_tmp10_ = line;
				_tmp10__length1 = line_length1;
				_tmp11_ = ((_tmp9_ + 0) != NULL) ? _vala_array_dup25 (_tmp9_ + 0, (_tmp10__length1 - 1) - 0) : ((gpointer) (_tmp9_ + 0));
				_tmp11__length1 = (_tmp10__length1 - 1) - 0;
				line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
				line = _tmp11_;
				line_length1 = _tmp11__length1;
				_line_size_ = line_length1;
				_tmp12_ = line;
				_tmp12__length1 = line_length1;
				_tmp13_ = _vala_g_strjoinv (" ", _tmp12_, _tmp12__length1);
				option_name = _tmp13_;
				_tmp14_ = option_name;
				_tmp15_ = option_value;
				_tmp16_ = g_strdup_printf ("setoption name %s value %s", _tmp14_, _tmp15_);
				_tmp17_ = _tmp16_;
				chess_engine_write_line ((ChessEngine*) self, _tmp17_);
				_g_free0 (_tmp17_);
				_g_free0 (option_name);
				_g_free0 (option_value);
				line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (o);
			}
		}
	}
	chess_engine_write_line ((ChessEngine*) self, "isready");
}


static void chess_engine_uci_class_init (ChessEngineUCIClass * klass) {
	chess_engine_uci_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessEngineUCIPrivate));
	CHESS_ENGINE_CLASS (klass)->start_game = chess_engine_uci_real_start_game;
	CHESS_ENGINE_CLASS (klass)->request_move = chess_engine_uci_real_request_move;
	CHESS_ENGINE_CLASS (klass)->report_move = chess_engine_uci_real_report_move;
	CHESS_ENGINE_CLASS (klass)->undo = chess_engine_uci_real_undo;
	CHESS_ENGINE_CLASS (klass)->process_input = chess_engine_uci_real_process_input;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_uci_finalize;
}


static void chess_engine_uci_instance_init (ChessEngineUCI * self) {
	self->priv = CHESS_ENGINE_UCI_GET_PRIVATE (self);
}


static void chess_engine_uci_finalize (GObject* obj) {
	ChessEngineUCI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE_UCI, ChessEngineUCI);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	_g_free0 (self->priv->moves);
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->go_options);
	G_OBJECT_CLASS (chess_engine_uci_parent_class)->finalize (obj);
}


GType chess_engine_uci_get_type (void) {
	static volatile gsize chess_engine_uci_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_uci_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineUCIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_uci_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngineUCI), 0, (GInstanceInitFunc) chess_engine_uci_instance_init, NULL };
		GType chess_engine_uci_type_id;
		chess_engine_uci_type_id = g_type_register_static (TYPE_CHESS_ENGINE, "ChessEngineUCI", &g_define_type_info, 0);
		g_once_init_leave (&chess_engine_uci_type_id__volatile, chess_engine_uci_type_id);
	}
	return chess_engine_uci_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



