/* test-stage.c generated by valac 0.23.1.3-23cc3-dirty, the Vala compiler
 * generated from test-stage.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "libgitg/libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <gitg-assert.h>


#define GITG_TEST_TYPE_TEST (gitg_test_test_get_type ())
#define GITG_TEST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_TEST, GitgTestTest))
#define GITG_TEST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_TEST, GitgTestTestClass))
#define GITG_TEST_IS_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_TEST))
#define GITG_TEST_IS_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_TEST))
#define GITG_TEST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_TEST, GitgTestTestClass))

typedef struct _GitgTestTest GitgTestTest;
typedef struct _GitgTestTestClass GitgTestTestClass;
typedef struct _GitgTestTestPrivate GitgTestTestPrivate;

#define GITG_TEST_TYPE_REPOSITORY (gitg_test_repository_get_type ())
#define GITG_TEST_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepository))
#define GITG_TEST_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))
#define GITG_TEST_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))

typedef struct _GitgTestRepository GitgTestRepository;
typedef struct _GitgTestRepositoryClass GitgTestRepositoryClass;
typedef struct _GitgTestRepositoryPrivate GitgTestRepositoryPrivate;

#define GITG_TEST_TYPE_STAGE (gitg_test_stage_get_type ())
#define GITG_TEST_STAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_STAGE, GitgTestStage))
#define GITG_TEST_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_STAGE, GitgTestStageClass))
#define GITG_TEST_IS_STAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_STAGE))
#define GITG_TEST_IS_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_STAGE))
#define GITG_TEST_STAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_STAGE, GitgTestStageClass))

typedef struct _GitgTestStage GitgTestStage;
typedef struct _GitgTestStageClass GitgTestStageClass;
typedef struct _GitgTestStagePrivate GitgTestStagePrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GitgTestTest {
	GObject parent_instance;
	GitgTestTestPrivate * priv;
};

struct _GitgTestTestClass {
	GObjectClass parent_class;
	void (*set_up) (GitgTestTest* self);
	void (*tear_down) (GitgTestTest* self);
};

struct _GitgTestRepository {
	GitgTestTest parent_instance;
	GitgTestRepositoryPrivate * priv;
	GitgRepository* d_repository;
};

struct _GitgTestRepositoryClass {
	GitgTestTestClass parent_class;
};

struct _GitgTestStage {
	GitgTestRepository parent_instance;
	GitgTestStagePrivate * priv;
};

struct _GitgTestStageClass {
	GitgTestRepositoryClass parent_class;
	void (*test_file_status) (GitgTestStage* self);
	void (*test_stage) (GitgTestStage* self);
	void (*test_unstage) (GitgTestStage* self);
	void (*test_revert) (GitgTestStage* self);
	void (*test_delete) (GitgTestStage* self);
};

struct _Block1Data {
	int _ref_count_;
	GitgTestStage* self;
	GeeHashSet* seen;
	GitgStageStatusEnumerator* e;
	GMainLoop* loop;
	GeeHashMap* cfiles;
};

struct _Block2Data {
	int _ref_count_;
	GitgTestStage* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block3Data {
	int _ref_count_;
	GitgTestStage* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block4Data {
	int _ref_count_;
	GitgTestStage* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block5Data {
	int _ref_count_;
	GitgTestStage* self;
	GitgStage* stage;
	GMainLoop* loop;
};


static gpointer gitg_test_stage_parent_class = NULL;

GType gitg_test_test_get_type (void) G_GNUC_CONST;
GType gitg_test_repository_get_type (void) G_GNUC_CONST;
GType gitg_test_stage_get_type (void) G_GNUC_CONST;
enum  {
	GITG_TEST_STAGE_DUMMY_PROPERTY
};
static void gitg_test_stage_real_set_up (GitgTestTest* base);
void gitg_test_test_set_up (GitgTestTest* self);
void gitg_test_repository_commit (GitgTestRepository* self, const gchar* filename, ...);
void gitg_test_repository_workdir_remove (GitgTestRepository* self, const gchar* filename, ...);
void gitg_test_repository_workdir_modify (GitgTestRepository* self, const gchar* filename, ...);
void gitg_test_repository_index_modify (GitgTestRepository* self, const gchar* filename, ...);
static void gitg_test_stage_check_file_status (GitgTestStage* self, GMainLoop* loop, GeeHashMap* cfiles);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda2_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GitgTestStage* gitg_test_stage_new (void);
GitgTestStage* gitg_test_stage_construct (GType object_type);
GitgTestRepository* gitg_test_repository_new (void);
GitgTestRepository* gitg_test_repository_construct (GType object_type);
static void gitg_test_stage_real_test_file_status (GitgTestStage* self);
static void gitg_test_stage_real_test_stage (GitgTestStage* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda3_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_stage_real_test_unstage (GitgTestStage* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda4_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_stage_real_test_revert (GitgTestStage* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda5_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_stage_real_test_delete (GitgTestStage* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda6_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Create basic repository with files in a variety of states.
 */
static void gitg_test_stage_real_set_up (GitgTestTest* base) {
	GitgTestStage * self;
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	self = (GitgTestStage*) base;
#line 29 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	GITG_TEST_TEST_CLASS (gitg_test_stage_parent_class)->set_up ((GitgTestTest*) G_TYPE_CHECK_INSTANCE_CAST (self, GITG_TEST_TYPE_REPOSITORY, GitgTestRepository));
#line 32 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "a", "hello world\n", "b", "gitg test file\n", "c", "hello\n", NULL);
#line 36 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_repository_workdir_remove ((GitgTestRepository*) self, "c", NULL);
#line 37 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_repository_workdir_modify ((GitgTestRepository*) self, "a", "changed world\n", NULL);
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_repository_workdir_modify ((GitgTestRepository*) self, "b", "changed test\n", NULL);
#line 40 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_repository_index_modify ((GitgTestRepository*) self, "b", "staged changes\n", NULL);
#line 218 "test-stage.c"
}


static gpointer _g_main_loop_ref0 (gpointer self) {
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	return self ? g_main_loop_ref (self) : NULL;
#line 225 "test-stage.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	return self ? g_object_ref (self) : NULL;
#line 232 "test-stage.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	return _data1_;
#line 241 "test-stage.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 250 "test-stage.c"
		GitgTestStage* self;
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		self = _data1_->self;
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data1_->e);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data1_->seen);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_main_loop_unref0 (_data1_->loop);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data1_->cfiles);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_slice_free (Block1Data, _data1_);
#line 264 "test-stage.c"
	}
}


static void __lambda2_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	GitgTestStage* self;
	GitgStageStatusFile** files = NULL;
	GAsyncResult* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GitgStageStatusFile** _tmp2_ = NULL;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GitgStageStatusFile** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GeeHashMap* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GitgStageStatusFile** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GeeHashSet* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	GMainLoop* _tmp32_ = NULL;
#line 55 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	self = _data1_->self;
#line 55 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (res != NULL);
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = res;
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = gitg_stage_status_enumerator_next_files_finish (_data1_->e, _tmp0_, &_tmp1_);
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	files = _tmp2_;
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	files_length1 = _tmp1_;
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_files_size_ = files_length1;
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = files;
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3__length1 = files_length1;
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp4_ = _data1_->cfiles;
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp5_ = gee_abstract_map_get_size ((GeeMap*) _tmp4_);
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp6_ = _tmp5_;
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_vala_assert (_tmp3__length1 == _tmp6_, "files.length == cfiles.size");
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp7_ = files;
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp7__length1 = files_length1;
#line 318 "test-stage.c"
	{
		GitgStageStatusFile** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		f_collection = _tmp7_;
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		f_collection_length1 = _tmp7__length1;
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		for (f_it = 0; f_it < _tmp7__length1; f_it = f_it + 1) {
#line 330 "test-stage.c"
			GitgStageStatusFile* _tmp8_ = NULL;
			GitgStageStatusFile* f = NULL;
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp8_ = _g_object_ref0 (f_collection[f_it]);
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			f = _tmp8_;
#line 337 "test-stage.c"
			{
				GeeHashMap* _tmp9_ = NULL;
				GitgStageStatusFile* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				GeeHashMap* _tmp15_ = NULL;
				GitgStageStatusFile* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gpointer _tmp20_ = NULL;
				GitgStageStatusFile* _tmp21_ = NULL;
				GgitStatusFlags _tmp22_ = 0;
				GgitStatusFlags _tmp23_ = 0;
				GeeHashSet* _tmp24_ = NULL;
				GitgStageStatusFile* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp9_ = _data1_->cfiles;
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp10_ = f;
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp11_ = gitg_stage_status_file_get_path (_tmp10_);
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp12_ = _tmp11_;
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp13_ = _tmp12_;
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp14_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, _tmp13_);
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_vala_assert (_tmp14_, "cfiles.has_key(f.path)");
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_g_free0 (_tmp13_);
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp15_ = _data1_->cfiles;
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp16_ = f;
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp17_ = gitg_stage_status_file_get_path (_tmp16_);
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp18_ = _tmp17_;
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp19_ = _tmp18_;
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp19_);
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp21_ = f;
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp22_ = gitg_stage_status_file_get_flags (_tmp21_);
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp23_ = _tmp22_;
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				gitg_test_assert_assert_inteq ((gint) ((GgitStatusFlags) ((gintptr) _tmp20_)), (gint) _tmp23_);
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_g_free0 (_tmp19_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp24_ = _data1_->seen;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp25_ = f;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp26_ = gitg_stage_status_file_get_path (_tmp25_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp27_ = _tmp26_;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp28_ = _tmp27_;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp24_, _tmp28_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_g_free0 (_tmp28_);
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				_g_object_unref0 (f);
#line 413 "test-stage.c"
			}
		}
	}
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp29_ = _data1_->seen;
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp29_);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp31_ = _tmp30_;
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_vala_assert (_tmp31_ == 0, "seen.size == 0");
#line 69 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp32_ = _data1_->loop;
#line 69 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_quit (_tmp32_);
#line 55 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 431 "test-stage.c"
}


static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 55 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	__lambda2_ (self, source_object, res);
#line 55 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	block1_data_unref (self);
#line 440 "test-stage.c"
}


static void gitg_test_stage_check_file_status (GitgTestStage* self, GMainLoop* loop, GeeHashMap* cfiles) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GitgStage* stage = NULL;
	GitgRepository* _tmp17_ = NULL;
	GitgStage* _tmp18_ = NULL;
	GitgStage* _tmp19_ = NULL;
	GitgStageStatusEnumerator* _tmp20_ = NULL;
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (loop != NULL);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (cfiles != NULL);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->_ref_count_ = 1;
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->self = g_object_ref (self);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = loop;
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = _g_main_loop_ref0 (_tmp0_);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_main_loop_unref0 (_data1_->loop);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->loop = _tmp1_;
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = cfiles;
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (_data1_->cfiles);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->cfiles = _tmp3_;
#line 45 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 45 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->seen = _tmp4_;
#line 488 "test-stage.c"
	{
		GeeIterator* _f_it = NULL;
		GeeHashMap* _tmp5_ = NULL;
		GeeSet* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		GeeSet* _tmp8_ = NULL;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _tmp10_ = NULL;
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp5_ = _data1_->cfiles;
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp7_ = _tmp6_;
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp8_ = _tmp7_;
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp10_ = _tmp9_;
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_tmp8_);
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_f_it = _tmp10_;
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		while (TRUE) {
#line 515 "test-stage.c"
			GeeIterator* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gchar* f = NULL;
			GeeIterator* _tmp13_ = NULL;
			gpointer _tmp14_ = NULL;
			GeeHashSet* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp11_ = _f_it;
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp12_ = gee_iterator_next (_tmp11_);
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			if (!_tmp12_) {
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
				break;
#line 531 "test-stage.c"
			}
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp13_ = _f_it;
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			f = (gchar*) _tmp14_;
#line 49 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp15_ = _data1_->seen;
#line 49 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp16_ = f;
#line 49 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
			_g_free0 (f);
#line 547 "test-stage.c"
		}
#line 47 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_f_it);
#line 551 "test-stage.c"
	}
#line 52 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp17_ = ((GitgTestRepository*) self)->d_repository;
#line 52 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp18_ = gitg_repository_get_stage (_tmp17_);
#line 52 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp19_ = _tmp18_;
#line 52 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	stage = _tmp19_;
#line 53 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp20_ = gitg_stage_file_status (stage, NULL);
#line 53 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->e = _tmp20_;
#line 55 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_stage_status_enumerator_next_files (_data1_->e, -1, ___lambda2__gasync_ready_callback, block1_data_ref (_data1_));
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (stage);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	block1_data_unref (_data1_);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_ = NULL;
#line 573 "test-stage.c"
}


GitgTestStage* gitg_test_stage_construct (GType object_type) {
	GitgTestStage * self = NULL;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	self = (GitgTestStage*) gitg_test_repository_construct (object_type);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	return self;
#line 583 "test-stage.c"
}


GitgTestStage* gitg_test_stage_new (void) {
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	return gitg_test_stage_construct (GITG_TEST_TYPE_STAGE);
#line 590 "test-stage.c"
}


static void gitg_test_stage_real_test_file_status (GitgTestStage* self) {
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GMainLoop* loop = NULL;
	GMainLoop* _tmp1_ = NULL;
#line 79 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 79 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	m = _tmp0_;
#line 81 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "a", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_MODIFIED));
#line 82 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "b", (gpointer) ((gintptr) (GGIT_STATUS_WORKING_TREE_MODIFIED | GGIT_STATUS_INDEX_MODIFIED)));
#line 83 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "c", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_DELETED));
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = g_main_loop_new (NULL, FALSE);
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	loop = _tmp1_;
#line 87 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_stage_check_file_status (self, loop, m);
#line 88 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_run (loop);
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_main_loop_unref0 (loop);
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (m);
#line 621 "test-stage.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	return _data2_;
#line 630 "test-stage.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 639 "test-stage.c"
		GitgTestStage* self;
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		self = _data2_->self;
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_main_loop_unref0 (_data2_->loop);
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data2_->stage);
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_slice_free (Block2Data, _data2_);
#line 649 "test-stage.c"
	}
}


static void __lambda3_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	GitgTestStage* self;
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	self = _data2_->self;
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (res != NULL);
#line 663 "test-stage.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 103 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp0_ = res;
#line 103 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_stage_stage_finish (_data2_->stage, _tmp0_, &_inner_error_);
#line 103 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		if (_inner_error_ != NULL) {
#line 672 "test-stage.c"
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
#line 101 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		e = _inner_error_;
#line 101 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_inner_error_ = NULL;
#line 104 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp1_ = e;
#line 104 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_test_assert_assert_no_error (_tmp1_);
#line 101 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_error_free0 (e);
#line 691 "test-stage.c"
	}
	__finally15:
#line 101 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	if (_inner_error_ != NULL) {
#line 101 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 101 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_clear_error (&_inner_error_);
#line 101 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		return;
#line 702 "test-stage.c"
	}
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	m = _tmp2_;
#line 108 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "a", (gpointer) ((gintptr) GGIT_STATUS_INDEX_MODIFIED));
#line 109 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "b", (gpointer) ((gintptr) (GGIT_STATUS_WORKING_TREE_MODIFIED | GGIT_STATUS_INDEX_MODIFIED)));
#line 110 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "c", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_DELETED));
#line 112 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_stage_check_file_status (self, _data2_->loop, m);
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (m);
#line 718 "test-stage.c"
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	__lambda3_ (self, source_object, res);
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	block2_data_unref (self);
#line 727 "test-stage.c"
}


static void gitg_test_stage_real_test_stage (GitgTestStage* self) {
	Block2Data* _data2_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_->_ref_count_ = 1;
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_->self = g_object_ref (self);
#line 96 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 96 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 96 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = _tmp1_;
#line 96 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_->stage = _tmp2_;
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_->loop = _tmp3_;
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_stage_stage_path (_data2_->stage, "a", ___lambda3__gasync_ready_callback, block2_data_ref (_data2_));
#line 115 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_run (_data2_->loop);
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	block2_data_unref (_data2_);
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_ = NULL;
#line 763 "test-stage.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	return _data3_;
#line 772 "test-stage.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 781 "test-stage.c"
		GitgTestStage* self;
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		self = _data3_->self;
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_main_loop_unref0 (_data3_->loop);
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data3_->stage);
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_slice_free (Block3Data, _data3_);
#line 791 "test-stage.c"
	}
}


static void __lambda4_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res) {
	GitgTestStage* self;
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 127 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	self = _data3_->self;
#line 127 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (res != NULL);
#line 805 "test-stage.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 130 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp0_ = res;
#line 130 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_stage_unstage_finish (_data3_->stage, _tmp0_, &_inner_error_);
#line 130 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		if (_inner_error_ != NULL) {
#line 814 "test-stage.c"
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		e = _inner_error_;
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_inner_error_ = NULL;
#line 131 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp1_ = e;
#line 131 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_test_assert_assert_no_error (_tmp1_);
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_error_free0 (e);
#line 833 "test-stage.c"
	}
	__finally16:
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	if (_inner_error_ != NULL) {
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_clear_error (&_inner_error_);
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		return;
#line 844 "test-stage.c"
	}
#line 133 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 133 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	m = _tmp2_;
#line 135 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "a", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_MODIFIED));
#line 136 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "b", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_MODIFIED));
#line 137 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "c", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_DELETED));
#line 139 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_stage_check_file_status (self, _data3_->loop, m);
#line 127 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (m);
#line 860 "test-stage.c"
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 127 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	__lambda4_ (self, source_object, res);
#line 127 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	block3_data_unref (self);
#line 869 "test-stage.c"
}


static void gitg_test_stage_real_test_unstage (GitgTestStage* self) {
	Block3Data* _data3_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_->_ref_count_ = 1;
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_->self = g_object_ref (self);
#line 123 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 123 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 123 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = _tmp1_;
#line 123 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_->stage = _tmp2_;
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_->loop = _tmp3_;
#line 127 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_stage_unstage_path (_data3_->stage, "b", ___lambda4__gasync_ready_callback, block3_data_ref (_data3_));
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_run (_data3_->loop);
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	block3_data_unref (_data3_);
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_ = NULL;
#line 905 "test-stage.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	return _data4_;
#line 914 "test-stage.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 923 "test-stage.c"
		GitgTestStage* self;
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		self = _data4_->self;
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_main_loop_unref0 (_data4_->loop);
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data4_->stage);
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_slice_free (Block4Data, _data4_);
#line 933 "test-stage.c"
	}
}


static void __lambda5_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	GitgTestStage* self;
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 154 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	self = _data4_->self;
#line 154 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (res != NULL);
#line 947 "test-stage.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp0_ = res;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_stage_revert_finish (_data4_->stage, _tmp0_, &_inner_error_);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		if (_inner_error_ != NULL) {
#line 956 "test-stage.c"
			goto __catch17_g_error;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		e = _inner_error_;
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_inner_error_ = NULL;
#line 158 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp1_ = e;
#line 158 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_test_assert_assert_no_error (_tmp1_);
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_error_free0 (e);
#line 975 "test-stage.c"
	}
	__finally17:
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	if (_inner_error_ != NULL) {
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_clear_error (&_inner_error_);
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		return;
#line 986 "test-stage.c"
	}
#line 160 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 160 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	m = _tmp2_;
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "b", (gpointer) ((gintptr) (GGIT_STATUS_INDEX_MODIFIED | GGIT_STATUS_WORKING_TREE_MODIFIED)));
#line 163 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "c", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_DELETED));
#line 165 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_stage_check_file_status (self, _data4_->loop, m);
#line 154 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (m);
#line 1000 "test-stage.c"
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 154 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	__lambda5_ (self, source_object, res);
#line 154 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	block4_data_unref (self);
#line 1009 "test-stage.c"
}


static void gitg_test_stage_real_test_revert (GitgTestStage* self) {
	Block4Data* _data4_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_->_ref_count_ = 1;
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_->self = g_object_ref (self);
#line 150 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 150 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 150 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = _tmp1_;
#line 150 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_->stage = _tmp2_;
#line 152 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 152 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_->loop = _tmp3_;
#line 154 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_stage_revert_path (_data4_->stage, "a", ___lambda5__gasync_ready_callback, block4_data_ref (_data4_));
#line 168 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_run (_data4_->loop);
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	block4_data_unref (_data4_);
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_ = NULL;
#line 1045 "test-stage.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	return _data5_;
#line 1054 "test-stage.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 1063 "test-stage.c"
		GitgTestStage* self;
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		self = _data5_->self;
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_main_loop_unref0 (_data5_->loop);
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data5_->stage);
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_slice_free (Block5Data, _data5_);
#line 1073 "test-stage.c"
	}
}


static void __lambda6_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	GitgTestStage* self;
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	self = _data5_->self;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (res != NULL);
#line 1087 "test-stage.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 183 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp0_ = res;
#line 183 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_stage_delete_finish (_data5_->stage, _tmp0_, &_inner_error_);
#line 183 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		if (_inner_error_ != NULL) {
#line 1096 "test-stage.c"
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
#line 181 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		e = _inner_error_;
#line 181 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_inner_error_ = NULL;
#line 184 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp1_ = e;
#line 184 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_test_assert_assert_no_error (_tmp1_);
#line 181 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_error_free0 (e);
#line 1115 "test-stage.c"
	}
	__finally18:
#line 181 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	if (_inner_error_ != NULL) {
#line 181 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 181 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		g_clear_error (&_inner_error_);
#line 181 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
		return;
#line 1126 "test-stage.c"
	}
#line 186 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 186 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	m = _tmp2_;
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "a", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_MODIFIED));
#line 189 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "b", (gpointer) ((gintptr) (GGIT_STATUS_INDEX_MODIFIED | GGIT_STATUS_WORKING_TREE_MODIFIED)));
#line 190 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "c", (gpointer) ((gintptr) GGIT_STATUS_INDEX_DELETED));
#line 192 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_stage_check_file_status (self, _data5_->loop, m);
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (m);
#line 1142 "test-stage.c"
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	__lambda6_ (self, source_object, res);
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	block5_data_unref (self);
#line 1151 "test-stage.c"
}


static void gitg_test_stage_real_test_delete (GitgTestStage* self) {
	Block5Data* _data5_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_->_ref_count_ = 1;
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_->self = g_object_ref (self);
#line 176 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 176 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 176 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = _tmp1_;
#line 176 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_->stage = _tmp2_;
#line 178 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 178 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_->loop = _tmp3_;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_stage_delete_path (_data5_->stage, "c", ___lambda6__gasync_ready_callback, block5_data_ref (_data5_));
#line 195 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_run (_data5_->loop);
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	block5_data_unref (_data5_);
#line 174 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_ = NULL;
#line 1187 "test-stage.c"
}


static void gitg_test_stage_class_init (GitgTestStageClass * klass) {
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_stage_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	GITG_TEST_TEST_CLASS (klass)->set_up = gitg_test_stage_real_set_up;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	GITG_TEST_STAGE_CLASS (klass)->test_file_status = gitg_test_stage_real_test_file_status;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	GITG_TEST_STAGE_CLASS (klass)->test_stage = gitg_test_stage_real_test_stage;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	GITG_TEST_STAGE_CLASS (klass)->test_unstage = gitg_test_stage_real_test_unstage;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	GITG_TEST_STAGE_CLASS (klass)->test_revert = gitg_test_stage_real_test_revert;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	GITG_TEST_STAGE_CLASS (klass)->test_delete = gitg_test_stage_real_test_delete;
#line 1206 "test-stage.c"
	/**
	 * Test whether the different file statuses created by the set_up()
	 * are properly reported by the stage file status enumerator.
	 */
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_signal_new ("test_file_status", GITG_TEST_TYPE_STAGE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestStageClass, test_file_status), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1213 "test-stage.c"
	/**
	 * test staging a complete file in the index.
	 */
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_signal_new ("test_stage", GITG_TEST_TYPE_STAGE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestStageClass, test_stage), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1219 "test-stage.c"
	/**
	 * test staging a complete file in the index.
	 */
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_signal_new ("test_unstage", GITG_TEST_TYPE_STAGE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestStageClass, test_unstage), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1225 "test-stage.c"
	/**
	 * test reverting a complete file in the index.
	 */
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_signal_new ("test_revert", GITG_TEST_TYPE_STAGE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestStageClass, test_revert), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1231 "test-stage.c"
	/**
	 * test deleting a file in the index.
	 */
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-stage.vala"
	g_signal_new ("test_delete", GITG_TEST_TYPE_STAGE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestStageClass, test_delete), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1237 "test-stage.c"
}


static void gitg_test_stage_instance_init (GitgTestStage * self) {
}


GType gitg_test_stage_get_type (void) {
	static volatile gsize gitg_test_stage_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_test_stage_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgTestStageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_test_stage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgTestStage), 0, (GInstanceInitFunc) gitg_test_stage_instance_init, NULL };
		GType gitg_test_stage_type_id;
		gitg_test_stage_type_id = g_type_register_static (GITG_TEST_TYPE_REPOSITORY, "GitgTestStage", &g_define_type_info, 0);
		g_once_init_leave (&gitg_test_stage_type_id__volatile, gitg_test_stage_type_id);
	}
	return gitg_test_stage_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



