/* chess-move.c generated by valac 0.24.0.24-2ca24a, the Vala compiler
 * generated from chess-move.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ChessMovePrivate ChessMovePrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHECK_STATE (check_state_get_type ())
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_COLOR (color_get_type ())
#define _chess_move_unref0(var) ((var == NULL) ? NULL : (var = (chess_move_unref (var), NULL)))
typedef struct _ParamSpecChessMove ParamSpecChessMove;

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessMove {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GTypeClass parent_class;
	void (*finalize) (ChessMove *self);
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ParamSpecChessMove {
	GParamSpec parent_instance;
};


static gpointer chess_move_parent_class = NULL;

gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
GType check_state_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_MOVE_DUMMY_PROPERTY
};
gchar* chess_move_get_lan (ChessMove* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType piece_type_get_type (void) G_GNUC_CONST;
gchar* chess_move_get_san (ChessMove* self);
static gchar* chess_move_make_san (ChessMove* self, gchar** piece_names, int piece_names_length1);
gchar* chess_move_get_fan (ChessMove* self);
GType color_get_type (void) G_GNUC_CONST;
Color chess_piece_get_color (ChessPiece* self);
gchar* chess_move_get_engine (ChessMove* self);
ChessMove* chess_move_copy (ChessMove* self);
ChessMove* chess_move_new (void);
ChessMove* chess_move_construct (GType object_type);
static void chess_move_finalize (ChessMove* obj);


gchar* chess_move_get_lan (ChessMove* self) {
	gchar* result = NULL;
	ChessPiece* _tmp0_ = NULL;
	GString* builder = NULL;
	GString* _tmp5_ = NULL;
	ChessPiece* _tmp6_ = NULL;
	static const gchar promotion_symbols[] = {' ', 'R', 'N', 'B', 'Q', 'K'};
	ChessPiece* _tmp17_ = NULL;
	CheckState _tmp22_ = 0;
	GString* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->moved_rook;
	if (_tmp0_ != NULL) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp1_ = self->f1;
		_tmp2_ = self->f0;
		if (_tmp1_ > _tmp2_) {
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("O-O");
			result = _tmp3_;
			return result;
		} else {
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("O-O-O");
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = g_string_new ("");
	builder = _tmp5_;
	_tmp6_ = self->victim;
	if (_tmp6_ != NULL) {
		GString* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp7_ = builder;
		_tmp8_ = self->f0;
		_tmp9_ = self->r0;
		_tmp10_ = self->f1;
		_tmp11_ = self->r1;
		g_string_append_printf (_tmp7_, "%c%dx%c%d", 'a' + _tmp8_, _tmp9_ + 1, 'a' + _tmp10_, _tmp11_ + 1);
	} else {
		GString* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		_tmp12_ = builder;
		_tmp13_ = self->f0;
		_tmp14_ = self->r0;
		_tmp15_ = self->f1;
		_tmp16_ = self->r1;
		g_string_append_printf (_tmp12_, "%c%d-%c%d", 'a' + _tmp13_, _tmp14_ + 1, 'a' + _tmp15_, _tmp16_ + 1);
	}
	_tmp17_ = self->promotion_piece;
	if (_tmp17_ != NULL) {
		GString* _tmp18_ = NULL;
		ChessPiece* _tmp19_ = NULL;
		PieceType _tmp20_ = 0;
		gchar _tmp21_ = '\0';
		_tmp18_ = builder;
		_tmp19_ = self->promotion_piece;
		_tmp20_ = _tmp19_->type;
		_tmp21_ = promotion_symbols[_tmp20_];
		g_string_append_printf (_tmp18_, "=%c", (gint) _tmp21_);
	}
	_tmp22_ = self->check_state;
	switch (_tmp22_) {
		case CHECK_STATE_CHECK:
		{
			GString* _tmp23_ = NULL;
			_tmp23_ = builder;
			g_string_append_c (_tmp23_, '+');
			break;
		}
		case CHECK_STATE_CHECKMATE:
		{
			GString* _tmp24_ = NULL;
			_tmp24_ = builder;
			g_string_append_c (_tmp24_, '#');
			break;
		}
		default:
		break;
	}
	_tmp25_ = builder;
	_tmp26_ = _tmp25_->str;
	_tmp27_ = g_strdup (_tmp26_);
	result = _tmp27_;
	_g_string_free0 (builder);
	return result;
}


gchar* chess_move_get_san (ChessMove* self) {
	gchar* result = NULL;
	static const gchar* piece_names[] = {"", "R", "N", "B", "Q", "K"};
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_move_make_san (self, (gchar**) piece_names, (G_N_ELEMENTS (piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
	result = _tmp0_;
	return result;
}


gchar* chess_move_get_fan (ChessMove* self) {
	gchar* result = NULL;
	static const gchar* white_piece_names[] = {"", "♖", "♘", "♗", "♕", "♔"};
	static const gchar* black_piece_names[] = {"", "♜", "♞", "♝", "♛", "♚"};
	ChessPiece* _tmp0_ = NULL;
	Color _tmp1_ = 0;
	Color _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->piece;
	_tmp1_ = chess_piece_get_color (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == COLOR_WHITE) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = chess_move_make_san (self, (gchar**) white_piece_names, (G_N_ELEMENTS (white_piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
		result = _tmp3_;
		return result;
	} else {
		gchar* _tmp4_ = NULL;
		_tmp4_ = chess_move_make_san (self, (gchar**) black_piece_names, (G_N_ELEMENTS (black_piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
		result = _tmp4_;
		return result;
	}
}


static gchar* chess_move_make_san (ChessMove* self, gchar** piece_names, int piece_names_length1) {
	gchar* result = NULL;
	ChessPiece* _tmp0_ = NULL;
	GString* builder = NULL;
	GString* _tmp5_ = NULL;
	GString* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	ChessPiece* _tmp8_ = NULL;
	PieceType _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp14_ = FALSE;
	ChessPiece* _tmp17_ = NULL;
	GString* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	ChessPiece* _tmp22_ = NULL;
	CheckState _tmp28_ = 0;
	GString* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->moved_rook;
	if (_tmp0_ != NULL) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp1_ = self->f1;
		_tmp2_ = self->f0;
		if (_tmp1_ > _tmp2_) {
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("O-O");
			result = _tmp3_;
			return result;
		} else {
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("O-O-O");
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = g_string_new ("");
	builder = _tmp5_;
	_tmp6_ = builder;
	_tmp7_ = piece_names;
	_tmp7__length1 = piece_names_length1;
	_tmp8_ = self->piece;
	_tmp9_ = _tmp8_->type;
	_tmp10_ = _tmp7_[_tmp9_];
	g_string_append (_tmp6_, _tmp10_);
	_tmp11_ = self->ambiguous_file;
	if (_tmp11_) {
		GString* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		_tmp12_ = builder;
		_tmp13_ = self->f0;
		g_string_append_printf (_tmp12_, "%c", 'a' + _tmp13_);
	}
	_tmp14_ = self->ambiguous_rank;
	if (_tmp14_) {
		GString* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		_tmp15_ = builder;
		_tmp16_ = self->r0;
		g_string_append_printf (_tmp15_, "%d", _tmp16_ + 1);
	}
	_tmp17_ = self->victim;
	if (_tmp17_ != NULL) {
		GString* _tmp18_ = NULL;
		_tmp18_ = builder;
		g_string_append (_tmp18_, "x");
	}
	_tmp19_ = builder;
	_tmp20_ = self->f1;
	_tmp21_ = self->r1;
	g_string_append_printf (_tmp19_, "%c%d", 'a' + _tmp20_, _tmp21_ + 1);
	_tmp22_ = self->promotion_piece;
	if (_tmp22_ != NULL) {
		GString* _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		ChessPiece* _tmp25_ = NULL;
		PieceType _tmp26_ = 0;
		const gchar* _tmp27_ = NULL;
		_tmp23_ = builder;
		_tmp24_ = piece_names;
		_tmp24__length1 = piece_names_length1;
		_tmp25_ = self->promotion_piece;
		_tmp26_ = _tmp25_->type;
		_tmp27_ = _tmp24_[_tmp26_];
		g_string_append_printf (_tmp23_, "=%s", _tmp27_);
	}
	_tmp28_ = self->check_state;
	switch (_tmp28_) {
		case CHECK_STATE_CHECK:
		{
			GString* _tmp29_ = NULL;
			_tmp29_ = builder;
			g_string_append_c (_tmp29_, '+');
			break;
		}
		case CHECK_STATE_CHECKMATE:
		{
			GString* _tmp30_ = NULL;
			_tmp30_ = builder;
			g_string_append_c (_tmp30_, '#');
			break;
		}
		default:
		break;
	}
	_tmp31_ = builder;
	_tmp32_ = _tmp31_->str;
	_tmp33_ = g_strdup (_tmp32_);
	result = _tmp33_;
	_g_string_free0 (builder);
	return result;
}


gchar* chess_move_get_engine (ChessMove* self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	static const gchar promotion_symbols[] = {' ', 'r', 'n', 'b', 'q', ' '};
	ChessPiece* _tmp1_ = NULL;
	GString* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->promotion_piece;
	if (_tmp1_ != NULL) {
		GString* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		ChessPiece* _tmp7_ = NULL;
		PieceType _tmp8_ = 0;
		gchar _tmp9_ = '\0';
		_tmp2_ = builder;
		_tmp3_ = self->f0;
		_tmp4_ = self->r0;
		_tmp5_ = self->f1;
		_tmp6_ = self->r1;
		_tmp7_ = self->promotion_piece;
		_tmp8_ = _tmp7_->type;
		_tmp9_ = promotion_symbols[_tmp8_];
		g_string_append_printf (_tmp2_, "%c%d%c%d%c", 'a' + _tmp3_, _tmp4_ + 1, 'a' + _tmp5_, _tmp6_ + 1, (gint) _tmp9_);
	} else {
		GString* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp10_ = builder;
		_tmp11_ = self->f0;
		_tmp12_ = self->r0;
		_tmp13_ = self->f1;
		_tmp14_ = self->r1;
		g_string_append_printf (_tmp10_, "%c%d%c%d", 'a' + _tmp11_, _tmp12_ + 1, 'a' + _tmp13_, _tmp14_ + 1);
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}


static gpointer _chess_piece_ref0 (gpointer self) {
	return self ? chess_piece_ref (self) : NULL;
}


ChessMove* chess_move_copy (ChessMove* self) {
	ChessMove* result = NULL;
	ChessMove* move = NULL;
	ChessMove* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ChessPiece* _tmp2_ = NULL;
	ChessPiece* _tmp3_ = NULL;
	ChessPiece* _tmp4_ = NULL;
	ChessPiece* _tmp5_ = NULL;
	ChessPiece* _tmp6_ = NULL;
	ChessPiece* _tmp7_ = NULL;
	ChessPiece* _tmp8_ = NULL;
	ChessPiece* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	CheckState _tmp16_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_move_new ();
	move = _tmp0_;
	_tmp1_ = self->number;
	move->number = _tmp1_;
	_tmp2_ = self->piece;
	_tmp3_ = _chess_piece_ref0 (_tmp2_);
	_chess_piece_unref0 (move->piece);
	move->piece = _tmp3_;
	_tmp4_ = self->promotion_piece;
	_tmp5_ = _chess_piece_ref0 (_tmp4_);
	_chess_piece_unref0 (move->promotion_piece);
	move->promotion_piece = _tmp5_;
	_tmp6_ = self->moved_rook;
	_tmp7_ = _chess_piece_ref0 (_tmp6_);
	_chess_piece_unref0 (move->moved_rook);
	move->moved_rook = _tmp7_;
	_tmp8_ = self->victim;
	_tmp9_ = _chess_piece_ref0 (_tmp8_);
	_chess_piece_unref0 (move->victim);
	move->victim = _tmp9_;
	_tmp10_ = self->r0;
	move->r0 = _tmp10_;
	_tmp11_ = self->f0;
	move->f0 = _tmp11_;
	_tmp12_ = self->r1;
	move->r1 = _tmp12_;
	_tmp13_ = self->f1;
	move->f1 = _tmp13_;
	_tmp14_ = self->ambiguous_rank;
	move->ambiguous_rank = _tmp14_;
	_tmp15_ = self->ambiguous_file;
	move->ambiguous_file = _tmp15_;
	_tmp16_ = self->check_state;
	move->check_state = _tmp16_;
	result = move;
	return result;
}


ChessMove* chess_move_construct (GType object_type) {
	ChessMove* self = NULL;
	self = (ChessMove*) g_type_create_instance (object_type);
	return self;
}


ChessMove* chess_move_new (void) {
	return chess_move_construct (TYPE_CHESS_MOVE);
}


static void value_chess_move_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_chess_move_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		chess_move_unref (value->data[0].v_pointer);
	}
}


static void value_chess_move_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = chess_move_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_chess_move_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_chess_move_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ChessMove* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = chess_move_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_chess_move_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessMove** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = chess_move_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessMove* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_MOVE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_chess_move (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE), NULL);
	return value->data[0].v_pointer;
}


void value_set_chess_move (GValue* value, gpointer v_object) {
	ChessMove* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MOVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		chess_move_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_move_unref (old);
	}
}


void value_take_chess_move (GValue* value, gpointer v_object) {
	ChessMove* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MOVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_move_unref (old);
	}
}


static void chess_move_class_init (ChessMoveClass * klass) {
	chess_move_parent_class = g_type_class_peek_parent (klass);
	CHESS_MOVE_CLASS (klass)->finalize = chess_move_finalize;
}


static void chess_move_instance_init (ChessMove * self) {
	self->ref_count = 1;
}


static void chess_move_finalize (ChessMove* obj) {
	ChessMove * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_MOVE, ChessMove);
	_chess_piece_unref0 (self->piece);
	_chess_piece_unref0 (self->promotion_piece);
	_chess_piece_unref0 (self->moved_rook);
	_chess_piece_unref0 (self->victim);
}


GType chess_move_get_type (void) {
	static volatile gsize chess_move_type_id__volatile = 0;
	if (g_once_init_enter (&chess_move_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_move_init, value_chess_move_free_value, value_chess_move_copy_value, value_chess_move_peek_pointer, "p", value_chess_move_collect_value, "p", value_chess_move_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessMoveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_move_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessMove), 0, (GInstanceInitFunc) chess_move_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_move_type_id;
		chess_move_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessMove", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_move_type_id__volatile, chess_move_type_id);
	}
	return chess_move_type_id__volatile;
}


gpointer chess_move_ref (gpointer instance) {
	ChessMove* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void chess_move_unref (gpointer instance) {
	ChessMove* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHESS_MOVE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



