/* gnome-klotski.c generated by valac 0.24.0.88-5dc64, the Vala compiler
 * generated from gnome-klotski.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Puzzle Info */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <locale.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>


#define TYPE_LEVEL_INFO (level_info_get_type ())
typedef struct _LevelInfo LevelInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_KLOTSKI (klotski_get_type ())
#define KLOTSKI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KLOTSKI, Klotski))
#define KLOTSKI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KLOTSKI, KlotskiClass))
#define IS_KLOTSKI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KLOTSKI))
#define IS_KLOTSKI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KLOTSKI))
#define KLOTSKI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KLOTSKI, KlotskiClass))

typedef struct _Klotski Klotski;
typedef struct _KlotskiClass KlotskiClass;
typedef struct _KlotskiPrivate KlotskiPrivate;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _puzzle_unref0(var) ((var == NULL) ? NULL : (var = (puzzle_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_CELL_RENDERER_LEVEL (cell_renderer_level_get_type ())
#define CELL_RENDERER_LEVEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CELL_RENDERER_LEVEL, CellRendererLevel))
#define CELL_RENDERER_LEVEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CELL_RENDERER_LEVEL, CellRendererLevelClass))
#define IS_CELL_RENDERER_LEVEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CELL_RENDERER_LEVEL))
#define IS_CELL_RENDERER_LEVEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CELL_RENDERER_LEVEL))
#define CELL_RENDERER_LEVEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CELL_RENDERER_LEVEL, CellRendererLevelClass))

typedef struct _CellRendererLevel CellRendererLevel;
typedef struct _CellRendererLevelClass CellRendererLevelClass;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;
#define _history_entry_unref0(var) ((var == NULL) ? NULL : (var = (history_entry_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
typedef struct _CellRendererLevelPrivate CellRendererLevelPrivate;

struct _LevelInfo {
	gchar* name;
	gint group;
	gint width;
	gint height;
	gchar* data;
};

struct _Klotski {
	GtkApplication parent_instance;
	KlotskiPrivate * priv;
};

struct _KlotskiClass {
	GtkApplicationClass parent_class;
};

struct _KlotskiPrivate {
	GSettings* settings;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_maximized;
	GtkBox* puzzles_panel;
	GtkButton* next_button;
	GtkButton* prev_button;
	GSimpleAction* next_level_action;
	GSimpleAction* prev_level_action;
	GSimpleAction* new_game_action;
	PuzzleView* view;
	GtkHeaderBar* headerbar;
	Puzzle* puzzle;
	gint current_level;
	History* history;
	GtkTreeStore* puzzles;
	GtkTreeIter* puzzles_items;
	gint puzzles_items_length1;
	gint _puzzles_items_size_;
};

struct _Puzzle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GTypeClass parent_class;
	void (*finalize) (Puzzle *self);
};

struct _CellRendererLevel {
	GtkCellRenderer parent_instance;
	CellRendererLevelPrivate * priv;
};

struct _CellRendererLevelClass {
	GtkCellRendererClass parent_class;
};


static gpointer klotski_parent_class = NULL;
static gpointer cell_renderer_level_parent_class = NULL;

GType level_info_get_type (void) G_GNUC_CONST;
LevelInfo* level_info_dup (const LevelInfo* self);
void level_info_free (LevelInfo* self);
void level_info_copy (const LevelInfo* self, LevelInfo* dest);
void level_info_destroy (LevelInfo* self);
GType klotski_get_type (void) G_GNUC_CONST;
GType puzzle_view_get_type (void) G_GNUC_CONST;
gpointer puzzle_ref (gpointer instance);
void puzzle_unref (gpointer instance);
GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle (GValue* value, gpointer v_object);
void value_take_puzzle (GValue* value, gpointer v_object);
gpointer value_get_puzzle (const GValue* value);
GType puzzle_get_type (void) G_GNUC_CONST;
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
#define KLOTSKI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KLOTSKI, KlotskiPrivate))
enum  {
	KLOTSKI_DUMMY_PROPERTY
};
#define KLOTSKI_MINWIDTH 250
#define KLOTSKI_MINHEIGHT 250
#define KLOTSKI_SPACE_PADDING 5
#define KLOTSKI_KEY_LEVEL "level"
static void klotski_restart_level_cb (Klotski* self);
static void _klotski_restart_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_toggle_puzzles_cb (Klotski* self);
static void _klotski_toggle_puzzles_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_next_level_cb (Klotski* self);
static void _klotski_next_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_prev_level_cb (Klotski* self);
static void _klotski_prev_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_scores_cb (Klotski* self);
static void _klotski_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_help_cb (Klotski* self);
static void _klotski_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_about_cb (Klotski* self);
static void _klotski_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_quit_cb (Klotski* self);
static void _klotski_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Klotski* klotski_new (void);
Klotski* klotski_construct (GType object_type);
static void klotski_real_startup (GApplication* base);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_load (History* self);
static gboolean klotski_window_configure_event_cb (Klotski* self, GdkEventConfigure* event);
static gboolean _klotski_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean klotski_window_state_event_cb (Klotski* self, GdkEventWindowState* event);
static gboolean _klotski_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void klotski_render_puzzle_name (GtkCellLayout* cell_layout, GtkCellRendererText* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
CellRendererLevel* cell_renderer_level_new (void);
CellRendererLevel* cell_renderer_level_construct (GType object_type);
GType cell_renderer_level_get_type (void) G_GNUC_CONST;
static void klotski_level_cb (Klotski* self, GtkTreePath* path, GtkTreeViewColumn* column);
static void _klotski_level_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void _klotski_prev_level_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _klotski_next_level_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void klotski_load_solved_state (Klotski* self);
static void klotski_new_game (Klotski* self, gint requested_level);
gpointer history_entry_ref (gpointer instance);
void history_entry_unref (gpointer instance);
GParamSpec* param_spec_history_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history_entry (GValue* value, gpointer v_object);
void value_take_history_entry (GValue* value, gpointer v_object);
gpointer value_get_history_entry (const GValue* value);
GType history_entry_get_type (void) G_GNUC_CONST;
static gint klotski_show_scores (Klotski* self, HistoryEntry* selected_entry, gboolean show_close);
static void klotski_game_score (Klotski* self);
static gchar* klotski_get_level_key (Klotski* self, gint level_number);
HistoryEntry* history_entry_new (GDateTime* date, guint level, guint moves);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, guint level, guint moves);
void history_add (History* self, HistoryEntry* entry);
void history_save (History* self);
GType score_dialog_get_type (void) G_GNUC_CONST;
ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_close);
ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_close);
static void klotski_update_menu_state (Klotski* self);
static void klotski_update_moves_label (Klotski* self);
Puzzle* puzzle_new (gint width, gint height, const gchar* data);
Puzzle* puzzle_construct (GType object_type, gint width, gint height, const gchar* data);
static void klotski_puzzle_moved_cb (Klotski* self);
static void _klotski_puzzle_moved_cb_puzzle_moved (Puzzle* _sender, gpointer self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
gboolean puzzle_game_over (Puzzle* self);
static void klotski_real_shutdown (GApplication* base);
static void klotski_real_activate (GApplication* base);
gint klotski_main (gchar** args, int args_length1);
static void klotski_finalize (GObject* obj);
enum  {
	CELL_RENDERER_LEVEL_DUMMY_PROPERTY
};
#define CELL_RENDERER_LEVEL_icon_size 10
static void cell_renderer_level_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height);
static void cell_renderer_level_real_render (GtkCellRenderer* base, cairo_t* ctx, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags);

const LevelInfo KLOTSKI_level[28] = {{"Only 18 Steps", 0, 6, 9, "######" "#a**b#" "#m**n#" "#cdef#" "#ghij#" "#k  l#" "##--##" "    .." "    .."}, {"Daisy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#zghi#" "#j  k#" "##--##" "    .." "    .."}, {"Violet", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghi#" "#j  k#" "##--##" "    .." "    .."}, {"Poppy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#fghi#" "#j  k#" "##--##" "    .." "    .."}, {"Pansy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghf#" "#i  j#" "##--##" "    .." "    .."}, {"Snowdrop", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfgh#" "#i  j#" "##--##" "    .." "    .."}, {"Red Donkey", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfge#" "#h  i#" "##--##" "    .." "    .."}, {"Trail", 0, 6, 9, "######" "#a**c#" "#a**c#" "#eddg#" "#hffj#" "# ii #" "##--##" "    .." "    .."}, {"Ambush", 0, 6, 9, "######" "#a**c#" "#d**e#" "#dffe#" "#ghhi#" "# jj #" "##--##" "    .." "    .."}, {"Agatka", 1, 7, 7, "..     " ".      " "#####--" "#**aab-" "#*ccde#" "#fgh  #" "#######"}, {"Success", 1, 9, 6, "#######  " "#**bbc#  " "#defgh#  " "#ijkgh-  " "#llk  #  " "#######.."}, {"Bone", 1, 6, 9, "######" "#abc*#" "# dd*#" "# ee*#" "# fgh#" "##-###" "     ." "     ." "     ."}, {"Fortune", 1, 7, 10, "     .." "     . " "####-. " "#ab  - " "#ccd # " "#ccd # " "#**ee# " "#*fgh# " "#*iih# " "###### "}, {"Fool", 1, 10, 6, "  ########" "  -aabc  #" "  #aabdef#" "  #ijggef#" "  #klhh**#" "..########"}, {"Solomon", 1, 7, 9, " .     " "..     " "#--####" "#  aab#" "# cdfb#" "#hcefg#" "#hijk*#" "#hll**#" "#######"}, {"Cleopatra", 1, 6, 8, "######" "#abcd#" "#**ee#" "#f*g #" "#fh i-" "####--" "    .." "     ."}, {"Shark", 1, 11, 8, "########   " "#nrr s #   " "#n*op q#   " "#***jml#   " "#hhijkl#   " "#ffcddg-   " "#abcdde- . " "########..."}, {"Rome", 1, 8, 8, "########" "#abcc**#" "#ddeef*#" "#ddghfi#" "#   jki#" "#--#####" " ..     " "  .     "}, {"Pennant Puzzle", 1, 6, 9, "######" "#**aa#" "#**bb#" "#de  #" "#fghh#" "#fgii#" "#--###" "    .." "    .."}, {"Ithaca", 2, 19, 19, ".aaaaaaaaaaaaaaaaab" "..  cddeffffffffffb" " .. cddeffffffffffb" "  . cddeffffffffffb" "ggg-############hhb" "ggg-  ABCDEFFGH#hhb" "ggg-       FFIJ#hhb" "ggg#       KLMJ#hhb" "ggg#NNNNOOOPQMJ#hhb" "ggg#NNNNOOOP*RS#hhb" "ggg#TTTTTUVW**X#hhb" "ggg#YZ12222W3**#hhb" "ggg#YZ12222W34*#iib" "jjj#YZ155555367#klb" "jjj#############mmb" "jjjnooooooooooppppb" "jjjqooooooooooppppb" "       rrrssssppppb" "ttttttuvvvvvvvwwwwx"}, {"Pelopones", 2, 9, 8, "#########" "#abbb***#" "#abbb*c*#" "#adeefgg#" "#  eefhh#" "#... ihh#" "#. . ihh#" "#########"}, {"Transeuropa", 2, 15, 8, "    ###########" "    -AAAAABBCC#" "    -   DEFGHI#" "    #   DEFGJI#" "    #   KEFGLI#" "    #   KEFG*I#" "  . #   MM****#" "....###########"}, {"Lodzianka", 2, 9, 7, "#########" "#**abbcc#" "#**abbdd#" "#eefgh  #" "#iiijk..#" "#iiijk..#" "#########"}, {"Polonaise", 2, 7, 7, "#######" "#aab**#" "#aabc*#" "#defgg#" "#..fhh#" "# .ihh#" "#######"}, {"Baltic Sea", 2, 6, 8, "######" "#.abc#" "#.dec#" "#fggc#" "#fhhi#" "#fjk*#" "#flk*#" "######"}, {"American Pie", 2, 10, 12, "##########" "#a*bcdefg#" "#**bhhhhg#" "#*iijjkkg#" "#liimnoop#" "#qiirrr  #" "#qstuvv  #" "#qwwxvv  #" "######--##" "         ." "        .." "        . "}, {"Traffic Jam", 2, 10, 7, "########  " "#** ffi#  " "#** fgh#  " "#aacehh#  " "#bbdjlm-  " "#bddklm-.." "########.."}, {"Sunshine", 2, 17, 22, "       ...       " "      .. ..      " "      .   .      " "      .. ..      " "       ...       " "######-----######" "#hh0iilltmmpp;qq#" "#hh,iill mmpp:qq#" "#2y{45v s w89x/z#" "#jj6kkaa nnoo<rr#" "#jj7kkaaunnoo>rr#" "#33333TTJWW11111#" "#33333TTJWW11111#" "#33333GG HH11111#" "#33333YYIgg11111#" "#33333YYIgg11111#" "#ddFeeA***BffOZZ#" "#ddFee** **ffOZZ#" "#MMKQQ*   *PPS^^#" "#VVLXX** **bbRcc#" "#VVLXXD***EbbRcc#" "#################"}};
static const GActionEntry KLOTSKI_action_entries[8] = {{"new-game", _klotski_restart_level_cb_gsimple_action_activate_callback}, {"show-puzzles", _klotski_toggle_puzzles_cb_gsimple_action_activate_callback}, {"next-level", _klotski_next_level_cb_gsimple_action_activate_callback}, {"prev-level", _klotski_prev_level_cb_gsimple_action_activate_callback}, {"scores", _klotski_scores_cb_gsimple_action_activate_callback}, {"help", _klotski_help_cb_gsimple_action_activate_callback}, {"about", _klotski_about_cb_gsimple_action_activate_callback}, {"quit", _klotski_quit_cb_gsimple_action_activate_callback}};

void level_info_copy (const LevelInfo* self, LevelInfo* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).group;
	(*dest).group = _tmp2_;
	_tmp3_ = (*self).width;
	(*dest).width = _tmp3_;
	_tmp4_ = (*self).height;
	(*dest).height = _tmp4_;
	_tmp5_ = (*self).data;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).data);
	(*dest).data = _tmp6_;
}


void level_info_destroy (LevelInfo* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).data);
}


LevelInfo* level_info_dup (const LevelInfo* self) {
	LevelInfo* dup;
	dup = g_new0 (LevelInfo, 1);
	level_info_copy (self, dup);
	return dup;
}


void level_info_free (LevelInfo* self) {
	level_info_destroy (self);
	g_free (self);
}


GType level_info_get_type (void) {
	static volatile gsize level_info_type_id__volatile = 0;
	if (g_once_init_enter (&level_info_type_id__volatile)) {
		GType level_info_type_id;
		level_info_type_id = g_boxed_type_register_static ("LevelInfo", (GBoxedCopyFunc) level_info_dup, (GBoxedFreeFunc) level_info_free);
		g_once_init_leave (&level_info_type_id__volatile, level_info_type_id);
	}
	return level_info_type_id__volatile;
}


static void _klotski_restart_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_restart_level_cb ((Klotski*) self);
}


static void _klotski_toggle_puzzles_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_toggle_puzzles_cb ((Klotski*) self);
}


static void _klotski_next_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_next_level_cb ((Klotski*) self);
}


static void _klotski_prev_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_prev_level_cb ((Klotski*) self);
}


static void _klotski_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_scores_cb ((Klotski*) self);
}


static void _klotski_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_help_cb ((Klotski*) self);
}


static void _klotski_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_about_cb ((Klotski*) self);
}


static void _klotski_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_quit_cb ((Klotski*) self);
}


Klotski* klotski_construct (GType object_type) {
	Klotski * self = NULL;
	self = (Klotski*) g_object_new (object_type, "application-id", "org.gnome.klotski", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Klotski* klotski_new (void) {
	return klotski_construct (TYPE_KLOTSKI);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _klotski_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = klotski_window_configure_event_cb ((Klotski*) self, event);
	return result;
}


static gboolean _klotski_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = klotski_window_state_event_cb ((Klotski*) self, event);
	return result;
}


static void _klotski_level_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	klotski_level_cb ((Klotski*) self, path, column);
}


static void _klotski_prev_level_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	klotski_prev_level_cb ((Klotski*) self);
}


static void _klotski_next_level_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	klotski_next_level_cb ((Klotski*) self);
}


static void klotski_real_startup (GApplication* base) {
	Klotski * self;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	GAction* _tmp5_ = NULL;
	GSimpleAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	GSimpleAction* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* histfile = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	History* _tmp16_ = NULL;
	History* _tmp17_ = NULL;
	GtkHeaderBar* _tmp18_ = NULL;
	GtkHeaderBar* _tmp19_ = NULL;
	GtkHeaderBar* _tmp20_ = NULL;
	GtkApplicationWindow* _tmp21_ = NULL;
	GtkWindow* _tmp22_ = NULL;
	GtkHeaderBar* _tmp23_ = NULL;
	GtkWindow* _tmp24_ = NULL;
	GtkWindow* _tmp25_ = NULL;
	gint ww = 0;
	GSettings* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint wh = 0;
	GSettings* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	GtkWindow* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	GSettings* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	GtkBox* vbox = NULL;
	GtkBox* _tmp38_ = NULL;
	GtkWindow* _tmp39_ = NULL;
	gchar* builder_str = NULL;
	gchar* _tmp40_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp41_ = NULL;
	GObject* _tmp44_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp45_ = NULL;
	GtkBox* _tmp46_ = NULL;
	GtkTreeStore* _tmp47_ = NULL;
	GtkTreeIter huarong_item = {0};
	GtkTreeStore* _tmp48_ = NULL;
	GtkTreeIter _tmp49_ = {0};
	GtkTreeStore* _tmp50_ = NULL;
	GtkTreeIter _tmp51_ = {0};
	GtkTreeIter challenge_item = {0};
	GtkTreeStore* _tmp52_ = NULL;
	GtkTreeIter _tmp53_ = {0};
	GtkTreeStore* _tmp54_ = NULL;
	GtkTreeIter _tmp55_ = {0};
	GtkTreeIter skill_item = {0};
	GtkTreeStore* _tmp56_ = NULL;
	GtkTreeIter _tmp57_ = {0};
	GtkTreeStore* _tmp58_ = NULL;
	GtkTreeIter _tmp59_ = {0};
	GtkTreeIter* _tmp60_ = NULL;
	GtkBox* _tmp109_ = NULL;
	GtkBox* _tmp110_ = NULL;
	GtkTreeView* puzzles_view = NULL;
	GtkTreeStore* _tmp111_ = NULL;
	GtkTreeView* _tmp112_ = NULL;
	GtkCellRendererText* cell = NULL;
	GtkCellRendererText* _tmp113_ = NULL;
	GtkTreeViewColumn* col = NULL;
	GtkTreeViewColumn* _tmp114_ = NULL;
	Klotski* _tmp115_ = NULL;
	CellRendererLevel* _tmp116_ = NULL;
	CellRendererLevel* _tmp117_ = NULL;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp118_ = NULL;
	GtkBox* _tmp119_ = NULL;
	GtkBox* bbox = NULL;
	GtkBox* _tmp120_ = NULL;
	GtkBox* _tmp121_ = NULL;
	const gchar* _tmp122_ = NULL;
	GtkButton* _tmp123_ = NULL;
	GtkButton* _tmp124_ = NULL;
	GtkButton* _tmp125_ = NULL;
	gint _tmp126_ = 0;
	GtkButton* _tmp127_ = NULL;
	GtkBox* _tmp128_ = NULL;
	GtkButton* _tmp129_ = NULL;
	const gchar* _tmp130_ = NULL;
	GtkButton* _tmp131_ = NULL;
	GtkButton* _tmp132_ = NULL;
	GtkButton* _tmp133_ = NULL;
	gint _tmp134_ = 0;
	GtkButton* _tmp135_ = NULL;
	GtkBox* _tmp136_ = NULL;
	GtkButton* _tmp137_ = NULL;
	GtkBox* _tmp138_ = NULL;
	GtkBox* _tmp139_ = NULL;
	GtkBox* _tmp140_ = NULL;
	GtkBox* _tmp141_ = NULL;
	PuzzleView* _tmp142_ = NULL;
	PuzzleView* _tmp143_ = NULL;
	PuzzleView* _tmp144_ = NULL;
	GtkBox* _tmp145_ = NULL;
	PuzzleView* _tmp146_ = NULL;
	GtkSizeGroup* sizegroup = NULL;
	GtkSizeGroup* _tmp147_ = NULL;
	GtkBox* _tmp148_ = NULL;
	GtkBox* _tmp149_ = NULL;
	GtkBox* _tmp150_ = NULL;
	GtkBox* _tmp151_ = NULL;
	GtkButton* button = NULL;
	const gchar* _tmp152_ = NULL;
	GtkToggleButton* _tmp153_ = NULL;
	GtkButton* _tmp154_ = NULL;
	GtkButton* _tmp155_ = NULL;
	GtkWidget* _tmp156_ = NULL;
	GtkButton* _tmp157_ = NULL;
	GtkButton* _tmp158_ = NULL;
	GtkBox* _tmp159_ = NULL;
	GtkButton* _tmp160_ = NULL;
	const gchar* _tmp161_ = NULL;
	GtkButton* _tmp162_ = NULL;
	GtkButton* _tmp163_ = NULL;
	GtkButton* _tmp164_ = NULL;
	GtkWidget* _tmp165_ = NULL;
	GtkButton* _tmp166_ = NULL;
	GtkButton* _tmp167_ = NULL;
	GtkBox* _tmp168_ = NULL;
	GtkButton* _tmp169_ = NULL;
	GtkBox* _tmp170_ = NULL;
	GtkSeparator* _tmp171_ = NULL;
	GtkSeparator* _tmp172_ = NULL;
	gint startup_level = 0;
	GSettings* _tmp173_ = NULL;
	gint _tmp174_ = 0;
	GError * _inner_error_ = NULL;
	self = (Klotski*) base;
	G_APPLICATION_CLASS (klotski_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = _ ("Klotski");
	g_set_application_name (_tmp0_);
	_tmp1_ = g_settings_new ("org.gnome.klotski");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	gtk_window_set_default_icon_name ("gnome-klotski");
	g_action_map_add_action_entries ((GActionMap*) self, KLOTSKI_action_entries, G_N_ELEMENTS (KLOTSKI_action_entries), self);
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp3_;
	_tmp4_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp4_, FALSE);
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "next-level");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp5_) : NULL);
	_g_object_unref0 (self->priv->next_level_action);
	self->priv->next_level_action = _tmp6_;
	_tmp7_ = self->priv->next_level_action;
	_tmp8_ = self->priv->current_level;
	g_simple_action_set_enabled (_tmp7_, _tmp8_ < (G_N_ELEMENTS (KLOTSKI_level) - 1));
	_tmp9_ = g_action_map_lookup_action ((GActionMap*) self, "prev-level");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp9_) : NULL);
	_g_object_unref0 (self->priv->prev_level_action);
	self->priv->prev_level_action = _tmp10_;
	_tmp11_ = self->priv->prev_level_action;
	_tmp12_ = self->priv->current_level;
	g_simple_action_set_enabled (_tmp11_, _tmp12_ > 0);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>n", "app.new-game", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>q", "app.quit", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "F1", "app.help", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "Page_Up", "app.next-level", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "Page_Down", "app.prev-level", NULL);
	_tmp13_ = g_get_user_data_dir ();
	_tmp14_ = g_build_filename (_tmp13_, "gnome-klotski", "history", NULL);
	histfile = _tmp14_;
	_tmp15_ = histfile;
	_tmp16_ = history_new (_tmp15_);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp16_;
	_tmp17_ = self->priv->history;
	history_load (_tmp17_);
	_tmp18_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp18_;
	_tmp19_ = self->priv->headerbar;
	gtk_header_bar_set_show_close_button (_tmp19_, TRUE);
	_tmp20_ = self->priv->headerbar;
	gtk_widget_show ((GtkWidget*) _tmp20_);
	_tmp21_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = (GtkWindow*) _tmp21_;
	_tmp22_ = self->priv->window;
	_tmp23_ = self->priv->headerbar;
	gtk_window_set_titlebar (_tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp24_, "configure-event", (GCallback) _klotski_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp25_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp25_, "window-state-event", (GCallback) _klotski_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp26_ = self->priv->settings;
	_tmp27_ = g_settings_get_int (_tmp26_, "window-width");
	_tmp28_ = MAX (_tmp27_, KLOTSKI_MINWIDTH);
	ww = _tmp28_;
	_tmp29_ = self->priv->settings;
	_tmp30_ = g_settings_get_int (_tmp29_, "window-height");
	_tmp31_ = MAX (_tmp30_, KLOTSKI_MINHEIGHT);
	wh = _tmp31_;
	_tmp32_ = self->priv->window;
	_tmp33_ = ww;
	_tmp34_ = wh;
	gtk_window_set_default_size (_tmp32_, _tmp33_, _tmp34_);
	_tmp35_ = self->priv->settings;
	_tmp36_ = g_settings_get_boolean (_tmp35_, "window-is-maximized");
	if (_tmp36_) {
		GtkWindow* _tmp37_ = NULL;
		_tmp37_ = self->priv->window;
		gtk_window_maximize (_tmp37_);
	}
	_tmp38_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp38_);
	vbox = _tmp38_;
	_tmp39_ = self->priv->window;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) vbox);
	gtk_widget_show ((GtkWidget*) vbox);
	_tmp40_ = g_strdup ("<interface>" "\n" \
"               <menu id='app-menu'>\n" \
"                  <section>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_New " \
"Game</attribute>\n" \
"                      <attribute name='action'>app.new-game</attribute" \
">\n" \
"                   </item>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Scor" \
"es</attribute>\n" \
"                      <attribute name='action'>app.scores</attribute>\n" \
"                   </item>\n" \
"                  </section>\n" \
"                  <section>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Help" \
"</attribute>\n" \
"                      <attribute name='action'>app.help</attribute>\n" \
"                   </item>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Abou" \
"t</attribute>\n" \
"                      <attribute name='action'>app.about</attribute>\n" \
"                   </item>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Quit" \
"</attribute>\n" \
"                      <attribute name='action'>app.quit</attribute>\n" \
"                   </item>\n" \
"                  </section>\n" \
"                </menu>\n" \
"               </interface>\n" \
"               ");
	builder_str = _tmp40_;
	_tmp41_ = gtk_builder_new ();
	builder = _tmp41_;
	{
		gtk_builder_add_from_string (builder, builder_str, (gsize) (-1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp42_ = stderr;
		fprintf (_tmp42_, "%s\n", "Error in gnome-klotski.vala function startup() - builder.add_from_stri" \
"ng failed");
		_tmp43_ = e->message;
		g_error ("gnome-klotski.vala:542: %s", _tmp43_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (builder);
		_g_free0 (builder_str);
		_g_object_unref0 (vbox);
		_g_free0 (histfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp44_ = gtk_builder_get_object (builder, "app-menu");
	gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp44_) : NULL);
	_tmp45_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp45_);
	hbox = _tmp45_;
	_tmp46_ = hbox;
	gtk_widget_show ((GtkWidget*) _tmp46_);
	_tmp47_ = gtk_tree_store_new (3, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT);
	_g_object_unref0 (self->priv->puzzles);
	self->priv->puzzles = _tmp47_;
	_tmp48_ = self->priv->puzzles;
	gtk_tree_store_append (_tmp48_, &_tmp49_, NULL);
	huarong_item = _tmp49_;
	_tmp50_ = self->priv->puzzles;
	_tmp51_ = huarong_item;
	gtk_tree_store_set (_tmp50_, &_tmp51_, 0, "HuaRong Trail", 2, -1, -1, -1);
	_tmp52_ = self->priv->puzzles;
	gtk_tree_store_append (_tmp52_, &_tmp53_, NULL);
	challenge_item = _tmp53_;
	_tmp54_ = self->priv->puzzles;
	_tmp55_ = challenge_item;
	gtk_tree_store_set (_tmp54_, &_tmp55_, 0, "Challenge Pack", 2, -1, -1, -1);
	_tmp56_ = self->priv->puzzles;
	gtk_tree_store_append (_tmp56_, &_tmp57_, NULL);
	skill_item = _tmp57_;
	_tmp58_ = self->priv->puzzles;
	_tmp59_ = skill_item;
	gtk_tree_store_set (_tmp58_, &_tmp59_, 0, "Skill Pack", 2, -1, -1, -1);
	_tmp60_ = g_new0 (GtkTreeIter, G_N_ELEMENTS (KLOTSKI_level));
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
	self->priv->puzzles_items = _tmp60_;
	self->priv->puzzles_items_length1 = G_N_ELEMENTS (KLOTSKI_level);
	self->priv->_puzzles_items_size_ = self->priv->puzzles_items_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp61_ = FALSE;
			_tmp61_ = TRUE;
			while (TRUE) {
				gint _tmp63_ = 0;
				gint _tmp64_ = 0;
				LevelInfo _tmp65_ = {0};
				gint _tmp66_ = 0;
				if (!_tmp61_) {
					gint _tmp62_ = 0;
					_tmp62_ = i;
					i = _tmp62_ + 1;
				}
				_tmp61_ = FALSE;
				_tmp63_ = i;
				if (!(_tmp63_ < G_N_ELEMENTS (KLOTSKI_level))) {
					break;
				}
				_tmp64_ = i;
				_tmp65_ = KLOTSKI_level[_tmp64_];
				_tmp66_ = _tmp65_.group;
				switch (_tmp66_) {
					case 0:
					{
						GtkTreeStore* _tmp67_ = NULL;
						GtkTreeIter* _tmp68_ = NULL;
						gint _tmp68__length1 = 0;
						gint _tmp69_ = 0;
						GtkTreeIter _tmp70_ = {0};
						GtkTreeIter _tmp71_ = {0};
						GtkTreeStore* _tmp72_ = NULL;
						GtkTreeIter* _tmp73_ = NULL;
						gint _tmp73__length1 = 0;
						gint _tmp74_ = 0;
						GtkTreeIter _tmp75_ = {0};
						gint _tmp76_ = 0;
						LevelInfo _tmp77_ = {0};
						const gchar* _tmp78_ = NULL;
						const gchar* _tmp79_ = NULL;
						gint _tmp80_ = 0;
						_tmp67_ = self->priv->puzzles;
						_tmp68_ = self->priv->puzzles_items;
						_tmp68__length1 = self->priv->puzzles_items_length1;
						_tmp69_ = i;
						_tmp70_ = huarong_item;
						gtk_tree_store_append (_tmp67_, &_tmp71_, &_tmp70_);
						_tmp68_[_tmp69_] = _tmp71_;
						_tmp72_ = self->priv->puzzles;
						_tmp73_ = self->priv->puzzles_items;
						_tmp73__length1 = self->priv->puzzles_items_length1;
						_tmp74_ = i;
						_tmp75_ = _tmp73_[_tmp74_];
						_tmp76_ = i;
						_tmp77_ = KLOTSKI_level[_tmp76_];
						_tmp78_ = _tmp77_.name;
						_tmp79_ = _ (_tmp78_);
						_tmp80_ = i;
						gtk_tree_store_set (_tmp72_, &_tmp75_, 0, _tmp79_, 1, FALSE, 2, _tmp80_, -1, -1);
						break;
					}
					case 1:
					{
						GtkTreeStore* _tmp81_ = NULL;
						GtkTreeIter* _tmp82_ = NULL;
						gint _tmp82__length1 = 0;
						gint _tmp83_ = 0;
						GtkTreeIter _tmp84_ = {0};
						GtkTreeIter _tmp85_ = {0};
						GtkTreeStore* _tmp86_ = NULL;
						GtkTreeIter* _tmp87_ = NULL;
						gint _tmp87__length1 = 0;
						gint _tmp88_ = 0;
						GtkTreeIter _tmp89_ = {0};
						gint _tmp90_ = 0;
						LevelInfo _tmp91_ = {0};
						const gchar* _tmp92_ = NULL;
						const gchar* _tmp93_ = NULL;
						gint _tmp94_ = 0;
						_tmp81_ = self->priv->puzzles;
						_tmp82_ = self->priv->puzzles_items;
						_tmp82__length1 = self->priv->puzzles_items_length1;
						_tmp83_ = i;
						_tmp84_ = challenge_item;
						gtk_tree_store_append (_tmp81_, &_tmp85_, &_tmp84_);
						_tmp82_[_tmp83_] = _tmp85_;
						_tmp86_ = self->priv->puzzles;
						_tmp87_ = self->priv->puzzles_items;
						_tmp87__length1 = self->priv->puzzles_items_length1;
						_tmp88_ = i;
						_tmp89_ = _tmp87_[_tmp88_];
						_tmp90_ = i;
						_tmp91_ = KLOTSKI_level[_tmp90_];
						_tmp92_ = _tmp91_.name;
						_tmp93_ = _ (_tmp92_);
						_tmp94_ = i;
						gtk_tree_store_set (_tmp86_, &_tmp89_, 0, _tmp93_, 1, FALSE, 2, _tmp94_, -1, -1);
						break;
					}
					case 2:
					{
						GtkTreeStore* _tmp95_ = NULL;
						GtkTreeIter* _tmp96_ = NULL;
						gint _tmp96__length1 = 0;
						gint _tmp97_ = 0;
						GtkTreeIter _tmp98_ = {0};
						GtkTreeIter _tmp99_ = {0};
						GtkTreeStore* _tmp100_ = NULL;
						GtkTreeIter* _tmp101_ = NULL;
						gint _tmp101__length1 = 0;
						gint _tmp102_ = 0;
						GtkTreeIter _tmp103_ = {0};
						gint _tmp104_ = 0;
						LevelInfo _tmp105_ = {0};
						const gchar* _tmp106_ = NULL;
						const gchar* _tmp107_ = NULL;
						gint _tmp108_ = 0;
						_tmp95_ = self->priv->puzzles;
						_tmp96_ = self->priv->puzzles_items;
						_tmp96__length1 = self->priv->puzzles_items_length1;
						_tmp97_ = i;
						_tmp98_ = skill_item;
						gtk_tree_store_append (_tmp95_, &_tmp99_, &_tmp98_);
						_tmp96_[_tmp97_] = _tmp99_;
						_tmp100_ = self->priv->puzzles;
						_tmp101_ = self->priv->puzzles_items;
						_tmp101__length1 = self->priv->puzzles_items_length1;
						_tmp102_ = i;
						_tmp103_ = _tmp101_[_tmp102_];
						_tmp104_ = i;
						_tmp105_ = KLOTSKI_level[_tmp104_];
						_tmp106_ = _tmp105_.name;
						_tmp107_ = _ (_tmp106_);
						_tmp108_ = i;
						gtk_tree_store_set (_tmp100_, &_tmp103_, 0, _tmp107_, 1, FALSE, 2, _tmp108_, -1, -1);
						break;
					}
					default:
					break;
				}
			}
		}
	}
	_tmp109_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp109_);
	_g_object_unref0 (self->priv->puzzles_panel);
	self->priv->puzzles_panel = _tmp109_;
	_tmp110_ = self->priv->puzzles_panel;
	gtk_widget_set_visible ((GtkWidget*) _tmp110_, FALSE);
	_tmp111_ = self->priv->puzzles;
	_tmp112_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp111_);
	g_object_ref_sink (_tmp112_);
	puzzles_view = _tmp112_;
	gtk_tree_view_set_headers_visible (puzzles_view, FALSE);
	_tmp113_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp113_);
	cell = _tmp113_;
	_tmp114_ = gtk_tree_view_column_new_with_attributes ("Puzzle", (GtkCellRenderer*) cell, "text", 0, NULL, NULL);
	g_object_ref_sink (_tmp114_);
	col = _tmp114_;
	_tmp115_ = _g_object_ref0 (self);
	g_object_set_data_full ((GObject*) col, "app", _tmp115_, g_object_unref);
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) col, (GtkCellRenderer*) cell, (GtkCellLayoutDataFunc) klotski_render_puzzle_name, NULL, NULL);
	gtk_tree_view_append_column (puzzles_view, col);
	_tmp116_ = cell_renderer_level_new ();
	g_object_ref_sink (_tmp116_);
	_tmp117_ = _tmp116_;
	gtk_tree_view_insert_column_with_attributes (puzzles_view, -1, "Complete", (GtkCellRenderer*) _tmp117_, "visible", 1, NULL, NULL);
	_g_object_unref0 (_tmp117_);
	g_signal_connect_object (puzzles_view, "row-activated", (GCallback) _klotski_level_cb_gtk_tree_view_row_activated, self, 0);
	gtk_widget_show_all ((GtkWidget*) puzzles_view);
	_tmp118_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp118_);
	scroll = _tmp118_;
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) puzzles_view);
	gtk_widget_show ((GtkWidget*) scroll);
	_tmp119_ = self->priv->puzzles_panel;
	gtk_box_pack_start (_tmp119_, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
	_tmp120_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp120_);
	bbox = _tmp120_;
	_tmp121_ = bbox;
	gtk_widget_show ((GtkWidget*) _tmp121_);
	_tmp122_ = _ ("Previous Puzzle");
	_tmp123_ = (GtkButton*) gtk_button_new_with_label (_tmp122_);
	g_object_ref_sink (_tmp123_);
	_g_object_unref0 (self->priv->prev_button);
	self->priv->prev_button = _tmp123_;
	_tmp124_ = self->priv->prev_button;
	g_signal_connect_object (_tmp124_, "clicked", (GCallback) _klotski_prev_level_cb_gtk_button_clicked, self, 0);
	_tmp125_ = self->priv->prev_button;
	_tmp126_ = self->priv->current_level;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp125_, _tmp126_ > 0);
	_tmp127_ = self->priv->prev_button;
	gtk_widget_show ((GtkWidget*) _tmp127_);
	_tmp128_ = bbox;
	_tmp129_ = self->priv->prev_button;
	gtk_container_add ((GtkContainer*) _tmp128_, (GtkWidget*) _tmp129_);
	_tmp130_ = _ ("Next Puzzle");
	_tmp131_ = (GtkButton*) gtk_button_new_with_label (_tmp130_);
	g_object_ref_sink (_tmp131_);
	_g_object_unref0 (self->priv->next_button);
	self->priv->next_button = _tmp131_;
	_tmp132_ = self->priv->next_button;
	g_signal_connect_object (_tmp132_, "clicked", (GCallback) _klotski_next_level_cb_gtk_button_clicked, self, 0);
	_tmp133_ = self->priv->next_button;
	_tmp134_ = self->priv->current_level;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp133_, _tmp134_ < (G_N_ELEMENTS (KLOTSKI_level) - 1));
	_tmp135_ = self->priv->next_button;
	gtk_widget_show ((GtkWidget*) _tmp135_);
	_tmp136_ = bbox;
	_tmp137_ = self->priv->next_button;
	gtk_container_add ((GtkContainer*) _tmp136_, (GtkWidget*) _tmp137_);
	_tmp138_ = self->priv->puzzles_panel;
	_tmp139_ = bbox;
	gtk_box_pack_start (_tmp138_, (GtkWidget*) _tmp139_, FALSE, TRUE, (guint) 0);
	_tmp140_ = hbox;
	_tmp141_ = self->priv->puzzles_panel;
	gtk_box_pack_start (_tmp140_, (GtkWidget*) _tmp141_, FALSE, TRUE, (guint) 0);
	_tmp142_ = puzzle_view_new ();
	g_object_ref_sink (_tmp142_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp142_;
	_tmp143_ = self->priv->view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp143_, KLOTSKI_MINWIDTH, KLOTSKI_MINHEIGHT);
	_tmp144_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp144_);
	_tmp145_ = hbox;
	_tmp146_ = self->priv->view;
	gtk_box_pack_start (_tmp145_, (GtkWidget*) _tmp146_, TRUE, TRUE, (guint) 0);
	_tmp147_ = gtk_size_group_new (GTK_SIZE_GROUP_BOTH);
	sizegroup = _tmp147_;
	_tmp148_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 8);
	g_object_ref_sink (_tmp148_);
	_g_object_unref0 (bbox);
	bbox = _tmp148_;
	_tmp149_ = bbox;
	gtk_widget_show ((GtkWidget*) _tmp149_);
	_tmp150_ = hbox;
	_tmp151_ = bbox;
	gtk_box_pack_start (_tmp150_, (GtkWidget*) _tmp151_, FALSE, TRUE, (guint) 15);
	_tmp152_ = _ ("_View Puzzles");
	_tmp153_ = (GtkToggleButton*) gtk_toggle_button_new_with_mnemonic (_tmp152_);
	g_object_ref_sink (_tmp153_);
	button = (GtkButton*) _tmp153_;
	_tmp154_ = button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp154_, "app.show-puzzles");
	_tmp155_ = button;
	_tmp156_ = gtk_bin_get_child ((GtkBin*) _tmp155_);
	g_object_set ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, GTK_TYPE_LABEL, GtkLabel), "margin", 12, NULL);
	_tmp157_ = button;
	gtk_widget_show ((GtkWidget*) _tmp157_);
	_tmp158_ = button;
	gtk_size_group_add_widget (sizegroup, (GtkWidget*) _tmp158_);
	_tmp159_ = bbox;
	_tmp160_ = button;
	gtk_box_pack_end (_tmp159_, (GtkWidget*) _tmp160_, FALSE, TRUE, (guint) 0);
	_tmp161_ = _ ("_Start Over");
	_tmp162_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp161_);
	g_object_ref_sink (_tmp162_);
	_g_object_unref0 (button);
	button = _tmp162_;
	_tmp163_ = button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp163_, "app.new-game");
	_tmp164_ = button;
	_tmp165_ = gtk_bin_get_child ((GtkBin*) _tmp164_);
	g_object_set ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp165_, GTK_TYPE_LABEL, GtkLabel), "margin", 12, NULL);
	_tmp166_ = button;
	gtk_widget_show ((GtkWidget*) _tmp166_);
	_tmp167_ = button;
	gtk_size_group_add_widget (sizegroup, (GtkWidget*) _tmp167_);
	_tmp168_ = bbox;
	_tmp169_ = button;
	gtk_box_pack_end (_tmp168_, (GtkWidget*) _tmp169_, FALSE, TRUE, (guint) 0);
	_tmp170_ = hbox;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp170_, TRUE, TRUE, (guint) 15);
	_tmp171_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp171_);
	_tmp172_ = _tmp171_;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp172_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp172_);
	klotski_load_solved_state (self);
	_tmp173_ = self->priv->settings;
	_tmp174_ = g_settings_get_int (_tmp173_, KLOTSKI_KEY_LEVEL);
	startup_level = _tmp174_;
	klotski_new_game (self, startup_level);
	_g_object_unref0 (button);
	_g_object_unref0 (sizegroup);
	_g_object_unref0 (bbox);
	_g_object_unref0 (scroll);
	_g_object_unref0 (col);
	_g_object_unref0 (cell);
	_g_object_unref0 (puzzles_view);
	_g_object_unref0 (hbox);
	_g_object_unref0 (builder);
	_g_free0 (builder_str);
	_g_object_unref0 (vbox);
	_g_free0 (histfile);
}


static void klotski_render_puzzle_name (GtkCellLayout* cell_layout, GtkCellRendererText* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	GValue val = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GValue _tmp2_ = {0};
	gint selected_level = 0;
	GValue _tmp3_ = {0};
	Klotski* app = NULL;
	GtkCellLayout* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	Klotski* _tmp6_ = NULL;
	Klotski* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = tree_model;
	_tmp1_ = *iter;
	gtk_tree_model_get_value (_tmp0_, &_tmp1_, 2, &_tmp2_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp2_;
	_tmp3_ = val;
	selected_level = g_value_get_int (&_tmp3_);
	_tmp4_ = cell_layout;
	_tmp5_ = g_object_get_data ((GObject*) _tmp4_, "app");
	_tmp6_ = _g_object_ref0 ((Klotski*) _tmp5_);
	app = _tmp6_;
	_tmp7_ = app;
	_tmp8_ = _tmp7_->priv->current_level;
	_tmp9_ = selected_level;
	if (_tmp8_ == _tmp9_) {
		GtkCellRendererText* _tmp10_ = NULL;
		_tmp10_ = cell;
		g_object_set (_tmp10_, "weight", 700, NULL);
	} else {
		GtkCellRendererText* _tmp11_ = NULL;
		_tmp11_ = cell;
		g_object_set (_tmp11_, "weight", 400, NULL);
	}
	_g_object_unref0 (app);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}


static gboolean klotski_window_configure_event_cb (Klotski* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->is_maximized;
	if (!_tmp0_) {
		GdkEventConfigure* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp1_ = event;
		_tmp2_ = _tmp1_->width;
		self->priv->window_width = _tmp2_;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->height;
		self->priv->window_height = _tmp4_;
	}
	result = FALSE;
	return result;
}


static gboolean klotski_window_state_event_cb (Klotski* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	result = FALSE;
	return result;
}


static void klotski_scores_cb (Klotski* self) {
	g_return_if_fail (self != NULL);
	klotski_show_scores (self, NULL, FALSE);
}


static void klotski_game_score (Klotski* self) {
	gchar* key = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp2_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkTreeStore* _tmp7_ = NULL;
	GtkTreeIter* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp9_ = 0;
	GtkTreeIter _tmp10_ = {0};
	GDateTime* date = NULL;
	GDateTime* _tmp11_ = NULL;
	HistoryEntry* entry = NULL;
	GDateTime* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	Puzzle* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	HistoryEntry* _tmp16_ = NULL;
	History* _tmp17_ = NULL;
	HistoryEntry* _tmp18_ = NULL;
	History* _tmp19_ = NULL;
	HistoryEntry* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	_tmp1_ = klotski_get_level_key (self, _tmp0_);
	key = _tmp1_;
	_tmp2_ = g_key_file_new ();
	keyfile = _tmp2_;
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "gnome-klotski", "levels", NULL);
	filename = _tmp4_;
	{
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (filename);
		_g_key_file_free0 (keyfile);
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_key_file_set_boolean (keyfile, key, "solved", TRUE);
	{
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = g_key_file_to_data (keyfile, NULL, NULL);
		_tmp6_ = _tmp5_;
		g_file_set_contents (filename, _tmp6_, (gssize) (-1), &_inner_error_);
		_g_free0 (_tmp6_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (filename);
		_g_key_file_free0 (keyfile);
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = self->priv->puzzles;
	_tmp8_ = self->priv->puzzles_items;
	_tmp8__length1 = self->priv->puzzles_items_length1;
	_tmp9_ = self->priv->current_level;
	_tmp10_ = _tmp8_[_tmp9_];
	gtk_tree_store_set (_tmp7_, &_tmp10_, 1, TRUE, -1, -1);
	_tmp11_ = g_date_time_new_now_local ();
	date = _tmp11_;
	_tmp12_ = date;
	_tmp13_ = self->priv->current_level;
	_tmp14_ = self->priv->puzzle;
	_tmp15_ = _tmp14_->moves;
	_tmp16_ = history_entry_new (_tmp12_, (guint) _tmp13_, (guint) _tmp15_);
	entry = _tmp16_;
	_tmp17_ = self->priv->history;
	_tmp18_ = entry;
	history_add (_tmp17_, _tmp18_);
	_tmp19_ = self->priv->history;
	history_save (_tmp19_);
	_tmp20_ = entry;
	_tmp21_ = klotski_show_scores (self, _tmp20_, TRUE);
	if (_tmp21_ == ((gint) GTK_RESPONSE_OK)) {
		gint _tmp22_ = 0;
		_tmp22_ = self->priv->current_level;
		klotski_new_game (self, _tmp22_);
	}
	_history_entry_unref0 (entry);
	_g_date_time_unref0 (date);
	_g_free0 (filename);
	_g_key_file_free0 (keyfile);
	_g_free0 (key);
}


static gint klotski_show_scores (Klotski* self, HistoryEntry* selected_entry, gboolean show_close) {
	gint result = 0;
	ScoreDialog* dialog = NULL;
	History* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ScoreDialog* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = selected_entry;
	_tmp2_ = show_close;
	_tmp3_ = score_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, _tmp4_);
	_tmp5_ = gtk_dialog_run ((GtkDialog*) dialog);
	_result_ = _tmp5_;
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_;
	_g_object_unref0 (dialog);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* klotski_get_level_key (Klotski* self, gint level_number) {
	gchar* result = NULL;
	guint32 _result_ = 0U;
	gchar* data = NULL;
	gint _tmp0_ = 0;
	LevelInfo _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint32 _tmp21_ = 0U;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = (guint32) 0xFFFFFFFFU;
	_tmp0_ = level_number;
	_tmp1_ = KLOTSKI_level[_tmp0_];
	_tmp2_ = _tmp1_.data;
	_tmp3_ = g_strdup (_tmp2_);
	data = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gchar _tmp8_ = '\0';
				gchar octet = '\0';
				const gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gchar _tmp11_ = '\0';
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = data;
				_tmp7_ = i;
				_tmp8_ = string_get (_tmp6_, (glong) _tmp7_);
				if (!(_tmp8_ != '\0')) {
					break;
				}
				_tmp9_ = data;
				_tmp10_ = i;
				_tmp11_ = string_get (_tmp9_, (glong) _tmp10_);
				octet = _tmp11_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp12_ = FALSE;
						_tmp12_ = TRUE;
						while (TRUE) {
							gint _tmp14_ = 0;
							gchar _tmp15_ = '\0';
							guint32 _tmp16_ = 0U;
							guint32 _tmp19_ = 0U;
							gchar _tmp20_ = '\0';
							if (!_tmp12_) {
								gint _tmp13_ = 0;
								_tmp13_ = j;
								j = _tmp13_ + 1;
							}
							_tmp12_ = FALSE;
							_tmp14_ = j;
							if (!(_tmp14_ < 8)) {
								break;
							}
							_tmp15_ = octet;
							_tmp16_ = _result_;
							if (((_tmp15_ >> 7) ^ (_tmp16_ >> 31)) != ((guint32) 0)) {
								guint32 _tmp17_ = 0U;
								_tmp17_ = _result_;
								_result_ = (_tmp17_ << 1) ^ 0x04c11db7;
							} else {
								guint32 _tmp18_ = 0U;
								_tmp18_ = _result_;
								_result_ = _tmp18_ << 1;
							}
							_tmp19_ = _result_;
							_result_ = _tmp19_ & 0xFFFFFFFFLL;
							_tmp20_ = octet;
							octet = (gchar) (_tmp20_ << 1);
						}
					}
				}
			}
		}
	}
	_tmp21_ = _result_;
	_tmp22_ = g_strdup_printf ("%08X", (guint) (~_tmp21_));
	result = _tmp22_;
	_g_free0 (data);
	return result;
}


static void klotski_load_solved_state (Klotski* self) {
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "gnome-klotski", "levels", NULL);
	filename = _tmp2_;
	{
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (filename);
		_g_key_file_free0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gchar* key = NULL;
				gint _tmp6_ = 0;
				gchar* _tmp7_ = NULL;
				gboolean value = FALSE;
				GtkTreeStore* _tmp11_ = NULL;
				GtkTreeIter* _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				GtkTreeIter _tmp14_ = {0};
				gboolean _tmp15_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ < G_N_ELEMENTS (KLOTSKI_level))) {
					break;
				}
				_tmp6_ = i;
				_tmp7_ = klotski_get_level_key (self, _tmp6_);
				key = _tmp7_;
				value = FALSE;
				{
					gboolean _tmp8_ = FALSE;
					const gchar* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = key;
					_tmp10_ = g_key_file_get_boolean (keyfile, _tmp9_, "solved", &_inner_error_);
					_tmp8_ = _tmp10_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch4_g_error;
					}
					value = _tmp8_;
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally4:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (key);
					_g_free0 (filename);
					_g_key_file_free0 (keyfile);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp11_ = self->priv->puzzles;
				_tmp12_ = self->priv->puzzles_items;
				_tmp12__length1 = self->priv->puzzles_items_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp15_ = value;
				gtk_tree_store_set (_tmp11_, &_tmp14_, 1, _tmp15_, -1, -1);
				_g_free0 (key);
			}
		}
	}
	_g_free0 (filename);
	_g_key_file_free0 (keyfile);
}


static void klotski_update_menu_state (Klotski* self) {
	GtkBox* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GtkButton* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSimpleAction* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GSimpleAction* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_panel;
	gtk_widget_queue_draw ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->next_button;
	_tmp2_ = self->priv->current_level;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp2_ < (G_N_ELEMENTS (KLOTSKI_level) - 1));
	_tmp3_ = self->priv->prev_button;
	_tmp4_ = self->priv->current_level;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_ > 0);
	_tmp5_ = self->priv->next_level_action;
	_tmp6_ = self->priv->current_level;
	g_simple_action_set_enabled (_tmp5_, _tmp6_ < (G_N_ELEMENTS (KLOTSKI_level) - 1));
	_tmp7_ = self->priv->prev_level_action;
	_tmp8_ = self->priv->current_level;
	g_simple_action_set_enabled (_tmp7_, _tmp8_ > 0);
	klotski_update_moves_label (self);
}


static void _klotski_puzzle_moved_cb_puzzle_moved (Puzzle* _sender, gpointer self) {
	klotski_puzzle_moved_cb ((Klotski*) self);
}


static void klotski_new_game (Klotski* self, gint requested_level) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkHeaderBar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	LevelInfo _tmp6_ = {0};
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	LevelInfo _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	LevelInfo _tmp13_ = {0};
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	LevelInfo _tmp16_ = {0};
	const gchar* _tmp17_ = NULL;
	Puzzle* _tmp18_ = NULL;
	Puzzle* _tmp19_ = NULL;
	PuzzleView* _tmp20_ = NULL;
	Puzzle* _tmp21_ = NULL;
	GSimpleAction* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = requested_level;
	_tmp1_ = CLAMP (_tmp0_, 0, G_N_ELEMENTS (KLOTSKI_level) - 1);
	self->priv->current_level = _tmp1_;
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->current_level;
	g_settings_set_int (_tmp2_, KLOTSKI_KEY_LEVEL, _tmp3_);
	_tmp4_ = self->priv->headerbar;
	_tmp5_ = self->priv->current_level;
	_tmp6_ = KLOTSKI_level[_tmp5_];
	_tmp7_ = _tmp6_.name;
	_tmp8_ = _ (_tmp7_);
	gtk_header_bar_set_title (_tmp4_, _tmp8_);
	_tmp9_ = self->priv->current_level;
	_tmp10_ = KLOTSKI_level[_tmp9_];
	_tmp11_ = _tmp10_.width;
	_tmp12_ = self->priv->current_level;
	_tmp13_ = KLOTSKI_level[_tmp12_];
	_tmp14_ = _tmp13_.height;
	_tmp15_ = self->priv->current_level;
	_tmp16_ = KLOTSKI_level[_tmp15_];
	_tmp17_ = _tmp16_.data;
	_tmp18_ = puzzle_new (_tmp11_, _tmp14_, _tmp17_);
	_puzzle_unref0 (self->priv->puzzle);
	self->priv->puzzle = _tmp18_;
	_tmp19_ = self->priv->puzzle;
	g_signal_connect_object (_tmp19_, "moved", (GCallback) _klotski_puzzle_moved_cb_puzzle_moved, self, 0);
	_tmp20_ = self->priv->view;
	_tmp21_ = self->priv->puzzle;
	puzzle_view_set_puzzle (_tmp20_, _tmp21_);
	_tmp22_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp22_, FALSE);
	klotski_update_menu_state (self);
}


static void klotski_puzzle_moved_cb (Klotski* self) {
	GSimpleAction* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	klotski_update_moves_label (self);
	_tmp0_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
}


static void klotski_update_moves_label (Klotski* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Puzzle* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Puzzle* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = _ ("Moves: %d");
	_tmp2_ = self->priv->puzzle;
	_tmp3_ = _tmp2_->moves;
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_header_bar_set_subtitle (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->puzzle;
	_tmp7_ = puzzle_game_over (_tmp6_);
	if (_tmp7_) {
		GtkHeaderBar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = self->priv->headerbar;
		_tmp9_ = _ ("Level completed.");
		gtk_header_bar_set_title (_tmp8_, _tmp9_);
		klotski_game_score (self);
	}
}


static void klotski_quit_cb (Klotski* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void klotski_level_cb (Klotski* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeIter iter = {0};
	GValue val = {0};
	GtkTreeStore* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	GtkTreeStore* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	GValue _tmp5_ = {0};
	gint requested_level = 0;
	GValue _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = self->priv->puzzles;
	_tmp1_ = path;
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = self->priv->puzzles;
	_tmp4_ = iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp3_, &_tmp4_, 2, &_tmp5_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp5_;
	_tmp6_ = val;
	requested_level = g_value_get_int (&_tmp6_);
	_tmp7_ = requested_level;
	if (_tmp7_ < 0) {
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		return;
	}
	_tmp8_ = self->priv->current_level;
	_tmp9_ = requested_level;
	if (_tmp8_ != _tmp9_) {
		gint _tmp10_ = 0;
		_tmp10_ = requested_level;
		klotski_new_game (self, _tmp10_);
	}
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}


static void klotski_restart_level_cb (Klotski* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	klotski_new_game (self, _tmp0_);
}


static void klotski_toggle_puzzles_cb (Klotski* self) {
	GtkBox* _tmp0_ = NULL;
	GtkBox* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_panel;
	_tmp1_ = self->priv->puzzles_panel;
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, !_tmp3_);
}


static void klotski_next_level_cb (Klotski* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	klotski_new_game (self, _tmp0_ + 1);
}


static void klotski_prev_level_cb (Klotski* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	klotski_new_game (self, _tmp0_ - 1);
}


static void klotski_help_cb (Klotski* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-klotski", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-klotski.vala:884: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void klotski_real_shutdown (GApplication* base) {
	Klotski * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (Klotski*) base;
	G_APPLICATION_CLASS (klotski_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
}


static void klotski_real_activate (GApplication* base) {
	Klotski * self;
	GtkWindow* _tmp0_ = NULL;
	self = (Klotski*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present (_tmp0_);
}


static void klotski_about_cb (Klotski* self) {
	static const gchar* authors[] = {"Lars Rydlinge (original author)", "Robert Ancell (port to vala)", "John Cheetham (port to vala)", NULL};
	static const gchar* documenters[] = {"Andrew Sobala", NULL};
	GtkWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = _ ("Klotski");
	_tmp2_ = _ ("Sliding block puzzles\n\nKlotski is a part of GNOME Games.");
	_tmp3_ = _ ("translator-credits");
	gtk_show_about_dialog (_tmp0_, "program-name", _tmp1_, "version", VERSION, "comments", _tmp2_, "copyright", "Copyright © 1999–2008 Lars Rydlinge", "license-type", GTK_LICENSE_GPL_2_0, "authors", authors, "documenters", documenters, "translator-credits", _tmp3_, "logo-icon-name", "gnome-klotski", "website", "https://wiki.gnome.org/Apps/Klotski", NULL, NULL);
}


gint klotski_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionGroup* _tmp1_ = NULL;
	Klotski* app = NULL;
	Klotski* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (NULL);
	context = _tmp0_;
	g_option_context_set_translation_domain (context, GETTEXT_PACKAGE);
	_tmp1_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (context, _tmp1_);
	{
		g_option_context_parse (context, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		fprintf (_tmp2_, "%s\n", _tmp4_);
		exit (EXIT_FAILURE);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp5_ = klotski_new ();
	app = _tmp5_;
	_tmp6_ = args;
	_tmp6__length1 = args_length1;
	_tmp7_ = g_application_run ((GApplication*) app, _tmp6__length1, _tmp6_);
	result = _tmp7_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return klotski_main (argv, argc);
}


static void klotski_class_init (KlotskiClass * klass) {
	klotski_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KlotskiPrivate));
	G_APPLICATION_CLASS (klass)->startup = klotski_real_startup;
	G_APPLICATION_CLASS (klass)->shutdown = klotski_real_shutdown;
	G_APPLICATION_CLASS (klass)->activate = klotski_real_activate;
	G_OBJECT_CLASS (klass)->finalize = klotski_finalize;
}


static void klotski_instance_init (Klotski * self) {
	self->priv = KLOTSKI_GET_PRIVATE (self);
	self->priv->current_level = -1;
}


static void klotski_finalize (GObject* obj) {
	Klotski * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KLOTSKI, Klotski);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->puzzles_panel);
	_g_object_unref0 (self->priv->next_button);
	_g_object_unref0 (self->priv->prev_button);
	_g_object_unref0 (self->priv->next_level_action);
	_g_object_unref0 (self->priv->prev_level_action);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->headerbar);
	_puzzle_unref0 (self->priv->puzzle);
	_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->puzzles);
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
	G_OBJECT_CLASS (klotski_parent_class)->finalize (obj);
}


GType klotski_get_type (void) {
	static volatile gsize klotski_type_id__volatile = 0;
	if (g_once_init_enter (&klotski_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KlotskiClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) klotski_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Klotski), 0, (GInstanceInitFunc) klotski_instance_init, NULL };
		GType klotski_type_id;
		klotski_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Klotski", &g_define_type_info, 0);
		g_once_init_leave (&klotski_type_id__volatile, klotski_type_id);
	}
	return klotski_type_id__volatile;
}


CellRendererLevel* cell_renderer_level_construct (GType object_type) {
	CellRendererLevel * self = NULL;
	self = (CellRendererLevel*) g_object_new (object_type, NULL);
	return self;
}


CellRendererLevel* cell_renderer_level_new (void) {
	return cell_renderer_level_construct (TYPE_CELL_RENDERER_LEVEL);
}


static void cell_renderer_level_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height) {
	CellRendererLevel * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	self = (CellRendererLevel*) base;
	g_return_if_fail (widget != NULL);
	_vala_x_offset = 0;
	_vala_y_offset = 0;
	_vala_height = CELL_RENDERER_LEVEL_icon_size;
	_vala_width = _vala_height;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}


static void cell_renderer_level_real_render (GtkCellRenderer* base, cairo_t* ctx, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags) {
	CellRendererLevel * self;
	cairo_t* _tmp0_ = NULL;
	GdkRectangle _tmp1_ = {0};
	cairo_t* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	self = (CellRendererLevel*) base;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = ctx;
	_tmp1_ = *background_area;
	gdk_cairo_rectangle (_tmp0_, &_tmp1_);
	{
		GtkIconTheme* icon_theme = NULL;
		GtkIconTheme* _tmp2_ = NULL;
		GtkIconTheme* _tmp3_ = NULL;
		GdkPixbuf* icon = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		gint x = 0;
		GdkRectangle _tmp5_ = {0};
		gint _tmp6_ = 0;
		GdkRectangle _tmp7_ = {0};
		gint _tmp8_ = 0;
		gint y = 0;
		GdkRectangle _tmp9_ = {0};
		gint _tmp10_ = 0;
		GdkRectangle _tmp11_ = {0};
		gint _tmp12_ = 0;
		cairo_t* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp2_ = gtk_icon_theme_get_default ();
		_tmp3_ = _g_object_ref0 (_tmp2_);
		icon_theme = _tmp3_;
		_tmp4_ = gtk_icon_theme_load_icon (icon_theme, "gtk-yes", CELL_RENDERER_LEVEL_icon_size, 0, &_inner_error_);
		icon = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (icon_theme);
			goto __catch7_g_error;
		}
		_tmp5_ = *background_area;
		_tmp6_ = _tmp5_.x;
		_tmp7_ = *background_area;
		_tmp8_ = _tmp7_.width;
		x = _tmp6_ + ((_tmp8_ - CELL_RENDERER_LEVEL_icon_size) / 2);
		_tmp9_ = *background_area;
		_tmp10_ = _tmp9_.y;
		_tmp11_ = *background_area;
		_tmp12_ = _tmp11_.height;
		y = _tmp10_ + ((_tmp12_ - CELL_RENDERER_LEVEL_icon_size) / 2);
		_tmp13_ = ctx;
		_tmp14_ = x;
		_tmp15_ = y;
		gdk_cairo_set_source_pixbuf (_tmp13_, icon, (gdouble) _tmp14_, (gdouble) _tmp15_);
		_g_object_unref0 (icon);
		_g_object_unref0 (icon_theme);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("gnome-klotski.vala:986: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp18_ = ctx;
	cairo_fill (_tmp18_);
}


static void cell_renderer_level_class_init (CellRendererLevelClass * klass) {
	cell_renderer_level_parent_class = g_type_class_peek_parent (klass);
	GTK_CELL_RENDERER_CLASS (klass)->get_size = cell_renderer_level_real_get_size;
	GTK_CELL_RENDERER_CLASS (klass)->render = cell_renderer_level_real_render;
}


static void cell_renderer_level_instance_init (CellRendererLevel * self) {
}


GType cell_renderer_level_get_type (void) {
	static volatile gsize cell_renderer_level_type_id__volatile = 0;
	if (g_once_init_enter (&cell_renderer_level_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CellRendererLevelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cell_renderer_level_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CellRendererLevel), 0, (GInstanceInitFunc) cell_renderer_level_instance_init, NULL };
		GType cell_renderer_level_type_id;
		cell_renderer_level_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER, "CellRendererLevel", &g_define_type_info, 0);
		g_once_init_leave (&cell_renderer_level_type_id__volatile, cell_renderer_level_type_id);
	}
	return cell_renderer_level_type_id__volatile;
}



