/* gitg-lanes.c generated by valac 0.24.0.87-362e, the Vala compiler
 * generated from gitg-lanes.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define GITG_TYPE_LANES (gitg_lanes_get_type ())
#define GITG_LANES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LANES, GitgLanes))
#define GITG_LANES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LANES, GitgLanesClass))
#define GITG_IS_LANES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LANES))
#define GITG_IS_LANES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LANES))
#define GITG_LANES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LANES, GitgLanesClass))

typedef struct _GitgLanes GitgLanes;
typedef struct _GitgLanesClass GitgLanesClass;
typedef struct _GitgLanesPrivate GitgLanesPrivate;

#define GITG_TYPE_COMMIT (gitg_commit_get_type ())
#define GITG_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT, GitgCommit))
#define GITG_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT, GitgCommitClass))
#define GITG_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT))
#define GITG_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT))
#define GITG_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT, GitgCommitClass))

typedef struct _GitgCommit GitgCommit;
typedef struct _GitgCommitClass GitgCommitClass;

#define GITG_LANES_TYPE_LANE_CONTAINER (gitg_lanes_lane_container_get_type ())
#define GITG_LANES_LANE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainer))
#define GITG_LANES_LANE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainerClass))
#define GITG_LANES_IS_LANE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_LANES_TYPE_LANE_CONTAINER))
#define GITG_LANES_IS_LANE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_LANES_TYPE_LANE_CONTAINER))
#define GITG_LANES_LANE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainerClass))

typedef struct _GitgLanesLaneContainer GitgLanesLaneContainer;
typedef struct _GitgLanesLaneContainerClass GitgLanesLaneContainerClass;
typedef struct _GitgLanesCollapsedLane GitgLanesCollapsedLane;
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GITG_TYPE_LANE (gitg_lane_get_type ())
#define GITG_LANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LANE, GitgLane))
#define GITG_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LANE, GitgLaneClass))
#define GITG_IS_LANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LANE))
#define GITG_IS_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LANE))
#define GITG_LANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LANE, GitgLaneClass))

typedef struct _GitgLane GitgLane;
typedef struct _GitgLaneClass GitgLaneClass;
#define _gitg_lanes_lane_container_unref0(var) ((var == NULL) ? NULL : (var = (gitg_lanes_lane_container_unref (var), NULL)))
typedef struct _GitgLanesLaneContainerPrivate GitgLanesLaneContainerPrivate;
typedef struct _GitgLanePrivate GitgLanePrivate;

#define GITG_TYPE_COLOR (gitg_color_get_type ())
#define GITG_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COLOR, GitgColor))
#define GITG_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COLOR, GitgColorClass))
#define GITG_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COLOR))
#define GITG_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COLOR))
#define GITG_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COLOR, GitgColorClass))

typedef struct _GitgColor GitgColor;
typedef struct _GitgColorClass GitgColorClass;

#define GITG_TYPE_LANE_TAG (gitg_lane_tag_get_type ())
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define _ggit_commit_parents_unref0(var) ((var == NULL) ? NULL : (var = (ggit_commit_parents_unref (var), NULL)))
#define _gitg_lanes_collapsed_lane_free0(var) ((var == NULL) ? NULL : (var = (gitg_lanes_collapsed_lane_free (var), NULL)))
typedef struct _GitgLanesParamSpecLaneContainer GitgLanesParamSpecLaneContainer;

struct _GitgLanes {
	GObject parent_instance;
	GitgLanesPrivate * priv;
};

struct _GitgLanesClass {
	GObjectClass parent_class;
};

struct _GitgLanesPrivate {
	gint _inactive_max;
	gint _inactive_collapse;
	gint _inactive_gap;
	gboolean _inactive_enabled;
	GSList* d_previous;
	GeeLinkedList* d_lanes;
	GHashTable* d_collapsed;
};

struct _GitgLanesLaneContainer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgLanesLaneContainerPrivate * priv;
	GitgLane* lane;
	guint inactive;
	GgitOId* from;
	GgitOId* to;
};

struct _GitgLanesLaneContainerClass {
	GTypeClass parent_class;
	void (*finalize) (GitgLanesLaneContainer *self);
};

typedef enum  {
	GITG_LANE_TAG_NONE = 0,
	GITG_LANE_TAG_START = 1 << 0,
	GITG_LANE_TAG_END = 1 << 1,
	GITG_LANE_TAG_SIGN_STASH = 1 << 2,
	GITG_LANE_TAG_SIGN_STAGED = 1 << 3,
	GITG_LANE_TAG_SIGN_UNSTAGED = 1 << 4
} GitgLaneTag;

struct _GitgLane {
	GObject parent_instance;
	GitgLanePrivate * priv;
	GitgColor* color;
	GSList* from;
	GitgLaneTag tag;
	GgitOId* boundary_id;
};

struct _GitgLaneClass {
	GObjectClass parent_class;
};

struct _GitgLanesCollapsedLane {
	GitgColor* color;
	guint index;
	GgitOId* from;
	GgitOId* to;
};

struct _GitgLanesParamSpecLaneContainer {
	GParamSpec parent_instance;
};


static gpointer gitg_lanes_parent_class = NULL;
static gpointer gitg_lanes_lane_container_parent_class = NULL;

GType gitg_lanes_get_type (void) G_GNUC_CONST;
GType gitg_commit_get_type (void) G_GNUC_CONST;
static gpointer gitg_lanes_lane_container_ref (gpointer instance);
static void gitg_lanes_lane_container_unref (gpointer instance);
static GParamSpec* gitg_lanes_param_spec_lane_container (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gitg_lanes_value_set_lane_container (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gitg_lanes_value_take_lane_container (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gitg_lanes_value_get_lane_container (const GValue* value) G_GNUC_UNUSED;
static GType gitg_lanes_lane_container_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void gitg_lanes_collapsed_lane_free (GitgLanesCollapsedLane* self);
#define GITG_LANES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_LANES, GitgLanesPrivate))
enum  {
	GITG_LANES_DUMMY_PROPERTY,
	GITG_LANES_INACTIVE_MAX,
	GITG_LANES_INACTIVE_COLLAPSE,
	GITG_LANES_INACTIVE_GAP,
	GITG_LANES_INACTIVE_ENABLED
};
GitgLanes* gitg_lanes_new (void);
GitgLanes* gitg_lanes_construct (GType object_type);
static guint _ggit_oid_hash_ghash_func (gconstpointer key);
static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _vala_GgitOId_free (GgitOId* self);
static void __vala_GgitOId_free0_ (gpointer var);
static void _gitg_lanes_collapsed_lane_free0_ (gpointer var);
void gitg_lanes_reset (GitgLanes* self);
void gitg_color_reset (void);
GType gitg_lane_get_type (void) G_GNUC_CONST;
GSList* gitg_lanes_next (GitgLanes* self, GitgCommit* next, gint* nextpos);
gboolean gitg_lanes_get_inactive_enabled (GitgLanes* self);
static void gitg_lanes_collapse_lanes (GitgLanes* self);
static void gitg_lanes_expand_lanes (GitgLanes* self, GitgCommit* commit);
static GitgLanesLaneContainer* gitg_lanes_find_lane_by_oid (GitgLanes* self, GgitOId* id, gint* pos);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new (GgitOId* from, GgitOId* to);
static GitgLanesLaneContainer* gitg_lanes_lane_container_construct (GType object_type, GgitOId* from, GgitOId* to);
GType gitg_color_get_type (void) G_GNUC_CONST;
GType gitg_lane_tag_get_type (void) G_GNUC_CONST;
GitgColor* gitg_color_copy (GitgColor* self);
static GSList* gitg_lanes_lanes_list (GitgLanes* self);
static void gitg_lanes_prepare_lanes (GitgLanes* self, GitgCommit* next, gint pos);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static void gitg_lanes_init_next_layer (GitgLanes* self);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
gint gitg_lanes_get_inactive_collapse (GitgLanes* self);
gint gitg_lanes_get_inactive_gap (GitgLanes* self);
static void gitg_lanes_add_collapsed (GitgLanes* self, GitgLanesLaneContainer* container, gint index);
static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container);
static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container);
static void gitg_lanes_collapse_lane (GitgLanes* self, GitgLanesLaneContainer* container, gint index);
GSList* gitg_commit_get_lanes (GitgCommit* self);
GSList* gitg_commit_remove_lane (GitgCommit* self, GitgLane* lane);
static void gitg_lanes_update_merge_indices (GitgLanes* self, GSList* lanes, gint index, gint direction);
guint gitg_commit_get_mylane (GitgCommit* self);
void gitg_commit_set_mylane (GitgCommit* self, guint value);
gint gitg_lanes_get_inactive_max (GitgLanes* self);
static void gitg_lanes_update_current_lane_merge_indices (GitgLanes* self, gint index, gint direction);
static gint gitg_lanes_ensure_correct_index (GitgLanes* self, GitgCommit* commit, gint index);
static void gitg_lanes_update_lane_merge_indices (GitgLanes* self, GSList* from, gint index, gint direction);
static void gitg_lanes_expand_lane (GitgLanes* self, GitgLanesCollapsedLane* lane);
GitgLane* gitg_lane_new_with_color (GitgColor* color);
GitgLane* gitg_lane_construct_with_color (GType object_type, GitgColor* color);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new_with_color (GgitOId* from, GgitOId* to, GitgColor* color);
static GitgLanesLaneContainer* gitg_lanes_lane_container_construct_with_color (GType object_type, GgitOId* from, GgitOId* to, GitgColor* color);
GitgLane* gitg_lane_copy (GitgLane* self);
GSList* gitg_commit_insert_lane (GitgCommit* self, GitgLane* lane, gint idx);
static void gitg_lanes_expand_lane_from_oid (GitgLanes* self, GgitOId* id);
static void gitg_lanes_lane_container_next (GitgLanesLaneContainer* self, gint index);
void gitg_lanes_set_inactive_max (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_collapse (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_gap (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_enabled (GitgLanes* self, gboolean value);
enum  {
	GITG_LANES_LANE_CONTAINER_DUMMY_PROPERTY
};
static void gitg_lanes_lane_container_finalize (GitgLanesLaneContainer* obj);
static void gitg_lanes_collapsed_lane_instance_init (GitgLanesCollapsedLane * self);
static void gitg_lanes_finalize (GObject* obj);
static void _vala_gitg_lanes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_lanes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static guint _ggit_oid_hash_ghash_func (gconstpointer key) {
	guint result;
	result = ggit_oid_hash (key);
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 254 "gitg-lanes.c"
}


static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = ggit_oid_equal (a, (GgitOId*) b);
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 263 "gitg-lanes.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 270 "gitg-lanes.c"
}


static void __vala_GgitOId_free0_ (gpointer var) {
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL));
#line 277 "gitg-lanes.c"
}


static void _gitg_lanes_collapsed_lane_free0_ (gpointer var) {
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (gitg_lanes_collapsed_lane_free (var), NULL));
#line 284 "gitg-lanes.c"
}


GitgLanes* gitg_lanes_construct (GType object_type) {
	GitgLanes * self = NULL;
	GHashTable* _tmp0_ = NULL;
#line 88 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self = (GitgLanes*) g_object_new (object_type, NULL);
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = g_hash_table_new_full (_ggit_oid_hash_ghash_func, _ggit_oid_equal_gequal_func, __vala_GgitOId_free0_, _gitg_lanes_collapsed_lane_free0_);
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_hash_table_unref0 (self->priv->d_collapsed);
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_collapsed = _tmp0_;
#line 93 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_reset (self);
#line 88 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 303 "gitg-lanes.c"
}


GitgLanes* gitg_lanes_new (void) {
#line 88 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return gitg_lanes_construct (GITG_TYPE_LANES);
#line 310 "gitg-lanes.c"
}


void gitg_lanes_reset (GitgLanes* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
#line 96 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_slist_free0 (self->priv->d_previous);
#line 98 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_previous = NULL;
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = gee_linked_list_new (GITG_LANES_TYPE_LANE_CONTAINER, (GBoxedCopyFunc) gitg_lanes_lane_container_ref, gitg_lanes_lane_container_unref, NULL, NULL, NULL);
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->priv->d_lanes);
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_lanes = _tmp0_;
#line 101 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_color_reset ();
#line 103 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = self->priv->d_collapsed;
#line 103 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_hash_table_remove_all (_tmp1_);
#line 335 "gitg-lanes.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 342 "gitg-lanes.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_slist_free (self);
#line 351 "gitg-lanes.c"
}


GSList* gitg_lanes_next (GitgLanes* self, GitgCommit* next, gint* nextpos) {
	gint _vala_nextpos = 0;
	GSList* result = NULL;
	GgitOId* myoid = NULL;
	GitgCommit* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GitgLanesLaneContainer* mylane = NULL;
	GgitOId* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GitgLanesLaneContainer* _tmp6_ = NULL;
	GitgLanesLaneContainer* _tmp7_ = NULL;
	GSList* res = NULL;
	GSList* _tmp26_ = NULL;
	GitgCommit* _tmp27_ = NULL;
	gint _tmp28_ = 0;
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (next != NULL, NULL);
#line 109 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = next;
#line 109 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_object_get_id ((GgitObject*) _tmp0_);
#line 109 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	myoid = _tmp1_;
#line 111 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->priv->_inactive_enabled;
#line 111 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp2_) {
#line 385 "gitg-lanes.c"
		GitgCommit* _tmp3_ = NULL;
#line 113 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_collapse_lanes (self);
#line 114 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = next;
#line 114 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_expand_lanes (self, _tmp3_);
#line 393 "gitg-lanes.c"
	}
#line 117 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = myoid;
#line 117 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = gitg_lanes_find_lane_by_oid (self, _tmp4_, &_tmp5_);
#line 117 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_vala_nextpos = _tmp5_;
#line 117 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	mylane = _tmp6_;
#line 119 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = mylane;
#line 119 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp7_ == NULL) {
#line 407 "gitg-lanes.c"
		GeeLinkedList* _tmp8_ = NULL;
		GgitOId* _tmp9_ = NULL;
		GitgLanesLaneContainer* _tmp10_ = NULL;
		GitgLanesLaneContainer* _tmp11_ = NULL;
		GeeLinkedList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 122 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = self->priv->d_lanes;
#line 122 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp9_ = myoid;
#line 122 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = gitg_lanes_lane_container_new (_tmp9_, NULL);
#line 122 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = _tmp10_;
#line 122 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp11_);
#line 122 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_gitg_lanes_lane_container_unref0 (_tmp11_);
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = self->priv->d_lanes;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp14_ = _tmp13_;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_vala_nextpos = ((gint) _tmp14_) - 1;
#line 435 "gitg-lanes.c"
	} else {
		GitgLanesLaneContainer* _tmp15_ = NULL;
		GitgLane* _tmp16_ = NULL;
		GitgLanesLaneContainer* _tmp17_ = NULL;
		GitgLane* _tmp18_ = NULL;
		GitgColor* _tmp19_ = NULL;
		GitgColor* _tmp20_ = NULL;
		GitgLanesLaneContainer* _tmp21_ = NULL;
		GitgLanesLaneContainer* _tmp22_ = NULL;
		GitgCommit* _tmp23_ = NULL;
		GgitOId* _tmp24_ = NULL;
		GitgLanesLaneContainer* _tmp25_ = NULL;
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp15_ = mylane;
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp16_ = _tmp15_->lane;
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp17_ = mylane;
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp18_ = _tmp17_->lane;
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp19_ = _tmp18_->color;
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp20_ = gitg_color_copy (_tmp19_);
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_tmp16_->color);
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp16_->color = _tmp20_;
#line 130 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp21_ = mylane;
#line 130 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		__vala_GgitOId_free0 (_tmp21_->to);
#line 130 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp21_->to = NULL;
#line 131 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp22_ = mylane;
#line 131 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp23_ = next;
#line 131 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp24_ = ggit_object_get_id ((GgitObject*) _tmp23_);
#line 131 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		__vala_GgitOId_free0 (_tmp22_->from);
#line 131 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp22_->from = _tmp24_;
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp25_ = mylane;
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp25_->inactive = (guint) 0;
#line 484 "gitg-lanes.c"
	}
#line 135 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp26_ = gitg_lanes_lanes_list (self);
#line 135 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	res = _tmp26_;
#line 136 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp27_ = next;
#line 136 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp28_ = _vala_nextpos;
#line 136 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_prepare_lanes (self, _tmp27_, _tmp28_);
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = res;
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_lane_container_unref0 (mylane);
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (myoid);
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (nextpos) {
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		*nextpos = _vala_nextpos;
#line 506 "gitg-lanes.c"
	}
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 510 "gitg-lanes.c"
}


static GgitOId* _vala_GgitOId_copy (GgitOId* self) {
#line 166 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return g_boxed_copy (ggit_oid_get_type (), self);
#line 517 "gitg-lanes.c"
}


static gpointer __vala_GgitOId_copy0 (gpointer self) {
#line 166 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self ? _vala_GgitOId_copy (self) : NULL;
#line 524 "gitg-lanes.c"
}


static void gitg_lanes_prepare_lanes (GitgLanes* self, GitgCommit* next, gint pos) {
	GgitCommitParents* parents = NULL;
	GitgCommit* _tmp0_ = NULL;
	GgitCommitParents* _tmp1_ = NULL;
	GgitOId* myoid = NULL;
	GitgCommit* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GitgLanesLaneContainer* mylane = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gpointer _tmp6_ = NULL;
	gboolean _tmp75_ = FALSE;
	GitgLanesLaneContainer* _tmp76_ = NULL;
	GSList* _tmp81_ = NULL;
	guint _tmp82_ = 0U;
	gint _tmp83_ = 0;
	gint _tmp84_ = 0;
	GitgCommit* _tmp87_ = NULL;
#line 141 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 141 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (next != NULL);
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = next;
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_commit_get_parents ((GgitCommit*) _tmp0_);
#line 143 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	parents = _tmp1_;
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = next;
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = ggit_object_get_id ((GgitObject*) _tmp2_);
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	myoid = _tmp3_;
#line 146 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_init_next_layer (self);
#line 147 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = self->priv->d_lanes;
#line 147 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = pos;
#line 147 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, _tmp5_);
#line 147 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	mylane = (GitgLanesLaneContainer*) _tmp6_;
#line 572 "gitg-lanes.c"
	{
		guint i = 0U;
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		i = (guint) 0;
#line 577 "gitg-lanes.c"
		{
			gboolean _tmp7_ = FALSE;
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = TRUE;
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			while (TRUE) {
#line 584 "gitg-lanes.c"
				guint _tmp9_ = 0U;
				GgitCommitParents* _tmp10_ = NULL;
				guint _tmp11_ = 0U;
				gint lnpos = 0;
				GgitOId* poid = NULL;
				GgitCommitParents* _tmp12_ = NULL;
				guint _tmp13_ = 0U;
				GgitOId* _tmp14_ = NULL;
				GitgLanesLaneContainer* container = NULL;
				GgitOId* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				GitgLanesLaneContainer* _tmp17_ = NULL;
				GitgLanesLaneContainer* _tmp18_ = NULL;
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				if (!_tmp7_) {
#line 600 "gitg-lanes.c"
					guint _tmp8_ = 0U;
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					_tmp8_ = i;
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					i = _tmp8_ + 1;
#line 606 "gitg-lanes.c"
				}
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp7_ = FALSE;
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp9_ = i;
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp10_ = parents;
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = ggit_commit_parents_size (_tmp10_);
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				if (!(_tmp9_ < _tmp11_)) {
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					break;
#line 620 "gitg-lanes.c"
				}
#line 152 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp12_ = parents;
#line 152 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp13_ = i;
#line 152 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp14_ = ggit_commit_parents_get_id (_tmp12_, _tmp13_);
#line 152 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				poid = _tmp14_;
#line 154 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp15_ = poid;
#line 154 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp17_ = gitg_lanes_find_lane_by_oid (self, _tmp15_, &_tmp16_);
#line 154 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				lnpos = _tmp16_;
#line 154 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				container = _tmp17_;
#line 156 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp18_ = container;
#line 156 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				if (_tmp18_ != NULL) {
#line 642 "gitg-lanes.c"
					gboolean _tmp19_ = FALSE;
					guint _tmp20_ = 0U;
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					_tmp20_ = i;
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					if (_tmp20_ == ((guint) 0)) {
#line 649 "gitg-lanes.c"
						gint _tmp21_ = 0;
						gint _tmp22_ = 0;
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp21_ = pos;
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp22_ = lnpos;
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp19_ = _tmp21_ < _tmp22_;
#line 658 "gitg-lanes.c"
					} else {
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp19_ = FALSE;
#line 662 "gitg-lanes.c"
					}
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					if (_tmp19_) {
#line 666 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp23_ = NULL;
						GgitOId* _tmp24_ = NULL;
						GgitOId* _tmp25_ = NULL;
						GitgLanesLaneContainer* _tmp26_ = NULL;
						GgitOId* _tmp27_ = NULL;
						GgitOId* _tmp28_ = NULL;
						GitgLanesLaneContainer* _tmp29_ = NULL;
						GitgLane* _tmp30_ = NULL;
						gint _tmp31_ = 0;
						GitgLanesLaneContainer* _tmp32_ = NULL;
						GitgLane* _tmp33_ = NULL;
						GitgLanesLaneContainer* _tmp34_ = NULL;
						GitgLane* _tmp35_ = NULL;
						GitgColor* _tmp36_ = NULL;
						GitgColor* _tmp37_ = NULL;
						GitgLanesLaneContainer* _tmp38_ = NULL;
						GeeLinkedList* _tmp39_ = NULL;
						GitgLanesLaneContainer* _tmp40_ = NULL;
#line 166 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp23_ = mylane;
#line 166 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp24_ = poid;
#line 166 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp25_ = __vala_GgitOId_copy0 (_tmp24_);
#line 166 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp23_->to);
#line 166 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp23_->to = _tmp25_;
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp26_ = mylane;
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp27_ = myoid;
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp28_ = __vala_GgitOId_copy0 (_tmp27_);
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp26_->from);
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp26_->from = _tmp28_;
#line 168 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp29_ = mylane;
#line 168 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp30_ = _tmp29_->lane;
#line 168 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp31_ = lnpos;
#line 168 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp30_->from = g_slist_append (_tmp30_->from, (gpointer) ((gintptr) _tmp31_));
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp32_ = mylane;
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp33_ = _tmp32_->lane;
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp34_ = mylane;
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp35_ = _tmp34_->lane;
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp36_ = _tmp35_->color;
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp37_ = gitg_color_copy (_tmp36_);
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp33_->color);
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp33_->color = _tmp37_;
#line 170 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp38_ = mylane;
#line 170 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp38_->inactive = (guint) 0;
#line 172 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp39_ = self->priv->d_lanes;
#line 172 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp40_ = container;
#line 172 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp39_, _tmp40_);
#line 739 "gitg-lanes.c"
					} else {
						GitgLanesLaneContainer* _tmp41_ = NULL;
						GgitOId* _tmp42_ = NULL;
						GgitOId* _tmp43_ = NULL;
						GitgLanesLaneContainer* _tmp44_ = NULL;
						GitgLane* _tmp45_ = NULL;
						gint _tmp46_ = 0;
						GitgLanesLaneContainer* _tmp47_ = NULL;
						GitgLane* _tmp48_ = NULL;
						GitgLanesLaneContainer* _tmp49_ = NULL;
						GitgLane* _tmp50_ = NULL;
						GitgColor* _tmp51_ = NULL;
						GitgColor* _tmp52_ = NULL;
						GitgLanesLaneContainer* _tmp53_ = NULL;
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp41_ = container;
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp42_ = myoid;
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp43_ = __vala_GgitOId_copy0 (_tmp42_);
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp41_->from);
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp41_->from = _tmp43_;
#line 177 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp44_ = container;
#line 177 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp45_ = _tmp44_->lane;
#line 177 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp46_ = pos;
#line 177 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp45_->from = g_slist_append (_tmp45_->from, (gpointer) ((gintptr) _tmp46_));
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp47_ = container;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp48_ = _tmp47_->lane;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp49_ = container;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp50_ = _tmp49_->lane;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp51_ = _tmp50_->color;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp52_ = gitg_color_copy (_tmp51_);
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp48_->color);
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp48_->color = _tmp52_;
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp53_ = container;
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp53_->inactive = (guint) 0;
#line 792 "gitg-lanes.c"
					}
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					_gitg_lanes_lane_container_unref0 (container);
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					__vala_GgitOId_free0 (poid);
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					continue;
#line 800 "gitg-lanes.c"
				} else {
					gboolean _tmp54_ = FALSE;
					GitgLanesLaneContainer* _tmp55_ = NULL;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					_tmp55_ = mylane;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					if (_tmp55_ != NULL) {
#line 808 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp56_ = NULL;
						GgitOId* _tmp57_ = NULL;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp56_ = mylane;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp57_ = _tmp56_->to;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp54_ = _tmp57_ == NULL;
#line 817 "gitg-lanes.c"
					} else {
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp54_ = FALSE;
#line 821 "gitg-lanes.c"
					}
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					if (_tmp54_) {
#line 825 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp58_ = NULL;
						GgitOId* _tmp59_ = NULL;
						GgitOId* _tmp60_ = NULL;
						GitgLanesLaneContainer* _tmp61_ = NULL;
						GitgLane* _tmp62_ = NULL;
						GitgLanesLaneContainer* _tmp63_ = NULL;
						GitgLane* _tmp64_ = NULL;
						GitgColor* _tmp65_ = NULL;
						GitgColor* _tmp66_ = NULL;
#line 188 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp58_ = mylane;
#line 188 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp59_ = poid;
#line 188 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp60_ = __vala_GgitOId_copy0 (_tmp59_);
#line 188 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp58_->to);
#line 188 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp58_->to = _tmp60_;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp61_ = mylane;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp62_ = _tmp61_->lane;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp63_ = mylane;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp64_ = _tmp63_->lane;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp65_ = _tmp64_->color;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp66_ = gitg_color_copy (_tmp65_);
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp62_->color);
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp62_->color = _tmp66_;
#line 861 "gitg-lanes.c"
					} else {
						GitgLanesLaneContainer* newlane = NULL;
						GgitOId* _tmp67_ = NULL;
						GgitOId* _tmp68_ = NULL;
						GitgLanesLaneContainer* _tmp69_ = NULL;
						GitgLanesLaneContainer* _tmp70_ = NULL;
						GitgLane* _tmp71_ = NULL;
						gint _tmp72_ = 0;
						GeeLinkedList* _tmp73_ = NULL;
						GitgLanesLaneContainer* _tmp74_ = NULL;
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp67_ = myoid;
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp68_ = poid;
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp69_ = gitg_lanes_lane_container_new (_tmp67_, _tmp68_);
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						newlane = _tmp69_;
#line 197 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp70_ = newlane;
#line 197 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp71_ = _tmp70_->lane;
#line 197 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp72_ = pos;
#line 197 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp71_->from = g_slist_prepend (_tmp71_->from, (gpointer) ((gintptr) _tmp72_));
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp73_ = self->priv->d_lanes;
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp74_ = newlane;
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp73_, _tmp74_);
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_gitg_lanes_lane_container_unref0 (newlane);
#line 896 "gitg-lanes.c"
					}
				}
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_gitg_lanes_lane_container_unref0 (container);
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				__vala_GgitOId_free0 (poid);
#line 903 "gitg-lanes.c"
			}
		}
	}
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp76_ = mylane;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp76_ != NULL) {
#line 911 "gitg-lanes.c"
		GitgLanesLaneContainer* _tmp77_ = NULL;
		GgitOId* _tmp78_ = NULL;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp77_ = mylane;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp78_ = _tmp77_->to;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp75_ = _tmp78_ == NULL;
#line 920 "gitg-lanes.c"
	} else {
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp75_ = FALSE;
#line 924 "gitg-lanes.c"
	}
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp75_) {
#line 928 "gitg-lanes.c"
		GeeLinkedList* _tmp79_ = NULL;
		GitgLanesLaneContainer* _tmp80_ = NULL;
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp79_ = self->priv->d_lanes;
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp80_ = mylane;
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp79_, _tmp80_);
#line 937 "gitg-lanes.c"
	}
#line 209 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp81_ = self->priv->d_previous;
#line 209 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp82_ = g_slist_length (_tmp81_);
#line 209 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp83_ = self->priv->_inactive_collapse;
#line 209 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp84_ = self->priv->_inactive_gap;
#line 209 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp82_ == ((guint) ((_tmp83_ + _tmp84_) + 1))) {
#line 949 "gitg-lanes.c"
		GSList* _tmp85_ = NULL;
		GSList* _tmp86_ = NULL;
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp85_ = self->priv->d_previous;
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp86_ = g_slist_last (_tmp85_);
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		self->priv->d_previous = g_slist_delete_link (self->priv->d_previous, _tmp86_);
#line 958 "gitg-lanes.c"
	}
#line 214 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp87_ = next;
#line 214 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_previous = g_slist_prepend (self->priv->d_previous, _tmp87_);
#line 141 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_lane_container_unref0 (mylane);
#line 141 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (myoid);
#line 141 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_ggit_commit_parents_unref0 (parents);
#line 970 "gitg-lanes.c"
}


static void gitg_lanes_add_collapsed (GitgLanes* self, GitgLanesLaneContainer* container, gint index) {
	GitgLanesCollapsedLane* collapsed = NULL;
	GitgLanesLaneContainer* _tmp0_ = NULL;
	GitgLanesCollapsedLane* _tmp1_ = NULL;
	GitgLanesCollapsedLane* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GHashTable* _tmp4_ = NULL;
	GitgLanesLaneContainer* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GgitOId* _tmp7_ = NULL;
	GitgLanesCollapsedLane* _tmp8_ = NULL;
#line 217 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 217 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (container != NULL);
#line 220 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 220 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gitg_lanes_collapsed_lane_new (_tmp0_);
#line 220 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	collapsed = _tmp1_;
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = collapsed;
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = index;
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_->index = (guint) _tmp3_;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = self->priv->d_collapsed;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = container;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = _tmp5_->to;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = __vala_GgitOId_copy0 (_tmp6_);
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = collapsed;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	collapsed = NULL;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_hash_table_insert (_tmp4_, _tmp7_, _tmp8_);
#line 217 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_collapsed_lane_free0 (collapsed);
#line 1017 "gitg-lanes.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 235 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self ? g_object_ref (self) : NULL;
#line 1024 "gitg-lanes.c"
}


static void gitg_lanes_collapse_lane (GitgLanes* self, GitgLanesLaneContainer* container, gint index) {
	GitgLanesLaneContainer* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSList* item = NULL;
	GSList* _tmp2_ = NULL;
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (container != NULL);
#line 229 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 229 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = index;
#line 229 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_add_collapsed (self, _tmp0_, _tmp1_);
#line 231 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->priv->d_previous;
#line 231 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	item = _tmp2_;
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1049 "gitg-lanes.c"
		GSList* _tmp3_ = NULL;
		GitgCommit* commit = NULL;
		GSList* _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		GitgCommit* _tmp6_ = NULL;
		GSList* lns = NULL;
		GitgCommit* _tmp7_ = NULL;
		GSList* _tmp8_ = NULL;
		GitgLane* lane = NULL;
		GSList* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gconstpointer _tmp11_ = NULL;
		GSList* _tmp12_ = NULL;
		GSList* _tmp13_ = NULL;
		GSList* _tmp42_ = NULL;
		GSList* _tmp43_ = NULL;
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = item;
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp3_ != NULL)) {
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1072 "gitg-lanes.c"
		}
#line 235 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = item;
#line 235 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = _tmp4_->data;
#line 235 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = _g_object_ref0 ((GitgCommit*) _tmp5_);
#line 235 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		commit = _tmp6_;
#line 236 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = commit;
#line 236 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = gitg_commit_get_lanes (_tmp7_);
#line 236 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		lns = _tmp8_;
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp9_ = lns;
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = index;
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = g_slist_nth_data (_tmp9_, (guint) _tmp10_);
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		lane = (GitgLane*) _tmp11_;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = item;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = _tmp12_->next;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp13_ != NULL) {
#line 1102 "gitg-lanes.c"
			gint newindex = 0;
			GitgLane* _tmp14_ = NULL;
			GSList* _tmp15_ = NULL;
			gconstpointer _tmp16_ = NULL;
			GitgCommit* _tmp17_ = NULL;
			GitgLane* _tmp18_ = NULL;
			GSList* _tmp19_ = NULL;
			GSList* _tmp20_ = NULL;
			GSList* _tmp21_ = NULL;
			GSList* _tmp22_ = NULL;
			guint mylane = 0U;
			GitgCommit* _tmp25_ = NULL;
			guint _tmp26_ = 0U;
			guint _tmp27_ = 0U;
			guint _tmp28_ = 0U;
			gint _tmp29_ = 0;
			gint _tmp34_ = 0;
#line 241 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp14_ = lane;
#line 241 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp15_ = _tmp14_->from;
#line 241 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp16_ = _tmp15_->data;
#line 241 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			newindex = (gint) ((gintptr) _tmp16_);
#line 243 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp17_ = commit;
#line 243 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp18_ = lane;
#line 243 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp19_ = gitg_commit_remove_lane (_tmp17_, _tmp18_);
#line 243 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			lns = _tmp19_;
#line 245 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp20_ = item;
#line 245 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp21_ = _tmp20_->next;
#line 245 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp22_ = _tmp21_->next;
#line 245 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (_tmp22_ != NULL) {
#line 1144 "gitg-lanes.c"
				GSList* _tmp23_ = NULL;
				gint _tmp24_ = 0;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp23_ = lns;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp24_ = newindex;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_update_merge_indices (self, _tmp23_, _tmp24_, -1);
#line 1153 "gitg-lanes.c"
			}
#line 250 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp25_ = commit;
#line 250 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp26_ = gitg_commit_get_mylane (_tmp25_);
#line 250 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp27_ = _tmp26_;
#line 250 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			mylane = _tmp27_;
#line 252 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp28_ = mylane;
#line 252 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp29_ = index;
#line 252 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (_tmp28_ > ((guint) _tmp29_)) {
#line 1169 "gitg-lanes.c"
				GitgCommit* _tmp30_ = NULL;
				GitgCommit* _tmp31_ = NULL;
				guint _tmp32_ = 0U;
				guint _tmp33_ = 0U;
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp30_ = commit;
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp31_ = commit;
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp32_ = gitg_commit_get_mylane (_tmp31_);
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp33_ = _tmp32_;
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				gitg_commit_set_mylane (_tmp31_, _tmp33_ - 1);
#line 1184 "gitg-lanes.c"
			}
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp34_ = newindex;
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			index = _tmp34_;
#line 1190 "gitg-lanes.c"
		} else {
			GitgLane* _tmp35_ = NULL;
			GitgLane* _tmp36_ = NULL;
			GitgLaneTag _tmp37_ = 0;
			GitgLane* _tmp38_ = NULL;
			GitgLanesLaneContainer* _tmp39_ = NULL;
			GgitOId* _tmp40_ = NULL;
			GgitOId* _tmp41_ = NULL;
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp35_ = lane;
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp36_ = lane;
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp37_ = _tmp36_->tag;
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp36_->tag = _tmp37_ | GITG_LANE_TAG_END;
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp38_ = lane;
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp39_ = container;
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp40_ = _tmp39_->to;
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp41_ = __vala_GgitOId_copy0 (_tmp40_);
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			__vala_GgitOId_free0 (_tmp38_->boundary_id);
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp38_->boundary_id = _tmp41_;
#line 1219 "gitg-lanes.c"
		}
#line 265 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp42_ = item;
#line 265 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp43_ = _tmp42_->next;
#line 265 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		item = _tmp43_;
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (commit);
#line 1229 "gitg-lanes.c"
	}
}


static void gitg_lanes_collapse_lanes (GitgLanes* self) {
	gint index = 0;
	GeeIterator* iter = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
#line 269 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 271 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	index = 0;
#line 273 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_lanes;
#line 273 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
#line 273 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	iter = _tmp1_;
#line 275 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1251 "gitg-lanes.c"
		GeeIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GitgLanesLaneContainer* container = NULL;
		GeeIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		GitgLanesLaneContainer* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		GitgLanesLaneContainer* _tmp11_ = NULL;
		GitgLanesLaneContainer* _tmp12_ = NULL;
		GitgLane* _tmp13_ = NULL;
		GSList* _tmp14_ = NULL;
		gconstpointer _tmp15_ = NULL;
		gint _tmp16_ = 0;
		GeeIterator* _tmp17_ = NULL;
#line 275 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = iter;
#line 275 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_iterator_next (_tmp2_);
#line 275 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (!_tmp3_) {
#line 275 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1276 "gitg-lanes.c"
		}
#line 277 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = iter;
#line 277 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = gee_iterator_get (_tmp4_);
#line 277 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		container = (GitgLanesLaneContainer*) _tmp5_;
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = container;
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = _tmp6_->inactive;
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = self->priv->_inactive_max;
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp9_ = self->priv->_inactive_gap;
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp7_ != ((guint) (_tmp8_ + _tmp9_))) {
#line 1294 "gitg-lanes.c"
			gint _tmp10_ = 0;
#line 281 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = index;
#line 281 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			index = _tmp10_ + 1;
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			continue;
#line 1304 "gitg-lanes.c"
		}
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = container;
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = container;
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = _tmp12_->lane;
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp14_ = _tmp13_->from;
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp15_ = _tmp14_->data;
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_collapse_lane (self, _tmp11_, (gint) ((gintptr) _tmp15_));
#line 286 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp16_ = index;
#line 286 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_update_current_lane_merge_indices (self, _tmp16_, -1);
#line 288 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp17_ = iter;
#line 288 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gee_iterator_remove (_tmp17_);
#line 275 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_gitg_lanes_lane_container_unref0 (container);
#line 1328 "gitg-lanes.c"
	}
#line 269 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (iter);
#line 1332 "gitg-lanes.c"
}


static gint gitg_lanes_ensure_correct_index (GitgLanes* self, GitgCommit* commit, gint index) {
	gint result = 0;
	guint len = 0U;
	GitgCommit* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gint _tmp3_ = 0;
	guint _tmp4_ = 0U;
#line 292 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 292 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (commit != NULL, 0);
#line 295 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = commit;
#line 295 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gitg_commit_get_lanes (_tmp0_);
#line 295 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = g_slist_length (_tmp1_);
#line 295 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	len = _tmp2_;
#line 297 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = index;
#line 297 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = len;
#line 297 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (((guint) _tmp3_) > _tmp4_) {
#line 1362 "gitg-lanes.c"
		guint _tmp5_ = 0U;
#line 299 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = len;
#line 299 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		result = (gint) _tmp5_;
#line 299 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		return result;
#line 1370 "gitg-lanes.c"
	} else {
		gint _tmp6_ = 0;
#line 303 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = index;
#line 303 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		result = _tmp6_;
#line 303 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		return result;
#line 1379 "gitg-lanes.c"
	}
}


static void gitg_lanes_update_lane_merge_indices (GitgLanes* self, GSList* from, gint index, gint direction) {
#line 307 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 311 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1389 "gitg-lanes.c"
		GSList* _tmp0_ = NULL;
		gint idx = 0;
		GSList* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		GSList* _tmp13_ = NULL;
		GSList* _tmp14_ = NULL;
#line 311 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = from;
#line 311 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp0_ != NULL)) {
#line 311 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1405 "gitg-lanes.c"
		}
#line 313 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = from;
#line 313 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _tmp1_->data;
#line 313 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		idx = (gint) ((gintptr) _tmp2_);
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = idx;
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = index;
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp4_ > _tmp5_) {
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp3_ = TRUE;
#line 1421 "gitg-lanes.c"
		} else {
			gboolean _tmp6_ = FALSE;
			gint _tmp7_ = 0;
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = direction;
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (_tmp7_ > 0) {
#line 1429 "gitg-lanes.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp8_ = idx;
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp9_ = index;
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp6_ = _tmp8_ == _tmp9_;
#line 1438 "gitg-lanes.c"
			} else {
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp6_ = FALSE;
#line 1442 "gitg-lanes.c"
			}
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp3_ = _tmp6_;
#line 1446 "gitg-lanes.c"
		}
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp3_) {
#line 1450 "gitg-lanes.c"
			GSList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = from;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = idx;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = direction;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp10_->data = (gpointer) ((gintptr) (_tmp11_ + _tmp12_));
#line 1462 "gitg-lanes.c"
		}
#line 320 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = from;
#line 320 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp14_ = _tmp13_->next;
#line 320 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		from = _tmp14_;
#line 1470 "gitg-lanes.c"
	}
}


static void gitg_lanes_update_merge_indices (GitgLanes* self, GSList* lanes, gint index, gint direction) {
	GSList* _tmp0_ = NULL;
#line 324 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 328 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = lanes;
#line 1481 "gitg-lanes.c"
	{
		GSList* lane_collection = NULL;
		GSList* lane_it = NULL;
#line 328 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		lane_collection = _tmp0_;
#line 328 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		for (lane_it = lane_collection; lane_it != NULL; lane_it = lane_it->next) {
#line 1489 "gitg-lanes.c"
			GitgLane* lane = NULL;
#line 328 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			lane = (GitgLane*) lane_it->data;
#line 1493 "gitg-lanes.c"
			{
				GitgLane* _tmp1_ = NULL;
				GSList* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 330 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp1_ = lane;
#line 330 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp2_ = _tmp1_->from;
#line 330 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp3_ = index;
#line 330 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp4_ = direction;
#line 330 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_update_lane_merge_indices (self, _tmp2_, _tmp3_, _tmp4_);
#line 1509 "gitg-lanes.c"
			}
		}
	}
}


static void gitg_lanes_update_current_lane_merge_indices (GitgLanes* self, gint index, gint direction) {
#line 333 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 1519 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _container_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _container_index = 0;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 1547 "gitg-lanes.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GitgLanesLaneContainer* _tmp11_ = NULL;
			GitgLane* _tmp12_ = NULL;
			GSList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				break;
#line 1572 "gitg-lanes.c"
			}
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = container;
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = _tmp11_->lane;
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp13_ = _tmp12_->from;
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp14_ = index;
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp15_ = direction;
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_update_lane_merge_indices (self, _tmp13_, _tmp14_, _tmp15_);
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 1596 "gitg-lanes.c"
		}
#line 336 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 1600 "gitg-lanes.c"
	}
}


static void gitg_lanes_expand_lane (GitgLanes* self, GitgLanesCollapsedLane* lane) {
	guint index = 0U;
	GitgLanesCollapsedLane* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GitgLane* ln = NULL;
	GitgLanesCollapsedLane* _tmp2_ = NULL;
	GitgColor* _tmp3_ = NULL;
	GitgLane* _tmp4_ = NULL;
	gint len = 0;
	GeeLinkedList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	guint _tmp8_ = 0U;
	gint _tmp9_ = 0;
	gint next = 0;
	GSList* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	gint _tmp14_ = 0;
	GitgLanesLaneContainer* container = NULL;
	GitgLanesCollapsedLane* _tmp15_ = NULL;
	GgitOId* _tmp16_ = NULL;
	GitgLanesCollapsedLane* _tmp17_ = NULL;
	GgitOId* _tmp18_ = NULL;
	GitgLanesCollapsedLane* _tmp19_ = NULL;
	GitgColor* _tmp20_ = NULL;
	GitgLanesLaneContainer* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	GitgLanesLaneContainer* _tmp23_ = NULL;
	GitgLane* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GeeLinkedList* _tmp26_ = NULL;
	guint _tmp27_ = 0U;
	GitgLanesLaneContainer* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	guint cnt = 0U;
	GSList* ptr = NULL;
	GSList* _tmp30_ = NULL;
#line 344 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 344 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (lane != NULL);
#line 346 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = lane;
#line 346 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_->index;
#line 346 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	index = _tmp1_;
#line 347 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = lane;
#line 347 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = _tmp2_->color;
#line 347 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = gitg_lane_new_with_color (_tmp3_);
#line 347 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	ln = _tmp4_;
#line 348 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = self->priv->d_lanes;
#line 348 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
#line 348 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = _tmp6_;
#line 348 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	len = _tmp7_;
#line 350 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = index;
#line 350 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp9_ = len;
#line 350 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp8_ > ((guint) _tmp9_)) {
#line 1675 "gitg-lanes.c"
		gint _tmp10_ = 0;
#line 352 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = len;
#line 352 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		index = (guint) _tmp10_;
#line 1681 "gitg-lanes.c"
	}
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp11_ = self->priv->d_previous;
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp12_ = _tmp11_->data;
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp13_ = index;
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp14_ = gitg_lanes_ensure_correct_index (self, (GitgCommit*) _tmp12_, (gint) _tmp13_);
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	next = _tmp14_;
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp15_ = lane;
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp16_ = _tmp15_->from;
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp17_ = lane;
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp18_ = _tmp17_->to;
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp19_ = lane;
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp20_ = _tmp19_->color;
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp21_ = gitg_lanes_lane_container_new_with_color (_tmp16_, _tmp18_, _tmp20_);
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	container = _tmp21_;
#line 361 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp22_ = index;
#line 361 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_update_current_lane_merge_indices (self, (gint) _tmp22_, 1);
#line 363 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp23_ = container;
#line 363 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp24_ = _tmp23_->lane;
#line 363 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp25_ = next;
#line 363 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp24_->from = g_slist_prepend (_tmp24_->from, (gpointer) ((gintptr) _tmp25_));
#line 364 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp26_ = self->priv->d_lanes;
#line 364 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp27_ = index;
#line 364 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp28_ = container;
#line 364 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gee_abstract_list_insert ((GeeAbstractList*) _tmp26_, (gint) _tmp27_, _tmp28_);
#line 366 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp29_ = next;
#line 366 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	index = (guint) _tmp29_;
#line 367 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	cnt = (guint) 0;
#line 369 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp30_ = self->priv->d_previous;
#line 369 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	ptr = _tmp30_;
#line 371 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1741 "gitg-lanes.c"
		GSList* _tmp31_ = NULL;
		GitgCommit* commit = NULL;
		GSList* _tmp32_ = NULL;
		gconstpointer _tmp33_ = NULL;
		GitgCommit* _tmp34_ = NULL;
		guint _tmp35_ = 0U;
		gint _tmp36_ = 0;
		GitgLane* copy = NULL;
		GitgLane* _tmp37_ = NULL;
		GitgLane* _tmp38_ = NULL;
		GSList* lns = NULL;
		GitgCommit* _tmp39_ = NULL;
		GSList* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		GSList* _tmp42_ = NULL;
		GSList* _tmp43_ = NULL;
		GitgCommit* _tmp62_ = NULL;
		GitgLane* _tmp63_ = NULL;
		guint _tmp64_ = 0U;
		guint mylane = 0U;
		GitgCommit* _tmp65_ = NULL;
		guint _tmp66_ = 0U;
		guint _tmp67_ = 0U;
		guint _tmp68_ = 0U;
		guint _tmp69_ = 0U;
		gint _tmp74_ = 0;
		guint _tmp75_ = 0U;
		GSList* _tmp76_ = NULL;
		GSList* _tmp77_ = NULL;
#line 371 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp31_ = ptr;
#line 371 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp31_ != NULL)) {
#line 371 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1777 "gitg-lanes.c"
		}
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp32_ = ptr;
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp33_ = _tmp32_->data;
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp34_ = _g_object_ref0 ((GitgCommit*) _tmp33_);
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		commit = _tmp34_;
#line 375 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp35_ = cnt;
#line 375 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp36_ = self->priv->_inactive_collapse;
#line 375 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp35_ == ((guint) _tmp36_)) {
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_g_object_unref0 (commit);
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1797 "gitg-lanes.c"
		}
#line 381 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp37_ = ln;
#line 381 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp38_ = gitg_lane_copy (_tmp37_);
#line 381 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		copy = _tmp38_;
#line 382 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp39_ = commit;
#line 382 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp40_ = gitg_commit_get_lanes (_tmp39_);
#line 382 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		lns = _tmp40_;
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp42_ = ptr;
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp43_ = _tmp42_->next;
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp43_ == NULL) {
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp41_ = TRUE;
#line 1819 "gitg-lanes.c"
		} else {
			guint _tmp44_ = 0U;
			gint _tmp45_ = 0;
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp44_ = cnt;
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp45_ = self->priv->_inactive_collapse;
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp41_ = (_tmp44_ + 1) == ((guint) _tmp45_);
#line 1829 "gitg-lanes.c"
		}
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp41_) {
#line 1833 "gitg-lanes.c"
			GitgLane* _tmp46_ = NULL;
			GitgLanesCollapsedLane* _tmp47_ = NULL;
			GgitOId* _tmp48_ = NULL;
			GgitOId* _tmp49_ = NULL;
			GitgLane* _tmp50_ = NULL;
			GitgLane* _tmp51_ = NULL;
			GitgLaneTag _tmp52_ = 0;
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp46_ = copy;
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp47_ = lane;
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp48_ = _tmp47_->from;
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp49_ = __vala_GgitOId_copy0 (_tmp48_);
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			__vala_GgitOId_free0 (_tmp46_->boundary_id);
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp46_->boundary_id = _tmp49_;
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp50_ = copy;
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp51_ = copy;
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp52_ = _tmp51_->tag;
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp51_->tag = _tmp52_ | GITG_LANE_TAG_START;
#line 1861 "gitg-lanes.c"
		} else {
			GSList* _tmp53_ = NULL;
			GSList* _tmp54_ = NULL;
			gconstpointer _tmp55_ = NULL;
			guint _tmp56_ = 0U;
			gint _tmp57_ = 0;
			GitgLane* _tmp58_ = NULL;
			gint _tmp59_ = 0;
			GSList* _tmp60_ = NULL;
			guint _tmp61_ = 0U;
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp53_ = ptr;
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp54_ = _tmp53_->next;
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp55_ = _tmp54_->data;
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp56_ = index;
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp57_ = gitg_lanes_ensure_correct_index (self, (GitgCommit*) _tmp55_, (gint) _tmp56_);
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			next = _tmp57_;
#line 392 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp58_ = copy;
#line 392 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp59_ = next;
#line 392 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp58_->from = g_slist_prepend (_tmp58_->from, (gpointer) ((gintptr) _tmp59_));
#line 394 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp60_ = lns;
#line 394 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp61_ = index;
#line 394 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_update_merge_indices (self, _tmp60_, (gint) _tmp61_, 1);
#line 1896 "gitg-lanes.c"
		}
#line 397 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp62_ = commit;
#line 397 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp63_ = copy;
#line 397 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp64_ = index;
#line 397 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_commit_insert_lane (_tmp62_, _tmp63_, (gint) _tmp64_);
#line 399 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp65_ = commit;
#line 399 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp66_ = gitg_commit_get_mylane (_tmp65_);
#line 399 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp67_ = _tmp66_;
#line 399 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		mylane = _tmp67_;
#line 401 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp68_ = mylane;
#line 401 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp69_ = index;
#line 401 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp68_ >= _tmp69_) {
#line 1920 "gitg-lanes.c"
			GitgCommit* _tmp70_ = NULL;
			GitgCommit* _tmp71_ = NULL;
			guint _tmp72_ = 0U;
			guint _tmp73_ = 0U;
#line 403 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp70_ = commit;
#line 403 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp71_ = commit;
#line 403 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp72_ = gitg_commit_get_mylane (_tmp71_);
#line 403 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp73_ = _tmp72_;
#line 403 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			gitg_commit_set_mylane (_tmp71_, _tmp73_ + 1);
#line 1935 "gitg-lanes.c"
		}
#line 406 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp74_ = next;
#line 406 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		index = (guint) _tmp74_;
#line 407 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp75_ = cnt;
#line 407 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		cnt = _tmp75_ + 1;
#line 409 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp76_ = ptr;
#line 409 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp77_ = _tmp76_->next;
#line 409 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		ptr = _tmp77_;
#line 371 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (copy);
#line 371 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (commit);
#line 1955 "gitg-lanes.c"
	}
#line 344 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_lane_container_unref0 (container);
#line 344 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (ln);
#line 1961 "gitg-lanes.c"
}


static void gitg_lanes_expand_lane_from_oid (GitgLanes* self, GgitOId* id) {
	GitgLanesCollapsedLane* collapsed = NULL;
	GHashTable* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	GitgLanesCollapsedLane* _tmp3_ = NULL;
#line 413 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 413 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (id != NULL);
#line 415 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_collapsed;
#line 415 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = id;
#line 415 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 415 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	collapsed = (GitgLanesCollapsedLane*) _tmp2_;
#line 417 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = collapsed;
#line 417 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp3_ != NULL) {
#line 1987 "gitg-lanes.c"
		GitgLanesCollapsedLane* _tmp4_ = NULL;
		GHashTable* _tmp5_ = NULL;
		GgitOId* _tmp6_ = NULL;
#line 419 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = collapsed;
#line 419 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_expand_lane (self, _tmp4_);
#line 420 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = self->priv->d_collapsed;
#line 420 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = id;
#line 420 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_hash_table_remove (_tmp5_, _tmp6_);
#line 2001 "gitg-lanes.c"
	}
}


static void gitg_lanes_expand_lanes (GitgLanes* self, GitgCommit* commit) {
	GitgCommit* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitCommitParents* parents = NULL;
	GitgCommit* _tmp3_ = NULL;
	GgitCommitParents* _tmp4_ = NULL;
#line 424 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 424 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (commit != NULL);
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = commit;
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_object_get_id ((GgitObject*) _tmp0_);
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = _tmp1_;
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_expand_lane_from_oid (self, _tmp2_);
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 428 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = commit;
#line 428 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = ggit_commit_get_parents ((GgitCommit*) _tmp3_);
#line 428 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	parents = _tmp4_;
#line 2033 "gitg-lanes.c"
	{
		guint i = 0U;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		i = (guint) 0;
#line 2038 "gitg-lanes.c"
		{
			gboolean _tmp5_ = FALSE;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = TRUE;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			while (TRUE) {
#line 2045 "gitg-lanes.c"
				guint _tmp7_ = 0U;
				GgitCommitParents* _tmp8_ = NULL;
				guint _tmp9_ = 0U;
				GgitCommitParents* _tmp10_ = NULL;
				guint _tmp11_ = 0U;
				GgitOId* _tmp12_ = NULL;
				GgitOId* _tmp13_ = NULL;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				if (!_tmp5_) {
#line 2055 "gitg-lanes.c"
					guint _tmp6_ = 0U;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					_tmp6_ = i;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					i = _tmp6_ + 1;
#line 2061 "gitg-lanes.c"
				}
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp5_ = FALSE;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp7_ = i;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp8_ = parents;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp9_ = ggit_commit_parents_size (_tmp8_);
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				if (!(_tmp7_ < _tmp9_)) {
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					break;
#line 2075 "gitg-lanes.c"
				}
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp10_ = parents;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = i;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp12_ = ggit_commit_parents_get_id (_tmp10_, _tmp11_);
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp13_ = _tmp12_;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_expand_lane_from_oid (self, _tmp13_);
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				__vala_GgitOId_free0 (_tmp13_);
#line 2089 "gitg-lanes.c"
			}
		}
	}
#line 424 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_ggit_commit_parents_unref0 (parents);
#line 2095 "gitg-lanes.c"
}


static void gitg_lanes_init_next_layer (GitgLanes* self) {
	gint index = 0;
#line 436 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 438 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	index = 0;
#line 2105 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _container_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _container_index = 0;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 2133 "gitg-lanes.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GitgLanesLaneContainer* _tmp11_ = NULL;
			gint _tmp12_ = 0;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				break;
#line 2155 "gitg-lanes.c"
			}
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 442 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = container;
#line 442 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = index;
#line 442 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			index = _tmp12_ + 1;
#line 442 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_lane_container_next (_tmp11_, _tmp12_);
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 2175 "gitg-lanes.c"
		}
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 2179 "gitg-lanes.c"
	}
}


static GitgLanesLaneContainer* gitg_lanes_find_lane_by_oid (GitgLanes* self, GgitOId* id, gint* pos) {
	gint _vala_pos = 0;
	GitgLanesLaneContainer* result = NULL;
	gint p = 0;
#line 446 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 446 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 449 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	p = 0;
#line 2194 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _container_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _container_index = 0;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 2222 "gitg-lanes.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			GitgLanesLaneContainer* _tmp12_ = NULL;
			gint _tmp18_ = 0;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				break;
#line 2245 "gitg-lanes.c"
			}
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 453 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = container;
#line 453 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (_tmp12_ != NULL) {
#line 2259 "gitg-lanes.c"
				GgitOId* _tmp13_ = NULL;
				GitgLanesLaneContainer* _tmp14_ = NULL;
				GgitOId* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
#line 454 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp13_ = id;
#line 454 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp14_ = container;
#line 454 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp15_ = _tmp14_->to;
#line 454 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp16_ = ggit_oid_equal (_tmp13_, _tmp15_);
#line 454 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = _tmp16_;
#line 2274 "gitg-lanes.c"
			} else {
#line 453 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = FALSE;
#line 2278 "gitg-lanes.c"
			}
#line 453 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (_tmp11_) {
#line 2282 "gitg-lanes.c"
				gint _tmp17_ = 0;
#line 456 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp17_ = p;
#line 456 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_vala_pos = _tmp17_;
#line 457 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				result = container;
#line 457 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_g_object_unref0 (_container_list);
#line 457 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				if (pos) {
#line 457 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					*pos = _vala_pos;
#line 2296 "gitg-lanes.c"
				}
#line 457 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				return result;
#line 2300 "gitg-lanes.c"
			}
#line 460 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp18_ = p;
#line 460 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			p = _tmp18_ + 1;
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 2308 "gitg-lanes.c"
		}
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 2312 "gitg-lanes.c"
	}
#line 463 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_vala_pos = -1;
#line 464 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = NULL;
#line 464 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (pos) {
#line 464 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		*pos = _vala_pos;
#line 2322 "gitg-lanes.c"
	}
#line 464 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2326 "gitg-lanes.c"
}


static GSList* gitg_lanes_lanes_list (GitgLanes* self) {
	GSList* result = NULL;
	GSList* ret = NULL;
#line 467 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 469 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	ret = NULL;
#line 2337 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _container_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _container_index = 0;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 2365 "gitg-lanes.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GitgLanesLaneContainer* _tmp11_ = NULL;
			GitgLane* _tmp12_ = NULL;
			GitgLane* _tmp13_ = NULL;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				break;
#line 2388 "gitg-lanes.c"
			}
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 473 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = container;
#line 473 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = _tmp11_->lane;
#line 473 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp13_ = gitg_lane_copy (_tmp12_);
#line 473 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			ret = g_slist_prepend (ret, _tmp13_);
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 2408 "gitg-lanes.c"
		}
#line 471 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 2412 "gitg-lanes.c"
	}
#line 476 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	ret = g_slist_reverse (ret);
#line 477 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = ret;
#line 477 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2420 "gitg-lanes.c"
}


gint gitg_lanes_get_inactive_max (GitgLanes* self) {
	gint result;
	gint _tmp0_ = 0;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_max;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2435 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_max (GitgLanes* self, gint value) {
	gint _tmp0_ = 0;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_max = _tmp0_;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-max");
#line 2449 "gitg-lanes.c"
}


gint gitg_lanes_get_inactive_collapse (GitgLanes* self) {
	gint result;
	gint _tmp0_ = 0;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_collapse;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2464 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_collapse (GitgLanes* self, gint value) {
	gint _tmp0_ = 0;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_collapse = _tmp0_;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-collapse");
#line 2478 "gitg-lanes.c"
}


gint gitg_lanes_get_inactive_gap (GitgLanes* self) {
	gint result;
	gint _tmp0_ = 0;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_gap;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2493 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_gap (GitgLanes* self, gint value) {
	gint _tmp0_ = 0;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_gap = _tmp0_;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-gap");
#line 2507 "gitg-lanes.c"
}


gboolean gitg_lanes_get_inactive_enabled (GitgLanes* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_enabled;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2522 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_enabled (GitgLanes* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_enabled = _tmp0_;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-enabled");
#line 2536 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_construct_with_color (GType object_type, GgitOId* from, GgitOId* to, GitgColor* color) {
	GitgLanesLaneContainer* self = NULL;
	GgitOId* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GitgColor* _tmp4_ = NULL;
	GitgLane* _tmp5_ = NULL;
#line 41 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self = (GitgLanesLaneContainer*) g_type_create_instance (object_type);
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = from;
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = __vala_GgitOId_copy0 (_tmp0_);
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->from = _tmp1_;
#line 46 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = to;
#line 46 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = __vala_GgitOId_copy0 (_tmp2_);
#line 46 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 46 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->to = _tmp3_;
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = color;
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = gitg_lane_new_with_color (_tmp4_);
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->lane = _tmp5_;
#line 48 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->inactive = (guint) 0;
#line 41 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 2578 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_new_with_color (GgitOId* from, GgitOId* to, GitgColor* color) {
#line 41 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return gitg_lanes_lane_container_construct_with_color (GITG_LANES_TYPE_LANE_CONTAINER, from, to, color);
#line 2585 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_construct (GType object_type, GgitOId* from, GgitOId* to) {
	GitgLanesLaneContainer* self = NULL;
	GgitOId* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = from;
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = to;
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self = (GitgLanesLaneContainer*) gitg_lanes_lane_container_construct_with_color (object_type, _tmp0_, _tmp1_, NULL);
#line 51 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 2601 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_new (GgitOId* from, GgitOId* to) {
#line 51 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return gitg_lanes_lane_container_construct (GITG_LANES_TYPE_LANE_CONTAINER, from, to);
#line 2608 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_next (GitgLanesLaneContainer* self, gint index) {
	GitgLane* _tmp0_ = NULL;
	GitgLane* _tmp1_ = NULL;
	GitgLane* _tmp2_ = NULL;
	GitgLane* _tmp3_ = NULL;
	GitgLane* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GgitOId* _tmp6_ = NULL;
#line 57 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 59 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->lane;
#line 59 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gitg_lane_copy (_tmp0_);
#line 59 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 59 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->lane = _tmp1_;
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->lane;
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_->tag = GITG_LANE_TAG_NONE;
#line 62 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = self->lane;
#line 62 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_slist_free0 (_tmp3_->from);
#line 62 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_->from = NULL;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = self->lane;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = index;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_->from = g_slist_prepend (_tmp4_->from, (gpointer) ((gintptr) _tmp5_));
#line 65 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = self->to;
#line 65 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp6_ != NULL) {
#line 2650 "gitg-lanes.c"
		guint _tmp7_ = 0U;
#line 67 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = self->inactive;
#line 67 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		self->inactive = _tmp7_ + 1;
#line 2656 "gitg-lanes.c"
	}
}


static void gitg_lanes_value_lane_container_init (GValue* value) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	value->data[0].v_pointer = NULL;
#line 2664 "gitg-lanes.c"
}


static void gitg_lanes_value_lane_container_free_value (GValue* value) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (value->data[0].v_pointer) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_unref (value->data[0].v_pointer);
#line 2673 "gitg-lanes.c"
	}
}


static void gitg_lanes_value_lane_container_copy_value (const GValue* src_value, GValue* dest_value) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (src_value->data[0].v_pointer) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		dest_value->data[0].v_pointer = gitg_lanes_lane_container_ref (src_value->data[0].v_pointer);
#line 2683 "gitg-lanes.c"
	} else {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2687 "gitg-lanes.c"
	}
}


static gpointer gitg_lanes_value_lane_container_peek_pointer (const GValue* value) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return value->data[0].v_pointer;
#line 2695 "gitg-lanes.c"
}


static gchar* gitg_lanes_value_lane_container_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (collect_values[0].v_pointer) {
#line 2702 "gitg-lanes.c"
		GitgLanesLaneContainer* object;
		object = collect_values[0].v_pointer;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (object->parent_instance.g_class == NULL) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2709 "gitg-lanes.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2713 "gitg-lanes.c"
		}
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = gitg_lanes_lane_container_ref (object);
#line 2717 "gitg-lanes.c"
	} else {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = NULL;
#line 2721 "gitg-lanes.c"
	}
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return NULL;
#line 2725 "gitg-lanes.c"
}


static gchar* gitg_lanes_value_lane_container_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GitgLanesLaneContainer** object_p;
	object_p = collect_values[0].v_pointer;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (!object_p) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2736 "gitg-lanes.c"
	}
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (!value->data[0].v_pointer) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		*object_p = NULL;
#line 2742 "gitg-lanes.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		*object_p = value->data[0].v_pointer;
#line 2746 "gitg-lanes.c"
	} else {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		*object_p = gitg_lanes_lane_container_ref (value->data[0].v_pointer);
#line 2750 "gitg-lanes.c"
	}
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return NULL;
#line 2754 "gitg-lanes.c"
}


static GParamSpec* gitg_lanes_param_spec_lane_container (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GitgLanesParamSpecLaneContainer* spec;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GITG_LANES_TYPE_LANE_CONTAINER), NULL);
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return G_PARAM_SPEC (spec);
#line 2768 "gitg-lanes.c"
}


static gpointer gitg_lanes_value_get_lane_container (const GValue* value) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER), NULL);
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return value->data[0].v_pointer;
#line 2777 "gitg-lanes.c"
}


static void gitg_lanes_value_set_lane_container (GValue* value, gpointer v_object) {
	GitgLanesLaneContainer* old;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER));
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	old = value->data[0].v_pointer;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (v_object) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_LANES_TYPE_LANE_CONTAINER));
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = v_object;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_ref (value->data[0].v_pointer);
#line 2797 "gitg-lanes.c"
	} else {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = NULL;
#line 2801 "gitg-lanes.c"
	}
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (old) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_unref (old);
#line 2807 "gitg-lanes.c"
	}
}


static void gitg_lanes_value_take_lane_container (GValue* value, gpointer v_object) {
	GitgLanesLaneContainer* old;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER));
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	old = value->data[0].v_pointer;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (v_object) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_LANES_TYPE_LANE_CONTAINER));
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = v_object;
#line 2826 "gitg-lanes.c"
	} else {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = NULL;
#line 2830 "gitg-lanes.c"
	}
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (old) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_unref (old);
#line 2836 "gitg-lanes.c"
	}
}


static void gitg_lanes_lane_container_class_init (GitgLanesLaneContainerClass * klass) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_lane_container_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	GITG_LANES_LANE_CONTAINER_CLASS (klass)->finalize = gitg_lanes_lane_container_finalize;
#line 2846 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_instance_init (GitgLanesLaneContainer * self) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->ref_count = 1;
#line 2853 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_finalize (GitgLanesLaneContainer* obj) {
	GitgLanesLaneContainer * self;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainer);
#line 36 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 38 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 39 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 2867 "gitg-lanes.c"
}


static GType gitg_lanes_lane_container_get_type (void) {
	static volatile gsize gitg_lanes_lane_container_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_lanes_lane_container_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gitg_lanes_value_lane_container_init, gitg_lanes_value_lane_container_free_value, gitg_lanes_value_lane_container_copy_value, gitg_lanes_value_lane_container_peek_pointer, "p", gitg_lanes_value_lane_container_collect_value, "p", gitg_lanes_value_lane_container_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GitgLanesLaneContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_lanes_lane_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgLanesLaneContainer), 0, (GInstanceInitFunc) gitg_lanes_lane_container_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gitg_lanes_lane_container_type_id;
		gitg_lanes_lane_container_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgLanesLaneContainer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gitg_lanes_lane_container_type_id__volatile, gitg_lanes_lane_container_type_id);
	}
	return gitg_lanes_lane_container_type_id__volatile;
}


static gpointer gitg_lanes_lane_container_ref (gpointer instance) {
	GitgLanesLaneContainer* self;
	self = instance;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_atomic_int_inc (&self->ref_count);
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return instance;
#line 2892 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_unref (gpointer instance) {
	GitgLanesLaneContainer* self;
	self = instance;
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		GITG_LANES_LANE_CONTAINER_GET_CLASS (self)->finalize (self);
#line 34 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2905 "gitg-lanes.c"
	}
}


static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container) {
	GitgLanesCollapsedLane* self;
	GitgLanesLaneContainer* _tmp0_ = NULL;
	GitgLane* _tmp1_ = NULL;
	GitgColor* _tmp2_ = NULL;
	GitgColor* _tmp3_ = NULL;
	GitgLanesLaneContainer* _tmp4_ = NULL;
	GgitOId* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GitgLanesLaneContainer* _tmp7_ = NULL;
	GgitOId* _tmp8_ = NULL;
	GgitOId* _tmp9_ = NULL;
#line 80 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (container != NULL, NULL);
#line 80 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self = g_slice_new0 (GitgLanesCollapsedLane);
#line 80 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_collapsed_lane_instance_init (self);
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_->lane;
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = _tmp1_->color;
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->color);
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->color = _tmp3_;
#line 83 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = container;
#line 83 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = _tmp4_->from;
#line 83 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = __vala_GgitOId_copy0 (_tmp5_);
#line 83 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 83 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->from = _tmp6_;
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = container;
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = _tmp7_->to;
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp9_ = __vala_GgitOId_copy0 (_tmp8_);
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->to = _tmp9_;
#line 80 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 2962 "gitg-lanes.c"
}


static void gitg_lanes_collapsed_lane_instance_init (GitgLanesCollapsedLane * self) {
}


static void gitg_lanes_collapsed_lane_free (GitgLanesCollapsedLane* self) {
#line 75 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->color);
#line 77 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 78 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 73 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_slice_free (GitgLanesCollapsedLane, self);
#line 2979 "gitg-lanes.c"
}


static void gitg_lanes_class_init (GitgLanesClass * klass) {
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_type_class_add_private (klass, sizeof (GitgLanesPrivate));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_lanes_get_property;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_lanes_set_property;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_lanes_finalize;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_MAX, g_param_spec_int ("inactive-max", "inactive-max", "inactive-max", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_COLLAPSE, g_param_spec_int ("inactive-collapse", "inactive-collapse", "inactive-collapse", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_GAP, g_param_spec_int ("inactive-gap", "inactive-gap", "inactive-gap", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_ENABLED, g_param_spec_boolean ("inactive-enabled", "inactive-enabled", "inactive-enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3002 "gitg-lanes.c"
}


static void gitg_lanes_instance_init (GitgLanes * self) {
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv = GITG_LANES_GET_PRIVATE (self);
#line 3009 "gitg-lanes.c"
}


static void gitg_lanes_finalize (GObject* obj) {
	GitgLanes * self;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_LANES, GitgLanes);
#line 30 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_slist_free0 (self->priv->d_previous);
#line 31 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->priv->d_lanes);
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_hash_table_unref0 (self->priv->d_collapsed);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (gitg_lanes_parent_class)->finalize (obj);
#line 3025 "gitg-lanes.c"
}


GType gitg_lanes_get_type (void) {
	static volatile gsize gitg_lanes_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_lanes_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgLanesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_lanes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgLanes), 0, (GInstanceInitFunc) gitg_lanes_instance_init, NULL };
		GType gitg_lanes_type_id;
		gitg_lanes_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgLanes", &g_define_type_info, 0);
		g_once_init_leave (&gitg_lanes_type_id__volatile, gitg_lanes_type_id);
	}
	return gitg_lanes_type_id__volatile;
}


static void _vala_gitg_lanes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_LANES, GitgLanes);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	switch (property_id) {
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_MAX:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_max (self));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_COLLAPSE:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_collapse (self));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_GAP:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_gap (self));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_ENABLED:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_value_set_boolean (value, gitg_lanes_get_inactive_enabled (self));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3070 "gitg-lanes.c"
		default:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3076 "gitg-lanes.c"
	}
}


static void _vala_gitg_lanes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_LANES, GitgLanes);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	switch (property_id) {
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_MAX:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_max (self, g_value_get_int (value));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_COLLAPSE:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_collapse (self, g_value_get_int (value));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_GAP:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_gap (self, g_value_get_int (value));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_ENABLED:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_enabled (self, g_value_get_boolean (value));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3110 "gitg-lanes.c"
		default:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3116 "gitg-lanes.c"
	}
}



