/* computer-player.c generated by valac 0.25.4.3-6021, the Vala compiler
 * generated from computer-player.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;
typedef struct _ComputerPlayerPrivate ComputerPlayerPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define COMPUTER_PLAYER_TYPE_STRATEGY (computer_player_strategy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PLAYER (player_get_type ())

#define COMPUTER_PLAYER_TYPE_POSSIBLE_MOVE (computer_player_possible_move_get_type ())
typedef struct _ComputerPlayerPossibleMove ComputerPlayerPossibleMove;
#define _computer_player_possible_move_free0(var) ((var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL)))
#define __g_list_free__computer_player_possible_move_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__computer_player_possible_move_free0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ComputerPlayer {
	GObject parent_instance;
	ComputerPlayerPrivate * priv;
};

struct _ComputerPlayerClass {
	GObjectClass parent_class;
};

struct _ComputerPlayerPrivate {
	Game* game;
	gint _level;
};

typedef enum  {
	COMPUTER_PLAYER_STRATEGY_PERFECT,
	COMPUTER_PLAYER_STRATEGY_VICTORY,
	COMPUTER_PLAYER_STRATEGY_BEST
} ComputerPlayerStrategy;

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _ComputerPlayerPossibleMove {
	gint x;
	gint y;
	gint n_tiles;
};


static gpointer computer_player_parent_class = NULL;

GType computer_player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define COMPUTER_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPUTER_PLAYER, ComputerPlayerPrivate))
enum  {
	COMPUTER_PLAYER_DUMMY_PROPERTY,
	COMPUTER_PLAYER_LEVEL
};
static GType computer_player_strategy_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define COMPUTER_PLAYER_POSITIVE_INFINITY 10000
#define COMPUTER_PLAYER_NEGATIVE_INFINITY (-10000)
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void computer_player_set_level (ComputerPlayer* self, gint value);
void computer_player_move (ComputerPlayer* self);
GType player_get_type (void) G_GNUC_CONST;
gboolean game_can_move (Game* self, Player color);
Player game_get_current_color (Game* self);
gint game_get_n_tiles (Game* self);
static void computer_player_random_select (Game* g, gint* move_x, gint* move_y);
gint game_place_tile (Game* self, gint x, gint y);
gint computer_player_get_level (ComputerPlayer* self);
static gint computer_player_search (Game* g, ComputerPlayerStrategy strategy, gint depth, gint a, gint b, gint* move_x, gint* move_y);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type, Game* game);
gboolean game_is_complete (Game* self);
gint game_count_tiles (Game* self, Player color);
Player player_flip_color (Player p);
static gint computer_player_calculate_heuristic (Game* g, ComputerPlayerStrategy strategy);
static GType computer_player_possible_move_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self);
static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self);
static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles);
static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b);
static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b);
void game_undo (Game* self, gint count);
void game_pass (Game* self);
static void _computer_player_possible_move_free0_ (gpointer var);
static void _g_list_free__computer_player_possible_move_free0_ (GList* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
static gint computer_player_eval_heuristic (Game* g);
static gint computer_player_around (Game* g);
Player game_get_owner (Game* self, gint x, gint y);
static gint computer_player_is_empty (Game* g, gint x, gint y);
gboolean game_can_place (Game* self, gint x, gint y, Player color);
static void computer_player_finalize (GObject* obj);
static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gint COMPUTER_PLAYER_heuristic[64] = {65, -3, 6, 4, 4, 6, -3, 65, -3, -29, 3, 1, 1, 3, -29, -3, 6, 3, 5, 3, 3, 5, 3, 6, 4, 1, 3, 1, 1, 3, 1, 4, 4, 1, 3, 1, 1, 3, 1, 4, 6, 3, 5, 3, 3, 5, 3, 6, -3, -29, 3, 1, 1, 3, -29, -3, 65, -3, 6, 4, 4, 6, -3, 65};

static GType computer_player_strategy_get_type (void) {
	static volatile gsize computer_player_strategy_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_strategy_type_id__volatile)) {
		static const GEnumValue values[] = {{COMPUTER_PLAYER_STRATEGY_PERFECT, "COMPUTER_PLAYER_STRATEGY_PERFECT", "perfect"}, {COMPUTER_PLAYER_STRATEGY_VICTORY, "COMPUTER_PLAYER_STRATEGY_VICTORY", "victory"}, {COMPUTER_PLAYER_STRATEGY_BEST, "COMPUTER_PLAYER_STRATEGY_BEST", "best"}, {0, NULL, NULL}};
		GType computer_player_strategy_type_id;
		computer_player_strategy_type_id = g_enum_register_static ("ComputerPlayerStrategy", values);
		g_once_init_leave (&computer_player_strategy_type_id__volatile, computer_player_strategy_type_id);
	}
	return computer_player_strategy_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level) {
	ComputerPlayer * self = NULL;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_val_if_fail (game != NULL, NULL);
	self = (ComputerPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = game;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp1_;
	_tmp2_ = level;
	computer_player_set_level (self, _tmp2_);
	return self;
}


ComputerPlayer* computer_player_new (Game* game, gint level) {
	return computer_player_construct (TYPE_COMPUTER_PLAYER, game, level);
}


void computer_player_move (ComputerPlayer* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	Game* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint depth = 0;
	gint _tmp14_ = 0;
	gint tiles_remaining = 0;
	Game* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	ComputerPlayerStrategy _tmp18_ = 0;
	gint _tmp19_ = 0;
	ComputerPlayerStrategy strategy = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint x = 0;
	gint y = 0;
	Game* _tmp24_ = NULL;
	Game* _tmp25_ = NULL;
	Game* _tmp26_ = NULL;
	ComputerPlayerStrategy _tmp27_ = 0;
	gint _tmp28_ = 0;
	Game* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_current_color (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = game_can_move (_tmp0_, _tmp3_);
	g_return_if_fail (_tmp4_);
	_tmp5_ = self->priv->game;
	_tmp6_ = game_get_n_tiles (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ < 8) {
		gint x = 0;
		gint y = 0;
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp8_ = self->priv->game;
		computer_player_random_select (_tmp8_, &_tmp9_, &_tmp10_);
		x = _tmp9_;
		y = _tmp10_;
		_tmp11_ = self->priv->game;
		_tmp12_ = x;
		_tmp13_ = y;
		game_place_tile (_tmp11_, _tmp12_, _tmp13_);
		return;
	}
	_tmp14_ = self->priv->_level;
	depth = (_tmp14_ * 2) + 1;
	_tmp15_ = self->priv->game;
	_tmp16_ = game_get_n_tiles (_tmp15_);
	_tmp17_ = _tmp16_;
	tiles_remaining = 64 - _tmp17_;
	_tmp19_ = self->priv->_level;
	if (_tmp19_ == 1) {
		_tmp18_ = COMPUTER_PLAYER_STRATEGY_PERFECT;
	} else {
		_tmp18_ = COMPUTER_PLAYER_STRATEGY_BEST;
	}
	strategy = _tmp18_;
	_tmp20_ = tiles_remaining;
	_tmp21_ = depth;
	if (_tmp20_ <= (_tmp21_ + 10)) {
		strategy = COMPUTER_PLAYER_STRATEGY_PERFECT;
	} else {
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp22_ = tiles_remaining;
		_tmp23_ = depth;
		if (_tmp22_ <= (_tmp23_ + 12)) {
			strategy = COMPUTER_PLAYER_STRATEGY_VICTORY;
		}
	}
	x = 0;
	y = 0;
	_tmp24_ = self->priv->game;
	_tmp25_ = game_new_copy (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = strategy;
	_tmp28_ = depth;
	computer_player_search (_tmp26_, _tmp27_, _tmp28_, COMPUTER_PLAYER_NEGATIVE_INFINITY, COMPUTER_PLAYER_POSITIVE_INFINITY, &x, &y);
	_g_object_unref0 (_tmp26_);
	_tmp29_ = self->priv->game;
	_tmp30_ = x;
	_tmp31_ = y;
	_tmp32_ = game_place_tile (_tmp29_, _tmp30_, _tmp31_);
	if (_tmp32_ == 0) {
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		_tmp33_ = x;
		_tmp34_ = y;
		g_critical ("computer-player.vala:98: Computer chose an invalid move: %d,%d", _tmp33_, _tmp34_);
	}
}


static gpointer _computer_player_possible_move_dup0 (gpointer self) {
	return self ? computer_player_possible_move_dup (self) : NULL;
}


static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = computer_player_compare_move ((ComputerPlayerPossibleMove*) a, (ComputerPlayerPossibleMove*) b);
	return result;
}


static void _computer_player_possible_move_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL));
}


static void _g_list_free__computer_player_possible_move_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _computer_player_possible_move_free0_, NULL);
	g_list_free (self);
}


static gint computer_player_search (Game* g, ComputerPlayerStrategy strategy, gint depth, gint a, gint b, gint* move_x, gint* move_y) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Game* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gint _tmp20_ = 0;
	GList* moves = NULL;
	GList* _tmp41_ = NULL;
	GList* _tmp51_ = NULL;
	gint _tmp85_ = 0;
	g_return_val_if_fail (g != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	g_return_val_if_fail (_tmp0_ <= _tmp1_, 0);
	_tmp2_ = g;
	_tmp3_ = game_is_complete (_tmp2_);
	if (_tmp3_) {
		gint n_current_tiles = 0;
		Game* _tmp4_ = NULL;
		Game* _tmp5_ = NULL;
		Player _tmp6_ = 0;
		Player _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint n_enemy_tiles = 0;
		Game* _tmp9_ = NULL;
		Game* _tmp10_ = NULL;
		Player _tmp11_ = 0;
		Player _tmp12_ = 0;
		Player _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		_tmp4_ = g;
		_tmp5_ = g;
		_tmp6_ = game_get_current_color (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = game_count_tiles (_tmp4_, _tmp7_);
		n_current_tiles = _tmp8_;
		_tmp9_ = g;
		_tmp10_ = g;
		_tmp11_ = game_get_current_color (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = player_flip_color (_tmp12_);
		_tmp14_ = game_count_tiles (_tmp9_, _tmp13_);
		n_enemy_tiles = _tmp14_;
		_tmp16_ = n_current_tiles;
		_tmp17_ = n_enemy_tiles;
		if (_tmp16_ > _tmp17_) {
			gint _tmp18_ = 0;
			_tmp18_ = n_enemy_tiles;
			_tmp15_ = COMPUTER_PLAYER_POSITIVE_INFINITY - _tmp18_;
		} else {
			gint _tmp19_ = 0;
			_tmp19_ = n_current_tiles;
			_tmp15_ = COMPUTER_PLAYER_NEGATIVE_INFINITY + _tmp19_;
		}
		result = _tmp15_;
		return result;
	}
	_tmp20_ = depth;
	if (_tmp20_ == 0) {
		Game* _tmp21_ = NULL;
		ComputerPlayerStrategy _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp21_ = g;
		_tmp22_ = strategy;
		_tmp23_ = computer_player_calculate_heuristic (_tmp21_, _tmp22_);
		result = _tmp23_;
		return result;
	}
	moves = NULL;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				gint _tmp26_ = 0;
				if (!_tmp24_) {
					gint _tmp25_ = 0;
					_tmp25_ = x;
					x = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				_tmp26_ = x;
				if (!(_tmp26_ < 8)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp27_ = FALSE;
						_tmp27_ = TRUE;
						while (TRUE) {
							gint _tmp29_ = 0;
							gint n_tiles = 0;
							Game* _tmp30_ = NULL;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							ComputerPlayerPossibleMove move = {0};
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							ComputerPlayerPossibleMove _tmp38_ = {0};
							ComputerPlayerPossibleMove* _tmp39_ = NULL;
							Game* _tmp40_ = NULL;
							if (!_tmp27_) {
								gint _tmp28_ = 0;
								_tmp28_ = y;
								y = _tmp28_ + 1;
							}
							_tmp27_ = FALSE;
							_tmp29_ = y;
							if (!(_tmp29_ < 8)) {
								break;
							}
							_tmp30_ = g;
							_tmp31_ = x;
							_tmp32_ = y;
							_tmp33_ = game_place_tile (_tmp30_, _tmp31_, _tmp32_);
							n_tiles = _tmp33_;
							_tmp34_ = n_tiles;
							if (_tmp34_ <= 0) {
								continue;
							}
							_tmp35_ = x;
							_tmp36_ = y;
							_tmp37_ = n_tiles;
							computer_player_possible_move_init (&move, _tmp35_, _tmp36_, _tmp37_);
							_tmp38_ = move;
							_tmp39_ = _computer_player_possible_move_dup0 (&_tmp38_);
							moves = g_list_insert_sorted (moves, _tmp39_, _computer_player_compare_move_gcompare_func);
							_tmp40_ = g;
							game_undo (_tmp40_, 1);
						}
					}
				}
			}
		}
	}
	_tmp41_ = moves;
	if (_tmp41_ == NULL) {
		ComputerPlayerPossibleMove move = {0};
		ComputerPlayerPossibleMove _tmp42_ = {0};
		ComputerPlayerPossibleMove* _tmp43_ = NULL;
		computer_player_possible_move_init (&move, 0, 0, 0);
		_tmp42_ = move;
		_tmp43_ = _computer_player_possible_move_dup0 (&_tmp42_);
		moves = g_list_append (moves, _tmp43_);
	} else {
		ComputerPlayerPossibleMove* move = NULL;
		GList* _tmp44_ = NULL;
		gconstpointer _tmp45_ = NULL;
		ComputerPlayerPossibleMove* _tmp46_ = NULL;
		ComputerPlayerPossibleMove* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		ComputerPlayerPossibleMove* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		_tmp44_ = moves;
		_tmp45_ = g_list_nth_data (_tmp44_, (guint) 0);
		_tmp46_ = _computer_player_possible_move_dup0 ((ComputerPlayerPossibleMove*) _tmp45_);
		move = _tmp46_;
		_tmp47_ = move;
		_tmp48_ = (*_tmp47_).x;
		*move_x = _tmp48_;
		_tmp49_ = move;
		_tmp50_ = (*_tmp49_).y;
		*move_y = _tmp50_;
		_computer_player_possible_move_free0 (move);
	}
	_tmp51_ = moves;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = _tmp51_;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			ComputerPlayerPossibleMove* _tmp52_ = NULL;
			ComputerPlayerPossibleMove* move = NULL;
			_tmp52_ = _computer_player_possible_move_dup0 ((ComputerPlayerPossibleMove*) move_it->data);
			move = _tmp52_;
			{
				ComputerPlayerPossibleMove* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gint next_x_move = 0;
				gint next_y_move = 0;
				gint a_new = 0;
				Game* _tmp69_ = NULL;
				ComputerPlayerStrategy _tmp70_ = 0;
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				Game* _tmp82_ = NULL;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
				_tmp53_ = move;
				_tmp54_ = (*_tmp53_).n_tiles;
				if (_tmp54_ == 0) {
					Game* _tmp55_ = NULL;
					_tmp55_ = g;
					game_pass (_tmp55_);
				} else {
					Game* _tmp56_ = NULL;
					ComputerPlayerPossibleMove* _tmp57_ = NULL;
					gint _tmp58_ = 0;
					ComputerPlayerPossibleMove* _tmp59_ = NULL;
					gint _tmp60_ = 0;
					gint _tmp61_ = 0;
					_tmp56_ = g;
					_tmp57_ = move;
					_tmp58_ = (*_tmp57_).x;
					_tmp59_ = move;
					_tmp60_ = (*_tmp59_).y;
					_tmp61_ = game_place_tile (_tmp56_, _tmp58_, _tmp60_);
					if (_tmp61_ == 0) {
						gint _tmp62_ = 0;
						ComputerPlayerPossibleMove* _tmp63_ = NULL;
						gint _tmp64_ = 0;
						ComputerPlayerPossibleMove* _tmp65_ = NULL;
						gint _tmp66_ = 0;
						ComputerPlayerPossibleMove* _tmp67_ = NULL;
						gint _tmp68_ = 0;
						_tmp62_ = depth;
						_tmp63_ = move;
						_tmp64_ = (*_tmp63_).x;
						_tmp65_ = move;
						_tmp66_ = (*_tmp65_).y;
						_tmp67_ = move;
						_tmp68_ = (*_tmp67_).n_tiles;
						g_critical ("computer-player.vala:157: Computer marked move (depth %d, %d,%d, %d fl" \
"ips) as valid, but is invalid when checking", _tmp62_, _tmp64_, _tmp66_, _tmp68_);
					}
				}
				next_x_move = 0;
				next_y_move = 0;
				_tmp69_ = g;
				_tmp70_ = strategy;
				_tmp71_ = depth;
				_tmp72_ = b;
				_tmp73_ = a;
				_tmp74_ = computer_player_search (_tmp69_, _tmp70_, _tmp71_ - 1, -_tmp72_, -_tmp73_, &next_x_move, &next_y_move);
				a_new = (-1) * _tmp74_;
				_tmp75_ = a_new;
				_tmp76_ = a;
				if (_tmp75_ > _tmp76_) {
					gint _tmp77_ = 0;
					ComputerPlayerPossibleMove* _tmp78_ = NULL;
					gint _tmp79_ = 0;
					ComputerPlayerPossibleMove* _tmp80_ = NULL;
					gint _tmp81_ = 0;
					_tmp77_ = a_new;
					a = _tmp77_;
					_tmp78_ = move;
					_tmp79_ = (*_tmp78_).x;
					*move_x = _tmp79_;
					_tmp80_ = move;
					_tmp81_ = (*_tmp80_).y;
					*move_y = _tmp81_;
				}
				_tmp82_ = g;
				game_undo (_tmp82_, 1);
				_tmp83_ = b;
				_tmp84_ = a;
				if (_tmp83_ <= _tmp84_) {
					_computer_player_possible_move_free0 (move);
					break;
				}
				_computer_player_possible_move_free0 (move);
			}
		}
	}
	_tmp85_ = a;
	result = _tmp85_;
	__g_list_free__computer_player_possible_move_free0_0 (moves);
	return result;
}


static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b) {
	gint result = 0;
	ComputerPlayerPossibleMove* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ComputerPlayerPossibleMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	_tmp0_ = b;
	_tmp1_ = (*_tmp0_).n_tiles;
	_tmp2_ = a;
	_tmp3_ = (*_tmp2_).n_tiles;
	result = _tmp1_ - _tmp3_;
	return result;
}


static gint computer_player_calculate_heuristic (Game* g, ComputerPlayerStrategy strategy) {
	gint result = 0;
	gint _tmp0_ = 0;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gint tile_difference = 0;
	ComputerPlayerStrategy _tmp16_ = 0;
	g_return_val_if_fail (g != NULL, 0);
	_tmp1_ = g;
	_tmp2_ = game_get_current_color (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == PLAYER_DARK) {
		Game* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		Game* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp4_ = g;
		_tmp5_ = game_get_n_dark_tiles (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g;
		_tmp8_ = game_get_n_light_tiles (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = _tmp6_ - _tmp9_;
	} else {
		Game* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		Game* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp10_ = g;
		_tmp11_ = game_get_n_light_tiles (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g;
		_tmp14_ = game_get_n_dark_tiles (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp0_ = _tmp12_ - _tmp15_;
	}
	tile_difference = _tmp0_;
	_tmp16_ = strategy;
	switch (_tmp16_) {
		case COMPUTER_PLAYER_STRATEGY_PERFECT:
		{
			result = tile_difference;
			return result;
		}
		case COMPUTER_PLAYER_STRATEGY_VICTORY:
		{
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			_tmp17_ = tile_difference;
			_tmp18_ = CLAMP (_tmp17_, -1, 1);
			result = _tmp18_;
			return result;
		}
		default:
		{
			gint _tmp19_ = 0;
			Game* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			Game* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			_tmp19_ = tile_difference;
			_tmp20_ = g;
			_tmp21_ = computer_player_eval_heuristic (_tmp20_);
			_tmp22_ = g;
			_tmp23_ = computer_player_around (_tmp22_);
			result = (_tmp19_ + _tmp21_) + _tmp23_;
			return result;
		}
	}
}


static gint computer_player_eval_heuristic (Game* g) {
	gint result = 0;
	gint count = 0;
	g_return_val_if_fail (g != NULL, 0);
	count = 0;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = x;
				if (!(_tmp2_ < 8)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							gint h = 0;
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							Player _tmp12_ = 0;
							Game* _tmp13_ = NULL;
							Player _tmp14_ = 0;
							Player _tmp15_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = y;
								y = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = y;
							if (!(_tmp5_ < 8)) {
								break;
							}
							_tmp6_ = y;
							_tmp7_ = x;
							_tmp8_ = COMPUTER_PLAYER_heuristic[(_tmp6_ * 8) + _tmp7_];
							h = _tmp8_;
							_tmp9_ = g;
							_tmp10_ = x;
							_tmp11_ = y;
							_tmp12_ = game_get_owner (_tmp9_, _tmp10_, _tmp11_);
							_tmp13_ = g;
							_tmp14_ = game_get_current_color (_tmp13_);
							_tmp15_ = _tmp14_;
							if (_tmp12_ != _tmp15_) {
								gint _tmp16_ = 0;
								_tmp16_ = h;
								h = -_tmp16_;
							}
							_tmp17_ = count;
							_tmp18_ = h;
							count = _tmp17_ + _tmp18_;
						}
					}
				}
			}
		}
	}
	result = count;
	return result;
}


static gint computer_player_around (Game* g) {
	gint result = 0;
	gint count = 0;
	g_return_val_if_fail (g != NULL, 0);
	count = 0;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = x;
				if (!(_tmp2_ < 8)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							gint a = 0;
							gint _tmp6_ = 0;
							Game* _tmp7_ = NULL;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							Game* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							Game* _tmp17_ = NULL;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							Game* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							Game* _tmp27_ = NULL;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							Game* _tmp32_ = NULL;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							Game* _tmp37_ = NULL;
							gint _tmp38_ = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							Game* _tmp42_ = NULL;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							Game* _tmp48_ = NULL;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							Player _tmp51_ = 0;
							Game* _tmp52_ = NULL;
							Player _tmp53_ = 0;
							Player _tmp54_ = 0;
							gint _tmp57_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = y;
								y = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = y;
							if (!(_tmp5_ < 8)) {
								break;
							}
							a = 0;
							_tmp6_ = a;
							_tmp7_ = g;
							_tmp8_ = x;
							_tmp9_ = y;
							_tmp10_ = computer_player_is_empty (_tmp7_, _tmp8_ + 1, _tmp9_);
							a = _tmp6_ - _tmp10_;
							_tmp11_ = a;
							_tmp12_ = g;
							_tmp13_ = x;
							_tmp14_ = y;
							_tmp15_ = computer_player_is_empty (_tmp12_, _tmp13_ + 1, _tmp14_ + 1);
							a = _tmp11_ - _tmp15_;
							_tmp16_ = a;
							_tmp17_ = g;
							_tmp18_ = x;
							_tmp19_ = y;
							_tmp20_ = computer_player_is_empty (_tmp17_, _tmp18_, _tmp19_ + 1);
							a = _tmp16_ - _tmp20_;
							_tmp21_ = a;
							_tmp22_ = g;
							_tmp23_ = x;
							_tmp24_ = y;
							_tmp25_ = computer_player_is_empty (_tmp22_, _tmp23_ - 1, _tmp24_ + 1);
							a = _tmp21_ - _tmp25_;
							_tmp26_ = a;
							_tmp27_ = g;
							_tmp28_ = x;
							_tmp29_ = y;
							_tmp30_ = computer_player_is_empty (_tmp27_, _tmp28_ - 1, _tmp29_);
							a = _tmp26_ - _tmp30_;
							_tmp31_ = a;
							_tmp32_ = g;
							_tmp33_ = x;
							_tmp34_ = y;
							_tmp35_ = computer_player_is_empty (_tmp32_, _tmp33_ - 1, _tmp34_ - 1);
							a = _tmp31_ - _tmp35_;
							_tmp36_ = a;
							_tmp37_ = g;
							_tmp38_ = x;
							_tmp39_ = y;
							_tmp40_ = computer_player_is_empty (_tmp37_, _tmp38_, _tmp39_ - 1);
							a = _tmp36_ - _tmp40_;
							_tmp41_ = a;
							_tmp42_ = g;
							_tmp43_ = x;
							_tmp44_ = y;
							_tmp45_ = computer_player_is_empty (_tmp42_, _tmp43_ + 1, _tmp44_ - 1);
							a = _tmp41_ - _tmp45_;
							_tmp46_ = a;
							if (_tmp46_ == 0) {
								a = 2;
							}
							_tmp48_ = g;
							_tmp49_ = x;
							_tmp50_ = y;
							_tmp51_ = game_get_owner (_tmp48_, _tmp49_, _tmp50_);
							_tmp52_ = g;
							_tmp53_ = game_get_current_color (_tmp52_);
							_tmp54_ = _tmp53_;
							if (_tmp51_ == _tmp54_) {
								gint _tmp55_ = 0;
								_tmp55_ = a;
								_tmp47_ = _tmp55_;
							} else {
								gint _tmp56_ = 0;
								_tmp56_ = a;
								_tmp47_ = -_tmp56_;
							}
							_tmp57_ = count;
							count = _tmp57_ + _tmp47_;
						}
					}
				}
			}
		}
	}
	result = count;
	return result;
}


static gint computer_player_is_empty (Game* g, gint x, gint y) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	g_return_val_if_fail (g != NULL, 0);
	_tmp4_ = x;
	if (_tmp4_ < 0) {
		_tmp3_ = TRUE;
	} else {
		gint _tmp5_ = 0;
		_tmp5_ = x;
		_tmp3_ = _tmp5_ >= 8;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp6_ = 0;
		_tmp6_ = y;
		_tmp2_ = _tmp6_ < 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp7_ = 0;
		_tmp7_ = y;
		_tmp1_ = _tmp7_ >= 8;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Player _tmp11_ = 0;
		_tmp8_ = g;
		_tmp9_ = x;
		_tmp10_ = y;
		_tmp11_ = game_get_owner (_tmp8_, _tmp9_, _tmp10_);
		_tmp0_ = _tmp11_ != PLAYER_NONE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	result = 1;
	return result;
}


static void computer_player_random_select (Game* g, gint* move_x, gint* move_y) {
	gint _vala_move_x = 0;
	gint _vala_move_y = 0;
	GList* moves = NULL;
	GList* _tmp15_ = NULL;
	g_return_if_fail (g != NULL);
	moves = NULL;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = x;
				if (!(_tmp2_ < 8)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Game* _tmp6_ = NULL;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							Player _tmp10_ = 0;
							Player _tmp11_ = 0;
							gboolean _tmp12_ = FALSE;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = y;
								y = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = y;
							if (!(_tmp5_ < 8)) {
								break;
							}
							_tmp6_ = g;
							_tmp7_ = x;
							_tmp8_ = y;
							_tmp9_ = g;
							_tmp10_ = game_get_current_color (_tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = game_can_place (_tmp6_, _tmp7_, _tmp8_, _tmp11_);
							if (_tmp12_) {
								gint _tmp13_ = 0;
								gint _tmp14_ = 0;
								_tmp13_ = x;
								_tmp14_ = y;
								moves = g_list_append (moves, (gpointer) ((gintptr) ((_tmp13_ * 8) + _tmp14_)));
							}
						}
					}
				}
			}
		}
	}
	_tmp15_ = moves;
	if (_tmp15_ != NULL) {
		gint32 i = 0;
		GList* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		gint32 _tmp18_ = 0;
		gint xy = 0;
		GList* _tmp19_ = NULL;
		gint32 _tmp20_ = 0;
		gconstpointer _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp16_ = moves;
		_tmp17_ = g_list_length (_tmp16_);
		_tmp18_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp17_));
		i = _tmp18_;
		_tmp19_ = moves;
		_tmp20_ = i;
		_tmp21_ = g_list_nth_data (_tmp19_, (guint) _tmp20_);
		xy = (gint) ((gintptr) _tmp21_);
		_tmp22_ = xy;
		_vala_move_x = _tmp22_ / 8;
		_tmp23_ = xy;
		_vala_move_y = _tmp23_ % 8;
	} else {
		gint _tmp24_ = 0;
		_vala_move_y = 0;
		_tmp24_ = _vala_move_y;
		_vala_move_x = _tmp24_;
	}
	_g_list_free0 (moves);
	if (move_x) {
		*move_x = _vala_move_x;
	}
	if (move_y) {
		*move_y = _vala_move_y;
	}
}


gint computer_player_get_level (ComputerPlayer* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_level;
	result = _tmp0_;
	return result;
}


static void computer_player_set_level (ComputerPlayer* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_level = _tmp0_;
	g_object_notify ((GObject *) self, "level");
}


static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	memset (self, 0, sizeof (ComputerPlayerPossibleMove));
	_tmp0_ = x;
	(*self).x = _tmp0_;
	_tmp1_ = y;
	(*self).y = _tmp1_;
	_tmp2_ = n_tiles;
	(*self).n_tiles = _tmp2_;
}


static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self) {
	ComputerPlayerPossibleMove* dup;
	dup = g_new0 (ComputerPlayerPossibleMove, 1);
	memcpy (dup, self, sizeof (ComputerPlayerPossibleMove));
	return dup;
}


static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self) {
	g_free (self);
}


static GType computer_player_possible_move_get_type (void) {
	static volatile gsize computer_player_possible_move_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_possible_move_type_id__volatile)) {
		GType computer_player_possible_move_type_id;
		computer_player_possible_move_type_id = g_boxed_type_register_static ("ComputerPlayerPossibleMove", (GBoxedCopyFunc) computer_player_possible_move_dup, (GBoxedFreeFunc) computer_player_possible_move_free);
		g_once_init_leave (&computer_player_possible_move_type_id__volatile, computer_player_possible_move_type_id);
	}
	return computer_player_possible_move_type_id__volatile;
}


static void computer_player_class_init (ComputerPlayerClass * klass) {
	computer_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ComputerPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_computer_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_computer_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = computer_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPUTER_PLAYER_LEVEL, g_param_spec_int ("level", "level", "level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void computer_player_instance_init (ComputerPlayer * self) {
	self->priv = COMPUTER_PLAYER_GET_PRIVATE (self);
}


static void computer_player_finalize (GObject* obj) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPUTER_PLAYER, ComputerPlayer);
	_g_object_unref0 (self->priv->game);
	G_OBJECT_CLASS (computer_player_parent_class)->finalize (obj);
}


GType computer_player_get_type (void) {
	static volatile gsize computer_player_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComputerPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) computer_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComputerPlayer), 0, (GInstanceInitFunc) computer_player_instance_init, NULL };
		GType computer_player_type_id;
		computer_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ComputerPlayer", &g_define_type_info, 0);
		g_once_init_leave (&computer_player_type_id__volatile, computer_player_type_id);
	}
	return computer_player_type_id__volatile;
}


static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
	switch (property_id) {
		case COMPUTER_PLAYER_LEVEL:
		g_value_set_int (value, computer_player_get_level (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
	switch (property_id) {
		case COMPUTER_PLAYER_LEVEL:
		computer_player_set_level (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



